<?php

/**
 * init.form2004.php - Tax Analysis Report
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],47,"");

$jobId = $_SERVER['argv'][0];
$GLOBALS['temp']['jobId'] = $jobId;

$pf_object_id = db_pf_object_by_name("tax_analysis_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Tax Analysis Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_tax_analysis.htm");
}

$GLOBALS['temp']['advancedForm'] = "collapse";
$GLOBALS['temp']['advancedTag'] = ">>  More";

$folioContactFilter = useFilter("folioContact",$_SERVER['argv'][9],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","fn_folio.fn_folio_to_id",false,"Cash","0");
$agentFilter = useFilter("agent",$_SERVER['argv'][7],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",false,"Direct booking","0");
$agentCountryFilter = useFilter("agentCountry",$_SERVER['argv'][8],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_ag.pr_corr_country_id",false,false,false);

$agentFilterType = $_SERVER['argv'][6];
$GLOBALS['temp']['agentNameRadioChecked'] = "checked";
$GLOBALS['temp']['agentCountryRadioChecked'] = "";
if($agentFilterType == "2") {
   $GLOBALS['temp']['agentNameRadioChecked'] = "";
   $GLOBALS['temp']['agentCountryRadioChecked'] = "checked";
   $agentWhere = $agentCountryFilter['where'];
} else {
   $agentWhere = $agentFilter['where'];
}

$originatorFilter = useFilter("originator",$_SERVER['argv'][10],"SELECT pr_persona.pr_name_first,pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_origin_agent_id",false,"No originator","0");
$sourceFilter = useFilter("source",$_SERVER['argv'][11],"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =","rv_reservation.rf_source_ix",false,"No source","0");
$createdByFilter = useFilter("createdBy",$_SERVER['argv'][12],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.pr_reservation_user_id",false,"No created by","0");
$nationalityFilter = useFilter("nationality",$_SERVER['argv'][13],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","rv_reservation.rf_country_id",false,"No nationality","0");
$rateFilter = useFilter("rate",$_SERVER['argv'][14],"SELECT rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type_ix=","rv_reservation.rt_rate_type_id",false,false,false);
$statusACL= $lDB->get("
	SELECT DISTINCT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id NOT IN ('15','25','40','50','97')
",3);
//Excluding status 15(Allocation)
//Excluding status 25(In Progress)
//Excluding status 40(Invoiced)
//Excluding status 50(Blocked)
//Excluding status 97(Deleted allocation)
$statusFilter = useFilter("status",$_SERVER['argv'][15],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);			
$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][16],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);
$paymentPlanFilter = useFilter("paymentPlan",$_SERVER['argv'][17],"SELECT IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc) as nameLast FROM ac_pay_plan WHERE ac_pay_plan.ac_pay_plan_ix =","rv_reservation.ac_pay_plan_id",false,false,false);
$serverFilter = useFilter("server",$_SERVER['argv'][21],"SELECT rf_db_description FROM rf_database WHERE rf_db_code=","fn_folio.fn_folio_db",false,"Reservation Office","Res");
$resList = $lDB->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
$serverFilter['where'] = str_replace("'Res'","'".join("','",$resList)."'",$serverFilter['where']);
$componentsFilter = useFilter("components",$_SERVER['argv'][18],"SELECT rt_component.rt_component_desc FROM rt_component WHERE rt_component.rt_component_ix =","rt_component.rt_component_ix",false,false,false);
$taxRateFilter = useFilter("taxRate",$_SERVER['argv'][19],"SELECT rf_tax_rate.rf_tax_rate_desc FROM rf_tax_rate WHERE rf_tax_rate.rf_tax_rate_ix =","rf_tax_rate.rf_tax_rate_ix",false,false,false);
$consultantFilter = useFilter("consultant",$_SERVER['argv'][20],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");

$invoiceStatus = $_SERVER['argv'][24];
if($invoiceStatus < 1 || $invoiceStatus > 3) {
	$invoiceStatus = 3;
}
$GLOBALS['temp']['showInvoicedChecked'] = "";
$GLOBALS['temp']['showUninvoicedChecked'] = "";
$invStatusText = array();
if( ($invoiceStatus & 1) == 1) {
	$GLOBALS['temp']['showInvoicedChecked'] = "checked";
	$invStatusText[] = "Invoiced";
}
if( ($invoiceStatus & 2) == 2) {
	$GLOBALS['temp']['showUninvoicedChecked'] = "checked";
	$invStatusText[] = "Uninvoiced";
}

$checkInclPos = true;
$checkInclNeg = true;
$checkInclZero = true;
$GLOBALS['temp']['checkInclPos'] = "checked";
$GLOBALS['temp']['checkInclNeg'] = "checked";
$GLOBALS['temp']['checkInclZero'] = "";

$amountsFilterText = array();
if($_SERVER['argv'][27] == "0") {
	$checkInclPos = false;
	$GLOBALS['temp']['checkInclPos'] = "";
} else {
	$amountItinSQL[] = "rv_res_item_comp_tax.rv_res_item_comp_tax_amt > 0";
	$amountExtraSQL[] = "rv_extra_amt_tax > 0";
	$amountsFilterText[] = "Include Positive Values";
}
if($_SERVER['argv'][28] == "0") {
	$checkInclNeg = false;
	$GLOBALS['temp']['checkInclNeg'] = "";
} else {
	$amountItinSQL[] = "rv_res_item_comp_tax.rv_res_item_comp_tax_amt < 0";
	$amountExtraSQL[] = "rv_extra_amt_tax < 0";
	$amountsFilterText[] = "Include Negative Values";
}
if($_SERVER['argv'][29] == "1") {
	$checkInclZero = true;
	$GLOBALS['temp']['checkInclZero'] = "checked";
	$amountItinSQL[] = "rv_res_item_comp_tax.rv_res_item_comp_tax_amt = 0";
	$amountExtraSQL[] = "rv_extra_amt_tax = 0";
	$amountsFilterText[] = "Include Zero Values";
}
$amountWhereItinSQL = " AND (".join(" || ",$amountItinSQL).") ";
$amountWhereExtraSQL = " AND (".join(" || ",$amountExtraSQL).") "; 

// *** [START] Billing Options (Invoice From)

$billingList = $lDB->get("
	SELECT DISTINCT
			pr_business.pr_business_id as id,
            pr_persona.pr_name_last as namelast,
			pr_business.pr_bus_billing_yn
	FROM
		fn_folio
		INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
",2);

function getHighestBilling($id) {
	global $lDB;
	$list = $lDB->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$id'
		ORDER BY
			pr_business_sequence
	",3);
	foreach($list as $item) {
		$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$item'",4);
		if($isInvoice == "1") {
			return $item;
		} else {
			return getHighestBilling($item);
		}
	}
	return "";
}

if(trim($_SERVER['argv'][23]) == "") {
	$_SERVER['argv'][23] = $lDB->get("
		SELECT
			pr_business_id
		FROM
			rf_db_business
		WHERE
			rf_db_code = '".$GLOBALS['dbcode']."'
	",4);
	if($_SERVER['argv'][23] == "0" || trim($_SERVER['argv'][23]) == "") {
		$topLevel = $lDB->get("SELECT pr_business_id FROM pr_business WHERE pr_business_parent = '0'",3);
		$finalId = "";
		foreach($topLevel as $topId) {
			$currId = $topId;
			$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
			if($isInvoice == "1") {
				$finalId = $currId; 
				break;
			} else {
				$finalId =	getHighestBilling($currId);
			}			
		}
		$_SERVER['argv'][23] = "";
		if($finalId != "") {
			$_SERVER['argv'][23] = $finalId;
		}
	} else {
		$currId = $_SERVER['argv'][23];
		$finalId = "";
		while($currId != "0" && trim($currId) != "" && $finalId == "") {
			$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
			if($isInvoice == "1") { $finalId = $currId; }
			$currId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($finalId != "") {
			$_SERVER['argv'][23] = $finalId;
		}
	}
}
$billingOptions = "";
foreach($billingList as $billingItem) {
	$selected = "";
	if($_SERVER['argv'][23] == $billingItem['id']) {
		$selected = "selected";
		$billingEntitiesFilter['names'] = $billingItem['namelast'];
	}
	$prefix = "";
	if($billingItem['pr_bus_billing_yn'] != "1") {
		$prefix = "* ";
	}
	$billingOptions .= "<option $selected value=\"$billingItem[id]\">$prefix$billingItem[namelast]</option>";
}
if(trim($_SERVER['argv'][23]) != "") {
	$billingEntitiesFilter['where'] = " AND fn_folio.pr_business_id = '".$_SERVER['argv'][23]."' ";
}
$businessInfo = $lDB->get("
	SELECT
		pr_business.pr_bus_home_curr_id,
		rf_currency.rf_currency_symbol,
		pr_persona.pr_name_last		
	FROM
		pr_business
		INNER JOIN rf_currency  ON rf_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id		
	WHERE
		pr_business_id = '".$_SERVER['argv'][23]."'
",1);
$GLOBALS['temp']['businessCurrencyId'] = $businessInfo['pr_bus_home_curr_id'];
$GLOBALS['temp']['businessCurrencySymbol'] = $businessInfo['rf_currency_symbol'];

$businessName = $businessInfo['pr_name_last'];

$GLOBALS['temp']['billingOptions'] = $billingOptions;

// *** [END] Billing Options (Invoice From)



$folioCurrencyFilter = useFilter("folioCurrency",$_SERVER['argv'][22],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","fn_folio.rf_currency_id",false,false,false);

$invFromD = $_SERVER['argv'][1];
$invToD = $_SERVER['argv'][2];

$trvlFromD = $_SERVER['argv'][4];
$trvlToD = $_SERVER['argv'][5];

$GLOBALS['temp']['checkBalance'] = "";
$GLOBALS['temp']['checkOutstanding'] = "";
$GLOBALS['temp']['overpaidChecked'] = "";
$GLOBALS['temp']['paidChecked'] = "";
$GLOBALS['temp']['tbaChecked'] = "";
$GLOBALS['temp']['checkOutstandingLimit'] = "";
$GLOBALS['temp']['checkOverpaidLimit'] = "";

if($_SERVER['argv'][28] == 1) {
	$checkOutstanding = true;
	$GLOBALS['temp']['checkOutstanding'] = "checked";
}
if($_SERVER['argv'][29] == 1) {
	$checkOutstandingLimit = true;
	$GLOBALS['temp']['checkOutstandingLimit'] = "checked";
}

if($_SERVER['argv'][31] == 1) {
	$checkOverpaid = true;
	$GLOBALS['temp']['checkOverpaid'] = "checked";
}
if($_SERVER['argv'][32] == 1) {
	$checkOverpaidLimit = true;
	$GLOBALS['temp']['checkOverpaidLimit'] = "checked";
}

if($_SERVER['argv'][34] == 1) {
	$checkPaid = true;
	$GLOBALS['temp']['paidChecked'] = "checked";
}
if($_SERVER['argv'][35] == 1) {
	$checkTBA = true;
	$GLOBALS['temp']['tbaChecked'] = "checked";
}

$outstandingLimitType = $_SERVER['argv'][36];
$GLOBALS['temp']['outstandingLimitTypeAbove'] = "";
$GLOBALS['temp']['outstandingLimitTypeBelow'] = "";
if($outstandingLimitType == "above") {
	$GLOBALS['temp']['outstandingLimitTypeAbove'] = "selected";
} else {
	$GLOBALS['temp']['outstandingLimitTypeBelow'] = "selected";
}

$outstandingLimit = $_SERVER['argv'][30];
$GLOBALS['temp']['outstandingLimit'] = $outstandingLimit;

$overpaidLimitType = $_SERVER['argv'][37];
$GLOBALS['temp']['overpaidLimitTypeAbove'] = "";
$GLOBALS['temp']['overpaidLimitTypeBelow'] = "";
if($overpaidLimitType == "above") {
	$GLOBALS['temp']['overpaidLimitTypeAbove'] = "selected";
} else {
	$GLOBALS['temp']['overpaidLimitTypeBelow'] = "selected";
}

$overpaidLimit = $_SERVER['argv'][33];
$GLOBALS['temp']['overpaidLimit'] = $overpaidLimit;

if($_SERVER['argv'][27] == 1) {
	$checkBalance = true;
	$GLOBALS['temp']['checkBalance'] = "checked";
}

// --- Extras

$extraFilterType = $_SERVER['argv'][38];
$GLOBALS['temp']['extraFilterTypeCategory'] = "";
$GLOBALS['temp']['extraFilterTypeExtra'] = "";
if($extraFilterType == "1") {
	$GLOBALS['temp']['extraFilterTypeCategory'] = "checked";
} else {
	$GLOBALS['temp']['extraFilterTypeExtra'] = "checked";
}
$extraCategoryFilter = useFilter("extraCategory", $_SERVER['argv'][39], "SELECT ac_extra_cat_desc  FROM ac_extra_category WHERE ac_extra_category_ix =", "ac_extra_category_id", false, false, false);
$extraFilter = useFilter("extras", $_SERVER['argv'][40], "SELECT ac_ext_desc FROM ac_extra WHERE ac_extra.ac_extra_ix =", "ac_extra.ac_extra_ix", false, false, false);
if($extraFilter['ids'] != "") {
   $catList = $lDB->get("
      SELECT DISTINCT
         ac_extra.ac_extra_category_id,
         ac_extra_category.ac_extra_cat_desc
      FROM
         ac_extra
         INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
      WHERE
         ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
   ",2);
   $extraFilterRows = "";
   $extraFilterIds = "";
   foreach($catList as $item) {
      $extraList = $lDB->get("
         SELECT
            ac_extra.ac_extra_ix as ac_extra_ix,
            ac_ext_desc
         FROM
            ac_extra
         WHERE
            ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
            AND ac_extra.ac_extra_category_id = '".$item['ac_extra_category_id']."'
      ",2);
      $extraNames = "";
      $extraIds = "";
      foreach($extraList as $extraItem) {
         if($extraNames != "") {
            $extraNames .= ", ";
         }
         $extraNames .= $extraItem['ac_ext_desc'];
         if($extraIds != "") {
            $extraIds .= ":";
         }
         $extraIds .= $extraItem['ac_extra_ix'];
      }
      $extraFilterRows .= "
         <tr id=\"extra_$item[ac_extra_category_id]\">
            <td width=\"80\" ><textarea rows=1 style=\"width:80;\" id=\"extraCatText\" class=\"txtg\" readonly tabIndex=\"-1\">$item[ac_extra_cat_desc]</textarea></td>
            <td width=\"300\"><textarea rows=1 style=\"width:300;\" id=\"extraText\" class=\"txtg\" readonly tabIndex=\"-1\">$extraNames</textarea></td>
            <td><input type=button class=\"button bDelete\" style=\"width:20; background-position: center;\" value=\"\" onclick=\"removeExtraIds('".$item['ac_extra_category_id']."');\"></td>
         </tr>
      ";
      $extraFilterIds .= "
         <input type=\"hidden\" id=\"extraIds_$item[ac_extra_category_id]\" name=\"extraIds\" value=\"$extraIds\">
      ";
   }
   $GLOBALS['temp']['extraFilterRows'] = $extraFilterRows;
   $GLOBALS['temp']['extraFilterIds'] = $extraFilterIds;
   $GLOBALS['temp']['extraAllClass'] = "collapse printCollapse";
} else {
   $GLOBALS['temp']['extraFilterRows'] = "";
   $GLOBALS['temp']['extraFilterIds'] = "";
   $GLOBALS['temp']['extraAllClass'] = "";
}

$extraProperty = $_SERVER['argv'][41];
$extraPropertyFilter = "";
$GLOBALS['temp']['extraPropertyChecked'] = "";
if($extraProperty == "1") {
	$GLOBALS['temp']['extraPropertyChecked'] = "checked";
	$extraPropertyList = $lDB->get("SELECT DISTINCT pr_business_id FROM ac_accomm_type WHERE ac_accomm_type_ix IN ('".join("','",explode(":",$accommFilter['ids']))."')",3);
	$extraPropertyFilter = " AND rv_extra.pr_business_id IN ('".join("','",$extraPropertyList)."') ";
}

if($extraFilterType == "1") {
	$extraWhere = $extraCategoryFilter['where'];
} else {
	$extraWhere = $extraFilter['where'];
}
$extraWhere .= " AND rv_extra.rv_extra_void_ind = 0 ";
$extraWhere .= $extraPropertyFilter;


// --- Extras

$displayCurrency = $_SERVER['argv'][46];
if ($displayCurrency == "1"){
	$showGLCurr = " (".$GLOBALS['temp']['businessCurrencySymbol'].")";
	$GLOBALS['temp']['GLCurrencyChecked'] = "selected";
	$GLOBALS['temp']['folioCurrencyChecked'] = "";
	$itinCurrencySelectSQL = "
			(rv_res_item_comp.rv_item_comp_amt_payable * fn_invoice.fn_inv_exch_rate_balance) AS rv_item_comp_amt_payable,
			((rv_res_item_comp.rv_item_comp_amt_payable - rv_res_item_comp.rv_item_comp_amt_tax) * fn_invoice.fn_inv_exch_rate_balance) AS excl_tax,
			rv_res_item_comp_tax.rv_res_item_comp_tax_amt * fn_invoice.fn_inv_exch_rate_balance AS tax_amt,
			((rv_res_item_comp.rv_item_comp_amt_payable - rv_res_item_comp.rv_item_comp_amt_tax) + rv_res_item_comp_tax.rv_res_item_comp_tax_amt) * fn_invoice.fn_inv_exch_rate_balance AS incl_tax,	
	";
	$extraCurrencySelectSQL = "
			(rv_extra.rv_extra_amt_payable - rv_extra_amt_tax) * fn_invoice.fn_inv_exch_rate_balance AS excl_tax,
			rv_extra_amt_tax * fn_invoice.fn_inv_exch_rate_balance AS tax_amt,
			rv_extra.rv_extra_amt_payable * fn_invoice.fn_inv_exch_rate_balance AS incl_tax,
	";	
} else {
	$GLOBALS['temp']['folioCurrencyChecked'] = "selected";
	$GLOBALS['temp']['GLCurrencyChecked'] = "";
	$itinCurrencySelectSQL = "
			rv_res_item_comp.rv_item_comp_amt_payable,
			(rv_res_item_comp.rv_item_comp_amt_payable - rv_res_item_comp.rv_item_comp_amt_tax) AS excl_tax,
			rv_res_item_comp_tax.rv_res_item_comp_tax_amt AS tax_amt,
			(rv_res_item_comp.rv_item_comp_amt_payable - rv_res_item_comp.rv_item_comp_amt_tax) + rv_res_item_comp_tax.rv_res_item_comp_tax_amt AS incl_tax,	
	";
	$extraCurrencySelectSQL = "
			(rv_extra.rv_extra_amt_payable - rv_extra_amt_tax) AS excl_tax,
			rv_extra_amt_tax AS tax_amt,
			rv_extra.rv_extra_amt_payable AS incl_tax,
	";		
}

$taxDetailCols = array();
$taxDetailCols = array(
	array('id'=>'1' , 'label'=>'Tax %', 'type'=>"string", 'fields'=>array("rf_tax_rate_perc"), 'style'=>array('bold'=>"1"), 'width'=>"50", 'align'=>"l"),
	array('id'=>'2' , 'label'=>'Tax Description', 'type'=>"string", 'fields'=>array("rf_tax_rate_desc"), 'style'=>array('bold'=>"1"), 'width'=>"100", 'align'=>"l"),
	array('id'=>'3' , 'label'=>'Revenue component', 'type'=>"string", 'fields'=>array("rev_component"), 'style'=>array('bold'=>"1"), 'width'=>"120", 'align'=>"l"),
);

$taxDetailColArg = $_SERVER['argv'][43];
$colArray = array();
$taxDetailColOrder = array();
$taxDetailColSort = array();
$colHeader = false;
if(trim($taxDetailColArg) != "") {
	$count = 0;
	foreach(explode(":",$taxDetailColArg) as $item) {
		$col = explode(",",$item);
		$colActive[$count] = isset($col[0]) ? $col[0] : "";
		$taxDetailColOrder[$count] = isset($col[1]) ? $col[1] : "";
		$taxDetailColSort[$count] = isset($col[2]) ? $col[2] : "";
		$width = isset($col[3]) ? $col[3] : "";
		if(!is_numeric($width)) {
			$width = isset($taxDetailCols[$count]['width']) ? $taxDetailCols[$count]['width'] : 0;
		}
		$label = isset($col[4]) ? trim(urldecode($col[4])) : "";
		if($label == "") {
			$label = isset($taxDetailCols[$count]['label']) ? $taxDetailCols[$count]['label'] : "";
		}
		$header = isset($col[5]) ? trim($col[5]) : "";
		if($header != "") {
			$colHeader = true;
		}
		$align = isset($col[6]) ? trim($col[6]) : "";
		if($align == "") {
			$align = isset($taxDetailCols[$count]['align']) ? $taxDetailCols[$count]['align'] : "";
		}
		$objType = isset($col[7]) ? trim($col[7]) : "";
		if($objType == "") {
			$objType = isset($taxDetailCols[$count]['objType']) ? $taxDetailCols[$count]['objType'] : "";
		}
		$guestId = isset($col[8]) ? trim($col[8]) : "";
		if($guestId == "") {
			$guestId = isset($taxDetailCols[$count]['rf_obj_guest_ix']) ? $taxDetailCols[$count]['rf_obj_guest_ix'] : "";
		}
		$split = isset($col[9]) ? trim($col[9]) : "";
		$disable = isset($col[10]) ? trim($col[10]) : "";
		if($disable == "") {
			$disable = isset($taxDetailCols[$count]['disable']) ? $taxDetailCols[$count]['disable'] : "";
		}
		
		$colArray[$count] = array(
			"active"=>$col[0],
			"order"=>$col[1],
			"sort"=>$col[2],
			//"direction"=>$col[3],
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"split"=>$split,
			"align"=>$align,
			"objType"=>$objType,
			"disable"=>$disable,
			"rf_obj_guest_ix"=>$guestId
		);
		$taxDetailCols[$count]['active'] = $col[0];
		$taxDetailCols[$count]['order'] = $col[1];
		$taxDetailCols[$count]['sort'] = $col[2];
		$taxDetailCols[$count]['width'] = $width;
		$taxDetailCols[$count]['label'] = $label;
		$taxDetailCols[$count]['header'] = $header;
		$taxDetailCols[$count]['split'] = $split;
		$taxDetailCols[$count]['align'] = $align;
		$taxDetailCols[$count]['objType'] = $objType;
		$taxDetailCols[$count]['rf_obj_guest_ix'] = $guestId;
		$taxDetailCols[$count]['disable'] = $disable;
		$count++;
	}
}
asort($taxDetailColOrder);
asort($taxDetailColSort);
$colData = array();

foreach($taxDetailCols as $colKey=>$colItem) {
	$width = $colItem['width'];
	$sort = "";
	$col_direction = "";
	$label = $colItem['label'];
	$active = "";
	$order = "";
	$header = "";
	$split = "";
	$align = isset($colItem['align']) ? $colItem['align'] : "";
	$objType = isset($colItem['objType']) ? $colItem['objType'] : "";
	$disable = isset($colItem['disable']) ? $colItem['disable'] : "";
	$guestId = isset($colItem['rf_obj_guest_ix']) ? $colItem['rf_obj_guest_ix'] : "";

	if(isset($colArray[$colKey]['active']) && $colArray[$colKey]['active'] == "1") {
		$width = $colArray[$colKey]['width'];
		$sort = $colArray[$colKey]['sort'];
		//$col_direction = $colArray[$colKey]['direction'];		
		$label = $colArray[$colKey]['label'];
		$active = "1";
		$order = $colArray[$colKey]['order'];
		$split = $colArray[$colKey]['split'];
		$header = $colArray[$colKey]['header'];
		$align = $colArray[$colKey]['align'];
		$objType = $colArray[$colKey]['objType'];
		$disable = $colArray[$colKey]['disable'];
		$guestId = $colArray[$colKey]['rf_obj_guest_ix'];
	}
	
		$colDataItem = array(
			'"id":"'.$colItem['id'].'"',
			'"name":"'.$colItem['label'].'"',
			'"width":"'.$width.'"',
			'"sort":"'.$sort.'"',
			'"label":"'.$label.'"',
			'"active":"'.$active.'"',
			'"order":"'.$order.'"',
			'"header":"'.$header.'"',
			'"split":"'.$split.'"',
			'"align":"'.$align.'"',
			'"objType":"'.$objType.'"',
			'"disable":"'.$disable.'"',
			'"rf_obj_guest_ix":"'.$guestId.'"'
		);
	
	array_push($colData,'{'.join(",",$colDataItem)."}\n");
}

$taxDetailColData = '['.join(",",$colData).']';
$GLOBALS['temp']['taxDetailColData'] = $taxDetailColData;

$sort_array = array();
$orderArr = array();
 foreach ($taxDetailCols as $key => $row) {
   $sort_array[$key]  = $row['id'];
   if(empty($row['order']))
		$orderArr[$key]  = 9999;
   else
	   $orderArr[$key]  = $row['order'];
}
array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $taxDetailCols);

$showGLCurr = isset($showGLCurr) ? $showGLCurr : "";
$taxAmountsCols = array();
$taxAmountsCols = array(
	array('id'=>'1' , 'label'=>'Excl. Tax'.$showGLCurr, 'type'=>"string", 'fields'=>array("excl_tax"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"r"),
	array('id'=>'2' , 'label'=>'Tax'.$showGLCurr, 'type'=>"string", 'fields'=>array("tax_amt"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"r"),
	array('id'=>'3' , 'label'=>'Incl. Tax'.$showGLCurr, 'type'=>"string", 'fields'=>array("incl_tax"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"r"),
);

$taxAmountsColArg = $_SERVER['argv'][44];
$colArray = array();
$taxAmountsColOrder = array();
$taxAmountsColSort = array();
$colHeader = false;
if(trim($taxAmountsColArg) != "") {
	$count = 0;
	foreach(explode(":",$taxAmountsColArg) as $item) {
		$col = explode(",",$item);
		$colActive[$count] = isset($col[0]) ? $col[0] : "";
		$taxAmountsColOrder[$count] = isset($col[1]) ? $col[1] : "";
		$taxAmountsColSort[$count] = isset($col[2]) ? $col[2] : "";
		$width = isset($col[3]) ? $col[3] : "";
		if(!is_numeric($width)) {
			$width = isset($taxAmountsCols[$count]['width']) ? $taxAmountsCols[$count]['width'] : 0;
		}
		$label = isset($col[4]) ? trim(urldecode($col[4])) : "";
		if($label == "") {
			$label = isset($taxAmountsCols[$count]['label']) ? $taxAmountsCols[$count]['label'] : "";
		}
		$header = isset($col[5]) ? trim($col[5]) : "";
		if($header != "") {
			$colHeader = true;
		}
		$align = isset($col[6]) ? trim($col[6]) : "";
		if($align == "") {
			$align = isset($taxAmountsCols[$count]['align']) ? $taxAmountsCols[$count]['align'] : "";
		}
		$objType = isset($col[7]) ? trim($col[7]) : "";
		if($objType == "") {
			$objType = isset($taxAmountsCols[$count]['objType']) ? $taxAmountsCols[$count]['objType'] : "";
		}
		$guestId = isset($col[8]) ? trim($col[8]) : "";
		if($guestId == "") {
			$guestId = isset($taxAmountsCols[$count]['rf_obj_guest_ix']) ? $taxAmountsCols[$count]['rf_obj_guest_ix'] : "";
		}
		$split = isset($col[9]) ? trim($col[9]) : "";
		$disable = isset($col[10]) ? trim($col[10]) : "";
		if($disable == "") {
			$disable = isset($taxAmountsCols[$count]['disable']) ? $taxAmountsCols[$count]['disable'] : "";
		}
		
		$colArray[$count] = array(
			"active"=>$col[0],
			"order"=>$col[1],
			"sort"=>$col[2],
			//"direction"=>$col[3],
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"split"=>$split,
			"align"=>$align,
			"objType"=>$objType,
			"disable"=>$disable,
			"rf_obj_guest_ix"=>$guestId
		);
		$taxAmountsCols[$count]['active'] = $col[0];
		$taxAmountsCols[$count]['order'] = $col[1];
		$taxAmountsCols[$count]['sort'] = $col[2];
		$taxAmountsCols[$count]['width'] = $width;
		$taxAmountsCols[$count]['label'] = $label;
		$taxAmountsCols[$count]['header'] = $header;
		$taxAmountsCols[$count]['split'] = $split;
		$taxAmountsCols[$count]['align'] = $align;
		$taxAmountsCols[$count]['objType'] = $objType;
		$taxAmountsCols[$count]['rf_obj_guest_ix'] = $guestId;
		$taxAmountsCols[$count]['disable'] = $disable;
		$count++;
	}
}
asort($taxAmountsColOrder);
asort($taxAmountsColSort);
$colData = array();

foreach($taxAmountsCols as $colKey=>$colItem) {
	$width = $colItem['width'];
	$sort = "";
	$col_direction = "";
	$label = $colItem['label'];
	$active = "";
	$order = "";
	$header = "";
	$split = "";
	$align = $colItem['align'];
	$objType = isset($colItem['objType']) ? $colItem['objType'] : "";
	$disable = isset($colItem['disable']) ? $colItem['disable'] : "";
	$guestId = isset($colItem['rf_obj_guest_ix']) ? $colItem['rf_obj_guest_ix'] : "";

	if(isset($colArray[$colKey]['active']) && $colArray[$colKey]['active'] == "1") {
		$width = $colArray[$colKey]['width'];
		$sort = $colArray[$colKey]['sort'];
		//$col_direction = $colArray[$colKey]['direction'];		
		$label = $colArray[$colKey]['label'];
		$active = "1";
		$order = $colArray[$colKey]['order'];
		$split = $colArray[$colKey]['split'];
		$header = $colArray[$colKey]['header'];
		$align = $colArray[$colKey]['align'];
		$objType = $colArray[$colKey]['objType'];
		$disable = $colArray[$colKey]['disable'];
		$guestId = $colArray[$colKey]['rf_obj_guest_ix'];
	}
	
		$colDataItem = array(
			'"id":"'.$colItem['id'].'"',
			'"name":"'.$colItem['label'].'"',
			'"width":"'.$width.'"',
			'"sort":"'.$sort.'"',
			'"label":"'.$label.'"',
			'"active":"'.$active.'"',
			'"order":"'.$order.'"',
			'"header":"'.$header.'"',
			'"split":"'.$split.'"',
			'"align":"'.$align.'"',
			'"objType":"'.$objType.'"',
			'"disable":"'.$disable.'"',
			'"rf_obj_guest_ix":"'.$guestId.'"'
		);
	
	array_push($colData,'{'.join(",",$colDataItem)."}\n");
}

$taxAmountsColData = '['.join(",",$colData).']';
$GLOBALS['temp']['taxAmountsColData'] = $taxAmountsColData;

$sort_array = array();
$orderArr = array();
 foreach ($taxAmountsCols as $key => $row) {
   $sort_array[$key]  = $row['id'];
   if(empty($row['order']))
		$orderArr[$key]  = 9999;
   else
	   $orderArr[$key]  = $row['order'];
}
array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $taxAmountsCols);


$invFromDate = useDate("invFrom", $invFromD);
$invToDate = useDate("invTo", $invToD);

$totalDisplay = $_SERVER['argv'][3];
if($totalDisplay == "") {
	$totalDisplay = "1";
}

$GLOBALS['temp']['totalByInvoiceDateChecked'] = "checked";
$GLOBALS['temp']['totalByDayChecked'] = "";
if($totalDisplay == "2") {
	$GLOBALS['temp']['totalByDayChecked'] = "checked";
}

switch($trvlFromD) {
case "all":
	$GLOBALS['temp']['trvlDateRangeOptAll'] = "checked=\"checked\"";
	$trvlFromDate = "All";
	$tmpDate = date("Y-m-d");
	$tmpArray = explode("-",$tmpDate);	

	$GLOBALS['temp']['trvlFromY']	= $tmpArray[0];
	$GLOBALS['temp']['trvlFromM']	= $tmpArray[1];
	$GLOBALS['temp']['trvlFromD']	= $tmpArray[2];
	$GLOBALS['temp']['trvlToY']		= $tmpArray[0];
	$GLOBALS['temp']['trvlToM']		= $tmpArray[1];
	$GLOBALS['temp']['trvlToD']		= $tmpArray[2];
	break;
default:
	$GLOBALS['temp']['trvlDateRangeOptCustomDate'] = "checked=\"checked\"";
	$trvlFromDate = useDate("trvlFrom", $trvlFromD);
	$trvlToDate = useDate("trvlTo", $trvlToD);
	break;
}

$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");

$groupBy = explode(":",$_SERVER['argv'][42]);

$groupByArray = array(
	"agent"=>array(
		'name'=>"Agent",
		'select'=>"
			rv_reservation.rv_agent_id AS id@,
			groupTable@.pr_name_last AS name@
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = rv_reservation.rv_agent_id
		",
		'order'=>"
			name@
		",
		'blank'=>"Direct"
	),
	"rateType"=>array(
		'name'=>"Rate type",
		'select'=>"
			groupTable@.rt_rate_type_ix as id@,
			groupTable@.rt_rate_type_desc as name@
		",
		'join'=>"
			LEFT JOIN rt_rate_type AS groupTable@ ON groupTable@.rt_rate_type_ix = rv_reservation.rt_rate_type_id
		",
		'order'=>"
			name@
		",
		'blank'=>"No rate type"
	),
	"status"=>array(
		'name'=>"Status",
		'select'=>"
			groupTable@.rf_reservation_status_id as id@,
			groupTable@.rf_reservation_status_desc as name@
		",
		'join'=>"
			LEFT JOIN rf_reservation_status AS groupTable@ ON groupTable@.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		",
		'order'=>"
			name@
		",
		'blank'=>"No status"
	),
	"reservation_number"=>array(
		'name'=>"Reservation number",
		'select'=>"
			rv_reservation.rv_reservation_ix as id@,
			rv_reservation.rv_reservation_ix as name@
		",
		'join'=>"",
		'order'=>"
			name@
		",
		'blank'=>"No reservation number"
	),
	"reservation_name"=>array(
		'name'=>"Reservation name",
		'select'=>"
			rv_reservation.rv_reservation_ix as id@,
			rv_reservation.rv_res_name as name@
		",
		'join'=>"",
		'order'=>"
			name@
		",
		'blank'=>"No reservation name"
	),
	"debtor"=>array(
		'name'=>"Debtor",
		'select'=>"
			fn_folio.fn_folio_to_id as id@,
			groupTable@.pr_name_first as name@_1,
			groupTable@.pr_name_last as name@_2
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = fn_folio.fn_folio_to_id
		",
		'order'=>"
			name@_1, name@_2
		",
		'blank'=>"No debtor"
	),
	"arrive_date"=>array(
		'name'=>"Arrive Date",
		'select'=>"
			rv_reservation.rv_date_arrive AS id@,
			rv_reservation.rv_date_arrive AS name@	
		",
		'join'=>"
		",
		'order'=>"
			name@
		",
		'blank'=>"No Arrive Date"
	),
	"depart_date"=>array(
		'name'=>"Depart Date",
		'select'=>"
			rv_reservation.rv_date_depart AS id@,
			rv_reservation.rv_date_depart AS name@			
		",
		'join'=>"
		",
		'order'=>"
			name@
		",
		'blank'=>"No Depart Date"
	),
	"invoice_date"=>array(
		'name'=>"Invoice Date",
		'select'=>"
			fn_invoice.fn_inv_date AS id@,
			fn_invoice.fn_inv_date AS name@
		",
		'join'=>"
		",
		'order'=>"
			name@
		",
		'blank'=>"No Invoice Date"
	),
	"tax_rate"=>array(
		'name'=>"Tax rate",
		'select'=>"
			rf_tax_rate.rf_tax_rate_ix as id@,
			rf_tax_rate.rf_tax_rate_desc as name@
		",
		'join'=>"",
		'order'=>"
			name@
		",
		'blank'=>"No tax rate"
	),
	"invoice_status"=>array(
		'name'=>"Invoice Status",
		'select'=>"
			fn_invoice.fn_inv_status_ind AS id@,
			IF(fn_invoice.fn_inv_status_ind=2,'Invoiced','Uninvoiced') AS name@
		",
		'join'=>"
		",
		'order'=>"
			name@
		",
		'blank'=>"Uninvoiced"
	),
	"revenue_component"=>array(
		'name'=>"Revenue component",	
		'itinselect'=>"
			CONCAT('i',rt_component.rt_component_ix) AS id@,
			rt_component.rt_component_desc AS name@
		",
		'extraselect'=>"
			CONCAT('e',ac_extra.ac_extra_ix) AS id@,
			ac_extra.ac_ext_desc AS name@
		",
		'join'=>"
		",
		'order'=>"
			name@
		",
		'blank'=>"No Revenue Component"
	),
	"property"=>array(
		'name'=>"Property",
		'itinselect'=>"
			rv_reservation_item.pr_business_id AS id@,
			groupTable@.pr_name_last AS name@ 
		",
		'extraselect'=>"
			rv_extra.pr_business_id AS id@,
			groupTable@.pr_name_last AS name@ 
		",		
		'itinjoin'=>"
			INNER JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = rv_reservation_item.pr_business_id
		",
		'extrajoin'=>"
			INNER JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = rv_extra.pr_business_id
		",		
		'order'=>"
			name@
		",
		'blank'=>"No property"
	),
	"owner_environment"=>array(
		'name'=>"Owner Environment",
		'select'=>"
			groupTable@.rf_db_code AS id@,
			groupTable@.rf_db_description AS name@
		",
		'join'=>"
			INNER JOIN rf_database AS groupTable@ ON groupTable@.rf_db_code = fn_folio.fn_folio_db
		",
		'order'=>"
			name@
		",
		'blank'=>"No owner environment"
	),
	"invoice_number"=>array(
		'name'=>"Invoice Number",
		'select'=>"
			fn_invoice.fn_invoice_ix AS id@,
			fn_invoice.fn_invoice_ix AS name@
		",
		'join'=>"
		",
		'order'=>"
			name@
		",
		'blank'=>"No Invoice Number"
	)
);

$all = array(
	"all"=>array(
		'name'=>"All",
		'select'=>"
			'' AS id@,
			'All' AS name@
		",
		'order'=>"
			name@
		",
	)
);

ksort($groupByArray);
$groupByArray = array_merge($all, $groupByArray);

$groups = 10;
$GLOBALS['temp']['groupCount'] = $groups;
$groupRowHTML = join("",file(__DIR__ . "/../../../public/html/rep_debtors_group_row.htm"));
for($count=0;$count<$groups;$count++) {
	$groupByOptions = "";
	foreach($groupByArray as $groupByKey=>$groupByItem) {
		$selected = "";
		if(isset($groupBy[$count]) && $groupBy[$count] == $groupByKey) {
			$selected = "selected";
		}
		$groupByOptions .= "
			<option value=\"$groupByKey\" $selected>$groupByItem[name]</option>
		";

	}
	if (isset($groupRows)) {
		$groupRows .= str_replace("!group!",$count,
			str_replace("!level!",$count+1,
			str_replace("!groupByOptions!",$groupByOptions,$groupRowHTML)));
	} else {
		$groupRows = str_replace("!group!",$count,
			str_replace("!level!",$count+1,
			str_replace("!groupByOptions!",$groupByOptions,$groupRowHTML)));
	}
}
$GLOBALS['temp']['groupRows'] = $groupRows;


$renderOption = $_SERVER['argv'][45];

switch ($renderOption & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_CSV:
	$renderMode = "csv";
	$renderType = "email";
	break;
case REP_SEND_CSV:
	$renderMode = "csv";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "view";
	break;
case REP_VIEW_OO:
	$renderMode = "ooffice";
	$renderType = "view";
	break;
}

if($_SERVER['argc'] > 1) {
	$GLOBALS['temp']['reportGenerated'] = "";
	
	$joins = array();
	$itinjoins = array();
	$extrajoins = array();
	$selects = array();
	$itinselects = array();
	$extraselects = array();
	$orders = array();
	for($count=0;$count<$groups;$count++) {
		if($count > 0 && $groupBy[$count] == "all") {
			$groups = $count;
			break;
		}
		if (isset($groupByArray[$groupBy[$count]]['join'])) {
			array_push($joins,str_replace("@",$count,$groupByArray[$groupBy[$count]]['join']));		
		}
		if (isset($groupByArray[$groupBy[$count]]['itinjoin'])) {
			array_push($itinjoins,str_replace("@",$count,$groupByArray[$groupBy[$count]]['itinjoin']));		
		}
		if (isset($groupByArray[$groupBy[$count]]['extrajoin'])) {
			array_push($extrajoins,str_replace("@",$count,$groupByArray[$groupBy[$count]]['extrajoin']));		
		}		
		if (isset($groupByArray[$groupBy[$count]]['select'])) {
			array_push($selects,str_replace("@",$count,$groupByArray[$groupBy[$count]]['select']));
		}		
		if (isset($groupByArray[$groupBy[$count]]['itinselect'])) {
			array_push($itinselects,str_replace("@",$count,$groupByArray[$groupBy[$count]]['itinselect']));
		}
		if (isset($groupByArray[$groupBy[$count]]['extraselect'])) {
			array_push($extraselects,str_replace("@",$count,$groupByArray[$groupBy[$count]]['extraselect']));
		}
		array_push($orders,str_replace("@",$count,$groupByArray[$groupBy[$count]]['order']));
	}

// -------- [START] Accommodation data ----------	

	$sqlSelect = "
		SELECT
			fn_folio.fn_folio_ix,
			fn_folio.fn_folio_amt_tax,
			fn_folio.rf_currency_id,
			fn_invoice.fn_inv_exch_rate_balance,
			rv_res_item_comp.rv_res_item_comp_ix,
			$itinCurrencySelectSQL
			rf_tax_rate.rf_tax_rate_perc,
			rf_tax_rate.rf_tax_rate_desc,
			rt_component.rt_component_desc AS rev_component,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_nights,
			".join(",",$selects)."
			".(count($selects)>0 && count($itinselects)>0 ? "," : " ")."
			".join(",",$itinselects)."
	";

	$sqlFrom = "
		FROM
			rv_res_item_comp_tax
			INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_tax.rv_res_item_comp_id
			INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id			
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			INNER JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp_tax.rf_tax_rate_id
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
			LEFT JOIN pr_persona as pr_ag ON rv_reservation.rv_agent_id = pr_ag.pr_persona_ix
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind = 2	
			".join("\n",$joins)."
			".join("\n",$itinjoins)."
	";

	$sqlWhere = "
		WHERE 1
			$agentWhere
			$amountWhereItinSQL
			".$folioContactFilter['where']."
			".$originatorFilter['where']."
			".$sourceFilter['where']."
			".$createdByFilter['where']."
			".$nationalityFilter['where']."
			".$rateFilter['where']."
			".$statusFilter['where']."
			".$paymentPlanFilter['where']."
			".(isset($resInvCurrencyFilter['where']) ? $resInvCurrencyFilter['where'] : "")."
			".$folioCurrencyFilter['where']."
			".(isset($rateCurrencyFilter['where']) ? $rateCurrencyFilter['where'] : "")."
			".$billingEntitiesFilter['where']."
			".$serverFilter['where']."
			".$componentsFilter['where']."
			".$taxRateFilter['where']."
			".$consultantFilter['where']."
			".$accommFilter['where']."
	";

	if($invoiceStatus < 3) { // not all
		if($invoiceStatus == 1) {
			$sqlWhere .= "
				AND fn_invoice.fn_invoice_ix IS NOT NULL
			";
		} elseif($invoiceStatus == 2) {
			$sqlWhere .= "
				AND fn_invoice.fn_invoice_ix IS NULL
			";
		}
	}	
	
	
	if($totalDisplay  == "2") {	// per day
		$sqlWhere .= " AND
			(
				(rv_reservation_item.rv_item_date_arrive >= '".$invFromDate['jsDate']."' AND rv_reservation_item.rv_item_date_arrive <= '".$invToDate['jsDate']."')
				OR (rv_reservation_item.rv_item_date_depart >= '".$invFromDate['jsDate']."' AND rv_reservation_item.rv_item_date_depart <= '".$invToDate['jsDate']."')
				OR (rv_reservation_item.rv_item_date_arrive < '".$invFromDate['jsDate']."' AND rv_reservation_item.rv_item_date_depart > '".$invToDate['jsDate']."')
			)
		";
	} else {
		$folioDateWhere = "
			fn_folio.fn_folio_date BETWEEN '".$invFromDate['jsDate']."' AND '".$invToDate['jsDate']."'
		";

		$sqlWhere .= "
				AND (
					(/* folio */
						fn_invoice.fn_invoice_ix IS NULL
						AND $folioDateWhere
					) OR (/* invoice */
						fn_invoice.fn_invoice_ix IS NOT NULL
						AND fn_invoice.fn_inv_date BETWEEN '".$invFromDate['jsDate']."' AND '".$invToDate['jsDate']."'
					) 
				)
		";
	}	


	$orderSQL = " ORDER BY ".join(",",$orders);

	$accommodation = $lDB->get($sqlSelect.$sqlFrom.$sqlWhere.$orderSQL,2);

// -------- [END] Accommodation data ----------
	
// -------- [START] Extra data ----------	

	$sqlSelect = "
		SELECT
			fn_folio.rf_currency_id,
			fn_invoice.fn_inv_exch_rate_balance,
			rv_extra.rv_extra_id,
			rv_extra.rv_extra_ix AS extra_id,
			(
				SELECT SUM(rv_extra_tax_amt)
				FROM rv_extra_tax
				WHERE rv_extra_tax.rv_extra_id = extra_id
			) as rv_extra_amt_tax,
			rv_extra.rv_extra_tax_ind,
			rv_extra.rf_tax_id,
			$extraCurrencySelectSQL
			rf_tax_rate.rf_tax_rate_perc,
			rf_tax_rate.rf_tax_rate_desc,
			ac_extra.ac_ext_desc AS rev_component,
			rv_extra.rv_extra_date_serv
			".(count($selects)>0 ? "," : " ")."			
			".join(",", $selects)."
			".(count($extraselects)>0 ? "," : " ")."			
			".join(",",$extraselects)."			
			
	";

	$sqlFrom = "
		FROM
			rv_extra
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id			
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_extra.rf_tax_id			
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			LEFT JOIN pr_persona as pr_ag ON rv_reservation.rv_agent_id = pr_ag.pr_persona_ix
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind = 2	
			".join("\n",$joins)."
			".join("\n",$extrajoins)."
	";

	$sqlWhere = "
		WHERE 1
			$agentWhere
			$extraWhere
			$amountWhereExtraSQL
			".$folioContactFilter['where']."
			".$originatorFilter['where']."
			".$sourceFilter['where']."
			".$createdByFilter['where']."
			".$nationalityFilter['where']."
			".$rateFilter['where']."
			".$statusFilter['where']."
			".$paymentPlanFilter['where']."
			".(isset($resInvCurrencyFilter['where']) ? $resInvCurrencyFilter['where'] : "")."
			".$folioCurrencyFilter['where']."
			".(isset($rateCurrencyFilter['where']) ? $rateCurrencyFilter['where'] : "")."
			".$billingEntitiesFilter['where']."
			".$serverFilter['where']."
			".$consultantFilter['where']."
	";

	if($invoiceStatus < 3) { // not all
		if($invoiceStatus == 1) {
			$sqlWhere .= "
				AND fn_invoice.fn_invoice_ix IS NOT NULL
			";
		} elseif($invoiceStatus == 2) {
			$sqlWhere .= "
				AND fn_invoice.fn_invoice_ix IS NULL
			";
		}
	}	
	
	if($totalDisplay  == "2") {	// per day
		$sqlWhere .= " 		
			AND (
				rv_extra.rv_extra_date_serv = '0000-00-00'
				OR (
					rv_extra.rv_extra_date_serv >= '".$invFromDate['jsDate']."'
					AND rv_extra.rv_extra_date_serv <= '".$invToDate['jsDate']."'
				)
			)		
		";
	} else {

		$folioDateWhere = "
			fn_folio.fn_folio_date BETWEEN '".$invFromDate['jsDate']."' AND '".$invToDate['jsDate']."'
		";
	
		$sqlWhere .= "
				AND (
					(/* folio */
						fn_invoice.fn_invoice_ix IS NULL
						AND $folioDateWhere
					) OR (/* invoice */
						fn_invoice.fn_invoice_ix IS NOT NULL
						AND fn_invoice.fn_inv_date BETWEEN '".$invFromDate['jsDate']."' AND '".$invToDate['jsDate']."'
					) 
				)
		";
	}


	$orderSQL = " ORDER BY ".join(",",$orders);

	$extras = $lDB->get($sqlSelect.$sqlFrom.$sqlWhere.$orderSQL,2);

	$newExtras = array();
	$count = 0;
	$taxFilter = $_SERVER['argv'][19];

	foreach($extras as $extra) {
        $glTaxExhange = $displayCurrency == "1" ? $extra['fn_inv_exch_rate_balance'] : 1;
		if ($extra['rv_extra_tax_ind'] == 20) {
			$taxRates = $lDB->get("
				SELECT
					rv_extra_tax.rf_tax_rate_id,
					rv_extra_tax.rv_extra_tax_perc,
                    rv_extra_tax.rv_extra_tax_amt * " . $glTaxExhange . " AS rv_extra_tax_amt,
					rf_tax_rate.rf_tax_rate_desc
				FROM
					rv_extra
					LEFT JOIN rv_extra_tax on rv_extra_tax.rv_extra_id = rv_extra.rv_extra_ix
					LEFT JOIN rf_tax_rate on rf_tax_rate.rf_tax_rate_ix = rv_extra_tax.rf_tax_rate_id
				WHERE
					rv_extra.rv_extra_ix = '".$extra['extra_id']."'
			",2);

			$total_tax_perc = 0;
			$total_tax_amt = 0;
			foreach ($taxRates as $taxRate) {
				$total_tax_perc += $taxRate['rv_extra_tax_perc'];
				$total_tax_amt += $taxRate['rv_extra_tax_amt'];
			}

			foreach ($taxRates as $taxRate) {
				if (empty($taxFilter) || in_array($taxRate['rf_tax_rate_id'], explode(':', $taxFilter))) {
					$incl_tax = $extra['incl_tax'];
					$excl_tax = $extra['excl_tax'];
					$tax_amt = $extra['tax_amt']/$total_tax_perc * $taxRate['rv_extra_tax_perc'];
					$tax_rate_group_pos = array_search('tax_rate', $groupBy);
					$newExtras[$count] = $extra;
					$newExtras[$count]['rf_tax_id'] = $taxRate['rf_tax_rate_id'];
					$newExtras[$count]['rf_tax_rate_desc'] = $taxRate['rf_tax_rate_desc'];
					$newExtras[$count]['id'.$tax_rate_group_pos] = $taxRate['rf_tax_rate_id'];
					$newExtras[$count]['name'.$tax_rate_group_pos] = $taxRate['rf_tax_rate_desc'];
					$newExtras[$count]['rv_extra_amt_tax'] = $total_tax_amt;
					$newExtras[$count]['excl_tax'] = $excl_tax;
					$newExtras[$count]['tax_amt'] = $tax_amt;
					$newExtras[$count]['incl_tax'] = $excl_tax + $tax_amt;
					$newExtras[$count]['incl_tax'] = $incl_tax;

					$newExtras[$count]['rf_tax_rate_perc'] = $taxRate['rv_extra_tax_perc'];
					$count++;
				}
			}
		} else {
			if (empty($taxFilter) || in_array($extra['rf_tax_id'], explode(':', $taxFilter))) {
				$newExtras[$count] = $extra;
				$count++;
			}
		}
	}
	$extra = $newExtras;
	unset($extras);
	unset($newExtras);
// -------- [END] Extra data ----------

	$accommodation = is_array($accommodation) ? $accommodation : array();
	$extra = is_array($extra) ? $extra : array();
	
	$results = array_merge($accommodation, $extra);

	$data = array();
	$total = array();
	$label = array();
	foreach($results as $item) {
		$curr = array();
		for($count=0;$count<$groups;$count++) {
			if( (isset($item['name'.$count."_1"]) && trim($item['name'.$count."_1"]) != "") || (isset($item['name'.$count."_2"]) && trim($item['name'.$count."_2"]) != "") ) {
				$name = trim($item['name'.$count."_1"] . " " . $item['name'.$count."_2"]);
			} else {
				$name = isset($item['name'.$count]) ? $item['name'.$count] : "";
			}
			if(empty($name)) {
				$name = $groupByArray[$groupBy[$count]]['blank'];
			}
			$label[$count][$item['id'.$count]] = $name;
			array_push($curr,$item['id'.$count]);
		}
		array_push($curr,$item['rf_currency_id']);
		if(!isset($label['currency']) || !is_array($label['currency'])) {
			$label['currency'] = array();
		}
		if(!isset($label['currency'][$item['rf_currency_id']]) || !is_string($label['currency'][$item['rf_currency_id']])) {
			$label['currency'][$item['rf_currency_id']] = $lDB->get("
				SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '".$item['rf_currency_id']."'
			",4);
		}

// [START] Accommodation split by day!		
		
		if (isset($item['rv_item_nights'])) {
			$itemStart = $item['rv_item_date_arrive'];
			list($itemEndYear, $itemEndMonth, $itemEndDay) = explode("-",$item['rv_item_date_depart']);
			$itemEnd = date("Y-m-d",mktime(0,0,0,$itemEndMonth,$itemEndDay-1,$itemEndYear));

			if($totalDisplay  == "2") {
				if($invFromDate['jsDate'] > $item['rv_item_date_arrive']) {
					$finalStart = $invFromDate['jsDate'];
				} else {
					$finalStart = $item['rv_item_date_arrive'];
				}
				if($invToDate['jsDate'] < $item['rv_item_date_depart']) {
					$finalEnd = $invToDate['jsDate'];
				} else {
					$finalEnd = $itemEnd;
				}
				$days = dateSubtract($finalEnd,$finalStart)+1;
				if($item['rv_item_nights'] != 0 && $days != 0) {
					$item['excl_tax'] = $item['excl_tax'] / $item['rv_item_nights'] * $days;
					$item['tax_amt'] = $item['tax_amt'] / $item['rv_item_nights'] * $days;
					$item['incl_tax'] = $item['rv_item_comp_amt_payable'] / $item['rv_item_nights'] * $days;			
				} else {
					$item['excl_tax'] = 0;
					$item['tax_amt'] = 0;
					$item['incl_tax'] = 0;
				}
			}
			
		}
		
// [END] Accommodation split by day!				

		$curr = join("_",$curr);
		if(!isset($data[$curr]) || !is_array($data[$curr])) {
			$data[$curr]['tax_amt'] = $item['tax_amt'];

		} else {
			$data[$curr]['tax_amt'] += $item['tax_amt'];
		}
		$data[$curr]['tax_detail'][] = $item;
	}
	
	foreach ($data as $key => $level){
		$componentArray = array();
		$extraArray = array();
		foreach ($level['tax_detail'] as $tax_detail){
			if (isset($tax_detail['rv_item_nights'])) { // itin
				if (!in_array($tax_detail['rv_res_item_comp_ix'],$componentArray)){
					if (isset($data[$key]['excl_tax'])) {
						$data[$key]['excl_tax'] += $tax_detail['excl_tax'];
					} else {
						$data[$key]['excl_tax'] = $tax_detail['excl_tax'];
					}
				}
				$componentArray[] = $tax_detail['rv_res_item_comp_ix'];
			} else { // extra
				if (!in_array($tax_detail['extra_id'],$extraArray)){
					if (!isset($data[$key]['excl_tax'])) {
						$data[$key]['excl_tax'] = $tax_detail['excl_tax'];
					} else {
						$data[$key]['excl_tax'] += $tax_detail['excl_tax'];
					}
					$extraArray[] = $tax_detail['extra_id'];
				}
			}
		}	
		$data[$key]['incl_tax'] = $data[$key]['excl_tax'] + $data[$key]['tax_amt'];
	}

	
	
	foreach ($data as $key => $level){
		foreach ($level['tax_detail'] as $tax_detail){
			if (isset($total[$tax_detail['rf_currency_id']]['tax_amt'])) {
				$total[$tax_detail['rf_currency_id']]['tax_amt'] += $tax_detail['tax_amt'] ;
			} else {
				$total[$tax_detail['rf_currency_id']]['tax_amt'] = $tax_detail['tax_amt'] ;
			}
			if (isset($total[$tax_detail['rf_currency_id']]['excl_tax'])) {
				$total[$tax_detail['rf_currency_id']]['excl_tax'] += $tax_detail['excl_tax'] ;
			} else {
				$total[$tax_detail['rf_currency_id']]['excl_tax'] = $tax_detail['excl_tax'] ;
			}
			if (isset($total[$tax_detail['rf_currency_id']]['incl_tax'])) {
				$total[$tax_detail['rf_currency_id']]['incl_tax'] += ($tax_detail['excl_tax'] + $tax_detail['tax_amt']) ;
			} else {
				$total[$tax_detail['rf_currency_id']]['incl_tax'] = ($tax_detail['excl_tax'] + $tax_detail['tax_amt']) ;
			}
		}	
	}

	ksort($data);
	
	if ( isset($renderMode) && $renderMode == "csv" && isset($renderType) && $renderType == "email" ) {
		outputMail($form,$renderOption);
	}	

	if(isset($renderMode) && $renderMode == "html") {
		session_set("reportURL","reservation.php?" . join("+",$_SERVER['argv']));
		$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");

		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";

		$width = 0;
		$rows = "";
		$cols = "";

		// *** [START] Headers
		$taxDetailColCount = 0;
		$taxAmountsColCount = 0;
		foreach($taxDetailCols as $col) {
			if($col['active'] == 1) {
				$taxDetailColCount++;
			}
		}
		foreach($taxAmountsCols as $col) {

			if($col['active'] == 1) {
				$taxAmountsColCount++;
			}
		}		
		$rows .= "
			<tr>
				<td colspan=\"".($groups+1)."\" class=\"outDk\" align=\"left\">Grouping</td>
		";
		if ($taxDetailColCount > 0){
			$rows .= "			
					<td colspan=\"".($taxDetailColCount)."\" class=\"outDk\" align=\"center\">Tax details</td>
			";
		}
		if ($taxAmountsColCount > 0){
			$rows .= "					
					<td colspan=\"".($taxAmountsColCount)."\" class=\"outDk\" align=\"center\">Tax amounts</td>				
			";
		}
		$rows .= "			
			</tr>
		";	
		
		
		$rows .= "
			<tr>
		";		
		for($count=0;$count<$groups;$count++) { 
			$width += 200;
			$cols .= "
				<col width=\"200\" />
			";
			$rows .= "
				<td class=\"outDk\" align=\"left\">".$groupByArray[$groupBy[$count]]['name']."</td>
			";
		}
		$width += 40;
		$cols .= "
			<col width=\"40\" />
		";
		$rows .= "
			<td class=\"outDk\" align=\"center\">Curr</td>
		";
		
		foreach($taxDetailCols as $col) {
			
			if($col['align'] == "r") {
				$align = "right";
			} else if($col['align'] == "c") {
				$align = "center";
			} else {
				$align = "left";
			}
			if($col['active'] == 1) {
				$width += $col['width'];
				$cols .= "
					<col width=\"".$col['width']."\" />
				";
				$rows .= "
					<td class=\"outDk\" align = '$align'>".$col['label']."</td>
				";
			}
		}		
		
		foreach($taxAmountsCols as $col) {
			
			if($col['align'] == "r") {
				$align = "right";
			} else if($col['align'] == "c") {
				$align = "center";
			} else {
				$align = "left";
			}
			if($col['active'] == 1) {

				$width += $col['width'];
				$cols .= "
					<col width=\"".$col['width']."\" />
				";
				$rows .= "
					<td class=\"outDk\" align = '$align'>".$col['label'].$showGLCurr."</td>
				";

			}
		}
		$rows .= "
			</tr>
		";			
		
		// *** [END] Headers

		foreach($data as $key=>$item) {
			$groupKeys = explode("_",$key);
			$rows .= "
				<tr class=\"imgLink\">
			";			
			$count = 0;
			for($count=0; $count<sizeof($groupKeys)-1; $count++) {
				$finalLabel = $label[$count][$groupKeys[$count]];
				if(empty($finalLabel)) {
					$finalLabel = "&nbsp;";
				}
				$rows .= "
					<td class=\"Ltln bt\" align=\"left\">".$finalLabel."</td>
				";
			}
			$rows .= "
				<td class=\"Ltln br bt\" align=\"center\">".$label['currency'][$groupKeys[sizeof($groupKeys)-1]]."</td>
			";			

			foreach($taxDetailCols as $col) {
				if($col['active'] == 1) {
					$rows .= "
						<td class=\"Ltln bt\">&nbsp;</td>
					";
				}
			}				
			
			$firstFolioAmount = true;
			foreach($taxAmountsCols as $col) {
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}
				if($col['active'] == 1) {
					
					$finalLabel = $item[$col['fields'][0]];
					fixAmtDisplay($finalLabel);
					
					if ($firstFolioAmount){
						$rows .= "
							<td align='$align' class=\"Ltln bl bt\">".$finalLabel."</td>
						";					
					} else {
						$rows .= "
							<td align='$align' class=\"Ltln bt\">".$finalLabel."</td>
						";	
					}
					$firstFolioAmount = false;
				}
			}			
			
			$rows .= "
				</tr>
			";
			
			// If we want tax detail, create new rows
			if ($taxDetailColCount > 0){
				foreach($item['tax_detail'] as $tax_detail){
		
					// $onclick = "onclick=\"window.location = '/reservation.php?647+".$tax_detail['rv_reservation_ix']."';\"";
					// $onMouseOver = "onmouseover=\"rowOn(this);\"";
					// $onMouseOut = "onmouseout=\"rowOff(this);\"";
					$onclick = isset($onclick) ? $onclick : "";
					$onMouseOver = isset($onMouseOver) ? $onMouseOver : "";
					$onMouseOut = isset($onMouseOut) ? $onMouseOut : "";
					$rows .= "
						<tr $onclick $onMouseOver $onMouseOut>
							<td colspan=\"".($groups+1)."\">&nbsp;</td>
					";
					
					foreach($taxDetailCols as $subCol) {
						
						if($subCol['align'] == "r") {
							$align = "right";
						} else if($subCol['align'] == "c") {
							$align = "center";
						} else {
							$align = "left";
						}
						if($subCol['active'] == 1) {

							$finalLabel = $tax_detail[$subCol['fields'][0]];
							//fixAmtDisplay($finalLabel);

							$rows .= "
								<td align='$align' style=\"white-space: nowrap; overflow: hidden;\">".$finalLabel."</td>
							";					
						}
					}

					foreach($taxAmountsCols as $subCol) {
						
						if($subCol['align'] == "r") {
							$align = "right";
						} else if($subCol['align'] == "c") {
							$align = "center";
						} else {
							$align = "left";
						}
						if($subCol['active'] == 1) {
							
							$finalLabel = $tax_detail[$subCol['fields'][0]];
							fixAmtDisplay($finalLabel);

							$rows .= "
								<td align='$align'>".$finalLabel."</td>
							";	
								
						}
					}					
					
					$rows .= "
						</tr>
					";					
				}
			}
		
		}
		
		// *** [START] Total rows
		foreach ($total as $currency => $totalItem){
			$rows .= "
				<tr>
					<td colspan=\"".($groups)."\" class=\"outLt txtb bt\" align=\"left\">Total</td>
					<td class=\"outLt txtb bt\" align=\"center\">".$label['currency'][$currency]."</td>
			";
			foreach($taxDetailCols as $col) {
				if($col['active'] == 1) {
					$rows .= "
						<td class=\"outLt bt\">&nbsp;</td>
					";					
				}
			}
			foreach($taxAmountsCols as $col) {
				
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}
				if($col['active'] == 1) {

					$finalLabel = $totalItem[$col['fields'][0]];
					fixAmtDisplay($finalLabel);

					$rows .= "
						<td align='$align' class=\"outLt txtb bt\">".$finalLabel."</td>
					";					
				}
			}

			$rows .= "
				</tr>
			";		
		}
		// *** [END] Total row			
		
		
		$GLOBALS['temp']['dataWidth'] = $width;
		$GLOBALS['temp']['cols'] = $cols;
		$GLOBALS['temp']['rows'] = $rows;
		 
		if(sizeof($data) == 0) {
			$GLOBALS['temp']['dataWidth'] = 750;
			$GLOBALS['temp']['cols'] = "<col width=\"750\">";
			$GLOBALS['temp']['rows'] = "
				<tr>
					<td class=\"txti\" align=\"center\">No data matched your filter criteria.</td> 
				</tr>
			";
		}	
	
	}
	
	if(isset($renderMode) && in_array($renderMode, array("csv","ooffice"))) {

		define("COLWIDTH",150);
		$rows = array();
		$cells = array();
		$tables = array();
		$multiCell = array();
		$tempCell = array();
		$tempCell_nxt = array();
		$rowCount = 1;
		$multiCell[$rowCount] = array();	
		
		$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
		$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
		$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
		$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

		$defaultStyle = array( 
			'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
			'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
			'font' => array('Size' => '8')
		);
		
		$xls = new XLS($defaultStyle);

		$header_style = array( 
			'interior' => array('Color' => '#dbc790', 'Pattern'=>'Solid'),
			'font' =>array('Bold' => '1'),
			'border' => array($borderL, $borderR, $borderT, $borderB)
		);
						
		$header_styleId = $xls->addStyle($header_style);

		$group_style = array( 
			'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
			'font' =>array('Bold' => '1'),
			'border' => array($borderL, $borderR, $borderT, $borderB)
		);
						
		$group_styleId = $xls->addStyle($group_style);		
		
		$cell_style = array( 
			'interior' => array('Pattern'=>'Solid'),
			'border' => array($borderL, $borderR, $borderT, $borderB)
		);

		$cell_styleLR = array( 
			'interior' => array('Pattern'=>'Solid'),
			'border' => array($borderL, $borderR)
		);

		$cell_styleLRT = array( 
			'interior' => array('Pattern'=>'Solid'),
			'border' => array($borderL, $borderR, $borderT)
		);

		$cell_styleLRB = array( 
			'interior' => array('Pattern'=>'Solid'),
			'border' => array($borderL, $borderR, $borderB)
		);
						
		$cell_styleId = $xls->addStyle($cell_style);
		$cell_styleIdLR = $xls->addStyle($cell_styleLR);
		$cell_styleIdLRT = $xls->addStyle($cell_styleLRT);
		$cell_styleIdLRB = $xls->addStyle($cell_styleLRB);
		
		$xls->Column(COLWIDTH,1,0);
		$xls->Column(COLWIDTH,1,0);		

		
		// *** [START] Headers
		$taxDetailColCount = 0;
		$taxAmountsColCount = 0;

		for($count=0;$count<$groups;$count++) { 
			$xls->Column(200,1,0);

		}
		
		foreach($taxDetailCols as $col) {
			if($col['active'] == 1) {
				$taxDetailColCount++;
				$xls->Column($col['width'],1,0);
			}
		}
		foreach($taxAmountsCols as $col) {

			if($col['active'] == 1) {
				$taxAmountsColCount++;
				$xls->Column($col['width'],1,0);
			}
		}	

		$cell = $xls->Cell(array('type'=>'String', 'data' => "Grouping"), $header_styleId, '', '', '', '', $groups);
		array_push($tempCell, $cell);		
		
		if($taxDetailColCount > 0) {
			$cell = $xls->Cell(array('type'=>'String', 'data' => "Tax details"), $header_styleId, '', '', '', '', $taxDetailColCount-1);
			array_push($tempCell, $cell);
		}
		if($taxAmountsColCount > 0) {
			$cell = $xls->Cell(array('type'=>'String', 'data' => "Tax amounts"), $header_styleId, '', '', '', '', $taxAmountsColCount-1);
			array_push($tempCell, $cell);
		}

		array_push($multiCell[$rowCount], $tempCell);
		$tempCell = array();
		$rowCount += 1;
		$multiCell[$rowCount] = array();


		for($count=0;$count<$groups;$count++) { 
			$cell = $xls->Cell(array('type'=>'String', 'data' => $groupByArray[$groupBy[$count]]['name']), $header_styleId, '', '', '', '');
			array_push($tempCell, $cell);

		}
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Curr"), $header_styleId, '', '', '', '');
		array_push($tempCell, $cell);

		foreach($taxDetailCols as $col) {
			if($col['active'] == 1) {
				$cell = $xls->Cell(array('type'=>'String', 'data' => $col['label']), $header_styleId, '', '', '', '');
				array_push($tempCell, $cell);				
			}
		}		
		
		foreach($taxAmountsCols as $col) {
			if($col['active'] == 1) {
				$cell = $xls->Cell(array('type'=>'String', 'data' => $col['label']), $header_styleId, '', '', '', '');
				array_push($tempCell, $cell);	
			}
		}

		array_push($multiCell[$rowCount], $tempCell);
		$tempCell = array();
		$rowCount += 1;
		$multiCell[$rowCount] = array();	
		
		// *** [END] Headers		
		
		// *** [START] Data		

		foreach($data as $key=>$item) {
			$groupKeys = explode("_",$key);

			$count = 0;
			for($count=0; $count<sizeof($groupKeys)-1; $count++) {
				$finalLabel = $label[$count][$groupKeys[$count]];
				if(empty($finalLabel)) {
					$finalLabel = "";
				}
				$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $group_styleId, '', '', '', '');
				array_push($tempCell, $cell);	
			}
		
			$cell = $xls->Cell(array('type'=>'String', 'data' => $label['currency'][$groupKeys[sizeof($groupKeys)-1]]), $group_styleId, '', '', '', '');
			array_push($tempCell, $cell);			

			foreach($taxDetailCols as $col) {
				if($col['active'] == 1) {
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $group_styleId, '', '', '', '');
					array_push($tempCell, $cell);	
				}
			}				
			
			foreach($taxAmountsCols as $col) {
				
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}
				if($col['active'] == 1) {

					$finalLabel = $item[$col['fields'][0]];
					fixAmtDisplay($finalLabel);

					$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $group_styleId, '', '', '', '');
					array_push($tempCell, $cell);					
				}
			}			
			
			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount += 1;
			$multiCell[$rowCount] = array();
			
			// If we want tax detail, create new rows
			if ($taxDetailColCount > 0){
				foreach($item['tax_detail'] as $tax_detail){
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $cell_styleId, '', '', '', '', $groups);
					array_push($tempCell, $cell);						
					
					foreach($taxDetailCols as $subCol) {

						if($subCol['active'] == 1) {

							$finalLabel = $tax_detail[$subCol['fields'][0]];

							$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $cell_styleId, '', '', '', '');
							array_push($tempCell, $cell);				
						}
					}

					foreach($taxAmountsCols as $subCol) {
						if($subCol['active'] == 1) {

							$finalLabel = $tax_detail[$subCol['fields'][0]];
							fixAmtDisplay($finalLabel);

							$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $cell_styleId, '', '', '', '');
							array_push($tempCell, $cell);
					
						}
					}					
					
					array_push($multiCell[$rowCount], $tempCell);
					$tempCell = array();
					$rowCount += 1;
					$multiCell[$rowCount] = array();				
				}
			}
		
		}		

		
		// *** [END] Data	
		
		// *** [START] Total rows
		foreach ($total as $currency => $totalItem){
			$cell = $xls->Cell(array('type'=>'String', 'data' => "Total"), $header_styleId, '', '', '', '',$groups-1);
			array_push($tempCell, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data' => $label['currency'][$currency]), $header_styleId, '', '', '', '');
			array_push($tempCell, $cell);						
			foreach($taxDetailCols as $col) {
				if($col['active'] == 1) {
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $header_styleId, '', '', '', '');
					array_push($tempCell, $cell);						
				}
			}
			foreach($taxAmountsCols as $col) {

				if($col['active'] == 1) {

					$finalLabel = $totalItem[$col['fields'][0]];
					fixAmtDisplay($finalLabel);

					$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $header_styleId, '', '', '', '');
					array_push($tempCell, $cell);					
				}
			}

			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount += 1;
			$multiCell[$rowCount] = array();		
		}
		
		// *** [END] Total row			

		// *** [START] Summary Block

		$tempCell = array();
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Filter Summary"), $header_styleId, '', '', '', '', 1);
		array_push($tempCell, $cell);	
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();	
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Invoice From"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $billingEntitiesFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Invoice Status"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => join(',',$invStatusText)), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Display Currency"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $displayCurrency=="0"?"Folio Currency":"GL Currency"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Amounts"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => join(',',$amountsFilterText)), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Date Range"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $invFromDate['jsDate'] . " to " . $invToDate['jsDate']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Display Totals As"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $totalDisplay=="2"?"Per Day":"By invoice date"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Tax Rate"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $taxRateFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Property / Accomm"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $accommFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Category"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $extraCategoryFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Extra"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $extraFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();		
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Components"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $componentsFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Owner Environment"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $serverFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Rate Type"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $rateFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Status"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $statusFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();

		// *** [END] Summary Block
		

		$cells = array();
		$rows = array();
		$temparr=array();
		$headerFlag = 1;
		
		foreach($multiCell as $rowId=>$temparr) {
			foreach($temparr as $cellArr) {
				foreach($cellArr as $tmp) {
					array_push($cells,$tmp);
				}
				
				if($headerFlag<=3) {
					$row = $xls->Row($cells, 20, 1);
				} else {
					$row = $xls->Row($cells);
				}
				$cells = array();
				array_push($rows,$row);
			}
			$headerFlag++;
		}	
		
		$table = $xls->Table($rows);
		array_push($tables, $table);
		$xls->Worksheet($tables);
		if ( isset($renderType) && $renderType == 'view' ) {
			$fromDate = date("d-m-Y");
			$csvName = "tax_analysis_$fromDate";		
			if ( isset($renderMode) && $renderMode == "ooffice" ) {
				$repName = $csvName.".xml";
				$repType = "xml";
			} else {
				$repName = $csvName.".xlsx";
				$repType = "xls";
			}			
			$xls->genrateWorkbook($repName, $repType);
		}		
			
		if ( isset($renderType) && $renderType == 'send' ) {
			$fromDate = date("d-m-Y");
			$csvName = "tax_analysis_$fromDate";		
			if ( isset($renderMode) && $renderMode == "ooffice" ) {
				$repName = $csvName.".xml";
				$repType = "xml";
			} else {
				$repName = $csvName.".xlsx";
				$repType = "xls";
			}

			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = stripslashes($_POST['mail_subj']);
			$message = stripslashes($_POST['mail_body']);
			$attachmentName = $_POST['attachmentName'];
			global $princName;

			$headers = "From: ".$princName."<$from>\r\n";
			$xlsSheet = $xls->genrateWorkbook($repName, $repType, 1);
			
			// and now mail it
			if ( $attachmentName != '!attachmentName!' ) {
				$pdfName = $attachmentName;
			} else {
				$pdfName = $repName;
			}

			// (from, to, subject, headers, message, action, emailID, resID)
			$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$xlsSheet,$pdfName);

			if ( !$error ) {
				echo '
							<script type="text/javascript" charset="utf-8">
								// <![CDATA[
								if ( opener && !opener.closed ) {
									opener.openMessage("Your email has been sent.");
								}
								window.close();
								// ]]>
							</script>
						</body>
					</html>
				';
				die();
			} else {
				echo '
							<script type="text/javascript" charset="utf-8">
								// <![CDATA[
								if ( opener && !opener.closed ) {
									opener.openMessage("Error sending email!");
								}
								window.close();
								// ]]>
							</script>
						</body>
					</html>
				';
				die();
			}
		}		
	}

	
} else {
	$GLOBALS['temp']['reportGenerated'] = " class=\"collapse printCollapse\" ";
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
	$GLOBALS['temp']['filterStatus'] = "";		
}

