<?php

/*
 * $Id: init.form2005.php,v 1.1 2012-06-13 16:59:14 light Exp $
 *
 * $Log: init.form2005.php,v $
 * Revision 1.1  2012-06-13 16:59:14  light
 * Bug #7917 - GRM: Import Tripsheet information
 *
 */

/**
 * init.form2005.php - Guest Tripsheet Select
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/guest_tripsheet_select.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if ($pmode == 1){ // Copying the guest
	if ($_SERVER['argv'][1] != ""){
		$resID = $_SERVER['argv'][1];
	}

	if ($_SERVER['argv'][2] != ""){
		$fromGuestID = $_SERVER['argv'][2];
	}

	if ($_SERVER['argv'][3] != ""){
		$toGuestID = $_SERVER['argv'][3];
	}

	$trip_obj_details = $lDB->get("
		SELECT 
			rf_obj_trip_ix, rf_obj_trip_label, rf_obj_trip_sort_seq, 
			rf_obj_trip_type_ind, rf_obj_trip_mandatory_yn, rf_obj_trip_inactive_yn,
			rf_obj_trip_prop.pr_business_id,
			pr_persona.pr_name_last
		FROM 
			rf_obj_trip 
			INNER JOIN rf_obj_trip_prop ON rf_obj_trip.rf_obj_trip_ix = rf_obj_trip_prop.rf_obj_trip_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rf_obj_trip_prop.pr_business_id
		ORDER BY 
			rf_obj_trip_prop.pr_business_id, rf_obj_trip.rf_obj_trip_sort_seq
	", 2);

	$audit = new AuditTrail($toGuestID, TYPE_PERSONA, ['rv_reservation_id'=>$resID]);

	// Delete all current rv_trip_obj_data for the TO guest on this reservation
	db_rv_trip_obj_data_delete_by_guest($toGuestID, $resID, $audit);


	// Get tripsheet info for FROM guest
	$trip_obj_details_from = $lDB->get("
		SELECT
			rv_trip_obj_data.rf_obj_trip_id,
			rv_trip_obj_data.pr_business_id,
			rv_trip_obj_data.rv_trip_obj_data,
			rv_trip_obj_data.rf_obj_trip_data_id,
			rf_obj_trip.rf_obj_trip_type_ind
		FROM
			rv_trip_obj_data
			INNER JOIN rf_obj_trip ON rf_obj_trip.rf_obj_trip_ix = rv_trip_obj_data.rf_obj_trip_id
		WHERE 
			rv_trip_obj_data.rv_reservation_id = '".$resID."'
			AND rv_trip_obj_data.pr_guest_id = '".$fromGuestID."'
	",2);	

	// Now insert one for each guest record
	foreach($trip_obj_details_from as $trip_obj) {
		$data_field = 'rv_trip_obj_data';
		$rf_obj_trip_type_ind = $trip_obj['rf_obj_trip_type_ind'];
		if($rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_RADIO || $rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_CHECKBOX || $rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_SELECTBOX) {
			$data_field = 'rf_obj_trip_data_id';
		}

		$rv_trip_obj_data_id = db_rv_trip_obj_data_insert($trip_obj['rf_obj_trip_id'], $toGuestID, $resID, $trip_obj['pr_business_id'], $trip_obj[$data_field], $rf_obj_trip_type_ind);
		$all = db_rv_trip_obj_data_get_all($rv_trip_obj_data_id);
		$audit->addDetail("", $all['id'], "", $rv_trip_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "tripsheet", "rv_trip_obj_data.", $trip_obj['rf_obj_trip_id'], "", $all['value']);
	}
	
	$audit->save("Tripsheet details (Copy)");
	// Return success code
	die("1");

} else { // Guest select

	if ($_SERVER['argv'][1] != ""){
		$resID = $_SERVER['argv'][1];
	}

	if ($_SERVER['argv'][2] != ""){
		$excludeGuestID = $_SERVER['argv'][2];
	} else {
		$excludeGuestID = "";
	}

	if ($excludeGuestID != ""){
		$excludeSQL = " AND rv_res_item_guest.pr_guest_id != '".$excludeGuestID."'";
	} else {
		$excludeSQL = "";
	}

	$guests = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart
		FROM
			pr_persona
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.pr_guest_id = pr_persona.pr_persona_ix
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_guest.rv_reservation_item_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN rv_trip_obj_data ON rv_trip_obj_data.pr_guest_id = pr_persona.pr_persona_ix 
				AND rv_trip_obj_data.rv_reservation_id = rv_reservation_item.rv_reservation_id
		WHERE
			rv_reservation_item.rv_reservation_id = '".$resID."'
			$excludeSQL
	",2);

	$guestRows = "";
	$guestRowHTML = join("",file(__DIR__ . "/../../../public/html/guest_tripsheet_select_row.htm"));
	if (count($guests) > 0){
		foreach($guests as $guest){
			$guestRows .= 	str_replace("!guest_id!", $guest['pr_persona_ix'],
							str_replace("!lastname!", $guest['pr_name_last'], 
							str_replace("!firstname!", $guest['pr_name_first'], 
							str_replace("!accommtype!", $guest['ac_accomm_desc'], 
							str_replace("!traveldate!", $guest['rv_item_date_arrive']." to ".$guest['rv_item_date_depart'], $guestRowHTML)))));
		}
	} else {
		$guestRows = "
			<tr>
				<td class=\"\" colspan=\"6\" align=\"center\" style=\"width: 520px\">There were no guests found on this reservation with tripsheet information</td>
			</tr>
		";
	}
	
	$GLOBALS['temp']['guestRows'] = $guestRows;

}

