<?php

/* 
 * $Id: init.form2007.func.php,v 1.1 2012-11-29 16:11:28 light Exp $
 * 
 * $Log: init.form2007.func.php,v $
 * Revision 1.1  2012-11-29 16:11:28  light
 * Bug #7570 - Debtors Statements
 *
 */

 /**
  * init.form2007.func.php - Customer statement report function file
  * Job: 2008
  * Function: 2000 (Reports Financials: Customer Statement)
  */

require_once(__DIR__ . '/class.report.php');
require_once(__DIR__ . '/functions.pdf.php');

require_once(__DIR__ . "/init.form2007.func.report.php");

function getDebtor($firstName,$lastName) {
	$name = trim($firstName . " " . $lastName);

	if(empty($name)) { return "Cash"; }
	
	return $name;
}

function getContactNameConcat($pr_name_first,$pr_name_last) {
	$name = trim($pr_name_first . " " . $pr_name_last);

	if($name != "") {
		return $name;
	} else {
		return "No contact";
	}
}

// Used for contacts and debtors
function getContactPhone($personaId) {
	global $lDB;
	
	$tel = $lDB->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}
// Used for contacts and debtors
function getCountry($countryId) {
	global $lDB;
	
	$country = $lDB->get("
		SELECT
			rf_country.rf_country_name
		FROM
			rf_country
		WHERE
			rf_country.rf_country_ix = '$countryId'
	",4);
	if (trim($country) == "" || $country == "0") {
		$country = "";
	}
	return $country;
}

function getFolioOutstanding($folios) {
	$total = 0;
	foreach($folios as $folio) {
		$total += $folio['fn_folio.fn_folio_amount'] - $folio['fn_folio.fn_folio_amt_paid'];
	}
	return $total;
}

function getKeys($item) {
	return array_map("getSubKey",$item['reservations']);
}

function getSubKey($item) {
	return $item['id'];
}

function resArray($items,$field) {
	$res = array();
	foreach($items as $item) {
		$res[$item[$field]] = array(
			'id'=>$item[$field],
			'rv_reservation_id'=>$item['rv_reservation.rv_reservation_ix'],
			'rv_res_name'=>$item['rv_reservation.rv_res_name'],
			'rate_type'=>$item['rv_reservation.rate_type'],
			'rv_date_arrive'=>$item['rv_reservation.rv_date_arrive'],
			'rv_date_depart'=>$item['rv_reservation.rv_date_depart'],
			'rv_agent_ref'=>$item['rv_reservation.rv_agent_ref'],
			'pay_plan'=>$item['rv_reservation.pay_plan'],
			'contact_persona.rv_corr_persona_name'=>$item['contact_persona.rv_corr_persona_name'],
			'contact_persona.rv_corr_persona_email'=>$item['contact_persona.rv_corr_persona_email'],
			'contact_persona.rv_corr_persona_telephone'=>(isset($item['contact_persona.rv_corr_persona_telephone']) ? $item['contact_persona.rv_corr_persona_telephone'] : ""),
			'folios'=>array()
		);

		$res[$item[$field]]['pay_plan_items'][$item['rv_pay_plan_item.rv_pay_plan_item_ix']] = array(
			'rv_pay_plan_date'=>$item['rv_pay_plan_item.rv_pay_plan_date'],
			'rv_pay_plan_amount'=>$item['rv_pay_plan_item.rv_pay_plan_amount']
		);

	}
	return $res;
}

function getPayPlan($ac_pay_plan_id){
	global $lDB;
	
	$payPlan = $lDB->get("
		SELECT
			ac_pay_plan.ac_pay_plan_desc
		FROM
			ac_pay_plan
		WHERE
			ac_pay_plan.ac_pay_plan_ix = '$ac_pay_plan_id'
	",4);
	if (trim($payPlan) == "" || $payPlan == "0") {
		$payPlan = "";
	}
	return $payPlan;	
}

function formatField($field,$format) {

	switch($format) {
	case "percent":
		return sprintf("%.2f",round($field * 100,2)) . "%";
		break;
	case "date":
		return date("d-M-y",strtotime($field));
		break;		
	case "integer":
		return sprintf("%d",round($field,0));
		break;
	case "average":
	case "amount":
		return number_format(round($field,2),2);
		break;
	default:
		break;
	}
}

function getBedNights($rv_item_accomm_count,$rv_item_nights,$rv_item_adult_count,$rv_item_child_count){
	return $rv_item_accomm_count * $rv_item_nights * ($rv_item_adult_count + $rv_item_child_count);
}