<?php

 /**
  * init.form2007.func.report.php - Customer statement report class file
  * Job: 2008
  * Function: 2000 (Reports Financials: Customer Statement)
  */

class custPDF extends PDF
{
	function Footer() {
		$this->SetLeftMargin(10);
		$this->SetRightMargin(10);
		parent::Footer();
	}

}

class CustomerStatementReport extends Report {
	var $billingEntity;
	var $summaryOnly;

	function Config() {

		// Set any global Report properties
		$this->FilterWidths['label'] = "150";
		$this->FilterWidths['button'] = "150";

		//$this->RenderOptions =array("openPDF","openCSV");
		$this->RenderOptions =array("emailSelected","openPDF");
		// $this->RenderOptions =array("openPDF");

		$this->Fields = array(
			array('name'=>"reservations",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix AS reservations_id"),'group'=>"complex",'group_function'=>"resArray"),
			array('name'=>"fn_folio.fn_folio_to",'type'=>"complex",'fields'=>array("debtor_persona.pr_name_first AS debtor_name_first","debtor_persona.pr_name_last AS debtor_name_last"),'key'=>"debtor_persona.pr_persona_ix AS fn_folio_to_key",'function'=>"getDebtor"),
			array('name'=>"rv_reservation.rv_reservation_ix",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix"),'key'=>"rv_reservation.rv_reservation_ix AS rv_reservation_ix_key"),
			array('name'=>"fn_folio.fn_folio_ix",'type'=>"string",'fields'=>array("fn_folio.fn_folio_ix")),
			array('name'=>"fn_folio.fn_folio_folio_num",'type'=>"string",'fields'=>array("fn_folio.fn_folio_folio_num")),
			array('name'=>"debtor_persona.debtor_email",'type'=>"string",'fields'=>array("debtor_persona.pr_email AS debtor_email")),
			array('name'=>"debtor_persona.pr_corr_country_name",'type'=>"complex",'fields'=>array("debtor_persona.pr_corr_country_id"),'function'=>"getCountry"),
			array('name'=>"debtor_persona.debtor_web",'type'=>"string",'fields'=>array("debtor_persona.pr_web_addr AS debtor_web")),
			array('name'=>"debtor_persona.debtor_phone",'type'=>"complex",'fields'=>array("debtor_persona.pr_persona_ix AS debtor_phone"),'function'=>"getContactPhone"),
			array('name'=>"contact_persona.rv_corr_persona_name",'type'=>"complex",'fields'=>array("contact_persona.pr_name_first AS contact_name_first","contact_persona.pr_name_last"),'function'=>"getContactNameConcat"),
			array('name'=>"contact_persona.rv_corr_persona_email",'type'=>"string",'fields'=>array("contact_persona.pr_email")),
			array('name'=>"contact_persona.contact_phone",'type'=>"complex",'fields'=>array("contact_persona.pr_persona_ix AS contact_phone"),'function'=>"getContactPhone"),
			array('name'=>"contact_persona.contact_web",'type'=>"string",'fields'=>array("contact_persona.pr_web_addr AS contact_web")),			
			array('name'=>"agent_persona.agent_persona_id",'type'=>"string",'fields'=>array("agent_persona.pr_persona_ix")),			
			array('name'=>"fn_folio.rf_currency_symbol",'type'=>"string",'fields'=>array("rf_currency.rf_currency_symbol")),
			array('name'=>"rv_reservation.rv_date_arrive",'type'=>"string",'fields'=>array("rv_reservation.rv_date_arrive")),
			array('name'=>"rv_reservation.rv_date_depart",'type'=>"string",'fields'=>array("rv_reservation.rv_date_depart")),
			array('name'=>"rv_reservation.pay_plan",'type'=>"complex",'fields'=>array("rv_reservation.ac_pay_plan_id"),'function'=>"getPayPlan"),
			array('name'=>"rv_reservation.rv_res_name",'type'=>"string",'fields'=>array("rv_reservation.rv_res_name")),
			array('name'=>"rv_reservation_item.rv_reservation_item_ix",'type'=>"string",'fields'=>array("rv_reservation_item.rv_reservation_item_ix")),
			array('name'=>"rv_reservation_item.bed_nights",'type'=>"complex",'fields'=>array("rv_reservation_item.rv_item_accomm_count","rv_reservation_item.rv_item_nights","rv_reservation_item.rv_item_adult_count","rv_reservation_item.rv_item_child_count"),'function'=>"getBedNights"),
			array('name'=>"rv_reservation.rv_agent_ref",'type'=>"string",'fields'=>array("rv_reservation.rv_agent_ref")),
			array('name'=>"rv_reservation.rate_type",'type'=>"string",'fields'=>array("rt_rate_type.rt_rate_type_desc")),
			array('name'=>"rv_pay_plan_item.rv_pay_plan_item_ix",'type'=>"string",'fields'=>array("rv_pay_plan_item.rv_pay_plan_item_ix")),
			array('name'=>"rv_pay_plan_item.rv_pay_plan_date",'type'=>"string",'fields'=>array("rv_pay_plan_item.rv_pay_plan_date")),
			array('name'=>"rv_pay_plan_item.rv_pay_plan_amount",'type'=>"string",'fields'=>array("rv_pay_plan_item.rv_pay_plan_amount")),
			array('name'=>"fn_folio.fn_folio_date",'type'=>"string",'fields'=>array("fn_folio.fn_folio_date")),
			array('name'=>"fn_folio.fn_folio_amount",'type'=>"string",'fields'=>array("fn_folio.fn_folio_amount")),
			array('name'=>"fn_folio.fn_folio_amt_paid",'type'=>"string",'fields'=>array("fn_folio.fn_folio_amt_paid")),
			array('name'=>"fn_invoice.fn_invoice_ix",'type'=>"string",'fields'=>array("fn_invoice.fn_invoice_ix")),
			array('name'=>"fn_invoice.fn_inv_date",'type'=>"string",'fields'=>array("fn_invoice.fn_inv_date")),
			array('name'=>"invoicing_persona.pr_business_id",'type'=>"string",'fields'=>array("invoicing_persona.pr_persona_ix")),
			array('name'=>"invoicing_persona.pr_business",'type'=>"string",'fields'=>array("invoicing_persona.pr_name_last AS invoicing_name_last")),
			array('name'=>"rv_reservation_item.pr_business",'type'=>"string",'fields'=>array("property_persona.pr_name_last AS property_name_last")),
			array('name'=>"rv_payment_item.rv_payment_item_ix",'type'=>"string",'fields'=>array("rv_payment_item.rv_payment_item_ix")),
			array('name'=>"rv_payment_item.rv_payment_item_amt",'type'=>"string",'fields'=>array("rv_payment_item.rv_payment_item_amt")),
			array('name'=>"rv_payment.rv_payment.rv_payment_ix",'type'=>"string",'fields'=>array("rv_payment.rv_payment.rv_payment_ix")),
			array('name'=>"rv_payment.rv_pmnt_date",'type'=>"string",'fields'=>array("rv_payment.rv_pmnt_date"))
		);

		$this->Joins['folio'] = array(
			array('table'=>"fn_folio"),
			array('table'=>"pr_persona",'alias'=>"debtor_persona",'type'=>"LEFT",'on'=>"debtor_persona.pr_persona_ix = fn_folio.fn_folio_to_id",'requires'=>"fn_folio"),
			array('table'=>"pr_persona",'alias'=>"contact_persona",'type'=>"LEFT",'on'=>"contact_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id",'requires'=>"rv_reservation"),
			array('table'=>"pr_persona",'alias'=>"invoicing_persona",'type'=>"INNER",'on'=>"invoicing_persona.pr_persona_ix = fn_folio.pr_business_id",'requires'=>"fn_folio"),
			array('table'=>"pr_persona",'alias'=>"property_persona",'type'=>"INNER",'on'=>"property_persona.pr_persona_ix = rv_reservation_item.pr_business_id",'requires'=>"rv_reservation_item"),
			array('table'=>"pr_persona",'alias'=>"agent_persona",'type'=>"INNER",'on'=>"agent_persona.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
			array('table'=>"rv_pay_plan_item",'type'=>"LEFT",'on'=>"rv_pay_plan_item.rv_reservation_id = rv_reservation.rv_reservation_ix",'requires'=>"rv_reservation"),
			array('table'=>"rf_currency",'type'=>"INNER",'on'=>"rf_currency.rf_currency_ix = fn_folio.rf_currency_id",'requires'=>"fn_folio"),
			array('table'=>"fn_invoice",'type'=>"LEFT",'on'=>"fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8",'requires'=>"fn_folio"),
			array('table'=>"rv_reservation",'type'=>"INNER",'on'=>"rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id",'requires'=>"fn_folio"),
			array('table'=>"rv_reservation_item",'type'=>"INNER",'on'=>"rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix",'requires'=>"rv_reservation"),
			array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id",'requires'=>"rv_reservation"),
			array('table'=>"rv_payment_item",'type'=>"LEFT",'on'=>"rv_payment_item.fn_folio_id = fn_folio.fn_folio_ix",'requires'=>"fn_folio"),
			array('table'=>"rv_payment",'type'=>"LEFT",'on'=>"rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id",'requires'=>"rv_payment_item")
		);

		$this->AddParams(array(
			new ReportParamFilterDateRangeTravel("travelDateRange","Travel date range"),
			new ReportParamFilter("status",false,"30"),
			new ReportParamFilterCheck("excludeExpiredProv","Exclude expired provisionals","1"),
			new ReportParamSection("reservation","Reservation filters",array(
				new ReportParamFilter("agent"),
				new ReportParamFilter("agentCountry",false,false,array('whereName'=>"agent_persona.pr_corr_country_id")),
				new ReportParamFilter("billingContact"),
				new ReportParamFilter("consultant"),
				new ReportParamFilter("createdBy"),
				new ReportParamFilter("nationality"),
				new ReportParamFilter("originator"),
				new ReportParamFilter("paymentPlan"),
				new ReportParamFilter("rate"),
				// new ReportParamFilter("currencies",false,false,array("whereName"=>"rv_reservation.rv_invoice_currency_id")),
				new ReportParamFilter("source"),
			)),
			new ReportParamSection("folio","Folio filters",array(
				new ReportParamFilter("billingEntities"),
				new ReportParamFilter("currencies",false,false,array("whereName"=>"fn_folio.rf_currency_id")),
				new ReportParamFilterCheck("invoicedCheck","Invoiced","1"),
				new ReportParamFilterCheck("uninvoicedCheck","Uninvoiced","1"),
				new ReportParamFilterCheck("cancelledPaymentsCheck","Include cancelled payments"),
				new ReportParamFilterCheckArea("folioBalanceCheck","Include by balance",array(
					new ReportParamFilterCheck("folioBalanceTBACheck","TBA"),
					new ReportParamFilterCheck("folioBalancePaidCheck","Fully paid"),
					new ReportParamFilterCheckDiffersBy("folioBalanceOwingByCheck","Owing","1"),
					new ReportParamFilterCheckDiffersBy("folioBalanceOverpaidByCheck","Overpaid by","1")
				),"1"),				
				
				new ReportParamFilterCheckArea("invoiceDateRangeCheck","Invoice date range",array(
					new ReportParamFilterDateRange("invoiceDateRange",false),
				)),				
				new ReportParamFilterServer(),
				new ReportParamFilter("folioContact"),
			)),
			new ReportParamSection("sectionsDisplay","Include sections",array(
				new ReportParamFilterCheckArea("sectionsDetail","Detail",array(
					new ReportParamSection("debtorDisplay","Debtor display",array(
						new ReportParamFilterCheck("debtorEmailAddress","Email address","1"),
						new ReportParamFilterCheck("debtorTelephone","Telephone","1"),
						new ReportParamFilterCheck("debtorWebAddress","Web address","1"),
					)),	
					new ReportParamSection("reservationDisplay","Reservation display",array(
						new ReportParamFilterCheck("reservationResNo","Res. No.","1"),
						new ReportParamFilterCheck("reservationName","Res. Name","1"),
						new ReportParamFilterCheck("reservationArriveDate","Arrive date","1"),
						new ReportParamFilterCheck("reservationDepartDate","Depart date","1"),
						new ReportParamFilterCheck("reservationProperties","Properties","1"),
						new ReportParamFilterCheck("reservationBedNights","Bed nights","1"),
						new ReportParamFilterCheck("reservationVoucher","Voucher","1"),
						new ReportParamFilterCheck("reservationRateType","Rate type","1"),
						new ReportParamSection("contactDisplay","Contact display",array(
							new ReportParamFilterCheck("contactEmailAddress","Email address","1"),
							new ReportParamFilterCheck("contactTelephone","Telephone","1"),
							new ReportParamFilterCheck("contactWebAddress","Web address") // TODO: Implement
						)),
					)),	
					new ReportParamSection("payPlanDisplay","Payment plan display",array(
						new ReportParamFilterCheck("payPlanName","Pmt. plan name","1"),
						new ReportParamFilterCheck("payPlanItems","Payment items","1")
					)),	
					new ReportParamSection("folioDisplay","Folio display",array(
						new ReportParamFilterCheck("folioNumber","Folio no.","1"),
						new ReportParamFilterCheck("folioInvoiceNumber","Invoice number","1")
					))
				),"1"),
				new ReportParamFilterCheck("sectionsSummary","Summary","1")
			))	
		));

	}

	function Build(){

		$this->BuildDebtors();
		$this->BuildKeys();
		$this->BuildFolios();

		$this->PurgeDebtors();

		$this->BuildTotals();

		$this->GetBillingEntityInfo();

//		$this->BuildDisplay("debtorDetails","2010-01-01","2012-01-01");
		
	}

	function GetBillingEntityInfo(){
		global $lDB;

		$billingEntities = $this->GetParamValue("billingEntities");		

		if (count((explode(":",$billingEntities))) > 1 || $billingEntities == ""){ // Use top most billing entity
			$billingEntity = $lDB->get("
				SELECT 
					IFNULL(concat(concat(pr_persona.pr_name_first, ' '),pr_persona.pr_name_last),pr_persona.pr_name_last) AS name,
					pr_persona.pr_corr_addr_line1,
					pr_persona.pr_corr_addr_line2,
					pr_persona.pr_corr_addr_line3,
					pr_persona.pr_corr_post_code,
					rf_country.rf_country_name
				FROM 
					pr_business 
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id 
					LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
				WHERE 
					pr_business.pr_business_parent = '0'
			",1);
		} else {
			$billingEntity = $lDB->get("
				SELECT 
					IFNULL(concat(concat(pr_persona.pr_name_first, ' '),pr_persona.pr_name_last),pr_persona.pr_name_last) AS name,
					pr_persona.pr_corr_addr_line1,
					pr_persona.pr_corr_addr_line2,
					pr_persona.pr_corr_addr_line3,
					pr_persona.pr_corr_post_code,
					rf_country.rf_country_name
				FROM 
					pr_business 
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id 
					LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
				WHERE 
					pr_business.pr_business_id = '$billingEntities'
			",1);
		}

		$this->billingEntity = $billingEntity;
	}

	function BuildKeys() {
		if(sizeof($this->Data) > 0) {
			$this->Keys = array_unique(call_user_func_array('array_merge',array_map("getKeys",$this->Data)));
		} else {
			$this->Keys = array();
		}


		// Optimisation -- create lookup table to convert all item's ids into a list of appropriate groups to consider
		$groupKeys = array();
		foreach($this->Data as $key=>$item) {
			foreach($item['reservations'] as $id=>$kItem) {
				if(!array_key_exists($id,$groupKeys)) {
					$groupKeys[$id] = array();
				}
				$groupKeys[$id][] = $key;
			}
		}
		$this->GroupKeys = $groupKeys;		
	}	

	function BuildDebtors(){

		$defaultFields = array(
			"reservations",
			"rv_reservation.rv_reservation_ix",
			"rv_reservation.rv_res_name",
			"rv_reservation.rv_date_arrive",
			"rv_reservation.rv_date_depart",
			"rv_reservation.rv_agent_ref",
			"rv_reservation.pay_plan",
			"rv_reservation.rate_type",
			"rv_pay_plan_item.rv_pay_plan_item_ix",
			"rv_pay_plan_item.rv_pay_plan_date",
			"rv_pay_plan_item.rv_pay_plan_amount",
			"agent_persona.pr_persona_ix",
			"debtor_persona.debtor_email",
			"debtor_persona.debtor_phone",
			"debtor_persona.debtor_web",
			"debtor_persona.pr_corr_country_name",
			"contact_persona.rv_corr_persona_name",
			"contact_persona.rv_corr_persona_email",
			"contact_persona.contact_phone",
			"contact_persona.contact_web"
		);

		// Fake output of report builder
		$grouping = array(
			"fn_folio.fn_folio_to" => array(
					"active" => "1"
			)
		);

		$sqlBuilder = new ReportSQLBuilder(
			$grouping,
			$this->Fields,
			$this->Joins['folio'],
			$defaultFields
		);

		$sql = new ReportSQL();

		$sql->Merge($sqlBuilder->SQL());

		$travelDateRange = $this->GetParam("travelDateRange");
		$sql->AddWhere($travelDateRange->SQL());
		unset($travelDateRange);		

		$sql->AddWhere($this->ConcatParamSQL(array(
			"agent",
			"agentCountry",
			"billingContact",
			"status",
			"consultant",
			"createdBy",
			"nationality",
			"originator",
			"paymentPlan",
			"rate",
			"source",
			"server",
			"folioContact",
			"billingEntities"
		)));

		if($this->GetParamValue("excludeExpiredProv") == "1") {
			$sql->AddWhere("
				AND (
					(
						rv_reservation.rf_reservation_status_id != 20
					) OR (
						rv_reservation.rf_reservation_status_id = 20
						AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
					)
				)
			");
		}

		$sql->AddOrder(array("debtor_persona.pr_name_last","rv_reservation.rv_reservation_ix"));

		$data = $sql->Run();

		$sqlBuilder->Render($data,array("fn_folio.fn_folio_to"));

		$this->Data = $data;

	}	

	function BuildFolios($where=false) {
		global $lDB;
		
		$defaultFields = array(
			"fn_folio.rv_reservation_id",
			"fn_folio.fn_folio_ix",
			"fn_folio.fn_folio_to_id",
			"fn_folio.fn_folio_folio_num",
			"fn_folio.fn_folio_date",
			"fn_folio.fn_folio_amount",
			"fn_folio.fn_folio_amt_paid",
			"fn_invoice.fn_invoice_ix",
			"fn_invoice.fn_inv_date",
			"fn_folio.rf_currency_symbol",
			"rv_reservation.rv_reservation_ix",
			"invoicing_persona.pr_business",
			"invoicing_persona.pr_business_id",
			"rv_payment_item.rv_payment_item_ix",
			"rv_payment_item.rv_payment_item_amt",
			"rv_payment_item.rv_payment_contra_id",
			"rv_payment.rv_pmnt_date",
			"rv_payment.rv_payment_ix"	
		);

		$itinFields = array(
			"rv_reservation_item.rv_reservation_item_ix",
			"rv_reservation_item.bed_nights",
			"rv_reservation_item.pr_business"
		);		

		$defaultFields = array_merge($defaultFields,$itinFields);

		$sqlBuilder = new ReportSQLBuilder(
			false,
			$this->Fields,
			$this->Joins['folio'],
			$defaultFields
		);

		$folioSQL = new ReportSQL();
		
		$folioSQL->Merge($sqlBuilder->SQL());

		$folioSQL->AddWhere("AND fn_folio.rv_reservation_id IN ('".join("','",$this->Keys)."')");

		$folioSQL->AddWhere($this->ConcatParamSQL(array(
			"folioContact",
			"billingEntities",
			"currencies",
		)));


		if($this->GetParamValue("excludeExpiredProv") == "1") {
			$folioSQL->AddWhere("
				AND (
					(
						rv_reservation.rf_reservation_status_id != 20
					) OR (
						rv_reservation.rf_reservation_status_id = 20
						AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
					)
				)
			");
		}

		if($this->GetParamValue("invoiceDateRangeCheck") == "1") {
			$invoiceDateRange = $this->GetParam("invoiceDateRange");
			$folioSQL->AddWhere($invoiceDateRange->SQL("
				AND (
					(
						fn_invoice.fn_invoice_ix IS NULL
						AND fn_folio.fn_folio_date BETWEEN '!fromDate!' AND '!toDate!'
					) OR (
						fn_invoice.fn_invoice_ix IS NOT NULL
						AND fn_invoice.fn_inv_date BETWEEN '!fromDate!' AND '!toDate!'
					)
				)
			"));
			unset($invoiceDateRange);
		}

		$invoicedCheck = $this->GetParamValue("invoicedCheck");
		$uninvoicedCheck = $this->GetParamValue("uninvoicedCheck");
		if($invoicedCheck || $uninvoicedCheck) {
			$where = array();
			if($invoicedCheck) {
				$where[] = "
					(
						fn_invoice.fn_invoice_ix IS NOT NULL
					)
				";
			}
			if($uninvoicedCheck) {
				$where[] = "
					(
						fn_invoice.fn_invoice_ix IS NULL
					)
				";
			}
			if(sizeof($where) > 0) {
				$folioSQL->AddWhere(" AND (". join(" OR ",$where) . ")");
			}
			unset($where);
		}
		unset($invoicedCheck);
		unset($uninvoicedCheck);

		if($this->GetParamValue("folioBalanceCheck") == "1") {
			$where = array();

			if($this->GetParamValue("folioBalanceTBACheck") == "1") {
				$where[] = "
					(
						fn_folio.fn_folio_amt_tba_yn = '1'
					)
				";
			}

			if($this->GetParamValue("folioBalancePaidCheck") == "1") {
				$where[] = "
					(
						fn_folio.fn_folio_amt_tba_yn <> '1'
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) = 0
					)
				";
			}

			list($folioBalanceOwingByCheck,$folioBalanceOwingByType,$folioBalanceOwingByValue) = explode(":",$this->GetParamValue("folioBalanceOwingByCheck"));
			if($folioBalanceOwingByCheck == "1") {
				if($folioBalanceOwingByType == "more") {
					$where[] = "
						(
							fn_folio.fn_folio_amt_tba_yn <> '1'
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > $folioBalanceOwingByValue
						)
					";
				} else {
					$where[] = "
						(
							fn_folio.fn_folio_amt_tba_yn <> '1'
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < $folioBalanceOwingByValue
						)
					";
				}
			}
			list($folioBalanceOverpaidByCheck,$folioBalanceOverpaidByType,$folioOverpaidByValue) = explode(":",$this->GetParamValue("folioBalanceOverpaidByCheck"));
			if($folioBalanceOverpaidByCheck == "1") {
				$folioOverpaidByValue *= -1;
				if($folioBalanceOverpaidByType == "more") {
					$where[] = "
						(
							fn_folio.fn_folio_amt_tba_yn <> '1'
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < $folioOverpaidByValue
						)
					";
				} else {
					$where[] = "
						(
							fn_folio.fn_folio_amt_tba_yn <> '1'
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < 0
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > $folioOverpaidByValue
						)
					";
				}
			}

			if(sizeof($where) > 0) {
				$folioSQL->AddWhere(" AND (". join(" OR ",$where) . ")");
			}
			unset($where);
		}		

		$folios = $folioSQL->Run();

		$sqlBuilder->Render($folios);

		// Build folio itineraries and payments
		$newFolios = array();
		foreach($folios as $folio) {
			foreach ($folio as $field=>$item){
				$newFolios[$folio['fn_folio.fn_folio_ix']][$field] = $item;	
			}
		
			foreach ($itinFields as $itinField){
				$newFolios[$folio['fn_folio.fn_folio_ix']]['itineraries'][$folio['rv_reservation_item.rv_reservation_item_ix']][$itinField] = $folio[$itinField];
			}

			foreach ($folio as $field=>$item){
				if (isset($folio['rv_payment_item.rv_payment_item_ix']) && $folio['rv_payment_item.rv_payment_item_ix'] != ""){

					$cancelledPaymentsCheck = $this->GetParamValue("cancelledPaymentsCheck");
					if (!$cancelledPaymentsCheck){
						if ($folio['rv_payment_item.rv_payment_contra_id'] == ""){
							$newFolios[$folio['fn_folio.fn_folio_ix']]['payments'][$folio['rv_payment_item.rv_payment_item_ix']]['receipt'] = $folio['rv_payment.rv_payment_ix'];
							$newFolios[$folio['fn_folio.fn_folio_ix']]['payments'][$folio['rv_payment_item.rv_payment_item_ix']]['date'] = $folio['rv_payment.rv_pmnt_date'];
							$newFolios[$folio['fn_folio.fn_folio_ix']]['payments'][$folio['rv_payment_item.rv_payment_item_ix']]['amount'] = $folio['rv_payment_item.rv_payment_item_amt'];
						}
					} else {
							$newFolios[$folio['fn_folio.fn_folio_ix']]['payments'][$folio['rv_payment_item.rv_payment_item_ix']]['receipt'] = $folio['rv_payment.rv_payment_ix'];
							$newFolios[$folio['fn_folio.fn_folio_ix']]['payments'][$folio['rv_payment_item.rv_payment_item_ix']]['date'] = $folio['rv_payment.rv_pmnt_date'];
							$newFolios[$folio['fn_folio.fn_folio_ix']]['payments'][$folio['rv_payment_item.rv_payment_item_ix']]['amount'] = $folio['rv_payment_item.rv_payment_item_amt'];
					}
					unset($cancelledPaymentsCheck);
				}
				
			}
			
		}


		// Attach folios to debtors array
		foreach($newFolios as $folioKey=>$folio) {
			$id = $folio["fn_folio.rv_reservation_id"];
			foreach($this->GroupKeys[$id] as $key) {
				// If folio belongs to this debtor
				if ($this->Data[$key]['fn_folio.fn_folio_to_key'] == $folio['fn_folio.fn_folio_to_id']){
					$this->Data[$key]['reservations'][$id]['folios'][$folioKey] = $folio;	
				}
				
			}
		}

	}	

	function PurgeDebtors(){
		foreach ($this->Data as $itemKey => $item){
			foreach ($item['reservations'] as $resKey => $reservation){
				if (count($reservation['folios']) == 0){
					unset($this->Data[$itemKey]['reservations'][$resKey]);
				}
			}
		}

		foreach ($this->Data as $itemKey => $item){
			if (count($item['reservations']) == 0){
				unset($this->Data[$itemKey]);
			}
		}		
	}

	function HTMLDetailHeader($item) {
		$html = "";

		$html .= "
			<span style=\"height: 100%;\">
				".trim($this->billingEntity['name'])."<br>
		";

		if (isset($this->billingEntity['pr_corr_addr_line1']) && $this->billingEntity['pr_corr_addr_line1'] != ""){
			$html .= "
				".$this->billingEntity['pr_corr_addr_line1']."<br>
			";			
		}
		
		if (isset($this->billingEntity['pr_corr_addr_line2']) && $this->billingEntity['pr_corr_addr_line2'] != ""){
			$html .= "
				".$this->billingEntity['pr_corr_addr_line2']."<br>
			";			
		}		
		
		if (isset($this->billingEntity['pr_corr_addr_line3']) && $this->billingEntity['pr_corr_addr_line3'] != ""){
			$html .= "
				".$this->billingEntity['pr_corr_addr_line3']."<br>
			";			
		}			
		
		if (isset($this->billingEntity['pr_corr_post_code']) && $this->billingEntity['pr_corr_post_code'] != ""){
			$html .= "
				".$this->billingEntity['pr_corr_post_code']."<br>
			";			
		}	
		
		if (isset($this->billingEntity['rf_country_name']) && $this->billingEntity['rf_country_name'] != ""){
			$html .= "
				".$this->billingEntity['rf_country_name']."
			";			
		}							
				
				
								
		$html .= "
			</span>		
		";

		return $html;
 	}

	function HTMLSummaryHeader($item) {
		$html = "";

		$travelDate = explode(":",$this->GetParamValue("travelDateRange"));

		$html .= "
			<span style=\"display: inline-block; width: 100%; text-align: center; font-weight: bold;\">SUMMARY</span><br>
			<span>".trim($this->billingEntity['name'])."</span><br>
			<span>Date: ".ucfirst($travelDate[0])." ".formatField($travelDate[1],'date')." to ".formatField($travelDate[2],'date')."</span><br>
			<span>Account No(s): ".join(",",$this->GetAccountNumbers($item))."</span>
		";

		return $html;
 	}

	function HTMLResHeaderRow($reservation) {
		$html = "";
		$sections = array();

		if ($this->GetParamValue("reservationResNo") == "1"){
			$sections['name'] = $reservation['rv_reservation_id'];
		}

		if ($this->GetParamValue("reservationName") == "1"){
			$sections['number'] = $reservation['rv_res_name'];
		}		

		if(!empty($sections)){
			$html = "Reservation: ".join(", ", $sections);
		}
		
		return $html;
	}

	function HTMLResTravelRow($reservation) {
		$html = "";
		$sections = array();

		if($this->GetParamValue("reservationArriveDate") == "1" && $this->GetParamValue("reservationDepartDate") == "1") {
			$sections['travel'] = "Travel: ".formatField($reservation['rv_date_arrive'],'date')." to ".formatField($reservation['rv_date_depart'],'date');
		} elseif ($this->GetParamValue("reservationArriveDate") == "1"){
			$sections['travel'] = "Travel: Arrive ".formatField($reservation['rv_date_arrive'],'date');
		} elseif ($this->GetParamValue("reservationDepartDate") == "1"){
			$sections['travel'] = "Travel: Depart ".formatField($reservation['rv_date_depart'],'date');
		}

		if ($this->GetParamValue("reservationVoucher") == "1" && isset($reservation['rv_agent_ref']) && $reservation['rv_agent_ref'] != ""){
			$sections['voucher'] = "Voucher: ".$reservation['rv_agent_ref'];
		}

		if ($this->GetParamValue("reservationRateType") == "1" && isset($reservation['rate_type']) && $reservation['rate_type'] != ""){
			$sections['rateType'] = "Rate type: ".$reservation['rate_type'];
		}		

		if($this->GetParamValue("reservationBedNights") == "1") {
			$numBedNights = 0;
			foreach($reservation['folios'] as $folio){
				foreach ($folio['itineraries'] as $itinerary){
					$numBedNights += $itinerary['rv_reservation_item.bed_nights'];
				}
			}
			$sections['bedNights'] = "Bednights: $numBedNights";
		}

		if($this->GetParamValue("reservationProperties") == "1") {
			$propArray = array();
			foreach($reservation['folios'] as $folio){
				foreach ($folio['itineraries'] as $itinerary){
					$propArray[$itinerary['rv_reservation_item.pr_business']] = $itinerary['rv_reservation_item.pr_business'];
				}
			}
			$sections['properties'] = "Properties: ".join(", ",$propArray);
		}

		$html .= join("; ", $sections);

		return $html;		
	}

	function HTMLResPayPlanRow($reservation) {
		$html = "";
		$sections = array();

		if($this->GetParamValue("payPlanName") == "1" && isset($reservation['pay_plan']) && $reservation['pay_plan'] != "") {
			$sections['name'] = $reservation['pay_plan'];
		}

		if($this->GetParamValue("payPlanItems") == "1") {
			$payPlanItems = array();
			foreach ($reservation['pay_plan_items'] as $pay_plan_item){
				$payPlanItems[] = "Due ".formatField($pay_plan_item['rv_pay_plan_date'],'date')." = ".formatField($pay_plan_item['rv_pay_plan_amount'],'amount');
			}				
			$sections['items'] = join("; ", $payPlanItems);
		}		

		if(!empty($sections)){
			$html .= "Pmt plan: ".join("; ", $sections);
		}

		

		return $html;		
	}

	function HTMLDetailAccountsRow($item) {
		$html = "";
		$sections = array();

		if($this->GetParamValue("debtorEmailAddress") == "1" && isset($item['debtor_persona.debtor_email']) && $item['debtor_persona.debtor_email'] != "") {
			$sections['email'] = "Email: ".$item['debtor_persona.debtor_email'];
		}

		if($this->GetParamValue("debtorTelephone") == "1" && isset($item['debtor_persona.debtor_phone']) && $item['debtor_persona.debtor_phone'] != "") {
			$sections['tel'] = "Tel: ".$item['debtor_persona.debtor_phone'];
		}

		if($this->GetParamValue("debtorWebAddress") == "1" && isset($item['debtor_persona.debtor_web']) && $item['debtor_persona.debtor_web'] != "") {
			$sections['web'] = "Web: ".$item['debtor_persona.debtor_web'];
		}

		//TODO: Add folios and invoices here

		$folio_ids = array();
		foreach($item['reservations'] as $reservation){
			foreach($reservation['folios'] as $id => $folio){
				$folio_ids[] = $id;
			}
		}
		$folio_ids = array_unique($folio_ids);

		$invoice_ids = array();
		foreach($item['reservations'] as $id=>$reservation){
			foreach($reservation['folios'] as $id => $folio){
				if (isset($folio['fn_invoice.fn_invoice_ix']) && $folio['fn_invoice.fn_invoice_ix'] != ""){
					$invoice_ids[] = $folio['fn_invoice.fn_invoice_ix'];
				}
				
			}
		}		
		$invoice_ids = array_unique($invoice_ids);

		$reservation_ids = array();
		foreach($item['reservations'] as $id=>$reservation){
			$reservation_ids[] = $id;
		}
		$reservation_ids = array_unique($reservation_ids);

		if(!empty($sections)){
			$html .= "
				<label><input name=\"selected_customers\" type=\"checkbox\" class=\"select_checkbox\" folio_ids=\"".join('|',$folio_ids)."\" invoice_ids=\"".join('|',$invoice_ids)."\" reservation_ids=\"".join('|',$reservation_ids)."\" folio_to_id=\"".$item['fn_folio.fn_folio_to_key']."\" /> Account: ".$item['fn_folio.fn_folio_to']."; ".join("; ",$sections)."</label>
			";
		} else {
			$html .= "
				<label><input name=\"selected_customers\" type=\"checkbox\" class=\"select_checkbox\" folio_ids=\"".join('|',$folio_ids)."\" invoice_ids=\"".join('|',$invoice_ids)."\" reservation_ids=\"".join('|',$reservation_ids)."\" folio_to_id=\"".$item['fn_folio.fn_folio_to_key']."\" /> Account: ".$item['fn_folio.fn_folio_to']."</label>
			";
		}

		return $html;		
	}

	function HTMLResContactRow($reservation) {
		$html = "";
		$sections = array();

		if($this->GetParamValue("contactEmailAddress") == "1" && isset($reservation['contact_persona.rv_corr_persona_email']) && $reservation['contact_persona.rv_corr_persona_email'] != "") {
			$sections['email'] = "Email: ".$reservation['contact_persona.rv_corr_persona_email'];
		}

		if($this->GetParamValue("contactTelephone") == "1" && isset($reservation['contact_persona.contact_phone']) && $reservation['contact_persona.contact_phone'] != "") {
			$sections['tel'] = "Tel: ".$reservation['contact_persona.contact_phone'];
		}

		if($this->GetParamValue("contactWebAddress") == "1" && isset($item['contact_persona.debtor_web']) && $item['contact_persona.debtor_web'] != "") {
			$sections['web'] = "Web: ".$reservation['contact_persona.debtor_web'];
		}

		if(!empty($sections)){
			$html .= "
				<span>Contact: ".$reservation['contact_persona.rv_corr_persona_name']."; ".join("; ",$sections)."</span>
			";
		} else {
			$html .= "
				<span>Contact: ".$reservation['contact_persona.rv_corr_persona_name']."
			";
		}

		return $html;	
	}	

	function HTMLSummaryAccountsRow($item) {
		$html = "";



		// If Detail section not showed, put selection checkbox on summary line
		if($this->GetParamValue("sectionsDetail") != "1") {

			$folio_ids = array();
			foreach($item['reservations'] as $reservation){
				foreach($reservation['folios'] as $id => $folio){
					$folio_ids[] = $id;
				}
			}
			$folio_ids = array_unique($folio_ids);

			$invoice_ids = array();
			foreach($item['reservations'] as $id=>$reservation){
				foreach($reservation['folios'] as $id => $folio){
					if (isset($folio['fn_invoice.fn_invoice_ix']) && $folio['fn_invoice.fn_invoice_ix'] != ""){
						$invoice_ids[] = $folio['fn_invoice.fn_invoice_ix'];
					}
					
				}
			}		
			$invoice_ids = array_unique($invoice_ids);

			$reservation_ids = array();
			foreach($item['reservations'] as $id=>$reservation){
				$reservation_ids[] = $id;
			}
			$reservation_ids = array_unique($reservation_ids);

			$html .= "<label><input name=\"selected_customers\" type=\"checkbox\" class=\"select_checkbox\" folio_ids=\"".join('|',$folio_ids)."\" invoice_ids=\"".join('|',$invoice_ids)."\" reservation_ids=\"".join('|',$reservation_ids)."\" folio_to_id=\"".$item['fn_folio.fn_folio_to_key']."\" /> ".$item['fn_folio.fn_folio_to'];

			if (isset($item['debtor_persona.pr_corr_country_name']) && $item['debtor_persona.pr_corr_country_name'] != ""){
				$html .= ", <span>".$item['debtor_persona.pr_corr_country_name']."</span>";			
			}	

			$html .= "</label>";

		} else {

			$html .= "<span>".$item['fn_folio.fn_folio_to']."</span>";			

			if (isset($item['debtor_persona.pr_corr_country_name']) && $item['debtor_persona.pr_corr_country_name'] != ""){
				$html .= ", <span>".$item['debtor_persona.pr_corr_country_name']."</span>";			
			}				
		}



		

		return $html;		
	}

	// function HTMLSummaryContactRow($item) {
	// 	$html = "";

	// 	$html .= "
	// 		<span style=\"font-style: italic;\">".$item['pr_persona.pr_corr_country_name']."</span>
	// 	";

	// 	return $html;		
	// }		

	function HTMLSummaryResTable($item){
		$html = "";
		$summary = array();
		$summaryCol = "";
		$summaryHead = "";
		if ($this->summaryOnly) {
			$summaryCol = "<col>";
			$summaryHead = "<th style=\"text-align: left; width: 150px;\">
								Res. Name
							</th>";
		}
		$html .= "
			<table border=\"0\" style=\"border-collapse: collapse; table-layout: fixed; width: 100%;\" class=\"resDetailsTable\">
				<colgroup>
					<col>
					$summaryCol
					<col>
					<col>
					<col>
					<col>
				</colgroup>
				<tbody>
					<tr>
						<th style=\"text-align: center; width:50px;\">
							Res No.
						</th>
						$summaryHead
						<th style=\"text-align: center;\">
							Date
						</th>
						<th style=\"text-align: center;\">
							Inv. No.
						</th>
						<th style=\"text-align: center;\">
							Currency
						</th>
						<th style=\"text-align: right; width:90px;\">
							Balance
						</th>
					</tr>
		";
		foreach($item['reservations'] as $key => $reservation){
			foreach ($reservation['folios'] as $folio){
				$summaryResName = !$this->summaryOnly ? "" : "<td style=\"text-align: left;\">" . $reservation["rv_res_name"] . "</td>";
				$html .= "
					<tr>
						<td style=\"text-align: center;\">
							$key
						</td>
						$summaryResName
						<td style=\"text-align: center;\">
							".formatField($folio['fn_folio.fn_folio_date'],'date')."
						</td>
						<td style=\"text-align: center;\">
							".$folio['fn_invoice.fn_invoice_ix']."
						</td>
						<td style=\"left: 209px; top: 35px; text-align: center;\">
							".$folio['fn_folio.rf_currency_symbol']."
						</td>
						<td style=\"text-align: right;\">
							".formatField(($folio['fn_folio.fn_folio_amount'] - $folio['fn_folio.fn_folio_amt_paid']),'amount')."
						</td>
					</tr>				
				";
				$key = "";
			}
		};
		$html .="
				</tbody>
			</table>
		";

		return $html;			
	}

	function HTMLSummaryAmountsTable($item) {
		$html = "";

		$html .= "
			<table style=\"border-collapse: collapse; table-layout: fixed; z-index: 900; left: 640px; top: 200.5px; width: 100%;\" border=\"0\">
				<colgroup>
					<col style=\"width: 65%;\">
					<col>
				</colgroup>
				<tbody>
					<tr>
						<th style=\"text-align: left;\">
							Amount Due:
						</th>
						<th>
							&nbsp;
						</th>
					</tr>
		";
		foreach($item['totals'] as $curr=>$total){
			$html .= "
						<tr>
							<td>
								$curr
							</td>
							<td style=\"text-align: right;\">
								".formatField($total,'amount')."
							</td>
						</tr>
			";
		}

		$html .= "
				</tbody>
			</table>
		";

		return $html;		
	}	

	function HTMLFoliosTable($reservation) {
		$html = "";


		$htmlCols = array("<col>","<col>","<col>","<col>","<col>");
		$htmlHeads = array();

		if($this->GetParamValue("folioNumber") == "1"){
			$htmlCols[] = "<col>";
			$htmlHeads[] = "<th style=\"width:30px;\">Folio</th>";
		}

		$htmlHeads[] = "<th>Date</th>";			

		if($this->GetParamValue("folioInvoiceNumber") == "1"){
			$htmlCols[] = "<col>";
			$htmlHeads[] = "<th>Inv. No.</th>";			
		}		

		$htmlHeads[] = "<th>
							Rec. No.
						</th>
						<th style=\"width:30px;\">
							Curr
						</th>
						<th style=\"width:90px; text-align: right;\">
							Amount
						</th>
						<th style=\"width:90px; text-align: right;\">
							Balance
						</th>";

		$html .= "
			<table class=\"folioTable\" border=\"0\" style=\"border-collapse: collapse; table-layout: fixed; width: 100%;\">
				<colgroup>
					".join("",$htmlCols)."
				</colgroup>
				<tbody>
					<tr>
						".join("",$htmlHeads)."
					</tr>
		";
		foreach($reservation['folios'] as $key => $folio){
			$htmlCells = array();

			if($this->GetParamValue("folioNumber") == "1"){
				$htmlCells[] = "<td style=\"text-align: center;\">".$folio['fn_folio.fn_folio_folio_num']."</td>";
			}

			$htmlCells[] = "<td style=\"text-align: center;\">".formatField($folio['fn_folio.fn_folio_date'],'date')."</td>";

			if($this->GetParamValue("folioInvoiceNumber") == "1"){
				$htmlCells[] = "<td style=\"text-align: center;\">".$folio['fn_invoice.fn_invoice_ix']."</td>";
			}	

			$htmlCells[] = "<td>
							&nbsp;
						</td>
						<td style=\"left: 209px; top: 35px; text-align: center;\">
							".$folio['fn_folio.rf_currency_symbol']."
						</td>
						<td style=\"text-align: right;\">
							".formatField($folio['fn_folio.fn_folio_amount'],'amount')."
						</td>
						<td style=\"text-align: right;\">
							".formatField(($folio['fn_folio.fn_folio_amount'] - $folio['fn_folio.fn_folio_amt_paid']),'amount')."
						</td>";

			$html .= "
					<tr>
						".join("",$htmlCells)."
					</tr>			
			";

			if (isset($folio['payments'])){
				foreach ($folio['payments'] as $payment){
					$htmlCells = array();

					if($this->GetParamValue("folioNumber") == "1"){
						$htmlCells[] = "<td style=\"text-align: center;\">&nbsp;</td>";
					}

					$htmlCells[] = "<td style=\"text-align: center;\">".formatField($payment['date'],'date')."</td>";

					if($this->GetParamValue("folioInvoiceNumber") == "1"){
						$htmlCells[] = "<td style=\"text-align: center;\">&nbsp;</td>";
					}	

					$htmlCells[] = "<td>
								".$payment['receipt']."
							</td>
							<td style=\"left: 209px; top: 35px; text-align: center;\">
								".$folio['fn_folio.rf_currency_symbol']."
							</td>
							<td style=\"text-align: right;\">
								".formatField(($payment['amount']*-1),'amount')."
							</td>
							<td style=\"text-align: right;\">
								&nbsp;
							</td>";

					$html .= "
						<tr>
							".join("",$htmlCells)."
						</tr>			
					";				
				}
			}

		}
		$html .="
				</tbody>
			</table>
		";

		return $html;		
	}		

	function HTMLDetailResTable($item) {
		$html = "";
		foreach($item['reservations'] as $reservation){
			$html .= "
				<table class=\"resTable\" border=\"0\" style=\"border-collapse: collapse; table-layout: fixed; left: 34px; top: 281px; width: 100%;\">
					<colgroup>
						<col>
					</colgroup>
					<tbody>
						<tr>
 							<th class=\"outLt\" style=\"text-align: left; cursor: pointer;\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"Set_Cookie('finTabName','Folios');window.location='/reservation.php?647+".$reservation['rv_reservation_id']."';\">
								".$this->HTMLResHeaderRow($reservation)."<br>
								".$this->HTMLResContactRow($reservation)."
							</th>
						</tr>
						<tr>
							<td>
								".$this->HTMLResTravelRow($reservation)."
							</td>
						</tr>
						<tr>
							<td>
								".$this->HTMLResPayPlanRow($reservation)."
							</td>
						</tr>
						<tr>
							<td>
								&nbsp;
			";

			$html .= $this->HTMLFoliosTable($reservation);

			$html .= "
							</td>
						</tr>
					</tbody>
				</table>
			";
		}
		

		return $html;
 	}


	function HTML(){
		$this->Padding = 2;
		$html = "";
		$this->summaryOnly = ($this->GetParamValue("sectionsDetail") != 1 && $this->GetParamValue("sectionsSummary") == 1);

		$debtorFilter = $this->GetParam("folioContact");
		$travelDate = explode(":",$this->GetParamValue("travelDateRange"));

		$this->CustomHTML = "
			<form method=\"post\" id=\"bulkEmailForm\" action=\"reservation.php?2009\" target=\"bulkEmail\">
				<input type=\"hidden\" id=\"selected_customers_list\" name=\"selected_customers_list\" value=\"\" />
				<input type=\"hidden\" id=\"from_date\" name=\"from_date\" value=\"".formatField($travelDate[1],'date')."\" />
				<input type=\"hidden\" id=\"to_date\" name=\"to_date\" value=\"".formatField($travelDate[2],'date')."\" />
				<input type=\"hidden\" id=\"customer_filter_arg\" name=\"customer_filter_arg\" value=\"".$debtorFilter->Arg."\" />
				<input type=\"hidden\" id=\"report_url\" name=\"report_url\" value=\"\" />
			</form>					
		";

		if(sizeof($this->Data) > 0) {

			// Javascript
			$html = "
				<script type=\"text/javascript\">

					var selected = [];		

					function emailSelected(){

						selected = [];

						selected_customers = document.getElementsByName(\"selected_customers\");
						for(count=0; count<selected_customers.length; count++) {
							if(selected_customers[count].checked) {
								folio_to_id = selected_customers[count].getAttribute(\"folio_to_id\");
								reservation_ids = selected_customers[count].getAttribute(\"reservation_ids\");
								folio_ids = selected_customers[count].getAttribute(\"folio_ids\");
								invoice_ids = selected_customers[count].getAttribute(\"invoice_ids\");
								selected.push(folio_to_id+'_'+reservation_ids+'_'+folio_ids+'_'+invoice_ids);
							}
						}	

						if(selected.length > 0) {

							if(selected.length > 25) {
								openConfirm(\"You have selected more than 25 records to be emailed. Please consider filtering down your results, or selecting fewer records to be sent at a time. Continue?\");
							} else {
								doEmailSelected();
							}

								
						} else {
							openMessage(\"No customers selected.\");
						}

					}

					function doEmailSelected(){

						selected_customers_list = selected.join(\":\");

						id(\"selected_customers_list\").value = selected_customers_list;
						id(\"report_url\").value = buildURL(1);

						pdfWin=openPopup(\"/resource/Resrequest/Application/public/html/wait.htm?Loading email popup...\",600,500,0,0,0,0,\"bulkEmail\",\"opener.id('bulkEmailForm').submit();\");													
					}

					function confirmPopupAction(){
						doEmailSelected();
					}

					function selectAll(){
						checkboxes = document.getElementsByName(\"selected_customers\");
						if (id('selected_all_customers').checked){
							for(count=0; count<checkboxes.length; count++) {
								checkboxes[count].checked = true;
							}
						} else {
							for(count=0; count<checkboxes.length; count++) {
								checkboxes[count].checked = false;
							}
						}
						
					}

				</script>

				<!-- Checkbox styling for neatness -->
				<style type=\"text/css\">
				label {
					display: block;
					padding-left: 15px;
					text-indent: -15px;
				}
				input.select_checkbox {
					width: 13px;
					height: 13px;
					padding: 0;
					margin:0;
					vertical-align: bottom;
					position: relative;
					<!-- top: -1px; -->
					*overflow: hidden;
				}
				</style>

			";

			$html .= "

				<table width=\"770\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">
					<tr>
						<td height=\"10\">&nbsp;&nbsp;Number of statements generated: ".count($this->Data)."</td>
					</tr>
					<tr>
						<td height=\"5\"></td>
					</tr>							
					<tr>
						<td height=\"10\">&nbsp;&nbsp;<input id=\"selected_all_customers\" type=\"checkbox\" class=\"select_checkbox\" onclick=\"selectAll();\" /> Select all</td>
					</tr>
					<tr>
						<td height=\"5\"></td>
					</tr>
				</table>
			";

			foreach($this->Data as $key=>$item) {
				$html .= "
					<div id=\"canvas\" style=\"width: 770px;\">
				";				
				if($this->GetParamValue("sectionsDetail") == "1") {
					$html .= "
						<div id=\"details\" style=\"display: inline-block; width: 439px; vertical-align: top;\">
							<div style=\"border: 2px solid black; margin: 2px; padding: 2px; left: 0px; top: 0px; height: 82px; text-align: left;\">
								".$this->HTMLDetailHeader($item)."
							</div>
							<div style=\"border: 2px solid black; margin: 2px; left: 0px; top: 0px; text-align: left; height: 30px\">
								<div style=\"margin: 2px;\">
									".$this->HTMLDetailAccountsRow($item)."
								</div>
							</div>
							<div style=\"border: 2px solid black; margin: 2px; left: 0px; top: 0px;\">
								".$this->HTMLDetailResTable($item)."
							</div>
						</div>
					";
				};
				if($this->GetParamValue("sectionsSummary") == "1") {
					$summaryWidth = !$this->summaryOnly ? "322px" : "472px";
					$html .= "
						<div id=\"summary\" style=\"display: inline-block; width: " . $summaryWidth . "; vertical-align: top;\">
							<div style=\"border: 2px solid black; margin: 2px; padding: 2px; left: 0px; top: 0px; height: 82px; text-align: left;\">
								".$this->HTMLSummaryHeader($item)."
							</div>
							<div style=\"border: 2px solid black; margin: 2px; left: 0px; top: 0px; text-align: left; height: 30px\">
								<div style=\"margin: 2px;\">
									".$this->HTMLSummaryAccountsRow($item)."
								</div>
							</div>
							<div style=\"border: 2px solid black; margin: 2px; left: 0px; top: 0px; text-align: left;\">
								".$this->HTMLSummaryResTable($item)."
							</div>
							<div style=\"border: 2px solid black; margin: 2px; left: 0px; text-align: left; top: 0px;\">
								".$this->HTMLSummaryAmountsTable($item)."
							</div>
						</div>
					";
				};
				$html .= "
					</div><br /><br />
				";					
			}

		}

		return $html;
	}

// --- [START] PDF

	function PDFDetailHeader(&$pdf, $item) {

		$data = "";

		$data .= trim($this->billingEntity['name'])."\n";

		if (isset($this->billingEntity['pr_corr_addr_line1']) && $this->billingEntity['pr_corr_addr_line1'] != ""){
			$data .= $this->billingEntity['pr_corr_addr_line1']."\n";			
		}
		
		if (isset($this->billingEntity['pr_corr_addr_line2']) && $this->billingEntity['pr_corr_addr_line2'] != ""){
			$data .= $this->billingEntity['pr_corr_addr_line2']."\n";			
		}		
		
		if (isset($this->billingEntity['pr_corr_addr_line3']) && $this->billingEntity['pr_corr_addr_line3'] != ""){
			$data .= $this->billingEntity['pr_corr_addr_line3']."\n";			
		}			
		
		if (isset($this->billingEntity['pr_corr_post_code']) && $this->billingEntity['pr_corr_post_code'] != ""){
			$data .= $this->billingEntity['pr_corr_post_code']."\n";			
		}	
		
		if (isset($this->billingEntity['rf_country_name']) && $this->billingEntity['rf_country_name'] != ""){
			$data .= $this->billingEntity['rf_country_name']."\n";			
		}	

		$pdf->SetFont('Arial', '', 9);
		$pdf->SetLeftMargin(10);
		$pdf->SetRightMargin(10);
		$pdf->SetXY(10,10);
		$pdf->Write(4, $data);
		$pdf->SetXY(10,9);
		$pdf->Cell(90,22,'',1,1,'C');

 	}

	function PDFSummaryHeader(&$pdf, $item) {
		$data = "";

		$travelDate = explode(":",$this->GetParamValue("travelDateRange"));

		$data .= "SUMMARY\n".trim($this->billingEntity['name'])."\nDate: ".ucfirst($travelDate[0])." ".formatField($travelDate[1],'date')." to ".formatField($travelDate[2],'date')."\nAccount No(s): ".join(",",$this->GetAccountNumbers($item));

		$pdf->SetFont('Arial', '', 9);
		$pdf->SetXY(105,10);
		$pdf->SetLeftMargin(105);
		$pdf->SetRightMargin(10);
		$pdf->Write(4, $data);
		$pdf->SetXY(105,9);
		$pdf->Cell(90,22,'',1,1,'C');
 	}

	function PDFResHeaderRow($reservation) {

		$data = "";

		$sections = array();

		if ($this->GetParamValue("reservationResNo") == "1"){
			$sections['name'] = $reservation['rv_reservation_id'];
		}

		if ($this->GetParamValue("reservationName") == "1"){
			$sections['number'] = $reservation['rv_res_name'];
		}		

		if(!empty($sections)){
			$data = "Reservation: ".join(", ", $sections);
		}
		
		// $pdf->SetFont('Arial','B',7);		
		// $pdf->SetXY(10,$ypos);
		// $pdf->SetLeftMargin(10);
		// $pdf->SetRightMargin(120);
		// $section_start = $pdf->GetY();
		// $pdf->Write(4, $data);		
		// $section_end = $pdf->GetY();
		// $pdf->Write(4, $section_end - $section_start);

		// return ($section_end - $section_start + 4);

		return $data;
	}

	function PDFResTravelRow($reservation) {
		$data = "";
		$sections = array();

		if($this->GetParamValue("reservationArriveDate") == "1" && $this->GetParamValue("reservationDepartDate") == "1") {
			$sections['travel'] = "Travel: ".formatField($reservation['rv_date_arrive'],'date')." to ".formatField($reservation['rv_date_depart'],'date');
		} elseif ($this->GetParamValue("reservationArriveDate") == "1"){
			$sections['travel'] = "Travel: Arrive ".formatField($reservation['rv_date_arrive'],'date');
		} elseif ($this->GetParamValue("reservationDepartDate") == "1"){
			$sections['travel'] = "Travel: Depart ".formatField($reservation['rv_date_depart'],'date');
		}

		if ($this->GetParamValue("reservationVoucher") == "1" && isset($reservation['rv_agent_ref']) && $reservation['rv_agent_ref'] != ""){
			$sections['voucher'] = "Voucher: ".$reservation['rv_agent_ref'];
		}

		if ($this->GetParamValue("reservationRateType") == "1" && isset($reservation['rate_type']) && $reservation['rate_type'] != ""){
			$sections['rateType'] = "Rate type: ".$reservation['rate_type'];
		}		

		if($this->GetParamValue("reservationBedNights") == "1") {
			$numBedNights = 0;
			foreach($reservation['folios'] as $folio){
				foreach ($folio['itineraries'] as $itinerary){
					$numBedNights += $itinerary['rv_reservation_item.bed_nights'];
				}
			}
			$sections['bedNights'] = "Bednights: $numBedNights";
		}

		if($this->GetParamValue("reservationProperties") == "1") {
			$propArray = array();
			foreach($reservation['folios'] as $folio){
				foreach ($folio['itineraries'] as $itinerary){
					$propArray[$itinerary['rv_reservation_item.pr_business']] = $itinerary['rv_reservation_item.pr_business'];
				}
			}
			$sections['properties'] = "Properties: ".join(", ",$propArray);
		}

		$data .= join("; ", $sections);
		
		// $pdf->SetFont('','');
		// $pdf->SetXY(10,$ypos);
		// $pdf->SetLeftMargin(10);
		// $pdf->SetRightMargin(120);
		// $section_start = $pdf->GetY();
		// $pdf->Write(4, $data);		
		// $section_end = $pdf->GetY();

		// return ($section_end - $section_start + 4);

		return $data;
	}

	function PDFResPayPlanRow($reservation) {
		$data = "";
		$sections = array();

		if($this->GetParamValue("payPlanName") == "1" && isset($reservation['pay_plan']) && $reservation['pay_plan'] != "") {
			$sections['name'] = $reservation['pay_plan'];
		}

		if($this->GetParamValue("payPlanItems") == "1") {
			$payPlanItems = array();
			foreach ($reservation['pay_plan_items'] as $pay_plan_item){
				$payPlanItems[] = "Due ".formatField($pay_plan_item['rv_pay_plan_date'],'date')." = ".formatField($pay_plan_item['rv_pay_plan_amount'],'amount');
			}				
			$sections['items'] = join("; ", $payPlanItems);
		}		

		if(!empty($sections)){
			$data .= "Pmt plan: ".join("; ", $sections);
		}

		// $pdf->SetFont('','');
		// $pdf->SetXY(10,$ypos);
		// $pdf->SetLeftMargin(10);
		// $pdf->SetRightMargin(120);
		// $pdf->Write(4, $data);		

		// return 8;

		return $data;
	}

	function PDFDetailAccountsRow(&$pdf, $item) {

		$data = "";

		$sections = array();

		if($this->GetParamValue("debtorEmailAddress") == "1" && isset($item['debtor_persona.debtor_email']) && $item['debtor_persona.debtor_email'] != "") {
			$sections['email'] = "Email: ".$item['debtor_persona.debtor_email'];
		}

		if($this->GetParamValue("debtorTelephone") == "1" && isset($item['debtor_persona.debtor_phone']) && $item['debtor_persona.debtor_phone'] != "") {
			$sections['tel'] = "Tel: ".$item['debtor_persona.debtor_phone'];
		}

		if($this->GetParamValue("debtorWebAddress") == "1" && isset($item['debtor_persona.debtor_web']) && $item['debtor_persona.debtor_web'] != "") {
			$sections['web'] = "Web: ".$item['debtor_persona.debtor_web'];
		}

		if(!empty($sections)){
			$data .= "Account: ".$item['fn_folio.fn_folio_to']."; ".join("; ",$sections)."\n";
		} else {
			$data .= "Account: ".$item['fn_folio.fn_folio_to']."\n";
		}

		$pdf->SetFont('Arial', '', 7);
		$pdf->SetXY(10,32);
		// $pdf->SetLeftMargin(10);
		// $pdf->SetRightMargin(120);
		// $section_start = $pdf->GetY();
		// $pdf->Write(4, $data);
		// $section_end = $pdf->GetY();

		// $pdf->SetXY(10,32);
		// $pdf->Cell(90,($section_end - $section_start + 2),'',1,1,'C');

		// MultiCell Test
		$pdf->MultiCell(90,$pdf->FontSize+1,$data,1,1,'');

		return $pdf->GetY();

	}

	function PDFResContactRow($reservation) {
		$data = "";
		$sections = array();

		if($this->GetParamValue("contactEmailAddress") == "1" && isset($reservation['contact_persona.rv_corr_persona_email']) && $reservation['contact_persona.rv_corr_persona_email'] != "") {
			$sections['email'] = "Email: ".$reservation['contact_persona.rv_corr_persona_email'];
		}

		if($this->GetParamValue("contactTelephone") == "1" && isset($reservation['contact_persona.contact_phone']) && $reservation['contact_persona.contact_phone'] != "") {
			$sections['tel'] = "Tel: ".$reservation['contact_persona.contact_phone'];
		}

		if($this->GetParamValue("contactWebAddress") == "1" && isset($item['contact_persona.debtor_web']) && $item['contact_persona.debtor_web'] != "") {
			$sections['web'] = "Web: ".$reservation['contact_persona.debtor_web'];
		}

		if(!empty($sections)){
			$data .= "Contact: ".$reservation['contact_persona.rv_corr_persona_name']."; ".join("; ",$sections);
		} else {
			$data .= "Contact: ".$reservation['contact_persona.rv_corr_persona_name'];
		}

		// $pdf->SetFont('Arial', '', 7);
		// $pdf->SetXY(10,$ypos);
		// $pdf->SetLeftMargin(10);
		// $pdf->SetRightMargin(120);
		// $pdf->SetFont('','B');
		// $pdf->Write(4, $data);

		// return 6;

		return $data;
	}	

	function PDFSummaryAccountsRow(&$pdf, $item) {
		
		$data = "";

		$data .= $item['fn_folio.fn_folio_to']."\n";

		if (isset($item['debtor_persona.pr_corr_country_name']) && $item['debtor_persona.pr_corr_country_name'] != ""){
			$data .= $item['debtor_persona.pr_corr_country_name'];			
		}			

		$pdf->SetFont('Arial', '', 7);
		$pdf->SetXY(105,32);
		$pdf->SetLeftMargin(105);
		$pdf->SetRightMargin(10);
		$pdf->Write(4, $data);
		$pdf->SetXY(105,32);
		$pdf->Cell(90,10,'',1,1,'C');


		// $pdf->SetXY(10,35);
		// $pdf->SetLeftMargin(10);
		// $pdf->SetRightMargin(120);
		// $pdf->Write(4, $data);
		// $pdf->SetXY(10,35);
		// $pdf->Cell(90,10,'',1,1,'C');

	}

	// function PDFSummaryContactRow(&$pdf, $item) {
	// 	$data = "";

	// 	$data .= $item['pr_persona.pr_corr_country_name'];

	// 	$pdf->SetXY(105,42);
	// 	$pdf->SetLeftMargin(105);
	// 	$pdf->SetRightMargin(10);
	// 	$pdf->Write(4, $data);

	// }		

	function PDFSummaryResTable(&$pdf, $item){
		$data = "";
		$summary = array();
		$this->summaryOnly = ($this->GetParamValue("sectionsDetail") != 1 && $this->GetParamValue("sectionsSummary") == 1);
		$summaryRightMargin = $this->summaryOnly ? 110 : 120;
		// $ypos = 44;


		$pdf->SetFont('Arial', '', 5);
		$pdf->SetXY(105,44);
		$pdf->SetLeftMargin(10);
		$pdf->SetRightMargin($summaryRightMargin);

		$headRow = array();
		
		if (!$this->summaryOnly) {
			array_push($headRow,
				array('width'=>"20%", 'height'=>"4", 'data'=>"Res. No.", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"20%", 'height'=>"4", 'data'=>"Date", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"20%", 'height'=>"4", 'data'=>"Inv. No.", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"20%", 'height'=>"4", 'data'=>"Curreny", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"20%", 'height'=>"4", 'data'=>"Balance", 'border'=>"", 'fill'=>0, 'style'=>"B", 'align'=>"R")
			);
		}
		else {
			array_push($headRow,
				array('width'=>"12%", 'height'=>"4", 'data'=>"Res. No.", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"28%", 'height'=>"4", 'data'=>"Res. Name", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"15%", 'height'=>"4", 'data'=>"Date", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"15%", 'height'=>"4", 'data'=>"Inv. No.", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"15%", 'height'=>"4", 'data'=>"Curreny", 'border'=>"", 'fill'=>0, 'style'=>"B"),
				array('width'=>"15%", 'height'=>"4", 'data'=>"Balance", 'border'=>"", 'fill'=>0, 'style'=>"B", 'align'=>"R")
			);
		}
      
		$pdf->Row($headRow);
		$ycount = 1;

		foreach ($item['reservations'] as $key => $reservation){
			foreach ($reservation['folios'] as $folio){
				$dataRow = array();
				if (!$this->summaryOnly) {
					array_push($dataRow,
						array('width'=>"20%", 'height'=>"4", 'data'=>$key, 'border'=>"", 'fill'=>0),
						array('width'=>"20%", 'height'=>"4", 'data'=>formatField($folio['fn_folio.fn_folio_date'],'date'), 'border'=>"", 'fill'=>0),
						array('width'=>"20%", 'height'=>"4", 'data'=>$folio['fn_invoice.fn_invoice_ix'], 'border'=>"", 'fill'=>0),
						array('width'=>"20%", 'height'=>"4", 'data'=>$folio['fn_folio.rf_currency_symbol'], 'border'=>"", 'fill'=>0),
						array('width'=>"20%", 'height'=>"4", 'data'=>formatField(($folio['fn_folio.fn_folio_amount'] - $folio['fn_folio.fn_folio_amt_paid']),'amount'), 'border'=>"", 'fill'=>0, 'align'=>"R")
					);
				}
				else {
					array_push($dataRow,
						array('width'=>"12%", 'height'=>"4", 'data'=>$key, 'border'=>"", 'fill'=>0),
						array('width'=>"28%", 'height'=>"4", 'data'=>$reservation['rv_res_name'], 'border'=>"", 'fill'=>0),
						array('width'=>"15%", 'height'=>"4", 'data'=>formatField($folio['fn_folio.fn_folio_date'],'date'), 'border'=>"", 'fill'=>0),
						array('width'=>"15%", 'height'=>"4", 'data'=>$folio['fn_invoice.fn_invoice_ix'], 'border'=>"", 'fill'=>0),
						array('width'=>"15%", 'height'=>"4", 'data'=>$folio['fn_folio.rf_currency_symbol'], 'border'=>"", 'fill'=>0),
						array('width'=>"15%", 'height'=>"4", 'data'=>formatField(($folio['fn_folio.fn_folio_amount'] - $folio['fn_folio.fn_folio_amt_paid']),'amount'), 'border'=>"", 'fill'=>0, 'align'=>"R")
					);
				}

				$pdf->SetX(105);
				$pdf->SetLeftMargin(10);
				$pdf->SetRightMargin($summaryRightMargin);
				$pdf->Row($dataRow);
				$ycount++;

			}
		}

		// $pdf->SetXY(105,$ypos-1);
		// $pdf->Cell(90,((3*$ycount)+2),'',1,1,'C');

		$ypos = ($pdf->GetY())+3;

		return $ypos;
	
	}

	function PDFSummaryAmountsTable(&$pdf, $item, $ypos) {
		$data = "";

		$pdf->SetXY(105,$ypos);
		// $pdf->SetLeftMargin(10);
		// $pdf->SetRightMargin(120);
		
		$headRow = array();
		
		array_push($headRow,
			array('width'=>"60%", 'height'=>"4", 'data'=>"Amount Due:", 'border'=>"", 'fill'=>0, 'style'=>"B"),
			array('width'=>"40%", 'height'=>"4", 'data'=>"", 'border'=>"", 'fill'=>0)
		);

		$pdf->Row($headRow);

		$ycount = 1;
		foreach($item['totals'] as $curr=>$total){
			$dataRow = array();
			array_push($dataRow,
				array('width'=>"60%", 'height'=>"4", 'data'=>$curr, 'border'=>"", 'fill'=>0),
				array('width'=>"40%", 'height'=>"4", 'data'=>formatField($total,'amount'), 'border'=>"", 'fill'=>0, 'align'=>"R")
			);

			$pdf->SetXY(105,$ypos+(4*$ycount));
			// $pdf->SetLeftMargin(10);
			// $pdf->SetRightMargin(120);
			$pdf->Row($dataRow);
			$ycount++;

		}

		$pdf->SetXY(105,$ypos-1);
		$pdf->Cell(90,((4*$ycount)+1),'',1,1,'C');
	
	}	

	function PDFFoliosTable(&$pdf, $reservation, $ypos) {

		// $ypos = $pdf->GetY();
		$pdf->SetFont('Arial', '', 5);
		$pdf->SetXY(10,$ypos);
		$pdf->SetLeftMargin(10);
		$pdf->SetRightMargin(120);

		$headRow = array();

		if($this->GetParamValue("folioNumber") == "1"){
			$headRow[] = array('width'=>"13", 'height'=>"3", 'data'=>"Folio", 'border'=>"", 'fill'=>0, 'style'=>"B");
		}

		$headRow[] = array('width'=>"13", 'height'=>"3", 'data'=>"Date", 'border'=>"", 'fill'=>0, 'style'=>"B");

		if($this->GetParamValue("folioInvoiceNumber") == "1"){
			$headRow[] = array('width'=>"13", 'height'=>"3", 'data'=>"Inv. No.", 'border'=>"", 'fill'=>0, 'style'=>"B");
		}		
		
		array_push($headRow,
			array('width'=>"13", 'height'=>"3", 'data'=>"Rec. No.", 'border'=>"", 'fill'=>0, 'style'=>"B"),
			array('width'=>"13", 'height'=>"3", 'data'=>"Curr", 'border'=>"", 'fill'=>0, 'style'=>"B"),
			array('width'=>"13", 'height'=>"3", 'data'=>"Amount", 'border'=>"", 'fill'=>0, 'style'=>"B", 'align'=>"R"),
			array('width'=>"13", 'height'=>"3", 'data'=>"Balance", 'border'=>"", 'fill'=>0, 'style'=>"B", 'align'=>"R")
		);

		$ypos = $ypos+3;
		$pdf->Row($headRow);
		$pdf->SetXY(10,$ypos); //  Had to hack this for some reason
		$rows = 0;

		foreach($reservation['folios'] as $key => $folio){
			$ypos = $pdf->GetY();
			$dataRow = array();

			if($this->GetParamValue("folioNumber") == "1"){
				$dataRow[] = array('width'=>"13", 'height'=>"3", 'data'=>$folio['fn_folio.fn_folio_folio_num'], 'border'=>"", 'fill'=>0);
			}

			$dataRow[] = array('width'=>"13", 'height'=>"3", 'data'=>formatField($folio['fn_folio.fn_folio_date'],'date'), 'border'=>"", 'fill'=>0);

			if($this->GetParamValue("folioInvoiceNumber") == "1"){
				$dataRow[] = array('width'=>"13", 'height'=>"3", 'data'=>$folio['fn_invoice.fn_invoice_ix'], 'border'=>"", 'fill'=>0);
			}	

			array_push($dataRow,
				array('width'=>"13", 'height'=>"3", 'data'=>"", 'border'=>"0", 'fill'=>0),
				array('width'=>"13", 'height'=>"3", 'data'=>$folio['fn_folio.rf_currency_symbol'], 'border'=>"0", 'fill'=>0),
				array('width'=>"13", 'height'=>"3", 'data'=>formatField($folio['fn_folio.fn_folio_amount'],'amount'), 'border'=>"0", 'fill'=>0, 'align'=>"R"),
				array('width'=>"13", 'height'=>"3", 'data'=>formatField(($folio['fn_folio.fn_folio_amount'] - $folio['fn_folio.fn_folio_amt_paid']),'amount'), 'border'=>"0", 'fill'=>0, 'align'=>"R")
			);

			$pdf->Row($dataRow);
			$ypos = $ypos+3;
			$pdf->SetXY(10,$ypos); 	// Had to hack this for some reason.  PDF's own row function seems to do weird things here because
									// of the summary table on teh right.
			if (isset($row)) {
				$row++;
			} else {
				$row = 1;
			}

			if (isset($folio['payments'])){
				foreach ($folio['payments'] as $payment){

					$dataRow = array();

					if($this->GetParamValue("folioNumber") == "1"){
						$dataRow[] = array('width'=>"13", 'height'=>"3", 'data'=>"", 'border'=>"", 'fill'=>0);
					}

					$dataRow[] = array('width'=>"13", 'height'=>"3", 'data'=>formatField($payment['date'],'date'), 'border'=>"", 'fill'=>0);

					if($this->GetParamValue("folioInvoiceNumber") == "1"){
						$dataRow[] = array('width'=>"13", 'height'=>"3", 'data'=>"", 'border'=>"", 'fill'=>0);
					}	

					array_push($dataRow,
						array('width'=>"13", 'height'=>"3", 'data'=>$payment['receipt'], 'border'=>"", 'fill'=>0),
						array('width'=>"13", 'height'=>"3", 'data'=>$folio['fn_folio.rf_currency_symbol'], 'border'=>"", 'fill'=>0),
                        array('width'=>"13", 'height'=>"3", 'data'=>formatField(($payment['amount']*-1),'amount'), 'border'=>"", 'fill'=>0, 'align'=>"R"),
                        array('width'=>"13", 'height'=>"3", 'data'=>"", 'border'=>"", 'fill'=>0, 'align'=>"R")
					);

					$pdf->Row($dataRow);
					$ypos = $ypos+3;
					$pdf->SetXY(10,$ypos); 	// Had to hack this for some reason.  PDF's own row function seems to do weird things here because
											// of the table on teh right.					
					$row++;
				}
			}
	
		}
		
		return $ypos;
	}		

	function PDFDetailResTable(&$pdf, $item) {

		foreach ($item['reservations'] as $reservation){
			$PDFResHeaderBox = "";
			$PDFResHeaderBox .= $this->PDFResHeaderRow($reservation);
			$PDFResHeaderBox .= "\n";
			$PDFResHeaderBox .= $this->PDFResContactRow($reservation);
			// MultiCell Test
			$pdf->SetXY(10,($pdf->GetY()+1));
			$pdf->SetFont('Arial','B',7);
			$pdf->MultiCell(90,$pdf->FontSize+1,$PDFResHeaderBox,1,'L',1);			
			// $ypos = $pdf->GetY();
			// $ypos += $this->PDFResTravelRow($pdf, $reservation, $ypos);
			// $ypos += $this->PDFResPayPlanRow($pdf, $reservation, $ypos);

			$PDFResTravelRow = $this->PDFResTravelRow($reservation);
			$PDFResPayPlanRow = $this->PDFResPayPlanRow($reservation);
			$pdf->SetFont('Arial','',7);
			$pdf->MultiCell(90,$pdf->FontSize+1,$PDFResTravelRow,0,'L',0);	
			$pdf->MultiCell(90,$pdf->FontSize+1,$PDFResPayPlanRow,0,'L',0);	

			// We need to get the Y posision this way because the summary table to the right causes isues with GetY();
			$ypos = $pdf->GetY();
			$folioTableHeight = $this->PDFFoliosTable($pdf, $reservation,$ypos);
			$pdf->SetXY(10,($folioTableHeight+7));

		}

		// $pdf->SetXY(10,$ypos_start + 1);
		// $pdf->Cell(90,($ypos-$ypos_start+2),'',1,1,'C');

 	}

 	function PDFResHeaderBox(&$pdf, $ypos, $ypos_start){
		// Draw UNshaded box.  Unfortunately, since it has to be drawn AFTER the text "inside", it would 
		// conceal the text if shaded
		$pdf->SetXY(10,($ypos_start-1));
		$pdf->Cell(90,($ypos - $ypos_start+1),'',1,1,'C',0);
 	}

	function PDF(){
		$ypos = 0;
		$pdf = new custPDF("","P");
		
		$pdf->SetFont('Arial', '', 9);
		$pdf->SetAutoPageBreak(true, 20);

		// $pdf->SetXY(10,272);
		// $pdf->Write(4,"Endtest");

		if(sizeof($this->Data) > 0) {
			foreach($this->Data as $key=>$item) {
				if($this->GetParamValue("sectionsSummary") == "1") {
					$this->PDFSummaryHeader($pdf, $item);

					$this->PDFSummaryAccountsRow($pdf, $item);

					$ypos = $this->PDFSummaryResTable($pdf, $item);

					$this->PDFSummaryAmountsTable($pdf, $item, $ypos);				
				}
				
				if($this->GetParamValue("sectionsDetail") == "1") {
					$this->PDFDetailHeader($pdf, $item);
					
					$ypos = $this->PDFDetailAccountsRow($pdf, $item);

					$this->PDFDetailResTable($pdf, $item, $ypos);
				}
				
				//$this->PDFSummaryContactRow($pdf, $item);

				// Prevent creation of blank page at end
				if ($key < (count($this->Data)-1)){
					$pdf->AddPage();	
				}
				
			}
		}

		//pdf_view($pdf);
		if (isset($GLOBALS['pdfEcho'])){
			$pdf->OutPut('',false,true);
		} else {
			$pdf->Output();
		}
	}

// --- [END] PDF	

	function TotalColumnWidth() {
		$width = 0;
		foreach($this->Columns as $col) {
			$width += $col['width'] + ($this->Padding * 2);
		}
		return $width;
	}

	function HTMLColumnHeaders() {
		$this->SpanColumnLabels();
		$html = "";
		$max = $this->MaxColumnLabels();

		foreach($this->Columns as $col) {
			$html .= "<col style=\"width: $col[width]px\" />\n";
		}
		$html .= "<col style=\"width: 20px\" />\n";

		for($count=0;$count<$max;$count++) {
			$html .= "<tr>\n";
			$colNum = 1;
			foreach($this->Columns as $col) {
				if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
					$rowspan = "";
					if($count == (sizeof($col['labels']) - 1) && sizeof($col['labels']) < $max) {
						$rowspan = "rowspan=\"" .($max - sizeof($col['labels']) + 1). "\"";
					}

					$align = $col['align'];
					$colspan = "";
					if($col['spans'][$count] > 1) {
						$colspan = "colspan=\"".$col['spans'][$count]."\"";
						$align = "center";
					}
					$hover = "";
					if(empty($col['class'])) {
						//$hover = "onmouseover=\"colOver(".$colNum.");\" onmouseout=\"colOut(".$colNum.");\"";
					}
					$html .= "<td id=\"column_".$count."_".$colNum."\" $hover class=\"outDk\" $colspan $rowspan align=\"$align\" style=\"overflow: hidden;\">" . $col['labels'][$count] . "</td>\n";
				}
				$colNum++;
			}
			$html .= "<td class=\"outDk\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>\n";
			$html .= "</tr>\n";
		}
		return $html;
 	}

	function SpanColumnLabels() {
		$last = false;
		$lastKey = false;

		foreach($this->Columns as $key=>$col) {
			if($lastKey === false) {
				$lastKey = array_fill(0,sizeof($col['labels']),$key);
				$last = $col['labels'];
				$this->Columns[$key]['spans'] = array_fill(0,sizeof($col['labels']),1);
			} else {
				$check = false;
				$done = false;
				foreach($col['labels'] as $id=>$label) {
					if($done) { continue; }
					if(isset($last[$id]) && $last[$id] == $label) {
						$this->Columns[$lastKey[$id]]['spans'][$id]++;
						$this->Columns[$key]['spans'][$id] = 0;
					} else {
						for($count = $id; $count < sizeof($col['labels']); $count++) {
							$lastKey[$count] = $key;
							$last[$count] = $col['labels'][$count];
							$this->Columns[$key]['spans'][$count] = 1;
						}
						$done = true;
					}
				}
			}
		}
	}

	function MaxColumnLabels() {
		$max = 0;
		foreach($this->Columns as $col) {
			if(sizeof($col['labels']) > $max) {
				$max = sizeof($col['labels']);
			}
		}
		return $max;
	}

	function BuildReference() {
		$this->Reference = array();
		foreach($this->Data as $key=>$data) {
			if(!array_key_exists($key,$this->Reference)) {
				$this->Reference[$key] = array();
			}				
		}
	}

	// function BuildDisplay($prefix,$startDate,$endDate){

	// 	// [START] Debtor Details
	// 	$displayDebtorDetails = $this->GetParamValue("displayDebtorDetails");

	// 	$displayDebtorDetailsFields = array();
	// 	foreach($displayDebtorDetails as $key=>$item) {
	// 		if($item['active'] == "1") {
	// 			$displayDebtorDetailsFields[$key] = $item;
	// 		}
	// 	}
	// 	unset($displayDebtorDetails);

	// 	uasort($displayDebtorDetailsFields, "ReportSQLBuilderOrderCompare");	

	// 	foreach($displayDebtorDetailsFields as $col) {
	// 		$this->AddColumn($prefix . "_" . $col['name'],"Debtor Details",$col);
	// 	}

	// 	// [END] Debtor Details

	// 	// [START] Amount Details
	// 	$displayAmountDetails = $this->GetParamValue("displayAmountDetails");

	// 	$displayAmountDetailsFields = array();
	// 	foreach($displayAmountDetails as $key=>$item) {
	// 		if($item['active'] == "1") {
	// 			$displayAmountDetailsFields[$key] = $item;
	// 		}
	// 	}
	// 	unset($displayAmountDetails);

	// 	uasort($displayAmountDetailsFields, "ReportSQLBuilderOrderCompare");	

	// 	foreach($displayAmountDetailsFields as $col) {
	// 		$this->AddColumn($prefix . "_" . $col['name'],"Amount Details",$col);
	// 	}
	// 	// [END] Amount Details

	// 	$this->DisplayColumns = array_merge(
	// 								$displayAmountDetailsFields,
	// 								$displayDebtorDetailsFields
	// 							);
	// 	unset($displayAmountDetailsFields);
	// 	unset($displayDebtorDetailsFields);

	// 	foreach($this->Data as $key=>$item) {

	// 		foreach($this->DisplayColumns as $name=>$col) {
	// 			$this->Data[$key][$prefix . "_" . $name] = $item[$name];
	// 		}	
	// 	}

	// 	// [START] Reservation Details
	// 	$displayReservation = $this->GetParamValue("displayReservation");		
	// 	$displayReservationFields = array();
	// 	foreach($displayReservation as $key=>$item) {
	// 		if($item['active'] == "1") {
	// 			$displayReservationFields[$key] = $item;
	// 		}
	// 	}
	// 	unset($displayReservation);

	// 	// [END] Reservation Details

	// }

	function AddColumn($field,$labels,$col,$class=false,$format=false) {
		if(!is_array($labels)) {
			$labels = array($labels);
			$labels[] = $col['cols']['label']['value'];
		}

		if(!empty($col['cols']['header']['value'])) {
			$header = array_shift($labels);
			array_unshift($labels,$header,$col['cols']['header']['value']);
		}

		if(!empty($col['cols']['width']['value'])) {
			$width = $col['cols']['width']['value'];
		} else {
			$width = 100;
		}
		switch($col['cols']['align']['value']) {
		case "l":
			$align = "left";
			break;
		case "r":
			$align = "right";
			break;
		case "c":
			$align ="center";
			break;
		}

		if(empty($class)) {
			$class = "";
		}

		if($format === false && isset($col['format'])) {
			$format = $col['format'];
		}

		if(!isset($col['total'])) {
			$col['total'] = "";
		}

		$this->Columns[] = array(
			'field'=>$field,
			'labels'=>$labels,
			'sort'=>$col['cols']['sort_order']['value'],
			'direction'=>$col['cols']['sort_direction']['value'],
			'width'=>$width,
			'align'=>$align,
			'class'=>$class,
			'format'=>$format,
			'total'=>$col['total']
		);
	}	

	function BuildTotals(){

		foreach ($this->Data as $key=>$item){
			$this->Data[$key]['totals'] = array();
			foreach ($item['reservations'] as $reservation){
				foreach ($reservation['folios']as $folio){
					if (array_key_exists($folio['fn_folio.rf_currency_symbol'], $this->Data[$key]['totals'])){
						$this->Data[$key]['totals'][$folio['fn_folio.rf_currency_symbol']] += $folio['fn_folio.fn_folio_amount'] - $folio['fn_folio.fn_folio_amt_paid'];
					} else {
						$this->Data[$key]['totals'][$folio['fn_folio.rf_currency_symbol']] = $folio['fn_folio.fn_folio_amount'] - $folio['fn_folio.fn_folio_amt_paid'];
					}
					
				}
			}

		}
	}

	function GetAccountNumbers($debtor){
		global $lDB;

		$business_ids = array();
		foreach ($debtor['reservations'] as $reservation){
			foreach ($reservation['folios'] as $folio){
				$business_ids[] = $folio['invoicing_persona.pr_business_id'];
			}
		}

		$accountNumbers = $lDB->get("
			SELECT
				fn_debtor.fn_debtor_code
			FROM
				pr_persona_inv
				INNER JOIN fn_debtor ON pr_persona_inv.fn_debtor_id = fn_debtor.fn_debtor_ix
			WHERE
				pr_persona_inv.pr_business_id IN ('".join("','",$business_ids)."')
				AND pr_persona_inv.pr_persona_id = '".$debtor['fn_folio.fn_folio_to_key']."'
		",3);		
		
		return $accountNumbers;

	}	

}