<?php

 /**
  * init.form2007.php - Customer statement report email popup
  * Job: 2008
  * Function: 2000 (Reports Financials: Customer Statement)
  */

if ( isset($_POST['url']) && $_POST['url'] != "" ) {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$GLOBALS['temp']['url'] = isset($_POST['url']) ? $_POST['url'] : "";
$_POST['url'] = "";

global $princName;

$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
$principalInfo = getPersonaDetail($principalId);
$resOfficeInfo = getPersonaDetail($resOfficeId);

if(isset($_POST['action']) && $_POST['action'] == "send") {
	$reportFilters = $_POST['report_url'];
	$customer_filter_arg = $_POST['customer_filter_arg'];

	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/customer_statement_email_pop_submit.htm");

	$cc = $_POST['email_cc'];
	$from = $_POST['email_from'];
	$subject = $_POST['email_subject'];
	$body = $_POST['email_body'];
	$attachment_ind = isset($_POST['email_attachment_ind']) ? $_POST['email_attachment_ind'] : "";
	$extra_res_doc = $_POST['extra_res_doc'];
	$extra_proforma = $_POST['extra_proforma'];
	$extra_invoice = $_POST['extra_invoice'];

	$items = unserialize(stripslashes($_POST['items']));

	$fileDate = date("Ymd");

	//$GLOBALS['temp']['princName'] = $principalName;
	$headers = "From: ".$princName."<$from>\r\n";

	$results = array();	
	foreach($items as $personaItem) {
		$attachments = array();
		$invoices = array();

		$attachments[] = array(
			'filename'=>"statement.pdf",
			'data'=>getCustomerPDF($personaItem['pr_persona_id'], $reportFilters, $customer_filter_arg)
		);
		
		if($extra_res_doc == "1"){
			foreach($personaItem['reservations'] as $reservation_id){
				$attachments[] = array(
					'filename'=>$reservation_id.".pdf",
					'data'=>getReservationDoc($reservation_id)
				);									
			}
			
		}

		if($extra_proforma == "1"){
			foreach($personaItem['folios'] as $folio_id){
				$attachments[] = array(
					'filename'=>"proforma_".$folio_id.".pdf",
					'data'=>getProformaDoc($folio_id)
				);									
			}
			
		}

		if($extra_invoice == "1"){
			foreach($personaItem['invoices'] as $invoice_id){
				$attachments[] = array(
					'filename'=>"invoice_".$folio_id.".pdf",
					'data'=>getInvoiceDoc($invoice_id)
				);									
			}
			
		}		

		// Temp for debug
		$to = $personaItem['pr_email'];
		// $to = "nicks@resrequest.com";

		if(!empty($cc)) {
			$to .= "," . $cc;
		}

		$error = email($from, $to, $subject, $headers, $body, 0, 0, "", $princName, $attachments, "",false);

		$results[] = array(
			'error'=>($error?"1":"0"),
			'from'=>$from,
			'to'=>$personaItem['pr_email'],
			'cc'=>$cc,
			'subject'=>$subject,
			'attachments'=>sizeof($attachments),
			'invoices'=>sizeof($invoices)
		);
	}
	$GLOBALS['temp']['data'] = serialize($results);
} elseif(isset($_POST['action']) && $_POST['action'] == "result") {
	if (!isset($GLOBALS[$form])) {
	   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/customer_statement_email_pop_result.htm");
	}

	$resultRowHTML = "
		<tr>
			<td class=\"colWh br\" style=\"width:25px; text-align:center;\"><img src=\"/resource/Resrequest/Application/public/img/!image!\" /></td>
			<td class=\"colWh br\" style=\"width:94px; overflow: hidden;\">!from!</td>
			<td class=\"colWh br\" style=\"width:94px; overflow: hidden;\">!to!</td>
			<td class=\"colWh br\" style=\"width:94px; overflow: hidden;\">!cc!</td>
			<td class=\"colWh br\" style=\"width:115px; overflow: hidden;\">!subject!</td>
			<td class=\"colWh br\" style=\"width:45px; text-align: right;\">!attachments!</td>
			<td class=\"colWh\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>		
	";
	$results = unserialize(stripslashes($_POST['data']));
	$rows = "";
	foreach($results as $result) {
		if($result['error'] == "1") {
			$result['image'] = "icon_close_16.gif";
		} else {
			$result['image'] = "icon_select_16.gif";
		}
		if(empty($result['cc'])) {
			$result['cc'] = "&nbsp;";
		}
		$rows .= showpage($result,$resultRowHTML);
	}
	$GLOBALS['temp']['rows'] = $rows;

	$GLOBALS['temp']['dateTime'] = chng_date(date("Y-m-d"),"-") . " " . date("H:i:s");
} else {

	$reportFilters = $_POST['report_url'];
	$customer_filter_arg = $_POST['customer_filter_arg'];
	$from_date = $_POST['from_date'];
	$to_date = $_POST['to_date'];

	// Customer data
	$list = explode(":",$_POST['selected_customers_list']);
	if (!empty($list)){
		$customer_ids = array();
		$customer_data = array();
		foreach ($list as $item){
			$tmp = explode("_", $item);
			$customer_data[$tmp[0]]['reservations'] = explode("|",$tmp[1]);
			$customer_data[$tmp[0]]['folios'] = explode("|",$tmp[2]);
			$customer_data[$tmp[0]]['invoices'] = explode("|",$tmp[3]);
			$customer_ids[] = $tmp[0];
		}
	}

	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/customer_statement_email_popup.htm");

	$templateData = initTemplates("");
	if($templateData !== false) {
		$GLOBALS['temp']['templateToggle'] = $templateData['toggle'];
	} else {
		$GLOBALS['temp']['templateToggle'] = "";
	}

	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];

	$GLOBALS['temp']['emailSubject'] = "Customer Statement";


	$user = $lDB->get("select pr_persona.pr_name_first, pr_persona.pr_name_last from pr_persona WHERE pr_persona_ix = '".$GLOBALS['userid']."'",1);
	$user_name = trim($user['pr_name_first']." ".$user['pr_name_last']);
	$principal_name = $GLOBALS['principal_name'];

	$email_text = "
Hi,

Please find attached your customer statement dated ".$from_date." to ".$to_date.".

Kind regards,

$user_name
$principal_name

	";

	$GLOBALS['temp']['emailBody'] = $email_text;

	$GLOBALS['temp']['report_url'] = $reportFilters;
	$GLOBALS['temp']['customer_filter_arg'] = $customer_filter_arg;	

	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$GLOBALS[userid]'
	",4);

	if (!empty($customer_ids)){
		$list = $lDB->get("
			SELECT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first,
				pr_persona.pr_email
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix IN ('".join("','",$customer_ids)."')
		",2);

		$customerList = array();
		foreach($list as $item) {
			$key = $item['pr_persona_ix'];
			if(!array_key_exists($key,$customerList)) {
				$customerList[$key] = array(
					'pr_persona_id'=>$key,
					'pr_name'=>trim($item['pr_name_first'] . " " . $item['pr_name_last']),
					'pr_email'=>$item['pr_email'],
					'reservation_ids'=>join(":",$customer_data[$key]['reservations']),
					'folio_ids'=>join(":",$customer_data[$key]['folios']),
					'invoice_ids'=>join(":",$customer_data[$key]['invoices']),
				);
			}
		}

		$rows = "<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
		$customerRowHTML = "
				<tr valign=\"top\">
					<td width=\"46%\" align=\"left\">
						<input type=\"hidden\" name=\"pr_persona_id\" id=\"id_!pr_persona_id!\" />
						<input type=\"hidden\" name=\"reservation_ids\" id=\"resids_!pr_persona_id!\" value=\"!reservation_ids!\"/>
						<input type=\"hidden\" name=\"folio_ids\" id=\"folioids_!pr_persona_id!\" value=\"!folio_ids!\"/>
						<input type=\"hidden\" name=\"invoice_ids\" id=\"invids_!pr_persona_id!\" value=\"!invoice_ids!\"/>
						!pr_name!
					</td>
					<td width=\"8%\">
						<button type=\"button\" class=\"button\" style=\"width:20px; height: 20px;\" onclick=\"contact_popup('email!pr_persona_id!');\"><img src=\"/resource/Resrequest/Application/public/img/button_prop_filter.gif\" /></button>
					</td>
					<td width=\"46%\" align=left>
						<input style=\"width:100%;\" type=\"text\" value=\"!pr_email!\" id=\"email!pr_persona_id!\" />
					</td>
				</tr>
		";


		foreach($customerList as $customer) {
			$rows .= showpage($customer,$customerRowHTML);
		}

		$rows .= "</table>";

		$GLOBALS['temp']['rows'] = $rows;		


	}

}

	


