<?php

 /**
  * init.form2009.php - Specials
  * Job: 2010
  * Function: 68 (Rates)
  */

if ($_SERVER['argc'] > 1){	

	$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

	$specialID = $_SERVER['argv'][1];
	$specialAction = $_SERVER['argv'][2];

	switch($specialAction){
	case "delete":
		if ($specialAction == "delete"){
			db_sp_special_delete($specialID);	
		}

		// Redirect at the end regardless (solves F5 issue)
		redirectTo(" ./reservation.php?2010");	
		break;
	case "restore":
		if ($specialAction == "restore"){
			db_sp_special_restore($specialID);	
		}

		// Redirect at the end regardless (solves F5 issue)
		redirectTo(" ./reservation.php?2010");	
		break;
	case "in_use_check":
		echo (db_sp_special_in_use_check($specialID)) ? "1" : "0";

		break;
	case "move":

		$direction = $_SERVER['argv'][3];

		$oldPriority = $GLOBALS['lDB']->get("
			SELECT
				sp_special.sp_special_priority
			FROM
				sp_special
			WHERE
				sp_special.sp_special_ix = '$specialID'
		",4);

		if ($direction == 0){ // Up
			$movement = -1;
			$newPriority = $oldPriority - 1;
		} else { // Down
			$movement = 1;
			$newPriority = $oldPriority + 1;
		}

		$allSpecialID = $GLOBALS['lDB']->get("
			SELECT
				sp_special.sp_special_ix,
				sp_special.sp_special_priority
			FROM
				sp_special
			ORDER BY
				sp_special.sp_special_priority
		",3);

		$key = array_search ($specialID, $allSpecialID);

		// Do nothing if in first position with upward movement, or last position with downward movement
		if ( !($key == 0 && $movement == -1 ) && !($key == (count($allSpecialID)-1) && $movement == 1)  ) {
			$out = array_splice($allSpecialID, $key, 1);
	    	array_splice($allSpecialID, ($key + $movement), 0, $out);
			foreach ($allSpecialID as $position => $id) {
				$GLOBALS['lDB']->put("
					UPDATE
						sp_special
					SET 
						sp_special_priority = ".$position."
					WHERE
						sp_special.sp_special_ix = '$id'
				");
			}
		}


		// Redirect at the end regardless (solves F5 issue)
		redirectTo(" ./reservation.php?2010");	
		break;
	}

	die();
}

if ( !isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/specials.htm");
}

$specials = $GLOBALS['lDB']->get("
	SELECT
		sp_special.sp_special_ix,
		sp_special.sp_special_desc,
		sp_special.sp_special_inactive_yn
	FROM
		sp_special
	ORDER BY
		sp_special.sp_special_priority
",2);

$specialData = array();
if (!empty($specials)) {
	foreach ($specials as $special){
		if ($special['sp_special_inactive_yn'] == 1) {
			$specialData[] = "<option style=\"color:#777\" value=\"".$special['sp_special_ix']."\" onclick=\"inactiveSpecialSelected();\" ondblclick=\"restoreSpecial();\">".$special['sp_special_desc']."</option>";
		} else {
			$specialData[] = "<option value=\"".$special['sp_special_ix']."\" onclick=\"specialSelected();\"  ondblclick=\"editSpecial();\">".$special['sp_special_desc']."</option>";
		}
	}
}

$GLOBALS['temp']['specialsRows'] = join($specialData,"");

$jobLevel = checkJob(2010,2);
$GLOBALS['temp']['readOnly'] = ($jobLevel < 10) ? "1" : "0";