<?php

/*
 * $Id: init.form201.php,v 1.6 2010-11-24 14:15:34 light Exp $
 *
 * $Log: init.form201.php,v $
 * Revision 1.6  2010-11-24 14:15:34  light
 * Bug #7385 - Add daily exchange rate to invoicing (plus enhancements)
 *
 *
 */

/**
 * init.form201.php - Daily exchange rate (list)
 * Job: 617,618,619,620,621,622
 * Function: 58 (Code Tables: Financial)
*/

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", "");
}

$GLOBALS['temp']['imgMode1'] = "std";
$GLOBALS['temp']['imgMode2'] = "std";
$GLOBALS['temp']['imgMode3'] = "std";
$GLOBALS['temp']['imgMode4'] = "std";
$GLOBALS['temp']['imgMode5'] = "std";
$GLOBALS['temp']['imgMode6'] = "std";
$GLOBALS['temp']['imgMode7'] = "std";
$GLOBALS['temp']['imgMode8'] = "std";
	
$order = " asc";
if($_SERVER['argv'][4] == "1") {
	$order = " desc";
}
switch($_SERVER['argv'][3]) {
case 0:
	$orderbyfield = "rf_exchange_rate.rf_exch_date";
	if($order == " asc") {
		$GLOBALS['temp']['imgMode1'] = "down";
	} else {
		$GLOBALS['temp']['imgMode2'] = "down";
	}
	break;
case 1:
	$orderbyfield = "from_currency.rf_currency_symbol";
	if($order == " asc") {
		$GLOBALS['temp']['imgMode3'] = "down";
	} else {
		$GLOBALS['temp']['imgMode4'] = "down";
	}
	break;
case 2:
	$orderbyfield = "to_currency.rf_currency_symbol";
	if($order == " asc") {
		$GLOBALS['temp']['imgMode5'] = "down";
	} else {
		$GLOBALS['temp']['imgMode6'] = "down";
	}
	break;
case 3:
	$orderbyfield = "rf_exchange_rate.rf_exch_rate";
	if($order == " asc") {
		$GLOBALS['temp']['imgMode7'] = "down";
	} else {
		$GLOBALS['temp']['imgMode8'] = "down";
	}
	break;
}

$RecordStart = "0";
$date = $_SERVER['argv'][2];
if(empty($date)) {
	$date = date("Y-m-d");
}    
$where = " WHERE rf_exchange_rate.rf_exch_date = '$date'";

$list = $GLOBALS['lDB']->get("
	SELECT
		rf_exchange_rate.rf_exchange_rate_ix,
		rf_exchange_rate.rf_exch_rate,
		rf_exchange_rate.rf_exch_date,
		rf_exchange_rate.rf_exch_curr_from_id,
		from_currency.rf_currency_symbol AS from_currency_symbol,
		from_currency.rf_currency_inactive_yn AS from_currency_inactive_yn,
		rf_exchange_rate.rf_exch_curr_to_id,
		to_currency.rf_currency_symbol AS to_currency_symbol,
		to_currency.rf_currency_inactive_yn AS to_currency_inactive_yn,
		rf_database.rf_db_code,
		rf_database.rf_db_description,
		rf_database.rf_db_env_type_ind 
	FROM
		rf_exchange_rate
		INNER JOIN rf_currency AS from_currency ON from_currency.rf_currency_ix = rf_exchange_rate.rf_exch_curr_from_id
		INNER JOIN rf_currency AS to_currency ON to_currency.rf_currency_ix = rf_exchange_rate.rf_exch_curr_to_id
		INNER JOIN rf_database ON rf_database.rf_db_code = rf_exchange_rate.rf_exchange_rate_db
	WHERE
		rf_exchange_rate.rf_exch_date = '$date'
	ORDER BY 
		$orderbyfield $order
",2);
$GLOBALS['temp']['numrows'] = sizeof($list);
/*if ($action != "3") {
	$selectjob = "617";
} else {
	$selectjob = "620";
}*/
/* WARNING: Override of normal financial code table security to allow property updates */
$jobLevel = $GLOBALS['lDB']->get("
	SELECT
		sc_fun_grp_level
	FROM
		sc_user
		INNER JOIN sc_fun_group ON sc_fun_group.sc_group_id = sc_user.sc_group_id	
		INNER JOIN sc_fun_job ON sc_fun_job.sc_function_id = sc_fun_group.sc_function_id
	WHERE
		sc_user.pr_user_id = '$GLOBALS[userid]'
		AND sc_fun_job.sc_job_id = '620'
",4);
if($jobLevel > 5) {
	$selectjob = $sortjob = "620";
	if($record == "") {
		$sortjob = "618";
	}
} else {
	$selectjob = $sortjob = "617";
}
$GLOBALS['temp']['selectjob'] = $selectjob;
$GLOBALS['temp']['sortjob'] = $sortjob;
$GLOBALS['temp']['rows'] = "";
$counti = "0";
$rowHTML = join("", file(__DIR__ . "/../../../public/html/code_daily_rates_rows.htm"));
$rows = "";
foreach($list as $item) {
	$exch_id = $item['rf_exchange_rate_ix'];
	$exch_rate = trimExchangeRate($item['rf_exch_rate']);
	$exch_date = chng_date($item['rf_exch_date'],"-");
	$exch_from = $item['from_currency_symbol'];
	$inactive_from = $item['from_currency_inactive_yn'];
	$exch_to = $item['to_currency_symbol'];
	$inactive_to = $item['to_currency_inactive_yn'];

	$exchange = array();
	$exchange['exch_id'] = $exch_id;
	$exchange['exch_rate'] = $exch_rate;
	$exchange['exch_from'] = t_encodeHTMLField($exch_from);
	$exchange['inactiveFrom'] = "";
	if($inactive_from != "0") {
		$exchange['inactiveFrom'] = "txtg txti";
	}
	$exchange['exch_to'] = t_encodeHTMLField($exch_to);
	$exchange['inactiveTo'] = "";
	if ($inactive_to != "0") {
		$exchange['inactiveTo'] = "txtg txti";
	}          

	$exchange['exch_date'] = $exch_date;

	if($record == $exch_id && $action == "3") {
		$counti--;
		$exchange['exch_date'] = $exch_date;
	}
	$exchange['date'] = $date;
	$finalSelectJob = $selectjob;
	if(!canEditDB($item['rf_db_code'])) {
		$finalSelectJob = 617;
	}
	$exchange['selectjob'] = $finalSelectJob;

	$exchange['exch_env'] = $item['rf_db_description'] . " (" . $item['rf_db_code'] . ")";
	$rows .= showpage($exchange, $rowHTML);
}

$GLOBALS['temp']['rowCount'] = (string) $counti;
if(empty($rows)) {
	$GLOBALS['temp']['rows'] = "
		<tr class='txt' height='18'>
			<td height='18' class='txt' align=center>&nbsp;&nbsp;There are no existing rates.</td>
		</tr>
	";
} else {
	$GLOBALS['temp']['rows'] = $rows;
}

