<?php

 /**
  * init.form2010.php - Specials
  * Job: 2011
  * Function: 68 (Rates)
  */


if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],14,"");

$saveClose = false;

$next_step = isset($_POST['next_step']) ? $_POST['next_step'] : "";

switch($next_step){
case 0:
	$saveClose = true;
	break;	
case 3:
	$job = "2013"; 
	break;	
case 2:
	$job = "2012"; 
	break;
case 1:
default:
	$job = "2011"; 
	break;	
}


if ( !isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/specials_tab1.htm");
}

if ($_SERVER['argc'] > 2){	// We are saving

	$sp_special_desc = urldecode($_SERVER['argv'][2]);
	$date = explode(":", $_SERVER['argv'][3]);
	$sp_special_date_from = $date[0];
	$sp_special_date_to = $date[1];
	$sp_special_lead_time_ind = $_SERVER['argv'][4];
	$sp_special_lead_time_amt = $_SERVER['argv'][5];
	$sp_special_comm_perc = $_SERVER['argv'][8];
	$sp_special_commissionable_yn = $_SERVER['argv'][9];
	$sp_special_min_properties = $_SERVER['argv'][11];
	$sp_special_note = urldecode($_SERVER['argv'][13]);

	if ($_SERVER['argv'][1] == ""){ // New record

		$specialId = db_sp_special_insert($sp_special_desc, $sp_special_date_from, $sp_special_date_to, $sp_special_lead_time_ind, $sp_special_lead_time_amt, $sp_special_comm_perc, $sp_special_commissionable_yn, $sp_special_min_properties, $sp_special_note);

	} else {	// Update record

		$specialId = $_SERVER['argv'][1];
		db_sp_special_update($specialId, $sp_special_desc, $sp_special_date_from, $sp_special_date_to, $sp_special_lead_time_ind, $sp_special_lead_time_amt, $sp_special_comm_perc, $sp_special_commissionable_yn, $sp_special_min_properties, $sp_special_note);
	}

	// Rate Periods
	db_sp_special_period_delete_by_special($specialId);
	if ($_SERVER['argv'][6] == ""){
		// Get all periods
		$ratePeriods = $GLOBALS['lDB']->get("
			SELECT
				rt_period_ix
			FROM
				rt_period
		",3);
	} else {
		$ratePeriods = explode(":", $_SERVER['argv'][6]);
	}
	foreach($ratePeriods as $ratePeriod){
		db_sp_special_period_insert($ratePeriod, $specialId);
	}

	// Rate Types
	db_sp_special_rate_type_delete_by_special($specialId);
	if ($_SERVER['argv'][7] == ""){
		// Get all rate types
		$rateTypes = $GLOBALS['lDB']->get("
			SELECT
				rt_rate_type_ix
			FROM
				rt_rate_type
		",3);
	} else {
		$rateTypes = explode(":", $_SERVER['argv'][7]);
	}
	foreach($rateTypes as $rateType){
		db_sp_special_rate_type_insert($rateType, $specialId);
	}	

	// Accomm Types
	db_sp_accomm_type_delete_by_special($specialId);
	if ($_SERVER['argv'][10] == ""){
		// Get all accomm types
		$accommTypes = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_type_ix
			FROM
				ac_accomm_type
		",3);
	} else {
		$accommTypes = explode(":", $_SERVER['argv'][10]);
	}

	foreach($accommTypes as $accommType){
		db_sp_accomm_type_insert($accommType, $specialId);
	}		

	// Rate Groups
	$rateGroups = json_decode(stripslashes($_SERVER['argv'][12]));
	db_sp_rate_group_qualify_delete_by_special($specialId);
	foreach($rateGroups as $rateGroup){
		if ($rateGroup->count > 0 || $rateGroup->nights > 0 || $rateGroup->bed_nights > 0){
			db_sp_rate_group_qualify_insert($rateGroup->rate_group_id, $specialId, $rateGroup->count, $rateGroup->nights, $rateGroup->bed_nights);	
		}
		
	}

	if (!$saveClose){
		// Redirect at the end regardless (solves F5 issue)
		redirectTo(" ./reservation.php?$job+".$specialId);
	} else {
		redirectTo(" ./reservation.php?2010");
	}

}


// If we have a record, get the details from the database, even if they have just been saved
if ($_SERVER['argv'][1] != ""){

	$sp_special = $GLOBALS['lDB']->get("

		SELECT
			sp_special.sp_special_desc,
			sp_special.sp_special_note,
			sp_special.sp_special_date_from,
			sp_special.sp_special_date_to,
			sp_special.sp_special_lead_time_ind,
			sp_special.sp_special_lead_time_amt,
			sp_special.sp_special_comm_perc,
			sp_special.sp_special_commissionable_yn,
			sp_special.sp_special_min_properties
		FROM
			sp_special
		WHERE
			sp_special.sp_special_ix = '".$_SERVER['argv'][1]."'
	",1);

	$_SERVER['argv'][2] = str_replace('"', '&quot;', $sp_special['sp_special_desc']);
	$_SERVER['argv'][3] = $sp_special['sp_special_date_from'].":".$sp_special['sp_special_date_to'];
	$_SERVER['argv'][4] = $sp_special['sp_special_lead_time_ind'];
	$_SERVER['argv'][5] = $sp_special['sp_special_lead_time_amt'];
	$_SERVER['argv'][8] = $sp_special['sp_special_comm_perc'];
	$_SERVER['argv'][9] = $sp_special['sp_special_commissionable_yn'];
	$_SERVER['argv'][11] = $sp_special['sp_special_min_properties'];
	$_SERVER['argv'][13] = $sp_special['sp_special_note'];


	$sp_special_period = $GLOBALS['lDB']->get("
		SELECT
			sp_special_period.rt_period_id
		FROM
			sp_special_period
		WHERE
			sp_special_period.sp_special_id = '".$_SERVER['argv'][1]."'
	",3);

	// Unfortunately since we're hacking report filters to work as these "selectors", we have to compare
	// the results against ALL in the database to prevent the filter showing every single items rather than the word "All"
	// Same for rate types and accomm types
	$allRatePeriods = $GLOBALS['lDB']->get("
		SELECT
			rt_period_ix
		FROM
			rt_period
	",3);

	if (count($sp_special_period) == count($allRatePeriods)){
		$_SERVER['argv'][6] = "";
	} else {
		$_SERVER['argv'][6] = join($sp_special_period, ":");	
	}

	$sp_special_rate_type = $GLOBALS['lDB']->get("
		SELECT
			sp_special_rate_type.rt_rate_type_id
		FROM
			sp_special_rate_type
		WHERE
			sp_special_rate_type.sp_special_id = '".$_SERVER['argv'][1]."'
	",3);

	$allRateTypes = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_type_ix
		FROM
			rt_rate_type
	",3);

	if (count($sp_special_rate_type) == count($allRateTypes)){
		$_SERVER['argv'][7] = "";
	} else {
		$_SERVER['argv'][7] = join($sp_special_rate_type, ":");
	}

	$sp_accomm_type = $GLOBALS['lDB']->get("
		SELECT
			sp_accomm_type.ac_accomm_type_id
		FROM
			sp_accomm_type
		WHERE
			sp_accomm_type.sp_special_id = '".$_SERVER['argv'][1]."'
	",3);
	
	$allAccommTypes = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type_ix
		FROM
			ac_accomm_type
	",3);

	if (count($sp_accomm_type) == count($allAccommTypes)){
		$_SERVER['argv'][10] = "";
	} else {
		$_SERVER['argv'][10] = join($sp_accomm_type, ":");
	}

}

$scripts = array();

$GLOBALS['temp']['sp_special_desc'] = $_SERVER['argv'][2];
$GLOBALS['temp']['sp_special_note'] = $_SERVER['argv'][13];
if ($_SERVER['argv'][4] == 1){
	$GLOBALS['temp']['leadTimeMoreSelected'] = "selected";
} else {
	$GLOBALS['temp']['leadTimeLessSelected'] = "selected";
}

$GLOBALS['temp']['dateAnyChecked'] = "checked";
$GLOBALS['temp']['dateLeadTimeChecked'] = "";
$GLOBALS['temp']['dateRangeChecked'] = "";
$GLOBALS['temp']['sp_special_lead_time_amt'] = $_SERVER['argv'][5];

if (($_SERVER['argv'][3] == "0000-00-00:0000-00-00" && $_SERVER['argv'][5] == 0) || $_SERVER['argv'][3] == "" && $_SERVER['argv'][5] == ""){
	$GLOBALS['temp']['dateAnyChecked'] = "checked";
	$GLOBALS['temp']['dateLeadTimeChecked'] = "";
	$GLOBALS['temp']['dateRangeChecked'] = "";
	$today = date("Y-m-d");
	$_SERVER['argv'][3] = $today.":".$today;
} elseif ($_SERVER['argv'][3] == "0000-00-00:0000-00-00"){
	$GLOBALS['temp']['dateAnyChecked'] = "";
	$GLOBALS['temp']['dateLeadTimeChecked'] = "checked";
	$GLOBALS['temp']['dateRangeChecked'] = "";
	$today = date("Y-m-d");
	$_SERVER['argv'][3] = $today.":".$today;
} else {
	$GLOBALS['temp']['dateAnyChecked'] = "";
	$GLOBALS['temp']['dateLeadTimeChecked'] = "";
	$GLOBALS['temp']['dateRangeChecked'] = "checked";
}


$dateRangeFilter = new ReportParamFilterDateRange("dateRange",false,false);
$dateRangeFilter->Arg = 3;
$dateRangeFilter->init();
$GLOBALS['temp']['dateRangeFilter'] = $dateRangeFilter->Render();
$scripts = array_merge($scripts,$dateRangeFilter->RenderScripts());


$GLOBALS['temp']['sp_special_comm_perc'] = $_SERVER['argv'][8];

if ($_SERVER['argv'][9] == "1"){
	$GLOBALS['temp']['specialCommissionableOptNoChecked'] = "";	
	$GLOBALS['temp']['specialCommissionableOptYesChecked'] = "checked";	
} else {
	$GLOBALS['temp']['specialCommissionableOptNoChecked'] = "checked";	
	$GLOBALS['temp']['specialCommissionableOptYesChecked'] = "";	
}

$GLOBALS['temp']['sp_special_min_properties'] = $_SERVER['argv'][11];



$ratePeriodFilter = new ReportParamFilter("ratePeriod");
$ratePeriodFilter->Arg = 6;
$ratePeriodFilter->init();
$GLOBALS['temp']['ratePeriodFilter'] = $ratePeriodFilter->Render();
$scripts = array_merge($scripts,$ratePeriodFilter->RenderScripts());

$rateTypeFilter = new ReportParamFilter("rate");
$rateTypeFilter->Arg = 7;
$rateTypeFilter->init();
$GLOBALS['temp']['rateTypeFilter'] = $rateTypeFilter->Render();
$scripts = array_merge($scripts,$rateTypeFilter->RenderScripts());

$propAccommFilter = new ReportParamFilter("accomm");
$propAccommFilter->Arg = 10;
$propAccommFilter->init();
$GLOBALS['temp']['propAccommFilter'] = $propAccommFilter->Render();
$scripts = array_merge($scripts,$propAccommFilter->RenderScripts());

$jobLevel = checkJob(2010,2);
$read_only = ($jobLevel < 10) ? true : false;
$yui_dt_rate_groups = createSpecialRateGroupTable(false, $read_only);

$GLOBALS['temp']['rate_group_display_html'] = $yui_dt_rate_groups['displayHTML'];
$GLOBALS['temp']['rate_group_display_js'] = $yui_dt_rate_groups["displayJS"];
$GLOBALS['temp']['rate_group_build_url_js'] = $yui_dt_rate_groups["buildURLJS"];


// Filter Javascript inclusion
$scripts = array_unique($scripts);
$scriptHTML = "";
foreach($scripts as $script) {
	$scriptHTML .= "<script type=\"text/javascript\" src=\"include/js/$script\"></script>\n";
}
$GLOBALS['temp']['filters'] = $scriptHTML;



$GLOBALS['temp']['specialID'] = $_SERVER['argv'][1];

// Get list of existing Special names to avoid duplicate names
$specials_names = $GLOBALS['lDB']->get("
	SELECT
		sp_special.sp_special_desc,
		sp_special.sp_special_ix
	FROM
		sp_special
",2);

$specials_js_array_names = array();
foreach ($specials_names as $name) {
	$specials_js_array_names[] = '"' . str_replace('"', '&quot;', $name['sp_special_desc']) . '":"' . $name['sp_special_ix'] . '"';
}

$GLOBALS['temp']['specials_names'] = '{'. implode(',', $specials_js_array_names) .'}';
$GLOBALS['temp']['special_id'] = (isset($_SERVER['argv'][1])) ? $_SERVER['argv'][1] : "";
$jobLevel = checkJob(2010,2);
$GLOBALS['temp']['readOnly'] = ($jobLevel < 10) ? "1" : "0";