<?php

 /**
  * init.form2011.php - Specials
  * Job: 2012
  * Function: 68 (Rates)
  */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$saveClose = false;

$next_step = isset($_POST['next_step']) ? $_POST['next_step'] : "";

switch($next_step){
case 0:
	$saveClose = true;
	break;	
case 1:
	$job = "2011"; 
	break;
case 2:
	$job = "2012"; 
	break;	
case 3:
default:
	$job = "2013"; 
	break;	
}

if ( !isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/specials_tab2.htm");
}

if ($_SERVER['argc'] > 2){	// We are saving

	$specialID = $_SERVER['argv'][1];

	// Rate Groups
	$properties = json_decode(stripslashes($_SERVER['argv'][2]));
	$property_optionals = explode(":",$_SERVER['argv'][3]);

	db_sp_prop_rate_group_delete_by_special($specialID);
	foreach ($properties as $pr_business_id => $rateGroups){
		foreach($rateGroups as $rateGroup){
			if ($rateGroup->count > 0 || $rateGroup->nights > 0 || $rateGroup->bed_nights > 0){
				db_sp_prop_rate_group_insert($rateGroup->rate_group_id, $pr_business_id, $specialID, $rateGroup->count, $rateGroup->nights, $rateGroup->bed_nights);	
			}
		}
	}

	// Optionals
	foreach($property_optionals as $property_optional){
		$pair = explode(",",$property_optional);
		$accomms = $GLOBALS['lDB']->get("
			SELECT
				sp_accomm_type.sp_accomm_type_ix
			FROM
				sp_accomm_type
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sp_accomm_type.ac_accomm_type_id
			WHERE
				ac_accomm_type.pr_business_id = '".$pair[0]."'
				AND sp_accomm_type.sp_special_id = '".$specialID."'
		",3);
		foreach ($accomms as $accomm){
			db_sp_accomm_type_update($accomm, $pair[1]);
		}
		
	}

	if (!$saveClose){
		// Redirect at the end regardless (solves F5 issue)
		redirectTo(" ./reservation.php?$job+".$specialID);
	} else {
		redirectTo(" ./reservation.php?2010");
	}

}

// --- DISPLAY

$GLOBALS['temp']['sp_special_desc'] = $GLOBALS['lDB']->get("
	SELECT 
		sp_special.sp_special_desc
	FROM
		sp_special
	WHERE
		sp_special.sp_special_ix = '".$_SERVER['argv'][1]."'
",4);

$sp_accomm_type = $GLOBALS['lDB']->get("
	SELECT 
		ac_accomm_type.ac_accomm_type_ix,
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_type.pr_business_id,
		pr_persona.pr_name_last,
		sp_accomm_type.sp_accomm_type_opt_yn
	FROM
		ac_accomm_type
		INNER JOIN sp_accomm_type ON sp_accomm_type.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
	WHERE
		sp_accomm_type.sp_special_id = '".$_SERVER['argv'][1]."'
	ORDER BY
		pr_business.pr_business_sequence
",2);

$properties = array();
foreach ($sp_accomm_type as $accomm_type){
	$properties[$accomm_type['pr_business_id']]['name'] = $accomm_type['pr_name_last'];
	$properties[$accomm_type['pr_business_id']]['accomm_types'][$accomm_type['ac_accomm_type_ix']] = $accomm_type['ac_accomm_desc'];
	$properties[$accomm_type['pr_business_id']]['optional'] = $accomm_type['sp_accomm_type_opt_yn'];
}

$propertySectionHTML = "";
$GLOBALS['temp']['rate_group_display_js'] = "";
$GLOBALS['temp']['rate_group_build_url_js'] = "";
$yui_dt_rate_groups = array();
$jobLevel = checkJob(2010,2);
$read_only = ($jobLevel < 10) ? true : false;

foreach ($properties as $pr_business_id => $property){
	
	$yui_dt_rate_groups = createSpecialRateGroupTable($pr_business_id, $read_only);

	if ($property['optional'] == "1"){
		$optional_no_checked = "";
		$optional_yes_checked = "checked ";
	} else {
		$optional_no_checked = "checked ";
		$optional_yes_checked = "";
	}
	$propertySectionHTML .= "
				<table border=\"0\" cellpadding=\"1\" cellspacing=\"0\" summary=\"\">
					<tbody>
						<tr>
							<td style=\"width: 150px; line-height: 20px;\">Property</td>
							<td colspan=\"2\">".$property['name']."</td>
						</tr>					
						<tr>
							<td style=\"width: 150px; line-height: 20px;\">Accommodation Types</td>
							<td colspan=\"2\">".join($property['accomm_types'],", ")."</td>
						</tr>
						<tr>
							<td style=\"width: 150px; line-height: 20px;\">Optional</td>
							<td colspan=\"2\">
								<input id=\"".$pr_business_id."_optionalOptNo\" name=\"".$pr_business_id."_optionalOpt\" value=\"0\" $optional_no_checked type=\"radio\"> No
								<input id=\"".$pr_business_id."_optionalOptYes\" name=\"".$pr_business_id."_optionalOpt\" value=\"1\" $optional_yes_checked type=\"radio\"> Yes
							</td>
						</tr>
						<tr>
							<td style=\"width: 150px; line-height: 20px; vertical-align: top;\">Min Quantities</td>
							<td colspan=\"2\">

								".$yui_dt_rate_groups["displayHTML"]."

							</td>
						</tr>
						<tr>
							<td colspan=\"3\">&nbsp;</td>
						</tr>
					</tbody>
				</table>
				<br />
	";


	$GLOBALS['temp']['rate_group_build_url_js'] .= $yui_dt_rate_groups["buildURLJS"];
	$GLOBALS['temp']['rate_group_display_js'] .= $yui_dt_rate_groups["displayJS"];
	

}


$GLOBALS['temp']['propertySectionHTML'] = $propertySectionHTML;
$GLOBALS['temp']['specialID'] = $_SERVER['argv'][1];
$GLOBALS['temp']['readOnly'] = ($jobLevel < 10) ? "1" : "0";