<?php

 /**
  * init.form2012.php - Specials
  * Job: 2013
  * Function: 68 (Rates)
  */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$saveClose = false;

$next_step = isset($_POST['next_step']) ? $_POST['next_step'] : "";

switch($next_step){
case 0:
	$saveClose = true;
	break;	
case 1:
	$job = "2011"; 
	break;
case 2:
	$job = "2012"; 
	break;	
case 3:
	$job = "2013"; 
	break;		
case 4:
default:
	$job = "2010"; 
	break;	
}

if ( !isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/specials_tab3.htm");
}

$specialID = $_SERVER['argv'][1];

if ($_SERVER['argc'] > 2){	// We are saving

	$donorPropertyID = $_SERVER['argv'][2];

	$benefitData = json_decode(stripslashes($_SERVER['argv'][3]));

	db_sp_rate_group_benefit_delete_by_special($specialID);

	foreach ($benefitData as $rateGroup){

		$rate_type_id_arr = explode("|", $rateGroup->free_nights_rate_type);
		if(count($rate_type_id_arr) > 1){
			$rate_type_id = $rate_type_id_arr[0];
		} else {
			$rate_type_id = false;
		}

		db_sp_rate_group_benefit_insert($rateGroup->rate_group_id, $specialID, $donorPropertyID, $rateGroup->recipients, $rateGroup->disc_nights, $rateGroup->disc_perc, $rateGroup->disc_amount, $rateGroup->free_nights_quantity, $rate_type_id);
	}

	if (!$saveClose){
		// Redirect at the end regardless (solves F5 issue)
		if ($job != "2010"){
			redirectTo(" ./reservation.php?$job+".$specialID);
		} else {
			redirectTo(" ./reservation.php?2010");	
		}	
	} else {
		redirectTo(" ./reservation.php?2010");
	}
}

$GLOBALS['temp']['sp_special_desc'] = $GLOBALS['lDB']->get("
	SELECT 
		sp_special.sp_special_desc
	FROM
		sp_special
	WHERE
		sp_special.sp_special_ix = '".$_SERVER['argv'][1]."'
",4);

// [START] All rate groups dropdown
$allRateGroups = $lDB->get("
	SELECT 
		rt_rate_group.rt_rate_group_ix,
		rt_rate_group.rt_rate_group_desc
	FROM
		rt_rate_group
	WHERE
		rt_rate_group.rt_rate_group_inactive_yn = 0
	ORDER BY
		rt_rate_group.rt_rate_group_class,
		rt_rate_group.rt_rate_group_desc
",2);

$rateGroupOptions = "";
foreach ($allRateGroups as $rateGroup){
	$rateGroupOptions .= "
		<option value=\"".$rateGroup['rt_rate_group_ix']."\">".$rateGroup['rt_rate_group_desc']."</option>
	";	
}
// [END] All rate groups dropdown

// [START] Rate types dropdown for table rows
$rateTypes = $lDB->get("
	SELECT 
		rt_rate_type.rt_rate_type_ix,
		rt_rate_type.rt_rate_type_desc
	FROM
		rt_rate_type
	WHERE
		rt_rate_type.rt_rate_type_inactive_yn = 0
	ORDER BY
		rt_rate_type.rt_rate_type_desc
",2);

$rateTypesOptions = array();
foreach ($rateTypes as $rateType){
	$rateTypeOptions[] = "{label:\"".$rateType['rt_rate_type_desc']."\", value:\"".$rateType['rt_rate_type_ix']."|".$rateType['rt_rate_type_desc']."\"}";
}

// [END] Rate types dropdown for table rows

$benefitData = $lDB->get("

	SELECT
		sp_rate_group_benefit.rt_rate_group_id AS rate_group_id,
		rt_rate_group.rt_rate_group_desc AS rate_group_desc,
		sp_rate_group_benefit.sp_discount_donor_property_id,
		sp_rate_group_benefit.sp_rate_group_recipients AS recipients,
		sp_rate_group_benefit.sp_discount_nights AS disc_nights,
		sp_rate_group_benefit.sp_discount_perc AS disc_perc,
		sp_rate_group_benefit.sp_discount_amount AS disc_amount,
		sp_rate_group_benefit.sp_free_nights_qty AS free_nights_quantity,
		CONCAT(rt_rate_type.rt_rate_type_ix, '|', rt_rate_type.rt_rate_type_desc) AS free_nights_rate_type
	FROM
		sp_rate_group_benefit
		LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = sp_rate_group_benefit.sp_free_nights_rate_type
		INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = sp_rate_group_benefit.rt_rate_group_id
	WHERE
		sp_rate_group_benefit.sp_special_id = '".$specialID."'

",2);

$properties = $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id,
		pr_persona.pr_name_last
	FROM
		ac_accomm_type
		INNER JOIN sp_accomm_type ON sp_accomm_type.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		sp_accomm_type.sp_special_id = '".$_SERVER['argv'][1]."'
",2);

if (isset($benefitData[0]['sp_discount_donor_property_id'])){
		$donorPropertyID = $benefitData[0]['sp_discount_donor_property_id'];
	} else {
		$donorPropertyID = "";
	}

$donorPropertyOptions = "
	<option value=\"\">Not specified</option>
	<option value=\"0\" " . ($donorPropertyID == '0' ? " selected":"") . ">Last property</option>
";	

foreach ($properties as $property){
	if ($property['pr_business_id'] == $donorPropertyID){
		$selected = " selected";
	} else {
		$selected = " ";
	}

	$donorPropertyOptions .= "
		<option value=\"".$property['pr_business_id']."\" $selected>".$property['pr_name_last']."</option>
	";	
}

$benefitJSON = array();
foreach ($benefitData as $benefit){

	// Weird, but needed to cater for NULL returned for rate type (YUI table doesn't like NULL)
	if($benefit['free_nights_rate_type'] == ""){
		$benefit['free_nights_rate_type'] = "";
	}
	$benefitJSON[] = json_encode($benefit);
}

$unitRateGroup =  $GLOBALS['lDB']->get("
	SELECT
		rt_rate_group_ix 
	FROM
		rt_rate_group
	WHERE
		rt_rate_group.rt_rate_group_sys_code = 1
",4);

$paxRateGroup =  $GLOBALS['lDB']->get("
	SELECT
		rt_rate_group_ix 
	FROM
		rt_rate_group
	WHERE
		rt_rate_group.rt_rate_group_sys_code = 99
",4);

$GLOBALS['temp']['benefit_data'] = join(", ",$benefitJSON);
$GLOBALS['temp']['rateTypeOptions'] = join(", ",$rateTypeOptions);
$GLOBALS['temp']['rateGroupOptions'] = $rateGroupOptions;
$GLOBALS['temp']['donorPropertyOptions'] = $donorPropertyOptions;
$GLOBALS['temp']['specialID'] = $_SERVER['argv'][1];
$GLOBALS['temp']['pax_rate_group'] = $paxRateGroup;
$GLOBALS['temp']['unit_rate_group'] = $unitRateGroup;
$jobLevel = checkJob(2010,2);
$GLOBALS['temp']['readOnly'] = ($jobLevel < 10) ? "1" : "0";