<?php

/**
 * init.form2013.php - Select special popup (Job 2014)
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/select_special_popup.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");
$rv_reservation_id = ($_SERVER['argv'][1] != "") ? $_SERVER['argv'][1] : $GLOBALS['wizResId'];
$parent_page = $_SERVER['argv'][2];

$specialManager = new SpecialManager($rv_reservation_id);

$qualifyingSpecials = $specialManager->GetQualifyingSpecials();
$currentSpecials = db_rv_special_get_specials_by_reservation($rv_reservation_id);

$allowOverride = db_sc_group_get_user_setting("sc_grp_res_ovr_specials_yn");

$listRowHTML = "";

$allSpecials = $lDB->get("
	SELECT 
		sp_special.sp_special_ix,
		sp_special.sp_special_desc
	FROM 
		sp_special
	WHERE
		sp_special.sp_special_inactive_yn != 1
	ORDER BY sp_special_priority
",6);

$hasNonQualifying = false;
foreach ($allSpecials as $special) {
	$specialNames[$special['sp_special_ix']] = $special['sp_special_desc'];
	if (!empty($qualifyingSpecials) && in_array($special['sp_special_ix'],$qualifyingSpecials)) {
		$class = "qrow";
	} else {
		$class = "nqrow";
	}

	$checked = "";
	if(in_array($special['sp_special_ix'], $currentSpecials)) {
		$checked = "checked";
	}

	if($class == "nqrow" && $checked == "checked") {
		$hasNonQualifying = true;
	}

	$listRowHTML .= "
		<tr onmouseover=\"this.style.backgroundColor = '#cfc';\" onmouseout=\"this.style.backgroundColor = '#fff';\" class=\"imgLink $class\">
			<td><input class=\"special_check uk-checkbox\" id=\"special_$special[sp_special_ix]_check\" type=\"checkbox\" $checked></td>
			<td style=\"text-align:left;\" >
				<label for=\"special_$special[sp_special_ix]_check\">
					".$special['sp_special_desc']."
				</label>
			</td> 
		</tr>
	";
}

$hasRateAmountOverride = (getSpecialHaveRateAmountOverrides($rv_reservation_id) == true) ? true : false;

if($allowOverride && !$hasRateAmountOverride) {
	$GLOBALS['temp']['showAllVisibility'] = "";
} else {
	$GLOBALS['temp']['showAllVisibility'] = "display: none;";
}

$saveButton = "";
if($allowOverride || !$hasNonQualifying) {
	$saveButton = "
		<button class=\"button btn-primary\" type=\"button\" onclick=\"recordSpecials('$parent_page','$rv_reservation_id',1);\">
			Save
		</button>
	";
}


$GLOBALS['temp']['saveButton'] = $saveButton;

$GLOBALS['temp']['specialRows'] = $listRowHTML;
$GLOBALS['temp']['overrideWarningVisibility'] = $hasRateAmountOverride ? "" : "display: none;";
$GLOBALS['temp']['varianceWarningVisibility'] = getSpecialHaveVariances($rv_reservation_id) ? "" : "display: none;";
$GLOBALS['temp']['specialOverrideWarningVisibility'] = $hasNonQualifying && !$allowOverride ? "" : "display: none;";
$GLOBALS['temp']['page'] = $parent_page;
$GLOBALS['temp']['rv_reservation_id'] = $rv_reservation_id;
$GLOBALS['temp']['showAllSpecialsChecked'] = $hasNonQualifying && $allowOverride ? "checked" : "";
