<?php

 /**
  * init.form2014.php - Save Special
  * Job: 2015
  * Function: 2001 (Specials)
  */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if ( !isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"","");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$redirect = $_SERVER['argv'][1];
$rv_reservation_id = $_SERVER['argv'][2];
$specials = explode("_",$_SERVER['argv'][3]);

$newSpecials = [];
foreach($specials as $sp_special_id) {
	if(db_sp_special_exists($sp_special_id)) {
		$newSpecials[] = $sp_special_id;
	}
}
$specials = $newSpecials;
unset($newSpecials);


// Check if special is an override
$specialManager = new SpecialManager($rv_reservation_id);
$qualifying = $specialManager->GetQualifying();
$qualifyingSuggested = [];
if(sizeof($qualifying) > 0) {
	$qualifyingSuggested = $qualifying[0]['specials'];
}
if(
	!empty($specials)
	&& !empty($qualifyingSuggested)
	&& array_diff($qualifyingSuggested, $specials) != array_diff($specials, $qualifyingSuggested)
) {
	$rv_sp_overide_yn = 1;
} else {
	$rv_sp_overide_yn = 0;
}

$currentSpecials = db_rv_special_get_specials_by_reservation($rv_reservation_id);
$newCurrentSpecials = [];
foreach($currentSpecials as $sp_special_id) {
	if(db_sp_special_exists($sp_special_id)) {
		$newCurrentSpecials[$sp_special_id] = db_sp_special_get_desc($sp_special_id);
	}
}
$currentSpecials = $newCurrentSpecials;
unset($newCurrentSpecials);


db_rv_special_delete_by_reservation($rv_reservation_id);
db_rv_reservation_set_special_override($rv_reservation_id, false);
if(empty($specials)) { // Specials removed and marked as override to auto-apply is prevented later
	db_rv_reservation_set_special_override($rv_reservation_id);
	clearExistingSpecial($rv_reservation_id);

	$specialsAuditTrail = new AuditTrail($rv_reservation_id,TYPE_RESERVATION);
	foreach($currentSpecials as $current_special_id=>$current_special_desc) {
		$specialsAuditTrail->addDetail(
			$current_special_desc,
			"None",
			$current_special_id,
			Null,
			DB_AD_RES_DETAIL_ACTION_EDIT,
			"resitinerary",
			"rv_special.rv_special_ix"
		);
	}
	$specialsAuditTrail->save("Special (Remove, Manual)");
} else { // Specials added
	foreach($specials as $sp_special_id) {
		db_rv_special_insert($rv_reservation_id, $sp_special_id);
	}
	applySpecialToRes($rv_reservation_id, false, $currentSpecials);
	if($rv_sp_overide_yn == 1) {
		db_rv_reservation_set_special_override($rv_reservation_id);
	}
}


if ($redirect == "2") { $redirect .= "+".$rv_reservation_id; }
redirectTo(" ./reservation.php?".$redirect);
