<?php

/**
 * init.form21.php - Contact agent popup
 * Job: 57, 58, 59, 60, 61, 62
 * Function: 83 (Contact Agent Role)
*/

$GLOBALS['bypassAddCheck'] = true;

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/contact_agent_pop.htm");
	$fields = array(
		"pr_agent_id",
		"rt_rate_type_id",
		"pr_agent_comm_deduct_yn",
		"pr_agent_commission_perc",
		"pr_agent_note_open",
		"pr_agent_note_conf",
		"pr_agent_inactive_yn",
		"pr_agent_account",
		"ac_pay_plan_id",
		"ac_pay_final_base",
		"ac_pay_final_days",
		"pr_agent_show_allocs_ind",
		"pr_agent_alloc_ext_yn",
		"pr_agent_alloc_auto_yn"
	);
	$ident = array("pr_agent_id");
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"pr_agent",$fields,"pr_agent_id = '$record'","","",$ident);
}

$record = $_SERVER['argv'][1] ?? "";
$rsAction = $_SERVER['argv'][2] ?? "";
$rsParams = $_SERVER['argv'][3] ?? "";

$GLOBALS['temp']['hideNote'] = "printCollapse";
if($userStatusId < 2) {
	$GLOBALS['temp']['hideNote'] = "collapse printCollapse";
}

$GLOBALS['temp']['rRows'] = "<tr><td height='15' colspan='2' class='txti' align='center'>No rate types.</td></tr>";
$GLOBALS['temp']['pRows'] = "<tr><td height='15' colspan='4' class='txti' align='center'>No property specific overrides.</td></tr>";
if($action != "2") {
	switch($rsAction) {
	case "rate_add":
		db_pr_agent_rate_insert($record, $rsParams);
		break;
	case "rate_delete":
		db_pr_agent_rate_delete_by_all($record, $rsParams);
		break;
	case "rate_default":
		db_pr_agent_rate_set_default_by_all($record, $rsParams);
		break;
	case "property_add_check":
		list($pr_business_id, $rt_rate_type_id, $pr_agent_prop_comm_perc) = explode("|",$rsParams);
		if(!db_rt_rate_type_exists($rt_rate_type_id)) {
			if(db_pr_agent_prop_exists_by_all($record, $pr_business_id)) {
				ajaxResponse("Only one entry with no rate type allowed per property");
			}
		} else {
			$rf_currency_id = db_rt_rate_type_get_currency($rt_rate_type_id);
			if(db_pr_agent_prop_exists_by_currency($record, $pr_business_id, $rf_currency_id)) {
				ajaxResponse("Only one entry per currency allowed for each property");
			}
		}
		ajaxResponse();
		break;
	case "property_add":
		list($pr_business_id, $rt_rate_type_id, $pr_agent_prop_comm_perc) = explode("|",$rsParams);
		db_pr_agent_prop_insert($record, $pr_business_id, $rt_rate_type_id, $pr_agent_prop_comm_perc);
		break;
	case "property_delete":
		db_pr_agent_prop_delete($rsParams);
		break;
	}

	$GLOBALS['temp']['rateStyle'] = "";
	if($action != "3") {
		$GLOBALS['temp']['rateStyle'] = " style=\"visibility: hidden;\"";
	}

	// Generate listing of all pr_agent rate types
	$agentRates = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_type.rt_rate_type_ix as rt_rate_type_id,
			IF(rt_rate_type_inactive_yn <> 0, concat('* ',rt_rate_type.rt_rate_type_desc),rt_rate_type.rt_rate_type_desc) AS rt_rate_type_desc,
			rf_currency.rf_currency_symbol,
			pr_agent_rate.pr_agent_rate_ix,
			pr_agent_rate.pr_agent_rate_default_yn
		FROM
			pr_agent_rate			
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			pr_agent_rate.pr_agent_id = '$record'
		ORDER BY
			rt_rate_type.rt_rate_type_desc
	",6);

	$agentRateIds = array();
	$rateTypeHTML = join("\n",file(__DIR__ . "/../../../public/html/agent_rate_rows.htm"));
		
	$rateTypeRows = "";
	foreach($agentRates as $agentRate) {
		$agentRate['default_checked'] = "";
		if($agentRate['pr_agent_rate_default_yn'] == "1") {
			$agentRate['default_checked'] = "checked";
		}
		$agentRateIds[] = $agentRate['rt_rate_type_id'];
		$agentRate['style'] = $GLOBALS['temp']['rateStyle'];
		$agentRate['disabled'] = "disabled";
		if($action > 1) {
			$agentRate['disabled'] = "";
		}

		$rateTypeRows .= showpage($agentRate,$rateTypeHTML);
	}
	if($rateTypeRows != "") {
		$GLOBALS['temp']['rRows'] = $rateTypeRows;
	}

	// Generate dropdown of all valid rate types
	$GLOBALS[$form]->AddField($form."_pr_agent_sysRateTypeId","sysRateTypeId","",3);
	$sql="
		SELECT
			rt_rate_type.rt_rate_type_ix,
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_symbol
		FROM
			rt_rate_type
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			rt_rate_type.rt_rate_type_ix NOT IN ('".join("','",$agentRateIds)."')
			AND	rt_rate_type_inactive_yn = '0'
		ORDER BY
			rt_rate_type.rt_rate_type_desc
	";

	$GLOBALS[$form.'_pr_agent_sysRateTypeId']->Select(combolist($GLOBALS['lDB'],$sql));
	$GLOBALS[$form.'_pr_agent_sysRateTypeId']->TabIndex = "13";
	$GLOBALS[$form.'_pr_agent_sysRateTypeId']->Width = "300";
	$GLOBALS[$form.'_pr_agent_sysRateTypeId']->Size = 90;             

	$agentPropertyRates = $GLOBALS['lDB']->get("
		SELECT
			pr_agent_prop.pr_agent_prop_ix,
			pr_agent_prop.pr_business_id,
			pr_persona.pr_name_last,
			pr_agent_prop.rt_rate_type_id,
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_symbol,
			pr_agent_prop.pr_agent_prop_comm_perc
		FROM
			pr_agent_prop
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_agent_prop.pr_business_id
			LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_prop.rt_rate_type_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			pr_agent_prop.pr_agent_id = '" . $record . "'
	",6);

	$propertyRowHTML = join("\n",file(__DIR__ . "/../../../public/html/agent_prop_rows.htm"));
	$agentPropertyIds = [];
	$propertyRows = "";
	foreach($agentPropertyRates as $agentPropertyRate) {
		$agentPropertyIds[] = $agentPropertyRate['pr_business_id'];
		if(is_null($agentPropertyRate['pr_agent_prop_comm_perc'])) {
			$agentPropertyRate['pr_agent_prop_comm_perc'] = "";
		} else {
			$agentPropertyRate['pr_agent_prop_comm_perc'] .= "%";
		}
		$agentPropertyRate['style'] = $GLOBALS['temp']['rateStyle'];
		$propertyRows .= showpage($agentPropertyRate,$propertyRowHTML);
	}

	if($propertyRows != "") {
		$GLOBALS['temp']['pRows'] = $propertyRows;
	}


	$GLOBALS[$form]->AddField($form."_pr_agent_sysPropertyId","sysPropertyId","",3);
	$sql = "
		SELECT DISTINCT
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last
		FROM
			sc_accomm
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			sc_accomm.sc_group_id = '" . $GLOBALS['lDB']->escape($GLOBALS['sc_group_id']) . "'
			AND ac_accomm_type.ac_accomm_type_inactive_yn=0
			AND pr_business.pr_bus_inactive_yn= '0'
		ORDER BY
			pr_persona.pr_name_last
	";
	$GLOBALS[$form.'_pr_agent_sysPropertyId']->Select(combolist($GLOBALS['lDB'],$sql));
	$GLOBALS[$form.'_pr_agent_sysPropertyId']->TabIndex = "13";
	$GLOBALS[$form.'_pr_agent_sysPropertyId']->Width = "130";

	$GLOBALS[$form]->AddField($form."_pr_agent_sysPropertyRateTypeId","sysPropertyRateTypeId","",3);
	$propertyRateTypeOptions = combolist($GLOBALS['lDB'],"
		SELECT
			rt_rate_type.rt_rate_type_ix,
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_symbol
		FROM
			rt_rate_type
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			rt_rate_type_inactive_yn = '0'
		ORDER BY
			rt_rate_type.rt_rate_type_desc
	");
	array_unshift($propertyRateTypeOptions, ":|:");
	$GLOBALS[$form.'_pr_agent_sysPropertyRateTypeId']->Select($propertyRateTypeOptions);
	$GLOBALS[$form.'_pr_agent_sysPropertyRateTypeId']->TabIndex = "13";
	$GLOBALS[$form.'_pr_agent_sysPropertyRateTypeId']->Width = "130";

	// rsUpdate, refresh the default rate dropdown and the default rate listing
	if($rsAction != "") {
		// Declare host variables
		$rsUpdateInnerHTML = array();
		$rsUpdateValue = array();
		$rsUpdateVar = array();
		$rsFuncList = array();

		// Add values to arrays
		$rsUpdateInnerHTML['raterows'] = "
			<div style=\"height: 3px;\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></div>
			<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" summary=\"\" style=\"table-layout: fixed;\">
			<col width=\"20\" />
			<col />
			<col width=\"40\" />
			" . $GLOBALS['temp']['rRows'] . "
			<tr><td colspan=\"3\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>
			</table>
		";
		$rsUpdateInnerHTML['rateSpan'] = $GLOBALS[$form.'_pr_agent_sysRateTypeId']->Show($action);

		$rsUpdateInnerHTML['propertyrows'] = "
				<div style=\"height: 3px;\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></div>
				<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" summary=\"\" style=\"table-layout: fixed;\">
				<col style=\"width: 135px\">
				<col style=\"width: 80px\">
				<col style=\"width: 135px\">
				<col style=\"width: 70px\">
				<col>
			" . $GLOBALS['temp']['pRows'] . "
				<tr>
					<td colspan=\"4\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
				</tr>
				</table>
		";

		array_push($rsFuncList,"toggleRateButton");
		array_push($rsFuncList,"''");

		// Output RS response
		echo rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList);
		die();
	}
	
	$GLOBALS['temp']['roleTxt'] = "";
	$GLOBALS['temp']['hideRateArea'] = "";
} else {
	$GLOBALS['temp']['rRows'] .= "<tr><td height='15' colspan='2' class='small' align='center'></td></tr>";
	$GLOBALS['temp']['rateStyle'] = " style=\"visibility:hidden\"";
	$GLOBALS['temp'][$form.'_pr_agent_sysRateTypeId'] = "Save role to add rates";
	$GLOBALS['temp']['hideRateArea'] = "";
	// $GLOBALS['temp']['hideRateArea'] = " style=\"display:none\"";
	$GLOBALS['temp']['roleTxt'] = "Save role to add rates";
}

$GLOBALS['temp']['inactive'] = $GLOBALS[$form.'_pr_agent_pr_agent_inactive_yn'] ?? "";
if(empty($GLOBALS['temp']['inactive']) == "") {
	$GLOBALS['temp']['inactive'] = "0";
}

if(isset($_POST['closeonload']) && $_POST['closeonload'] == "1" && $pmode == 0) {
	if ($GLOBALS[$form.'_pr_agent_pr_agent_inactive_yn']->Value == "0") {
		echo "<body onload='opener.setAgentCheck();window.close();'></body>";
	} else {
		echo "<body onload='opener.inactiveAgent();window.close();'></body>";
	}
	die();
}

if ($record != "") {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if ($action != "2") {
		$record = $GLOBALS['passthrurecord'];
		$_SERVER['argv'][1] = $record;
	}
}

$GLOBALS['temp']['record'] = $record;
$GLOBALS['autovar'] = "1";	// argv index that will be updated with the autoincrement ID after an insert
$GLOBALS[$form]->Get($action);

// echo $GLOBALS[$form]->ListFields();

if ($record != "" || $action == "3" && $action != "1") {
	$table = $GLOBALS[$form]->TableList[0];
	$GLOBALS[$table]->Refresh($record,$action);
}

$actVal = "0";
$inActVal = "1";
$actFlag = $form."_pr_agent_pr_agent_inactive_yn";

if ($GLOBALS[$actFlag]->Value == $actVal || $action == "2") {
	$GLOBALS[$actFlag]->Value = $actVal;
	$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
	$hidelist = array($actFlag);
} else {
	if ($record == "" && $action == "1") {
		$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
	} else {
		$GLOBALS[$actFlag]->Value = $inActVal;
		$GLOBALS['temp']['actInd'] = "";
	}
}

$GLOBALS[$actFlag]->Select(array("$inActVal-Inactive","$actVal-Active"));
$GLOBALS[$actFlag]->StyleType = "small";

if (isset($hidelist)) {
	$GLOBALS[$form]->Hide($hidelist);
}

$table = $GLOBALS[$form]->TableList[0];
$GLOBALS[$table]->Keys = array($form."_pr_agent_pr_agent_id");

$GLOBALS[$form.'_pr_agent_pr_agent_id']->SetValue($record);

//$GLOBALS[form93_rf_note_rf_note_guest_yn]->TabIndex = 4;

$GLOBALS[$form.'_pr_agent_pr_agent_alloc_ext_yn']->Class = 9;
$GLOBALS[$form.'_pr_agent_pr_agent_alloc_ext_yn']->TabIndex = "6";
$GLOBALS[$form.'_pr_agent_pr_agent_alloc_auto_yn']->Class = 9;
$GLOBALS[$form.'_pr_agent_pr_agent_alloc_auto_yn']->TabIndex = "5";

if ( $pmode == "1" ) {
	if ( $action == "2" || $action == "3" ) {
		if ( !isset($_POST['pr_agent_alloc_ext_yn']) || $_POST['pr_agent_alloc_ext_yn'] != "on" ) {
			$GLOBALS[$form.'_pr_agent_pr_agent_alloc_ext_yn']->SetValue(0);
		}
		if ( !isset($_POST['pr_agent_alloc_auto_yn']) || $_POST['pr_agent_alloc_auto_yn'] != "on" ) {
			$GLOBALS[$form.'_pr_agent_pr_agent_alloc_auto_yn']->SetValue(0);
		}
	}
}


if ($pmode == "0") {
	$GLOBALS['temp']['name'] = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$record'",4);

	// The select was causing errors. So I have put in an html drop down for the time being
	$GLOBALS[$form.'_pr_agent_pr_agent_comm_deduct_yn']->Class = 3;
	$GLOBALS[$form.'_pr_agent_pr_agent_comm_deduct_yn']->Select = array("0:|:Gross Amount","1:|:Nett Amount");
	$GLOBALS[$form.'_pr_agent_pr_agent_comm_deduct_yn']->StyleType = "txt";
	$GLOBALS[$form.'_pr_agent_pr_agent_comm_deduct_yn']->TabIndex = "1";

	$GLOBALS[$form.'_pr_agent_rt_rate_type_id']->Class = 3;
	$sql4 = "
		SELECT 
			rt_rate_type_ix,
			rt_rate_type_desc 
		FROM 
			rt_rate_type 
		WHERE 
			rt_rate_type_inactive_yn = '0'
		ORDER BY
			rt_rate_type_desc
	";
	
	$GLOBALS[$form.'_pr_agent_rt_rate_type_id']->Size = 25; // This is the minimum size in '&nbsp;' of the dropdown in view mode
	$GLOBALS[$form.'_pr_agent_rt_rate_type_id']->Select = combolist($GLOBALS['lDB'],$sql4);
	$GLOBALS[$form.'_pr_agent_rt_rate_type_id']->TabIndex = "12";

	$GLOBALS[$form.'_pr_agent_pr_agent_commission_perc']->Class = 1;
	$GLOBALS[$form.'_pr_agent_pr_agent_commission_perc']->StyleType = "txtr";
	$GLOBALS[$form.'_pr_agent_pr_agent_commission_perc']->TabIndex = "2";
	$GLOBALS[$form.'_pr_agent_pr_agent_commission_perc']->Width = "36";

	$GLOBALS[$form.'_pr_agent_pr_agent_account']->Class = 1;
	$GLOBALS[$form.'_pr_agent_pr_agent_account']->Size = 25;
	$GLOBALS[$form.'_pr_agent_pr_agent_account']->StyleType = "txt";
	$GLOBALS[$form.'_pr_agent_pr_agent_account']->TabIndex = "3";

	$GLOBALS[$form.'_pr_agent_ac_pay_plan_id']->Class = 3;
	$sql4 = "
		SELECT 
			ac_pay_plan_ix AS ac_pay_plan_id,
			IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc)
		FROM
			ac_pay_plan
		WHERE
			ac_pay_plan.ac_pay_plan_inactive_yn = 0
			OR ac_pay_plan.ac_pay_plan_ix = '".$GLOBALS[$form.'_pr_agent_ac_pay_plan_id']->Value."'
		ORDER BY
			ac_pay_plan_desc
	";
	
	$GLOBALS[$form.'_pr_agent_ac_pay_plan_id']->Size = 25; // This is the minimum size in '&nbsp;' of the dropdown in view mode
	$GLOBALS[$form.'_pr_agent_ac_pay_plan_id']->Select = combolist($GLOBALS['lDB'],$sql4,"0:|:");
	$GLOBALS[$form.'_pr_agent_ac_pay_plan_id']->Width = "156";
	$GLOBALS[$form.'_pr_agent_ac_pay_plan_id']->TabIndex = "7";

	$GLOBALS[$form.'_pr_agent_ac_pay_final_base']->TabIndex = 3;
	$GLOBALS[$form.'_pr_agent_ac_pay_final_base']->Select(array("0:|:No (Use Default)", "2:|:Day of Month"));
	$GLOBALS[$form.'_pr_agent_ac_pay_final_base']->Size = 30;
	$GLOBALS[$form.'_pr_agent_ac_pay_final_base']->Width = 156;
	$GLOBALS[$form.'_pr_agent_ac_pay_final_base']->onChange = "inputchange = -1; payBaseChange();";
	$GLOBALS[$form.'_pr_agent_ac_pay_final_base']->TabIndex = "8";

	$GLOBALS[$form.'_pr_agent_ac_pay_final_days']->Class = 1;
	$GLOBALS[$form.'_pr_agent_ac_pay_final_days']->Size = 3;
	$GLOBALS[$form.'_pr_agent_ac_pay_final_days']->StyleType = "txtr";
	$GLOBALS[$form.'_pr_agent_ac_pay_final_days']->TabIndex = "9";
	

	$GLOBALS[$form.'_pr_agent_pr_agent_note_open']->Class = 5;
	$GLOBALS[$form.'_pr_agent_pr_agent_note_open']->Rows = 5;
	$GLOBALS[$form.'_pr_agent_pr_agent_note_open']->Width = 460;
	$GLOBALS[$form.'_pr_agent_pr_agent_note_open']->StyleType = "txt";
	$GLOBALS[$form.'_pr_agent_pr_agent_note_open']->TabIndex = "10";

	$GLOBALS[$form.'_pr_agent_pr_agent_note_conf']->Class = 5;
	$GLOBALS[$form.'_pr_agent_pr_agent_note_conf']->Rows = 5;
	$GLOBALS[$form.'_pr_agent_pr_agent_note_conf']->Cols = 80;
	$GLOBALS[$form.'_pr_agent_pr_agent_note_conf']->TabIndex = "11";

	$GLOBALS[$form.'_pr_agent_pr_agent_show_allocs_ind']->Class = 3;
	$GLOBALS[$form.'_pr_agent_pr_agent_show_allocs_ind']->Size = 25;
	$GLOBALS[$form.'_pr_agent_pr_agent_show_allocs_ind']->Select = array("0:|:Use system default","1:|:Show","2:|:Do not show");
	$GLOBALS[$form.'_pr_agent_pr_agent_show_allocs_ind']->StyleType = "txt";
	$GLOBALS[$form.'_pr_agent_pr_agent_show_allocs_ind']->TabIndex = 4;

}

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

if ($action != "4" && $pmode == "0") {
	$html = "
		<tr>
			<td class=\"small\" width=\"46%\">&nbsp;&nbsp;!lastname!</td>
			<td class=\"small\" width=\"29%\">&nbsp;&nbsp;!firstname!</td>
			<td class=\"small\">&nbsp;&nbsp;!username!</td>
		</tr>
	";

	$temp = $GLOBALS['lDB']->get("
		SELECT 
			pr_user.pr_user_id,
			pr_user.pr_user_name,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_link.pr_link_from
		FROM 
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
			INNER JOIN pr_user ON pr_user.pr_user_id = pr_link.pr_link_from
		WHERE 
			pr_link.pr_link_to = '$record' 
			AND pr_link.rf_link_type_id = 'RS2' 
			AND	pr_persona.pr_sys_code < '7' 
		ORDER BY 
			pr_name_last
	",2);

	$userlist = array();
	$GLOBALS['temp']['rows'] = "";

	for ($i = 0; $i < sizeof($temp); $i++) {
		array_push($userlist,$temp[$i][0]);
		$out = str_replace("!lastname!",$temp[$i][2],$html);
		$out = str_replace("!firstname!",$temp[$i][3],$out);
		$out = str_replace("!username!",$temp[$i][1],$out);
		$GLOBALS['temp']['rows'] .= $out;
	}

	$GLOBALS['temp']['numrows'] = sizeof($temp);
	$GLOBALS['temp']['hideUserArea'] = "";
	
	if (isset($GLOBALS['temp']['rows']) && $GLOBALS['temp']['rows'] == "") {
		$GLOBALS['temp']['rows'] = "<tr><td height=\"18\" align=center colspan=3 class=form width=100%></td></tr>";
		$GLOBALS['temp']['numrows'] = 1;
	}
}

$GLOBALS['temp']['modehide'] = " style=\"display:none\"";

// Start Access Control Toolbar Setup
$newr = 58;
$edit = 60;
$view = 57;
$dele = 62;
$sedit = 61;
$snewr = 59;

$pgJOBS = array();
$pgJOBS['view'] = "0";

if ( checkJob($view) ) {
	$pgJOBS['view'] = "1";
}

$pgJOBS['add'] = "0";
$pgJOBS['edit'] = "0";

if ( checkJob($edit) ) {
	$pgJOBS['edit'] = "1";
}

$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
$pgJOBS['saveclose'] = "0";

if ( $action == "2" || $action == "3" ) {
	$pgJOBS['save'] = "1";
	$pgJOBS['saveclose'] = "1";
}

if ( $action == "2" || $action == "4" ) {
	$pgJOBS['edit'] = "0";
}

if ( $action == "3" ) {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if ( checkJob($dele) ) {
		$pgJOBS['del'] = "1";
	}
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"" . $pgJOBS['add'] . "\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"" . $pgJOBS['edit'] . "\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDeleterole\" value=\"" . $pgJOBS['del'] . "\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"" . $pgJOBS['save'] . "\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSaveclose\" value=\"" . $pgJOBS['saveclose'] . "\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobExit\" value=\"1\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobPrint\" value=\"1\" />\n";
// End Access Control Toolbar Setup -------------------------------------------

$GLOBALS['temp']['allowSetup'] = "0";

switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] 								= "display";
	$GLOBALS['temp']['new_record'] 	= "reservation.php?" . $newr . "+" . $record;
	$GLOBALS['temp']['edit_view'] 	= "reservation.php?60+" . $record;	// actually this is display view used to reload page in display mode
	$GLOBALS['temp']['current'] 		= "reservation.php?57+" . $record;
	$GLOBALS['temp']['save_record'] = "#"; 															// from add users popup
	$GLOBALS['temp']['del_record'] 	= "#";
	$GLOBALS['temp']['parent_url'] 	= "reservation.php?47+" . $record;
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = "59+".$record;
	if ( $pmode == "1" ) {
		// Uh... do nothing?		
	} else {
		if ( $record == "" ) {
			echo "<body onload=\"opener.clearAgent();window.close();\"></body>";
			die();
		}
	}		
	$GLOBALS['mode'] 								= "new";
	$GLOBALS['temp']['new_record'] 	= "reservation.php?" . $newr . "+" . $record;
	$GLOBALS['temp']['edit_view'] 	= "reservation.php?60+" . $record;
	$GLOBALS['temp']['current'] 		= "reservation.php?60+" . $record;
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit();";
	$GLOBALS['temp']['del_record'] 	= "#";
	$GLOBALS['temp']['parent_url'] 	= "reservation.php?45+" . $record;
	$GLOBALS['temp']['modehide'] 		= "";
	break;
case (3) : // Edit Record
	$GLOBALS['temp']['allowSetup'] 	= "1";
	$GLOBALS[$form]->Arguments 			= "61+" . $record;
	$GLOBALS['mode'] 								= "edit";
	$GLOBALS['temp']['new_record'] 	= "reservation.php?" . $newr . "+" . $record;
	$GLOBALS['temp']['edit_view'] 	= "reservation.php?57+" . $record;
	$GLOBALS['temp']['current'] 		= "reservation.php?60+" . $record;
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit();";
	$GLOBALS['temp']['del_record'] 	= "reservation.php?62+" . $record;
	$GLOBALS['temp']['parent_url'] 	= "reservation.php?45+" . $record;
	$GLOBALS['temp']['modehide'] 		= "";
	break;
case (4) : // Delete Record
	$now 	= date("Y-m-d H:i:s");
	$reservationCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation
		WHERE
			(
				rf_reservation_status_id ='25' 
				AND rv_create_expiry_date >= '" . $now . "'
			) OR (
				rf_reservation_status_id != '25'
				AND (
					rv_agent_id = '" . $record . "'
					OR rv_origin_agent_id = '" . $record . "' 
					OR rv_corr_persona_id = '" . $record . "' 
					OR rv_invoice_persona_id = '" . $record . "'
					OR rv_billing_persona_id = '" . $record . "'
				)
			)
	",4);
		
	$linkCount = $GLOBALS['lDB']->get("
		SELECT 
			COUNT(*)
		FROM 
			pr_link 
			RIGHT JOIN pr_user ON pr_user.pr_user_id = pr_link.pr_link_from
		WHERE 
			pr_link.pr_link_to = '" . $record . "'
	",4);

	if($reservationCount == 0 && $linkCount == 0) {
		db_pr_agent_prop_delete_by_agent($record);
		db_pr_agent_rate_delete_by_agent($record);
		$GLOBALS['initrecord'] = $record;
		$GLOBALS['delrecord'] = $record;
	} else {
		if ($GLOBALS['lDB']->put("UPDATE pr_agent SET pr_agent_inactive_yn = '1' WHERE pr_agent_id = '$record'")) {
			$GLOBALS['temp']['parent_url'] = "reservation.php?45+" . $record;
			echo "<body onload=\"opener.inactiveAgent();window.close();\"></body>";
		}
		die();
	}
	break;
}

if ($pmode == "0") {
	$rows = new tpParseTable();
	$sql = "
		SELECT
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			'gotoPersona(this.id)' as onclick,
			'this.style.backgroundColor=\'#CCFFCC\'' as onmouseover,
			'this.style.backgroundColor=\'\'' as onmouseout
		FROM
			pr_persona
		INNER JOIN pr_link ON 
			pr_link.pr_link_from = pr_persona.pr_persona_ix
		WHERE
			pr_link.pr_link_to = '" . $record . "'
		AND 
			pr_persona.pr_persona_ix NOT IN ('" . join("','",$userlist) . "')
	";
	
	$rows->Data = $lDB->get($sql,2);
	
	if ( sizeof($rows->Data) == "0" ) {
		$GLOBALS['tagList']['contactBox'] = blankObject();
	}
	$GLOBALS['tagList']['contactRows'] = $rows;
}

$sarg = $_SERVER['argv'];
if ( $sarg[0] == "59" ) {
	$sarg[0] = "60";
}

$GLOBALS['temp']['self_url'] = "reservation.php?" . join("+", $sarg);
$GLOBALS['lDB']->insert_override = $record;

$GLOBALS['temp']['agent_name'] = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$record'",4);

$allocationCount = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_reservation
	WHERE
		rv_agent_id = '$record'
		AND rf_reservation_status_id = '15'
		AND rv_reservation.rv_date_depart >= '".date("Y-m-d")."'
",4);

if(!array_key_exists(267,$GLOBALS['jobLevelArray']) || $GLOBALS['jobLevelArray'][267] < 5) {
	$GLOBALS['temp']['allocationTab'] = "<td id=\"buttonAllocation\" type=\"button\" style=\"width:120px; height:22px;\" class=\"tab tabInactive tabDisabled\">Allocation</td>";
} elseif($allocationCount > 0) {
	$GLOBALS['temp']['allocationTab'] = "<td id=\"buttonAllocation\" onclick=\"buttonPressGeneric('Allocation')\" type=\"button\" style=\"width:120px; height:22px;\" class=\"tab tabInactive tabLink bAllocation16 bLeftBG\">Allocation</td>";
} else {
	$GLOBALS['temp']['allocationTab'] = "<td id=\"buttonAllocation\" onclick=\"buttonPressGeneric('Allocation')\" class=\"tab tabInactive tabLink\" >Allocation</td>";
}
