<?php

/**
 * init.form210.php - This form is called from the calendar via an iframe to add/remove/display itinerary items
 * Job: 637
 * Function: 50 (Availability calendar)
 * 
 */
 
session_set("takenStep3",false);
session_set("wizResStatusUpdated",true);

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", "");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],17,"");

$roomingModule = !empty($_SERVER['argv'][17]);

$tempMasterData = $GLOBALS['lDB']->isMaster;
$GLOBALS['lDB']->isMaster = "1";
$GLOBALS['calendarPage'] = true;


$GLOBALS['temp']['rateDesc'] = "";
$GLOBALS['temp']['resCurr'] = "";
$GLOBALS['temp']['rateId'] = "";
$GLOBALS['temp']['agentId'] = "";
$GLOBALS['temp']['contactId'] = "";

if(isset($_SESSION['calEndDate']) && !empty($_SESSION['calEndDate'])) {
	$tempEndDate = explode("-", $_SESSION['calEndDate']);
} else {
	$tempEndDate = explode("-", date("Y-m-d"));
}
$newEndDate = date("Y-m-d", mktime(0, 0, 0, $tempEndDate[1], $tempEndDate[2] + 1, $tempEndDate[0]));

$wizResId = isset($_SESSION['wizResId']) ? $_SESSION['wizResId'] : "";
validResId($wizResId);

$validResId = false;
if ($lDB->get("select count(*) from rv_reservation where rv_reservation_ix = '" . $wizResId . "'", 4) > 0) {
	$validResId = true;
}

switch ($_SERVER['argv'][2]) {
	case 0 :
		// Delete EVERYTHING --------------------------------------------------
		if ($validResId) {
			removeSpecialsFromRes($wizResId);

			$itemList = $GLOBALS['lDB']->get("select rv_reservation_item_ix from rv_reservation_item where rv_reservation_id = '$wizResId'", 3);
			foreach ($itemList as $item) {
				calDeleteItem($item, $wizResId, true, true, true);
			}
			
		}
		unsetWizResId($wizResId);
		break;

	// Display (do nothing) ---------------------------------------------------
	case 1 : 
		break;

	// Create new itinerary (and res if required) -----------------------------
	case 2 :
		

		$rate_id = $_SERVER['argv'][4];
		$agentList = explode(":", $_SERVER['argv'][5]);
		$agent_id = $agentList[0];
		if ($agent_id == "")
			$agent_id = 0;
		$contact_id = $_SERVER['argv'][7];
		if (strpos($wizResId, "rsFrame") !== false) {
			unsetWizResId($wizResId);
		}

		if (!$validResId) {
			$note = false;
			if (isset($_SESSION['requestRoomNote']) && $_SESSION['requestRoomNote'] != "") {
				$note = "\nOVERBOOKING REQUEST:\n".$_SESSION['requestRoomNote'];
				session_set("requestRoomNote","");
			}
			
			if(sizeof($agentList) > 1 && trim($agentList[1]) != "") {
				$wizResId = db_rv_reservation_insert($rate_id,$contact_id,$agent_id,$agentList[1], $agentList[2],false,false,false,false,false,$note);
			} else {
				$wizResId = db_rv_reservation_insert($rate_id,$contact_id,$agent_id,false, false,false,false,false,false,false,$note);
			}
		}

		$itemCommPerc = false;
		if(sizeof($agentList) > 3) {
			$itemCommPerc = $agentList[3];
			if(!is_numeric($itemCommPerc)) {
				$itemCommPerc = false;
			}
		}

		$compList = explode(":", $_SERVER['argv'][6]);
		$rv_item_split_yn = $_SERVER['argv'][8];
		$override = explodeOrides($_SERVER['argv'][9]);
		$itemDataRaw = $_SERVER['argv'][1];

		$allocations = $_SERVER['argv'][14];
		$itemRateId = $_SERVER['argv'][15];
		$items = calCreateItem($wizResId, $itemDataRaw, $itemRateId, $compList, $override, $rv_item_split_yn, "0", false, $allocations, false, false, false, false, false, $itemCommPerc);
		
		if ( trim($_SERVER['argv'][11]) != "" ) {
			$roomList = explode(":", $_SERVER['argv'][11]);
			$roomRequestYN = $_SERVER['argv'][12];
			$roomRequestReason = addslashes(urldecode($_SERVER['argv'][13]));
			foreach($items as $rv_reservation_item_id) {
				foreach ($roomList as $ac_accomm_room_id) {
					db_rv_res_item_group_insert($rv_reservation_item_id, $ac_accomm_room_id, $roomRequestYN, $roomRequestReason);
				}
			}
		}
		updateReservation($wizResId);

		if(array_key_exists("wizItemOverbooking",$_SESSION)) {
			session_set("wizOverbooking",true);
		}
		break;

	case 4 :
		# Delete an item, and the reservation if no more item's exist
		$items = explode(":", $_SERVER['argv'][1]);
		foreach($items as $item) {
			calDeleteItem($item, $wizResId, true, true, true);
		}
		if ($validResId) {
			updateReservation($wizResId);
		}
		break;

	case 6 :
		# Update a different configuration item [save after diff config popup popped up]
		if ($validResId) {
			$oldItems = explode(":", $_SERVER['argv'][1]);
			if(!empty($_SERVER['argv'][3])) {
				$newItems = array_map(function($rawItem) {
					list($data, $optionals, $override, $rate, $commission) = explode("|", $rawItem);
					$optionals = explode(":", $optionals);
					list($ac_accomm_type_id, $arrive, $depart, $nights, $config) = explode(":", $data);
					return [
						'arrive'=>$arrive,
						'depart'=>$depart,
						'optionals'=>$optionals,
						'config'=>$config,
						'rate'=>$rate,
						'comm'=>$commission,
						'override'=>$override
					];
				},explode(",", $_SERVER['argv'][3]));
			} else {
				$newItems = [];
			}
			calApplyDifferentConfig($oldItems,$newItems,"add");
		}
		break;

	case 7 :
		$rv_reservation_item_id = $_SERVER['argv'][1];

		# clear any existing rooms
		$groupList = $lDB->get("SELECT rv_res_item_group_ix FROM rv_res_item_group WHERE rv_reservation_item_id = '$rv_reservation_item_id'", 3);
		foreach ($groupList as $group) {
			$lDB->put("DELETE FROM rv_res_item_group WHERE rv_res_item_group_ix = '$group'");
		}

		$guestList = $lDB->get("SELECT rv_res_item_guest_ix FROM rv_res_item_guest where rv_reservation_item_id = '$rv_reservation_item_id'", 3);
		foreach ($guestList as $guest) {
			$lDB->put("DELETE FROM rv_res_item_guest WHERE rv_res_item_guest_ix = '$guest'");
		}

		# update rooming
		$roomArray = explode(":", $_SERVER['argv'][3]);
		$rv_room_requested_yn = $_SERVER['argv'][4];
		$rv_room_requested_reason = addslashes(urldecode($_SERVER['argv'][5]));
		foreach ($roomArray as $ac_accomm_room_id) {
			db_rv_res_item_group_insert($rv_reservation_item_id, $ac_accomm_room_id, $rv_room_requested_yn, $rv_room_requested_reason);
		}
		break;
}

if ($_SERVER['argv'][10] == "1") {
	session_set("wizResId",$wizResId);
	if (trim($itemDataRaw) != "") {
		$itemDataArray = explode(":", $itemDataRaw);
		redirectTo(" reservation.php?20+" . $itemDataArray[1]);
	} else {
		redirectTo(" reservation.php?20");
	}
	#echo "<script>parent.window.location = '/reservation.php?20';</script>";
	die();
}
elseif ($_SERVER['argv'][10] == "2") {
	session_set("wizResId",$wizResId);
	redirectTo(" reservation.php?639");
	#echo "<script>parent.window.location = '/reservation.php?639';</script>";
	die();
}

if($roomingModule) {
	session_set("wizResId",$wizResId);
	$response = [];
	$response['reservation_id'] = $wizResId ?? "";
	$response['items'] = $items ?? [];
	$response['expiry'] = $GLOBALS['lDB']->get("SELECT rv_create_expiry_date FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
	if($_SERVER['argv'][2] == 1) {
		$itineraryIds = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$wizResId' ORDER BY rv_item_date_arrive, ac_accomm_type_id", 3);
		$resRate = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
		$itineraries = [];
		foreach($itineraryIds as $rv_reservation_item_id) {
			$item = getItemDetails($rv_reservation_item_id);
			$item['total'] = getDisplayItemTotal($rv_reservation_item_id);
			$item['special'] = itemSpecialItinLineIndicator($rv_reservation_item_id);
			$item['rate_ind'] = "Rte";
			if($resRate != $item['rt_rate_type_id']) {
				$item['rate_ind'] = "Ovr";
			}
			if($item['commPerc'] != $item['itemCommPerc']) {
				$item['rate_ind'] .= " %";
			}
			$item['rate_ind'] .= $item['special'];
			$item['alloc_yn'] = $item['allocCount'] > 0;
			$itineraries[] = $item;
		}
		$response['itineraries'] = $itineraries;
	}
	echo json_encode($response);
	die();
}

$specialIndicationData = getSpecialIndicationText($wizResId,1);

$GLOBALS['temp']['resCurr'] = "";
$GLOBALS['temp']['itinTotal'] = "";
$GLOBALS['temp']['itinComm'] = "";
$GLOBALS['temp']['commText'] = "Commission";
$GLOBALS['temp']['itinFinal'] = "";

$out = "";
$GLOBALS['temp']['wizCalIndex'] = "";
$GLOBALS['temp']['wizCalData'] = "";
$GLOBALS['temp']['isItinerary'] = "0";
$validResId = false;
if ($lDB->get("select count(*) from rv_reservation where rv_reservation_ix = '" . $wizResId . "'", 4) > 0) {
	$validResId = true;
}
$wizCalData = array ();
$rv_split_items = array ();
if ($validResId) {
	if (!$GLOBALS['lDB']->count("rv_reservation_item", "rv_reservation_id", $wizResId, 0)) {
		$list = $GLOBALS['lDB']->get("select rv_reservation_item_ix from rv_reservation_item where rv_reservation_id = '$wizResId' order by rv_item_date_arrive, ac_accomm_type_id", 3);
		$temphtml = Join("\n", File(__DIR__ . "/../../../public/html/cal_reservation_item_table_rows.htm"));
		$resRate = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
		for ($x = 0; $x < sizeof($list); $x++) {
			# Input parameters (for testing purposes)
			$rv_reservation_item_id = $list[$x];

			###################################
			# Obtain reservation item details #
			###################################

			$itemId = $list[$x];
			$resItem = getItemDetails($rv_reservation_item_id);

			$resItem['rt_rate_type_desc_fmt'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($resItem['rt_rate_type_desc'])));
			$special = itemSpecialItinLineIndicator($itemId);
			$resItem['rateLabel'] = "Rte".$special;
			$resItem['rate_text_colour'] = "";
			if($resRate != $resItem['rt_rate_type_id']) {
				$resItem['rateLabel'] = "Ovr".$special;
			}
			if($resItem['commPerc'] != $resItem['itemCommPerc']) {
				$resItem['rateLabel'] .= " %";
			}
			
			if ($resItem['rv_item_split_yn'] == "1") {
				array_push($rv_split_items, $rv_reservation_item_id);
			}

			$resItem['arrive1'] = $resItem['rv_item_date_arrive'];
			$resItem['arrive'] = chng_date($resItem['rv_item_date_arrive'], "-");
			$resItem['depart'] = chng_date($resItem['rv_item_date_depart'], "-");
			$resItem['rv_reservation_item_id'] = $rv_reservation_item_id;
			$resItem['hideCompButton'] = "";
			$resItem['allowCompButton'] = "true";
			$resItem['hideRoomButton'] = "";
			$resItem['allowRoomButton'] = "true";
			if ($userStatusId < 2) {
				$resItem['hideCompButton'] = " style=\"visibility:hidden\"";
				$resItem['allowCompButton'] = "false";
				$resItem['hideRoomButton'] = " style=\"visibility:hidden\"";
				$resItem['allowRoomButton'] = "false";
			}

			$resItem['hideDelButton'] = "";
			$resItem['allowDelButton'] = "true";
			

			$resItem['total'] = getDisplayItemTotal($rv_reservation_item_id);

			// Set the rate type and currency from the result
			if ($GLOBALS['temp']['rateDesc'] == "") {
				$GLOBALS['temp']['rateDesc'] = $resItem['rt_rate_type_desc'];
			}
			if ($GLOBALS['temp']['resCurr'] == "") {
				$GLOBALS['temp']['resCurr'] = isset($resItem['rf_currency_symbol'])?$resItem['rf_currency_symbol']:"";
			}

			$resItem['showGoTo'] = "";
			if ($_SESSION['whichCalendar'] == "availability_calendar")
				$resItem['showGoTo'] = " style=\"visibility:hidden\"";

			if ($resItem['rv_item_date_arrive'] < $_SESSION['calStartDate'] || $resItem['rv_item_date_depart'] > $newEndDate && $resItem['rv_item_date_arrive'] != $_SESSION['calStartDate']) {
				$resItem['showGoTo'] = "";
			}

			// generate the js array
			if (in_array($resItem['ac_accomm_type_id'], $_SESSION['calAccommList'])) {
				$ignore = "0";
				$period = $resItem['noNights'];
				$startDate = $resItem['rv_item_date_arrive'];
				if ($resItem['rv_item_date_arrive'] < $_SESSION['calStartDate']) {
					$startDate = $_SESSION['calStartDate'];
					$buffer = dateSubtract($_SESSION['calStartDate'], $resItem['rv_item_date_arrive']);
					if ($buffer >= $resItem['noNights']) {
						$ignore = "1";
					} else {
						$period = $resItem['noNights'] - $buffer;
					}
				}
				$row = "";
				if ($ignore == "0") {
					$list2 = makeDates($startDate . ":" . $_SESSION['calEndDate'], $period, "m:d:Y");
					$row = "new Array(";
					if (isset($list2[0]) && $list2[0] != "") {
						for ($l = 0; $l < sizeof($list2); $l++) {
							$row .= "\"" . $resItem['ac_accomm_type_id'] . ":" . $list2[$l] . "\",";
						}
						$row .= (string) $resItem['rv_item_accomm_count'] . ")";
						$wizCalData["ri_".$rv_reservation_item_id] = $row;
					}
				}
			}
			// end the js array

			// Rooming info
			$roomList = join(":", $GLOBALS['lDB']->get("SELECT ac_accomm_room_id FROM rv_res_item_group WHERE rv_reservation_item_id = '$rv_reservation_item_id'", 3));
			$roomRequest = $GLOBALS['lDB']->get("
							SELECT 
								rv_room_requested_yn,
								rv_room_request_reason
							FROM
								rv_res_item_group
							WHERE
								rv_reservation_item_id = '$rv_reservation_item_id'
						", 1);
			$resItem['roomList'] = $roomList;
			$resItem['requestYN'] = $roomRequest['rv_room_requested_yn'];
			$resItem['requestReason'] = str_replace("<BR>", "\\n", t_encodeOverlib($roomRequest['rv_room_request_reason']));

			$resItem['rowClass'] = "txt";
			$result = $GLOBALS['lDB']->get("
				SELECT
					COUNT(rv_item_comp_edit_yn)
				FROM
					rv_res_item_comp
				WHERE
					rv_item_comp_edit_yn = 1
					AND rv_reservation_item_id = '$rv_reservation_item_id'
			",4);
			if($result > 0){
				$resItem['rowClass'] = "txtbr";
			}
			
			$resItem['pr_name_last'] = t_encodeHTMLField($resItem['pr_name_last']);
			$resItem['ac_accomm_desc'] = t_encodeHTMLField($resItem['ac_accomm_desc']);
			$resItem['invoice_currency'] = t_encodeHTMLField($resItem['invoice_currency']);
			$out .= showpage($resItem, $temphtml);
			$GLOBALS['temp']['isItinerary'] = "1";
		}
		$GLOBALS['temp']['wizCalData'] = "";
		$keys = array_keys($wizCalData);
		for ($j = 0; $j < sizeof($keys); $j++) {
			$itemId = $keys[$j];
			$GLOBALS['temp']['wizCalData'] .= $wizCalData[$itemId];
		}
		$GLOBALS['temp']['wizCalIndex'] = Join(",", $keys);

		if ($out == "") {
			$out = "<tr>\n
						<td colspan=\"14\" class=\"br bl txt\" align=\"center\">No Items found.</td>\n
					</tr>\n";
		}

		// Totals Display
		$data = getResDocTotals($wizResId, "", "", "", 1);
		$GLOBALS['temp']['itinTotal'] = $data['total_gross'];
		$GLOBALS['temp']['itinComm'] = $data['total_comm'];
		if ($GLOBALS['temp']['itinComm'] < 0) {
			$GLOBALS['temp']['commText'] = "Less Commission";
		}
		$GLOBALS['temp']['itinFinal'] = getDisplayResTotals($wizResId);
	}
	if ($out == "") {
		$out = "<tr>\n
					<td colspan=\"14\" class=\"br bb txt\" align=\"center\">Create an item to continue your reservation.</td>\n
				</tr>\n";
	}
	$sql = "
			SELECT
				rt_rate_type.rt_rate_type_desc,
				rf_currency.rf_currency_symbol,
				rv_reservation.rt_rate_type_id,
				rv_reservation.rv_agent_id,
				rv_reservation.rv_corr_persona_id
			FROM
				rt_rate_type,
				rf_currency,
				rv_reservation
			WHERE
				rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
				AND rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
				AND rv_reservation.rv_reservation_ix = '$wizResId'
		";
	$rateData = $GLOBALS['lDB']->get($sql, 1);
	$GLOBALS['temp']['rateDesc'] = $rateData[0];
	$GLOBALS['temp']['resCurr'] = $rateData[1];
	$GLOBALS['temp']['rateId'] = $rateData[2];
	$GLOBALS['temp']['agentId'] = $rateData[3];
	$GLOBALS['temp']['contactId'] = $rateData[4];
}
if ($out == "") {
	$out = "<tr>\n
				<td colspan=\"14\" class=\"br bb txt\" align=\"center\">Create an item to start your reservation.</td>\n
			</tr>\n";
}
$out = "
	<table width=\"770\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\" align=\"center\" style=\"table-layout: fixed;\">
		<col width=\"22\" />
		<col width=\"81\" />
		<col width=\"81\" />
		<col width=\"120\" />
		<col width=\"120\" />
		<col width=\"36\" />
		<col width=\"36\" />
		<col width=\"38\" />
		<col width=\"34\" />
		<col width=\"96\" />
		<col width=\"34\" />
		<col width=\"25\" />
		<col width=\"25\" />
		<col width=\"22\" />		
		" . $out . "
	</table>
";

$parent = "parent.";
require_once(__DIR__ . '/functions.imageset.php');
if (
	$userStatusId == "0" &&
	$GLOBALS['pr_sys_code'] == "7" &&
	isV3Imageset($GLOBALS['principal_id'])
) {
	// If we have a public user, using a V3 imageset, alter the parent. for iframe referencing, to not end up with parent.parent.element
	$parent = "";
}

// Declare host variables
$rsUpdateInnerHTML = array ();
$rsUpdateValue = array ();
$rsUpdateVar = array ();
$rsFuncList = array ();

// Add values to arrays
$rsUpdateInnerHTML['datarows'] = $out;
$rsUpdateInnerHTML['commText'] = (string) $GLOBALS['temp']['commText'];
$rsUpdateInnerHTML['rateEcho'] = (string) $GLOBALS['temp']['rateDesc'] . " (" . $GLOBALS['temp']['resCurr'] . ")";
if ($GLOBALS['temp']['resCurr'] == "" || $GLOBALS['temp']['rateDesc'] == "") {
	$rsUpdateInnerHTML['rateEcho'] = "";
}
$rsUpdateInnerHTML['resCurr1'] = (string) $GLOBALS['temp']['resCurr'];
$rsUpdateInnerHTML['resCurr2'] = (string) $GLOBALS['temp']['resCurr'];
$rsUpdateInnerHTML['resCurr3'] = (string) $GLOBALS['temp']['resCurr'];
//$rsUpdateInnerHTML[MenuPos] = "";

$rsUpdateValue['itinTotal'] = (string) $GLOBALS['temp']['itinTotal'];
$rsUpdateValue['itinComm'] = (string) $GLOBALS['temp']['itinComm'];
$rsUpdateValue['itinFinal'] = (string) $GLOBALS['temp']['itinFinal'];

$rsUpdateVar[$parent . "frameRateId"] = (string) "\"" . $GLOBALS['temp']['rateId'] . "\"";
$rsUpdateVar[$parent . "frameAgentId"] = (string) "\"" . $GLOBALS['temp']['agentId'] . "\"";
$rsUpdateVar[$parent . "frameContactId"] = (string) "\"" . $GLOBALS['temp']['contactId'] . "\"";
$rsUpdateVar[$parent . "isItinerary"] = (string) "\"" . $GLOBALS['temp']['isItinerary'] . "\"";
$keys = array_keys($wizCalData);
for ($x = 0; $x < sizeof($wizCalData); $x++) {
	$key = $keys[$x];
	$item = $wizCalData[$key];
	$rsUpdateVar[$key] = $item;
}

$rsUpdateInnerHTML['specialDesc'] = (string) $specialIndicationData['appliedSpecialDesc'];
$rsUpdateInnerHTML['defaultSpecialSuggestionDesc'] = $specialIndicationData['defaultSpecialSuggestionDesc'];

$rsUpdateVar["parent.wizCalData"] = (string) "new Array (" . $GLOBALS['temp']['wizCalIndex'] . ")";
array_push($rsFuncList, "frameLoad");
array_push($rsFuncList, "");
if ($GLOBALS['temp']['alertUser'] == "1") {
	array_push($rsFuncList, $parent . "alertUser");
	array_push($rsFuncList, "");
}
if ($GLOBALS['temp']['isItinerary'] == "1") {
	array_push($rsFuncList, $parent . "showItinerary");
	array_push($rsFuncList, "");
} else {
	array_push($rsFuncList, $parent . "hideItinerary");
	array_push($rsFuncList, "");
}
$GLOBALS['temp']['timer'] = "-2";

$timer = "-2";
if ($GLOBALS['temp']['isItinerary'] == "1") {
	$rsUpdateValue['rv_agent_id'] = (string) $GLOBALS['temp']['agentId'];
	$rsUpdateValue['rv_corr_persona_id'] = (string) $GLOBALS['temp']['contactId'];
	$now = date("U");
	$expiry = explode(" ", $lDB->get("select rv_create_expiry_date from rv_reservation where rv_reservation_ix = '$wizResId'", 4));
	$temp1 = explode("-", $expiry[0]);
	$temp2 = explode(":", $expiry[1]);
	$expire = date("U", mktime($temp2[0], $temp2[1], $temp2[2], $temp1[1], $temp1[2], $temp1[0]));
	$timer = $expire - $now;
	$GLOBALS['temp']['timer'] = $timer;
}
array_push($rsFuncList, $parent . "updateTimer");
array_push($rsFuncList, $timer);

// Output RS response
echo rsOutput($rsUpdateInnerHTML, $rsUpdateValue, $rsUpdateVar, $rsFuncList);

if (is_array($rv_split_items) && sizeof($rv_split_items) > 0) {
	echo "<script>" . $parent . "openPopup('reservation.php?684+" . join(":", $rv_split_items) . "+new',540,555);</script>";
}

session_set("wizResId",$wizResId);
$GLOBALS['lDB']->isMaster = $tempMasterData;
die();

