<?php

/**
 * init.form212.php - Booking wizard step 2
 * Job: 639
 * Function: 50 (Availability calendar)
 */

/*
    Check if reservation status has been updated, if yes set the Global variable
    wizResStatusUpdated to true, that is used to show the dialog or not
 */
if (isset($_SESSION['wizResStatusUpdated']) && $_SESSION['wizResStatusUpdated'] == false) {
    $GLOBALS['temp']['wizResStatusUpdated'] = "false";
}


if ($_SESSION['takenStep3']) {
	redirectTo(" reservation.php?693");
	die();
}

session_set("takenStep3",false);
session_set("wizResStatusUpdated",true);

switch($_SESSION['whichCalendar']) {
case "quick_search":
	$GLOBALS['temp']['cancelJob'] = "693";
	break;
case "rooming_module":
	$GLOBALS['temp']['cancelJob'] = "1024";
	break;
default:
	$GLOBALS['temp']['cancelJob'] = "20";
	break;
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/cal_step2_detailsEXT.htm");
}

// Globals required by add field function
$GLOBALS['form'] = $form;
$GLOBALS['tabcount'] = 0;

$tempMasterData = $GLOBALS['lDB']->isMaster;
$GLOBALS['lDB']->isMaster = "1";
$wizResId = $_SESSION['wizResId'];

$GLOBALS['temp']['rv_res_id'] = $wizResId;

if ($_SESSION['userStatusId'] > 1) {
	$internal = 1;
} else {
	$internal = 0;
}

$GLOBALS['temp']['today'] = date("Ymd");

$wizResId = $_SESSION['wizResId'];
validResId($wizResId);

$validResId = false;

if ($lDB->get("select count(*) from rv_reservation where rv_reservation_ix = '".$wizResId."'",4) > 0) {
	$validResId = true;
}

if (!$validResId) {
	redirectTo(" ./reservation.php?20");
  die();
}

$wizAgentId = $GLOBALS['lDB']->get("select rv_agent_id from rv_reservation where rv_reservation_ix = '$wizResId'",4);

if($internal == 1) {
	$GLOBALS[$form]->Arguments = "353";
} else {
	$GLOBALS[$form]->Arguments = "640";
}

// Wipe out the extras in case they exist
if ($GLOBALS['lDB']->get("select count(*) from rv_extra where rv_reservation_id = '".$wizResId."'",4) != "0") {
  	db_rv_extra_delete_by_rv_reservation_id($wizResId);
}
// End extra catering

$tabcount = 1;
// Start creating the form fields
addFormField("rv_reservation_name","48");
$tabcount++; // 2:source button
addFormField("src_name","45");
addFormField("consultant","48");
addFormField("agent_name","48");
addFormField("rv_agent_ref","48");
$GLOBALS[$form.'_rv_agent_ref']->Value = $GLOBALS['lDB']->get("SELECT rv_agent_ref FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
$tabcount++; // 6: originator button
addFormField("originator","45");
$tabcount++; // 7: contact button
addFormField("pr_name_first","50","txts",-1);
addFormField("pr_name_last","27","txts",-1);
$GLOBALS[$form.'_pr_name_first']->Value .= " ".$GLOBALS[$form.'_pr_name_last']->Value;
$GLOBALS[$form.'_pr_name_last']->IsHidden = "1";
addFormField("pr_contact_name","45","txts");
addFormField("pr_contact_name_first","45","txts");
addFormField("pr_contact_name_last","45","txts");
addFormField("pr_email");
addFormField("contact_telephone");
addFormField("contact_fax");
addFormField("pr_corr_addr_line1");
addFormField("pr_corr_addr_line2");
addFormField("pr_corr_post_code");

$GLOBALS[$form.'_rv_reservation_name']->Width = "250";
$GLOBALS[$form.'_rv_reservation_name']->TabIndex = "1";

$GLOBALS[$form.'_consultant']->Width = "250";
$GLOBALS[$form.'_agent_name']->Width = "250";
$GLOBALS[$form.'_rv_agent_ref']->Width = "250";

if ($internal == "1") {
	$GLOBALS[$form.'_src_name']->Width = "250";
	$GLOBALS[$form.'_originator']->Width = "250";
	$GLOBALS[$form.'_pr_contact_name']->Width = "250";
} else {
	$GLOBALS[$form.'_src_name']->Width = "250";
	$GLOBALS[$form.'_originator']->Width = "250";
	$GLOBALS[$form.'_pr_contact_name']->Width = "250";
}

$GLOBALS[$form.'_pr_email']->Width = "250";
$GLOBALS[$form.'_contact_telephone']->Width = "250";
$GLOBALS[$form.'_contact_fax']->Width = "250";
$GLOBALS[$form.'_pr_corr_addr_line1']->Width = "250";
$GLOBALS[$form.'_pr_corr_addr_line2']->Width = "250";
$GLOBALS[$form.'_pr_corr_post_code']->Width = "250";

// Extras code
if ($internal == "1") {
	$temp = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_last,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart
		FROM
			rv_reservation_item
			INNER JOIN ac_accomm_type ON rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			INNER JOIN pr_persona ON ac_accomm_type.pr_business_id = pr_persona.pr_persona_ix
		WHERE
			rv_reservation_item.rv_reservation_id='$wizResId'
		GROUP BY
			pr_persona.pr_name_last, rv_reservation_item.rv_item_date_arrive
		ORDER BY
			rv_reservation_item.rv_item_date_arrive, rv_reservation_item.rv_reservation_item_id
	", 2);

	$propList = array("0:|:");
    for($x=0;$x<sizeof($temp);$x++){
		$id = $temp[$x][0];
        $out = $id.".|.".$temp[$x][2].":|:".$temp[$x][1]." (".chng_date($temp[$x][2],"-")." to ".chng_date($temp[$x][3],"-").")";
        array_push($propList,$out);
	}

    $propDataVal = "";
    $GLOBALS[$form]->AddField("propDate","propDate",$propDataVal,3);

	$GLOBALS['propDate']->TabIndex = $tabcount++;
	$GLOBALS['propDate']->Select($propList);
	$GLOBALS['propDate']->Size = 46;
	$GLOBALS['propDate']->onChange = " temp = this.options[this.selectedIndex].value.toString(); temp = temp.substr(temp.length-10,10); tempYear = temp.substr(0,4); tempMonth = temp.substr(5,2).replace(/^0/,''); tempDay = temp.substr(8,2).replace(/^0/,''); window.id('select_day').selectedIndex = parseInt(tempDay); window.id('select_month').selectedIndex = parseInt(tempMonth); if(tempYear == '0') {tempYear = '';} window.id('year').value = tempYear;";

	# Set service date to first item date
	$firstItemArrivalDate = $temp[0][2];

	// Set up the three date dropdowns
	$days = array("0" => ":|:");
	for ($x=1;$x<32;$x++){
		$days[$x] = $x /*str_pad($x,2,"0",STR_PAD_LEFT)*/.":|:".date("d",mktime(0,0,0,1,$x,2000));
	}
	$months = array("0" => ":|:");
	for ($x=1;$x<13;$x++){
		$months[$x] = $x /*str_pad($x,2,"0",STR_PAD_LEFT)*/.":|:".date("M",mktime(0,0,0,$x,1,2000));
	}

	$SdValue = 0;
	$SmValue = 0;
	$SyValue = "";

	$start = $firstItemArrivalDate;

	if ($start == "0000-00-00"){
		$start = date("Y-m-d");
	}
	if ($start != "" && $start != "0000-00-00") {
		$temp = explode("-",$start);
		$SdValue = 0;
		$SmValue = 0;
		$SyValue = "";
		if ($action == "2" && $pmode == "0") {
			$temp2 = explode("-",date("Y-m-d",mktime(0,0,0,$SmValue,$SdValue,$SyValue)));
			$SdValue = 0;
			$SmValue = 0;
			$SyValue = "";
		}
	}

	$newDfield = "select_day";
	$GLOBALS[$form]->AddField($newDfield,$newDfield,$SdValue,0);
	$GLOBALS[$newDfield]->Select($days);
	$GLOBALS[$newDfield]->Size = "4";
	$GLOBALS[$newDfield]->TabIndex = $tabcount++;

	$newMfield = "select_month";
	$GLOBALS[$form]->AddField($newMfield,$newMfield,$SmValue,0);
	$GLOBALS[$newMfield]->Select($months);
	$GLOBALS[$newMfield]->Size = "7";
	$GLOBALS[$newMfield]->TabIndex = $tabcount++;
	$GLOBALS[$newMfield]->onChange = "select_daymonth_changed();";

	$newYfield = "year";
	$GLOBALS[$form]->AddField($newYfield,$newYfield,$SyValue,0);
	$GLOBALS[$newYfield]->Size = "2";
	$GLOBALS[$newYfield]->StyleType = "txt";
	$GLOBALS[$newYfield]->TabIndex = $tabcount++;
	$GLOBALS[$newYfield]->onChange = "select_daymonth_changed();";

	$sql = "select rf_currency_symbol, rf_currency_ix from rf_currency where rf_currency_ix = '".(isset($GLOBALS['temp']['resCurrId'])?$GLOBALS['temp']['resCurrId']:"")."'";
	$temp = $GLOBALS['lDB']->get($sql,1);
	$GLOBALS['temp']['resCurr'] = $temp[0];
	$GLOBALS['temp']['nowResCurr'] = (string) $temp[1];

	$acAmount = "0";
	$acCurrId = "0";
	$GLOBALS['temp']['acCurr'] = "";

	$GLOBALS['temp']['newItemCurr'] = "";
	$GLOBALS['temp']['nowItemCurr'] = "";

	$GLOBALS[$form]->AddField("echange_display","echange_display","",0);
	$GLOBALS['echange_display']->Size = 12;
	$GLOBALS['echange_display']->StyleType = "txtR";
	$GLOBALS['echange_display']->TabIndex = $tabcount++;
	if ($GLOBALS['echange_display']->Value > 0) {
		if ($GLOBALS['echange_display']->Value == "1") {
			$GLOBALS['echange_display']->Value = "None";
		}
	} else {
		$GLOBALS['echange_display']->Value = "None";
	}

	$GLOBALS['temp']['exch_expiry'] = "";
}
// End extra code

$tabcount = 22;
addFormField("guest_nationality","85");
addFormField("rf_country_id");

// Exception fields (textbox)
$GLOBALS[$form.'_guest_nationality']->StyleType = "txt";
$GLOBALS[$form.'_guest_nationality']->Width = "365";

$tabcount = 24;

$fieldname = "guest_names";
$GLOBALS[$form]->AddField($form."_".$fieldname,$fieldname,"","5");
$GLOBALS[$form."_".$fieldname]->Rows = "5";
$GLOBALS[$form."_".$fieldname]->Cols = "80";
$GLOBALS[$form."_".$fieldname]->StyleType = "txt";
$GLOBALS[$form."_".$fieldname]->TabIndex = $tabcount++;

$tabcount = 28;

$fieldname = "rv_note_general";
$curNote = $GLOBALS['lDB']->get("select rv_note_general from rv_reservation where rv_reservation_ix = '$wizResId'",4);
$GLOBALS[$form]->AddField($form."_".$fieldname,$fieldname,$curNote,"5");
$GLOBALS[$form."_".$fieldname]->Rows = "7";
$GLOBALS[$form."_".$fieldname]->Cols = "80";
$GLOBALS[$form."_".$fieldname]->StyleType = "txt";
$GLOBALS[$form."_".$fieldname]->TabIndex = $tabcount++;

$fieldname = "rv_note_internal";
$curNote = $GLOBALS['lDB']->get("select rv_note_internal from rv_reservation where rv_reservation_ix = '$wizResId'",4);
$GLOBALS[$form]->AddField($form."_".$fieldname,$fieldname,$curNote,"5");
$GLOBALS[$form."_".$fieldname]->Rows = "7";
$GLOBALS[$form."_".$fieldname]->Cols = "80";
$GLOBALS[$form."_".$fieldname]->StyleType = "txt";
$GLOBALS[$form."_".$fieldname]->TabIndex = $tabcount++;

// Exception fields (hidden)
$GLOBALS[$form]->AddField($form."_rv_agent_id","rv_agent_id","","1");
$GLOBALS[$form]->AddField($form."_rv_corr_persona_id","rv_corr_persona_id","","1");
$GLOBALS[$form.'_rv_corr_persona_id']->onChange = "return;";
$GLOBALS[$form.'_rv_agent_id']->onChange = "return;";

// Populate Agent record
$GLOBALS['temp']['linkAddrHide'] = "class=\"\"";

$disableAddress = false;

$GLOBALS['temp']['contactNameClass'] = "collapse";
$GLOBALS['temp']['contactSplitNameClass'] = "expand";
if ($_SESSION['userStatusId'] > 0) {
	$GLOBALS['temp']['contactNameClass'] = "expand";
	$GLOBALS['temp']['contactSplitNameClass'] = "collapse";
	if ($wizAgentId != "0" && $wizAgentId != "") {
		$GLOBALS[$form.'_rv_agent_id']->Value = $wizAgentId;
        $GLOBALS[$form.'_agent_name']->Value = $GLOBALS['lDB']->get("select pr_name_last from pr_persona where pr_persona_ix = '$wizAgentId'",4);
	} elseif ($_SESSION['calAgentId'] != "0") {
		$GLOBALS[$form.'_rv_agent_id']->Value = $_SESSION['calAgentId'];
		$GLOBALS[$form.'_agent_name']->Value = $GLOBALS['lDB']->get("select pr_name_last from pr_persona where pr_persona_ix = '".$_SESSION['calAgentId']."'",4);
	}
	if($GLOBALS[$form.'_agent_name']->Value == "0" || trim($GLOBALS[$form.'_agent_name']->Value) == "") {
		$GLOBALS[$form.'_agent_name']->Value = "Direct";
	}

    // Populate contact/consultant record
	$myContactId = $GLOBALS['lDB']->get("SELECT rv_corr_persona_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
	$GLOBALS[$form.'_rv_corr_persona_id']->Value = $myContactId;

    $contactData = $GLOBALS['lDB']->get("
		SELECT
			pr_name_last,
			pr_name_first,
			pr_email,
			pr_corr_addr_line1,
			pr_corr_addr_line2,
			pr_corr_post_code,
			pr_persona_link_id
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$myContactId'
	",1);
	if($contactData !== false) {
		$contactName = trim($contactData['pr_name_first'] . " " . $contactData['pr_name_last']);
		$tCondata = $contactData[1]." ".$contactData[0];
	} else {
		$contactName = "";
		$tCondata = "";
		$contactData = array_fill(0,7,"");
	}

	nozero($GLOBALS[$form.'_pr_name_first']->Value,$tCondata);
	nozero($GLOBALS[$form.'_pr_contact_name']->Value,$contactName);
	nozero($GLOBALS[$form.'_pr_email']->Value,$contactData[2]);
	$GLOBALS['temp']['linkAddrHide'] = "class=\"collapse\"";
	if ($contactData[6] == "0" || $contactData[6] == "") {
		nozero($GLOBALS[$form.'_pr_corr_addr_line1']->Value,$contactData[3]);
		nozero($GLOBALS[$form.'_pr_corr_addr_line2']->Value,$contactData[4]);
		nozero($GLOBALS[$form.'_pr_corr_post_code']->Value,$contactData[5]);
		$disableAddress = false;
	} else {
		$GLOBALS['temp']['linkAddrHide'] = "";
		$data = getPersona(array("pr_corr_addr_line1","pr_corr_addr_line2", "pr_corr_post_code"),$contactData[6],1);
		nozero($GLOBALS[$form.'_pr_corr_addr_line1']->Value,$data['pr_corr_addr_line1']);
		nozero($GLOBALS[$form.'_pr_corr_addr_line2']->Value,$data['pr_corr_addr_line2']);
		nozero($GLOBALS[$form.'_pr_corr_post_code']->Value,$data['pr_corr_post_code']);
		$disableAddress = true;
	}

	$consultant = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_email,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_post_code
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_consultant_id
		WHERE
			rv_reservation_ix = '$wizResId'
	", 1);

	$GLOBALS[$form.'_consultant']->Value = $consultant['pr_name_first'];
	$GLOBALS[$form.'_consultant']->StyleType = "txts";
	if ($GLOBALS[$form.'_consultant']->Value != "") { $GLOBALS[$form.'_consultant']->Value .= ", "; }
	$GLOBALS[$form.'_consultant']->Value .= $consultant['pr_name_last'];

	$originator = $GLOBALS['lDB']->get ("
		SELECT
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona_ix = rv_reservation.rv_origin_agent_id
		WHERE
			rv_reservation.rv_reservation_ix = '$wizResId'
	", 1);
	$GLOBALS['temp']['rv_origin_agent_id'] = $originator['pr_persona_ix'];
	$GLOBALS[$form.'_originator']->Value = trim($originator['pr_name_first'] . " " . $originator['pr_name_last']);
	$GLOBALS[$form.'_originator']->onChange = "return;";
	$GLOBALS[$form.'_originator']->StyleType = "txts";

	$GLOBALS['temp']['hideConsultant'] = "";
	$GLOBALS['temp']['hideOriginator'] = "";
	if ($userStatusId < "2") {
		$GLOBALS['temp']['hideOriginator'] = " style=\"display:none\"";
	}
	if ($isConsultant == "0") {
		$GLOBALS['temp']['hideConsultant'] = " style=\"display:none\"";
	}

	$def = $GLOBALS['lDB']->get("select rf_phone_type_id from rf_default",4);

	/* ----------------------------------------------------------------------
	Bug #5784 - Reservation wizard: Step 2.
	If the pr_persona_id == 0 and there happened to be a pr_phone entry with
	no pr_persona_id, the results were being displayed even though the agent
	had been set to Direct in Step 1.
	Simple solution: Check for "" or 0 before getting any details.
	------------------------------------------------------------------------- */
	if ( $myContactId != "" && $myContactId != "0" ) {
		nozero($GLOBALS[$form.'_contact_fax']->Value,$GLOBALS['lDB']->get("select pr_phone_number from pr_phone where pr_persona_id = '$myContactId' and rf_phone_type_id = 'RS1'",4));
		nozero($GLOBALS[$form.'_contact_telephone']->Value,$GLOBALS['lDB']->get("select pr_phone_number from pr_phone where pr_persona_id = '$myContactId' and rf_phone_type_id = '$def'",4));
	}
}
// Check if user is allowed to do cross invoicing
$sc_grp_cross_invoice_yn = $GLOBALS['lDB']->get("
	SELECT
		sc_group.sc_grp_cross_invoice_yn
	FROM
		sc_user
		INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
	WHERE
		sc_user.pr_user_id = '$GLOBALS[userid]'
",4);
$GLOBALS['temp']['sc_grp_cross_invoice_yn'] = $sc_grp_cross_invoice_yn ? "true" : "false";

// End form fields
//
clearPaymentGateway();
$pg_accounts = loadPaymentGatewayByReservation($wizResId);
$paymentGatewayPopup = createPaymentGatewayPopup($pg_accounts);
$GLOBALS['temp']['paymentGateway'] = "false";
$GLOBALS['temp']['payment_gateway'] = "";
if($pg_accounts !== false) {
	$GLOBALS['temp']['paymentGateway'] = "true";
	$GLOBALS['temp']['payment_gateway'] = $paymentGatewayPopup;
}

$sc_grp_force_payment_yn = $GLOBALS['lDB']->get("
	SELECT
		sc_group.sc_grp_force_payment_yn
	FROM
		sc_user
		INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
	WHERE
		sc_user.pr_user_id = '$GLOBALS[userid]'
",4);


// Decide which FormHTML to use
if ($internal == "1") {
	$GLOBALS[$form]->FormHTML = Join("",file(__DIR__ . "/../../../public/html/cal_step2_detailsINT.htm"));
	$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/cal_step2_detailsINT.htm";
} else {
	$GLOBALS[$form.'_pr_email']->onChange = "window.contactDetailChanged = true";
	$GLOBALS[$form.'_contact_telephone']->onChange = "window.contactDetailChanged = true";
	$GLOBALS[$form.'_contact_fax']->onChange = "window.contactDetailChanged = true";

	$GLOBALS[$form.'_pr_corr_addr_line1']->onChange = "window.contactDetailChanged = true";
	$GLOBALS[$form.'_pr_corr_addr_line2']->onChange = "window.contactDetailChanged = true";
	$GLOBALS[$form.'_pr_corr_post_code']->onChange = "window.contactDetailChanged = true";
}

// End FormHTML

// Start itinerary display
$GLOBALS['temp']['resCurr'] = "";
$GLOBALS['temp']['itinTotal'] = "";
$GLOBALS['temp']['itinComm'] = "";
$GLOBALS['temp']['commText'] = "Commission";
$GLOBALS['temp']['itinFinal'] = "";

$GLOBALS['temp']['rows'] = "";
if ($wizResId != "") {
	if (!$GLOBALS['lDB']->count("rv_reservation_item", "rv_reservation_id", $wizResId, 0)) {
		$reservationId = $wizResId;
		$list = $lDB->get("
			SELECT
				rv_reservation_item_ix
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_id = '".$reservationId."'
			ORDER BY
				rv_item_date_arrive, ac_accomm_type_id
		", 3);
		$rowHTML = join("", file(__DIR__ . "/../../../public/html/cal_res_item_rows.htm"));

        $resData = $GLOBALS['lDB']->get("
			SELECT
				rt_rate_type.rt_rate_type_desc,
				rf_currency.rf_currency_symbol,
				rv_reservation.rv_invoice_currency_id
			FROM
				rv_reservation
			LEFT JOIN rt_rate_type ON
				rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			LEFT JOIN rf_currency ON
				rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
			WHERE
				rv_reservation_ix = '".$reservationId."'
			", 1);

        $rf_currency_symbol = $resData['rf_currency_symbol'];

		if(!isset($GLOBALS['temp']['rateDesc']) || $GLOBALS['temp']['rateDesc'] == "") {
			$GLOBALS['temp']['rateDesc'] = t_encodeHTMLField($resData['rt_rate_type_desc']);
		}
		if(!isset($GLOBALS['temp']['resCurr']) || $GLOBALS['temp']['resCurr'] == "") {
			$GLOBALS['temp']['resCurr'] = t_encodeHTMLField($resData['rf_currency_symbol']);
		}
		if(!isset($GLOBALS['temp']['resCurrId']) || $GLOBALS['temp']['resCurrId'] == "") {
			$GLOBALS['temp']['resCurrId'] = $resData['rv_invoice_currency_id'];
		}

		$imax = sizeof($list);
		$itemOut = "";
		for ($i=0;$i<$imax;$i++) {
			$itemId = $list[$i];
			$resItem = getItemDetails($itemId);
			$resItem['total'] = getDisplayItemTotal($itemId);
			$resItem['rf_currency_symbol'] = $resItem['itemCurr'] = $rf_currency_symbol;
			if ($resItem['total'] == "TBA") {
				$resItem['rf_currency_symbol'] = $resItem['itemCurr'] = "";
			}

			$resItem['arrive'] = chng_date($resItem['rv_item_date_arrive'],"-");
			$resItem['depart'] = chng_date($resItem['rv_item_date_depart'],"-");
			$resItem['id'] = $itemId;
			$resItem['hideCompButton'] = "";
			if (checkJob($GLOBALS['job'],2) < 15) {
				$resItem['hideCompButton'] = " style=\"visibility:hidden\"";
			}
			$resItem['hideDelButton'] = "";
			if ($imax == "1") {
				$resItem['hideDelButton'] = " style=\"visibility:hidden\"";
			}
			# Test to see whether this item's component(s) have been modified
			$result = $GLOBALS['lDB']->get("SELECT rv_item_comp_edit_yn FROM rv_res_item_comp WHERE rv_item_comp_edit_yn='1' AND rv_reservation_item_id = '$resItem[id]'", 4);

			if($result >= "1") {
				$resItem['rowClass'] = "txtbr";
			} else {
				$resItem['rowClass'] = "txt";
			}

            $resItem['discount'] = "";
			$resItem['pr_name_last'] = t_encodeHTMLField($resItem['pr_name_last']);
			$resItem['ac_accomm_desc'] = t_encodeHTMLField($resItem['ac_accomm_desc']);
			$resItem['invoice_currency'] = t_encodeHTMLField($resItem['invoice_currency']);
			$resItem['rf_currency_symbol'] = t_encodeHTMLField($resItem['rf_currency_symbol']);
            $itemOut .= showpage($resItem,$rowHTML);
		}

		$GLOBALS['temp']['isItinerary'] = "0";
		if ($itemOut != "") {
			$GLOBALS['temp']['isItinerary'] = "1";
			$GLOBALS['temp']['rows'] .= $itemOut;
		}
	}
	if ($GLOBALS['temp']['rows'] == "") {
		$GLOBALS['temp']['rows'] = "<tr><td colspan='12' class='txt' align='center'>No Items found.</td></tr>";
	}
}
if ($GLOBALS['temp']['rows'] == "") {
	$GLOBALS['temp']['rows'] = "<tr><td colspan='12' class='txt' align='center'>No Items found.</td></tr>";
}

// Totals Display
$data = getResDocTotals($wizResId, "", "", "", 1);
$GLOBALS['temp']['itinTotal'] = $data['acc_gross'];
$GLOBALS['temp']['itinComm'] = $data['acc_comm'];
if ($GLOBALS['temp']['itinComm'] < 0) {
	$GLOBALS['temp']['commText'] = "Less Commission";
}
$GLOBALS['temp']['itinFinal'] = getDisplayAccommTotal($wizResId);
// End itinerary display

// Overbooking Code
$GLOBALS['temp']['hideOverbooking'] = " style=\"display:none\"";
# check the availability, will this status result in an overbooking?
$result = check_availability($wizResId,true);
$GLOBALS['temp']['status_error'] = "NONE";

if (is_array($result) && !empty($result)) {
	# Prepare error message
	$GLOBALS['temp']['hideOverbooking'] = "";
	$output = "";
	for ($x=0;$x<sizeof($result);$x++) {
		$Date_Arrive = $result[$x]['date_arrive'];
		$Date_Depart = $result[$x]['date_depart'];
		$Unit_Count = $result[$x]['unit_count'];
		$accomm_name = $result[$x]['accomm_name'];
		$property_name = $result[$x]['property_name'];
		$max_overbook = $result[$x]['max_overbook'];
		$days = Join(", ",$result[$x]['days']);
		$numdays = sizeof($result[$x]['days']);

		$output .= "&nbsp;&nbsp;".$property_name." (".$Unit_Count." ".$accomm_name.")&nbsp;&nbsp;from ".chng_date($Date_Arrive,"-")." to ".chng_date($Date_Depart,"-")."&nbsp;&nbsp;has an overbooking on ".$numdays." days.<br>\n";
	}

	$GLOBALS['temp']['status_error'] = $output;
}
// End overbooking code

// For the status selection
$rv_prov_expiry_days = $db->get("SELECT rf_prov_expiry_days FROM rf_default", 4);

$days = array("0" => ":|:");
for ($x=1;$x<32;$x++) {
	$days[$x] = $x /*str_pad($x,2,"0",STR_PAD_LEFT)*/.":|:".date("d",mktime(0,0,0,1,$x,2000));
}

$months = array("0" => ":|:");
for ($x=1;$x<13;$x++) {
	$months[$x] = $x /*str_pad($x,2,"0",STR_PAD_LEFT)*/.":|:".date("M",mktime(0,0,0,$x,1,2000));
}

$autoexpire = explode("-",date("Y-m-d",mktime (0,0,0,date("m"),date("d")+$rv_prov_expiry_days,date("Y"))));
$pDay = $autoexpire[2];
$pMonth = $autoexpire[1];
$pYear = $autoexpire[0];
$GLOBALS['temp']['provExpireDateRead'] = date("d M Y",mktime (0,0,0,date("m"), date("d")+$rv_prov_expiry_days, date("Y")));

$tabcount = 74;
$newDfield = "pDay";
$GLOBALS[$form]->AddField($newDfield,$newDfield,$pDay,0);
$GLOBALS[$newDfield]->Select($days);
$GLOBALS[$newDfield]->Size = "4";
$GLOBALS[$newDfield]->StyleType = "txt";
$GLOBALS[$newDfield]->TabIndex = $tabcount++;

$newMfield = "pMonth";
$GLOBALS[$form]->AddField($newMfield,$newMfield,$pMonth,0);
$GLOBALS[$newMfield]->Select($months);
$GLOBALS[$newMfield]->Size = "7";
$GLOBALS[$newMfield]->StyleType = "txt";
$GLOBALS[$newMfield]->TabIndex = $tabcount++;
$GLOBALS[$newMfield]->onChange = "select_pdaymonth_changed();";

$newYfield = "pYear";
$GLOBALS[$form]->AddField($newYfield,$newYfield,$pYear,0);
$GLOBALS[$newYfield]->Size = "4";
$GLOBALS[$newYfield]->Length = "4";
$GLOBALS[$newYfield]->StyleType = "txt";
$GLOBALS[$newYfield]->TabIndex = $tabcount++;
$GLOBALS[$newYfield]->onChange = "select_pdaymonth_changed();";
$tabcount++;
$tabcount++;
$tabcount++;
$tabcount++;
$tabcount++;
$tabcount++;
$tabcount++;
$tabcount++;
$tabcount++;
$GLOBALS[$form]->AddField("prov_date_Day","prov_date_Day","","3");
$GLOBALS[$form]->AddField("prov_date_Month","prov_date_Month","","3");
$GLOBALS[$form]->AddField("prov_date_Year","prov_date_Year","","0");



$isTBA = db_rv_reservation_is_tba($wizResId);

$GLOBALS['temp']['statusConfirmedLabel'] = "Please confirm this reservation and forward the relevant documentation.";
$GLOBALS['temp']['statusQuotationLabel'] = "Please provide a detailed quotation for this request - we acknowledge that no space is being held on our behalf.";

$GLOBALS['temp']['statusConfirmedCollapse'] = "";
$GLOBALS['temp']['statusProvisionalCollapse'] = "";
$GLOBALS['temp']['statusWaitlistCollapse'] = "";
$GLOBALS['temp']['statusQuotationCollapse'] = "";

$GLOBALS['temp']['statusConfirmedDisabled'] = "disabled";
$GLOBALS['temp']['statusProvisionalDisabled'] = "disabled";
$GLOBALS['temp']['statusWaitlistDisabled'] = "disabled";
$GLOBALS['temp']['statusQuotationDisabled'] = "disabled";

$GLOBALS['temp']['statusConfirmedChecked'] = "";
$GLOBALS['temp']['statusProvisionalChecked'] = "";
$GLOBALS['temp']['statusWaitlistChecked'] = "";
$GLOBALS['temp']['statusQuotationChecked'] = "";

switch($_SESSION['userStatusId']) {
case 0: /* Public */
	$GLOBALS['temp']['statusQuotationDisabled'] = "";

	if($pg_accounts !== false && $GLOBALS['temp']['status_error'] == "NONE" && !$isTBA) {
		$GLOBALS['temp']['statusConfirmedDisabled'] = "";
		$GLOBALS['temp']['statusConfirmedChecked'] = "checked";
	} else {
		$GLOBALS['temp']['statusQuotationChecked'] = "checked";
		$GLOBALS['temp']['statusConfirmedCollapse'] = "collapse";
		$GLOBALS['temp']['statusProvisionalCollapse'] = "collapse";
		$GLOBALS['temp']['statusWaitlistCollapse'] = "collapse";
	}
	break;
case 1: /* External */
	if($GLOBALS['temp']['status_error'] == "NONE" && !$isTBA) {
		$GLOBALS['temp']['statusConfirmedDisabled'] = "";
		$GLOBALS['temp']['statusProvisionalDisabled'] = "";
		$GLOBALS['temp']['statusWaitlistDisabled'] = "";
		$GLOBALS['temp']['statusQuotationDisabled'] = "";
		if($pg_accounts !== false) {
			$GLOBALS['temp']['statusConfirmedChecked'] = "checked";
		} else {
			$GLOBALS['temp']['statusProvisionalChecked'] = "checked";
		}
	} else {
		if(!array_key_exists("wizOverbooking",$_SESSION)) {
			$GLOBALS['temp']['statusProvisionalDisabled'] = "";
		}
		$GLOBALS['temp']['statusWaitlistDisabled'] = "";
		$GLOBALS['temp']['statusQuotationDisabled'] = "";
		$GLOBALS['temp']['statusWaitlistChecked'] = "checked";
	}
	break;
case 2: /* Internal */
	if(!array_key_exists("wizOverbooking",$_SESSION)) {
		$GLOBALS['temp']['statusConfirmedDisabled'] = "";
		$GLOBALS['temp']['statusProvisionalDisabled'] = "";
		if($GLOBALS['temp']['status_error'] == "NONE") {
			$GLOBALS['temp']['statusProvisionalChecked'] = "checked";
		} else {
			$GLOBALS['temp']['statusWaitlistChecked'] = "checked";
		}
	} else {
		$GLOBALS['temp']['statusWaitlistChecked'] = "checked";
	}
	$GLOBALS['temp']['statusWaitlistDisabled'] = "";
	$GLOBALS['temp']['statusQuotationDisabled'] = "";
	break;
}

$GLOBALS['temp']['statusConfirmedOverlib'] = "";
if($_SESSION['userStatusId'] < 2 && $pg_accounts !== false) {
		$GLOBALS['temp']['statusConfirmedLabel'] = "Confirm and pay now."; //&nbsp;<img src=\"images/payment_gateway/lock.gif\" />";
		$GLOBALS['temp']['statusQuotationLabel'] = "Send me more information.";
		$GLOBALS['temp']['statusProvisionalCollapse'] = "collapse";
		$GLOBALS['temp']['statusWaitlistCollapse'] = "collapse";
		if($isTBA) {
			$GLOBALS['temp']['statusConfirmedOverlib'] = "onmouseout=\"nd();\" onmouseover=\"overlib('Online payments cannot be processed on a reservation where the rate is to be advised. Please select the option for more information.');\"";
		}
}

$roomCount = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
	WHERE
		rv_reservation.rv_reservation_ix = '$wizResId'
", 4);

$allocCount = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation_item AS link_item ON rv_reservation_item.rv_reservation_item_ix = link_item.rv_link_res_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$wizResId'
", 4);

if($allocCount > 0) {
	$GLOBALS['temp']['statusWaitlistDisabled'] = "disabled";
	$GLOBALS['temp']['statusQuotationDisabled'] = "disabled";
	if($GLOBALS['temp']['statusWaitlistChecked'] == "checked") {
		$GLOBALS['temp']['statusWaitlistChecked'] = "";
		if(!array_key_exists("wizOverbooking",$_SESSION)) {
			$GLOBALS['temp']['statusProvisionalChecked'] = "checked";
		}
	}
}

// End the status selection code

/* Extras listing - BEGIN */
$out = "
	<table width=\"1491\" cellspacing=\"0\" align=\"center\" style=\"table-layout:fixed;\">
	<col width=\"80\">
	<col width=\"100\">
	<col width=\"100\">
	<col width=\"100\">
	<col width=\"100\">
	<col width=\"100\">
	<col width=\"63\" />
	<col width=\"63\" />
	<col width=\"134\"  />
	<col width=\"140\"  />
	<col width=\"40\">
	<col width=\"105\">
	<col width=\"65\">
	<col width=\"105\">
	<col width=\"105\">
	<col width=\"50\">
	<col width=\"50\">
	<col width=\"50\">
	<col width=\"50\">
	<col width=\"100\">
	<col width=\"100\">
	<col width=\"40\">
	<col width=\"40\">
		<tr>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">Date</td>
			<td class=\"outLt\" rowspan=\"2\">Internal property</td>
			<td class=\"outLt\" rowspan=\"2\">Type</td>
			<td class=\"outLt\" rowspan=\"2\">Category</td>
			<td class=\"outLt\" rowspan=\"2\">Room</td>
			<td class=\"outLt\" rowspan=\"2\">Extra</td>
			<td class=\"outLt\" rowspan=\"2\" >ETA</td>
			<td class=\"outLt\" rowspan=\"2\" >ETD</td>
			<td class=\"outLt\" rowspan=\"2\">Service By</td>
			<td class=\"outLt\" rowspan=\"2\" >Reference</td>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">Qty</td>
			<td class=\"outLt\" align=\"right\" rowspan=\"2\">Charge<br>Amt</td>
			<td class=\"outLt\" align=\"right\" rowspan=\"2\">Exch</td>
			<td class=\"outLt\" height=\"20\" align=\"center\" colspan=\"3\">Unit Price</td>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">Disc</td>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">Comm rec</td>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">Comm pay</td>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">Invoice to</td>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">POS</td>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">Note</td>
			<td class=\"outLt\" align=\"center\" rowspan=\"2\">Int<br>Memo </td>
		</tr>
		<tr>
			<td class=\"outLt\" align=\"right\" height=\"15\">Total</td>
			<td class=\"outLt\" align=\"right\">Amt</td>
			<td class=\"outLt\" align=\"right\">Tax rate</td>
		</tr>
";

$extraList = $GLOBALS['lDB']->get("
	SELECT
		rv_extra.rv_extra_ix as id,
		rv_extra.rv_extra_date_serv,
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last,
		ac_extra.ac_extra_ix,
		ac_extra.ac_ext_desc,
		ac_extra_category.ac_extra_cat_desc,
		rv_extra.rv_extra_units,
		rv_extra.rv_extra_travel_eta,
		rv_extra.rv_extra_travel_etd,
		rv_extra.rv_extra_supplier_conf_yn,
		rv_extra.pr_supplier_id,
		rv_extra.rv_extra_ref,
		CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name,
		rv_extra.rv_extra_charge,
		rv_extra.rv_extra_tax_perc,
		rv_extra.rf_currency_id as extra_currency_id,
		from_currency.rf_currency_symbol as extra_currency_symbol,
		rv_extra.rv_extra_inv_curr_id as folio_currency_id,
		to_currency.rf_currency_symbol as folio_currency_symbol,
		rv_extra.rv_extra_exch_rate,
		rv_extra.rv_extra_exch_expiry,
		rv_extra.rv_extra_discount,
		rv_extra.rv_extra_comm_rec,
		rv_extra.rv_extra_comm_pay,
		rv_extra.rv_extra_amt_payable,
		rv_extra_note,
		rv_extra_note_internal,
		invoice_persona.pr_name_last as invoice_name_last,
		invoice_persona.pr_name_first as invoice_name_first,
		rv_res_item_group.rv_res_item_group_ix,
		ac_accomm_room.ac_desc,
		rv_extra.fn_folio_id,
		fn_folio.fn_folio_folio_num,
		rv_extra.pr_business_id
	FROM
		rv_extra
		INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
		INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
		LEFT JOIN rf_currency AS from_currency ON from_currency.rf_currency_ix = rv_extra.rf_currency_id
		LEFT JOIN rf_currency AS to_currency ON to_currency.rf_currency_ix = rv_extra.rv_extra_inv_curr_id
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
		LEFT JOIN pr_persona AS invoice_persona ON invoice_persona.pr_persona_ix = fn_folio.fn_folio_to_id
		LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id
	WHERE
		rv_extra.rv_reservation_id = '$wizResId'
", 6);

$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/reservation_extras_rows.htm"));
foreach($extraList as $item) {
	if(!empty($item['pr_supplier_id'])) {
		$item['supplier_image'] = "
			<button onmouseout='nd()' align='right' style=\"width:20;height:20;\"  onmouseover=\"overlib('Show supplier information',BELOW,OFFSETY,17,OFFSETX,-135,WIDTH,130)\" class='button ' onclick='event.cancelBubble = true;contactDet(\"". $item['pr_supplier_id']."\")'>
			<img src='/resource/Resrequest/Application/public/img/icon_contact_16.gif' valign='middle' class='imgLink' />
			</button>
		";
	} else {
		$item['supplier_image'] = "";
	}

	if(trim($item['rv_extra_travel_eta']) == "" ) {
		$item['rv_extra_travel_eta'] = "&nbsp;";
	}
	if(trim($item['rv_extra_travel_etd']) == "" ) {
		$item['rv_extra_travel_etd'] = "&nbsp;";
	}

	$guestList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_last
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_guest.rv_res_item_group_id = '$item[rv_res_item_group_ix]'
	", 2);
	$roomInfo = trim($item['ac_desc']);
	$guestNames = "";
	foreach($guestList as $guestItem) {
		if($guestNames != "") {
			$guestNames .= ", ";
		}
		$guestNames .= trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
	}
	if($roomInfo != "" && $guestNames != "") {
		$roomInfo .= ": ";
	}
	if($guestNames != "") {
		$roomInfo .= $guestNames;
	}
	$item['roomInfo'] = $roomInfo;
	if($item['rv_extra_date_serv'] == "0000-00-00") {
		$item['rv_extra_date_serv_fmt'] = "&nbsp;";
	} else {
		$item['rv_extra_date_serv_fmt'] = chng_date($item['rv_extra_date_serv'],"-");
	}
	if(trim($item['pr_name_last']) == "") {
		$item['pr_name_last'] = "&nbsp;";
	}
	if(trim($item['ac_desc']) == "") {
		$item['ac_desc'] = "&nbsp;";
	}
	$item['from_total'] = $item['rv_extra_units'] * $item['rv_extra_charge'];
	//$item['to_total'] = $item['from_total'] * $item['rv_extra_exch_rate'];
	$item['to_total'] = $item['rv_extra_amt_payable'];
	fixAmtDisplay($item['rv_extra_charge'],2);
	fixAmtDisplay($item['from_total'],2);
	$item['from_total'] .= " $item[from_currency_symbol]";
	$item['to_total'] .= " $item[to_currency_symbol]";
	fixAmtDisplay($item['to_total'],2);
	fixAmtDisplay($item['rv_extra_discount'],2);
	fixAmtDisplay($item['rv_extra_comm_rec'],2);
	fixAmtDisplay($item['rv_extra_comm_pay'],2);
	fixAmtDisplay($item['rv_extra_tax_perc'],2);
	if(trim($item['rv_extra_note']) == "") {
		$item['showNote'] = "style=\"display:none\"";
		$item['replaceNote'] = "&nbsp;";
	} else {
		$item['rv_extra_note_fmt'] = t_encodeOverlib($item['rv_extra_note']);
		$item['rv_extra_note'] = $item['rv_extra_note'];
		$item['showNote'] = "";
		$item['replaceNote'] = "";
	}
	if(trim($item['rv_extra_note_internal']) == "" || $_SESSION['userStatusId'] < 2) {
		$item['rv_extra_note_internal'] = "";
		$item['showMemo'] = "style=\"display:none\"";
		$item['replaceMemo'] = "&nbsp;";
	} else {
		$item['rv_extra_note_internal_fmt'] = t_encodeOverlib($item['rv_extra_note_internal']);
		$item['rv_extra_note_internal'] = $item['rv_extra_note_internal'];
		$item['showMemo'] = "";
		$item['replaceMemo'] = "";
	}
	$invoiceName = "";
	if($item['invoice_name_first'] != "") {
		$invoiceName .= $item['invoice_name_first'];
	}
	if($item['invoice_name_last'] != "") {
		if($invoiceName != "") {
			$invoiceName .= " ";
		}
		$invoiceName .= $item['invoice_name_last'];
	}
	if(trim($invoiceName) == "") {
		$invoiceName = "&nbsp;";
	}
	$item['invoiceName'] = $invoiceName;
	$item['rowBackgroundColor'] = '';
	$item['auditCells'] = "";
	$out .= showpage($item,$rowHTML);
}

$out .= "</table>";
$GLOBALS['temp']['eRows'] = $out;

/* Extras listing - END */

/* Extra auxillary - START */
$folioList = $GLOBALS['lDB']->get ("
	SELECT
		fn_folio_ix,
		fn_folio_folio_num,
		pr_invoice.pr_name_last as invoice_name_last,
		pr_invoice.pr_name_first as invoice_name_first,
		business.pr_name_last as businessName,
		business.pr_persona_ix as billing_unit_id,
		rf_currency.rf_currency_ix,
		rf_currency.rf_currency_symbol,
		ac_accomm_room.ac_desc,
		fn_folio.rv_res_item_group_id
	FROM
		fn_folio
		LEFT JOIN pr_persona AS pr_invoice ON pr_invoice.pr_persona_ix = fn_folio.fn_folio_to_id
		LEFT JOIN pr_persona AS business ON business.pr_persona_ix = fn_folio.pr_business_id
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation_id = '$wizResId'
		AND fn_folio.fn_folio_db IN ('".join("','",getDBCodes())."')
		AND (
		fn_folio.fn_invoice_id IS NULL
		OR fn_folio.fn_invoice_id = '0'
		OR fn_folio.fn_invoice_id = ''
		)
	ORDER BY
		fn_folio.fn_folio_folio_num + 0
", 2);
//debug($folioList);

$folioRows = "";
foreach($folioList as $item) {
	$to = trim($item['invoice_name_first']);
	if($to != "") {
		$to .= " ";
	}
	$to .= trim($item['invoice_name_last']);
	if($to == "") {
		$to = "&nbsp;";
		$toJS = "";
	} else {
		$to = t_encodeHTMLField($to);
		$toJS = t_encodeOverlib($to);
	}
	$room = trim($item['ac_desc']);
	if($room == "") {
		$room = "&nbsp;";
	} else {
		$room = t_encodeHTMLField($room);
	}
	$guestList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_group_id = '$item[rv_res_item_group_id]'
			AND '$item[rv_res_item_group_id]' != ''
	", 2);
	$guestNames = "";
	foreach($guestList as $guestItem) {
		if($guestNames != "") {
			$guestNames .= "<BR>";
		}
		$guestNames .= $guestItem['pr_name_last'];
		if(trim($guestItem['pr_name_first']) != "") {
			$guestNames .= ", " . $guestItem['pr_name_first'];
		}
	}
	if($guestNames == "") {
		$guestNames = "&nbsp;";
	} else {
		$guestNames = t_encodeHTMLField($guestNames);
	}
	$folioRows .= "
		<tr class=\"imgLink\" billing_unit_id=\"$item[billing_unit_id]\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"selectFolio('$item[fn_folio_ix]','$item[fn_folio_folio_num]: $toJS','$item[rf_currency_ix]','$item[rf_currency_symbol]');\">
			<td class=\"br\" valign=\"top\" align=\"center\">$item[fn_folio_folio_num]</td>
			<td class=\"br\" valign=\"top\">$to</td>
			<td class=\"br\" valign=\"top\">".t_encodeHTMLField($item['businessName'])."</td>
			<td class=\"br\" valign=\"top\" align=\"center\">".t_encodeHTMLField($item['rf_currency_symbol'])."</td>
			<td class=\"br\" valign=\"top\">$room</td>
			<td valign=\"top\">$guestNames</td>
		</tr>
	";
}
$GLOBALS['temp']['folioList'] = $folioRows;

$localPropertyId = $GLOBALS['lDB']->get("SELECT pr_business_id FROM rf_db_business WHERE rf_db_code = '$GLOBALS[dbcode]'",4);

$resItemList = $GLOBALS['lDB']->get("
	SELECT
		pr_business_id
	FROM
		rv_reservation_item
	WHERE
		rv_reservation_id = '$wizResId'
", 3);

$entityACL = array();
foreach($resItemList as $item) {
	$businessId = "";
	$currId = $item;
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		$billingPropYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		if($billingYN == "1" || $billingPropYN == "1") {
			$businessId = $currId;
		} else {
			$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id ='$currId'", 4);
		}
	}
	if($businessId != "" && $businessId != "0") {
		array_push($entityACL, $businessId);
	}
}
$entityACL = array_unique($entityACL);

$currencyList = $GLOBALS['lDB']->get("SELECT rf_currency_ix FROM rf_currency ORDER BY rf_currency_symbol", 3);

$currencyList = array_unique($currencyList);
$currencyOptions = "";

foreach($currencyList as $item) {
	$currencySymbol	= $GLOBALS['lDB']->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency.rf_currency_ix = '$item'", 4);
	$currencyName = $GLOBALS['lDB']->get("SELECT rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix = '$item'", 4);
	$localCheck	= $GLOBALS['lDB']->get("SELECT count(*) FROM pr_business WHERE pr_business_id = '$localPropertyId' AND pr_bus_home_curr_id = '$item'", 4);

	if ( $localCheck > 0 ) {
		$currencySelected = 'selected="selected" ';
	} else {
		$currencySelected = '';
	}
	$currencyOptions .= '<option value="' . $item . '" ' . $currencySelected . '>' . t_encodeHTMLField($currencyName . ' (' . $currencySymbol) . ')</option>';
}

$GLOBALS['temp']['currencyOptions'] = $currencyOptions;

$contactList = $GLOBALS['lDB']->get("
	SELECT
		fn_folio_to_id
	FROM
		fn_folio
	WHERE
		fn_folio.rv_reservation_id = '$wizResId'
		AND fn_folio_to_id IS NOT NULL
		AND fn_folio_to_id <> ''
		AND fn_folio_to_id <> '0'
", 3);
array_splice($contactList,sizeof($contactList), 0, $GLOBALS['lDB']->get("
	SELECT
		rv_billing_persona_id,
		rv_invoice_persona_id
	FROM
		rv_reservation
	WHERE
		rv_reservation_ix = '$wizResId'
", 1));

$contactList = array_unique($contactList);
$contactOptions = "";
foreach($contactList as $item) {
	$contact = $GLOBALS['lDB']->get("
		SELECT
			pr_name_last,
			pr_name_first
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$item'
	", 1);
	$name = trim($contact['pr_name_first']);
	if($name != "") {
		$name .= " ";
	}
	$name .= trim($contact['pr_name_last']);
	$contactOptions .= "<option value=\"$item\">$name</option>";
}
$GLOBALS['temp']['contactOptions'] = $contactOptions;

$entityList = $GLOBALS['lDB']->get("
	SELECT
		pr_business_id
	FROM
		pr_business
	WHERE
		pr_bus_billing_yn = '1'
		OR pr_bus_billing_prop_yn = '1'
", 3);
$entityList = array_intersect($entityACL, $entityList);
$entityOptions = "";
foreach($entityList as $item) {
	$name = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$item'",4);
	if($localPropertyId == $item) {
		$entitySelected = " selected ";
	} else {
		$entitySelected = "";
	}
	$entityOptions .= "<OPTION value=\"$item\" $entitySelected>".t_encodeHTMLField($name)."</option>";
}
$GLOBALS['temp']['entityOptions'] = $entityOptions;

$roomList = $GLOBALS['lDB']->get("
	SELECT
		rv_res_item_group.rv_res_item_group_ix,
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_reservation_item_id,
		pr_persona.pr_name_last,
		ac_accomm_type.ac_accomm_desc,
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$wizResId'
	ORDER BY
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart
",2);

$newRoomList = array();
foreach($roomList as $item) {
	$item['rv_item_date_arrive'] = chng_date($item['rv_item_date_arrive'],"-");
	$item['rv_item_date_depart'] = chng_date($item['rv_item_date_depart'],"-");
	$item['ac_desc_raw'] = $item['ac_desc'];
	if(trim($item['ac_desc']) == "") {
		$item['ac_desc'] = "&nbsp;";
	}
	$guestList = $GLOBALS['lDB']->get ("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_ix,
			pr_guest.pr_guest_primary_yn,
			rf_title.rf_title_desc,
			rf_name_suffix.rf_suffix_desc
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
			LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
			LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
		WHERE
			rv_res_item_group_id = '$item[rv_res_item_group_ix]'
	", 2);

	if(sizeof($guestList) > 0) {
		$guestNames = "";
		foreach($guestList as $guestItem) {
			$guestNames = $guestItem['pr_name_last'];
			if(trim($guestItem['pr_name_first']) != "") {
				$guestNames .= ", " . $guestItem['pr_name_first'];
			}
			if(trim($guestItem['rf_title_desc']) != "") {
				$guestNames .= ", " . $guestItem['rf_title_desc'];
			}
			if(trim($guestItem['rf_suffix_desc']) != "") {
				$guestNames .= ", " . $guestItem['rf_suffix_desc'];
			}

			$item['guestNames'] = $guestNames;
			if($guestItem['pr_guest_primary_yn'] == "1") {
				$item['guestNames'] = "<span class=\"txtb\">$guestNames</span>";
			}
			$item['guestNamesRaw'] = $guestNames;
			$item['role'] = "Guest";
			$item['pr_persona_ix'] = $guestItem['pr_persona_ix'];
			array_push($newRoomList,$item);
		}

	} elseif ( $item['ac_desc'] != "0" && trim($item['ac_desc']) != "") {
		$item['guestNamesRaw'] = "";
		$item['guestNames'] = "&nbsp;";
		$item['role'] = "Room";
		$item['pr_persona_ix'] = "";
		array_push($newRoomList, $item);
	}
}

$agentInfo = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
	WHERE
		rv_reservation_ix = '$wizResId'
", 1);
array_unshift($newRoomList,array('role'=>'Agent', 'guestNames'=>$agentInfo['pr_name_last'], 'guestNamesRaw'=>$agentInfo['pr_name_last'], 'ac_desc'=>"&nbsp;",'ac_desc_raw'=>"", 'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;", 'pr_persona_ix'=>$agentInfo['pr_persona_ix'],'rv_res_item_group_ix'=>""));

$billing = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_first,
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_billing_persona_id
	WHERE
		rv_reservation_ix = '$wizResId'
", 1);
$billingName = trim($billing['pr_name_first']);
if($billingName != "") { $billingName .= " "; }
$billingName .= trim($billing['pr_name_last']);
array_unshift($newRoomList,array('role'=>'Billing Contact','guestNames'=>$billingName, 'guestNamesRaw'=>$billingName, 'ac_desc'=>"&nbsp;", 'ac_desc_raw'=>"",'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;",'pr_persona_ix'=>$billing['pr_persona_ix'],'rv_res_item_group_ix'=>""));

$invoice = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_first,
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_invoice_persona_id
	WHERE
		rv_reservation_ix = '$wizResId'
", 1);
$invoiceName = trim($invoice['pr_name_first']);
if($invoiceName != "") { $invoiceName .= " "; }
$invoiceName .= trim($invoice['pr_name_last']);
array_unshift($newRoomList,array('role'=>'Invoice Contact','guestNames'=>$invoiceName, 'guestNamesRaw'=>$invoiceName, 'ac_desc'=>"&nbsp;",'ac_desc_raw'=>"", 'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;",'pr_persona_ix'=>$invoice['pr_persona_ix'],'rv_res_item_group_ix'=>""));
$roomList = null;
//debug($newRoomList);

$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/reservation_extras_room_pop_rows.htm"));
$rows = "";

foreach($newRoomList as $item) {
	$item['guestNamesRaw'] = t_encodeOverlib($item['guestNamesRaw']);
	$rows .= showpage($item,$rowHTML);
}
$GLOBALS['temp']['contactRows'] = $rows;

$exchangeList = db_rf_exchange_rate_get_all_rates();
$rows = "";
foreach($exchangeList as $item) {
	$rows .= "<INPUT type=\"hidden\" id=\"curr$item[rf_exch_curr_from_id]_$item[rf_exch_curr_to_id]\" value=\"$item[rf_exch_rate]\">\n";
}
$GLOBALS['temp']['exchangeList'] = $rows;

$expiryDays = $GLOBALS['lDB']->get("select rf_exch_expiry_days from rf_default",4);
$expiryDate = date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$expiryDays,date("Y")));
list($expiryYear, $expiryMonth, $expiryDay) = explode("-",$expiryDate);

$GLOBALS['temp']['expiryDate'] = $expiryDate;
$GLOBALS['temp']['expiryYear'] = $expiryYear;
$GLOBALS['temp']['expiryMonth'] = $expiryMonth;
$GLOBALS['temp']['expiryDay'] = $expiryDay;

// Tax rates dropdown
$sql = "
	SELECT
		rf_tax_rate_ix,
		IF(rf_tax_rate_inactive_yn <> '0',concat('*',rf_tax_rate_desc),rf_tax_rate_desc) as rf_tax_rate_desc
	FROM
		rf_tax_rate
	WHERE
		rf_tax_rate_inactive_yn = '0'
	ORDER BY rf_tax_rate_desc
";

$tax_rates = $GLOBALS['lDB']->get($sql,2);

$rfTaxRateSelect = '<select id="rf_tax_rate" name="rf_tax_rate" class="forminput" style="width: 110px"  tabindex="23" >';
$rfTaxRateSelect .= '<option value=""></option>';
foreach ($tax_rates as $tax_rate) {
	$id = $tax_rate['rf_tax_rate_ix'];
	$rfTaxRateSelect .= '<option value="'.$id.'">'.$tax_rate['rf_tax_rate_desc'].'</option>';
}
$rfTaxRateSelect .= '</select>';

$GLOBALS['temp']['rf_tax_rate'] = $rfTaxRateSelect;

// Tax groups dropdown
$sql = "
	SELECT
		rt_tax_group_ix,
		IF(rt_tax_group_inactive_yn <> '0',concat('*',rt_tax_group_desc),rt_tax_group_desc) as rt_tax_group_desc
	FROM
		rt_tax_group
	WHERE
		rt_tax_group_inactive_yn = '0'
	ORDER BY rt_tax_group_desc
";

$tax_groups = $GLOBALS['lDB']->get($sql,2);

$rtTaxGroupSelect = '<select id="rt_tax_group" name="rt_tax_group" class="forminput" style="width: 110px"  tabindex="23" >';
$rtTaxGroupSelect .= '<option value=""></option>';
foreach ($tax_groups as $tax_group) {
	$id = $tax_group['rt_tax_group_ix'];
	$rtTaxGroupSelect .= '<option value="'.$id.'">'.$tax_group['rt_tax_group_desc'].'</option>';
}
$rtTaxGroupSelect .= '</select>';

$GLOBALS['temp']['rt_tax_group'] = $rtTaxGroupSelect;

// Prepare an array of tax groups with their total percentages
$sql =  "
	SELECT
		rt_tax_group.rt_tax_group_ix AS id,
		SUM(rf_tax_rate.rf_tax_rate_perc) AS perc
	FROM
		rt_tax_group
		LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = rt_tax_group.rt_tax_group_ix
		LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
	WHERE
		rf_tax_rate.rf_tax_rate_inactive_yn = 0
	GROUP BY rt_tax_group.rt_tax_group_ix
";
$perc = $GLOBALS['lDB']->get($sql,2);
$tax_group_array = array();
foreach ($perc as $tax_group) {
	$tax_group_array[$tax_group['id']] = $tax_group['perc'];
}
$GLOBALS['temp']['tax_group_array'] = json_encode($tax_group_array);

$sql =  "
	SELECT
		rf_tax_rate.rf_tax_rate_ix AS id,
		rf_tax_rate.rf_tax_rate_perc AS perc
	FROM
		rf_tax_rate
	WHERE
		rf_tax_rate.rf_tax_rate_inactive_yn = 0
	ORDER BY rf_tax_rate.rf_tax_rate_ix
";
$perc = $GLOBALS['lDB']->get($sql,2);
$tax_rate_array = array();
foreach ($perc as $tax_rate) {
	$tax_rate_array[$tax_rate['id']] = $tax_rate['perc'];
}
$GLOBALS['temp']['tax_rate_array'] = json_encode($tax_rate_array);

$deliverRoomList = $GLOBALS['lDB']->get("
	SELECT
		rv_res_item_group.rv_res_item_group_ix,
		ac_accomm_room.ac_desc
	FROM
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		INNER JOIN ac_accomm_room on ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation.rv_reservation_ix = '$wizResId'
", 2);

$deliverRoomOptions = "";
foreach($deliverRoomList as $deliverRoomItem) {
	$deliverRoomOptions .= "<option value=\"$deliverRoomItem[rv_res_item_group_ix]\">$deliverRoomItem[ac_desc]</option>";
}
$GLOBALS['temp']['deliverRoomOptions'] = $deliverRoomOptions;

$sourceLookup = $GLOBALS['lDB']->get("
	SELECT
		rf_source.rf_source_ix,
		rf_source.rf_source_desc
	FROM
		rv_reservation
		INNER JOIN rf_source ON rf_source.rf_source_ix = rv_reservation.rf_source_ix
	WHERE
		rv_reservation.rv_reservation_ix = '$wizResId'
	", 1);
$GLOBALS['temp']['sourceId'] = $sourceLookup['rf_source_ix'];
$GLOBALS[$form.'_src_name']->Value = $sourceLookup['rf_source_desc'];

$resNameLookup = $GLOBALS['lDB']->get("SELECT rv_res_name FROM rv_reservation WHERE rv_reservation.rv_reservation_ix = '$wizResId'",4);
$GLOBALS[$form.'_rv_reservation_name']->Value = $resNameLookup;

// Extra Auxillary : END ------------------------------------------------------

$hideList = array($form."_rv_agent_id",$form."_rv_corr_persona_id",$form."_rf_country_id");
$GLOBALS[$form]->Hide($hideList);

$disableList = array($form."_agent_name");
array_push($disableList,$form."_guest_nationality");
array_push($disableList,$form."_src_name");

if ($isConsultant != "0" && $internal == "1") {
	array_push($disableList,$form."_originator");
}

if ($internal == "1") {
	array_push($disableList,$form."_pr_name_first");
	array_push($disableList,$form."_pr_name_last");
	array_push($disableList,$form."_pr_contact_name");
	array_push($disableList,$form."_consultant");
	array_push($disableList,"echange_display");
}

if ($_SESSION['userStatusId'] == 1) {
	array_push($disableList,$form."_pr_name_first");
	array_push($disableList,$form."_pr_name_last");
	array_push($disableList,$form."_pr_contact_name");
}

if ($disableAddress) {
	array_push($disableList,$form."_pr_corr_addr_line1");
	array_push($disableList,$form."_pr_corr_addr_line2");
	array_push($disableList,$form."_pr_corr_post_code");
}

if ($internal == "1" && !isMasterDB()) {
	array_push($disableList,$form."_contact_telephone");
	array_push($disableList,$form."_contact_fax");
	array_push($disableList,$form."_pr_email");
	array_push($disableList,$form."_pr_corr_addr_line1");
	array_push($disableList,$form."_pr_corr_addr_line2");
	array_push($disableList,$form."_pr_corr_post_code");
}

$GLOBALS[$form]->Disable($disableList);

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"0\">\n";

$GLOBALS['temp']['exchTableVis'] = "hidden";

$GLOBALS['temp']['travelClass'] 	= "disabled";
$GLOBALS['temp']['travelArrive'] 	= "";
$GLOBALS['temp']['travelDepart'] 		= "";
$GLOBALS['temp']['travelTransfer'] 	= "";

$GLOBALS['temp']['wizResId'] = $wizResId;

// Set the reservation to expire in 10 + rf_default minutes from loadtime
if ($_SESSION['addedExpiry'] != true) {
	$pad = $GLOBALS['lDB']->get("select rf_res_create_expiry_mins from rf_default",4);
	$total = ($pad + 10) * 60;
	// $total = 60;
	$expiry = date("Y-m-d H:i:s",mktime(date("H"),date("i"),date("s")+$total,date("m"),date("d"),date("Y")));
	$GLOBALS['lDB']->put("UPDATE rv_reservation SET rv_create_expiry_date = '$expiry' WHERE rv_reservation_ix = '$wizResId'");
	$_SESSION['addedExpiry'] = true;
}
// End reservation expiry update

// Set the expiry timer
$now = date("U");
$expiry = explode(" ",$lDB->get("select rv_create_expiry_date from rv_reservation where rv_reservation_ix = '$wizResId'",4));
$temp1 	= explode("-",$expiry[0]);
$temp2 	= explode(":",$expiry[1]);

$expire = date("U",mktime($temp2[0],$temp2[1],$temp2[2],$temp1[1],$temp1[2],$temp1[0]));
$timer 	= $expire - $now;
$GLOBALS['temp']['timer'] = $timer;
// End expiry timer

$GLOBALS['lDB']->isMaster = $tempMasterData;

$GLOBALS['temp']['rv_date_arrive'] = $GLOBALS['lDB']->get("SELECT rv_date_arrive FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);

$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];

global $principal_id;
global $domain;
$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";

if ($userStatusId == "0" && $GLOBALS['pr_sys_code'] == "7") {
	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/cal_step2_detailsEXT.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file($GLOBALS['images_dir_on_disk']."/$principal_id/cal_step2_detailsEXT.htm")));
	}
	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/template_restructure_reservation_calendar.js")) {
		$GLOBALS['temp']['customHTML'] .= '<script>'
			. join("",file($GLOBALS['images_dir_on_disk']."/$principal_id/template_restructure_calendar_step_two.js"))
			. '</script>';
	}
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/cal_step2_detailsEXT.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />";
		$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/cal_step2_detailsEXT.css\" type=\"text/css\" />";
	} elseif(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-cal_step2.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/template-cal_step2.css\" type=\"text/css\" />";
		$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/shared/global.css\" type=\"text/css\">";
	} else {
		$indexCSS = "<link rel=\"stylesheet\" href=\"styles/cal_step2_detailsEXT.css\" type=\"text/css\" />";
	}
	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/uikit.min.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/uikit.min.css\" type=\"text/css\" />";
		$indexHTML = "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit.min.js"));
		$indexHTML .= "</script>";
		$indexHTML .= "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit_image_height.js"));
		$indexHTML .= "</script>";
		$indexHTML .= "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit-icons.min.js"));
		$indexHTML .= "</script>";
		$GLOBALS['temp']['customHTML'] .= $indexHTML;
	} elseif(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-cal_step2.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/ui-kit/uikit.min.css\" />";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js\"></script>\n";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js\"></script>\n";
	} else {
		$uikitCSS = "";
	}

	$GLOBALS['temp']['customDefaultCSS'] = "
		$uikitCSS
	";
	$custom = "";
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/custom.css")) {
		$custom = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/custom.css\" type=\"text/css\">";
	}

	$GLOBALS['temp']['customCSS'] = "
		$indexCSS
		$custom
	";

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Don't include anything extra if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customDefaultCSS'] = "
			<style>
				body {
					background-color: transparent !important;
				}
			</style>
		";
		$GLOBALS['temp']['customCSS'] = "<link rel=\"stylesheet\" href=\"styles/cal_step2_detailsEXT.css\" type=\"text/css\" />";
	}	
} else {
	$GLOBALS['temp']['customDefaultCSS'] = "";
}

// Block booking details
$blockDetails = $GLOBALS['lDB']->get("
	SELECT
		bl_block.bl_block_ix,
		bl_block.bl_block_name
	FROM
		bl_block
		INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
		LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
		LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
		LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
	WHERE
		draw_down_item.rv_reservation_id = '$wizResId'
",1);
if (!empty($blockDetails)) {
	$blockDetailsTableHTML = "
	<table align='center' id='tblBlockDetails' class='table' width='770'>
		<col width='5' />
		<col width='756' />
		<col width='5' />
		<tr>
			<td class='br colLt'><img src='/resource/Resrequest/Application/public/img/1x1.gif' width='5' height='25' alt='' /></td>
			<td class='bt bb colLtt' valign='middle'>
				<table align='center' id='tblBlockDetails' class='table' width='100%'>
					<col width='200' />
					<col width='100' />
					<col width='100' />
					<col width='255' />
					<tr>
						<td class='colLtt'>&nbsp;&nbsp;Block template details</td>
						<td class='frmLbl2Col'><label>Number</label></td>
						<td class='frmVal2Col'>!bl_block_ix!</td>
						<td class='frmLbl2Col'><label>Name</label></td>
						<td class='frmVal2Col'>!bl_block_name!</td>
					</tr>
				</table>
			</td>
			<td class='bl colLt'><img src='/resource/Resrequest/Application/public/img/1x1.gif' width='5' height='25' alt='' /></td>
		</tr>
	</table>

	";
	$GLOBALS['temp']['blockDetails'] = showpage($blockDetails, $blockDetailsTableHTML);
	$GLOBALS['temp']['step1Description'] = 'Step 1: Block';
	if($GLOBALS[$form.'_rv_reservation_name']->Value == "") { 
		$GLOBALS[$form.'_rv_reservation_name']->Value = $blockDetails['bl_block_name'];
	}
} else {
	$GLOBALS['temp']['blockDetails'] = '';
	$GLOBALS['temp']['step1Description'] = 'Step 1: Calendar';
}
