<?php

/**
 * init.form213.php - Reservation Wizard Step 3
 * Job: 640
 * Function: 50 (Availability calendar)
 */

session_set("takenStep3",true);

switch($_SESSION['whichCalendar']) {
case "quick_search":
	$GLOBALS['temp']['cancelJob'] = "693";
	break;
case "rooming_module":
	$GLOBALS['temp']['cancelJob'] = "1024";
	break;
default:
	$GLOBALS['temp']['cancelJob'] = "20";
	break;
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/cal_step3_payInfoEXT.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$tempMasterData = $GLOBALS['lDB']->isMaster;
$GLOBALS['lDB']->isMaster = "1";

$wizResId = isset($_SESSION['wizResId']) ? $_SESSION['wizResId'] : "";

global $wizResId;

$wetu = new Wetu($wizResId, $GLOBALS['lDB']);
$GLOBALS['temp']['wetuDropdownOptions'] = $wetu->GenerateButtontext();

if ($_SESSION['userStatusId'] > 1) {
	$calendarLevel = $lDB->get("SELECT sc_fun_grp_level FROM sc_fun_group WHERE sc_group_id = '" . $GLOBALS['sc_group_id'] . "' AND sc_function_id = '50'",4);
	if ($calendarLevel > "5") {
		$internal = 1;
	} else {
		$internal = 0;
	}
} else {
	$internal = 0;
}

session_set("calStepNumber","1");
$GLOBALS[$form]->Arguments = "642";

if ($_SERVER['argv'][2] == "") {
	if ($wizResId != "" && $GLOBALS['lDB']->count("rv_reservation","rv_reservation_ix",$wizResId,1)) {
		$resData = $GLOBALS['lDB']->get("SELECT rf_reservation_status_id, rv_create_expiry_date FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",1);
		if ($resData[0] == "25") {
			if ($resData[1] < date("Y-m-d H:i:s")){
				redirectTo(" ./reservation.php?20");
				die();
			}
		}
	} else {
		redirectTo(" ./reservation.php?20");
		die();
	}
}

if(empty($_POST['paymentGateway'])) {
	if ($userStatusId > 1) {
		session_restart();
		unset($_SESSION['extWizContact']);
		session_write_close();
	} else {
		$_SESSION['extWizContact'] = array();
		if ($userStatusId > 0) {
			$_SESSION['extWizContact']['pr_name_first'] = $GLOBALS['lDB']->get("
				SELECT
					pr_name_first
				FROM
					rv_reservation
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id
				WHERE
					rv_reservation.rv_reservation_ix = '$wizResId'
			",4);
			$_SESSION['extWizContact']['pr_name_last'] = $GLOBALS['lDB']->get("
				SELECT
					pr_name_last
				FROM
					rv_reservation
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id
				WHERE
					rv_reservation.rv_reservation_ix = '$wizResId'
			",4);
		} else {
			$_SESSION['extWizContact']['pr_name_first'] = "";//$_POST['pr_name_first'];
			$_SESSION['extWizContact']['pr_name_last'] = $_POST['pr_contact_name'];
		}
		$_SESSION['extWizContact']['rf_source_ix'] = isset($_POST['rf_source_ix'])?$_POST['rf_source_ix']:"";
		$_SESSION['extWizContact']['contact_telephone'] = $_POST['contact_telephone'];
		$_SESSION['extWizContact']['contact_fax'] = $_POST['contact_fax'];
		$_SESSION['extWizContact']['pr_corr_addr_line1'] = $_POST['pr_corr_addr_line1'];
		$_SESSION['extWizContact']['pr_corr_addr_line2'] = $_POST['pr_corr_addr_line2'];
		$_SESSION['extWizContact']['pr_corr_post_code'] = $_POST['pr_corr_post_code'];
		$_SESSION['extWizContact']['rv_reservation_id'] = $wizResId;
		$_SESSION['extWizContact']['pr_email'] = $_POST['pr_email'];
		session_set("extWizContact",$_SESSION['extWizContact']);
	}
}

// Decide which FormHTML to use
if ($internal == "1"){
	$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/cal_step3_payInfoINT.htm";
	$GLOBALS[$form]->FormHTML = Join("",file(__DIR__ . "/../../../public/html/cal_step3_payInfoINT.htm"));
}
// End FormHTML
$record = $wizResId;
$GLOBALS['temp']['record'] = (string) $record;
$method = $_SERVER['argv'][2];

if($internal == "1") {
	$_POST['rv_agent_id'] = $GLOBALS['lDB']->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
}

$GLOBALS['temp']['payplanStyle'] = "";
if (!isset($_POST['rv_agent_id']) || $_POST['rv_agent_id'] == "") {
	$_POST['rv_agent_id'] = "0";
}

if ($method == "genPayPlan") {
	$acPayPlanId = $_SERVER['argv'][3];
} else {
	if ($_POST['rv_agent_id'] != "0") {
		$acPayPlanId = $GLOBALS['lDB']->get("
			SELECT
				pr_agent.ac_pay_plan_id
			FROM
				pr_agent
				INNER JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_ix = pr_agent.ac_pay_plan_id
			WHERE
				pr_agent.pr_agent_id = '" . $_POST['rv_agent_id'] . "'
				AND ac_pay_plan.ac_pay_plan_inactive_yn = '0'
		",4);
	} else {
		$acPayPlanId = "";
	}
}
if (trim($acPayPlanId) == "" || $acPayPlanId == "0") {
	$acPayPlanId = $GLOBALS['lDB']->get("SELECT ac_pay_plan_id FROM rf_default",4);
}
if ($method == "customPayPlan") {
	$payItemId = $_SERVER['argv'][3];
	$payAmnt = $_SERVER['argv'][4];
	$payDate = $_SERVER['argv'][5];
	if ($payItemId != "0" && $payItemId != "1") {
		// Check for any payment plan items on the same date
		$checkPayPlanItem = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_pay_plan_item
			WHERE				
				rv_reservation_id = '$record'
				AND rv_pay_plan_date = '$payDate'
				AND rv_pay_plan_item_ix != '$payItemId'
		",4,1);
		if($checkPayPlanItem > 0) {
			$GLOBALS['lDB']->put("DELETE FROM rv_pay_plan_item WHERE rv_pay_plan_item_ix = '$payItemId'");
			$payPlanItem = $GLOBALS['lDB']->get("
				SELECT
					rv_pay_plan_item_ix,
					rv_pay_plan_amount
				FROM
					rv_pay_plan_item
				WHERE
					rv_reservation_id = '$record'
					AND rv_pay_plan_date = '$payDate'
			",1);
			$payItemId = $payPlanItem['rv_pay_plan_item_ix'];
			$finalAmount = $payAmnt + $payPlanItem['rv_pay_plan_amount'];
			$GLOBALS['lDB']->put("
				UPDATE rv_pay_plan_item SET
					rv_pay_plan_amount = '".$lDB->escape($finalAmount)."'
				WHERE
					rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'
			");
		} else { 
			$GLOBALS['lDB']->put("
				UPDATE rv_pay_plan_item SET
					rv_pay_plan_amount = '".$lDB->escape($payAmnt)."',
					rv_pay_plan_date = '".$lDB->escape($payDate)."'
				WHERE
					rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'
			");
		}
	} else {
		// Check for any payment plan items on the same date
		$checkPayPlanItem = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_pay_plan_item
			WHERE
				rv_reservation_id = '$record'
				AND rv_pay_plan_date = '$payDate'
		",4);
		if($checkPayPlanItem > 0) {
			$payPlanItem = $GLOBALS['lDB']->get("
				SELECT
					rv_pay_plan_item_ix,
					rv_pay_plan_amount
				FROM
					rv_pay_plan_item
				WHERE
					rv_reservation_id = '$record'
					AND rv_pay_plan_date = '$payDate'
			",1);
			$payItemId = $payPlanItem['rv_pay_plan_item_ix'];
			$finalAmount = $payAmnt + $payPlanItem['rv_pay_plan_amount'];
			$GLOBALS['lDB']->put("
				UPDATE rv_pay_plan_item SET
					rv_pay_plan_amount = '".$lDB->escape($finalAmount)."'
				WHERE
					rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'
			");
		} else {			 
			$GLOBALS['lDB']->put("
				INSERT INTO rv_pay_plan_item (
					rv_pay_plan_item_db,
					rv_pay_plan_amount,
					rv_pay_plan_date,
					rv_reservation_id
				) VALUES (
					'". $GLOBALS['dbcode'] . "',
					'$payAmnt',
					'$payDate',
					'$record'
				)
			");
			$key = $GLOBALS['lDB']->insert_id;
		}
	}
} elseif($method == "delPayPlan") {
	$payItemId = $_SERVER['argv'][3];
	$GLOBALS['lDB']->put("DELETE FROM rv_pay_plan_item WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
} else {
	genPaymentPlan($record,$acPayPlanId);
}
$GLOBALS['editPayPlan'] = true;
$paymentPlan = getPayItems($record);

// Generate listing of all default rate types
$GLOBALS['temp']['payplanrows'] = "";
if ($internal == "1") {
	$payplanHTML = join("\n",file(__DIR__ . "/../../../public/html/reservation_billing_payitem_rows.htm"));
} else {
	$payplanHTML = join("\n",file(__DIR__ . "/../../../public/html/cal_step3_payitem_rows.htm"));
}
// Show amount paid and balance for public users
if($userStatusId == "0" && $paymentPlan['payedTotal'] > 0) {
	$paid = $paymentPlan['payedTotal'];
	$outstanding = $paymentPlan['payTotal'] - $paid;
	fixAmtDisplay($outstanding,2);
	$paymentPlan['items'][] = array("pay_id" => "0", "date_pc" => "", "pay_date" => "Amount paid", "rv_pay_plan_amount" => $paid, "rf_currency_symbol" => $paymentPlan['payments'][0]['rf_currency_symbol'], "hideShowDel" => " style=\"visibility:hidden\" ","pr_name"=>"","type"=>"total_paid");
	$paymentPlan['items'][] = array("pay_id" => "0", "date_pc" => "", "pay_date" => "Balance", "rv_pay_plan_amount" => $outstanding, "rf_currency_symbol" => $paymentPlan['payments'][0]['rf_currency_symbol'], "hideShowDel" => " style=\"visibility:hidden\" ","pr_name"=>"","type"=>"balance");
}
for($a=0;$a<sizeof($paymentPlan['items']);$a++) {
	$payplanData = $paymentPlan['items'][$a];
	if($userStatusId == "0" && $payplanData['type'] == "total_planned") {
		continue;
	}
	$payplanData['style'] = " style=\"visibility:hidden\"";
	$GLOBALS['temp']['payplanrows'] .= showpage($payplanData,$payplanHTML);
}
$GLOBALS['temp']['isPayPlan'] = "1";
if ($GLOBALS['temp']['payplanrows'] == "") {
	$GLOBALS['temp']['payplanrows'] .= "<tr><td height='20' colspan='3'>No payment plan</td></tr>";
	$GLOBALS['temp']['isPayPlan'] = "0";
}

$payedHTML = join("\n",file(__DIR__ . "/../../../public/html/cal_step3_payed_rows.htm"));
$GLOBALS['temp']['payedrows'] = "";
for($a=0;$a<sizeof($paymentPlan['payments']);$a++) {
	$payplanData = $paymentPlan['payments'][$a];
	$GLOBALS['temp']['payedrows'] .= showpage($payplanData,$payedHTML);
}
if($GLOBALS['temp']['payedrows'] == "") {
	$GLOBALS['temp']['payedrows'] .= "<tr><td height='20' colspan='9'>&nbsp;No payments found</td></tr>";
}
$GLOBALS['temp']['payOutstanding'] = $paymentPlan['outstanding'];
fixAmtDisplay($GLOBALS['temp']['payOutstanding']);

// Generate dropdown of all valid rate types
$GLOBALS[$form]->AddField($form."_sysPayPlanId","sysPayPlanId",$acPayPlanId,3);
$sql = "
	SELECT
		ac_pay_plan.ac_pay_plan_ix,
		ac_pay_plan.ac_pay_plan_desc
	FROM
		ac_pay_plan
	ORDER BY
		ac_pay_plan.ac_pay_plan_desc
";
$GLOBALS[$form.'_sysPayPlanId']->Select(combolist($GLOBALS['lDB'],$sql));
$GLOBALS[$form.'_sysPayPlanId']->AlwaysOn = "1";

// rsUpdate, refresh the default rate dropdown and the default rate listing
$method = $_SERVER['argv'][2];
if ($method == "genPayPlan" || $method == "customPayPlan" || $method == "delPayPlan") {
	$listOut = "<table width='100%' cellspacing='0' cellpadding='0' id='payPlan'>".$GLOBALS['temp']['payplanrows']."</table>";

	// Declare host variables
	$rsUpdateInnerHTML = array();
	$rsUpdateValue = array();
	$rsUpdateVar = array();
	$rsFuncList = array();

	// Add values to arrays
	$rsUpdateInnerHTML['payplanrows'] = $listOut;
	#$rsUpdateInnerHTML['payplanspan'] = $GLOBALS[$form.'_sysPayPlanId']->Show($action);

	$rsUpdateValue['payOutstanding'] = $GLOBALS['temp']['payOutstanding'];

	array_push($rsFuncList,"togglePayPlanButton");
	array_push($rsFuncList,"''");

	array_push($rsFuncList,"effectPayPlanChange");
	array_push($rsFuncList,"'".$GLOBALS['temp']['isPayPlan']."'");

	$rsUpdateVar["diff"] = $GLOBALS['temp']['diff'];

	// Output RS response
	echo rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList);
	die();
}

$status = "";
$status_result = "";
if ($internal != "1") {
	// update the status information
	$today = date("Y-m-d");
	$_POST['rf_reservation_status_id'] = isset($_POST['rf_reservation_status_id']) ? $_POST['rf_reservation_status_id'] : "";
	switch($_POST['rf_reservation_status_id']) {
	case "0":
		$status = "quotation";
		$status_result = "Please provide a quotation for this request - we acknowledge that no space is being held on our behalf.";
		break;
	case "10":
		$status = "waitlisted";
		$status_result = "We acknowledge that this reservation includes dates over which no accommodation is currently available.&nbsp;&nbsp;Please waitlist this reservation and advise us<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;when / if the rooms become available.";
		break;
	case "20":
		$status = "provisional";
		$status_result = "Please hold this reservation on a provisional basis only and advise us (by return email) the date on which this reservation status should be confirmed.";
		break;
	case "30":
		$status = "confirmed";
		$status_result = "Please confirm this reservation and forward the relevant documentation.";
		break;
	}
}
// Get Guest Names and Guest Notes and concatenate
/* All notes need to be stored in plain ASCII!
$guestNames = htmlspecialchars($_POST['guest_names'],ENT_QUOTES);
$guestNote = htmlspecialchars($_POST['guest_notes'],ENT_QUOTES);
*/
$guestNames = isset($_POST['guest_names']) ? $_POST['guest_names'] : "";
$guestNote = isset($_POST['guest_notes'])?$_POST['guest_notes']:"";

$guestNotes = trim($guestNames);
if(trim($guestNote) != "") {
	$guestNotes .= "\n\n" . $guestNote;
}

$lpoContact = "";
$dietary = "";
if (isset($_POST['textarea']) && trim($_POST['textarea']) != "") {
	$dietary = "\nDietary Requirements: ".$_POST['textarea'];
}
$guestNotes .= $dietary;
if (isset($_POST['textarea2']) && trim($_POST['textarea2']) != "") {
	$lpoContact = "\nLast Point of Contact: ".$_POST['textarea2'];
}
$guestNotes .= $lpoContact;
// update the reservation
/* All notes need to be stored in plain ASCII!
	rv_note_general = '".htmlspecialchars($note_general,ENT_QUOTES)."',
	rv_note_internal = '".htmlspecialchars($_POST['rv_note_internal'], ENT_QUOTES)."',
*/

if(empty($_POST['paymentGateway'])) {
	if ($internal != "1") {
		if ($_POST['rv_agent_id'] != "0") {
			$invoice_persona = $_POST['rv_agent_id'];
			if ($_POST['rv_corr_persona_id'] == "0") {
				$billing_persona = $_POST['rv_agent_id'];
			}
		}

		if ($_POST['rv_corr_persona_id'] != "0") {
			$billing_persona = $_POST['rv_corr_persona_id'];
			if (!isset($invoice_persona) || $invoice_persona == "0" || $invoice_persona == "") {
				$invoice_persona = $_POST['rv_corr_persona_id'];
			}
		}

		$GLOBALS['lDB']->put("
			UPDATE
				rv_reservation
			SET
				rv_res_name = '".$lDB->escape($_POST['rv_reservation_name'])."',
				rf_source_ix = '".$lDB->escape(isset($_POST['rf_source_ix'])?$_POST['rf_source_ix']:"")."',
				rv_corr_persona_id = '".$lDB->escape($_POST['rv_corr_persona_id'])."',
				rv_origin_agent_id = '".$lDB->escape(isset($_POST['rv_origin_agent_id'])?$_POST['rv_origin_agent_id']:"")."',
				rv_billing_persona_id = '".$lDB->escape($billing_persona)."',
				rv_invoice_persona_id = '".$lDB->escape($invoice_persona)."',
				rv_agent_ref = '".$lDB->escape($_POST['rv_agent_ref'])."'
			WHERE
				rv_reservation_ix = '$wizResId'
		");
		db_rv_reservation_set_status($wizResId,$_POST['rf_reservation_status_id'], false, false, false);
		db_rv_note_insert($wizResId,$_POST['rf_country_id'],false,$_POST['rv_note_general'],$guestNotes,isset($_POST['rv_note_internal'])?$_POST['rv_note_internal']:"");
	} else {
		db_rv_note_insert($wizResId,$_POST['rf_country_id'],false,false,$guestNotes,false);

		if(isset($_POST['allResItemGroupRoom']) && $_POST['allResItemGroupRoom'] != "") {
			$totalItemArr = unserialize($_POST['allResItemGroupRoom']);
			$resId = $wizResId;
			foreach ($totalItemArr as $itemId => $item) {
				$resItemId = $itemId;
				foreach ($item as $key => $guestListArr) {
					if (empty($key)) {
						break;
					}
					$data = explode("-", $key);
					$roomId = $data[1];
					$groupId = $data[0];
					
					$guestList = unserialize($guestListArr);
					$GLOBALS['temp']['pr_persona_ix'] =  "";
					
					foreach($guestList as $guestKey=>$guestItem) {
						if($guestItem['pr_phone_number'] == "Telephone") { $guestItem['pr_phone_number'] = ""; }
						if($guestItem['pr_email'] == "Email") { $guestItem['pr_email'] = ""; }
						
						// Edit Existing Guest
						if($guestItem['pr_persona_ix'] != "0" && trim($guestItem['pr_persona_ix']) != "") { 
							$pr_persona_ix = $guestItem['pr_persona_ix'];
							$personaAudit = new AuditTrail($pr_persona_ix,TYPE_PERSONA);
							$personaChanges = false;
							$old = $lDB->get("
								SELECT
									pr_name_last,
									pr_name_first,
									pr_email,
									pr_title_id,
									pr_name_suffix_id
								FROM
									pr_persona
								WHERE
									pr_persona_ix = '".$lDB->escape($pr_persona_ix)."'
							",1);
							$rf_name_suffix_ix = (isset($guestItem['rf_name_suffix_ix'])?$guestItem['rf_name_suffix_ix']:"");
							$GLOBALS['lDB']->put("
								UPDATE 
									pr_persona 
								SET
									pr_name_first = '".$lDB->escape($guestItem['pr_name_first'])."',
									pr_name_last = '".$lDB->escape($guestItem['pr_name_last'])."',
									pr_email = '".$lDB->escape($guestItem['pr_email'])."',
									pr_title_id = '".$lDB->escape($guestItem['rf_title_ix'])."',
									pr_name_suffix_id = '".$lDB->escape($rf_name_suffix_ix)."'
								WHERE 
									pr_persona_ix = '" . $guestItem['pr_persona_ix'] . "'
							");
							if($old['pr_name_last'] != $guestItem['pr_name_last']) {
								$personaAudit->addDetail($old['pr_name_last'], $guestItem['pr_name_last'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_name_last");
								$personaChanges = true;
							}
							if($old['pr_name_first'] != $guestItem['pr_name_first']) {
								$personaAudit->addDetail($old['pr_name_first'], $guestItem['pr_name_first'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_name_first");
								$personaChanges = true;
							}
							if($old['pr_email'] != $guestItem['pr_email']) {
								$personaAudit->addDetail($old['pr_email'], $guestItem['pr_email'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_email");
								$personaChanges = true;
							}
							if($old['pr_title_id'] != $guestItem['rf_title_ix']) {
								$personaAudit->addDetail($old['pr_title_id'], $guestItem['rf_title_ix'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_title_id");
								$personaChanges = true;
							}
							if($old['pr_name_suffix_id'] != $rf_name_suffix_ix) {
								$personaAudit->addDetail($old['pr_name_suffix_id'], $rf_name_suffix_ix, $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_name_suffix_id");
								$personaChanges = true;
							}
							$GLOBALS['lDB']->put("
								UPDATE 
									pr_guest 
								SET
									pr_guest_primary_yn = '".$lDB->escape($guestItem['pr_guest_primary_yn'])."',
									pr_guest_note = '".$lDB->escape($guestItem['pr_guest_note'])."',
									pr_guest_memo = '".$lDB->escape($guestItem['pr_guest_memo'])."'
								WHERE 
									pr_guest_id = '" . $guestItem['pr_persona_ix'] . "'
							");

							if($guestItem['pr_phone_number'] != $guestItem['pr_phone_number_old']) {
								// Remove old telephone record
								$oldPhoneId = $GLOBALS['lDB']->get("
									SELECT
										pr_phone_ix
									FROM
										pr_phone
									WHERE
										pr_phone.pr_persona_id = '" . $guestItem['pr_persona_ix'] . "'
										AND pr_phone.pr_default_yn = '1'
										AND pr_phone.pr_phone_number = '" . $guestItem['pr_phone_number_old'] . "'
								",4);
								
								$GLOBALS['lDB']->put("DELETE FROM pr_phone WHERE pr_phone_ix = '$oldPhoneId'");
								$personaAudit->addDetail($guestItem['pr_phone_number_old'], "", $oldPhoneId, "", DB_AD_PERSONA_DETAIL_ACTION_DELETE, "phone", "pr_phone.pr_phone_number");
								$personaChanges = true;

								if($guestItem['pr_phone_number'] != "") {
									// Add new telephone record
									$GLOBALS['lDB']->put("
										INSERT INTO pr_phone (
											pr_phone_db,
											pr_phone_id,
											pr_default_yn,
											pr_phone_number,
											rf_phone_type_id,
											pr_persona_id
										) VALUES (
											'" . $GLOBALS['dbcode'] . "',
											'',
											'1',
											'" . $guestItem['pr_phone_number'] . "',
											'RS3',
											'" . $guestItem['pr_persona_ix'] . "'
										)
									", 1);
									$pr_phone_id = $lDB->insert_id;
									$personaAudit->addDetail("", 1, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_default_yn");
									$personaAudit->addDetail("", $guestItem['pr_phone_number'], "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number");
									$personaAudit->addDetail("", "RS3", "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id");
								}
							}

							if($personaChanges) {
								$personaAudit->save("Contact details (Edit)");
							}
							$guestName = getContactFullName($guestItem['pr_persona_ix'],false);
							ammendReservation($wizResId,"Guests (Edit: $guestName [".$guestItem['pr_persona_ix']."])");									
							
						} else { // Add New Guest
							
							$GLOBALS['lDB']->put("
								INSERT INTO pr_persona (
									pr_persona_db,
									pr_persona_id,
									pr_name_last,
									pr_name_first,
									pr_email,
									pr_title_id
								) VALUES (
									'" . $GLOBALS['dbcode'] . "',
									'',
									'" . $guestItem['pr_name_last'] . "',
									'" . $guestItem['pr_name_first'] . "',
									'" . $guestItem['pr_email'] . "',
									'" . $guestItem['rf_title_ix'] . "'
								)
							");
							$pr_persona_ix = $GLOBALS['lDB']->insert_id;

							$personaAudit = new AuditTrail($pr_persona_ix,TYPE_PERSONA);
							$personaAudit->addDetail("", $guestItem['pr_name_last'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_name_last");
							$personaAudit->addDetail("", $guestItem['pr_name_first'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_name_first");
							$personaAudit->addDetail("", $guestItem['pr_email'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_email");
							$personaAudit->addDetail("", $guestItem['rf_title_ix'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_title_id");
							
							$GLOBALS['temp']['pr_persona_ix'] = $pr_persona_ix;
							$guestItem['pr_persona_ix'] = $pr_persona_ix;
							$guestList[$guestKey]['pr_persona_ix'] = $pr_persona_ix;
							db_pr_guest_insert($pr_persona_ix, '0', '0', '0',$guestItem['pr_guest_note'], $guestItem['pr_guest_memo'], $guestItem['pr_guest_primary_yn']);

							db_rv_reservation_guest_insert($resId,$pr_persona_ix);
							if($groupId == "" || $groupId == "0") {
								$groupId = db_rv_res_item_group_insert($resItemId);
							}
							if($groupId != "") {
								db_rv_res_item_guest_insert($pr_persona_ix, $groupId);
							}
							
							if($guestItem['pr_phone_number'] != "") {
								// Add new telephone record
								$GLOBALS['lDB']->put("
									INSERT INTO pr_phone (
										pr_phone_db,
										pr_phone_id,
										pr_default_yn,
										pr_phone_number,
										rf_phone_type_id,
										pr_persona_id
									) VALUES (
										'" . $GLOBALS['dbcode'] . "',
										'',
										'1',
										'" . $guestItem['pr_phone_number'] . "',
										'RS3',
										'" . $guestItem['pr_persona_ix'] . "'
									)
								");
								$pr_phone_id = $lDB->insert_id;
								$personaAudit->addDetail("", 1, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_default_yn");
								$personaAudit->addDetail("", $guestItem['pr_phone_number'], "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number");
								$personaAudit->addDetail("", "RS3", "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id");
							}
						}
						$personaAudit->save("Contact details (Add)");
						$guestName = getContactFullName($guestItem['pr_persona_ix'],false);
						ammendReservation($wizResId,"Guests (Insert: $guestName [".$guestItem['pr_persona_ix']."])");								
					}
					// update linkage
					foreach($guestList as $guestKey=>$guestItem) {
						if($guestItem['primary_id'] !== "") { linkPrimary($guestItem['primary_id'], $guestItem['pr_persona_ix']); }
						if($guestItem['primary_count'] !== "") { linkPrimary($guestList[$guestItem['primary_count']]['pr_persona_ix'],$guestItem['pr_persona_ix']); }
					}
				}
			}
		}
	}

	// Check that the accommodation folios are being billed to someone. If not, bill to the contact.
	if ($internal != "1") {
		$folioIdList = $GLOBALS['lDB']->get("SELECT fn_folio_id FROM rv_reservation_item WHERE rv_reservation_id = '$wizResId'",3);
		foreach($folioIdList as $folioId) {
			$folioToId = $GLOBALS['lDB']->get("SELECT fn_folio_to_id FROM fn_folio WHERE fn_folio.fn_folio_ix = '$folioId'",4);
			$agentCount = $GLOBALS['lDB']->get("
				SELECT
					COUNT(pr_persona.pr_persona_ix)
				FROM
					rv_reservation
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
				WHERE
					rv_reservation.rv_reservation_ix = '$wizResId'
			",4);
			if($folioToId != $_POST['rv_corr_persona_id'] && $agentCount < 1) {
				$GLOBALS['lDB']->put("UPDATE fn_folio SET fn_folio_to_id = '" . $_POST['rv_corr_persona_id'] . "' WHERE fn_folio_ix = '$folioId'");
			}
		}
	}
	// END folio check
} else {
	if($_POST['paymentAction'] == "moreInfo" || $_POST['paymentAction'] ==  "otherMethod") {
		$today = date("Y-m-d");
		switch($_POST['paymentAction']) {
		case "moreInfo":
			$status = "quotation";
			$status_result = "Please provide a quotation for this request - we acknowledge that no space is being held on our behalf.";
			db_rv_reservation_set_status($wizResId,0, false, false, false);
			break;
		case "otherMethod":
			$status = "provisional";
			$status_result = "Please hold this reservation on a provisional basis only and advise us (by return email) the date on which this reservation status should be confirmed.";
			db_rv_reservation_set_status($wizResId,20, false, false, false);
			break;
		}

		$note = $GLOBALS['lDB']->get("SELECT rv_note_general FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
		$note .= "\n" . $_POST['paymentData'];
		db_rv_note_insert($wizResId,false,false,$note,false,false);
	}
}

//Get back the data for display
$resData = $GLOBALS['lDB']->get("
	SELECT
		rv_res_name,
		rv_agent_id,
		rv_corr_persona_id,
		rv_note_general,
		rv_note_guests,
		rv_agent_ref,
		rt_rate_type_id
	FROM
		rv_reservation
	WHERE
		rv_reservation_ix = '$wizResId'
",1);
$rt_rate_type_id = $resData['rt_rate_type_id'];
$rv_corr_persona_id = $resData['rv_corr_persona_id'];
$GLOBALS['temp']['rv_res_id'] = (string) $wizResId;
$GLOBALS['temp']['rv_res_name'] = t_encodeHTMLField($resData[0]);
$GLOBALS['temp']['rv_agent_ref'] = t_encodeHTMLField($resData['rv_agent_ref']);
$GLOBALS['temp']['hideNote'] = "";
$GLOBALS['temp']['rv_note_general'] = t_encodeOverlib($resData[3]);
if ($GLOBALS['temp']['rv_note_general'] != "") {
	$GLOBALS['temp']['rv_note_general'] .= t_encodeOverlib("\n");
}
$GLOBALS['temp']['rv_note_general'] .= t_encodeOverlib($resData[4]);
if (trim($GLOBALS['temp']['rv_note_general']) == "") {
	$GLOBALS['temp']['hideNote'] = " style=\"display:none\"";
}
global $publicData;
if ($_SESSION['userStatusId'] > 0) {
	$publicData = false;
	noZero($GLOBALS['temp']['agent_name'],$GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$resData[1]'",4));
	$contact = $GLOBALS['lDB']->get("SELECT pr_name_first,pr_name_last,pr_email FROM pr_persona WHERE pr_persona_ix = '$resData[2]'",1);
	$GLOBALS['temp']['first_name'] = t_encodeHTMLField($contact[0]);
	$GLOBALS['temp']['last_name'] = t_encodeHTMLField($contact[1]);
	$GLOBALS['temp']['email'] = t_encodeHTMLField($contact[2]);
	if ($_SESSION['userStatusId'] < 2) {
		if (isset($_POST['pr_email'])) {
			$GLOBALS['temp']['email'] = t_encodeHTMLField($_POST['pr_email']);
		}
	}
} else {
	$publicData = array();
	$publicData['agent_name'] = isset($_POST['agent_name'])?$_POST['agent_name']:"";
	$publicData['pr_name_first'] = "";//$_POST['pr_name_first'];
	$publicData['pr_name_last'] = isset($_POST['pr_contact_name']) ? $_POST['pr_contact_name'] : "";
	$publicData['pr_email'] = isset($_POST['pr_email']) ? $_POST['pr_email'] : "";

	$publicData['telephone'] = isset($_POST['contact_telephone']) ? $_POST['contact_telephone'] : "";
	$publicData['fax'] = isset($_POST['contact_fax']) ? $_POST['contact_fax'] : "";
	$publicData['post1'] = isset($_POST['pr_corr_addr_line1']) ? $_POST['pr_corr_addr_line1'] : "";
	$publicData['post2'] = isset($_POST['pr_corr_addr_line2']) ? $_POST['pr_corr_addr_line2'] : "";
	$publicData['postcode'] = isset($_POST['pr_corr_post_code']) ? $_POST['pr_corr_post_code'] : "";

	noZero($GLOBALS['temp']['agent_name'],$publicData['agent_name']);
	$GLOBALS['temp']['first_name'] = t_encodeHTMLField($publicData['pr_name_first']);
	$GLOBALS['temp']['last_name'] = t_encodeHTMLField($publicData['pr_name_last']);
	$GLOBALS['temp']['email'] = t_encodeHTMLField($publicData['pr_email']);
}
$GLOBALS['temp']['agent_name'] = t_encodeHTMLField($GLOBALS['temp']['agent_name']);
$GLOBALS['temp']['status'] = $status;
$GLOBALS['temp']['status_result'] = $status_result;

// Start itinerary display
$GLOBALS['temp']['resCurr'] = "";
$GLOBALS['temp']['itinTotal'] = "";
$GLOBALS['temp']['itinComm'] = "";
$GLOBALS['temp']['commText'] = "Commission";
$GLOBALS['temp']['itinFinal'] = "";

if ($wizResId != "") {
	$GLOBALS['temp']['rows'] = "";
	if (!$GLOBALS['lDB']->count("rv_reservation_item","rv_reservation_id",$wizResId,0)) {
		$reservationId = $wizResId;
		$list = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$reservationId' ORDER BY rv_item_date_arrive, ac_accomm_type_id",3);
		$rowHTML = join("",file(__DIR__ . "/../../../public/html/cal_res_item_rows.htm"));
		$resData = $GLOBALS['lDB']->get("
			SELECT
				rt_rate_type.rt_rate_type_desc,
				rf_currency.rf_currency_symbol,
				rv_reservation.rv_invoice_currency_id
			FROM
				rv_reservation
				LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
			WHERE
			rv_reservation_ix = '$reservationId'
		",1);

		$rf_currency_symbol = $resData['rf_currency_symbol'];

		if(!isset($GLOBALS['temp']['rateDesc']) || $GLOBALS['temp']['rateDesc'] == "") {
			$GLOBALS['temp']['rateDesc'] = $resData['rt_rate_type_desc'];
		}
		if(!isset($GLOBALS['temp']['resCurr']) || $GLOBALS['temp']['resCurr'] == "") {
			$GLOBALS['temp']['resCurr'] = $resData['rf_currency_symbol'];
		}
		if(!isset($GLOBALS['temp']['resCurrId']) || $GLOBALS['temp']['resCurrId'] == "") {
			$GLOBALS['temp']['resCurrId'] = $resData['rv_invoice_currency_id'];
		}

		$imax = sizeof($list);
		$itemOut = "";
		for ($i=0;$i<$imax;$i++) {
			$itemId = $list[$i];
			$resItem = getItemDetails($itemId);
			$resItem['total'] = getDisplayItemTotal($itemId);
			$resItem['rf_currency_symbol'] = $resItem['itemCurr'] = $rf_currency_symbol;
			if ($resItem['total'] == "TBA") {
				$resItem['rf_currency_symbol'] = $resItem['itemCurr'] = "";
			}
			$resItem['arrive'] = chng_date($resItem['rv_item_date_arrive'],"-");
			$resItem['depart'] = chng_date($resItem['rv_item_date_depart'],"-");
			$resItem['id'] = $itemId;
			$resItem['hideCompButton'] = "";
			if (checkJob($GLOBALS['job'],2) < 15) {
				$resItem['hideCompButton'] = " style=\"visibility:hidden\"";
			}
			$resItem['hideDelButton'] = "";
			if ($imax == "1") {
				$resItem['hideDelButton'] = " style=\"visibility:hidden\"";
			}
			# Test to see whether this item's component(s) have been modified
			$result = $GLOBALS['lDB']->get("SELECT rv_item_comp_edit_yn FROM rv_res_item_comp WHERE rv_item_comp_edit_yn='1' AND rv_reservation_item_id = '" . $resItem['id'] . "'",4);
			if($result >= "1") {
				$resItem['rowClass'] = "txtbr";
			} else {
				$resItem['rowClass'] = "txt";
			}
			$resItem['discount'] = "";

			$resItem['pr_name_last'] = t_encodeHTMLField($resItem['pr_name_last']);
			$resItem['ac_accomm_desc'] = t_encodeHTMLField($resItem['ac_accomm_desc']);
			$resItem['invoice_currency'] = t_encodeHTMLField($resItem['invoice_currency']);
			$resItem['rf_currency_symbol'] = t_encodeHTMLField($resItem['rf_currency_symbol']);
			$itemOut .= showpage($resItem,$rowHTML);
		}

		$GLOBALS['temp']['isItinerary'] = "0";
		if ($itemOut != "") {
			$GLOBALS['temp']['isItinerary'] = "1";
			$GLOBALS['temp']['rows'] .= $itemOut;
		}
	}
	if ($GLOBALS['temp']['rows'] == "") {
		$GLOBALS['temp']['rows'] = "<tr><td colspan='12' class='form10' align='center'>No Items found.</td></tr>";
	}
}
if ($GLOBALS['temp']['rows'] == "") {
	$GLOBALS['temp']['rows'] = "<tr><td colspan='12' class='form10' align='center'>No Items found.</td></tr>";
}

// Totals Display
$data = getResDocTotals($wizResId,"","","",1);
$GLOBALS['temp']['itinTotal'] = $data['acc_gross'];
$GLOBALS['temp']['itinComm'] = $data['acc_comm'];
if ($GLOBALS['temp']['itinComm'] < 0) {
	$GLOBALS['temp']['commText'] = "Less Commission";
}
$GLOBALS['temp']['itinFinal'] = getDisplayAccommTotal($wizResId);
// End itinerary display

$extraList = $GLOBALS['lDB']->get("
	SELECT
		rv_extra.rv_extra_ix as id,
		rv_extra.rv_extra_date_serv,
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last,
		ac_extra.ac_extra_ix,
		ac_extra.ac_ext_desc,
		ac_extra_category.ac_extra_cat_desc,
		ac_extra_category.ac_extra_cat_ind,
		rv_extra.rv_extra_units,
		rv_extra.rv_extra_charge,
		rv_extra.rv_extra_tax_perc,
		rv_extra.rf_currency_id as extra_currency_id,
		from_currency.rf_currency_symbol as extra_currency_symbol,
		rv_extra.rv_extra_inv_curr_id as folio_currency_id,
		to_currency.rf_currency_symbol as folio_currency_symbol,
		rv_extra.rv_extra_exch_rate,
		rv_extra.rv_extra_exch_expiry,
		rv_extra.rv_extra_discount,
		rv_extra.rv_extra_comm_rec,
		rv_extra.rv_extra_comm_pay,
		rv_extra_note,
		rv_extra_note_internal,
		invoice_persona.pr_name_last as invoice_name_last,
		invoice_persona.pr_name_first as invoice_name_first,
		rv_res_item_group.rv_res_item_group_ix,
		ac_accomm_room.ac_desc,
		rv_extra.fn_folio_id,
		fn_folio.fn_folio_folio_num,
		rv_extra.pr_business_id
	FROM
		rv_extra
		INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
		INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
		LEFT JOIN rf_currency AS from_currency ON from_currency.rf_currency_ix = rv_extra.rf_currency_id
		LEFT JOIN rf_currency AS to_currency ON to_currency.rf_currency_ix = rv_extra.rv_extra_inv_curr_id
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
		LEFT JOIN pr_persona AS invoice_persona ON invoice_persona.pr_persona_ix = fn_folio.fn_folio_to_id
	WHERE
		rv_extra.rv_reservation_id = '$record'
",2);

$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/cal_res_extra_rows_step3.htm"));
$rows = "";
foreach($extraList as $item) {
	$guestList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_last
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_guest.rv_res_item_group_id = '" . $item['rv_res_item_group_ix'] . "'
	",2);
	$roomInfo = trim($item['ac_desc']);
	$guestNames = "";
	foreach($guestList as $guestItem) {
		if($guestNames != "") {
			$guestNames .= ", ";
		}
		$guestNames .= trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
	}
	if($roomInfo != "" && $guestNames != "") {
		$roomInfo .= ": ";
	}
	if($guestNames != "") {
		$roomInfo .= $guestNames;
	}
	$item['roomInfo'] = $roomInfo;
	if($item['rv_extra_date_serv'] == "0000-00-00") {
		$item['rv_extra_date_serv_fmt'] = "&nbsp;";
	} else {
		$item['rv_extra_date_serv_fmt'] = chng_date($item['rv_extra_date_serv'],"-",4);
	}
	if(trim($item['pr_name_last']) == "") {
		$item['pr_name_last'] = "&nbsp;";
	}
	if(trim($item['ac_desc']) == "") {
		$item['ac_desc'] = "&nbsp;";
	}

	switch($item['ac_extra_cat_ind']) {
	case DB_AC_EXTRA_CAT_GENERAL:
		$ac_extra_cat_type = "<i class='material-icons'>collections</i>&nbsp;General";
		break;
	case DB_AC_EXTRA_CAT_ACTIVITY:
		$ac_extra_cat_type = "<i class='material-icons'>photo_camera</i>&nbsp;Activity";
		break;
	case DB_AC_EXTRA_CAT_TRAVEL:
		$ac_extra_cat_type = "<i class='/material-icons/'>flight</i>&nbsp;Travel";
		$ac_extra_cat_img = "icon_travel.gif";
		break;
	case DB_AC_EXTRA_CAT_ACCOMMODATION:
		$ac_extra_cat_type = "<i class='/material-icons/'>pin_drop</i>&nbsp;Accommodation";
		$extra_desc = "Prop/Accom descrip";
		break;
	}

	$item['ac_extra_cat_type'] = $ac_extra_cat_type;

	$item['from_total'] = $item['rv_extra_units'] * $item['rv_extra_charge'];
	$item['to_total'] = $item['from_total'] * $item['rv_extra_exch_rate'];
	fixAmtDisplay($item['rv_extra_charge'],2);
	fixAmtDisplay($item['from_total'],2);
	fixAmtDisplay($item['to_total'],2);
	$item['rv_extra_charge'] .= " " . $item['extra_currency_symbol'];
	$item['from_total'] .= " " . $item['extra_currency_symbol'];
	$item['to_total'] .= " " . $item['folio_currency_symbol'];
	fixAmtDisplay($item['rv_extra_discount'],2);
	fixAmtDisplay($item['rv_extra_comm_rec'],2);
	fixAmtDisplay($item['rv_extra_comm_pay'],2);
	fixAmtDisplay($item['rv_extra_tax_perc'],2);
	if(trim($item['rv_extra_note']) == "") {
		$item['showNote'] = "style=\"display:none\"";
		$item['replaceNote'] = "&nbsp;";
	} else {
		$item['rv_extra_note_fmt'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($item['rv_extra_note'])));
		$item['rv_extra_note'] = $item['rv_extra_note'];
		$item['showNote'] = "";
		$item['replaceNote'] = "";
	}
	if(trim($item['rv_extra_note_internal']) == "" || $_SESSION['userStatusId'] < 2) {
		$item['rv_extra_note_internal'] = "";
		$item['showMemo'] = "style=\"display:none\"";
		$item['replaceMemo'] = "&nbsp;";
	} else {
		$item['rv_extra_note_internal_fmt'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($item['rv_extra_note_internal'])));
		$item['rv_extra_note_internal'] = $item['rv_extra_note_internal'];
		$item['showMemo'] = "";
		$item['replaceMemo'] = "";
	}
	$invoiceName = "";
	if($item['invoice_name_first'] != "") {
		$invoiceName .= $item['invoice_name_first'];
	}
	if($item['invoice_name_last'] != "") {
		if($invoiceName != "") {
			$invoiceName .= " ";
		}
		$invoiceName .= $item['invoice_name_last'];
	}
	if(trim($invoiceName) == "") {
		$invoiceName = "Cash";
	}
	$item['invoiceName'] = t_encodeHTMLField($invoiceName);

	$item['ac_ext_desc'] = t_encodeHTMLField($item['ac_ext_desc']);
	$item['ac_extra_cat_desc'] = t_encodeHTMLField($item['ac_extra_cat_desc']);
	$item['pr_name_last'] = t_encodeHTMLField($item['pr_name_last']);
	$rows .= showpage($item,$rowHTML);
}

$GLOBALS['temp']['eRows'] = $rows;
if($rows == "") {
	$GLOBALS['temp']['eRows'] = "<tr><td colspan=\"18\" height=\"25\">No Extras</td></tr>";
}

$GLOBALS['temp']['editstyle'] = " style=\"visibility:hidden\"";
if (checkjob(0)) {
	$GLOBALS['temp']['editstyle'] = "";
	$GLOBALS['temp']['editjob'] = "0";
	$GLOBALS['temp']['edit_view_label'] = "View";
}
if (checkjob(2)) {
	$GLOBALS['temp']['editstyle'] = "";
	$GLOBALS['temp']['editjob'] = "2";
	$GLOBALS['temp']['edit_view_label'] = "Edit";
}
session_set(array(
	'publicData'=>$publicData,
	'wizResId'=>$wizResId
));

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"0\">\n";

// check for internal / external here
$emailed = false;
$_POST['externalPayment'] = isset($_POST['externalPayment']) ? $_POST['externalPayment'] : "";
if ( $userStatusId < 2 && $_POST['externalPayment'] != "1" && $dbcode[0] == "W") {
	$emailPersona = $GLOBALS['lDB']->get("SELECT rv_corr_persona_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
	$emailAddress = $GLOBALS['lDB']->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$emailPersona'",4);

	if (isset($_POST['pr_email']) && trim($_POST['pr_email']) != "") {
		$emailAddress = $_POST['pr_email'];
	} elseif(trim($_SESSION['extWizContact']['pr_email']) != "") {
		$emailAddress = $_SESSION['extWizContact']['pr_email'];
	}

	$GLOBALS['temp']['emailUser'] = "
		<iframe name=\"emailFrame\" src=\"wait.htm\" style=\"display:none\">
		</iframe>
		<form id=\"emailForm\" method=\"post\" action=\"reservation.php?642+$wizResId+5\" TARGET=\"emailFrame\">
			<input type=\"hidden\" name=\"mail_to\" value=\"$emailAddress\">
		</form>
		<script language=\"javascript\">
			id('emailForm').submit();
		</script>
	";
	$GLOBALS['temp']['emailText'] = "
		Your reservation request has been submitted. A copy of your request has been emailed to you for your records.<br>
		Should you not receive a response from us within one working day, please resubmit or let us know.<br>
		We recommend that, for your records, you print or email a copy of your request by clicking on the documentation button below.
	";
	$emailed = true;
} else {
	$GLOBALS['temp']['emailUser'] = "";
	$GLOBALS['temp']['emailText'] = "";
}

if(empty($_POST['paymentGateway'])) {
	// Audit trails
	$reservation = $GLOBALS['lDB']->get("
		SELECT
			rv_note_guests,
			rf_country_id
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$record'
	", 1);
	$reservationAuditTrail = new AuditTrail($wizResId,TYPE_RESERVATION);
	$reservationAuditTrail->addDetail(
		Null,
		$reservation['rv_note_guests'],
		Null,
		Null,
		DB_AD_RES_DETAIL_ACTION_ADD,
		"resnote",
		"rv_note.rv_note_guests"
	);
	$reservationAuditTrail->addDetail(
		Null,
		$_POST['rf_country_id'],
		Null,
		Null,
		DB_AD_RES_DETAIL_ACTION_ADD,
		"resnote",
		"rv_reservation.rf_country_id"
	);
	$reservationAuditTrail->save("Reservation Create - Guest Information");
}

if(isset($_POST['paymentAction']) && $_POST['paymentAction'] == "success") {
	$resOffTel = $GLOBALS['lDB']->get("
		SELECT 
			pr_phone.pr_phone_number 
		FROM 
			rf_default
			INNER JOIN pr_phone ON rf_default.rf_res_office_id = pr_phone.pr_persona_id
		ORDER BY
			pr_phone.pr_default_yn DESC
	",4);
	if(empty($resOffTel)) {
		$resOffTel = "None";
	}

	$resOffEmail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_email
		FROM
			rf_default
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rf_default.rf_res_office_id
	",4);
	if(empty($resOffEmail)) {
		$resOffEmail = "None";
	}

	$GLOBALS['temp']['message'] = "Thank you. Your payment has been processed.<br /><br />Your reservation <b>".$GLOBALS['temp']['rv_res_name']." (your reference: ".$GLOBALS['temp']['rv_res_id'].")</b> has been sent to our central reservations office".($emailed?" and a copy has been emailed to you":"").".<br /><br />Please contact our offices by telephone $resOffTel or <span class=\"link\" onclick=\"openPopup('email_form.php?email_address=$resOffEmail&email_subject=ResRequest Enquiry',595,363)\">$resOffEmail</span> should you require more information.<br /><br />".($emailed?"Should you not receive a response from us within one working day, please contact us on the above contact details.<br /><br />":"")."To print or email additional copies of your booking summary, click on the Documentation button at the bottom of this confirmation screen.<br /><br />";
} else { 
	$GLOBALS['temp']['message'] = "Your reservation \"<b>".$GLOBALS['temp']['rv_res_name']."</b>\" with reservation reference number: <b>".$GLOBALS['temp']['rv_res_id']."</b> will be submitted to our reservation office.<br /><br />
		We will revert to you per your request to:<br /> ".$GLOBALS['temp']['status_result']."<br /><br />".$GLOBALS['temp']['emailText'];
}

if(isset($_POST['menuAction']) && $_POST['menuAction'] != "") {
	$GLOBALS[$form]->FormHTML = str_replace("<body","<script>".stripslashes($_POST['menuAction'])."</script><body",$GLOBALS[$form]->FormHTML);
}

$GLOBALS['lDB']->isMaster = $tempMasterData;

$GLOBALS['temp']['resDetailJob'] = "";
$GLOBALS['temp']['resExtraJob'] = "";
if (canEditReservation($wizResId)) {
	$GLOBALS['temp']['resDetailJob'] = "2";
	$GLOBALS['temp']['resExtraJob'] = "610";
} else {
	$GLOBALS['temp']['resDetailJob'] = "0";
	$GLOBALS['temp']['resExtraJob'] = "609";
}

if(canEditReservation($wizResId) && array_key_exists(137,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][137] > 5) {
	$GLOBALS['temp']['resNoteJob'] = "137";
} else {
	$GLOBALS['temp']['resNoteJob'] = "138";
}
$GLOBALS['temp']['showNotesTab'] = "expand";
if(empty($GLOBALS['jobLevelArray'][138])) {
	$GLOBALS['temp']['showNotesTab'] = "collapse printCollapse";
}

if(canEditReservation($wizResId) && array_key_exists(216,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][216] > 5) {
	$GLOBALS['temp']['resRoomJob'] = "216";
} else {
	$GLOBALS['temp']['resRoomJob'] = "215";
}
$GLOBALS['temp']['showRoomingTab'] = "expand";
if(empty($GLOBALS['jobLevelArray'][215])) {
	$GLOBALS['temp']['showRoomingTab'] = "collapse printCollapse";
}

if(canEditReservation($wizResId) && array_key_exists(647,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][647] > 5) {
	$GLOBALS['temp']['resFinancialJob'] = "647";
} else {
	$GLOBALS['temp']['resFinancialJob'] = "646";
}
$GLOBALS['temp']['showFinancialTab'] = "expand";
if(empty($GLOBALS['jobLevelArray'][646])) {
	$GLOBALS['temp']['showFinancialTab'] = "collapse printCollapse";
}

if(isset($_POST['externalPayment']) && $_POST['externalPayment'] == "1") {
	if ($userStatusId == "0") {
		if(isset($_SESSION['wizResContact']) && is_array($_SESSION['wizResContact'])) {
			$wizResContact = $_SESSION['wizResContact'];
		} else {
			$wizResContact = array();
		}
		$wizResContact[$wizResId] = array(
			'first_name'=>$_POST['pr_contact_name_first'],
			'last_name'=>$_POST['pr_contact_name_last'],
			'email'=>$_POST['pr_email'],
			'phone'=>$_POST['contact_telephone'],
			'address'=>$_POST['pr_corr_addr_line1'],
			'city'=>$_POST['pr_corr_addr_line2'],
			'code'=>$_POST['pr_corr_post_code']
		);
		session_set("wizResContact",$wizResContact);
	}
	$pg_accounts = loadPaymentGateway();
	initPaymentGateway($pg_accounts);
}
//finalisePaymentGateway();

addLastRes($wizResId);
unsetWizResId($wizResId);

$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];

if(isset($_SESSION['calendarParms']) && isset($_SESSION['calendarParms'][4])) {
	$checkAgent = $GLOBALS['lDB']->get("SELECT COUNT(pr_agent_id) FROM pr_agent WHERE pr_agent_id = '".$_SESSION['calendarParms'][4]."'",4);
	if($checkAgent < 1) {
		$_SESSION['calendarParms'][4] = null;
		$_SESSION['calendarParms'][5] = null;
		$_SESSION['calendarParms'][6] = null;
		session_set("calendarParms",$_SESSION['calendarParms']);
	}
}

global $principal_id;
global $domain;
$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";

if ($userStatusId == "0") {
	$GLOBALS['temp']['detailsButtonClass'] = "collapse printCollapse";
	$GLOBALS['temp']['detailsAreaClass'] = "collapse printCollapse";
	$GLOBALS['temp']['detailsSpaceClass'] = "collapse printCollapse";
} else {
	$GLOBALS['temp']['detailsButtonClass'] = "expand";
	$GLOBALS['temp']['detailsAreaClass'] = "collapse";
	$GLOBALS['temp']['detailsSpaceClass'] = "colLt";
}
if ($userStatusId == "0") {            // Accessed from public imageset
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/cal_step3_payInfoEXT.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file($GLOBALS['images_dir_on_disk']."/$principal_id/cal_step3_payInfoEXT.htm")));
	}
	if (file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/template_restructure_reservation_calendar.js")) {
		$GLOBALS['temp']['customHTML'] .= '<script>'
			. join("",file($GLOBALS['images_dir_on_disk']."/$principal_id/template_restructure_calendar_step_three.js"))
			. '</script>';
	}
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/cal_step3_payInfoEXT.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />";
		$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/cal_step3_payInfoEXT.css\" type=\"text/css\" />";
	} elseif(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-cal_step3.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/template-cal_step3.css\" type=\"text/css\" />";
		$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/shared/global.css\" type=\"text/css\">";
	} else {
		$indexCSS = "<link rel=\"stylesheet\" href=\"styles/cal_step3_payInfoEXT.css\" type=\"text/css\" />";
	}
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/uikit.min.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/uikit.min.css\" type=\"text/css\" />";
		$indexHTML = "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit.min.js"));
		$indexHTML .= "</script>";
		$indexHTML .= "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit_image_height.js"));
		$indexHTML .= "</script>";
		$indexHTML .= "<script>";
		$indexHTML .= join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/uikit-icons.min.js"));
		$indexHTML .= "</script>";
		$GLOBALS['temp']['customHTML'] .= $indexHTML;
	} elseif(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-cal_step3.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/ui-kit/uikit.min.css\" />";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js\"></script>\n";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js\"></script>\n";
	} else {
		$uikitCSS = "";
	}
	$custom = "";
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/custom.css")) {
		$custom = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/custom.css\" type=\"text/css\">";
	}
	$GLOBALS['temp']['customDefaultCSS'] = "
	";

	$GLOBALS['temp']['customCSS'] = "
		$uikitCSS
		$indexCSS
		$custom
	";

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Don't include anything extra if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customDefaultCSS'] = "
			<style>
				body {
					background-color: transparent !important;
				}
			</style>
		";
		$GLOBALS['temp']['customCSS'] = "";
		redirectTo("/public/reservation_calendar_pay_confirmation.php", $GLOBALS['temp'], true);
	}
} else {
	$GLOBALS['temp']['customDefaultCSS'] = "";
}

// Block booking details
$blockDetails = $GLOBALS['lDB']->get("
	SELECT
		bl_block.bl_block_ix,
		bl_block.bl_block_name
	FROM
		bl_block
		INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
		LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
		LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
		LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
	WHERE
		draw_down_item.rv_reservation_id = '$record'
",1);
if (!empty($blockDetails)) {
	$GLOBALS['temp']['blockDetails'] = $blockDetails['bl_block_name'] . " (" . $blockDetails['bl_block_ix'] . ")";
	$GLOBALS['temp']['bl_block_ix'] = $blockDetails['bl_block_ix'];
	$GLOBALS['temp']['step1Description'] = 'Step 1: Block';
	$GLOBALS['temp']['hideBlock'] = "";
	$GLOBALS['temp']['returnButtonsTableWidth'] = "242";
} else {
	$GLOBALS['temp']['blockDetails'] = '';
	$GLOBALS['temp']['step1Description'] = 'Step 1: Calendar';
	$GLOBALS['temp']['hideBlock'] = " style=\"display:none\"";
	$GLOBALS['temp']['returnButtonsTableWidth'] = "102";
}
