<?php

/**
 * init.form214.php - Booking wizard step 2 background iframe updater
 * Job: 641
 * Functon: 50 (Availability calendar)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

$mode = $_SERVER['argv'][1];
$extraId = $_SERVER['argv'][2]; // contact id for contact update iframe

// for contact update iframe
$resName = addslashes(urlDecode($_SERVER['argv'][3]));
$sourceId = $_SERVER['argv'][4];
	
$resId = $GLOBALS['wizResId'];

// Ignore passed percentage, look up percentage from Tax Code Table
$taxId = $_POST['rf_tax_ind'] == 10 ? $_POST['rf_tax_rate'] : $_POST['rt_tax_group'];
$taxPerc = taxPercentage($taxId, $_POST['rf_tax_ind']);

if($mode == 1) { // add
	$extraId = db_rv_extra_insert($resId, $_POST['ac_extra_id'], $_POST['pr_business_id'], $_POST['rv_extra_units'], $_POST['rv_extra_date_serv'], $_POST['rv_extra_charge'], $_POST['rv_extra_discount'], $taxPerc,  $_POST['rv_extra_comm_rec'], $_POST['rv_extra_comm_pay'], $_POST['rv_extra_note'], $_POST['rv_extra_note_internal'], $_POST['rv_res_item_group_id'], $_POST['extra_currency_id'], $_POST['folio_currency_id'], $_POST['exchangeRate'], $_POST['rv_extra_exch_expiry'] , $_POST['folio_business_id'], $_POST['rv_extra_travel_eta'], $_POST['rv_extra_travel_etd'], $_POST['rv_extra_adult_count'], $_POST['rv_extra_child_count'], $_POST['rv_extra_date_depart'], $_POST['rv_extra_ref'], $_POST['rv_extra_supplier_conf_yn'], $_POST['pr_supplier_id']);
		
	if ($_POST['rf_tax_ind'] == 10) {
		db_rv_extra_tax_insert($extraId, $_POST['rf_tax_ind'], $_POST['rf_tax_rate']);
	} else if ($_POST['rf_tax_ind'] == 20) {
		db_rv_extra_tax_insert($extraId, $_POST['rf_tax_ind'], $_POST['rt_tax_group']);
	}
	verify_extra($extraId);
}

if($mode == 2) { // update
	db_rv_extra_update($extraId, $_POST['rv_extra_units'], $_POST['rv_extra_date_serv'], $_POST['rv_extra_charge'], $_POST['rv_extra_discount'], $taxPerc,  $_POST['rv_extra_comm_rec'], $_POST['rv_extra_comm_pay'], $_POST['rv_extra_note'], $_POST['rv_extra_note_internal'], $_POST['rv_res_item_group_id'], $_POST['extra_currency_id'], $_POST['folio_currency_id'], $_POST['exchangeRate'], $_POST['rv_extra_exch_expiry'], $_POST['folio_business_id'], "" /*$_POST['auditReason']*/, $_POST['rv_extra_travel_eta'], $_POST['rv_extra_travel_etd'], $_POST['rv_extra_adult_count'], $_POST['rv_extra_child_count'], $_POST['rv_extra_date_depart'],$_POST['rv_extra_ref'], $_POST['rv_extra_supplier_conf_yn'], $_POST['pr_supplier_id']);

	if ($_POST['rf_tax_ind'] == 10) {
		db_rv_extra_tax_insert($extraId, $_POST['rf_tax_ind'], $_POST['rf_tax_rate']);
	} else if ($_POST['rf_tax_ind'] == 20) {
		db_rv_extra_tax_insert($extraId, $_POST['rf_tax_ind'], $_POST['rt_tax_group']);
	}
}

if($mode == 1 || $mode == 2) { // on add or update, check folio
	if($_POST['fn_folio_id'] == "" || $_POST['fn_folio_id'] == "1") {
		$folioId = db_fn_folio_insert_extra($extraId, $_POST['fn_folio_group_id'],$_POST['fn_folio_to_id'], true);
	} else {
		$folioId = $_POST['fn_folio_id'];
	}
	if($folioId != "2") { // No folio (zero cost extra)
		db_rv_extra_set_folio($extraId, $folioId);
	}

	// Insert an exchange rate if one was used and doesn't exist
	db_rf_exchange_rate_set($_POST['extra_currency_id'],$_POST['folio_currency_id'],$_POST['exchangeRate']);
	// End exchange update
}

if($mode == 4) { // delete
	$extraList = explode(":",$_POST['extraDelete']);
	foreach($extraList as $item) {
		db_rv_extra_delete($item);
	}
}
if($mode == 5) { // set contact
	//$contactId = $extraId;
	$GLOBALS['lDB']->put("
		UPDATE rv_reservation SET
			rv_corr_persona_id = '".$lDB->escape($_POST['rv_corr_persona_id'])."',
				rv_billing_persona_id = '".$lDB->escape($_POST['rv_corr_persona_id'])."',
			rv_invoice_persona_id = '".$lDB->escape($_POST['rv_corr_persona_id'])."',
			rv_res_name = '".$lDB->escape($_POST['rv_res_name'])."',
			rf_source_ix = '".$lDB->escape($_POST['rf_source_ix'])."',
			rv_agent_ref = '".$lDB->escape($_POST['rv_agent_ref'])."',
			rv_origin_agent_id = '".$lDB->escape($_POST['rv_origin_agent_id'])."'
		WHERE rv_reservation.rv_reservation_ix = '$resId'
	");
	echo "<script language=\"javascript\">parent.location = parent.location;</script>";
	die();
}

$out = "
	<script language=\"javascript\">
		var extraDetails = [];
	</script>		
	<table width=\"2070\" cellspacing=\"0\" align=\"center\" style=\"table-layout:fixed;\">
	<col width=\"25\">
	<col width=\"145\">
	<col width=\"130\">
	<col width=\"100\">
	<col width=\"120\">
	<col width=\"100\">
	<col width=\"150\">
	<col width=\"63\" />
	<col width=\"63\" />
	<col width=\"134\" />
	<col width=\"140\" />
	<col width=\"40\">
	<col width=\"105\">
	<col width=\"65\">
	<col width=\"105\">
	<col width=\"105\">
	<col width=\"50\">
	<col width=\"50\">
	<col width=\"50\">
	<col width=\"50\">
	<col width=\"100\">
	<col width=\"100\">
	<col width=\"40\">
	<col width=\"40\">
	<tr>
		<td class=\"outLt\" height=\"20\" rowspan=\"2\">!deleteButton!</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">Date</td>
		<td class=\"outLt\" rowspan=\"2\">Internal property</td>
		<td class=\"outLt\" rowspan=\"2\">Type</td>
		<td class=\"outLt\" rowspan=\"2\">Category</td>
		<td class=\"outLt\" rowspan=\"2\">Room</td>
		<td class=\"outLt\" rowspan=\"2\">Extra</td>
		<td class=\"outLt\" rowspan=\"2\">ETD</td>
		<td class=\"outLt\" rowspan=\"2\">ETA</td>
		<td class=\"outLt\" rowspan=\"2\">Service By</td>
		<td class=\"outLt\" rowspan=\"2\" >Reference</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">Qty</td>
		<td class=\"outLt\" align=\"right\" rowspan=\"2\">Charge<br>Amt</td>
		<td class=\"outLt\" align=\"right\" rowspan=\"2\">Exch</td>
		<td class=\"outLt\" height=\"20\" align=\"center\" colspan=\"3\">Unit Price</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">Disc</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">Comm rec</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">Comm pay</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">Invoice to</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">POS</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">Note</td>
		<td class=\"outLt\" align=\"center\" rowspan=\"2\">Int<br>Memo </td>
	</tr>
	<tr>
		<td class=\"outLt\" align=\"right\" height=\"15\">Total</td>
		<td class=\"outLt\" align=\"right\">Amt</td>
		<td class=\"outLt\" align=\"right\">Tax rate</td>
	</tr>
";

$extraList = $GLOBALS['lDB']->get("
	SELECT
		rv_extra.rv_extra_ix as id,
		rv_extra.rv_extra_date_serv,
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last,
		ac_extra.ac_extra_ix,
		ac_extra.ac_ext_desc,
		ac_extra_category.ac_extra_cat_desc,
		ac_extra_category.ac_extra_cat_ind,
		rv_extra.rv_extra_units,
		rv_extra.rv_extra_travel_eta,
		rv_extra.rv_extra_travel_etd,
		rv_extra.rv_extra_adult_count,
		rv_extra.rv_extra_child_count,
		rv_extra.rv_extra_nights,
		rv_extra.rv_extra_date_depart,
		rv_extra.rv_extra_supplier_conf_yn,
		rv_extra.pr_supplier_id,
		rv_extra.rv_extra_ref,
		CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name,
		rv_extra.rv_extra_charge,
		rv_extra.rv_extra_tax_perc,
		rv_extra.rf_tax_id,
		rv_extra.rv_extra_tax_ind,
		rv_extra.rf_currency_id as extra_currency_id,
		from_currency.rf_currency_symbol as extra_currency_symbol,
		rv_extra.rv_extra_inv_curr_id as folio_currency_id,
		to_currency.rf_currency_symbol as folio_currency_symbol,
		rv_extra.rv_extra_exch_rate,
		rv_extra.rv_extra_exch_expiry,
		rv_extra.rv_extra_discount,
		rv_extra.rv_extra_comm_rec,
		rv_extra.rv_extra_comm_pay,
		rv_extra.rv_extra_amt_payable,
		rv_extra_note,
		rv_extra_note_internal,
		invoice_persona.pr_name_last as invoice_name_last,
		invoice_persona.pr_name_first as invoice_name_first,
		rv_res_item_group.rv_res_item_group_ix,
		ac_accomm_room.ac_desc,
		rv_extra.fn_folio_id,
		fn_folio.fn_folio_folio_num,
		rv_extra.pr_business_id
	FROM
		rv_extra
		INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
		INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
		LEFT JOIN rf_currency AS from_currency ON from_currency.rf_currency_ix = rv_extra.rf_currency_id
		LEFT JOIN rf_currency AS to_currency ON to_currency.rf_currency_ix = rv_extra.rv_extra_inv_curr_id
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
		LEFT JOIN pr_persona AS invoice_persona ON invoice_persona.pr_persona_ix = fn_folio.fn_folio_to_id
		LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id
	WHERE
		rv_extra.rv_reservation_id = '$resId'
	ORDER BY
		rv_extra.rv_extra_date_serv DESC
		",2);

foreach ($extraList as $key => $extra) {
	// Find the billing entity for each extra
	$businessId = "";
	$currId = $extra['pr_business_id'];
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		if(!$GLOBALS['isPropServer']) {
			$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		} else {
			$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($billingYN == "1") {
			$businessId = $currId;
		} else {
			$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
	}
	$extraList[$key]['billing_entity_id'] = $businessId;
}

if(sizeof($extraList) > 0) {
	$deleteButton = "<input type=button style=\"width:18; height:20; background-position: center;\" class=\"button bDelete\" onclick=\"deleteExtras();\">";
} else {
	$deleteButton = "&nbsp;";
}
$out = str_replace("!deleteButton!",$deleteButton,$out);
$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/reservation_extras_rows.htm"));
foreach($extraList as $item) {
	if(!empty($item['pr_supplier_id'])) {
		$item['supplier_image'] = "
			<button onmouseout='nd()' align='right' style=\"width:20;height:20;\"  onmouseover=\"overlib('Show supplier information',BELOW,OFFSETY,17,OFFSETX,-135,WIDTH,130)\" class='button ' onclick='event.cancelBubble = true;contactDet(\"".$item['pr_supplier_id']."\")'>
				<img src='/resource/Resrequest/Application/public/img/icon_contact_16.gif' valign='middle' class='imgLink' />
			</button>
		";
	} else {
		$item['supplier_image'] = "";
	}

	switch($item['ac_extra_cat_ind']) {
	case DB_AC_EXTRA_CAT_GENERAL:
		$ac_extra_cat_type = "<i class='material-icons'>collections</i>&nbsp;General";
		break;
	case DB_AC_EXTRA_CAT_ACTIVITY:
		$ac_extra_cat_type = "<i class='material-icons'>photo_camera</i>&nbsp;Activity";
		break;
	case DB_AC_EXTRA_CAT_TRAVEL:
		$ac_extra_cat_type = "<i class='material-icons'>flight</i>&nbsp;Travel";
		$ac_extra_cat_img = "icon_travel.gif";
		break;
	case DB_AC_EXTRA_CAT_ACCOMMODATION:
		$ac_extra_cat_type = "<i class='material-icons'>pin_drop</i>&nbsp;Accommodation";
		$extra_desc = "Prop/Accom descrip";
		break;
	}

	$item['ac_extra_cat_type'] = $ac_extra_cat_type;

	if(trim($item['rv_extra_travel_eta']) == "") {
		$item['rv_extra_travel_eta_fmt'] = "&nbsp;";
	} else {
		$item['rv_extra_travel_eta_fmt'] = t_encodeHTMLField($item['rv_extra_travel_eta']);
	}
	if(trim($item['rv_extra_travel_etd']) == "") {
		$item['rv_extra_travel_etd_fmt'] = "&nbsp;";
	} else {
		$item['rv_extra_travel_etd_fmt'] = t_encodeHTMLField($item['rv_extra_travel_etd']);
	}
	if(trim($item['rv_extra_ref']) == "") {
		$item['rv_extra_ref_fmt'] = "&nbsp;";
	} else {
		$item['rv_extra_ref_fmt'] = t_encodeHTMLField($item['rv_extra_ref']);
	}

	$item['allowEdit'] = "";
	$item['allowDelete'] = "";
	$item['textClass'] = "";
	$item['rowClass'] = "imgLink";

	$guestList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_last
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_guest.rv_res_item_group_id = '$item[rv_res_item_group_ix]'
	",2);
	$roomInfo = trim($item['ac_desc']);
	$guestNames = "";
	foreach($guestList as $guestItem) {
		if($guestNames != "") {
			$guestNames .= ", ";
		}
		$guestNames .= trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
	}
	if($roomInfo != "" && $guestNames != "") {
		$roomInfo .= ": ";
	}
	if($guestNames != "") {
		$roomInfo .= $guestNames;
	}
	$item['roomInfo'] = $roomInfo;
	
	if($item['ac_extra_cat_ind'] == DB_AC_EXTRA_CAT_ACCOMMODATION) {
		$dateDepartTS = strtotime($item['rv_extra_date_depart']);
		$dateArrivalTS = $dateDepartTS - (86400 * $item['rv_extra_nights']);
		$dateArrival = date("Y-m-d", $dateArrivalTS);
		$item['rv_extra_date_serv_fmt'] =  chng_date($dateArrival,"-",4). " to<br> ". chng_date($item['rv_extra_date_depart'],"-",4). " (".$item['rv_extra_nights']." nights)";
	} else {
		if($item['rv_extra_date_serv'] == "0000-00-00") {
			$item['rv_extra_date_serv_fmt'] = "&nbsp;";
		} else {
			$item['rv_extra_date_serv_fmt'] = chng_date($item['rv_extra_date_serv'],"-",4);
		}
	}

	$item['from_total'] = $item['rv_extra_units'] * $item['rv_extra_charge'];
//	$item['to_total'] = $item['from_total'] * $item['rv_extra_exch_rate'];
	$item['to_total'] = $item['rv_extra_amt_payable'];
	fixAmtDisplay($item['rv_extra_charge'],2);
	fixAmtDisplay($item['from_total'],2);
	fixAmtDisplay($item['to_total'],2);
	$item['rv_extra_charge'] .= " $item[extra_currency_symbol]";
	$item['from_total'] .= " $item[extra_currency_symbol]";
	$item['to_total'] .= " $item[folio_currency_symbol]";
	fixAmtDisplay($item['rv_extra_discount'],2);
	fixAmtDisplay($item['rv_extra_comm_rec'],2);
	fixAmtDisplay($item['rv_extra_comm_pay'],2);
	fixAmtDisplay($item['rv_extra_tax_perc'],2);

	// Notes and memos need to be HTML encoded twice due to how the decode happens in the browser
	if(trim($item['rv_extra_note']) == "") {
		$item['showNote'] = "display:none";
		$item['replaceNote'] = "&nbsp;";
		$item['rv_extra_note_fmt'] = "";
	} else {
		$item['rv_extra_note_fmt'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($item['rv_extra_note'])));
		$item['rv_extra_note'] = $item['rv_extra_note'];
		$item['showNote'] = "";
		$item['replaceNote'] = "";
	}
	if(trim($item['rv_extra_note_internal']) == "" || $_SESSION['userStatusId'] < 2) {
		$item['rv_extra_note_internal'] = "";
		$item['showMemo'] = "display:none";
		$item['replaceMemo'] = "&nbsp;";
		$item['rv_extra_note_internal_fmt'] = "";
	} else {
		$item['rv_extra_note_internal_fmt'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($item['rv_extra_note_internal'])));
		$item['rv_extra_note_internal'] = $item['rv_extra_note_internal'];
		$item['showMemo'] = "";
		$item['replaceMemo'] = "";
	}
	$invoiceName = "";
	if($item['invoice_name_first'] != "") {
		$invoiceName .= $item['invoice_name_first'];
	}
	if($item['invoice_name_last'] != "") {
		if($invoiceName != "") {
			$invoiceName .= " ";
		}
		$invoiceName .= $item['invoice_name_last'];
	}
	if(trim($invoiceName) == "") {
		$invoiceName = "Cash";
	}
	$invoiceNameRaw = $invoiceName;
	$invoiceName .= " (" . $item['fn_folio_folio_num'] . ")";
	$item['invoiceName'] = $invoiceName;
	$item['fn_folio_folio_num'] .= ": " . $invoiceNameRaw;
	if($item['extra_currency_id'] == "0" || trim($item['extra_currency_id']) == "") {
		$item['rv_extra_charge'] = "&nbsp;";
		$item['from_total'] = "&nbsp;";
		$item['to_total'] = "&nbsp;";
		$item['rv_extra_exch_rate'] = "&nbsp;";
		$item['invoiceName'] = "&nbsp;";
	}
	$item['ac_pos_name_rr'] = "&nbsp;";
	$item['rowBackgroundColor'] = '';
	$item['auditCells'] = "";

	$item['ac_ext_desc_js'] = t_encodeOverlib($item['ac_ext_desc']);
	$item['ac_extra_cat_desc_js'] = t_encodeOverlib($item['ac_extra_cat_desc']);
	$item['pr_name_last_js'] = t_encodeOverlib($item['pr_name_last']);
	$item['supplier_name_js'] = t_encodeOverlib($item['supplier_name']);

	$item['ac_ext_desc'] = t_encodeHTMLField($item['ac_ext_desc']);
	$item['ac_extra_cat_desc'] = t_encodeHTMLField($item['ac_extra_cat_desc']);
	$item['pr_name_last'] = t_encodeHTMLField($item['pr_name_last']);
	$item['supplier_name'] = t_encodeHTMLField($item['supplier_name']);

	if(trim($item['pr_name_last']) == "") {
		$item['pr_name_last'] = "&nbsp;";
	}
	if(trim($item['ac_desc']) == "") {
		$item['ac_desc'] = "&nbsp;";
	}

	$out .= showpage($item,$rowHTML);
}


$out .= "
	<tr>
		<td colspan=24 class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
	</tr>
	</table>
	<script language=\"javascript\">
		parent.extraDetails = extraDetails;
	</script>		
";
$exchangeList = db_rf_exchange_rate_get_all_rates();
foreach($exchangeList as $item) {
	$out .= "<INPUT type=\"hidden\" id=\"curr$item[rf_exch_curr_from_id]_$item[rf_exch_curr_to_id]\" value=\"$item[rf_exch_rate]\">\n";
}

/* repopulate folio list...  */
$folioList = $GLOBALS['lDB']->get("
	SELECT
		fn_folio_ix,
		fn_folio_folio_num,
		pr_invoice.pr_name_last as invoice_name_last,
		pr_invoice.pr_name_first as invoice_name_first,
		business.pr_name_last as businessName,
		business.pr_persona_ix as billing_unit_id,
		rf_currency.rf_currency_ix,
		rf_currency.rf_currency_symbol,
		ac_accomm_room.ac_desc,
		fn_folio.rv_res_item_group_id
	FROM
		fn_folio
		LEFT JOIN pr_persona AS pr_invoice ON pr_invoice.pr_persona_ix = fn_folio.fn_folio_to_id
		LEFT JOIN pr_persona AS business ON business.pr_persona_ix = fn_folio.pr_business_id
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation_id = '$resId'
		AND fn_folio.fn_folio_db IN ('".join("','",getDBCodes())."')
		AND (
			fn_folio.fn_invoice_id IS NULL
			OR fn_folio.fn_invoice_id = '0'
			OR fn_folio.fn_invoice_id = ''
		)
	ORDER BY
		fn_folio.fn_folio_folio_num + 0
",2);

$folioRows = "";
foreach($folioList as $item) {
	$to = trim($item['invoice_name_first']);
	if($to != "") {
		$to .= " ";
	}
	$to .= trim($item['invoice_name_last']);
	if($to == "") {
		$to = "&nbsp;";
	}
	$room = trim($item['ac_desc']);
	if($room == "") {
		$room = "&nbsp;";
	}
	$guestList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_group_id = '$item[rv_res_item_group_id]'
	",2);
	$guestNames = "";
	foreach($guestList as $guestItem) {
		if($guestNames != "") {
			$guestNames .= "<BR>";
		}
		$guestNames .= $guestItem['pr_name_last'];
		if(trim($guestItem['pr_name_first']) != "") {
			$guestNames .= ", " . $guestItem['pr_name_first'];
		}
	}
	if($guestNames == "") {
		$guestNames = "&nbsp;";
	}
	$to = t_encodeOverlib($to);
	$folioRows .= "
		<tr class=\"imgLink\" billing_unit_id=\"$item[billing_unit_id]\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"selectFolio('$item[fn_folio_ix]','$item[fn_folio_folio_num]: $to','$item[rf_currency_ix]','$item[rf_currency_symbol]');\">
			<td class=\"br\" valign=\"top\" align=\"center\">$item[fn_folio_folio_num]</td>
			<td class=\"br\" valign=\"top\">$to</td>
			<td class=\"br\" valign=\"top\">$item[businessName]</td>
			<td class=\"br\" valign=\"top\" align=\"center\">$item[rf_currency_symbol]</td>
			<td class=\"br\" valign=\"top\">$room</td>
			<td valign=\"top\">$guestNames</td>
		</tr>
	";
}

$folioRows = "
	<table cellspacing=\"0\" cellpadding=\"0\"  style=\"table-layout: fixed; background-color: #FFFFFF;\" id=\"folioListTable\">
		<col width=\"30\">
		<col width=\"100\">
		<col width=\"100\">
		<col width=\"60\">
		<col width=\"100\">
		<col width=\"115\">
		$folioRows
	</table>
";

/* end folio repop */


// Declare host variables
$rsUpdateInnerHTML = array();
$rsUpdateValue = array();
$rsUpdateVar = array();
$rsFuncList = array();

// Add values to arrays
$rsUpdateInnerHTML['datarows'] = $out;
$rsUpdateInnerHTML['folioListDiv'] = $folioRows;
// Output RS response
echo rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList);
die();
