<?php

require_once(__DIR__ . '/db.fn_invoice.php');
require_once(__DIR__ . '/db.rf_default.php');

require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.mail.php');
require_once(__DIR__ . '/functions.financial.php');
require_once(__DIR__ . '/functions.property.php');
require_once(__DIR__ . '/functions.reservation.php');
require_once(__DIR__ . "/functions.templates.php");   
require_once(__DIR__ . "/Roman/roman.php");	
require_once(__DIR__ . "/functions.files.php");
require_once(__DIR__ . '/class.fiscalator.php');



function textHeader($label) {
	$label = strtoupper($label);
	return "============================================================\n$label\n============================================================\n";
}

function removeBlank(&$arr,$blank="&nbsp;") {
	foreach($arr as $key=>$item) {
		if(is_array($item) || (is_string($item) && trim($item) == "")) {
			$arr[$key] = $blank;
		}
	}
}

function getBusinessDetails($resId, $folioId, $invoiceId, $docType, $selectedBanks, $options) {
	global $lDB;

	$businessArray = array();
	// Get a list of all properties in accommodation list
	$businessArray = $lDB->get("
		SELECT DISTINCT
			pr_business_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '$resId'
			AND pr_business_id != ''
			AND pr_business_id != '0'
			AND pr_business_id IS NOT NULL
		",3);

	// Add the list of all properties in extras list (this may no longer be nessessary)
	// and reduce to each unique business ID
	$businessArray = array_unique(array_merge($businessArray, $lDB->get("
		SELECT DISTINCT
			pr_business_id
		FROM
			rv_extra
		WHERE
			rv_extra.rv_reservation_id = '$resId'
			AND pr_business_id != ''
			AND pr_business_id != '0'
			AND pr_business_id IS NOT NULL
			AND rv_extra.rv_extra_void_ind = '0'
	",3)));
	// Find all billing entities among the business IDs specified and their parents
	$newBusinessArray = array();
	$propertyArray = array();
	foreach($businessArray as $item) {
		$currId = $item;
		while($currId != "0" && trim($currId) != "") {
			array_push($propertyArray,$currId);
			if($lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4) == "1"
				&& !in_array($currId, $newBusinessArray)) {
				array_push($newBusinessArray,$currId);
			}
			$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
			$currId = $parentId;
		}
	}
	$businessArray = $newBusinessArray;

	if($docType == DOC_FOLIO || $docType == DOC_INVOICE) {
		$businessArray = array();

		// Get a list of all properties in accommodation list
		$businessArray = $lDB->get("
			SELECT DISTINCT
				pr_business_id
			FROM
				fn_folio
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",3);
	}

	if($docType == DOC_RESERVATION) {
		$currencyId = getInvCurr($resId);
		// Display only the banks for applicable properties in use on the reservation
		$businessArray = $lDB->get("SELECT DISTINCT pr_business_id FROM fn_folio WHERE rv_reservation_id = '$resId'",3);
	} else {
		$currencyId = $lDB->get("SELECT fn_folio.rf_currency_id FROM fn_folio WHERE fn_folio_ix = '$folioId'",4);
	}
	// Find all banks account entries applicable to both the business' selected and the reservation invoice currency
	$busBankSql = $lDB->get("
		SELECT DISTINCT
			rf_bank.rf_bank_ix as busBankId
		FROM
			pr_bus_bank
			INNER JOIN rf_bank ON rf_bank.rf_bank_ix = pr_bus_bank.rf_bank_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			pr_bus_bank.pr_business_id IN ('".join("','",$businessArray)."')
			AND rf_bank.rf_bank_ind = '0'
			AND rf_bank.rf_bank_sys_code = '0'
			AND rf_bank.rf_currency_id = '$currencyId'
	",2);

	// Make list of bank Ids which are linked to business
	$busBankList = array();
	foreach($busBankSql as $busBankId){
		array_push($busBankList,$busBankId['busBankId']);
	}

	// Get all banks for show / hide
	$bankList = $lDB->get("
		SELECT
			rf_bank.rf_bank_ix as bankId,
			rf_bank.rf_bank_acc_name as bankAccName,
			rf_currency.rf_currency_symbol as bankCurr
		FROM
			rf_bank
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			rf_bank.rf_bank_ind = '0'
			AND rf_bank.rf_bank_inactive_yn = '0'
			AND rf_bank.rf_bank_sys_code = '0'
		ORDER BY
			rf_bank.rf_bank_acc_name
	",2);

	$bankListRows = "";
	$checked = "";
	$bankIds = array();
	$showAll = true;
	if($docType == DOC_INVOICE) {
		$checkInvoice = $GLOBALS['lDB']->get("SELECT fn_inv_print_count FROM fn_invoice WHERE fn_invoice_ix = '$invoiceId'",4);
		if( $checkInvoice < 1 &&  ( ($options & 7) == REP_VIEW_PDF || ($options & 7) == REP_SEND_PDF) ) {
			$showAll = false;
		}
	}
	
	$banksSelected = false;
	foreach($bankList as $bankListItem) {
		//Check banks which are linked to business
		if (in_array($bankListItem['bankId'], $busBankList, true)) {
			$checked = "checked";
			$banksSelected = true;
			if(!$showAll) array_push($bankIds,$bankListItem['bankId']);
		}

		$bankListRows .= '
			<tr valign="top">
				<td>
					<input type="checkbox" id="' . $bankListItem['bankId'] . 'Check" onclick="toggleBanks(\'' . $bankListItem['bankId'] . '\');" ' . $checked . '>
				</td>
				<td>' . $bankListItem['bankAccName'] . ' (' . $bankListItem['bankCurr'] . ')</td>
			</tr>
		';
		$checked = "";
		$GLOBALS['temp']['showHideBank'] = "";
		if($showAll) array_push($bankIds,$bankListItem['bankId']);
	}
	$GLOBALS['temp']['bankidList'] = join(",",$bankIds);
	if(!isset($GLOBALS['temp']['bankListRows'])) {
		$GLOBALS['temp']['bankListRows'] = "";
	}
	$GLOBALS['temp']['bankListRows'] .= $bankListRows;
	$bankSQL = $bankIds;
		
	if ( !(($options & 7) == REP_VIEW_PDF || ($options & 7) == REP_SEND_PDF) ) {
		$bankSQL = $bankIds;
	}
	
	if ($banksSelected == true) {
		$GLOBALS['temp']['bankDetailDefault'] = "expand";
	} else {
		$GLOBALS['temp']['bankDetailDefault'] = "collapse printCollapse";
	}

	if($selectedBanks != ""){
		$bankSQL = explode(",",$selectedBanks);
	}

	$bankArray = $lDB->get("
		SELECT DISTINCT
			rf_currency.rf_currency_symbol as rf_currency_name,
			rf_bank.rf_bank_name,
			rf_bank.rf_bank_acc_no,
			rf_bank.rf_bank_detail_1,
			rf_bank.rf_bank_detail_2,
			rf_bank.rf_bank_detail_3,
			rf_bank.rf_bank_acc_name,
			rf_bank.rf_bank_ix as bankId
		FROM
			rf_bank
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			rf_bank.rf_bank_ix IN ('".join("','",$bankSQL)."')
			AND rf_bank.rf_bank_ind = '0'
	",2);

	foreach($bankArray as $bankKey=>$bankItem) {
		$detail = trim($bankItem['rf_bank_detail_1']);
		if($bankItem['rf_bank_detail_2'] != "") {
			if(trim($detail) != "") {
				$detail .= "<br>";
			}
			$detail .= $bankItem['rf_bank_detail_2'];
		}
		if($bankItem['rf_bank_detail_3'] != "") {
			if(trim($detail) != "") {
				$detail .= "<br>";
			}
			$detail .= $bankItem['rf_bank_detail_3'];
		}
		$bankArray[$bankKey]['rf_bank_detail_1'] = $detail;

		if (in_array($bankItem['bankId'], $busBankList, true)) {
			$bankArray[$bankKey]['bankClass'] = "expand";
		} else {
			$bankArray[$bankKey]['bankClass'] = "collapse printCollapse";
		}
	}
	if($docType == DOC_INVOICE) {
		$checkInvoice = $GLOBALS['lDB']->get("SELECT fn_inv_print_count FROM fn_invoice WHERE fn_invoice_ix = '$invoiceId'",4);
		if($checkInvoice == -1 &&  ( ($options & 7) == REP_VIEW_PDF || ($options & 7) == REP_SEND_PDF)) {
			$invoiceBankList = $GLOBALS['lDB']->get("SELECT fn_invoice_bank_ix FROM fn_invoice_bank WHERE fn_invoice_id = '$invoiceId'",3);
			foreach($invoiceBankList as $invoiceBankId) {
				$GLOBALS['lDB']->put("DELETE FROM fn_invoice_bank WHERE fn_invoice_bank_ix = '$invoiceBankId'");
			}
		}
		if($checkInvoice < 1 &&  ( ($options & 7) == REP_VIEW_PDF || ($options & 7) == REP_SEND_PDF)) {
			// needs banks added
			foreach($bankArray as $bankKey=>$bankItem) {
				$lDB->put("
					INSERT INTO fn_invoice_bank (
						fn_invoice_bank_db,
						fn_invoice_bank_id,
						fn_inv_bank_acc_name,
						fn_inv_bank_acc_no,
						fn_inv_bank_detail_1,
						fn_inv_bank_detail_2,
						fn_inv_bank_detail_3,
						fn_inv_bank_name,
						fn_inv_currency_symbol,
						fn_invoice_id
					) VALUES (
						'$GLOBALS[dbcode]',
						'',
						'$bankItem[rf_bank_acc_name]',
						'$bankItem[rf_bank_acc_no]',
						'$bankItem[rf_bank_detail_1]',
						'$bankItem[rf_bank_detail_2]',
						'$bankItem[rf_bank_detail_3]',
						'$bankItem[rf_bank_name]',
						'$bankItem[rf_currency_name]',
						'$invoiceId'
					)
				");
			}
		}
		if($checkInvoice > 0) {
			$bankArray = $lDB->get("
				SELECT
					fn_invoice_bank.fn_inv_currency_symbol as rf_currency_name,
					fn_invoice_bank.fn_inv_bank_name as rf_bank_name,
					fn_invoice_bank.fn_inv_bank_acc_no as rf_bank_acc_no,
					fn_invoice_bank.fn_inv_bank_detail_1 as rf_bank_detail_1,
					fn_invoice_bank.fn_inv_bank_detail_2 as rf_bank_detail_2,
					fn_invoice_bank.fn_inv_bank_detail_3 as rf_bank_detail_3,
					fn_invoice_bank.fn_inv_bank_acc_name as rf_bank_acc_name,
					fn_invoice_bank.fn_invoice_bank_ix as bankId
				FROM
					fn_invoice_bank
				WHERE
					fn_invoice_id = '$invoiceId'
					
			",2);

			foreach($bankArray as $bankKey=>$bankItem) {
				$detail = trim($bankItem['rf_bank_detail_1']);
				if($bankItem['rf_bank_detail_2'] != "") {
					if(trim($detail) != "") {
						$detail .= ",<br>";
					}
					$detail .= $bankItem['rf_bank_detail_2'];
				}
				if($bankItem['rf_bank_detail_3'] != "") {
					if(trim($detail) != "") {
						$detail .= ",<br>";
					}
					$detail .= $bankItem['rf_bank_detail_3'];
				}
				$bankArray[$bankKey]['rf_bank_detail_1'] = $detail;
				$bankArray[$bankKey]['bankClass'] = "expand";
			}
		}
	}

	// Get the required information on each selected business
	$businessArray = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_business.pr_bus_statutory_1,
			pr_business.pr_bus_statutory_2,
			pr_business.pr_bus_statutory_3,
			pr_business.pr_bus_statutory_label_1,
			pr_business.pr_bus_statutory_label_2,
			pr_business.pr_bus_statutory_label_3,
			pr_business.pr_business_id
		FROM
			pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_business.pr_business_id IN ('".join("','",$businessArray)."')
	",2);

	$propertyArray = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_business.pr_bus_memo_info
		FROM
			pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_business.pr_business_id IN ('".join("','",$propertyArray)."')
			AND trim(pr_business.pr_bus_memo_info) <> ''
	",2);
	if($docType == DOC_INVOICE) {
		$businessArray = $lDB->get("
			SELECT
				fn_inv_from as pr_name_last,
				fn_inv_be_statutory_1 as pr_bus_statutory_1,
				fn_inv_be_statutory_2 as pr_bus_statutory_2,
				fn_inv_be_statutory_3 as pr_bus_statutory_3,
				fn_inv_be_statutory_label_1 as pr_bus_statutory_label_1,
				fn_inv_be_statutory_label_2 as pr_bus_statutory_label_2,
				fn_inv_be_statutory_label_3 as pr_bus_statutory_label_3
			FROM
				fn_invoice
			WHERE
				fn_invoice_ix = '$invoiceId'
		",2);
		$propertyArray = $lDB->get("
			SELECT
				fn_invoice.fn_inv_from as pr_name_last,
				fn_invoice.fn_inv_bus_memo_conditions as pr_bus_memo_info
			FROM
				fn_invoice
			WHERE
				fn_invoice_ix = '$invoiceId'
		",2);
	}
	return array('billingInfo'=>$businessArray, 'bankInfo'=>$bankArray, 'propertyNotes'=>$propertyArray);
}

// THIS MUST BE INTEGRATED WITH init.form253 (reports) and init.form0 (resDetails)
function getReservationRooming($resNum) {
	$guestList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_ix,
			pr_guest.pr_guest_note,
			pr_guest.pr_guest_memo
		FROM
			rv_reservation_item
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resNum'
	",2);

   $roomList = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_item_date_arrive as arrive,
			rv_reservation_item.rv_item_date_depart as depart,
			pr_persona.pr_name_last as property,
			ac_accomm_type.ac_accomm_desc  as accomm,
			ac_accomm_room.ac_desc as room,
			rv_res_item_group.rv_room_requested_yn as locked,
			rv_room_request_reason as reason
		FROM
			rv_reservation_item
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resNum'
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			(ac_accomm_room.ac_desc+0),
			ac_accomm_room.ac_desc
	",2);
	$arrive = null;
	$depart = null;
	$property = null;
	$accomm = null;
	$level = 1;
	foreach($roomList as $key=>$item) {
		if($arrive != $item['arrive']) {
			$roomList[$key]['arrive'] = chng_date($item['arrive'],"-");
			$roomList[$key]['depart'] = chng_date($item['depart'],"-");
			$arrive = $item['arrive'];
			$depart = $item['depart'];
			$property = $item['property'];
			$accomm = $item['accomm'];
			$level = 1;
		}
		if($depart != $item['depart']) {
			$depart = $item['depart'];
			$property = $item['property'];
			$accomm = $item['accomm'];
			$level = 2;
		}
		if($property != $item['property']) {
			$property = $item['property'];
			$accomm = $item['accomm'];
			$level = 3;
		}
		if($accomm != $item['accomm']) {
			$accomm = $item['accomm'];
			$level = 4;
		}

		if($level == 2) { $roomList[$key]['arrive'] = ""; }
		if($level == 3) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; }
		if($level == 4) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; $roomList[$key]['property'] = ""; }
		if($level == 5) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; $roomList[$key]['property'] = ""; $roomList[$key]['accomm'] = ""; }

		$level = 5;

		if($item['locked'] == "1") {
			$roomList[$key]['locked'] = "Yes";
		} else {
			$roomList[$key]['locked'] = "No";
			$roomList[$key]['reason'] = "";
		}
	}
	$guestGroup = array();
	$itemList = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item_ix
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_id = '$resNum'
	",3);

	$groupName = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_res_item_group.rv_res_item_group_ix
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
		WHERE
			rv_reservation.rv_reservation_ix = '$resNum'
			AND (
				rv_res_item_group.ac_accomm_room_id = ''
				OR rv_res_item_group.ac_accomm_room_id IS NULL
				OR rv_res_item_group.ac_accomm_room_id = '0'
			)
	",3);
	$itemCount = 1;
	for($count = 0; $count < ceil(sizeof($itemList) / 4); $count++) {
		$row = array();
		$row['item1'] = "";
		$row['item2'] = "";
		$row['item3'] = "";
		$row['item4'] = "";
		$row['rows'] = array();
		$first = true;
		foreach($guestList as $guestItem) {
			$item = array('name' => $guestItem['pr_name_last'] . ($guestItem['pr_name_first'] != ""?", ".$guestItem['pr_name_first']:""));
			if(trim($guestItem['pr_guest_note']) != "") {
				$item['guestNote'] = "x";
			} else {
				$item['guestNote'] = "";
			}
			if(trim($guestItem['pr_guest_memo']) != "") {
				$item['guestMemo'] = "x";
			} else {
				$item['guestMemo'] = "";
			}
			for($count2 = 0; $count2 < 4; $count2++) {
				if(($count * 4) + $count2 < sizeof($itemList)) {
					if($first) {
						$row['item' . ($count2+1)] = "Item " . ($itemCount);
						$itemCount++;
					}

					$guestRoom = $GLOBALS['lDB']->get("
						SELECT
							ac_accomm_room.ac_desc,
							rv_res_item_group.rv_room_requested_yn,
							rv_res_item_group.rv_res_item_group_ix as id,
							rv_reservation_item.rv_item_date_arrive,
							rv_reservation_item.rv_item_date_depart,
							rv_reservation_item.rv_item_adult_count,
							rv_reservation_item.rv_item_child_count,
							pr_persona.pr_name_last,
							ac_accomm_type.ac_accomm_name_short,
							ac_accomm_type.ac_accomm_desc
						FROM
							rv_reservation_item
							INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
							INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
							INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
							LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
							INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
							INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		               WHERE
							rv_reservation_item.rv_reservation_item_ix = '".$itemList[($count * 4) + $count2]."'
							AND rv_res_item_guest.pr_guest_id = '" . $guestItem['pr_persona_ix'] . "'
					",1);
					$compArray = $GLOBALS['lDB']->get("
						SELECT
							rt_component_desc
						FROM
							rv_res_item_comp
							INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
						WHERE
							rv_res_item_comp.rv_reservation_item_id = '".$itemList[($count * 4) + $count2]."'
							AND rv_res_item_comp.rv_item_comp_option_yn = '1'
					",3);
					if($guestRoom !== false) {

						$row['item' . ($count2+1)] =
							"Arr: " . chng_date($guestRoom['rv_item_date_arrive'],'-') . "<BR>" .
							"Dep: " . chng_date($guestRoom['rv_item_date_depart'],'-') . "<BR>" .
							"Prop: " . $guestRoom['pr_name_last'] . "<BR>" .
							"Accomm: " .$guestRoom['ac_accomm_desc'] . "<BR>" .
							"Adult: " .$guestRoom['rv_item_adult_count'] . "<BR>" .
							"Child: " .$guestRoom['rv_item_child_count'] . "<BR>" .
							"Options: " .join(", ", $compArray);
						if($guestRoom['ac_desc'] == "" || $guestRoom['ac_desc'] == "0") {
							$groupKey = array_search($guestRoom['id'],$groupName);
							if($groupKey === false) {
								$guestRoom['ac_desc'] = "";
							} else {
								$guestRoom['ac_desc'] = "(" . strtolower(IntToRoman($groupKey+1)) . ")";
							}
						}
						$item["item".($count2+1)] = $guestRoom['ac_desc'];
						if($guestRoom['rv_room_requested_yn'] == "1") {
							$item["item".($count2+1)."Lock"] = "";
						} else {
							$item["item".($count2+1)."Lock"] = "display:none;";
						}
					} else {
						$itinerary = $GLOBALS['lDB']->get("
							SELECT
								ac_accomm_room.ac_desc,
								rv_reservation_item.rv_item_date_arrive,
								rv_reservation_item.rv_item_date_depart,
								rv_reservation_item.rv_item_adult_count,
								rv_reservation_item.rv_item_child_count,
								rv_reservation_item.rv_reservation_item_ix,
								rv_reservation_item.rv_item_accomm_count,
								pr_persona.pr_name_last,
								ac_accomm_type.ac_accomm_name_short,
								ac_accomm_type.ac_accomm_desc
							FROM
								rv_reservation_item
								INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
								INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
								LEFT JOIN rv_res_item_group ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
								LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			               WHERE
								rv_reservation_item.rv_reservation_item_ix = '".$itemList[($count * 4) + $count2]."'
						",1);
						$row['item' . ($count2+1)] =
							"Arr: " . chng_date($itinerary['rv_item_date_arrive'],'-') . "<BR>" .
							"Dep: " . chng_date($itinerary['rv_item_date_depart'],'-') . "<BR>" .
							"Prop: " . $itinerary['pr_name_last'] . "<BR>" .
							"Accomm: " .$itinerary['ac_accomm_desc'] . "<BR>" .
							"Adult: " .$itinerary['rv_item_adult_count'] . "<BR>" .
							"Child: " .$itinerary['rv_item_child_count'] . "<BR>" .
							"Options: " .join(", ", $compArray);

						$item['item' . ($count2+1)] = "";
						$item['item' . ($count2+1).'Lock'] = "display:none;";
					}
				} else {
					$item["item".($count2+1)] = "";
					$item["item".($count2+1)."Lock"] = "display:none;";
					$item['guestNote'] = "";
					$item['guestMemo'] = "";
				}
			}
			$first = false;
			array_push($row['rows'],$item);
		}
		$row['htmlRow'] = true;
		array_push($guestGroup,$row);
	}
	$notes = array();
	$memos = array();

	foreach($guestList as $item) {
		$name = $item['pr_name_last'] . ($item['pr_name_first'] != ""?", ".$item['pr_name_first']:"");
		if(trim($item['pr_guest_note']) != "") {
			array_push($notes,array('name'=>$name, 'note'=>$item['pr_guest_note']));
		}
		if(trim($item['pr_guest_memo']) != "") {
			array_push($memos,array('name'=>$name, 'note'=>$item['pr_guest_memo']));
		}
	}

	return array('guests'=>$guestList, 'rooms'=>$roomList, 'guestGroups'=>$guestGroup, 'notes'=>$notes, 'memos'=>$memos);
}

// THIS MUST BE INTEGRATED WITH init.form253 (reports)

function getContactInfo($resId, &$result,$docType) {
	global $lDB;

	$contactId = $lDB->get("SELECT rv_corr_persona_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
	$agentId = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
	$checkAgentLink = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			pr_link
		WHERE
			pr_link.rf_link_type_id = 'RS2'
			AND pr_link.pr_link_to = '$agentId'
			AND pr_link.pr_link_from = '$contactId'
	",4);
	$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);
	$result['showContactDropdown'] = "class='expand'";
	if($docType == DOC_RESERVATION) {
		if($checkAgentLink > 0) {
			$contact = getContactName($contactId) . "\n" . getContactName($agentId) . "\n" .t_encodeHTML(getContactCorrAddress($contactId));
		} else {
			$contact = getContactName($contactId) . "\n" .t_encodeHTML(getContactCorrAddress($contactId));
		}
		$result['contactName'] = trim(getContactName($contactId));
		$contactTelephone = getContactTelephone($contactId);
		if ($contactTelephone != "") {
			$contact .= "Telephone: " . $contactTelephone . "\n";
		}
		$contactFax = getContactFax($contactId);
		if ($contactFax != "") {
			$contactFax = str_pad( $contactFax, (strlen($contactFax)+12)," ",STR_PAD_LEFT);
			$contact .= "Fax: " . $contactFax . "\n";
		}
		$contactEmail = getContactEmail($contactId);
		if ($contactEmail != "") {
			$result['emailTo'] = $contactEmail;
			$contact .= "Email: " . $contactEmail . "\n";
		} else {
			$result['emailTo'] = "";
		}
		$contactURL = getContactURL($contactId);
		if ($contactURL != "") {
			$contact .= "Web: " . $contactURL . "\n";
		}
		$contactTax = $lDB->get("
			SELECT
				pr_persona.pr_statutory_1,
				pr_persona.pr_statutory_2,
				pr_persona.pr_statutory_3
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix = '$contactId'
				AND pr_persona.pr_statutory_1 IS NOT NULL
		",1);
		for ($x=1; $x < 4; $x++) {
			if (trim($contactTax['pr_statutory_'.$x]) != "" && trim($contactTax['pr_statutory_'.$x]) != "0") {
				$contact .= $default_statutory_labels['rf_statutory_label_'.$x].": " . $contactTax['pr_statutory_'.$x] . "\n";
			}
		}
		if (trim($contact) != "") {
			$result['contactDetail'] = $contact;
		} else {
			$result['contactDetail'] = "No contact on this reservation";
		}
	} elseif($docType == DOC_FOLIO) {
		$contactId = $lDB->get("SELECT fn_folio_to_id FROM fn_folio WHERE fn_folio_ix = '$result[folioId]'",4);
		$checkAgentLink = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				pr_link
			WHERE
				pr_link.rf_link_type_id = 'RS2'
				AND pr_link.pr_link_to = '$agentId'
				AND pr_link.pr_link_from = '$contactId'
		",4);
		if(trim($contactId) != "" && $contactId != "0") {
			if($checkAgentLink > 0) {
				$contact = getContactName($contactId) . "\n" . getContactName($agentId) . "\n" .t_encodeHTML(getContactCorrAddress($contactId));
			} else {
				$contact = getContactName($contactId) . "\n" .t_encodeHTML(getContactCorrAddress($contactId));
			}
			$result['contactName'] = trim(getContactName($contactId));
			$contactTelephone = getContactTelephone($contactId);
			if ($contactTelephone != "") {
				$contact .= "Telephone: " . $contactTelephone . "\n";
			}
			$contactFax = getContactFax($contactId);
			if ($contactFax != "") {
				$contactFax = str_pad($contactFax, (strlen($contactFax)+12)," ",STR_PAD_LEFT);
				$contact .= "Fax: " . $contactFax . "\n";
			}
			$contactEmail = getContactEmail($contactId);
			if ($contactEmail != "") {
				$result['emailTo'] = $contactEmail;
				$contact .= "Email: " . $contactEmail . "\n";
			} else {
				$result['emailTo'] = "";
			}
			$contactURL = getContactURL($contactId);
			if ($contactURL != "") {
				$contact .= "Web: " . $contactURL . "\n";
			}
			$contactTax = $GLOBALS['lDB']->get("
				SELECT
					pr_persona.pr_statutory_1,
					pr_persona.pr_statutory_2,
					pr_persona.pr_statutory_3
				FROM
					pr_persona
				WHERE
					pr_persona.pr_persona_ix = '$contactId'
					AND pr_persona.pr_statutory_1 IS NOT NULL
			",1);
			for ($x=1; $x < 4; $x++) {
				if (trim($contactTax['pr_statutory_'.$x]) != "" && trim($contactTax['pr_statutory_'.$x]) != "0") {
					$contact .= $default_statutory_labels['rf_statutory_label_'.$x].": " . $contactTax['pr_statutory_'.$x] . "\n";
				}
			}
		} else {
			$contact = "Cash\n";
		}
		if (trim($contact) != "") {
			$result['contactDetail'] = $contact;
		} else {
       	 $result['contactDetail'] = "No contact on this reservation";
		}
		$result['showContactDropdown'] = "class='collapse printCollapse'";
	} elseif($docType == DOC_INVOICE) {
		$invoiceTo = $GLOBALS['lDB']->get("
			SELECT
				fn_inv_to,
				fn_inv_to_addr_line1,
				fn_inv_to_addr_line2,
				fn_inv_to_addr_line3,
				fn_inv_to_city,
				fn_inv_to_country,
				fn_inv_to_post_code,
				fn_inv_to_statutory_1,
				fn_inv_to_statutory_2,
				fn_inv_to_statutory_3
			FROM
				fn_invoice
			WHERE
				fn_invoice_ix = '$result[invoiceId]'
		",1);
		
		$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);

		$contact = "";
		if(trim($invoiceTo['fn_inv_to']) != "") {
			$contact .= $invoiceTo['fn_inv_to'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_addr_line1']) != "") {
			$contact .= $invoiceTo['fn_inv_to_addr_line1'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_addr_line2']) != "") {
			$contact .= $invoiceTo['fn_inv_to_addr_line2'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_addr_line3']) != "") {
			$contact .= $invoiceTo['fn_inv_to_addr_line3'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_city']) != "") {
			$contact .= $invoiceTo['fn_inv_to_city'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_country']) != "") {
			$contact .= $invoiceTo['fn_inv_to_country'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_post_code']) != "") {
			$contact .= $invoiceTo['fn_inv_to_post_code'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_statutory_1']) != "") {
			$contact .= $default_statutory_labels['rf_statutory_label_1'].": ".$invoiceTo['fn_inv_to_statutory_1'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_statutory_2']) != "") {
			$contact .= $default_statutory_labels['rf_statutory_label_2'].": ".$invoiceTo['fn_inv_to_statutory_2'] . "\n";
		}
		if(trim($invoiceTo['fn_inv_to_statutory_3']) != "") {
			$contact .= $default_statutory_labels['rf_statutory_label_3'].": ".$invoiceTo['fn_inv_to_statutory_3'] . "\n";
		}
		if (trim($contact) != "") {
			$result['contactDetail'] = $contact;
		} else {
			$result['contactDetail'] = "No contact on this reservation";
		}
		$result['showContactDropdown'] = "class='collapse printCollapse'";
	}

	if (isset($_SESSION['extWizContact']) && $_SESSION['extWizContact']['rv_reservation_id'] == $resId) {
		$result['contactName'] = (trim($_SESSION['extWizContact']['pr_name_first']) != ""?$_SESSION['extWizContact']['pr_name_first'].", ":"") . $_SESSION['extWizContact']['pr_name_last'];
		$result['contactDetail'] = $result['contactName'];
		$result['rv_contact'] = $result['contactName'];
		if (trim($_SESSION['extWizContact']['pr_corr_addr_line1']) != "") {
			$result['contactDetail'] .= "\n" . $_SESSION['extWizContact']['pr_corr_addr_line1'];
		}
		if (trim($_SESSION['extWizContact']['pr_corr_addr_line2']) != "") {
			$result['contactDetail'] .= "\n" . $_SESSION['extWizContact']['pr_corr_addr_line2'];
		}
		if (trim($_SESSION['extWizContact']['pr_corr_post_code']) != "") {
			$result['contactDetail'] .= "\n" . $_SESSION['extWizContact']['pr_corr_post_code'];
		}
		if (trim($_SESSION['extWizContact']['contact_telephone']) != "") {
			$result['contactDetail'] .= "\nTelephone: " . $_SESSION['extWizContact']['contact_telephone'];
			$result['tel_number'] = $_SESSION['extWizContact']['contact_telephone'];
		}
		if (trim($_SESSION['extWizContact']['contact_fax']) != "") {
			$_SESSION['extWizContact']['contact_fax'] = str_pad($_SESSION['extWizContact']['contact_fax'], (strlen($_SESSION['extWizContact']['contact_fax'])+12)," ",STR_PAD_LEFT);
			$result['contactDetail'] .= "\nFax: " . $_SESSION['extWizContact']['contact_fax'];
			$result['fax_number'] = $_SESSION['extWizContact']['contact_fax'];
		}
		if (trim($_SESSION['extWizContact']['pr_email']) != "") {
			$result['email_address'] = $_SESSION['extWizContact']['pr_email'];
		}
	}
	// get agent info (get agent id moved to before contact)
	$agent = getContactName($agentId) . "\n". t_encodeHTML(getContactCorrAddress($agentId));
	$result['agentName'] = trim(getContactName($agentId));
	$agentTelephone = getContactTelephone($agentId);
	if ($agentTelephone != "") {
		$agent .= "Telephone: " . $agentTelephone . "\n";
	}
	$agentFax = getContactFax($agentId);
	if ($agentFax != "") {
		$agentFax = str_pad($agentFax, (strlen($agentFax)+12)," ",STR_PAD_LEFT);
		$agent .= "Fax: " . $agentFax . "\n";
	}
	$agentEmail = getContactEmail($agentId);
	if ($agentEmail != "") {
		$agent .= "Email: " . $agentEmail . "\n";
	}
	$agentURL = getContactURL($agentId);
	if ($agentURL != "") {
		$agent .= "Web: " . $agentURL . "\n";
	}
	if (trim($agent) != "") {
		$result['agentDetail'] = $agent;
	} else {
		$result['agentDetail'] = "No agent on this reservation";
	}
	// get consultant
	$consultantId = $GLOBALS['lDB']->get("
		SELECT
			rv_consultant_id
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$resId'
	", 4);
	$consultant = getContactName($consultantId) . "\n". t_encodeHTML(getContactCorrAddress($consultantId));
	$result['consultantName'] = trim(getContactName($consultantId));
	$consultantTelephone = getContactTelephone($consultantId);
	if ($consultantTelephone != "") {
		$consultant .= "Telephone: " . $consultantTelephone . "\n";
	}
	$consultantFax = getContactFax($consultantId);
	if ($consultantFax != "") {
		$consultantFax = str_pad($consultantFax, (strlen($consultantFax)+12)," ",STR_PAD_LEFT);
		$consultant .= "Fax: " . $consultantFax . "\n";
	}
	$consultantEmail = getContactEmail($consultantId);
	if ($consultantEmail != "") {
		$consultant .= "Email: " . $consultantEmail . "\n";
	}
	$consultantURL = getContactURL($consultantId);
	if ($consultantURL != "") {
		$consultant .= "Web: " . $consultantURL . "\n";
	}
	if (trim($consultant) != "") {
		$result['consultantDetail'] = $consultant;
	} else {
		$result['consultantDetail'] = "No consultant on this reservation";
	}
	// get billing contact
	$billingContactId = $GLOBALS['lDB']->get("
		SELECT
			rv_billing_persona_id
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$resId'
	", 4);
	$checkAgentLink = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			pr_link
		WHERE
			pr_link.rf_link_type_id = 'RS2'
			AND pr_link.pr_link_to = '$agentId'
			AND pr_link.pr_link_from = '$billingContactId'
	",4);
	if($checkAgentLink > 0) {
		$billingContact = getContactName($billingContactId) . "\n". getContactName($agentId) . "\n" . t_encodeHTML(getContactCorrAddress($billingContactId));
	} else {
		$billingContact = getContactName($billingContactId) . "\n". t_encodeHTML(getContactCorrAddress($billingContactId));
	}
	$result['billingContactName'] = trim(getContactName($billingContactId));
	$billingContactTelephone = getContactTelephone($billingContactId);
	if ($billingContactTelephone != "") {
		$billingContact .= "Telephone: " . $billingContactTelephone . "\n";
	}
	$billingContactFax = getContactFax($billingContactId);
	if ($billingContactFax != "") {
		$billingContactFax = str_pad($billingContactFax, (strlen($billingContactFax)+12)," ",STR_PAD_LEFT);
		$billingContact .= "Fax: " . $billingContactFax . "\n";
	}
	$billingContactEmail = getContactEmail($billingContactId);
	if ($billingContactEmail != "") {
		$billingContact .= "Email: " . $billingContactEmail . "\n";
	}
	$billingContactURL = getContactURL($billingContactId);
	if ($billingContactURL != "") {
		$billingContact .= "Web: " . $billingContactURL . "\n";
	}
	if (!empty(trim($billingContact))) {
		$result['billingContactDetail'] = $billingContact;
	} else {
		$result['billingContactDetail'] = "No billing contact on this reservation";
	}
	return $result;
}

function getContactEmail($personaId) {
	global $lDB;

	$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($email) == "" || $email == "0") {
		$personaId = getLinkedPersona($personaId);
		$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($email) == "" || $email == "0") {
			return "";
		} else {
			return $email;
		}
	} else {
		return $email;
	}
}

function getContactURL($personaId) {
	global $lDB;

	$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if (trim($url) == "" || $url == "0") {
		$personaId = getLinkedPersona($personaId);
		$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($url) == "" || $url == "0") {
			return "";
		} else {
			return $url;
		}
	} else {
		return $url;
	}
}

function getContactFax($personaId) {
	global $lDB;
	
	$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
	if (trim($faxNumber) == "" || $faxNumber == "0") {
		$personaId = getLinkedPersona($personaId);
		$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
		if (trim($faxNumber) == "" || $faxNumber == "0") {
			return "";
		} else {
			return $faxNumber;
		}
	} else {
		return $faxNumber;
	}
}

function getContactTelephone($personaId) {
	global $lDB;

	$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND pr_default_yn = 1", 4);
	if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
		$personaId = getLinkedPersona($personaId);
		$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '".$personaId."' AND pr_default_yn = 1", 4);
		if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
			return "";
		} else {
			return $telephoneNumber;
		}
	} else {
		return $telephoneNumber;
	}
}

function getContactName($personaId) {
	global $lDB;
	
	$nameArray = $lDB->get("
		SELECT
			/*0*/ pr_name_first,
			/*1*/ pr_name_second,
			/*2*/ pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$personaId'
	",1);
	$name = $nameArray['pr_name_last'];
	if (trim($nameArray['pr_name_second']) != "" && $nameArray['pr_name_second'] != "0") {
		$name = $nameArray['pr_name_second'] . " " . $name;
	}
	if (trim($nameArray['pr_name_first']) != "" && $nameArray['pr_name_first'] != "0") {
		$name = $nameArray['pr_name_first'] . " " . $name;
	}
	$link = $lDB->get("
		SELECT
			pr_name_last
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
		WHERE
			pr_link.pr_link_from = '$personaId'
			AND pr_link.rf_link_type_id IN ('RS1','RS2')
	",4);
	if($link != "0" && trim($link) != "") {
		$name .= " (".$link.")";
	}
	if($lDB->get("SELECT rf_res_office_id FROM rf_default",4) == $personaId) {
		$name .= " (Res Office)";
	}
	return $name;
}

function getLinkedPersona($personaId) {
	$linkId = $GLOBALS['lDB']->get("SELECT pr_persona_link_id FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($linkId) != "" && $linkId != "0") {
		return $linkId;
	} else {
		return $personaId;
	}
}

function relatedEmailSort($a, $b) {
	return strcasecmp($a['name'],$b['name']);
/*    if ($a['name'] == $b['name']) {
        return 0;
    }
	return ($a['name'] < $b['name']) ? -1 : 1;*/
}


function relatedEmailAddress($reservationId,$folioId=false) {
	if($GLOBALS['userStatusId'] < 2) {
		return array();
	}
	$personaArray = array();
	if($folioId === false) {
		$lookup = $GLOBALS['lDB']->get("
			SELECT
				rv_corr_persona_id,
				rv_billing_persona_id,
				rv_agent_id,
				rv_consultant_id,
				rv_invoice_persona_id
			FROM
				rv_reservation
			WHERE
				rv_reservation_ix = '$reservationId'
		",1);
	} else {
		$lookup = $GLOBALS['lDB']->get("
			SELECT
				fn_folio.fn_folio_to_id,
				rv_billing_persona_id,
				rv_corr_persona_id,
				rv_agent_id,
				rv_consultant_id,
				rv_invoice_persona_id
			FROM
				fn_folio 
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",1);
	}
	foreach($lookup as $item) {
		if (trim($item) != "" && $item != "0") {
			array_push($personaArray, $item);

			$linked = $GLOBALS['lDB']->get("
				SELECT
					pr_link.pr_link_from
				FROM
					pr_link
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				WHERE
					pr_link.pr_link_to = '$item'
					AND pr_link.rf_link_type_id = 'RS2'
					AND pr_sys_code != '9'
				ORDER BY
					pr_persona.pr_name_first,
					pr_persona.pr_name_last
			",3);
			if(sizeof($linked) > 0) {
				$personaArray = array_merge($personaArray,$linked);
			}
		}
	}
	array_splice($personaArray, count($personaArray), 0, $GLOBALS['lDB']->get("
		SELECT
			pr_link_from
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
		WHERE
			rf_link_type_id = 'RS1'
			AND pr_persona.pr_persona_inactive_yn = '0'
			AND pr_sys_code != '9'
	",3));
	array_push($personaArray,$GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default",4));
	array_push($personaArray, $GLOBALS['userid']);
	array_splice($personaArray, sizeof($personaArray), 0, getUsers(getAgent($GLOBALS['userid'])));
	$personaArray = array_unique($personaArray);
	$emailArray = array();
	foreach($personaArray as $id) {
		if ($id != "0") {
			if (getContactEmail($id) != "") {
				array_push($emailArray, array('email'=>getContactEmail($id),'name'=>escapeName(getContactName($id)),'id'=>$id));
			}
		}
	}

	$firstItem = array_shift($emailArray);
	usort($emailArray,"relatedEmailSort");
	array_unshift($emailArray,$firstItem);
	return $emailArray;
}

/**
 * Get a list of all the user IDs linked to an agent
 * @param string $agentId
 * @return string
 */
function getUsers($agentId) {
	$userArray = $GLOBALS['lDB']->get("
		SELECT
			pr_link_from
		FROM
			pr_link
		WHERE
			pr_link_to = '$agentId'
			AND rf_link_type_id = 'RS2'
	",3);
	if (sizeof($userArray) > 0) {
		return $userArray;
	}
	return "0";
}

function sortByDates($a1, $a2) {
	if ($a1['amt_date'] == $a2['amt_date']) {
		return 0;
	}
	else if ($a1['amt_date'] > $a2['amt_date']) {
		return 1;
	}
	else {
		return -1;
	}
}

function hasContactDetails($pr_persona_id) {
	if(trim(getContactCorrAddress($pr_persona_id)) != "") {
		return true;
	}

	if(trim(getContactTelephone($pr_persona_id)) != "") {
		return true;
	}

	if(trim(getContactFax($pr_persona_id)) != "") {
		return true;
	}
	
	if(trim(getContactEmail($pr_persona_id)) != "") {
		return true;
	}

	if(trim(getContactURL($pr_persona_id)) != "") {
		return true;
	}

	return false;
}
