<?php

/**
 * Documentation / Invoice for a single reservation
 *
 * Job(s): 642
 * Form: 216
 */

if (!isset($_SESSION['userName'])) {
	redirectTo("/");
}

if(!isset($GLOBALS[$form])) {
	require_once(__DIR__ . '/class.form.php');
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/doc.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],28,"");
$doFiscalise = false;
$allowPrint = true;
$disablePrintClass = "";
$fiscalData = "";
$fiscalInfo = "";

$resId = trim($_SERVER['argv'][1]);
$options = $_SERVER['argv'][2];
$folioId = trim($_SERVER['argv'][3]); // DB TODO: this still has references elsewhere to be investigate elsewhere
$invoiceId = trim($_SERVER['argv'][4]);
// argv 5 is used as the randomid
$toggleMap = $_SERVER['argv'][6];
$addressArg = trim(urldecode($_SERVER['argv'][7]));
$commentArg	= trim(urldecode($_SERVER['argv'][8]));
$emailTo = trim($_SERVER['argv'][8]); // DB TODO: remove the overloaded argv
$emailPersonaId	= $_SERVER['argv'][9];
$selectedBanks = $_SERVER['argv'][10];
$customNotesList = $_SERVER['argv'][11];
$dayActivity = $_SERVER['argv'][12];
$hideFinancials	= $_SERVER['argv'][13];
$useInvoiceDefaults = $_SERVER['argv'][14];
$useResDetailDefault = $_SERVER['argv'][15];
$showReference = $_SERVER['argv'][16];
$showSupplier = $_SERVER['argv'][17];
$showAgentComm = $_SERVER['argv'][18];
$showPayPlanInv = $_SERVER['argv'][19];
$showConsolidatedItems = $_SERVER['argv'][20];
$showServiceDate = !empty($_SERVER['argv'][21]) ? $_SERVER['argv'][21] : "1";
$showTaxTable = $_SERVER['argv'][22];
$showTaxTableGL = $_SERVER['argv'][23];
$showTaxTableRate = $_SERVER['argv'][24];
$showTaxTableTotal = $_SERVER['argv'][25];
$showSpecial = !empty($_SERVER['argv'][26]) ? $_SERVER['argv'][26] : "0";
$showSpecialNote = !empty($_SERVER['argv'][27]) ? $_SERVER['argv'][27] : "0";
if($options == "") { $options = 0; }

$GLOBALS['temp']['selectedBanks'] = $selectedBanks;
$GLOBALS['temp']['customNotesList']	= $customNotesList;
$GLOBALS['temp']['dayActivity'] = $dayActivity;
$GLOBALS['temp']['hideFinancials'] = $hideFinancials;

$GLOBALS['temp']['showServiceDate'] = $showServiceDate;
$GLOBALS['temp']['showSpecial'] = $showSpecial;
$GLOBALS['temp']['showSpecialNote'] = $showSpecialNote;
$GLOBALS['temp']['fiscalisedOnlyClass'] = "collapse printCollapse";
$GLOBAL['temp']['fiscalLabelCol'] = "";
$GLOBAL['temp']['fiscalInfo'] = "";
$GLOBALS['temp']['qrcode'] = "";
$fiscalLabelCol = "";
$fiscalInfo = "";
$qrcode = "";


$GLOBALS['temp']['commissionLabel'] = commissionLabel();
$allowPrintButtons = '';

$rf_mail_id = $lDB->get("SELECT rf_database.rf_mail_id FROM rf_database WHERE rf_database.rf_db_code = '$GLOBALS[dbcode]'",4);
$GLOBALS['temp']['rf_mail_id'] = "";
if ( $rf_mail_id == 2 && $GLOBALS['dbcode'][0] != "W" ) {
	$GLOBALS['temp']['rf_mail_id'] = $rf_mail_id;
}

$envType = $lDB->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_database.rf_db_code = '$dbcode'",4);
$GLOBALS['temp']['envType'] = $envType;

$GLOBALS['temp']['header_button_style'] = "visibility: hidden;";
if($userStatusId > 0) {
	$GLOBALS['temp']['header_button_style'] = "";
}

$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
$principalName = getContactFullName($principalId);
$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
$proformaNote = trim($lDB->get("SELECT rf_proforma_note FROM rf_default", 4));

$templateData = initTemplates($resId);

$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);

if (!defined('DOC_EMAIL_TEXT')) define("DOC_EMAIL_TEXT",4);
if (!defined('DOC_SEND_TEXT')) define("DOC_SEND_TEXT",5);
$fiscalised = false;

switch ( $options & 7 ) {
	case REP_VIEW_HTML:
		$renderMode = "html";
		$renderType = "";
		break;
	case REP_VIEW_PDF:
		$renderMode = "pdf";
		$renderType = "view";
		break;
	case REP_EMAIL_PDF:
		$renderMode = "pdf";
		$renderType = "email";
		break;
	case REP_SEND_PDF:
		$renderMode = "pdf";
		$renderType = "send";
		break;
	case DOC_EMAIL_TEXT:
		$renderMode = "text";
		$renderType = "view";
		break;
	case DOC_SEND_TEXT:
		$renderMode = "text";
		$renderType = "send";
		break;
}

if (!defined('DOC_RESERVATION')) define("DOC_RESERVATION",0);
if (!defined('DOC_FOLIO')) define("DOC_FOLIO",1);
if (!defined('DOC_INVOICE')) define("DOC_INVOICE",2);

$docList = array();

if($invoiceId != "") {
	$docType = DOC_INVOICE;
	$invoiceIdList = explode("|",$invoiceId);
	foreach($invoiceIdList as $item) {
		$resId = $lDB->get("SELECT rv_reservation_id FROM fn_invoice WHERE fn_invoice_ix = '$item'",4);
		$folioId = $lDB->get("SELECT fn_folio_id FROM fn_invoice WHERE fn_invoice_ix = '$item'",4);
		array_push($docList,array('resId'=>$resId, 'folioId'=>$folioId, 'invoiceId'=>$item));
	}
	$GLOBALS['temp']['btnPrintClass'] = "collapse";
} elseif($folioId != "") {
	$docType = DOC_FOLIO;
	$folioIdList = explode("|",$folioId);
	foreach($folioIdList as $item) {
		$resId = $lDB->get("SELECT rv_reservation_id FROM fn_folio WHERE fn_folio_ix = '$item'",4);
		array_push($docList,array('resId'=>$resId, 'folioId'=>$item, 'invoiceId'=>""));
	}
} else {
	$docType = DOC_RESERVATION;
	$resIdList = array($GLOBALS['wizResId']);
	if($resId != "") {
		$resIdList = explode("|",$resId);
	}
	foreach($resIdList as $item) {
		array_push($docList,array('resId'=>$item, 'folioId'=>"", 'invoiceId'=>""));
	}
}

// Get special details
$specials = array();

switch ( $docType ) {
	case DOC_INVOICE:
		$specials = db_sp_special_get_by_invoice($invoiceId);
		break;
	case DOC_FOLIO:
		$specials = db_sp_special_get_by_folio($folioId);
		break;
	case DOC_RESERVATION:
		$specials = db_sp_special_get_by_reservation($resId);
		break;
}

// Look up document defaults
list(
	$rf_doc_header_res_office_yn,
	$rf_doc_header_res_office_type_ind,
	$rf_doc_header_res_office_url_yn,
	$rf_doc_header_logo_yn,
	$rf_doc_header_logo_type_ind,
	$rf_doc_header_invoice_yn
) = $lDB->get("
	SELECT
		rf_doc_header_res_office_yn,
		rf_doc_header_res_office_type_ind,
		rf_doc_header_res_office_url_yn,
		rf_doc_header_logo_yn,
		rf_doc_header_logo_type_ind,
		rf_doc_header_invoice_yn
	FROM
		rf_default
",1);

// Get logos for each document
foreach($docList as $docKey=>$docItem) {
	$principal_id = !empty($_SESSION['principal_id']) ? $_SESSION['principal_id'] : $GLOBALS['principal_id'];
	if($docType == DOC_RESERVATION) {
		$businessList = $lDB->get("SELECT DISTINCT pr_business_id FROM rv_reservation_item WHERE rv_reservation_id = '$docItem[resId]'",3);
		if($rf_doc_header_logo_type_ind == RF_DEFAULT_DOC_HEADER_LOGO_TYPE_SYSTEM) {
			$logoList = array();
			foreach($businessList as $pr_business_id) {
				$logoFilename = "";
				$currId = $pr_business_id;
				while($currId != "0" && trim($currId) != "" && $logoFilename == "") {
					$prefix = strtolower($lDB->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$currId'",4));
					$fileName = $prefix . '_mkg';
					$logoFilename = imageFile($fileName);
					$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
					$currId = $parentId;
				}
				if($logoFilename != "") {
					array_push($logoList,$logoFilename);
				}
			}
			$logoList = array_unique($logoList);
			if(sizeof($logoList) == 1) {
				$logoFilename = $logoList[0];
			} else {
				$fileName = "top_client_mkg";
				$logoFilename = imageFile($fileName, false);
			}
		} else { // RF_DEFAULT_DOC_HEADER_LOGO_TYPE_FIRST_PARENT
			$commonParents = findCommonParents($businessList);
			foreach($commonParents as $pr_business_id) {
				$prefix = strtolower($lDB->get("
					SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$pr_business_id'
				",4));
				$fileName = $prefix . '_mkg';
				$logoFilename = imageFile($fileName);
				if (!empty($logoFilename)) {
					break;
				}
			}
			if(empty($logoFilename)) {
				$fileName = "top_client_mkg";
				$logoFilename = imageFile($fileName, false);
			}
		}
	} else {
		$logoFilename = "";
		$currId = $lDB->get("SELECT pr_business_id FROM fn_folio WHERE fn_folio_ix = '$docItem[folioId]'",4);
		while($currId != "0" && trim($currId) != "" && $logoFilename == "") {
			$prefix = strtolower($lDB->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$currId'",4));
			$fileName = $prefix . '_fin';
			$logoFilename = imageFile($fileName);
			$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
			$currId = $parentId;
		}

		if ($logoFilename == "") {
			$logoFilename = imageFile("top_client_fin", false);
		}
	}
	$docList[$docKey]['logoFilename'] = $logoFilename;
}

$GLOBALS['temp']['customCSS'] = "";

if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/financial_documents.css")) {
	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/financial_documents.css\" type=\"text/css\">
	";
}

$guestServicesUrl = $GLOBALS['http'] . $GLOBALS['domain'] . '/guest';
$GLOBALS['temp']['guest_services_url'] = $guestServicesUrl;
$GLOBALS['temp']['guest_list_url'] = $guestListUrl = $guestServicesUrl . '/list';
$GLOBALS['temp']['guest_check_in_url'] = $guestCheckInUrl = $guestServicesUrl . '/check-in';

$payNowUrl = $GLOBALS['http'] . $GLOBALS['domain'] . '/reservation.php?1021';
require_once(__DIR__ . '/functions.imageset.php');
if (isV3Imageset($principal_id)) {
	// Different link if it's a V3+ imageset
	$payNowUrl = $GLOBALS['http'] . $GLOBALS['domain'] . '/public/paynow.php';
}
$GLOBALS['temp']['pay_now_url'] = $payNowUrl;

foreach($docList as $docKey=>$docItem) {
	$resId = $docItem['resId'];
	$folioId = $docItem['folioId'];
	$invoiceId = $docItem['invoiceId'];
	$logoFilename = $docItem['logoFilename'];

	$GLOBALS['temp']['resNum'] = $resId;
	$GLOBALS['temp']['invoiceId'] = $invoiceId;
	$GLOBALS['temp']['folioId'] = $folioId;

	$GLOBALS['temp']['doc_header_res_office_class'] = "";
	$GLOBALS['temp']['doc_header_res_office_width'] = "190";
	$GLOBALS['temp']['doc_header_filler_class'] = "collapse printCollapse";
	$GLOBALS['temp']['doc_header_filler_width'] = "";
	$GLOBALS['temp']['doc_header_logo_class'] = "";
	$GLOBALS['temp']['doc_header_logo_width'] = "";
	$GLOBALS['temp']['doc_header_logo_align'] = "center";
	$rf_doc_header_logo_align = "C";
	$GLOBALS['temp']['doc_header_invoice_class'] = "";
	$GLOBALS['temp']['doc_header_invoice_width'] = "190";
	if($docType != DOC_INVOICE) {

		// Count how many columns are shown and collapse any that are not
		$rf_doc_header_count = 0;
		if($rf_doc_header_res_office_yn == "1") {
			$rf_doc_header_count++;
		} else {
			$GLOBALS['temp']['doc_header_res_office_class'] = "collapse printCollapse";
			$GLOBALS['temp']['doc_header_res_office_width'] = "";
		}
		if($rf_doc_header_logo_yn == "1") {
			$rf_doc_header_count++;
		} else {
			$GLOBALS['temp']['doc_header_logo_class'] = "collapse printCollapse";
		}
		if($rf_doc_header_invoice_yn == "1") {
			$rf_doc_header_count++;
		} else {
			$GLOBALS['temp']['doc_header_invoice_class'] = "collapse printCollapse";
			$GLOBALS['temp']['doc_header_invoice_width'] = "";
		}

		// If there are only two or less columns showing, and the logo is hidden, enable the filler cell
		if($rf_doc_header_count < 3 && $rf_doc_header_logo_yn != "1") {
			$GLOBALS['temp']['doc_header_filler_class'] = "";
		}

		// If there are only two columns showing, and one of them is the logo...
		if($rf_doc_header_count == 2 && $rf_doc_header_logo_yn == "1") {
			if($rf_doc_header_res_office_yn == "1") {
				// ... set the alignment of the logo left if the other column is the res office details
				$GLOBALS['temp']['doc_header_logo_align'] = "";
				$rf_doc_header_logo_align = "L";
			} else {
				// ... else set the alignment of the logo right if the other column is the invoice details
				$GLOBALS['temp']['doc_header_logo_align'] = "right";
				$rf_doc_header_logo_align = "R";
			}	
		}
	} else {
		$rf_doc_header_count = 3;
		$rf_doc_header_res_office_yn = "1";
		$rf_doc_header_res_office_url_yn = "1";
		$rf_doc_header_logo_yn = "1";
		$rf_doc_header_logo_align = "C";
		$rf_doc_header_invoice_yn = "1";
	}

	$result = getReservationHeader($resId);

	if($result['tel_number'] == "None") {
		$GLOBALS['temp']['resDetailsHideTelephone'] = "collapse printCollapse";
	} else {
		$GLOBALS['temp']['resDetailsHideTelephone'] = "";
	}

	if($result['fax_number'] == "None") {
		$GLOBALS['temp']['resDetailsHideFax'] = "collapse printCollapse";
	} else {
		$GLOBALS['temp']['resDetailsHideFax'] = "";
	}

	$result = array_merge($result,$lDB->get("
		SELECT
			rv_reservation.rv_commission_perc,
			rv_reservation.rv_provision_expiry_date,
			rf_currency.rf_currency_symbol,
			pr_persona.pr_name_last as originator_name_last,
			pr_persona.pr_name_first as originator_name_first
		FROM 
			rv_reservation
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id
		WHERE
			rv_reservation.rv_reservation_ix = '$resId'
	",1));

	$result['originator_name'] = trim($result['originator_name_first'] . " " . $result['originator_name_last']);

	$result['rv_provision_expiry_date']	= chng_date($result['rv_provision_expiry_date'],"-");

	// Contact details for email popup
	$emailPopupTelephone = getContactTelephone($resOfficeId);
	if(!empty($emailPopupTelephone)) {
		$result['resOffTel'] = $emailPopupTelephone;
	} else {
		$result['resOffTel'] = "None";
	}

	$emailPopupFax = getContactFax($resOfficeId);
	if($emailPopupFax == "") {
		$emailPopupFax = str_pad("None", 16," ",STR_PAD_LEFT);
	} else {
		$emailPopupFax = str_pad($emailPopupFax, (strlen($emailPopupFax)+11)," ",STR_PAD_LEFT);
	}
	$result['fax'] = $emailPopupFax;

	// Res office contact details
	$resOfficeHeaderId = $resOfficeId;
	if($rf_doc_header_res_office_type_ind == RF_DEFAULT_DOC_HEADER_RES_OFFICE_TYPE_FIRST_PARENT) {
		if($docType == DOC_RESERVATION) {
			$businessList = $lDB->get("SELECT DISTINCT pr_business_id FROM rv_reservation_item WHERE rv_reservation_id = '$docItem[resId]'",3);
		} else {
			$businessList = $lDB->get("SELECT pr_business_id FROM fn_folio WHERE fn_folio_ix = '$docItem[folioId]'",4);
		}
		$commonParents = findCommonParents($businessList);
		foreach($commonParents as $pr_business_id) {
			if(hasContactDetails($pr_business_id)) {
				$resOfficeHeaderId = $pr_business_id;
				break;
			}
		}
	}
	$result['fromAddress'] = getContactCorrAddress($resOfficeHeaderId);

	$addresseeTelephone = getContactTelephone($resOfficeHeaderId);
	$addresseeFax = getContactFax($resOfficeHeaderId);

	if($addresseeTelephone == "") {
		$addresseeTelephone = "None";
	}
	
	if($addresseeFax == "") {
		$addresseeFax = str_pad("None",16," ",STR_PAD_LEFT);
	} else {
		$addresseeFax = str_pad($addresseeFax,(strlen($addresseeFax)+12)," ",STR_PAD_LEFT);
	}
	
	if(trim($addresseeTelephone) != "None") {
		$result['fromAddress'] .= "Telephone: " . $addresseeTelephone . "\n";
	}
	if(trim($addresseeFax) != "None") {
		$result['fromAddress'] .= "Fax: " . $addresseeFax . "\n";
	}
	
	$addresseeEmail = getContactEmail($resOfficeHeaderId);
	if($addresseeEmail != "") {
		$result['fromAddress'] .= "Email: " . $addresseeEmail . "\n";
	}

	$addresseeURL = getContactURL($resOfficeHeaderId);
	if($addresseeURL != "") {
		$result['fromAddress'] .= "Web: " . $addresseeURL . "\n";
	}

	// Get contact
	if($rf_doc_header_res_office_url_yn == "1") {
		$principal_name_short = !empty($_SESSION['principal_name_short']) ? $_SESSION['principal_name_short'] : $GLOBALS['principal_name_short'];

		$result['fromAddress'] .= "Res-Web: " . $principal_name_short . ".resrequest.com\n";
	}
	$result = array_merge($result,getDocTitle($resId));
	$result['resId'] = $resId;

	$GLOBALS['temp']['printCount'] = -1;
	$GLOBALS['temp']['docTitleClass'] = "";
	$GLOBALS['temp']['docSubTitleClass'] = "";
	$GLOBALS['temp']['allowHideFin'] = "collapse printCollapse";
	$GLOBALS['temp']['hasAccomm'] = "1";

	$titleResName = $result['rv_res_name'];
	if(strlen($titleResName) > 32) {
		$titleResName = substr($titleResName,0,32) . "...";
	}

	if($docType == DOC_RESERVATION) {
		$result['resItems'] = getAccommRateData($resId);
		$genExtras = getExtraDetails($resId,"0");
		$actExtras = getExtraDetails($resId,"1");
		$result['resExtras'] = array_merge($genExtras, $actExtras);
		$result['resTravel'] = getTravelDetails($resId);
		$result['resAccomExtras'] = getExtraDetails($resId,"3");
		
		$result['docTitle'] = "Reservation Summary";
		$result['docRef'] = $resId . ": " . $titleResName;
		$result['roomHeaderClass'] = "collapse printCollapse";
		$result['currencyCheck'] = $lDB->get("SELECT COUNT(DISTINCT rf_currency_id) FROM fn_folio WHERE rv_reservation_id = '$resId'",4);
		$GLOBALS['temp']['allowHideFin']	= "";
		$consolidatedLabel = addslashes($lDB->get("SELECT rf_doc_summary_comp_group_label FROM rf_default",4));

		$commList = $lDB->get("
			SELECT DISTINCT
				rv_reservation_item.rv_item_comm_perc
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_id = '" . $lDB->escape($resId) . "'
		",3);

	} elseif($docType == DOC_FOLIO) { 

		$invoicePrint = $lDB->get("
			SELECT
				fn_inv_opt_accomm,
				fn_inv_opt_bank,
				fn_inv_opt_cca,
				fn_inv_opt_date,
				fn_inv_opt_special,
				fn_inv_opt_special_note,
				fn_inv_opt_tax,
				fn_inv_opt_tax_table,
				fn_inv_opt_tax_table_gl,
				fn_inv_opt_tax_table_rate,
				fn_inv_opt_tax_table_total,
				fn_inv_opt_terms,
				fn_inv_opt_terms_bus,
				fn_inv_tax_table_align,
				fn_inv_print_count,
				pr_business_id
			FROM
				fn_invoice
			WHERE
				fn_invoice_ix = '$folioId'
		",1);

		if($invoicePrint['fn_inv_print_count'] > 0 || ($invoicePrint['fn_inv_print_count'] == -1 && $useInvoiceDefaults != 1)) {
			$optAccomm = $invoicePrint['fn_inv_opt_accomm'];
			$optBank = $invoicePrint['fn_inv_opt_bank'];
			$optCCA = $invoicePrint['fn_inv_opt_cca'];
			$optDate = $invoicePrint['fn_inv_opt_date'];
			$optSpecial = $invoicePrint['fn_inv_opt_special'];
			$optSpecialNote = $invoicePrint['fn_inv_opt_special_note'];
			$optTax = $invoicePrint['fn_inv_opt_tax'];
			$optTaxTable = $invoicePrint['fn_inv_opt_tax_table'];
			$optTaxTableGL = $invoicePrint['fn_inv_opt_tax_table_gl'];
			$optTaxTableRate = $invoicePrint['fn_inv_opt_tax_table_rate'];
			$optTaxTableTotal = $invoicePrint['fn_inv_opt_tax_table_total'];
			$optTerms = $invoicePrint['fn_inv_opt_terms'];
			$optTermsBus = $invoicePrint['fn_inv_opt_terms_bus'];
			$optTaxTableAlign = $invoicePrint['fn_inv_tax_table_align'];
		}

		
		$result['resItems'] = getAccommRateData($resId,$folioId);
		if(sizeof($result['resItems']) < 1) {
			$GLOBALS['temp']['hasAccomm'] = "0";
		}
		
		$genExtras = getExtraDetails($resId,"0",$folioId);
		$actExtras = getExtraDetails($resId,"1",$folioId);
		$result['resExtras'] = array_merge($genExtras, $actExtras);
		$result['resTravel'] = getTravelDetails($resId,$folioId);
		$result['resAccomExtras'] = getExtraDetails($resId,"3",$folioId);

		$defaultDate = ($lDB->get("SELECT rf_invoice_date FROM rf_default",4)==1?"MAX(rv_item_date_depart)":"MIN(rv_item_date_arrive)");

		$amt_date = $lDB->get("
			SELECT
				$defaultDate
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.fn_folio_id = '$folioId'
				",4);
		

		$sqlSelect = "
			SUM(rv_res_item_comp.rv_item_comp_amt_payable) AS fn_folio_amount,
			SUM(rv_res_item_comp.rv_item_comp_amt_tax) AS fn_folio_amount_tax,
			SUM(rv_res_item_comp.rv_item_comp_amt_payable-rv_res_item_comp.rv_item_comp_amt_tax) AS fn_folio_amount_excl,
			rv_res_item_comp.rv_item_comp_tax_perc AS tax_rate,
			'$amt_date' as amt_date,
			IF(rv_res_item_comp.rt_tax_ind = 10, rf_tax_rate.rf_tax_rate_desc, rt_tax_group.rt_tax_group_desc) AS taxDesc
		";

		$sqlSelectNoTax = "
			SUM(rv_res_item_comp.rv_item_comp_amt_payable) AS fn_folio_amount,
			SUM(rv_res_item_comp.rv_item_comp_amt_payable-rv_res_item_comp.rv_item_comp_amt_tax) AS fn_folio_amount_excl,
			'$amt_date' as amt_date
		";

		$sqlFrom = "
			rv_res_item_comp
			INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
			LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp.rt_tax_id
			LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_res_item_comp.rt_tax_id
		";

		$sqlWhere = "
			AND rv_reservation_item.fn_folio_id = '$folioId'
		";

		$sqlGroup = "
			rv_res_item_comp.rv_item_comp_tax_perc
		";

		$consolidatedLabel = addslashes($lDB->get("SELECT rf_doc_proforma_comp_group_label FROM rf_default",4));

		$list = $lDB->get("
			SELECT
				'$consolidatedLabel' AS fn_folio_desc,
				$sqlSelect
			FROM
				$sqlFrom
			WHERE
				(
					(
						rt_component.rt_component_separate_proforma_ind = 0
						AND rv_res_item_comp.rv_item_comp_separate_yn = 0
					) OR (
						rt_component.rt_component_separate_proforma_ind = 2
					)
				)
				$sqlWhere
			GROUP BY
				$sqlGroup
		",2);

		foreach ( $list as $key => $item ) {
			$idList = $lDB->get("
				SELECT
					DISTINCT rv_res_item_comp.rv_res_item_comp_ix AS id
				FROM
					$sqlFrom
				WHERE
					(
						(
							rt_component.rt_component_separate_proforma_ind = 0
							AND rv_res_item_comp.rv_item_comp_separate_yn = 0
						) OR (
							rt_component.rt_component_separate_proforma_ind = 2
						)
					)
					AND rv_res_item_comp.rv_item_comp_tax_perc = '" . $item['tax_rate'] . "'
					$sqlWhere
			",3);
			$list[$key]['idList'] = $idList;
		}

		$listNoTax = $lDB->get("
			SELECT
				'$consolidatedLabel' AS fn_folio_desc,
				$sqlSelectNoTax
			FROM
				$sqlFrom
			WHERE
				(
					(
						rt_component.rt_component_separate_proforma_ind = 0
						AND rv_res_item_comp.rv_item_comp_separate_yn = 0
					) OR (
						rt_component.rt_component_separate_proforma_ind = 2
					)
				)
				$sqlWhere
		",2);

		foreach ( $listNoTax as $key => $item ) {
			$idList = $lDB->get("
				SELECT
					DISTINCT rv_res_item_comp.rv_res_item_comp_ix AS id
				FROM
					$sqlFrom
				WHERE
					(
						(
							rt_component.rt_component_separate_proforma_ind = 0
							AND rv_res_item_comp.rv_item_comp_separate_yn = 0
						) OR (
							rt_component.rt_component_separate_proforma_ind = 2
						)
					)
					$sqlWhere
			",3);
			if (empty($idList)) {
				// No entries, will result in a phantom accomm record, remove array entry completely
				array_splice($listNoTax, $key, 1);
			} else {
				$listNoTax[$key]['idList'] = $idList;
			}
		}
		

		$listSep = $lDB->get("
			SELECT
				rt_component.rt_component_desc AS fn_folio_desc,
				$sqlSelect
			FROM
				$sqlFrom
			WHERE
				(
					(
						rt_component.rt_component_separate_proforma_ind = 0
						AND rv_res_item_comp.rv_item_comp_separate_yn = 1
					) OR (
						rt_component.rt_component_separate_proforma_ind = 1
					)
				)
				$sqlWhere
			GROUP BY
				rt_component.rt_component_desc,
				$sqlGroup
		",2);

		foreach ( $listSep as $key => $item ) {
			$resId2 = $lDB->get("
				SELECT
					DISTINCT rv_res_item_comp.rv_res_item_comp_ix AS id
				FROM 
					$sqlFrom
				WHERE 
					(
						(
							rt_component.rt_component_separate_proforma_ind = 0
							AND rv_res_item_comp.rv_item_comp_separate_yn = 1
						) OR (
							rt_component.rt_component_separate_proforma_ind = 1
						)
					)
					AND rt_component.rt_component_desc = '$item[fn_folio_desc]'
					AND rv_res_item_comp.rv_item_comp_tax_perc = '" . $item['tax_rate'] . "'
					$sqlWhere
			",3);
			$listSep[$key]['idList'] = $resId2;
		}
		$list = array_merge($list,$listSep);
		$listNoTax = array_merge($listNoTax,$listSep);

		$exclTotal = 0;
		$taxTotal = 0;
		$amountTotal = 0;
		foreach($list as $item) {
			$exclTotal += $item['fn_folio_amount_excl'];
			$taxTotal += $item['fn_folio_amount_tax'];
			$amountTotal += $item['fn_folio_amount'];
		}
		fixAmtDisplay($exclTotal,2);
		fixAmtDisplay($taxTotal,2);
		fixAmtDisplay($amountTotal,2);

		$consolidatedList = array(array(
			'fn_folio_desc'=>stripslashes($consolidatedLabel),
			'fn_folio_amount'=>$amountTotal,
			'fn_folio_amount_tax'=>$taxTotal,
			'taxDesc'=>'',
			'fn_folio_amount_excl'=>$exclTotal,
			'amt_date'=>$amt_date
		));

		$folioExtras = $lDB->get("
			SELECT 
				ac_extra.ac_ext_desc AS fn_folio_desc,
				rv_extra_amt_payable AS fn_folio_amount,
				rv_extra.rv_extra_ix AS extra_id,
				(
					SELECT SUM(rv_extra_tax_amt)
					FROM rv_extra_tax
					WHERE rv_extra_tax.rv_extra_id = extra_id
				) as fn_folio_amount_tax,
				rv_extra.rv_extra_tax_ind,
				IF(	rv_extra.rv_extra_tax_ind = '10',
					rf_tax_rate.rf_tax_rate_desc,
					rt_tax_group.rt_tax_group_desc) AS taxDesc,
				rv_extra_amt_payable-rv_extra_amt_tax AS fn_folio_amount_excl,
				rv_extra.rv_extra_date_serv AS amt_date
			FROM 
				rv_extra
				INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_extra.rf_tax_id
				LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_extra.rf_tax_id
			WHERE
				fn_folio_id = '$folioId'
				AND rv_extra.rv_extra_void_ind = '0'
			ORDER BY rv_extra.rv_extra_date_serv
		",2);

		$result['folioItems'] = array_merge($folioExtras,$list);
		usort($result['folioItems'], "sortByDates");
		$result['folioNoTaxItems'] = array_merge($folioExtras,$listNoTax);
		usort($result['folioNoTaxItems'], "sortByDates");
		$result['folioConsolidatedItems'] = array_merge($folioExtras,$consolidatedList);
		usort($result['folioConsolidatedItems'], "sortByDates");
		$result['docTitle'] = $lDB->get("SELECT rf_proforma_title FROM rf_default",4);
		$folioNum = $lDB->get("SELECT fn_folio_folio_num FROM fn_folio WHERE fn_folio_ix = '$folioId'",4);
		$result['docRef'] = $resId . " / F#" . $folioNum . ": " . $titleResName;

		$result['folioId'] = $folioId;
		$result['folioCurrency'] = $lDB->get("
			SELECT 
				rf_currency_symbol 
			FROM 
				fn_folio 
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			WHERE 
				fn_folio.fn_folio_ix = '$folioId'
		",4);

		$result['rf_currency_symbol'] = $result['folioCurrency'];

		$folioRoom = $lDB->get("
			SELECT 
				ac_accomm_room.ac_desc 
			FROM
				fn_folio 
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",4);

		$result['roomHeaderClass'] = "expand";

		if($folioRoom == "0" || trim($folioRoom) == "") {
			$folioRoom = "";
			$result['roomHeaderClass'] = "collapse printCollapse";
		}

		$result['folio_room_desc'] = $folioRoom;
		$GLOBALS['temp']['allowReference'] = "collapse printCollapse";
		$GLOBALS['temp']['allowServiceBy'] = "collapse printCollapse";

		$itemTax = $lDB->get("
			SELECT
				rf_tax_rate.rf_tax_rate_desc AS tax_desc,
				rv_res_item_comp_tax.rv_res_item_comp_tax_perc AS tax_perc,
				SUM(rv_res_item_comp_tax.rv_res_item_comp_tax_amt) AS tax_amt
			FROM
				rv_res_item_comp_tax
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_tax.rv_res_item_comp_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
				INNER JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp_tax.rf_tax_rate_id 
			WHERE
				rv_reservation_item.fn_folio_id = '$folioId'
			GROUP BY
				rf_tax_rate.rf_tax_rate_desc
		",2);	
		$extraTax = $lDB->get("
			SELECT
				rv_extra.rv_extra_ix AS extra_id,
				rf_tax_rate.rf_tax_rate_desc AS tax_desc,
				MAX(rv_extra_tax.rv_extra_tax_perc) AS tax_perc,
				SUM(rv_extra_tax.rv_extra_tax_amt) AS tax_amt
			FROM
				rv_extra
				LEFT JOIN rv_extra_tax on rv_extra_tax.rv_extra_id = rv_extra.rv_extra_ix
				LEFT JOIN rf_tax_rate on rf_tax_rate.rf_tax_rate_ix = rv_extra_tax.rf_tax_rate_id
			WHERE
				rv_extra.fn_folio_id = '$folioId'
			GROUP BY
				rv_extra_tax.rf_tax_rate_id
		",2);
		$combinedTax = array_merge($itemTax,$extraTax);

		$folioTaxTable = array();
		foreach($combinedTax as $item) {
			$key = $item['tax_desc'];
			if(!array_key_exists($key,$folioTaxTable)) {
				$folioTaxTable[$key] = array(
					'tax_desc'=>$key,
					'tax_perc'=>$item['tax_perc'],
					'tax_amt'=>$item['tax_amt']
				);
			} else {
				$tax_amt = isset($item['tax_amt']) && !empty($item['tax_amt']) ? $item['tax_amt'] : 0;
				$folioTaxTable[$key]['tax_amt'] += $tax_amt;
			}
		}
		$result['folioTaxTable'] = $folioTaxTable;

		$taxTableRows = "";
		$GLOBALS['temp']['taxTableRows'] = $taxTableRows;

		$commList = $lDB->get("
			SELECT DISTINCT
				rv_reservation_item.rv_item_comm_perc
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.fn_folio_id = '" . $lDB->escape($folioId) . "'
		",3);

	} elseif ( $docType == DOC_INVOICE ) {
		$consolidatedLabel = addslashes($lDB->get("SELECT rf_doc_invoice_comp_group_label FROM rf_default",4));
		$result['resItems'] = getAccommRateData($resId,$folioId);
		if(sizeof($result['resItems']) < 1) {
			$GLOBALS['temp']['hasAccomm'] = "0";
		}

		$genExtras = getExtraDetails($resId,"0",$folioId);
		$actExtras = getExtraDetails($resId,"1",$folioId);
		$acmExtras = getExtraDetails($resId,"3",$folioId);
		$result['resExtras'] = array_merge($genExtras, $actExtras, $acmExtras);
		$result['resTravel'] = getTravelDetails($resId,$folioId);
		$result['resAccomExtras'] = array();
		
		$result['fn_inv_agent_ref'] = $lDB->get("SELECT fn_inv_agent_ref FROM fn_invoice WHERE fn_invoice_ix = '$invoiceId'",4);
		$result['invoicePaid']= $lDB->get("SELECT fn_inv_amt_paid FROM fn_invoice WHERE fn_invoice_ix = '$invoiceId'",4);

		$invoiceExchange = $lDB->get("
			SELECT 
				fn_inv_exch_rate,
				fn_inv_curr,
				fn_inv_curr_home,
				fn_inv_status_ind,
				fn_inv_type_ind,
				fn_inv_reverse_ind,
				fn_inv_void_yn
			FROM
				fn_invoice
			WHERE
				fn_invoice_ix = '$invoiceId'
		",1);

		$result['invoiceExchangeToCurrency'] = $invoiceExchange['fn_inv_curr_home'];
		$result['invoiceExchangeRate'] = $invoiceExchange['fn_inv_exch_rate'];
		$result['invoiceExchangeFromCurrency'] = $invoiceExchange['fn_inv_curr'];

		$result['invoiceItems'] = $lDB->get("
			SELECT 
				fn_inv_item_amount,
				fn_inv_item_amt_tax,
				fn_inv_item_amount - fn_inv_item_amt_tax AS fn_inv_item_amt_excl,
				fn_inv_item_desc,
				fn_inv_item_date,
				fn_inv_item_tax_perc AS tax_rate,
				fn_invoice_item.fn_inv_item_tax_desc AS taxDesc
			FROM
				fn_invoice 
				INNER JOIN fn_invoice_item ON fn_invoice_item.fn_invoice_id = fn_invoice.fn_invoice_ix
			WHERE
				fn_invoice_ix = '$invoiceId'
			ORDER BY
				fn_inv_item_date
		",2);

		$result['docRef'] = $invoiceId;
		$result['folioId'] = $folioId;
		$result['invoiceId'] = $invoiceId;

		$fromInfo = $lDB->get("
			SELECT
				fn_inv_from,
				fn_inv_be_addr_line1,
				fn_inv_be_addr_line2,
				fn_inv_be_addr_line3,
				fn_inv_be_city,
				fn_inv_be_country,
				fn_inv_be_post_code,
				fn_inv_be_email,
				fn_inv_be_fax,
				fn_inv_be_phone,
				fn_inv_be_web_addr
			FROM
				fn_invoice
			WHERE
				fn_invoice_ix = '$invoiceId'
		",1);

		$result['fromAddress'] = $fromInfo['fn_inv_from'];
		if(trim($fromInfo['fn_inv_be_addr_line1']) != "") {
			$result['fromAddress'] .= "\n" . $fromInfo['fn_inv_be_addr_line1'];
		}

		if(trim($fromInfo['fn_inv_be_addr_line2']) != "") {
			$result['fromAddress'] .= "\n" . $fromInfo['fn_inv_be_addr_line2'];
		}

		if(trim($fromInfo['fn_inv_be_addr_line3']) != "") {
			$result['fromAddress'] .= "\n" . $fromInfo['fn_inv_be_addr_line3'];
		}

		if(trim($fromInfo['fn_inv_be_city']) != "") {
			$result['fromAddress'] .= "\n" . $fromInfo['fn_inv_be_city'];
		}

		if(trim($fromInfo['fn_inv_be_country']) != "") {
			$result['fromAddress'] .= "\n" . $fromInfo['fn_inv_be_country'];
		}

		if(trim($fromInfo['fn_inv_be_post_code']) != "") {
			$result['fromAddress'] .= "\n" . $fromInfo['fn_inv_be_post_code'];
		}

		if(trim($fromInfo['fn_inv_be_phone']) != "") {
			$result['fromAddress'] .= "\nTelephone: " . $fromInfo['fn_inv_be_phone'];
		}

		if(trim($fromInfo['fn_inv_be_fax']) != "") {
			$fromInfo['fn_inv_be_fax'] = str_pad( $fromInfo['fn_inv_be_fax'], (strlen( $fromInfo['fn_inv_be_fax'])+12)," ",STR_PAD_LEFT);
			$result['fromAddress'] .= "\nFax: " . $fromInfo['fn_inv_be_fax'];
		}

		if(trim($fromInfo['fn_inv_be_email']) != "") {
			$result['fromAddress'] .= "\nEmail: " . $fromInfo['fn_inv_be_email'];
		}

		if(trim($fromInfo['fn_inv_be_web_addr']) != "") {
			$result['fromAddress'] .= "\nWeb: " . $fromInfo['fn_inv_be_web_addr'];
		}

		$result['fromAddress'] .= "\n";

		$result['folioCurrency'] = $lDB->get("
			SELECT 
				rf_currency_symbol 
			FROM 
				fn_folio
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",4);

		$result['rf_currency_symbol'] = $result['folioCurrency'];

		$folioRoom = $lDB->get("
			SELECT
				ac_accomm_room.ac_desc
			FROM
				fn_folio
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",4);

		$result['roomHeaderClass'] = "expand";

		if($folioRoom == "0" || trim($folioRoom) == "") {
			$folioRoom = "";
			$result['roomHeaderClass'] = "collapse printCollapse";
		}

		$result['folio_room_desc'] = $folioRoom;

		// Get print options ( or defaults)
		$invoicePrint = $lDB->get("
			SELECT
				fn_inv_opt_accomm,
				fn_inv_opt_bank,
				fn_inv_opt_cca,
				fn_inv_opt_date,
				fn_inv_opt_special,
				fn_inv_opt_special_note,
				fn_inv_opt_tax,
				fn_inv_opt_tax_table,
				fn_inv_opt_tax_table_gl,
				fn_inv_opt_tax_table_rate,
				fn_inv_opt_tax_table_total,
				fn_inv_opt_terms,
				fn_inv_opt_terms_bus,
				fn_inv_tax_table_align,
				fn_inv_print_count,
				pr_business_id,
				fn_inv_fiscal_status_ind
			FROM
				fn_invoice
			WHERE
				fn_invoice_ix = '$invoiceId'
		",1);

		$GLOBALS['temp']['fsDisable'] = '';
		$GLOBALS['temp']['disablePrintClass'] = '';
		$GLOBALS['temp']['fiscalisedOnlyClass'] = "collapse printCollapse";

		if ($invoicePrint['fn_inv_fiscal_status_ind'] != '' && $invoicePrint['fn_inv_fiscal_status_ind'] != '9' && $invoicePrint['fn_inv_fiscal_status_ind'] != '2' && $invoicePrint['fn_inv_fiscal_status_ind'] != '7') {
			// Disable print buttons if invoice has a fiscal status, and it is not 2 (Verified), 7 (CN verified) or 9 (Folio amount = Zero)
			$GLOBALS['temp']['fsDisable'] = 'disabled';
			$GLOBALS['temp']['disablePrintClass'] = 'txtgr';
		}

		if($invoicePrint['fn_inv_print_count'] > 0 || ($invoicePrint['fn_inv_print_count'] == -1 && $useInvoiceDefaults != 1)) {
			$optAccomm = $invoicePrint['fn_inv_opt_accomm'];
			$optBank = $invoicePrint['fn_inv_opt_bank'];
			$optCCA = $invoicePrint['fn_inv_opt_cca'];
			$optDate = $invoicePrint['fn_inv_opt_date'];
			$optSpecial = $invoicePrint['fn_inv_opt_special'];
			$optSpecialNote = $invoicePrint['fn_inv_opt_special_note'];
			$optTax = $invoicePrint['fn_inv_opt_tax'];
			$optTaxTable = $invoicePrint['fn_inv_opt_tax_table'];
			$optTaxTableGL = $invoicePrint['fn_inv_opt_tax_table_gl'];
			$optTaxTableRate = $invoicePrint['fn_inv_opt_tax_table_rate'];
			$optTaxTableTotal = $invoicePrint['fn_inv_opt_tax_table_total'];
			$optTerms = $invoicePrint['fn_inv_opt_terms'];
			$optTermsBus = $invoicePrint['fn_inv_opt_terms_bus'];
			$optTaxTableAlign = $invoicePrint['fn_inv_tax_table_align'];
		} else {
			$businessPrint = $lDB->get("
				SELECT
					pr_bus_opt_accomm,
					pr_bus_opt_bank,
					pr_bus_opt_cca,
					pr_bus_opt_date,
					pr_bus_opt_special,
					pr_bus_opt_special_note,
					pr_bus_opt_tax,
					pr_bus_opt_tax_table,
					pr_bus_opt_tax_table_gl,
					pr_bus_opt_tax_table_rate,
					pr_bus_opt_tax_table_total,
					pr_bus_opt_terms,
					pr_bus_opt_terms_bus,
					pr_bus_tax_table_align
				FROM
					pr_business
				WHERE
					pr_business_id = '$invoicePrint[pr_business_id]'
			",1);
			list($optAccomm,$optBank,$optCCA,$optDate,$optSpecial,$optSpecialNote,$optTax,$optTaxTable,$optTaxTableGL,$optTaxTableRate,$optTaxTableTotal,$optTerms,$optTermsBus,$optTaxTableAlign) = $businessPrint;
		}

		$itemTotal = 0;

		foreach ( $result['invoiceItems'] as $item ) {
			$itemTotal += $item['fn_inv_item_amount'];
		}

		$result['docTitle'] = $lDB->get("SELECT rf_invoice_title FROM rf_default",4);

		if($invoiceExchange['fn_inv_type_ind'] == DB_FN_INVOICE_TYPE_CREDIT) {
			$result['docTitle'] = "Credit Note";
		}

		if($invoiceExchange['fn_inv_status_ind'] == DB_FN_INVOICE_STATUS_UNLINKED) {
			if($invoiceExchange['fn_inv_void_yn'] == "1") {
				$result['docTitle'] = "Void " . $result['docTitle'];
				$GLOBALS['temp']['docTitleClass'] = "color: #f00;";
				$GLOBALS['temp']['docSubTitleClass'] = "color: #f00;";
			}
			if($invoiceExchange['fn_inv_reverse_ind'] == DB_FN_INVOICE_REVERSE_CHILD) {
				$result['docTitle'] .= " (reversal)";
			}
		}

		if ( $renderMode == "html" ) {
			$result['docTitle'] = "Preview " . $result['docTitle'];
		}

		if ( $invoicePrint['fn_inv_print_count'] > 0 ) {
			$result['docTitle'] = 'Copy ' . $result['docTitle'];
		}

		$GLOBALS['temp']['printCount'] = $invoicePrint['fn_inv_print_count'];

		$result['invDate'] = chng_date($lDB->get("SELECT fn_inv_date FROM fn_invoice WHERE fn_invoice_ix = '$invoiceId'",4),"-");

		$GLOBALS['temp']['hideCustNotes'] = "display: none;";

		$result['invoicePaymentList'] = $lDB->get("
			SELECT
				fn_inv_payment_date,
				fn_inv_payment_payer,
				fn_inv_payment_ref,
				fn_inv_payment_method,
				fn_inv_payment_bank,
				fn_inv_payment_curr,
				fn_inv_payment_amt
			FROM
				fn_invoice_payment
			WHERE
				fn_invoice_payment.fn_invoice_id = '$invoiceId'
				AND (
					fn_invoice_payment.rv_payment_contra_id IS NULL
					OR fn_invoice_payment.rv_payment_contra_id = '0'
					OR fn_invoice_payment.rv_payment_contra_id = ''
				)
		",2);

		$result['invoicePaymentTotal'] = 0;

		foreach ( $result['invoicePaymentList'] as $invoicePaymentItem ) {
			$result['invoicePaymentTotal'] += $invoicePaymentItem['fn_inv_payment_amt'];
		}

		$result['invoicePaymentOutstanding'] = $itemTotal - $result['invoicePaymentTotal'];

		fixAmtDisplay($result['invoicePaymentTotal'],2);
		fixAmtDisplay($result['invoicePaymentOutstanding'],2);

		$result['invoiceTaxTable'] = $lDB->get("
			SELECT
				fn_invoice_item_tax.fn_invoice_item_tax_desc,
				fn_invoice_item_tax.fn_invoice_item_tax_perc,
				SUM(fn_invoice_item_tax.fn_invoice_item_tax_amt) AS fn_invoice_item_tax_amt,
				fn_invoice.fn_inv_exch_rate
			FROM
				fn_invoice_item_tax
				INNER JOIN fn_invoice_item ON fn_invoice_item.fn_invoice_item_ix = fn_invoice_item_tax.fn_invoice_item_id
				INNER JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_invoice_item.fn_invoice_id
			WHERE
				fn_invoice_item.fn_invoice_id = '$invoiceId'
				AND fn_invoice_item_tax.fn_invoice_item_tax_inactive_yn = '0'
			GROUP BY
				fn_invoice_item_tax.fn_invoice_item_tax_seq,
				fn_invoice_item_tax.fn_invoice_item_tax_desc
		",2);

		$commList = [];
	}
	$GLOBALS['temp']['consolidatedLabel'] = stripslashes($consolidatedLabel);

	$commList[] = $result['rv_commission_perc'];
	$commList = array_unique($commList);

	if(sizeof($commList) > 1) {
		$result['rv_commission_perc'] = "multiple";
	}

	if($docType == DOC_RESERVATION) {
		$tmp = getPayItems($resId,false,true);
		$result['payOutstanding'] = $tmp['outstanding'];
		$result['payedTotal'] = $tmp['payedTotal'];
		$result['payTotal'] = isset($tmp['payTotal'])?$tmp['payTotal']:"";
		$result['payItems'] = $tmp['items'];
		$result['payInvItems'] = $tmp['splitItems'];
		$result['payedItems'] = $tmp['payments'];
		$result = array_merge($result,getPayItems($resId,false,true));

		$tmp2 = getPayItems($resId,false,false);
		$result['payOutstanding2']	= $tmp2['outstanding'];
		$result['payTotal2'] = isset($tmp2['payTotal'])?$tmp2['payTotal']:"";
		$result['payItems2'] = $tmp2['items'];
		$result['payInvItems2'] = $tmp2['splitItems'];
		$result['payedItems2'] = $tmp2['payments'];
		$result['compTotals'] = getCompTotals($resId);
		$result['exchange'] = getExchange($resId);
		$result = array_merge($result,getResDocTotals($resId, $result['resItems'], $result['resExtras'], $result['resTravel'], "1"));
	} else {
		$tmp = getPayItems($resId,false,true,$folioId);

		$folioTotal = $lDB->get("SELECT fn_folio_amount FROM fn_folio WHERE fn_folio_ix = '$folioId'",4);

		$outstand = $folioTotal - $tmp['payedTotal'];
		fixAmtDisplay($outstand,2);

		if($tmp['outstanding'] == "TBA") {
			$outstand = "TBA";
		}
		$result['payOutstanding'] = $outstand;
		$result['payedTotal'] = $tmp['payedTotal'];
		$result['payTotal'] = $tmp['payTotal'];
		$result['payItems'] = $tmp['items'];
		$result['payInvItems'] = $tmp['splitItems'];
		$result['payedItems'] = $tmp['payments'];
		$result = array_merge($result,getPayItems($resId,false,false,$folioId));

		$tmp2 = getPayItems($resId,false,false,$folioId);
		$result['payOutstanding2']	= $tmp2['outstanding'];
		$result['payTotal2'] = $tmp2['payTotal'];
		$result['payItems2'] = $tmp2['items'];
		$result['payInvItems2'] = $tmp2['splitItems'];
		$result['payedItems2'] = $tmp2['payments'];
		$result['compTotals'] = getCompTotals($resId);
		$result['exchange'] = getExchange($resId);

		$result['compTotals'] = getCompTotals($resId,false,$folioId);
		$result['exchange'] = getExchange($resId, $folioId);
		$result = array_merge($result,getResDocTotals($resId, $result['resItems'], $result['resExtras'], $result['resTravel'], "1"));
	}


	// Per person charges
	$result['perPersonItems'] = [];
	if($docType == DOC_RESERVATION || $docType == DOC_FOLIO) {
		$result['perPersonItems'] = getPerPerson($result['resItems']);
	}

	foreach($result['compTotals']['Accommodation'] as $key=>$item) {
		$excl = round($item['payAmt'] - $item['taxAmt'],2);
		fixAmtDisplay($excl,2);
		$result['compTotals']['Accommodation'][$key]['exclTax'] = $excl;
	}

	foreach($result['compTotals']['Accomm-Extras'] as $key=>$item) {
		$excl = round($item['payAmt'] - $item['taxAmt'],2);
		fixAmtDisplay($excl,2);
		$result['compTotals']['Accomm-Extras'][$key]['exclTax'] = $excl;
	}

	foreach($result['compTotals']['Extras'] as $key=>$item) {
		$excl = round($item['payAmt'] - $item['taxAmt'],2);
		fixAmtDisplay($excl,2);
		$result['compTotals']['Extras'][$key]['exclTax'] = $excl;
	}

	foreach($result['compTotals']['Travel'] as $key=>$item) {
		$excl = round($item['payAmt'] - $item['taxAmt'],2);
		fixAmtDisplay($excl,2);
		$result['compTotals']['Travel'][$key]['exclTax'] = $excl;
	}

	foreach($result['compTotals']['Totals'] as $key=>$item) {
		$excl = round($item['payAmt'] - $item['taxAmt'],2);
		fixAmtDisplay($excl,2);
		$result['compTotals']['Totals'][$key]['exclTax'] = $excl;
	}

	$GLOBALS['temp']['noAccomTotal'] = "txts";
	if(!isset($result['compTotals']['Accommodation'][0]) || $result['compTotals']['Accommodation'][0] == "") {
		$GLOBALS['temp']['noAccomTotal'] = "collapse printCollapse";
	}
	
	$GLOBALS['temp']['noAccomExtraTotal'] = "txts";
	if(!isset($result['compTotals']['Accomm-Extras'][0]) || $result['compTotals']['Accomm-Extras'][0] == "") {
		$GLOBALS['temp']['noAccomExtraTotal'] = "collapse printCollapse";
	}

	$GLOBALS['temp']['noExtraTotal'] = "txts";
	if((!isset($result['compTotals']['Extras'][0]) || $result['compTotals']['Extras'][0] == "") && (!isset($result['compTotals']['Accomm-Extras'][0]) || $result['compTotals']['Accomm-Extras'][0] == "")) {
		$GLOBALS['temp']['noExtraTotal'] = "collapse printCollapse";
	}
	
	$GLOBALS['temp']['noTravelTotal'] = "txts";
	if(!isset($result['compTotals']['Travel'][0]) || $result['compTotals']['Travel'][0] == "") {
		$GLOBALS['temp']['noTravelTotal'] = "collapse printCollapse";
	}

	$result['resNote'] = getReservationNote($resId);
	if(strtoupper($result['resNote']) == "FALSE") {
		$result['resNote'] = "";
	}

	$result['resGuestNote'] = $lDB->get("SELECT rv_note_guests FROM rv_reservation WHERE	rv_reservation_ix = '$resId'",4);
	$result['resInternalNote'] = $lDB->get("SELECT rv_note_internal FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
	$result['cancelNote'] = trim($lDB->get("SELECT rv_cancel_reason FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4));

	$guestCountryId = trim($lDB->get("SELECT rf_country_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'", 4));
	if($guestCountryId == "0" || $guestCountryId == "") {
		$guestNationality = "";
	} else {
		$guestNationality = trim($lDB->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '$guestCountryId'", 4));
		if ( $guestNationality == "0" ) {
			$guestNationality = "";
		} else {
			$guestNationality = "Nationality: " . $guestNationality;
		}
	}

	$result['guestNationality']	= $guestNationality;
	$result['proformaNote']	= $proformaNote;

	$result = array_merge($result,getBusinessDetails($resId,$folioId,$invoiceId,$docType,$selectedBanks,$options));

	$result['rooming'] = getReservationRooming($resId);

	// FOLIO START
	$invoiceDateDefault = $lDB->get("SELECT fn_folio_date FROM fn_folio WHERE fn_folio_ix = '$folioId'",4);
	$GLOBALS['temp']['invoiceDate'] = $invoiceDateDefault;

	$busList = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_persona_ix,
			pr_business.pr_bus_home_curr_id,
			rf_currency.rf_currency_symbol
		FROM
			pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
			INNER JOIN rf_currency ON rf_currency_ix = pr_business.pr_bus_home_curr_id
		WHERE
			pr_bus_billing_yn = '1'
			OR pr_bus_billing_prop_yn = '1'
		ORDER BY
			pr_business_sequence
	",2);

	foreach ( $busList as $key => $item ) {
		$folioList = $lDB->get("
			SELECT
				fn_folio.fn_folio_ix,
				fn_folio.fn_folio_folio_num,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last,
				fn_folio.rf_currency_id,
				rf_currency.rf_currency_symbol
			FROM
				fn_folio
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			WHERE
				fn_folio.rv_reservation_id = '$resId'
				AND fn_folio.pr_business_id = '$item[pr_persona_ix]'
				AND (
					fn_folio.fn_invoice_id = ''
					OR fn_folio.fn_invoice_id = '0'
					OR fn_folio.fn_invoice_id IS NULL
				)
		",2);
		$busList[$key]['folioList'] = $folioList;

		foreach($folioList as $folioKey => $folioItem) {
			$busList[$key]['folioList'][$folioKey]['paymentTotal'] = $lDB->get("
				SELECT
					SUM(rv_payment_item_amt)
				FROM 
					rv_payment_item 
				WHERE 
					fn_folio_id = '$folioItem[fn_folio_ix]'
			",4);
			fixAmtDisplay($busList[$key]['folioList'][$folioKey]['paymentTotal']);

			$busList[$key]['folioList'][$folioKey]['pr_name'] = trim($folioItem['pr_name_first'] . " " . $folioItem['pr_name_last']);
			if($busList[$key]['folioList'][$folioKey]['pr_name'] == "") {
				$busList[$key]['folioList'][$folioKey]['pr_name'] = "Cash";
			}

			$exclTotal = 0;
			$taxTotal = 0;
			$payableTotal = 0;

			$accommAll = $lDB->get("
				SELECT
					'$consolidatedLabel' as rt_component_desc,
					SUM(rv_res_item_comp.rv_item_comp_amt_comm) as rv_item_comp_amt_comm,
					SUM(rv_res_item_comp.rv_item_comp_amt_gross) as rv_item_comp_amt_gross,
					SUM(rv_res_item_comp.rv_item_comp_amt_nett) as rv_item_comp_amt_nett,
					SUM(rv_res_item_comp.rv_item_comp_amt_payable) as rv_item_comp_amt_payable,
					SUM(rv_res_item_comp.rv_item_comp_amt_tax) as rv_item_comp_amt_tax,
					rv_reservation.rv_commission_deduct_yn,
					rv_res_item_comp.rv_item_comp_tax_perc,
					COUNT(rv_res_item_comp.rv_res_item_comp_id) as accommCount,
					COUNT(rv_reservation_item.rv_reservation_item_ix) as itemCount,
					rv_res_item_comp.rv_item_comp_separate_yn,
					IF(rv_res_item_comp.rt_tax_ind = 10, rf_tax_rate.rf_tax_rate_desc, rt_tax_group.rt_tax_group_desc) AS taxDesc
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
					LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
					LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp.rt_tax_id
					LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_res_item_comp.rt_tax_id
				WHERE
					rv_reservation_item.fn_folio_id = '$folioItem[fn_folio_ix]'
					AND (
						rv_res_item_comp.rv_item_comp_separate_yn = 0
						OR rt_component.rt_component_id IS NULL
					)
				GROUP BY
					rv_reservation_ix,
					rv_res_item_comp.rt_tax_id, rv_res_item_comp.rt_tax_ind
			",2);

			$accommList = $lDB->get("
				SELECT
					rt_component.rt_component_desc,
					rv_res_item_comp.rv_item_comp_tax_perc,
					SUM(rv_res_item_comp.rv_item_comp_amt_gross) as rv_item_comp_amt_gross,
					SUM(rv_res_item_comp.rv_item_comp_amt_nett) as rv_item_comp_amt_nett,
					SUM(rv_res_item_comp.rv_item_comp_amt_payable) as rv_item_comp_amt_payable,
					SUM(rv_res_item_comp.rv_item_comp_amt_tax) as rv_item_comp_amt_tax,
					rv_reservation.rv_commission_deduct_yn,
					rv_res_item_comp.rv_item_comp_separate_yn,
					IF(rv_res_item_comp.rt_tax_ind = 10, rf_tax_rate.rf_tax_rate_desc, rt_tax_group.rt_tax_group_desc) AS taxDesc
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
					LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
					LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp.rt_tax_id
					LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_res_item_comp.rt_tax_id
				WHERE
					rv_reservation_item.fn_folio_id = '$folioItem[fn_folio_ix]'
					AND rv_res_item_comp.rv_item_comp_separate_yn = 1
				GROUP BY
					rv_res_item_comp.rt_component_id,
					rv_res_item_comp.rt_tax_id, rv_res_item_comp.rt_tax_ind
			",2);
			
			$hasTBA = false;
			foreach($accommAll as $accommKey=>$accommItem) {
				if($accommItem['accommCount'] == 0 && $accommItem['itemCount'] > 0) {
					$accommAll[$accommKey]['rt_component_desc'] = stripslashes($consolidatedLabel);
					$accommAll[$accommKey]['rv_item_comp_amt_comm'] = "TBA";
					$accommAll[$accommKey]['rv_item_comp_amt_gross'] = "TBA";
					$accommAll[$accommKey]['rv_item_comp_amt_nett'] = "TBA";
					$accommAll[$accommKey]['rv_item_comp_amt_payable'] = "TBA";
					$accommAll[$accommKey]['rv_item_comp_amt_tax'] = "TBA";
					$accommAll[$accommKey]['rv_item_comp_tax_perc'] = "0.00";
					$hasTBA = true;
				}
			}

			if(sizeof($accommAll) > 0) {
				$accommList = array_merge($accommList,$accommAll);
			}

			foreach($accommList as $accommKey=>$accommItem) {
				if($accommItem['rv_commission_deduct_yn'] == 1) {
					$total = $accommItem['rv_item_comp_amt_nett'];
				} else {
					$total = $accommItem['rv_item_comp_amt_gross'];
				}
				$accommList[$accommKey]['rv_item_comp_amt_payable'] = $total;
				$accommList[$accommKey]['rv_item_comp_amt_excl'] = $total - $accommItem['rv_item_comp_amt_tax'];
				$exclTotal += ($total - $accommItem['rv_item_comp_amt_tax']);
				$taxTotal += $accommItem['rv_item_comp_amt_tax'];
				$payableTotal += $total;

				if($accommList[$accommKey]['rv_item_comp_amt_payable'] != "TBA") {
					fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_payable'],2);
					fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_tax'],2);
					fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_nett'],2);
					fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_gross'],2);
					fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_excl'],2);
				} else {
					$accommList[$accommKey]['rv_item_comp_amt_excl'] = "TBA";
				}
			}
			$busList[$key]['folioList'][$folioKey]['accommList'] = $accommList;

			$extraList = $lDB->get("
				SELECT
					ac_extra.ac_ext_desc,
					rv_extra.rv_extra_tax_perc,
					rv_extra.rv_extra_amt_gross,
					rv_extra.rv_extra_amt_nett,
					rv_extra.rv_extra_ix AS extra_id,
					(
						SELECT
							SUM(rv_extra_tax.rv_extra_tax_amt)
						FROM rv_extra_tax
							LEFT JOIN rv_extra ON rv_extra.rv_extra_ix = rv_extra_tax.rv_extra_id
						WHERE rv_extra_tax.rv_extra_id = extra_id
					) as rv_extra_amt_tax,
					rv_reservation.rv_commission_deduct_yn
				FROM
					rv_extra
					INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
				WHERE
					rv_extra.fn_folio_id = '$folioItem[fn_folio_ix]'
			",2);

			foreach($extraList as $extraKey=>$extraItem) {
				if($extraItem['rv_commission_deduct_yn'] == 1) {
					$total = $extraItem['rv_extra_amt_nett'];
				} else {
					$total = $extraItem['rv_extra_amt_gross'];
				}
				$extraList[$extraKey]['rv_extra_amt_payable'] = $total;
				$extraList[$extraKey]['rv_extra_amt_excl'] = $total - $extraItem['rv_extra_amt_tax'];

				$exclTotal += ( $total - $extraItem['rv_extra_amt_tax']);
				$taxTotal += $extraItem['rv_extra_amt_tax'];
				$payableTotal += $total;

				fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_gross']);
				fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_nett']);
				fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_payable']);
				fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_excl']);
				fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_tax']);
			}

			$busList[$key]['folioList'][$folioKey]['extraList'] = $extraList;

			fixAmtDisplay($exclTotal,2);
			fixAmtDisplay($taxTotal,2);
			fixAmtDisplay($payableTotal,2);

			$busList[$key]['folioList'][$folioKey]['exclTotal'] = $exclTotal;
			$busList[$key]['folioList'][$folioKey]['taxTotal'] = $taxTotal;
			$busList[$key]['folioList'][$folioKey]['payableTotal']	= $payableTotal;
			$busList[$key]['folioList'][$folioKey]['hasTBA'] = isset($hasTBA) ? $hasTBA : "";

			$outstanding = $payableTotal - $busList[$key]['folioList'][$folioKey]['paymentTotal'];
			fixAmtDisplay($outstanding);
			$busList[$key]['folioList'][$folioKey]['outstanding'] = $outstanding;
		}
	}

	$hideButton = "visibility: hidden;";
	if($action == 3) { $hideButton = ""; }

	$folioRows = "";
	foreach($busList as $item) {
		if(sizeof($item['folioList']) > 0) {
			$folioRows .= '
				<table width="100%" align="center" cellpadding="1" cellspacing="0" valign="top">
				<tr style="height: 15px;">
					<td class="txtbbr">' . t_encodeHTMLField($item['pr_name_last']) . '</td>
				</tr>
				</table>
				<table width="100%" border="0" cellpadding="0" cellspacing="0" summary="" align="center" valign="top">
				<tr style="height: 25px;">
					<td>
						<table width="100%" border="0" cellspacing="0" cellpadding="2" align="center" class="bt" style="table-layout: fixed;">
						<col width="50" />
						<col width="100" />
						<col width="63" />
						<col width="90" />
						<col width="55" id="taxCol10">
						<col width="51" id="taxCol11">
						<col width="52" id="taxCol12">
						<col width="80">
						<col width="80">
						<tr>
							<td class="outLt">Folio</td>
							<td class="outLt">Details</td>
							<td class="outLt">Summary</td>
							<td class="outLt">Description</td>
							<td align="center" class="outLt">Tax Rate</td>
							<td align="right" class="outLt">Excl Tax</td>
							<td align="right" class="outLt">Tax</td>
							<td align="right" class="outLt">Payable&nbsp;<span id="taxCol13"><br />(incl tax)</span></td>
							<td align="right" class="outLt">Amount Paid</td>
						</tr>
			';

			foreach($item['folioList'] as $folioItem) {
				$first				= true;
				$firstAccomm	= true;
				$firstExtra		= true;
				$showCurrency	= false;

				foreach($folioItem['accommList'] as $accommItem) {
					if($first) {
						$folioRows .= '
							<tr>
								<td class="br">' . $folioItem['fn_folio_folio_num'] . '</td>
								<td class="br">' . t_encodeHTMLField($folioItem['pr_name']) . '</td>
						';
					} else {
						if(!$showCurrency) {
							$currency = t_encodeHTMLField($folioItem['rf_currency_symbol']);
							$showCurrency = true;
						} else {
							$currency = "&nbsp;";
						}
						$folioRows .= '
							<tr valign="top">
								<td class="br"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="1" alt="" /></td>
								<td class="br">' . $currency . '</td>
						';
					}

					if($firstAccomm) {
						$folioRows .= '<td class="br">Accomm</td>';
					} else {
						$folioRows .= '<td class="br"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="1" alt="" /></td>';
					}

					$folioRows .= '
							<td class="br">' . t_encodeHTMLField($accommItem['rt_component_desc']) . '</td>
							<td class="br" align="right">' . $accommItem['taxDesc'] . '</td>
							<td class="br" align="right">' . $accommItem['rv_item_comp_amt_excl'] . '</td>
							<td class="br" align="right">' . $accommItem['rv_item_comp_amt_tax'] . '</td>
							<td class="br" align="right">' . $accommItem['rv_item_comp_amt_payable'] . ' ' . t_encodeHTMLField($folioItem['rf_currency_symbol']) . '</td>
							<td class="br" align="right"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="1" alt="" /></td>
						</tr>
					';
					$first				= false;
					$firstAccomm	= false;
				}

				$firstExtra = true;
				foreach($folioItem['extraList'] as $extraItem) {
					if($first) {
						$folioRows .= "
							<tr>
								<td class=\"br\">$folioItem[fn_folio_folio_num]</td>
								<td class=\"br\">".t_encodeHTMLField($folioItem['pr_name'])."</td>
						";
					} else {
						if(!$showCurrency) {
							$currency = t_encodeHTMLField($folioItem['rf_currency_symbol']);
							$showCurrency = true;
						} else {
							$currency = "&nbsp;";
						}
						$folioRows .= "
							<tr valign=\"top\">
								<td class=\"br\">&nbsp;</td>
								<td class=\"br\">$currency</td>
						";
					}
					if($firstExtra) {
						$folioRows .= "
							<td class=\"br\">Extras</td>
						";
						$firstExtra = false;
					} else {
						$folioRows .= "
							<td class=\"br\">&nbsp;</td>
						";
					}
					$folioRows .= "
							<td class=\"br\">".t_encodeHTMLField($extraItem['ac_ext_desc'])."</td>
							<td class=\"br\" align=\"right\">$extraItem[rv_extra_tax_perc]%</td>
							<td class=\"br\" align=\"right\">$extraItem[rv_extra_amt_excl]</td>
							<td class=\"br\" align=\"right\">$extraItem[rv_extra_amt_tax]</td>
							<td class=\"br\" align=\"right\">$extraItem[rv_extra_amt_payable] ".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
							<td class=\"br\" align=\"right\">&nbsp;</td>
						</tr>
					";
					$first = false;
				}
				if(!$showCurrency) {
					$folioRows .= "
						<tr valign=\"top\">
							<td class=\"br\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
							<td class=\"br\">".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
							<td align=\"center\" class=\"br\">&nbsp;</td>
							<td class=\"br\">&nbsp;</td>
							<td class=\"br\">&nbsp;</td>
							<td class=\"br\" align=\"right\">&nbsp;</td>
							<td class=\"br\" align=\"right\">&nbsp;</td>
							<td class=\"br\" align=\"right\">&nbsp;</td>
							<td class=\"br\" align=\"right\">&nbsp;</td>
						</tr>
					";
				}

				$folioRows .= "
					<!--TOTALS-->
					<tr valign=\"top\">
						<td class=\"bt\">&nbsp;</td>
						<td class=\"bt\">&nbsp;</td>
						<td class=\"br bt\">&nbsp;</td>
						<td class=\"txtb br bt bb colLtt\">TOTALS</td>
						<td class=\"br bt bb\" align=\"right\">&nbsp;</td>
						<td class=\"br bt bb\" align=\"right\">$folioItem[exclTotal]</td>
						<td class=\"br bt bb\"align=\"right\">$folioItem[taxTotal]</td>
						<td class=\"br bt bb\" align=\"right\">$folioItem[payableTotal] ".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
						<td class=\"br bt bb\" align=\"right\">$folioItem[paymentTotal] ".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
					</tr>
					<!--END TOTALS-->
				";
			}
			$folioRows .= "
						</table>
					</td>
				</tr>
				</table>
			";
		}
	}
	$GLOBALS['temp']['folioRows'] = $folioRows;
	// FOLIO END

	$result['invoice'] = $lDB->get("
		SELECT
			fn_invoice.fn_invoice_ix,
			fn_invoice.fn_inv_date,
			fn_invoice.fn_inv_from,
			fn_invoice.fn_inv_to,
			fn_invoice.fn_inv_print_count,
			fn_invoice.fn_folio_id,
			SUM(fn_invoice_item.fn_inv_item_amt_comm) as fn_invoice_amt_comm,
			SUM(fn_invoice_item.fn_inv_item_amt_tax) as fn_invoice_amt_tax,
			SUM(fn_invoice_item.fn_inv_item_amount) as fn_invoice_amount,
			fn_invoice.fn_inv_curr
		FROM
			fn_invoice
			INNER JOIN fn_invoice_item ON fn_invoice_item.fn_invoice_id = fn_invoice.fn_invoice_ix
		WHERE
			fn_invoice.rv_reservation_id = '$resId'
		GROUP BY
			fn_invoice.fn_invoice_ix
	",2);

	foreach($result['invoice'] as $key=>$item) {
		$amountPaid = $lDB->get("
			SELECT
				SUM(rv_payment_item_amt)
			FROM
				rv_payment_item
			WHERE
				rv_payment_item.fn_folio_id = '$item[fn_folio_id]'
		",4);
		if($amountPaid == "") {
			$amountPaid = "0";
		}
		$result['invoice'][$key]['fn_invoice_amt_paid'] = $amountPaid;
		$exclTax = $item['fn_invoice_amount'] - $item['fn_invoice_amt_tax'];
		$result['invoice'][$key]['fn_invoice_amt_excl'] = $exclTax;
		$result['invoice'][$key]['fn_inv_date'] = chng_date($item['fn_inv_date'],"-");
		fixAmtDisplay($result['invoice'][$key]['fn_invoice_amt_comm']);
		fixAmtDisplay($result['invoice'][$key]['fn_invoice_amt_tax']);
		fixAmtDisplay($result['invoice'][$key]['fn_invoice_amt_excl']);
		fixAmtDisplay($result['invoice'][$key]['fn_invoice_amt_paid']);
		fixAmtDisplay($result['invoice'][$key]['fn_invoice_amount']);
	}

	$result = array_merge($result,getContactInfo($resId,$result,$docType));

	if ($userStatusId < 2) {
		$GLOBALS['temp']['resInternalNote'] = "";
		$GLOBALS['temp']['guestNationality'] = "";
		$GLOBALS['temp']['hideCustNotes'] = "display: none;";
		$GLOBALS['temp']['extraMemo'] = "";
		$GLOBALS['temp']['travelMemo'] = "";
		$result['invoice'] = array();
		$GLOBALS['temp']['folioRows'] = "";
		/*$result['compTotals'] = array();
		$result['acc_comm'] = "";
		$result['ext_comm'] = "";
		$result['tra_comm'] = "";*/
		//$result['total_comm'] = "";
	}

	$mergedExtra = array();	
	$totalExtras = array_merge($result['resExtras'], $result['resTravel'], $result['resAccomExtras']);
	foreach($totalExtras as $extra) {
		$mergedExtra[strtotime($extra['rv_extra_date_serv'])][] = $extra;
	}
	ksort($mergedExtra);

 // [START] HTML Section
	if(isset($renderMode) && $renderMode == "html") {
		if(isset($GLOBALS['temp']['guestNationality']) && $GLOBALS['temp']['guestNationality'] != "") {
			$GLOBALS['temp']['guestNationality'] = "<br>$guestNationality<br><br>";
		}
		if(trim($result['resInternalNote']) != "") {
			$result['resInternalNote'] = t_encodeHTML($result['resInternalNote']);
			$result['resInternalNote'] = "<u>Reservation Internal Memos</u><br>".trim($result['resInternalNote']) . "<br>";
		}
		
		// Reservation Extras
		$resExtraHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_res_extra_rows.htm"));
		$resExtraRows = "";

		// Sort extra by service date
		$col = array_column( $result['resExtras'], "rv_extra_date_serv" );
		array_multisort( $col, SORT_ASC, $result['resExtras'] );

		foreach($result['resExtras'] as $item) {
			if($item['rv_extra_supplier_conf_yn']) {
				$item['supplier_name'] = "";
			}
			if(!$item['rv_extra_ref']) {
				$item['rv_extra_ref'] = "";
			}
						
			$item['pr_name_last'] = t_encodeHTMLField($item['pr_name_last']);
			$item['ac_extra_cat_desc'] = t_encodeHTMLField($item['ac_extra_cat_desc']);
			$item['ac_ext_desc'] = t_encodeHTMLField($item['ac_ext_desc']);
			$item['supplier_name'] = t_encodeHTMLField($item['supplier_name']);
			$item['rv_extra_ref'] = t_encodeHTMLField($item['rv_extra_ref']);
			removeBlank($item);
			$resExtraRows .= showpage($item,$resExtraHTML);
		}
		
		if($resExtraRows == "") {
			$resExtraRows = "
				<tr>
					<td colspan=\"7\" align=\"center\">No extras</td>
				</tr>
			";
			$GLOBALS['temp']['showExtras'] = "collapse printCollapse";
		}
		
		$GLOBALS['temp']['resExtraRows'] = $resExtraRows;
		
		// Reservation Travel
		$resTravelRows = "";
		$resExtraTravelHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_res_extra_travel_rows.htm"));
		foreach($result['resTravel'] as $item) {
			if($item['rv_extra_supplier_conf_yn']) {
				$item['supplier_name']= "";
			}
												
			$item['pr_name_last'] = t_encodeHTMLField($item['pr_name_last']);
			$item['ac_extra_cat_desc'] = t_encodeHTMLField($item['ac_extra_cat_desc']);
			$item['ac_ext_desc'] = t_encodeHTMLField($item['ac_ext_desc']);
			$item['supplier_name'] = t_encodeHTMLField($item['supplier_name']);
			$item['rv_extra_ref'] = t_encodeHTMLField($item['rv_extra_ref']);
			removeBlank($item);
			$resTravelRows .= showpage($item,$resExtraTravelHTML);
		}
		if($resTravelRows == "") {
			$resTravelRows = "
				<tr>
					<td colspan=\"7\" align=\"center\">No travel</td>
				</tr>
			";
			$GLOBALS['temp']['showTravel'] = "collapse printCollapse";
		}
		
		$GLOBALS['temp']['resTravelRows'] = $resTravelRows;
				
		// Accommodation Extras
		$resAccomExtraRows = "";
		if($docType == DOC_RESERVATION || $docType == DOC_FOLIO) {
			$resExtraAccomHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_res_extra_accom_rows.htm"));
			
			foreach($result['resAccomExtras'] as $item) {
				if($item['rv_extra_supplier_conf_yn']) {
					$item['supplier_name']= "";
				}
				
				if($item['rv_extra_date_depart'] != "" && $item['rv_extra_date_depart'] != "0000-00-00") {
					$item['rv_extra_date_depart'] = chng_date($item['rv_extra_date_depart'], "-");
					$item['rv_extra_date_serv'] = chng_date($item['rv_extra_date_serv'], "-");
				} else {
					$item['rv_extra_date_depart'] = "";
					$item['rv_extra_date_serv'] =  "";
				}
				if($item['pr_name_last'] != "" && $item['pr_name_last'] != "&nbsp;") {
					$item['ac_ext_desc'] = $item['ac_ext_desc']." (".$item['pr_name_last'].")";
				}
				
				$item['pr_name_last'] = t_encodeHTMLField($item['pr_name_last']);
				$item['ac_extra_cat_desc'] = t_encodeHTMLField($item['ac_extra_cat_desc']);
				$item['ac_ext_desc'] = t_encodeHTMLField($item['ac_ext_desc']);
				$item['supplier_name'] = t_encodeHTMLField($item['supplier_name']);
				$item['rv_extra_ref'] = t_encodeHTMLField($item['rv_extra_ref']);
				removeBlank($item);
				$resAccomExtraRows .= showpage($item,$resExtraAccomHTML);
			}

			if($resAccomExtraRows == "" || $docType == DOC_FOLIO) {
				$resAccomExtraRows = "
					<tr>
						<td colspan=\"7\" align=\"center\">No accommodation extras.</td>
					</tr>
				";
				$GLOBALS['temp']['showAccomExtras'] = "collapse printCollapse";
			}
		
		} else {
			$GLOBALS['temp']['showAccomExtras'] = "collapse printCollapse";
		}

		$extraNote = "";
		$extraMemo = "";
		foreach($mergedExtra as $resExtra) {
			foreach($resExtra as $item) {
				if(isset($item['rv_res_item_group_ix'])) {
					// Only guests that are linked to the group and have a group set (i.e. are not orphaned)
					$guestList = $lDB->get("
					SELECT
						pr_persona.pr_name_first,
						pr_persona.pr_name_last
					FROM
						rv_res_item_guest
						INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
					WHERE
						rv_res_item_guest.rv_res_item_group_id = '".$item['rv_res_item_group_ix']."'
					",2);
				}
				else {
					// We don't want to pull any guests
					$guestList = [];
				}

				$roomInfo = trim($item['ac_desc']);
				
				$guestNames = "";
				foreach($guestList as $guestItem) {
					if($guestNames != "") {
						$guestNames .= ", ";
					}
					$guestNames .= trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
				}
				if($roomInfo != "" && $guestNames != "") {
					$roomInfo .= ": ";
				}
				if($guestNames != "") {
					$roomInfo .= $guestNames;
				}
				if($roomInfo != "") {
					$roomInfo = "[$roomInfo]<br>";
				}

				$extraDate = chng_date($item['rv_extra_date_serv'], "-");
				if (trim($extraDate) == "" || $extraDate == "0") {
					$extraDate = "";
				} else {
					$extraDate .= ":";
				}

				$item['rv_extra_date_serv'] = chng_date($item['rv_extra_date_serv'], "-");
				if($item['rv_extra_date_depart'] != "" && $item['rv_extra_date_depart'] != "0000-00-00") {
					$item['rv_extra_date_depart'] = chng_date($item['rv_extra_date_depart'], "-");
				} else {
					$item['rv_extra_date_depart'] = "";
				}
				
				if($item['pr_name_last'] != "" && $item['pr_name_last'] != "&nbsp;") {
					$propName = "&nbsp;<u>".t_encodeHTMLField($item['pr_name_last'])."</u>";
				} else {
					$propName = "";
				}
				if(trim($item['rv_extra_note']) != "" && $item['rv_extra_note'] != "0") {
					if($item['rv_extra_ind'] == 3) {
						$extraNote .= "<b>".$item['rv_extra_date_serv']." to ". $item['rv_extra_date_depart']. 
							"</b>".$propName.":  ". $item['ac_ext_desc']." - ".trim(t_encodeHTMLField($item['ac_desc'])). " (". t_encodeHTMLField($item['ac_extra_cat_desc']).") - " . t_encodeHTMLField($item['rv_extra_note']) . "<br />
						";
					} else {
						$extraNote .= "<b>".$item['rv_extra_date_serv']."</b>".$propName.": ".t_encodeHTMLField($item['ac_ext_desc'])." (".t_encodeHTMLField($item['ac_extra_cat_desc']). ") -".$roomInfo. t_encodeHTMLField($item['rv_extra_note'])."<br>
							";
					}
					$extraNote .= "<br>";
				}
				if(trim($item['rv_extra_note_internal']) != "" && $item['rv_extra_note_internal'] != "0" ) {
					if($item['rv_extra_ind'] == 3) {
						$extraMemo .= "<b>".$item['rv_extra_date_serv']." to ". $item['rv_extra_date_depart']. 
							"</b>".$propName.":  ". t_encodeHTMLField($item['ac_ext_desc'])." - ".trim(t_encodeHTMLField($item['ac_desc'])). " (". t_encodeHTMLField($item['ac_extra_cat_desc']).") - " . t_encodeHTML(t_encodeHTMLField($item['rv_extra_note_internal'])) . "<br />
						";
					} else {
						$extraMemo .= "<b>".$item['rv_extra_date_serv']."</b>".$propName.": ".t_encodeHTMLField($item['ac_ext_desc'])." (".t_encodeHTMLField($item['ac_extra_cat_desc']). ") -".$roomInfo. t_encodeHTML(t_encodeHTMLField($item['rv_extra_note_internal']))."<br>
						";
					}
					$extraMemo .= "<br>";
				}
			}
		}
		
		$GLOBALS['temp']['extraNote'] = $extraNote;
		if($extraMemo != "") {
			$extraMemo = "<u>Extras Internal Memos</u><br>".$extraMemo;
		}
		$GLOBALS['temp']['extraMemo'] = $extraMemo;
			
		$GLOBALS['temp']['resAccomExtraRows'] = $resAccomExtraRows;

		global $domain;
				
		if(file_exists("$GLOBALS[images_dir_on_disk]/".$GLOBALS['principal_id']."/".$logoFilename)) {	
			$GLOBALS['temp']['logoURL'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/$logoFilename";
		} else {
			$GLOBALS['temp']['logoURL'] = "/resource/Resrequest/Application/public/img/1x1.gif";
		}

		if(trim($result['resNote']) != "") {
			$result['resNote'] = t_encodeHTML($result['resNote']);
		}
		if(trim($result['resGuestNote']) != "") {
			$result['resGuestNote'] = t_encodeHTML($result['resGuestNote']);
		}
		$GLOBALS['temp'] = array_merge($result, $GLOBALS['temp']);
		$GLOBALS['temp']['fromAddress'] = t_encodeHTML($result['fromAddress']);

		if($result['rf_reservation_status_id'] == 20) {
			$GLOBALS['temp']['showExpiryDate'] = "";
		} else {
			$GLOBALS['temp']['showExpiryDate'] = "class=\"collapse\"";
		}

		$GLOBALS['temp']['contactDetail'] = t_encodeHTML($GLOBALS['temp']['contactDetail'])."<BR>";
		$toggleResDet = ($toggleMap & 524288) == 524288;
		if($useResDetailDefault == "1") {
			if(sizeof($result['resItems']) < 1) {
				$toggleResDet = false;
			} else {
				$toggleResDet = true;
			}
		}
		if($docType == DOC_INVOICE) {
			$toggleResDet = true;
		}

		if($toggleResDet == "0") {
			$GLOBALS['temp']['contactDetail'] .= "Res No: $result[rv_reservation_id]<BR>";
			if(isset($result['folio_room_desc']) && trim($result['folio_room_desc']) != "") {
				$GLOBALS['temp']['contactDetail'] .= "Room: ".$result['folio_room_desc'] . "<BR>";
			}
			if($docType == DOC_INVOICE) {
				$GLOBALS['temp']['contactDetail'] .= "Invoice Date: $result[invDate]<BR>";
			}
		}

		$GLOBALS['temp']['agentDetail'] = t_encodeHTML($GLOBALS['temp']['agentDetail']);
		$GLOBALS['temp']['consultantDetail'] = t_encodeHTML($GLOBALS['temp']['consultantDetail']);
		$GLOBALS['temp']['billingContactDetail'] = t_encodeHTML($GLOBALS['temp']['billingContactDetail']);

		$GLOBALS['temp']['hideOptions'] = "";
		$GLOBALS['temp']['allowResDet'] = "expand";
		$GLOBALS['temp']['allowResAccomm'] = "collapse printCollapse";
		$GLOBALS['temp']['allowServiceDate'] = "collapse printCollapse";
		$GLOBALS['temp']['allowTaxTable'] = "collapse printCollapse";
		$GLOBALS['temp']['allowTaxTableGL'] = "collapse printCollapse";
		$GLOBALS['temp']['allowTaxTableRate'] = "collapse printCollapse";
		$GLOBALS['temp']['allowTaxTableTotal'] = "collapse printCollapse";
		$GLOBALS['temp']['allowPayPlan'] = "expand";
		$GLOBALS['temp']['allowPayReceipts'] = "expand";
		$GLOBALS['temp']['allowPerPerson'] = "expand";
		$GLOBALS['temp']['allowResNote'] = "expand";
		$GLOBALS['temp']['allowBankDetails'] = "expand";
		$GLOBALS['temp']['allowBankList'] = "expand";
		$GLOBALS['temp']['allowCreditCard'] = "expand";
		$GLOBALS['temp']['allowGuestInformation'] = "expand";
		$GLOBALS['temp']['allowCommission'] = "expand";
		$GLOBALS['temp']['allowRooming'] = "expand";
		$GLOBALS['temp']['allowGuestNote'] = "expand";
		$GLOBALS['temp']['allowGuestMemo'] = "expand";
		$GLOBALS['temp']['allowExchNote'] = "expand";
		$GLOBALS['temp']['allowExtraNote'] = "expand";
		$GLOBALS['temp']['allowCostComponent'] = "expand";
		$GLOBALS['temp']['allowPropertyNote'] = "expand";
		if(empty($GLOBALS['temp']['allowReference'])) {
			$GLOBALS['temp']['allowReference'] = "expand";
		}
		if(empty($GLOBALS['temp']['allowServiceBy'])) {
			$GLOBALS['temp']['allowServiceBy'] = "expand";
		}
		$GLOBALS['temp']['allowCostSummary'] = "expand";
		$GLOBALS['temp']['allowInternalMemo'] = "expand";
		$GLOBALS['temp']['allowCancelNote'] = "expand";
		$GLOBALS['temp']['allowCancelledPayments'] = "expand";
		$GLOBALS['temp']['allowFolioList'] = "expand";
		$GLOBALS['temp']['allowInvoiceList'] = "expand";
		$GLOBALS['temp']['allowOriginator'] = "expand";
		$GLOBALS['temp']['allowRateTypeSummary'] = "expand";
		$GLOBALS['temp']['allowItemConsolidate'] = "collapse printCollapse";
		$GLOBALS['temp']['allowSpecial'] = "expand";
 
		$GLOBALS['temp']['invoiceHideClass'] = "expand";
		$GLOBALS['temp']['invoiceExchangeClass'] = "collapse printCollapse";
		$GLOBALS['temp']['hideCommission'] = "yes";
		$agentId = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'", 4);

		$agentName = getContactName($agentId);
		$GLOBALS['temp']['rv_agent_name'] = $agentName;
		if($agentName == ""){
			$GLOBALS['temp']['rv_agent_name'] = "Direct";
		}

		if($result['total_comm'] == 0 && ($agentId == "0" || trim($agentId) == "") ) {
			$GLOBALS['temp']['hideCommission'] = "yes";
		}

		if($docType != DOC_INVOICE) {
			$GLOBALS['temp']['hideTax'] = "";
			$rf_doc_settings = $lDB->get("SELECT rf_doc_settings FROM rf_default",4);
			if( ($rf_doc_settings & 33554432) != 33554432) {
				$GLOBALS['temp']['hideTax'] = "1";
			}
		}

		$GLOBALS['temp']['showTaxTable'] = "";
		$GLOBALS['temp']['showTaxTableGL'] = "";
		$GLOBALS['temp']['showTaxTableRate'] = "";
		$GLOBALS['temp']['showTaxTableTotal'] = "";
		$GLOBALS['temp']['taxTableRows'] = "";
		$GLOBALS['temp']['taxTableWithoutRatesRows'] = "";
		$GLOBALS['temp']['taxTableGLRows'] = "";
		$GLOBALS['temp']['taxTableGLWithoutRatesRows'] = "";

		
		if($docType == DOC_FOLIO) {
			$pr_bus_proforma_tax_ind = $lDB->get("
				SELECT
					pr_business.pr_bus_proforma_tax_ind
				FROM
					fn_folio
					INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
				WHERE
					fn_folio_ix = '$folioId'
			",4);
			switch($pr_bus_proforma_tax_ind) {
			case 1:
				$GLOBALS['temp']['hideTax'] = "";
				break;
			case 2:
				$GLOBALS['temp']['hideTax'] = "1";
				break;
			}

			$rf_doc_tax_table_yn = $lDB->get("SELECT rf_doc_tax_table_yn FROM rf_default",4);
			if($rf_doc_tax_table_yn == "1") {
				$GLOBALS['temp']['showTaxTable'] = "1";
			}
			$rf_doc_tax_table_rate_yn = $lDB->get("SELECT rf_doc_tax_table_rate_yn FROM rf_default",4);
			if($rf_doc_tax_table_rate_yn == "1") {
				$GLOBALS['temp']['showTaxTableRate'] = "1";
			}
			$rf_doc_tax_table_total_yn = $lDB->get("SELECT rf_doc_tax_table_total_yn FROM rf_default",4);
			if($rf_doc_tax_table_total_yn == "1") {
				$GLOBALS['temp']['showTaxTableTotal'] = "1";
			}
		}

		if ($userStatusId < 2) {
			$GLOBALS['temp']['allowInternalMemo'] = "collapse printCollapse";
			$GLOBALS['temp']['allowGuestMemo'] = "collapse printCollapse";
			$GLOBALS['temp']['allowCommission'] = "collapse printCollapse";
			$GLOBALS['temp']['allowCancelledPayments'] = "collapse printCollapse";
			$GLOBALS['temp']['allowCostComponent'] = "collapse printCollapse";
			$GLOBALS['temp']['allowFolioList'] = "collapse printCollapse";
			$GLOBALS['temp']['allowInvoiceList'] = "collapse printCollapse";

			$GLOBALS['temp']['resInternalNote'] = "";
			$GLOBALS['temp']['guestNationality'] = "";
			$GLOBALS['temp']['extraMemo'] = "";
			$GLOBALS['temp']['travelMemo'] = "";
			$result['invoice'] = array();
			$GLOBALS['temp']['folioRows'] = "";
			/*$result['compTotals'] = array();
			$result['acc_comm'] = "";
			$result['ext_comm'] = "";
			$result['tra_comm'] = "";*/
			//$result['total_comm'] = "";
		}

		$GLOBALS['temp']['paymentPlanDefault'] = "expand";
		$GLOBALS['temp']['paymentReceiptsDefault'] = "expand";
		$GLOBALS['temp']['showPerPerson'] = "collapse printCollapse";
		$GLOBALS['temp']['invoicePaymentClass'] = "collapse printCollapse";
		$GLOBALS['temp']['invoicePaidDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['exchangeRateDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['cancelNoteDefault'] = "collapse printCollapse";
		if($result['resNote'] != "") {
			$GLOBALS['temp']['resNoteDefault'] = "expand";
		} else {
			$GLOBALS['temp']['resNoteDefault'] = "collapse printCollapse";
		}
		$GLOBALS['temp']['guestInformationDefault'] = "expand";
		$GLOBALS['temp']['roomingDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['guestNoteDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['guestMemoDefault'] = "collapse printCollapse";
		if(trim($extraNote) != "") {
			$GLOBALS['temp']['extraNoteDefault'] = "expand";
		} else {
			$GLOBALS['temp']['allowExtraNote'] = "collapse printCollapse";
			$GLOBALS['temp']['extraNoteDefault'] = "collapse printCollapse";
		}
		$GLOBALS['temp']['internalMemoDefault'] = "collapse printCollapse";
		//$GLOBALS['temp']['bankDetailDefault'] = "expand";
		$GLOBALS['temp']['showCreditCard'] = "collapse printCollapse";
		if(sizeof($result['propertyNotes']) > 0) {
			$GLOBALS['temp']['propertyNoteDefault'] = "expand";
		} else {
			$GLOBALS['temp']['propertyNoteDefault'] = "collapse printCollapse";
		}
		if(isset($bookingTerms) && sizeof($bookingTerms) > 0) {
			$GLOBALS['temp']['bookingTermsDefault'] = "expand";
		} else {
			$GLOBALS['temp']['bookingTermsDefault'] = "collapse printCollapse";
		}
		$GLOBALS['temp']['standardNoteDefault'] = "expand";
		$GLOBALS['temp']['folioDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['invoiceDefault'] = "collapse printCollapse";

		if(trim($result['proformaNote']) == "") {
			$GLOBALS['temp']['showStandardNote'] = "collapse printCollapse";
		} else {
			$GLOBALS['temp']['showStandardNote'] = "expand";
			$GLOBALS['temp']['proformaNote'] = t_encodeHTML($result['proformaNote']);
		}
		if(trim($result['cancelNote']) == "") {
			$GLOBALS['temp']['allowCancelNote'] = "collapse printCollapse";
		}
		if(trim($result['resNote']) == "") {
			$GLOBALS['temp']['allowResNote'] = "collapse printCollapse";
		}
		if(trim($result['resGuestNote']) == "") {
			$GLOBALS['temp']['allowGuestInformation'] = "collapse printCollapse";
			$GLOBALS['temp']['guestInformationDefault'] = "collapse printCollapse";
		}
		if(sizeof($result['rooming']['notes']) == 0) {
			$GLOBALS['temp']['allowGuestNote'] = "collapse printCollapse";
		}
		if(sizeof($result['rooming']['memos']) == 0) {
			$GLOBALS['temp']['allowGuestMemo'] = "collapse printCollapse";
		}
		if(sizeof($result['invoice']) == 0) {
			$GLOBALS['temp']['allowInvoiceList'] = "collapse printCollapse";
		}
		if(trim($result['resInternalNote']) == "" && trim($result['guestNationality']) == "" && trim($extraMemo) == "") {
			$GLOBALS['temp']['allowInternalMemo'] = "collapse printCollapse";
		}

		// [START] Custom Notes
		$customNotes = $lDB->get("
			SELECT
				rf_note_custom.rf_note_custom_ix as custNoteId,
				rf_note_custom.rf_note_custom_desc as custNoteDesc,
				rf_note_custom.rf_note_custom_hdg as custNoteHdg
			FROM
				rf_note_custom
			ORDER BY
				rf_note_custom.rf_note_custom_desc
		",2);
		$customRows = "";
		$customIds = array();
		if(sizeof($customNotes) > 0) {
			foreach($customNotes as $custom) {
				$dbInd = $lDB->get("SELECT rf_database.rf_db_env_type_ind FROM rf_database WHERE rf_database.rf_db_code = '$GLOBALS[dbcode]'",4);
				if($dbInd == 2) {
					$checkDB = "AND rf_note_cust_default.rf_db_code = ''";
				} else {
					$checkDB = "AND rf_note_cust_default.rf_db_code = '$GLOBALS[dbcode]'";
				}
				// Get defaults
				$def = $lDB->get("
					SELECT
						rf_note_cust_def_ext_inv_yn,
						rf_note_cust_def_ext_summ_yn,
						rf_note_cust_def_ext_pro_yn,
						rf_note_cust_def_int_inv_yn,
						rf_note_cust_def_int_summ_yn,
						rf_note_cust_def_int_pro_yn
					FROM
						rf_note_cust_default
					WHERE
						rf_note_cust_default.rf_note_custom_id = '$custom[custNoteId]'
						$checkDB
				",1);
				$check = "";
				if($docType == DOC_RESERVATION) {
					if($userStatusId < 2) {
						if($def['rf_note_cust_def_ext_summ_yn'] == 1) {
							$check = "checked";
						}
					} else {
						if($def['rf_note_cust_def_int_summ_yn'] == 1) {
							$check = "checked";
						}
					}
				}
				if($docType == DOC_FOLIO) {
					if($userStatusId < 2){
						if($def['rf_note_cust_def_ext_pro_yn'] == 1) {
							$check = "checked";
						}
					} else {
						if($def['rf_note_cust_def_int_pro_yn'] == 1) {
							$check = "checked";
						}
					}
				}
				if($docType == DOC_INVOICE) {
					if($userStatusId < 2) {
						if($def['rf_note_cust_def_ext_inv_yn'] == 1) {
							$check = "checked";
						}
					} else {
						if($def['rf_note_cust_def_int_inv_yn'] == 1) {
							$check = "checked";
						}
					}
				}

				array_push($customIds,$custom['custNoteId']);
				$customRows .= "
					<tr>
						<td>
							<input type=\"checkbox\" id=\"$custom[custNoteId]CustCheck\" onclick=\"toggle(event,'$custom[custNoteId]CustArea')\" $check />
						</td>
						<td>
							<label for=\"$custom[custNoteId]CustCheck\">$custom[custNoteDesc]</label>
						</td>
					</tr>
				";
			}
			$GLOBALS['temp']['customRows'] = $customRows;
			$GLOBALS['temp']['customIds'] = join(",",$customIds);
			
			$imgPath = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/custom/";
			$customNote = "";
			foreach($customNotes as $custId) {
				$customItems = $lDB->get("
					SELECT
						rf_note_cust_item.rf_note_cust_item_ix as itemId,
						rf_note_cust_item.rf_note_cust_item_path as itemImgName,
						rf_note_cust_item.rf_note_cust_item_seq as itemSeq,
						rf_note_cust_item.rf_note_cust_item_text as itemText
					FROM
						rf_note_cust_item
					WHERE
						rf_note_cust_item.rf_note_custom_id = '$custId[custNoteId]'
					ORDER BY
						rf_note_cust_item.rf_note_cust_item_seq
				",2);

				// Display combined notes
				$itemNote = "";
				foreach($customItems as $item) {
					if($item['itemText'] != "" || $item['itemText'] != null) {
						$itemNote .= t_encodeHTML($item['itemText']) . "<br />";
					} else {
						$itemNote .= "<img src='" . $imgPath . $item['itemImgName'] . "'><br />";
					}
				}
				$customNote .= "
					<table width=\"627\" border=\"0\" align=\"center\" cellpadding=\"1\" cellspacing=\"0\" class=\"collapse printCollapse\" id=\"$custId[custNoteId]CustArea\">
					<tr>
						<td height=\"25\"><span class=\"txtb u\">$custId[custNoteHdg]</span></td>
					</tr>
					<tr>
						<td>$itemNote<p></td>
					</tr>
					</table>
				";
			}
			$GLOBALS['temp']['customNote'] = $customNote;
		} else {
			$GLOBALS['temp']['customNote'] = "";
			$GLOBALS['temp']['customRows'] = "There are no notes setup";
			$GLOBALS['temp']['customIds'] = "";
		}
		// [END] Custom Notes

		$GLOBALS['temp']['invoiceOnlyClass'] = "collapse printCollapse";
		$GLOBALS['temp']['resItemRows'] = "";
		$multiGroups = false;
		if($docType == DOC_RESERVATION) {
			// Reservation (Accomodation) Items
			$resItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_accomm_item_rows.htm"));
			$resItemRows = "";
			$rateTypeSummaryHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_rate_type_summary_rows.htm"));
			$rateTypeSummaryRows = "";
			$resItemCount = 1;
			foreach($result['resItems'] as $key => $item) {
				$addRateGroups = (isset($item['add_rate_groups']) && is_array($item['add_rate_groups'])) ? $item['add_rate_groups'] : array();
				$item['total'] = trim($item['compAmt'] . " " . $item['rf_currency_symbol']);
				removeBlank($item);
				if ($key == 0){
					$item['topborder'] = "";
				} else {
					$item['topborder'] = "bt";
				}
				
				if (count($item['add_rate_groups']) > 0 || $resItemCount < count($result['resItems'])){
					$item['botborder'] = "";
				} else {
					$item['botborder'] = "bb";
				}
				
				$item['pr_name_last'] = t_encodeHTMLField($item['pr_name_last']);
				$item['ac_accomm_desc'] = t_encodeHTMLField($item['ac_accomm_desc']);
				$resItemRows .= showpage($item,$resItemHTML);
				// If we need extra rows for additional rate groups, add them here
				$rgCount = 1;
				foreach ($addRateGroups as $subkey => $addRateGroupItem){
					$addRateGroupHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_accomm_item_rows_add_rate_group.htm"));

					if ($rgCount >= count($item['add_rate_groups']) && $resItemCount > count($result['resItems'])){
						$addRateGroupItem['botborder'] = "bb";
					} else {
						$addRateGroupItem['botborder'] = "";
					}
				
					$resItemRows .= showpage($addRateGroupItem,$addRateGroupHTML);
					$rgCount++;
				}
				$rateTypeSummaryRows .= showpage($item,$rateTypeSummaryHTML);
				$resItemCount++;
			}
			$GLOBALS['temp']['resItemRows'] = $resItemRows;
			$GLOBALS['temp']['rateTypeSummaryRows'] = $rateTypeSummaryRows;
			$GLOBALS['temp']['proformaClass'] = "expand";
			$GLOBALS['temp']['invoiceClass'] = "collapse printCollapse";
			$GLOBALS['temp']['noAccommClass'] = "collapse printCollapse";
			$GLOBALS['temp']['invoiceItemRows'] = "";
			$GLOBALS['temp']['invoiceItemWithDateRows'] = "";
			$GLOBALS['temp']['invoiceItemNoTaxRows'] = "";
			$GLOBALS['temp']['invoiceItemNoTaxWithDateRows'] = "";
			$GLOBALS['temp']['invoiceItemConsolidatedRows'] = "";
			$GLOBALS['temp']['invoiceItemConsolidatedWithDateRows'] = "";
			$GLOBALS['temp']['invoiceItemConsolidatedNoTaxRows'] = "";
			$GLOBALS['temp']['invoiceItemConsolidatedNoTaxWithDateRows'] = "";
		} elseif($docType == DOC_FOLIO) {
			$GLOBALS['temp']['allowResAccomm'] = "expand";
			$GLOBALS['temp']['allowServiceDate'] = "expand";
			$GLOBALS['temp']['allowTaxTable'] = "expand";
			$GLOBALS['temp']['allowTaxTableRate'] = "expand";
			$GLOBALS['temp']['allowTaxTableTotal'] = "expand";
			$GLOBALS['temp']['resNoteDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['extraNoteDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['guestInformationDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['propertyNoteDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['proformaClass'] = "collapse printCollapse";
			$GLOBALS['temp']['invoiceClass'] = "expand";
			$GLOBALS['temp']['allowFolioList'] = "collapse printCollapse";
			$GLOBALS['temp']['allowInvoiceList'] = "collapse printCollapse";
			$GLOBALS['temp']['showExtras'] = "collapse printCollapse";
			$GLOBALS['temp']['showTravel'] = "collapse printCollapse";
			$GLOBALS['temp']['allowItemConsolidate'] = "expand";

			$checkTBA = $lDB->get("
				SELECT
					COUNT(rv_res_item_comp.rv_res_item_comp_ix)
				FROM
					rv_reservation_item
					LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				WHERE
					rv_reservation_item.fn_folio_id = '$folioId'
				GROUP BY
					rv_reservation_item.rv_reservation_item_ix
			",3);
			if(sizeof($checkTBA) > 0 && in_array(0,$checkTBA)) {
				$isTBA = true;
			} else {
				$isTBA = false;
			}

			$invoiceRows = "";
			$invoiceWithDateRows = "";
			$exclTotal = 0;
			$taxTotal = 0;
			$amountTotal = 0;
			$convertTotal = 0;
			foreach($result['folioItems'] as $item) {
				$exclTotal += $item['fn_folio_amount_excl'];
				$taxTotal += $item['fn_folio_amount_tax'];
				$amountTotal += $item['fn_folio_amount'];

				$item['fn_folio_amount_excl'] = round($item['fn_folio_amount_excl'],2);
				fixAmtDisplay($item['fn_folio_amount_excl'],2);
				$item['fn_folio_amount_tax'] = round($item['fn_folio_amount_tax'],2);
				fixAmtDisplay($item['fn_folio_amount_tax'],2);
				$invoiceRows .= "
					<tr>
						<td class=\"bl br\">$item[fn_folio_desc]&nbsp;</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[taxDesc]</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount_excl]</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount_tax]</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount] $result[folioCurrency]</td>
					</tr>
				";

				$item['amt_date'] = chng_date($item['amt_date'],"-");
				$invoiceWithDateRows .= "
					<tr>
						<td class=\"bl br\">$item[amt_date]&nbsp;</td>
						<td class=\"br\">$item[fn_folio_desc]&nbsp;</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[taxDesc]</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount_excl]</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount_tax]</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount] $result[folioCurrency]</td>
					</tr>
				";
			}
			if(!$isTBA) {
				$exclTotal = round($exclTotal,2);
				fixAmtDisplay($exclTotal,2);
				$taxTotal = round($taxTotal,2);
				fixAmtDisplay($taxTotal,2);
				fixAmtDisplay($amountTotal,2);
				
				$invoiceRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\" colspan=\"2\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$exclTotal</td>
						<td class=\"bt bb br\" align=\"right\">$taxTotal</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[folioCurrency]</td>
					</tr>
				";

				$invoiceWithDateRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\" colspan=\"3\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$exclTotal</td>
						<td class=\"bt bb br\" align=\"right\">$taxTotal</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[folioCurrency]</td>
					</tr>
				";

			} else {
				$invoiceRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\" colspan=\"2\">Total</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
						<td class=\"bt bb br\" align=\"right\">&nbsp;</td>
					</tr>
				";

				$invoiceWithDateRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\" colspan=\"3\">Total</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
						<td class=\"bt bb br\" align=\"right\">&nbsp;</td>
					</tr>
				";
			}
			$GLOBALS['temp']['invoiceItemRows'] = $invoiceRows;
			$GLOBALS['temp']['invoiceItemWithDateRows'] = $invoiceWithDateRows;

			$invoiceNoTaxRows = "";
			$invoiceNoTaxWithDateRows = "";
			$amountTotal = 0;
			foreach($result['folioNoTaxItems'] as $item) {
				$amountTotal += $item['fn_folio_amount'];

				$invoiceNoTaxRows .= "
					<tr>
						<td class=\"bl br\">$item[fn_folio_desc]&nbsp;</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount] $result[folioCurrency]</td>
					</tr>
				";

				$item['amt_date'] = chng_date($item['amt_date'],"-");
				$invoiceNoTaxWithDateRows .= "
					<tr>
						<td class=\"bl br\">$item[amt_date]&nbsp;</td>
						<td class=\"br\">$item[fn_folio_desc]&nbsp;</td>
						<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount] $result[folioCurrency]</td>
					</tr>
				";
			}
			if(!$isTBA) {
				fixAmtDisplay($amountTotal,2);
				
				$invoiceNoTaxRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[folioCurrency]</td>
					</tr>
				";

				$invoiceNoTaxWithDateRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\" colspan=\"2\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[folioCurrency]</td>
					</tr>
				";

			} else {
				$invoiceNoTaxRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\">Total</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
					</tr>
				";

				$invoiceNoTaxWithDateRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\" colspan=\"2\">Total</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
					</tr>
				";
			}
			$GLOBALS['temp']['invoiceItemNoTaxRows'] = $invoiceNoTaxRows;
			$GLOBALS['temp']['invoiceItemNoTaxWithDateRows'] = $invoiceNoTaxWithDateRows;

			$invoiceConsolidatedRows = "";
			$invoiceConsolidatedWithDateRows = "";
			$invoiceConsolidatedNoTaxRows = "";
			$invoiceConsolidatedNoTaxWithDateRows = "";
			if(!$isTBA) {
				foreach($result['folioConsolidatedItems'] as $item) {
					$item['fn_folio_amount_excl'] = round($item['fn_folio_amount_excl'],2);
					fixAmtDisplay($item['fn_folio_amount_excl'],2);
					$item['fn_folio_amount_tax'] = round($item['fn_folio_amount_tax'],2);
					fixAmtDisplay($item['fn_folio_amount_tax'],2);				

					$item['amt_date'] = chng_date($item['amt_date'],"-");
					
					$invoiceConsolidatedRows .= "
						<tr>
							<td class=\"bl br\">$item[fn_folio_desc]&nbsp;</td>
							<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount_excl]</td>
							<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount_tax]</td>
							<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount] $result[folioCurrency]</td>
							</tr>
					";

					$invoiceConsolidatedWithDateRows .= "
						<tr>
							<td class=\"bl br\">$item[amt_date]&nbsp;</td>
							<td class=\"br\">$item[fn_folio_desc]&nbsp;</td>
							<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount_excl]</td>
							<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount_tax]</td>
							<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount] $result[folioCurrency]</td>
							</tr>
					";

					$invoiceConsolidatedNoTaxRows .= "
						<tr>
							<td class=\"bl br\">$item[fn_folio_desc]&nbsp;</td>
							<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount] $result[folioCurrency]</td>
						</tr>
					";

					$invoiceConsolidatedNoTaxWithDateRows .= "
						<tr>
							<td class=\"bl br\">$item[amt_date]&nbsp;</td>
							<td class=\"bl br\">$item[fn_folio_desc]&nbsp;</td>
							<td class=\"br\" align=\"right\">&nbsp;$item[fn_folio_amount] $result[folioCurrency]</td>
						</tr>
					";
				}
				$invoiceConsolidatedRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$exclTotal</td>
						<td class=\"bt bb br\" align=\"right\">$taxTotal</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[folioCurrency]</td>
					</tr>
				";

				$invoiceConsolidatedWithDateRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\" colspan=\"2\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$exclTotal</td>
						<td class=\"bt bb br\" align=\"right\">$taxTotal</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[folioCurrency]</td>
					</tr>
				";

				$invoiceConsolidatedNoTaxRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[folioCurrency]</td>
					</tr>
				";

				$invoiceConsolidatedNoTaxWithDateRows .= "
					<tr>
						<td class=\"outLtt bt bl bb\" align=\"right\" colspan=\"2\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[folioCurrency]</td>
					</tr>
				";
			} else {
			}
			$GLOBALS['temp']['invoiceItemConsolidatedRows'] = $invoiceConsolidatedRows;
			$GLOBALS['temp']['invoiceItemConsolidatedWithDateRows'] = $invoiceConsolidatedWithDateRows;
			$GLOBALS['temp']['invoiceItemConsolidatedNoTaxRows'] = $invoiceConsolidatedNoTaxRows;
			$GLOBALS['temp']['invoiceItemConsolidatedNoTaxWithDateRows'] = $invoiceConsolidatedNoTaxWithDateRows;

			$taxTableRows = "";
			$taxTableWithoutRatesRows = "";
			$taxTotal = 0;
			foreach($result['folioTaxTable'] as $item) {
				$item['tax_perc'] = round($item['tax_perc'],2);
				fixAmtDisplay($item['tax_perc'],2);
				$item['tax_amt'] = round($item['tax_amt'],2);
				fixAmtDisplay($item['tax_amt'],2);
				$taxTotal += $item['tax_amt'];
	
				$taxTableRows .= "
					<tr>
						<td class=\"bl br\">$item[tax_desc]</td>
						<td class=\"br\" align=\"right\">$item[tax_perc]</td>
						<td class=\"br\" align=\"right\">$item[tax_amt]</td>
					</tr>
				";

				$taxTableWithoutRatesRows .= "
					<tr>
						<td class=\"bl br\">$item[tax_desc]</td>
						<td class=\"br\" align=\"right\">$item[tax_amt]</td>
					</tr>
				";
			}
			fixAmtDisplay($taxTotal,2);
			$taxTableRows .= "
					<tr id=\"taxTableTotalRow\">
						<td class=\"colLtt bt bl br\" align=\"left\" colspan=\"2\">Folio Total</td>
						<td class=\"bt br\" align=\"right\">$amountTotal</td>
					</tr>
					<tr>
						<td class=\"bt\" colspan=\"3\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
					</tr>
			";
			$taxTableWithoutRatesRows .= "
					<tr id=\"taxTableTotalWithoutRatesRow\">
						<td class=\"colLtt bt bl br\" align=\"left\" >Folio Total</td>
						<td class=\"bt br\" align=\"right\">$amountTotal</td>
					</tr>
					<tr>
						<td class=\"bt\" colspan=\"2\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
					</tr>
			";
				
			$GLOBALS['temp']['taxTableRows'] = $taxTableRows;
			$GLOBALS['temp']['taxTableWithoutRatesRows'] = $taxTableWithoutRatesRows;
			

			$resItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_invoice_accomm_item_rows.htm"));
			$resItemRows = "";
			$rateTypeSummaryHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_rate_type_summary_rows.htm"));
			$rateTypeSummaryRows = "";
			foreach($result['resItems'] as $item) {
				$item['total'] = trim($item['compAmt'] . " " . $item['rf_currency_symbol']);
				removeBlank($item);
				$resItemRows .= showpage($item,$resItemHTML);
				$rateTypeSummaryRows .= showpage($item,$rateTypeSummaryHTML);
			}
			$GLOBALS['temp']['rateTypeSummaryRows'] = $rateTypeSummaryRows;
      
			if(sizeof($result['resItems']) > 0) {
				$GLOBALS['temp']['invoiceResItemRows'] = $resItemRows;
				$GLOBALS['temp']['noAccommClass'] = "expand";
				$GLOBALS['temp']['paymentPlanDefault'] = "expand";
			} else {
				$GLOBALS['temp']['noAccommClass'] = 'collapse printCollapse';
				$GLOBALS['temp']['invoiceResItemRows'] = '<tr><td align="center" class="txti" colspan="8">No accommodation items</td></td>';
				$GLOBALS['temp']['paymentPlanDefault'] = 'collapse printCollapse';
			}
		} elseif($docType == DOC_INVOICE) {
			$GLOBALS['temp']['allowResDet'] = "collapse printCollapse";
			$GLOBALS['temp']['allowResAccomm'] = "expand";
			$GLOBALS['temp']['allowServiceDate'] = "expand";
			$GLOBALS['temp']['allowTaxTable'] = "expand";
			$GLOBALS['temp']['allowTaxTableGL'] = "expand";
			$GLOBALS['temp']['allowTaxTableRate'] = "expand";
			$GLOBALS['temp']['allowTaxTableTotal'] = "expand";
			$GLOBALS['temp']['allowPayPlan'] = "collapse printCollapse";
			$GLOBALS['temp']['allowPayReceipts'] = "collapse printCollapse";
			$GLOBALS['temp']['allowPerPerson'] = "collapse printCollapse";
			$GLOBALS['temp']['allowResNote'] = "collapse printCollapse";
			$GLOBALS['temp']['allowGuestInformation'] = "collapse printCollapse";
			$GLOBALS['temp']['allowRooming'] = "collapse printCollapse";
			$GLOBALS['temp']['allowGuestNote'] = "collapse printCollapse";
			$GLOBALS['temp']['allowGuestMemo'] = "collapse printCollapse";
			$GLOBALS['temp']['allowExchNote'] = "collapse printCollapse";
			$GLOBALS['temp']['allowExtraNote'] = "collapse printCollapse";
			$GLOBALS['temp']['allowCostComponent'] = "collapse printCollapse";
			$GLOBALS['temp']['allowCostSummary'] = "collapse printCollapse";
			$GLOBALS['temp']['allowInternalMemo'] = "collapse PrintCollapse";
			$GLOBALS['temp']['allowCancelNote'] = "collapse printCollapse";
			$GLOBALS['temp']['allowFolioList'] = "collapse printCollapse";
			$GLOBALS['temp']['allowInvoiceList'] = "collapse printCollapse";
			$GLOBALS['temp']['allowOriginator'] = "collapse printCollapse";
			$GLOBALS['temp']['allowRateTypeSummary'] = "collapse printCollapse";
			$GLOBALS['temp']['paymentPlanDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['paymentReceiptsDefault'] = "collapse printCollapse";
			if(sizeof($result['invoicePaymentList']) > 0) {
				$GLOBALS['temp']['invoicePaymentClass'] = "expand";
			}
			$GLOBALS['temp']['invoicePaidDefault'] = "expand";
			$GLOBALS['temp']['exchangeRateDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['resNoteDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['guestInformationDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['guestNoteDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['guestMemoDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['extraNoteDefault'] = "collapse printCollapse";
			if($invoicePrint['fn_inv_print_count'] > 0) {
				$GLOBALS['temp']['hideOptions'] = "display: none;";
			}
			if($optAccomm == "1") {
				$GLOBALS['temp']['noAccommClass'] = "expand";
			} else {
				$GLOBALS['temp']['noAccommClass'] = "collapse printCollapse";
			}
			if($optBank == "1") {
				$GLOBALS['temp']['bankDetailDefault'] = "expand";
			} else {
				$GLOBALS['temp']['bankDetailDefault'] = "collapse printCollapse";
			}
			if($optCCA == "1") {
				$GLOBALS['temp']['showCreditCard'] = "expand";
			} else {
				$GLOBALS['temp']['showCreditCard'] = "collapse printCollapse";
			}
			if($optDate == "1") {
				$GLOBALS['temp']['showServiceDate'] = "1";
			} else {
				$GLOBALS['temp']['showServiceDate'] = "0";
			}
			if($optSpecial == "1") {
				$GLOBALS['temp']['showSpecial'] = "1";
				$GLOBALS['temp']['specialDetailDefault'] = "";
				$GLOBALS['temp']['specialChecked'] = 'checked="checked"';
			} else {
				$GLOBALS['temp']['showSpecial'] = "0";
			}
			if($optSpecialNote == "1") {
				$GLOBALS['temp']['showSpecialNote'] = "1";
				$GLOBALS['temp']['specialNoteChecked'] = 'checked="checked"';
				$GLOBALS['temp']['specialNoteExpanded'] = "";
			} else {
				$GLOBALS['temp']['showSpecialNote'] = "0";
			}
			if($optTax == "1") {
				$GLOBALS['temp']['hideTax'] = "";
			} else {
				$GLOBALS['temp']['hideTax'] = "1";
			}			
			if($optTaxTable == "1") {
				$GLOBALS['temp']['showTaxTable'] = "1";
			} else {
				$GLOBALS['temp']['showTaxTable'] = "0";
			}
			if($optTaxTableGL == "1") {
				$GLOBALS['temp']['showTaxTableGL'] = "1";
			} else {
				$GLOBALS['temp']['showTaxTableGL'] = "0";
			}
			if($optTaxTableRate == "1") {
				$GLOBALS['temp']['showTaxTableRate'] = "1";
			} else {
				$GLOBALS['temp']['showTaxTableRate'] = "0";
			}
			if($optTaxTableTotal == "1") {
				$GLOBALS['temp']['showTaxTableTotal'] = "1";
			} else {
				$GLOBALS['temp']['showTaxTableTotal'] = "0";
			}
			if($optTerms == "1") {
				$GLOBALS['temp']['bookingTermsDefault'] = "expand";
			} else {
				$GLOBALS['temp']['bookingTermsDefault'] = "collapse printCollapse";
			}
			if($optTermsBus == "1") {
				$GLOBALS['temp']['propertyNoteDefault'] = "expand";
			} else {
				$GLOBALS['temp']['propertyNoteDefault'] = "collapse printCollapse";
			}
			$GLOBALS['temp']['standardNoteDefault'] = "expand";
			$GLOBALS['temp']['folioDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['invoiceDefault'] = "collapse printCollapse";

			if($result['invoiceExchangeFromCurrency'] != $result['invoiceExchangeToCurrency']) {
				$GLOBALS['temp']['invoiceExchangeClass'] = "expand";
			}

			$GLOBALS['temp']['proformaClass'] = "collapse printCollapse";
			$GLOBALS['temp']['invoiceClass'] = "expand";
			$GLOBALS['temp']['invoiceOnlyClass'] = "expand";
			$GLOBALS['temp']['invoiceHideClass'] = "collapse printCollapse";
			$GLOBALS['temp']['showExtras'] = "collapse printCollapse";
			$GLOBALS['temp']['showTravel'] = "collapse printCollapse";

			if (checkFiscalisationByInvoice($invoiceId)) {
				$fiscalise = new Fiscalator();	
				$fiscalData = $fiscalise->getFiscalData($invoiceId);
				$isFiscalised = !empty($fiscalData) ? true : false;

				if ($isFiscalised) {
					$GLOBALS['temp']['fiscalisedOnlyClass'] = "expand"; 
					$fiscalLabels = !empty($fiscalData['fiscalDocFields']) ? $fiscalData['fiscalDocFields'] : "";
					$fiscalLabelCol = "";
					$fiscalInfo = "";
					if ($fiscalLabels && !empty($fiscalData['fiscalDocFields'])) {
						foreach ($fiscalLabels as $fiscalLabel => $value) {
							if (strtolower($fiscalLabel) != "qrcode") {
								$fiscalLabelCol .= $fiscalLabel . ":<br>";
								$fiscalInfo .= $value . "<br>";
							}
						}
					}
					if (isset($fiscalData['qrCodeBase64']) && !empty($fiscalData['qrCodeBase64'])) {
						$qrcodesrc = "data:image/png;base64," . $fiscalData['qrCodeBase64'];
						$qrcode = "<img src='" . $qrcodesrc . "' style='width:90%;' alt='QR Code'>";
					}
				}
			}
			$GLOBALS['temp']['qrcode'] = $qrcode;
			$GLOBALS['temp']['fiscalLabelCol'] = $fiscalLabelCol;
			$GLOBALS['temp']['fiscalInfo'] = $fiscalInfo;

			$checkTBA = $lDB->get("
				SELECT
					COUNT(rv_res_item_comp.rv_res_item_comp_ix)
				FROM
					rv_reservation_item
					LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				WHERE
					rv_reservation_item.fn_folio_id = '$folioId'
				GROUP BY
					rv_reservation_item.rv_reservation_item_ix
			",3);
			if(sizeof($checkTBA) > 0 && in_array(0,$checkTBA)) {
				$isTBA = true;
			} else {
				$isTBA = false;
			}

			$invoiceRows = "";
			$invoiceWithDateRows = "";
			$invoiceNoTaxRows = "";
			$invoiceNoTaxWithDateRows = "";
			$exclTotal = 0;
			$taxTotal = 0;
			$amountTotal = 0;
			$convertTotal = 0;
			foreach($result['invoiceItems'] as $item) {
				$exclTotal += $item['fn_inv_item_amt_excl'];
				$taxTotal += $item['fn_inv_item_amt_tax'];
				$amountTotal += $item['fn_inv_item_amount'];

				$item['fn_inv_item_amt_excl'] = round($item['fn_inv_item_amt_excl'],2);
				fixAmtDisplay($item['fn_inv_item_amt_excl'],2);
				$item['fn_inv_item_amt_tax'] = round($item['fn_inv_item_amt_tax'],2);
				fixAmtDisplay($item['fn_inv_item_amt_tax'],2);

				$item['fn_inv_item_date'] = chng_date($item['fn_inv_item_date'],"-");

				$invoiceRows .= "
					<tr>
						<td class=\"bl br\">$item[fn_inv_item_desc]</td>
						<td class=\"br\" align=\"right\">$item[taxDesc]</td>
						<td class=\"br\" align=\"right\">$item[fn_inv_item_amt_excl]</td>
						<td class=\"br\" align=\"right\">$item[fn_inv_item_amt_tax]</td>
						<td class=\"br\" align=\"right\">$item[fn_inv_item_amount] $result[invoiceExchangeFromCurrency]</td>
					</tr>
				";

				$invoiceNoTaxRows .= "
					<tr>
						<td class=\"bl br\">$item[fn_inv_item_desc]</td>
						<td class=\"br\" align=\"right\">$item[fn_inv_item_amount] $result[invoiceExchangeFromCurrency]</td>
					</tr>
				";

				$invoiceWithDateRows .= "
					<tr>
						<td class=\"bl br\">&nbsp;$item[fn_inv_item_date]</td>
						<td class=\"br\">$item[fn_inv_item_desc]</td>
						<td class=\"br\" align=\"right\">$item[taxDesc]</td>
						<td class=\"br\" align=\"right\">$item[fn_inv_item_amt_excl]</td>
						<td class=\"br\" align=\"right\">$item[fn_inv_item_amt_tax]</td>
						<td class=\"br\" align=\"right\">$item[fn_inv_item_amount] $result[invoiceExchangeFromCurrency]</td>
					</tr>
				";

				$invoiceNoTaxWithDateRows .= "
					<tr>
						<td class=\"bl br\">&nbsp;$item[fn_inv_item_date]</td>
						<td class=\"br\">$item[fn_inv_item_desc]</td>
						<td class=\"br\" align=\"right\">$item[fn_inv_item_amount] $result[invoiceExchangeFromCurrency]</td>
					</tr>
				";
				
			}
			if(!$isTBA) {
				$exclTotal = round($exclTotal,2);
				fixAmtDisplay($exclTotal,2);
				$taxTotalRounded = round($taxTotal,2);
				fixAmtDisplay($taxTotalRounded,2);
				fixAmtDisplay($amountTotal,2);
				$invoiceRows .= "
					<tr>
						<td class=\"outLt bt bl bb\" align=\"right\" colspan=\"2\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$exclTotal</td>
						<td class=\"bt bb br\" align=\"right\">$taxTotalRounded</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[invoiceExchangeFromCurrency]</td>
					</tr>
				";
				$invoiceNoTaxRows .= "
					<tr>
						<td class=\"outLt bt bl bb\" align=\"right\" colspan=\"1\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[invoiceExchangeFromCurrency]</td>
					</tr>
				";
				$invoiceWithDateRows .= "
					<tr>
						<td class=\"outLt bt bl bb\" align=\"right\" colspan=\"3\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$exclTotal</td>
						<td class=\"bt bb br\" align=\"right\">$taxTotalRounded</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[invoiceExchangeFromCurrency]</td>
					</tr>
				";
				$invoiceNoTaxWithDateRows .= "
					<tr>
						<td class=\"outLt bt bl bb\" align=\"right\" colspan=\"2\">Total</td>
						<td class=\"bt bb br\" align=\"right\">$amountTotal $result[invoiceExchangeFromCurrency]</td>
					</tr>
				";
				
			} else {
				$invoiceRows .= "
					<tr>
						<td class=\"bt\" ><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"outLtt bt bl bb\" align=\"right\">Total</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
					</tr>
				";
				$invoiceNoTaxRows .= "
					<tr>
						<td class=\"bt\" ><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"outLtt bt bl bb\" align=\"right\">Total</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
					</tr>
				";
				$invoiceWithDateRows .= "
					<tr>
						<td class=\"bt\" ><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"bt\" ><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"outLtt bt bl bb\" align=\"right\">Total</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
					</tr>
				";
				$invoiceNoTaxWithDateRows .= "
					<tr>
						<td class=\"bt\" ><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"bt\" ><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"outLtt bt bl bb\" align=\"right\">Total</td>
						<td class=\"bt bb br\" align=\"right\">TBA</td>
					</tr>
				";
			}
			$convertTotal = $amountTotal*$result['invoiceExchangeRate'];
			$convertTax	= $taxTotal*$result['invoiceExchangeRate'];
			$convertExclTax = $convertTotal - $convertTax;
			fixAmtDisplay($convertTotal,2);
			fixAmtDisplay($convertExclTax,2);
			fixAmtDisplay($convertTax,2);
			$GLOBALS['temp']['convertTotal'] = $convertTotal;
			$GLOBALS['temp']['convertExclTax'] = $convertExclTax;
			$GLOBALS['temp']['convertTax'] = $convertTax;
			$GLOBALS['temp']['invoiceItemRows'] = $invoiceRows;
			$GLOBALS['temp']['invoiceItemNoTaxRows'] = $invoiceNoTaxRows;
			$GLOBALS['temp']['invoiceItemWithDateRows'] = $invoiceWithDateRows;
			$GLOBALS['temp']['invoiceItemNoTaxWithDateRows'] = $invoiceNoTaxWithDateRows;
			$resItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_invoice_accomm_item_rows.htm"));
			$resItemRows = "";
			foreach($result['resItems'] as $item) {
			$item['total'] = trim($item['compAmt'] . " " . $item['rf_currency_symbol']);
				removeBlank($item);
				$resItemRows .= showpage($item,$resItemHTML);
			}
			if(sizeof($result['resItems']) > 0) {
				$GLOBALS['temp']['invoiceResItemRows'] = $resItemRows;
				if($optAccomm == "1") {
					$GLOBALS['temp']['noAccommClass'] = "expand";
				} else {
					$GLOBALS['temp']['noAccommClass'] = "collapse printCollapse";
				}
			} else {
				$GLOBALS['temp']['invoiceResItemRows'] = "<tr><td align=\"center\" class=\"txti\" colspan=\"8\">No accommodation items</td></td>";
				$GLOBALS['temp']['noAccommClass'] = "collapse printCollapse";
			}
			$GLOBALS['temp']['invoicePaymentTotal'] = $result['invoicePaymentTotal'];
			$GLOBALS['temp']['invoicePaymentOutstanding'] = $result['invoicePaymentOutstanding'];
			$invoicePaymentHTML = "
				<tr>
					<td>!fn_inv_payment_date_fmt!</td>
					<td>!fn_inv_payment_payer!</td>
					<td>!fn_inv_payment_ref!</td>
					<td>!fn_inv_payment_method!</td>
					<td>!fn_inv_payment_bank!</td>
					<td align=\"right\">!fn_inv_payment_amt! !fn_inv_payment_curr!</td>
				</tr>
			";
			$invoicePaymentRows = "";
			foreach($result['invoicePaymentList'] as $invoicePaymentItem) {
				$invoicePaymentItem['fn_inv_payment_date_fmt'] = chng_date($invoicePaymentItem['fn_inv_payment_date'],"-");
				$invoicePaymentRows .= showpage($invoicePaymentItem,$invoicePaymentHTML);
			}
			$GLOBALS['temp']['invoicePaymentRows'] = $invoicePaymentRows;
			$GLOBALS['temp']['invoiceItemConsolidatedRows'] = "";
			$GLOBALS['temp']['invoiceItemConsolidatedWithDateRows'] = "";
			$GLOBALS['temp']['invoiceItemConsolidatedNoTaxRows'] = "";
			$GLOBALS['temp']['invoiceItemConsolidatedNoTaxWithDateRows'] = "";

			$GLOBALS['temp']['invoiceItemConsolidatedNoTaxRows'] = "";
			
			$taxTableRows = "";
			$taxTableWithoutRatesRows = "";
			$taxTotal = 0;
			$taxTableGLRows = "";
			$taxTableGLWithoutRatesRows = "";
			$taxTotalGL = 0;
			$result['invoiceTaxTable'] = (is_array($result['invoiceTaxTable'])) ? $result['invoiceTaxTable'] : array();
			foreach($result['invoiceTaxTable'] as $item) {
				$fn_invoice_item_tax_amt_gl = round($item['fn_invoice_item_tax_amt'] * $item['fn_inv_exch_rate'],2);
				$item['fn_invoice_item_tax_amt'] = round($item['fn_invoice_item_tax_amt'],2);
				fixAmtDisplay($item['fn_invoice_item_tax_amt'],2);
				$taxTotal += $item['fn_invoice_item_tax_amt'];
	
				$taxTableRows .= "
					<tr>
						<td class=\"bl br\">$item[fn_invoice_item_tax_desc]</td>
						<td class=\"br\" align=\"right\">$item[fn_invoice_item_tax_perc]</td>
						<td class=\"br\" align=\"right\">$item[fn_invoice_item_tax_amt]</td>
					</tr>
				";

				$taxTableWithoutRatesRows .= "
					<tr>
						<td class=\"bl br\">$item[fn_invoice_item_tax_desc]</td>
						<td class=\"br\" align=\"right\">$item[fn_invoice_item_tax_amt]</td>
					</tr>
				";
				

				fixAmtDisplay($fn_invoice_item_tax_amt_gl,2);
				$taxTotalGL += $fn_invoice_item_tax_amt_gl;
				$taxTableGLRows .= "
					<tr>
						<td class=\"bl br\">$item[fn_invoice_item_tax_desc]</td>
						<td class=\"br\" align=\"right\">$item[fn_invoice_item_tax_perc]</td>
						<td class=\"br\" align=\"right\">$fn_invoice_item_tax_amt_gl</td>
					</tr>
				";
				$taxTableGLWithoutRatesRows .= "
					<tr>
						<td class=\"bl br\">$item[fn_invoice_item_tax_desc]</td>
						<td class=\"br\" align=\"right\">$fn_invoice_item_tax_amt_gl</td>
					</tr>
				";
			}
			fixAmtDisplay($taxTotal,2);
			$taxTableRows .= "
					<tr id=\"taxTableTotalRow\">
						<td class=\"colLtt bt bl br\" align=\"left\" colspan=\"2\">Invoice Total</td>
						<td class=\"bt br\" align=\"right\">$amountTotal</td>
					</tr>
					<tr>
						<td class=\"bt\" colspan=\"3\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
					</tr>
			";
			$taxTableWithoutRatesRows .= "
					<tr id=\"taxTableTotalWithoutRatesRow\">
						<td class=\"colLtt bt bl br\" align=\"left\">Invoice Total</td>
						<td class=\"bt br\" align=\"right\">$amountTotal</td>
					</tr>
					<tr>
						<td class=\"bt\" colspan=\"2\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
					</tr>
			";

			fixAmtDisplay($taxTotalGL,2);
			$taxTableGLRows .= "
					<tr id=\"taxTableTotalGLRow\">
						<td class=\"colLtt bt bl br\" align=\"left\" colspan=\"2\">Invoice Total</td>
						<td class=\"bt br\" align=\"right\">$convertTotal</td>
					</tr>
					<tr>
						<td class=\"bt\" colspan=\"3\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
					</tr>
			";
			$taxTableGLWithoutRatesRows .= "
					<tr id=\"taxTableTotalGLWithoutRatesRow\">
						<td class=\"colLtt bt bl br\" align=\"left\">Invoice Total</td>
						<td class=\"bt br\" align=\"right\">$convertTotal</td>
					</tr>
					<tr>
						<td class=\"bt\" colspan=\"2\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
					</tr>
			";
				
			$GLOBALS['temp']['taxTableRows'] = $taxTableRows;
			$GLOBALS['temp']['taxTableWithoutRatesRows'] = $taxTableWithoutRatesRows;
			$GLOBALS['temp']['taxTableGLRows'] = $taxTableGLRows;
			$GLOBALS['temp']['taxTableGLWithoutRatesRows'] = $taxTableGLWithoutRatesRows;
		}

		$GLOBALS['temp']['costSummaryDefault'] = "";
		$GLOBALS['temp']['showPaymentTotals'] = "";
		if(isset($result['currencyCheck']) && $result['currencyCheck'] > 1) {
			$GLOBALS['temp']['allowCostSummary'] = "collapse printCollapse";
			$GLOBALS['temp']['allowCommission'] = "collapse printCollapse";
			$GLOBALS['temp']['costSummaryDefault'] = "collapse printCollapse";
			$GLOBALS['temp']['showPaymentTotals'] = "collapse printCollapse";
			$GLOBALS['temp']['allowPayPlan'] = "collapse printCollapse";
			$GLOBALS['temp']['paymentPlanDefault'] = 'collapse printCollapse';
		}
		$GLOBALS['temp']['line'] = "collapse printCollapse";

		if(sizeof($result['rooming']['rooms']) == 0) {
			$GLOBALS['temp']['allowRooming'] = "collapse printCollapse";
			$GLOBALS['temp']['roomingDefault'] = "collapse printCollapse";
		}
		if(sizeof($result['rooming']['guests']) == 0) {
			$GLOBALS['temp']['allowRoomingGuests'] = "collapse printCollapse";
			$GLOBALS['temp']['roomingDefault'] = "collapse printCollapse";
		}

		$GLOBALS['temp']['specialDetailDefault'] = "collapse printCollapse";
		$GLOBALS['temp']['specialChecked'] = "";
		$GLOBALS['temp']['specialNoteChecked'] = "";
		$GLOBALS['temp']['specialNoteExpanded'] = "collapse printCollapse";
		$specialNoteDefault = "collapse printCollapse";

		// Pay Items
		$payItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_pay_item_rows.htm"));
		$payRows = "";
		foreach($result['payItems'] as $item) {
			removeBlank($item);
			$payRows .= showpage($item,$payItemHTML);
		}
		$GLOBALS['temp']['payRows'] = $payRows;

		$payInvItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_pay_inv_item_rows.htm"));
		$payInvRows = "";
		$lastDate = "";
		foreach($result['payInvItems'] as $item) {
			if($lastDate == $item['pay_date']) {
				$item['pay_date'] = "";
			} else {
				$lastDate = $item['pay_date'];
			}
			$item['pr_name'] = t_encodeHTMLField($item['pr_name']);
			removeBlank($item);
			$payInvRows .= showpage($item,$payInvItemHTML);
		}
		$GLOBALS['temp']['payInvRows'] = $payInvRows;
		// Payed Items
		$payedItemHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_payed_item_rows.htm"));
		$payedRows = "";
		if(is_array($result['payedItems'])) {
			foreach($result['payedItems'] as $item) {
				removeBlank($item);
				$payedRows .= showpage($item,$payedItemHTML);
			}
		}
		$GLOBALS['temp']['noPayments'] = "";
		$GLOBALS['temp']['payedRows'] = $payedRows;
		if(trim($payedRows) == "") {
			$GLOBALS['temp']['noPayments'] = "collapse printCollapse";
			$GLOBALS['temp']['payedRows'] = "<tr><td colspan=8 class=\"txti\" align=\"center\">None</td></tr>";
		}

		$payedRows2 = "";
		if(is_array($result['payedItems2'])) {
			foreach($result['payedItems2'] as $item) {
				removeBlank($item);
				$payedRows2 .= showpage($item,$payedItemHTML);
			}
		}
		$GLOBALS['temp']['payedRows2'] = $payedRows2;
		if(trim($payedRows2) == "") {
			$GLOBALS['temp']['noPayments'] = "collapse printCollapse";
			$GLOBALS['temp']['payedRows2'] = "<tr><td colspan=8 class=\"txti\" align=\"center\">None</td></tr>";
		}

		// Cost components
		$compHTML = "
			<tr>
				<td height=\"15\" class=\"!catClass!\">!cat!&nbsp;</td>
				<td class=\"!compDescClass!\">!compDesc!&nbsp;</td>
				<td align=\"right\" class=\"!totals!\">!taxRate!&nbsp;</td>
				<td align=\"right\" class=\"!totals!\">!exclTax!&nbsp;</td>
				<td align=\"right\" class=\"!totals!\">!taxAmt!&nbsp;</td>
				<td align=\"right\" class=\"!totals!\">!payAmt!&nbsp;!rf_currency_symbol!</td>
			</tr>
		";
		$compRows = "";
		foreach($result['compTotals'] as $compCat => $compList) {
			$first = true;
			foreach($compList as $compItem) {
				$compItem['compDescClass'] = "br bl";
				$compItem['totals'] = "br";
				if($compItem['compDesc'] == "Totals") {
					$compItem['compDescClass'] = "colLtt bAll";
					$compItem['totals'] = "br bb bt";
				}
				if($first && $compCat != "Totals") {
					$first = false;
					$compItem['cat'] = $compCat;
					$compItem['catClass'] = "bb";
				} else {
					$compItem['cat'] = "";
					$compItem['catClass'] = "";
				}
				$compItem['compDesc'] = t_encodeHTMLField($compItem['compDesc']);
				$compRows .= showpage($compItem, $compHTML);
			}
		}
		$GLOBALS['temp']['compRows'] = $compRows;

		$perPersonRows = "";
		if($docType == DOC_RESERVATION || $docType == DOC_FOLIO) {
			$perPersonHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_per_person_rows.htm"));
			$perPersonGroupRowHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_per_person_group_rows.htm"));
			foreach($result['perPersonItems'] as $perPersonItem) {
				$perPersonItem['rate_groups'] = array_reduce($perPersonItem['rate_groups'], function($html, $group) use ($perPersonGroupRowHTML) {
					$html .= showpage($group,$perPersonGroupRowHTML);
					return $html;
				}, "");
				$perPersonRows .= showpage($perPersonItem, $perPersonHTML);
			}
		}
		if($perPersonRows != "") {
			$GLOBALS['temp']['perPersonRows'] = $perPersonRows;
		} else {
			$GLOBALS['temp']['perPersonRows'] = "<tr><td colspan=\"8\" class=\"txti\" align=\"center\">No per person charges</td></tr>";
		}

		$GLOBALS['temp']['exchNote'] = $result['exchange']['note'];
		$exchangeHTML = join("\n",file(__DIR__ . "/../../../public/html/docs_exchange_item_rows.htm"));
		$exchangeRows = "";
		foreach($result['exchange']['extras'] as $item) {
			$item['ac_ext_desc'] = t_encodeHTMLField($item['ac_ext_desc']);
			$item['curr_conversion'] = t_encodeHTMLField($item['curr_conversion']);
			$exchangeRows .= showpage($item,$exchangeHTML);
		}
		if(trim($exchangeRows) != "") {
			$GLOBALS['temp']['exchRows'] = $exchangeRows;
		} else {
			$GLOBALS['temp']['exchRows'] = "<tr><td colspan=4 class=\"txti\" align=\"center\">No exchange rates</td></tr>";
		}

		$propNotes = "";
		foreach($result['propertyNotes'] as $item) {
			$propNotes .= "<U>".$item['pr_name_last'] ."</U><BR>" . t_encodeHTML($item['pr_bus_memo_info']) . "<BR><BR>";
		}
		$GLOBALS['temp']['propNotes'] = $propNotes;

		$terms = $lDB->get("select rf_booking_info from rf_custom where rf_custom_id = 1",4);
		$bookingTerms = urldecode($terms);
		if($docType == DOC_INVOICE) {
			$bookingTerms = urldecode($lDB->get("SELECT fn_inv_booking_info FROM fn_invoice WHERE fn_invoice_ix = '$invoiceId'",4));
		}
		$GLOBALS['temp']['bookingTerms'] = $bookingTerms;

		if (empty($specials)) { // No specials applied
			$GLOBALS['temp']['specialDetail'] = "None";
		} else { // Special is active, display by default
			$appliedSpecial = '';
			foreach ($specials as $special) {
				$appliedSpecial .= '<div>'.$special['sp_special_desc'].'</div>';
				$appliedSpecial .= '<div class="docSpecialNoteDetail" style="margin-bottom:5px;">&nbsp;-&nbsp;'.$special['sp_special_note'].'</div>';
			}
			$GLOBALS['temp']['specialDetail'] = $appliedSpecial;

			$GLOBALS['temp']['showSpecial'] = "1";
			$GLOBALS['temp']['specialDetailDefault'] = "";
			$GLOBALS['temp']['specialChecked'] = 'checked="checked"';
			$GLOBALS['temp']['showSpecialNote'] = "1";
			$GLOBALS['temp']['specialNoteChecked'] = 'checked="checked"';
			$GLOBALS['temp']['specialNoteExpanded'] = "";
		}

		$bankInfo = "";
		foreach($result['bankInfo'] as $item) {
			$bankInfo .= "
				<tr>
					<td id='$item[bankId]row' class='$item[bankClass]'>
						Acc Name: ".t_encodeHTMLField($item['rf_bank_acc_name'])." (".t_encodeHTMLField($item['rf_currency_name']).")<br>
						Acc No: ".t_encodeHTMLField($item['rf_bank_acc_no'])."<br>
						Detail: ".t_encodeHTMLField($item['rf_bank_name'])." - ".$item['rf_bank_detail_1']."&nbsp;&nbsp;<br>
						<br>
					</td>
				</tr>
			";
		}
		if(trim($bankInfo) != "") {
			$GLOBALS['temp']['bankInfo'] = $bankInfo;
		} else {
			$GLOBALS['temp']['bankInfo'] = "No Bank Details";
		}

		$regInfo = "";
		$busUnit = "";
		$folioProperties = $lDB->get("SELECT DISTINCT pr_business_id FROM fn_folio WHERE rv_reservation_id = '$resId'",3);
		foreach($result['billingInfo'] as $item) {
			if (isset($item['pr_business_id']) && !in_array($item['pr_business_id'], $folioProperties)) {
				continue;
			}
			$regInfo .= "<b>".t_encodeHTMLField($item['pr_name_last'])."</b>";
			$busUnit = $item['pr_name_last'];
			if(trim($item['pr_bus_statutory_1']) != "" && $item['pr_bus_statutory_1'] != "0") {
				$pr_bus_statutory_1_label = $item['pr_bus_statutory_label_1'] != "" ? $item['pr_bus_statutory_label_1'] : $default_statutory_labels['rf_statutory_label_1'];
				$regInfo .= "<br>".$pr_bus_statutory_1_label.": ".t_encodeHTMLField($item['pr_bus_statutory_1']);
			}
			if(trim($item['pr_bus_statutory_2']) != "" && $item['pr_bus_statutory_2'] != "0") {
				$pr_bus_statutory_2_label = $item['pr_bus_statutory_label_2'] != "" ? $item['pr_bus_statutory_label_2'] : $default_statutory_labels['rf_statutory_label_2'];
				$regInfo .= "<br>".$pr_bus_statutory_2_label.": ".t_encodeHTMLField($item['pr_bus_statutory_2']);
			}
			if(trim($item['pr_bus_statutory_3']) != "" && $item['pr_bus_statutory_3'] != "0") {
				$pr_bus_statutory_3_label = $item['pr_bus_statutory_label_3'] != "" ? $item['pr_bus_statutory_label_3'] : $default_statutory_labels['rf_statutory_label_3'];
				$regInfo .= "<br>".$pr_bus_statutory_3_label.": ".t_encodeHTMLField($item['pr_bus_statutory_3']);
			}
			$regInfo .= "<br>";
		}

		$GLOBALS['temp']['regInfo'] = $regInfo;
		$GLOBALS['temp']['busUnit'] = t_encodeHTMLField($busUnit);
		$GLOBALS['temp']['busUnitJS'] = t_encodeOverlib($busUnit);

		// ROOMING START
		$roomHTML = join("\n",file(__DIR__ . "/../../../public/html/doc_room_rows.htm"));
		$roomRows = "";
		foreach($result['rooming']['rooms'] as $item) {
			$item['property'] = t_encodeHTMLField($item['property']);
			$item['accomm'] = t_encodeHTMLField($item['accomm']);
			$item['room'] = t_encodeHTMLField($item['room']);
			$item['reason'] = t_encodeHTMLField($item['reason']);
			$roomRows .= showPage($item,$roomHTML);
		}
		$GLOBALS['temp']['rooms'] = $roomRows;
		$guestGroupHTML = join("\n",file(__DIR__ . "/../../../public/html/doc_guest_rows.htm"));
		$guestGroupRowHTML = join("\n",file(__DIR__ . "/../../../public/html/doc_guest_group_rows.htm"));
		$guestGroupRows = "";
		foreach($result['rooming']['guestGroups'] as $item) {
			$currRow = "";
			foreach($item['rows'] as $rowItem) {
				$currRow .= showPage($rowItem,$guestGroupRowHTML);
			}
			$rowTemp = str_replace("!rows!",$currRow,$guestGroupHTML);
			$item['rows'] = "";
			$item['item1'] = str_replace("\n","<BR>",t_encodeHTMLField(str_replace("<BR>","\n",$item['item1'])));
			$item['item2'] = str_replace("\n","<BR>",t_encodeHTMLField(str_replace("<BR>","\n",$item['item2'])));
			$item['item3'] = str_replace("\n","<BR>",t_encodeHTMLField(str_replace("<BR>","\n",$item['item3'])));
			$item['item4'] = str_replace("\n","<BR>",t_encodeHTMLField(str_replace("<BR>","\n",$item['item4'])));
			$guestGroupRows .= showPage($item,$rowTemp);
		}
		$GLOBALS['temp']['guestGroups'] = $guestGroupRows;

		$guestNoteHTML = join("\n",file(__DIR__ . "/../../../public/html/doc_guest_note_rows.htm"));
		$guestNoteRows = "";
		foreach($result['rooming']['notes'] as $item) {
			$guestNoteRows .= showpage($item,$guestNoteHTML);
		}
		$GLOBALS['temp']['guestNotes'] = $guestNoteRows;

		$guestMemoRows = "";
		foreach($result['rooming']['memos'] as $item) {
			$guestMemoRows .= showpage($item,$guestNoteHTML);
		}
	   $GLOBALS['temp']['guestMemos'] = $guestMemoRows;

		$invoiceHTML = "
			<tr bgcolor=\"#FFFFFF\" class=\"txt\">
				<td class=\"br\" valign=\"top\">!fn_invoice_ix!</td>
				<td class=\"br\" valign=\"top\">!fn_inv_date!</td>
				<td class=\"br\" valign=\"top\">!fn_inv_from!</td>
				<td class=\"br\" valign=\"top\">!fn_inv_to!</td>
				<td class=\"br\" align=\"right\" valign=\"top\">!fn_invoice_amt_excl!</td>
				<td class=\"br\" align=\"right\" valign=\"top\">!fn_invoice_amt_tax!</td>
				<td class=\"br\" align=\"right\" valign=\"top\">!fn_invoice_amount! !fn_inv_curr!</td>
			</tr>
		";
		$invoiceRows = "";
		foreach($result['invoice'] as $item) {
			$invoiceRows .= showpage($item,$invoiceHTML);
		}
		$GLOBALS['temp']['invoiceRows'] = $invoiceRows;
		// ROOMING END

		// Comment box start	
		if($_SESSION['userStatusId'] == "0") {
			if(!isset($_SESSION['publicData'])) {
				$commentName = "";
				$commentTel = "";
				$commentFax = "";
			} else {
				$commentName = trim($_SESSION['publicData']['pr_name_first']." ".$_SESSION['publicData']['pr_name_last']);
				$commentTel = $_SESSION['publicData']['telephone'];
				$commentFax = $_SESSION['publicData']['fax'];
			}
			$addresseeEmail = getContactEmail($resOfficeId);
			$GLOBALS['temp']['emailTo'] = $addresseeEmail;
		} else {
			$commentName = getContactName($GLOBALS['userid']);
			$commentTel = getContactTelephone($GLOBALS['userid']);
			$commentFax = getContactFax($GLOBALS['userid']);
		}
		
		$GLOBALS['temp']['commentBox'] = "We trust all is in order. Should you require any further assistance please contact us.\n\nRegards,\n$commentName";
		if(trim($commentTel) != "" && $commentTel != "0") {
			$GLOBALS['temp']['commentBox'] .=  "\nTel: " . $commentTel;
		}
		if(trim($commentFax) != "" && $commentFax != "0") {
			$GLOBALS['temp']['commentBox'] .= "\nFax: " . $commentFax;
		}
		// Comment box end

		$GLOBALS['temp']['randomId'] = md5(uniqid(rand(), 1));
	}
	// [END] HTML Section

	// [START] Text Section
	if((isset($renderMode) && $renderMode == "text" && isset($renderType) && $renderType == "view") || ( (!isset($_POST['mail_body']) || trim($_POST['mail_body']) == "") && (isset($renderMode) && $renderMode == "text") && (isset($renderType) && $renderType == "send")) ) {
		$email_text = join("", file(__DIR__ . "/detailed_email.txt"));
		$emailToSetup = "";
		$relate = relatedEmailAddress($resId,false);
		$index = 1;
		foreach($relate as $item) {
			$emailToSetup .= "emailToName[emailToName.length] = \"$item[name]\"; emailToAddress[emailToAddress.length] = \"$item[email]\";";
			if($item['id'] == $emailPersonaId) {
				$GLOBALS['temp']['emailToIndex'] = $index;
			}
			$index++;
		}
		if ($_SESSION['userStatusId'] == "0") {
			$emailToSetup .= "showSearch = false;";
		}
		$autoCC = array();
		$autoClass = "collapse printCollapse";
		if(db_pf_object_exists_by_name("email_document")) {
			$autoCC = getAutoCC(db_pf_object_by_name("email_document"));
			if(sizeof($autoCC) > 0) {
				$autoClass = "expand";
			}
		}
		$GLOBALS[$form]->FormHTML =
			str_replace("!emailToSetup!", str_replace("'", "\\'", $emailToSetup),
			str_replace("!emailSubject!", "$result[rv_res_name] ($resId)",
			str_replace("!hasAttachment!", "collapse",
			str_replace("!emailBody!", $email_text,
			str_replace("!emailTo!", $emailTo,
			str_replace("!auto_cc_class!",$autoClass,
			str_replace("!auto_cc!",join(", ",$autoCC),
			Join("", file(__DIR__ . "/../../../public/html/email_popup.htm")))))))));
		$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/email_popup.htm";

		$GLOBALS['temp'] = array_merge($result, $GLOBALS['temp']);
		$GLOBALS['temp']['email_type'] = DOC_SEND_TEXT;
		$GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$_SESSION[userid]'",4);

		$GLOBALS['temp']['princName'] = $principalName;
		$GLOBALS['temp']['fromAddress'] = $principalName . "\n\n" . t_decodeHTML($GLOBALS['temp']['fromAddress']);
		if($userStatusId != "0") {
			$GLOBALS['temp']['consultantDetail'] = "Consultant:\n" . t_decodeHTML($GLOBALS['temp']['consultantDetail']) . "\n";
			$GLOBALS['temp']['agentDetail'] = "Agent:\n" . t_decodeHTML($GLOBALS['temp']['agentDetail']) . "\n";
			$GLOBALS['temp']['contactDetail'] = "Contact:\n" . t_decodeHTML($GLOBALS['temp']['contactDetail']) . "\n";
			$GLOBALS['temp']['billingContactDetail'] = "Billing Contact:\n" . t_decodeHTML($GLOBALS['temp']['billingContactDetail']) . "\n";
		} else {
			$GLOBALS['temp']['consultantDetail'] = "";
			$GLOBALS['temp']['agentDetail'] = "";
			$GLOBALS['temp']['contactDetail'] = "";
			$GLOBALS['temp']['billingContactDetail'] = "";
		}

		$resItemText = join("",file(__DIR__ . "/docs_accomm_item_rows.txt"));
		$resItemRows = "";
		foreach($result['resItems'] as $item) {
			$item['total'] = trim($item['compAmt'] . " " . $item['rf_currency_symbol']);
			removeBlank($item," ");
			$resItemRows .= showpage($item,$resItemText);
		}
		$GLOBALS['temp']['resItemRows'] = $resItemRows;

		if(trim($result['resNote']) != "") {
			$GLOBALS['temp']['resNote'] = textHeader("Reservation Notes").$result['resNote'] . "\n\n";
		} else {
			$GLOBALS['temp']['resNote'] = "";
		}
		if(trim($result['resGuestNote']) != "") {
			$GLOBALS['temp']['guestInfo'] = textHeader("Guest Information").$result['resGuestNote'] . "\n\n";
		} else {
			$GLOBALS['temp']['guestInfo'] = "";
		}
		$resExtraText = join("",file(__DIR__ . "/docs_res_extra_rows.txt"));
		
		$resAccomExtraRows = "";
		$extraNote = "";
		foreach($result['resAccomExtras'] as $item) {
			$item['date_service'] = chng_date($item['rv_extra_date_serv'], "-") . " to ". chng_date($item['rv_extra_date_depart'], "-");
			removeBlank($item," ");
			$resAccomExtraRows .= showpage($item,$resExtraText);
		}
		
		$GLOBALS['temp']['resAccomExtraRows'] = $resAccomExtraRows;
				
		$resExtraRows = "";
		foreach($result['resExtras'] as $item) {
			removeBlank($item," ");
			$resExtraRows .= showpage($item,$resExtraText);
		}
		
		$GLOBALS['temp']['resExtraRows'] = $resExtraRows;
				
		$resTravelRows = "";
		foreach($result['resTravel'] as $item) {
			removeBlank($item," ");
			$resTravelRows .= showpage($item,$resExtraText);
		}
		
		$GLOBALS['temp']['resTravelRows'] = $resTravelRows;

		$GLOBALS['temp']['paymentSummary'] = "";
		if($userStatusId == "0") {
			$outstanding = $result['payTotal'] - $result['payedTotal'];
			fixAmtDisplay($outstanding,2);
			$currency = $result['payItems'][0]['rf_currency_symbol'];
			$GLOBALS['temp']['paymentSummary'] = textHeader("Payment Summary") ."Total due to supplier: $result[payTotal] $currency
Amount paid: $result[payedTotal] $currency
Total outstanding: $outstanding $currency\n\n";
		}

		$extraNote = "";
		$extraMemo = "";
		foreach($mergedExtra as $resExtra) {
			foreach($resExtra as $item) {
				if(isset($item['rv_res_item_group_ix'])) {
					// Only guests that are linked to the group and have a group set (i.e. are not orphaned)
					$guestList = $lDB->get("
						SELECT
							pr_persona.pr_name_first,
							pr_persona.pr_name_last
						FROM
							rv_res_item_guest
							INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
						WHERE
							rv_res_item_guest.rv_res_item_group_id = '".$item['rv_res_item_group_ix']."'
					",2);
				}
				else {
					// We don't want to pull any guests
					$guestList = [];
				}
				$roomInfo = trim($item['ac_desc']);
				
				$guestNames = "";
				foreach($guestList as $guestItem) {
					if($guestNames != "") {
						$guestNames .= ", ";
					}
					$guestNames .= trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
				}
				if($roomInfo != "" && $guestNames != "") {
					$roomInfo .= ": ";
				}
				if($guestNames != "") {
					$roomInfo .= $guestNames;
				}
				if($roomInfo != "") {
					$roomInfo = "[$roomInfo]\n";
				}

				$extraDate = chng_date($item['rv_extra_date_serv'], "-");
				if (trim($extraDate) == "" || $extraDate == "0") {
					$extraDate = "";
				} else {
					$extraDate .= ":";
				}

				$item['rv_extra_date_serv'] = chng_date($item['rv_extra_date_serv'], "-");
				if($item['rv_extra_date_depart'] != "" && $item['rv_extra_date_depart'] != "0000-00-00") {
					$item['rv_extra_date_depart'] = chng_date($item['rv_extra_date_depart'], "-");
				} else {
					$item['rv_extra_date_depart'] = "";
				}
				
				if($item['pr_name_last'] != "" && $item['pr_name_last'] != "&nbsp;") {
					$propName = "&nbsp;".$item['pr_name_last'];
				} else {
					$propName = "";
				}
				if(trim($item['rv_extra_note']) != "" && $item['rv_extra_note'] != "0") {
					if($item['rv_extra_ind'] == 3) {
						$extraNote .= $item['rv_extra_date_serv']." to ". $item['rv_extra_date_depart']. 
							$propName.":  ". $item['ac_ext_desc']." - ".trim($item['ac_desc']). " (". $item['ac_extra_cat_desc'].") - " . $item['rv_extra_note'] . "\n
						";
					} else {
						$extraNote .= $item['rv_extra_date_serv'].$propName.": ".$item['ac_ext_desc']." (".$item['ac_extra_cat_desc']. ") - ".$roomInfo. $item['rv_extra_note']."\n
							";
					}
					$extraNote .= "\n";
				}
				if(trim($item['rv_extra_note_internal']) != "" && $item['rv_extra_note_internal'] != "0" ) {
					if($item['rv_extra_ind'] == 3) {
						$extraMemo .= $item['rv_extra_date_serv']." to ". $item['rv_extra_date_depart']. 
							$propName.":  ". $item['ac_ext_desc']." - ".trim($item['ac_desc']). " (". $item['ac_extra_cat_desc'].") - " . $item['rv_extra_note_internal'] . "\n
						";
					} else {
						$extraMemo .= $item['rv_extra_date_serv'].$propName.": ".$item['ac_ext_desc']." (".$item['ac_extra_cat_desc']. ") - ".$roomInfo. $item['rv_extra_note_internal']."\n
						";
					}
					$extraMemo .= "\n";
				}
			}
		}
		
		if(trim($extraNote) != "") {
			$GLOBALS['temp']['extraNote'] = textHeader("Extras Notes").$extraNote . "\n\n";
		} else {
			$GLOBALS['temp']['extraNote'] = "";
		}
		
		if($extraMemo != "") {
			$extraMemo = "Extras Internal Memos\n".$extraMemo;
		}
		$GLOBALS['temp']['extraMemo'] = $extraMemo;
	}

	if(isset($renderMode) && $renderMode == "text" && isset($renderType) && $renderType == "send") {
		// Send the email
		$to = $_POST['mail_to'];
		if(!isset($_POST['mail_from']) || trim($_POST['mail_from']) == "") {
			$from = $GLOBALS['temp']['emailFrom'];
			if(trim($from) == "") {
				$from = $_SESSION['principal_email'];
			}
		} else {
			$from = $_POST['mail_from'];
		}
		if(!isset($_POST['mail_subj']) || trim($_POST['mail_subj']) == "") {
			if ($userStatusId < 2 /*&& $dbcode[0] == "W"*/) {
				$subject = "Thank you: Reservation $resId from Resrequest";
			} else {
				$subject = "Reservation ".$resId;
			}
		} else {
			$subject = $_POST['mail_subj'];
		}
		if (!isset($_POST['mail_body']) || trim($_POST['mail_body']) == "") {
			$message = showpage($GLOBALS['temp'], "Thank you for your reservation request with details:\n".$email_text);
		} else {
			$message = $_POST['mail_body'];
		}
		$headers = "From: ".$principalName."<$from>\r\n";
		/* and now mail it */
		$error = email($from, $to, $subject, $headers, $message, 0, 0, $resId, $principalName,"","",db_pf_object_by_name("email_document"));
		if (!$error) {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
		} else {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
		}
		die();
	}
	// [END] Text Section

	// [START] PDF Section
	if(isset($renderMode) && $renderMode == "pdf" && isset($renderType) && $renderType != "email") {
		$regInfo = "";
		$busUnit = "";
		$folioProperties = $lDB->get("SELECT DISTINCT pr_business_id FROM fn_folio WHERE rv_reservation_id = '$resId'",3);
		foreach($result['billingInfo'] as $item) {
			if (isset($item['pr_business_id']) && !in_array($item['pr_business_id'], $folioProperties)) {
				continue;
			}
			$regInfo .= "<B>$item[pr_name_last]</B>";
			$busUnit = $item['pr_name_last'];

			if(trim($item['pr_bus_statutory_1']) != "" && $item['pr_bus_statutory_1'] != "0") {
				$pr_bus_statutory_1_label = $item['pr_bus_statutory_label_1'] != "" ? $item['pr_bus_statutory_label_1'] : $default_statutory_labels['rf_statutory_label_1'];
				$regInfo .= "\n".$pr_bus_statutory_1_label.": $item[pr_bus_statutory_1]";
			}
			if(trim($item['pr_bus_statutory_2']) != "" && $item['pr_bus_statutory_2'] != "0") {
				$pr_bus_statutory_2_label = $item['pr_bus_statutory_label_2'] != "" ? $item['pr_bus_statutory_label_2'] : $default_statutory_labels['rf_statutory_label_2'];
				$regInfo .= "\n".$pr_bus_statutory_2_label.": $item[pr_bus_statutory_2]";
			}
			if(trim($item['pr_bus_statutory_3']) != "" && $item['pr_bus_statutory_3'] != "0") {
				$pr_bus_statutory_3_label = $item['pr_bus_statutory_label_3'] != "" ? $item['pr_bus_statutory_label_3'] : $default_statutory_labels['rf_statutory_label_3'];
				$regInfo .= "\n".$pr_bus_statutory_3_label.": $item[pr_bus_statutory_3]";
			}

			$regInfo .= "\n";
		}
		$result['regInfo'] = $regInfo;
		$result['busUnit'] = strtoupper($busUnit);

		$extraNote = "";
		$extraMemo = "";
		foreach($mergedExtra as $resExtra) {
			foreach($resExtra as $item) {
				if(isset($item['rv_res_item_group_ix'])) {
					// Only guests that are linked to the group and have a group set (i.e. are not orphaned)
					$guestList = $lDB->get("
					SELECT
						pr_persona.pr_name_first,
						pr_persona.pr_name_last
					FROM
						rv_res_item_guest
						INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
					WHERE
						rv_res_item_guest.rv_res_item_group_id = '".$item['rv_res_item_group_ix']."'
					",2);
				}
				else {
					// We don't want to pull any guests
					$guestList = [];
				}
				$roomInfo = trim($item['ac_desc']);
				
				$guestNames = "";
				foreach($guestList as $guestItem) {
					if($guestNames != "") {
						$guestNames .= ", ";
					}
					$guestNames .= trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
				}
				if($roomInfo != "" && $guestNames != "") {
					$roomInfo .= ": ";
				}
				if($guestNames != "") {
					$roomInfo .= $guestNames;
				}
				if($roomInfo != "") {
					$roomInfo = "[$roomInfo]\n";
				}

				$item['rv_extra_date_serv'] = chng_date($item['rv_extra_date_serv'], "-");
				if($item['rv_extra_date_depart'] != "" && $item['rv_extra_date_depart'] != "0000-00-00") {
					$item['rv_extra_date_depart'] = chng_date($item['rv_extra_date_depart'], "-");
				} else {
					$item['rv_extra_date_depart'] = "";
				}
				
				if($item['pr_name_last'] != "" && $item['pr_name_last'] != "&nbsp;") {
					$propName = " ".$item['pr_name_last'].":";
				} else {
					$propName = "";
				}
								
				if(trim($item['rv_extra_note']) != "" && $item['rv_extra_note'] != "0") {
					if($item['rv_extra_ind'] == 3) {
						$extraNote .= $item['rv_extra_date_serv']." to ". $item['rv_extra_date_depart']. 
							$propName." ". $item['ac_ext_desc']." - ".trim($item['ac_desc']). " (". $item['ac_extra_cat_desc'].") - " . $item['rv_extra_note'] . "\n
						";
					} else {
						$extraNote .= $item['rv_extra_date_serv'].$propName." ". $item['ac_ext_desc']." (".$item['ac_extra_cat_desc']. ") - ".$roomInfo. $item['rv_extra_note']."\n
							";
					}
					$extraNote .= "\n";
				}
				if(trim($item['rv_extra_note_internal']) != "" && $item['rv_extra_note_internal'] != "0" ) {
					if($item['rv_extra_ind'] == 3) {
						$extraMemo .= $item['rv_extra_date_serv']." to ". $item['rv_extra_date_depart']. 
							$propName."  ". $item['ac_ext_desc']." - ".trim($item['ac_desc']). " (". $item['ac_extra_cat_desc'].") - " . $item['rv_extra_note_internal'] . "\n
						";
					} else {
						$extraMemo .= $item['rv_extra_date_serv'].$propName." ".$item['ac_ext_desc']. " (".$item['ac_extra_cat_desc']. ") - ".$roomInfo. $item['rv_extra_note_internal']."\n
						";
					}
					$extraMemo .= "\n";
				}
			}
		}

		if($docKey == "0") {
			$pdf = new PDF("\t",'P','mm','A4',false);
		} else {
			$pdf->AddPage();
		}
		$firstPage = $pdf->PageNo();
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$togglePlan = ($toggleMap & 1) == 1;
		$toggleReservationNote = ($toggleMap & 2) == 2;
		$toggleBankDetails = ($toggleMap & 4) == 4;
		$toggleGuestInformation = ($toggleMap & 8) == 8;
		$toggleCommission = ($toggleMap & 16) == 16;
		$toggleExtraNote = ($toggleMap & 32) == 32;
		$toggleExchNote = ($toggleMap & 64) == 64;
		$togglePropertyNoteCheck = ($toggleMap & 128) == 128;
		$toggleInternalMemoCheck = ($toggleMap & 256) == 256;
		$toggleComment = ($toggleMap & 512) == 512;
		$toggleCancelNoteCheck = ($toggleMap & 1024) == 1024;
		$toggleCostComponent = ($toggleMap & 2048) == 2048;
		$toggleCostSummary = ($toggleMap & 4096) == 4096;
		$toggleRooming = ($toggleMap & 8192) == 8192;
		$toggleGuestNote = ($toggleMap & 16384) == 16384;
		$toggleGuestMemo = ($toggleMap & 32768) == 32768;
		$toggleFolio = ($toggleMap & 65536) == 65536;
		$toggleInvoice = ($toggleMap & 131072) == 131072;
		$toggleCancelPay = ($toggleMap & 262144) == 262144;
		$toggleResDet = ($toggleMap & 524288) == 524288;
		if($useResDetailDefault == "1") {
			if(sizeof($result['resItems']) < 1) {
				$toggleResDet = false;
			} else {
				$toggleResDet = true;
			}
		}
		if($docType == DOC_INVOICE) {
			$toggleResDet = true;
			$showTaxTableAlign = ($optTaxTableAlign == "1"?"R":"L");
		}		
		$toggleCreditCard = ($toggleMap & 1048576) == 1048576;
		$toggleBookingTerms = ($toggleMap & 2097152) == 2097152;
		$togglePayReceipts = ($toggleMap & 4194304) == 4194304;
		$toggleResAccomm = ($toggleMap & 8388608) == 8388608;
		$toggleRoomingNames = ($toggleMap & 16777216) == 16777216;
		$toggleTax = ($toggleMap & 33554432) == 33554432;
		$toggleOriginator = ($toggleMap & 67108864) == 67108864;
		$toggleRateTypeSummary = ($toggleMap & 134217728) == 134217728;
		$toggleRateTypeSummaryNote = ($toggleMap & 268435456) == 268435456;
		$toggleTotalItem = ($toggleMap & 536870912) == 536870912;
		$toggleGross = ($toggleMap & 1073741824) == 1073741824;
		$togglePerPerson = ($toggleMap & 2147483648) == 2147483648;
		$toggleOnlineGuestCheckIn = ($toggleMap & 4294967296) == 4294967296;
		$togglePublicPayments = ($toggleMap & 8589934592) == 8589934592;

		if($docType == DOC_INVOICE && ($invoicePrint['fn_inv_print_count'] > 0 || $useInvoiceDefaults == "1")) {
			$toggleResAccomm = ($optAccomm == "1");
			$toggleBankDetails = ($optBank == "1");
			$toggleCreditCard = ($optCCA == "1");
			$showServiceDate = ($optDate == "1");
			$toggleTax = ($optTax == "1");
			$showTaxTable = ($optTaxTable == "1");
			$showTaxTableGL = ($optTaxTableGL == "1");
			$showTaxTableRate = ($optTaxTableRate == "1");
			$showTaxTableTotal = ($optTaxTableTotal == "1");
			$toggleBookingTerms = ($optTerms == "1");
			$togglePropertyNoteCheck = ($optTermsBus == "1");
		}

		if($toggleComment != "" && $renderType != "send") {
			if($_POST['comment'] != "") {
				session_set("documentComment",$_POST['comment']);
			}
			if ($commentArg != "") {
				session_set("documentComment",$commentArg);
			}
			$documentComment = $_SESSION['documentComment'];
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Comments", 'LRTB', 1, 'L', 1);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $documentComment, '', 'L', 0, 0);
			$pdf->Ln(4);
			$pdf->SetFillColor(0x00, 0x00, 0x00);
			$pdf->Row(array(array('fill' => 1, 'height' => 0.5)));
			$pdf->SetFillColor(0xD0, 0xD0, 0xC8);
			$pdf->Ln(4);
		} else {
			session_restart();
			unset($_SESSION['documentComment']);
			session_write_close();
		}
		if(isset($_POST['address']) && $_POST['address'] != "" || $addressArg != "") {
			if($_POST['address'] != "") {
				session_set("documentAddress",t_decodeHTML($_POST['address']));
				$documentAddress = $_POST['address'];
			} else {
				session_set("documentAddress",t_decodeHTML($addressArg));
				$documentAddress = t_decodeHTML($addressArg);
			}
		} else {
			$documentAddress = isset($_SESSION['documentAddress']) ? $_SESSION['documentAddress'] : "";
			session_restart();
			unset($_SESSION['documentAddress']);
			session_write_close();
		}
		$documentAddress = str_replace("&nbsp;", " ", $documentAddress);

		if($docType == DOC_FOLIO || $docType == DOC_INVOICE) {
			$documentAddress = t_decodeHTML($result['contactDetail']);
		}
		$logoY = $pdf->y;
		$resOfficeHead = "";
		if($docType != DOC_INVOICE) {
			$resOfficeHead = "<B>Reservation Office:</B>\n";
		}

		$scalingFactor = 1/$pdf->k;
		$sideColumnWidth = $scalingFactor * 190;
		$middleColumnWidth = $pdf->GetPageWidth(1) - ($sideColumnWidth*2);

		$logoWidth = $middleColumnWidth;
		
		if($rf_doc_header_logo_yn == "1") {
			if($rf_doc_header_count == 1) {
				$logoWidth = $pdf->GetPageWidth(1);
			} elseif($rf_doc_header_count == 2) {
				$logoWidth = $sideColumnWidth + $middleColumnWidth;
			}
		} else {
			if($rf_doc_header_count == 1) {
				$logoWidth = $sideColumnWidth + $middleColumnWidth;
			}
		}
		if($rf_doc_header_count > 0) {
			if($rf_doc_header_res_office_yn == "1") {
				$pdf->MultiCell($sideColumnWidth, $pdf->FontSize+1, $resOfficeHead.t_decodeHTML($result['fromAddress']), '', 'L', 0, 1);
			}
			$pdf->MultiCell($logoWidth, $pdf->FontSize+1, "", '', 0, '', 1);
			if($rf_doc_header_invoice_yn == "1") {
				$pdf->MultiCell($sideColumnWidth-10, $pdf->FontSize+1, t_decodeHTML($result['regInfo']), '', 'L', 0, 1);
			}
			$pdf->Ln(0, 4);
			if($rf_doc_header_logo_yn == "1") {
				$principal_id = !empty($_SESSION['principal_id']) ? $_SESSION['principal_id'] : $GLOBALS['principal_id'];
				if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$logoFilename")) {
					$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename");
					$pic['w'] = ($pic['w'] * $scalingFactor) - 2;
					if ($pic['w'] > $logoWidth) {
						$pic['w'] = $logoWidth;
					}
					$res_logo = explode(".",$logoFilename);
					if(substr($res_logo[0],-3,3) != "pdf") {
						$pdf_logo = $res_logo[0] . '_pdf.' . $res_logo[1];
						if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$pdf_logo")) {
							$logoFilename = $pdf_logo;
						}
					}
					if($GLOBALS['system'] != "training") {
						if($rf_doc_header_logo_align == "C") {
							$logoX = ($logoWidth / 2) - ($pic['w']/2);
						} elseif($rf_doc_header_logo_align == "R") {
							$logoX = $logoWidth - $pic['w'];
						} else {
							$logoX = 0;
						}
						if($rf_doc_header_res_office_yn == "1") {
							$logoX += $sideColumnWidth;
						}

						require_once(__DIR__ . '/functions.imageset.php');
						$logoWidth = imagesetLogoSizeOverride("invoiceFolioResSummaryPdfLogoWidthOverride", $pic['w']);
						$finalH = $pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename", $logoX, $logoY, $logoWidth);
					}
					if (($logoY + $finalH) > $pdf->y) {
						$pdf->y = $logoY + $finalH;
					}
				}
			}
		}
		$pdf->SetLeftMargin(1);
		$pdf->Ln(2);
		$pdf->SetFont('Arial', 'B', 13);
		$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, strtoupper(t_decodeHTML($result['docTitle'] . " - " .$result['docRef'])), '', 1, 'C');
		$pdf->SetFont('Arial', 'B', $pdfFontSize);
		$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "", 'B', 1, 'C');
		$pdf->Ln(2);

		//Display res number if res details have been collapsed
		if($toggleResDet == "0") {
			if(!preg_match("/Res No:/",$documentAddress)) {
				$documentAddress .= "Res No: $result[rv_reservation_id]\n";
			}
			if(isset($result['folio_room_desc']) && trim($result['folio_room_desc']) != "") {
				$documentAddress .= "Room: ".$result['folio_room_desc'] . "\n";
			}
			if($docType == DOC_INVOICE) {
				$documentAddress .= "Invoice Date: $result[invDate]\n";
			}
		}
		$documentAddress = t_decodeHTML($documentAddress);

		$pdf->SetTextColor(255, 255, 255);
		$pdf->MultiCell(9, $pdf->FontSize+1, "CUS:", '', 'L', 0, 1);
		$pdf->SetTextColor(0, 0, 0);

		$pdf->MultiCell(($pdf->GetPageWidth() * 0.37), $pdf->FontSize+1, $documentAddress, '', 'L', 0, 1);
		$pdf->MultiCell(($pdf->GetPageWidth() * 0.085), $pdf->FontSize+1, "", '', 'L', 0, 1);

		if ($docType == DOC_INVOICE) {
			$fiscalise = new Fiscalator();
			$fiscalData = $fiscalise->getFiscalData($invoiceId);
			$isFiscalised = !empty($fiscalData) ? true : false;

			if ($isFiscalised) {
				$fiscalLabels = !empty($fiscalData['fiscalDocFields']) ? $fiscalData['fiscalDocFields'] : "";
				$fiscalLabelCol = "";
				$fiscalInfo = "";
				if ($fiscalLabels && !empty($fiscalData['fiscalDocFields'])) {
					foreach ($fiscalLabels as $fiscalLabel => $value) {
						if (strtolower($fiscalLabel) != "qrcode") {
							$fiscalLabelCol .= $fiscalLabel . ":\n";
							$fiscalInfo .= $value . "\n";
						}
					}
				}

				if (isset($fiscalData['qrCodeBase64']) && !empty($fiscalData['qrCodeBase64'])) {
					$pdf->Image(
						"data:image/png;base64," . $fiscalData['qrCodeBase64'],
						($pdf->GetPageWidth() * 0.37),
						$pdf->GetY(),
						21,
						0,
						"png"
					);
				}
			}
		}

		$pdf->SetLeftMargin(10);
		global $publicData;
		if(isset($_SESSION['publicData'])) {
			$publicData = $_SESSION['publicData'];
		} else {
			$publicData = array(
				'pr_name_first'=>"",
				'pr_name_last'=>"",
				'telephone'=>""
			);
		}	
		$userStatusId = !empty($_SESSION['userStatusId']) ? $_SESSION['userStatusId'] : $GLOBALS['userStatusId'];
		
		if ($userStatusId == "0") {
			$result['rv_contact'] = $publicData['pr_name_first']." ".$publicData['pr_name_last'];
			$result['tel_number'] = $publicData['telephone'];
		}
		if($toggleResDet != "0") {
			if($toggleOriginator) {
				$originatorLabel = "Originator:         \n";
				$originatorValue = $result['originator_name'] . "\n";
			} else {
				$originatorLabel = "";
				$originatorValue = "";
			}
			if($docType != DOC_INVOICE) {
				$agentId = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'", 4);
				$agentName = getContactName($agentId);
				if($agentName == "") {
					$agentName = "Direct";
				}
				$agentRef = $result['rv_agent_ref'];
				if(strlen($agentRef) > 20) {
					$agentRef = substr($agentRef,0,20) . "...";
				}
				$reservationInfo = 
					"Reservation Status: \n".
					($result['rf_reservation_status_id'] == 20?"Expires: ". "\n":"").
					(isset($result['folio_room_desc']) && trim($result['folio_room_desc'])!=""?"Room:     \n":"").
					"Date Created:       \n".
					"Date Amended:       \n".
					"Contact Person:     \n".
					"Agent:     \n";
				if($result['tel_number'] != "None") {
					$reservationInfo .= "Telephone:          \n";
				}
				if($result['fax_number'] != "None") {
					$reservationInfo .= "Fax:                \n";
				}
				$reservationInfo .=
					"Email:              \n".
					(trim($agentRef) != ""?"Voucher Reference:  \n":"").
					$originatorLabel . 
					(($hideFinancials != "true")?
						"Rate Type:          \n".
						"Payment Plan:       \n"
					:"").
					(trim($result['consultantName']) != ""?"Your Consultant:    ":"");
			} else {
				$reservationInfo = "Invoice Date:    \n". "Reservation Name:   \n". "Reservation No:     \n" . "Voucher Reference:  \n";
			}

			if ($docType == DOC_INVOICE && $isFiscalised) {
				$reservationInfo .= $fiscalLabelCol;
			}

			$pdf->MultiCell($pdf->GetPageWidth() * 0.16, $pdf->FontSize+1, t_decodeHTML($reservationInfo), '', 'L', 0, 1);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			if($docType != DOC_INVOICE) {
				$agentPercent = ($showAgentComm == "true")?" (".$result['rv_commission_perc'].")":"";
				$reservationInfo = 
					"<B>" . $result['rf_reservation_status_desc']."</B>\n".
					($result['rf_reservation_status_id'] == 20?
						chng_date($lDB->get("SELECT rv_provision_expiry_date FROM rv_reservation WHERE rv_reservation_ix = '$result[rv_reservation_id]'",4),"-")."\n"
					:"").
					(isset($result['folio_room_desc']) && trim($result['folio_room_desc'])!=""?$result['folio_room_desc']."\n":"").
					$result['rv_date_recorded']."\n".
					$result['rv_date_changed']."\n".
					$result['rv_contact']."\n".
					$agentName."\n";
				if($result['tel_number'] != "None") {
					$reservationInfo .= $result['tel_number']."\n";
				}
				if($result['fax_number'] != "None") {
					$reservationInfo .= $result['fax_number']."\n";
				}
				$reservationInfo .=
					$result['email_address']."\n".
					(trim($agentRef) != ""?$agentRef."\n":"").
					$originatorValue.
					(($hideFinancials != "true")?
						$result['rt_rate_type_desc'] . " (" . $result['rf_currency_symbol'] . ")\n".
						$result['ac_pay_plan_desc'].$agentPercent."\n"
					:"").
					(trim($result['consultantName']) != ""?"".$result['consultantName']:"");
			} else {
				$reservationInfo = $result['invDate']."\n".$result['rv_res_name']."\n". $result['rv_reservation_id']."\n".$result['fn_inv_agent_ref']."\n";
				
				if ($docType == DOC_INVOICE && $isFiscalised) {
					$reservationInfo .= $fiscalInfo;
				}
			}
			$pdf->MultiCell($pdf->GetPageWidth() * 0.34, $pdf->FontSize+1, t_decodeHTML($reservationInfo), '', 'L', 0, 1);
		}
		$pdf->Ln(0, 1);
		$pdf->Ln(4);

		if(($docType == DOC_FOLIO || $docType == DOC_INVOICE) && $toggleResAccomm) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			if(sizeof($result['resItems']) != 0) {
				if($dayActivity == "true") {
					$accommWidth = "85%";
					$accommLabel = "Activity";
					$accommArriveLabel = "Date";
					$accommPropertyLabel = "";
					$accommAccommLabel = "";
					$accommRoomLabel = "Unit";
				} else {
					$accommWidth = "100%";
					$accommLabel = "Accommodation";
					$accommArriveLabel = "Arrive";
					$accommPropertyLabel = "Property";
					$accommAccommLabel = "Accommodation";
					$accommRoomLabel = "Rm";
				}
				$pdf->Row(array(array('width' =>$accommWidth, 'data' => $accommLabel, 'border' => 'LRTB', 'fill' => 1)));
				$pdf->SetFont('Arial', '', $pdfFontSize);

				$pdf->Row(array(array('width' => "10%", 'data' => $accommArriveLabel, 'border' => 'LRTB', 'fill' => 1)),0);

				if($dayActivity != "true") {
					$pdf->Row(array(array('width' => "10%", 'data' => "Depart", 'border' => 'LRTB', 'fill' => 1)),0);
				}

				$pdf->Row(array(
					array('width' => "30%", 'data' => $accommPropertyLabel, 'border' => 'LRTB', 'fill' => 1),
					array('width' => "30%", 'data' => $accommAccommLabel, 'border' => 'LRTB', 'fill' => 1)
				),0);

				if($dayActivity != "true") {
					$pdf->Row(array(array('width' => "5%", 'data' => "Ngt", 'border' => 'LRTB', 'fill' => 1, 'align'=>'R')),0);
				}

				$pdf->Row(array(
					array('width' => "5%", 'data' => $accommRoomLabel, 'border' => 'LRTB', 'fill' => 1, 'align'=>'R'),
					array('width' => "5%", 'data' => "Ad", 'border' => 'LRTB', 'fill' => 1, 'align'=>'R'),
					array('width' => "5%", 'data' => "Ch", 'border' => 'LRTB', 'fill' => 1, 'align'=>'R')
				));

				foreach($result['resItems'] as $item) {
					$pdfRowArray = array();

					array_push($pdfRowArray,array('width' => "10%", 'data' => t_decodeHTML($item["date_arrive"]), 'border' => "LRTB", 'align' => "L"));

					if($dayActivity != "true" ) {
						array_push($pdfRowArray,array('width' => "10%", 'data' => t_decodeHTML($item["date_depart"]), 'border' => "LRTB", 'align' => "L"));
					}

					array_push($pdfRowArray,array('width' => "30%", 'data' => t_decodeHTML($item["pr_name_last"]), 'border'=> "LRTB"));
					array_push($pdfRowArray,array('width' => "30%", 'data' => t_decodeHTML($item["ac_accomm_desc"]), 'border' => "LRTB"));

					if ( $dayActivity != "true" ) {
						array_push($pdfRowArray,array('width' => "5%", 'data' => t_decodeHTML($item["noNights"]), 'border' => "LRTB", 'align' => "R"));
					}

					array_push($pdfRowArray,array('width' => "5%", 'data' => t_decodeHTML($item["rv_item_accomm_count"]), 'border' => "LRTB", 'align' => "R"));
					array_push($pdfRowArray,array('width' => "5%", 'data' => t_decodeHTML($item["rv_item_adult_count"]), 'border' => "LRTB", 'align' => "R"));
					array_push($pdfRowArray,array('width' => "5%", 'data' => t_decodeHTML($item["rv_item_child_count"]), 'border' => "LRTB", 'align' => "R"));

					$pdf->Row($pdfRowArray);
				}
			}
			$pdf->Ln(4);
		}

		if($docType == DOC_RESERVATION) {
			$accommWidth = 100;
			if($dayActivity == "true") {
				$accommWidth -= 11.5;
				$accommLabel = "Activity";
				$accommArriveLabel = "Date";
				$accommPropertyLabel = "";
				$accommAccommLabel = "";
				$accommRoomLabel = "Units";
				$accommRoomWidth = "5%";
			} else {
				$accommLabel = "Accommodation";
				$accommArriveLabel = "Arrive";
				$accommPropertyLabel = "Property";
				$accommAccommLabel = "Accommodation";
				$accommRoomLabel = "Rms";
				$accommRoomWidth = "3.5%";
			}
			if($hideFinancials == "true") { $accommWidth -= 36; }
			$accommWidth = $accommWidth . "%";
			
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>$accommWidth, 'data'=>$accommLabel, 'border'=>'LRTB', 'fill'=>1)
			));
			
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$headerArray = array(
				array('width'=>"9.5%", 'data'=>$accommArriveLabel, 'border'=>'LRTB', 'fill'=>1)
			);
			if($dayActivity != "true") {
				array_push($headerArray,
					array('width'=>"9.5%", 'data'=>"Depart", 'border'=>'LRTB', 'fill'=>1)
				);
			}
			array_push($headerArray,
				array('width'=>"15%", 'data'=>$accommPropertyLabel, 'border'=>'LRTB', 'fill'=>1),
				array('width'=>"12%", 'data'=>$accommAccommLabel, 'border'=>'LRTB', 'fill'=>1)
			);
			$chargeLabel = "Charge";
			if($dayActivity != "true") {
				array_push($headerArray,
					array('width'=>"3.5%", 'data'=>"Ngt", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R')
				);
				$chargeLabel = "Charge Per Night";
			}
			array_push($headerArray,
				array('width'=>$accommRoomWidth, 'data'=>$accommRoomLabel, 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
				array('width'=>"3.5%", 'data'=>"Ad", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
				array('width'=>"3.5%", 'data'=>"Ch", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
				array('width'=>"6%", 'data'=>"Grp", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R')
			);
			
			if($hideFinancials != "true") {
				array_push($headerArray,
					array('width'=>"24%", 'data'=>$chargeLabel, 'border'=>'LRTB', 'fill'=>1, 'align'=>'C'),
					array('width'=>"10%", 'data'=>"Due to Supplier", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R')
				);
			}
			$pdf->Row($headerArray);

			$headerArray = array(
				array('width'=>"9.5%", 'data'=>"", 'border'=>'LRB', 'fill'=>1)
			);
			if($dayActivity != "true") {
				array_push($headerArray,
					array('width'=>"9.5%", 'data'=>"", 'border'=>'LRB', 'fill'=>1)
				);
			}
			array_push($headerArray,
				array('width'=>"15%", 'data'=>"", 'border'=>'LRB', 'fill'=>1),
				array('width'=>"12%", 'data'=>"", 'border'=>'LRB', 'fill'=>1)
			);
			$rmLabel = "Per Unit";
			if($dayActivity != "true") {
				array_push($headerArray,
					array('width'=>"3.5%", 'data'=>"", 'border'=>'LRB', 'fill'=>1)
				);
				$rmLabel = "Per Room";
			}
			array_push($headerArray,
				array('width'=>$accommRoomWidth, 'data'=>"", 'border'=>'LRB', 'fill'=>1),
				array('width'=>"3.5%", 'data'=>"", 'border'=>'LRB', 'fill'=>1),
				array('width'=>"3.5%", 'data'=>"", 'border'=>'LRB', 'fill'=>1),
				array('width'=>"6%", 'data'=>"", 'border'=>'LRB', 'fill'=>1)
			);
			if($hideFinancials != "true") {
				array_push($headerArray,
					array('width'=>"8%", 'data'=>$rmLabel, 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"8%", 'data'=>"Per Adlt", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"8%", 'data'=>"Per Chld", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"10%", 'data'=>"", 'border'=>'LRB', 'fill'=>1)
				);
			}
			$pdf->Row($headerArray);
			$multiGroups = false;
			$resItemCount = 1;
			foreach ( $result['resItems'] as $item ) {
		
				if (count($item['add_rate_groups']) > 0){
					$bottomBorder = "LR";
				} else {
					$bottomBorder = "LRB";
				}
		
				$pdfRowArray = array();
				array_push($pdfRowArray,array('width'=>"9.5%", 'data'=>t_decodeHTML($item["date_arrive"]), 'border'=>"$bottomBorder", 'align'=>"C"));
				if($dayActivity != "true") {
					array_push($pdfRowArray,array('width'=>"9.5%", 'data'=>t_decodeHTML($item["date_depart"]), 'border'=>"$bottomBorder", 'align'=>"C"));
				}
				array_push($pdfRowArray,
					array('width'=>"15%", 'data'=>t_decodeHTML($item["pr_name_last"]), 'border'=>"$bottomBorder"),
					array('width'=>"12%", 'data'=>t_decodeHTML($item["ac_accomm_desc"]), 'border'=>"$bottomBorder")
				);
				if($dayActivity != "true") {
					array_push($pdfRowArray,array('width' => "3.5%", 'data' => t_decodeHTML($item["noNights"]), 'border' => "$bottomBorder", 'align' => "R"));
				}				
				array_push($pdfRowArray,
					array('width'=>$accommRoomWidth, 'data'=>t_decodeHTML($item["rv_item_accomm_count"]), 'border'=>"$bottomBorder", 'align'=>"R"),
					array('width'=>"3.5%", 'data'=>t_decodeHTML($item["sysCodeAdultCount"]), 'border'=>"$bottomBorder", 'align'=>"R"),
					array('width'=>"3.5%", 'data'=>t_decodeHTML($item["sysCodeChildCount"]), 'border'=>"$bottomBorder", 'align'=>"R"),
					array('width'=>"6%", 'data'=>t_decodeHTML("Ad/Ch"), 'border'=>"$bottomBorder", 'align'=>"R")
				);
				if($hideFinancials != "true") {
					array_push($pdfRowArray,
						array('width'=>"8%", 'data'=>t_decodeHTML($item["roomTotal2"]), 'border'=>"$bottomBorder", 'align'=>"R"),
						array('width'=>"8%", 'data'=>t_decodeHTML($item["adultTotal2"]), 'border'=>"$bottomBorder", 'align'=>"R"),
						array('width'=>"8%", 'data'=>t_decodeHTML($item["childTotal2"]), 'border'=>"$bottomBorder", 'align'=>"R"),
						array('width'=>"10%", 'data'=>t_decodeHTML($item["compAmt"]) . " " . $item["rf_currency_symbol"], 'border'=>"$bottomBorder", 'align'=>"R")
					);
				}
				$pdf->Row($pdfRowArray);
				$resItemCount++;
				// If we need extra rows for additional rate groups, add them here
				foreach ($item['add_rate_groups'] as $addRateGroupItem){
					$pdfRowArray = array();
					
					array_push($pdfRowArray,array('width'=>"9.5%", 'data'=>t_decodeHTML(""), 'border'=>"LRB", 'align'=>"C"));
					if($dayActivity != "true") {
						array_push($pdfRowArray,array('width'=>"9.5%", 'data'=>t_decodeHTML(""), 'border'=>"LRB", 'align'=>"C"));
					}
					array_push($pdfRowArray,
						array('width'=>"15%", 'data'=>t_decodeHTML(""), 'border'=>"LRB"),
						array('width'=>"12%", 'data'=>t_decodeHTML(""), 'border'=>"LRB")
					);
					if($dayActivity != "true") {
						array_push($pdfRowArray,array('width' => "3.5%", 'data' => t_decodeHTML(""), 'border' => "LRB", 'align' => "R"));
					};				
					array_push($pdfRowArray,
						array('width'=>"3.5%", 'data'=>t_decodeHTML(""), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"3.5%", 'data'=>t_decodeHTML($addRateGroupItem["adultCount"]), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"3.5%", 'data'=>t_decodeHTML($addRateGroupItem["childCount"]), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"6%", 'data'=>t_decodeHTML($addRateGroupItem["groupAbbrv"]), 'border'=>"LRB", 'align'=>"R")
					);					
					if($hideFinancials != "true") {
			
						array_push($pdfRowArray,
							array('width'=>"8%", 'data'=>t_decodeHTML(""), 'border'=>"LRB", 'align'=>"R"),
							array('width'=>"8%", 'data'=>t_decodeHTML($addRateGroupItem["adultAmount"]), 'border'=>"LRB", 'align'=>"R"),
							array('width'=>"8%", 'data'=>t_decodeHTML($addRateGroupItem["childAmount"]), 'border'=>"LRB", 'align'=>"R"),
							array('width'=>"10%", 'data'=>t_decodeHTML(""), 'border'=>"LRB", 'align'=>"R")
						);
					}					
					$pdf->Row($pdfRowArray);
				}				
				
				
			}
		
			$pdf->Ln(4);

			if($toggleRateTypeSummary) {
				$accommWidth = 100;
				if($dayActivity == "true") { $accommWidth -= 13.5; }
				if($hideFinancials == "true") { $accommWidth -= 12; }
				if(!$toggleRateTypeSummaryNote) { $accommWidth -= 12; }
				$accommWidth = $accommWidth . "%";

				$pdf->SetFont('Arial', 'B', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>$accommWidth, 'data'=>"Rate Type Summary", 'border'=>'LRTB', 'fill'=>1)
				));
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$headerRow = array(
					array('width'=>"9.5%", 'data'=>"Arrive", 'border'=>'LRTB', 'fill'=>1)
				);
				if($dayActivity != "true") {
					array_push($headerRow,array('width'=>"9.5%", 'data'=>"Depart", 'border'=>'LRTB', 'fill'=>1));
				}
				array_push($headerRow,
					array('width'=>"17%", 'data'=>"Property", 'border'=>'LRTB', 'fill'=>1),
					array('width'=>"12%", 'data'=>"Accommodation", 'border'=>'LRTB', 'fill'=>1)
				);
				if($dayActivity != "true"){
					array_push($headerRow,array('width'=>"4%", 'data'=>"Ngt", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'));
				}
				array_push($headerRow,
					array('width'=>"4%", 'data'=>"Rm", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"4%", 'data'=>"Ad", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"4%", 'data'=>"Ch", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"12%", 'data'=>"Rate Type", 'border'=>'LRTB', 'fill'=>1, 'align'=>'L')
				);
				if($toggleRateTypeSummaryNote) {
					array_push($headerRow,array('width'=>"12%", 'data'=>"Rate note", 'border'=>'LRTB', 'fill'=>1, 'align'=>'L'));
				}
				if($hideFinancials != "true") {
					array_push($headerRow,array('width'=>"12%", 'data'=>"Due to Supplier", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'));
				}
				$pdf->Row($headerRow);
				foreach($result['resItems'] as $item ) {
					$pdfRowArray = array(
						array('width'=>"9.5%", 'data'=>t_decodeHTML($item["date_arrive"]), 'border'=>"LRB", 'align'=>"C")
					);					
					if ( $dayActivity != "true" ) {
						array_push($pdfRowArray,array('width'=>"9.5%", 'data'=>t_decodeHTML($item["date_depart"]), 'border'=>"LRB", 'align'=>"C"));
					}
					array_push($pdfRowArray,
						array('width'=>"17%", 'data'=>t_decodeHTML($item["pr_name_last"]), 'border'=>"LRB"),
						array('width'=>"12%", 'data'=>t_decodeHTML($item["ac_accomm_desc"]), 'border'=>"LRB")
					);
					if ( $dayActivity != "true" ) {
						array_push($pdfRowArray,array('width' => "4%", 'data' => t_decodeHTML($item["noNights"]), 'border' => "LRB", 'align' => "R"));
					}
					array_push($pdfRowArray,
						array('width'=>"4%", 'data'=>t_decodeHTML($item["rv_item_accomm_count"]), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"4%", 'data'=>t_decodeHTML($item["rv_item_adult_count"]), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"4%", 'data'=>t_decodeHTML($item["rv_item_child_count"]), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"12%", 'data'=>t_decodeHTML($item["rt_rate_type_desc"]), 'border'=>"LRB", 'align'=>"L")
					);
					if($toggleRateTypeSummaryNote) {
						array_push($pdfRowArray,array('width'=>"12%", 'data'=>t_decodeHTML($item["rt_rate_type_note"]), 'border'=>"LRB", 'align'=>"L"));
					}					
					if ( $hideFinancials != "true" ) {
						array_push($pdfRowArray,array('width'=>"12%", 'data'=>t_decodeHTML($item["compAmt"]) . " " . $item["rf_currency_symbol"], 'border'=>"LRB", 'align'=>"R"));
					}			
					$pdf->Row($pdfRowArray);
				}		
			}

			$pdf->Ln(4);

			$descWidth = 24;
			if($showSupplier != "true") {
				$descWidth += 10;
			}
			if($showReference != "true") {
				$descWidth += 10;
			}

			if (sizeof($result['resAccomExtras']) > 0 && $docType == DOC_RESERVATION) {
				$accomWidth = "100%";

				if($hideFinancials == "true"){
					$accomWidth = "87%";
				}
				$pdf->SetFont('Arial', 'B', $pdfFontSize);
				$pdf->Row(array(
					array('data'=>"Accommodation - Extras", 'width'=>$accomWidth, 'border'=>"LRTB", 'fill'=>1)
				));
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$descAccom = 29;
				
				if($showSupplier != "true") {
					$descAccom += 11.5;
				}

				if($showReference != "true") {
					$descAccom += 11.5;
				}
				
				$headRow = array(
					array('width'=>"9.5%", 'data'=>"Arrive", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"9.5%", 'data'=>"Depart", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>$descAccom."%", 'data'=>"Description", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"4%", 'data'=>"Ngt", 'border'=>"LRTB", 'fill'=>1, 'align'=>'R'),
					array('width'=>"4%", 'data'=>"Rm", 'border'=>"LRTB", 'fill'=>1, 'align'=>'R'),
					array('width'=>"4%", 'data'=>"Ad", 'border'=>"LRTB", 'fill'=>1, 'align'=>'R'),
					array('width'=>"4%", 'data'=>"Ch", 'border'=>"LRTB", 'fill'=>1, 'align'=>'R'),
				);

				if($showSupplier == "true") {
					array_push($headRow,array('width'=>"11.5%", 'data'=>"Service By", 'border'=>"LRTB", 'fill'=>1));	
				}

				if($showReference == "true") {
					array_push($headRow,array('width'=>"11.5%", 'data'=>"Reference", 'border'=>"LRTB", 'fill'=>1));
				}
               
				$pdf->Row($headRow,0);

				if($hideFinancials != "true") {
					$pdf->Row(array(
						array('width'=>"13%", 'data'=>"Due to Supplier", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
					));
				} else {
					$pdf->Row(array(
						array('width'=>"13%", 'data'=>"", 'border'=>"")
					));
				}
				foreach($result['resAccomExtras'] as $item) {
					if($item['rv_extra_supplier_conf_yn']) {
						$item['supplier_name']= "";
					}
					
					if($item['rv_extra_date_depart'] != "" && $item['rv_extra_date_depart'] != "0000-00-00") {
						$item['rv_extra_date_depart'] = chng_date($item['rv_extra_date_depart'], "-");
						$item['rv_extra_date_serv'] = chng_date($item['rv_extra_date_serv'], "-");
					} else {
						$item['rv_extra_date_depart'] = "";
						$item['rv_extra_date_serv'] =  "";
					}
					if($item['pr_name_last'] != "" && $item['pr_name_last'] != "&nbsp;") {
						$item['ac_ext_desc'] = $item['ac_ext_desc']." (".$item['pr_name_last'].")";
					}
														
					$accomExtraRow = array(
						array('width'=>"9.5%", 'data'=>$item['rv_extra_date_serv'], 'border'=>"LRTB"),
						array('width'=>"9.5%", 'data'=>$item['rv_extra_date_depart'], 'border'=>"LRTB"),
						array('width'=>$descAccom."%", 'data'=>$item['ac_ext_desc'], 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>$item['rv_extra_nights'], 'border'=>"LRTB", 'align'=>'R'),
						array('width'=>"4%", 'data'=>$item['rv_extra_units'], 'border'=>"LRTB", 'align'=>'R'),
						array('width'=>"4%", 'data'=>$item['rv_extra_adult_count'], 'border'=>"LRTB", 'align'=>'R'),
						array('width'=>"4%", 'data'=>$item['rv_extra_child_count'], 'border'=>"LRTB", 'align'=>'R')
					);
                   
					if($showSupplier == "true") {
						array_push($accomExtraRow,array('width'=>"11.5%", 'data'=>$item['supplier_name'], 'border'=>"LRTB"));
					} 

					if($showReference == "true") {
						 array_push($accomExtraRow,array('width'=>"11.5%", 'data'=>$item['rv_extra_ref'], 'border'=>"LRTB"));
					} 

					if($hideFinancials != "true"){
						array_push($accomExtraRow,array('width'=>"13%", 'data'=>$item['total']." ".$item['rf_currency_symbol'], 'border'=>"LRTB", 'align'=>"R"));
					} else {
						array_push($accomExtraRow,array('width'=>"12%", 'data'=>"", 'border'=>""));
					}
					$pdf->Row($accomExtraRow);
				}
				$pdf->Ln(4);
			}
			
			if(sizeof($result['resExtras']) > 0) {
				$extraWidth = "100%";
				if ( $hideFinancials == "true" ) {
					$extraWidth = "87%";
				}				
				$pdf->SetFont('Arial', 'B', $pdfFontSize);
				$pdf->Row(array(array('data'=>"Extras", 'width'=>$extraWidth, 'border'=>"LRTB", 'fill'=>1)));
				$pdf->SetFont('Arial', '', $pdfFontSize);
                  
				$headRow = array(
					array('width'=>"10%", 'data'=>"Service Date", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"12%", 'data'=>"Property", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"10%", 'data'=>"Category", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>$descWidth."%", 'data'=>"Description", 'border'=>"LRTB", 'fill'=>1)
				);			
				
				if($showSupplier == "true") {
					array_push($headRow,array('width'=>"10%", 'data'=>"Service By", 'border'=>"LRTB", 'fill'=>1));		
				} 
				
				if($showReference == "true") {
					array_push($headRow,array('width'=>"10%", 'data'=>"Reference", 'border'=>"LRTB", 'fill'=>1));
				} 
				
				array_push($headRow,array('width'=>"6%", 'data'=>"Room", 'border'=>"LRTB", 'fill'=>1));
				array_push($headRow,array('width'=>"5%", 'data'=>"Units", 'border'=>"LRTB", 'fill'=>1));
				
				$pdf->Row($headRow,0);
				
				if($hideFinancials != "true") {
					$pdf->Row(array(
						array('width'=>"13%", 'data'=>"Due to Supplier", 'border'=>"LRTB", 'fill'=>1)
					));
				} else {
					$pdf->Row(array(
						array('width'=>"13%", 'data'=>"", 'border'=>"")
					));
				}
				
				// Sort extra by service date
				$col = array_column( $result['resExtras'], "rv_extra_date_serv" );
				array_multisort( $col, SORT_ASC, $result['resExtras'] );

				foreach($result['resExtras'] as $item) {
					$extraRow = array(
						array('width'=>"10%", 'data'=>$item['date_service'], 'border'=>"LRTB"),
						array('width'=>"12%", 'data'=>$item['pr_name_last'], 'border'=>"LRTB"),
						array('width'=>"10%", 'data'=>$item['ac_extra_cat_desc'], 'border'=>"LRTB"),
						array('width'=>$descWidth."%", 'data'=>$item['ac_ext_desc'], 'border'=>"LRTB")
					);
                    
					if($showSupplier == "true") {
						if(empty($item['supplier_name'])) {
							$item['supplier_name'] = " ";
						}
						array_push($extraRow,array('width'=>"10%", 'data'=>$item['supplier_name'], 'border'=>"LRTB"));
					} 
					
					if($showReference == "true") {
						if(empty($item['rv_extra_ref'])) {
							$item['rv_extra_ref'] = " ";
						}
						array_push($extraRow,array('width'=>"10%", 'data'=>$item['rv_extra_ref'], 'border'=>"LRTB"));
					} 
					array_push($extraRow,array('width'=>"6%", 'data'=>$item['roomDetails'], 'border'=>"LRTB", 'align'=>"R"));
					array_push($extraRow,array('width'=>"5%", 'data'=>$item['rv_extra_units'], 'border'=>"LRTB", 'align'=>"C"));

					if($hideFinancials != "true") {
						array_push($extraRow,array('width'=>"13%", 'data'=>$item['total']." ".$item['rf_currency_symbol'], 'border'=>"LRTB", 'align'=>"R"));
					} else {
						array_push($extraRow,array('width'=>"13%", 'data'=>"", 'border'=>""));
					}
					$pdf->Row($extraRow);
				}
				$pdf->Ln(4);
			}
             
			$descWidth -=14; 

			if (sizeof($result['resTravel']) > 0) {
				$travelWidth = "100%";
				if($hideFinancials == "true"){
					$travelWidth = "87%";
				}
				$pdf->SetFont('Arial', 'B', $pdfFontSize);
				$pdf->Row(array(
					array('data'=>"Travel", 'width'=>$travelWidth, 'border'=>"LRTB", 'fill'=>1)
				));
				$pdf->SetFont('Arial', '', $pdfFontSize);
                
				$headRow = array(
					array('width'=>"10%", 'data'=>"Service Date", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"12%", 'data'=>"Property", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"10%", 'data'=>"Category", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>$descWidth."%", 'data'=>"Description", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"7%", 'data'=>"ETD", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"7%", 'data'=>"ETA", 'border'=>"LRTB", 'fill'=>1)
				);

				if($showSupplier == "true") {
					array_push($headRow,array('width'=>"10%", 'data'=>"Service By", 'border'=>"LRTB", 'fill'=>1));		
				} 

				if($showReference == "true") {
					array_push($headRow,array('width'=>"10%", 'data'=>"Reference", 'border'=>"LRTB", 'fill'=>1));
				} 
               
				array_push($headRow,array('width'=>"6%", 'data'=>"Room", 'border'=>"LRTB", 'fill'=>1));
				array_push($headRow,array('width'=>"5%", 'data'=>"Units", 'border'=>"LRTB", 'fill'=>1));

				$pdf->Row($headRow,0);

				if($hideFinancials != "true") {
					$pdf->Row(array(
						array('width'=>"13%", 'data'=>"Due to Supplier", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
					));
				} else {
					$pdf->Row(array(
						array('width'=>"13%", 'data'=>"", 'border'=>"")
					));
				}
				foreach($result['resTravel'] as $item) {
					if($item['rv_extra_supplier_conf_yn']) {
						$item['supplier_name']= "";
					} 
					if($item['rv_extra_travel_eta'] == '00:00:00') {
					  $item['rv_extra_travel_eta'] = "";
					} 
					if($item['rv_extra_travel_etd'] == '00:00:00') {
						$item['rv_extra_travel_etd'] = "";
					} 
					
					$travelRow = array(
						array('width'=>"10%", 'data'=>$item['date_service'], 'border'=>"LRTB"),
						array('width'=>"12%", 'data'=>$item['pr_name_last'], 'border'=>"LRTB"),
						array('width'=>"10%", 'data'=>$item['ac_extra_cat_desc'], 'border'=>"LRTB"),
						array('width'=>$descWidth."%", 'data'=>$item['ac_ext_desc'], 'border'=>"LRTB"),
						array('width'=>"7%", 'data'=>$item['rv_extra_travel_etd'], 'border'=>"LRTB"),
						array('width'=>"7%", 'data'=>$item['rv_extra_travel_eta'], 'border'=>"LRTB")
					);
                   
					if($showSupplier == "true") {
						array_push($travelRow,array('width'=>"10%", 'data'=>$item['supplier_name'], 'border'=>"LRTB"));
					} 

					if($showReference == "true") {
						 array_push($travelRow,array('width'=>"10%", 'data'=>$item['rv_extra_ref'], 'border'=>"LRTB"));
					} 

					array_push($travelRow,array('width'=>"6%", 'data'=>$item['roomDetails'], 'border'=>"LRTB", 'align'=>"R"));
					array_push($travelRow,array('width'=>"5%", 'data'=>$item['rv_extra_units'], 'border'=>"LRTB", 'align'=>"C"));
                 
					if($hideFinancials != "true"){
						array_push($travelRow,array('width'=>"13%", 'data'=>$item['total']." ".$item['rf_currency_symbol'], 'border'=>"LRTB", 'align'=>"R"));
					} else {
						array_push($travelRow,array('width'=>"13%", 'data'=>"", 'border'=>""));
					}
					$pdf->Row($travelRow);
				}
				$pdf->Ln(4);
			}
		} elseif($docType == DOC_FOLIO) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			if($toggleTax) {
				if(!$showConsolidatedItems) {
					if($showServiceDate) {
						$pdf->Row(array(
							array('width' => "10%", 'data' => "Service Date", 'border' => 'LRTB', 'fill' => 1),
							array('width' => "34%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
							array('width' => "14%", 'data' => "Tax Rate", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Excl Tax", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Tax Included", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Due to Supplier", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
						));
					} else {
						$pdf->Row(array(
							array('width' => "44%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
							array('width' => "14%", 'data' => "Tax Rate", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Excl Tax", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Tax Included", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Due to Supplier", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
						));
					}
				} else {
					if($showServiceDate) {
						$pdf->Row(array(
							array('width' => "10%", 'data' => "Service Date", 'border' => 'LRTB', 'fill' => 1),
							array('width' => "48%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
							array('width' => "14%", 'data' => "Excl Tax", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Tax Included", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Due to Supplier", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
						));
					} else {
						$pdf->Row(array(
							array('width' => "58%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
							array('width' => "14%", 'data' => "Excl Tax", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Tax Included", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
							array('width' => "14%", 'data' => "Due to Supplier", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
						));
					}
				}
			} else {
				if($showServiceDate) {
					$pdf->Row(array(
						array('width' => "10%", 'data' => "Service Date", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "76%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "Due to Supplier", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
					));
				} else {
					$pdf->Row(array(
						array('width' => "86%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "Due to Supplier", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
					));
				}
			}

			if(!$showConsolidatedItems) {
				if($toggleTax) {			
					$exclTotal = 0;
					$taxTotal = 0;
					$amountTotal = 0;
					foreach($result['folioItems'] as $item) {
						$exclTotal += $item['fn_folio_amount_excl'];
						$taxTotal += $item['fn_folio_amount_tax'];
						$amountTotal += $item['fn_folio_amount'];
						$item['fn_folio_amount_excl'] = round($item['fn_folio_amount_excl'],2);
						fixAmtDisplay($item['fn_folio_amount_excl'],2);
						$item['fn_folio_amount_tax'] = round($item['fn_folio_amount_tax'],2);
						fixAmtDisplay($item['fn_folio_amount_tax'],2);
						if($showServiceDate) {
							$item['amt_date'] = chng_date($item['amt_date'],"-");
							$pdf->Row(array(
								array('width' => "10%", 'data' => t_decodeHTML($item['amt_date']), 'border' => "LRTB"),
								array('width' => "34%", 'data' => t_decodeHTML($item['fn_folio_desc']), 'border' => "LRTB"),
								array('width' => "14%", 'data' => t_decodeHTML($item['taxDesc']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount_excl']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount_tax']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount']." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
							));
						} else {
							$pdf->Row(array(
								array('width' => "44%", 'data' => t_decodeHTML($item['fn_folio_desc']), 'border' => "LRTB"),
								array('width' => "14%", 'data' => t_decodeHTML($item['taxDesc']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount_excl']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount_tax']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount']." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
							));
						}
					}
					fixAmtDisplay($exclTotal,2);
					fixAmtDisplay($taxTotal,2);
					fixAmtDisplay($amountTotal,2);
					$pdf->Row(array(
						array('width' => "58%", 'data' => "Total", 'border' => "LRTB", 'align' => "R", 'fill' => "1"),
						array('width' => "14%", 'data' => t_decodeHTML($exclTotal), 'border' => "LRTB", 'align' => "R"),
						array('width' => "14%", 'data' => t_decodeHTML($taxTotal), 'border' => "LRTB", 'align' => "R"),
						array('width' => "14%", 'data' => t_decodeHTML($amountTotal." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
					));
				} else {
					$exclTotal = 0;
					$taxTotal = 0;
					$amountTotal = 0;
					foreach($result['folioNoTaxItems'] as $item) {
						$exclTotal += $item['fn_folio_amount_excl'];
						$taxTotal += isset($item['fn_folio_amount_tax'])?$item['fn_folio_amount_tax']:0;
						$amountTotal += $item['fn_folio_amount'];
						if($showServiceDate) {
							$item['amt_date'] = chng_date($item['amt_date'],"-");
							$pdf->Row(array(
								array('width' => "10%", 'data' => t_decodeHTML($item['amt_date']), 'border' => "LRTB"),
								array('width' => "76%", 'data' => t_decodeHTML($item['fn_folio_desc']), 'border' => "LRTB"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount']." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
							));
						} else {
							$pdf->Row(array(
								array('width' => "86%", 'data' => t_decodeHTML($item['fn_folio_desc']), 'border' => "LRTB"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount']." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
							));
						}
					}
					fixAmtDisplay($exclTotal,2);
					fixAmtDisplay($taxTotal,2);
					fixAmtDisplay($amountTotal,2);
					$pdf->Row(array(
						array('width' => "86%", 'data' => "Total", 'border' => "LRTB", 'align' => "R", 'fill' => "1"),
						array('width' => "14%", 'data' => t_decodeHTML($amountTotal." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
					));
				}
			}

			if($showConsolidatedItems) {
				$exclTotal = 0;
				$taxTotal = 0;
				$amountTotal = 0;
				foreach($result['folioConsolidatedItems'] as $item) {
					$item['fn_folio_amount_excl'] = round($item['fn_folio_amount_excl'],2);
					fixAmtDisplay($item['fn_folio_amount_excl'],2);
					$item['fn_folio_amount_tax'] = round($item['fn_folio_amount_tax'],2);
					fixAmtDisplay($item['fn_folio_amount_tax'],2);								
					$exclTotal += $item['fn_folio_amount_excl'];
					$taxTotal += $item['fn_folio_amount_tax'];
					$amountTotal += $item['fn_folio_amount'];					
					if($toggleTax) {
						if($showServiceDate) {
							$item['amt_date'] = chng_date($item['amt_date'],"-");
							$pdf->Row(array(
								array('width' => "10%", 'data' => t_decodeHTML($item['amt_date']), 'border' => "LRTB"),
								array('width' => "48%", 'data' => t_decodeHTML($item['fn_folio_desc']), 'border' => "LRTB"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount_excl']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount_tax']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount']." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
							));
						} else {
							$pdf->Row(array(
								array('width' => "58%", 'data' => t_decodeHTML($item['fn_folio_desc']), 'border' => "LRTB"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount_excl']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount_tax']), 'border' => "LRTB", 'align' => "R"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount']." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
							));
						}
					} else {
						if($showServiceDate) {
							$item['amt_date'] = chng_date($item['amt_date'],"-");
							$pdf->Row(array(
								array('width' => "10%", 'data' => t_decodeHTML($item['amt_date']), 'border' => "LRTB"),
								array('width' => "76%", 'data' => t_decodeHTML($item['fn_folio_desc']), 'border' => "LRTB"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount']." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
							));
						} else {
							$pdf->Row(array(
								array('width' => "86%", 'data' => t_decodeHTML($item['fn_folio_desc']), 'border' => "LRTB"),
								array('width' => "14%", 'data' => t_decodeHTML($item['fn_folio_amount']." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
							));
						}
					}
				}
				fixAmtDisplay($exclTotal,2);
				fixAmtDisplay($taxTotal,2);
				fixAmtDisplay($amountTotal,2);				
				if($toggleTax) {
					$pdf->Row(array(
						array('width' => "58%", 'data' => "Total", 'border' => "LRTB", 'align' => "R", 'fill' => "1"),
						array('width' => "14%", 'data' => t_decodeHTML($exclTotal), 'border' => "LRTB", 'align' => "R"),
						array('width' => "14%", 'data' => t_decodeHTML($taxTotal), 'border' => "LRTB", 'align' => "R"),
						array('width' => "14%", 'data' => t_decodeHTML($amountTotal." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
					));
				} else {
					$pdf->Row(array(
						array('width' => "86%", 'data' => "Total", 'border' => "LRTB", 'align' => "R", 'fill' => "1"),
						array('width' => "14%", 'data' => t_decodeHTML($amountTotal." ".$result['folioCurrency']), 'border' => "LRTB", 'align'=>"R")
					));
				}
			}
			$pdf->Ln(4);
			
			if($toggleRateTypeSummary) {
				$accommWidth = 100;
				if($dayActivity == "true") { $accommWidth -= 13.5; }
				if($hideFinancials == "true") { $accommWidth -= 12; }
				if(!$toggleRateTypeSummaryNote) { $accommWidth -= 12; }
				$accommWidth = $accommWidth . "%";

				$pdf->SetFont('Arial', 'B', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>$accommWidth, 'data'=>"Rate Type Summary", 'border'=>'LRTB', 'fill'=>1)
				));
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$headerRow = array(
					array('width'=>"9.5%", 'data'=>"Arrive", 'border'=>'LRTB', 'fill'=>1)
				);
				if($dayActivity != "true") {
					array_push($headerRow,array('width'=>"9.5%", 'data'=>"Depart", 'border'=>'LRTB', 'fill'=>1));
				}
				array_push($headerRow,
					array('width'=>"17%", 'data'=>"Property", 'border'=>'LRTB', 'fill'=>1),
					array('width'=>"12%", 'data'=>"Accommodation", 'border'=>'LRTB', 'fill'=>1)
				);
				if($dayActivity != "true"){
					array_push($headerRow,array('width'=>"4%", 'data'=>"Ngt", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'));
				}
				array_push($headerRow,
					array('width'=>"4%", 'data'=>"Rm", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"4%", 'data'=>"Ad", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"4%", 'data'=>"Ch", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'),
					array('width'=>"12%", 'data'=>"Rate Type", 'border'=>'LRTB', 'fill'=>1, 'align'=>'L')
				);
				if($toggleRateTypeSummaryNote) {
					array_push($headerRow,array('width'=>"12%", 'data'=>"Rate note", 'border'=>'LRTB', 'fill'=>1, 'align'=>'L'));
				}
				if($hideFinancials != "true") {
					array_push($headerRow,array('width'=>"12%", 'data'=>"Due to Supplier", 'border'=>'LRTB', 'fill'=>1, 'align'=>'R'));
				}
				$pdf->Row($headerRow);
				foreach($result['resItems'] as $item ) {
					$pdfRowArray = array(
						array('width'=>"9.5%", 'data'=>t_decodeHTML($item["date_arrive"]), 'border'=>"LRB", 'align'=>"C")
					);					
					if ( $dayActivity != "true" ) {
						array_push($pdfRowArray,array('width'=>"9.5%", 'data'=>t_decodeHTML($item["date_depart"]), 'border'=>"LRB", 'align'=>"C"));
					}
					array_push($pdfRowArray,
						array('width'=>"17%", 'data'=>t_decodeHTML($item["pr_name_last"]), 'border'=>"LRB"),
						array('width'=>"12%", 'data'=>t_decodeHTML($item["ac_accomm_desc"]), 'border'=>"LRB")
					);
					if ( $dayActivity != "true" ) {
						array_push($pdfRowArray,array('width' => "4%", 'data' => t_decodeHTML($item["noNights"]), 'border' => "LRB", 'align' => "R"));
					}
					array_push($pdfRowArray,
						array('width'=>"4%", 'data'=>t_decodeHTML($item["rv_item_accomm_count"]), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"4%", 'data'=>t_decodeHTML($item["rv_item_adult_count"]), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"4%", 'data'=>t_decodeHTML($item["rv_item_child_count"]), 'border'=>"LRB", 'align'=>"R"),
						array('width'=>"12%", 'data'=>t_decodeHTML($item["rt_rate_type_desc"]), 'border'=>"LRB", 'align'=>"L")
					);
					if($toggleRateTypeSummaryNote) {
						array_push($pdfRowArray,array('width'=>"12%", 'data'=>t_decodeHTML($item["rt_rate_type_note"]), 'border'=>"LRB", 'align'=>"L"));
					}					
					if ( $hideFinancials != "true" ) {
						array_push($pdfRowArray,array('width'=>"12%", 'data'=>t_decodeHTML($item["compAmt"]) . " " . $item["rf_currency_symbol"], 'border'=>"LRB", 'align'=>"R"));
					}			
					$pdf->Row($pdfRowArray);
				}		
			}
			$pdf->Ln(4);

			if($showTaxTable) {
				$pdf->Row(array(
					array('width'=>"100%", 'data'=>"Taxes", 'border'=>"LRTB", 'fill'=>1)
				));
				if($showTaxTableRate) {
					$pdf->Row(array(
						array('width' => "85%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "15%", 'data' => "Tax Included", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
					));
				} else {
					$pdf->Row(array(
						array('width' => "70%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "15%", 'data' => "Tax Rate", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
						array('width' => "15%", 'data' => "Tax Included", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
					));
				}

				$taxTotal = 0;
				foreach($result['folioTaxTable'] as $item) {
					$item['tax_amt'] = round($item['tax_amt'],2);
					fixAmtDisplay($item['tax_amt'],2);
					$taxTotal += $item['tax_amt'];

					if($showTaxTableRate) {
						$pdf->Row(array(
							array('width' => "85%", 'data' => $item['tax_desc'], 'border' => 'LRTB'),
							array('width' => "15%", 'data' => $item['tax_amt'], 'border' => 'LRTB', 'align'=>"R")
						));
					} else {
						$pdf->Row(array(
							array('width' => "70%", 'data' => $item['tax_desc'], 'border' => 'LRTB'),
							array('width' => "15%", 'data' => $item['tax_perc'], 'border' => 'LRTB', 'align'=>"R"),
							array('width' => "15%", 'data' => $item['tax_amt'], 'border' => 'LRTB', 'align'=>"R")
						));
					}	
				}
				if(!$showTaxTableTotal) {
					fixAmtDisplay($taxTotal,2);
					$pdf->Row(array(
						array('width' => "85%", 'data' => "Folio Total", 'border' => 'LRTB', 'fill'=>1, 'align'=>"L"),
						array('width' => "15%", 'data' => $amountTotal, 'border' => 'LRTB', 'align'=>"R")
					));
				}
				$pdf->Ln(4);
			}
		} elseif($docType == DOC_INVOICE) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			if($showServiceDate) {
				if($toggleTax) {
					$pdf->Row(array(
						array('width' => "10%", 'data' => "Service Date", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "34%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "Tax Rate", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
						array('width' => "14%", 'data' => "Excl Tax", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
						array('width' => "14%", 'data' => "Tax Included", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
						array('width' => "14%", 'data' => "Total", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
					));
				} else {
					$pdf->Row(array(
						array('width' => "10%", 'data' => "Service Date", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "76%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "Total", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
					));
				}
			} else {
				if($toggleTax) {
					$pdf->Row(array(
						array('width' => "44%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "Tax Rate", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
						array('width' => "14%", 'data' => "Excl Tax", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
						array('width' => "14%", 'data' => "Tax Included", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
						array('width' => "14%", 'data' => "Total", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
					));
				} else {
					$pdf->Row(array(
						array('width' => "86%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "Total", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R")
					));
				}
			}

			$exclTotal = 0;
			$taxTotal = 0;
			$amountTotal = 0;
			foreach($result['invoiceItems'] as $item) {
				$exclTotal += $item['fn_inv_item_amt_excl'];
				$taxTotal += $item['fn_inv_item_amt_tax'];
				$amountTotal += $item['fn_inv_item_amount'];

				$item['fn_inv_item_amt_excl'] = round($item['fn_inv_item_amt_excl'],2);
				fixAmtDisplay($item['fn_inv_item_amt_excl'],2);
				$item['fn_inv_item_amt_tax'] = round($item['fn_inv_item_amt_tax'],2);
				fixAmtDisplay($item['fn_inv_item_amt_tax'],2);

				if($showServiceDate) {
					$item['fn_inv_item_date'] = chng_date($item['fn_inv_item_date'],"-");
					if($toggleTax) {				
						$pdf->Row(array(
							array('width' => "10%", 'data' => t_decodeHTML($item['fn_inv_item_date']), 'border' => "LRTB", 'align' => "L"),
							array('width' => "34%", 'data' => t_decodeHTML($item['fn_inv_item_desc']), 'border' => "LRTB", 'align' => "L"),
							array('width' => "14%", 'data' => t_decodeHTML($item['taxDesc']), 'border' => "LRTB", 'align' => "R"),
							array('width' => "14%", 'data' => t_decodeHTML($item['fn_inv_item_amt_excl']), 'border' => "LRTB", 'align' => "R"),
							array('width' => "14%", 'data' => t_decodeHTML($item['fn_inv_item_amt_tax']), 'border' => "LRTB", 'align' => "R"),
							array('width' => "14%", 'data' => t_decodeHTML($item['fn_inv_item_amount']." ".$result['invoiceExchangeFromCurrency']), 'border' => "LRTB", 'align' => "R")
						));
					} else {
						$pdf->Row(array(
							array('width' => "10%", 'data' => t_decodeHTML($item['fn_inv_item_date']), 'border' => "LRTB", 'align' => "L"),
							array('width' => "76%", 'data' => t_decodeHTML($item['fn_inv_item_desc']), 'border' => "LRTB", 'align' => "L"),
							array('width' => "14%", 'data' => t_decodeHTML($item['fn_inv_item_amount']." ".$result['invoiceExchangeFromCurrency']), 'border' => "LRTB", 'align' => "R")
						));
					}
				} else {
					if($toggleTax) {				
						$pdf->Row(array(
							array('width' => "44%", 'data' => t_decodeHTML($item['fn_inv_item_desc']), 'border' => "LRTB", 'align' => "L"),
							array('width' => "14%", 'data' => t_decodeHTML($item['taxDesc']), 'border' => "LRTB", 'align' => "R"),
							array('width' => "14%", 'data' => t_decodeHTML($item['fn_inv_item_amt_excl']), 'border' => "LRTB", 'align' => "R"),
							array('width' => "14%", 'data' => t_decodeHTML($item['fn_inv_item_amt_tax']), 'border' => "LRTB", 'align' => "R"),
							array('width' => "14%", 'data' => t_decodeHTML($item['fn_inv_item_amount']." ".$result['invoiceExchangeFromCurrency']), 'border' => "LRTB", 'align' => "R")
						));
					} else {
						$pdf->Row(array(
							array('width' => "86%", 'data' => t_decodeHTML($item['fn_inv_item_desc']), 'border' => "LRTB", 'align' => "L"),
							array('width' => "14%", 'data' => t_decodeHTML($item['fn_inv_item_amount']." ".$result['invoiceExchangeFromCurrency']), 'border' => "LRTB", 'align' => "R")
						));
					}
				}
			}
			$exclTotal = round($exclTotal,2);
			fixAmtDisplay($exclTotal,2);
			$taxTotalRounded = round($taxTotal,2);
			fixAmtDisplay($taxTotalRounded,2);
			fixAmtDisplay($amountTotal,2);

			$convertTotal = $amountTotal*$result['invoiceExchangeRate'];
			$convertTax	= $taxTotal*$result['invoiceExchangeRate'];
			$convertExclTax = $convertTotal - $convertTax;
			fixAmtDisplay($convertTotal,2);
			fixAmtDisplay($convertExclTax,2);
			fixAmtDisplay($convertTax,2);

			if($toggleTax) {				
				$pdf->Row(array(
					array('width' => "44%", 'data' => "", 'align' => "R"),
					array('width' => "14%", 'data' => "Total", 'border' => "LRTB", 'align' => "R", 'fill' => "1"),
					array('width' => "14%", 'data' => t_decodeHTML($exclTotal), 'border' => "LRTB", 'align' => "R"),
					array('width' => "14%", 'data' => t_decodeHTML($taxTotalRounded), 'border' => "LRTB", 'align' => "R"),
					array('width' => "14%", 'data' => t_decodeHTML($amountTotal." ".$result['invoiceExchangeFromCurrency']), 'border' => "LRTB", 'align'=>"R")
				));
			} else {
				$pdf->Row(array(
					array('width' => "72%", 'data' => "", 'align' => "R"),
					array('width' => "14%", 'data' => "Total", 'border' => "LRTB", 'align' => "R", 'fill' => "1"),
					array('width' => "14%", 'data' => t_decodeHTML($amountTotal." ".$result['invoiceExchangeFromCurrency']), 'border' => "LRTB", 'align'=>"R")
				));
			}
			if($result['invoiceExchangeFromCurrency'] != $result['invoiceExchangeToCurrency']) {
				if($toggleTax) {				
					$pdf->Row(array(
						array('width' => "44%", 'data' => "Converted to $result[invoiceExchangeToCurrency] at $result[invoiceExchangeRate]", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "$convertExclTax", 'border' => 'LRTB', 'fill' => 1, 'align' => "R"),
						array('width' => "14%", 'data' => "$convertTax", 'border' => 'LRTB', 'fill' => 1, 'align' => "R"),
						array('width' => "14%", 'data' => "$convertTotal $result[invoiceExchangeToCurrency]", 'border' => 'LRTB', 'fill' => 1, 'align' => "R"),
					));
				} else {
					$pdf->Row(array(
						array('width' => "72%", 'data' => "Converted to $result[invoiceExchangeToCurrency] at $result[invoiceExchangeRate]", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "", 'border' => 'LRTB', 'fill' => 1),
						array('width' => "14%", 'data' => "$convertTotal $result[invoiceExchangeToCurrency]", 'border' => 'LRTB', 'fill' => 1, 'align' => "R"),
					));
				}
				$pdf->Ln(4);
			}
			$pdf->Ln(4);
			$pdf->Row(array(
				array('width' => "30%", 'data' =>"Total Amount Paid", 'border' => "LRTB", 'fill'=>1),
				array('width' =>"70%", 'data'=>t_decodeHTML($result['invoicePaid']." ".$result['invoiceExchangeFromCurrency']),'border'=>"LRTB",'align'=>"R")
			));
			$pdf->Ln(4);

			if($showTaxTable) {
				$pdf->Row(array(
					array('width'=>"100%", 'data'=>"Taxes", 'border'=>"LRTB", 'fill'=>1)
				));
				if($showTaxTableGL) {
					$taxCurrency = $result['invoiceExchangeToCurrency'];
				} else {
					$taxCurrency = $result['invoiceExchangeFromCurrency'];
				}
				if($showTaxTableRate) {
					$pdf->Row(array(
						array('width' => "85%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1, 'align'=>$showTaxTableAlign),
						array('width' => "15%", 'data' => "Tax Included ($taxCurrency)", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
					));
				} else {
					$pdf->Row(array(
						array('width' => "70%", 'data' => "Description", 'border' => 'LRTB', 'fill' => 1, 'align'=>$showTaxTableAlign),
						array('width' => "15%", 'data' => "Tax Rate", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
						array('width' => "15%", 'data' => "Tax Included ($taxCurrency)", 'border' => 'LRTB', 'fill' => 1, 'align'=>"R"),
					));
				}

				$taxTotal = 0;
				$taxESD = 0;
				foreach($result['invoiceTaxTable'] as $item) {
					if($showTaxTableGL) {
						$item['fn_invoice_item_tax_amt'] = round($item['fn_invoice_item_tax_amt'] * $item['fn_inv_exch_rate'],2);
					} else {
						$item['fn_invoice_item_tax_amt'] = round($item['fn_invoice_item_tax_amt'],2);
					}
					fixAmtDisplay($item['fn_invoice_item_tax_amt'],2);
					$taxTotal += $item['fn_invoice_item_tax_amt'];

					if($showTaxTableRate) {
						$pdf->Row(array(
							array('width' => "85%", 'data' => $item['fn_invoice_item_tax_desc'], 'border' => 'LRTB', 'align'=>$showTaxTableAlign),
							array('width' => "15%", 'data' => $item['fn_invoice_item_tax_amt'], 'border' => 'LRTB', 'align'=>"R")
						));
					} else {
						$pdf->Row(array(
							array('width' => "70%", 'data' => $item['fn_invoice_item_tax_desc'], 'border' => 'LRTB', 'align'=>$showTaxTableAlign),
							array('width' => "15%", 'data' => $item['fn_invoice_item_tax_perc'], 'border' => 'LRTB', 'align'=>"R"),
							array('width' => "15%", 'data' => $item['fn_invoice_item_tax_amt'], 'border' => 'LRTB', 'align'=>"R")
						));
					}
					$taxESD = $item['fn_invoice_item_tax_amt'];
	
				}
				if(!$showTaxTableTotal) {				
					if($showTaxTableGL) {
						$taxTotal = $convertTotal;
					} else {
						$taxTotal = $amountTotal;
					}
					if($showTaxTableRate) {
						$pdf->Row(array(
							array('width' => "85%", 'data' => "Invoice Total", 'border' => 'LRTB', 'fill'=>1, 'align'=>$showTaxTableAlign),
							array('width' => "15%", 'data' => $taxTotal, 'border' => 'LRTB', 'align'=>"R")
						));
					} else {
						$pdf->Row(array(
							array('width' => "70%", 'data' => "Invoice Total", 'border' => 'LRTB', 'fill'=>1, 'align'=>$showTaxTableAlign),
							array('width' => "15%", 'data' => "", 'border' => 'LRTB', 'fill'=>1),
							array('width' => "15%", 'data' => $taxTotal, 'border' => 'LRTB', 'align'=>"R")
						));
					}
				}
				$pdf->Ln(4);
			}
			
		}
		if($toggleCostSummary) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row(array(array('data'=>"Totals", 'border'=>"LRTB", 'fill'=>1)));
			$pdf->SetFont('Arial', '', $pdfFontSize);
			if($toggleGross) {
				$headerRow = array (
					array('width'=>"86%", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"14%", 'data'=>"Gross", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
				);
			} elseif($toggleCommission) {
				$headerRow =  array(
					array('width'=>"44%", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"14%", 'data'=>"Gross", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R"),
					array('width'=>"14%", 'data'=>commissionLabel(), 'border'=>"LRTB", 'fill'=>1, 'align'=>"R"),
					array('width'=>"14%", 'data'=>"Nett", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R"),
					array('width'=>"14%", 'data'=>"Due to Supplier", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
				);
			} else {
				$headerRow = array (
					array('width'=>"86%", 'border'=>"LRTB", 'fill'=>1),
					array('width'=>"14%", 'data'=>"Due to Supplier", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
				);
			}
			$pdf->Row($headerRow);
			if($toggleTotalItem) {
				if(isset($result['compTotals']['Accommodation'][0]) && $result['compTotals']['Accommodation'][0] != "") {
					if($toggleGross) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, stripslashes($consolidatedLabel), 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					} elseif ($toggleCommission) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.44, $pdf->FontSize+1, stripslashes($consolidatedLabel), 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_gross'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_comm'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_net'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					} else {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, stripslashes($consolidatedLabel), 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['acc_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					}
					$pdf->Ln(0, 1);
				}
				
				if(
					(isset($result['compTotals']['Extras'][0]) && $result['compTotals']['Extras'][0] != "")
					|| (isset($result['compTotals']['Accomm-Extras'][0]) && $result['compTotals']['Accomm-Extras'][0] != "")
				) {
					if($toggleGross) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Extras", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					} elseif($toggleCommission) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.44, $pdf->FontSize+1, "Extras", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_gross'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_comm'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_net'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					} else {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Extras", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['ext_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					}
					$pdf->Ln(0, 1);
				}
				if(isset($result['compTotals']['Travel'][0]) && $result['compTotals']['Travel'][0] != "") {
					if($toggleGross) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Travel", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					} elseif($toggleCommission) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.44, $pdf->FontSize+1, "Travel", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_gross'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_comm'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_net'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					} else {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Travel", 'LRTB', '', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['tra_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					}
					$pdf->Ln(0, 1);
				}
			}
			if($toggleGross) {
				$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Total", 'LRTB', '', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_gross']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
			} elseif ($toggleCommission) {
				$pdf->MultiCell($pdf->GetPageWidth() * 0.44, $pdf->FontSize+1, "Total", 'LRTB', '', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_gross'], 'LRTB', 'R', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_comm'], 'LRTB', 'R', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_net'], 'LRTB', 'R', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
			} else {
				$pdf->MultiCell($pdf->GetPageWidth() * 0.86, $pdf->FontSize+1, "Total", 'LRTB', '', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $result['total_invoice']. " " . $result['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
			}
			$pdf->Ln(0, 1);
			$pdf->Ln(4);
		}
		if($toggleCostComponent) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			if($toggleTax) {
				$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Cost Components", 'LRTB', 1, 'L', 1);
			} else {
				$pdf->Cell($pdf->GetPageWidth()*0.58, $pdf->FontSize+1, "Cost Components", 'LRTB', 1, 'L', 1);
			}
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, "Description", 'LRTB', '', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.30, $pdf->FontSize+1, "Component", 'LRTB', '', 1, 1);
			if($toggleTax) {
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, "Tax rate", 'LRTB', 'R', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, "Excluding tax", 'LRTB', 'R', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, "Tax included", 'LRTB', 'R', 1, 1);
			}
			$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, "Amount payable", 'LRTB', 'R', 1, 1);
			$pdf->Ln(0, 1);
			foreach($result['compTotals'] as $compCat => $compList) {
				$first = true;
				foreach($compList as $compItem) {
					if ($first && $compCat != "Totals") {
						$first = false;
						$compItem['cat'] = $compCat;
					} else {
						$compItem['cat'] = "";
					}
					if ($compItem['cat'] != "") {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $compItem['cat'], 'LRTB', '', 0, 1);
					} else {
						if($compCat == "Totals") {
							$brdr = "R";
						} else {
							$brdr = "LR";
						}
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, "", $brdr, 'R', 0, 1);
					}
					if($compItem['compDesc'] == "Totals") {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.30, $pdf->FontSize+1, $compItem['compDesc'], 'LRTB', '', 1, 1);
					} else {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.30, $pdf->FontSize+1, $compItem['compDesc'], 'LRTB', '', 0, 1);
					}
					if($toggleTax) {
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $compItem['taxRate'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $compItem['exclTax'], 'LRTB', 'R', 0, 1);
						$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $compItem['taxAmt'], 'LRTB', 'R', 0, 1);
					}
					$pdf->MultiCell($pdf->GetPageWidth() * 0.14, $pdf->FontSize+1, $compItem['payAmt']." ". $compItem['rf_currency_symbol'], 'LRTB', 'R', 0, 1);
					$pdf->Ln(0, 1);
				}
			}
			$pdf->Ln(4);
		}
		if ($togglePlan) {
			if(sizeof($result['resItems']) > 0) {
				$pdf->SetFont('Arial', 'B', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>"100%",'data'=>"Payment Plan")
				));
				$pdf->Ln(1);
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>"100%",'data'=>"Payments according to the following schedule should be made:")
				));
				$pdf->Ln(4);
				$pdf->Row(array(
					array('data'=>"Plan",'fill'=>1,'border'=>'LRTB')
				));
				if(!$showPayPlanInv) {
					$pdf->Row(array(
						array('width'=>"86%",'data'=>"Date Due",'fill'=>1,'border'=>'LRTB'),
						array('width'=>"14%",'data'=>"Amount",'fill'=>1,'border'=>'LRTB','align'=>"R")
					));
					foreach($result['payItems'] as $item) {
						$pdf->Row(array(
							array('width'=>"86%",'data'=>$item['pay_date'],'border'=>'LR'),
							array('width'=>"14%",'data'=>$item['rv_pay_plan_amount'] . " " . $item['rf_currency_symbol'],'border'=>'LR', 'align'=>"R")
						));
					}
				} else {
					$pdf->Row(array(
						array('width'=>"20%",'data'=>"Date Due",'fill'=>1,'border'=>'LRTB'),
						array('width'=>"66%",'data'=>"Invoicing Unit",'fill'=>1,'border'=>'LRTB'),
						array('width'=>"14%",'data'=>"Amount",'fill'=>1,'border'=>'LRTB','align'=>"R")
					));
					foreach($result['payInvItems'] as $item) {
						$pdf->Row(array(
							array('width'=>"20%",'data'=>$item['pay_date'],'border'=>'LR'),
							array('width'=>"66%",'data'=>$item['pr_name'],'border'=>'LR'),
							array('width'=>"14%",'data'=>$item['rv_pay_plan_amount'] . " " . $item['rf_currency_symbol'],'border'=>'LR', 'align'=>"R")
						));
					}
				}
				$pdf->Row(array(
					array('width'=>"100%",'data'=>"",'border'=>'T')
				));
				$pdf->Ln(4);
			}
		}
		if($togglePayReceipts) {
			if($toggleCancelPay) {
				$payedItems = $result['payedItems2'];
			} else {
				$payedItems = $result['payedItems'];
			}
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"100%",'data'=>"Receipts")
			));
			$pdf->Ln(1);
			if(sizeof($payedItems) != 0) {
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>"11%",'data'=>"Payment Date",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"13%",'data'=>"Payer",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"9%",'data'=>"Int #",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"8%",'data'=>"Ref",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"8%",'data'=>"Method",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"14%",'data'=>"Bank / Cash Point",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"6%",'data'=>"Curr",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"8%",'data'=>"Folio",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"9%",'data'=>"Invoice",'fill'=>1,'border'=>'LRTB'),
					array('width'=>"14%",'data'=>"Amount",'fill'=>1,'border'=>'LRTB','align'=>"R")
				));
				foreach($payedItems as $item) {
					$pdf->Row(array(
						array('width'=>"11%",'data'=>$item['pay_date'],'border'=>'LRTB'),
						array('width'=>"13%",'data'=>$item['pr_name_last'],'border'=>'LRTB'),
						array('width'=>"9%",'data'=>$item['rv_payment_ix'],'border'=>'LRTB'),
						array('width'=>"8%",'data'=>$item['rv_pmnt_ref'],'border'=>'LRTB'),
						array('width'=>"8%",'data'=>$item['rf_mthd_pmnt_desc'],'border'=>'LRTB'),
						array('width'=>"14%",'data'=>$item['rf_bank_acc_name'],'border'=>'LRTB'),
						array('width'=>"6%",'data'=>$item['rf_currency_symbol'],'border'=>'LRTB'),
						array('width'=>"8%",'data'=>$item['fn_folio_folio_num'],'border'=>'LRTB'),
						array('width'=>"9%",'data'=>$item['fn_invoice_ix'],'border'=>'LRTB'),
						array('width'=>"14%",'data'=>$item['rv_payment_item_amt'] . " " . $item['invCurrSym'],'border'=>'LRTB', 'align'=>"R")
					));
				}
			}
			if(!isset($result['currencyCheck']) || $result['currencyCheck'] <= 1) {
				$pdf->SetFont('Arial', '', $pdfFontSize);
				$pdf->Row(array(
					array('width'=>"58%",'data'=>"",'border'=>'TR', 'align'=>"R"),
					array('width'=>"28%",'data'=>"Total amount paid to date ",'border'=>'LRTB', 'fill'=>1),
					array('width'=>"14%",'data'=>$result['payedTotal'] . " " . $result['rf_currency_symbol'],'border'=>'LRTB', 'align'=>"R")
				));
				$pdf->Row(array(
					array('width'=>"58%",'data'=>"",'border'=>'R', 'align'=>"R"),
					array('width'=>"28%",'data'=>"Total amount STILL DUE ",'border'=>'LRTB', 'fill'=>1),
					array('width'=>"14%",'data'=>$result['payOutstanding'] . " " . $result['rf_currency_symbol'],'border'=>'LRTB', 'align'=>"R", 'style'=>"B")
				));
			}
			$pdf->Ln(4);
		}
		if($docType == DOC_INVOICE && sizeof($result['invoicePaymentList']) > 0) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"100%",'data'=>"Receipts")
			));
			$pdf->Ln(1);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"12%",'data'=>"Payment Date",'fill'=>1,'border'=>'LRTB'),
				array('width'=>"18%",'data'=>"Payer",'fill'=>1,'border'=>'LRTB'),
				array('width'=>"15%",'data'=>"Ref",'fill'=>1,'border'=>'LRTB'),
				array('width'=>"15%",'data'=>"Method",'fill'=>1,'border'=>'LRTB'),
				array('width'=>"25%",'data'=>"Bank / Cash Point",'fill'=>1,'border'=>'LRTB'),
				array('width'=>"15%",'data'=>"Amount",'fill'=>1,'border'=>'LRTB','align'=>"R")
			));
			foreach($result['invoicePaymentList'] as $item) {
				$pdf->Row(array(
					array('width'=>"12%",'data'=>$item['fn_inv_payment_date'],'border'=>'LRTB'),
					array('width'=>"18%",'data'=>$item['fn_inv_payment_payer'],'border'=>'LRTB'),
					array('width'=>"15%",'data'=>$item['fn_inv_payment_ref'],'border'=>'LRTB'),
					array('width'=>"15%",'data'=>$item['fn_inv_payment_method'],'border'=>'LRTB'),
					array('width'=>"25%",'data'=>$item['fn_inv_payment_bank'],'border'=>'LRTB'),
					array('width'=>"15%",'data'=>$item['fn_inv_payment_amt'] . " " . $item['fn_inv_payment_curr'],'border'=>'LRTB', 'align'=>"R")
				));
			}
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"45%",'data'=>"",'border'=>'TR', 'align'=>"R"),
				array('width'=>"40%",'data'=>"Total paid when invoiced",'border'=>'LRTB', 'fill'=>1),
				array('width'=>"15%",'data'=>$result['invoicePaymentTotal'] . " " . $result['rf_currency_symbol'],'border'=>'LRTB', 'align'=>"R")
			));
			$pdf->Row(array(
				array('width'=>"45%",'data'=>"",'border'=>'R', 'align'=>"R"),
				array('width'=>"40%",'data'=>"Total still outstanding when invoiced",'border'=>'LRTB', 'fill'=>1),
				array('width'=>"15%",'data'=>$result['invoicePaymentOutstanding'] . " " . $result['rf_currency_symbol'],'border'=>'LRTB', 'align'=>"R", 'style'=>"B")
			));
			$pdf->Ln(4);
		}

		if($togglePerPerson) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row([
				['width'=>"100%",'data'=>"Per Person Charges"]
			]);
			$pdf->Ln(1);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row([
				['width'=>"10%",'data'=>"Arrive",'fill'=>1,'border'=>'LRTB'],
				['width'=>"10%",'data'=>"Depart",'fill'=>1,'border'=>'LRTB'],
				['width'=>"28%",'data'=>"Property",'fill'=>1,'border'=>'LRTB'],
				['width'=>"28%",'data'=>"Accomm",'fill'=>1,'border'=>'LRTB'],
				['width'=>"6%",'data'=>"Nights",'fill'=>1,'border'=>'LRTB','align'=>"R"],
				['width'=>"6%",'data'=>"Rooms",'fill'=>1,'border'=>'LRTB','align'=>"R"],
				['width'=>"6%",'data'=>"Adult",'fill'=>1,'border'=>'LRTB','align'=>"R"],
				['width'=>"6%",'data'=>"Child",'fill'=>1,'border'=>'LRTB','align'=>"R"]
			]);
			foreach($result['perPersonItems'] as $perPersonItem) {
				$pdf->Row([
					['width'=>"10%",'data'=>$perPersonItem['date_arrive'],'border'=>'LR'],
					['width'=>"10%",'data'=>$perPersonItem['date_depart'],'border'=>'LR'],
					['width'=>"28%",'data'=>$perPersonItem['pr_name_last'],'border'=>'LR'],
					['width'=>"28%",'data'=>$perPersonItem['ac_accomm_desc'],'border'=>'LR'],
					['width'=>"6%",'data'=>$perPersonItem['nights'],'border'=>'LR','align'=>"R"],
					['width'=>"6%",'data'=>$perPersonItem['rv_item_accomm_count'],'border'=>'LR','align'=>"R"],
					['width'=>"6%",'data'=>$perPersonItem['rv_item_adult_count'],'border'=>'LR','align'=>"R"],
					['width'=>"6%",'data'=>$perPersonItem['rv_item_child_count'],'border'=>'LR','align'=>"R"]
				]);
				$pdf->Row([
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"28%",'data'=>"",'border'=>'LR'],
					['width'=>"28%",'data'=>"",'border'=>'LR'],
					['width'=>"6%",'data'=>"",'border'=>'LR'],
					['width'=>"6%",'data'=>"",'border'=>'LR'],
					['width'=>"6%",'data'=>"",'border'=>'LR'],
					['width'=>"6%",'data'=>"",'border'=>'LR']
				]);
				$pdf->Row([
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"48%",'data'=>"Rate Group",'fill'=>1,'border'=>'LRTB'],
					['width'=>"14%",'data'=>"Per Unit / Person",'fill'=>1,'border'=>'LRTB','align'=>"R"],
					['width'=>"6%",'data'=>"Qty",'fill'=>1,'border'=>'LRTB','align'=>"R"],
					['width'=>"12%",'data'=>"Total Per Unit",'fill'=>1,'border'=>'LRTB','align'=>"R"]
				]);
				foreach($perPersonItem['rate_groups'] as $rateGroup) {
					$pdf->Row([
						['width'=>"10%",'data'=>"",'border'=>'LR'],
						['width'=>"10%",'data'=>"",'border'=>'LR'],
						['width'=>"48%",'data'=>$rateGroup['name'],'border'=>'LR'],
						['width'=>"14%",'data'=>$rateGroup['per_person'],'border'=>'LR','align'=>"R"],
						['width'=>"6%",'data'=>$rateGroup['qty'],'border'=>'LR','align'=>"R"],
						['width'=>"12%",'data'=>$rateGroup['per_night'],'border'=>'LR','align'=>"R"]
					]);
				}
				$pdf->Row([
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"10%",'data'=>"",'border'=>'LR'],
					['width'=>"48%",'data'=>"Total Per Night",'border'=>'LRB'],
					['width'=>"14%",'data'=>"",'border'=>'LRB','align'=>"R"],
					['width'=>"6%",'data'=>"",'border'=>'LRB','align'=>"R"],
					['width'=>"12%",'data'=>$perPersonItem['total_per_night'],'border'=>'LRB','align'=>"R"]
				]);
				$pdf->Row([
					['width'=>"10%",'data'=>"",'border'=>'LRB'],
					['width'=>"10%",'data'=>"",'border'=>'LRB'],
					['width'=>"48%",'data'=>"",'border'=>'B'],
					['width'=>"14%",'data'=>"",'border'=>'B'],
					['width'=>"6%",'data'=>"",'border'=>'B'],
					['width'=>"12%",'data'=>"",'border'=>'BR']
				]);
			}
			if(empty($result['perPersonItems'])) {
				$pdf->Row([
					['data'=>"No per person charges",'align'=>"C",'style'=>"I"]
				]);
			}
			$pdf->Ln(4);
		}

		if($showSpecial) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Special", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);

			if (empty($specials)) { // No specials applied
				$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "No Special", '', 1, 'L');
			} else {
				foreach ($specials as $special) {
					$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, $special['sp_special_desc'], '', 1, 'L');
					if($showSpecialNote) {
						if(trim($special['sp_special_note']) != "") {
							$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, ' - '.$special['sp_special_note'], '', 1, 'L');
						}
					}
				}
			}

			$pdf->Ln(4);
		}
		if($toggleBankDetails) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Bank Details", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);

			if(sizeof($result['bankInfo'])>0) {
				foreach($result['bankInfo'] as $item) {
					$bankDet = str_replace("<br>","\n",$item['rf_bank_detail_1']);
					$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Acc Name: ".$item['rf_bank_acc_name'] . " (" . $item['rf_currency_name'] . ")", '', 1, 'L');
					$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Acc No: ".$item['rf_bank_acc_no'], '', 1, 'L');
					$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, "Detail: ".$item['rf_bank_name'] . " - " .$bankDet, '', 1, 'L');
					$pdf->Ln(4);
				}
			} else {
				$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "No Bank Details", '', 1, 'L', 0);
			}
			$pdf->Ln(4);
		}
		if($toggleFolio) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			if($toggleTax) {
				$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Folios", '', 1, 'L', 0);
			} else {
				$pdf->Cell($pdf->GetPageWidth()*0.7, $pdf->FontSize+1, "Folios", '', 1, 'L', 0);
			}
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);			
			foreach($busList as $busItem) {
				if(sizeof($busItem['folioList']) > 0) {
					if($toggleTax) {
						$pdf->Row(array(
							array('data'=>"$busItem[pr_name_last]", 'fill'=>1, 'border'=>"LRTB")
						));
					} else {
						$pdf->Row(array(
							array('width'=>"70%", 'data'=>"$busItem[pr_name_last]", 'fill'=>1, 'border'=>"LRTB")
						));
					}
					if($toggleTax) {
						$pdf->Row(array(
							array('width'=>"10%", 'data'=>"Folio",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"15%", 'data'=>"Details",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Summary",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"15%", 'data'=>"Description",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Tax Rate",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Excl Tax",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Tax",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Payable (incl tax)",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Amount Paid",'fill'=>1,'border'=>"LRTB")
						));
					} else {
						$pdf->Row(array(
							array('width'=>"10%", 'data'=>"Folio",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"15%", 'data'=>"Details",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Summary",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"15%", 'data'=>"Description",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Payable",'fill'=>1,'border'=>"LRTB"),
							array('width'=>"10%", 'data'=>"Amount Paid",'fill'=>1,'border'=>"LRTB")
						));
					}
					foreach($busItem['folioList'] as $folioItem) {
						$first = false;
						$second = false;
						$folioName = "";
						if(trim($folioItem['pr_name_last']) != "") {
							$folioName .= $folioItem['pr_name_last'];
						}
						if(trim($folioItem['pr_name_first']) != "") {
							if($folioName != "") {
								$folioName .= ", ";
							}
							$folioName .= $folioItem['pr_name_first'];
						}
						$firstAccomm = false;
						foreach($folioItem['accommList'] as $accommItem) {
							if($firstAccomm == false) {
								$summary = "Accomm";
								$firstAccomm = true;
							} else {
								$summary = "";
							}
							if($first == false) {
								$first = true;
								if($toggleTax) {
									$pdf->Row(array(
										array('width'=>"10%", 'data'=>$folioItem['fn_folio_folio_num'],'border'=>"LR"),
										array('width'=>"15%", 'data'=>$folioName,'border'=>"LR"),
										array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
										array('width'=>"15%", 'data'=>$accommItem['rt_component_desc'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_tax_perc'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_excl'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_tax'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_payable'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>"",'border'=>"LR")
									));
								} else {
									$pdf->Row(array(
										array('width'=>"10%", 'data'=>$folioItem['fn_folio_folio_num'],'border'=>"LR"),
										array('width'=>"15%", 'data'=>$folioName,'border'=>"LR"),
										array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
										array('width'=>"15%", 'data'=>$accommItem['rt_component_desc'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_payable'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>"",'border'=>"LR")
									));
								}
							} else {
								if($second == false) {
									if($toggleTax) {
										$pdf->Row(array(
											array('width'=>"10%", 'data'=>"",'border'=>"LR"),
											array('width'=>"15%", 'data'=>$folioItem['rf_currency_symbol'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
											array('width'=>"15%", 'data'=>$accommItem['rt_component_desc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_tax_perc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_excl'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_tax'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_payable'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>"",'border'=>"LR")
										));
									} else {
										$pdf->Row(array(
											array('width'=>"10%", 'data'=>"",'border'=>"LR"),
											array('width'=>"15%", 'data'=>$folioItem['rf_currency_symbol'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
											array('width'=>"15%", 'data'=>$accommItem['rt_component_desc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_payable'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>"",'border'=>"LR")
										));
									}
									$second = true;
								} else {
									if($toggleTax) {
										$pdf->Row(array(
											array('width'=>"10%", 'data'=>"",'border'=>"LR"),
											array('width'=>"15%", 'data'=>"",'border'=>"LR"),
											array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
											array('width'=>"15%", 'data'=>$accommItem['rt_component_desc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_tax_perc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_excl'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_tax'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_payable'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>"",'border'=>"LR")
										));
									} else {
										$pdf->Row(array(
											array('width'=>"10%", 'data'=>"",'border'=>"LR"),
											array('width'=>"15%", 'data'=>"",'border'=>"LR"),
											array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
											array('width'=>"15%", 'data'=>$accommItem['rt_component_desc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$accommItem['rv_item_comp_amt_payable'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>"",'border'=>"LR")
										));
									}
								}
							}
						}
						$firstExtra = false;
						foreach($folioItem['extraList'] as $extraItem) {
							if($firstExtra == false) {
								$summary = "Extras";
								$firstExtra = true;
							} else {
								$summary = "";
							}
							if($first == false) {
								$first = true;
								if($toggleTax) {
									$pdf->Row(array(
										array('width'=>"10%", 'data'=>$folioItem['fn_folio_folio_num'],'border'=>"LR"),
										array('width'=>"15%", 'data'=>$folioName,'border'=>"LR"),
										array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
										array('width'=>"15%", 'data'=>$extraItem['ac_ext_desc'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$extraItem['rv_extra_tax_perc'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_excl'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$extraItem['rv_item_comp_amt_tax'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$extraItem['rv_item_comp_amt_payable'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>"",'border'=>"LR")
									));
								} else {
									$pdf->Row(array(
										array('width'=>"10%", 'data'=>$folioItem['fn_folio_folio_num'],'border'=>"LR"),
										array('width'=>"15%", 'data'=>$folioName,'border'=>"LR"),
										array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
										array('width'=>"15%", 'data'=>$extraItem['ac_ext_desc'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>$extraItem['rv_item_comp_amt_payable'],'border'=>"LR"),
										array('width'=>"10%", 'data'=>"",'border'=>"LR")
									));
								}
							} else {
								if($second == false) {
									if($toggleTax) {
										$pdf->Row(array(
											array('width'=>"10%", 'data'=>"",'border'=>"LR"),
											array('width'=>"15%", 'data'=>$folioItem['rf_currency_symbol'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
											array('width'=>"15%", 'data'=>$extraItem['ac_ext_desc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_tax_perc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_excl'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_tax'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_payable'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>"",'border'=>"LR")
										));
									} else {
										$pdf->Row(array(
											array('width'=>"10%", 'data'=>"",'border'=>"LR"),
											array('width'=>"15%", 'data'=>$folioItem['rf_currency_symbol'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
											array('width'=>"15%", 'data'=>$extraItem['ac_ext_desc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_payable'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>"",'border'=>"LR")
										));
									}
									$second = true;
								} else {
									if($toggleTax) {
										$pdf->Row(array(
											array('width'=>"10%", 'data'=>"",'border'=>"LR"),
											array('width'=>"15%", 'data'=>"",'border'=>"LR"),
											array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
											array('width'=>"15%", 'data'=>$extraItem['ac_ext_desc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_tax_perc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_excl'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_tax'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_payable'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>"",'border'=>"LR")
										));
									} else {
										$pdf->Row(array(
											array('width'=>"10%", 'data'=>"",'border'=>"LR"),
											array('width'=>"15%", 'data'=>"",'border'=>"LR"),
											array('width'=>"10%", 'data'=>$summary,'border'=>"LR"),
											array('width'=>"15%", 'data'=>$extraItem['ac_ext_desc'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>$extraItem['rv_extra_amt_payable'],'border'=>"LR"),
											array('width'=>"10%", 'data'=>"",'border'=>"LR")
										));
									}
								}
							}
						}
						if($second == false) {
							if($toggleTax) {
								$pdf->Row(array(
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"15%", 'data'=>$folioItem['rf_currency_symbol'],'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"15%", 'data'=>"",'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR")
								));
							} else {
								$pdf->Row(array(
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"15%", 'data'=>$folioItem['rf_currency_symbol'],'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"15%", 'data'=>"",'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR"),
									array('width'=>"10%", 'data'=>"",'border'=>"LR")
								));
							}
						}
						if($toggleTax) {
							$pdf->Row(array(
								array('width'=>"10%", 'data'=>"",'fill'=>1,'border'=>"LRTB"),
								array('width'=>"15%", 'data'=>"",'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>"",'fill'=>1,'border'=>"LRTB"),
								array('width'=>"15%", 'data'=>"TOTALS", 'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>"",'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>$folioItem['exclTotal'],'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>$folioItem['taxTotal'],'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>$folioItem['payableTotal'],'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>$folioItem['paymentTotal'],'fill'=>1,'border'=>"LRTB")
							));
						} else {
							$pdf->Row(array(
								array('width'=>"10%", 'data'=>"",'fill'=>1,'border'=>"LRTB"),
								array('width'=>"15%", 'data'=>"",'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>"",'fill'=>1,'border'=>"LRTB"),
								array('width'=>"15%", 'data'=>"TOTALS", 'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>$folioItem['payableTotal'],'fill'=>1,'border'=>"LRTB"),
								array('width'=>"10%", 'data'=>$folioItem['paymentTotal'],'fill'=>1,'border'=>"LRTB")
							));
						}
					}
				}
			}
			$pdf->Ln(4);
		}
		if ($toggleExchNote) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPagewidth(), $pdf->FontSize+1, "Exchange Rate", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['exchange']['note'], '', 'L', 0, 0);
			$pdf->Ln(4);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.21, $pdf->FontSize+1, "Charge", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, "Currency Conversion", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.09, $pdf->FontSize+1, "Rate", 'LRTB', 'R', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.12, $pdf->FontSize+1, "Expiry Date", 'LRTB', 'C', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.20, $pdf->FontSize+1, "", '', 'L', 0, 1);
			$pdf->Ln(0, 1);
			if(sizeof($result['exchange']['extras'])>0){
				foreach($result['exchange']['extras'] as $item) {
					$pdf->Row(array(
						array('width' => "21%", 'data' => $item['ac_ext_desc'], 'border' => "LRTB"),
						array('width' => "18%", 'data' => $item['curr_conversion'], 'border' => "LRTB"),
						array('width' => "9%", 'data' => $item['rv_extra_exch_rate'], 'border' => "LRTB", 'align' => "R"),
						array('width' => "12%", 'data' => $item['exch_expiry'], 'border' => "LRTB", 'align' => "C")
					));
				}
			} else {
				$pdf->Row(array(array('width' => "60%", 'data' =>"No exchange rates", 'border' => "LRTB", 'align' => "C")));
			}
			$pdf->Ln(4);
		}
		if ($toggleReservationNote && trim($result['resNote']) != "") {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Reservation Notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['resNote'], '', 'L', 0, 0);
			$pdf->Ln(4);
		}
		if ($toggleGuestInformation && trim($result['resGuestNote']) != "") {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Guest Information", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['resGuestNote'], '', 'L', 0, 0);
			$pdf->Ln(4);
		}
		if ($toggleRooming) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Rooming Summary", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.10, $pdf->FontSize+1, "Arrive", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.10, $pdf->FontSize+1, "Depart", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.20, $pdf->FontSize+1, "Property", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.20, $pdf->FontSize+1, "Accomm", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.15, $pdf->FontSize+1, "Room / Unit", 'LRTB', 'L', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.05, $pdf->FontSize+1, "Lock", 'LRTB', 'C', 1, 1);
			$pdf->MultiCell($pdf->GetPageWidth() * 0.20, $pdf->FontSize+1, "Reason", 'LRTB', 'L', 1, 1);
			$pdf->Ln(0, 1);
			foreach($result['rooming']['rooms'] as $item) {
				$pdf->MultiCell($pdf->GetPageWidth() * 0.10, $pdf->FontSize+1, $item['arrive'], 'LRTB', 'L', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.10, $pdf->FontSize+1, $item['depart'], 'LRTB', 'L', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.20, $pdf->FontSize+1, $item['property'], 'LRTB', 'L', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.20, $pdf->FontSize+1, $item['accomm'], 'LRTB', 'L', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.15, $pdf->FontSize+1, $item['room'], 'LRTB', 'L', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.05, $pdf->FontSize+1, $item['locked'], 'LRTB', 'C', 0, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.20, $pdf->FontSize+1, $item['reason'], 'LRTB', 'L', 0, 1);
				$pdf->Ln(0, 1);
			}
			$pdf->Ln(4);
		}
		if($toggleRoomingNames) {
			$offset = 1;
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Rooming (Guest Names) Summary", '', 1, 'L', 0);
      		$pdf->SetFont('Arial', '', $pdfFontSize);
			foreach($result['rooming']['guestGroups'] as $item) {
				$pdf->MultiCell($pdf->GetPageWidth() * 0.24, $pdf->FontSize+1, "Guest Names", 'LRTB', 'L', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.02, $pdf->FontSize+1, "", 'LRTB', 'L', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.02, $pdf->FontSize+1, "", 'LRTB', 'L', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, str_replace("<BR>", "\n", $item['item'.($offset)]), 'LRTB', 'L', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, str_replace("<BR>", "\n", $item['item'.($offset+1)]), 'LRTB', 'L', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, str_replace("<BR>", "\n", $item['item'.($offset+2)]), 'LRTB', 'L', 1, 1);
				$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, str_replace("<BR>", "\n", $item['item'.($offset+3)]), 'LRTB', 'L', 1, 1);
				$pdf->Ln(0, 1);
				foreach($item['rows'] as $rowItem) {
					$pdf->MultiCell($pdf->GetPageWidth() * 0.24, $pdf->FontSize+1, $rowItem['name'], 'LRTB', 'L', 0, 1);
					$pdf->MultiCell($pdf->GetPageWidth() * 0.02, $pdf->FontSize+1, $rowItem['guestNote'], 'LRTB', 'L', 0, 1);
					$pdf->MultiCell($pdf->GetPageWidth() * 0.02, $pdf->FontSize+1, $rowItem['guestMemo'], 'LRTB', 'L', 0, 1);
					$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, $rowItem['item1'], 'LRTB', 'L', 0, 1);
					$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, $rowItem['item2'], 'LRTB', 'L', 0, 1);
					$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, $rowItem['item3'], 'LRTB', 'L', 0, 1);
					$pdf->MultiCell($pdf->GetPageWidth() * 0.18, $pdf->FontSize+1, $rowItem['item4'], 'LRTB', 'L', 0, 1);
					$pdf->Ln(0, 1);
				}
				$offset += 4;
				$pdf->Ln(4);
			}
		}
		if($toggleGuestNote) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Guest Notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			foreach($result['rooming']['notes'] as $item) {
				$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, $item['name'], 'LRTB', 1, 'L', 1);
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $item['note'], '', 'L', 0);
				$pdf->Ln(4);
			}
		}
		if($toggleGuestMemo) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Guest Memos", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			foreach($result['rooming']['memos'] as $item) {
				$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, $item['name'], 'LRTB', 1, 'L', 1);
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $item['note'], '', 'L', 0);
				$pdf->Ln(4);
			}
		}
		if($toggleExtraNote && (trim($extraNote) != "")) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Extras Notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			if(trim($extraNote) != "") {
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $extraNote, '', 'L', 0, 0);
			}
			$pdf->Ln(4);
		}
		if($toggleCancelNoteCheck && $result['rf_reservation_status_id'] >= 90 && trim($result['cancelNote']) != "") {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Cancellation notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, t_decodeHTML($result['cancelNote']), '', 'L', 0, 0);
			$pdf->Ln(4);
		}
		if($toggleInternalMemoCheck) {
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Internal Notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			if($result['resInternalNote'] != "") {
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, "<U>Reservation Internal Memos</U>", '', 'L', 0, 0);
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['resInternalNote'], '', 'L', 0, 0);
			}
			if(trim($result['guestNationality']) != "") {
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $result['guestNationality']."\n\n", '', 'L', 0, 0);
			}

			if($extraMemo != "") {
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, "<U>Extras internal memos</U>", '', 'L', 0, 0);
				$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $extraMemo, '', 'L', 0, 0);
			}
			
			$pdf->Ln(4);
		}
		if($togglePropertyNoteCheck) {
			$propNotes = "";
			foreach($result['propertyNotes'] as $item) {
				$propNotes .= $item['pr_name_last']."\n".$item['pr_bus_memo_info']."\n\n";
			}
			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Property Notes", '', 1, 'L', 0);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, $propNotes, '', 'L', 0, 0);
			$pdf->Ln(4);
		}
		if($toggleBookingTerms) {
			$terms = $lDB->get("select rf_booking_info from rf_custom where rf_custom_id = 1",4);
			if($docType == DOC_INVOICE) {
				$terms = $lDB->get("SELECT fn_inv_booking_info FROM fn_invoice WHERE fn_invoice_ix = '$invoiceId'",4);
			}
			$search = array (
				"'<script[^>]*?>.*?</script>'si",  // Strip out javascript
				"'<[\/\!]*?[^<>]*?>'si",           // Strip out html tags
				"'([\r\n])[\s]+'",                 // Strip out white space
				"'&(quot|#34);'i",                 // Replace html entities
				"'&(amp|#38);'i",
				"'&(lt|#60);'i",
				"'&(gt|#62);'i",
				"'&(nbsp|#160);'i",
				"'&(iexcl|#161);'i",
				"'&(cent|#162);'i",
				"'&(pound|#163);'i",
				"'&(copy|#169);'i"
			);
			$replace = array (
				"",
				"",
				"\\1",
				"\"",
				"&",
				"<",
				">",
				" ",
				chr(161),
				chr(162),
				chr(163),
				chr(169)
			);

			//TODO: Replace with str_ireplace in PHP5
			$terms =
					str_replace("</div>","\n",
					str_replace("</DIV>","\n",
					str_replace("</p>","\n",
					str_replace("</P>","\n",
					str_replace("<br>","\n",
					str_replace("<BR>","\n",
				urldecode($terms)))))));
			$terms = preg_replace ($search, $replace, $terms);
			$terms = preg_replace_callback(
				"'&#(\d+);'",
				function($matches) {
					return chr($matches[1]);
				},
				$terms
			);

			$pdf->SetFont('Arial', 'B', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>"Booking Terms and Conditions")
			));
			$pdf->Ln(1);

			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>t_decodeHTML($terms))
			));
			$pdf->Ln(1);
		}
		if($toggleCreditCard) {
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"25%", 'data'=>"Authorisation to debit credit card",'style'=>"B"),
				array('width'=>"75%", 'data'=>" (Reference: ".$result['rv_reservation_id'].")")
			));
			$pdf->Ln(1);
			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card holder's name"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card holder's address"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>" (postal or physical)"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Passport or ID number"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"25%", 'data'=>" Date of birth"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Mother's maiden name"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);			
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card type"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Amex"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Visa"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Master"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Diners"),
				array('width'=>"2%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>"Other"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR"),
				array('width'=>"5%", 'data'=>"")

			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Credit card number"),
				array('width'=>"75%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card expiry date"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"25%", 'data'=>" Security code on reverse (CVC)"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"5%", 'data'=>"")
			));
			$pdf->Ln(1);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Amount to be debited"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"25%", 'data'=>" Colour of card"),
				array('width'=>"25%", 'data'=>"", 'border'=>"LTBR", 'align'=>"C"),
				array('width'=>"5%", 'data'=>"")
			));			
			$pdf->Ln(10);
			$pdf->Row(array(
				array('width'=>"20%", 'data'=>"Card holder's signature"),
				array('width'=>"60%", 'data'=>"", 'border'=>"B", 'align'=>"C"),
				array('width'=>"10%", 'data'=>"")
			));
			$pdf->Ln(5);
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>"Completing the credit card details authorises the service provider to deduct deposits and prepayments as detailed on this document")
			));
			$pdf->Ln(1);
		}

		if (trim(t_decodeHTML($proformaNote)) != "") {
			$pdf->Ln(1);
			$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, t_decodeHTML($proformaNote), '', 'C', 0, 0);
			$pdf->Ln(4);
		}

		if ($toggleOnlineGuestCheckIn) {
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>'Online check-in','style'=>"B"),
			));
			$pdf->Write(5,'For your convenience use our ');
			$pdf->SetTextColor(201, 37, 47);
			$pdf->Write(5,'Online Guest Services', $guestServicesUrl);
			$pdf->SetTextColor(0);
			$pdf->Write(5,' to update your ');
			$pdf->SetTextColor(201, 37, 47);
			$pdf->Write(5,'Guest List', $guestListUrl);
			$pdf->SetTextColor(0);
			$pdf->Write(5,' or to ');
			$pdf->SetTextColor(201, 37, 47);
			$pdf->Write(5,'Check-in Online', $guestCheckInUrl);
			$pdf->SetTextColor(0);
			$pdf->Write(5,'.');
			$pdf->Ln(8);
		}

		if ($togglePublicPayments) {
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>'Public Payments','style'=>"B"),
			));
			$pdf->Write(5,'For your convenience use our ');
			$pdf->SetTextColor(201, 37, 47);
			$pdf->Write(5,'Pay Now', $payNowUrl);
			$pdf->SetTextColor(0);
			$pdf->Write(5,' page to pay your account online.');
			$pdf->Ln(8);
		}

		// [START] Custom Notes
		if($customNotesList != "") {
			$customArray = explode(",",$customNotesList); // comes from argv[11]
			if(sizeof($customArray) > 0) {
				foreach($customArray as $custNote) {
					$customNotes = $lDB->get("
						SELECT
							rf_note_custom.rf_note_custom_desc as custNoteDesc,
							rf_note_custom.rf_note_custom_hdg as custNoteHdg
						FROM
							rf_note_custom
						WHERE
							rf_note_custom.rf_note_custom_ix = '$custNote'
					",1);
					$customItems = $lDB->get("
						SELECT
							rf_note_cust_item.rf_note_cust_item_ix as itemId,
							rf_note_cust_item.rf_note_cust_item_path as itemImgName,
							rf_note_cust_item.rf_note_cust_item_seq as itemSeq,
							rf_note_cust_item.rf_note_cust_item_text as itemText,
							rf_note_cust_item.rf_note_cust_pg_brk_yn as newPage
						FROM
							rf_note_cust_item
						WHERE
							rf_note_cust_item.rf_note_custom_id = '$custNote'
						ORDER BY
							rf_note_cust_item.rf_note_cust_item_seq
					",2);

					//If section 1 is on new page - custNoteHdg to be on new page with first section
					$hdgNewPage = "0";
					if(isset($customItems[0]['newPage']) && $customItems[0]['newPage'] == "1") {
						$pdf->AddPage();
						$hdgNewPage = "1";
					}
					$pdf->Row(array(
						array('width'=>"100%", 'data'=>$customNotes['custNoteHdg'],'style'=>"B")
					));
          			$pdf->Ln(1);

					// Display combined notes
					$itemNote = "";
					foreach($customItems as $item){
						if($item['newPage'] == "1" && $hdgNewPage == "0"){
							$pdf->AddPage();
						}
						if($item['itemText'] != "" || $item['itemText'] != null) {
							$pdf->Row(array(
								array('width'=>"100%", 'data'=>$item['itemText'])
							));
						} else { // it is an image
							$imgPath = "$GLOBALS[images_dir_on_disk]/".$_SESSION['principal_id']."/custom/";
							$itemNote .= $imgPath.$item['itemImgName'];
							if(file_exists($imgPath.$item['itemImgName'])) {
								$picY = $pdf->y;
								$picX = $pdf->x;
								$pic = $pdf->_parsejpg($imgPath.$item['itemImgName']);
								$finalH = $pdf->Image($imgPath.$item['itemImgName'], $picX, $picY, $pic['w']/3.5, $pic['h']/3.5);
								if (($picY + $finalH) > $pdf->y) {
									$pdf->y = $picY + $finalH;
								}
								$pdf->Ln(2);
							}
						}
						$hdgNewPage = "0";
					}
					$pdf->Ln(4);
				}
			}
		}
		// [END] Custom Notes

		if($docType == DOC_INVOICE) {
			// This adds the tax totals to the top of the first page of the invoice
			// in a fixed location, for ESD machines to read. This not supposed
			// to be read by humans, thus we make the text white to "hide" it

			$taxESD = isset($taxESD) ? $taxESD : "";
			$totalESD = isset($taxTotal) ? $taxTotal : "";

			$pdf->SetFont('Arial', '', $pdfFontSize);
			$pdf->SetTextColor(255, 255, 255);
			//$pdf->SetTextColor(0, 0, 0);	// uncomment this line to make the text black, for debugging
			$currentPage = $pdf->PageNo();
			$pdf->SetPage($firstPage);
			$pdf->SetXY(0, 0);
			$pdf->Row(array(
				array('width' => "30px", 'data' => $taxESD),
				array('width' => "30px", 'data' => $totalESD),
				array('width' => "30px", 'data' => $taxESD != 0 ? '' : 'TAXEXEMPT')
			));
			$pdf->Ln(1);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetPage($currentPage);
		}

		if($docType == DOC_INVOICE) {
			$finalCount = $invoicePrint['fn_inv_print_count']+1;
			if($finalCount < 1) { $finalCount = 1; }
			$lDB->put("UPDATE fn_invoice SET fn_inv_print_count = '".$finalCount."' WHERE fn_invoice_ix = '$invoiceId'");
			if($invoicePrint['fn_inv_print_count'] < 1) {
				$optAccomm = 0;
				$optBank = 0;
				$optCCA = 0;
				$optDate = 0;
				$optSpecial = 0;
				$optSpecialNote = 0;
				$optTax = 0;
				$optTaxTable = 0;
				$optTaxTableGL = 0;
				$optTaxTableRate = 0;
				$optTaxTableTotal = 0;
				$optTerms = 0;
				$optTermsBus = 0;
				if ($toggleResAccomm) { $optAccomm = 1;}
				if ($toggleBankDetails) { $optBank = 1;}
				if ($toggleCreditCard) { $optCCA = 1; }
				if ($showServiceDate) { $optDate = 1; }
				if ($showSpecial) { $optSpecial = 1; }
				if ($showSpecialNote) { $optSpecialNote = 1; }
				if ($toggleTax) { $optTax = 1; }
				if ($showTaxTable) { $optTaxTable = 1; }
				if ($showTaxTableGL) { $optTaxTableGL = 1; }
				if ($showTaxTableRate) { $optTaxTableRate = 1; }
				if ($showTaxTableTotal) { $optTaxTableTotal = 1; }
				if ($toggleBookingTerms) { $optTerms = 1; }
				if ($togglePropertyNoteCheck) { $optTermsBus = 1; }
				$lDB->put("
					UPDATE fn_invoice SET
						fn_inv_opt_accomm = '$optAccomm',
						fn_inv_opt_bank = '$optBank',
						fn_inv_opt_cca = '$optCCA',
						fn_inv_opt_date = '$optDate',
						fn_inv_opt_special = '$optSpecial',
						fn_inv_opt_special_note = '$optSpecialNote',
						fn_inv_opt_tax = '$optTax',
						fn_inv_opt_tax_table = '$optTaxTable',
						fn_inv_opt_tax_table_gl = '$optTaxTableGL',
						fn_inv_opt_tax_table_rate = '$optTaxTableRate',
						fn_inv_opt_tax_table_total = '$optTaxTableTotal',
						fn_inv_opt_terms = '$optTerms',
						fn_inv_opt_terms_bus = '$optTermsBus',
						fn_inv_tax_table_align = '".$lDB->escape($optTaxTableAlign)."'
					WHERE
						fn_invoice_ix = '$invoiceId'
				");
			}
		}
		if ($renderType == "save") {
			$pdf->OutPut('./PDF/current/invoice1.pdf');
		} elseif ($renderType == "view") {
			if($docKey == (sizeof($docList)-1)) {
				if(isset($GLOBALS['pdfEcho']) && $GLOBALS['pdfEcho']) {
					$pdf->OutPut('',false,true);
				} else {
					$pdf->OutPut();
					die();
				}
			}
		} elseif ($renderType == "send") {
			if($docKey == (sizeof($docList)-1)) {
				$to = $_POST['mail_to'];
				$from = $_POST['mail_from'];
				$subject = $_POST['mail_subj'];
				$message = $_POST['mail_body'];
				$headers = "From: ".$principalName."<$from>\r\n";
				// close the pdf
				if ($pdf->state < 3) $pdf->Close();
				/* and now mail it */
				switch($docType) {
				case DOC_RESERVATION:
					$pf_object_id = db_pf_object_by_name("email_document"); 
					break;
				case DOC_FOLIO:
					$pf_object_id = db_pf_object_by_name("email_proforma"); 
					break;
				case DOC_INVOICE:
					$pf_object_id = db_pf_object_by_name("email_invoice"); 
					break;
				}
				$attachments = explode("|",$_POST['attachments']);

				$error = email($from, $to, $subject, $headers, $message, 0, 0, $resId, $principalName, $pdf->buffer, $result['rv_reservation_id'].".pdf",$pf_object_id,$attachments);
				if (!$error) {
					echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				} else {
					echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				}
				session_restart();
				unset($_SESSION['documentComment']);
				unset($_SESSION['documentAddress']);
				session_write_close();
				die();
			}
		}
	}

	if(isset($renderMode) && $renderMode == "pdf" && isset($renderType) && $renderType == "email") {
		$GLOBALS['temp'] = array_merge($result, $GLOBALS['temp']);
		$attachmentTable = "
			<table border=\"0\" cellspacing=\"0\" width=\"100%\">
			<tr valign=\"top\">
				<td class=\"uk-flex\" width=\"100%\"><i class=\"material-icons uk-margin-small-right\">attachment</i><div id=\"attachmentLabel\">!rv_reservation_id!.pdf</div></td>
			</tr>
			</table>
		";

		$email_text = isset($_POST['comment'])?$_POST['comment']:"";
		$email_text .= "\n\nAdobe Reader is recommended to open the attached PDF document. Adobe Reader can be downloaded at http://www.adobe.com\n";
		$emailToSetup = "";
		if($docType == DOC_RESERVATION) {
			$relate = relatedEmailAddress($resId,false);
		} else {
			$relate = relatedEmailAddress($resId,$folioId);
		}
		foreach($relate as $item) {
			$emailToSetup .= "emailToName[emailToName.length] = \"".$item['name']."\"; emailToAddress[emailToAddress.length] = \"".$item['email']."\";";
		}
		if($_SESSION['userStatusId'] == "0") {
			$emailToSetup .= "showSearch = false;";
		}
		if(sizeof($docList) > 1 && $_SERVER['argv'][3] != "") { // DB TODO: Figure out why this argv is here and remove it
			$GLOBALS['temp']['folioId'] = $_SERVER['argv'][3];
		}

		switch($docType) {
		case DOC_RESERVATION:
			$pf_object_name = "email_document";
			break;
		case DOC_FOLIO:
			$pf_object_name = "email_proforma";
			break;
		case DOC_INVOICE:
			$pf_object_name = "email_invoice";
			break;
		}
		$autoCC = array();
		$autoClass = "collapse printCollapse";
		if(db_pf_object_exists_by_name($pf_object_name)) {
			$autoCC = getAutoCC(db_pf_object_by_name($pf_object_name));
			if(sizeof($autoCC) > 0) {
				$autoClass = "expand";
			}
		}

		$billingEmail = $lDB->get("
			SELECT
				pr_persona.pr_email
			FROM
				rv_reservation
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_billing_persona_id
			WHERE
				rv_reservation.rv_reservation_ix = '$resId'
		",4);
		$invoiceEmail = $lDB->get("
			SELECT
				pr_persona.pr_email
			FROM
				rv_reservation
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_invoice_persona_id
			WHERE
				rv_reservation.rv_reservation_ix = '$resId'
		",4);
		
		// If we have a default template
		$template_toggle = "";
		if($templateData['text'] !== false) {
			$email_text = $templateData['text'];
			$template_toggle = $templateData['toggle'];
		}
		
		$GLOBALS[$form]->FormHTML =
			str_replace("!emailToSetup!", str_replace("'", "\\'", $emailToSetup),
			str_replace("!emailTo!","",
			str_replace("!billingEmail!",$billingEmail,
			str_replace("!invoiceEmail!",$invoiceEmail,
			str_replace("!toggleMap!", $toggleMap,
			str_replace("!email_type!", REP_SEND_PDF,
			str_replace("!showReference!",$showReference,
			str_replace("!showSupplier!", $showSupplier,
			str_replace("!showAgentComm!", $showAgentComm,
			str_replace("!showPayPlanInv!", $showPayPlanInv,
			str_replace("!showConsolidatedItems!",$showConsolidatedItems,
			str_replace("!showServiceDate!",$showServiceDate,
			str_replace("!showSpecial!",$showSpecial,
			str_replace("!showSpecialNote!",$showSpecialNote,
			str_replace("!showTaxTable!",$showTaxTable,
			str_replace("!showTaxTableGL!",$showTaxTableGL,
			str_replace("!showTaxTableRate!",$showTaxTableRate,
			str_replace("!showTaxTableTotal!",$showTaxTableTotal,
			str_replace("!attachmentInfo!", $attachmentTable,
			str_replace("!hasAttachment!", "expand",
			str_replace("!emailBody!", $email_text,
			str_replace("!auto_cc_class!",$autoClass,
			str_replace("!auto_cc!",join(", ",$autoCC),
			str_replace("!templateToggle!", $template_toggle,
			str_replace("!attachmentToggle!", attachmentToggle(),
			Join("", file(__DIR__ . "/../../../public/html/email_popup.htm")))))))))))))))))))))))))));

		if ($_SESSION['userStatusId'] == "0") {
			$GLOBALS[$form]->FormHTML = str_replace("!emailToSetup!", "showSearch = false;", $GLOBALS[$form]->FormHTML);
		}
		$resIdList = "";
		foreach($docList as $resIdItem) {
			if($resIdList != "") {
				$resIdList .= ", ";
			}
			$resIdList .= $resIdItem['resId'];
		}
		$GLOBALS['temp']['emailSubject'] = "$result[rv_res_name] ($resIdList)";
		if(isset($_POST['comment']) && $_POST['comment'] != "") {
			session_set("documentComment",$_POST['comment']);
		}
		if(isset($_POST['address']) && $_POST['address'] != "") {
			session_set("documentAddress",t_decodeHTML($_POST['address']));
		}
		$GLOBALS['temp']['emailFrom'] = $lDB->get("
			SELECT
				pr_persona.pr_email
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix = '$_SESSION[userid]'
		",4);
		$GLOBALS['temp']['princName'] = $principalName;
	}
}
// [END] PDF Section

foreach($GLOBALS['temp'] as $key=>$item) {
	if(is_array($item)) {
		$GLOBALS['temp'][$key] = "";
	}
}
