<?php

/**
 * init.form217.php - The overbooking calendar/resdetails popup
 * Job: 644
 * Function: 50 (Availability calendar)
 */

if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/continue_yn2.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],9,"");

$userStatusId = isset($_SESSION['userStatusId'])?$_SESSION['userStatusId']:"0";
$wizResId = isset($_SESSION['wizResId'])?$_SESSION['wizResId']:"";

global $userStatusId;

$data = explode(":",$_SERVER['argv'][1]);
$ac_accomm_type_id			= $data[0];
$rv_item_date_arrive		= str_replace("/","-",$data[1]);
$rv_item_date_depart		= str_replace("/","-",$data[2]);

$rateGroupArr = explode("~",$data[4]);
foreach($rateGroupArr as $rateGroupPair){
	$rateGroupPairArr = array_pad(explode("_", $rateGroupPair),2,0);
	$rateGroups[] = array(
					"rt_rate_group_ix" => $rateGroupPairArr[0],
					"name"	=> "",
					"qty"	=> $rateGroupPairArr[1])
	;
}
$rv_item_accomm_count		= $rateGroups[0]['qty'];

$rateId					= $_SERVER['argv'][3];
$reservationId	= $_SERVER['argv'][4];
$itemId					= $_SERVER['argv'][5];
$allocations		= $_SERVER['argv'][6];
//$orideamt = $_SERVER['argv'][7];
$override = explodeOrides($_SERVER['argv'][7]);

if ( $reservationId != "" && strpos($reservationId,"rsFrame") === false ) {
	$wizResId = $reservationId;
}
   
$GLOBALS['temp']['reservationId'] = $reservationId;
$GLOBALS['temp']['itemId']				= $itemId;

$showOptions = checkOptionalComponents(array($rv_item_date_arrive,$rv_item_date_depart),$rateId,$ac_accomm_type_id);

session_restart();
unset($_SESSION['wizItemOverbooking']);
session_write_close();

if(!empty($wizResId)) {
	$allocCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation_item AS link_item ON rv_reservation_item.rv_reservation_item_ix = link_item.rv_link_res_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$wizResId'
	", 4);
} else {
	$allocCount = 0;
}

$hasAllocations = (trim($allocations) != "") || ($allocCount > 0);

if ( $_SERVER['argv'][2] != "1" ) {
	$rsFuncList = array();

	$invalidDate = false;
	$arriveDateArray = explode("-",$rv_item_date_arrive);
	$departDateArray = explode("-",$rv_item_date_depart);
	if(
		!checkdate($arriveDateArray[1],$arriveDateArray[2],$arriveDateArray[0])
		|| !checkdate($departDateArray[1],$departDateArray[2],$departDateArray[0])
	) {
		$invalidDate = true;
	}

	if($invalidDate) {
		array_push($rsFuncList,"openMessage");
		array_push($rsFuncList,"\"Invalid arrival or departure date\"");
	} else {
		$result			= check_item_availability($rv_item_date_arrive,$rv_item_date_depart,$ac_accomm_type_id,$rv_item_accomm_count,$itemId,$allocations);

		if(isset($_SESSION['wizOverbooking']) && $_SESSION['wizOverbooking'] == true && $hasAllocations) {
			$result = false;
		}
	
		if ( $result !== true ) {
			array_push($rsFuncList,"showOverbooking");
			array_push($rsFuncList,"");
		} else {
			$roomResult = check_room_availability($rv_item_date_arrive,$rv_item_date_depart,$itemId);
			
			if ( $roomResult !== true ) {
				
				foreach ( $roomResult as $key => $item ) {
					$roomResult[$key] = t_encodeOverlib($item);
				}
				array_push($rsFuncList,"showRoomOverbooking");
				array_push($rsFuncList,"['".join("','",$roomResult)."']");
			} else {
				array_push($rsFuncList,"continueBooking");
				array_push($rsFuncList,"");
			}
		}
	}
	// Output RS response --------------------------------------------------------
	echo rsOutput("","","",$rsFuncList);
	die();
} else {
	$GLOBALS['temp']['accomm_type_id']	= $ac_accomm_type_id;
	$GLOBALS['temp']['date_arrive']			= $rv_item_date_arrive;
	$GLOBALS['temp']['date_depart']			= $rv_item_date_depart;
	$GLOBALS['temp']['unit_count']			= $rv_item_accomm_count;
	$GLOBALS['temp']['rv_res_id']				= (string) $wizResId;
	$GLOBALS['temp']['showOverBook']		= ' style="display: none;"';
	
	if ( $userStatusId > 1 ) {
		$GLOBALS['temp']['showOverBook'] = "";
	}

	$GLOBALS['temp']['allowOverbooking'] = "collapse printCollapse";
	$GLOBALS['temp']['allowOverbookingExtraMessage'] = "";
	$GLOBALS['temp']['disallowOverbooking'] = "collapse printCollapse";
	$GLOBALS['temp']['disallowOverbookingExtraMessage'] = "";
	if(db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn") == "1") {
		$GLOBALS['temp']['allowOverbooking'] = "";
	} else {
		if(!empty($wizResId)) {
			$rf_reservation_status_id = $GLOBALS['lDB']->get("SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
		} else {
			$rf_reservation_status_id = 25;
		}

		if($rf_reservation_status_id == 25) {
			if(!$hasAllocations) {
				// new reservation
				$GLOBALS['temp']['allowOverbooking'] = "";
				if($userStatusId < 1) {
					$GLOBALS['temp']['allowOverbookingExtraMessage'] = "Your access rights do not permit you to create overbookings. This booking can only be set to Quotation.";
				} else {
					$GLOBALS['temp']['allowOverbookingExtraMessage'] = "Your access rights do not permit you to create overbookings. This booking can only be set to Waitlist or Quotation.";
				}
				session_set("wizItemOverbooking",true);
			} else {
				$GLOBALS['temp']['disallowOverbooking'] = "";
				$GLOBALS['temp']['disallowOverbookingExtraMessage'] = "Your access rights do not permit you to create overbookings and bookings with allocations may not be set to waitlist or quotation.<br/><br/>";
			}
		} elseif($rf_reservation_status_id < 15) {
			$GLOBALS['temp']['allowOverbooking'] = "";
			$GLOBALS['temp']['allowOverbookingExtraMessage'] = "Your access rights do not permit you to create overbookings. This reservation is set to Waitlist / Quotation which means you can apply these changes.";
		} else {
			$GLOBALS['temp']['disallowOverbooking'] = "";
			if($rf_reservation_status_id != 15) {
				$GLOBALS['temp']['disallowOverbookingExtraMessage'] = "Change the booking status to Waitlist or Quotation and then proceed.<br/><br/>";
			}
		}
	}
	
	$GLOBALS['temp']['showOptions'] = "false";
	
	if ( $showOptions ) {
		$GLOBALS['temp']['showOptions'] = "true";
	}
}
