<?php

/**
 * init.form219.php - Reservation Financial Tab
 * Job: 646, 647, 648
*/

if(array_key_exists("action",$_POST)) {
	switch($_POST['action']) {
	case "agent_defaults":
		$record = $_SERVER['argv'][1];
		$pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '" . $record . "'",4);
		echo json_encode(getDefaultTerms($pr_agent_id));
		break;
	}
	die();
}

$GLOBALS['resAMMEND'] = false;
$fiscalMessage = '';
$showFiscal = '0';
$fiscal_status = '';
$fiscalStatusCheck = updateIncompleteFiscalInvoices();

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/reservation_billing.htm");
	$fields = array(
		"rv_agent_id",
		"rv_invoice_persona_id",
		"rv_billing_persona_id",
		"rv_invoice_currency_id",
		"rv_commission_deduct_yn",
		"rv_commission_perc",
		"rv_exchg_rate",
		"rv_exchg_expiry_date",
		"rv_folio_level_ind",
		"rv_date_changed"
	);
	$ident = array("");
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'], "rv_reservation", $fields, "rv_reservation_ix = '$record'", "", "", $ident);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],8,"");

$wetu = new Wetu($record, $GLOBALS['lDB']);
$GLOBALS['temp']['wetuDropdownOptions'] = $wetu->GenerateButtontext();

$GLOBALS['temp']['commissionLabel'] = commissionLabel();

$allowInvoiceCreate = false;
if (isset($GLOBALS['funLevelArray']) && isset($GLOBALS['funLevelArray'][108])) {
	$allowInvoiceCreate = $GLOBALS['funLevelArray'][108] >= 10;
}
$allowInvoiceVoid = db_sc_group_get_user_setting("sc_grp_res_void_invoice_yn") == "1";

// Define scrollset
$resScrollSet = isset($_SESSION['resScrollSet'])?$_SESSION['resScrollSet']:"";
if (!is_array($resScrollSet)) {
	$resScrollSet = array();
}

// Initialise startup listing variables
$GLOBALS['temp']['startupListTitle'] = "";
$GLOBALS['temp']['startupList'] = "";
if(!array_key_exists("postSaveMessage",$GLOBALS['temp'])) {
	$GLOBALS['temp']['postSaveMessage'] = "";
}

// Setup the record scrolling
$rPrev = $record;
$rNext = $record;
if(!in_array($record, $resScrollSet) && $record != "0" && $record != "") {
	array_push($resScrollSet, $record);
}

if(is_array($resScrollSet)) {
	for($q = 0; $q < sizeof($resScrollSet); $q++) {
		$key = isset($resScrollSet[$q]) ? $resScrollSet[$q] : "";
		if($key == $record) {
			if($q > "0") {
				$rPrev = $resScrollSet[$q-1];
			}
			if($q+1 < sizeof($resScrollSet)) {
				$rNext = $resScrollSet[$q+1];
			}
		}
	}
}
addLastRes($record);

$record = $_SERVER['argv'][1];
$GLOBALS['temp']['record'] = (string) $record;

// Verify that the user can edit, or delete for this reservation
$canEditReservation = canEditReservation($record,true,647);
if(
	!(isset($_POST['batchInvoice']) && $_POST['batchInvoice'] == "1" && $allowInvoiceCreate) /* if not invoicing */
	&&!(isset($_POST['voidId']) && $_POST['voidId'] && $allowInvoiceVoid) /* and not voiding */
	&& $action == "3" && !$canEditReservation) {
	redirectTo(" ./reservation.php?646+".$_SERVER['argv'][1]."+".$_SERVER['argv'][2]."+++++".$_SERVER['argv'][7]);
}

$moduleFieldValues = array();
$auditActions = array();

$isInternal = "false";
// Determine the userStatus
if($GLOBALS['pr_sys_code'] == "9") {
	$calAgentId = "0";
	$userStatusId = "3";
	$isInternal = "true";
} else {
	if($GLOBALS['pr_business_link'] != "0") {
		$calAgentId = "0";
		$userStatusId = "2";
		$isInternal = "true";
	} else {
		if($GLOBALS['is_an_agent']) {
			$calAgentId = $GLOBALS['userid'];
			$userStatusId = "1";
		} elseif($GLOBALS['pr_agent_link'] != "0") {
			$calAgentId = $GLOBALS['pr_agent_link'];
			$userStatusId = "1";
		} else {
			$calAgentId = "0";
			$userStatusId = "0";
		}
	}
}
$GLOBALS['temp']['isInternal'] = (string) $isInternal;
$GLOBALS['temp']['payplanStyle'] = "";
if($action != "3") {
	$GLOBALS['temp']['payplanStyle'] = " style=\"visibility:hidden\"";
}
if(isset($GLOBALS['RECALCTOTALS']) && $GLOBALS['RECALCTOTALS'] > 0) {
	if($GLOBALS['RECALCTOTALS'] == 1) {
		recalcTotals($record);
	}
	if($GLOBALS['RECALCTOTALS'] == 2) {
		regenBilling($record);
	}
	$GLOBALS['RECALCTOTALS'] = "0";
}
// START - Process any folio requests
if(isset($_POST['folioNewContact']) && $_POST['folioNewContact'] == "1" ) {
	if ( trim($_POST['folioNewContactFolioId']) != "" ) {
		$GLOBALS['lDB']->put("UPDATE fn_folio SET fn_folio_to_id = '" . $_POST['folioNewContactPersonaId'] . "' WHERE fn_folio_ix = '" . $_POST['folioNewContactFolioId'] . "'");
		ammendReservation($record,"Folio name change");
		$_POST['folioNewContact'] = "0";
	}
}
// END - Process any folio requests

// START - Process any invoice requests
$GLOBALS['temp']['invoiceScript'] = "";
$invoiceArray = array();
if(isset($_POST['invoiceFolio']) && isset($_POST['invoiceDate']) && $_POST['invoiceFolio'] && $_POST['invoiceDate']) {
	$newInvoice = db_fn_invoice_create($_POST['invoiceFolio'], $_POST['invoiceDate'], $_POST['invoiceExch']);

	array_push($invoiceArray, $newInvoice);
}

if(isset($_POST['voidId']) && $_POST['voidId'] && $allowInvoiceVoid) {
	if($_POST['voidPrint'] == "1") {
		$print = " with print";
	} else {
		$print = " without print";
	}
	if($_POST['voidDateType'] == "default") {
		$voidDate = false;
	} else {
		$voidDate = $_POST['voidDate'];
	}
	if($_POST['voidType'] == "cancel") {
		db_fn_invoice_void($_POST['voidId'],false,$voidDate);
	} else {
		db_fn_invoice_reverse($_POST['voidId'],$voidDate);
	}
}
if(isset($_POST['batchInvoice']) && $_POST['batchInvoice'] == "1" && $allowInvoiceCreate) {
	$folioArray = explode(":",$_POST['batchInvoiceFolioList']);
	$dateType = $_POST['batchInvoiceDateType'];
	$invoiceDate = $_POST['batchInvoiceDate'];
	$exchangeRate = $_POST['batchInvoiceExch'];
	$printInvoice = $_POST['batchInvoicePrint'];

	foreach($folioArray as $folioId) {
		if($dateType == 1) {
			$invoiceDate = $GLOBALS['lDB']->get("SELECT fn_folio_date FROM fn_folio WHERE fn_folio_ix = '$folioId'",4);
		}
		if(trim($exchangeRate) == "") {
			$newInvoice = db_fn_invoice_create($folioId,$invoiceDate);
		} else {
			$newInvoice = db_fn_invoice_create($folioId,$invoiceDate,$exchangeRate);
			$folioInfo = $GLOBALS['lDB']->get("
				SELECT
					fn_folio.rf_currency_id,
					pr_business.pr_bus_home_curr_id
				FROM
					fn_folio
					INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
				WHERE
					fn_folio.fn_folio_ix = '$folioId'
			",1);
		}
		$businessPrint = $GLOBALS['lDB']->get("
			SELECT
				pr_bus_opt_accomm,
				pr_bus_opt_bank,
				pr_bus_opt_cca,
				pr_bus_opt_date,
				pr_bus_opt_special,
				pr_bus_opt_special_note,
				pr_bus_opt_tax,
				pr_bus_opt_tax_table,
				pr_bus_opt_tax_table_gl,
				pr_bus_opt_tax_table_rate,
				pr_bus_opt_tax_table_total,
				pr_bus_opt_terms,
				pr_bus_opt_terms_bus,
				pr_bus_tax_table_align,
				pr_business.pr_business_id
			FROM
				fn_folio
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",1);
		if($businessPrint['pr_bus_opt_bank'] == "1") {
			$folioCurrencyId = $GLOBALS['lDB']->get("SELECT rf_currency_id FROM fn_folio WHERE fn_folio_ix = '$folioId'",4);
			$bankArray = $lDB->get("
				SELECT DISTINCT
					rf_currency.rf_currency_symbol,
					rf_bank.rf_bank_name,
					rf_bank.rf_bank_acc_no,
					rf_bank.rf_bank_detail_1,
					rf_bank.rf_bank_detail_2,
					rf_bank.rf_bank_detail_3,
					rf_bank.rf_bank_acc_name,
					rf_bank.rf_bank_ix as bankId
				FROM
					pr_bus_bank
					INNER JOIN rf_bank ON rf_bank.rf_bank_ix = pr_bus_bank.rf_bank_id
					INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
				WHERE
					pr_bus_bank.pr_business_id = '" . $businessPrint['pr_business_id'] . "'
					AND rf_bank.rf_currency_id = '" . $folioCurrencyId . "'
			",2);
			foreach($bankArray as $bankItem) {
				$lDB->put("
					INSERT INTO fn_invoice_bank (
						fn_invoice_bank_db,
						fn_inv_bank_acc_name,
						fn_inv_bank_acc_no,
						fn_inv_bank_detail_1,
						fn_inv_bank_detail_2,
						fn_inv_bank_detail_3,
						fn_inv_bank_name,
						fn_inv_currency_symbol,
						fn_invoice_id
					) VALUES (
						'$GLOBALS[dbcode]',
						'$bankItem[rf_bank_acc_name]',
						'$bankItem[rf_bank_acc_no]',
						'$bankItem[rf_bank_detail_1]',
						'$bankItem[rf_bank_detail_2]',
						'$bankItem[rf_bank_detail_3]',
						'$bankItem[rf_bank_name]',
						'$bankItem[rf_currency_symbol]',
						'$newInvoice'
					)
				");
			}
		}
		$GLOBALS['lDB']->put("
			UPDATE fn_invoice SET
				fn_inv_opt_accomm = '$businessPrint[pr_bus_opt_accomm]',
				fn_inv_opt_bank = '$businessPrint[pr_bus_opt_bank]',
				fn_inv_opt_cca = '$businessPrint[pr_bus_opt_cca]',
				fn_inv_opt_date = '$businessPrint[pr_bus_opt_date]',
				fn_inv_opt_special = '$businessPrint[pr_bus_opt_special]',
				fn_inv_opt_special_note = '$businessPrint[pr_bus_opt_special_note]',
				fn_inv_opt_tax = '$businessPrint[pr_bus_opt_tax]',
				fn_inv_opt_tax_table = '$businessPrint[pr_bus_opt_tax_table]',
				fn_inv_opt_tax_table_gl = '$businessPrint[pr_bus_opt_tax_table_gl]',
				fn_inv_opt_tax_table_rate = '$businessPrint[pr_bus_opt_tax_table_rate]',
				fn_inv_opt_tax_table_total = '$businessPrint[pr_bus_opt_tax_table_total]',
				fn_inv_opt_terms = '$businessPrint[pr_bus_opt_terms]',
				fn_inv_opt_terms_bus = '$businessPrint[pr_bus_opt_terms_bus]',
				fn_inv_tax_table_align = '$businessPrint[pr_bus_tax_table_align]',
				fn_inv_print_count = '-1'
			WHERE
				fn_invoice_ix = '$newInvoice'
		");

		array_push($invoiceArray,$newInvoice);
	}
	if($_POST['batchInvoicePrint'] == "1") {
		$GLOBALS['temp']['invoiceScript'] .= "
			<script language=\"javascript\">
				openPopup(\"reservation.php?642++1++".join("|",$invoiceArray)."++++++++++1\",645,518,0,0,0,0,\"ddd\");
			</script>
		";
	}
	$GLOBALS['temp']['startupList'] = "'" . join("','",$invoiceArray) . "'";
	if(sizeof($invoiceArray) > 1) {
		$GLOBALS['temp']['startupListTitle'] = sizeof($invoiceArray) . " invoices have been created:";
	} else {
		$GLOBALS['temp']['startupListTitle'] = sizeof($invoiceArray) . " invoice has been created:";
	}
}

// END   - Process any invoice requests

// Race condition below :p
$GLOBALS['temp']['todayD'] = date("d");
$GLOBALS['temp']['todayM'] = date("m");
$GLOBALS['temp']['todayY'] = date("Y");

if($_SERVER['argv'][4] == "regenReservation" || (isset($_POST['regenReservation']) && $_POST['regenReservation'] == "1")) {
	regenReservation($record);
	ammendReservation($record,"Regenerate All Itineraries");
	redirectTo(" reservation.php?".$_SERVER['argv'][0]."+".$record);
	die();
}


if(($_SERVER['argv'][4] == "regenTotals" || (isset($_POST['regenTotals']) && $_POST['regenTotals'] == "1"))) {
	regenBilling($record);
	ammendReservation($record,"Regenerate costs");
	ammendReservation($record,"Update payment plan");
	$GLOBALS[$form]->FormHTML = str_replace("</body>","<script>toggleFinTabs('Folios')</script></body>",$GLOBALS[$form]->FormHTML);
}
$GLOBALS['temp']['record'] = (string) $record;
$method = $_SERVER['argv'][2];
$showVoid = $_SERVER['argv'][7];
$GLOBALS['temp']['showVoidChecked'] = "";
if($showVoid == "1") {
	$GLOBALS['temp']['showVoidChecked'] = "checked";
}

if($method == "customPayPlan") {
	$payItemId = $_SERVER['argv'][3];
	$payAmnt = $_SERVER['argv'][4];
	$payDate = $_SERVER['argv'][5];
	if($payItemId != "0" && $payItemId != "1") {
		// Check for any payment plan items on the same date
		$checkPayPlanItem = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_pay_plan_item
			WHERE
				rv_reservation_id = '$record'
				AND rv_pay_plan_date = '$payDate'
				AND rv_pay_plan_item_ix != '$payItemId'
		",4);
		if($checkPayPlanItem > 0) {
			$GLOBALS['lDB']->put("DELETE FROM rv_pay_plan_item WHERE rv_pay_plan_item_ix = '$payItemId'");
			$payPlanItem = $GLOBALS['lDB']->get("
				SELECT
					rv_pay_plan_item_ix,
					rv_pay_plan_amount
				FROM
					rv_pay_plan_item
				WHERE
					rv_reservation_id = '$record'
					AND rv_pay_plan_date = '$payDate'
			",1);
			$payItemId = $payPlanItem['rv_pay_plan_item_ix'];
			$finalAmount = $payAmnt + $payPlanItem['rv_pay_plan_amount'];
			$GLOBALS['lDB']->put("UPDATE rv_pay_plan_item SET rv_pay_plan_amount = '$finalAmount' WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
		} else {
   	         $GLOBALS['lDB']->put("UPDATE rv_pay_plan_item SET rv_pay_plan_amount = '$payAmnt', rv_pay_plan_date = '$payDate' WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
		}
	} else {
		// Check for any payment plan items on the same date
		$checkPayPlanItem = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_pay_plan_item
			WHERE
				rv_reservation_id = '$record'
				AND rv_pay_plan_date = '$payDate'
		",4);
		if($checkPayPlanItem > 0) {
			$payPlanItem = $GLOBALS['lDB']->get("
				SELECT
					rv_pay_plan_item_ix,
					rv_pay_plan_amount
				FROM
					rv_pay_plan_item
				WHERE
					rv_reservation_id = '$record'
					AND rv_pay_plan_date = '$payDate'
			",1);
			$payItemId = $payPlanItem['rv_pay_plan_item_ix'];
			$finalAmount = $payAmnt + $payPlanItem['rv_pay_plan_amount'];
			$GLOBALS['lDB']->put("UPDATE rv_pay_plan_item SET rv_pay_plan_amount = '$finalAmount' WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
		} else {
			$GLOBALS['lDB']->put("
				INSERT INTO rv_pay_plan_item (
					rv_pay_plan_item_db,
					rv_pay_plan_amount,
					rv_pay_plan_date,
					rv_reservation_id
				) values (
					'$GLOBALS[dbcode]',
					'$payAmnt',
					'$payDate',
					'$record'
				)
			");
			$key = $GLOBALS['lDB']->insert_id;
		}
	}
	ammendReservation($record,"Edit payment plan item");
} elseif($method == "delPayPlan") {
	$payItemId = $_SERVER['argv'][3];
	$GLOBALS['lDB']->put("DELETE FROM rv_pay_plan_item WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
	ammendReservation($record,"Edit payment plan item");
}
$GLOBALS['editPayPlan'] = true;

if($method == "genPayPlan") {
	$acPayPlanId = $_SERVER['argv'][3];
	recalcTotals($record);
	genPaymentPlan($record, $acPayPlanId);
	ammendReservation($record,"Update payment plan");
} else {
	$acPayPlanId = $GLOBALS['lDB']->get("SELECT ac_pay_plan_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
}
if($pmode == "0") {
	// Generate listing of all default rate types
	$paymentPlan = getPayItems($record);
	$GLOBALS['temp']['payplanrows'] = "";
	$GLOBALS['temp']['isPayPlan'] = "1";
	$GLOBALS['temp']['payOutstanding'] = "";
	$GLOBALS['temp']['payedTotal'] = "";
	if ($action == "3") {
		$payplanHTML = join("\n", file(__DIR__ . "/../../../public/html/reservation_billing_payitem_rows.htm"));
	} else {
		if ($userStatusId > "1") {
			$payplanHTML = join("\n", file(__DIR__ . "/../../../public/html/reservation_billing_payitem_rows.htm"));
		} else {
			$payplanHTML = join("\n", file(__DIR__ . "/../../../public/html/cal_step3_payitem_rows.htm"));
		}
	}

	for($a = 0; $a < sizeof($paymentPlan['items']); $a++) {
		if($action == "1" && $method != "customPayPlan") {
			$paymentPlan['items'][$a]['hideShowDel'] = " style=\"visibility:hidden\" ";
		}
		$payplanData = $paymentPlan['items'][$a];
		$payplanData['style'] = $GLOBALS['temp']['payplanStyle'];

		$GLOBALS['temp']['payplanrows'] .= showpage($payplanData, $payplanHTML);
	}
	if($GLOBALS['temp']['payplanrows'] == "") {
		$GLOBALS['temp']['payplanrows'] .= "<tr><td height='25' colspan='3' class='txtbr txti'>No pay items allocated</td></tr>";
		$GLOBALS['temp']['isPayPlan'] = "0";
	}
	$payedHTML = join("\n", file(__DIR__ . "/../../../public/html/reservation_billing_payed_rows.htm"));
	$goClick = false;
	if (checkJob("298")) $goClick = true;
	$GLOBALS['temp']['payedrows'] = "";
	for($a = 0; $a < sizeof($paymentPlan['payments']); $a++) {
		$payplanData = $paymentPlan['payments'][$a];

		if(!empty($payplanData['rv_payment_gateway_id'])) {
			$payments = db_rv_payment_gateway_get_by_reservation($payplanData['rv_reservation_id']);
			if(sizeof($payments) > 0) {
				$payment = $payments[0];
			} else {
				$payment = array(
					'status'=>"unknown",
					'pg_acc_name'=>"unknown",
					'rv_payment_gateway_ref'=>"unknown",
					'rv_payment_gateway_amt_paid'=>"unknown",
					'rv_payment_gateway_amt_req'=>"unknown",
					'rf_currency_symbol'=>"unknown"
				);
			}
			$payplanData['rv_pmnt_note_action'] = "event.cancelBubble = true; openPopup('reservation.php?1008+$payplanData[rv_reservation_id]',750,520);";
			$payplanData['rv_pmnt_note_short'] = "Payment $payment[status] via $payment[pg_acc_name] gateway.<br /><br />Reference: $payment[rv_payment_gateway_ref]<br />Amount req: $payment[rv_payment_gateway_amt_req]$payment[rf_currency_symbol]<br />Amount paid: $payment[rv_payment_gateway_amt_paid]$payment[rf_currency_symbol]";
			$payplanData['hidePayBut'] = "button bNote";
		} else {
			$payplanData['rv_pmnt_note_action'] = "openPayNote('!rv_pmnt_note!','Payment');";
			$payplanData['rv_pmnt_note_short'] = $payplanData['rv_pmnt_note'];
			if(strlen($payplanData['rv_pmnt_note']) > 100) {
				$payplanData['rv_pmnt_note_short'] = substr($payplanData['rv_pmnt_note'],0,100)."..";
			}
		}
		$payplanData['clickThrough'] = "";
		if($goClick) $payplanData['clickThrough'] = " style=\"cursor:pointer\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"window.location='/reservation.php?298+".$payplanData['rv_payment_ix']."+".$payplanData['rv_reservation_id']."'\"";
		$editClass = "";
		$canEdit = canEditDB($payplanData['rv_payment_item_db']) || ($GLOBALS['dbcode'] == $payplanData['rv_payment_item_db'] && $payplanData['rv_payment_item_trf_yn'] == "0" && $GLOBALS['dbcode'][0] != "W");
		if(!$canEdit) $editClass = "txtg";
		$payplanData['editClass'] = $editClass;
		$payplanData['tran_button'] = "";
		$tranCheck = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				fn_tran
			WHERE
				fn_tran.fn_tran_link_ind <> ".DB_FN_TRAN_LINK_INVOICE."
				AND fn_tran.fn_tran_link_id = '$payplanData[rv_payment_item_ix]'
		",4);
		if($tranCheck > 0) {
			$payplanData['tran_button'] = "<input type=\"button\" class=\"button bReport16\" style=\"width:20px; height 20px;\" value=\"   \" onclick=\"showTran(1,'$payplanData[rv_payment_item_ix]');\"/>";
		}

        $payplanData['fn_invoice_overlib'] = "";
		if(isset($payplanData['fn_invoice_ix']) && $payplanData['fn_invoice_ix'] != "" ){
            $payplanData['fn_invoice_overlib'] = "onmouseout=\"nd()\" onmouseover=\"overlib('Invoice: ". t_encodeOverlib($payplanData['fn_invoice_ix']) ."<br/>To: " . t_encodeOverlib($payplanData['pr_name_last']) . "<br/>',WIDTH,200)\"";
        }

        $GLOBALS['temp']['payedrows'] .= showpage($payplanData, $payedHTML);
	}
	if($GLOBALS['temp']['payedrows'] == "") {
         $GLOBALS['temp']['payedrows'] .= "<tr><td height='25' colspan='13' class='txtbr txti'>No payments recorded</td></tr>";
	}
	$GLOBALS['temp']['payOutstanding'] = $paymentPlan['outstanding'];
	$GLOBALS['temp']['payedTotal'] = $paymentPlan['payedTotal'];
	fixAmtDisplay($GLOBALS['temp']['payOutstanding']);
	fixAmtDisplay($GLOBALS['temp']['payedTotal']);
}

$GLOBALS['temp']['hideRatePopup'] = "";
if($userStatusId == 0) {
	$GLOBALS['temp']['hideRatePopup'] = " style=\"visibility:hidden\"";
}

$GLOBALS['temp']['payment'] = $_SERVER['argv'][6];

// Generate dropdown of all valid rate types
$GLOBALS[$form]->AddField($form."_sysPayPlanId", "sysPayPlanId", $acPayPlanId, 3);
$GLOBALS[$form.'_sysPayPlanId']->Select(combolist($GLOBALS['lDB'], "
	SELECT
		ac_pay_plan_ix,
		IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc)
	FROM
		ac_pay_plan
	WHERE
		ac_pay_plan.ac_pay_plan_inactive_yn = 0
		OR ac_pay_plan.ac_pay_plan_ix = '$acPayPlanId'
	ORDER BY
		ac_pay_plan_desc
"));
$GLOBALS[$form.'_sysPayPlanId']->TabIndex = 16;
$GLOBALS[$form.'_sysPayPlanId']->StyleType = "txt";
$GLOBALS[$form.'_sysPayPlanId']->onChange = "return;";
// rsUpdate, refresh the default rate dropdown and the default rate listing
$method = $_SERVER['argv'][2];
if ($method == "genPayPlan" || $method == "customPayPlan" || $method == "delPayPlan") {
	$listOut = "
		<table width='100%' cellspacing='0' cellpadding='0' id='payPlan'>
		<tr>
			<td class='outLt' width='85%'>&nbsp;Date Due</td>
			<td class='outLt' colspan='2' align='right'>Amount&nbsp;</td>
		</tr>".$GLOBALS['temp']['payplanrows']."
		</table>
	";
	// Declare host variables
	$rsUpdateInnerHTML = array();
	$rsUpdateValue = array();
	$rsUpdateVar = array();
	$rsFuncList = array();
	// Add values to arrays
	$rsUpdateInnerHTML['payplanrows'] = $listOut;
	$rsUpdateValue['payOutstanding'] = $GLOBALS['temp']['payOutstanding'];
	$rsUpdateValue['payedTotal'] = $GLOBALS['temp']['payedTotal'];
	array_push($rsFuncList, "togglePayPlanButton");
	array_push($rsFuncList, "''");
	array_push($rsFuncList, "effectPayPlanChange");
	array_push($rsFuncList, "'".$GLOBALS['temp']['isPayPlan']."'");
	$rsUpdateVar["diff"] = $GLOBALS['temp']['diff'];
	// Output RS response

	echo rsOutput($rsUpdateInnerHTML, $rsUpdateValue, $rsUpdateVar, $rsFuncList);
	die();
}

$docTitle = getDocTitle($record);
$GLOBALS['temp']['proforma'] = $docTitle['docTitle'];
$GLOBALS['temp']['proformaBut'] = $docTitle['docTitle'];
if(strlen($GLOBALS['temp']['proformaBut']) < 25) {
	$GLOBALS['temp']['proformaBut'] = substr($GLOBALS['temp']['proformaBut'], 0, 25);
} else {
	$GLOBALS['temp']['proformaBut'] = substr($GLOBALS['temp']['proformaBut'], 0, 25)."...";
}
$resExtraJob = "609";
if (checkJob($_SERVER['argv'][0], 610) > 5) {
	$resExtraJob = "610";
}
$GLOBALS['temp']['extrajob'] = "/reservation.php?$resExtraJob+$record";

$GLOBALS['temp']['notesTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['notesDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][138])) {
	$GLOBALS['temp']['notesTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['notesDisabled'] = "disabled";
}

$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['roomingDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][215])) {
	$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['roomingDisabled'] = "disabled";
}

$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['financialDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][646])) {
	$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['financialDisabled'] = "disabled";
}

$GLOBALS['temp']['resDocumentJob'] = "/reservation.php?642+".$record;

if (
	array_key_exists(137,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][137] > 5 &&	// Reservation Notes Add Note
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['resnotejob'] = "/reservation.php?137+".$record;
} else {
	$GLOBALS['temp']['resnotejob'] = "/reservation.php?138+".$record;
}

if (
	array_key_exists(216,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][216] > 5 &&	// Edit rooming tab
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['resRoomJob'] = "/reservation.php?216+".$record;
} else {
	$GLOBALS['temp']['resRoomJob'] = "/reservation.php?215+".$record;
}

if (
	array_key_exists(2,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][2] > 5 &&		// Edit reservation form
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['resjob'] = "/reservation.php?2+$record";
} else {
	$GLOBALS['temp']['resjob'] = "/reservation.php?0+$record";
}

# Display/hide notes icon
$GLOBALS['temp']['nflag'] = "noNotes";
$nflag = $GLOBALS['lDB']->get("SELECT rv_note_general FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
$iflag = $GLOBALS['lDB']->get("SELECT rv_note_internal FROM rv_reservation WHERE rv_reservation_ix = '$record'", 4);
$gflag = $GLOBALS['lDB']->get("SELECT rv_note_guests FROM rv_reservation WHERE rv_reservation_ix = '$record'", 4);
if($_SESSION['userStatusId'] > 1) {
	if(((strlen(trim($nflag)) > 0) || (strlen(trim($iflag)) > 0) || (strlen(trim($gflag)) > 0)) && $action != "2") {
		$GLOBALS['temp']['nflag'] = "notes";
	}
} else {
	if (((strlen(trim($nflag)) > 0) || (strlen(trim($gflag)) > 0)) && $action != "2") {
		$GLOBALS['temp']['nflag'] = "notes";
	}
}
$GLOBALS['temp']['eflag'] = "noExtras";
$sql = "SELECT COUNT(*) FROM rv_extra WHERE rv_reservation_id = '$record'";
$eflag = $GLOBALS['lDB']->get($sql, 1);
if ($eflag[0] > 0) {
	$GLOBALS['temp']['eflag'] = "extras";
}

$GLOBALS['temp']['rtabflag'] = "";
$rtabflag = getReservationRooming($record);
if(sizeof($rtabflag['guests']) > 0 || sizeof($rtabflag['rooms']) > 0){
	$GLOBALS['temp']['rtabflag'] = "signal_cellular_4_bar";
}

$ctabflag = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM em_mail INNER JOIN em_mail_log ON em_mail.em_mail_ix = em_mail_log.em_mail_id WHERE em_action = '-1' AND rv_reservation_id LIKE '$record'",4);
$commProvCheck = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ad_reservation WHERE ad_reservation.rv_reservation_id LIKE '$record' AND ad_reservation.ad_res_form = 'Sent Prov Notification'",4);
$GLOBALS['temp']['ctabflag'] = "";
if($ctabflag > 0 || $commProvCheck > 0) {
	$GLOBALS['temp']['ctabflag'] = "bEmail";
}

$remSQL = "SELECT COUNT(*) FROM re_reminder WHERE re_reminder_link_to_ind_id = '1' AND re_reminder_link_to_id  = '{$record}'";
$GLOBALS['temp']['retabflag'] = ($GLOBALS['lDB']->get($remSQL,4) > 0 ) ? "show" : "";

// Details for the Itinerary Summary Popup in functions.reservation.php
getItinSummary($record);
$roomCheckIn = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '5'
",4);

$roomCheckOut = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '8'
",4);

$GLOBALS['temp']['rflag'] = "bRoomNone";

if($roomCheckIn > 0 || $roomCheckOut > 0) {
	$roomCheckTime = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_group.rv_grp_status_time
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
			AND (
				rv_res_item_group.rv_grp_status_ind = '5'
				OR rv_res_item_group.rv_grp_status_ind = '8'
			)
		ORDER BY
			rv_res_item_group.rv_grp_status_time DESC
	",4);
}
if($roomCheckIn > 0) {
	$GLOBALS['temp']['rflag'] = "bRoomIn";
}
if($roomCheckOut > 0) {
	$GLOBALS['temp']['rflag'] = "bRoomOut";
}

$pCommDeduct = isset($_POST['rv_commission_deduct_yn'])?$_POST['rv_commission_deduct_yn']:"";
$pExchgRate = isset($_POST['rv_exchg_rate'])?$_POST['rv_exchg_rate']:"";
$pCommPerc = isset($_POST['rv_commission_perc'])?$_POST['rv_commission_perc']:"";
$GLOBALS[$form]->Get($action);

if ($record != "" || $action == "3" && $action != "1") {
	$table = $GLOBALS[$form]->TableList[0];
	$GLOBALS[$table]->Refresh($_SERVER['argv'][1], $action);
}

if ($pmode == "1") {
	if (($pCommDeduct != $GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn']->Value)
		|| ($pExchgRate != $GLOBALS[$form.'_rv_reservation_rv_exchg_rate']->Value)
		|| ($pCommPerc != $GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Value)
	) {
		$GLOBALS['RECALCTOTALS'] = "1";
      }
}

if ($pExchgRate != $GLOBALS[$form.'_rv_reservation_rv_exchg_rate']->Value && $pmode == "1" && trim($pExchgRate) != "" ) {
	$invCurr = $_POST['rv_invoice_currency_id'];
	$rateId = $_POST['rateSelect'];
	if ($rateId == "") {
		$rateId = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
	}
	$rateCurr = $GLOBALS['lDB']->get("SELECT rf_currency_id FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix = '$rateId'",4);
	if ($rateCurr != $invCurr) {
		db_rf_exchange_rate_set($rateCurr,$invCurr,$pExchgRate);
	}
	$moduleFieldValues[] = array('rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_exchg_rate");
}

if ($pmode == "0") {
	$agentName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '".$GLOBALS[$form.'_rv_reservation_rv_agent_id']->Value."'",4);
	$GLOBALS[$form]->AddField("agent_name", "agent_name", $agentName, 0);
	$GLOBALS['agent_name']->Size = "30";
	$GLOBALS['agent_name']->Width = "180";
	$GLOBALS['agent_name']->StyleType = "txt";
	if($GLOBALS['agent_name']->Value == "0") {
		$GLOBALS['agent_name']->Value = "Direct";
		$GLOBALS['temp']['hideAgentButtons'] = " visibility:hidden; ";
	}

	$optionalCount = $GLOBALS['lDB']->get("
		SELECT
			count(rv_res_item_comp_id)
		FROM
			rv_res_item_comp
			INNER JOIN rt_component ON rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
			AND rv_item_comp_option_yn = '1' ORDER BY rt_component.rt_component_desc
	",4);

	$optionMessage = "";
	if($optionalCount > 0) {
		$optionMessage = " This reservation has optional services allocated which will be lost!";
	}
	$GLOBALS['temp']['optionMessage'] = $optionMessage;
	$GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn']->Select(array("0" => "0:|:Gross", "1" => "1:|:Nett"));
	$GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn']->StyleType = "txt";
	$GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn']->Width = "60";

	$GLOBALS[$form.'_rv_reservation_rv_folio_level_ind']->Select(array("0"=>"1:|:Business Level","1"=>"3:|:Group (room) Level"));
	$GLOBALS[$form.'_rv_reservation_rv_folio_level_ind']->StyleType = "txt";
	$GLOBALS[$form.'_rv_reservation_rv_folio_level_ind']->Width = "180";

	$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Select(combolist($GLOBALS['lDB'],"
		SELECT
			rf_currency_ix,
			IF(rf_currency_inactive_yn <> 0,CONCAT('* ',rf_currency_name),rf_currency_name) as rf_currency_name
		FROM
			rf_currency
		WHERE
			rf_currency_inactive_yn = 0
			OR (
				rf_currency_inactive_yn <> 0
				AND rf_currency_ix = '".$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Value."'
			)
		ORDER BY
			rf_currency.rf_currency_name
	"));
	$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->onChange = "checkInvCurr()";
	$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Width = "";
	$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->StyleType = "txt";
	$GLOBALS['temp']['oldInvCurrId'] = $GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Value;
	$GLOBALS['temp']['oldCommission'] = $GLOBALS['lDB']->escape($GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Value);
	$GLOBALS['temp']['invCurr'] = $GLOBALS['lDB']->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '".$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Value."'",4);

	$billingContact = getPersona("pr_name_last, pr_name_first", $GLOBALS[$form.'_rv_reservation_rv_billing_persona_id']->Value, 1);
	$billingContact = trim($billingContact['pr_name_first']." ".$billingContact['pr_name_last']);
	$GLOBALS[$form]->AddField("billing_contact", "billing_contact", $billingContact, 0);
	$GLOBALS['billing_contact']->Width = "180";
	if($GLOBALS['billing_contact']->Value == "0" || $GLOBALS['billing_contact']->Value == "") {
		$GLOBALS['billing_contact']->Value = "Cash";
	}
	$GLOBALS['billing_contact']->StyleType = "txt";
	$invoiceContact = getPersona("pr_name_last, pr_name_first", $GLOBALS[$form.'_rv_reservation_rv_invoice_persona_id']->Value, 1);
	$invoiceContact = trim($invoiceContact['pr_name_first']." ".$invoiceContact['pr_name_last']);
	$GLOBALS[$form]->AddField("invoice_contact", "invoice_contact", $invoiceContact, 0);
	$GLOBALS['invoice_contact']->Width = "180";
	if($GLOBALS['invoice_contact']->Value == "0" || $GLOBALS['invoice_contact']->Value == "") {
		$GLOBALS['invoice_contact']->Value = "Cash";
	}
	$GLOBALS['invoice_contact']->StyleType = "txt";
	$allocCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation_item AS link_item ON rv_reservation_item.rv_reservation_item_ix = link_item.rv_link_res_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
	",4);
	if($allocCount > 0) {
		$GLOBALS['temp']['hideAgentSearchCell'] = " onmouseover=\"overlib('The agent cannot be changed as there are allocation draw downs on this reservation.');\" onmouseout=\"nd();\" ";
		$GLOBALS['temp']['hideAgentSearchButton'] = " display: none; ";
	}
	if($action == "1") {
		$GLOBALS['temp']['hideAgentSearch'] = " style=\"visibility:hidden;\"";
		$GLOBALS['temp']['hideSearchButtons'] = " style=\"visibility:hidden;\"";
		$GLOBALS['temp']['hideAgentButtons'] = " visibility:hidden;";
		$GLOBALS['agent_name']->Width = "180";
		$GLOBALS['billing_contact']->Width = "180";
		$GLOBALS['invoice_contact']->Width = "180";
	}
	$GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Size = "5";
	$GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Width = "60";
	$GLOBALS[$form.'_rv_reservation_rv_commission_perc']->StyleType = "txtR";
	$GLOBALS[$form]->AddField("echange_display", "echange_display", $GLOBALS[$form.'_rv_reservation_rv_exchg_rate']->Value, 1);
	$GLOBALS['echange_display']->Size = "11";
	$GLOBALS['echange_display']->StyleType = "txtR";
	if($GLOBALS[$form.'_rv_reservation_rv_exchg_rate']->Value == "1.0000") {
		$GLOBALS['echange_display']->Value = "None";
	}
	$GLOBALS['temp']['exch_expiry'] = "";
	$GLOBALS['temp']['expiryFlag'] = "0";
	if($GLOBALS['echange_display']->Value != "None") {
		$value = $GLOBALS[$form.'_rv_reservation_rv_exchg_expiry_date']->Value;
		$exch_expiry = explode("-",$value);
		$GLOBALS['temp']['exchY'] = $exch_expiry[0];
		$GLOBALS['temp']['exchM'] = $exch_expiry[1];
		$GLOBALS['temp']['exchD'] = $exch_expiry[2];
		$GLOBALS['temp']['exch_expiry'] = $value;
		if ($GLOBALS[$form.'_rv_reservation_rv_exchg_expiry_date']->Value < date("Y-m-d")) {
			$GLOBALS['temp']['expiryFlag'] = "1";
		}
	}
	$GLOBALS['temp']['exchTableVis'] = "hidden";
	if ($action != "2" && $record != "" && $GLOBALS['echange_display']->Value != "None") {
		$GLOBALS['temp']['exchTableVis'] = "visible";
	}
	$GLOBALS[$form.'_rv_reservation_rv_exchg_rate']->Varname = "rv_extra_exch_rate";
	$GLOBALS[$form.'_rv_reservation_rv_exchg_expiry_date']->Varname = "rv_extra_exch_expiry";
}

if ($pmode == "1") {
	$GLOBALS[$form.'_rv_reservation_rv_date_changed']->SetValue(date("Y-m-d"));
}

// Start table control
$table = $GLOBALS[$form]->TableList[0];
$hideList = array($form."_rv_reservation_rv_exchg_rate", $form."_rv_reservation_rv_exchg_expiry_date", $form."_rv_reservation_rv_invoice_persona_id", $form."_rv_reservation_rv_billing_persona_id", $form."_rv_reservation_rv_agent_id");
$GLOBALS[$form]->Hide($hideList);
$disableList = array("agent_name", "echange_display");
array_push($disableList, "billing_contact");
array_push($disableList, "invoice_contact");
if ($isInternal != "true") {
	array_push($disableList, $form."_rv_reservation_rv_commission_deduct_yn");
	array_push($disableList, $form."_rv_reservation_rv_commission_perc");
	array_push($disableList, $form."_rv_reservation_rv_invoice_currency_id");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_commission_deduct_yn");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_commission_perc");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_invoice_currency_id");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_exchg_rate");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_exchg_expiry_date");
}
$GLOBALS['temp']['hideExchButtons'] = "collapse printCollapse";
if ($action == "3") {
	$GLOBALS['temp']['hideExchButtons'] = "button bSetExch printCollapse";
}

// Get environment dbcode list
$resDBCode = $GLOBALS['lDB']->get("SELECT rv_reservation_db FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
$envIndex = $GLOBALS['lDB']->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '$resDBCode'",4);
if($envIndex == "4") {
	$checkCodes = array($resDBCode);
} else {
	$checkCodes = $GLOBALS['lDB']->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
}

$result = $GLOBALS['lDB']->get("
	SELECT
		SUM(rv_payment_item.rv_payment_item_amt) AS SumOfrv_payment_item_amt
	FROM
		rv_payment_item
	WHERE
		rv_payment_item.rv_reservation_id='$record'
	GROUP BY
		rv_payment_item.rv_reservation_id
",4);
$invCount = $GLOBALS['lDB']->get("
	SELECT
		COUNT(fn_invoice_id)
	FROM
		fn_invoice
	WHERE
		rv_reservation_id = '$record'
		AND fn_invoice.fn_invoice_db IN ('".join("','",$checkCodes)."')
		AND fn_invoice.fn_inv_status_ind <> 8
",4);
if($invCount != 0) {
	array_push($disableList, $form."_rv_reservation_rv_commission_perc");
	array_push($disableList, $form."_rv_reservation_rv_commission_deduct_yn");
}

$GLOBALS['temp']['bl_block_ix'] = "";
$GLOBALS['temp']['bl_block_name'] = "";
$GLOBALS['temp']['hideRateTypeSearchCell'] = "";
$blockDetails = $GLOBALS['lDB']->get("
	SELECT
		bl_block.bl_block_ix,
		bl_block.bl_block_name
	FROM
		bl_block
		INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
		LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
		LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
		LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
	WHERE
		draw_down_item.rv_reservation_id = '$record'
",1);
$hideRateType = "";
if (!empty($blockDetails)) {
	$GLOBALS['temp']['bl_block_ix'] = $blockDetails['bl_block_ix'];
	$GLOBALS['temp']['bl_block_name'] = $blockDetails['bl_block_name'];
}
$rateSelectButton = "";
if ($action == "3") {
	$rateSelectButton = "
	<button class=\"button txts\" type=\"button\" style=\"width: 20px; height: 20px; padding: 0px; vertical-align: top; $hideRateType\" onclick=\"rateDropdownShow();\">
	<i class=\"material-icons\">search</i>
	</button>
";
}
if ( ($result != "0" && $result != "") || $invCount > 0) {
	$rateSelectButton = "";
	array_push($disableList, $form."_rv_reservation_rv_invoice_currency_id");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_invoice_currency_id");
}

$rateId = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
if(trim($rateId) == "" || $rateId == "0") {
	$rateId = $GLOBALS['lDB']->get("
		SELECT
			pr_agent_rate.rt_rate_type_id
		FROM
			pr_agent_rate
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
		WHERE
			pr_agent_id = '$calAgentId'
		ORDER BY
			pr_agent_rate_default_yn DESC,
			rt_rate_type.rt_rate_type_desc ASC
	",4);
	if(trim($rateId) == "" || $rateId == "0") {
		$rateId = $GLOBALS['lDB']->get("select rt_rate_type_id from rf_default", 4);
	}
}
$rateInfo = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol,
		rt_rate_type.rf_currency_id
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_ix = '$rateId'
",1);

$hasRateOverride = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_reservation_item
	WHERE
		rv_reservation_item.rv_reservation_id = '" . $GLOBALS['lDB']->escape($record) . "'
		AND rv_reservation_item.rt_rate_type_id != '" . $GLOBALS['lDB']->escape($rateId) . "'
",4) > 0;
$rateOverrideIndicator = "";
if($hasRateOverride) {
	$rateOverrideIndicator = "<i style=\"width: 20px; height:20px; padding:0px; vertical-align: top;\" class=\"material-icons text-red warning\" onmouseover=\"overlib('Itineraries with different rates exist.');\" onmouseout=\"nd();\">warning</i>";
}


$GLOBALS['temp']['commOverrideCount'] = $lDB->get("
	SELECT
		COUNT(*)
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		rv_reservation_item.rv_reservation_id = '" . $lDB->escape($record) . "'
		AND rv_reservation.rv_commission_perc != rv_reservation_item.rv_item_comm_perc
",4);
$GLOBALS['temp']['rateOverrideCount'] = $lDB->get("
	SELECT
		COUNT(*)
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		rv_reservation_item.rv_reservation_id = '" . $lDB->escape($record) . "'
		AND rv_reservation.rt_rate_type_id != rv_reservation_item.rt_rate_type_id
",4);

$GLOBALS['temp']['rateSelect'] = "
	<input type=\"text\" disabled id=\"rateSelectLabel\" value=\"$rateInfo[rt_rate_type_desc], $rateInfo[rf_currency_symbol]\" />
	$rateSelectButton
	$rateOverrideIndicator
	<input type=\"hidden\" name=\"rateSelect\" id=\"rateSelect\" value=\"$rateId\" />
	<input type=\"hidden\" name=\"rateSelectCurrency\" id=\"rateSelectCurrency\" value=\"$rateInfo[rf_currency_id]\" />
	<input type=\"hidden\" name=\"rateSelectType\" id=\"rateSelectType\" value=\"all\" />
";

$hasCommissionOverride = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_reservation_item
	WHERE
		rv_reservation_item.rv_reservation_id = '" . $GLOBALS['lDB']->escape($record) . "'
		AND rv_reservation_item.rv_item_comm_perc != '" . $GLOBALS['lDB']->escape($GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Value) . "'
",4) > 0;
$commissionOverrideIndicator = "";
if($hasCommissionOverride) {
	$commissionOverrideIndicator = "<i style=\"width: 20px; height:20px; padding:0px; vertical-align: top;\" class=\"material-icons text-red warning\" onmouseover=\"overlib('Itineraries with different commissions exist.');\" onmouseout=\"nd();\">warning</i>";
}
$GLOBALS['temp']['commissionOverrideIndicator'] = $commissionOverrideIndicator;

$GLOBALS[$form]->Disable($disableList);
$GLOBALS['temp'] = array_merge($GLOBALS['temp'], getResDocTotals($record, "", "", "", "1"));
// end totals
// Start generate folio / invoice tab
// FIXME: This should be done at the folio level
$invoiceDefault = $GLOBALS['lDB']->get("SELECT rf_invoice_date FROM rf_default",4);
if($invoiceDefault == 1) { // Depatrue
	$dateSelect = "rv_reservation.rv_date_depart as resDate";
} else {
	$dateSelect = "rv_reservation.rv_date_arrive as resDate";
}
$invoiceDateDefault = $GLOBALS['lDB']->get("SELECT $dateSelect FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
$GLOBALS['temp']['invoiceDate'] = $invoiceDateDefault;

$busList = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix,
		pr_business.pr_bus_home_curr_id,
		rf_currency.rf_currency_symbol,
		IF (pr_business.fiscalator_key != '', 1, 0) as pr_business_fiscalise
	FROM
		pr_business
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		INNER JOIN rf_currency ON rf_currency_ix = pr_business.pr_bus_home_curr_id
	WHERE
		pr_bus_billing_yn = '1'
		OR pr_bus_billing_prop_yn = '1'
	ORDER BY
		pr_business_sequence
",2);

foreach($busList as $key=>$item) {
	$folioList = $GLOBALS['lDB']->get("
		SELECT
			fn_folio.fn_folio_ix,
			fn_folio.fn_folio_folio_num,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			rf_title.rf_title_desc,
			rf_name_suffix.rf_suffix_desc,
			fn_folio.rf_currency_id,
			rf_currency.rf_currency_symbol,
			fn_folio.fn_folio_db,
			fn_folio.fn_folio_trf_yn,
			ac_accomm_room.ac_desc,
			rv_reservation.rf_reservation_status_id,
			fn_folio.fn_folio_date
		FROM
			fn_folio
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
			LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
			LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			fn_folio.rv_reservation_id = '$record'
			AND fn_folio.pr_business_id = '$item[pr_persona_ix]'
			AND (
				fn_folio.fn_invoice_id = ''
				OR fn_folio.fn_invoice_id = '0'
				OR fn_folio.fn_invoice_id IS NULL
			)
		ORDER BY
			fn_folio_folio_num
	",2);
	$busList[$key]['folioList'] = $folioList;
	foreach($folioList as $folioKey=>$folioItem) {
		$hasTBA = false;
		$busList[$key]['folioList'][$folioKey]['pr_business_fiscalise'] = $busList[$key]['pr_business_fiscalise'];
		$busList[$key]['folioList'][$folioKey]['paymentTotal'] = $GLOBALS['lDB']->get("
			SELECT
				SUM(rv_payment_item_amt)
			FROM
				rv_payment_item
			WHERE
				fn_folio_id = '$folioItem[fn_folio_ix]'
		",4);
		fixAmtDisplay($busList[$key]['folioList'][$folioKey]['paymentTotal']);
		$folioPrName = trim($folioItem['pr_name_last']);
		if($folioItem['rf_suffix_desc'] != ""){
			$folioPrName .= " ".$folioItem['rf_suffix_desc'];
		}
		if(trim($folioItem['pr_name_first']) != ""){
			if($folioPrName != ""){
				$folioPrName .= ", ";
			}
			$folioPrName .= $folioItem['pr_name_first'];
		}
		if($folioItem['rf_title_desc'] != ""){
			$folioPrName .= " ".$folioItem['rf_title_desc'];
		}
		$busList[$key]['folioList'][$folioKey]['pr_name'] = $folioPrName;
		if($busList[$key]['folioList'][$folioKey]['pr_name'] == "") {
			$busList[$key]['folioList'][$folioKey]['pr_name'] = "Cash";
		}
		$busList[$key]['folioList'][$folioKey]['pr_name_extra'] = "";
		if(trim($folioItem['ac_desc']) != "") {
			$busList[$key]['folioList'][$folioKey]['pr_name_extra'] .= " (<b>".t_encodeHTMLField($folioItem['ac_desc'])."</b>)";
		}
		$exclTotal = 0;
		$taxTotal = 0;
		$payableTotal = 0;
		$accommAll = $GLOBALS['lDB']->get("
			SELECT
				'Accommodation' as rt_component_desc,
				SUM(rv_res_item_comp.rv_item_comp_amt_comm) as rv_item_comp_amt_comm,
				SUM(rv_res_item_comp.rv_item_comp_amt_gross) as rv_item_comp_amt_gross,
				SUM(rv_res_item_comp.rv_item_comp_amt_nett) as rv_item_comp_amt_nett,
				SUM(rv_res_item_comp.rv_item_comp_amt_payable) as rv_item_comp_amt_payable,
				SUM(rv_res_item_comp.rv_item_comp_amt_tax) as rv_item_comp_amt_tax,
				rv_reservation.rv_commission_deduct_yn,
				rv_res_item_comp.rv_item_comp_tax_perc,
				COUNT(rv_res_item_comp.rv_res_item_comp_id) as accommCount,
				COUNT(rv_reservation_item.rv_reservation_item_ix) as itemCount,
				rv_res_item_comp.rv_item_comp_separate_yn,
				IF(rv_res_item_comp.rt_tax_ind = 10, rf_tax_rate.rf_tax_rate_desc, rt_tax_group.rt_tax_group_desc) AS taxDesc
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp.rt_tax_id
				LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_res_item_comp.rt_tax_id
			WHERE
				rv_reservation_item.fn_folio_id = '$folioItem[fn_folio_ix]'
				AND (
					rv_res_item_comp.rv_item_comp_separate_yn = 0
					OR rt_component.rt_component_id IS NULL
				)
			GROUP BY
				rv_reservation_ix,
				rv_res_item_comp.rt_tax_id
		",2);

		$accommList = $GLOBALS['lDB']->get("
			SELECT
				rt_component.rt_component_desc AS rt_component_desc,
				rv_res_item_comp.rv_item_comp_tax_perc,
				SUM(rv_res_item_comp.rv_item_comp_amt_gross) as rv_item_comp_amt_gross,
				SUM(rv_res_item_comp.rv_item_comp_amt_nett) as rv_item_comp_amt_nett,
				SUM(rv_res_item_comp.rv_item_comp_amt_payable) as rv_item_comp_amt_payable,
				SUM(rv_res_item_comp.rv_item_comp_amt_tax) as rv_item_comp_amt_tax,
				rv_reservation.rv_commission_deduct_yn,
				rv_res_item_comp.rv_item_comp_separate_yn,
				IF(rv_res_item_comp.rt_tax_ind = 10, rf_tax_rate.rf_tax_rate_desc, rt_tax_group.rt_tax_group_desc) AS taxDesc
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp.rt_tax_id
				LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_res_item_comp.rt_tax_id
			WHERE
				rv_reservation_item.fn_folio_id = '$folioItem[fn_folio_ix]'
				AND rv_res_item_comp.rv_item_comp_separate_yn = 1
			GROUP BY
				rv_res_item_comp.rt_component_id,
				rv_res_item_comp.rt_tax_id
			ORDER BY rt_component_desc DESC
		",2);

		foreach($accommAll as $accommKey=>$accommItem) {
			if($accommItem['accommCount'] == 0 && $accommItem['itemCount'] > 0) {
				$accommAll[$accommKey]['rt_component_desc'] = "Accommodation";
				$accommAll[$accommKey]['rv_item_comp_amt_comm'] = "TBA";
				$accommAll[$accommKey]['rv_item_comp_amt_gross'] = "TBA";
				$accommAll[$accommKey]['rv_item_comp_amt_nett'] = "TBA";
				$accommAll[$accommKey]['rv_item_comp_amt_payable'] = "TBA";
				$accommAll[$accommKey]['rv_item_comp_amt_tax'] = "TBA";
				$accommAll[$accommKey]['rv_item_comp_tax_perc'] = "0.00";
				$hasTBA = true;
			}
		}
		if(sizeof($accommAll) > 0) {
			$accommList = array_merge($accommList,$accommAll);
		}
		foreach($accommList as $accommKey=>$accommItem) {
			if($accommItem['rv_commission_deduct_yn'] == 1) {
				$total = $accommItem['rv_item_comp_amt_nett'];
			} else {
				$total = $accommItem['rv_item_comp_amt_gross'];
			}
			$accommList[$accommKey]['rv_item_comp_amt_payable'] = $total;
			$accommList[$accommKey]['rv_item_comp_amt_excl'] = $total - $accommItem['rv_item_comp_amt_tax'];
			$exclTotal += ($total - $accommItem['rv_item_comp_amt_tax']);
			$taxTotal += $accommItem['rv_item_comp_amt_tax'];
			$payableTotal += $total;
			if($accommList[$accommKey]['rv_item_comp_amt_payable'] != "TBA") {
				fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_payable'],2);
				$accommList[$accommKey]['rv_item_comp_amt_tax'] = round($accommList[$accommKey]['rv_item_comp_amt_tax'],2);
				fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_tax'],2);
				fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_nett'],2);
				fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_gross'],2);
				fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_excl'],2);
			} else {
				$accommList[$accommKey]['rv_item_comp_amt_excl'] = "TBA";
			}
		}
		$busList[$key]['folioList'][$folioKey]['accommList'] = $accommList;

		$extraList = $GLOBALS['lDB']->get("
			SELECT
				ac_extra.ac_ext_desc,
				rv_extra.rv_extra_tax_perc,
				rv_extra.rv_extra_amt_gross,
				rv_extra.rv_extra_amt_nett,
				rv_extra.rv_extra_ix,
				(
					SELECT SUM(rv_extra_tax_amt)
					FROM rv_extra_tax
					WHERE rv_extra_tax.rv_extra_id = rv_extra.rv_extra_ix
				) as rv_extra_amt_tax,
				rv_reservation.rv_commission_deduct_yn,
				IF(rv_extra.rv_extra_tax_ind = 10, rf_tax_rate.rf_tax_rate_desc, rt_tax_group.rt_tax_group_desc) AS taxDesc
			FROM
				rv_extra
				INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_extra.rf_tax_id
				LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_extra.rf_tax_id
			WHERE
				rv_extra.fn_folio_id = '$folioItem[fn_folio_ix]'
		",2);
		foreach($extraList as $extraKey=>$extraItem) {
			if($extraItem['rv_commission_deduct_yn'] == 1) {
				$total = $extraItem['rv_extra_amt_nett'];
			} else {
				$total = $extraItem['rv_extra_amt_gross'];
			}
			$extraList[$extraKey]['rv_extra_amt_payable'] = $total;
			$extraList[$extraKey]['rv_extra_amt_excl'] = $total - $extraItem['rv_extra_amt_tax'];

			$exclTotal += ( $total - $extraItem['rv_extra_amt_tax']);
			$taxTotal += $extraItem['rv_extra_amt_tax'];
			$payableTotal += $total;

			fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_gross']);
			fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_nett']);
			fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_payable']);
			fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_excl']);
			$extraList[$extraKey]['rv_extra_amt_tax'] = round($extraList[$extraKey]['rv_extra_amt_tax'],2);
			fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_tax'],2);
		}
		$busList[$key]['folioList'][$folioKey]['extraList'] = $extraList;

		fixAmtDisplay($exclTotal,2);
		$taxTotal = round($taxTotal,2);
		fixAmtDisplay($taxTotal,2);
		fixAmtDisplay($payableTotal,2);
		$busList[$key]['folioList'][$folioKey]['exclTotal'] = $exclTotal;
		$busList[$key]['folioList'][$folioKey]['taxTotal'] = $taxTotal;
		$busList[$key]['folioList'][$folioKey]['payableTotal'] = $payableTotal;
		$busList[$key]['folioList'][$folioKey]['hasTBA'] = $hasTBA;

		$outstanding = $payableTotal - $busList[$key]['folioList'][$folioKey]['paymentTotal'];
		fixAmtDisplay($outstanding);
		$busList[$key]['folioList'][$folioKey]['outstanding'] = $outstanding;
	}
}
$hideButton = "display: none;";
if($action == 3 || !canEditDB($lDB->get("SELECT rv_reservation_db FROM rv_reservation WHERE rv_reservation_ix = '$record'",4))) {
	$hideButton = "";
}

$folioRows = "";
$businessCurrencyList = "var businessCurrencyList = new Array();\n";
$businessCurrencyList .= "var businessCurrencySymbolList = new Array();\n";
foreach($busList as $item) {
	$businessCurrencyList .= "businessCurrencyList['$item[pr_persona_ix]'] = '$item[pr_bus_home_curr_id]';\n";
	$businessCurrencyList .= "businessCurrencySymbolList['$item[pr_persona_ix]'] = '$item[rf_currency_symbol]';\n";
	if(sizeof($item['folioList']) > 0) {
		$folioRows .= '
			<table width="770" align="center" cellpadding="2" cellspacing="0" valign="top">
				<col width="6" />
				<col />
				<col width="6" />
				<tr>
					<td class="br colLt"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="6" height="4" alt="" /></td>
					<td><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="4" height="4" alt="" /></td>
					<td class="bl colLt"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="6" height="4" alt="" /></td>
				</tr>
				<tr>
					<td class="br colLt"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="6" height="25" alt="" /></td>
					<td class="txtbbr">' . t_encodeHTMLField($item['pr_name_last']) . '</td>
					<td class="bl colLt"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="6" height="25" alt="" /></td>
				</tr>
			</table>
			<table width="770" align="center" cellpadding="0" cellspacing="0" class="wwbw">
				<tr>
					<td class="br colLt"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="10" height="25" alt="" /></td>
					<td>
						<table width="730" border="0" cellspacing="0" cellpadding="2" align="center" class="bt bl br wwbw" style="table-layout: fixed;">
							<col width="20"><!-- Generate Invoice -->
							<col width="40"><!-- Folio number button -->
							<col width="80"><!-- Details / Change contact -->
							<col width="53"><!-- Summary -->
							<col width="95"><!-- Description -->
							<col width="68"><!-- Tax Rate-->
							<col width="60"><!-- Excl Tax -->
							<col width="60"><!-- Tax Amount -->
							<col width="87"><!-- Payable -->
							<col width="83"><!-- Amount Paid -->
							<col width="85"><!-- Outstanding -->
							<tr>
								<td align="center" colspan="2" class="outDk">Folio #</td>
								<td class="outDk">Details</td>
								<td class="outDk">Summary</td>
								<td class="outDk">Description</td>
								<td align="right" class="outDk">Tax Rate</td>
								<td align="right" class="outDk">Excl Tax</td>
								<td align="right" class="outDk">Tax</td>
								<td align="right" class="outDk">Payable<br /><span class="txts">(incl Tax)</span></td>
								<td align="right" class="outDk">Amount Paid</td>
								<td align="right" class="outDk">Outstanding</td>
							</tr>
		';
		foreach($item['folioList'] as $folioItem) {
			$fiscaliseBusiness = 0;
			if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5 && $GLOBALS['userStatusId'] > 1 && (canEditDB($folioItem['fn_folio_db']) || ($GLOBALS['dbcode'] == $folioItem['fn_folio_db'] && $folioItem['fn_folio_trf_yn'] == "0" && $GLOBALS['dbcode'][0] != "W"))) {
				$hideButton = "";
				$editClass = "";
				$editFolioClass = "";
				$canEditFolio = true;
			} else {
				$hideButton = "display:none; ";
				$editClass = "txtg";
				$editFolioClass = "txtgb";
				$canEditFolio = false;
			}
			$first = true;
			$firstAccomm = true;
			$firstExtra = true;
			$showCurrency = false;

			if($folioItem['rf_currency_id'] != $item['pr_bus_home_curr_id']) {
				// need exchange
				$exchangeNeeded = "true";
				$exchangeRate = db_rf_exchange_rate_get_rate_by_all($folioItem['rf_currency_id'],$item['pr_bus_home_curr_id']);
			} else {
				$exchangeNeeded = "false";
				$exchangeRate = "1";
			}

			$folioItem['allowFutureInvoice'] = (db_fn_invoice_allow_future_date($folioItem['fn_folio_ix'])?"1":"0");
			$folioItem['invoiceMaxDate'] = db_fn_invoice_max_date($folioItem['fn_folio_ix']);

			foreach($folioItem['accommList'] as $accommItem) {
				if($first) {
					if($hideButton != "") {
						$folioNum = $folioItem['fn_folio_folio_num'];
					} else {
						$folioNum = "";
					}
					$cannotInvoiceReason = "";
					if($folioItem['rf_reservation_status_id'] != 30 && $folioItem['rf_reservation_status_id'] != 90) {
						$cannotInvoiceReason = "A reservation must have either a confirmed or cancelled status for the folios to be invoiced.";
					}
					If($folioItem['hasTBA']) {
						$cannotInvoiceReason = "A reservation must not have any to be advised charges for the folios to be invoiced.";
					}
					if(!canEditDB($folioItem['fn_folio_db'])) {
						$cannotInvoiceReason = "You do not have access to invoice this folio on this enviroment. This is due to either the folio belonging to a different environment or your environment not having master status.";
					}
					if($GLOBALS['userStatusId'] < 2 || $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] <= 5 || !$allowInvoiceCreate) {
						$cannotInvoiceReason = "You do not have access to invoice on this enviroment.";
					}
					$invoiceCheckBox = "<span onmouseover=\"overlib('".t_encodeOverlib($cannotInvoiceReason)."')\" onmouseout=\"nd()\"><input type=\"checkbox\" disabled><span>";
					if( ($folioItem['rf_reservation_status_id'] == 30 || $folioItem['rf_reservation_status_id'] == 90) && !$folioItem['hasTBA'] && canEditDB($folioItem['fn_folio_db']) && $GLOBALS['userStatusId'] > 1 && $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5 && $allowInvoiceCreate) {
						$invoiceCheckBox = "<span><input name=\"invoiceCheck\" type=\"checkbox\" onclick=\"invoiceCheckClick(event,this);\" currency=\"$folioItem[rf_currency_symbol]\" currency_id=\"$folioItem[rf_currency_id]\" folio_id=\"$folioItem[fn_folio_ix]\" folio_num=\"$folioItem[fn_folio_folio_num]\" folio_date=\"$folioItem[fn_folio_date]\" invoice_max_date=\"$folioItem[invoiceMaxDate]\" allow_future_invoice=\"$folioItem[allowFutureInvoice]\" outstanding=\"".$folioItem['outstanding']."\" reservation_id=\"$record\" business=\"$item[pr_persona_ix]\" exchange=\"$exchangeRate\" pr_business_fiscalise=\"$item[pr_business_fiscalise]\" onchange=\"return;\"></span>";
					}
					$folioRows .= "
<tr valign=\"top\" class=\"imgLink\" onclick=\"showFolio(event,'$folioItem[fn_folio_ix]');\" onmouseover=\"folioMouseOver('$folioItem[fn_folio_ix]');\" onmouseout=\"folioMouseOut('$folioItem[fn_folio_ix]');\">
	<td><input type=hidden name=\"row_$folioItem[fn_folio_ix]\">$invoiceCheckBox</td>
	<td class=\"br\" align=\"center\"><input name=\"button223\" onclick=\"event.cancelBubble = true; openPopup('reservation.php?231+$record+$item[pr_persona_ix]',850,600)\" type=\"button\" class=\"button txtb\" style=\"width:20; height:18; text-align:center; $hideButton\" value=\"$folioItem[fn_folio_folio_num]\"><span align=\"left\" class=\"$editFolioClass\">$folioNum</span><input type=button class=\"button bDropDown\" value=\"  \" style=\"width:14; height:18; background-position: center center;\" onclick=\"showFolioMenu(event,'$folioItem[fn_folio_ix]');\"></td>
					";
					if($canEditFolio) {
						$folioRows .= "
	<td class=\"$editClass br\"><button type=\"button\" class=\"button\" onClick=\"event.cancelBubble = true; window.id('folioNewContactFolioId').value='$folioItem[fn_folio_ix]'; openPopup('reservation.php?692+22',350,525);\" onMouseOver=\"overlib('<span class=txts>Set/Change</span>',LEFT,WIDTH,55)\" onMouseOut=\"nd()\" style=\"height: 100%; word-break: break-word;\">".t_encodeHTMLField($folioItem['pr_name']).$folioItem['pr_name_extra']."</button></td>
						";
					} else {
						$folioRows .= "
	<td class=\"$editClass br\">".t_encodeHTMLField($folioItem['pr_name']).$folioItem['pr_name_extra']."</td>
						";
					}
				} else {
					if(!$showCurrency) {
						$currency = $folioItem['rf_currency_symbol'];
						$showCurrency = true;
					} else {
						$currency = "";
					}
					$folioRows .= "
<tr valign=\"top\" class=\"imgLink\" onclick=\"showFolio(event,'$folioItem[fn_folio_ix]');\" onmouseover=\"folioMouseOver('$folioItem[fn_folio_ix]');\" onmouseout=\"folioMouseOut('$folioItem[fn_folio_ix]');\">
	<td><input type=hidden name=\"row_$folioItem[fn_folio_ix]\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
	<td class=\"br\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
	<td align=\"center\" class=\"br\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
					";
				}
				if($firstAccomm) {
					$folioRows .= "
	<td class=\"br $editClass\">Accomm</td>
					";
				} else {
					$folioRows .= "
	<td class=\"br\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
					";
				}
				$folioRows .= "
	<td class=\"br $editClass\">$accommItem[rt_component_desc]</td>
	<td class=\"br $editClass\" align=\"right\">$accommItem[taxDesc]</td>
	<td class=\"br $editClass\" align=\"right\">$accommItem[rv_item_comp_amt_excl]</td>
	<td class=\"br $editClass\" align=\"right\">$accommItem[rv_item_comp_amt_tax]</td>
	<td class=\"br $editClass\" align=\"right\">$accommItem[rv_item_comp_amt_payable] ".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
	<td class=\"br\" align=\"right\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
	<td align=\"right\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
				";
				if($first) {
					if($folioItem['hasTBA'] || $folioItem['rf_reservation_status_id'] < 30 ) {
						$invoiceDisabled = " visibility: hidden; ";
					} else {
						$invoiceDisabled = "";
					}
					$outstanding = $folioItem['payableTotal'] - $folioItem['paymentTotal'];
					$folioRows .= "
</tr>
					";
				} else {
					$folioRows .= "
</tr>
					";
				}
				$first = false;
				$firstAccomm = false;
			}
			foreach($folioItem['extraList'] as $extraItem) {
				if($first) {
					if($hideButton != "") {
						$folioNum = $folioItem['fn_folio_folio_num'];
					} else {
						$folioNum = "";
					}
					$cannotInvoiceReason = "";
					if($folioItem['rf_reservation_status_id'] != 30 && $folioItem['rf_reservation_status_id'] != 90) {
						$cannotInvoiceReason = "A reservation must have either a confirmed or cancelled status for the folios to be invoiced.";
					}
					If($folioItem['hasTBA']) {
						$cannotInvoiceReason = "A reservation must not have any to be advised charges for the folios to be invoiced.";
					}
					if(!canEditDB($folioItem['fn_folio_db'])) {
						$cannotInvoiceReason = "You do not have access to invoice this folio on this enviroment. This is due to either the folio belonging to a different environment or your environment not having master status.";
					}
					if($GLOBALS['userStatusId'] < 2 || $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] <= 5 || !$allowInvoiceCreate) {
						$cannotInvoiceReason = "You do not have access to invoice on this enviroment.";
					}

					$invoiceCheckBox = "<span onmouseover=\"overlib('".t_encodeOverlib($cannotInvoiceReason)."')\" onmouseout=\"nd()\"><input type=\"checkbox\" disabled><span>";
					if(($folioItem['rf_reservation_status_id'] == 30 || $folioItem['rf_reservation_status_id'] == 90) && !$folioItem['hasTBA'] && canEditDB($folioItem['fn_folio_db']) && $GLOBALS['userStatusId'] > 1 && $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5 && $allowInvoiceCreate) {
						$invoiceCheckBox = "<span><input name=\"invoiceCheck\" type=\"checkbox\" onclick=\"invoiceCheckClick(event,this);\" currency=\"$folioItem[rf_currency_symbol]\" currency_id=\"$folioItem[rf_currency_id]\" folio_id=\"$folioItem[fn_folio_ix]\" folio_num=\"$folioItem[fn_folio_folio_num]\" folio_date=\"$folioItem[fn_folio_date]\" invoice_max_date=\"$folioItem[invoiceMaxDate]\" allow_future_invoice=\"$folioItem[allowFutureInvoice]\" outstanding=\"".$folioItem['outstanding']."\" reservation_id=\"$record\" business=\"$item[pr_persona_ix]\" exchange=\"$exchangeRate\" onchange=\"return;\"></span>";
					}
					$folioRows .= "
<tr valign=\"top\" class=\"imgLink\" onclick=\"showFolio(event,'$folioItem[fn_folio_ix]');\" onmouseover=\"folioMouseOver('$folioItem[fn_folio_ix]');\" onmouseout=\"folioMouseOut('$folioItem[fn_folio_ix]');\">
	<td><input type=hidden name=\"row_$folioItem[fn_folio_ix]\">$invoiceCheckBox</td>
	<td class=\"br\" align=\"center\"><input name=\"button223\" onclick=\"event.cancelBubble = true; openPopup('reservation.php?231+$record+$item[pr_persona_ix]'850,600)\" type=\"button\" class=\"button txtb\" style=\"width:20; height:18; text-align:center; $hideButton\" value=\"$folioItem[fn_folio_folio_num]\"><span align=\"left\" class=\"$editFolioClass\">$folioNum</span><input type=button class=\"button bDropDown\" value=\"  \" style=\"width:14; height:18; background-position: center center;\" onclick=\"showFolioMenu(event,'$folioItem[fn_folio_ix]');\"></td>
					";
					if($canEditFolio) {
						$folioRows .= "
	<td class=\"$editClass br\"><button type=\"button\" class=\"button\" onClick=\"event.cancelBubble = true; window.id('folioNewContactFolioId').value='$folioItem[fn_folio_ix]'; openPopup('reservation.php?692+22',350,525);\" onMouseOver=\"overlib('<span class=txts>Set/Change</span>',LEFT,WIDTH,55)\" onMouseOut=\"nd()\" style=\"height: 100%;\">".t_encodeHTMLField($folioItem['pr_name']).$folioItem['pr_name_extra']."</button></td>
						";
					} else {
						$folioRows .= "
	<td class=\"$editClass br\">".t_encodeHTMLField($folioItem['pr_name']).$folioItem['pr_name_extra']."</td>
						";
					}
				} else {
					if(!$showCurrency) {
						$currency = $folioItem['rf_currency_symbol'];
						$showCurrency = true;
					} else {
						$currency = "";
					}
					$folioRows .= "
<tr valign=\"top\" class=\"imgLink\" onclick=\"showFolio(event,'$folioItem[fn_folio_ix]');\" onmouseover=\"folioMouseOver('$folioItem[fn_folio_ix]');\" onmouseout=\"folioMouseOut('$folioItem[fn_folio_ix]');\">
	<td><input type=hidden name=\"row_$folioItem[fn_folio_ix]\">&nbsp;</td>
	<td class=\"br\">&nbsp;</td>
<!--	<td class=\"$editClass\">&nbsp;</td>-->
	<td align=\"center\" class=\"br\">&nbsp;</td>
					";
				}
				if($firstExtra) {
					$folioRows .= "
	<td class=\"br $editClass\">Extras</td>
					";
				} else {
					$folioRows .= "
	<td class=\"br\">&nbsp;</td>
					";
				}
				$folioRows .= "
	<td class=\"br $editClass\">".t_encodeHTMLField($extraItem['ac_ext_desc'])."</td>
	<td class=\"br $editClass\" align=\"right\">$extraItem[taxDesc]</td>
	<td class=\"br $editClass\" align=\"right\">$extraItem[rv_extra_amt_excl]</td>
	<td class=\"br $editClass\" align=\"right\">$extraItem[rv_extra_amt_tax]</td>
	<td class=\"br $editClass\" align=\"right\">$extraItem[rv_extra_amt_payable] ".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
	<td class=\"br $editClass\" align=\"right\">&nbsp;</td>
	<td class=\"$editClass\" align=\"right\">&nbsp;</td>
				";
				if($first) {
					if($folioItem['hasTBA'] || $folioItem['rf_reservation_status_id'] < 30 ) {
						$invoiceDisabled = " visibility: hidden; ";
					} else {
						$invoiceDisabled = "";
					}
					$outstanding = $folioItem['payableTotal'] - $folioItem['paymentTotal'];
					$folioRows .= "
</tr>
					";
				} else {
					$folioRows .= "
</tr>
					";
				}
				$first = false;
			}
			if(!$showCurrency) {
				$folioRows .= "
<tr valign=\"top\" class=\"imgLink\" onclick=\"showFolio(event,'$folioItem[fn_folio_ix]');\" onmouseover=\"folioMouseOver('$folioItem[fn_folio_ix]');\" onmouseout=\"folioMouseOut('$folioItem[fn_folio_ix]');\">
	<td><input type=hidden name=\"row_$folioItem[fn_folio_ix]\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
	<td class=\"br\"><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
	<td align=\"center\" class=\"br\">&nbsp;</td>
	<td class=\"br\">&nbsp;</td>
	<td class=\"br\">&nbsp;</td>
	<td class=\"br\" align=\"right\">&nbsp;</td>
	<td class=\"br\" align=\"right\">&nbsp;</td>
	<td class=\"br\" align=\"right\">&nbsp;</td>
	<td class=\"br\" align=\"right\">&nbsp;</td>
	<td class=\"br\" align=\"right\">&nbsp;</td>
	<td align=\"right\">&nbsp;</td>
</tr>
				";
			}

			$folioItem['outstanding'] = $folioItem['payableTotal'] - $folioItem['paymentTotal'];
			fixAmtDisplay($folioItem['outstanding']);

			if($folioItem['hasTBA']) {
				$folioItem['exclTotal'] = "TBA";
				$folioItem['taxTotal'] = "TBA";
				$folioItem['payableTotal'] = "TBA";
				$folioItem['paymentTotal'] = "TBA";
				$folioItem['outstanding'] = "TBA";
				$folioItem['rf_currency_symbol'] = "";
			}

			$folioRows .= "
					<!--TOTALS-->
					<tr valign=\"top\">
						<td colspan=\"5\" height=\"20\" class=\"bt bb br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"txtb br bt bb $editClass\" align=\"right\">Total</td>
						<td class=\"br bt bb $editClass\" align=\"right\">$folioItem[exclTotal]</td>
						<td class=\"br bt bb $editClass\" align=\"right\">$folioItem[taxTotal]</td>
						<td class=\"br bt bb $editClass\" align=\"right\">$folioItem[payableTotal] ".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
						<td class=\"br bt bb $editClass\" align=\"right\">$folioItem[paymentTotal] ".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
						<td class=\"txtb bt bb $editClass\" align=\"right\">$folioItem[outstanding] ".t_encodeHTMLField($folioItem['rf_currency_symbol'])."</td>
					</tr>
					<tr>
						<td colspan=\"11\" height=\"1\" style=\"padding:0;\" class=\"bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
					</tr>
					<!--END TOTALS-->
			";
		}

		if($allowInvoiceCreate) {
			$invoiceButton = "
				<span style=\"width:7\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></span><input onclick=\"invoiceSelected(event);\" id=\"btnInvoiceSelected\" type=\"button\" style=\"width:65; height:20;\" class=\"button masterButton\" value=\"Invoice\" onmouseout=\"nd();\" onmouseover=\"overlib('<span class=txts>Generate Invoice(s)</span>',WIDTH,90);\">
			";
		} else {
			$invoiceButton = "&nbsp;";
		}

		$folioRows .= "
					</table>
					<table width=\"730\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"table-layout: fixed;\">
					<tr>
					</tr>
					</table>
				</td>
				<td width=\"10\" class=\"bl colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
			</tr>
			<tr>
				<td width=\"10\" class=\"br colLt\" height=\"4\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
				<td width=\"730\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
				<td width=\"10\" class=\"bl colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
			<tr>
				<td width=\"10\" class=\"br colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
				<td>$invoiceButton</td>
				<td width=\"10\" class=\"bl colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
			</tr>
			</table>
		";
	}
}
$GLOBALS['temp']['businessCurrencyList'] = $businessCurrencyList;

if(trim($folioRows) != "") {
	$GLOBALS['temp']['folioRows'] = $folioRows;
} else {
	$GLOBALS['temp']['folioRows'] = "
		<table width=\"770\" align=\"center\" cellpadding=\"2\" cellspacing=\"0\" valign=\"top\">
		<tr>
			<td width=\"6\" class=\"br colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
			<td height=\"4\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
			<td width=\"6\" class=\"bl colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		</tr>
		<tr>
			<td width=\"6\" class=\"br colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
			<td align=\"center\" class=\"txti\">No folios</td>
			<td width=\"6\" class=\"bl colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		</tr>
		</table>
	";
}

$voidSQL = "
	AND fn_invoice.fn_inv_status_ind != 8
";
if($showVoid == "1") {
	$voidSQL = "";
}

$voidCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM fn_invoice WHERE fn_invoice.rv_reservation_id = '$record' AND fn_invoice.fn_inv_status_ind = 8",4);
$GLOBALS['temp']['voidClass'] = "collapse printCollapse";
if($voidCount > 0) {
	$GLOBALS['temp']['voidClass'] = "expand";
}

$GLOBALS['temp']['voidCount'] = $GLOBALS['lDB']->get("
	SELECT COUNT(*) FROM fn_invoice WHERE fn_invoice.rv_reservation_id = '$record' AND fn_invoice.fn_inv_void_yn = '1'
",4);
$GLOBALS['temp']['reverseCount'] = $GLOBALS['lDB']->get("
	SELECT COUNT(*) FROM fn_invoice WHERE fn_invoice.rv_reservation_id = '$record' AND fn_invoice.fn_inv_reverse_ind != '0'
",4);

$invoiceList = $GLOBALS['lDB']->get("
	SELECT
		fn_invoice_db,
		fn_invoice_trf_yn,
		fn_invoice_ix,
		fn_invoice.fn_invoice_prefix,
		fn_invoice.fn_inv_date,
		fn_invoice.fn_inv_to,
		fn_invoice.fn_inv_from,
		fn_invoice.fn_inv_print_count,
		fn_invoice.fn_inv_curr,
		fn_invoice.fn_folio_id,
		fn_invoice.fn_inv_status_ind,
		fn_invoice.fn_inv_fiscal_status_ind,
		fn_invoice.fn_inv_reverse_ind,
		fn_invoice.fn_inv_void_yn
	FROM
		fn_invoice
	WHERE
		fn_invoice.rv_reservation_id = '$record'
		$voidSQL
	ORDER BY
		fn_invoice.fn_inv_status_ind,
		fn_invoice.fn_inv_void_yn
",2);
$invoiceRows = "";

$validHeader = false;
$reverseHeader = false;
$voidHeader = false;
$first = true;
foreach($invoiceList as $item) {
	$bt = "";
	if(!$first) {
		$bt = "bt";
	}
	if($item['fn_inv_status_ind'] == DB_FN_INVOICE_STATUS_LINKED && !$validHeader) {
		$invoiceRows .= "
			<tr>
				<td colspan=\"11\" class=\"colLtt txti br bb $bt\">Valid invoices</td>
			</tr>
		";
		$validHeader = true;
	}
	if($item['fn_inv_status_ind'] == DB_FN_INVOICE_STATUS_UNLINKED && $item['fn_inv_void_yn'] == "0" && !$reverseHeader) {
		$invoiceRows .= "
			<tr>
				<td colspan=\"11\" class=\"colLtt txti br bb $bt\">Reversed invoices</td>
			</tr>
		";
		$reverseHeader = true;
	}
	if($item['fn_inv_status_ind'] == DB_FN_INVOICE_STATUS_UNLINKED && $item['fn_inv_void_yn'] == "1" && !$voidHeader) {
		$invoiceRows .= "
			<tr>
				<td colspan=\"11\" class=\"colLtt txti br bb $bt\">Void invoices</td>
			</tr>
		";
		$voidHeader = true;
	}

	$showVoid = "1";
	$hasBatch = "0";
	$batchCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
		WHERE
			fn_tran.fn_tran_link_id = '$item[fn_invoice_ix]'
			AND fn_tran.fn_tran_link_ind = ".DB_FN_TRAN_LINK_INVOICE."
	",4);
	if($batchCheck > 0) {
		$hasBatch = "1";
	}
	$isVoid = "0";
	if($item['fn_inv_status_ind'] == "8") {
		$isVoid = "1";
	}
	if($GLOBALS['userStatusId'] > 1 && (canEditDB($item['fn_invoice_db']) || ($GLOBALS['dbcode'] == $item['fn_invoice_db'] && $item['fn_invoice_trf_yn'] == "0" && $GLOBALS['dbcode'][0] != "W"))) {
		$hideButton = "";
		$editClass = "";
		$editFolioClass = "";
	} else {
		$hideButton = "display:none; ";
		$editClass = "txtg";
		$editFolioClass = "txtgb";
	}
	$totals = $GLOBALS['lDB']->get("
		SELECT
			SUM(fn_inv_item_amount) as total,
			SUM(fn_inv_item_amt_comm) as comm,
			SUM(fn_inv_item_amt_tax) as tax
		FROM
			fn_invoice_item
		WHERE
			fn_invoice_id = '$item[fn_invoice_ix]'
	",1);
	$item['exclAmount'] = $totals['total'] - $totals['tax'];
	fixAmtDisplay($item['exclAmount']);

	if($item['fn_inv_status_ind'] == DB_FN_INVOICE_STATUS_LINKED) {
		$paymentTotal = $GLOBALS['lDB']->get("
			SELECT
				SUM(rv_payment_item_amt)
			FROM
				rv_payment_item
			WHERE
				fn_folio_id = '$item[fn_folio_id]'
		",4);
	} else {
		$paymentTotal = 0;
	}
	$amountPayable = $totals['total']  - $paymentTotal;
	fixAmtDisplay($paymentTotal);
	fixAmtDisplay($amountPayable);
	fixAmtDisplay($totals['comm']);
	$totals['tax'] = round($totals['tax'],2);
	fixAmtDisplay($totals['tax']);
	fixAmtDisplay($totals['total']);
	$rowColour = "colInv";
	if($amountPayable < 0) {
		$rowColour = "colInvCrBal";
	}
	if($totals['total'] < 0) {
		$rowColour = "colInvCrNote";
	}
	if($item['fn_inv_status_ind'] != "8" && $allowInvoiceVoid) {
		$hideVoid = "";
	} else {
		$showVoid = "0";
		$hideVoid = "display: none;";
		if($item['fn_inv_void_yn'] == "1") {
			$rowColour = "colInvVoid txti";
		}
	}
	if($item['fn_inv_print_count'] < 0) {
		$item['fn_inv_print_count'] = "0";
	}

	$allowFuture = (db_fn_invoice_allow_future_date(false,$item['fn_invoice_ix'])?"1":"0");
	$maxDate = db_fn_invoice_max_date(false,$item['fn_invoice_ix']);
	$minDate = $item['fn_inv_date'];

	$item['fn_inv_date'] = chng_date($item['fn_inv_date'],"-");

	$fiscalShowHide = "";
	$fiscalMessage = '';
	$showFiscal = '0';
	$fiscal_status = '';

	if (checkFiscalisationByInvoice($item['fn_invoice_ix'])) {
		// 1 = Pending, 2 = Verified, 3 = Rejected, 4 = Error, 9 = Zero folio
		$fiscalShowHide = " style='display:none;' ";
		$fiscal_status = '<i class="material-icons txtred">report</i>';
		$showFiscal = '1';

		switch ($item['fn_inv_fiscal_status_ind']) {
			case 1:
				$fiscalMessage = "title='Fiscal status: Pending'";
				break;
			case 2:
				$fiscalMessage = "title='Verified'";
				$fiscalShowHide = "";
				$fiscal_status = '<i class="material-icons">check_circle</i>';
				break;
			case 3:
				$fiscalMessage = "title='Fiscal status: Rejected'";
				$bgColor = "#FFFFE0";
				break;
			case 4:
				$fiscalMessage = "title='Fiscal status: Error'";
				$bgColor = "#FFFFE0";
				break;
			case 5:
				$fiscalMessage = "title='Fiscal status: Credit upload pending'";
				$bgColor = "#FFFFE0";
				break;
			case 6:
				$fiscalMessage = "title='Fiscal status: Credit approval pending'";
				break;
			case 7:
				$fiscalMessage = "title='Fiscal status: Credit approved'";
				$fiscal_status = '<i class="material-icons">check_circle</i>';
				break;
			case 8:
				$fiscalMessage = "title='Fiscal status: Credit error'";
				break;
			case 9:
				$fiscalMessage = "title='Fiscal status: Zero total not submitted'";
				$bgColor = "#FFFFE0";
				$fiscal_status = '<i class="material-icons">check_circle</i>';
				break;
			default:
				$fiscalMessage = "title='Fiscal status: Not Submitted'";
		}
	}
	$GLOBALS['temp']['fiscalShowHide'] = $fiscalShowHide;

	$invoiceRows .= "
		<tr bgcolor=\"#FFFFFF\" class=\"imgLink $rowColour\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"showInvoice('$item[fn_invoice_ix]');\" valign=\"top\" $fiscalMessage>
			<td class=\"br $rowColour\">$item[fn_invoice_ix]</td>
			<td class=\"br $rowColour\">$item[fn_inv_date]</td>
			<td class=\"br $rowColour\">$item[fn_inv_from]</td>
			<td class=\"br $rowColour\">$item[fn_inv_to]</td>
			<td class=\"br $rowColour\" align=\"center\">$item[fn_inv_print_count]</td>
			<td class=\"br $rowColour\" align=\"right\">$totals[comm]</td>
			<td class=\"br $rowColour\" align=\"right\">$item[exclAmount]</td>
			<td class=\"br $rowColour\" align=\"right\">$totals[tax]</td>
			<td class=\"br $rowColour\" align=\"right\">$totals[total]&nbsp;$item[fn_inv_curr]</td>
			<td class=\"br $rowColour\" align=\"right\">$paymentTotal</td>
			<td class=\"br $rowColour\" align=\"center\">$fiscal_status</td>
			<td><input type=button class=\"button bDropDown\" value=\"  \" style=\"width:18; height:18; background-position: center center; $hideButton\" onclick=\"showInvoiceMenu(event,'$item[fn_invoice_ix]','$item[fn_folio_id]',$isVoid,$showVoid,$hasBatch,$allowFuture,'$minDate','$maxDate', '$showFiscal');\">
		</tr>
	";
	$first = false;
}
if($invoiceRows == "") {
	$invoiceRows = "
		<tr>
			<td colspan=12 class=\"txti\">No invoiced amounts</td>
		</tr>
	";
}
$GLOBALS['temp']['invoiceRows'] = $invoiceRows;
// End generate folio / invoice tab

// Start Access Control Toolbar Setup
$edit = 647;
$view = 646;
$sedit = 648;
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['edit'] = "0";
if ($canEditReservation && checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['save'] = "0";
if ($action == "3") {
	$pgJOBS['save'] = "1";
}
if ($action == "4") {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
}
$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" name=\"record\" value=\"$record\" disabled>\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" name=\"recordprev\" value=\"$rPrev\" disabled>\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" name=\"recordnext\" value=\"$rNext\" disabled>\n";

// End Access Control Toolbar Setup
$GLOBALS['temp']['hideRegenCost'] = " style=\"visibility:hidden\"";
$folioDBList = $lDB->get("SELECT DISTINCT fn_folio_db FROM fn_folio WHERE rv_reservation_id = '$record'",3);
$allowEdit = false;
foreach($folioDBList as $folioDB) {
	if(canEditDB($folioDB)) { $allowEdit = true; }
}

if(!$allowEdit || $GLOBALS['userStatusId'] < 2 || $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] <= 5) {
	$GLOBALS['temp']['disableEditButtons'] = " disabled";
	$GLOBALS['temp']['classEditButtons'] = "buttonDisabled";
	$GLOBALS['temp']['collapseEditButtons'] = " collapse ";
} else {
	$GLOBALS['temp']['disableEditButtons'] = "";
	$GLOBALS['temp']['classEditButtons'] = "";
	$GLOBALS['temp']['collapseEditButtons'] = "";
}

$GLOBALS['temp']['hidePaymentButton'] = "";
// check for access to "299"
if(!array_key_exists(299,$GLOBALS['jobLevelArray']) || $GLOBALS['jobLevelArray'][299] < 10) {
	$GLOBALS['temp']['hidePaymentButton'] = " style=\"visibility: hidden\"";
}

$GLOBALS['temp']['hidePaymentGatewayButton'] = " style=\"visibility:hidden\"";
if($lDB->get("SELECT COUNT(*) FROM rv_payment_gateway_folio WHERE rv_reservation_id = '$record'",4) > 0) {
	$GLOBALS['temp']['hidePaymentGatewayButton'] = "";
}


switch ($action) {
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['edit_view'] = "/reservation.php?$edit+$record";
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS[$form]->Arguments = "$view+$record";
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = "$sedit+$record";
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['edit_view'] = "/reservation.php?$view+$record";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	if(checkjob($_SERVER['argv'][0], 2) == "15") {
		$GLOBALS['temp']['hideRegenCost'] = "";
	}
	break;
}
$temp = $GLOBALS['lDB']->get("SELECT rv_res_name, rv_date_recorded FROM rv_reservation WHERE rv_reservation_ix = '$record'", 1);
$GLOBALS['temp']['rnum'] = (string) $record;
$GLOBALS['temp']['rname'] = (string) $temp[0];
$GLOBALS['temp']['date_ammend'] = chng_date($GLOBALS[$form.'_rv_reservation_rv_date_changed']->Value, "-");
$GLOBALS['temp']['date_create'] = chng_date($temp[1], "-");
//Created by code:
$userId = $lDB->get("select pr_reservation_user_id from rv_reservation where rv_reservation_ix = '$record'", 4);
$temp = $lDB->get("select pr_name_first, pr_name_last from pr_persona where pr_persona_ix = '$userId'", 1);
$GLOBALS['temp']['user_created'] = trim($temp['pr_name_first']." ".$temp['pr_name_last']);
if ($GLOBALS['temp']['user_created'] == "") {
	$GLOBALS['temp']['user_created'] = "N/A";
}
//End
//Reservation Status
$resStatus = $GLOBALS['lDB']->get("
	SELECT
		rf_reservation_status.rf_reservation_status_id as resStatusId,
		rf_reservation_status.rf_reservation_status_desc as resStatusDesc
	FROM
		rv_reservation
		INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
	WHERE
		rv_reservation.rv_reservation_ix = '$record'
",1);
$GLOBALS['temp']['statusDesc'] = $resStatus['resStatusDesc'];
$GLOBALS['temp']['statusClass'] = "txt";
if($resStatus['resStatusId'] == "90"){
	$GLOBALS['temp']['statusClass'] = "txtb";
}
if($resStatus['resStatusId'] == "20"){
	$expDate = $lDB->get("
		SELECT
			rv_provision_expiry_date
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$record'
	",4);

	$today = date("Y-m-d");
	if ($today == $expDate) {
		$GLOBALS['temp']['provBg'] = "#F1C55D";
		$GLOBALS['temp']['statusDesc'] .= " (Expires: ".chng_date($expDate, "-").")";
	} elseif ($today > $expDate) {
		$GLOBALS['temp']['provBg'] = "#DB4242";
		$GLOBALS['temp']['statusDesc'] .= " (Expires: ".chng_date($expDate, "-").")";
	}
}

$GLOBALS['temp']['invCurrSym'] = $GLOBALS['lDB']->get("select rf_currency_symbol from rf_currency where rf_currency_ix = '".getInvCurr($record)."'", 4);

if ($pmode == "1") {
	if(isset($_POST['rv_agent_id']) && $_POST['rv_agent_id'] != $GLOBALS[$form.'_rv_reservation_rv_agent_id']->Value) {
		if($_POST['rv_billing_persona_id'] == "0" || trim($_POST['rv_billing_persona_id']) == "") {
			$GLOBALS[$form.'_rv_reservation_rv_billing_persona_id']->SetValue($_POST['rv_agent_id']);
		}
		if($_POST['rv_invoice_persona_id'] == "0" || trim($_POST['rv_invoice_persona_id']) == "") {
			$GLOBALS[$form.'_rv_reservation_rv_invoice_persona_id']->SetValue($_POST['rv_agent_id']);
		}
	}

	$rateId = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
	if(isset($_POST['restoreDefaultType']) && !empty($_POST['restoreDefaultType'])) {
		$reservationTerms = getReservationTerms($record);

		$pr_agent_id = $_POST['rv_agent_id'] ?? GLOBALS[$form.'_rv_reservation_rv_agent_id']->Value;
		$defaultTerms = getDefaultTerms($pr_agent_id);

		$GLOBALS['temp']['postSaveMessage'] = "Defaults restored.";

		switch($_POST['restoreDefaultType']) {
		case "agent":
			db_rv_reservation_set_terms($record, $defaultTerms['rt_rate_type_id'], $defaultTerms['rv_commission_perc']);
			$itemList = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$record'",3);
			foreach($itemList as $rv_reservation_item_id) {
				db_rv_reservation_item_set_terms($rv_reservation_item_id, $defaultTerms['rt_rate_type_id'], $defaultTerms['rv_commission_perc']);
			}
			$auditActions[] = "restore defaults agent only";
			break;

		case "property":
			$itemList = $GLOBALS['lDB']->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix AS rv_reservation_item_id,
					rv_reservation_item.pr_business_id
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_id = '$record'
			",6);
			foreach($itemList as $item) {
				$agentTerms = getAgentPropertyTerms($pr_agent_id, $reservationTerms['rf_currency_id'], $item['pr_business_id'], false, true);
				$item_commission_perc = $agentTerms['rv_commission_perc'] ?? $reservationTerms['rv_commission_perc'];
				$item_rate_type_id = $agentTerms['rt_rate_type_id'] ?? $reservationTerms['rt_rate_type_id'];
				db_rv_reservation_item_set_terms($item['rv_reservation_item_id'], $item_rate_type_id, $item_commission_perc);
			}
			$auditActions[] = "restore defaults property only";
			break;

		case "both":
			db_rv_reservation_set_terms($record, $defaultTerms['rt_rate_type_id'], $defaultTerms['rv_commission_perc']);
			$itemList = $GLOBALS['lDB']->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix AS rv_reservation_item_id,
					rv_reservation_item.pr_business_id
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_id = '$record'
			",6);
			foreach($itemList as $item) {
				$agentTerms = getAgentPropertyTerms($pr_agent_id, $defaultTerms['rf_currency_id'], $item['pr_business_id'], false, true);
				$item_commission_perc = $agentTerms['rv_commission_perc'] ?? $defaultTerms['rv_commission_perc'];
				$item_rate_type_id = $agentTerms['rt_rate_type_id'] ?? $defaultTerms['rt_rate_type_id'];
				db_rv_reservation_item_set_terms($item['rv_reservation_item_id'], $item_rate_type_id, $item_commission_perc);
			}
			$auditActions[] = "restore defaults both";
			break;
		}

		$newReservationTerms = getReservationTerms($record);
		if($newReservationTerms['rt_rate_type_id'] != $reservationTerms['rt_rate_type_id']) {
			$moduleFieldValues[] = array('rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rt_rate_type_id",'from'=>$reservationTerms['rt_rate_type_id'],'to'=>$newReservationTerms['rt_rate_type_id']);
		}
		if($newReservationTerms['rv_commission_perc'] != $reservationTerms['rv_commission_perc']) {
			$moduleFieldValues[] = array('rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_commission_perc",'from'=>$reservationTerms['rv_commission_perc'],'to'=>$newReservationTerms['rv_commission_perc']);
		}
		$GLOBALS['RECALCTOTALS'] = 2;
	} else {
		if(isset($_POST['rateSelect']) && $_POST['rateSelect'] != $rateId) {
			$invCurrency = $GLOBALS['lDB']->get("SELECT rv_reservation.rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$record'", 4);
			$oldCurrency = $GLOBALS['lDB']->get("SELECT rt_rate_type.rf_currency_id FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix = '$rateId'", 4);
			$newCurrency = $GLOBALS['lDB']->get("SELECT rt_rate_type.rf_currency_id FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix = '$_POST[rateSelect]'", 4);
			if ($newCurrency == $invCurrency) {
				$GLOBALS[$form.'_rv_reservation_rv_exchg_rate']->SetValue(1);
			}
			if($oldCurrency == $newCurrency && $_POST['rateSelectType'] == "default") {
				$itemList = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$record' AND rt_rate_type_id = '$rateId'",3);
			} else { // if the currency changes update *all* items
				$itemList = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$record'",3);
			}
			foreach($itemList as $item) {
				$GLOBALS['lDB']->put("UPDATE rv_reservation_item SET rt_rate_type_id = '$_POST[rateSelect]' WHERE rv_reservation_item_ix = '$item'");
			}
			$GLOBALS['lDB']->put("UPDATE rv_reservation SET rt_rate_type_id = '$_POST[rateSelect]' WHERE rv_reservation_ix = '$record'");
			$moduleFieldValues[] = array('rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rt_rate_type_id",'from'=>$rateId,'to'=>$_POST['rateSelect']);
			$GLOBALS['RECALCTOTALS'] = 2;
		}

		if(isset($_POST['rv_commission_perc']) && $_POST['rv_commission_perc'] != $GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Value) {
			$commissionType = $_POST['commissionChangeType'] ?? "default";
			if($commissionType == "default") {
				$items = $lDB->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '" . $lDB->escape($record) . "'
						AND rv_reservation_item.rv_item_comm_perc = '" . $lDB->escape($GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Value) . "'
				",3);
			} else { // all
				$items = $lDB->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '" . $lDB->escape($record) . "'
				",3);
			}
			foreach($items as $rv_reservation_item_id) {
				db_rv_reservation_item_set_commission($rv_reservation_item_id, $_POST['rv_commission_perc']);
			}
			$GLOBALS['RECALCTOTALS'] = "1";
		}
	}

	if (isset($_POST['rv_invoice_currency_id']) && $_POST['rv_invoice_currency_id'] != $GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Value && trim($_POST['rv_invoice_currency_id']) != "") {

		if ($_POST['currChangeRegenType'] == "1"){
			db_rv_res_item_comp_set_variance_by_res_exchg_rate($record, $pExchgRate);
			$GLOBALS['RECALCTOTALS'] = 1;
		} else {
			$GLOBALS['RECALCTOTALS'] = 2;
		}

	}

	if (!$GLOBALS['resAMMEND']) {
		$reservationAuditTrail = new AuditTrail($record,TYPE_RESERVATION);
		$newModuleFields = [
			['rf_audit_module_description_internal'=>"resdetail", 'ad_module_field_name'=>"rv_reservation.rv_agent_id"],
			['rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_invoice_persona_id"],
			['rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_commission_deduct_yn"],
			['rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_commission_perc"],
			['rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_invoice_currency_id"],
			['rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_exchg_rate"],
			['rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_folio_level_ind"],
			['rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_exchg_expiry_date"],
			['rf_audit_module_description_internal'=>"resfinancial", 'ad_module_field_name'=>"rv_reservation.rv_billing_persona_id"]
		];
		foreach($newModuleFields as $newModuleField) {
			$hasField = false;
			foreach($moduleFieldValues as $moduleFieldValue) {
				if($moduleFieldValue['ad_module_field_name'] == $newModuleField['ad_module_field_name']) {
					$hasField = true;
					break;
				}
			}
			if(!$hasField) {
				$moduleFieldValues[] = $newModuleField;
			}
		}
		foreach ($moduleFieldValues as $moduleFieldValue) {
			$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
			$valueFrom = (isset($moduleFieldValue['from'])) ? $moduleFieldValue['from'] : $GLOBALS[$form.'_rv_reservation_'.$moduleFieldName]->Value;
			$valueTo = (isset($moduleFieldValue['to'])) ? $moduleFieldValue['to'] : (isset($_POST[$moduleFieldName])?$_POST[$moduleFieldName]:"");
			$reservationAuditTrail->addDetail(
				$valueFrom,
				$valueTo,
				Null,
				Null,
				DB_AD_RES_DETAIL_ACTION_EDIT,
				$moduleFieldValue['rf_audit_module_description_internal'],
				$moduleFieldValue['ad_module_field_name']
			);
		}
		$auditLabel = "Financials";
		if(sizeof($auditActions) > 0) {
			$auditLabel .= " (" . join(", ", $auditActions) . ")";
		}
		$reservationAuditTrail->save($auditLabel);
	}
}

// Check for multi-currency folios
$currencyCheck = $GLOBALS['lDB']->get("SELECT COUNT(DISTINCT rf_currency_id) FROM fn_folio WHERE rv_reservation_id = '$record'",4);
$GLOBALS['temp']['showCommissionSummary'] = "";
$GLOBALS['temp']['showPaymentTotals'] = "";
if($currencyCheck > 1) {
	$GLOBALS['temp']['showCommissionSummary'] = " style=\"display:none\" ";
	$GLOBALS['temp']['showPaymentTotals'] = " class=\"collapse printCollapse\" ";
}

// Check for variances on any components (to be used in a currency-change verification)
$currencyCheck = $GLOBALS['lDB']->get("
	SELECT
		SUM(rv_res_item_comp.rv_item_comp_var)
	FROM
		rv_res_item_comp
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
",4);

if ($currencyCheck != 0){
	$GLOBALS['temp']['hasVariances'] = "1";
} else {
	$GLOBALS['temp']['hasVariances'] = "0";
}

$GLOBALS['temp']['sc_grp_res_ovr_overbooking_yn'] = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn");
