<?php

require_once(__DIR__ . "/db.rv_payment_gateway.php");
require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/functions.report.php");
require_once(__DIR__ . '/functions.reservation.advanced.php');
require_once(__DIR__ . '/class.audit.php');   

/**
 * Given the current page, the total number of pages, and the total page links
 * to be displayed, generate a bunch of links for pagination.
 *
 * @param int $currentPage
 * @param int $totalPages
 * @param int $totalPageLinks
 * @return string
 */
function generateModReqPaginationLinks($currentPage, $totalPages, $totalPageLinks)
{
    $startPage = $currentPage - (int) ($totalPageLinks/2);

    if ($startPage < 1) {
        $startPage = 1;
    }

    if ($startPage > $totalPages) {
        $startPage = $totalPages;
    }

    $endPage = $startPage+$totalPageLinks;

    if ($endPage > $totalPages) {
        $endPage = $totalPages;
    }

    if ($currentPage > $endPage) {
        $currentPage = $endPage;
    }

    $links = "<a class=txtbr>Pages:</a> ";

    if ($startPage > 1) {
        $links .= "<a href=\"/reservation.php?650+modReqReceived++++1\" class=txtbr>First</a>, ";
    }

    for($i = $startPage; $i <= $endPage; $i++) {
        if ($i != $startPage) {
            $links .= ", ";
        }

        $links .= "<a class=txtbr";

        if ($i != $currentPage) {
            $links .= " href=\"/reservation.php?650+modReqReceived++++$i\"";
        }

        $links .= ">". $i. "</a>";
    }

    if ($endPage < $totalPages) {
        $links .= "<a class=txtbr>...</a> <a href=\"/reservation.php?650+modReqReceived++++$totalPages\" class=txtbr>Last</a>";
    }

    $links .= "<a class=txtbr> of ". $totalPages ." page(s)</a>";
    return $links;
}