<?php

/**
 *
 * init.form221.php - Tracking Incoming Reservations
 * Job: 650
 * Function: 70
 *
 */

if(!isset($GLOBALS[$form])) {
  $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/req_rec.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

$accessJob = "0";
if(checkjob(2)) {
	$accessJob = "2";
}

global $lDB;

$prov_expiry_days = $lDB->get("SELECT rf_prov_expiry_days FROM rf_default",4);
$provExpiryDate = dateAddDay(date("Y-m-d"),$prov_expiry_days);

$temp0 = explode("-",$provExpiryDate);

$GLOBALS['temp']['expireDefDay'] = $temp0[2];
$GLOBALS['temp']['expireDefMonth'] = $temp0[1];
$GLOBALS['temp']['expireDefYear'] = $temp0[0];
$GLOBALS['temp']['showStatusFilters'] = "";

$consultantFilter = "AND pr_persona.pr_persona_ix IS NULL";
$modificationStatus = "";
$modificationFilter = "";
$modificationOrder = "";

$hideOrigin = false;
$showAcceptRequests = true;
$showMarkAsSeen = false;

$groupBy = 'status';

$isModReqRec = false;
$recordsPerPage = 20;
$currentPage = (int) $_SERVER['argv'][5];

if (!$currentPage) {
	$currentPage = 1;
}

$pageResIdFilterSql = '';
$pageType = !empty($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : "reqreceived";
$pageType = !empty($_SERVER['argv'][6]) ? $_SERVER['argv'][6] : $pageType;
if (
    !empty($_SERVER['argv'][1])
    && $_SERVER['argv'][1] != "reqreceived"
    && $_SERVER['argv'][1] != "waitlisted"
    && $_SERVER['argv'][1] != "modReqReceived"
) {
    $accepting = true;
} else {
    $accepting = false;
}

$GLOBALS['temp']['pageType'] = $pageType;

switch ($pageType) {
case "reqreceived":
	$statusFilter = "AND rv_reservation.rf_reservation_status_id IN ('0', '20', '30', '90', '95')";
	$GLOBALS['temp']['pageTitle'] = "Requests Received";
	break;
case "waitlisted":
	$statusFilter = "AND rv_reservation.rf_reservation_status_id = 10";
	$GLOBALS['temp']['pageTitle'] = "Waitlisted";
	$consultantFilter = "";
    $GLOBALS['temp']['showStatusFilters'] = "display: none;";
	break;
case "modReqReceived":
	$hideOrigin = true;
	$showAcceptRequests = false;
	$showMarkAsSeen = true;
	$statusFilter = '';
	$modificationStatus = "OR rv_reservation.rf_reservation_status_id = '90'";		// Show cancelled reservations
	$modificationFilter = ' AND (rv_reservation.rv_mod_request_yn = 1 OR rv_reservation.rv_mod_yn = 1)';
	$GLOBALS['temp']['pageTitle'] = 'Modifications/Requests';
	$consultantFilter = '';
	$groupBy = 'mod/req';
	$modificationOrder = 'rv_reservation.rv_mod_request_yn DESC,';
	$isModReqRec = true;
	
	$userId = $_SESSION['userid'];

	if (isset($_POST['markedAsSeen'])) {
		// Determine all the reservations that need to acknowledged and which parts
		$seenList = [];
		$seenItems = explode(':', $_POST['markedAsSeen']);	// Different acknowledgements separated by :
		
		foreach($seenItems as $item) {
			list($ackType, $resId) = explode(';', $item);		// Ack Type;Res Id
			if (!array_key_exists($resId, $seenList)) {
				// The reservation does not exist in items seen so far.. so add it
				$seenList[$resId] = [
					'ackModReq' => false,
					'ackMod' => false
				];
			}

			if ($ackType === 'Modifications') {
				// Acknowledging modifications
				$seenList[$resId]['ackMod'] = true;
			} else {
				// Acknowledging modification requests.
				$seenList[$resId]['ackModReq'] = true;
			}
		}

		// Update acknowledged reservations
		foreach($seenList as $resId => $ack) {
			$ackSql = 'UPDATE rv_reservation SET ';
			if ($ack['ackModReq']) {
				$ackSql .= "

					rv_mod_request_yn = 0,
					rv_mod_request_ack_date = NOW(),
					rv_mod_request_ack_id = '$userId'

				";
			}
			if ($ack['ackMod']) {
				if ($ack['ackModReq']) {
					$ackSql .= ',';
				}
				$ackSql .= "

					rv_mod_yn = 0,
					rv_mod_ack_date = NOW(),
					rv_mod_ack_id = '$userId'

				";
			}
			$ackSql .= "WHERE rv_reservation_ix = '$resId'";

			$lDB->put($ackSql);
		}
		if (array_key_exists('returnUrl', $_POST) && !empty($_POST['returnUrl'])) {
			redirectTo($_POST['returnUrl']);
		} else {
			redirectTo('/reservation.php?650+modReqReceived');
		}
	}
	break;
default:
	$statusFilter = "";
	$GLOBALS['temp']['pageTitle'] = "Requests Received";
	break;
}

$GLOBALS['temp']['hideOrigin'] = $hideOrigin ? 'collapse' : '';
$GLOBALS['temp']['showMarkAsSeen'] = $showMarkAsSeen ? '' : 'collapse';
if($accepting) {
	$resScrollSet = isset($_SESSION['resScrollSet'])?$_SESSION['resScrollSet']:array();

	$resScrollSet = array();
	
	// Show the accepted listing -------------------------------------------------
	$records = explode(":",$_SERVER['argv'][1]);

	$provExpiryDate = $_SERVER['argv'][3];
	$cancel_reason = addslashes(urldecode($_SERVER['argv'][4]));

	$status = $_SERVER['argv'][2];
	switch ($status) {
	case 0:
		$statusName = "rv_date_quote";
		$statusNameTo = "Quotation";
		break;
	case 10:
		$statusName = "rv_wait_list_date";
		$statusNameTo = "Wait listed";
		break;
	case 20:
		$statusName = "rv_prov_date";
		$statusNameTo = "Provisional";
		break;
	case 30:
		$statusName = "rv_confirmation_date";
		$statusNameTo = "Confirmed";
		break;	
	case 90:
		$statusName = "rv_cancel_date";
		$statusNameTo = "Cancelled";
		break;
	}
	$imax = sizeof($records);
	$today = date("Y-m-d");
  
	for($i=0;$i<$imax;$i++ ) {
		$reservationBefore = $GLOBALS['lDB']->get("
			SELECT 
				rv_reservation.rf_reservation_status_id,
				rf_reservation_status.rf_reservation_status_desc,
				rv_reservation.rv_cancel_date,
				rv_reservation.rv_cancel_reason,
				rv_reservation.rv_confirmation_date,
				rv_reservation.rv_consultant_id,
				rv_reservation.rv_date_consultant,
				rv_reservation.rv_date_quote,
				rv_reservation.rv_prov_date,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rv_wait_list_date
			FROM 
				rv_reservation
				LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			WHERE 
				rv_reservation.rv_reservation_ix = '".$records[$i]."'	
		",1);
		$moduleFieldValues = array();
		switch ($status) {
		case 0:
			$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_date_quote", 'from'=>$reservationBefore['rv_date_quote'], 'to'=>$today);
			break;
		case 10:
			$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_wait_list_date", 'from'=>$reservationBefore['rv_wait_list_date'], 'to'=>$today);
			break;
		case 20:
			$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_prov_date", 'from'=>$reservationBefore['rv_prov_date'], 'to'=>$today);
			break;
		case 30:
			$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_confirmation_date", 'from'=>$reservationBefore['rv_confirmation_date'], 'to'=>$today);
			break;	
		case 90:
			$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_cancel_date", 'from'=>$reservationBefore['rv_cancel_date'], 'to'=>$today);
			break;
		}
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_consultant_id", 'from'=>$reservationBefore['rv_consultant_id'], 'to'=>$GLOBALS['userid']);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_date_consultant", 'from'=>$reservationBefore['rv_date_consultant'], 'to'=>$today);
		$sql = "
			UPDATE rv_reservation SET
				rv_consultant_id = '".$GLOBALS['userid']."',
				rv_date_consultant = '$today',
				rv_date_changed = '$today'
		";
		
		if ( $status != "" ) {
			$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rf_reservation_status_id", 'from'=>$reservationBefore['rf_reservation_status_id'], 'to'=>$status);
			$sql .= ", rf_reservation_status_id = '$status', $statusName  = '$today'";
			
			if ( $statusName == "rv_prov_date" ) {
				$sql .= ", rv_provision_expiry_date = '$provExpiryDate' ";
				$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_provision_expiry_date", 'from'=>$reservationBefore['rv_provision_expiry_date'], 'to'=>$provExpiryDate);
			}
			
			if ( $statusName == "rv_cancel_date" ) {
				$sql .= ", rv_cancel_reason = '$cancel_reason' ";
				$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_cancel_reason", 'from'=>$reservationBefore['rv_cancel_reason'], 'to'=>$cancel_reason);
			}
		}
		
		$sql .= " WHERE rv_reservation_ix = '".$records[$i]."'";
		$GLOBALS['lDB']->put($sql);
			
		$reservationAuditTrail = new AuditTrail($records[$i],TYPE_RESERVATION);
		foreach ($moduleFieldValues as $moduleFieldValue) {
			$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
			$reservationAuditTrail->addDetail(
				$moduleFieldValue['from'],
				$moduleFieldValue['to'],
				Null,
				Null,
				DB_AD_RES_DETAIL_ACTION_EDIT,
				"resdetail",
				$moduleFieldValue['ad_module_field_name']
			);
		}
		$reservationAuditTrail->save("Reservation Status: " . $reservationBefore['rf_reservation_status_desc'] . " to " . $statusNameTo);

		// Non-stock-holding status, remove any rooming information
		if (in_array($status, array(0, 10, 90))) {
			removeRoomingInfo($records[$i]);
		}

	}
	$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/res_ownership_confirm.htm";
	$GLOBALS[$form]->FormHTML = join("",file(__DIR__ . "/../../../public/html/res_ownership_confirm.htm"));
	$GLOBALS['temp']['allocDate'] = chng_date($today,"-");
  
	$tempName = $GLOBALS['lDB']->get("
		SELECT 
			pr_name_first,
			pr_name_last 
		FROM 
			pr_persona 
		WHERE 
			pr_persona_ix = '$GLOBALS[userid]'
	",1);
  
	$GLOBALS['temp']['userName'] = trim($tempName['pr_name_first']." ".$tempName['pr_name_last']);
}

if ( $userStatusId > "1" ) {
	$agentFilterSQL = "";
} else {
	$agentFilterSQL = " AND rv_reservation.rv_agent_id = '" . $calAgentId . "' ";
}

$dbFilter = "";
$GLOBALS['temp']['rsSelect'] = "";
$GLOBALS['temp']['waSelect'] = "";
$GLOBALS['temp']['wbSelect'] = "";

if($_SERVER['argv'][2] != "" && $_SERVER['argv'][2] != "0" ) {
	$dbFilter = " AND rv_reservation.rv_reservation_db = '".$_SERVER['argv'][2]."' ";
  
	switch ($_SERVER['argv'][2]) {
	case "RS":
		$GLOBALS['temp']['rsSelect'] = " selected";
		break;	
	case "WA":
		$GLOBALS['temp']['waSelect'] = " selected";
		break;			
	case "WB":
		$GLOBALS['temp']['wbSelect'] = " selected";
		break;
	}
}

$pageFilter = "";
$GLOBALS['temp']['showPagination'] = 'collapse printCollapse';

if ($isModReqRec) {

	$totalRecords = $lDB->get("
		SELECT
			COUNT(*)
		FROM 
			rv_reservation
		WHERE
			rv_reservation.rf_reservation_status_id != '25' 
			AND rv_reservation.rf_reservation_status_id != '15' 
			AND (
				rv_reservation.rf_reservation_status_id < '40'
				OR rv_reservation.rf_reservation_status_id = '95'
				$modificationStatus
			)
			" . $modificationFilter . "
		ORDER BY 
			$modificationOrder
			rv_reservation.rf_reservation_status_id DESC 
	", 4);

	if ($totalRecords > $recordsPerPage) {
		$recordOffset = ($currentPage - 1) * $recordsPerPage;

		if ($recordOffset >= $totalRecords) {
			$currentPage = 1;
			$recordOffset = 0;
		}

		$resIdsForPage = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix
			FROM 
				rv_reservation
			WHERE
				rv_reservation.rf_reservation_status_id != '25' 
				AND rv_reservation.rf_reservation_status_id != '15' 
				AND (
					rv_reservation.rf_reservation_status_id < '40'
					OR rv_reservation.rf_reservation_status_id = '95'
					$modificationStatus
				)
				" . $modificationFilter . "
			ORDER BY 
				$modificationOrder
				rv_reservation.rf_reservation_status_id DESC 
			LIMIT $recordOffset, $recordsPerPage
		", 3);

		$resIdsForPage = array_map(function($item) {
			return "'" . $item . "'";
		}, $resIdsForPage);

		$resIdsForPage = implode(',', $resIdsForPage);
		$pageFilter = "AND rv_reservation.rv_reservation_ix IN ($resIdsForPage)";

		$totalPages = intdiv($totalRecords, $recordsPerPage);
		$totalPageLinks = 10;
		$GLOBALS['temp']['limited'] = $totalRecords;
		$GLOBALS['temp']['nextprev'] = generateModReqPaginationLinks($currentPage, $totalPages, $totalPageLinks);
		$GLOBALS['temp']['pgNum'] = $currentPage;
		$GLOBALS['temp']['showPagination'] = '';
		$nextPage = $currentPage + 1;
		$prevPage = $currentPage - 1;
		$GLOBALS['temp']['pNext'] = "/reservation.php?650+modReqReceived++++$nextPage";
		$GLOBALS['temp']['pPrev'] = "/reservation.php?650+modReqReceived++++$prevPage";

		if ($currentPage == $totalPages) {
			$GLOBALS['temp']['hideNext'] = "class=\"collapse\"";
		} else {
			$GLOBALS['temp']['hideNext'] = "";
		}

		if ($currentPage == 1) {
			$GLOBALS['temp']['hidePrev'] = "class=\"collapse\"";
		} else {
			$GLOBALS['temp']['hidePrev'] = "";
		}
	}
}

// Show the incoming listing --------------------------------------------------
$sql = "
	SELECT
		rv_reservation_item.rv_reservation_id as resId,
		rv_reservation_item.rv_item_date_arrive as dateArrive,
		rv_reservation_item.rv_item_date_depart as dateDepart,
		ac_accomm_type.pr_business_id as propId,
		rv_reservation.rv_date_recorded as dateCreated,
		pr_user_name.pr_name_last as pr_user_name_last,
		pr_user_name.pr_name_first as pr_user_name_first,
		pr_agent_name.pr_name_last as pr_agent_name_last,
		pr_agent_name.pr_name_first as pr_agent_name_first,
		pr_contact_name.pr_name_last as pr_contact_name_last,
		pr_contact_name.pr_name_first as pr_contact_name_first,
		rv_reservation.rv_note_general as resNote,
		rv_reservation.rf_reservation_status_id as statusId,
		rv_reservation.rv_provision_expiry_date as expiry,
		rv_reservation.rv_mod_request_yn as rv_mod_request_yn,
		rv_reservation.rv_mod_yn as rv_mod_yn
	FROM 
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_consultant_id
		LEFT JOIN pr_persona AS pr_agent_name ON pr_agent_name.pr_persona_ix = rv_reservation.rv_agent_id
		LEFT JOIN pr_persona AS pr_contact_name ON pr_contact_name.pr_persona_ix = rv_reservation.rv_corr_persona_id
		LEFT JOIN pr_persona AS pr_user_name ON pr_user_name.pr_persona_ix = rv_reservation.pr_reservation_user_id
	WHERE
		rv_reservation.rf_reservation_status_id != '25' 
		AND rv_reservation.rf_reservation_status_id != '15' 
		AND (
			rv_reservation.rf_reservation_status_id < '40'
			OR rv_reservation.rf_reservation_status_id = '95'
			$modificationStatus
		)
		" . $consultantFilter . "
		" . $modificationFilter . "
		" . $pageFilter . "
		" . $dbFilter . $agentFilterSQL . "
		" . $statusFilter . "
	ORDER BY 
		$modificationOrder
		rv_reservation.rf_reservation_status_id DESC, 
		rv_reservation_item.rv_item_date_arrive ASC,
		ac_accomm_type.pr_business_id
";

if ($accepting) {
	$sql = "
		SELECT
			rv_reservation_item.rv_reservation_id as resId,
			rv_reservation_item.rv_item_date_arrive as dateArrive,
			rv_reservation_item.rv_item_date_depart as dateDepart,
			ac_accomm_type.pr_business_id as propId,
			rv_reservation.rv_date_recorded as dateCreated,
			pr_user_name.pr_name_last as pr_user_name_last,
			pr_user_name.pr_name_first as pr_user_name_first,
			pr_agent_name.pr_name_last as pr_agent_name_last,
			pr_agent_name.pr_name_first as pr_agent_name_first,
			pr_contact_name.pr_name_last as pr_contact_name_last,
			pr_contact_name.pr_name_first as pr_contact_name_first,
			rv_reservation.rv_note_general as resNote,
			rv_reservation.rf_reservation_status_id as statusId,
			rv_reservation.rv_provision_expiry_date as expiry,
			rv_reservation.rv_mod_request_yn as rv_mod_request_yn,
			rv_reservation.rv_mod_yn as rv_mod_yn
		FROM 
			rv_reservation_item 
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id 
			LEFT JOIN pr_persona AS pr_agent_name ON pr_agent_name.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN pr_persona AS pr_contact_name ON pr_contact_name.pr_persona_ix = rv_reservation.rv_corr_persona_id
			LEFT JOIN pr_persona AS pr_user_name ON pr_user_name.pr_persona_ix = rv_reservation.pr_reservation_user_id
		WHERE 			
			rv_reservation.rv_reservation_ix IN ('" . join("','",$records) . "')
		ORDER BY 
			rv_reservation.rf_reservation_status_id DESC, 
			rv_reservation_item.rv_item_date_arrive ASC,
			ac_accomm_type.pr_business_id
	";
}

$result = $lDB->get($sql,2);

$resList		= array();
$reservation	= array();
$properties		= array();

foreach($GLOBALS['property_id'] as $item) {
	$properties[$item] = "";
	$propNames[$item] = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$item'",4);
}

$propList = array_keys($properties);
$propResLink = array();

$statuses = array();
$statusList	= array();

$statusArray = $lDB->get("SELECT rf_reservation_status_id, rf_reservation_status_desc FROM rf_reservation_status",2);

foreach($statusArray as $statusItem) {
	array_push($statusList,$statusItem['rf_reservation_status_id']);
	$statuses[$statusItem['rf_reservation_status_id']] = $statusItem['rf_reservation_status_desc'];
}

$hasModOrReq = false;

foreach($result as $row){
	$resId = $row['resId'];


	if($accepting) {
		array_push($resScrollSet,$resId);
	}
  
	$propId = $row['propId'];
	$statusId = $row['statusId'];
	$expiry = $row['expiry'];
	$arrive = $row['dateArrive'];
	$depart = $row['dateDepart'];
	$created = $row['dateCreated'];
	$note = $row['resNote'];

	if ($groupBy == 'mod/req') {
		$hasModOrReq = true;
	}

	if(!in_array($resId,$resList)) {
		$contact = trim($row['pr_contact_name_first'] . " " . $row['pr_contact_name_last']);
		$user = trim($row['pr_user_name_first'] . " " . $row['pr_user_name_last']);
		$agent = trim($row['pr_agent_name_first'] . " " . $row['pr_agent_name_last']);
		
		$status = $statuses[$statusId];
		$hasModRequest = $row['rv_mod_request_yn'];
		$isModified = $row['rv_mod_yn'];
		
		array_push($resList,$resId);

		
		$res = array(
			"contact" => $contact,
			"agent" => $agent,
			"user" => $user,
			"entry" => $propId,
			"props" => $propId,
			"created" => $created,
			"arrive" => $arrive,
			"depart" => $depart,
			"note" => $note,
			"payments"=>db_rv_payment_gateway_get_by_reservation($resId),
			"statusId"=>$statusId,
			"expiry"=>$expiry
		);

		$temp = array_keys($reservation);
		
		if ($groupBy == 'mod/req') {
			if ($hasModRequest) {
				if (!in_array('Modification Requests', $temp)) {
					$reservation['Modification Requests'] = $properties;
				}
				$reservation['Modification Requests'][$propId][$resId] = $res;
			}
			if ($isModified) {
				if (!in_array('Modifications', $temp)) {
					$reservation['Modifications'] = $properties;
				}
				$reservation['Modifications'][$propId][$resId] = $res;
			}
		} else {
			if ( !in_array($status,$temp) ) {
				$reservation[$status] = $properties;
			}
            if (!isset($reservation[$status]) || !is_array($reservation[$status])) {
                $reservation[$status] = array();
            }
            if (!isset($reservation[$status][$propId]) || !is_array($reservation[$status][$propId])) {
                $reservation[$status][$propId] = array();
            }
            if (!isset($reservation[$status][$propId][$resId]) || !is_array($reservation[$status][$propId][$resId])) {
                $reservation[$status][$propId][$resId] = array();
            }
			$reservation[$status][$propId][$resId] = $res;
		}
		
		$propResLink[$resId] = $propId;
	} else {
		$entry = $propResLink[$resId];
		if ($groupBy == 'mod/req') {
			if ($hasModRequest) {
				if ( preg_match("/,/",$reservation['Modification Requests'][$entry][$resId]['props']) ) {
					$thisPropList = explode(",",$reservation['Modification Requests'][$entry][$resId]['props']);
				} else {
					$thisPropList = array($reservation['Modification Requests'][$entry][$resId]['props']);
				}
				
				if ( !in_array($propId,$thisPropList) ) {
					$reservation['Modification Requests'][$entry][$resId]['props'] .= "," . $propId;
				}
				
				if ( $arrive < $reservation['Modification Requests'][$entry][$resId]['arrive'] ) {
					$reservation['Modification Requests'][$entry][$resId]['arrive'] = $arrive;
				}
				
				if ( $depart > $reservation['Modification Requests'][$entry][$resId]['depart'] ) {
					$reservation['Modification Requests'][$entry][$resId]['depart'] = $depart;
				}	
			}

			if ($isModified) {
				if ( preg_match("/,/",$reservation['Modifications'][$entry][$resId]['props']) ) {
					$thisPropList = explode(",",$reservation['Modifications'][$entry][$resId]['props']);
				} else {
					$thisPropList = array($reservation['Modifications'][$entry][$resId]['props']);
				}
				
				if ( !in_array($propId,$thisPropList) ) {
					$reservation['Modifications'][$entry][$resId]['props'] .= "," . $propId;
				}
				
				if ( $arrive < $reservation['Modifications'][$entry][$resId]['arrive'] ) {
					$reservation['Modifications'][$entry][$resId]['arrive'] = $arrive;
				}
				
				if ( $depart > $reservation['Modifications'][$entry][$resId]['depart'] ) {
					$reservation['Modifications'][$entry][$resId]['depart'] = $depart;
				}	
			}
		} else {	
			if ( preg_match("/,/",$reservation[$status][$entry][$resId]['props']) ) {
				$thisPropList = explode(",",$reservation[$status][$entry][$resId]['props']);
			} else {
				$thisPropList = array($reservation[$status][$entry][$resId]['props']);
			}
			
			if ( !in_array($propId,$thisPropList) ) {
				$reservation[$status][$entry][$resId]['props'] .= "," . $propId;
			}
			
			if ( $arrive < $reservation[$status][$entry][$resId]['arrive'] ) {
				$reservation[$status][$entry][$resId]['arrive'] = $arrive;
			}
			
			if ( $depart > $reservation[$status][$entry][$resId]['depart'] ) {
				$reservation[$status][$entry][$resId]['depart'] = $depart;
			}
		}
	}
}

$statusFilter = array();
foreach ($statusArray as $status) {
    $excludeStatuses = array('10', '15', '25', '40', '50', '90', '97');
    if (!in_array($status['rf_reservation_status_id'], $excludeStatuses)) {
        $statusFilter[] = '<div><input id="statusFilter' . $status['rf_reservation_status_id'] . '" type="checkbox" class="statusFilterCheckbox" value="' . $status['rf_reservation_status_id'] . '" onchange="filterStatuses();" checked >&nbsp;&nbsp; <label for="statusFilter' . $status['rf_reservation_status_id'] . '">' . $status['rf_reservation_status_desc'] . '</label></div>';
    }
}
$GLOBALS['temp']['statusFilter'] = join('', $statusFilter);

$rows = array();

$GLOBALS['temp']['canAccept'] = " style=\"visibility: hidden;\"";
$GLOBALS['temp']['hasModReq'] = $hasModOrReq ? '' : 'disabled';
$showAcceptRequests = false;

if(checkJob($_SERVER['argv'][0],2) > 5 && !$GLOBALS['isPropServer'] ) {
	$isConsultant = $GLOBALS['lDB']->get("
		SELECT 
			sc_group.sc_grp_consultant_yn 
		FROM 
			sc_user 
			INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id 
		WHERE 
			pr_user_id = '$GLOBALS[userid]'
	",4);

	$showAcceptRequests = true;

	if ( $isConsultant != "0" ) {
		$GLOBALS['temp']['canAccept'] = "";
	} else {
		$GLOBALS['temp']['showMarkAsSeen'] = "collapse";
	}
}

$GLOBALS['temp']['showAcceptRequests'] = $showAcceptRequests ? '' : 'collapse';

$keysA	= array_keys($reservation);
$amax		= sizeof($reservation);
$group	= array();

if ($accepting) {
	$rowHTML = join("",file(__DIR__ . "/../../../public/html/req_rec_row_click.htm"));
} else {
	$rowHTML = join("",file(__DIR__ . "/../../../public/html/req_rec_row.htm"));
}

$groupHTML = join("",file(__DIR__ . "/../../../public/html/req_rec_grp.htm"));
$out = "";
foreach($reservation as $key=>$item) {
	$group['group'] = $key;
	$group['rows']	= "";
	foreach($item as $keyB=>$itemB) {
		if(is_array($itemB)) {
			foreach($itemB as $keyC=>$itemC) {
				$row = $itemC;
				$row['resId'] = $keyC;
				
				if ( preg_match("/,/",$row['props']) ) {
					$temp = explode(",",$row['props']);
					$row['props'] = sizeof($temp);
				} else {
					$row['props'] = "1";
				}
				
				$row['arrive'] = chng_date($row['arrive'],"-");
				$row['depart'] = chng_date($row['depart'],"-");
				$row['created'] = chng_date($row['created'],"-");

				if(sizeof($row['payments']) > 0) {
					$payment = $row['payments'][0];
					$row['pay_image'] = "<button type=\"button\" class=\"button\" style=\"width:22px; height: 20px;\" onmouseover=\"overlib('Payment $payment[status] via $payment[pg_acc_name] gateway.<br /><br />Reference: $payment[rv_payment_gateway_ref]<br />Amount req: $payment[rv_payment_gateway_amt_req]$payment[rf_currency_symbol]<br />Amount paid: $payment[rv_payment_gateway_amt_paid]$payment[rf_currency_symbol]',WIDTH,200,LEFT);\" onmouseout=\"nd();\" onclick=\"openPopup('reservation.php?1008+$row[resId]',750,520);\"><img src=\"$payment[image]\" /></button>";
				} else {
					$row['pay_image'] = "&nbsp;";
				}
				unset($row['payments']);
				
				$propId = $row['entry'];
				
				$row['entry'] = t_encodeHTMLField($propNames[$propId]);
				
				if ( trim($row['note']) == "" ) {
					$row['note'] = "&nbsp;";
				} else {
					$rowNote = t_encodeOverlib($row['note']);
					$row['note']	= "<input type=\"button\" class=\"button bNote\" style=\"width: 20px; height: 20px; background-position: center center;\" onclick=\"openNote('" . $keyC . "')\" onmouseover=\"overlib('" . $rowNote . "',BELOW,OFFSETY,17,OFFSETX,-235,WIDTH,230)\" onmouseout=\"nd();\" />";
				}
				
				$row['available'] = "<img src=\"/resource/Resrequest/Application/public/img/icon_select_16.gif\" />";
				if ( check_availability($keyC) != 1 ) { //rand(0,5) < 2) { //check_availability($keyC) != 1 ) {
					$string = "<button type=\"button\" onclick=\"overbookPopup('".$row['resId']."')\" class=\"button\"><img src=\"/resource/Resrequest/Application/public/img/icon_close_16.gif\" /></button>";
					$row['available'] = $string;
				}
				$row['hideCheck'] = "";
				if ( $accepting || $GLOBALS['temp']['canAccept'] != "" ) {
					$row['hideCheck'] = " style=\"visibility:hidden\"";
				}

				if ( $row['statusId'] == "20" ) {
					$row['provClass'] = "";

					$row['expiryFormatted'] = "onmouseover=\"overlib('Expires: ".chng_date($row['expiry'],"-")."',WIDTH,110);\" onmouseout=\"nd();\"";
					$today = date("Y-m-d");
					if ( $today == $row['expiry'] ) {
						$row['provClass'] = "colOrange";
					}
					if ( $today > $row['expiry'] ) {
						$row['provClass'] = "colRed";
					}
				} else {
					$row['provClass'] = "";
					$row['expiryFormatted'] = "";
				}				
				
				$row['clickJobId'] = $accessJob;
				$row['checkboxValue'] = $groupBy == 'mod/req' ? $group['group'].';'.$row['resId'] : $row['resId'];
                $group['statusId'] = $row['statusId'];
				$group['rows'] .= showpage($row,$rowHTML);
			}
		}
	}
	$out .= showpage($group,$groupHTML);
}

$GLOBALS['temp']['hideFooter'] = "";

if (trim($out) == "") {
	$out = "<tr><td align=\"center\" width=\"770\" colspan=\"14\"><table class=\"blkBord\" width=\"770\" height=\"50\"><tr><td class=\"txt\" align=\"center\">&nbsp;&nbsp;No data matched your filter criteria.<br /> Please change your filters and press one of the report buttons above.</td></tr></table></td></tr>\n";
	$GLOBALS['temp']['hideFooter'] = "style=\"display: none;\"";
}

$GLOBALS['temp']['rows'] = $out;

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"0\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"0\">\n";

if ($accepting) {
	setRecordScroll($resScrollSet);
}
