<?php

/*
 * $Id: init.form222.php,v 1.75 2013-08-23 10:24:14 light Exp $
 *
 * $Log: init.form222.php,v $
 * Revision 1.75  2013-08-23 10:24:14  light
 * Bug #8289 - [INCL 8288&8169] Deactivated banks shown on making payment
 *
 * Revision 1.74  2011-05-30 12:49:58  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.73  2011-05-17 14:08:25  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.72  2010-10-04 16:46:53  light
 * Bug #7301 - Rates phase 1 - Search & Replace
 *
 * Revision 1.71  2008-01-31 17:29:55  light
 * Bug #5871 - Financial Interface
 *
 * Revision 1.70  2007-12-19 09:18:23  light
 * Bug #5871 - Financial Interface
 *
 * Revision 1.69  2007-11-12 13:03:48  light
 * Bug #5871 - Financial Interface
 *
 * Revision 1.68  2007-06-25 13:04:27  light
 * Fix to record payment (void button image)
 *
 * Revision 1.67  2007-06-04 12:01:24  gregs
 * Bug #5866 - Record Payments on the Financials Menu
 *
 */

/**
 * init.form222.php - Payment Capture
 * Job: 668
 * Function: 69
 */

if($_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

require_once(__DIR__ . "/class.template.php");

if (!is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/pymnt_capture.htm");
}

$record = $_SERVER['argv'][1];
$fromRes = $_SERVER['argv'][2];
$fromFolio = $_SERVER['argv'][3];
$options = $_SERVER['argv'][4];

$GLOBALS['autovar'] = "1";

if ($record != "") {
 $GLOBALS['passthrurecord'] = $record;
} else {
	if ($action != "2") {
		$record = $GLOBALS['passthrurecord'];
		if ($_SERVER['argv'][1] == "") {
			$_SERVER['argv'][1] = $record;
		}
	}
}

$GLOBALS['temp']['record'] = $record;

if ($_SERVER['argv'][0] == "669" && $pmode=="1") { 
	array_pop($GLOBALS['history']); 
}

define("REP_VIEW_HTML",0);
define("REP_VIEW_PDF",1);
define("REP_EMAIL_PDF",2);
define("REP_SEND_PDF",3);
define("REP_VIEW_CSV",4);

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
}

if($renderMode == "html") {	
	$fields = array(
		"rv_payment_id",
		"rv_pmnt_date",
		"rv_pmnt_date_created",
		"rv_pmnt_note",
		"rv_pmnt_ref",
		"rv_pmnt_amount",
		"rv_pmnt_user_id",
		"pr_persona_id",
		"rf_currency_id",
		"rf_mthd_pmnt_id",
		"rf_bank_id"
	);
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"rv_payment",$fields,"rv_payment_ix = '$record'","","","");
	
	
	$rv_payment_db = $GLOBALS['lDB']->get("SELECT rv_payment_db FROM rv_payment WHERE rv_payment_ix = '$record'",4);
	$rv_payment_trf_yn = $GLOBALS['lDB']->get("SELECT rv_payment_trf_yn FROM rv_payment WHERE rv_payment_ix = '$record'",4);

	// Form 222 - The Payment Module
	if($_SERVER['argv'][0] == "669" && $pmode == "1") {
		if($_SESSION['saveTest'] == "1") {
			if($_POST['rv_contra_payment_id'] != "") {
				if ($_SESSION['saveDelete'] == "1") {
					session_set(array(
						'saveTest'=>"0",
						'saveDelete'=>"0"
					));
					redirectTo(" reservation.php?668");
					die();
				}
			} else {
				session_set("saveTest","0");
				redirectTo(" reservation.php?668");
				die();
			}
		}
	}

	session_set("saveTest","1");
	
	if ($_SERVER['argv'][0] == "668" || $_SERVER['argv'][0] == "667") {
		session_set("saveTest","0");
	}
	
	if ($pmode == "1") { 
		session_set("saveDelete","0");
	}
	
	if ($action == "2" && $pmode == "1") {
		if ($_POST['rv_contra_payment_id'] != "") {
			session_set("saveDelete","1");
			$sql = "
				SELECT
					rv_payment.rf_currency_id,
					rv_payment.rv_pmnt_ref,
					rf_mthd_pmnt.rf_mthd_pmnt_ix
				FROM
					rv_payment
				LEFT JOIN rf_mthd_pmnt ON
					rf_mthd_pmnt.rf_mthd_pmnt_sys_code = 1
				WHERE
					rv_payment.rv_payment_ix = '".$_POST['rv_contra_payment_id']."'
			";
			$data = $lDB->get($sql,1);

			$_POST['select_day'] = date("d");
			$_POST['select_month'] = (int) date("m");
			$_POST['select_year'] = date("Y");
			$_POST['rf_currency_id'] = $data['rf_currency_id'];
			$_POST['rf_mthd_pmnt_id'] = $data['rf_mthd_pmnt_ix'];
			$_POST['rv_pmnt_ref'] = $data['rv_pmnt_ref'];
			$_POST['pr_persona_id'] = $GLOBALS['userid'];

			$sql = "
				SELECT
					fn_folio_id,
					rv_payment_item_ix,
					rv_payment_item_amt,
					rv_pay_item_amt_rec,
					rv_pay_item_exch_rate
				FROM
					rv_payment_item
				WHERE
					rv_payment_item_ix 
				IN
					('".join("','",$_POST['contraItems'])."')
			";
			
			$list = $lDB->get($sql,2);
			$imax = sizeof($list);
			
			for ($i = 0; $i < $imax; $i++) {
				$item = $list[$i];
				$folioId = $item['fn_folio_id'];
				$_POST['paidAmount'][$folioId] = $item['rv_pay_item_amt_rec'] * -1;
				$_POST['exchRate'][$folioId] = $item['rv_pay_item_exch_rate'];
				$_POST['recptAmount'][$folioId] = $item['rv_payment_item_amt'] * -1;
				$_POST['contraList'][$folioId] = $item['rv_payment_item_ix'];

				fixAmtDisplay($_POST['paidAmount'][$folioId]);
				fixAmtDisplay($_POST['recptAmount'][$folioId]);
			}
		}
	}
	
	$GLOBALS[$form]->Get($action);
	
	$table = $GLOBALS[$form]->TableList[0];
	
	if ($record != "" || $action == "3" && $action != "1") {
		$GLOBALS[$table]->Refresh($record,$action);
	}

	if ($action == "2") {
		$GLOBALS['form222_rv_payment_rv_payment_db']->SetValue($dbcode);
		$GLOBALS['form222_rv_payment_rv_pmnt_date_created']->SetValue(date("Y-m-d H:i:s"));
	}
	
	$GLOBALS['temp']['hidePayerSearch'] = "";
	
	if ($action == "1") {
		$GLOBALS['temp']['hidePayerSearch'] = " style=\"visibility:hidden\"";
	} else {
		if ($action == "3" && (checkJob($_SERVER['argv'][0],2) < 15 || ($rv_payment_db == $GLOBALS['dbcode'] && $rv_payment_trf_yn == "0" && $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] < 15) )) {
			$GLOBALS['temp']['hidePayerSearch'] = " style=\"visibility:hidden\"";
		}
	}
	
	$GLOBALS['temp']['fromRes'] 	= $fromRes;
	$GLOBALS['temp']['fromFolio'] = $fromFolio;
	$GLOBALS['temp']['randomId']	= md5(uniqid(rand(),1));
	$GLOBALS['temp']['resId'] 		= $fromRes;
	
	if ($action == "2" && $pmode == 0) {
		$GLOBALS['temp']['reservationId'] = "";
		$GLOBALS['temp']['hideReturnRes'] = " style=\"visibility:hidden\"";
		$GLOBALS['temp']['resId'] 				= "";
		
		$execCode = "";
		
		if ($fromFolio != "") {
			$fromRes = $lDB->get("
				SELECT 
					rv_reservation_id 
				FROM 
					fn_folio 
				WHERE 
					fn_folio.fn_folio_ix = '".$fromFolio."'
			",4);
			
			$GLOBALS['temp']['reservationId'] = $fromRes;
			$GLOBALS['temp']['resId'] 				= $fromRes;
			$GLOBALS['temp']['hideReturnRes'] = "";
			
			$resName = $lDB->get("
				SELECT 
					rv_res_name 
				FROM 
					rv_reservation 
				WHERE 
					rv_reservation_ix = '".$fromRes."'
			",4);
			
			$currency = $GLOBALS['lDB']->get("
				SELECT 
					rf_currency_id 
				FROM 
					fn_folio 
				WHERE 
					fn_folio_ix = '".$fromFolio."'
			",4);
			
			$GLOBALS['form222_rv_payment_rf_currency_id']->SetValue($currency);
			
			$_POST['pr_persona_id'] = $lDB->get("
				SELECT 
					fn_folio_to_id 
				FROM 
					fn_folio 
				WHERE 
					fn_folio_ix = '".$fromFolio."'
			",4);
			$execCode = "<script>loadRes('".$fromRes."','','".t_encodeOverlib($resName)."');</script>";
		} elseif ($fromRes != "" && $fromRes != "conf") {
			$GLOBALS['temp']['reservationId']	= $fromRes;
			$GLOBALS['temp']['resId'] 				= $fromRes;
			$GLOBALS['temp']['hideReturnRes'] = "";
			
			$currency = $GLOBALS['lDB']->get("
				SELECT 
					rv_invoice_currency_id 
				FROM 
					rv_reservation 
				WHERE 
					rv_reservation_ix = '".$fromRes."'
			",4);
			
			$GLOBALS['form222_rv_payment_rf_currency_id']->SetValue($currency);
			
			$_POST['pr_persona_id'] = $lDB->get("
				SELECT 
					fn_folio_to_id 
				FROM 
					fn_folio 
				WHERE 
					rv_reservation_id = '".$fromRes."' 
				ORDER BY 
					fn_folio_folio_num 
				ASC 
				LIMIT 1
			",4);
			$execCode = "<script>loadRes('".$fromRes."','','".t_encodeOverlib($resName)."');</script>";
		} else {
			if ($userStatusId > 1) {
				$sql = "
					SELECT
						rf_currency.rf_currency_ix
					FROM
						rt_rate_type
						INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_ix
					WHERE
						rt_rate_type.rt_rate_type_inactive_yn = '0'
					ORDER BY
						rt_rate_type.rt_rate_type_desc
					LIMIT 1
				";
				$currency = $GLOBALS['lDB']->get($sql,4);
				$GLOBALS['form222_rv_payment_rf_currency_id']->SetValue($currency);
			}
		}
	}

	// Set up defaults
	$disabledList = array();
	$hideList 		= array();
	$tabcount 		= "1";

	$GLOBALS['temp']['hideAddItem'] = " style=\"visibility:hidden\"";
	
	if ($action == "2" || $GLOBALS['job'] == "669") {
		$GLOBALS['temp']['hideAddItem'] = "";
	}
	
	$GLOBALS['temp']['onload'] = "";
	
	if ($GLOBALS['job'] == "669") {
		// $GLOBALS['temp']['onload'] = "addPayItem()";
	 }

	// The payer/payee name display field
	$pr_persona 		= "payer";
	$pr_persona_id 	= "form222_rv_payment_".$pr_persona;
	$name 					= "";
	
	if ($_POST['pr_persona_id'] != "") {
		$GLOBALS['form222_rv_payment_pr_persona_id']->Value = $_POST['pr_persona_id'];
	}
	
	if ($action == "2" && $pmode == "0" && ($fromRes == "" || $fromRes == "conf")) {
		$GLOBALS['form222_rv_payment_pr_persona_id']->Value = $GLOBALS['userid'];
		
		if ($GLOBALS['pr_agent_link'] != "" && $GLOBALS['pr_agent_link'] != "0") {
			$GLOBALS['form222_rv_payment_pr_persona_id']->Value = $GLOBALS['pr_agent_link'];
		}
	}

	if ($GLOBALS['form222_rv_payment_pr_persona_id']->Value != "") {
		if ($GLOBALS['form222_rv_payment_pr_persona_id']->Value == "0") {
			$name = "Cash";
		} else {
			$tempname = $GLOBALS['lDB']->get("
				SELECT 
					pr_name_first,
					pr_name_last 
				FROM 
					pr_persona 
				WHERE 
					pr_persona_ix = '".$GLOBALS['form222_rv_payment_pr_persona_id']->Value."'
			",1);
			$name = trim($tempname['pr_name_first']." ".$tempname['pr_name_last']);
		}
	}
	
	$GLOBALS[$form]->AddField($pr_persona_id,$pr_persona,$name,0);
	$GLOBALS[$pr_persona_id]->Size = "40";
	$GLOBALS[$pr_persona_id]->TabIndex = $tabcount++;
	$GLOBALS[$pr_persona_id]->StyleType = "txt";
	
	array_push($disabledList,$pr_persona_id);

	// Set up the three date dropdowns
	$days = array("0" => ":|:");
	
	for ($x = 1; $x < 32; $x++) {
		$days[$x] = str_pad($x,2,"0",STR_PAD_LEFT).":|:".date("d",mktime(0,0,0,1,$x,2000));
	}
	
	$months = array("0" => ":|:");
	
	for ($x = 1; $x < 13; $x++) {
		$months[$x] = $x/*str_pad($x,2,"0",STR_PAD_LEFT)*/.":|:".date("M",mktime(0,0,0,$x,1,2000));
	}

	$SdValue = date("d");
	$SmValue = date("m");
	$SyValue = date("Y");
	
	if ($action == "2") {
		$start = date("Y-m-d");
	} else {
		$start = $GLOBALS['form222_rv_payment_rv_pmnt_date']->Value;
	}
	
	if ($start == "0000-00-00") {
		$start = date("Y-m-d");
		echo "Date Incorrect!<br />";
	}
	
	if ($start != "" && start != "0000-00-00") {
		$temp 		= explode("-",$start);
		$SdValue 	= $temp[2];
		$SmValue 	= $temp[1];
		$SyValue 	= $temp[0];
		
		if ($action == "2" && $pmode == "0") {
			$temp2 		= explode("-",date("Y-m-d",mktime(0,0,0,$SmValue,$SdValue,$SyValue)));
			$SdValue 	= $temp2[2];
			$SmValue 	= $temp2[1];
			$SyValue 	= $temp2[0];
		}
	}
	
	$newDfield = "select_day";
	$GLOBALS[$form]->AddField($newDfield,$newDfield,$SdValue,0);
	$GLOBALS[$newDfield]->Select($days);
	$GLOBALS[$newDfield]->Size = "4";
	$GLOBALS[$newDfield]->TabIndex = $tabcount++;
	$GLOBALS[$newDfield]->onChange = "";

	$newMfield = "select_month";
	$GLOBALS[$form]->AddField($newMfield,$newMfield,$SmValue,0);
	$GLOBALS[$newMfield]->Select($months);
	$GLOBALS[$newMfield]->Size = "7";
	$GLOBALS[$newMfield]->TabIndex = $tabcount++;
	$GLOBALS[$newMfield]->onChange = "select_daymonth_changed();";

	$newYfield = "year";
	$GLOBALS[$form]->AddField($newYfield,$newYfield,$SyValue,0);
	$GLOBALS[$newYfield]->Size = "2";
	$GLOBALS[$newYfield]->StyleType = "txt";
	$GLOBALS[$newYfield]->TabIndex = $tabcount++;
	$GLOBALS[$newYfield]->onChange = "select_daymonth_changed();";

	$bankList = $GLOBALS['lDB']->get("
		SELECT
			rf_bank.rf_bank_ix,
			rf_bank.rf_bank_acc_name,
			rf_currency.rf_currency_ix,
			rf_currency.rf_currency_symbol,
			rf_bank_env.rf_bank_env_default_yn
		FROM
			rf_database
		INNER JOIN rf_bank_env ON 
			rf_bank_env.rf_database_id = rf_database.rf_database_id
		INNER JOIN rf_bank ON 
			rf_bank.rf_bank_ix = rf_bank_env.rf_bank_id
		INNER JOIN rf_currency ON 
			rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			rf_database.rf_db_code = '$GLOBALS[dbcode]'
			AND rf_bank.rf_bank_inactive_yn = '0'
	",2);
	
	$bankOptions = "";
	$bankCurrencyList = "";
	
	foreach($bankList as $item) {
		$selected = "";
		
		if($action != "1" && $item['rf_bank_env_default_yn'] == "1") {
			$selected = "selected";
		}

		if($action == "1" && $GLOBALS['form222_rv_payment_rf_bank_id']->Value == $item['rf_bank_ix']) {
			$selected = "selected";
		}
		
		$bankOptions .= '<option ' . $selected . ' value="' . $item['rf_bank_ix'] . '">' . $item['rf_bank_acc_name'] . '</option>';
		$bankCurrencyList .= "bankCurrencyIdArray['$item[rf_bank_ix]'] = \"$item[rf_currency_ix]\";\n";
		$bankCurrencyList .= "bankCurrencyNameArray['$item[rf_bank_ix]'] = \"$item[rf_currency_symbol]\";\n";
	}
	
	$GLOBALS['temp']['bankCount'] = sizeof($bankList);
	$GLOBALS['temp']['envCode'] 	= $dbcode;
	$sysAdminId = $GLOBALS['lDB']->get("
		SELECT
			pr_persona_id
		FROM
			rf_sys_admin
		WHERE
			rf_sys_admin_primary = 1
		LIMIT 1
	",4);
	
	$sysAdminDetails = $GLOBALS['lDB']->get("
		SELECT
			pr_email,
			pr_name_first,
			pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$sysAdminId'
	",1);
	
	$GLOBALS['temp']['sysAdminName'] = trim($sysAdminDetails['pr_name_first'] . " " . $sysAdminDetails['pr_name_last']);
	$GLOBALS['temp']['sysAdminEmail'] = $sysAdminDetails['pr_email'];
	
	if(sizeof($bankList) > 0) {
		$GLOBALS['temp']['bankOptions'] = $bankOptions;
	} else {
		$GLOBALS['temp']['bankOptions'] = '<option selected value="0">No banks or cash points defined for this environment</option>';
		$bankCurrencyList = "bankCurrencyIdArray[0] = \"0\";\n";
		$bankCurrencyList = "bankCurrencyNameArray[0] = \"Unknown\";\n";
	}
	
	$GLOBALS['temp']['bankCurrencyList'] = $bankCurrencyList;

	// Set up the currency field
	$sql = "
		SELECT
			rf_currency_db,rf_currency_id,
		IF (
				rf_currency_inactive_yn <> '0',CONCAT('* ',rf_currency_symbol),rf_currency_symbol
			)
		AS 
			rf_currency_symbol
		FROM
			rf_currency
		WHERE
			rf_currency_inactive_yn = '0'
		OR (
			rf_currency_ix = '".$GLOBALS['form222_rv_payment_rf_currency_id']->Value."'
			)
		ORDER BY
			rf_currency.rf_currency_symbol
	";
	
	$GLOBALS['form222_rv_payment_rf_currency_id']->Select(combolist($GLOBALS['lDB'],$sql));
	$GLOBALS['form222_rv_payment_rf_currency_id']->TabIndex = $tabcount++;
	$GLOBALS['form222_rv_payment_rf_currency_id']->StyleType = "txtR";
	$GLOBALS['form222_rv_payment_rf_currency_id']->Width = "60";

	// Set up the method of payment field
	$sysCode = "0";
	if ($GLOBALS['form222_rv_payment_rf_mthd_pmnt_id']->Value != "") {
		$sysCode = $lDB->get("
			SELECT 
				rf_mthd_pmnt_sys_code 
			FROM 
				rf_mthd_pmnt 
			WHERE 
				rf_mthd_pmnt_ix = '".$GLOBALS['form222_rv_payment_rf_mthd_pmnt_id']->Value."'
		",4);
	 }
	
	if ($action == "2" || $sysCode == "0") {
		$sql = "
			SELECT 
				rf_mthd_pmnt_db,
				rf_mthd_pmnt_id,
				rf_mthd_pmnt_desc 
			FROM 
				rf_mthd_pmnt 
			WHERE 
				rf_mthd_pmnt_inactive_yn = '0'
			AND 
				rf_mthd_pmnt_sys_code = 0 
			ORDER BY 
				rf_mthd_pmnt_desc";
	} else {
		$sql = "
			SELECT 
				rf_mthd_pmnt_db,
				rf_mthd_pmnt_id,
				rf_mthd_pmnt_desc 
			FROM 
				rf_mthd_pmnt 
			WHERE 
				rf_mthd_pmnt_inactive_yn = '0'
			ORDER BY 
				rf_mthd_pmnt_desc
		";
	}

	$GLOBALS['form222_rv_payment_rf_mthd_pmnt_id']->Select(combolist($GLOBALS['lDB'],$sql,"0:|:"));
	$GLOBALS['form222_rv_payment_rf_mthd_pmnt_id']->TabIndex = $tabcount++;
	$GLOBALS['form222_rv_payment_rf_mthd_pmnt_id']->StyleType = "txt";
	$GLOBALS['form222_rv_payment_rf_mthd_pmnt_id']->Width = "132";

	$sql = "
		SELECT
			rf_bank_db,
			rf_bank_id,
			rf_bank_acc_name
		FROM 
			rf_bank 
		ORDER BY
			rf_bank_acc_name
	";
	
	$GLOBALS['form222_rv_payment_rf_bank_id']->Select(combolist($GLOBALS['lDB'],$sql,"0:|:"));
	$GLOBALS['form222_rv_payment_rf_bank_id']->TabIndex = $tabcount++;
	$GLOBALS['form222_rv_payment_rf_bank_id']->StyleType = "txtR";
	$GLOBALS['form222_rv_payment_rf_bank_id']->Width = "181";
	
	if(trim($GLOBALS['form222_rv_payment_rf_bank_id']->Value) == "") {
		// Find linked bank....
		$businessId = $GLOBALS['lDB']->get("
			SELECT
				pr_business_id
			FROM
				rf_db_business
			WHERE
				rf_db_code = '$GLOBALS[dbcode]'
		",4);
		
		$bankId = $GLOBALS['lDB']->get("
			SELECT
				rf_bank_id
			FROM
				pr_bus_bank
			WHERE
				pr_business_id = '$businessId'
			",4);
		
		if($bankId == "0" || trim($bankId) == "") {
			$bankId = "";
		}
		
		$GLOBALS['form222_rv_payment_rf_bank_id']->SetValue($bankId);
	}

	// Set up the payment amount field
	$GLOBALS['form222_rv_payment_rv_pmnt_ref']->Class = "0";
	$GLOBALS['form222_rv_payment_rv_pmnt_ref']->Size = "30";
	$GLOBALS['form222_rv_payment_rv_pmnt_ref']->TabIndex = $tabcount++;
	$GLOBALS['form222_rv_payment_rv_pmnt_ref']->StyleType = "txt";

	// Set up the payment amount field
	$GLOBALS['form222_rv_payment_rv_pmnt_note']->Rows = "5";
	$GLOBALS['form222_rv_payment_rv_pmnt_note']->Cols = "80";
	$GLOBALS['form222_rv_payment_rv_pmnt_note']->TabIndex = $tabcount++;
	$GLOBALS['form222_rv_payment_rv_pmnt_note']->StyleType = "txt";

	// Set the payment user id (recorder)
	$GLOBALS['form222_rv_payment_rv_pmnt_user_id']->SetValue($GLOBALS['userid']);
	
	// Disable the selected fields
	$table = $GLOBALS[$form]->TableList[0];
	
	$GLOBALS['temp']['bankDisabled'] = "";
	if($action == "1") {
		$GLOBALS['temp']['bankDisabled'] = "disabled";
	}
	
	if ($action == "3") {
		if (checkJob("669",2) != "15" && !($rv_payment_db == $GLOBALS['dbcode'] && $rv_payment_trf_yn == "0" && $GLOBALS['jobLevelArray'][669] == "15")) {
			$disabledList = array("form222_rv_payment_payer",
														"select_day",
														"select_month",
														"year",
														"form222_rv_payment_rf_currency_id",
														"form222_rv_payment_rf_mthd_pmnt_id",
														"form222_rv_payment_rv_pmnt_ref",
														"form222_rv_payment_rv_pmnt_note");
			$GLOBALS[$table]->Keys = array_merge($GLOBALS[$table]->KeyList,$disabledList);
		}
		
		array_push($disabledList,"form222_rv_payment_rf_currency_id");
		array_push($disabledList,"form222_rv_payment_rv_pmnt_amount");
		array_push($GLOBALS[$table]->Keys,"form222_rv_payment_rf_currency_id");
	}
	
	$GLOBALS['temp']['payConfirm'] = "";
	
	if ($fromRes != "") {
		$GLOBALS['temp']['payConfirm'] = "class=\"collapse\"";   
		// array_push($disabledList,"form222_rv_payment_rf_currency_id");
	}   	 
	
	array_push($GLOBALS[$table]->Keys,"form222_rv_payment_rv_pmnt_date_created");
	array_push($disabledList,"form222_rv_payment_payer");
	
	$GLOBALS[$form]->Disable($disabledList);

	array_push($hideList,"form222_rv_payment_pr_persona_id");
	
	$GLOBALS[$form]->Hide($hideList);

	// On post, compile the date from the day, month and year inputs
	if ($pmode == "1") {
		if (trim($_POST['year']) != "" && trim($_POST['select_month']) != "" && trim($_POST['select_day']) != "") {
			$date = $_POST['year']."-".$_POST['select_month']."-".$_POST['select_day'];
		} else {
			$date = date("Y-m-d");
		}
		$GLOBALS['form222_rv_payment_rv_pmnt_date']->SetValue($date);
		$GLOBALS['form222_rv_payment_rf_bank_id']->SetValue($_POST['bankId']);
	}

	$newr 	= 668;
	$edit 	= $newr + 2;
	$view 	= $newr - 1;
	$dele 	= $newr + 4;
	$sedit	= $edit + 1;
	$snewr 	= $newr + 1;
	
	// Start Access Control Toolbar Setup
	$pgJOBS = array();
	$pgJOBS['view'] = "0";
	if (checkJob($view)) {
		$pgJOBS['view'] = "1";
	}
	$pgJOBS['add'] = "0";
	if (checkJob($newr)) {
		$pgJOBS['add'] = "1";
	}
	$pgJOBS['edit'] = "0";
	if (checkJob($edit,2) == "15" || ($rv_payment_db == $GLOBALS['dbcode'] && $rv_payment_trf_yn == "0" && $GLOBALS['jobLevelArray'][$edit] == "15")) {
		$pgJOBS['edit'] = "1";
	}
	$pgJOBS['del'] = "0";
	$pgJOBS['save'] = "0";
	if ($action == "2" || ($action == "3" && checkJob($edit,2) == "15")) {
		$pgJOBS['save'] = "1";
	}
	if ($action == "2" || $action == "4" || $record == null) {
		$pgJOBS['edit'] = "0";
	}
	$GLOBALS['temp']['pgJobs']  = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
	$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
	$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
	$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
	// End Access Control Toolbar Setup

	$GLOBALS['temp']['new_record'] = "reservation.php?".$newr;

	switch ($action) {
	case (0) : // List Records
		break;		
	case (1) : // Display Record
		$GLOBALS['mode'] = "display";
		$GLOBALS[$form]->Arguments = (string) $snewr."+".$record."+".$fromRes;
		$GLOBALS['temp']['edit_view'] = "reservation.php?".$edit."+".$record."+".$fromRes;
		$GLOBALS['temp']['save_record'] = "#";
		$GLOBALS['temp']['del_record'] = "#";
		break;
	case (2) : // Add Record
		$GLOBALS[$form]->Arguments = (string) $snewr."++".$fromRes;
		$GLOBALS['temp']['edit_view'] = "#";
		$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
		$GLOBALS['temp']['del_record'] = "#";
		$GLOBALS['mode'] = "new";
		break;	
	case (3) : // Edit Record
		$GLOBALS[$form]->Arguments = (string) $sedit."+".$record."+".$fromRes;
		$GLOBALS['mode'] = "edit";
		$GLOBALS['temp']['edit_view'] = "reservation.php?".$view."+".$record."+".$fromRes;
		$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
		$GLOBALS['temp']['del_record'] = "reservation.php?".$dele."+".$record;
		break;
	case (4) : // Delete Record
		$GLOBALS['initrecord'] = $record;
		$GLOBALS['delrecord'] = $record;
		break;
	}
	
	$GLOBALS['temp']['new_record'] .= "++".$_SERVER['argv'][2]."+".$_SERVER['argv'][3];

	if (($fromRes == "" || $fromRes == "conf") && $fromFolio == "") {
		$GLOBALS['tagList']['returnToRes'] = blankObject();
	}

	if (($action != "2" && $pmode == "0") || $fromRes != "") {
		$GLOBALS['tagList']['findRes'] = blankObject();
		$GLOBALS['tagList']['totalAmount'] = setNewValue($GLOBALS['form222_rv_payment_rv_pmnt_amount']->Value);
		$GLOBALS['tagList']['rv_pmnt_amount'] = setNewValue($GLOBALS['form222_rv_payment_rv_pmnt_amount']->Value);
		$GLOBALS['tagList']['rv_payment_ix'] = setNewValue($record);
		
		$userRefNum = $GLOBALS['form222_rv_payment_rv_pmnt_ref']->Value;
		
		$GLOBALS['temp']['noRef'] = "";
		
		if($userRefNum == ""){
			$GLOBALS['temp']['noRef'] = "collapse printCollapse";
		} else {
			$GLOBALS['tagList']['userRefNum'] = setNewValue($userRefNum);
		}
		
		if ($_SERVER['argv'][0] != "668" && $pmode != "1") {
			$test = $lDB->get("
				SELECT 
					rf_mthd_pmnt_sys_code 
				FROM 
					rv_payment 
					INNER JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_id = rv_payment.rf_mthd_pmnt_id 
				WHERE 
					rv_payment_ix = '".$record."'
			",4);
			
			if ($test == "0") {
				$GLOBALS['tagList']['saveBut'] = setNewParam("class","collapse printCollapse");
				
				$paymentDB = $lDB->get("
					SELECT 
						rv_payment_db 
					FROM 
						rv_payment 
					WHERE 
						rv_payment_ix = '$record'
				",4);
				
				$paymentTrf = $lDB->get("
					SELECT 
						rv_payment_trf_yn 
					FROM 
						rv_payment 
					WHERE 
						rv_payment_ix = '$record'
				",4);
				
				if(canEditDB($paymentDB) || ($paymentTrf == "0" && $paymentDB == $GLOBALS['dbcode']) ) {
					$GLOBALS['tagList']['delButton'] = setNewParam("class","button");                       
					$GLOBALS['tagList']['delButton2'] = setNewParam("class","button");                       
				}
			} else {
				$GLOBALS['tagList']['saveBut'] = setNewParam("class","expand");         
				$GLOBALS['tagList']['saveButton'] = blankObject();
			}
		}
	}
	
	if (($action == "2" && $pmode == "0") && $fromRes == "") {
		$GLOBALS['tagList']['payHeader'] = blankObject();
	}

	if ($reservationId != "" || ($action != "2" && $pmode == "0")) {
		$divKey = "rowreplacer";
		$resList = $lDB->get("
			SELECT DISTINCT 
				rv_reservation_id 
			FROM 
				rv_payment_item 
			WHERE 
				rv_payment_id = '".$record."'
		",3);
		
		$rf_currency_id = $lDB->get("
			SELECT 
				rf_currency_id 
			FROM 
				rv_payment 
			WHERE 
				rv_payment_ix = '".$record."'
		",4);

		$HTML = join("",file(__DIR__ . "/../../../public/html/temp.htm"));

		$GLOBALS['tagList'][$divKey]  = "<input type=\"hidden\" name=\"mode\" value=\"!mode!\" />\n";
		$GLOBALS['tagList'][$divKey] .= "<input type=\"hidden\" name=\"rv_contra_payment_id\" value=\"" . $record . "\" />\n";
		$GLOBALS['tagList'][$divKey] .= getItemsPerPayment($divKey,$resList,$rf_currency_id,$HTML,1,$record);
	}
	
	if ($pmode == "0") {
		if ($_SERVER['argv'][0] == "669" || ($fromRes != "" && $_SERVER['argv'][0] != "669" && $_SERVER['argv'][0] != "668")) {
			if ($pmode == "0") {
				$GLOBALS['tagList']['title'] = "Payment";
				if ($sysCode != "0") {
					$GLOBALS['tagList']['title'] = "Adjustment";
				}
			}
			$GLOBALS['temp']['hideConf'] 			= "colLt";
			$GLOBALS['temp']['hideConfPrint'] = "button";
			$GLOBALS['temp']['hideConfEmail'] = "button";
			$GLOBALS['temp']['hideConfPdf'] 	= "button";
		} else {
			$GLOBALS['tagList']['payConfirm'] = blankObject();
			$GLOBALS['temp']['hideConf'] 	= "collapse printCollapse";
			$GLOBALS['temp']['hideConfPrint'] = "collapse printCollapse";
			$GLOBALS['temp']['hideConfEmail'] = "collapse printCollapse";
			$GLOBALS['temp']['hideConfPdf'] = "collapse printCollapse";
		}
		$GLOBALS['tagList']['currLabel'] = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$rf_currency_id'",4);
		$GLOBALS['tagList']['currLabel2'] = $GLOBALS['tagList']['currLabel'];
	}

	$GLOBALS['temp']['logoURL'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/top_clientlogo.jpg";
	$GLOBALS['temp']['principalName'] = getContactFullName($principalId);

	if ($execCode != "") {
		$GLOBALS[$form]->FormHTML = str_replace("</body>",$execCode."\n</body>",$GLOBALS[$form]->FormHTML);
	}	
}

if ($renderMode == "pdf") {
	if ($record != "") {
		// Get the data for the pdf
		$sql = "
			SELECT
				rv_payment.rv_payment_ix,
				rv_payment.rv_pmnt_date,
				rv_payment.rv_pmnt_ref,
				rv_payment.rv_pmnt_amount,
				rv_payment.rf_currency_id,
				rf_mthd_pmnt.rf_mthd_pmnt_desc,
				rv_payment.rv_pmnt_user_id,
				rv_payment.pr_persona_id,
				rv_payment.rv_pmnt_note,
				rf_bank.rf_bank_acc_name
			FROM
				rv_payment
				LEFT JOIN rf_mthd_pmnt ON rv_payment.rf_mthd_pmnt_id = rf_mthd_pmnt.rf_mthd_pmnt_ix
				LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
			WHERE
				rv_payment.rv_payment_ix = '".$record."'
		";
		$data = $lDB->get($sql,2);    
	}
	
	if($renderMode == "pdf" && $renderType == "email") {    
		$pdfName = "Payment Capture Receipt: Ref" . $data['rv_pmnt_ref'];
		$attachmentTable = "
			<table border=\"0\" cellspacing=\"0\" width=\"100%\">
				<tr valign=\"top\">
					<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
					<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
				</tr>
			</table>";
		$newOptions = ($options & ~3) + 3;
		$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,4))."+$newOptions";

		$GLOBALS[$form]->FormHTML = 
			str_replace("!formAction!",$formAction,
			str_replace("!attachmentInfo!",$attachmentTable,
			str_replace("!attachmentName!",$pdfName.".pdf",
			str_replace("!hasAttachment!","expand",
			str_replace("!emailBody!","",
			str_replace("!emailSubject!",$pdfName,
			Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
		
		$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
		$resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
		
		$principalInfo = getPersonaDetail($principalId);
		$resOfficeInfo = getPersonaDetail($resOfficeId);
		$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
		
		$GLOBALS['temp']['princName'] = $principalInfo['name'];
		$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
		$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
		$userId = $_SESSION['userid'];
		$GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_email
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix = '$userId'
		",4);
		$GLOBALS['temp']['emailTo'] = "";
	}
			 
	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$pdf = new PDF("Payment Capture Receipt");
		$reportLabel = "Payment Receipt";

		$logoY = $pdf->y;
		$pdf->Ln(0, 1);
		$server = $_SESSION['server'];
		$principal_id = $_SESSION['principal_id'];
		$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/".$principal_id."/top_clientlogo.jpg");
		
		if ($pic['w'] > $pdf->GetPageWidth(1)/4) {
			$pic['w'] = $pdf->GetPageWidth(1)/4;
		}
		
		require_once(__DIR__ . '/functions.imageset.php');
		$logoWidth = imagesetLogoSizeOverride("paymentCaptureReceiptPdfLogoWidthOverride", $pic['w']);
		$finalH = $pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/top_clientlogo.jpg", ($pdf->GetPageWidth(1)/3)-($pic['w']/1), $logoY, $logoWidth);
		if (($logoY + $finalH) > $pdf->y) {
			$pdf->y = $logoY + $finalH;
		}
		
		$currSym = $GLOBALS['lDB']->get("
			SELECT
				rf_currency_symbol
			FROM
				rf_currency
			WHERE
				rf_currency_ix = '".$data[0]['rf_currency_id']."'
		",4);
		
		$payer = $GLOBALS['lDB']->get("
			SELECT
				pr_name_first,
				pr_name_last
			FROM
				pr_persona
			WHERE
				pr_persona_ix = '".$data[0]['pr_persona_id']."'
		",1);
		
		if ($payer['pr_name_first'] != "") {
			$payer['pr_name_first'] .= ", ";
		}
		
		$payerPayee = $payer['pr_name_first'].$payer['pr_name_last'];
		
		$pdf->Ln(1);
		$pdf->SetFont('Arial', '', 9);
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "97%", data =>"Recorded Payment")
		));
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "97%", data =>"Thank-you. Your transaction was successful")
		));

		$pdf->Ln(1);
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Reference Number:", style=>"B"),
			array(width => "80%", data =>$data[0]['rv_pmnt_ref'], style=>"B")
		));
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Receipt Number:", style=>"B"),
			array(width => "80%", data =>$data[0]['rv_payment_ix'], style=>"B")
		));
		
		$pdf->Ln(10);
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Payer/payee:"),
			array(width => "80%", data =>$payerPayee)
		));
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Date:"),
			array(width => "80%", data =>chng_date($data[0]['rv_pmnt_date'],"-"))
		));
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Currency:"),
			array(width => "80%", data =>$currSym)
		));
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Method of payment:"),
			array(width => "80%", data =>$data[0]['rf_mthd_pmnt_desc'])
		));
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Bank / Cash point:"),
			array(width => "80%", data =>$data[0]['rf_bank_acc_name'])
		));
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Ref/receipt number:"),
			array(width => "80%", data =>$data[0]['rv_pmnt_ref'])
		));
		$pdf->Row(array(
			array(width => "3%", data =>""),
			array(width => "20%", data =>"Notes:"),
			array(width => "80%", data =>$data[0]['rv_pmnt_note'])
		));
		$pdf->Ln(3);
		$pdf->SetFont('Arial', '', 8);
		$headRow = array();
		array_push($headRow,
			array(width => "3%", data =>""),
			array(width=>"10%", height=>"5", data=>"Res Number", border=>"LT", style=>"B", fill=>1),
			array(width=>"17%", height=>"5", data=>"Res Name", border=>"TL", style=>"B", fill=>1),
			array(width=>"20%", height=>"5", data=>"Agent", border=>"TL", style=>"B", fill=>1),
			array(width=>"50%", height=>"5", data=>"Amount", border=>"TLR", align=>"C", style=>"B", fill=>1)
		);
		$pdf->Row($headRow);
		
		$headRow2 = array();
		array_push($headRow2,
			array(width => "3%", data =>""),
			array(width=>"10%", height=>"5", data=>"", border=>"LBR", style=>"B", fill=>1),
			array(width=>"17%", height=>"5", data=>"", border=>"BRL", style=>"B", fill=>1),
			array(width=>"20%", height=>"5", data=>"", border=>"BRL", style=>"B", fill=>1),
			array(width=>"12%", height=>"5", data=>"Outstanding", border=>"TBRL", style=>"B", fill=>1, align=>"R"),
			array(width=>"12%", height=>"5", data=>"Curr Pd", border=>"TBRL", style=>"B", fill=>1, align=>"R"),
			array(width=>"12%", height=>"5", data=>"Conversion", border=>"TBRL", style=>"B", fill=>1, align=>"R"),
			array(width=>"14%", height=>"5", data=>"Amount", border=>"TBRL", style=>"B", fill=>1, align=>"R")
		);
		$pdf->Row($headRow2);

		//Start of loop from advanced.php
		$resList = $lDB->get("SELECT DISTINCT rv_reservation_id FROM rv_payment_item WHERE rv_payment_id = '$record'",3);
		
		$mode = "1";
		$hmax = sizeof($resList);
		
		for ($h = 0; $h < $hmax; $h++) {
			$tagList = array();
			$rv_reservation_id = $resList[$h];
			$sql="SELECT DISTINCT ";
			if ($mode != "0") {
				$sql .= "
					rv_payment_item.rv_payment_item_ix,
					rv_payment_item.rv_payment_item_amt,
					rv_payment_item.rv_pay_item_amt_rec,
					rv_payment_item.rv_pay_item_exch_rate,
					rv_payment_item.rv_payment_contra_id,
					rv_payment_item.rv_payment_id, ";
			}

			$sql .= "
					rv_reservation.rv_reservation_ix as resId,
					rv_reservation.rv_res_name as resName,
					pr_persona.pr_name_last as resAgent,
					fn_folio.fn_folio_ix as folioId,
					fn_folio.fn_folio_amount as folPayable,
					fn_folio.fn_folio_folio_num as folioNum,
					fn_folio.pr_business_id,
					fn_folio.fn_folio_to_id,
					fn_invoice.fn_invoice_prefix,
					fn_invoice.fn_invoice_ix as fnInvKey,
					rf_currency.rf_currency_symbol as folioCurr,
					rf_currency.rf_currency_ix as folioCurrId
				FROM
					rv_reservation ";

			if ($mode != "0") {
				$sql .= "
					INNER JOIN rv_payment_item ON
						rv_payment_item.rv_payment_id = '".$record."' 
						AND 
						rv_payment_item.rv_reservation_id = '".$rv_reservation_id."' 
				";
			}

			$sql .= "LEFT JOIN fn_folio ON ";
			
			if ($mode != "0") {
				$sql .= "fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id";
			} else {
				$sql .= "fn_folio.rv_reservation_id = rv_reservation.rv_reservation_ix ";
			}
			
			$sql .= "
				LEFT JOIN fn_invoice ON
					fn_invoice.fn_invoice_ix = fn_folio.fn_invoice_id
			";
			
			if ($mode == "0") {
				$sql .= "
					LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id 
				";
			} else {
				$sql .= "
					LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_item.rf_currency_id 
				";
			}
			
			$sql .= "
				LEFT JOIN pr_persona ON
					pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
				WHERE
					rv_reservation.rv_reservation_ix = '".$rv_reservation_id."'
				ORDER BY
					fn_folio.fn_folio_folio_num
			";

			$result = $lDB->get($sql,2);

			$payData = array();
			$imax = sizeof($result);
			
			for ($i = 0; $i < $imax; $i++) {
				$payData[$i] = array();
				$row = $result[$i];
				$rv_reservation_id = "";
				
				if ($i == 0) {
					$rv_reservation_id = $row['resId'];
				}

				$folioName = "Folio  ";
				
				if ($row['fnInvKey'] != "") {
					$folioName = "      ".$row['fn_invoice_prefix']." ";
					$folioName = "      ".$row['fnInvKey']." ";
				} else {
					$folioName .= $row['folioNum'];
				}

				$folioTitle = $folioName;
				
				if (trim($folioTitle) == "") {
					$folioTitle = "None";
				}
				
				$payData[$i]['folioName'] = setNewValue($folioTitle);
				$rowToLast = getPersona("pr_name_last",$row['fn_folio_to_id'],4);
				$rowToFirst = getPersona("pr_name_first",$row['fn_folio_to_id'],4);
				
				if($rowToFirst == "" || $rowToFirst == "0") {
					$row['TO'] = $rowToLast;
				} else {
					$row['TO'] = $rowToLast.", ".$rowToFirst;
				}
				
				if($rowToLast == "" || $rowToLast == "0"){
					$row['TO'] = $rowToFirst;
				}
				
				if ($row['fn_folio_to_id'] == "" || $row['fn_folio_to_id'] == "0") {
					$row['TO'] = "Cash";
				}
				
				$row['BUS'] = getPersona("pr_name_last",$row['pr_business_id'],4);
				
				if ($row['BUS'] == "0") {
					$row['BUS'] = "N/A";
				}

				// Outstanding. Why, thank you...
				$paid = $lDB->get("
					SELECT 
						SUM(rv_payment_item_amt) 
					FROM 
						rv_payment_item 
					WHERE 
						fn_folio_id = '".$row['folioId']."'
				",4);
				
				$amount = $row['folPayable'] - $paid;
				$amount = (string) $amount;
				
				fixAmtDisplay($amount);

				$payData[$i]['folio_curr1'] = $row['folioCurr'];

				if ($mode != "0") {
					fixAmtDisplay($row['rv_pay_item_amt_rec']);
					fixAmtDisplay($row['rv_pay_item_exch_rate'],4);
					fixAmtDisplay($row['rv_payment_item_amt']);
				}

				$dataRow = array();
				
				if ($rv_reservation_id != "") {
					array_push($dataRow,
						array(width => "3%", data =>""),
						array(width=>"10%", height=>"5", data=>$rv_reservation_id, border=>"LTBR"),
						array(width=>"17%", height=>"5", data=>$row['resName'], border=>"TBRL"),
						array(width=>"20%", height=>"5", data=>$row['resAgent'], border=>"TBRL"),
						array(width=>"12%", height=>"5", data=>$amount." ".$row['folioCurr'], border=>"TBRL", align=>"R"),
						array(width=>"12%", height=>"5", data=>$row['rv_pay_item_amt_rec']." ".$currSym, border=>"TBRL", align=>"R"),
						array(width=>"12%", height=>"5", data=>$row['rv_pay_item_exch_rate'], border=>"TBRL", align=>"R"),
						array(width=>"14%", height=>"5", data=>$row['rv_payment_item_amt']." ".$row['folioCurr'], border=>"TBRL", align=>"R"));
				} else {
					array_push($dataRow,
						array(width => "3%", data =>""),
						array(width=>"10%", height=>"5", data=>"", border=>"LTBR"),
						array(width=>"17%", height=>"5", data=>"", border=>"TBRL"),
						array(width=>"20%", height=>"5", data=>"", border=>"TBRL"),
						array(width=>"12%", height=>"5", data=>$amount." ".$row['folioCurr'], border=>"TBRL", align=>"R"),
						array(width=>"12%", height=>"5", data=>$row['rv_pay_item_amt_rec']." ".$currSym, border=>"TBRL", align=>"R"),
						array(width=>"12%", height=>"5", data=>$row['rv_pay_item_exch_rate'], border=>"TBRL", align=>"R"),
						array(width=>"14%", height=>"5", data=>$row['rv_payment_item_amt']." ".$row['folioCurr'], border=>"TBRL", align=>"R"));
				}
				
				$pdf->Row($dataRow);

				$folioName = "Folio  ";
				$folioNumRow = array();
				
				if ($row['fnInvKey'] != "") {
					array_push($folioNumRow,
						array(width => "3%", data =>""),
						array(width=>"15%", height=>"4", data=>"Invoice Number:", border=>"L"),
						array(width=>"82%", height=>"4", data=>$row['fnInvKey']." ", border=>"R"));
				} else {
					array_push($folioNumRow,
						array(width => "3%", data =>""),
						array(width=>"15%", height=>"4", data=>"Folio Number:", border=>"L"),
						array(width=>"82%", height=>"4", data=>$row['folioNum'], border=>"R"));
				}
				
				$pdf->Row($folioNumRow);

				$folioToRow = array();
					array_push($folioToRow,
						array(width => "3%", data =>""),
						array(width=>"15%", height=>"4", data=>"To:", border=>"L"),
						array(width=>"82%", height=>"4", data=>t_encodeOverlib($row['TO']), border=>"R"));
				
				$pdf->Row($folioToRow);

				$folioBusRow = array();
				array_push($folioBusRow,
					array(width => "3%", data =>""),
					array(width=>"15%", height=>"4", data=>"Business Unit:", border=>"LB"),
					array(width=>"82%", height=>"4", data=>t_encodeOverlib($row['BUS']), border=>"RB"));
				
				$pdf->Row($folioBusRow);
			}
		}
		// End loop

		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}
		
		if($renderType == "send") {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = stripslashes($_POST['mail_subj']);
			$message = stripslashes($_POST['mail_body']);
			$attachmentName = $_POST['attachmentName'];
			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

			// Close the pdf
			if ($pdf->state<3) {
				$pdf->Close();
			}

			// Mail the pdf
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}
			
			// (from, to, subject, headers, message, action, emailID, resID)
			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);
			
			if(!$error) {
				echo "
							<script type=\"text/javascript\">
								if (opener && !opener.closed) {
									opener.openMessage('Your email has been sent.');
								}
								window.close();
							</script>
						</body>
					</html>";
				die();
			 } else {
				echo "
							<script type=\"text/javascript\">
								if(opener && !opener.closed) {
									opener.openMessage('Error sending email!');
								}
								window.close();
							</script>
						</body>
					</html>";
				die();
			}
		}
	}
}
