<?php

/**
 * init.form225.php - Record Payments Report
 * Job: 654
 * Function: 53 (Reports: Std, Prov, Contact, Mail, Pay received)
*/

require_once(__DIR__ . "/class.template.php");

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}   

$pf_object_id = db_pf_object_by_name("payment_received_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Payments Received Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/pymnt_find.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],23,"");

//Get variables from URL
$fromDate = $_SERVER['argv'][1];
$toDate = $_SERVER['argv'][2];
$person = $_SERVER['argv'][3];
$temp = explode(":",$_SERVER['argv'][4]);
$notes = isset($temp[0]) ? $temp[0] : "";
$reser = isset($temp[1]) ? $temp[1] : "";
	
if ($notes == "true") {
	$GLOBALS['temp']['disNotes'] = " checked";
}
	
if ($reser == "true") {
	$GLOBALS['temp']['disResDet'] = " checked";
}
	
$advancedVal = $_SERVER['argv'][5];
$advfDate = $_SERVER['argv'][6];
$advtDate = $_SERVER['argv'][7];
$recBy = $_SERVER['argv'][8];
$payRefVal = $_SERVER['argv'][9];
$curr = $_SERVER['argv'][10];
$voucher = $_SERVER['argv'][19];
	
if(trim($voucher) == "") {
	$voucher = "*";
}
	
$GLOBALS['temp']['voucher'] = $voucher;
$GLOBALS['temp']['checkonload'] = "";   

if ($curr == ":|:")	{
	$curr = "";
}
	
$payMeth = $_SERVER['argv'][11];
	
if (trim($payMeth) == "0") {
	$payMeth = "";
}
	
if (strpos($payMeth,":") !== false) {
	$payMeth = explode(":",$payMeth);
} else {
	if (trim($payMeth) != "") {
		$payMeth = array($payMeth);
	} else {
		$payMeth = array();
	}
}
	
$pageNumber = $_SERVER['argv'][12];
$GLOBALS['tagList']['pageNumberValue'] = $pageNumber;
$dateRange = $_SERVER['argv'][13];
$payNum = str_replace("*","%",$_SERVER['argv'][14]);
$options = $_SERVER['argv'][22];
$bankOptions = "";

$bankListActive = $lDB->get("
	SELECT 
		rf_bank.rf_bank_ix
	AS 
		rf_bank_ix, rf_bank_acc_name
	FROM 
		rf_bank
	WHERE
		rf_bank.rf_bank_inactive_yn = '0'
	ORDER BY
		rf_bank.rf_bank_acc_name ASC
",2);

$bankListInactive = $lDB->get("
	SELECT 
		rf_bank.rf_bank_ix
	AS 
		rf_bank_ix, rf_bank_acc_name
	FROM 
		rf_bank
	WHERE
		rf_bank.rf_bank_inactive_yn != '0'
	ORDER BY
		rf_bank.rf_bank_acc_name ASC
",2);

foreach ($bankListInactive as $key => $value) {
	$bankListInactive[$key]['rf_bank_acc_name'] = '* '.$bankListInactive[$key]['rf_bank_acc_name'];
}

$bankList = array_merge($bankListActive,$bankListInactive);

if(trim($_SERVER['argv'][18]) == "") {
	$_SERVER['argv'][18] = $lDB->get("
		SELECT
			rf_bank_env.rf_bank_id
		FROM
			rf_bank_env
		INNER JOIN rf_database ON
			rf_database.rf_database_id = rf_bank_env.rf_database_id
		WHERE
			rf_database.rf_db_code = '" . $GLOBALS['dbcode'] . "'
		AND 
			rf_bank_env.rf_bank_env_default_yn = 1
	",4);
}

$arrCashPoint = explode(":",$_SERVER['argv'][18]);

foreach($bankList as $bankItem) {
	$selected = "";
	if(in_array($bankItem['rf_bank_ix'],$arrCashPoint)) {
		$selected = "selected";
	}
	$bankOptions .= "<option " . $selected . " value=\"" . $bankItem['rf_bank_ix'] . "\">" . $bankItem['rf_bank_acc_name'] . "</option>";
}
	
$GLOBALS['temp']['bankOptions'] = $bankOptions;

$bankFilterForSQL = implode("','",$arrCashPoint);

if(trim($_SERVER['argv'][18]) != "" && $_SERVER['argv'][18] != "0") {
	$bankFilter['where'] = " AND rv_payment.rf_bank_id IN ('" . $bankFilterForSQL . "') ";
} else {
	$bankFilter['where'] = "
		AND (
			TRIM(rv_payment.rf_bank_id) = '' OR rv_payment.rf_bank_id = '0')
	";
}

$folioCheck = $_SERVER['argv'][20];
$invoiceCheck = $_SERVER['argv'][21];
$invoiceFilter = "";
if($_SERVER['argc'] > 1 && $folioCheck == "0" && $invoiceCheck == "0") { // Invoice filter default
	$folioCheck = "1";
	$invoiceCheck = "1";
}
if($folioCheck == "1" && $invoiceCheck == "0") { // Uninvoiced folios only
	$invoiceFilter = "
		AND fn_invoice.fn_invoice_ix IS NULL
	";
}
if($folioCheck == "0" && $invoiceCheck == "1") { // Invoiced folios only
	$invoiceFilter = "
		AND fn_invoice.fn_invoice_ix IS NOT NULL
	";
}

$GLOBALS['temp']['folioChecked'] = "";
if($folioCheck == "1") {
	$GLOBALS['temp']['folioChecked'] = "checked";
}
$GLOBALS['temp']['invoiceChecked'] = "";
if($invoiceCheck == "1") {
	$GLOBALS['temp']['invoiceChecked'] = "checked";	
}


// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
//$filterStatus = $_SERVER['argv'][21];
//$showHideButtonText = $_SERVER['argv'][22];
$filterStatus = "";
$showHideButtonText = "";

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// BUG #5484: END -------------------------------------------------------------

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "export";
	break;
}

switch($dateRange) {
case 0:
	$pdfDates = chng_date($fromDate,"-")." to ".chng_date($toDate,"-");
	break;
case 1:
	$pdfDates = chng_date($advfDate,"-")." to ".chng_date($advtDate,"-");
	break;
case 2:
	$pdfDates = "All";
	break;
}

if($renderMode == "pdf" && $renderType == "email") {
	$pdfName = "Payments Received " . $pdfDates;
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?" . join("+",array_slice($_SERVER['argv'],0,22)) . "+" . $newOptions;

	$GLOBALS[$form]->FormHTML = str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$userId'
	",4);
	$GLOBALS['temp']['emailTo'] = "";
}

switch($dateRange) {
case "0":
	$GLOBALS['temp']['datePaidChecked'] = "checked";
	break;
case "1":
	$GLOBALS['temp']['dateRecordedChecked'] = "checked";
	break;
default:
	$GLOBALS['temp']['dateAllChecked'] = "checked";
	break;
}


if ($payNum != "" && $payNum != "0") {
	//$payNum = preg_replace("/[A-z]/i","",$payNum);
	if (strpos($payNum,",") !== false) {
		$payNum = explode(",",$payNum);
	} else {
		$payNum = array($payNum);
	}

	$result = array();
	$imax = sizeof($payNum);
	
	for ($i = 0; $i < $imax; $i++) {
		$payid = trim($payNum[$i]);
		if (strpos($payid,"-") !== false) {
			$payid = explode("-",$payid);
			$start = $payid[0];
			$end = $payid[sizeof($payid)-1];
			$start = (int) $start;
			$end = (int) $end;
			
			if ($start != "" && $end != "") {
				$list = range($start,$end);
				$jmax = sizeof($list);
				
				for ($j = 0; $j < $jmax; $j++) {
					$paynumber = $list[$j];
					if (!in_array($paynumber,$result)) {
						array_push($result,$paynumber);
					}
				}
			}
		} else {
			if (!in_array(trim($payid),$result) && trim($payid) != "") {
				array_push($result,trim($payid));
			}
		}
	}
	$payNum = $result;
}

if(sizeof($payNum) > 1) {
	$GLOBALS['tagList']['recNum2'] = setNewValue($_SERVER['argv'][14]);
	$GLOBALS['tagList']['recNum'] = setNewAttrib("disabled");
	$GLOBALS['tagList']['radioB'] = setNewAttrib("checked");
} else {
	$GLOBALS['tagList']['recNum'] = setNewValue($_SERVER['argv'][14]);
	$GLOBALS['tagList']['recNum2'] = setNewAttrib("disabled");
	$GLOBALS['tagList']['radioA'] = setNewAttrib("checked");
}

$GLOBALS['temp']['hidePayer'] = "";
$GLOBALS['temp']['hideRecordBy'] = "";
if($userStatusId < 2) {
	$GLOBALS['temp']['hidePayer'] = " style=\"display:none\"";
	$GLOBALS['temp']['hideRecordBy'] = " style=\"display:none\"";
	$person = $calAgentId;
}
if($fromDate == "") {
	$fromDate = date("Y-m-d");
}
if($toDate == "") {
	$toDate = date("Y-m-d");
}
if($advfDate == "") {
	$advfDate = date("Y-m-d");
}
if($advtDate == "") {
	$advtDate = date("Y-m-d");
}
$page = $pageNumber;
$GLOBALS['temp']['payRefVal'] = $payRefVal;
$GLOBALS['temp']['curr'] = $curr;
$GLOBALS['temp']['payMeth'] = join(":",$payMeth);

//Set Dates to populate the date drop downs
$GLOBALS['temp']['fromDate'] = chng_date($fromDate, "-");
$GLOBALS['temp']['fromD'] = "0";
$GLOBALS['temp']['fromM'] = "0";
$GLOBALS['temp']['fromY'] = "";
if($fromDate != "") {
	$temp = explode("-", $fromDate);
	$GLOBALS['temp']['fromY'] = $temp[0];
	$GLOBALS['temp']['fromM'] = $temp[1];
	$GLOBALS['temp']['fromD'] = $temp[2];
}
$GLOBALS['temp']['toDate'] = chng_date($toDate, "-");
$GLOBALS['temp']['toD'] = "0";
$GLOBALS['temp']['toM'] = "0";
$GLOBALS['temp']['toY'] = "";
if($toDate != "") {
	$temp = explode("-", $toDate);
	$GLOBALS['temp']['toY'] = $temp[0];
	$GLOBALS['temp']['toM'] = $temp[1];
	$GLOBALS['temp']['toD'] = $temp[2];
}
$GLOBALS['temp']['advfDate'] = chng_date($advfDate, "-");
$GLOBALS['temp']['advfD'] = "0";
$GLOBALS['temp']['advfM'] = "0";
$GLOBALS['temp']['advfY'] = "";
if($advfDate != 0) {
	$temp = explode("-", $advfDate);
	$GLOBALS['temp']['advfY'] = $temp[0];
	$GLOBALS['temp']['advfM'] = $temp[1];
	$GLOBALS['temp']['advfD'] = $temp[2];
} else {
	$GLOBALS['temp']['advfDate'] = "";
}
$GLOBALS['temp']['advtDate'] = chng_date($advtDate, "-");
$GLOBALS['temp']['advtD'] = "0";
$GLOBALS['temp']['advtM'] = "0";
$GLOBALS['temp']['advtY'] = "";
if($advtDate != 0) {
	$temp = explode("-", $advtDate);
	$GLOBALS['temp']['advtY'] = $temp[0];
	$GLOBALS['temp']['advtM'] = $temp[1];
	$GLOBALS['temp']['advtD'] = $temp[2];
} else {
	$GLOBALS['temp']['advtDate'] = "";
}
if(trim($page) == "" || $page == "0") {
	$page = "1";
}
$GLOBALS['temp']['page'] = "<input type='hidden' name='pageNumber' id='pageNumber' value='$page'>";
$GLOBALS['temp']['person'] = "<input type='hidden' name='payerId' id='payerId' value='$person'>";
$GLOBALS['temp']['recorder'] = "<input type='hidden' name='recordId' id='recordId' value='$recBy'>";

$orderFlag = $_SERVER['argv'][15];
$orderType = $_SERVER['argv'][16];

if($orderFlag == "") {
	$orderFlag = "rv_payment_id";
}

if($orderType != "1") {
	$orderType = "0";
}

if ($orderType == "1") {
	switch ($orderFlag) {
	case "rv_payment_id":
		$flagType = "payment_id";
		break;
	case "rv_pmnt_user_id":
		$flagType = "user_id";
		break;
	case "rf_mthd_pmnt_id":
		$flagType = "mthd_id";
		break;
	case "rf_bank_id":
		$flagType = "bank_id";
		break;
	}
	$GLOBALS['tagList']["order_".$flagType] = setNewParam("src","/resource/Resrequest/Application/public/img/arrow_descend_down.gif");
}

$orderClause = "";

switch ($orderFlag) {
case "rv_pmnt_user_id":
	$orderClause = " rv_payment.rv_pmnt_user_id ";
	if($orderType == "1") {
		$orderClause .= " desc ";
	}
	break;
case "rf_mthd_pmnt_id":
	$orderClause = " rv_payment.rf_mthd_pmnt_id ";
	if($orderType == "1") {
		$orderClause .= " desc ";
	}
	break;
case "rf_bank_id":
	$orderClause = " rf_bank.rf_bank_id ";
	if($orderType == "1") {
		$orderClause .= " desc ";
	}
	break;
default:
	$orderClause = " rv_payment.rv_payment_id ";
	if($orderType != "1") {
		$orderClause .= " desc ";
	}
	$orderFlag = "rv_payment_id";
	break;
}

$GLOBALS['tagList']['orderFlag'] = setNewValue($orderFlag);
$GLOBALS['tagList']['orderType'] = setNewValue($orderType);

//Filters - Add onto SQL
$extra = "";
$extra1 = "";
$extra2 = "";
$extra3 = "";
$extra4 = "";
$extra5 = "";

$personJoin = "LEFT";
$GLOBALS['temp']['personName'] = "All";
if($person == "0") {
	$GLOBALS['temp']['personName'] = "Cash";
}

if ($person != "" && $person != "0" && $person != "2") {
	$temp = $lDB->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '".$person."'", 1);
	$pName = trim($temp['pr_name_last']);
	if(trim($temp['pr_name_first']) != "") {
		$pName = trim($temp['pr_name_first']." ".$pName);
	}
	$GLOBALS['temp']['personName'] = $pName;
	$extra1 = " AND pr_persona.pr_persona_ix = '".$person."'";
	if ($person != "0") {
		$personJoin = "INNER";
	}
}

if($person == "0") {
	$extra1 = " AND (pr_persona.pr_persona_ix IS NULL OR pr_persona.pr_persona_ix = '' OR pr_persona.pr_persona_ix = '0') ";
}

if($recBy != "" && $recBy != "0") {
	$temp = $lDB->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '$recBy'", 1);
	$rName = trim($temp['pr_name_first']." ".$temp['pr_name_last']);
	$GLOBALS['temp']['recName'] = $rName;
	$extra2 = " AND rv_payment.rv_pmnt_user_id = '$recBy'";
} else {
	$GLOBALS['temp']['recName'] = "";
}

if($payRefVal != "") {
	$extra3 = " AND rv_payment.rv_pmnt_ref LIKE '".urldecode($payRefVal)."'";
}

if($curr != "") {
	$currName = $lDB->get("SELECT rf_currency_name FROM rf_currency WHERE rf_currency_ix = '$curr'", 4);
	$GLOBALS['temp']['currName'] = $currName;
	$extra4 = " AND rv_payment.rf_currency_id = '$curr'";
}

if(sizeof($payMeth) > 0) {
	$payMeths = $lDB->get("SELECT rf_mthd_pmnt_desc FROM rf_mthd_pmnt WHERE  rf_mthd_pmnt_ix IN ('".join("','",$payMeth)."')",3);
	$payMethName = join(",",$payMeths);
	$extra5 = " AND rv_payment.rf_mthd_pmnt_id IN ('".join("','",$payMeth)."')";
}

$GLOBALS['temp']['payRefVal'] = $payRefVal;
$GLOBALS['temp']['hideAll'] = "";
//Hide if user is External
$GLOBALS['temp']['advHide'] = "";
if ($userStatusId <= "1") {
	$GLOBALS['temp']['advHide'] = " style=\"display:none\"";
}

//Hide or show the advanced fields
$GLOBALS['temp']['adVal'] = "";
if ($advancedVal == "expand") {
	$GLOBALS['temp']['adVal'] = "expand";
} else {
	$GLOBALS['temp']['adVal'] = "collapse printCollapse";
}
if (($advancedVal == "expand") && ($advfDate == -00-00) && ($advtDate == -00-00) && ($recBy == "") && ($payRefVal == "") && ($curr == "") && ($payMeth == "")) {
	$GLOBALS['temp']['adVal'] = "collapse printCollapse";
}

$GLOBALS[$form]->AddField("rf_currency_id", "rf_currency_id", $curr, 3);
$sql = "select rf_currency_db,rf_currency_id, rf_currency_name from rf_currency where rf_currency_inactive_yn = '0' order by rf_currency_name";
$GLOBALS['rf_currency_id']->Width = 120;
$GLOBALS['rf_currency_id']->Select(combolist($lDB, $sql,":|:"));
$GLOBALS['rf_currency_id']->AlwaysOn = "1";

$allList = $lDB->get("select rf_mthd_pmnt_ix from rf_mthd_pmnt",3);
$check = 0;
$GLOBALS['tagList']["mthdpayIds"] = setNewValue(join(":",$payMeth));
$GLOBALS['temp']['mthdpayNames'] = "";
$imax = sizeof($payMeth);
for ($i=0;$i<$imax;$i++) {
	if ($i!=0) {
		$GLOBALS['temp']['mthdpayNames'] .= ", ";
	}
	$GLOBALS['temp']['mthdpayNames'] .= $lDB->get("select rf_mthd_pmnt_desc from rf_mthd_pmnt where rf_mthd_pmnt_ix = '".$payMeth[$i]."'",4);
}
if ($GLOBALS['temp']['mthdpayNames'] == "" || $allList == $payMeth) {
	$GLOBALS['temp']['mthdpayNames'] = "All";
	$mthdpayNames = "All";
	$GLOBALS['tagList']["mthdpayIds"] = setNewValue(join(":",$allList));
}

//Do not display results if nothing has been selected

$generated = $_SERVER['argc'] > 1;

if (!$generated) {
	$GLOBALS['temp']['hideAll'] = "1";
} else {
	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
	}
	if($_SERVER['argc'] > 1) {
		$GLOBALS['temp']['hideAll'] = "0";
		$GLOBALS['temp']['hideButs'] = "";
	} else {
		$GLOBALS['temp']['hideAll'] = "1";
		$GLOBALS['temp']['hideButs'] = "collapse printCollapse";
	}
     
	# Records per page
	$limit = "20";
	# Start from row
	$start = ($page-1) * $limit;      
      
	if($renderMode == "csv") {
		$limitString = "";
	} else {
		$limitString = " LIMIT $start,$limit";      
	}
	$SQL = "
		FROM
			rv_payment 
			$personJoin JOIN pr_persona ON pr_persona.pr_persona_ix = rv_payment.pr_persona_id
			LEFT JOIN pr_persona AS pr_parent ON pr_parent.pr_persona_ix = rv_payment.rv_pmnt_user_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment.rf_currency_id
			LEFT JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id 
			LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id		 
	";

	$WHERE = "WHERE 1 ";
	  
	switch ($dateRange) {
	case "0":
		$WHERE .= "
			AND rv_payment.rv_pmnt_date >= '$fromDate'
			AND rv_payment.rv_pmnt_date <= '".$toDate."'
		";
		break;
	case "1":
		$WHERE .= "
			AND rv_payment.rv_pmnt_date_created >= '$advfDate 00:00:00'
			AND rv_payment.rv_pmnt_date_created <= '$advtDate 23:59:59'
		";
		break;
	case "2":
		break;
	}
  
	if (sizeof($payNum) > 0 && $payNum != "") {
		if (is_array($payNum)) {
			if (sizeof($payNum) > 1) {
				$WHERE .= " AND rv_payment.rv_payment_id ";
				$WHERE .= "IN ('".join("','",$payNum)."') ";
			} else {
				$WHERE .= " AND rv_payment.rv_payment_ix ";
				$WHERE .= "LIKE '%".join("','",$payNum)."' ";
			}
		} else {
			$WHERE .= "AND rv_payment.rv_payment_ix LIKE '".$payNum."' ";
		}
		 
	}
  
	$SQL .= $WHERE .  " " .$extra1 . " " . $bankFilter['where'];

	$countSQL = "SELECT count(*) ".$SQL.$extra.$extra2.$extra3.$extra4.$extra5;
	$countCurrency = $lDB->get("SELECT count(DISTINCT rv_payment.rf_currency_id) ".$SQL.$extra.$extra2.$extra3.$extra4.$extra5,4);
	  
	$countRows = $lDB->get($countSQL, 4);
	// Calculate page splits
	// Set the records found value
	$GLOBALS['temp']['recFound'] = (string) $countRows;
	# Get the number of pages
	$realPages = ($countRows / $limit);
	$pCount = (int) $realPages;
	if($realPages > $pCount) {
		$pCount++;
	}
	$GLOBALS['temp']['pageCount'] = (string) $pCount;
	# Limit maximum page number, also set previous and next page numbers
	$nextPage = $page + 1;
	if($page >= $pCount) {
		$page = $pCount;
		$nextPage = "0";
	}
	$prevPage = $page - 1;
	$GLOBALS['temp']['prevPageNum'] = $prevPage;
	$GLOBALS['temp']['nextPageNum'] = $nextPage;
	# Hide or show the next and previous buttons
	$GLOBALS['temp']['hidePrevButton'] = "button";
	$GLOBALS['temp']['hideNextButton'] = "button";
	$GLOBALS['temp']['hidepgsplits'] = "";
      
	if($prevPage == "0") {
		$GLOBALS['temp']['hidePrevButton'] = "collapse printCollapse";
	}
	if($nextPage == "0") {
		$GLOBALS['temp']['hideNextButton'] = "collapse printCollapse";
	}
	if($page >= $pCount && $countCurrency <= 1) {
		$GLOBALS['temp']['showTotals'] = "colLtt bAll";
		$totalCurrencyId = $lDB->get("SELECT DISTINCT rv_payment.rf_currency_id ".$SQL.$extra.$extra2.$extra3.$extra4.$extra5,4);
		$totalCurrency = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$totalCurrencyId'",4);
		$GLOBALS['temp']['totalCurrency'] = $totalCurrency;
		$totalAmount = $lDB->get("SELECT SUM(rv_payment.rv_pmnt_amount) ".$SQL.$extra.$extra2.$extra3.$extra4.$extra5,4);
		fixAmtDisplay($totalAmount,2);
		$GLOBALS['temp']['totalAmount'] = $totalAmount;
	} else {
		$GLOBALS['temp']['showTotals'] = "collapse printCollapse";
	}

	# Generate the pages list
	$pStart = "1";
	$pEnd = $pCount;
	$pLimit = "7";
	$pBreak = (1 + ($pLimit * 2));
	if($pCount > $pBreak) {
		$pEnd = $page + $pLimit;
		$pStart = $page - $pLimit;
		if($pStart < "1") {
			$left = $page - "1";
			$pStart = "1";
			$pEnd += ($pLimit - $left);
			if ($pEnd > $pCount) {
				$pEnd = $pCount;
			}
		}
		if($pEnd > $pCount) {
			$right = $pEnd - $pCount;
			$pEnd = $pCount;
			$pStart = $page - ($pLimit + $right);
			if($pStart < "1") {
				$pStart = "1";
			}
		}
	}
	$pages = range($pStart, $pEnd);
	$pageList = "";
	$imax = sizeof($pages);
	if($pCount > $pBreak) {
		$imax = $imax - 1;
	}
	for($i=0; $i<$imax; $i++) {
		if($i == "0" && $pCount > $pBreak) {
			$pageNum = "1";
			if($pageNum == $page) {
				$pageList .= "<b>First</b>";
			} else {
				$pageList .= "<a href=\"javascript:setPage('1');\" class=\"txtbr\" >First</a>";
			}
		} else {
			$pageNum = $pages[$i];
			if ($i != "0") {
				$pageList .= ", ";
			}
			if($pageNum == $page) {
				$pageList .= "<span class=txt>".$pageNum."</span>";
			} else {
				$pageList .= "<a href=\"javascript:setPage('".$pageNum."');\" class=\"txtbr\">".$pageNum."</a>";
			}
		}
	}
	if ($pCount > $pBreak) {
		$pageNum = $pCount;
		$pageList .= ", ";
		if($pageNum == $page) {
			$pageList .= "<b>Last</b>";
		} else {
			$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"setPage('".$pageNum."')\">Last</a>";
		}
	}
	$GLOBALS['temp']['pageList'] = $pageList;
	$GLOBALS['temp']['pageNum'] = $page;
	$getsql = "
		SELECT
			rv_payment.rv_payment_ix as rvPayId,
			rv_payment.rv_pmnt_date_created as payDateCrtd,
			rv_payment.rv_pmnt_date as payDate,
			rv_payment.rv_pmnt_ref as payRef,
			rv_payment.rv_pmnt_note as payNote,
			rv_payment.rf_currency_id as payCurrId,
			rv_payment.rv_pmnt_user_id as payRecBy,
			rv_payment.pr_persona_id as payedBy,
			rv_payment.rv_pmnt_amount as payAmnt,
			rf_currency.rf_currency_symbol as payCurr,
			pr_persona.pr_name_first as payedByFName,
			pr_persona.pr_name_last as payedByLName,
			rf_mthd_pmnt.rf_mthd_pmnt_desc as payMthd,
			pr_parent.pr_name_first as payFName,
			pr_parent.pr_name_last as payLName,
			rv_payment.rv_payment_db,
			rf_bank.rf_bank_acc_name,
			rf_bank.rf_bank_id
			$SQL
	";

	$getsql .= $extra . $extra2 . $extra3 . $extra4 . $extra5 . " ORDER BY " . $orderClause . $limitString;

	$result = $lDB->get($getsql,0);

	// HTML files
	$payHTML = join("", file(__DIR__ . "/../../../public/html/pymnt_find_rows.htm"));
	$noteHTML = join("", file(__DIR__ . "/../../../public/html/pymnt_find_notes_rows.htm"));

	$rows = mysqli_num_rows($result);
	$limit = "27";
	$GLOBALS['temp']['rows'] = "";
	for($i=0; $i<$rows; $i++) {
		$resultSet = mysqli_fetch_array($result);
		// Disable row click if the user does not have access
		$payCapId = 299;
		$resultSet['resPayNum'] = $resultSet['rvPayId'];
		// Get reservation number for payment
		$resultSet['resNum'] = $lDB->get("SELECT rv_payment_item.rv_reservation_id FROM rv_payment_item WHERE rv_payment_item.rv_payment_id = '$resultSet[rvPayId]'",4);
		$resultSet['rowColor'] = "this.style.backgroundColor = '#CCFFCC'";
		$resultSet['rowColorWh'] = "this.style.backgroundColor = ''";
		$resultSet['rowClick'] = "goToPayments('".$resultSet['rvPayId']."+conf')";
		$resultSet['rowCursor'] = "imgLink";

		if($reser != "true") {
			$resultSet['rowCursor'] = "collapse printCollapse";
		}
		$resultSet['payAmnt'] = $resultSet['payAmnt'];
		$resultSet['payNote'] = t_encodeOverlib($resultSet['payNote']);
		if (strlen($resultSet['payRef']) > 9) {
			$resultSet['payRef'] = substr($resultSet['payRef'], 0, 9) . "...";
		}
		$resultSet['hideNote'] = "";
		$resultSet['hideFlag'] = "visibility:visible;";
		if ($resultSet['payNote'] == "") {
			$resultSet['hideFlag'] = "visibility:hidden;";
		}
		if ($resultSet['payNote'] == "" || $notes != "true") {
			$resultSet['hideNote'] = "collapse printCollapse";
		}         

		$resultSet['payName'] = trim($resultSet['payFName']." ".$resultSet['payLName']);

		$GLOBALS['temp']['payCurr'] = $resultSet['payCurr'];
		$GLOBALS['temp']['payMthd'] = $resultSet['payMthd'];
		if($resultSet['payedBy'] <> "0") {
			$resultSet['payedByName'] = trim($resultSet['payedByFName']." ".$resultSet['payedByLName']);
		} else {
			$resultSet['payedByName'] = "Cash";
		}
		$payedLen = strlen($resultSet['payedByName']);
		if($payedLen > $limit) {
			$resultSet['payedByName'] = substr($resultSet['payedByName'], 0, $limit)."..";
		}
		$resultSet['payDateCrtd'] = chng_date(substr($resultSet['payDateCrtd'],0,10), "-");
		$resultSet['payDate'] = chng_date($resultSet['payDate'], "-");

		$tagList['resTable'] = new tpParseTable();
		$sql = "
			SELECT
				rv_payment_item.rv_payment_id,
				rv_payment_item.rv_payment_item_ix,
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				fn_folio.fn_folio_folio_num,
				fn_invoice.fn_invoice_ix,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first,
				rv_payment_item.rv_pay_item_amt_rec,
				rf_currency.rf_currency_symbol,
				rv_payment_item.rv_pay_item_exch_rate,
				rv_payment_item.rv_payment_item_amt,
				rv_payment_item.rv_payment_contra_id
			FROM
				rv_payment_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_payment_item.rv_reservation_id
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
				LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind = 2
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			WHERE
				rv_payment_item.rv_payment_id = '$resultSet[rvPayId]'
			ORDER BY
				fn_folio.fn_folio_folio_num
		";
		$tagList['resTable']->Data = $lDB->get($sql,2);

		foreach($tagList['resTable']->Data as $resTableKey=>$resTableItem) {
			$tagList['resTable']->Data[$resTableKey]['pr_name'] = trim($resTableItem['pr_name_first'] . ' ' . $resTableItem['pr_name_last']);
			if(trim($resTableItem['fn_invoice_ix']) != "") {
				$tagList['resTable']->Data[$resTableKey]['fn_folio_folio_num'] = $resTableItem['fn_invoice_ix'];
			}
		}

		$noteRowOut = showpage($resultSet, $noteHTML);
		//debug($tagList);
		$detailRowOut = tpParse($tagList,showpage($resultSet, $payHTML));
		$GLOBALS['temp']['rows'] .= $noteRowOut.$detailRowOut;
	}
}

if(!isset($GLOBALS['temp']['rows']) || $GLOBALS['temp']['rows'] == "") {
	$GLOBALS['temp']['rows'] = "<table width=\"100%\" height=\"50\" align=\"center\"><tr><td class=\"txt\" align=\"center\">&nbsp;&nbsp;No data matched your filter criteria.<br> Please change your filters and press 'Submit find'.</td></tr></table>";
	$GLOBALS['temp']['hidepgsplits'] = "collapse printCollapse";
	$GLOBALS['temp']['hideButs'] = "collapse printCollapse";      
	$GLOBALS['temp']['showTotals'] = "collapse printCollapse";
}

if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
	$pdf = new PDF("Payments Received Report");

	if(!isset($pName) || $pName == "") {
		$pName = "All";
	}
	if ($GLOBALS['temp']['mthdpayNames'] == "All") {
		$payMethName = "All";   
	}   
	if(isset($GLOBALS['temp']['datePaidChecked']) && $GLOBALS['temp']['datePaidChecked'] == "checked") {
		$dateName = "Date of Payment";
		$dateValue = "From: ".chng_date($_SERVER['argv'][1],"-")." To: ".chng_date($_SERVER['argv'][2],"-");  
	} else if(isset($GLOBALS['temp']['dateRecordedChecked']) && $GLOBALS['temp']['dateRecordedChecked'] == "checked") {
		$dateName = "Recorded On";
		$dateValue = "From: ".chng_date($_SERVER['argv'][6],"-")." To: ".chng_date($_SERVER['argv'][7],"-");  
	}
	$pdf->ReportHeader("Payments Received Report",array(
		array('name'=>"Payment Number",'value'=>$_SERVER['argv'][14]),
		array('name'=>(isset($dateName) ? $dateName : ""),'value'=>(isset($dateValue) ? $dateValue: "")),
		array('name'=>"Payer/Payee",'value'=>(isset($pName) ? $pName: "")),
		array('name'=>"Bank",'value'=>(isset($bankName) ? $bankName : "")),
		array('name'=>"Recorded By",'value'=>(isset($rName) ? $rName: "")),
		array('name'=>"Payment Reference",'value'=>urldecode($_SERVER['argv'][9])),
		array('name'=>"Currency",'value'=>(isset($currName) ? $currName: "")),
		array('name'=>"Method of Payment",'value'=>(isset($payMethName) ? $payMethName : ""))
	));

	$pdf->Row(array(
		array('width'=>"8%", 'data'=>"Payment no.", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"6%", 'data'=>"Res no.", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"11%", 'data'=>"Recorded by", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"8%", 'data'=>"Recorded on", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"18%", 'data'=>"Payer/Payee", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"12%", 'data'=>"Bank / Cash point", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),    
		array('width'=>"8%", 'data'=>"Date", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"9%", 'data'=>"Amount", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B", 'align'=>"R"),
		array('width'=>"4%", 'data'=>"Curr", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"8%", 'data'=>"Pay method", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"8%", 'data'=>"Reference", 'border'=>"LTBR", 'fill'=>1, 'style'=>"B")     
	));  

	$getsql = "
		SELECT
			rv_payment.rv_payment_ix as rvPayId,
			rv_payment.rv_pmnt_date_created as payDateCrtd,
			rv_payment.rv_pmnt_date as payDate,
			rv_payment.rv_pmnt_ref as payRef,
			rv_payment.rv_pmnt_note as payNote,
			rv_payment.rf_currency_id as payCurrId,
			rv_payment.rv_pmnt_user_id as payRecBy,
			rv_payment.pr_persona_id as payedBy,
			rv_payment.rv_pmnt_amount as payAmnt,
			rf_currency.rf_currency_symbol as payCurr,
			pr_persona.pr_name_first as payedByFName,
			pr_persona.pr_name_last as payedByLName,
			rf_mthd_pmnt.rf_mthd_pmnt_desc as payMthd,
			pr_parent.pr_name_first as payFName,
			pr_parent.pr_name_last as payLName,
			rf_bank.rf_bank_acc_name,
			rf_bank.rf_bank_id
			$SQL
	";

	$getsql .= $extra . $extra2 . $extra3 . $extra4 . $extra5 . " ORDER BY " . $orderClause;

	$result = $lDB->get($getsql,0);

	$rows = mysqli_num_rows($result);
	if($rows == "0") {
		$pdf->Row(array(
			array('data'=>"No data matched your filter criteria", 'border'=>"LTBR", 'align'=>"C")
		));    
	} else {
		for($i=0; $i<$rows; $i++) {
			$resultSet = mysqli_fetch_array($result);
			// Disable row click if the user does not have access
			$payCapId = 299;
			$resultSet['resPayNum'] = $resultSet['rvPayId'];
			// Get reservation number for payment
			$resultSet['resNum'] = $lDB->get("SELECT rv_payment_item.rv_reservation_id FROM rv_payment_item WHERE rv_payment_item.rv_payment_id = '$resultSet[rvPayId]'",4);
			$resultSet['payAmnt'] = $resultSet['payAmnt'];
			$resultSet['payNote'] = t_encodeOverlib($resultSet['payNote']);
			$resultSet['hideNote'] = "";
			$resultSet['hideFlag'] = "visibility:visible;";
			if($resultSet['payNote'] == "") {
				$resultSet['hideFlag'] = "visibility:hidden;";
			}       
			if($resultSet['payNote'] == "" || $notes != "true") {
				$resultSet['hideNote'] = "collapse printCollapse";
			}
  
			$resultSet['payName'] = trim($resultSet['payFName']." ".$resultSet['payLName']);
  
			$GLOBALS['temp']['payCurr'] = $resultSet['payCurr'];
			$GLOBALS['temp']['payMthd'] = $resultSet['payMthd'];
			if($resultSet['payedBy'] <> "0") {
				$resultSet['payedByName'] = trim($resultSet['payedByFName']." ".$resultSet['payedByLName']);
			} else {
				$resultSet['payedByName'] = "Cash";
			}
			$payedLen = strlen($resultSet['payedByName']);
			if($payedLen > $limit) {
				$resultSet['payedByName'] = substr($resultSet['payedByName'], 0, $limit)."..";
			}
			$resultSet['payDateCrtd'] = chng_date(substr($resultSet['payDateCrtd'],0,10), "-");
			$resultSet['payDate'] = chng_date($resultSet['payDate'], "-");
  
			$sql="
				SELECT
					rv_payment_item.rv_payment_id,
					rv_payment_item.rv_payment_item_ix,
					rv_reservation.rv_reservation_ix,
					rv_reservation.rv_res_name,
					fn_folio.fn_folio_folio_num,
					fn_invoice.fn_invoice_ix,
					pr_persona.pr_name_last,
					pr_persona.pr_name_first,
					rv_payment_item.rv_pay_item_amt_rec,
					rf_currency.rf_currency_symbol,
					rv_payment_item.rv_pay_item_exch_rate,
					rv_payment_item.rv_payment_item_amt,
					rv_payment_item.rv_payment_contra_id
				FROM
					rv_payment_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_payment_item.rv_reservation_id
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
					LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind = 2
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
					LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
				WHERE
					rv_payment_item.rv_payment_id = '$resultSet[rvPayId]'
				ORDER BY
					fn_folio.fn_folio_folio_num
			";
			$resResult = $lDB->get($sql,2);
			foreach($resResult as $resKey=>$resItem) {
				$resResult[$resKey]['pr_name'] = trim($resItem['pr_name_first'] . " " . $resItem['pr_name_last']);
				if(trim($resItem['fn_invoice_ix']) != "") {
					$resResult[$resKey]['fn_folio_folio_num'] = $resItem['fn_invoice_ix'];
				}
			}
      
			$pdf->Row(array(
				array('width'=>"8%", 'data'=>$resultSet['resPayNum'], 'border'=>"LTBR", 'style'=>"B"),
				array('width'=>"6%", 'data'=>$resultSet['resNum'], 'border'=>"LTBR"),
				array('width'=>"11%", 'data'=>$resultSet['payName'], 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>$resultSet['payDateCrtd'], 'border'=>"LTBR"),
				array('width'=>"18%", 'data'=>$resultSet['payedByName'], 'border'=>"LTBR"),
				array('width'=>"12%", 'data'=>$resultSet['rf_bank_acc_name'], 'border'=>"LTBR"),        
				array('width'=>"8%", 'data'=>$resultSet['payDate'], 'border'=>"LTBR"),
				array('width'=>"9%", 'data'=>$resultSet['payAmnt'], 'border'=>"LTBR", 'align'=>"R"),
				array('width'=>"4%", 'data'=>$resultSet['payCurr'], 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>$resultSet['payMthd'], 'border'=>"LTBR"),
				array('width'=>"8%", 'data'=>$resultSet['payRef'], 'border'=>"LTBR")     
			));
			if($resultSet['payNote'] && (isset($GLOBALS['temp']['disNotes']) && $GLOBALS['temp']['disNotes'] == " checked")) {
				$pdf->Row(array(
					array('width'=>"10%", 'data'=>"", 'border'=>"LTBR", 'style'=>"B"),      
					array('width'=>"10%", 'data'=>"Payment Note: ", 'border'=>"TB", 'style'=>"B"),
					array('width'=>"80%", 'data'=>$resultSet['payNote'], 'border'=>"TBR")        
				));    
			}
   
			if(isset($GLOBALS['temp']['disResDet']) && $GLOBALS['temp']['disResDet'] == " checked") {
				$pdf->Row(array(
					array('width'=>"10%", 'data'=>"", 'border'=>"LR", 'style'=>"B"),
					array('width'=>"8%", 'data'=>"Res No", 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"20%", 'data'=>"Res Name", 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"7%", 'data'=>"Folio/Inv", 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"18%", 'data'=>"Invoice to", 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"10%", 'data'=>"Rec Amount", 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"7%", 'data'=>"Inv Curr", 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"9%", 'data'=>"Exch Rate", 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"9%", 'data'=>"Ledger Amt", 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"2%", 'data'=>"", 'border'=>"LR")             
				));
				foreach ($resResult as $res) {
					$pdf->Row(array(
						array('width'=>"10%", 'data'=>"", 'border'=>"LR"),      
						array('width'=>"8%", 'data'=>$res['rv_reservation_ix'], 'border'=>"LTBR"),
						array('width'=>"20%", 'data'=>$res['rv_res_name'], 'border'=>"LTBR"),
						array('width'=>"7%", 'data'=>$res['fn_folio_folio_num'], 'border'=>"LTBR"),
						array('width'=>"18%", 'data'=>$res['pr_name'], 'border'=>"LTBR"),
						array('width'=>"10%", 'data'=>$res['rv_pay_item_amt_rec'], 'border'=>"LTBR", 'align'=>"R"),
						array('width'=>"7%", 'data'=>$res['rf_currency_symbol'], 'border'=>"LTBR"),
						array('width'=>"9%", 'data'=>$res['rv_pay_item_exch_rate'], 'border'=>"LTBR", 'align'=>"R"),
						array('width'=>"9%", 'data'=>$res['rv_payment_item_amt'], 'border'=>"LTBR", 'align'=>"R"),
						array('width'=>"2%", 'data'=>"", 'border'=>"LR")
					));
				}
				$pdf->Row(array(
					array('width'=>"100%", 'data'=>"", 'border'=>"LR")
				));          
			}   
		}
	}  
	if($countCurrency <= 1) {
		$totalAmount = $lDB->get("SELECT SUM(rv_payment.rv_pmnt_amount) ".$SQL.$extra.$extra2.$extra3.$extra4.$extra5,4);
		fixAmtDisplay($totalAmount,2);
		$totalCurrencyId = $lDB->get("SELECT DISTINCT rv_payment.rf_currency_id ".$SQL.$extra.$extra2.$extra3.$extra4.$extra5,4);
		$totalCurrency = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$totalCurrencyId'",4);
		$pdf->Row(array(
			array('width'=>"71%", 'data'=>"Total amount received", 'align'=>"R", 'fill'=>1, 'border'=>"LRTB"),
			array('width'=>"9%", 'data'=>$totalAmount, 'align'=>"R", 'fill'=>1, 'border'=>"LRTB"),
			array('width'=>"4%", 'data'=>$totalCurrency, 'align'=>"L", 'fill'=>1, 'border'=>"LRTB"),
			array('width'=>"16%", 'data'=>"", 'align'=>"C", 'fill'=>1, 'border'=>"LRTB")
		));
	}

	if ($renderType == "view") {
		pdf_view($pdf);
	} elseif ($renderType == "send") {
		pdf_send($pdf,"Payments Received.pdf");
	}
	// End PDF code
}

if($renderMode == "csv") {   
	if(!isset($pName) || $pName == "") {
		$pName = "All";
	}
	if ($GLOBALS['temp']['mthdpayNames'] == "All") {
		$payMethName = "All";   
	}   


	$showNotes = (isset($GLOBALS['temp']['disNotes'])) && $GLOBALS['temp']['disNotes'] == " checked";
	$showRes = (isset($GLOBALS['temp']['disResDet'])) && $GLOBALS['temp']['disResDet'] == " checked";
	$format = "multi";
	if(!$showRes) {
		$format = "single";
	}
	
	$csvFile = array();
	array_push($csvFile,array("Payments Received Report"));
	array_push($csvFile,array());
	array_push($csvFile,array("Payment Number",$_SERVER['argv'][14]));
	if(isset($GLOBALS['temp']['datePaidChecked']) && $GLOBALS['temp']['datePaidChecked'] == "checked") {
		array_push($csvFile,array("Date of Payment","From: ".chng_date($_SERVER['argv'][1],"-")." To: ".chng_date($_SERVER['argv'][2],"-")));
	} else if (isset($GLOBALS['temp']['dateRecordedChecked']) && $GLOBALS['temp']['dateRecordedChecked'] == "checked") {
		array_push($csvFile,array("Recorded On","From: ".chng_date($_SERVER['argv'][6],"-")." To: ".chng_date($_SERVER['argv'][7],"-")));   
	}
	array_push($csvFile,array("Payer/Payee",$pName));
	array_push($csvFile,array("Total Results",$countRows));
	if($advancedVal == "expand") {
		array_push($csvFile,array("Advanced Settings:"));
		array_push($csvFile,array("Recorded By",(isset($rName) ? $rName : "")));
		array_push($csvFile,array("Payment Reference",urldecode($_SERVER['argv'][9])));
		array_push($csvFile,array("Currency",$currName));
		array_push($csvFile,array("Method of Payment",$payMethName));
	}
	array_push($csvFile,array());
	$headers = array("Payment No","Res No","Recorded by","Recorded on","Payer/payee","Bank / Cash Point","Date","Amount","Curr","Pay Method","Reference");
	if($format == "single" && $showNotes) {
		array_push($headers,"Payment Note");
	}
	array_push($csvFile,$headers);

	$getsql = "
		SELECT
			rv_payment.rv_payment_ix as rvPayId,
			rv_payment.rv_pmnt_date_created as payDateCrtd,
			rv_payment.rv_pmnt_date as payDate,
			rv_payment.rv_pmnt_ref as payRef,
			rv_payment.rv_pmnt_note as payNote,
			rv_payment.rf_currency_id as payCurrId,
			rv_payment.rv_pmnt_user_id as payRecBy,
			rv_payment.pr_persona_id as payedBy,
			rv_payment.rv_pmnt_amount as payAmnt,
			rf_currency.rf_currency_symbol as payCurr,
			pr_persona.pr_name_first as payedByFName,
			pr_persona.pr_name_last as payedByLName,
			rf_mthd_pmnt.rf_mthd_pmnt_desc as payMthd,
			pr_parent.pr_name_first as payFName,
			pr_parent.pr_name_last as payLName,
			rf_bank.rf_bank_acc_name,
			rf_bank.rf_bank_id
			$SQL
	";

	$getsql .= $extra . $extra2 . $extra3 . $extra4 . $extra5 . " ORDER BY " . $orderClause;

	$result = $lDB->get($getsql,0);

	$rows = mysqli_num_rows($result);
	if($rows == "0") {
		array_push($csvFile,array("No data matched your filter criteria"));
	} else {
		for ($i = 0; $i < $rows; $i++) {
			$resultSet = mysqli_fetch_array($result);
			// Disable row click if the user does not have access
			$payCapId = 299;
			$resultSet['resPayNum'] = $resultSet['rvPayId'];
			// Get reservation number for payment
			$resultSet['resNum'] = $lDB->get("SELECT rv_payment_item.rv_reservation_id FROM rv_payment_item WHERE rv_payment_item.rv_payment_id = '$resultSet[rvPayId]'",4);
			$resultSet['payAmnt'] = $resultSet['payAmnt'];
			$resultSet['payNote'] = t_encodeOverlib($resultSet['payNote']);
			$resultSet['hideNote'] = "";
			$resultSet['hideFlag'] = "visibility:visible;";
			if($resultSet['payNote'] == "") {
				$resultSet['hideFlag'] = "visibility:hidden;";
				$resultSet['hideNote'] = "collapse printCollapse";
			}       
			if($resultSet['payNote'] == "" || $notes != "true") {
				$resultSet['hideNote'] = "collapse printCollapse";
			}
  
			$resultSet['payName'] = trim($resultSet['payFName']." ".$resultSet['payLName']);
  
			$GLOBALS['temp']['payCurr'] = $resultSet['payCurr'];
			$GLOBALS['temp']['payMthd'] = $resultSet['payMthd'];
			if($resultSet['payedBy'] <> "0") {
				$resultSet['payedByName'] = trim($resultSet['payedByFName']." ".$resultSet['payedByLName']);
			} else {
				$resultSet['payedByName'] = "Cash";
			}
			$payedLen = strlen($resultSet['payedByName']);
			if($payedLen > $limit) {
				$resultSet['payedByName'] = substr($resultSet['payedByName'], 0, $limit)."..";
			}
			$resultSet['payDateCrtd'] = chng_date(substr($resultSet['payDateCrtd'],0,10), "-");
			$resultSet['payDate'] = chng_date($resultSet['payDate'], "-");
  
			$sql="
				SELECT
					rv_payment_item.rv_payment_id,
					rv_payment_item.rv_payment_item_ix,
					rv_reservation.rv_reservation_ix,
					rv_reservation.rv_res_name,
					fn_folio.fn_folio_folio_num,
					fn_invoice.fn_invoice_ix,
					pr_persona.pr_name_last,
					pr_persona.pr_name_first,
					rv_payment_item.rv_pay_item_amt_rec,
					rf_currency.rf_currency_symbol,
					rv_payment_item.rv_pay_item_exch_rate,
					rv_payment_item.rv_payment_item_amt,
					rv_payment_item.rv_payment_contra_id
				FROM
					rv_payment_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_payment_item.rv_reservation_id
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
					LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind = 2
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
					LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
				WHERE
					rv_payment_item.rv_payment_id = '".$resultSet['rvPayId']."'
				ORDER BY
					fn_folio.fn_folio_folio_num
			";
			$resResult = $lDB->get($sql,2);         
			foreach($resResult as $resKey=>$resItem) {
				$resResult[$resKey]['pr_name'] = trim($resItem['pr_name_first'] . " " . $resItem['pr_name_last']);
				if(trim($resItem['fn_invoice_ix']) != "") {
					$resResult[$resKey]['fn_folio_folio_num'] = $resItem['fn_invoice_ix'];
				}
			}
  
			$row = array($resultSet['resPayNum'],$resultSet['resNum'],$resultSet['payName'],$resultSet['payDateCrtd'],$resultSet['payedByName'],$resultSet['rf_bank_acc_name'],$resultSet['payDate'],$resultSet['payAmnt'],$resultSet['payCurr'],$resultSet['payMthd'],$resultSet['payRef']);
			if($format == "single" && $showNotes) {
				array_push($row,$resultSet['payNote']);
			}
			array_push($csvFile,$row);
			if($format == "multi" && $showNotes && $resultSet['payNote']) {
				array_push($csvFile,array("Payment Note: ",$resultSet['payNote']));    
			}
   
			if($format == "multi" && $showRes) {
				array_push($csvFile,array("","Res no","Res name","Folio/Inv","Invoice to","Rec Amount","Inv curr","Exch Rate","Ledger Amount"));
				foreach ($resResult as $res) {
					array_push($csvFile,array("",$res['rv_reservation_ix'],$res['rv_res_name'],$res['fn_folio_folio_num'],$res['pr_name'],$res['rv_pay_item_amt_rec'],$res['rf_currency_symbol'],$res['rv_pay_item_exch_rate'],$res['rv_payment_item_amt']));
				}
				array_push($csvFile,array(""));
			}   
		}
	}

	repOutputCSV("payments_".$pdfDates,$csvFile);
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

