<?php
/*
 * $Id: init.form227.php,v 1.9 2011-05-17 14:08:26 light Exp $
 *
 * $Log: init.form227.php,v $
 * Revision 1.9  2011-05-17 14:08:26  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.8  2010-10-04 16:46:54  light
 * Bug #7301 - Rates phase 1 - Search & Replace
 *
 * Revision 1.7  2007-02-22 14:30:38  light
 * 3.14.0 bugs: Fixed the agent rate popup to only show rate types.
 *
 * Revision 1.6  2004-07-14 08:03:14  mbaxendale
 * If no rates... the scrollbar was being pushed off the screen.
 * I just reduced the size of the row
 *
 * Revision 1.5  2004/05/10 08:21:35  light
 * Bug #1891 - Property: Rates
 *
 */
 
/**
 * Form 227 - Record Payments Report
 */

if (!is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rate_pop.htm");
}

$agentId = $_SERVER['argv'][1];

$agentRates = array();
if ($agentId != "") {
	if ($agentId != "0" && !$GLOBALS['lDB']->count("pr_agent_rate","pr_agent_id",$agentId,0)) {
		$sql = "
			SELECT
				rt_rate_type.rt_rate_type_ix as rt_rate_type_id
			FROM
				rt_rate_type, rf_currency, pr_agent_rate
			WHERE
				(rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
				AND pr_agent_rate.pr_agent_id = '$agentId')
				AND rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
				AND rt_rate_type_inactive_yn = '0'
			ORDER BY
				rt_rate_type.rt_rate_type_desc
		";
	} else {
		$sql = "
			SELECT
				rt_rate_type.rt_rate_type_ix as rt_rate_type_id
			FROM
				rf_default_rate
				LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rf_default_rate.rf_default_rate_id
				LEFT JOIN rf_currency ON rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
			WHERE
				rt_rate_type_inactive_yn = '0'
			ORDER BY
				rt_rate_type.rt_rate_type_desc";
	}
	$agentRates = $GLOBALS['lDB']->get($sql,3);
} else {
	if ($userStatusId > "1") {
		$sql = "
			SELECT
				rt_rate_type.rt_rate_type_ix
			FROM
				rt_rate_type, rf_currency
			WHERE
				rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
				AND rt_rate_type.rt_rate_type_inactive_yn = '0'
			ORDER BY
				rt_rate_type.rt_rate_type_desc
		";
	} else {
		if ($calAgentId != "0" && !$GLOBALS['lDB']->count("pr_agent_rate","pr_agent_id",$calAgentId,0)) {
			$sql = "
				SELECT
					rt_rate_type.rt_rate_type_ix as rt_rate_type_id
				FROM
					rt_rate_type, rf_currency, pr_agent_rate
				WHERE
					rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
					AND pr_agent_rate.pr_agent_id = '$calAgentId'
					AND rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
					AND rt_rate_type_inactive_yn = '0'
				ORDER BY
					rt_rate_type.rt_rate_type_desc
			";
		} else {
			$sql = "
				SELECT
					rt_rate_type.rt_rate_type_ix as rt_rate_type_id
				FROM
					rf_default_rate
					LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rf_default_rate.rf_default_rate_id
					LEFT JOIN rf_currency ON rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
				WHERE
					rt_rate_type_inactive_yn = '0'
				ORDER BY
					rt_rate_type.rt_rate_type_desc
			";
		}
	}
	$agentRates = $GLOBALS['lDB']->get($sql,3);
}

$agentRateSql = " AND rt_rate.rt_rate_type_id IN ('".join("','",$agentRates)."') ";

$result = $GLOBALS['lDB']->get($sql = "
	SELECT DISTINCT
		rt_rate_type.rt_rate_type_ix as rfRateId,
		rt_rate_type.rt_rate_type_desc as rfRateDesc,
		rf_currency.rf_currency_symbol as rateCurr
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_ix IN ('".join("','",$agentRates)."')
	ORDER BY
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
",0);

// Result file
$rowHTML = Join("",file(__DIR__ . "/../../../public/html/rate_pop_rows.htm"));
$output = "";

$resultRows = mysqli_num_rows($result);

$rateTypeList = array();

$gRateDesc = "";
$gPrdDesc = "";
$gPropDesc = "";
for ($i=0; $i<$resultRows; $i++) {
	$resultSet = mysqli_fetch_array($result);

	if ($resultSet['rfRateDesc'] == $gRateDesc) {
		$resultSet['rfRateDesc'] = "";
	} else {
		$gRateDesc = $resultSet['rfRateDesc'];
		$gPrdDesc = "";
		$resultSet['rfRateDesc'] .= " (".$resultSet['rateCurr'].")";
	}


	$output .= showpage($resultSet,$rowHTML);
}

if ($output) {
	$GLOBALS['temp']['rows'] = $output;
} else {
	$GLOBALS['temp']['rows'] = "
		<table width=\"436\" height=\"230\" bgcolor=\"#FFFFFF\">
			<tr>
				<td colspan=2 align=center>No Rate Type/Period combinations for this property.</td>
			</tr>
		</table>
	";
}
