<?php

/**
 * Form 232 - Multi-filter popup for reports
 */

if(!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/filter_popup.htm");
}

// From rate sheet, rate type filter sends rate list via POST
if (
   isset($_SERVER['argv'][1]) &&
   $_SERVER['argv'][1] == "rate" &&
   isset($_POST) &&
   isset($_POST['rate'])
) {
   $_SERVER['argv'][2] = $_POST['rate'];
}

if(isset($_POST['filterUrl']) && $_POST['filterUrl'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['filterUrl'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$search = isset($_POST['lastname']) ? $_POST['lastname'] : "";

if ( $search == "" ) {
	$search = "*";
}

$GLOBALS['temp']['lastsearch'] 	= $search;
$GLOBALS['temp']['blankAll'] 		= "true";
$GLOBALS['temp']['allowNone'] 	= "false";
$GLOBALS['temp']['pastDateButton'] = "collapse printCollapse";
$GLOBALS['temp']['initPastDates'] = "";
$GLOBALS['temp']['inactiveButton'] = "collapse printCollapse";
$GLOBALS['temp']['initInactiveRateTypes'] = "";

$search 				= str_replace("*", "%", $search);

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$filter 				= $_SERVER['argv'][1];
$selectedArray 	= explode(":", $_SERVER['argv'][2]);
// argv 3 is used to specify a subset. For example a property id for an accommodation type filter
// argv 4 is used for as an additional toggle or data that may be needed
$filterAlias 	= $_SERVER['argv'][5];

$searchURL = array($_SERVER['argv'][0],$_SERVER['argv'][1],"",$_SERVER['argv'][3],$_SERVER['argv'][4],$_SERVER['argv'][5]);
$GLOBALS['temp']['searchURL'] = t_encodeOverlib(join("+",$searchURL));

$excludeArray = array();
$default 			= "";

$GLOBALS['temp']['overlibTxt'] = "overlib('<div>Select the filter to be applied by clicking the checkbox to the left of the name. Use the search field at the top to narrow the list. Wildcards can be used, for example: enter B* to list all records that start with a B, once you have entered this in the search area, click the Go button to display results</div>',WIDTH,215)";
$listArray = array();

$maxSelect = 0;

switch ($filter) {
case "propertiesExtra":
	$selectOn = "";
	if ( in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "" ) {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">Not property specific</span></td></tr></table>";
case "properties": //Properties
	$listArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ac_accomm_type.pr_business_id as id,
			pr_persona.pr_name_last as namelast,
			pr_business.pr_bus_inactive_yn as inactiveYN
		FROM
			sc_accomm,
			ac_accomm_type,
			pr_business,
			pr_persona
		WHERE
			sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
		AND
			sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		AND
			ac_accomm_type.ac_accomm_type_inactive_yn = 0
		AND
			ac_accomm_type.pr_business_id = pr_business.pr_business_id
		/* AND pr_business.pr_bus_inactive_yn= '0' */
		AND
			pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		AND
		pr_persona.pr_name_last LIKE '" . $search . "'
	", 2);
	break;
case "accomm":
	$listArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ac_accomm_type.ac_accomm_type_ix as id,
			CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) as namelast,
            ac_accomm_type.ac_accomm_type_inactive_yn as inactiveYN
         FROM
            sc_accomm, ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
         WHERE
            sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
            AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
            AND ac_accomm_type.ac_accomm_type_inactive_yn=0
            AND ac_accomm_type.ac_accomm_desc LIKE '$search'
		 ORDER BY
		 	ac_accomm_type.ac_accomm_desc
      ", 2);

	   break;
   case "status": //Status
      $sql = "
         SELECT
            rf_reservation_status.rf_reservation_status_id as id,
            rf_reservation_status.rf_reservation_status_desc as namelast,
            '0' as inactiveYN
         FROM
            rf_reservation_status
         WHERE
            rf_reservation_status.rf_reservation_status_desc LIKE '".$search."'
         ORDER BY
            rf_reservation_status.rf_reservation_status_desc";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      array_push($excludeArray, "15"); //Excluding status 15(Allocation)
      array_push($excludeArray, "25"); //Excluding status 25(In Progress)
      array_push($excludeArray, "40"); //Excluding status 40(Invoiced)
      array_push($excludeArray, "50"); //Excluding status 50(Blocked)
      array_push($excludeArray, "97"); //Excluding status 97(Deleted allocation)
      break;
   case "statusAlloc": //Status with allocations
      $sql = "
         SELECT
            rf_reservation_status.rf_reservation_status_id as id,
            rf_reservation_status.rf_reservation_status_desc as namelast,
            '0' as inactiveYN
         FROM
            rf_reservation_status
         WHERE
            rf_reservation_status.rf_reservation_status_desc LIKE '".$search."'
         ORDER BY
            rf_reservation_status.rf_reservation_status_desc";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      array_push($excludeArray, "25"); //Excluding status 25(In Progress)
      array_push($excludeArray, "40"); //Excluding status 40(Invoiced)
      array_push($excludeArray, "50"); //Excluding status 50(Blocked)
      array_push($excludeArray, "97"); //Excluding status 97(Deleted allocation)
      break;
   case "statusRoom": //Status for the rooming chart
      $sql = "
         SELECT
            rf_reservation_status.rf_reservation_status_id as id,
            rf_reservation_status.rf_reservation_status_desc as namelast,
            '0' as inactiveYN
         FROM
            rf_reservation_status
         WHERE
            rf_reservation_status.rf_reservation_status_desc LIKE '".$search."'
         ORDER BY
            rf_reservation_status.rf_reservation_status_desc";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      array_push($excludeArray, "0"); //Excluding status 0(Quotation)
      array_push($excludeArray, "10"); //Excluding status 10(Waitlist)
      array_push($excludeArray, "25"); //Excluding status 25(In Progress)
      array_push($excludeArray, "40"); //Excluding status 40(Invoiced)
      array_push($excludeArray, "50"); //Excluding status 50(Blocked)
      array_push($excludeArray, "90"); //Excluding status 90(Cancelled)
      array_push($excludeArray, "95"); //Excluding status 95(Deleted)
      array_push($excludeArray, "97"); //Excluding status 97(Deleted allocation)
      break;

   case "agent": //Agent
      $agentWhere = "";
      if($userStatusId < 2) {
         $agentWhere = " AND pr_persona.pr_persona_ix = '$calAgentId' ";
         $default = "";
      }
      $sql = "
         SELECT
            pr_persona.pr_persona_ix as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_agent.pr_agent_inactive_yn as inactiveYN
         FROM
            pr_persona
            INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
         WHERE
            pr_persona.pr_name_last LIKE '".$search."'
            $agentWhere
         ORDER BY
            pr_persona.pr_name_last,
            pr_persona.pr_name_first
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
	  if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		  $selectOn = "checked=\"checked\"";
	  }
	  $default = "
		  <table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		  <col width=\"40\" />
		  <col />
		  <tr>
		  <td valign=\"middle\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\" " . $selectOn . "/></td>
		  <td valign=\"middle\"><label for=\"0\" id=\"0name\" class=\"uk-text-bold\">Direct booking</label></td>
		  </tr>
		  </table>
		  ";

	  if ( $userStatusId < 2 ) {
		  $default = "";
	  }

	  $pattern = "/^".str_replace("%",".*",$search)."/i";

	  if ( !preg_match($pattern, "Direct") ) {
		  $default = "";
	  }
	  break;
   case "agentRelationship": //Agent
      $agentWhere = "";
      if($userStatusId < 2) {
         $agentWhere = " AND pr_persona.pr_persona_ix = '$calAgentId' ";
         $default = "";
      }
      $sql = "
         SELECT
            pr_persona.pr_persona_ix as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_agent.pr_agent_inactive_yn as inactiveYN
         FROM
            pr_persona
            INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
         WHERE
            pr_persona.pr_name_last LIKE '".$search."'
            /*AND pr_agent.pr_agent_inactive_yn = '0'*/
            $agentWhere
         ORDER BY
            pr_persona.pr_name_last,
            pr_persona.pr_name_first
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = "checked=\"checked\"";
      }
			$default = "
				<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
				<col width=\"40\" />
				<col />
					<tr>
						<td valign=\"middle\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\" " . $selectOn . "/></td>
						<td valign=\"middle\"><label for=\"0\" id=\"0name\" class=\uk-text-bold\">Direct booking</label></td>
					</tr>
				</table>
			";

			if ( $userStatusId < 2 ) {
				$default = "";
			}

			$pattern = "/^".str_replace("%",".*",$search)."/i";

			if ( !preg_match($pattern, "Direct") ) {
				$default = "";
			}
			break;
	case "agentAlloc": // Agent filter for use with allocations
      $agentWhere = "";
      if($userStatusId < 2) {
         $agentWhere = " AND pr_persona.pr_persona_ix = '$calAgentId' ";
         $default = "";
      }
      $sql = "
         SELECT
            pr_persona.pr_persona_ix as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_agent.pr_agent_inactive_yn as inactiveYN
         FROM
            pr_persona
            INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
         WHERE
            pr_persona.pr_name_last LIKE '".$search."'
            /*AND pr_agent.pr_agent_inactive_yn = '0'*/
            $agentWhere
         ORDER BY
            pr_persona.pr_name_last,
            pr_persona.pr_name_first
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = "checked=\"checked\"";
      }

			$pattern = "/^".str_replace("%",".*",$search)."/i";

			$default = "";
			break;
   case "contact": //Contact
      $sql = "
         SELECT DISTINCT
            pr_persona.pr_persona_ix as id,
            pr_persona.pr_name_first as namelast,
            pr_persona.pr_name_last as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
		 	rv_reservation
            INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id
         WHERE
            /*AND pr_persona.pr_persona_inactive_yn = 0*/
            pr_persona.pr_name_last LIKE '".$search."'
         ORDER BY
            pr_persona.pr_name_last,
            pr_persona.pr_name_first
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Contact</span></td></tr></table>";
      break;
case "extraSupplier": //Service By
	$sql = "
		SELECT DISTINCT
			pr_persona.pr_persona_ix as id,
			pr_persona.pr_name_last as namelast,
			pr_persona.pr_name_first as namefirst,
			pr_persona.pr_persona_inactive_yn as inactiveYN
		FROM
			pr_persona
			INNER JOIN rv_extra ON pr_persona.pr_persona_ix = rv_extra.pr_supplier_id
		WHERE
			pr_persona.pr_name_last LIKE '".$search."'
			AND pr_persona.pr_sys_code < 5
			AND pr_persona.pr_persona_db <> ''
		ORDER BY
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
	";
	$listArray = $GLOBALS['lDB']->get($sql, 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Contact</span></td></tr></table>";
	break;
case "createdBy": //Created By
	$sql = "
		SELECT DISTINCT
			pr_persona.pr_persona_ix as id,
			pr_persona.pr_name_last as namelast,
			pr_persona.pr_name_first as namefirst,
			pr_persona.pr_persona_inactive_yn as inactiveYN
		FROM
			pr_persona
			INNER JOIN rv_reservation ON pr_persona.pr_persona_ix = rv_reservation.pr_reservation_user_id
		WHERE
			pr_persona.pr_name_last LIKE '".$search."'
		ORDER BY
			pr_persona.pr_name_first,
			pr_persona.pr_name_last
	";
	$listArray = $GLOBALS['lDB']->get($sql, 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No created  by</span></td></tr></table>";
	break;
   case "consultant": //Consultant
      $sql = "
         SELECT
            sc_user.pr_user_id as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
            sc_group
            INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
            INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
         WHERE
            sc_group.sc_grp_consultant_yn = 1
            /*AND pr_persona.pr_persona_inactive_yn = 0*/
            AND (pr_persona.pr_name_last LIKE '%".$search."%' OR pr_persona.pr_name_first LIKE '%".$search."%')
         ORDER BY
            pr_persona.pr_name_first,
            pr_persona.pr_name_last
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Consultant</span></td></tr></table>";
      break;
	case "api_audit_user":
	$sql = "
		SELECT DISTINCT
			pr_user.pr_user_id as id,
			ad_api.pr_user_id,
			pr_persona.pr_name_last as namelast,
			pr_persona.pr_name_first as namefirst,
			pr_persona.pr_persona_inactive_yn as inactiveYN,
			sc_group.sc_grp_api_yn
		FROM
			pr_user
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_user.pr_user_id
			LEFT JOIN ad_api ON pr_user.pr_user_id = ad_api.pr_user_id
			LEFT JOIN sc_user ON sc_user.pr_user_id = pr_persona.pr_persona_ix
			LEFT JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
		WHERE
			pr_user.pr_user_inactive_yn = 0
			AND pr_persona.pr_name_last LIKE '".$search."'
			ORDER BY
			pr_persona.pr_name_first,
			pr_persona.pr_name_last
	";
	$listArray = $GLOBALS['lDB']->get($sql, 2);
/*	foreach($listArray as $key=>$item) {
		if($listArray[$key]['sc_grp_api_yn'] == 1) {
			$listArray[$key]['namelast'] = '<B>'.$listArray[$key]['namelast'].'</B>';
			$listArray[$key]['namefirst'] = '<B>'.$listArray[$key]['namefirst'].'</B>';
		}
}*/

	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "";
      break;
   case "rate": //Rate type
      if ($calAgentId != "0") {
         $sql = "
            SELECT
               pr_agent_rate.rt_rate_type_id as id,
               rt_rate_type.rt_rate_type_desc as namelast,
               rt_rate_type.rt_rate_type_inactive_yn as inactiveYN
            FROM
               pr_agent_rate
               LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
            WHERE
               pr_agent_id = '".$calAgentId."'
               AND rt_rate_type.rt_rate_type_desc LIKE '".$search."'";
      } elseif ($userStatusId > "1") {
         $sql = "
            SELECT
				rt_rate_type.rt_rate_type_ix as id,
				rt_rate_type_desc as namelast,
				rt_rate_type.rt_rate_type_inactive_yn as inactiveYN
            FROM
				rt_rate_type
			WHERE
				rt_rate_type.rt_rate_type_desc LIKE '".$search."'
         ";
      } else {
         $sql = "
            SELECT
               rf_default_rate.rf_default_rate_id as id,
               rt_rate_type.rt_rate_type_desc as namelast,
               rt_rate_type.rt_rate_type_inactive_yn as inactiveYN
            FROM
               rf_default_rate
               LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rf_default_rate.rf_default_rate_id
            WHERE
               rt_rate_type.rt_rate_type_desc LIKE '".$search."'
         ";
      }
	  $sql .= "
		  ORDER BY
		  	rt_rate_type.rt_rate_type_desc
	 ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      break;
   case "originator":
      $excludeList = array_merge(
         $GLOBALS['lDB']->get("SELECT pr_business.pr_business_id FROM pr_business",3),
         array());//$GLOBALS['lDB']->get("SELECT pr_agent.pr_agent_id FROM pr_agent",3));
      $excludeBusiness = " AND pr_persona.pr_persona_ix NOT IN ('".join("','",$excludeList)."') ";
      $sql = "
         SELECT DISTINCT
            pr_persona.pr_persona_ix as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
		 	rv_reservation
            INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id
         WHERE
			(
			 	pr_persona.pr_name_last LIKE '$search'
				OR pr_persona.pr_name_first LIKE '$search'
			)
            AND pr_persona.pr_sys_code < 6
               /*AND pr_persona.pr_persona_inactive_yn=0*/
            /* $excludeBusiness */
         ORDER BY
            pr_persona.pr_name_last, pr_name_first
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Originator</span></td></tr></table>";
      break;
   case "source": //Source
      $sql = "
         SELECT
            rf_source_ix as id,
            rf_source_desc as namelast,
            rf_source_inactive_yn as inactiveYN
         FROM
            rf_source
         WHERE
            rf_source_desc LIKE '$search'
         ORDER BY
            rf_source_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Source</span></td></tr></table>";
      break;
   case "currencies": //Currency
      $sql = "
         SELECT
            rf_currency_ix as id,
            rf_currency_name as namelast,
            rf_currency_inactive_yn as inactiveYN
         FROM
            rf_currency
         WHERE
            rf_currency_name LIKE '$search'
         ORDER BY
            rf_currency_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "components": //Components
      $sql = "
         SELECT
            rt_component_ix as id,
            rt_component_desc as namelast,
            rt_component_inactive_yn as inactiveYN
         FROM
            rt_component
         WHERE
            rt_component_desc LIKE '$search'
         ORDER BY
            rt_component_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "country": //Country
      $sql = "
         SELECT
            rf_country_ix as id,
            rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            rf_country
         WHERE
            rf_country_name LIKE '$search'
         ORDER BY
            rf_country_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "agentCountry":
      $sql = "
         SELECT DISTINCT
            rf_country.rf_country_ix as id,
            rf_country.rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            pr_persona
            INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
            INNER JOIN rf_country ON pr_persona.pr_corr_country_id = rf_country.rf_country_ix
         WHERE
            rf_country.rf_country_name LIKE '$search'
         ORDER BY
            rf_country.rf_country_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "agentPostCountry":
      $sql = "
         SELECT DISTINCT
            rf_country.rf_country_ix as id,
            rf_country.rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            pr_persona
            INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
            INNER JOIN rf_country ON pr_persona.pr_corr_country_id = rf_country.rf_country_ix
         WHERE
            rf_country.rf_country_name LIKE '$search'
         ORDER BY
            rf_country.rf_country_name
      ";
		$GLOBALS['temp']['allowNone'] = "true";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "postCountry":
      $sql = "
         SELECT
            rf_country_ix as id,
            rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            rf_country
         WHERE
            rf_country_name LIKE '$search'
         ORDER BY
            rf_country_name
      ";
      $GLOBALS['temp']['allowNone'] = "true";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "physCountry":
      $sql = "
         SELECT
            rf_country_ix as id,
            rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            rf_country
         WHERE
            rf_country_name LIKE '$search'
         ORDER BY
            rf_country_name
      ";
      $GLOBALS['temp']['allowNone'] = "true";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "agentPhysCountry":
      $sql = "
         SELECT DISTINCT
            rf_country.rf_country_ix as id,
            rf_country.rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            pr_persona
            INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
            INNER JOIN rf_country ON pr_persona.pr_phys_country_id = rf_country.rf_country_ix
         WHERE
            rf_country.rf_country_name LIKE '$search'
         ORDER BY
            rf_country.rf_country_name
      ";
		$GLOBALS['temp']['allowNone'] = "true";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
      case "originatorPostCountry":
      $sql = "
         SELECT DISTINCT
            rf_country.rf_country_ix as id,
            rf_country.rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            pr_persona
            INNER JOIN rv_reservation ON pr_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id
            INNER JOIN rf_country ON pr_persona.pr_corr_country_id = rf_country.rf_country_ix
         WHERE
            rf_country.rf_country_name LIKE '$search'
         ORDER BY
            rf_country.rf_country_name
      ";
		$GLOBALS['temp']['allowNone'] = "true";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "originatorPhysCountry":
      $sql = "
         SELECT DISTINCT
            rf_country.rf_country_ix as id,
            rf_country.rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            pr_persona
            INNER JOIN rv_reservation ON pr_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id
            INNER JOIN rf_country ON pr_persona.pr_phys_country_id = rf_country.rf_country_ix
         WHERE
            rf_country.rf_country_name LIKE '$search'
         ORDER BY
            rf_country.rf_country_name
      ";
		$GLOBALS['temp']['allowNone'] = "true";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "nationality":
      $sql = "
         SELECT DISTINCT
            rf_country.rf_country_ix as id,
            rf_country.rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            rv_reservation
            INNER JOIN rf_country ON rv_reservation.rf_country_id = rf_country.rf_country_ix
         WHERE
            rf_country.rf_country_name LIKE '$search'
         ORDER BY
            rf_country.rf_country_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\">\n<tr>\n<td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"" . $selectOn . "></td>\n<td><label for=\"0\" id=\"0name\" class=\"uk-text-bold\">No nationality</label></td>\n</tr>\n</table>\n";
      break;
   case "nationalityGuest":
      $sql = "
         SELECT DISTINCT
            rf_country.rf_country_ix as id,
            rf_country.rf_country_name as namelast,
            rf_country_inactive as inactiveYN
         FROM
            pr_guest
            INNER JOIN rf_country ON pr_guest.rf_country_id = rf_country.rf_country_ix
         WHERE
            rf_country.rf_country_name LIKE '$search'
         ORDER BY
            rf_country.rf_country_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\">\n<tr>\n<td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"" . $selectOn . "></td>\n<td><label for=\"0\" id=\"0name\" class=\"uk-text-bold\">No nationality</label></td>\n</tr>\n</table>\n";
      break;
   case "paymentPlan" :
      $sql = "
         SELECT DISTINCT
            ac_pay_plan.ac_pay_plan_ix as id,
            ac_pay_plan.ac_pay_plan_desc as namelast,
            ac_pay_plan.ac_pay_plan_inactive_yn as inactiveYN
         FROM
            ac_pay_plan
         WHERE
            ac_pay_plan.ac_pay_plan_desc LIKE '$search'
         ORDER BY
            ac_pay_plan.ac_pay_plan_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "roomComponents": //Components
      $sql = "
         SELECT DISTINCT
            rt_component.rt_component_ix as id
         FROM
            rt_component
            INNER JOIN ac_accomm_room_attr ON ac_accomm_room_attr.rt_component_id = rt_component.rt_component_ix
         WHERE
            rt_component_desc LIKE '$search'
            AND ac_accomm_room_attr.ac_accomm_type_id = '".$_SERVER['argv'][3]."'
      ";
      $listArray = $GLOBALS['lDB']->get($sql,3);
      $sql = "
         SELECT
            rt_component.rt_component_ix as id
         FROM
            rt_component
            WHERE
            rt_component_desc LIKE '$search'
      ";
      if($_SERVER['argv'][4] == "") {
         $listArray = array_diff($GLOBALS['lDB']->get($sql,3),$listArray);
         $sql = "
            SELECT
               rt_component.rt_component_ix as id,
               rt_component.rt_component_desc as namelast,
               rt_component.rt_component_inactive_yn as inactiveYN
            FROM
               rt_component
            WHERE
               rt_component.rt_component_ix IN ('".join("','",$listArray)."')
            ORDER BY
               rt_component_desc
         ";
         $listArray = $GLOBALS['lDB']->get($sql,2);
      } else {
         $sql = "
            SELECT
               rt_component.rt_component_ix as id,
               rt_component.rt_component_desc as namelast,
               rt_component.rt_component_inactive_yn as inactiveYN
            FROM
               rt_component
            WHERE
               rt_component_desc LIKE '$search'
            ORDER BY
               rt_component_desc
         ";
         $listArray = $GLOBALS['lDB']->get($sql,2);
      }
      $GLOBALS['temp']['blankAll'] = "false";
     $GLOBALS['temp']['allowNone'] = "true";
	 $maxSelect = 5;
      break;
   case "rooms":
      $sql = "
         SELECT
            ac_accomm_room.ac_accomm_room_ix as id,
            ac_accomm_room.ac_desc as namelast,
            ac_accomm_room.ac_accomm_room_inactive_yn as inactiveYN
         FROM
            ac_accomm_room
         WHERE
            ac_desc LIKE '$search'
            AND ac_accomm_type_id = '".$_SERVER['argv'][3]."'
         ORDER BY
            (ac_desc+0),ac_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      foreach($listArray as $key=>$item) {
         $compArray = $GLOBALS['lDB']->get("
            SELECT
               rt_component.rt_component_desc
            FROM
               ac_accomm_room_attr
               INNER JOIN rt_component ON rt_component.rt_component_ix = ac_accomm_room_attr.rt_component_id
            WHERE
               ac_accomm_room_attr.ac_accomm_room_id = '$item[id]'
         ",3);
         $compList = join(", ",$compArray);
		 if(trim($compList) != "") {
	         $listArray[$key]['namelast'] .= " (" . $compList . ")";
		 }
      }
      $GLOBALS['temp']['blankAll'] = "false";
      break;
   case "guestLink":
      $sql = "
         SELECT DISTINCT
            pr_persona.pr_persona_ix as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
            pr_persona
            INNER JOIN pr_link ON pr_link.pr_link_to = pr_persona.pr_persona_ix AND
               (pr_link.rf_link_type_id = 'RS3' OR pr_link.rf_link_type_id = 'RS4')
         WHERE
            pr_persona.pr_name_last LIKE '$search'
            AND pr_persona.pr_sys_code < 6
            /*AND pr_persona.pr_persona_inactive_yn=0*/
         ORDER BY
            pr_persona.pr_name_last, pr_name_first";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "extraCategory":
      $sql = "
         SELECT
            ac_extra_category_ix as id,
            ac_extra_cat_desc as namelast,
            ac_extra_category_inactive_yn as inactiveYN
         FROM
            ac_extra_category
         WHERE
            ac_extra_cat_desc LIKE '".$search."'
         ORDER BY
            ac_extra_cat_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "mthdpay": //Method of payment
      $sql = "
         SELECT
            rf_mthd_pmnt_ix as id,
            rf_mthd_pmnt_desc as namelast,
            rf_mthd_pmnt_inactive_yn as inactiveYN
         FROM
            rf_mthd_pmnt
         WHERE
            rf_mthd_pmnt_desc LIKE '$search'
         ORDER BY
            rf_mthd_pmnt_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      #$default = "<table cellspacing=\"0\" width=\"100%\"><td width=\"40\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"txtb\">All</span></td></tr></table>";
      break;
   case "propertyServer": //Property Server
      function getChildren($businessId) {
         $list = $GLOBALS['lDB']->get("
            SELECT
               pr_business_id
            FROM
               pr_business
            WHERE
               pr_business_parent = '$businessId'
         ",3);
         $children = array();
         foreach($list as $item) {
            $children =
            array_merge($children,getChildren($item));
         }
         array_push($children, $businessId);
         return $children;
      }

      $sql = "
         SELECT
            pr_link_to
         FROM
            pr_link
         WHERE
            pr_link.rf_link_type_id = 'RS1'
         AND
            pr_link.pr_link_from = '".$GLOBALS['userid']."'";
      $topProperty = $GLOBALS['lDB']->get($sql,4);

      $propertyList = $GLOBALS['lDB']->get("
         SELECT DISTINCT
            ac_accomm_type.pr_business_id
         FROM
            ac_accomm_type
         INNER JOIN pr_persona ON
            pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
         WHERE
            ac_accomm_type.pr_business_id IN ('".join("','",getChildren($topProperty))."')
      ",3);

      $sql="SELECT
               rf_database.rf_db_code as id,
               CONCAT(rf_db_description, ' [', rf_database.rf_db_code, ']') as namelast
            FROM
               rf_database
            INNER JOIN rf_db_business ON
               rf_database.rf_db_code = rf_db_business.rf_db_code
            WHERE
               rf_db_business.pr_business_id IN ('".join("','",$propertyList)."')
            GROUP BY
               rf_db_business.rf_db_code";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      break;
   case "server":
      $sql = "
         SELECT
			rf_db_code as id,
            rf_db_description as namelast,
			rf_db_inactive_yn as inactiveYN
         FROM
            rf_database
		 WHERE
			 rf_db_env_type_ind <> 2
         ORDER BY
            rf_db_description
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
	  array_unshift($listArray,array("id"=>"Res","namelast"=>"Reservation Office","inactiveYN"=>"0"));
      break;
   case "serverAudit":
      $sql = "
         SELECT
			rf_db_code as id,
            rf_db_description as namelast,
			rf_db_inactive_yn as inactiveYN
         FROM
            rf_database
		 WHERE
			 rf_db_env_type_ind <> 2
         ORDER BY
            rf_db_description
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
	  array_unshift($listArray,array("id"=>"Res","namelast"=>"Reservation Office","inactiveYN"=>"0"));
      break;
   case "sourceAllActive":
      $sql = "
         SELECT
			rf_db_code as id,
            CONCAT(rf_db_description, ' [', rf_db_code, ']') as namelast,
			rf_db_inactive_yn as inactiveYN
         FROM
            rf_database
		WHERE
            CONCAT(rf_db_description, ' [', rf_db_code, ']') LIKE '$search'
         ORDER BY
            rf_db_description
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "folioContact": // Folio contacts (invoice report)
      $sql = "
         SELECT DISTINCT
            pr_persona.pr_persona_ix as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
            pr_persona
            INNER JOIN fn_folio ON fn_folio.fn_folio_to_id = pr_persona.pr_persona_ix
         WHERE
            pr_persona.pr_name_last LIKE '".$search."'
         ORDER BY
            pr_persona.pr_name_last,
            pr_persona.pr_name_first
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">Cash</span></td></tr></table>";
      if($userStatusId < 2) $default = "";
     $pattern = "/^".str_replace("%",".*",$search)."/i";
     if(!preg_match ($pattern, "Direct")) $default = "";
      break;
   case "billingEntities": // Billing Entities
      $listArray = $GLOBALS['lDB']->get("
         SELECT DISTINCT
			pr_business.pr_business_id as id,
            pr_persona.pr_name_last as namelast,
            pr_business.pr_bus_inactive_yn as inactiveYN
         FROM
            pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
         WHERE
			pr_business.pr_bus_billing_yn = 1
            AND pr_persona.pr_name_last LIKE '$search'
      ", 2);
      break;
	  case "bank":
		  $listArray = $GLOBALS['lDB']->get("
		  SELECT
		  	rf_bank.rf_bank_ix as id,
			rf_bank.rf_bank_acc_name as namelast,
			'0' as inactiveYN
		  FROM
		  	rf_bank
           WHERE rf_bank.rf_bank_acc_name LIKE '%$search%' 
		  ORDER BY
		  	rf_bank.rf_bank_acc_name
		  ",2);
			$selectOn = "";
			if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
				$selectOn = " checked";
			}
			$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">None</span></td></tr></table>";
			if($userStatusId < 2) $default = "";
			$pattern = "/^".str_replace("%",".*",$search)."/i";
			if(!preg_match ($pattern, "None")) $default = "";
			break;
	case "batch":
		$listArray = $GLOBALS['lDB']->get("
			SELECT
				fn_batch.fn_batch_ix as id,
				fn_batch.fn_batch_name as namelast
			FROM
				fn_batch
			WHERE
				fn_batch.pr_business_id = '".$_SERVER['argv'][3]."'
				AND fn_batch_closed_yn = 0
		",2);
		$selectOn = "";
		if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
			$selectOn = " checked";
		}
		$default = "<table cellspacing=\"0\" width=\"100%\">\n<tr>\n<td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"" . $selectOn . "></td>\n<td><label for=\"0\" id=\"0name\" class=\"uk-text-bold\">Unallocated</label></td>\n</tr>\n</table>\n";
	  	break;

case "title": //Title
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rf_title_ix as id,
			rf_title_desc as namelast,
			rf_title_inactive_yn as inactiveYN
		FROM
			rf_title
		WHERE
			rf_title_desc LIKE '$search'
		ORDER BY
			rf_title_desc
	", 2);
	break;

case "suffix": //Suffix
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rf_name_suffix_ix as id,
			rf_suffix_desc as namelast,
			rf_suffix_inactive_yn as inactiveYN
		FROM
			rf_name_suffix
		WHERE
			rf_suffix_desc LIKE '$search'
		ORDER BY
			rf_suffix_desc
	", 2);
	break;

case "gender": //Gender
	$listArray =  array(array(
			0 => 'RS1','id' => 'RS1',
			1 => 'Male', 'namelast' => 'Male',
			2 => 0, 'inactiveYN' => 0
		),
		array(
			0 => 'RS2', 'id' => 'RS2',
			1 => 'Female', 'namelast' => 'Female',
			2 => 0, 'inactiveYN' => 0
		)
	);
	break;

case "guestRole": //Gender
	$listArray =  array(array(
			0 => 'RS1','id' => 'RS1',
			1 => 'Male', 'namelast' => 'Primary',
			2 => 0, 'inactiveYN' => 0
		),
		array(
			0 => 'RS2', 'id' => 'RS2',
			1 => 'Female', 'namelast' => 'Secondary',
			2 => 0, 'inactiveYN' => 0
		)
	);
	break;

case "guestType": //guest type
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rf_guest_type_ix as id,
			rf_guest_type_name as namelast,
			rf_guest_type_inactive_yn as inactiveYN
		FROM
			rf_guest_type
		WHERE
			rf_guest_type_name LIKE '$search'
		ORDER BY
			rf_guest_type_name
	", 2);
	break;

case "guest": //guest
	$guest = explode('_', $_SERVER['argv'][3]);
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rf_obj_guest_data_ix as id,
			rf_obj_guest_data_content as namelast,
			rf_obj_guest_data_inactive_yn as inactiveYN
		FROM
			rf_obj_guest_data
		WHERE
			rf_obj_guest_id = '$guest[1]'
			AND rf_obj_guest_data_content LIKE '$search'
		ORDER BY
			rf_obj_guest_data_content
	", 2);
	break;

case "trip": //guest
	$trip = explode('_', $_SERVER['argv'][3]);
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rf_obj_trip_data_ix as id,
			rf_obj_trip_data_content as namelast,
			rf_obj_trip_data_inactive_yn as inactiveYN
		FROM
			rf_obj_trip_data
		WHERE
			rf_obj_trip_id = '$trip[1]'
			AND rf_obj_trip_data_content LIKE '$search'
		ORDER BY
			rf_obj_trip_data_content
	", 2);
	break;

case "sales": //guest
	$trip = explode('_', $_SERVER['argv'][3]);
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rc_obj_sales_data_ix as id,
			rc_obj_sales_data_content as namelast,
			rc_obj_sales_data_inactive_yn as inactiveYN
		FROM
			rc_obj_sales_data
		WHERE
			rc_obj_sales_id = '$trip[1]'
			AND rc_obj_sales_data_content LIKE '$search'
		ORDER BY
			rc_obj_sales_data_content
	", 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">None</span></td></tr></table>";
	break;

case "event_tag": //Event tag code table eventAction
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rc_tag_ix as id,
			rc_tag_desc as namelast,
			rc_tag_inactive_yn as inactiveYN
		FROM
			rc_tag
		WHERE
			rc_tag_desc LIKE '$search'
		ORDER BY
			rc_tag_desc
	", 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Event Tag</span></td></tr></table>";
	break;

case "eventAction": //Event action code table
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rc_action_ix as id,
			rc_action_desc as namelast,
			rc_action_inactive_yn as inactiveYN
		FROM
			rc_action
		WHERE
			rc_action_desc LIKE '$search'
		ORDER BY
			rc_action_desc
	", 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Event type</span></td></tr></table>";
	break;

case "event": //Event code table
case "eventOrigin":
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rc_event_ix as id,
			rc_event_desc as namelast,
			rc_event_inactive_yn as inactiveYN
		FROM
			rc_event
		WHERE
			rc_event_desc LIKE '$search'
		ORDER BY
			rc_event_desc
	", 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Event</span></td></tr></table>";
	break;

case "clientRep":
	$sql = "
		SELECT DISTINCT
			pr_persona.pr_persona_ix as id,
			pr_persona.pr_name_last as namelast,
			pr_persona.pr_name_first as namefirst,
			pr_persona.pr_persona_inactive_yn as inactiveYN
		FROM
			pr_persona
			INNER JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_from
		WHERE
			pr_persona.pr_name_last LIKE '".$search."'
			AND pr_persona.pr_sys_code < 5
			AND pr_persona.pr_persona_db <> ''
			AND pr_link.rf_link_type_id = 'RS2'
		ORDER BY
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
	";
	$listArray = $GLOBALS['lDB']->get($sql, 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Contact</span></td></tr></table>";
	break;
case "internalRep": //Internal Rep
case "internalRepSales": //Internal Rep
	$sql = "
		SELECT DISTINCT
			pr_persona.pr_persona_ix as id,
			pr_persona.pr_name_last as namelast,
			pr_persona.pr_name_first as namefirst,
			pr_persona.pr_persona_inactive_yn as inactiveYN
		FROM
			pr_persona
			INNER JOIN pr_user ON pr_persona.pr_persona_ix = pr_user.pr_user_id
			INNER JOIN pr_link ON pr_link.pr_link_from = pr_persona.pr_persona_ix AND pr_link.rf_link_type_id = 'RS1'
		WHERE
			pr_persona.pr_name_last LIKE '".$search."'
			AND pr_persona.pr_persona_db <> ''
			AND pr_persona.pr_sys_code <> '9'
			AND pr_persona.pr_persona_inactive_yn = '0'
			AND pr_user.pr_user_inactive_yn = '0'
		ORDER BY
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
	";
	$listArray = $GLOBALS['lDB']->get($sql, 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Contact</span></td></tr></table>";
	break;

case "contactName": //Internal Rep
	$sql = "
		SELECT DISTINCT
			pr_persona.pr_persona_ix as id,
			pr_persona.pr_name_last as namelast,
			pr_persona.pr_name_first as namefirst,
			pr_persona.pr_persona_inactive_yn as inactiveYN
		FROM
			pr_persona
		WHERE
			pr_persona.pr_name_last LIKE '".$search."'
			AND pr_persona.pr_persona_db <> ''
		ORDER BY
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
	";
	$listArray = $GLOBALS['lDB']->get($sql, 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	break;

case "contactRole": //Gender
	$listArray =  array(array(
			0 => 'RS1','id' => 'RS1',
			1 => 'General (no role)', 'namelast' => 'General (no role)',
			2 => 0, 'inactiveYN' => 0
		),
		array (
			0 => 'RS2', 'id' => 'RS2',
			1 => 'Guest', 'namelast' => 'Guest',
			2 => 0, 'inactiveYN' => 0
		),
		array (
			0 => 'RS3', 'id' => 'RS3',
			1 => 'User', 'namelast' => 'User',
			2 => 0, 'inactiveYN' => 0
		),
		array (
			0 => 'RS4', 'id' => 'RS4',
			1 => 'Agent', 'namelast' => 'Agent',
			2 => 0, 'inactiveYN' => 0
		)
	);
	break;

case "contactType":
	$listArray =  array(array(
			0 => 'RS1','id' => 'RS1',
			1 => 'Individual', 'namelast' => 'Individual',
			2 => 0, 'inactiveYN' => 0
		),
		array (
			0 => 'RS2', 'id' => 'RS2',
			1 => 'Organisations', 'namelast' => 'Guest',
			2 => 0, 'inactiveYN' => 0
		)
	);
	break;
case "ratePeriod":
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rt_period.rt_period_ix AS id,
			rt_period.rt_period_desc AS namelast,
			rt_period.rt_period_date_to AS date_to
		FROM
			rt_period
		WHERE
			rt_period.rt_period_desc LIKE '".$search."';
	", 2);
	break;
case "rateComponent":
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rt_component.rt_component_ix AS id,
			rt_component.rt_component_desc AS namelast
		FROM
			rt_component
		WHERE
			rt_component.rt_component_desc LIKE '".$search."'
			AND rt_component.rt_component_inactive_yn <> 1;
	", 2);
	break;
// These two rateGroup cases are the identical aside from the names used.  We need two distinct ones for the Rate Sheet.
case "rateGroupSplit":
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_group.rt_rate_group_ix AS id,
			rt_rate_group.rt_rate_group_desc AS namelast
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_desc LIKE '".$search."'
			AND rt_rate_group.rt_rate_group_inactive_yn <> 1
		ORDER BY rt_rate_group.rt_rate_group_desc;
	", 2);
	break;
case "rateGroupAmount":
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_group.rt_rate_group_ix AS id,
			rt_rate_group.rt_rate_group_desc AS namelast
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_desc LIKE '".$search."'
			AND rt_rate_group.rt_rate_group_inactive_yn <> 1
		ORDER BY rt_rate_group.rt_rate_group_desc;
	", 2);
	break;
case "taxRate":
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rf_tax_rate.rf_tax_rate_ix AS id,
			rf_tax_rate.rf_tax_rate_desc AS namelast
		FROM
			rf_tax_rate
		WHERE
			rf_tax_rate.rf_tax_rate_desc LIKE '".$search."'
			AND rf_tax_rate.rf_tax_rate_inactive_yn <> 1;
	", 2);
	break;
case "taxGroup":
	$listArray = $GLOBALS['lDB']->get("
		SELECT
			rt_tax_group.rt_tax_group_ix AS id,
			rt_tax_group.rt_tax_group_desc AS namelast
		FROM
			rt_tax_group
		WHERE
			rt_tax_group.rt_tax_group_desc LIKE '".$search."'
			AND rt_tax_group.rt_tax_group_inactive_yn <> 1;
	", 2);
	break;
case "billingContact": //Billing Contact
	$sql = "
		SELECT DISTINCT
			pr_persona.pr_persona_ix as id,
			pr_persona.pr_name_first as namelast,
			pr_persona.pr_name_last as namefirst,
			pr_persona.pr_persona_inactive_yn as inactiveYN
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_billing_persona_id
		WHERE
			/*AND pr_persona.pr_persona_inactive_yn = 0*/
			pr_persona.pr_name_last LIKE '".$search."'
			ORDER BY
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
	";
	$listArray = $GLOBALS['lDB']->get($sql, 2);
	$selectOn = "";
	if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
		$selectOn = " checked";
	}
	$default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No billing contact</span></td></tr></table>";
	break;
   case "auditTrailModule":
      $sql = "
         SELECT
			rf_audit_module_id as id,
            CONCAT(rf_audit_module_name, ' (', rf_audit_module_description_external, ')') as namelast
         FROM
            rf_audit_module
         ORDER BY
            rf_audit_module_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "auditTrailField":
      $sql = "
         SELECT
			ad_module_field_id as id,
            CONCAT(ad_module_field_description, ' (', rf_audit_module_name, ')') as namelast
         FROM
            ad_module_field
			INNER JOIN rf_audit_module ON rf_audit_module.rf_audit_module_id = ad_module_field.rf_audit_module_id
         ORDER BY
            rf_audit_module_name, ad_module_field_description
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "auditTrailUser":
      $sql = "
         SELECT DISTINCT
            sc_user.pr_user_id as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
            sc_group
            INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
            INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
			INNER JOIN ad_reservation ON ad_reservation.pr_user_id = pr_persona.pr_persona_ix
         WHERE
            pr_persona.pr_name_last LIKE '".$search."'
         ORDER BY
            pr_persona.pr_name_first,
            pr_persona.pr_name_last
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Consultant</span></td></tr></table>";
      break;
   case "auditTrailAction":
	  $listArray = array(
		  array("id" => "1", "namelast" => "Add"),
		  array("id" => "2", "namelast" => "Edit"),
		  array("id" => "3", "namelast" => "Delete"),
	  );
      break;
   case "auditTrailPersonaModule":
      $sql = "
         SELECT
			rf_audit_module_id as id,
            CONCAT(rf_audit_module_name, ' (', rf_audit_module_description_external, ')') as namelast
         FROM
            rf_audit_module
         WHERE
            rf_audit_module.rf_audit_module_description_internal IN ('persona','phone','guest','tripsheet')
         ORDER BY
            rf_audit_module_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "auditTrailPersonaUser":
      $sql = "
         SELECT DISTINCT
            sc_user.pr_user_id as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
            sc_group
            INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
            INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
			INNER JOIN ad_persona ON ad_persona.pr_user_id = pr_persona.pr_persona_ix
         WHERE
            pr_persona.pr_name_last LIKE '".$search."'
         ORDER BY
            pr_persona.pr_name_first,
            pr_persona.pr_name_last
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      $default = "<table cellspacing=\"0\" width=\"100%\"><tr height=\"20\"><td width=\"32\"><input id=\"0\" class=\"uk-checkbox\" type=\"checkbox\"".$selectOn."></td><td><span id=\"0name\" class=\"uk-text-bold\" onclick=\"chngBox('0');\" style=\"cursor:default;\">No Consultant</span></td></tr></table>";
      break;
   case "specials":
      $sql = "
         SELECT
			sp_special_ix AS id,
			sp_special_desc AS namelast
         FROM
			sp_special
         WHERE
            sp_special_desc LIKE '".$search."'
         ORDER BY
            sp_special_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "rateEditComponents":
      $sql = "
		SELECT
			rt_component.rt_component_ix AS id,
			rt_component.rt_component_desc AS namelast
		FROM
			rt_component
		WHERE
			rt_component.rt_component_inactive_yn = '0'
			AND rt_component.rt_component_desc LIKE '".$search."'
			AND rt_component.rt_component_ix NOT IN ('".implode($selectedArray,"','")."')
		ORDER BY
			rt_component.rt_component_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      $GLOBALS['temp']['blankAll'] = "false";
      break;
   case "allocation":
      $sql = "
		SELECT 
			rv_reservation.rv_reservation_ix AS id, 
			IF (
				bl_block.bl_block_abbrev = '' OR bl_block.bl_block_abbrev IS NULL,
				rv_reservation.rv_res_name,
				CONCAT('Block (', bl_block.bl_block_abbrev, '): ', rv_reservation.rv_res_name)
			) AS namelast
		FROM 
			rv_reservation 
			LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
			LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
		WHERE 
			rf_reservation_status_id IN ('15')
			AND IF (
				bl_block.bl_block_abbrev = '' OR bl_block.bl_block_abbrev IS NULL,
				rv_reservation.rv_res_name,
				CONCAT('Block (', bl_block.bl_block_abbrev, '): ', rv_reservation.rv_res_name)
			) LIKE '".$search."'
         ORDER BY
            rv_res_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "blockTemplate":
      $sql = "
      SELECT 
         bl_block.bl_block_ix AS id, 
         CONCAT(bl_block.bl_block_name, ' (', bl_block.bl_block_abbrev, ')') AS namelast
      FROM 
         bl_block
      WHERE 
         CONCAT(bl_block.bl_block_name, ' (', bl_block.bl_block_abbrev, ')') LIKE '".$search."'
         ORDER BY
         bl_block.bl_block_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "userGroup":
      $sql = "
      SELECT 
         sc_group.sc_group_id AS id, 
         sc_group.sc_grp_desc AS namelast
      FROM 
         sc_group
      WHERE 
         sc_group.sc_grp_desc LIKE '".$search."'
         ORDER BY
         sc_group.sc_grp_desc
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   case "useraccessAuditUser":
      $sql = "
         SELECT DISTINCT
            sc_user.pr_user_id as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
            sc_group
            INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
            INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
            INNER JOIN ad_useraccess ON ad_useraccess.pr_user_id = pr_persona.pr_persona_ix
         WHERE
            pr_persona.pr_name_last LIKE '".$search."'
         ORDER BY
            pr_persona.pr_name_first,
            pr_persona.pr_name_last
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      break;
   case "userAccessFunction":
      $sql = "
         SELECT DISTINCT
            ad_useraccess.ad_useraccess_form as id,
            ad_useraccess.ad_useraccess_form as namelast
         FROM
            ad_useraccess
         WHERE
            ad_useraccess.ad_useraccess_form LIKE '".$search."'
            AND ad_useraccess.ad_useraccess_form NOT LIKE '%reminder%'
         ORDER BY
            ad_useraccess.ad_useraccess_form
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);

      foreach ($selectedArray as $key => $value) {
         $selectedArray[$key] = str_replace(array(' ', '(', ')'), '', urldecode($value));
      }

      foreach ($listArray as $key => $value) {
         $listArray[$key]['id'] = str_replace(array(' ', '(', ')'), '', $value['id']);
      }

      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      break;
   case "userAccessType":
      $sql = "
         SELECT DISTINCT
            ad_module_field.ad_module_field_id as id,
            ad_module_field.ad_module_field_description as namelast
         FROM
            ad_useraccess_detail
            LEFT JOIN ad_module_field ON ad_module_field.ad_module_field_id = ad_useraccess_detail.ad_module_field_id
         WHERE
            ad_useraccess_detail.ad_module_field_id != ''
         ORDER BY
            ad_module_field.ad_module_field_description
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);
      break;
   
   case "miscAuditUser":
      $sql = "
         SELECT DISTINCT
            sc_user.pr_user_id as id,
            pr_persona.pr_name_last as namelast,
            pr_persona.pr_name_first as namefirst,
            pr_persona.pr_persona_inactive_yn as inactiveYN
         FROM
            sc_group
            INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
            INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
            INNER JOIN ad_misc ON ad_misc.pr_user_id = pr_persona.pr_persona_ix
         WHERE
            pr_persona.pr_name_last LIKE '".$search."'
         ORDER BY
            pr_persona.pr_name_first,
            pr_persona.pr_name_last
      ";
      $listArray = $GLOBALS['lDB']->get($sql, 2);
      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      break;
   case "miscFunction":
      $sql = "
         SELECT DISTINCT
            ad_misc.ad_misc_form as id,
            ad_misc.ad_misc_form as namelast
         FROM
            ad_misc
         WHERE
            ad_misc.ad_misc_form LIKE '".$search."'
            AND ad_misc.ad_misc_form NOT LIKE '%reminder%'
         ORDER BY
            ad_misc.ad_misc_form
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);

      foreach ($selectedArray as $key => $value) {
         $selectedArray[$key] = str_replace(array(' ', '(', ')'), '', urldecode($value));
      }

      foreach ($listArray as $key => $value) {
         $listArray[$key]['id'] = str_replace(array(' ', '(', ')'), '', $value['id']);
      }

      $selectOn = "";
      if (in_array("0", $selectedArray) || $_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") {
         $selectOn = " checked";
      }
      break;
   case "miscType":
      $sql = "
         SELECT DISTINCT
            REPLACE(ad_misc_detail_field_name, ' ', '') as id,
            ad_misc_detail_field_name as namelast,
            ad_misc.ad_misc_form as function
         FROM
            ad_misc_detail
            LEFT JOIN ad_misc ON ad_misc.ad_misc_ix = ad_misc_detail.ad_misc_id
         WHERE
            ad_misc_detail_field_name != ''
         ORDER BY
            ad_misc_detail_field_name
      ";
      $listArray = $GLOBALS['lDB']->get($sql,2);

      if (!empty($_SERVER['argv'][3])) {
         // Filter out types for unselected functions
         $newListArray = array();
         foreach ($listArray as $key => $value) {
            if (
               in_array(
                  str_replace(array(' ', '(', ')'), '', $value['function']),  // function name
                  explode(":", $_SERVER['argv'][3])                           // list of selected functions
               )
            ) {
               $newListArray[] = $value;
            }
         }
         $listArray = $newListArray;
      }
      break;
}

if($filter == "guest" || $filter == "trip"  || $filter == "sales") {
	$GLOBALS['temp']['filter'] = $_SERVER['argv'][3];
} elseif ($filterAlias != ""){
	$GLOBALS['temp']['filter'] = $filterAlias;
}else {
	$GLOBALS['temp']['filter'] = $filter;
}

if ( ($_SERVER['argv'][2] == "All" || $_SERVER['argv'][2] == "") && $maxSelect === 0) {
   foreach($listArray as $listItem) {
      array_push($selectedArray, $listItem['id']);
   }
}

if($_SERVER['argv'][3] == 'tripProp'){
	$maxSelect = 1;
}

$rowHTML = Join("", file(__DIR__ . "/../../../public/html/filter_pop_rows.htm"));
$rows = $default;

foreach ( $listArray as $item ) {
	if ( !in_array($item['id'], $excludeArray) ) {
		if ( in_array($item['id'], $selectedArray) ) {
			$item['select'] = "checked=\"checked\"";
		} else {
			$item['select'] = "";
		}

		if(isset($item['namefirst'])) {
			$item['name'] = trim($item['namefirst'] . " " . $item['namelast']);
		} else {
			$item['name'] = trim($item['namelast']);
		}

		if ( isset($item['inactiveYN']) && ($item['inactiveYN'] == "1" || $item['inactiveYN'] == "-1")) {
			$item['nameClass'] = "txtg";
		} else{
			$item['nameClass'] = "";
		}

		if ($filter == "ratePeriod") {
			$GLOBALS['temp']['pastDateButton'] = "";
			$GLOBALS['temp']['initPastDates'] = "initPastDates();";
			
			$current_date = date("Y-m-d");
			if (!empty($item["date_to"])) {
				if (strtotime($item["date_to"]) < time()) {
					$item['nameClass'] = "ratePeriodPastDate";
				} else {
					$item['nameClass'] = "";
				}
			}
		}

		if ($filter == "rate") {
			$GLOBALS['temp']['inactiveButton'] = "";
			$GLOBALS['temp']['initInactiveRateTypes'] = "initInactiveRateTypes();";
			
			if ($item["inactiveYN"] != 0) {
				$item['nameClass'] = "inactiveRateType";
			} else {
				$item['nameClass'] = "";
			}
		}

		$item['name'] = t_encodeHTMLField($item['name']);
		$rows .= showpage($item, $rowHTML);
	}
}

if ($rows != "") {
	$GLOBALS['temp']['rows'] = $rows;
} else {
	$GLOBALS['temp']['rows'] = "<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>No results found</td></tr></table>";
}

//$GLOBALS['temp']['filter'] 		= $filter;
$GLOBALS['temp']['selected'] 	= "";
$GLOBALS['temp']['maxSelect']	= $maxSelect;
