<?php

/**
 * init.form240.php - Reservation Item Popup
 * Job: 674
 * Function: 66 (General Access)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/cal_roomnumNEW1.htm");
}

require_once(__DIR__ . "/class.template.php");
require_once(__DIR__ . '/functions.reservation.itinerary.php');

$newRelic = new NewRelic();
$newRelic->record_transaction("Add/Edit Itinerary");

clearTimedOutReservations();

$_SERVER['argv'] = array_pad($_SERVER['argv'],13,"");
// Inputs:
$cellStart = $_SERVER['argv'][1];
$cellEnd = $_SERVER['argv'][2];
$resId = $_SERVER['argv'][3];
$itemId = $_SERVER['argv'][4];
$accommId = $_SERVER['argv'][5];
$agentId = $_SERVER['argv'][6];
$rateId = $_SERVER['argv'][7];
$currencyId = $_SERVER['argv'][8];
$roomId = $_SERVER['argv'][9]; // When populated the popup is configured for use on the rooming module
$roomIndex = $_SERVER['argv'][10];
$commPerc = $_SERVER['argv'][11];
$forceDefault = ($_SERVER['argv'][12] == "1" ? true : false);
$forceRate = ($_SERVER['argv'][12] == "2" ? true : false);

if (!isset($_SESSION['userName']) && !empty($itemId)) {
	redirectTo("/");
}

if ($rateId == "") {
	$rateId = $GLOBALS['lDB']->get("
		SELECT 
			rt_rate_type_id
		FROM 
			rv_reservation
		WHERE 
			rv_reservation_ix = '" . $resId . "';
	",4);
}

if(trim($rateId) != "") {
	$currency = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_type.rf_currency_id,
			rf_currency.rf_currency_symbol
		FROM
			rt_rate_type
			INNER JOIN rf_currency ON rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
		WHERE
			rt_rate_type_ix = '$rateId'
	",1);
	$currencyId = $currency['rf_currency_id'];
}
if(trim($itemId) != "") {
	$agentId = $GLOBALS['lDB']->get("
		SELECT
			rv_agent_id
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$itemId'
	",4);
	$currency = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_type.rf_currency_id,
			rf_currency.rf_currency_symbol
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			INNER JOIN rf_currency ON rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
		WHERE
		rv_reservation_item.rv_reservation_item_ix = '$itemId'
	",1);
	$currencyId = $currency['rf_currency_id'];
}

$GLOBALS['temp']['cellStart'] = $cellStart;
$GLOBALS['temp']['cellEnd'] = $cellEnd;
$GLOBALS['temp']['itemId'] = $itemId;
$GLOBALS['temp']['optDesc'] = "No optionals";
$GLOBALS['temp']['optionals'] = "";
$GLOBALS['temp']['userStatusId'] = $userStatusId;
$GLOBALS['temp']['pastCheck'] = date("Y-m-d");
$GLOBALS['temp']['minRooms'] = "0";
$GLOBALS['temp']['minPersons'] = "0";
$GLOBALS['temp']['showDiff'] = "1";
$GLOBALS['temp']['hasSpecial'] = (itemSpecialHaveApplied($itemId)) ? "1" : "0";
$GLOBALS['temp']['hasCheckin'] = "0";

$GLOBALS['temp']['commissionLabel'] = commissionLabel();

$limit = userAvailLimit();
if($limit === false) $limit = -1;

// Only internal users with financial tab update access may edit commission
$allowCommission = ($GLOBALS['userStatusId'] > 1 && isset($GLOBALS['jobLevelArray'][646]) && $GLOBALS['jobLevelArray'][646] > 5);

$hasAgent = false;
$agentInfo = [
	'pr_agent_id' => "",
	'pr_agent_alloc_ext_yn' => "",
	'pr_agent_alloc_auto_yn' => ""
];
$GLOBALS['temp']['restoreDefaultsCollapse'] = "collapse";
if ( $lDB->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$agentId'",4) > 0 ) {
	$hasAgent = true;
	$agentInfo = $lDB->get("
		SELECT
			pr_agent.pr_agent_id,
			pr_agent.pr_agent_alloc_ext_yn,
			pr_agent.pr_agent_alloc_auto_yn
		FROM
			pr_agent
		WHERE
			pr_agent.pr_agent_id = '" . $agentId . "'
	",1);
	if($allowCommission) {
		$GLOBALS['temp']['restoreDefaultsCollapse'] = "";
	}
}

//$limit = "3";
session_set("roomLimit",$limit);

$GLOBALS['temp']['roomLimit'] = $limit;

# ($pAction:  -- Legend
	# 0 = plain calendar add,
	# 1 = calendar add,
	# 2 = resdetail add,
	# 3 = resdetail edit
# )

// Default and validate inputs
$pAction = "0";
if ($itemId != "") {
	$pAction = "3";
} else {
	if ($resId != "") {
		$pAction = "2";
	} elseif ($cellStart != "" && $cellEnd != "") {
		$pAction = "1";
	}
}

if ($pAction < 2) {
	$resId = isset($_SESSION['wizResId']) && $_SESSION['wizResId'] != "" ? $_SESSION['wizResId'] : "";
}


if ($pAction == "3") {
	$result = $lDB->get("
		SELECT
			COUNT(rv_res_item_guest.rv_res_item_guest_id) as total
		FROM
			rv_res_item_group
			LEFT JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
		WHERE
			rv_res_item_group.rv_reservation_item_id = '$itemId'
			AND (
				(
					rv_res_item_group.ac_accomm_room_id IS NOT NULL
					AND rv_res_item_group.ac_accomm_room_id <> ''
					AND rv_res_item_group.ac_accomm_room_id <> '0'
				) OR
					rv_res_item_guest.rv_res_item_guest_id IS NOT NULL
			)
		GROUP BY
			rv_res_item_group.rv_res_item_group_ix
		ORDER BY
			total desc
	",2);
	if (sizeof($result) > 0) {
		$GLOBALS['temp']['minRooms'] = sizeof($result);
		$GLOBALS['temp']['minPersons'] = $result[0][0];
	}
}

// On submit do this:
/*if ($submit) {
	switch ($pAction) {
	case 3:
		// Update Item
		break;
	case 2:
		// Add Item to $resId
		break;
	}
	echo "\n<script>opener.reloadItinerary()</script>\n";
}*/

// On output do this:

// Standard output variables
$pr_business_id = false;
$pageTitle = "Create new itinerary item...";
$hideAccommList = "";
$hideAccommStatic = "style=\"display:none\"";
// Determine accommodation type, else render whole list
if ($pAction == 3) {
	if(trim($itemId) != "") {
		$accommId = "0";
		$accommId = $lDB->get("SELECT ac_accomm_type_id FROM rv_reservation_item WHERE rv_reservation_item.rv_reservation_item_ix = '$itemId'",4);
	}
} elseif ($pAction == 1) {
	$temp = explode(":",$cellStart);
	$accommId = $temp[0];
}


// Determine applicable rate periods
if ($pAction == "0" || $pAction == "2") {
	$SQL = "
		SELECT
			ac_accomm_type.ac_accomm_type_ix,
			pr_name_last,
			ac_accomm_type.ac_accomm_desc
		FROM
			sc_accomm
			INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id AND sc_user.pr_user_id = '$GLOBALS[userid]'
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = 0
	";

	if (is_array($_SESSION['calAccommList']) && $pAction == "0") {
		$SQL .= " AND ac_accomm_type.ac_accomm_type_ix IN ('".join("','",$_SESSION['calAccommList'])."')";
	} else {
		$SQL .= " AND ac_accomm_type.pr_business_id IN ('".join("','",$GLOBALS['property_id'])."')";
	}

	$SQL .= " ORDER BY pr_name_last, ac_accomm_type.ac_accomm_desc";

	// Generate the list of accommodation types
	$GLOBALS[$form]->AddField("accommId","accommId",$accommId,3);
	$GLOBALS['accommId']->Select = combolist($lDB,$SQL,"0:|:Select property & accommodation");
	$GLOBALS['accommId']->StyleType = "uk-select";
	$GLOBALS['accommId']->Length = "38";
	$GLOBALS['accommId']->onChange = "accommPick()";
}

$rooms = "";
$roomList = "";
$roomsDisabled = "";
$nightsDisabled = "";
$fromDisabled = "";
$roomingModule = "false";
if(!empty($roomId)) {
	$rooms = 1;
	$roomList = $roomId;
	$roomsDisabled = "disabled";
	$nightsDisabled = "disabled";
	$fromDisabled = 'customDisabledDay="disabled" customDisabledMonth="disabled" customDisabledYear="disabled" customDisabledCal="disabled"';
	$roomingModule = "true";
}
$maxCapacity = "2";
$maxAdults = "2";
$adultCount = "";
$children = "";
$GLOBALS['temp']['max_child_age'] = "";
if ( $accommId != "0" && $accommId != "" ) {
	// Get the rt_rate record, and reference all the optional components
	$accommData = $lDB->get("
		SELECT
			pr_business_id,
			pr_name_last,
			ac_accomm_desc,
			ac_accomm_capacity,
			ac_accomm_max_capacity,
			ac_accomm_max_adults,
			ac_accomm_max_child_age
		FROM
			ac_accomm_type
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_ix = '$accommId'
	",1);
	$pr_business_id = $accommData['pr_business_id'];
	$pageTitle = "$accommData[pr_name_last], $accommData[ac_accomm_desc]";
	if( (trim($cellStart) != "" && trim($cellEnd) != "") || trim($itemId) != "") {
		$hideAccommList = " style=\"display:none\"";
		$hideAccommStatic = "";
	}
	$adultCount = $accommData['ac_accomm_capacity'];
	$maxCapacity = $accommData['ac_accomm_max_capacity'];
	$maxAdults = $accommData['ac_accomm_max_adults'];
	if(trim($accommData['ac_accomm_max_child_age']) != "" && $accommData['ac_accomm_max_child_age'] != "0") {
		$GLOBALS['temp']['max_child_age'] = "(maximum child age: $accommData[ac_accomm_max_child_age])";
	}
}

// Set some output variables
$GLOBALS['temp']['title'] = $pageTitle;
$GLOBALS['temp']['hidePropAccomm'] = $hideAccommList;
$GLOBALS['temp']['hidePropAccommStatic'] = $hideAccommStatic;
$goFunction = "makeBooking";

$startDate = date("Y-m-d");
$endDate = date("Y-m-d");
if (isset($_SESSION['calStartDate']) && $_SESSION['calStartDate'] != "") {
	$startDate = $_SESSION['calStartDate'];
}
if (isset($_SESSION['calEndDate']) && $_SESSION['calEndDate'] != "") {
	$endDate = $_SESSION['calEndDate'];
}
if (($pAction == "0" && isset($_SESSION['wizResId']) && $_SESSION['wizResId'] != "") || $pAction == "2") {
	$startDate = $lDB->get("SELECT MAX(rv_item_date_depart) FROM rv_reservation_item WHERE rv_reservation_id = '$resId'",4);
	$endDate = $startDate;
}

$GLOBALS['temp']['flatrate'] = "";
$oridelevel = "";
$orideamt = "";
switch ($pAction) {
case 1:
	$startDate = explode(":",$cellStart);
	$endDate = explode(":",$cellEnd);

	if ($startDate[3].$startDate[1].$startDate[2] > $endDate[3].$endDate[1].$endDate[2]){
		$temp = $cellEnd;
		$cellEnd = $cellStart;
		$cellStart = $temp;
	}

	$startDate = explode(":",$cellStart);
	$endDate = explode(":",$cellEnd);

	$sDay = $startDate[2];
	$sMonth = $startDate[1];
	$sYear = $startDate[3];
	$startDate = $sYear."-".$sMonth."-".$sDay;

	$eDay = $endDate[2] + 1;
	$eMonth = $endDate[1];
	$eYear = $endDate[3];
	$endDate = date("Y-m-d",mktime(0,0,0,$eMonth,$eDay,$eYear));

	$nights = dateSubtract($endDate,$startDate);

	$GLOBALS['temp']['orideamt'] = "";

	// Determine if another item at this accommodation type exists
	$alreadyStaying = false;
	$items = $lDB->get("
		SELECT
			*
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '".(isset($_SESSION['wizResId']) ? $_SESSION['wizResId'] : "")."'
			AND rv_reservation_item.ac_accomm_type_id = '$accommId'
	",2);

	if (count($items) > 0){
		$alreadyStaying = true;
	}

	$optDesc = array();
	$optionals = array();

	$perStayAutoEnabled = $GLOBALS['lDB']->get("SELECT rf_per_stay_auto_yn FROM rf_default", 4);

	if ($perStayAutoEnabled == 1 && $alreadyStaying){
		$perStayComp = $GLOBALS['lDB']->get("
			SELECT
				rt_component.rt_component_ix,
				rt_component.rt_component_abbrv
			FROM
				rt_component
			WHERE
				rt_component.rt_component_sys_code = 1
		",1);


		array_push($optionals,$perStayComp[0]);
		array_push($optDesc,$perStayComp[1]);

	}

	// [START] -- Default optionals
	$defaultOptionals = getDefaultOptionalComponents($accommId,$rateId,$startDate,$endDate);
	foreach ($defaultOptionals as $defaultOptional){
		array_push($optionals,$defaultOptional[0]);
		array_push($optDesc,$defaultOptional[1]);
	}

	if (count($optDesc) > 0){
		$GLOBALS['temp']['optDesc'] = join(", ",$optDesc);
	} else {
		$GLOBALS['temp']['optDesc'] = "No optionals";
	}

	$GLOBALS['temp']['optionals'] = join(":",$optionals);

	// [END] -- Default optionals
	break;
case 3:
	$dates = $lDB->get("
		SELECT
			rv_item_accomm_count,
			rv_item_adult_count,
			rv_item_child_count,
			rv_item_date_arrive,
			rv_item_date_depart,
			TO_DAYS(rv_item_date_depart) - TO_DAYS(rv_item_date_arrive) as nights,
			rv_reservation_id,
			rt_rate_type_id,
			rv_item_comm_perc
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item_ix = '$itemId'
	",1);

	if($dates === false) {
		redirectTo(" prompt.php?type=a&message=". rawurlencode("The itinerary you are trying to edit has been changed by another user. Reload the reservation and try again."));
		die();
	}

	// If Rate Type has changed, don't carry across override
	if ($rateId == ""){
		$rateId = $dates['rt_rate_type_id'];
	}

	if ($dates['rt_rate_type_id'] == $rateId){
		$dates['override'] = getOverrideArray($itemId);
	} else {
		$dates['override'] = getOverrideArray('0');
	}

	$oridelevel = $dates['override']['level'];
	$startDate = $dates['rv_item_date_arrive'];
	$endDate = $dates['rv_item_date_depart'];

	$startDate = explode("-",$startDate);
	$sDay = $startDate[2];
	$sMonth = $startDate[1];
	$sYear = $startDate[0];
	$startDate = $sYear."-".$sMonth."-".$sDay;

	$endDate = explode("-",$endDate);
	$eDay = $endDate[2];
	$eMonth = $endDate[1];
	$eYear = $endDate[0];
	$endDate = $eYear."-".$eMonth."-".$eDay;

	$nights = $dates['nights'];
	$rooms = $dates['rv_item_accomm_count'];
	//$adults = $dates[rv_item_adult_count];
	$adultCount = $dates['rv_item_adult_count'];
	$children = $dates['rv_item_child_count'];

	// $orideamt = $dates['rv_item_overide_amt'];
	// $oridelevel = $dates['rv_item_overide_level_ind'];

	$reservationId = $dates['rv_reservation_id'];

	$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/reservation_roomnumNEW1.htm";
	$GLOBALS[$form]->FormHTML = join("",file($GLOBALS[$form]->HTML));
	$goFunction = "selfBooking";
	$saveAction = "edit";

	$list = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_res_item_comp.rt_component_id,
			rt_component.rt_component_abbrv
		FROM
			rv_res_item_comp
			INNER JOIN rt_component ON rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
		WHERE
			rv_res_item_comp.rv_item_comp_option_yn = 1
			AND rv_res_item_comp.rv_reservation_item_id = '$itemId'
		ORDER BY
		rt_component.rt_component_abbrv
	",2);
	$optDesc = array();
	$optionals = array();
	$imax = sizeof($list);
	for ($i=0;$i<$imax;$i++) {
		array_push($optionals,$list[$i][0]);
		array_push($optDesc,$list[$i][1]);
	}
	$GLOBALS['temp']['optDesc'] = join(", ",$optDesc);
	$GLOBALS['temp']['optionals'] = join(":",$optionals);

	if ($GLOBALS['temp']['optionals'] == "") {
		$GLOBALS['temp']['optDesc'] = "No optionals";
		$GLOBALS['temp']['optionals'] = "";
	}

	$hasRooming = false;
	$checkinStatus = [];
	$groupList = $lDB->get("SELECT rv_res_item_group_ix FROM rv_res_item_group WHERE rv_reservation_item_id = '$itemId'",3);
	foreach($groupList as $groupId) {
		$roomCount = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_res_item_group
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_res_item_group.rv_res_item_group_ix = '$groupId'
		",4);
		$guestCount = $lDB->get("SELECT COUNT(*) FROM rv_res_item_guest WHERE rv_res_item_group_id = '$groupId'",4);
		if($roomCount > 0 || $guestCount > 0) {
			$hasRooming = true;
		}
		$checkinStatus[] = $lDB->get("SELECT rv_grp_status_ind FROM rv_res_item_group WHERE rv_res_item_group_ix = '$groupId'",4);
	}
	if($hasRooming) { $GLOBALS['temp']['showDiff'] = "0"; }
	if(in_array('5',$checkinStatus)) {
		$fromDisabled = 'customDisabledDay="disabled" customDisabledMonth="disabled" customDisabledYear="disabled" customDisabledCal="disabled"';
		$GLOBALS['temp']['hasCheckin'] = "1";
	}
	break;
default:
	$optDesc = array();
	$optionals = array();

	$startDate = explode("-",$startDate);

	$sDay = $startDate[2];
	$sMonth = $startDate[1];
	$sYear = $startDate[0];
	$startDate = $sYear."-".$sMonth."-".$sDay;

	$endDate = date("Y-m-d",mktime (0,0,0,$sMonth,$sDay+1,$sYear));

	$endDate = explode("-",$endDate);
	$eDay = $endDate[2];
	$eMonth = $endDate[1];
	$eYear = $endDate[0];
	$endDate = $eYear."-".$eMonth."-".$eDay;

	$nights = dateSubtract($endDate,$startDate);
	if ($pAction == "2") {
		if ($rateId == ""){
			$rateId = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
		}
		$reservationId = $_SERVER['argv'][3];
		$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/reservation_roomnumNEW1.htm";
		$GLOBALS[$form]->FormHTML = join("",file($GLOBALS[$form]->HTML));
		$goFunction = "selfBooking";
		$saveAction = "add";
	}

	// Determine if another item at this accommodation type exists
	$alreadyStaying = false;
	if(isset($_SESSION['wizResId']) && $_SESSION['wizResId'] != "") {
		$items = $lDB->get("
			SELECT
				*
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_id = '".$_SESSION['wizResId']."'
				AND rv_reservation_item.ac_accomm_type_id = '$accommId'
		",2);
	} else {
		$items = "";
	}

	if (count($items) > 0){
		$alreadyStaying = true;
	}

	$perStayAutoEnabled = $GLOBALS['lDB']->get("SELECT rf_per_stay_auto_yn FROM rf_default", 4);

	if ($perStayAutoEnabled == 1 && $alreadyStaying){
		$perStayComp = $GLOBALS['lDB']->get("
			SELECT
				rt_component.rt_component_ix,
				rt_component.rt_component_abbrv
			FROM
				rt_component
			WHERE
				rt_component.rt_component_sys_code = 1
		",1);

		array_push($optionals,$perStayComp[0]);
		array_push($optDesc,$perStayComp[1]);

		$GLOBALS['temp']['optDesc'] = join(", ",$optDesc);
		$GLOBALS['temp']['optionals'] = join(":",$optionals);
	}

	// [START] -- Default optionals

	$defaultOptionals = getDefaultOptionalComponents($accommId,$rateId,$startDate,$endDate);
	foreach ($defaultOptionals as $defaultOptional){
		array_push($optionals,$defaultOptional[0]);
		array_push($optDesc,$defaultOptional[1]);
	}

	if (count($optDesc) > 0){
		$GLOBALS['temp']['optDesc'] = join(", ",$optDesc);
	} else {
		$GLOBALS['temp']['optDesc'] = "No optionals";
	}

	$GLOBALS['temp']['optionals'] = join(":",$optionals);

	// [END] -- Default optionals


	break;
}

$endArray = explode("-",$endDate);
$newEndDate = date("Y-m-d",mktime(0,0,0,$endArray[1],$endArray[2]-1,$endArray[0]));
if(trim($agentId) == "") {
	$agentId = "0";
}



$blockCount = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		bl_block
		INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
		LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
		LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
		LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
	WHERE
		draw_down_item.rv_reservation_item_ix = '$itemId'
",4);
$excludeBlockAllocations = true;
if ($blockCount > 0) {
	$excludeBlockAllocations = false;
}

$GLOBALS['temp']['loggedIn'] = !empty($_SESSION['loggedIn']);

if(!empty($accommId)) {
	$stock = new Stock($accommId,$startDate,$newEndDate,false,$agentId,true);
	$allocationArray = $stock->ToReservationAllocation($itemId, $excludeBlockAllocations);
} else {
	$allocationArray = array();
}
$allocationDateRow = "
	<thead>
		<tr>
";

$unallocatedRow = "<tr id=\"unallocatedRow\">";

$allocationRows = "";
$allocationNameRows = "";
$allocationCol = "";

$allocationResId = array();

$allocationBlockDetails = array();
$blockDetails = "";
$bl_block_ix = "";

foreach ( $allocationArray as $date => $dayList ) {
	$dateFmt = chng_date($date, "-");
	$dateArray = explode(" ",$dateFmt);
	$dateFmt = $dateArray[0] . " " . $dateArray[1];
	$allocationDateRow .= "<th class=\"uk-text-nowrap\">" . $dateFmt . "</th>";
	$unallocatedRow .= "<td align=\"center\" class=\"\">0</td>";
	$allocationCol .= "<col width=\"200\" />";

	foreach ( $dayList as $resId => $item ) {
		if(empty($item['bl_block_name'])) {
			$resName = (!empty($item['bl_block_name'])) ? $item['rv_res_name'] . " (Block: " . $item['bl_block_name'] . ")" : $item['rv_res_name'];
			$allocationResId[$resId] = $resName;
		} elseif (!empty($itemId)) {
			$allocationBlockDetails[$resId] = array('bl_block_name' => $item['bl_block_name'], 'bl_block_ix'=>$item['bl_block_ix']);
		}
	}
}
$allocationBlockDetails = count($allocationBlockDetails) > 0 ? $allocationBlockDetails : array_unique($allocationBlockDetails);
$blockAllocationIds = array();
if (!empty($itemId)) {
	foreach ($allocationBlockDetails as $allocationId => $allocationBlockDetail) {
		$blockDetails .= "
			<tr>
				<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"15\" height=\"20\" alt=\"\" /></td>
				<td height=\"20\" class=\"\">&nbsp;Block booking</td>
				<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"10\" height=\"20\" alt=\"\" /></td>
				<td id=\"\">". $allocationBlockDetails[$resId]['bl_block_name'] . " (" . $allocationBlockDetails[$resId]['bl_block_ix'] . ")</td>
				<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"15\" height=\"20\" alt=\"\" /></td>
			</tr>";
		$bl_block_ix = $allocationBlockDetails[$resId]['bl_block_ix'];
		$blockAllocationIds[] = $allocationId;
	}
}
$GLOBALS['temp']['hidBlockAllocation'] = "<input type=\"hidden\" id=\"hidBlockAllocation\" value=\"". implode(":",$blockAllocationIds) ."\" />";

// Stupid fix for the JavaScript function called to update these rows...
if ( count($allocationArray) == 0 ) {
	$GLOBALS['temp']['noAllocForJS'] = "<input type=\"hidden\" id=\"noAllocForJS\" value=\"1\" />";
} else {
	$GLOBALS['temp']['noAllocForJS'] = "<input type=\"hidden\" id=\"noAllocForJS\" value=\"0\" />";
}

$allocationDateRow .= "
		</tr>
	</thead>
";

$unallocatedRow .= "
	</tr>
";

$hasAllocStock = false;
if ($blockCount == 0) {
	foreach ( $allocationResId as $resId => $resName ) {
		$selected = false;
		$rowSelected = "";

		foreach ( $allocationArray as $date => $dayList ) {
			if (isset($dayList[$resId]) && $dayList[$resId]['selected'] ) {
				$selected = true;
				$rowSelected = " allocationSelected=\"true\" ";
			}
		}

		if ( strlen($resName) > 16 ) {
			$resNameDisplay = substr($resName,0,13) . "...";
		} else {
			$resNameDisplay = $resName;
		}

		$colSpan = 1;
		if($selected) {
			$allocationNameRows .= "
			<tr id=\"" . $resId . "_a\" onmouseover=\"mouseOverAllocation('" . $resId . "'); overlib('".t_encodeOverlib($resName)."',WIDTH,200);\" onmouseout=\" mouseOutAllocation('" . $resId . "'); nd();\" onclick=\"selectAllocation('" . $resId . "');\">
				<td class=\"txtb\" style=\"cursor: pointer;\" colspan=\"$colSpan\">&nbsp;" . $resNameDisplay . "</td>
			</tr>
			";
		} else {
			$allocationNameRows .= "
			<tr id=\"" . $resId . "_a\" onmouseover=\"mouseOverAllocation('" . $resId . "'); overlib('".t_encodeOverlib($resName)."',WIDTH,200);\" onmouseout=\" mouseOutAllocation('" . $resId . "'); nd();\" onclick=\"selectAllocation('" . $resId . "');\">
				<td class=\"\" style=\"cursor: pointer;\" colspan=\"$colSpan\">&nbsp;" . $resNameDisplay . "</td>
			</tr>
			";
		}

		if($GLOBALS['userStatusId'] > 1 && $agentInfo['pr_agent_alloc_auto_yn'] == "0") {
			$selected = true;
			$rowSelected = " allocationSelected=\"true\" ";
		}
		if($GLOBALS['userStatusId'] == 1 && $agentInfo['pr_agent_alloc_ext_yn'] == "0") {
			$selected = true;
			$rowSelected = " allocationSelected=\"true\" ";
		}

		$allocationRows .= "
			<tr class=\"imgLink\" id=\"" . $resId . "\"" . $rowSelected . "onmouseover=\"mouseOverAllocation(this.id);\" onmouseout=\" mouseOutAllocation(this.id);\" onclick=\"selectAllocation(this.id);\">
		";

		foreach ( $allocationArray as $date => $dayList ) {
			if (!isset($dayList[$resId]) || $dayList[$resId]['allocation_count'] == "" || $dayList[$resId]['expired']) {
				$dayList[$resId]['allocation_count'] = "0";
			}
			if($dayList[$resId]['allocation_count'] > 0 || $selected) {
				$hasAllocStock = true;
			}
			if ( $selected ) {
				$allocationRows .= "<td align=\"center\" class=\"colBlue txtb\" id=\"".$dayList[$resId]['allocation_count']."\">0</td>";
			} else {
				$allocationRows .= "<td align=\"center\" class=\"\" id=\"".$dayList[$resId]['allocation_count']."\">0</td>";
			}
		}
		$allocationRows .= "</tr>";
	}
}

if ( count($allocationArray) > 2 ) {
	$GLOBALS['temp']['overflow'] = "scroll";
	$tableWidth = count($allocationArray)*100;
} else {
	$GLOBALS['temp']['overflow'] = "hidden";
	$tableWidth = 200;
}

if ( count($allocationResId) > 1 ) {
	$GLOBALS['temp']['divHeight'] = 29*count($allocationResId);

	if ( $GLOBALS['temp']['divHeight'] > 60 ) {
		$GLOBALS['temp']['divHeight'] = 60;
		$GLOBALS['temp']['allocationScrollY'] = "scroll";
	} else {
		$GLOBALS['temp']['allocationScrollY'] = "hidden";
	}

} else {
	$GLOBALS['temp']['divHeight'] = 105;
}

$GLOBALS['temp']['divWidth'] = 218;
$GLOBALS['temp']['tableWidth'] = $tableWidth;
$GLOBALS['temp']['allocationCol'] = $allocationCol;
$GLOBALS['temp']['allocationNames'] = $allocationNameRows;
$GLOBALS['temp']['allocationDateRow'] = $allocationDateRow;
$GLOBALS['temp']['allocations'] = $allocationRows;
$GLOBALS['temp']['unallocatedRow'] = $unallocatedRow;

if(
	$hasAgent
	&& sizeof($allocationResId) > 0
	&& $hasAllocStock
	&& (
		($GLOBALS['userStatusId'] > 1 && $agentInfo['pr_agent_alloc_auto_yn'] == "1")
		|| ($GLOBALS['userStatusId'] == 1 && $agentInfo['pr_agent_alloc_ext_yn'] == "1")
	)
) {
	$GLOBALS['temp']['hasAllocation'] = "1";
}

$GLOBALS['temp']['nights'] = $nights;
$GLOBALS['temp']['roomCount'] = $rooms;
$GLOBALS['temp']['roomList'] = $roomList;
$GLOBALS['temp']['roomId'] = $roomId;
$GLOBALS['temp']['roomIndex'] = $roomIndex;
$GLOBALS['temp']['roomsDisabled'] = $roomsDisabled;
$GLOBALS['temp']['nightsDisabled'] = $nightsDisabled;
$GLOBALS['temp']['fromDisabled'] = $fromDisabled;
$GLOBALS['temp']['roomingModule'] = $roomingModule;
$GLOBALS['temp']['personCount'] = $maxCapacity;
$GLOBALS['temp']['adultLimit'] = $maxAdults;
$GLOBALS['temp']['adultCount'] = $adultCount;
$GLOBALS['temp']['childCount'] = $children;
$GLOBALS['temp']['goFunction'] = $goFunction;
$GLOBALS['temp']['accommIds'] = $accommId;
$GLOBALS['temp']['acCapacityList'] = "";
$GLOBALS['temp']['reservationId'] = isset($reservationId) ? $reservationId : "";
$GLOBALS['temp']['saveAction'] = isset($saveAction) ? $saveAction : "";

$days = array("0" => ":|:");
for ($x=1;$x<32;$x++){
	$days[$x] = $x /*str_pad($x,2,"0",STR_PAD_LEFT)*/.":|:".date("d",mktime(0,0,0,1,$x,2000));
}

$months = array("0" => ":|:");
for ($x=1;$x<13;$x++){
	$months[$x] = $x /*str_pad($x,2,"0",STR_PAD_LEFT)*/.":|:".date("M",mktime(0,0,0,$x,1,2000));
}
/*
$newDfield = "sDay";
$GLOBALS[$form]->AddField($newDfield,$newDfield,$sDay,0);
$GLOBALS[$newDfield]->Select($days);
$GLOBALS[$newDfield]->Size = "4";
$GLOBALS[$newDfield]->StyleType = "txt";
$GLOBALS[$newDfield]->TabIndex = "2";
#$GLOBALS[$newDfield]->TabIndex = $tabcount++;

$newMfield = "sMonth";
$GLOBALS[$form]->AddField($newMfield,$newMfield,$sMonth,0);
$GLOBALS[$newMfield]->Select($months);
$GLOBALS[$newMfield]->Size = "7";
$GLOBALS[$newMfield]->StyleType = "txt";
$GLOBALS[$newMfield]->TabIndex = "3";
#$GLOBALS[$newMfield]->TabIndex = $tabcount++;

$newYfield = "sYear";
$GLOBALS[$form]->AddField($newYfield,$newYfield,$sYear,0);
$GLOBALS[$newYfield]->Size = "1";
$GLOBALS[$newYfield]->Length = "4";
$GLOBALS[$newYfield]->StyleType = "txt";
$GLOBALS[$newYfield]->TabIndex = "4";
#$GLOBALS[$newYfield]->TabIndex = $tabcount++;

$newDfield = "eDay";
$GLOBALS[$form]->AddField($newDfield,$newDfield,$eDay,0);
$GLOBALS[$newDfield]->Select($days);
$GLOBALS[$newDfield]->Size = "4";
$GLOBALS[$newDfield]->StyleType = "txt";

$newMfield = "eMonth";
$GLOBALS[$form]->AddField($newMfield,$newMfield,$eMonth,0);
$GLOBALS[$newMfield]->Select($months);
$GLOBALS[$newMfield]->Size = "7";
$GLOBALS[$newMfield]->StyleType = "txt";
#$GLOBALS[$newMfield]->TabIndex = $tabcount++;

$newYfield = "eYear";
$GLOBALS[$form]->AddField($newYfield,$newYfield,$eYear,0);
$GLOBALS[$newYfield]->Size = "1";
$GLOBALS[$newYfield]->Length = "4";
$GLOBALS[$newYfield]->StyleType = "txt";
#$GLOBALS[$newYfield]->TabIndex = $tabcount++;
*/

$GLOBALS['temp']['sDay'] = ltrim($sDay, '0');
$GLOBALS['temp']['sMonth'] = ltrim($sMonth, '0');
$GLOBALS['temp']['sYear'] = ltrim($sYear, '0');

$GLOBALS['temp']['eDay'] = ltrim($eDay, '0');
$GLOBALS['temp']['eMonth'] = ltrim($eMonth, '0');
$GLOBALS['temp']['eYear'] = ltrim($eYear, '0');

if ($pAction == "3") {
	$isInvoiced = false;
	if ($lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
			INNER JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$itemId'
	",4)) $isInvoiced = true;

	if ($isInvoiced && 0) {
		$GLOBALS['tagList']['rooms'] = setNewAttrib("disabled");
		$GLOBALS['tagList']['sDay'] = setNewAttrib("disabled");
		$GLOBALS['tagList']['sMonth'] = setNewAttrib("disabled");
		$GLOBALS['tagList']['sYear'] = setNewAttrib("disabled");
		$GLOBALS['tagList']['nights'] = setNewAttrib("disabled");
		$GLOBALS['tagList']['adultCount'] = setNewAttrib("disabled");
		$GLOBALS['tagList']['childCount'] = setNewAttrib("disabled");

		$GLOBALS['tagList']['optServPick'] = setNewParam("style","visibility:hidden");
		$GLOBALS['tagList']['diffButton'] = setNewParam("style","visibility:hidden");
		$GLOBALS['tagList']['createButton'] = setNewParam("style","visibility:hidden");
	}
}

$calDateLimit = $GLOBALS['lDB']->get("SELECT rf_date_res_limit FROM rf_default",4);
$GLOBALS['temp']['calDateResLimit'] = $calDateLimit;
$GLOBALS['temp']['calDateResLimitNice'] = chng_date($calDateLimit,"-");
$GLOBALS['temp']['calDateResLimitYear'] = date('Y', strtotime($calDateLimit));

$GLOBALS['temp']['agentId'] = $agentId;
$GLOBALS['temp']['currencyId'] = $currencyId;

$commissionDisabled = "";
$commissionValue = "";


if($forceRate) { // Rate type has been changed by the user, use the chosen rate and look up the commission
	$agentTerms = getAgentPropertyTerms($agentId, $currencyId, $pr_business_id, $rateId);
	$commissionValue = $agentTerms['rv_commission_perc'];
} elseif($forceDefault) { // Restore defaults, use the rate and commission based on the chosen property and currency (of the header rate type)
	$agentTerms = getAgentPropertyTerms($agentId, $currencyId, $pr_business_id);
	$rateId = $agentTerms['rt_rate_type_id'];
	$commissionValue = $agentTerms['rv_commission_perc'];
} elseif(!empty($itemId)) { // Editing existing item, keep the existing rate and look up commission from the itinerary
	$commissionValue = $dates['rv_item_comm_perc'];
} else {
	$agentHeaderTerms = getAgentPropertyTerms($agentId, $currencyId); // get the header (non-property specific) terms for the agent
	$rateOverride = $agentHeaderTerms['rt_rate_type_id'] != $rateId;
	$commOverride = $agentHeaderTerms['rv_commission_perc'] != $commPerc && $commPerc !== "";
	if(!$rateOverride && !$commOverride) { // no override, use rate and commission based on the chosen property and currency
		$agentTerms = getAgentPropertyTerms($agentId, $currencyId, $pr_business_id);
		$rateId = $agentTerms['rt_rate_type_id'];
		$commissionValue = $agentTerms['rv_commission_perc'];
	} elseif($rateOverride && !$commOverride) { // only rate override, use the rate, currency and property to look up the commission
		$agentTerms = getAgentPropertyTerms($agentId, $currencyId, $pr_business_id, $rateId);
		$commissionValue = $agentTerms['rv_commission_perc'];
	} elseif(!$rateOverride && $commOverride) { // only comm override, use the property and currency to look up the rate
		$agentTerms = getAgentPropertyTerms($agentId, $currencyId, $pr_business_id);
		$rateId = $agentTerms['rt_rate_type_id'];
		$commissionValue = $commPerc;
	} else { // both overridden, use the given rate and commission
		$commissionValue = $commPerc;
	}
}

if(trim($rateId) == "" || $rateId == "0") {
	$rateId = $GLOBALS['lDB']->get("
		SELECT
			pr_agent_rate.rt_rate_type_id
		FROM
			pr_agent_rate
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
		WHERE
			pr_agent_id = '$agentId'
		ORDER BY
			pr_agent_rate_default_yn DESC,
			rt_rate_type.rt_rate_type_desc ASC
	",4);
	if(trim($rateId) == "" || $rateId == "0") {
		$rateId = $GLOBALS['lDB']->get("select rt_rate_type_id from rf_default", 4);
	}
}

$rateInfo = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_ix = '$rateId'
",1);

$rateSelectButton = "";
if($GLOBALS['userStatusId'] > 1) { // Add all rates for internal users
	$rateSelectButton = "
		<button id=\"rateSelectButton\" type=\"button\" class=\"btn btn-lgrey buttonFilter\" onclick=\"rateDropdownShow();\">
			Rate
		</button>
	";
} else {
	$rateSelectButton = "Rate";
}
$GLOBALS['temp']['rateSelectButton'] = $rateSelectButton;
$GLOBALS['temp']['rateSelect'] = "
			<input type=\"text\" disabled class=\"uk-input\" id=\"rateSelectLabel\" value=\"".t_encodeHTMLField($rateInfo['rt_rate_type_desc'].", ".$rateInfo['rf_currency_symbol'])."\">
			<input type=\"hidden\" id=\"rateSelect\" value=\"$rateId\">
			<span id=\"rateDropdownButton\"></span>
";
if(!$allowCommission) {
	$commissionDisabled = "disabled";
}
$GLOBALS['temp']['commissionDisabled'] = $commissionDisabled;
$GLOBALS['temp']['commissionValue'] = $commissionValue;

// Get existing item rate groups
$itemRateGroups = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_group.rt_rate_group_ix,
		rt_rate_group.rt_rate_group_desc,
		rt_rate_group.rt_rate_group_sys_code,
		rv_res_item_rate_grp.rv_res_item_rate_grp_count AS qty
	FROM
		rv_res_item_rate_grp
		INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
	WHERE
		rv_res_item_rate_grp.rv_reservation_item_id  = '".$itemId."'
",2);

$rate = new Rate($accommId,$startDate,$endDate,$itemRateGroups,$rateId);
$periods = $rate->ToPeriods();
$freqComponent = false;
if (count($periods) > 1){
	$freqComponent = checkFreqComponent($periods);
}
if ($freqComponent){
	$GLOBALS['temp']['freqComponent'] = "1";
} else {
	$GLOBALS['temp']['freqComponent'] = "0";
}

// Use rate override level if we don't already have a saved one, or the saved one is "none"
if ($oridelevel == "" || $oridelevel == 0){
	$oridelevel = $rate->Periods[0]['rt_rate_overide_level_ind'];
}

$orideRateGroupHide  = "";
$orideUnitStayHide = "";
switch($oridelevel){
	case 1:
		$GLOBALS['temp']['personOrideOption'] = "<option value=\"1\" selected>Person</option>";
		$GLOBALS['temp']['unitOrideOption'] = "<option value=\"2\">Unit</option>";
		$GLOBALS['temp']['stayOrideOption'] = "<option value=\"3\">Stay</option>";
		$orideRateGroupHide  = "";
		$orideUnitStayHide = "uk-hidden";
		$oridelevelname = "person";
		break;
	case 2:
		$GLOBALS['temp']['personOrideOption'] = "<option value=\"1\">Person</option>";
		$GLOBALS['temp']['unitOrideOption'] = "<option value=\"2\" selected>Unit</option>";
		$GLOBALS['temp']['stayOrideOption'] = "<option value=\"3\">Stay</option>";
		$orideRateGroupHide  = "uk-hidden";
		$orideUnitStayHide = "";
		$oridelevelname = "unit";
		break;
	case 3:
		$GLOBALS['temp']['personOrideOption'] = "<option value=\"1\" selected>Person</option>";
		$GLOBALS['temp']['unitOrideOption'] = "<option value=\"2\">Unit</option>";
		$GLOBALS['temp']['stayOrideOption'] = "<option value=\"3\" selected>Stay</option>";
		$orideRateGroupHide = "uk-hidden";
		$orideUnitStayHide = "";
		$oridelevelname = "stay";
		break;
}

$orideCurr = isset($currency)?$currency['rf_currency_symbol']:"";

$rateGroupHTML = "";
$orideRateGroupInputs  = "";
$adultRateGroups = array();
foreach ($rate->RateGroups as $rateGroup) {
	$rateGroup['rt_rate_comp_grp_seq'] = isset($rateGroup['rt_rate_comp_grp_seq'])?$rateGroup['rt_rate_comp_grp_seq']:"";
	if ($rateGroup['rt_rate_comp_grp_seq'] != '0' || (isset($rateGroup['qty']) && $rateGroup['qty'] != "")) {
		if ($rateGroup['rt_rate_group_sys_code'] != "1"){


			if ($rateGroup['rt_rate_group_class'] == "1"){
				$adultRateGroups[] = "'".$rateGroup['rt_rate_group_ix']."'";
			}

			if ($rateGroup['rt_rate_group_sys_code'] == "2" && ($rateGroup['qty'] == "0" || (!isset($rateGroup['qty']))) && $pAction != "3"){
				$rateGroupQty = ($adultCount === "") ? "0" : $adultCount;
			} else {
				$rateGroupQty = isset($rateGroup['qty']) ? $rateGroup['qty'] : "0";
			}

			$rateGroupHTML  .= "
				<div class=\"uk-margin-remove-left uk-child-width-expand\" uk-grid>
					<div class=\"uk-padding-remove-left\">".$rateGroup['rt_rate_group_desc']." per room: </div>
					<div class=\"uk-width-1-3\"><input id=\"RateGroupQty_".$rateGroup['rt_rate_group_ix']."\" name=\"RateGroupQty_".$rateGroup['rt_rate_group_ix']."\" type=\"text\" class=\"uk-margin-small-left uk-float-right\" size=\"1\"  tabindex=\"50\" value=\"".$rateGroupQty."\" /></div>
				</div>
			";

			$canOverride = checkRateGroupOverride($rate->Periods[0]['rt_rate_ix'], $rateGroup['rt_rate_group_ix']);

			if ($canOverride){
				$orideRateGroupInputs  .= "
					<div class=\"rate-grouping uk-margin-remove-left uk-child-width-expand $orideRateGroupHide\" uk-grid>
						<div class=\"uk-padding-remove-left\">
							<div class=\"uk-flex\">
								<input id=\"unitOrideAmt_".$rateGroup['rt_rate_group_ix']."\" class=\"orideInputRateGroupAmt\" type=\"text\" size=\"18\" tabindex=\"52\" value=\"".(isset($dates)&&isset($dates['override']['amounts']['rate_group'][$rateGroup['rt_rate_group_ix']])?$dates['override']['amounts']['rate_group'][$rateGroup['rt_rate_group_ix']]:"")."\" \>
								<input id=\"unitOrideCurr_".$rateGroup['rt_rate_group_ix']."\" class=\"orideInputRateGroupCurr uk-margin-small-left\" type=\"text\" tabindex=\"-1\" disabled size=\"1\" value=\"".$orideCurr."\" $orideRateGroupHide readonly=\"readonly\"\>
							</div>
						</div>
					</div>
				";
			} else {
				$orideRateGroupInputs  .= "";
			}
		}
	}
}

$GLOBALS['temp']['adultRateGroups'] = "var adultRateGroups = [".join($adultRateGroups,",")."];";

$unitGroup =  $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1", 4);
$GLOBALS['temp']['unitGroup'] = $unitGroup;


$orideUnitStayAmt = "";
if ($oridelevel == 2) {
	$rateGroupAmount = isset($dates['override']['amounts']['rate_group'][$unitGroup]) ? $dates['override']['amounts']['rate_group'][$unitGroup] : "";
	$orideUnitStayAmt = isset($dates)?$rateGroupAmount:"";
} elseif ($oridelevel == 3){
	$orideUnitStayAmt = isset($dates)?$dates['override']['amounts']['stay']:"";
}

$canOverrideUnit = checkRateGroupOverride($rate->Periods[0]['rt_rate_ix'], $unitGroup);
$GLOBALS['temp']['canOverrideUnit'] = (($canOverrideUnit) ? 1 : 0) ;

if (!$canOverrideUnit){
	$orideUnitStayHide = " style=\"display:none\"";
	$GLOBALS['temp']['unitOrideOption'] = "";
	$GLOBALS['temp']['personOrideOption'] = "<option value=\"1\" selected>Person</option>";
}

$overrideHTML = "

	<div class=\"unit-grouping uk-margin-remove-left uk-child-width-expand\" uk-grid>
		<div class=\"uk-padding-remove-left\">
			<div class=\"uk-flex\">
				<input id=\"unitStayOrideAmt\" class=\"orideInputAmt\" size=\"18\" tabindex=\"52\" value=\"".$orideUnitStayAmt."\" \>
				<input id=\"unitStayOrideCurr\" class=\"orideInputCurr uk-margin-small-left\" disabled tabindex=\"-1\" value=\"".$orideCurr."\" size=\"1\" readonly=\"readonly\"\>
			</div>
		</div>
	</div>
	$orideRateGroupInputs
";

// TODO: Delete this?
// $GLOBALS['temp']['oridelvlind'] = $rate->Periods[0]['rt_rate_overide_level_ind'];
// if ($orideUnitStayAmt != "" && $rate->Periods[0]['rt_rate_overide_level_ind'] != $oridelevel) {
	// $GLOBALS['temp']['oridewarning'] = "Per ".$oridelevelname." override of ".$orideUnitStayAmt." exists";
// } elseif (!empty($dates['override']['rate_group']) && $rate->Periods[0]['rt_rate_overide_level_ind'] != $oridelevel){
	// $GLOBALS['temp']['oridewarning'] = "Per person override exists and will be overwritten.";
// }

// Does user have rights to override  (we base this on JOB 0 which uses function 52 as well)
$GLOBALS['temp']['orideHide'] = " style=\"display:none\"";

if(db_sc_group_get_user_setting("sc_grp_res_ovr_amount_yn") == "1" && $rate->Periods[0]['rt_rate_overide_level_ind'] != 0) {
	$GLOBALS['temp']['orideHide'] = " style=\"\"";
}

$GLOBALS['temp']['overrideHTML'] = $overrideHTML;
$GLOBALS['temp']['rateGroupHTML'] = $rateGroupHTML;

global $principal_id;
global $domain;
$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";
if ($userStatusId == "0") {
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/cal_roomnum.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file(__DIR__ . "/../images/$principal_id/cal_roomnum.htm")));
	}

	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/cal_roomnum.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/cal_roomnum.css\" type=\"text/css\" />";
	} else {
		$indexCSS = "";
	}
	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />
		$indexCSS
	";

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Do not include imageset CSS if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customCSS'] = "";
	}
}

$GLOBALS['temp']['blockDetails'] = $blockDetails;
$GLOBALS['temp']['bl_block_ix'] = $bl_block_ix;
$GLOBALS['temp']['sc_grp_res_ovr_overbooking_yn'] = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn");
$rt_rate_type_id = "";
if ($itemId) {
	$rt_rate_type_id = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$itemId'",4);
}
$GLOBALS['temp']['rt_rate_type_id'] = $rt_rate_type_id;

$newRelic->stop_transaction();
