<?php

# # # # # # # # # # # # # # # # # # # # # # # # #
# Reservation Extras Report                     #
# Reference: rep_extras_1.0.doc                 #
# Created: 11/08/2003 [DPB]                     #
# # # # # # # # # # # # # # # # # # # # # # # # #

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_POST['url'] = str_replace(array("/reservation.php?", "reservation.php??"), "reservation.php?", $_POST['url']);
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if (!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rep_extras.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],16,"");

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
//
$filterDivClass = $_SERVER['argv'][12];
$showHideFilterButtonText = $_SERVER['argv'][13];

$GLOBALS['temp']['filterDivClass'] = urldecode($filterDivClass);
$GLOBALS['temp']['showHideFilterButtonText'] = urldecode($showHideFilterButtonText);

if($GLOBALS['temp']['showHideFilterButtonText'] == "") {
	$GLOBALS['temp']['showHideFilterButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterDivClass == "") {
		$GLOBALS['temp']['filterDivClass'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideFilterButtonText'] = ">> Show Filters";
	}
}
// Bug #5484 : END ------------------------------------------------------------


$pageLength = 35;
// Retreive parameters
$fromDate = useDate("from", $_SERVER['argv'][1]);
$toDate = useDate("to", $_SERVER['argv'][2]);
$propertyACL = $lDB->get("
   SELECT DISTINCT
      ac_accomm_type.pr_business_id
   FROM
      sc_accomm, ac_accomm_type, pr_business, pr_persona
   WHERE
      sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
      AND   sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
      AND   ac_accomm_type.ac_accomm_type_inactive_yn=0
      AND   ac_accomm_type.pr_business_id = pr_business.pr_business_id
      /*AND pr_business.pr_bus_inactive_yn= '0'*/
      AND   pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
", 3);
array_push($propertyACL,"0");

$statusACL = $lDB->get("
   SELECT
      rf_reservation_status_id
    FROM
      rf_reservation_status
    WHERE
      rf_reservation_status_id <> 25
",3);
$propertyFilter = useFilter("propertiesExtra", $_SERVER['argv'][3], "SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =", "rv_extra.pr_business_id", $propertyACL, "Not property specific","0");
//debug("Property filter:",$_SERVER['argv'][3],$propertyFilter);
$extraFilter = useFilter("extras", $_SERVER['argv'][4], "SELECT ac_ext_desc FROM ac_extra WHERE ac_extra.ac_extra_ix =", "ac_extra.ac_extra_ix", false, false, false);
if($extraFilter['ids'] != "") {
   $catList = $lDB->get("
      SELECT DISTINCT
         ac_extra.ac_extra_category_id,
         ac_extra_category.ac_extra_cat_desc
      FROM
         ac_extra
         INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
      WHERE
         ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
   ",2);
   $extraFilterRows = "";
   $extraFilterIds = "";
   foreach($catList as $item) {
      $extraList = $lDB->get("
         SELECT
            ac_extra.ac_extra_ix as ac_extra_ix,
            ac_ext_desc
         FROM
            ac_extra
         WHERE
            ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
            AND ac_extra.ac_extra_category_id = '$item[ac_extra_category_id]'
      ",2);
      $extraNames = "";
      $extraIds = "";
      foreach($extraList as $extraItem) {
         if($extraNames != "") {
            $extraNames .= ", ";
         }
         $extraNames .= $extraItem['ac_ext_desc'];
         if($extraIds != "") {
            $extraIds .= ":";
         }
         $extraIds .= $extraItem['ac_extra_ix'];
      }
      $extraFilterRows .= "
         <tr id=\"extra_$item[ac_extra_category_id]\">
            <td width=\"80\" ><textarea rows=1 style=\"width:80;\" id=\"extraCatText\" class=\"txtg\" readonly tabIndex=\"-1\">$item[ac_extra_cat_desc]</textarea></td>
            <td width=\"300\"><textarea rows=1 style=\"width:300;\" id=\"extraText\" class=\"txtg\" readonly tabIndex=\"-1\">$extraNames</textarea></td>
            <td><input type=button class=\"button bDelete\" style=\"width:20; background-position: center;\" value=\"\" onclick=\"removeExtraIds('$item[ac_extra_category_id]');\"></td>
         </tr>
      ";
      $extraFilterIds .= "
         <input type=\"hidden\" id=\"extraIds_$item[ac_extra_category_id]\" name=\"extraIds\" value=\"$extraIds\">
      ";
   }
   $GLOBALS['temp']['extraFilterRows'] = $extraFilterRows;
   $GLOBALS['temp']['extraFilterIds'] = $extraFilterIds;
   $GLOBALS['temp']['extraAllClass'] = "collapse printCollapse";
} else {
   $GLOBALS['temp']['extraFilterRows'] = "";
   $GLOBALS['temp']['extraFilterIds'] = "";
   $GLOBALS['temp']['extraAllClass'] = "";
}

$extraCategoryFilter = useFilter("extraCategory", $_SERVER['argv'][5], "SELECT ac_extra_cat_desc  FROM ac_extra_category WHERE ac_extra_category_ix =", "ac_extra_category_ix", false, false, false);

$page = $_SERVER['argv'][6];
$sortField = $_SERVER['argv'][7];
$options = $_SERVER['argv'][8];

$statusFilter = useFilter("status",$_SERVER['argv'][9],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);

$extraSupplierFilter = useFilter("extraSupplier",$_SERVER['argv'][14],"SELECT IFNULL(CONCAT(CONCAT(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_extra.pr_supplier_id",false,"Direct booking","0",true);

$extraFilterType = $_SERVER['argv'][10];
$randomId = $_SERVER['argv'][11];
$reference = $_SERVER['argv'][15];
$referenceSQL = "";
if(trim($reference) != "") {
	$referenceSQL = " AND rv_extra.rv_extra_ref LIKE ('".str_replace("*", "%", $reference)."') ";
}
$GLOBALS['temp']['reference'] = $reference;

define("REP_BUTTON_NOTES", 8);
define("REP_BUTTON_INTERNAL_NOTES", 16);
define("REP_COL_SERV_DATE", 32);
define("REP_COL_PROP", 64);
define("REP_COL_ROOM", 128);
define("REP_COL_GUEST", 256);
define("REP_COL_CAT", 512);
define("REP_COL_EXTRA", 1024);
define("REP_COL_ETA", 67108864);
define("REP_COL_ETD", 134217728);
define("REP_COL_SERVICE", 268435456);
define("REP_COL_REFERENCE", 536870912);
define("REP_COL_RES_NO", 2048);
define("REP_COL_RES_NAME", 4096);
define("REP_COL_AGENT", 8192);
define("REP_COL_QTY", 16384);
define("REP_COL_CHARGE", 32768);
define("REP_COL_TOTAL", 65536);
define("REP_COL_UNIT_PRICE", 131072);
define("REP_COL_DISC", 262144);
define("REP_COL_COM_REC", 524288);
define("REP_COL_COM_PAY", 1048576);    
define("REP_COL_INV_TO", 2097152);
define("REP_COL_POS", 4194304);
define("REP_COL_NOTE", 8388608);
define("REP_COL_INT_NOTE", 16777216);
define("REP_COL_CODE_TABLE", 33554432); 

switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
      break;
}
//debug("Options: $options");

if($extraFilterType == 1) {
   $GLOBALS['temp']['extraFilterTypeCategory'] = "checked";
   $GLOBALS['temp']['extraFilterTypeExtra'] = "";
} else {
   $GLOBALS['temp']['extraFilterTypeCategory'] = "";
   $GLOBALS['temp']['extraFilterTypeExtra'] = "checked";
}

if ($renderMode == "pdf" && $renderType == "email") {
   $pdfName = "Extras report" . " from " . $fromDate['htmlDate'] . " to " . $toDate['htmlDate'];
   $attachmentTable = "
      <table border='0' cellspacing='0' cellpadding='0' width=\"100%\">
      <tr valign='top'>
         <td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
         <td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
      </tr>
      </table>";
   $newOptions = ($options & ~3) + 3;
   $formAction = "reservation.php?".join("+", array_slice($_SERVER['argv'], 0, 8))."+$newOptions+".$_SERVER['argv'][9]."+".$_SERVER['argv'][10];
   $GLOBALS[$form]->FormHTML = str_replace("!formAction!", $formAction,
      str_replace("!attachmentInfo!", $attachmentTable,
      str_replace("!attachmentName!", $pdfName.".pdf",
      str_replace("!hasAttachment!", "expand",
      str_replace("!emailBody!", "",
      str_replace("!emailSubject!", $pdfName,
      Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
   $principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);
   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   $GLOBALS['temp']['emailFrom'] = $lDB->get("
      SELECT
         pr_persona.pr_email
      FROM
         pr_persona
      WHERE
         pr_persona.pr_persona_ix = '".$userId."'
   ", 4);
   $GLOBALS['temp']['emailTo'] = "";
}
if (trim($page) == "") {
   $page = "1";
}
$GLOBALS['temp']['page']  = $page;
if (trim($sortField) == "") {
   $sortField = "serviceDate,0";
}
$GLOBALS['temp']['sort'] = $sortField;
// Decide whether to create a report
if ($_SERVER['argc'] <= 1) {
   $makeReport = false;
} else {
   $makeReport = true;
   if ($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
   }
}
$sqlCount = "
   SELECT
      COUNT(DISTINCT rv_extra.rv_extra_ix)
";
$sqlSelect = "
	SELECT DISTINCT
      rv_extra.rv_extra_ix as id,
      rv_extra.rv_extra_date_serv,
      pr_persona.pr_persona_ix,
      pr_persona.pr_name_last,
      pr_business.pr_bus_name_short,
      ac_extra.ac_extra_ix as ac_extra_ix,
      ac_extra.ac_ext_desc,
      ac_extra.ac_ext_amount as codeAmnt,
      ac_extra.rf_currency_id as codeCurrId,
      code_currency.rf_currency_symbol as codeCurrSym,
      ac_extra.rf_tax_id as codeTaxId,
      rf_tax_rate.rf_tax_rate_perc as codeTax,
      ac_extra.ac_ext_comm_rec as codeCommRec,
      ac_extra.ac_ext_comm_pay as codeCommPay,      
      ac_extra_category.ac_extra_cat_desc,
      rv_extra.rv_extra_units,
      rv_extra.rv_extra_travel_eta,
      rv_extra.rv_extra_travel_etd,
      rv_extra.rv_extra_supplier_conf_yn,
      rv_extra.pr_supplier_id,
      rv_extra.rv_extra_ref,
      CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name,
      rv_extra.rv_extra_charge,
      rv_extra.rv_extra_tax_perc,
      rv_extra.rf_currency_id as extra_currency_id,
      from_currency.rf_currency_symbol as extra_currency_symbol,
      rv_extra.rv_extra_inv_curr_id as folio_currency_id,
      to_currency.rf_currency_symbol as folio_currency_symbol,
      rv_extra.rv_extra_exch_rate,
      rv_extra.rv_extra_exch_expiry,
      rv_extra.rv_extra_discount,
      rv_extra.rv_extra_comm_rec,
      rv_extra.rv_extra_comm_pay,
      rv_extra_note,
      rv_extra_note_internal,
      invoice_persona.pr_name_last as invoice_name_last,
      invoice_persona.pr_name_first as invoice_name_first,
      ac_accomm_room.ac_desc,
      rv_extra.fn_folio_id,
      fn_folio.fn_folio_folio_num,
      rv_res_item_group.rv_res_item_group_ix,
      rv_reservation.rv_reservation_ix,
      rv_reservation.rv_res_name,
      rv_reservation.rv_agent_id,
	  ac_pos.ac_pos_name_rr,
	  ac_pos.ac_pos_name
";
if($extraFilterType == 1) {
   $extraFilterSQL = $extraCategoryFilter['where'];
} else {
   $extraFilterSQL = $extraFilter['where'];
}
$sqlFrom = "
   FROM
      rv_extra
      INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
      INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
      LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
      LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id 
      LEFT JOIN rf_currency AS from_currency ON from_currency.rf_currency_ix = rv_extra.rf_currency_id
      LEFT JOIN rf_currency AS to_currency ON to_currency.rf_currency_ix = rv_extra.rv_extra_inv_curr_id
      LEFT JOIN rf_currency AS code_currency ON code_currency.rf_currency_ix = ac_extra.rf_currency_id
      LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
      LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
      LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
      LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
      LEFT JOIN pr_persona AS invoice_persona ON invoice_persona.pr_persona_ix = fn_folio.fn_folio_to_id
      LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
      LEFT JOIN ac_pos ON ac_pos.ac_pos_ix = rv_extra.ac_pos_id
      LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id
   WHERE
		rv_extra.rv_extra_void_ind = 0
	  AND (
      (
         rv_extra.rv_extra_date_serv = '0000-00-00'
         AND (
               (
                  rv_reservation.rv_date_arrive >= '$fromDate[jsDate]' AND
                  rv_reservation.rv_date_arrive <= '$toDate[jsDate]'
               ) OR (
                  rv_reservation.rv_date_depart >= '$fromDate[jsDate]' AND
                  rv_reservation.rv_date_depart <= '$toDate[jsDate]'
               ) OR (
                  rv_reservation.rv_date_arrive < '$fromDate[jsDate]' AND
                  rv_reservation.rv_date_depart > '$toDate[jsDate]'
               )
         )
      ) OR (
		rv_extra_ind <> ".DB_RV_EXTRA_ACCOMMODATION."
         AND rv_extra.rv_extra_date_serv >= '$fromDate[jsDate]' AND
         rv_extra.rv_extra_date_serv <= '$toDate[jsDate]'
      ) OR (
		rv_extra_ind = ".DB_RV_EXTRA_ACCOMMODATION."
		AND (
			(
				rv_extra.rv_extra_date_serv >= '$fromDate[jsDate]'
				AND rv_extra.rv_extra_date_serv <= '$toDate[jsDate]'
			) OR (
				rv_extra.rv_extra_date_depart >= '$fromDate[jsDate]'
				AND rv_extra.rv_extra_date_depart <= '$toDate[jsDate]'
			) OR (
				rv_extra.rv_extra_date_serv < '$fromDate[jsDate]'
				AND rv_extra.rv_extra_date_depart > '$toDate[jsDate]'
			)
		)
	)
  	  )
      ".$extraFilterSQL.$propertyFilter['where'].$statusFilter['where'].$extraSupplierFilter['where'].$referenceSQL;

$GLOBALS['temp']['serviceDateUp'] = "std";
$GLOBALS['temp']['serviceDateDown'] = "std";
$GLOBALS['temp']['propertyNameUp'] = "std";
$GLOBALS['temp']['propertyNameDown'] = "std";
$GLOBALS['temp']['roomUp'] = "std";
$GLOBALS['temp']['roomDown'] = "std";
$GLOBALS['temp']['categoryUp'] = "std";
$GLOBALS['temp']['categoryDown'] = "std";
$GLOBALS['temp']['extraUp'] = "std";
$GLOBALS['temp']['extraDown'] = "std";
$GLOBALS['temp']['etaUp'] = "std";
$GLOBALS['temp']['etaDown'] = "std";
$GLOBALS['temp']['etdUp'] = "std";
$GLOBALS['temp']['etdDown'] = "std";
$GLOBALS['temp']['serviceUp'] = "std";
$GLOBALS['temp']['serviceDown'] = "std";
$GLOBALS['temp']['referenceUp'] = "std";
$GLOBALS['temp']['referenceDown'] = "std";
$GLOBALS['temp']['resUp'] = "std";
$GLOBALS['temp']['resDown'] = "std";

if ($makeReport) {
   // count for pages
	$pageList = isset($pageList) ? $pageList : "";
   if ($renderMode == "html") {
      $totalRows = $lDB->get($sqlCount.$sqlFrom, 4);
      if ($totalRows == 0) {
         $GLOBALS['temp']['rows'] = "<tr><td colspan=8 height=5></td></tr><tr><td colspan=8><table class=\"blkBord\" width=\"770\" height=\"50\"><tr><td class=\"txt\" align=\"center\">&nbsp;&nbsp;No data matched your filter criteria.<br> Please change your filters and press one of the report buttons above.</td></tr></table></td></tr>";
         $GLOBALS['temp']['showHeader'] = "collapse printCollapse";
         $GLOBALS['temp']['showButHeader'] = "collapse printCollapse";
      } else {
         $GLOBALS['temp']['showHeader'] = "expand";
         $GLOBALS['temp']['showButHeader'] = "outLtt printCollapse";
         $GLOBALS['temp']['pageCount'] = ceil($totalRows/$pageLength);
         $GLOBALS['temp']['pageNum'] = $page;
         $GLOBALS['temp']['nextPageNum'] = $page+1;
         $GLOBALS['temp']['prevPageNum'] = $page-1;
         if ($page == 1) {
            $GLOBALS['temp']['hidePrevButton'] = "class=\"collapse printCollapse\"";
         } else {
            $GLOBALS['temp']['hidePrevButton'] = "class=\"button printCollapse\"";
         }
         if ($page >= $GLOBALS['temp']['pageCount']) {
            $GLOBALS['temp']['hideNextButton'] = "class=\"collapse printCollapse\"";
         } else {
            $GLOBALS['temp']['hideNextButton'] = "class=\"button printCollapse\"";
         }
         $totalPages = ceil($totalRows/$pageLength);
         if (($totalPages - $page) < 2 ) {
            $startPage = $totalPages - 2;
         } elseif($page < 4) {
            $startPage = 4;
         } else {
            $startPage = $page;
         }
         if ($page != 1) {
            $pageList .= "<A class=\"txtbr\" href=\"#\" onclick=\"setPage(1);\">1</A>";
         } else {
            $pageList = "<B>1</B>";
         }
         for($count = 2; $count <= ($totalPages > 8?8:$totalPages); $count++) {
            if ($count == $page) {
               $pageList .= ", <B>$count</B>";
            } else {
               $pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($count);\">$count</A>";
            }
         }
         if (($totalPages - $page) > 3 ) {
            $pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($totalPages);\">Last</SPAN>";
         }
         $GLOBALS['temp']['pageList'] = $pageList;

         $limit = " LIMIT ". (($page-1) * $pageLength ) .",".$pageLength;
         $GLOBALS['temp']['recFound'] = $totalRows;//sizeof($rowArray);
         $GLOBALS['temp']['rows'] = "";
         //$extraRowHtml = Join("", file(__DIR__ . "/../../../public/html/rep_extra_row.htm"));
         //$extraRowHtml = Join("", file(__DIR__ . "/../../../public/html/reservation_extras_rows.htm"));
         $extraRowHtml = Join("", file(__DIR__ . "/../../../public/html/rep_extra_row.htm"));
         $extraRowNoteHtml = Join("", file(__DIR__ . "/../../../public/html/rep_extra_row_note.htm"));
      }
   } else {
      $limit = "";
      if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
         $pdf = new PDF("Extras","l");
         // Main PDF header
         $reportLabel = "Extras";
         $headerArray = array(
            array('name' => "Date Range", 'value' => $fromDate['htmlDate']." to ".$toDate['htmlDate']),
            array('name' => "Status Filter", 'value' => $statusFilter['names']),
            array('name' => "Property Filter", 'value' => $propertyFilter['names']),
         );
         if($extraFilterType == 1) {
            array_push($headerArray,array('name' => "Extra Category Filter", 'value' => $extraCategoryFilter['names']));
         } else {
            array_push($headerArray,array('name' => "Extra Filter", 'value' => $extraFilter['names']));
         }

         $pdf->ReportHeader($reportLabel, $headerArray);
         $pdfFontSize = 8;
         $pdf->SetFont('Arial', '', $pdfFontSize);

      }
   }
   $orderBy = " ORDER BY ";
   $sortArray = explode(",", $sortField);
   switch ($sortArray[0]) {
      case "propertyName":
         $orderBy .= "pr_persona.pr_name_last";
         if ($sortArray[1] != 0) {
            $GLOBALS['temp']['propertyNameDown'] = "down";
         } else {
            $GLOBALS['temp']['propertyNameUp'] = "down";
         }
         break;
      case "room":
         $orderBy .= "ac_accomm_room.ac_desc";
         if($sortArray[1] != 0) {
            $GLOBALS['temp']['roomDown'] = "down";
         } else {
            $GLOBALS['temp']['roomUp'] = "down";
         }
         break;
      case "category":
         $orderBy .= "ac_extra_category.ac_extra_cat_desc";
         if($sortArray[1] != 0) {
            $GLOBALS['temp']['categoryDown'] = "down";
         } else {
            $GLOBALS['temp']['categoryUp'] = "down";
         }
         break;
      case "extra":
         $orderBy .= "ac_extra.ac_ext_desc";
         if ($sortArray[1] != 0) {
            $GLOBALS['temp']['extraDown'] = "down";
         } else {
            $GLOBALS['temp']['extraUp'] = "down";
         }
         break;
      case "eta":
         $orderBy .= "rv_extra.rv_extra_travel_eta";
         if ($sortArray[1] != 0) {
            $GLOBALS['temp']['etaDown'] = "down";
         } else {
            $GLOBALS['temp']['etaUp'] = "down";
         }
         break;
      case "etd":
         $orderBy .= "rv_extra.rv_extra_travel_etd";
         if ($sortArray[1] != 0) {
            $GLOBALS['temp']['etdDown'] = "down";
         } else {
            $GLOBALS['temp']['etdUp'] = "down";
         }
         break;
      case "service":
         $orderBy .= "pr_extra_supplier.pr_name_first";
         if ($sortArray[1] != 0) {
            $GLOBALS['temp']['serviceDown'] = "down";
         } else {
            $GLOBALS['temp']['serviceUp'] = "down";
         }
         break;
      case "reference":
         $orderBy .= "rv_extra.rv_extra_ref";
         if ($sortArray[1] != 0) {
            $GLOBALS['temp']['referenceDown'] = "down";
         } else {
            $GLOBALS['temp']['referenceUp'] = "down";
         }
         break; 
      case "res":
         $orderBy .= "rv_reservation.rv_reservation_db,rv_reservation.rv_reservation_id";
         if ($sortArray[1] != 0) {
            $GLOBALS['temp']['resDown'] = "down";
         } else {
            $GLOBALS['temp']['resUp'] = "down";
         }
         break;
      case "serviceDate":
      default:
         $orderBy .= "rv_extra.rv_extra_date_serv";
         if ($sortArray[1] != 0) {
            $GLOBALS['temp']['serviceDateDown'] = "down";
         } else {
            $GLOBALS['temp']['serviceDateUp'] = "down";
         }
   }
   if ($sortArray[1] != "0") {
      $orderBy .= " DESC";
   }

    $sql = $sqlSelect.$sqlFrom.(isset($orderBy) ? $orderBy : "").(isset($limit) ? $limit : "");
   $rowArray = $lDB->get($sql, 2);
   foreach($rowArray as $key => $item) {
      $rowArray[$key]['guestNames'] = join(", ",$lDB->get("
         SELECT
            trim(concat(pr_persona.pr_name_first,concat(' ',pr_persona.pr_name_last)))
         FROM
            rv_res_item_guest
            INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id AND rv_res_item_guest.rv_res_item_group_id != ''
         WHERE
            rv_res_item_guest.rv_res_item_group_id = '$item[rv_res_item_group_ix]'
      ",3));
      $rowArray[$key]['from_total'] = $item['rv_extra_units'] * $item['rv_extra_charge'];
      $rowArray[$key]['to_total'] = $rowArray[$key]['from_total'] * $item['rv_extra_exch_rate'];
      $invoiceName = "";
      if($item['invoice_name_first'] != "") {
         $invoiceName .= $item['invoice_name_first'];
      }
      if($item['invoice_name_last'] != "") {
         if($invoiceName != "") {
            $invoiceName .= " ";
         }
         $invoiceName .= $item['invoice_name_last'];
      }
	  if($invoiceName == "") {
		  $invoiceName = "Cash";
	  }
      $rowArray[$key]['invoiceName'] = $invoiceName;
   }
   if ($renderMode == "html") {
      $rowHTML = join("\n",file(__DIR__ . "/../../../public/html/rep_extra_row.htm"));
      $rows = "";
      $noteCount = 0;
      $memoCount = 0;
      $notes = false;
      foreach($rowArray as $item) {
        $item['resExtraJob'] = "609";
        $item['resExtraId'] = $item['rv_reservation_ix'];
        if (checkJob(610)){
          $item['resExtraJob'] = "610";
        }

         if(trim($item['guestNames']) == "") {
            $item['guestNames'] = "&nbsp;";
         }
         if($item['rv_extra_date_serv'] == "0000-00-00") {
            $item['rv_extra_date_serv_fmt'] = "&nbsp;";
         } else {
            $item['rv_extra_date_serv_fmt'] = chng_date($item['rv_extra_date_serv'],"-");
         }
         if(trim($item['pr_name_last']) == "") {
            $item['pr_name_last'] = "&nbsp;";
         }
         if(trim($item['pr_bus_name_short']) == ""){
         	  $item['pr_bus_name_short'] = "&nbsp;";
         }
         $agentName = $lDB->get("SELECT
         			 	 pr_name_first,
               	 pr_name_last
               FROM pr_persona
               INNER JOIN rv_extra ON
               	 rv_extra.rv_reservation_id = '$item[rv_reservation_ix]'
               WHERE
               	 pr_persona.pr_persona_ix = '$item[rv_agent_id]'	
         ",1);
         
         if($agentName[0] != ""){
           $agentName[0] .= " ";
         }
         $item['agent_name'] = $agentName[0].$agentName[1];
         if(trim($item['ac_desc']) == "") {
            $item['ac_desc'] = "&nbsp;";
         }
         fixAmtDisplay($item['rv_extra_charge'],2);
         fixAmtDisplay($item['from_total'],2);
         fixAmtDisplay($item['to_total'],2);
         $item['from_total'] .= " $item[extra_currency_symbol]";
         $item['to_total'] .= " $item[folio_currency_symbol]";
         $item['rv_extra_charge'] .= " ". $item['extra_currency_symbol'];
         fixAmtDisplay($item['rv_extra_discount'],2);
         fixAmtDisplay($item['rv_extra_comm_rec'],2);
         fixAmtDisplay($item['rv_extra_comm_pay'],2);
         fixAmtDisplay($item['rv_extra_tax_perc'],2);
         if($notes) {
            $item['borderClass'] = "bt";
         } else {
            $item['borderClass'] = "";
         }

         $notes = false;
         $noteRows = "";
         if(trim($item['rv_extra_note']) == "") {
         	$item['rv_extra_note_fmt'] = "";
         	$item['rv_extra_note'] = "";
            $item['showNote'] = "style=\"display:none\"";
            $item['replaceNote'] = "&nbsp;";
         } else {
            $item['rv_extra_note_fmt'] = t_encodeOverlib($item['rv_extra_note']);
            $item['rv_extra_note'] = $item['rv_extra_note'];
            $item['showNote'] = "";
            $item['replaceNote'] = "";
            if($options & REP_BUTTON_NOTES) {
               $notes = true;
               $noteClass = "expand";
			   $GLOBALS['temp']['noteCheck'] = "checked";
            } else {
               $noteClass = "collapse printCollapse";
			   $GLOBALS['temp']['noteCheck'] = "";
            }
            $noteRows = str_replace("!noteTitle!","NOTES",
               str_replace("!noteDetail!",$item['rv_extra_note'],
               str_replace("!borderClass!","bt",
               str_replace("!noteId!","note_$noteCount",
               str_replace("!noteClass!",$noteClass,$extraRowNoteHtml)))));
            $noteCount++;
         }
         if(trim($item['rv_extra_note_internal']) == "" || $_SESSION['userStatusId'] < 2) {
            $item['rv_extra_note_internal_fmt'] = "";
            $item['rv_extra_note_internal'] = "";
            $item['showMemo'] = "style=\"display:none\"";
            $item['replaceMemo'] = "&nbsp;";
         } else {
            $item['rv_extra_note_internal_fmt'] = t_encodeOverlib($item['rv_extra_note_internal']);
            $item['rv_extra_note_internal'] = $item['rv_extra_note_internal'];
            $item['showMemo'] = "";
            $item['replaceMemo'] = "";
            if($options & REP_BUTTON_INTERNAL_NOTES) {
               $notes = true;
               $noteClass = "expand";
			   $GLOBALS['temp']['memoCheck'] = "checked";
            } else {
               $noteClass = "collapse printCollapse";
			   $GLOBALS['temp']['noteCheck'] = "";
            }
            if($notes) {
               $borderClass = "";
            } else {
               $borderClass = "bt";
            }
            $noteRows .= str_replace("!noteTitle!","INT. NOTES",
               str_replace("!noteDetail!",$item['rv_extra_note_internal'],
               str_replace("!borderClass!",$borderClass,
               str_replace("!noteId!","memo_$memoCount",
               str_replace("!noteClass!",$noteClass,$extraRowNoteHtml)))));
            $memoCount++;
         }
         if(trim($item['invoiceName']) == "") {
            $item['invoiceName'] = "&nbsp;";
         }
		 if(trim($item['extra_currency_symbol']) == "") {
			$item['rv_extra_charge'] = "&nbsp;";
			$item['from_total'] = "&nbsp;";
			$item['to_total'] = "&nbsp;";
			//$item['rv_extra_discount'] = "&nbsp;";
			//$item['rv_extra_comm_rec'] = "&nbsp;";
			//$item['rv_extra_comm_pay'] = "&nbsp;";
			//$item['rv_extra_tax_perc'] = "&nbsp;";
			$item['rv_extra_exch_rate'] = "&nbsp;";
			$item['invoiceName'] = "&nbsp;";	 
		 }
		 if(trim($item['ac_pos_name_rr']) == "") {
			 $item['ac_pos_name_rr'] = "&nbsp;";
		 }
		 
		 if(empty($item['supplier_name'])) {
		     $item['supplier_name'] = "&nbsp;";
		 }
		 
		 if(empty($item['rv_extra_ref'])) {
		     $item['rv_extra_ref'] = "&nbsp;";
		 }

		 if(trim($item['rv_extra_travel_eta']) == "") {
		     $item['rv_extra_travel_eta'] = "&nbsp;";
		 } 

		 if(trim($item['rv_extra_travel_etd']) == "") {
		      $item['rv_extra_travel_etd'] = "&nbsp;";
		 } 
         $rows .= showpage($item,$rowHTML) . $noteRows;
      }
      if(sizeof($rowArray) > 0) {
         $GLOBALS['temp']['rows'] = $rows;
      } else {
         $GLOBALS['temp']['rows'] = "
            <tr><td align=\"right\" class=\"txti\" colspan=5>No results found&nbsp;&nbsp;&nbsp;</td></tr>
         ";
      }
      $GLOBALS['temp']['totalNote'] = $noteCount;
      $GLOBALS['temp']['totalMemo'] = $memoCount;
   }
   if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
      // Insert pdf line code here
      extraListPDF($pdf, $rowArray, $options);
   }

   if ($renderMode == "csv" ) {
      $csvFile = array();
      array_push($csvFile,array("Report: Extras"));
      array_push($csvFile,array("Date range: " . $fromDate['htmlDate'] . " to " . $toDate['htmlDate']));
      array_push($csvFile,array("Status: " .$statusFilter['names']));
      array_push($csvFile,array("Property: " . $propertyFilter['names']));
      if($extraFilterType == 1) {
         array_push($csvFile,array("Extra Category: ".$extraCategoryFilter['names']));
      } else {
         array_push($csvFile,array("Extra: ".$extraFilter['names']));
      }
      array_push($csvFile,array("Service By: " . $extraSupplierFilter['names']));
      if($reference) {
          array_push($csvFile,array("Reference: " . $reference));
      }

      array_push($csvFile,array());          
      $headers = array(); 
      if($options & REP_COL_SERV_DATE){array_push($headers,"Service date");}
      if($options & REP_COL_PROP){array_push($headers,"Property");}
      if($options & REP_COL_ROOM){array_push($headers,"Room / Unit");}
      if($options & REP_COL_GUEST){array_push($headers,"Guest(s)");}
      if($options & REP_COL_CAT){array_push($headers,"Category");}
      if($options & REP_COL_EXTRA){array_push($headers,"Extra");}
      if($options & REP_COL_ETD){array_push($headers,"ETD");}
      if($options & REP_COL_ETA){array_push($headers,"ETA");}
      if($options & REP_COL_SERVICE){array_push($headers,"Service By");}
      if($options & REP_COL_REFERENCE){array_push($headers,"Reference");}
      if($options & REP_COL_RES_NO){array_push($headers,"Reservation number");}
      if($options & REP_COL_RES_NAME){array_push($headers,"Reservation name");}
      /*Remember to get Agent info*/
      if($options & REP_COL_AGENT){array_push($headers,"Agent");}
      if($options & REP_COL_QTY){array_push($headers,"Quantity");}
      if($options & REP_COL_CHARGE){array_push($headers,"Charge Amount");}
      if($options & REP_COL_TOTAL){array_push($headers,"Total","Currency of Folio");}
      if($options & REP_COL_UNIT_PRICE){array_push($headers,"Exchange rate (per unit)","Price (per unit)","Currency of Extra","Tax rate (per unit)");}      
			if($options & REP_COL_DISC){array_push($headers,"Discount");}
      if($options & REP_COL_COM_REC){array_push($headers,"Commission received");}
      if($options & REP_COL_COM_PAY){array_push($headers,"Commission payed");}   
			if($options & REP_COL_CODE_TABLE){array_push($headers,"Code amount","Code curr","Code tax","Code comm rec","Code comm pay");}
      if($options & REP_COL_INV_TO){array_push($headers,"Invoice to");}
      if($options & REP_COL_POS){array_push($headers,"POS");}
	  if($options & REP_COL_NOTE){array_push($headers,"Note");}
	  if($options & REP_COL_INT_NOTE){array_push($headers,"Internal Memo");}
      
      array_push($csvFile,$headers);
      
      foreach($rowArray as $key => $item) {
 		 if(trim($item['extra_currency_symbol']) == "") {
			$item['rv_extra_charge'] = "";
			$item['from_total'] = "";
			$item['to_total'] = "";
			//$item['rv_extra_discount'] = "&nbsp;";
			//$item['rv_extra_comm_rec'] = "&nbsp;";
			//$item['rv_extra_comm_pay'] = "&nbsp;";
			//$item['rv_extra_tax_perc'] = "&nbsp;";
			$item['rv_extra_exch_rate'] = "";
			$item['invoiceName'] = "";	 
		 }
     
		 $agentName = $lDB->get("SELECT pr_name_first, pr_name_last FROM pr_persona INNER JOIN rv_extra ON rv_extra.rv_reservation_id = '$item[rv_reservation_ix]' WHERE pr_persona.pr_persona_ix = '$item[rv_agent_id]'",1);         
		 if($agentName[0] != ""){
		   $agentName[0] .= " ";
		 }
         $item['agent_name'] = $agentName[0].$agentName[1];     
     
		 if(trim($item['ac_pos_name_rr']) != "") {
			 $item['ac_pos_name_rr'] = $item['ac_pos_name_rr'] . " (" . $item['ac_pos_name'] . ")";
		 } else {
			 $item['ac_pos_name_rr'] = "";
		 }

		  if(empty($item['supplier_name'])) {
			  $item['supplier_name'] = " ";
		  }

		  if(empty($item['rv_extra_ref'])) {
			  $item['rv_extra_ref'] = " ";
		  }


			 $csvLine = array();
    		 $csvRows = array();
         if($options & REP_COL_SERV_DATE){array_push($csvRows,chng_date($item['rv_extra_date_serv'], "-"));}
         if($options & REP_COL_PROP){array_push($csvRows,$item['pr_name_last']);}
         if($options & REP_COL_ROOM){array_push($csvRows,$item['ac_desc']);}
         if($options & REP_COL_GUEST){array_push($csvRows,$item['guestNames']);}
         if($options & REP_COL_CAT){array_push($csvRows,$item['ac_extra_cat_desc']);}
         if($options & REP_COL_EXTRA){array_push($csvRows,$item['ac_ext_desc']);}
         if($options & REP_COL_ETD){array_push($csvRows,$item['rv_extra_travel_etd']);}
         if($options & REP_COL_ETA){array_push($csvRows,$item['rv_extra_travel_eta']);}
         if($options & REP_COL_SERVICE){array_push($csvRows,$item['supplier_name']);}
         if($options & REP_COL_REFERENCE){array_push($csvRows,$item['rv_extra_ref']);}
         if($options & REP_COL_RES_NO){array_push($csvRows,$item['rv_reservation_ix']);}
         if($options & REP_COL_RES_NAME){array_push($csvRows,$item['rv_res_name']);}
         /*Remember to get Agent info*/
         if($options & REP_COL_AGENT){array_push($csvRows,$item['agent_name']);}
         if($options & REP_COL_QTY){array_push($csvRows,$item['rv_extra_units']);}
         if($options & REP_COL_CHARGE){array_push($csvRows,$item['to_total']);}
         if($options & REP_COL_TOTAL){array_push($csvRows,$item['from_total'],$item['folio_currency_symbol']);}
         if($options & REP_COL_UNIT_PRICE){array_push($csvRows,$item['rv_extra_exch_rate'],$item['rv_extra_charge'],$item['extra_currency_symbol'],$item['rv_extra_tax_perc']);}      
    		 if($options & REP_COL_DISC){array_push($csvRows,$item['rv_extra_discount']);}
         if($options & REP_COL_COM_REC){array_push($csvRows,$item['rv_extra_comm_rec']);}
         if($options & REP_COL_COM_PAY){array_push($csvRows,$item['rv_extra_comm_pay']);}   
    		 if($options & REP_COL_CODE_TABLE){array_push($csvRows,$item['codeAmnt'],$item['codeCurrSym'],$item['codeTax']." %",$item['codeCommRec']." %",$item['codeCommPay']." %");}
         if($options & REP_COL_INV_TO){array_push($csvRows,$item['invoiceName']);}
         if($options & REP_COL_POS){array_push($csvRows,$item['ac_pos_name_rr']);}
		 if($options & REP_COL_NOTE){array_push($csvRows,str_replace("\r","",$item['rv_extra_note']));}
		 if($options & REP_COL_INT_NOTE){array_push($csvRows,str_replace("\r","",$item['rv_extra_note_internal']));}
     
         array_push($csvFile,$csvRows);
      }
      $csvText = "";
      foreach($csvFile as $csvLine) {
         $first = true;
         foreach($csvLine as $csvItem) {
            if(!$first) {
               $csvText .= ",";
            } else {
               $first = false;
            }
            $csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
         }
         $csvText .= "\n";
      }
      header('Content-Type: text/csv');
      header("Cache-control: private");
      header('Content-Length: '.strlen($csvText));
      header("Content-Disposition: inline; filename=extras_".str_replace(" ","_",chng_date(date("Y-m-d"),"-")).".csv");
      echo $csvText;
      flush();
      die();
   }
} else {
   $GLOBALS['temp']['makeReport'] = "collapse printCollapse";
}
if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send") ) {
   if ($renderType == "view") {
      if (isset($GLOBALS['showTime'])) {
         $GLOBALS['timeEnd'] = getmicrotime();
         $timeTaken = $GLOBALS['timeEnd'] - $GLOBALS['timeStart'];
         $pdf->Ln(10);
         $resSize = sizeof($resArray);
         if ($resSize == 0) {
            $resSize = 1;
         }
         $pdf->Row(array(
         array(data => "Time taken: ".$timeTaken." seconds, ".($timeTaken/$resSize. " per record, total records ".sizeof($resArray)))
         ));
      }
      $pdf->OutPut();
      die();
   }
   if ($renderType == "send") {
      $to = $_POST['mail_to'];
      $from = $_POST['mail_from'];
      $subject = $_POST['mail_subj'];
      $message = $_POST['mail_body'];
      $attachmentName = $_POST['attachmentName'];
      $headers = "From: ".$GLOBALS['princName']."<$from>\r\n";
      // close the pdf
      if ($pdf->state < 3)
         $pdf->Close();
      /* and now mail it */
      if ($attachmentName != "!attachmentName!") {
         $pdfName = $attachmentName;
      } else {
         $pdfName = "Extras report from $fromDate to $toDate.pdf";
      }
      $error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'], $pdf->buffer, $pdfName);
      // (from, to, subject, headers, message, action, emailID, resID)
      if (!$error) {
         echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
         die();
      } else {
         echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
         die();
      }
   }
}

function extraListPDF(&$pdf, &$rowArray, $options) {
	global $lDB;
  $notes = false;
   $pdf->SetFont('Arial', '', 6);
   $pdf->Ln(2);
   $headRow = array();
	 $headRow2 = array();
   if($options & REP_COL_SERV_DATE){
   	 array_push($headRow,array('width'=>"6%", 'data'=>"Service", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"6%", 'data'=>"Date", 'border'=>"LB", 'fill'=>1));
   }
   if($options & REP_COL_PROP){
   	 array_push($headRow,array('width'=>"4%", 'data'=>"Property", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"4%", 'data'=>"", 'border'=>"LB", 'fill'=>1));
   }
   if($options & REP_COL_ROOM){
   	 array_push($headRow,array('width'=>"4%", 'data'=>"Rm / Unit", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"4%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_GUEST){
   	 array_push($headRow,array('width'=>"5%", 'data'=>"Guest(s)", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"5%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_CAT){
   	 array_push($headRow,array('width'=>"5%", 'data'=>"Category", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"5%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_EXTRA){
   	 array_push($headRow,array('width'=>"6%", 'data'=>"Extra", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"6%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }


   if($options & REP_COL_ETD){
   	 array_push($headRow,array('width'=>"3%", 'data'=>"ETD", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"3%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }

   if($options & REP_COL_ETA){
   	 array_push($headRow,array('width'=>"3%", 'data'=>"ETA", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"3%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }

   if($options & REP_COL_SERVICE){
   	 array_push($headRow,array('width'=>"6%", 'data'=>"Service By", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"6%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }

   if($options & REP_COL_REFERENCE){
   	 array_push($headRow,array('width'=>"6%", 'data'=>"Reference", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"6%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }

   if($options & REP_COL_RES_NO){
   	 array_push($headRow,array('width'=>"4%", 'data'=>"Res No", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"4%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_RES_NAME){
   	 array_push($headRow,array('width'=>"5%", 'data'=>"Res Name", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"5%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_AGENT){
   	 array_push($headRow,array('width'=>"6%", 'data'=>"Agent", 'border'=>"LT", 'fill'=>1));
     array_push($headRow2,array('width'=>"6%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_QTY){
   	 array_push($headRow,array('width'=>"2%", 'data'=>"Qty", 'border'=>"LT", 'fill'=>1, 'align'=>"C"));
     array_push($headRow2,array('width'=>"2%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_CHARGE){
   	 array_push($headRow,array('width'=>"5%", 'data'=>"Charge", 'border'=>"LT", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"5%", 'data'=>"Amount", 'border'=>"LB", 'fill'=>1, 'align'=>"R"));   
   }
   if($options & REP_COL_TOTAL){
   	 array_push($headRow,array('width'=>"5%", 'data'=>"Total", 'border'=>"LT", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"5%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_UNIT_PRICE){
   	 array_push($headRow,array('width'=>"9%", 'data'=>"Unit Price", 'border'=>"LBT", 'align'=>"C",'fill'=>1));
     array_push($headRow2,array('width'=>"3%", 'data'=>"Exch", 'border'=>"TLB", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"4%", 'data'=>"Amt", 'border'=>"TLB", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"2%", 'data'=>"Tax", 'border'=>"TLB", 'fill'=>1, 'align'=>"R"));   
   }
   if($options & REP_COL_DISC){
   	 array_push($headRow,array('width'=>"3%", 'data'=>"Disc", 'border'=>"LT", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"3%", 'data'=>"", 'border'=>"LB", 'fill'=>1));   
   }
   if($options & REP_COL_COM_REC){
   	 array_push($headRow,array('width'=>"3%", 'data'=>"Comm", 'border'=>"LT", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"3%", 'data'=>"Rec", 'border'=>"LB", 'fill'=>1, 'align'=>"R"));   
   }
   if($options & REP_COL_COM_PAY){
   	 array_push($headRow,array('width'=>"3%", 'data'=>"Comm", 'border'=>"LT", 'fill'=>1, 'align'=>"R"));   
     array_push($headRow2,array('width'=>"3%", 'data'=>"Pay", 'border'=>"LB", 'fill'=>1, 'align'=>"R"));
   }   
   if($options & REP_COL_CODE_TABLE){
     array_push($headRow,array('width'=>"16%", 'data'=>"Code Table Price", 'border'=>"LBT", 'align'=>"C",'fill'=>1));     
     array_push($headRow2,array('width'=>"4%", 'data'=>"Amt", 'border'=>"TLB", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"3%", 'data'=>"Curr", 'border'=>"TLB", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"3%", 'data'=>"Tax", 'border'=>"TLB", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"3%", 'data'=>"Comm Rec", 'border'=>"TLB", 'fill'=>1, 'align'=>"R"));
     array_push($headRow2,array('width'=>"3%", 'data'=>"Comm Pay", 'border'=>"TLB", 'fill'=>1, 'align'=>"R"));
   }
   if($options & REP_COL_INV_TO){
   	 array_push($headRow,array('width'=>"6%", 'data'=>"Invoice To", 'border'=>"LTR", 'fill'=>1));
     array_push($headRow2,array('width'=>"6%", 'data'=>"", 'border'=>"LB", 'fill'=>1));        
   }
   if($options & REP_COL_POS){
   	 array_push($headRow,array('width'=>"3%", 'data'=>"POS", 'border'=>"LTR", 'fill'=>1));
     array_push($headRow2,array('width'=>"3%", 'data'=>"", 'border'=>"LBR", 'fill'=>1));        
   }        

   $pdf->Row($headRow);
   $pdf->Row($headRow2);

   foreach($rowArray as $key=>$item) {
	 if(empty($item['supplier_name'])) {
		 $item['supplier_name'] = " ";
	 }
	   
	 if(empty($item['rv_extra_ref'])) {
		 $item['rv_extra_ref'] = " ";
	 }

      fixAmtDisplay($item['rv_extra_charge'],2);
      fixAmtDisplay($item['from_total'],2);
      fixAmtDisplay($item['to_total'],2);
      $item['from_total'] .= " $item[extra_currency_symbol]";
      $item['to_total'] .= " $item[folio_currency_symbol]";
      $item['rv_extra_charge'] .= " ". $item['extra_currency_symbol'];
      fixAmtDisplay($item['rv_extra_discount'],0);
      fixAmtDisplay($item['rv_extra_comm_rec'],0);
      fixAmtDisplay($item['rv_extra_comm_pay'],0);
      fixAmtDisplay($item['rv_extra_tax_perc'],0);
      $listRow = array();
      if($notes == true) {
         $border = "LRT";
      } else {
         $border = "LR";
      }
 		 if(trim($item['extra_currency_symbol']) == "") {
			$item['rv_extra_charge'] = "";
			$item['from_total'] = "";
			$item['to_total'] = "";
			//$item['rv_extra_discount'] = "&nbsp;";
			//$item['rv_extra_comm_rec'] = "&nbsp;";
			//$item['rv_extra_comm_pay'] = "&nbsp;";
			//$item['rv_extra_tax_perc'] = "&nbsp;";
			$item['rv_extra_exch_rate'] = "";
			$item['invoiceName'] = "";	 
		 }
     
		 $agentName = $lDB->get("SELECT pr_name_first, pr_name_last FROM pr_persona INNER JOIN rv_extra ON rv_extra.rv_reservation_id = '$item[rv_reservation_ix]' WHERE pr_persona.pr_persona_ix = '$item[rv_agent_id]'",1);         
     if($agentName[0] != ""){
       $agentName[0] .= " ";
     }
     $item['agent_name'] = $agentName[0].$agentName[1];     
     
		 if(trim($item['ac_pos_name_rr']) != "") {
			 $item['ac_pos_name_rr'] = $item['ac_pos_name_rr'] . " (" . $item['ac_pos_name'] . ")";
		 } else {
			 $item['ac_pos_name_rr'] = "";
		 }
     	 $width = 0;
    	 if($options & REP_COL_SERV_DATE){
       	 $width += 6;
         array_push($listRow,array('width'=>"6%", 'data'=>chng_date($item['rv_extra_date_serv'], "-"), 'border'=>$border));
       }
       if($options & REP_COL_PROP){
         $width += 4;
         array_push($listRow,array('width'=>"4%", 'data'=>$item['pr_bus_name_short'], 'border'=>$border));
       }
       if($options & REP_COL_ROOM){
         $width += 4;
         array_push($listRow,array('width'=>"4%", 'data'=>$item['ac_desc'], 'border'=>$border));   
       }
       if($options & REP_COL_GUEST){
         $width += 5;
         array_push($listRow,array('width'=>"5%", 'data'=>$item['guestNames'], 'border'=>$border));   
       }
       if($options & REP_COL_CAT){
         $width += 5;
         array_push($listRow,array('width'=>"5%", 'data'=>$item['ac_extra_cat_desc'], 'border'=>$border));   
       }
       if($options & REP_COL_EXTRA){
         $width += 6;
         array_push($listRow,array('width'=>"6%", 'data'=>$item['ac_ext_desc'], 'border'=>$border));   
       }
       if($options & REP_COL_ETD){
         $width += 3;
         array_push($listRow,array('width'=>"3%", 'data'=>$item['rv_extra_travel_etd'], 'border'=>$border));   
       }
       if($options & REP_COL_ETA){
         $width += 3;
         array_push($listRow,array('width'=>"3%", 'data'=>$item['rv_extra_travel_eta'], 'border'=>$border));   
       }
       if($options & REP_COL_SERVICE){
         $width += 6;
         array_push($listRow,array('width'=>"6%", 'data'=>$item['supplier_name'], 'border'=>$border));   
       }
       if($options & REP_COL_REFERENCE){
         $width += 6;
         array_push($listRow,array('width'=>"6%", 'data'=>$item['rv_extra_ref'], 'border'=>$border));   
       }
       if($options & REP_COL_RES_NO){
         $width += 4;
         array_push($listRow,array('width'=>"4%", 'data'=>$item['rv_reservation_ix'], 'border'=>$border));   
       }
       if($options & REP_COL_RES_NAME){
         $width += 5;
         array_push($listRow,array('width'=>"5%", 'data'=>$item['rv_res_name'], 'border'=>$border));   
       }
       if($options & REP_COL_AGENT){
         $width += 6;
         array_push($listRow,array('width'=>"6%", 'data'=>$item['agent_name'], 'border'=>$border));   
       }
       if($options & REP_COL_QTY){
         $width += 2;
         array_push($listRow,array('width'=>"2%", 'data'=>$item['rv_extra_units'], 'border'=>$border, 'align'=>"C"));   
       }
       if($options & REP_COL_CHARGE){
         $width += 5;
         array_push($listRow,array('width'=>"5%", 'data'=>$item['to_total'], 'border'=>$border, 'align'=>"R"));
       }
       if($options & REP_COL_TOTAL){
         $width += 5;
         array_push($listRow,array('width'=>"5%", 'data'=>$item['from_total'], 'border'=>$border, 'align'=>"R"));   
       }
       if($options & REP_COL_UNIT_PRICE){
         $width += 9;
         array_push($listRow,array('width'=>"3%", 'data'=>$item['rv_extra_exch_rate'], 'border'=>$border, 'align'=>"R"));
         array_push($listRow,array('width'=>"4%", 'data'=>$item['rv_extra_charge'], 'border'=>$border, 'align'=>"R"));
         array_push($listRow,array('width'=>"2%", 'data'=>$item['rv_extra_tax_perc']."%", 'border'=>$border, 'align'=>"R"));   
       }
       if($options & REP_COL_DISC){
         $width += 3;
         array_push($listRow,array('width'=>"3%", 'data'=>$item['rv_extra_discount']."%", 'border'=>$border, 'align'=>"R"));   
       }
       if($options & REP_COL_COM_REC){
         $width += 3;
         array_push($listRow,array('width'=>"3%", 'data'=>$item['rv_extra_comm_rec']."%", 'border'=>$border, 'align'=>"R"));   
       }
       if($options & REP_COL_COM_PAY){
         $width += 3;   
         array_push($listRow,array('width'=>"3%", 'data'=>$item['rv_extra_comm_pay']."%", 'border'=>$border, 'align'=>"R"));
       }   
       if($options & REP_COL_CODE_TABLE){
       	 $width += 16;              
         array_push($listRow,array('width'=>"4%", 'data'=>$item['codeAmnt'], 'border'=>$border, 'align'=>"R"));
         array_push($listRow,array('width'=>"3%", 'data'=>$item['codeCurrSym'], 'border'=>$border, 'align'=>"R"));
         array_push($listRow,array('width'=>"3%", 'data'=>$item['codeTax'], 'border'=>$border, 'align'=>"R"));
         array_push($listRow,array('width'=>"3%", 'data'=>$item['codeCommRec'], 'border'=>$border, 'align'=>"R"));
         array_push($listRow,array('width'=>"3%", 'data'=>$item['codeCommPay'], 'border'=>$border, 'align'=>"R"));
       }
       if($options & REP_COL_INV_TO){
         $width += 6;
         array_push($listRow,array('width'=>"6%", 'data'=>$item['invoiceName'], 'border'=>$border));        
       }
       if($options & REP_COL_POS){
         $width += 3;
         array_push($listRow,array('width'=>"3%", 'data'=>$item['ac_pos_name_rr'], 'border'=>$border));        
       }                 
      $pdf->Row($listRow);
      $notes = false;
      if(trim($item['rv_extra_note']) != "" && $options & REP_BUTTON_NOTES){
         $noteRow = array();
         $notes = true;
         array_push($noteRow,
            array('width'=>"6%", 'data'=>"", 'style'=> "B", 'align'=>"R",'border'=>"L"),
            array('width'=>"6%", 'data'=>"NOTE: ", 'style'=> "B", 'align'=>"L",'border'=>"LT"),
            array('width'=>"88%", 'data'=>$item['rv_extra_note'], 'border'=>"RT")
         );
         $pdf->Row($noteRow);
      }
      $noteIntRow = array();
      if(trim($item['rv_extra_note_internal']) != "" && $options & REP_BUTTON_INTERNAL_NOTES){
         $noteRow = array();
         if($notes == true) {
            $border = "";
         } else {
            $border = "T";
         }
         $notes = true;
         array_push($noteIntRow,
            array('width'=>"6%", 'data'=>"", 'style'=> "B", 'align'=>"R", 'border'=>"L"),
            array('width'=>"6%", 'data'=>"INT. NOTE: ", 'style'=> "B", 'align'=>"L", 'border'=>"L".$border),
            array('width'=>"88%", 'data'=>$item['rv_extra_note_internal'],'border'=>"R".$border)
         );
         $pdf->Row($noteIntRow);
      }
   }   
   $pdf->Row(array(
      array('width'=>$width."%", 'data'=>"", 'border'=>"T")
   ));
   }
   function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
   function getPersonaDetail($personaId) {
      $detail = $GLOBALS['lDB']->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
   }
$GLOBALS['temp']['options'] = $options;
$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
