<?php

/*
 * $Id$
 *
 * $Log$
 *
 */

/**
 * init.form242.php - Optional components popup
 * Job: 676
 * Function: 50 (Availability calendar)
 */

if (!isset($_SESSION['userName'])) {
	redirectTo("/");
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/optional.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

$date = explode(":",$_SERVER['argv'][1]);
$cellStart = $date[0];
$cellEnd = $date[1];
$rateTypeId = $_SERVER['argv'][2];
$accommTypeId = $_SERVER['argv'][3];
$itemId = $_SERVER['argv'][4];
$selectedOptionals = $_SERVER['argv'][5];
$autoPopulateDefaults = (isset($_SERVER['argv'][6])) ? $_SERVER['argv'][6] : "";

if (preg_match("/:/",$itemId)) {
	$item = explode(":",$itemId);
	$itemId = $item[0];
}
//$periodList = "";

$sqa="SELECT
	rf_currency_symbol
	FROM
	rt_rate_type
	INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
	rt_rate_type.rt_rate_type_ix = '".$rateTypeId."'";

$GLOBALS['temp']['currSym'] = $GLOBALS['lDB']->get($sqa,4);

$splitItems = $lDB->get("select rf_period_split from rf_default",4);
if ($splitItems == "2") {
	$sql="
		SELECT DISTINCT
			rt_period.rt_period_ix
		FROM
			rt_period
			INNER JOIN rt_rate ON rt_rate.rt_period_id = rt_period.rt_period_ix
			INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
		WHERE
			rt_period.rt_period_ix = rt_rate.rt_period_id
			AND rt_rate.ac_accomm_type_id = '$accommTypeId'
			AND rt_rate.rt_rate_type_id = '$rateTypeId'
			AND (
				(rt_period_dates.rt_period_from  >= '$cellStart' AND rt_period_dates.rt_period_from < '$cellEnd')
				OR (rt_period_dates.rt_period_to >= '$cellStart' AND rt_period_dates.rt_period_to <= '$cellEnd')
				OR (rt_period_dates.rt_period_from <= '$cellStart' AND rt_period_dates.rt_period_to >= '$cellEnd')
			)
		ORDER BY
			rt_period_dates.rt_period_from
	";
} else {
	$sql="
		SELECT
			rt_period.rt_period_ix
		FROM
			rt_period
			INNER JOIN rt_rate ON rt_rate.rt_period_id = rt_period.rt_period_ix
			INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
		WHERE
			rt_rate.ac_accomm_type_id = '$accommTypeId'
			AND rt_rate.rt_rate_type_id = '$rateTypeId'
			AND (
				rt_period_dates.rt_period_from <= '$cellStart'
				AND rt_period_dates.rt_period_to >= '$cellStart'
			)
		ORDER BY
			rt_period_dates.rt_period_from
		LIMIT 1
	";
}

$periodList = $lDB->get($sql,3);
$periodList = array_unique($periodList);
cleanse($periodList);
$prdCount = sizeof($periodList);
#echo $prdCount."<br>";

$SQL="FROM
	rt_rate_component
	INNER JOIN rt_rate ON
	rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
	INNER JOIN rt_component ON
	rt_component.rt_component_ix = rt_rate_component.rt_component_id
	INNER JOIN rt_period ON
	rt_period_ix = rt_rate.rt_period_id
	INNER JOIN rt_rate_type ON
	rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
	INNER JOIN rf_currency ON
	rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
	rt_rate_component.rt_comp_opt_yn = '1'
	AND
	rt_rate.rt_rate_type_id = '".$rateTypeId."'
	AND
	rt_rate.ac_accomm_type_id = '".$accommTypeId."'
	AND
	rt_rate.rt_period_id IN ('".join("','",$periodList)."')
	ORDER BY
	rt_component.rt_component_desc
	";


$SEL="SELECT
	rt_rate_component_ix,
	rt_rate_component.rt_component_id as cmpId,
	rt_rate_component.rt_comp_freq_ind,
	rt_component.rt_component_desc as cmpDesc,
	rt_rate.rt_period_id as acPrdId,
	rt_period.rt_period_date_from,
	rt_period.rt_period_date_to,
	rf_currency.rf_currency_symbol as cmpCurr,
	rt_component.rt_component_abbrv as cmpAbbr ".$SQL;


$result = $lDB->get($SEL,2);

$perStayEnabled = $GLOBALS['lDB']->get("SELECT rf_per_stay_yn FROM rf_default", 4);
if ($perStayEnabled == 1){
	$perStayComp = $GLOBALS['lDB']->get("
		SELECT
		'' AS rt_rate_component_ix,
		rt_component.rt_component_ix as cmpId,
		rt_component.rt_component_desc as cmpDesc,
		rt_component.rt_component_abbrv as cmpAbbr,
		rt_component.rt_component_sys_code
		FROM
		rt_component
		WHERE
		rt_component.rt_component_sys_code = 1
		",1);
	array_push($result,$perStayComp);
}

$count = count($result);
if ($count > "0") {

	$checkList = $lDB->get("select rt_component_id from rv_res_item_comp where rv_item_comp_option_yn = '1' and rv_reservation_item_id = '".$itemId."'",3);

	$rowHTML = join("",file(__DIR__ . "/../../../public/html/optional_rows.htm"));
	$out = "";

	$cmpList = array();
	$imax = $count;
	$cmpIds = array();
	$cmpAbbrs = array();
	$cmpCount = 0;

	for ($i=0;$i<$imax;$i++){

		$row = $result[$i];

		$rateGroupSQL = "
			SELECT 
			rt_rate_group.rt_rate_group_abbrv
			FROM
			rt_rate_group
			INNER JOIN rt_rate_comp_grp ON rt_rate_comp_grp.rt_rate_group_id = rt_rate_group.rt_rate_group_ix
			INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
			WHERE 
			rt_rate_component.rt_rate_component_ix = '".$row['rt_rate_component_ix']."'
			AND rt_rate_comp_grp.rt_rate_comp_amt <> 0
			";

		$rateGroups = $lDB->get($rateGroupSQL,3);
		if (count($rateGroups) > 0){
			$row['rateGroupAbbrvs'] = join(",",$rateGroups);		 

			if ($row['rt_comp_freq_ind'] == "1") {
				$row['rt_comp_freq_ind'] = "Per Night";
			} else {
				$row['rt_comp_freq_ind'] = "Per Stay";
			}					
		} else {
			$row['rateGroupAbbrvs'] = "No charge";	
			$row['rt_comp_freq_ind'] = "";				
		}

		$row['hideCheck'] = "";
		$row['cmpPrd'] = "";
		$row['checked'] = "";


		if (in_array($row['cmpId'],$cmpList)) {
			$row['hideCheck'] = " style=\"visibility:hidden\"";
			if ($prdCount > 1) {
				$row['cmpDesc'] = "&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;";
				$row['cmpPrd'] = " from ".chng_date($row['rt_period_date_from'],"-");
			}
		} else {

			$selectedOptionalsArr = explode(":",$selectedOptionals);

			$row['cmpPrd'] = "";
			if(isset($row['rt_period_date_from'])) {
				$row['cmpPrd'] = " from ".chng_date($row['rt_period_date_from'],"-");
			}
			if (in_array($row['cmpId'],$checkList)){
				$row['checked'] = " checked";
				$cmpIds[$cmpCount] = $row['cmpId'];
				$cmpAbbrs[$cmpCount] = $row['cmpAbbr'];
				$cmpCount++;
			} elseif (in_array($row['cmpId'],$selectedOptionalsArr)){
				$row['checked'] = " checked";
				$cmpIds[$cmpCount] = $row['cmpId'];
				$cmpAbbrs[$cmpCount] = $row['cmpAbbr'];
				$cmpCount++;
			}
		}

		array_push($cmpList,$row['cmpId']);
		$out .= showpage($row,$rowHTML);
	}

} else {
	$out = "<table><tr><td colspan=\"3\" align=\"center\"></td></tr></table>";
}

$GLOBALS['temp']['rows'] = $out;


$GLOBALS['temp']['hideOvrdRate'] = " style=\"display:none\"";
$GLOBALS['temp']['overide'] = "false";

if ($autoPopulateDefaults == "1") {
	echo '{"ids":"'.implode(":", $cmpIds).'", "abbrs":"'.implode(", ", $cmpAbbrs).'"}';
	die();
}
