<?php

/**
 * init.form247.php - Reservation details itinerary
 * Job: 680
 * Function: 53
 */

if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"","");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],15,"");

// Get the variables
$pAction = $_SERVER['argv'][1];
$reservationId = $_SERVER['argv'][2];
$itemId = $_SERVER['argv'][3];
$itemData = array_pad(explode(":",$_SERVER['argv'][4]),7,"");
$compList = explode(":",$_SERVER['argv'][5]);
$rv_item_split_yn = $_SERVER['argv'][6];
$override = explodeOrides($_SERVER['argv'][7]);
$roomList = explode(":",$_SERVER['argv'][8]);
$roomRequestYN = $_SERVER['argv'][9];
$roomRequestReason = addslashes(rawurldecode($_SERVER['argv'][10]));
$allocations = $_SERVER['argv'][11];
$itemRateId = $_SERVER['argv'][12];
$clearAllBlockAllocations = $_SERVER['argv'][13] == 1 ? true : false;
$itemCommPerc = $_SERVER['argv'][14];

if ($_SERVER['argv'][2] == "6") {
	$reservationId = $_SERVER['argv'][6];
}

$record = $reservationId;
$reservationModified = false;

// Remove any blank groups (to prevent the existance of extra groups)
$groupList = $lDB->get("SELECT rv_res_item_group_ix FROM rv_res_item_group WHERE rv_reservation_item_id = '$itemId'",3);
foreach($groupList as $groupId) {
	$roomCount = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$groupId'
	",4);
	$guestCount = $lDB->get("SELECT COUNT(*) FROM rv_res_item_guest WHERE rv_res_item_group_id = '$groupId'",4);
	if($roomCount < 1 && $guestCount < 1) {
		$lDB->put("DELETE FROM rv_res_item_group WHERE rv_res_item_group_ix = '$groupId'");
	}
}

session_set("blockRateOverLap","0");
$blockRateData = $GLOBALS['lDB']->get("select rf_period_split from rf_default",4);
if ($blockRateData == "2") {
	session_set("blockRateOverLap","1");
}

// Do the action
// For ADD and EDIT action, split up items over multiple periods
if ($pAction == "add" || $pAction == "edit") {
	$ratePeriodId = $lDB->get("
		SELECT
			rv_reservation.rt_rate_type_id as rateId
		FROM
			rv_reservation
		WHERE
		rv_reservation.rv_reservation_ix = '$reservationId'
	",4);

	$accommTypeId = $itemData[0];

	$itemArriveDate = str_replace("/","-",$itemData[1]);
	$itemDepartDate = str_replace("/","-",$itemData[2]);

	$getRateDates = array();
	$getRateDates['accommType'] = $accommTypeId;
	$getRateDates['rateType']   = $ratePeriodId;
	$getRateDates['startDate']  = $itemArriveDate;
	$getRateDates['endDate']    = $itemDepartDate;
	$prdDates = getRateDates($getRateDates);

	$itemsToCreate = array();
	if(sizeof($prdDates) > 1) {
		if($_SESSION['blockRateOverLap'] == "1") {
			$tmp = explode("-",$prdDates[0]['rt_period_date_to']);
			$endDate = date("Y-m-d",mktime(0,0,0,$tmp[1],$tmp[2]+1,$tmp[0]));
			$firstItem = array("start" => $itemArriveDate, "end" => $endDate, "prdId" => $prdDates[0]['acPeriodId']);
			array_push($itemsToCreate,$firstItem);

			for($a=1;$a<sizeof($prdDates);$a++){
				$start = $prdDates[$a]['rt_period_date_from'];
				$tmp = explode("-",$prdDates[$a]['rt_period_date_to']);
				$end = date("Y-m-d",mktime(0,0,0,$tmp[1],$tmp[2]+1,$tmp[0]));

				$nextItem = "";
				if ($itemDepartDate <= $end){
					$nextRes = array("start" => $start, "end" => $itemDepartDate, "prdId" => $prdDates[$a]['acPeriodId']);
				} else {
					$nextRes = array("start" => $start, "end" => $end, "prdId" => $prdDates[$a]['acPeriodId']);
					if ($prdDates[$a]['rt_period_date_to'] < $itemDepartDate) {
						if ($a == (sizeof($prdDates)-1)) {
							$nextItem['start'] = $end;
							$nextItem['end'] = $itemDepartDate;
							$nextItem['prdId'] = "0";
						}
					}
				}
				array_push($itemsToCreate,$nextRes);
				if (is_array($nextItem)) array_push($itemsToCreate,$nextItem);
			}
		} else {
			$firstItem = array("start" => $itemArriveDate, "end" => $itemDepartDate, "prdId" => $prdDates[0]['acPeriodId']);
			array_push($itemsToCreate,$firstItem);
		}
	} else {
		$firstItem = array("start" => $itemArriveDate, "end" => $itemDepartDate, "prdId" => (isset($prdDates[0])?$prdDates[0]['acPeriodId']:""));
		array_push($itemsToCreate,$firstItem);
	}

	$itemAccommCount = $itemData[4];
	$itemAdultCount = $itemData[5];
	$itemChildCount = $itemData[6];
	$itemCreateUser = $GLOBALS['userid'];
}


switch ($pAction) {
case "delete":
	$resItem = getItemDetails($itemId);
	$trfFlag = $GLOBALS['lDB']->get("SELECT rv_reservation_item_trf_yn FROM rv_reservation_item WHERE rv_reservation_item_ix = '$itemId'",4);

	$itinCount = $GLOBALS['lDB']->get("SELECT COUNT(rv_reservation_item_ix) FROM rv_reservation_item WHERE rv_reservation_id = '$reservationId'",4);

	$canEditBlockItinerary = true;
	if ($resItem['bl_block_ix']) {
		$canEditBlockItinerary = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn") == "1";
	}
	$canEdit = (
			canEditDB($resItem['rv_reservation_item_db'])
			|| ($trfFlag == "0" && $resItem['rv_reservation_item_db'] == $GLOBALS['dbcode'])
		) && (
			isMasterDB() || $GLOBALS['dbcode'][0] != "W"
		) && $GLOBALS['userStatusId'] > 0 
		&& $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5
		&& canEditReservation($record,true,"2",$itemId)
		&& canEditItineraries()
		&& $canEditBlockItinerary
		&& $itinCount > 1;

	if($canEdit) {	
		// Audit trail
		$reservationItem = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item.rv_reservation_item_ix,
				rv_reservation_item.rv_item_amt_comm,
				rv_reservation_item.rv_item_amt_gross,
				rv_reservation_item.rv_item_amt_nett,
				rv_reservation_item.rv_item_amt_payable,
				rv_reservation_item.rv_item_amt_tax,
				rv_reservation_item.rv_item_comm_perc,
				rv_reservation_item.rv_item_overide_level_ind,
				rv_reservation_item.rv_item_overide_amt,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_reservation_item.rv_item_exch_rate,
				rv_reservation_item.rv_item_nights,
				rv_reservation_item.rv_item_accomm_count,
				rv_reservation_item.rv_item_note_conf,
				rv_reservation_item.rv_item_note_general,
				rv_reservation_item.rv_item_split_yn,
				rv_reservation_item.rv_item_var_perc,
				rv_reservation_item.rt_rate_type_id,
				rv_reservation_item.ac_accomm_type_id,
				rv_reservation_item.pr_business_id
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item_ix = '$itemId'
		", 1);
		
		$reservationAuditTrail = new AuditTrail($reservationId,TYPE_RESERVATION);
		$moduleFieldValues = array();
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_comm");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_gross");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_nett");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_payable");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_tax");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_comm_perc");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_overide_level_ind");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_overide_amt");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_date_arrive");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_date_depart");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_adult_count");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_child_count");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_exch_rate");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_nights");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_accomm_count");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_note_conf");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_note_general");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_split_yn");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_var_perc");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rt_rate_type_id");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.ac_accomm_type_id");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.pr_business_id");
			
		foreach ($moduleFieldValues as $moduleFieldValue) {
			$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
			$reservationAuditTrail->addDetail(
				$reservationItem[$moduleFieldName],
				"",
				$reservationItem['rv_reservation_item_ix'],
				Null,
				DB_AD_RES_DETAIL_ACTION_DELETE,
				"resitinerary",
				$moduleFieldValue['ad_module_field_name']
			);
		}
        $clearAllBlockAllocations = true;
        if ($resItem['bl_block_ix']) {
            $drawDownItem = $GLOBALS['lDB']->get("
                SELECT
                    rv_reservation_item.rv_reservation_item_ix
                FROM
                    rv_reservation_item
                    LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_link_res_item_id = rv_reservation_item.rv_reservation_item_ix
                    LEFT JOIN rv_reservation allocation ON allocation.rv_reservation_ix = allocation_item.rv_reservation_id AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
                WHERE
                    rv_reservation_item.rv_reservation_id = '$reservationId'
                    AND rv_reservation_item.rv_item_date_arrive = '".$resItem['rv_item_date_arrive']."'
                    AND rv_reservation_item.rv_item_date_depart = '".$resItem['rv_item_date_depart']."'
                    AND rv_reservation_item.ac_accomm_type_id = '".$resItem['ac_accomm_type_id']."'
                    AND rv_reservation_item.rv_reservation_item_ix != '$itemId'
            ", 1);
            if (!empty($drawDownItem)) {
                $clearAllBlockAllocations = false;
            }
        }
		calDeleteItem($itemId, $reservationId, false, true, false, false, true);
		$reservationAuditTrail->save("Itinerary (Delete)");
		updateReservation($reservationId);
		$reservationModified = true;
	}
	break;
case "edit":
	$reservationItemBefore = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation_item.rv_item_amt_comm,
			rv_reservation_item.rv_item_amt_gross,
			rv_reservation_item.rv_item_amt_nett,
			rv_reservation_item.rv_item_amt_payable,
			rv_reservation_item.rv_item_amt_tax,
			rv_reservation_item.rv_item_comm_perc,
			rv_reservation_item.rv_item_overide_level_ind,
			rv_reservation_item.rv_item_overide_amt,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_item_exch_rate,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_note_conf,
			rv_reservation_item.rv_item_note_general,
			rv_reservation_item.rv_item_split_yn,
			rv_reservation_item.rv_item_var_perc,
			rv_reservation_item.rt_rate_type_id,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.pr_business_id,
            alloc_item.bl_series_id
		FROM
			rv_reservation_item
            LEFT JOIN rv_reservation_item alloc_item ON alloc_item.rv_link_res_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$itemId'
	", 1);
    $reservationItemIds = calCreateItem(
        $reservationId,
        $_SERVER['argv'][4],
        $itemRateId,
        $compList,
        $override,
        $rv_item_split_yn,
        "0",
        $itemId,
        $allocations,
        false,
        false,
        $clearAllBlockAllocations,
		$reservationItemBefore['bl_series_id'],
		false,
		$itemCommPerc,
		true
     );
	$reservationAuditTrail = new AuditTrail($reservationId,TYPE_RESERVATION);
	foreach ($reservationItemIds as $reservationItemId) {
		$reservationItemAfter = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item.rv_item_amt_comm,
				rv_reservation_item.rv_item_amt_gross,
				rv_reservation_item.rv_item_amt_nett,
				rv_reservation_item.rv_item_amt_payable,
				rv_reservation_item.rv_item_amt_tax,
				rv_reservation_item.rv_item_comm_perc,
				rv_reservation_item.rv_item_overide_level_ind,
				rv_reservation_item.rv_item_overide_amt,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_reservation_item.rv_item_exch_rate,
				rv_reservation_item.rv_item_nights,
				rv_reservation_item.rv_item_accomm_count,
				rv_reservation_item.rv_item_note_conf,
				rv_reservation_item.rv_item_note_general,
				rv_reservation_item.rv_item_split_yn,
				rv_reservation_item.rv_item_var_perc,
				rv_reservation_item.rt_rate_type_id,
				rv_reservation_item.ac_accomm_type_id,
				rv_reservation_item.pr_business_id
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item_ix = '$reservationItemId'
		", 1);
		$moduleFieldValues = array();
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_comm");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_gross");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_nett");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_payable");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_amt_tax");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_comm_perc");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_overide_level_ind");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_overide_amt");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_date_arrive");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_date_depart");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_adult_count");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_child_count");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_exch_rate");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_nights");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_accomm_count");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_note_conf");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_note_general");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_split_yn");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rv_item_var_perc");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.rt_rate_type_id");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.ac_accomm_type_id");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation_item.pr_business_id");
		$idBefore = ($itemId != $reservationItemId) ? $itemId : null;
		$idAfter = ($itemId != $reservationItemId) ? $reservationItemId : null;
		foreach ($moduleFieldValues as $moduleFieldValue) {
			$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
			$reservationAuditTrail->addDetail(
				$reservationItemBefore[$moduleFieldName],
				$reservationItemAfter[$moduleFieldName],
				$idBefore,
				$idAfter,
				DB_AD_RES_DETAIL_ACTION_EDIT,
				"resitinerary",
				$moduleFieldValue['ad_module_field_name']
			);
		}
	}
	$reservationAuditTrail->save("Itinerary (Edit)");
	$reservationModified = true;
	// If case was 'delete', then break
	// Fall through to add
	break;
case "add":
	// Audit trail
	$reservationItems = calCreateItem($reservationId,$_SERVER['argv'][4],$itemRateId,$compList,$override,$rv_item_split_yn,"0",false,$allocations,false,false,false,false,false,$itemCommPerc, true);
	calCreateItemAudit($reservationItems, $reservationId);
	$reservationModified = true;
	break;
case "rooming":
	# clear any existing rooms
	$groupList = $lDB->get("SELECT rv_res_item_group_ix FROM rv_res_item_group WHERE rv_reservation_item_id = '$itemId'",3);
	foreach($groupList as $group) {
		$lDB->put("DELETE FROM rv_res_item_group WHERE rv_res_item_group_ix = '$group'");
	}	
	$guestList = $lDB->get("SELECT rv_res_item_guest_ix FROM rv_res_item_guest where rv_reservation_item_id = '$itemId'",3);
	foreach($guestList as $guest) {
		$lDB->put("DELETE FROM rv_res_item_guest WHERE rv_res_item_guest_ix = '$guest'");
	}	
	foreach($roomList as $ac_accomm_room_id) {
		db_rv_res_item_group_insert($itemId, $ac_accomm_room_id, $roomRequestYN, $roomRequestReason);
	}	  
	break;
default:
	if ($_SERVER['argv'][2] == "6") {
		$reservationId = $_SERVER['argv'][6];
		if ($_SERVER['argv'][1] != "") {
			$oldItems = explode(":", $_SERVER['argv'][1]);
			if(!empty($_SERVER['argv'][3])) {
				$newItems = array_map(function($rawItem) {
					list($data, $optionals, $override, $rate, $commission) = explode("|", $rawItem);
					$optionals = explode(":", $optionals);
					list($ac_accomm_type_id, $arrive, $depart, $nights, $config) = explode(":", $data);
					return [
						'arrive'=>$arrive,
						'depart'=>$depart,
						'optionals'=>$optionals,
						'config'=>$config,
						'rate'=>$rate,
						'comm'=>$commission,
						'override'=>$override
					];
				},explode(",", $_SERVER['argv'][3]));
			} else {
				$newItems = [];
			}
			$mode = $_SERVER['argv'][7];
			if($mode != "edit") {
				$mode = "add";
			}
			calApplyDifferentConfig($oldItems,$newItems,$mode,$clearAllBlockAllocations);
		}
	}
	break;
}

if ($reservationModified) {
	if ($GLOBALS['userStatusId'] == 1) {
		// Flag modifications made by external users
		$reservationAuditTrail->flagReservationModification();
	}
}

$specialIndicationData = getSpecialIndicationText($reservationId,1);

// Produce listing
# Get total for extras for this reservation
if(trim($pAction) != "" && $pAction != "view") {	  
	recalcTotals($reservationId,4);
}
$resAmt = getDisplayResTotals($reservationId);
$paymentPlan = getPayItems($reservationId,$resAmt);

$GLOBALS['temp']['total_gross'] = $resAmt;
$GLOBALS['temp']['payedTotal'] = $paymentPlan['payedTotal'];
$GLOBALS['temp']['payOutstanding'] = $paymentPlan['outstanding'];
$GLOBALS['temp']['rows'] = "<tr style=\"height: 20px\">
	<td colspan=\"13\" align=\"center\">No items currently exist for this Reservation [" . $reservationId . "]</td>
</tr>
";
$GLOBALS['temp']['totalResCost'] = getDisplayAccommTotal($reservationId);
$GLOBALS['temp']['extra_travel_total'] = getDisplayExtTrvTotals($reservationId);

$list = $lDB->get("
	SELECT
		rv_reservation_item_ix
	FROM
		rv_reservation_item
	WHERE
		rv_reservation_id = '".$record."'
	ORDER BY
		rv_item_date_arrive,
		rv_item_date_depart,
		pr_business_id,
		ac_accomm_type_id
",3);
$rowHTMLA = join("",file(__DIR__ . "/../../../public/html/reservation_item_row.htm"));
$rowHTMLB = join("",file(__DIR__ . "/../../../public/html/reservation_item_row_view.htm"));
$rowHTML = $rowHTMLA;
if ($_SERVER['argv'][0] == "0") {
	$rowHTML = $rowHTMLB;
}


$GLOBALS['temp']['rv_split_items'] = "";
$rf_currency_symbol = getInvCurrSymbol($record);
$rv_split_items = array();
$editItem = array();
$imax = sizeof($list);
$lastArrive = "";
$lastDepart = "";
$lastProperty = "";
$out = "";
$resRate = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
for ($i=0;$i<$imax;$i++) {
	$itemId = $list[$i];
	$resItem = getItemDetails($itemId);

	$resItem['rt_rate_type_desc_fmt'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($resItem['rt_rate_type_desc'])));
	$special = itemSpecialItinLineIndicator($itemId);
	$resItem['rateLabel'] = "Rte".$special;

	if($resRate != $resItem['rt_rate_type_id']) {
		$resItem['rateLabel'] = "Ovr".$special;
	}
	if($resItem['commPerc'] != $resItem['itemCommPerc']) {
		$resItem['rateLabel'] .= " %";
	}

	if ($resItem['rv_item_split_yn'] == "1") {
		array_push($rv_split_items,$itemId);
	}

	$resItem['amount'] = getDisplayItemTotal($itemId);
	$resItem['itemCurr'] = $rf_currency_symbol;

	if ($resItem['amount'] == "TBA") {
		$resItem['itemCurr'] = "";
	}

	$resItem['arrive'] = chng_date($resItem['rv_item_date_arrive'],"-");
	$resItem['depart'] = chng_date($resItem['rv_item_date_depart'],"-");
	$resItem['id'] = $itemId;
	$guestCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
		WHERE
			rv_res_item_group.rv_reservation_item_id = '$itemId'
	",4);
	$maxGroupStatus = $GLOBALS['lDB']->get("
		SELECT
			MAX(rv_grp_status_ind)
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.rv_reservation_item_id = '$itemId'
	",4);
	$resItem['hideRoomButton'] = "";
	$resItem['allowRoomButton'] = "true";
	if ($userStatusId < 2 || $guestCount > 0 || $maxGroupStatus > 2) {
		$resItem['hideRoomButton'] = " style=\"visibility:hidden\"";
		$resItem['allowRoomButton'] = "false";
	}

	if($lastArrive == $resItem['arrive'] && $lastDepart == $resItem['depart'] && $lastProperty == $resItem['pr_name_last']) {
		$resItem['arrive'] = "";
		$resItem['depart'] = "";
		$resItem['pr_name_last'] = "";
	} else {
		$lastArrive = $resItem['arrive'];
		$lastDepart = $resItem['depart'];
		$lastProperty = $resItem['pr_name_last'];
	}

	$textColour = "txt";
	$bgColour = "#fff";
	
	$invoiced = $GLOBALS['lDB']->get("
		SELECT
			COUNT(rv_reservation_item_ix)
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item_ix = '$resItem[id]'
			AND fn_invoice_id IS NOT NULL
			AND fn_invoice_id <> '0'
			AND trim(fn_invoice_id) <> ''
	",4);

	if ( $invoiced > "0" ) {
		$textColour = "txtred";
	}
	
	// Test to see whether this item's component(s) have been modified ----------
	$hasBeenModified = $GLOBALS['lDB']->get("SELECT count(rv_item_comp_edit_yn) FROM rv_res_item_comp WHERE rv_item_comp_edit_yn = 1 AND rv_reservation_item_id = '" . $resItem['id'] . "'",4);	
	// --------------------------------------------------------------------------
	// NB! Once we implement server access control use class txtg for the server
	// controlled items
	// --------------------------------------------------------------------------
	if ( $hasBeenModified >= "1" ) {
		$bgColour = "#f1c55d";
	}

	// Test to see whether this item has been overridden
	$rateGroupOverrides = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_rate_grp_overide_amt
		FROM
			rv_res_item_rate_grp
		WHERE
			rv_res_item_rate_grp.rv_reservation_item_id = '".$resItem['id']."'
			AND rv_res_item_rate_grp_overide_amt IS NOT NULL
	",3);

	if ($resItem['rv_item_overide_amt'] != "" || (!empty($rateGroupOverrides))) {
		$bgColour = "#bad3ea";
	}

	$resItem['rowClass'] = "$textColour br";
	$resItem['bgColour'] = "$bgColour";

	if ( !in_array($itemId,$editItem) ) {
		array_push($editItem,$itemId);
	}	
	
	  
	// Rooming info
	$roomList = join(":",$GLOBALS['lDB']->get("SELECT ac_accomm_room_id FROM rv_res_item_group WHERE rv_reservation_item_id = '$itemId'",3));
	$roomRequest = $GLOBALS['lDB']->get("
		SELECT 
			rv_room_requested_yn,
			rv_room_request_reason
		FROM
			rv_res_item_group
		WHERE
			rv_reservation_item_id = '$itemId'
	",1);
	$resItem['roomList'] = $roomList;
	$resItem['requestYN'] = $roomRequest['rv_room_requested_yn'];
	$resItem['requestReason'] = str_replace("<br />","\\n",t_encodeOverlib($roomRequest['rv_room_request_reason']));
	$resItem['rv_reservation_item_id'] = $itemId;

	$trfFlag = $GLOBALS['lDB']->get("SELECT rv_reservation_item_trf_yn FROM rv_reservation_item WHERE rv_reservation_item_ix = '$itemId'",4);

	$canEdit =
		(
			canEditDB($resItem['rv_reservation_item_db']) 
			|| ($trfFlag == "0" && $resItem['rv_reservation_item_db'] == $GLOBALS['dbcode'])
		) && (
			isMasterDB() || $GLOBALS['dbcode'][0] != "W"
		) && $GLOBALS['userStatusId'] > 0 
		&& $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5
		&& canEditReservation($record,true,"2",$itemId)
		&& canEditItineraries();


	$resItem['hideCompButton'] = "";
	$resItem['allowCompButton'] = "true";

	if ($userStatusId < 2) {
		$resItem['hideCompButton'] = " style=\"visibility:hidden\"";
		$resItem['allowCompButton'] = "false";
	}

    $resItem['hideDelButton'] = "";
    $resItem['allowDelButton'] = "true";

	if ($imax == "1" || !$canEdit || $invoiced > 0) {
		$resItem['hideDelButton'] = " style=\"visibility:hidden\"";
		$resItem['allowDelButton'] = "false";
	}
	
	
	if ($canEdit) {
		$editItem = $list;
	}

	$resItem['pr_name_last'] = t_encodeHTMLField($resItem['pr_name_last']);
	$resItem['ac_accomm_desc'] = t_encodeHTMLField($resItem['ac_accomm_desc']);
	$resItem['invoice_currency'] = t_encodeHTMLField($resItem['invoice_currency']);

	if ( !$canEdit && $invoiced == "0" ) {
		$resItem['rowClass'] = "txtg br";
	}

	if(!$canEdit || $invoiced>"0") {
		$out .= showpage($resItem,$rowHTMLB);
	} else {
		$out .= showpage($resItem,$rowHTML);
	}
}

$GLOBALS['temp']['isItinerary'] = "0";
if ($out != "") {
	$GLOBALS['temp']['isItinerary'] = "1";
	$GLOBALS['temp']['rows'] = "<table width=\"770\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" style=\"table-layout: fixed;\" class=\"noTop\">
		<col width=\"81\" />
		<col width=\"81\" />
		<col width=\"120\" />
		<col width=\"120\" />
		<col width=\"31\" />
		<col width=\"36\" />
		<col width=\"36\" />
		<col width=\"38\" />
		<col width=\"34\" />
		<col width=\"85\" />
		<col width=\"34\" />
		<col width=\"48\" />
		<col width=\"24\" align=\"center\" />
	";
	$GLOBALS['temp']['rows'] .= $out;
	$GLOBALS['temp']['rows'] .= "</table>";
}

// do remoteScripting server side
if ($pAction != "") {
	// Declare host variables
	$rsUpdateInnerHTML = array();
	$rsUpdateValue = array();
	$rsUpdateVar = array();
	$rsFuncList = array();
	$specialNotification = isset($GLOBALS['specialNotification']) ? $GLOBALS['specialNotification'] : "";
	$GLOBALS['specialNotification'] = "";

	// Add values to arrays
	$rsUpdateInnerHTML['itinRows'] = $GLOBALS['temp']['rows'];

	$rsUpdateValue['payedTotal'] = $GLOBALS['temp']['payedTotal'];
	$rsUpdateValue['payOutstanding'] = $GLOBALS['temp']['payOutstanding'];
	$rsUpdateValue['total_gross'] = (string) $GLOBALS['temp']['total_gross'];
	$rsUpdateValue['totalResCost'] = (string) $GLOBALS['temp']['totalResCost'];
	$rsUpdateValue['extra_travel_total'] = (string) $GLOBALS['temp']['extra_travel_total'];
	
	$rsUpdateInnerHTML['appliedSpecialDescDiv'] = $specialIndicationData['appliedSpecialDesc'];
	$rsUpdateInnerHTML['defaultSpecialSuggestionDesc'] = $specialIndicationData['defaultSpecialSuggestionDesc'];
	if ($specialNotification != "") {
		$rsUpdateValue['specialNotification'] = $specialNotification;
		array_push($rsFuncList, "specialChangedNotification");
	}

	$paxSummary = getPaxSummary($reservationId);
	$rsUpdateInnerHTML['paxsummary'] = $paxSummary['paxsummary'];
	$rsUpdateInnerHTML['reservationBedNights'] = $paxSummary['reservationBedNights'];

	$rsUpdateVar["parent.isItinerary"] = (string) "\"".$GLOBALS['temp']['isItinerary']."\"";
	$rsUpdateVar["parent.editItem"] = (string) "new Array('".join("','",$editItem)."');";

	// Output RS response
	echo rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList);
	echo "<script>parent.wait.hide();</script>";

	if (is_array($rv_split_items) && sizeof($rv_split_items) > 0) {
		$popupAction = ($pAction == "edit") ? "edit" : "new";
		echo "<script>parent.openPopup('reservation.php?684+".join(":",$rv_split_items)."+".$popupAction."',540,555);</script>";
	}

	die();
}
