<?php

/**
 * Form 250 - Agent contact details
 * Jobs: 683 (view), 751 (edit), 752 (edit/save)
 * Function: 54 (Contacts)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/agent_role_info.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");
   
$agentId = $_SERVER['argv'][1];
$record = $agentId;
$agentName = $_SERVER['argv'][2];
$saveSession = $_SERVER['argv'][3];
$contactId = $_SERVER['argv'][4];
$GLOBALS['temp']['aName'] = urldecode($agentName);   
   
if($_SERVER['argv'][0] == "683" && isset($GLOBALS['jobLevelArray'][751]) && $GLOBALS['jobLevelArray'][751] >= 10) {
	$agentName = t_encodeOverlib(urldecode($agentName));
	echo "<script language=\"javascript\">window.location = '/reservation.php?751+$record+$agentName+$saveSession+$contactId';</script>";  
	die();
}

   
$fields = array(
	"pr_corr_addr_line1",
	"pr_corr_addr_line2",
	"pr_corr_addr_line3",
	"pr_corr_city",
	"pr_corr_country_id",
	"pr_corr_post_code",
	"pr_phys_addr_line1",
	"pr_phys_addr_line2",
	"pr_phys_addr_line3",
	"pr_phys_city",
	"pr_phys_country_id",
	"pr_phys_post_code",
	"pr_email",
	"pr_web_addr",
	"pr_statutory_1",
	"pr_statutory_2",
	"pr_statutory_3",
	"pr_email",
	"pr_persona_fwd_id",
	"pr_persona_link_id"
);
$ident = "";
$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"pr_persona",$fields,"pr_persona_ix = '$record'","","",$ident);

$GLOBALS['autovar'] = "1";
$GLOBALS[$form]->Get($action);

if($pmode == "1") {
	// Audit trail
	$current = $GLOBALS['lDB']->get("
		SELECT
			*
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$lDB->escape($record)."'
	",1);

	$audit = new AuditTrail($record,TYPE_PERSONA);
	$changes = false;
	
	$oldId = $record;
	$newId = $record;

	foreach($fields as $field) {
		// Ignore disabled/unused fields
		if($field == "pr_persona_ix" || $field == "pr_persona_fwd_id" || $field == "rf_comms_preference_id") {
			continue;
		}
		if(isset($_POST[$field]) && $_POST[$field] != $current[$field]) {
			$changes = true;
			$oldValue = $current[$field];
			$newValue = $_POST[$field];
			$audit->addDetail(
				$oldValue,
				$newValue,
				$oldId,
				$newId,
				DB_AD_PERSONA_DETAIL_ACTION_EDIT,
				"persona",
				"pr_persona.".$field
			);
		}
	}		
	$GLOBALS['lDB']->put("
		UPDATE pr_agent SET
			pr_agent_comm_deduct_yn = '$_POST[pr_agent_comm_deduct_yn]',
			pr_agent_commission_perc = '$_POST[pr_agent_commission_perc]',
			pr_agent_account = '".$GLOBALS['lDB']->escape($_POST['pr_agent_account'])."',
			ac_pay_plan_id = '$_POST[ac_pay_plan_id]',
			pr_agent_note_open = '".$GLOBALS['lDB']->escape($_POST['pr_agent_note_open'])."'
		WHERE
			pr_agent_id = '$agentId'
	");
	if($_POST['phone_number'] != $_POST['old_phone_number']) {
		// Remove old telephone record
		$oldPhoneId = $GLOBALS['lDB']->get("
			SELECT
				pr_phone_ix
			FROM
				pr_phone
			WHERE
				pr_phone.pr_persona_id = '$agentId'
				AND pr_phone.pr_default_yn = '1'
				AND pr_phone.pr_phone_number = '".$GLOBALS['lDB']->escape($_POST['old_phone_number'])."'
		",4);
		$changes = true;
		$audit->addDetail(
			$_POST['old_phone_number'],
			"",
			$oldPhoneId,
			"",
			DB_AD_PERSONA_DETAIL_ACTION_DELETE,
			"phone",
			"pr_phone.pr_phone_number"
		);
		$GLOBALS['lDB']->put("DELETE FROM pr_phone WHERE pr_phone_ix = '$oldPhoneId'");

		if($_POST['phone_number'] != "") {
			// Add new telephone record
			$GLOBALS['lDB']->put("
				INSERT INTO pr_phone (
					pr_phone_db,
					pr_phone_id,
					pr_default_yn,
					pr_phone_number,
					rf_phone_type_id,
					pr_persona_id
				) VALUES (
					'$GLOBALS[dbcode]',
					'',
					'1',
					'".$GLOBALS['lDB']->escape($_POST['phone_number'])."',
					'RS3',
					'$agentId'
				)
			",1);
			$pr_phone_id = $lDB->insert_id;
			$audit->addDetail(
				"",
				$_POST['phone_number'],
				"",
				$pr_phone_id,
				DB_AD_PERSONA_DETAIL_ACTION_ADD,
				"phone",
				"pr_phone.pr_phone_number"
			);
		}		
	}
	if($_POST['fax_number'] != $_POST['old_fax_number']) {
		// Remove old telephone record
		$oldPhoneId = $GLOBALS['lDB']->get("
			SELECT
				pr_phone_ix
			FROM
				pr_phone
			WHERE
				pr_phone.pr_persona_id = '$agentId'
				AND rf_phone_type_id = 'RS1'
				AND pr_phone.pr_phone_number = '".$GLOBALS['lDB']->escape($_POST['old_fax_number'])."'
		",4);
		$changes = true;
		$audit->addDetail(
			$_POST['old_fax_number'],
			"",
			$oldPhoneId,
			"",
			DB_AD_PERSONA_DETAIL_ACTION_DELETE,
			"phone",
			"pr_phone.pr_phone_number"
		);
		$GLOBALS['lDB']->put("DELETE FROM pr_phone WHERE pr_phone_ix = '$oldPhoneId'");

		if($_POST['fax_number'] != "") {
			// Add new telephone record
			$GLOBALS['lDB']->put("
				INSERT INTO pr_phone (
					pr_phone_db,
					pr_phone_id,
					pr_default_yn,
					pr_phone_number,
					rf_phone_type_id,
					pr_persona_id
				) VALUES (
					'$GLOBALS[dbcode]',
					'',
					'0',
					'".$GLOBALS['lDB']->escape($_POST['fax_number'])."',
					'RS1',
					'$agentId'
				)
			",1);
			$pr_phone_id = $lDB->insert_id;
			$audit->addDetail(
				"",
				$_POST['fax_number'],
				"",
				$pr_phone_id,
				DB_AD_PERSONA_DETAIL_ACTION_ADD,
				"phone",
				"pr_phone.pr_phone_number"
			);
		}		
	}
	if ($changes) {
		$audit->save("Contact details (Edit)");
	}
}


$GLOBALS['temp']['hideExt'] = "";
if($userStatusId < 2){
	$GLOBALS['temp']['hideExt'] = "collapse";
}

$GLOBALS[$form.'_pr_persona_pr_email']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_web_addr']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_statutory_1']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_statutory_2']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_statutory_3']->Width = "200";

$GLOBALS[$form.'_pr_persona_pr_corr_addr_line1']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line2']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line3']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_corr_post_code']->Width = "95";
$GLOBALS[$form.'_pr_persona_pr_corr_city']->Width = "200";

$GLOBALS[$form.'_pr_persona_pr_phys_addr_line1']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line2']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line3']->Width = "200";
$GLOBALS[$form.'_pr_persona_pr_phys_post_code']->Width = "95";
$GLOBALS[$form.'_pr_persona_pr_phys_city']->Width = "200";

$sql = "
	SELECT
		rf_country_db,
		rf_country_id,
		rf_country_name,
		rf_country_code
	FROM
		rf_country
	WHERE
		rf_country_inactive = '0'
	ORDER BY
		rf_country_name
";


$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Class = 3;
$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Select = combolist($GLOBALS['lDB'],$sql,"0:|:");
$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Width = "200";

$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Class = 3;
$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Select = combolist($GLOBALS['lDB'],$sql,"0:|:");
$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Width = "200";   
   
$agentTel = $GLOBALS['lDB']->get("
	SELECT
		pr_phone_number
	FROM
		pr_phone
	WHERE
		pr_phone.pr_persona_id = '".$agentId."'
		AND pr_default_yn = 1
", 4);
if($agentTel == "0") { $agentTel = ""; }
$GLOBALS[$form]->AddField("phone_number","phone_number",$agentTel,1);
$GLOBALS[$form]->AddField("old_phone_number","old_phone_number",$agentTel,1);

$aFax = $GLOBALS['lDB']->get("
	SELECT
		pr_phone_number
	FROM
		pr_phone
	WHERE
		pr_phone.pr_persona_id = '".$agentId."'
		AND rf_phone_type_id = 'RS1'
", 4);
if($aFax == "0") { $aFax = ""; }
$GLOBALS[$form]->AddField("fax_number","fax_number",$aFax,1);
$GLOBALS[$form]->AddField("old_fax_number","old_fax_number",$aFax,1);

$agentDetails = $GLOBALS['lDB']->get("
	SELECT
		pr_agent_commission_perc as aComm,
		pr_agent_comm_deduct_yn as deductComm,
		ac_pay_plan_id as payPlanId,
		pr_agent_note_open as aNote,
		pr_agent_account as aAccount
	FROM
		pr_agent
	WHERE
		pr_agent_id = '".$agentId."'
",2);

$aComm = $agentDetails[0][0];
$GLOBALS[$form]->AddField("pr_agent_account","pr_agent_account",$agentDetails[0]['aAccount'],1);
$GLOBALS['pr_agent_account']->Width = "200";
$GLOBALS[$form]->AddField("pr_agent_commission_perc","pr_agent_commission_perc",$agentDetails[0]['aComm'],1);
$GLOBALS['pr_agent_commission_perc']->Width = "50";
$GLOBALS[$form]->AddField("pr_agent_comm_deduct_yn","pr_agent_comm_deduct_yn",$agentDetails[0]['deductComm'],3);
$GLOBALS['pr_agent_comm_deduct_yn']->Select = array("0:|:Gross","1:|:Nett");
$GLOBALS['pr_agent_comm_deduct_yn']->Width = "50";
$GLOBALS[$form]->AddField("ac_pay_plan_id","ac_pay_plan_id",$agentDetails[0]['payPlanId'],3);
$GLOBALS['ac_pay_plan_id']->Select = combolist($GLOBALS['lDB'],"select ac_pay_plan_ix,ac_pay_plan_desc from ac_pay_plan order by ac_pay_plan_desc","0:|:");
$GLOBALS['ac_pay_plan_id']->Width = "200";
$GLOBALS[$form]->AddField("pr_agent_note_open","pr_agent_note_open",$agentDetails[0]['aNote'],5);
$GLOBALS['pr_agent_note_open']->Width = "285";
$GLOBALS['pr_agent_note_open']->Rows = "5";

$agentRates = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_desc as rateDesc,
		rf_currency.rf_currency_symbol as curr
	FROM
		pr_agent_rate
		INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		pr_agent_rate.pr_agent_id = '$agentId'
	ORDER BY
		rt_rate_type.rt_rate_type_desc
",2);

$aRates = "";
foreach($agentRates as $rateItem) {
	$aRates .= "$rateItem[rateDesc] ($rateItem[curr])\n";
}
$GLOBALS[$form]->AddField("rate_types","rate_types",$aRates,5);
$GLOBALS['rate_types']->Width = "285";
$GLOBALS['rate_types']->Rows = "5";

          
$linkUsers = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		pr_persona.pr_name_last as nameLast,
		pr_persona.pr_name_first as nameFirst,
		pr_link.pr_link_from as linkedId,
		IF(pr_agent.pr_agent_id = pr_link.pr_link_from,'1','0') as isAgent,
		IF(pr_user.pr_user_id = pr_link.pr_link_from,'1','0') as isUser,
		IF(pr_guest.pr_guest_id = pr_link.pr_link_from,'1','0') as isGuest
	FROM
		pr_link
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from            
		LEFT JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
			AND pr_agent.pr_agent_inactive_yn = 0
		LEFT JOIN pr_user ON pr_user.pr_user_id = pr_persona.pr_persona_ix
			AND pr_user.pr_user_inactive_yn = 0
		LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix            
	WHERE
		pr_link.pr_link_to = '".$agentId."'
	ORDER BY
		pr_persona.pr_name_last
",2);

$linkSize = sizeof($linkUsers);
$aLink = "";
foreach($linkUsers as $user) {
	$aRole = "";
	if($user['isAgent'] == "1") { $aRole .= "Agent"; }
	if($user['isUser'] == "1") {
		if($aRole != "") { $aRole .= ", User"; } else {	$aRole .= "User"; }  
	}        
	if($user['isGuest'] == "1") {
		if($aRole != "") { $aRole .= ", Guest"; } else { $aRole .= "Guest";	}  
	}
	if($aRole != "") { $aRole = " (".$aRole.")"; }             
	$aLink = trim($user['nameFirst']." ".$user['nameLast']) . $aRole . "\n";	
}

$GLOBALS[$form]->AddField("linked_users","linked_users",$aLink,5);
$GLOBALS['linked_users']->Width = "285";
$GLOBALS['linked_users']->Rows = "5";

$hidelist = array('old_phone_number','old_fax_number');
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array('rate_types','linked_users');
$GLOBALS[$form]->Disable($disablelist);


switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['popuphide'] = " style=\"visibility:hidden\"";
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = "752+$record+$agentName+$saveSession+$contactId";
	$GLOBALS['mode'] = "edit";
	break;
}

$GLOBALS['temp']['record'] = $record;

// Start Access Control Toolbar Setup
$edit = 751;
$sedit = 752; 
$view = 683;

$pgJOBS = array();
$save = "";
if (checkJob($view)) { $pgJOBS['view'] = "1"; } else { $pgJOBS['view'] = "0"; }
if (checkJob($edit)) { $save = "allowSave"; $pgJOBS['edit'] = "1"; } else { $pgJOBS['edit'] = "0"; }
if($save != ""){
	$GLOBALS['temp']['allowSave'] = "";  
} else {
	$GLOBALS['temp']['allowSave'] = "collapse printCollapse";  
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") { $pgJOBS['save'] = "1"; }
if ($action == "2" || $action == "4") { $pgJOBS['edit'] = "0"; }
if ($action == "3") { $pgJOBS['edit'] = $pgJOBS['view']; }

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"$pgJOBS[del]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">\n";

// End Access Control Toolbar Setup


if(isset($_POST['saveCloseYN']) && $_POST['saveCloseYN'] == "1") {
	//Reloading the calendar makes it loose the chosen agent - maybe we can get around this by settings the agent session var?
	//$_SESSION['calAgentId'] = $record; // This doesn't seem to have the desired effect
	if($saveSession == "1") {
		//echo "<script language=\"javascript\">window.opener.location = 'reservation.php?20++++$record++$contactId'; window.close();</script>";
		echo "<script language=\"javascript\">window.close();</script>";
	} else if ($saveSession == "2") {
		echo "<script language=\"javascript\">window.opener.location = 'reservation.php?693++++$record++$contactId'; window.close();</script>";
	}else {	
		echo "<script language=\"javascript\">window.opener.location = window.opener.location; window.close();</script>";  
	}
}      
