<?php

/**
 * init.form251.php - Different configurations popup
 * Job: 684
 * Function: 50 (Availability calendar)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/cal_roomnumNEW2.htm");
}

$GLOBALS['temp']['title'] = "Different Configurations";
$GLOBALS['temp']['goFunction'] = "makeBooking";
$GLOBALS['temp']['userStatusId'] = $userStatusId;

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$itemList = explode(":",$_SERVER['argv'][1]);
$itinerary_status = $_SERVER['argv'][2];		// new or edit
if(empty($itinerary_status)) {
	$itinerary_status = "edit";
}
$forceDefault = ($_SERVER['argv'][3] == "1" ? true : false);

if($itinerary_status == "commission") {
	$rt_rate_type_id = $_SERVER['argv'][3];
	if(!db_rt_rate_type_exists($rt_rate_type_id)) {
		$rt_rate_type_id = false;
	}

	$itemData = $lDB->get("
		SELECT
			rv_reservation.rv_agent_id,
			rt_rate_type.rf_currency_id,
			rv_reservation_item.pr_business_id	
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '" . $lDB->escape($itemList[0]) . "'
	",1);

	$agentTerms = getAgentPropertyTerms($itemData['rv_agent_id'], $itemData['rf_currency_id'], $itemData['pr_business_id'], $rt_rate_type_id);
	echo json_encode($agentTerms['rv_commission_perc']);
	die();
}

$GLOBALS['temp']['itinerary_status'] = $itinerary_status;

$sql = "
	SELECT
		rv_reservation_item.rv_reservation_item_ix as rvItemId,
		rv_reservation_item.ac_accomm_type_id as acAccommId,
		rv_reservation_item.rv_item_date_arrive as rvItemArrive,
		rv_reservation_item.rv_item_date_depart as rvItemDepart,
		rv_reservation_item.rv_item_accomm_count as numRooms,
		rv_reservation_item.rv_item_adult_count as numAdults,
		rv_reservation_item.rv_item_child_count as numChildren,
		rv_reservation.rv_agent_id,
		rv_reservation_item.rt_rate_type_id,
		rt_rate_type.rf_currency_id,
		rv_reservation_item.rv_item_comm_perc,
		rv_reservation_item.pr_business_id
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id
	WHERE
		rv_reservation_item.rv_reservation_item_ix IN ('".join("','",$itemList)."')
	ORDER BY
		rv_item_date_arrive
";
$itemListData = $lDB->get($sql,2);
$imax = sizeof($itemListData);

$rateId = $itemListData[0]['rt_rate_type_id'];

// Only internal users with financial tab update access may edit commission
$allowCommission = ($GLOBALS['userStatusId'] > 1 && isset($GLOBALS['jobLevelArray'][646]) && $GLOBALS['jobLevelArray'][646] > 5);

$hasAgent = false;
$GLOBALS['temp']['restoreDefaultsCollapse'] = "collapse";
if( $lDB->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '" . $itemListData[0]['rv_agent_id'] . "'",4) > 0 ) {
	$hasAgent = true;
	if($allowCommission) {
		$GLOBALS['temp']['restoreDefaultsCollapse'] = "";
	}
}

$commissionDisabled = "";
$commissionValue = "";
if($forceDefault) {
	$agentTerms = getAgentPropertyTerms($itemListData[0]['rv_agent_id'], $itemListData[0]['rf_currency_id'], $itemListData[0]['pr_business_id']);
	$rateId = $agentTerms['rt_rate_type_id'];
	$commissionValue = $agentTerms['rv_commission_perc'];
} else {
	$commissionValue = $itemListData[0]['rv_item_comm_perc'];
}
if(!$allowCommission) {
	$commissionDisabled = "disabled";
}
$GLOBALS['temp']['commissionDisabled'] = $commissionDisabled;
$GLOBALS['temp']['commissionValue'] = $commissionValue;

$accommId = $itemListData[0]['acAccommId'];
$GLOBALS['temp']['accommId'] = $accommId;

$accommData = $lDB->get("select ac_accomm_desc, pr_business_id, ac_accomm_max_adults from ac_accomm_type where ac_accomm_type_ix = '$accommId'",1);
$GLOBALS['temp']['adultLimit'] = $accommData['ac_accomm_max_adults'];
$accommName = $accommData['ac_accomm_desc'];
$propName = $lDB->get("select pr_name_last from pr_persona where pr_persona_ix = '".$accommData['pr_business_id']."'",4);
$GLOBALS['temp']['propAccommName'] = $propName.", ".$accommName;

$numRooms = $itemListData[0]['numRooms'];
$GLOBALS['temp']['numRooms'] = $numRooms;

$GLOBALS['temp']['sDate'] = $itemListData[0]['rvItemArrive'];
$GLOBALS['temp']['dateArrive'] = chng_date($itemListData[0]['rvItemArrive'],"-");

$itemList = "";
$departDate = "";
for ($i=0;$i<$imax;$i++) {
	$itemData = $itemListData[$i];
	if (
		$i == 0
		|| (
			$itemData['numRooms'] == $numRooms
			&& $itemData['acAccommId'] == $accommId
		)
	) {
		if ($itemList != "") {
			$itemList .= ":";
		}
		$itemList .= $itemData['rvItemId'];
		$departDate = $itemData['rvItemDepart'];
	}
}

$GLOBALS['temp']['eDate'] = $departDate;
$GLOBALS['temp']['dateDepart'] = chng_date($departDate,"-");

$GLOBALS['temp']['numNights'] = dateSubtract($departDate,$itemListData[0]['rvItemArrive']);

$GLOBALS['temp']['itemList'] = $itemList;
$item = explode(":",$itemList);
$itemId = $item[0];
$optionalAbbrvs = $lDB->get("
	SELECT 
		rt_component.rt_component_abbrv 
	FROM 
		rv_res_item_comp 
		INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
	WHERE 
		rv_item_comp_option_yn = '1' AND rv_reservation_item_id = '".$itemId."'",3);
$GLOBALS['temp']['optDesc'] = join(",",$optionalAbbrvs);
$optionalIds = $lDB->get("
	SELECT 
		rv_res_item_comp.rt_component_id
	FROM 
		rv_res_item_comp 
		INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
	WHERE 
		rv_item_comp_option_yn = '1' AND rv_reservation_item_id = '".$itemId."'",3);
$GLOBALS['temp']['optionalIds'] = join(":",$optionalIds);

$GLOBALS['temp']['agentId'] = $itemListData[0]['rv_agent_id'];
$GLOBALS['temp']['currencyId'] = $itemListData[0]['rf_currency_id'];


if(trim($rateId) == "" || $rateId == "0") {
	$rateId = $GLOBALS['lDB']->get("
		SELECT
			pr_agent_rate.rt_rate_type_id
		FROM
			pr_agent_rate
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
		WHERE
			pr_agent_id = '$calAgentId'
		ORDER BY
			pr_agent_rate_default_yn DESC,
			rt_rate_type.rt_rate_type_desc ASC
	",4);
	if(trim($rateId) == "" || $rateId == "0") {
		$rateId = $GLOBALS['lDB']->get("select rt_rate_type_id from rf_default", 4);
	}
}
$rateInfo = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_ix = '$rateId'
",1);

$GLOBALS['temp']['rateSelect'] = "
	<input type=\"text\" disabled id=\"rateSelectLabel\" value=\"".t_encodeHTMLField($rateInfo["rt_rate_type_desc"] . ", " . $rateInfo["rf_currency_symbol"])."\" class=\"uk-input\">
	<input type=\"hidden\" id=\"rateSelect\" value=\"$rateId\">";
	

// Get existing item rate groups
$itemRateGroups = $GLOBALS['lDB']->get("
					SELECT 
						rt_rate_group.rt_rate_group_ix,
						rt_rate_group.rt_rate_group_desc,
						rt_rate_group.rt_rate_group_abbrv,
						rt_rate_group.rt_rate_group_sys_code,
						rv_res_item_rate_grp.rv_res_item_rate_grp_count AS qty
					FROM
						rv_res_item_rate_grp
						INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
					WHERE
						rv_res_item_rate_grp.rv_reservation_item_id  = '".$itemId."'	
",2);	
	
$rate = new Rate($accommId,$itemListData[0]['rvItemArrive'],$departDate,$itemRateGroups,$rateId);

// 2011-10-09 - Disabling for now
// Use rate override level if we don't already have a saved one
// if ($oridelevel == ""){
	// $oridelevel = $rate->Periods[0]['rt_rate_overide_level_ind'];
// }

// switch($oridelevel){
	// case 1:
		// $GLOBALS['temp']['personOrideSelected'] = "selected";
		// $orideRateGroupHide  = "";
		// $orideUnitStayHide = " style=\"display:none\"";
		// $oridelevelname = "person";
		// break;
	// case 2:
		// $GLOBALS['temp']['unitOrideSelected'] = "selected";
		// $orideRateGroupHide  = " style=\"display:none\"";
		// $orideUnitStayHide = "";
		// $oridelevelname = "unit";
		// break;
	// case 3:
		// $GLOBALS['temp']['stayOrideSelected'] = "selected";
		// $orideRateGroupHide = " style=\"display:none\"";
		// $orideUnitStayHide = "";
		// $oridelevelname = "stay";
		// break;
// }

$rateGroupHTML = "";
foreach ($rate->RateGroups as $rateGroup){
	if ($rateGroup['rt_rate_group_sys_code'] != "1"){
	
		if ($rateGroup['rt_rate_group_class'] == "1"){
			$adultRateGroups[] = "'".$rateGroup['rt_rate_group_ix']."'";
		}
	
		$rateGroupHTML  .= "
		<div class=\"uk-child-width-expand\" uk-grid>
			<div class=\"uk-width-1-3 align-m\">
				".$rateGroup['rt_rate_group_desc']." per room
			</div>
			<div class=\"uk-flex\">
				<input id=\"RateGroupQty_".$rateGroup['rt_rate_group_ix']."\" name=\"RateGroupQty_".$rateGroup['rt_rate_group_ix']."\" type=\"text\" class=\"txtr\" size=\"4\" value=\"".$rateGroup['qty']."\" />
				<input name=\"RateGroupAbbrv_".$rateGroup['rt_rate_group_ix']."\" type=\"hidden\" id=\"RateGroupAbbrv_".$rateGroup['rt_rate_group_ix']."\" class=\"txtr\" value=\"".$rateGroup['rt_rate_group_abbrv']."\" />
			</div>
		</div>
		";	
	}
		
}

$GLOBALS['temp']['adultRateGroups'] = "var adultRateGroups = [".join($adultRateGroups,",")."];";
$GLOBALS['temp']['rateGroupHTML'] = $rateGroupHTML;

