<?php

/**
 * init.form252.php - Generic note popup using on the billings tab, reservation requests and rooming
 */

if(!isset($GLOBALS[$form])) {
    $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/pay_note_pop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

$note = $_SERVER['argv'][1];
$noteName = urldecode($_SERVER['argv'][2]);
$noteType = $_SERVER['argv'][3];
switch($noteType) {
    case 1: // Guest note
        $guestId = $_SERVER['argv'][4];
        $note = t_encodeHTML($GLOBALS['lDB']->get("
			SELECT
				pr_guest_note
			FROM
				pr_guest
			WHERE
				pr_guest_id = '$guestId'
		",4));
        $noteName = "Guest note";
        break;
    case 2: // Guest memo
        $guestId = $_SERVER['argv'][4];
        $note = t_encodeHTML($GLOBALS['lDB']->get("
			SELECT
				pr_guest_memo
			FROM
				pr_guest
			WHERE
				pr_guest_id = '$guestId'
		",4));
        $noteName = "Guest internal memo";
        break;
    case 3: // Extra note
        $extraId = $_SERVER['argv'][4];
        $note = t_encodeHTML($GLOBALS['lDB']->get("
			SELECT
				rv_extra_note
			FROM
				rv_extra
			WHERE
				rv_extra_ix = '$extraId'
		",4));
        $noteName = "Extra note";
        break;
    case 4: // Extra memo
        $extraId = $_SERVER['argv'][4];
        $note = t_encodeHTML($GLOBALS['lDB']->get("
			SELECT
				rv_extra_note_internal
			FROM
				rv_extra
			WHERE
				rv_extra_ix = '$extraId'
		",4));
        $noteName = "Extra internal note";
        break;
    case 5: // Contact details
        $resId = $_SERVER['argv'][4];
        $resInfo = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation.rv_agent_id,
				rv_reservation.rv_corr_persona_id,
				rv_reservation.rv_billing_persona_id
			FROM
				rv_reservation
			WHERE
				rv_reservation_ix = '$resId'
		",1);
        $agentInfo = getPersonaDetail($resInfo['rv_agent_id']);
        $contactInfo = getPersonaDetail($resInfo['rv_corr_persona_id']);
        $billingInfo = getPersonaDetail($resInfo['rv_billing_persona_id']);
        $note = "
			<span class=\"txtb\">Agent</span><br>
			Name: $agentInfo[name]<br>
			Telephone: $agentInfo[telephone]<br>
			Fax: $agentInfo[fax]<br>
			Email: <a class=\"imgLink\" onclick=\"openEmail('$agentInfo[email]','$resId');\">$agentInfo[email]</a><br>
			<br>
			<span class=\"txtb\">Contact</span><br>
			Name: $contactInfo[name]<br>
			Telephone: $contactInfo[telephone]<br>
			Fax: $contactInfo[fax]<br>
	  		Email: <a class=\"imgLink\" onclick=\"openEmail('$contactInfo[email]','$resId');\">$contactInfo[email]</a><br>
			<br>
			<span class=\"txtb\">Billing Contact</span><br>
			Name: $billingInfo[name]<br>
			Telephone: $billingInfo[telephone]<br>
			Fax: $billingInfo[fax]<br>
			Email: <a class=\"imgLink\" onclick=\"openEmail('$billingInfo[email]','$resId');\">$billingInfo[email]</a><br>
			<br>
		";
        $noteName = "Contact details";
        $GLOBALS['temp']['resId'] = $resId;
        break;
    case 6: // Financial details
        $resId = $_SERVER['argv'][4];
        $resInfo = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_name_last,
				pr_persona.pr_name_first,
				rv_reservation.rv_commission_deduct_yn,
				rv_reservation.rv_commission_perc,
				rv_reservation.rv_amt_paid,
				(rv_reservation.rv_amt_accomm_payable+rv_reservation.rv_amt_extra_payable+rv_reservation.rv_amt_travel_payable) as rv_amt_payable,
				rt_rate_type.rt_rate_type_desc
			FROM
				rv_reservation
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
				LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			WHERE
				rv_reservation_ix = '$resId'
		",1);
        $note = t_encodeHTML(
            "Agent " . trim($resInfo['pr_name_first'] . " " . $resInfo['pr_name_last']) . "\n" .
            "Rate Type: " . $resInfo['rt_rate_type_desc'] . "\n" .
            "Comm: " . $resInfo['rv_commission_perc'] . "%\n".
            "Deduct Comm: " . ($resInfo['rv_commission_deduct_yn']==1?"Yes":"No") . "\n" .
            "Total Due: " . $resInfo['rv_amt_payable'] . "\n".
            "Total Payed: " . $resInfo['rv_amt_paid']
        );
        $noteName = "Financials";
        break;
    case 7: // Guest notes
        $reservationId = $_SERVER['argv'][4];
        $note = t_encodeHTML($GLOBALS['lDB']->get("
			SELECT
				rv_note_guests
			FROM
				rv_note
			WHERE
				rv_reservation_id = '{$reservationId}'
            ORDER BY
                rv_note.ad_create_date DESC
		",4));
        $noteName = "Guest notes";
        break;
    case 8: // Internal Memo
        $reservationId = $_SERVER['argv'][4];
        $note = t_encodeHTML($GLOBALS['lDB']->get("
			SELECT
				rv_note_internal
			FROM
				rv_note
			WHERE
				rv_reservation_id = '{$reservationId}'
            ORDER BY 
                rv_note.ad_create_date DESC
		",4));

        $noteName = "Internal Memos";
        break;
    case 9: // Reservation Notes
        $reservationId = $_SERVER['argv'][4];
        $note = t_encodeHTML($GLOBALS['lDB']->get("
			SELECT
				rv_note_general
			FROM
				rv_note
			WHERE
				rv_reservation_id = '{$reservationId}'
            ORDER BY 
                rv_note.ad_create_date DESC
            
		",4));
        $noteName = "Reservation notes";
        break;
    default: // Note in argv[1] - this needs to be changed since long note >4k will not fit in the url
        $note = urldecode($note);
        break;
}

if(isset($_POST['note']) && $_POST['note']) {
    $note = $_POST['note'];
}
if(isset($_POST['noteName']) && $_POST['noteName']) {
    $noteName = $_POST['noteName'];
}

$GLOBALS['temp']['note'] = $note;
$GLOBALS['temp']['noteName'] = $noteName;

function getPersonaFax($personaId) {
    $fax = $GLOBALS['lDB']->get("
	  SELECT
		 pr_phone.pr_phone_number
	  FROM
		 pr_phone, rf_phone_type
	  WHERE
		 pr_phone.pr_persona_id = '$personaId'
		 AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
		 AND rf_phone_type.rf_phone_type_sys_code = '1'",4);
    if(trim($fax) == "" || $fax == "0") {
        $fax = "";
    }
    return $fax;
}

function getPersonaTelephone($personaId) {
    $tel = $GLOBALS['lDB']->get("
	  SELECT
		 pr_phone.pr_phone_number
	  FROM
		 pr_phone
	  WHERE
		 pr_phone.pr_persona_id = '$personaId'
		 AND pr_phone.pr_default_yn = '1'",4);
    if(trim($tel) == "" || $tel == "0") {
        $tel = "";
    }
    return $tel;
}

function getPersonaDetail($personaId) {
    $detail = $GLOBALS['lDB']->get("
	  SELECT
		 pr_persona.pr_name_first,
		 pr_persona.pr_name_second,
		 pr_persona.pr_name_last,
		 pr_persona.pr_email
	  FROM
		 pr_persona
	  WHERE
		 pr_persona.pr_persona_ix = '".$personaId."'",2);
    if (count($detail) > 0){
        $detail = $detail[0];
        $name = "";
        if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
            $name .= $detail['pr_name_first'] . " ";
        }
        if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
            $name .= $detail['pr_name_second'] . " ";
        }
        if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
            $name .= $detail['pr_name_last'] . " ";
        }
        $result = array();
        $result['name'] = trim($name);
        $result['fax'] = getPersonaFax($personaId);
        $result['telephone'] = getPersonaTelephone($personaId);
        $result['email'] = $detail['pr_email'];
        if(trim($result['email']) == "" || $result['email'] == "0") {
            $result['email'] = "";
        }

    } else {
        $result = array();
        $result['name'] = "";
        $result['fax'] = "";
        $result['telephone'] = "";
        $result['email'] = "";
    }

    return $result;
}