<?php

/**
 * init.form253.php - General report form
 * Job: 201
 *
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],50,"");
$resRows = "";
$dateRangeSQL = "";

switch($_SERVER['argv'][0]) {
case 201:
	$pf_object_id = db_pf_object_by_name("standard_report");
	break;
case 202:
	$pf_object_id = db_pf_object_by_name("arrDep_report");
	break;
case 203:
	$pf_object_id = db_pf_object_by_name("consultant_report");
	break;
case 204:
	$pf_object_id = db_pf_object_by_name("provisional_report");
	break;
case 205:
	$pf_object_id = db_pf_object_by_name("update_report");
	break;
}

processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

$GLOBALS['temp']['agentFolioCheck'] = "";
$GLOBALS['temp']['allFolioCheck'] = "checked";
// Parameter list -------------------------------------------------------------
$reportOptions = array_slice($_SERVER['argv'],10,10); // argv[10] -> argv[19] for report specific options
$advancedForm = $reportOptions[0];
$includeDetail = $reportOptions[1];
$inclTravRes = $reportOptions[4];
$inclRoomList = $reportOptions[6];

if ( $reportOptions[5] == "1" ) {
	$onlyTBA = true;
} else {
	$onlyTBA = false;
}

$GLOBALS['showTime'] = false;

if ( $_SESSION['server'] != "blackmax" ) {
	$GLOBALS['showTime'] = false;
}

if ( $GLOBALS['showTime'] ) {
	$GLOBALS['timeStart'] = getmicrotime();
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/report.htm");
}

global $resScrollSet;
$resScrollSet = array();

$updateNew = false;
$updateAmended = false;

// Hide the Financial report button. Only show on specified reports -----------
$showFinancialReportButton = false;
$showProvExpiryDateOptions = false;

global $report;
switch($_SERVER['argv'][0]) {
case 201:
	$report = "standard";
	$reportLabel = "Standard Report";
	$showFinancialReportButton = true;
	break;
case 202:
	$report = "arr/dep";
	$reportLabel = "Arrivals / Departures";
	break;
case 203:
	$report = "consultant";
	$reportLabel = "Consultant Report";
	$showFinancialReportButton = true;
	break;
case 204:
	$report = "provisional";
	$reportLabel = "Provisional Expiry Report";
	$showFinancialReportButton = true;
	$showProvExpiryDateOptions = true;
	break;
case 205:
	$report = "update";
	$reportLabel = "Reservation Update Report";
	
	$updateNew = false;
	$updateAmended = false;
	
	if ( $reportOptions[2] == "1" ) {
		$updateNew = true;
	}
	
	if ( $reportOptions[3] == "1" ) {
		$updateAmended = true;
	}
	
	if ( !$updateNew && !$updateAmended && $_SERVER['argc'] > 1 ) {
		$updateNew = true;
		$updateAmended = true;
	}
	$showFinancialReportButton = true;	
	break;
default:
	$report = "unknown";
	break;
}
if(trim($title) !="") {
	$reportLabel = $title;
}

if ( $userStatusId < 2 || $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] < 15) {
	$showFinancialReportButton = false;
}

if ( $showFinancialReportButton ) {
	$GLOBALS['temp']['showFinButton'] = "";
} else {
	$GLOBALS['temp']['showFinButton'] = "collapse printCollapse";
}

if ( $showProvExpiryDateOptions ) {
	$GLOBALS['temp']['showProvExpiryDateOptions'] = "";
} else {
	$GLOBALS['temp']['showProvExpiryDateOptions'] = "collapse printCollapse";
}

$fromD = $_SERVER['argv'][1];
$toD = $_SERVER['argv'][2];

switch($fromD) {
case "all":
	$fromDate = "All";
	$toDate = "All";
	$tmpDate = date("Y-m-d");
	$tmpArray = explode("-",$tmpDate);

	$GLOBALS['temp']['fromY']	= $tmpArray[0];
	$GLOBALS['temp']['fromM']	= $tmpArray[1];
	$GLOBALS['temp']['fromD']	= $tmpArray[2];
	$GLOBALS['temp']['toY']		= $tmpArray[0];
	$GLOBALS['temp']['toM']		= $tmpArray[1];
	$GLOBALS['temp']['toD']		= $tmpArray[2];
	break;
case "today":
	$fromDate = useDate("from","");
	$toDate = useDate("to","");
	break;
case "todayplus":
	if($toD == "") {
		$toD = "0";
	}
	$fromDate = useDate("from","");
	$toDate = useDate("to",date("Y-m-d",mktime (0,0,0,date("m") ,date("d")+$toD,date("Y"))));
	break;
case "upToPlus":
	if($toD == "") {
		$toD = "0";
	}
	$fromDate = useDate("from", "0000-00-00");
	$toDate = useDate("to",date("Y-m-d",mktime (0,0,0,date("m") ,date("d")+$toD,date("Y"))));
	break;
case "single":
	$report = "single";
	$reportLabel = "Detailed Report";
	$reportSingle = $toD;
	$reportSingle = explode(":",$reportSingle);
	$fromDate = "";
	break;
default:
	$fromDate = useDate("from", $fromD);
	$toDate = useDate("to", $toD);
	break;
}
if($_SERVER['argc'] < 2 && trim($_SERVER['argv'][3]) == "") {
	$_SERVER['argv'][3] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}

// Added for accommodation access control -------------------------------------
$accommList = $lDB->get("
	SELECT
		sc_accomm.ac_accomm_type_id
	FROM
		sc_accomm
		INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id
	WHERE
		sc_user.pr_user_id = '" . $GLOBALS['userid'] . "'
",3);

$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);


$statusACL = $lDB->get("
	SELECT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id <> 25
	AND 
		rf_reservation_status_id <> 15
	AND 
		rf_reservation_status_id <> 97
",3);

$accommFilter = useFilter("accomm",$_SERVER['argv'][3],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

$propertyACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		sc_accomm
	INNER JOIN ac_accomm_type ON 
		ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
	INNER JOIN pr_business ON 
		pr_business.pr_business_id = ac_accomm_type.pr_business_id
	INNER JOIN pr_persona ON 
		pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
	AND 
		ac_accomm_type.ac_accomm_type_inactive_yn = 0
",3);

$propertyIds = join(":",$lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		ac_accomm_type
	WHERE
		ac_accomm_type.ac_accomm_type_ix IN ('".join("','",explode(":",$accommFilter['ids']))."')
",3));
$propertyFilter = useFilter("properties",$propertyIds,"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","ac_accomm_type.pr_business_id",$propertyACL,false,false);

$statusFilter = useFilter("status",$_SERVER['argv'][4],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);

$agentACL = false;

if ( $userStatusId < 2 ) {
	$agentACL = array($calAgentId);
}

$agentFilter = useFilter("agent",$_SERVER['argv'][5],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");

$contactFilter = useFilter("contact",$_SERVER['argv'][35],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_corr_persona_id",false,"No contact","0");

$consultantFilter = useFilter("consultant",$_SERVER['argv'][6],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");

$createdByFilter = useFilter("createdBy",$_SERVER['argv'][46],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.pr_reservation_user_id",false,"No created by","0");

$originatorFilter = useFilter("originator",$_SERVER['argv'][20],"SELECT pr_persona.pr_name_first, pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_origin_agent_id",false,"No originator","0");

$sourceFilter = useFilter("source",$_SERVER['argv'][21],"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =","rv_reservation.rf_source_ix",false,"No Source","0");

$nationalityFilter = useFilter("nationality",$_SERVER['argv'][22],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","rv_reservation.rf_country_id",false,"No nationality","0");

$rateFilter = useFilter("rate",$_SERVER['argv'][23],"SELECT rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix =","rv_reservation.rt_rate_type_id",false,false,false);

// Country Filter -------------------------------------------------------------
$postCountry = $_SERVER['argv'][24];
$physCountry = $_SERVER['argv'][45];

if ( $_SERVER['argv'][25] == "none" ) {
	$agentPostCountryFilter['names'] = 'None';
	$agentPostCountryFilter['where'] = "
		AND (
			pr_persona.pr_corr_country_id IS NULL
			OR pr_persona.pr_corr_country_id = ''
			OR pr_persona.pr_corr_country_id = '0'
		)
	";
	$GLOBALS['temp']['agentPostCountryIds'] = "<input type=hidden id='agentPostCountryIds' value='none'>";
	$GLOBALS['temp']['agentPostCountryNames'] = "None";
} else {
	$agentPostCountryFilter = useFilter("agentPostCountry",$_SERVER['argv'][25],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","agent_persona.pr_corr_country_id",false,false,false);
}

if ( $_SERVER['argv'][26] == "none" ) {
	$agentPhysCountryFilter['names'] = 'None';
	$agentPhysCountryFilter['where'] = "
		AND (
			pr_persona.pr_phys_country_id IS NULL
			OR pr_persona.pr_phys_country_id = ''
			OR pr_persona.pr_phys_country_id = '0'
		)
	";
	$GLOBALS['temp']['agentPhysCountryIds'] = "<input type=hidden id='agentPhysCountryIds' value='none'>";
	$GLOBALS['temp']['agentPhysCountryNames'] = "None";
} else {
	$agentPhysCountryFilter = useFilter("agentPhysCountry",$_SERVER['argv'][26],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","agent_persona.pr_phys_country_id",false,false,false);
}

if ( $postCountry == "1" ){
	$agentPhysCountryFilter['where'] = "";
} else {
	$agentPostCountryFilter['where'] = "";
}

$postal = explode(":",$_SERVER['argv'][25]);
$countryList = Join("','",$postal);
$physical = explode(":",$_SERVER['argv'][26]);
$physCountryList = Join("','",$physical);

if ( $postCountry == "1" && $countryList != "" ) {
	if ( $countryList == "0" ){
		$countryList .= "','";
	}
	$GLOBALS['temp']['check_post'] = " checked";
}

if ( $physCountry == "1" && $physCountryList != "" ) {
	if ( $physCountryList == "0" ){
		$physCountryList .= "','";
	}
	$GLOBALS['temp']['check_phys'] = " checked";
}

if ( $postCountry == "0" && $physCountryList != "" ) {
	$GLOBALS['temp']['check_phys'] = " checked";
}

$cancelDate = $_SERVER['argv'][36];
$GLOBALS['temp']['cancelDateCheck'] = "";
if($cancelDate == "1") {
	$GLOBALS['temp']['cancelDateCheck'] = "checked";
}

$cancelFromDate = useDate("cancelFrom",$_SERVER['argv'][37]);
$cancelToDate = useDate("cancelTo",$_SERVER['argv'][38]);

$travelDate = $_SERVER['argv'][39];
$GLOBALS['temp']['travelDateCheck'] = "";
if($travelDate == "1") {
	$GLOBALS['temp']['travelDateCheck'] = "checked";
}

$travelFromDate = useDate("travelFrom",$_SERVER['argv'][40]);
$travelToDate = useDate("travelTo",$_SERVER['argv'][41]);

$propertyDetail = $_SERVER['argv'][42];
$GLOBALS['temp']['propertyDetailCheck'] = "";
if($propertyDetail == "1") {
	$GLOBALS['temp']['propertyDetailCheck'] = "checked";
}

$nonPropertyDetail = $_SERVER['argv'][43];
$GLOBALS['temp']['nonPropertyDetailCheck'] = "";
if($nonPropertyDetail == "1") {
	$GLOBALS['temp']['nonPropertyDetailCheck'] = "checked";
}

$createDate = $_SERVER['argv'][47];
$GLOBALS['temp']['createDateCheck'] = "";
if($createDate == "1") {
	$GLOBALS['temp']['createDateCheck'] = "checked";
}

$amendDate = $_SERVER['argv'][48];
$GLOBALS['temp']['amendDateCheck'] = "";
if($amendDate == "1") {
	$GLOBALS['temp']['amendDateCheck'] = "checked";
}

$provDate = $_SERVER['argv'][49];
$GLOBALS['temp']['provDateCheck'] = "";
if($provDate == "1") {
	$GLOBALS['temp']['provDateCheck'] = "checked";
}


$page			= $_SERVER['argv'][7];
$perPage	= $_SERVER['argv'][8];
$options	= $_SERVER['argv'][9];

// $options & 33554432 - Res Find structure
define("REP_STYLE_LIST",512);
define("REP_STYLE_ITEM",33554432);
define("REP_STYLE_FINANCIAL",67108864);

if ( empty($perPage) && $options != "" ) {
	if ( $options & REP_STYLE_LIST ) {
		$perPage = "20";
	} else if ( $options & REP_STYLE_ITEM ) {
		$perPage = "30";
	} else {
		$perPage = "1";
	}
}

define("REP_BUTTON_CONTACT_INFO",8);
define("REP_BUTTON_RESERVATION_NOTES",16);
define("REP_BUTTON_GUEST_INFO",32);
define("REP_BUTTON_EXTRA_NOTES",64);
define("REP_BUTTON_TRAVEL_NOTES",128);
define("REP_BUTTON_INTERNAL_NOTES",256);

// 512 is the list report
define("REP_BUTTON_AUDIT",1024);
define("REP_BUTTON_CANCEL_NOTES",2048);
define("REP_BUTTON_COMPONENTS",4096);
define("REP_BUTTON_EXCHANGE_RATES",8192);
define("REP_BUTTON_ROOMING",16384);
define("REP_BUTTON_GUEST_NOTE",32768);
define("REP_BUTTON_GUEST_MEMO",65536);
define("REP_BUTTON_PAYMENT",131072);
define("REP_BUTTON_POST_ADDRESS",262144);

define("REP_COL_RES_NO",524288);
define("REP_COL_RES_NAME",1048576);
define("REP_COL_SRC",2097152);
define("REP_COL_CONSULT",4194304);
define("REP_COL_AGENT",8388608);
define("REP_COL_CONTACT",16777216);

if($page == 0 && ($options & REP_STYLE_LIST)) {
	// All columns are assumed to be visible if on the cover page
	$options |= REP_COL_RES_NO | REP_COL_RES_NAME | REP_COL_SRC | REP_COL_CONSULT | REP_COL_AGENT | REP_COL_CONTACT;
}

// 33554432 is the find report
// 67108864 is the financial report
define("REP_BUTTON_FINANCIAL",134217728);
define("REP_BUTTON_ITINERARY",268435456);
define("REP_BUTTON_PAYMENT_SUMMARY",536870912);
define("REP_BUTTON_DETAILS",1073741824);

// 0-4 Type (0=HTML, 1=PDF View, 2=PDF Email, 3=PDF Send, 4=CSV View)
// 8 Contact Info Button
// 16 Reservation Notes Button
// 32 Guest Info Button
// 64 Extra Notes
// 128 Travel Notes
// 256 Internal Notes
// 512 0=Detail View, 1=List View
// 1024 Audit notes
// 2048 Cancel notes
// 4096 Cost Components
// 8192 Exchange rates
// 16384 -- future
// ..etc..
// Report Options
// --------------
// Arr/Dep [0] = advanced options
// Arr/Dep [1] = show detail
// Updated [0] = advanced options
// Updated [1] = show detail
// Updated [2] = new check
// Updated [3] = amend check
// Updated [4] = Include travelled reservations
// Standard [5] = Show only TBA reservations

$sortBy = "8";
if ( trim($_SERVER['argv'][27]) != "" ) {
	$sortBy = $_SERVER['argv'][27];
}

$GLOBALS['temp']['sortby'] = $sortBy;

// Show Hide Options for Arr/Dep PDF in function arriveDepartSummaryListPDF()
$arrDepOptions = array_slice($_SERVER['argv'],29,4);
$arrDepResNum = $arrDepOptions[0];
$arrDepResName = $arrDepOptions[1];
$arrDepProp	= $arrDepOptions[2];
$arrDepAgent = $arrDepOptions[3];    

/*$resNum = $_SERVER['argv'][29];
$resName = $_SERVER['argv'][30];
$property	= $_SERVER['argv'][31];
$agent = $_SERVER['argv'][32];
$arrDepOptions = array($resNum, $resName, $property, $agent);*/
$randomId = $_SERVER['argv'][29];


// [START] : BUG #5484 --------------------------------------------------------
// Reports to hide filters by default
$filterStatus = $_SERVER['argv'][28];
$showHideButtonText = $_SERVER['argv'][34];

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = urldecode($showHideButtonText);

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// [ END ] : BUG #5484 --------------------------------------------------------

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "export";
	break;
}

if ( $fromDate == "All" ){
	$pdfDates = "";
}
if ( $fromDate != "All" && $fromDate != "" && isset($fromDate['htmlDate']) && isset($toDate['htmlDate'])) {
	$pdfDates = " from ". $fromDate['htmlDate'] . " to " . $toDate['htmlDate'];
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = $reportLabel . (isset($pdfDates) ? $pdfDates : "");
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~7) + 3;
		$arrDepOptions = join("+",array_slice($_SERVER['argv'],29,4));
	//$arrDepOptions = join("+",array("","","",""));
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,9))."+$newOptions+".join("+",array_slice($_SERVER['argv'],10,19))."+$arrDepOptions+".join("+",array_slice($_SERVER['argv'],33,14));

	$GLOBALS[$form]->FormHTML = str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$principalName = getContactFullName($principalId);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName']	= $principalInfo['name'];
	$GLOBALS['temp']['fax']				= $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel']	= $resOfficeInfo['telephone'];

	$userId = $_SESSION['userid'];

	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$userId."'
	",4);
	$GLOBALS['temp']['emailTo'] = "";
}

if($renderMode == "html") {
	flush();
	$startPage = 1;
	$table_width = 986;
	$GLOBALS['temp']['jobId']								= $_SERVER['argv'][0];
	$GLOBALS['temp']['reportLabel']					= $reportLabel;
	$GLOBALS['temp']['hasPDF']							= "true";
	$GLOBALS['temp']['accommFilter']			= "collapse";
	$GLOBALS['temp']['statusFilter']				= "collapse";
	$GLOBALS['temp']['sourceFilter']				= "collapse";
	$GLOBALS['temp']['agentFilter']					= "collapse";
	$GLOBALS['temp']['contactFilter']					= "collapse";
	$GLOBALS['temp']['consultantFilter']		= "collapse";
	$GLOBALS['temp']['createdByFilter'] = "collapse";
	$GLOBALS['temp']['originatorFilter']		= "collapse";
	$GLOBALS['temp']['nationalityFilter']		= "collapse";
	$GLOBALS['temp']['rateFilter']					= "collapse";
	$GLOBALS['temp']['countryFilter']				= "collapse";
	$GLOBALS['temp']['updateFilter']				= "collapse";
	$GLOBALS['temp']['advancedOptions']			= "colLt";
	$GLOBALS['temp']['advancedForm']				= "collapse printCollapse";
	$GLOBALS['temp']['inclTravRes']					= "collapse";
	$GLOBALS['temp']['inclTravResCheck']				= "";
	$GLOBALS['temp']['inclRoomList']				= "collapse";
	$GLOBALS['temp']['inclRoomListCheck']		=	"";
	$GLOBALS['temp']['hideRepBut']					= "";
	$GLOBALS['temp']['showRepBut']					= "collapse";
	$GLOBALS['temp']['exportClass']					= "button bExport";
	$GLOBALS['temp']['todayPlus']						= "";
	$GLOBALS['temp']['upToPlus']						= "";
	$GLOBALS['temp']['inclResDet']					= "collapse";
	$GLOBALS['temp']['exclResDet']					= "";
	$GLOBALS['temp']['inclResDetCheck']			= "";
	$GLOBALS['temp']['detailCheck']					= "";
	$GLOBALS['temp']['disableAll']					= "";
	$GLOBALS['temp']['noAll']								= "";
	$GLOBALS['temp']['internalNoteToggle']	= "collapse";
	$GLOBALS['temp']['componentToggle']			= "collapse";
	$GLOBALS['temp']['hideCreateHead']			= "outLt";
	$GLOBALS['temp']['hideCreate']					= "";
	$GLOBALS['temp']['hideAmendedHead']			= "outLt";
	$GLOBALS['temp']['hideAmended']					= "";
	$GLOBALS['temp']['hideProvHead']			= "outLt";
	$GLOBALS['temp']['hideProv']					= "";
	$GLOBALS['temp']['hideStatusHead']			= "outLt";
	$GLOBALS['temp']['hideStatus']					= "";
	$GLOBALS['temp']['expDateHead']					= "collapse printCollapse";
	$GLOBALS['temp']['expDate']							= "collapse printCollapse";
	$GLOBALS['temp']['summHide']						= "";
	$GLOBALS['temp']['onlyTBA']							= "collapse";
	$GLOBALS['temp']['onlyTBACheck']				= "";
	$GLOBALS['temp']['provRoomCheck'] = "collapse printCollapse";
	$GLOBALS['temp']['travelDateFilter'] = "collapse printCollapse";
	$GLOBALS['temp']['cancelDateFilter'] = "collapse printCollapse";
	$GLOBALS['temp']['table_width']			= $table_width;
	
	if ( $onlyTBA ) {
		$GLOBALS['temp']['onlyTBACheck']			= "checked";
	}
	
	$GLOBALS['temp']['chngProvHeader']						= "collapse printCollapse";
	$GLOBALS['temp']['chngProv']						= "collapse printCollapse";
	$GLOBALS['temp']['notify']							= "collapse printCollapse";
	
	// List of ids for provisional expiry date update ----------------------------
	$GLOBALS['temp']['fullResList']					= "";

	// Detail report -------------------------------------------------------------
	if ( !($options & REP_STYLE_LIST) && !($options & REP_STYLE_ITEM) && !($options & REP_STYLE_FINANCIAL) ) {
		$GLOBALS['temp']['showHideButtonClass']	= "button";
		$GLOBALS['temp']['reportStyle']					= "detail";
	} else { // List Report
		$GLOBALS['temp']['showHideButtonClass']	= "collapse";
		
		if ( $options & REP_STYLE_LIST ) {
			$GLOBALS['temp']['reportStyle'] = "list";
		} else if ( $options & REP_STYLE_ITEM) {
			$GLOBALS['temp']['reportStyle'] = "find";
		} else {
			$GLOBALS['temp']['reportStyle'] = "financial";
		}
	}

	$GLOBALS['temp']['emailPDF']						= "button bEmail"; 

	if ( $userStatusId > 1 ) {
		$GLOBALS['temp']['internalNoteToggle']	= "";
		$GLOBALS['temp']['componentToggle']			= "";
	}

	switch($report) {
	case "arr/dep":
		$GLOBALS['temp']['upToPlus']						= "collapse printCollapse";
		$GLOBALS['temp']['accommFilter']			= "colLt";
		$GLOBALS['temp']['nationalityFilter']		= "colLtt";

		if ( $reportOptions[0] == "0" ) {
			$GLOBALS['temp']['advancedForm']			= "collapse printCollapse";
		}

		$GLOBALS['temp']['inclRoomList']				= "colLtt";			 

		if ( $reportOptions[6] == "1" ) {
			$GLOBALS['temp']['inclRoomListCheck']	= "checked";
		}

		$GLOBALS['temp']['inclResDet']						= "colLtt";
		$GLOBALS['temp']['exclResDet']						= "collapse printCollapse";

		if ( $reportOptions[1] == "1" ) {
			$GLOBALS['temp']['detailCheck']				= "checked";
			$GLOBALS['temp']['showHideButtonClass']	= "button";
		} else {
			$GLOBALS['temp']['summHide']						= "visibility:hidden;";
			$GLOBALS['temp']['showHideButtonClass']	= "collapse printCollapse";
		}

		$GLOBALS['temp']['disableAll']						= "collapse printCollapse";
		$GLOBALS['temp']['noAll']									= "Date Range";
		$GLOBALS['temp']['hideRepBut']						= "collapse printCollapse";
		$GLOBALS['temp']['showRepBut']						= "";
		$GLOBALS['temp']['reportInfo']						= $GLOBALS['info_dir']."info_rep_arr.htm";
		$GLOBALS['temp']['exportClass']						= "collapse printCollapse";
		
		$startPage = 0;
		break;

	case "standard":
		$GLOBALS['temp']['upToPlus']						= "collapse printCollapse";
		$GLOBALS['temp']['accommFilter']			= "colLt";
		$GLOBALS['temp']['nationalityFilter']		= "colLtt";
		$GLOBALS['temp']['statusFilter']				= "colLt";
		
		if ( $userStatusId > 1 ) {
			$GLOBALS['temp']['sourceFilter']			= "colLtt";
		}
		$GLOBALS['temp']['agentFilter']					= "colLtt";
		$GLOBALS['temp']['contactFilter']					= "colLtt";
		$GLOBALS['temp']['consultantFilter']		= "colLtt";
		$GLOBALS['temp']['createdByFilter'] = "colLtt";
		
		if ( $userStatusId > 1 ) {
			$GLOBALS['temp']['originatorFilter']	= "colLtt";
		}
		
		$GLOBALS['temp']['rateFilter']					= "colLtt";
		$GLOBALS['temp']['countryFilter']				= "colLtt"; 
		$GLOBALS['temp']['reportInfo']					= $GLOBALS['info_dir']."info_res_report.htm";
		$GLOBALS['temp']['onlyTBA']							= "colLtt";

		if ( $reportOptions[0] == "0" ) {
			$GLOBALS['temp']['advancedForm']			= "collapse printCollapse";
		}
		$GLOBALS['temp']['cancelDateFilter'] = "colLtt";
		if(!($options & REP_STYLE_LIST) && !($options & REP_STYLE_ITEM) && !($options & REP_STYLE_FINANCIAL)) {
			$GLOBALS['temp']['exportClass']						= "collapse printCollapse";
		}
		break;

	case "consultant":
		$GLOBALS['temp']['accommFilter']		= "colLt";
		$GLOBALS['temp']['statusFilter']			= "colLt";
		$GLOBALS['temp']['consultantFilter']	= "colLtt";
		$GLOBALS['temp']['createdByFilter'] = "colLtt";
		$GLOBALS['temp']['todayPlus']					= "collapse printCollapse";
		$GLOBALS['temp']['upToPlus']					= "collapse printCollapse";
		$GLOBALS['temp']['reportInfo']				= $GLOBALS['info_dir']."info_rep_consultant.htm";
		$GLOBALS['temp']['advancedOptions']		= "colLt";
		$GLOBALS['temp']['advancedForm']			= "colLt";
		$GLOBALS['temp']['travelDateFilter'] = "colLtt";
		$GLOBALS['temp']['cancelDateFilter'] = "colLtt";

		if ( $reportOptions[0] == "0" ) {
			$GLOBALS['temp']['advancedForm']		= "collapse printCollapse";
		}
		break;

	case "provisional":
		$GLOBALS['temp']['accommFilter']		= "colLt";
		$GLOBALS['temp']['agentFilter']				= "colLtt";
		$GLOBALS['temp']['consultantFilter']	= "colLtt";
		$GLOBALS['temp']['createdByFilter'] = "colLtt";
		$GLOBALS['temp']['reportInfo']				= $GLOBALS['info_dir']."info_rep_prov.htm";
		$GLOBALS['temp']['hideStatusHead']		= "collapse printCollapse";
		$GLOBALS['temp']['hideStatus']				= "collapse printCollapse";
		$GLOBALS['temp']['expDateHead']				= "outLt";
		$GLOBALS['temp']['expDate']						= "";

		if (!$createDate) {
			$GLOBALS['temp']['hideCreateHead']		= "collapse printCollapse";
			$GLOBALS['temp']['hideCreate']				= "collapse printCollapse";
			$table_width = $table_width - 72;
			$GLOBALS['temp']['table_width']			= $table_width;
		}
		if (!$amendDate) {
			$GLOBALS['temp']['hideAmendedHead']		= "collapse printCollapse";
			$GLOBALS['temp']['hideAmended']				= "collapse printCollapse";
			$table_width = $table_width - 72;
			$GLOBALS['temp']['table_width']			= $table_width;
		}
		if (!$provDate) {
			$GLOBALS['temp']['hideProvHead']		= "collapse printCollapse";
			$GLOBALS['temp']['hideProv']				= "collapse printCollapse";
			$table_width = $table_width - 72;
			$GLOBALS['temp']['table_width']			= $table_width;
		}
		
		if ( $GLOBALS['jobLevelArray'][204] > "5" ) {
			$GLOBALS['temp']['chngProvHeader']				= "outLt printCollapse";
			$GLOBALS['temp']['chngProv']				= "printCollapse";
			$GLOBALS['temp']['notify']					= "button";
		}

		if ( $userStatusId > 1 ) {
			$GLOBALS['temp']['originatorFilter']	= "colLtt";
		}

		if ( $options & REP_STYLE_ITEM ) {
			$GLOBALS['temp']['chngProv'] = "";
		} else {
			$GLOBALS['temp']['chngProv'] = "collapse printCollapse";
		} 

		if ( $reportOptions[0] == "0" ) {
			$GLOBALS['temp']['advancedForm']		= "collapse printCollapse";
		}
		$GLOBALS['temp']['provRoomCheck'] = "colLt";
		$GLOBALS['temp']['travelDateFilter'] = "colLtt";
		break;

	case "update":
		$GLOBALS['temp']['upToPlus']					= "collapse printCollapse";
		$GLOBALS['temp']['accommFilter']		= "colLt";
		$GLOBALS['temp']['statusFilter']			= "colLt";
		$GLOBALS['temp']['updateFilter']			= "colLt";
		$GLOBALS['temp']['consultantFilter']	= "colLtt";
		$GLOBALS['temp']['createdByFilter'] = "colLtt";
		$GLOBALS['temp']['inclTravRes']				= "";
		$GLOBALS['temp']['reportInfo']				= $GLOBALS['info_dir']."info_rep_update.htm";
		$GLOBALS['temp']['inclResDet']				= "colLtt";
		$GLOBALS['temp']['exclResDet']				= "collapse printCollapse";
		$GLOBALS['temp']['advancedOptions']		= "colLt";
		// $GLOBALS['temp']['advancedForm']		= "colLt";
		
		if ( $reportOptions[0] == "0" ) {
			$GLOBALS['temp']['advancedForm']		= "collapse printCollapse";
		}

		if ( $reportOptions[1] == "1" ) {
			$GLOBALS['temp']['detailCheck']					= "checked";
			$GLOBALS['temp']['showHideButtonClass']	= "button";
		} else {
			$GLOBALS['temp']['summHide']						= "visibility:hidden;";
			$GLOBALS['temp']['showHideButtonClass']	= "collapse printCollapse";
		}

		if ( $reportOptions[4] == "1" ) {
			$GLOBALS['temp']['inclTravResCheck']			= "checked";
		}

		$GLOBALS['temp']['updateNew']							= "";
		$GLOBALS['temp']['updateAmended']					= "";
		
		if ( $updateNew ) {
			$GLOBALS['temp']['updateNew']						= "checked";
		}

		if ( $updateAmended ) {
			$GLOBALS['temp']['updateAmended']				= "checked";
		}

		$GLOBALS['temp']['disableAll']						= "collapse printCollapse";
		$GLOBALS['temp']['noAll']									= "Date Range";
		// $GLOBALS['temp']['hideRepBut']					= "collapse printCollapse";
		// $GLOBALS['temp']['showRepBut']					= "";
		$GLOBALS['temp']['todayPlus']							= "collapse printCollapse";
		$GLOBALS['temp']['exportClass']						= "collapse printCollapse";
		$GLOBALS['temp']['travelDateFilter'] = "colLtt";
		$GLOBALS['temp']['cancelDateFilter'] = "colLtt";
		
		$startPage = 0;
		
		break;
	}

	if ( $page == "" ) {
		$page = $startPage;
	}

	$GLOBALS['temp']['page'] = "<input type=\"hidden\" id=\"currentPage\" value=\"" . $page . "\">";

	$GLOBALS['temp']['check1']				= "";
	$GLOBALS['temp']['check2']				= "";
	$GLOBALS['temp']['check3']				= "";
	$GLOBALS['temp']['check4']				= "";
	$GLOBALS['temp']['toDatePlus']		= "";
	$GLOBALS['temp']['upToDatePlus']	= "";

	switch ( $fromD ) {
	case "all":
		$GLOBALS['temp']['check1'] = "checked=\"checked\"";
		break;

	case "today":
		$GLOBALS['temp']['check2'] = "checked=\"checked\"";
		break;
	
	case "todayplus":
		$GLOBALS['temp']['check3']			= "checked=\"checked\"";
		$GLOBALS['temp']['toDatePlus']	= $toD;
		break;

	case "upToPlus":
		$GLOBALS['temp']['check5']				= "checked=\"checked\"";
		$GLOBALS['temp']['upToDatePlus']	= $toD;
		break;

	default:
		$GLOBALS['temp']['check4'] = "checked=\"checked\"";
		break;
	}

	$GLOBALS['temp']['today']				= chng_date(date("Y-m-d"),"-");
	$GLOBALS['temp']['todayDate']		= date("Y-m-d");
	$GLOBALS['temp']['genDate']			= chng_date(date("Y-m-d"),"-")." ".date("H:i:s");
	 
	$GLOBALS['temp']['perPage0']		= "";
	$GLOBALS['temp']['perPage1']		= "";
	$GLOBALS['temp']['perPage2']		= "";
	$GLOBALS['temp']['perPage5']		= "";
	$GLOBALS['temp']['perPage10']		= "";
	$GLOBALS['temp']['perPage20']		= "";
	$GLOBALS['temp']['perPage50']		= "";
	$GLOBALS['temp']['perPage100']	= "";

	switch($perPage) {
		case 2:
			$GLOBALS['temp']['perPage2'] = "selected";
			break;

		case 5:
			$GLOBALS['temp']['perPage5'] = "selected";
			break;

		case 10:
			$GLOBALS['temp']['perPage10'] = "selected";
			break;

		case 20:
			$GLOBALS['temp']['perPage20'] = "selected";
			break;

		case 50:
			$GLOBALS['temp']['perPage50'] = "selected";
			break;

		case 100:
			$GLOBALS['temp']['perPage100'] = "selected";
			break;

		case 1:
			$GLOBALS['temp']['perPage1'] = "selected";
			break;

		default:
			$GLOBALS['temp']['perPage0'] = "";
			break;
	}
}

if ( $_SERVER['argc'] > 1 ) {

	if ( $renderMode == "html" ) {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
	}

	if ( !($options & REP_STYLE_LIST) ) {
		$sqlCountModifier = " DISTINCT ";
	} else {
		$sqlCountModifier = "";
	}
	
	$sqlCount = "SELECT COUNT($sqlCountModifier rv_reservation.rv_reservation_ix)";
	
	$sqlFrom = "
		FROM 
			rv_reservation
		INNER JOIN rv_reservation_item ON 
			rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN rf_reservation_status ON 
			rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id 
		INNER JOIN ac_accomm_type ON 
			ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_persona ON 
			pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id 
		LEFT JOIN pr_persona AS agent_persona ON 
			agent_persona.pr_persona_ix = rv_reservation.rv_agent_id 
		LEFT JOIN rf_source ON 
			rf_source.rf_source_ix = rv_reservation.rf_source_ix 
		WHERE 
			rv_reservation.rf_reservation_status_id != '25' 
		AND 
			rv_reservation_item.ac_accomm_type_id IN ('" . join("','",$accommList) . "')
		";
	
	if ( $onlyTBA ) {
		$sqlFrom .= "
			AND 
				(
					rv_reservation.rv_amt_accomm_gross IS NULL
					OR 
					rv_reservation.rv_amt_accomm_nett IS NULL
				)
		";
	}

	$sqlOrder			= " ORDER BY rv_reservation.rv_date_arrive, rv_reservation_item.rv_item_date_depart, rv_reservation.rv_reservation_ix ";	
	$sqlDateWhere	= "";

	switch ( $report ) {
	
	case "arr/dep":
		$sqlDateWhere	= " AND rv_reservation.rf_reservation_status_id = 30 ";
		$sqlOrder			= " ORDER BY rv_reservation_item.rv_item_date_arrive, rv_reservation_item.rv_item_date_depart ";
	
	case "standard":
		if ( $options & REP_STYLE_ITEM ) {

			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$sqlDateWhere .= "
					AND 
						(
							(
								rv_reservation.rv_date_arrive >= '" . $fromDate['jsDate'] . "' 
								AND 
								rv_reservation.rv_date_arrive <= '" . $toDate['jsDate'] . "'
							)
						OR 
							(
								rv_reservation.rv_date_depart >= '" . $fromDate['jsDate'] . "' 
								AND 
								rv_reservation.rv_date_depart <= '".$toDate['jsDate']."'
							)
						OR 
							(
								rv_reservation.rv_date_arrive < '" . $fromDate['jsDate'] . "' 
								AND 
								rv_reservation.rv_date_depart > '" . $toDate['jsDate'] . "'
							)
						)
				";
			}
		} else {

			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$sqlDateWhere .= "
					AND 
						(
							(
								rv_reservation_item.rv_item_date_arrive >= '" . $fromDate['jsDate'] . "' 
								AND 
								rv_reservation_item.rv_item_date_arrive <= '" . $toDate['jsDate'] . "'
							)
							OR 
							(
								rv_reservation_item.rv_item_date_depart >= '" . $fromDate['jsDate'] . "' 
								AND 
								rv_reservation_item.rv_item_date_depart <= '" . $toDate['jsDate'] . "'
							)
							OR 
							(
								rv_reservation_item.rv_item_date_arrive < '" . $fromDate['jsDate'] . "' 
								AND 
								rv_reservation_item.rv_item_date_depart > '" . $toDate['jsDate'] . "'
							)
						)
				";
			}
		}
		break;
	
		case "consultant":
			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$sqlDateWhere = "
					AND (rv_reservation.rv_date_consultant >= '" . $fromDate['jsDate'] . "' AND rv_reservation.rv_date_consultant <= '" . $toDate['jsDate'] . "')
				";
			}
			break;
		case "provisional":
			// See form 223 -----------------------------------------------------------
			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$sqlDateWhere = "
					AND rv_reservation.rv_provision_expiry_date >= '" . $fromDate['jsDate'] . "' AND rv_reservation.rv_provision_expiry_date <= '" . $toDate['jsDate'] . "' AND rv_reservation.rf_reservation_status_id = '20'
				";
			}
			break;
		case "update":
			if ( $updateNew && isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$sqlDateWhere = "
					AND (
						(
							rv_reservation.rv_date_recorded >= '" . $fromDate['jsDate'] . "'
							AND rv_reservation.rv_date_recorded <= '" . $toDate['jsDate'] . "'
						)
				";
				if (!$updateAmended) {
					$sqlDateWhere .= "
						)
					";
				}
				if ($reportOptions[4] != "1") {
					$sqlFrom .= "
						AND rv_reservation.rv_date_depart > '" . date("Y-m-d") . "'
					";
				}
			}
			if ($updateAmended) {
				if (!$updateNew) {
					$sqlDateWhere = " AND ( ";
				} else {
					$sqlDateWhere .= " OR ";
				}
				if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
					$sqlDateWhere .= "
							(
								rv_reservation.rv_date_changed >= '".$fromDate['jsDate']."'
								AND rv_reservation.rv_date_changed <= '".$toDate['jsDate']."'
							)
						)
					";
				}
				if ($reportOptions[4] != "1") {
					$sqlFrom .= " AND rv_reservation.rv_date_depart > '" . date("Y-m-d") . "' ";
				}
			}
			break;
		case "single":
			$sqlDateWhere = " AND rv_reservation.rv_reservation_ix IN ('".join("','",$reportSingle)."')";
		default:
			break;
	}

	if ( $fromD=="all" ) {
		switch($report) {
			case "provisional":
				$sqlDateWhere = " AND rv_reservation.rf_reservation_status_id = '20' ";
				break;
			default:
				$sqlDateWhere = "";
				break;
		}
	}
	$cancelDateSQL = "";
	if($cancelDate == "1") {
		$cancelDateSQL = "
			AND rv_reservation.rv_cancel_date >= '$cancelFromDate[jsDate]' AND rv_reservation.rv_cancel_date <= '$cancelToDate[jsDate]'
		";
	}
	$sqlDateWhere .= $cancelDateSQL;

	$travelDateSQL = "";
	if($travelDate == "1") {
		$travelDateSQL = "
				AND 
					(
						(
							rv_reservation.rv_date_arrive >= '" . $travelFromDate['jsDate'] . "' 
							AND 
							rv_reservation.rv_date_arrive <= '" . $travelToDate['jsDate'] . "'
						)
					OR 
						(
							rv_reservation.rv_date_depart >= '" . $travelFromDate['jsDate'] . "' 
							AND 
							rv_reservation.rv_date_depart <= '".$travelToDate['jsDate']."'
						)
					OR 
						(
							rv_reservation.rv_date_arrive < '" . $travelFromDate['jsDate'] . "' 
							AND 
							rv_reservation.rv_date_depart > '" . $travelToDate['jsDate'] . "'
						)
					)
		";
	}
	$sqlDateWhere .= $travelDateSQL;
	$sqlLimit = "";
	if ( $renderMode == "html" ) {
	
		if ( !($options & REP_STYLE_FINANCIAL) ) {
			$totalCount = $lDB->get($sqlCount . $sqlFrom . $sqlDateWhere . $accommFilter['where'] . $statusFilter['where'] . $sourceFilter['where'] . $agentFilter['where'] . $contactFilter['where'] . $consultantFilter['where'] . $createdByFilter['where'] . $originatorFilter['where'] . $nationalityFilter['where'] . $rateFilter['where'] . $agentPostCountryFilter['where'] . $agentPhysCountryFilter['where'],4);
	
			$GLOBALS['temp']['recFound'] = $totalCount;
	
			$totalPages = ceil($totalCount/$perPage);
			
			if ( $page > $totalPages ) {
				$page = $totalPages;
			}
	
			$startCount = ($page-1) * $perPage;
	
			if ( ($report == "update" || $report == "arr/dep") && $reportOptions[1] != "1" ) {
				$GLOBALS['temp']['pageCount'] = "Summary";
			} else {
				$GLOBALS['temp']['pageCount'] = $totalPages;
			}
	
			$GLOBALS['temp']['options'] = $options;
			$GLOBALS['temp']['pageNum'] = "Page $page";
	
			if ( $page == 0 ) {
				$GLOBALS['temp']['pageNum'] = "Summary";
			}
	
			$sqlLimit = " LIMIT $startCount, $perPage ";
	
			$GLOBALS['temp']['hidePrevButton'] = "button";
			$GLOBALS['temp']['hideNextButton'] = "button";
	
			if ( $page == 1 && $report != "update" && $report != "arr/dep" ) {
				$GLOBALS['temp']['hidePrevButton'] = "collapse printCollapse";
			}
	
			if ( $page == 0 && ($report == "update" || $report == "arr/dep") ) {
				$GLOBALS['temp']['hidePrevButton'] = "collapse printCollapse";
			}
	
			if ( $page == $totalPages || ( ($report == "update" || $report == "arr/dep") && $reportOptions[1] != "1" ) ) {
				$GLOBALS['temp']['hideNextButton'] = "collapse printCollapse";
			}
	
			$pageList = "";
	
			if ( $report == "update" || $report == "arr/dep" ) {
				$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage(0);\">Summary</a>";
			}
	
			if ( $reportOptions[1] == "1" || ($report != "update" && $report != "arr/dep") ) {
				$totalList = 8;
				$startList = 1;
	
				if ( $totalPages < $totalList ) {
					$startList = 1;
					$totalList = $totalPages;
				} else if($page <= ($totalList/2)) {
					$startList = 1;
				} else if($page > ($totalList/2) && $page < ($totalPages-($totalList/2))) {
					$startList = $page-($totalList/2)+1;
				} else {
					$startList = $totalPages-$totalList+1;
				}
	
				if ($page > 1 && $totalPages > 1 && $startList > 1 ) {
					if ( $pageList != "" ) {
						$pageList .= ", ";
					}
					
					$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage(1);\">First</a>";
				}
	
				for ( $count = $startList; $count < ($totalList + $startList); $count++ ) {
					if ( $pageList != "" ) {
						$pageList .= ", ";
					}
	
					if ( $count == $page ) {
						$pageList .= "<span class=\"txt\">" . $count . "</span>";
					} else {
						$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage($count);\">$count</a>";
					}
				}
	
				if ( $page < $totalPages && ($startList+$totalList-1) < $totalPages ) {
					if ( $pageList != "" ) {
						$pageList .= ", ";
					}
					$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage(" . $totalPages . ");\">Last</a>";
				}
			}
			$GLOBALS['temp']['pageList'] = $pageList;
		} else {
			// We don't want page numbers on the Financial report (yet) ---------------
			$GLOBALS['temp']['pageList'] = "";
		}
	
		$GLOBALS['temp']['report'] = '<input type="hidden"6/16/2008 name="report" value="' . $report . '" />';
		$GLOBALS['temp']['options'] = $options;
	}

	$sqlData = " SELECT DISTINCT
		rv_reservation.rv_reservation_ix AS resNum,
		rv_reservation.rv_provision_expiry_date AS provExpDt,
		rv_reservation.rf_reservation_status_id AS resStatId,
		rv_reservation.rv_date_consultant AS allocDate,
		rv_reservation.rt_rate_type_id AS rateId,
		rv_reservation.rv_invoice_currency_id AS invCurrId,
		rv_reservation.rv_consultant_id AS consultantId,
		rv_reservation.rv_agent_id AS agentId,
		rv_reservation.rv_corr_persona_id AS contactId,
		rv_reservation.rv_exchg_rate AS exchRate,
		rv_reservation.rv_commission_perc AS commPerc,
		rv_reservation.rv_commission_deduct_yn AS commDeductYn,
		rv_reservation.ac_pay_plan_id AS payId,
		rv_reservation.rv_origin_agent_id AS originatorId,
		rf_source.rf_source_desc AS srcDesc
	";
	
	if ( $renderMode == "pdf" && ($renderType == "view" || $renderType == "send") ) {
		$pdf = new PDF($reportLabel);
		// Main PDF header
		$headerArray = array();
	
		if ( $report != "single" ) {
			if(is_array($fromDate)) {
				$dateRange = $fromDate['htmlDate'] . " to " . $toDate['htmlDate'];
			} else {
				$dateRange = "All";
			}
			array_push($headerArray,
				array('name'=>"Date Range", 'value'=>$dateRange),
				array('name'=>"Property Filter", 'value'=>$accommFilter['names']),
				array('name'=>"Status Filter", 'value'=>$statusFilter['names']),
				array('name'=>"Source Filter", 'value'=>$sourceFilter['names']),
				array('name'=>"Agent Filter", 'value'=>$agentFilter['names']),
				array('name'=>"Contact Filter", 'value'=>$contactFilter['names']),
				array('name'=>"Consultant Filter", 'value'=>$consultantFilter['names'])
			);
			if($report == "update" || $report == "standard" || $report == "consultant" || $report == "provisional") {
				array_push($headerArray,array('name'=>"Created By Filter", 'value'=>$createdByFilter['names']));
			}
			array_push($headerArray,array('name'=>"Originator Filter", 'value'=>$originatorFilter['names']));
		}
		$pdf->ReportHeader($reportLabel,$headerArray);
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
	}
	
	if ( $renderMode == "csv" ) {
		$csvHeader = array();
		if($fromDate == "All") {
			$date_suffix = date("dMy");
		} else {
			$date_suffix = str_replace(" ", "", $fromDate['htmlDate'] . "_to_" . $toDate['htmlDate']);
		}

		if($options & REP_STYLE_FINANCIAL) {
			$headerRep = "Financial Report";
			$reportName = "financial_report_". $date_suffix;
		}
		else if($options & REP_STYLE_ITEM) {
			$headerRep = "List Report";
			$reportName = "list_report_". $date_suffix;
		}
		else if($options & REP_STYLE_LIST) {
			$headerRep = "Item Report";
			$reportName = "item_report_". $date_suffix;
		} else {
			$headerRep = "Detailed Report";
			$reportName = "detailed_report_". $date_suffix;
		}
		
		array_push($csvHeader,array($report." report"));
		array_push($csvHeader,array($headerRep));
		array_push($csvHeader,array());
		if($fromDate == "All") {
			array_push($csvHeader,array("Date Range","All"));
		} else {
			array_push($csvHeader,array("Date Range",$fromDate['htmlDate'] . " to " . $toDate['htmlDate']));
		}
		array_push($csvHeader,array("Property Filter",$propertyFilter['names']));
		if($report == "update" || $report == "standard" || $report == "consultant") {
			array_push($csvHeader,array("Status Filter",$statusFilter['names']));
		}
		if($report == "update" || $report == "standard" || $report == "consultant" || $report == "provisional") {
			array_push($csvHeader,array("Consultant Filter",$consultantFilter['names']));
			array_push($csvHeader,array("Created By Filter",$createdByFilter['names']));
		}
		if($report == "standard") {
			array_push($csvHeader,array("Source Filter",$sourceFilter['names']));
			array_push($csvHeader,array("Contact Filter",$contactFilter['names']));
		}

		if($report == "provisional" || $report == "standard") {
			array_push($csvHeader,array("Originator Filter",$originatorFilter['names']));
			array_push($csvHeader,array("Agent Filter",$agentFilter['names']));
		}
		if($report == "update") {
			$countNew = $lDB->get("SELECT
				COUNT(DISTINCT rv_reservation.rv_reservation_ix)
				" . $sqlFrom . "
				AND 
					rv_reservation.rv_date_recorded >= '" . $fromDate['jsDate'] . "'
				AND 
					rv_reservation.rv_date_recorded <= '" . $toDate['jsDate'] . "'
				$cancelDateSQL
				$travelDateSQL
				" . $propertyFilter['where']
				. $statusFilter['where']
				. $agentFilter['where']
				. $contactFilter['where']
				. $consultantFilter['where']
				. $createdByFilter['where']
				. $originatorFilter['where']
				. $nationalityFilter['where']
				. $rateFilter['where']
				. $agentPostCountryFilter['where']
				. $agentPhysCountryFilter['where']
			,4);
			
			$countAmended = $lDB->get("
				SELECT
					COUNT(DISTINCT rv_reservation.rv_reservation_ix)
					" . $sqlFrom . "
					AND rv_reservation.rv_date_changed >= '" . $fromDate['jsDate'] . "'
					AND rv_reservation.rv_date_changed <= '" . $toDate['jsDate'] . "'
					$cancelDateSQL
					$travelDateSQL
					" . $propertyFilter['where']
					. $statusFilter['where']
					. $agentFilter['where']
					. $contactFilter['where']
					. $consultantFilter['where']
					. $createdByFilter['where']
					. $originatorFilter['where']
					. $nationalityFilter['where']
					. $rateFilter['where']
					. $agentPostCountryFilter['where']
					. $agentPhysCountryFilter['where']
			,4);
			array_push($csvHeader,array("New Records",$countNew));
			array_push($csvHeader,array("Amended Records",$countAmended));
		}
		if($report == "update" || $report == "consultant" || $report == "provisional") {
			if($travelDate==1) {
				$travelHeader = $travelFromDate['htmlDate'] . " to " . $travelToDate['htmlDate'];
			} else {
				$travelHeader = "";
			}
			array_push($csvHeader,array("Travel date range",$travelHeader));
		}
		if($report == "update" || $report == "consultant" || $report == "standard") {
			if($cancelDate==1) {
				$cancelHeader = $cancelFromDate['htmlDate'] . " to " . $cancelToDate['htmlDate'];
			} else {
				$cancelHeader = "";
			}
			array_push($csvHeader,array("Cancellation date range",$cancelHeader));
		}
		if($report == "standard" || $report == "arr/dep") {
			array_push($csvHeader,array("Nationality",$nationalityFilter['names']));
		}
		if($report == "standard") {
			array_push($csvHeader,array("Rate Type",$rateFilter['names']));
			//array_push($csvHeader,array("Agent Country",$sourceFilter['names']));
			array_push($csvHeader,array("Show Only TBA",$onlyTBA?"Yes":"No"));
		}
		array_push($csvHeader,array("Filter detail by property",$propertyDetail?"Yes":"No"));
		array_push($csvHeader,array("Include non-property specific",$nonPropertyDetail?"Yes":"No"));
		if($report == "update") {
			array_push($csvHeader,array("Include travelled reservations",$inclTravRes?"Yes":"No"));
		}

		if($report == "arr/dep") {
			array_push($csvHeader,array("Include room/unit listing",$inclRoomList?"Yes":"No"));
		}
		
	}

	if ( ($page == 0 && $renderMode == "html") || ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) ) {
		if ( $report == "update" ) {
			$summaryArray = array();
			$summaryArray['html'] = __DIR__ . "/../../../public/html/report_update.htm";
			$summaryArray['fromDate'] = $fromDate['htmlDate'];
			$summaryArray['toDate'] = $toDate['htmlDate'];
	
			$countNew = $lDB->get("SELECT
				COUNT(DISTINCT rv_reservation.rv_reservation_ix)
				" . $sqlFrom . "
				AND 
					rv_reservation.rv_date_recorded >= '" . $fromDate['jsDate'] . "'
				AND 
					rv_reservation.rv_date_recorded <= '" . $toDate['jsDate'] . "'
				$cancelDateSQL
				$travelDateSQL
				" . $accommFilter['where']
				. $statusFilter['where']
				. $agentFilter['where']
				. $contactFilter['where']
				. $consultantFilter['where']
				. $createdByFilter['where']
				. $originatorFilter['where']
				. $nationalityFilter['where']
				. $rateFilter['where']
				. $agentPostCountryFilter['where']
				. $agentPhysCountryFilter['where']
			,4);
	
			$countAmended = $lDB->get("
				SELECT
					COUNT(DISTINCT rv_reservation.rv_reservation_ix)
					" . $sqlFrom . "
					AND rv_reservation.rv_date_changed >= '" . $fromDate['jsDate'] . "'
					AND rv_reservation.rv_date_changed <= '" . $toDate['jsDate'] . "'
					$cancelDateSQL
					$travelDateSQL
					" . $accommFilter['where']
					. $statusFilter['where']
					. $agentFilter['where']
					. $contactFilter['where']
					. $consultantFilter['where']
					. $createdByFilter['where']
					. $originatorFilter['where']
					. $nationalityFilter['where']
					. $rateFilter['where']
					. $agentPostCountryFilter['where']
					. $agentPhysCountryFilter['where']
			,4);
	
			$summaryArray['numCreate']		= $countNew;
			$summaryArray['numChange']		= $countAmended;
			$summaryArray['noNewRes']			= "";
			$summaryArray['noChangeRes']	= "";
	
			if ( $countNew == "0" ) {
				$summaryArray['numCreate'] = "There are no new reservations for the selected criteria";
				$summaryArray['noNewRes'] = "<table cellspacing=\"0\" cellpadding=\"0\" width=\"640\"><tr style=\"height: 15px;\"><td align=\"center\">No records found</td></tr></table>";
			}
	
			if ( $countAmended == "0" ) {
				$summaryArray['numChange'] = "There are no amended reservations for the selected criteria";
				$summaryArray['noChangeRes'] = "<table cellspacing=\"0\" cellpadding=\"0\" width=\"640\"><tr style=\"height: 15px;\"><td align=\"center\">No records found</td></tr></table>";
			}
	
			$dateCompareSelect = "rv_reservation.rv_date_changed AS dateCompare";
	
			if ( !$updateNew && $updateAmended ) {
				$dateCompareSelect = "rv_reservation.rv_date_recorded AS dateCompare";
			}
	
			$updateSelect = "
				SELECT DISTINCT
					rv_reservation.rv_reservation_ix as id,
					rv_reservation.rv_res_name as name,
					" . $dateCompareSelect . ",
					ac_accomm_type.pr_business_id as propId,
					pr_persona.pr_name_last as propName,
					rf_reservation_status_desc as statusDesc
			";
			$updateOrder = " ORDER BY ac_accomm_type.pr_business_id DESC, rv_reservation.rv_reservation_ix ";
	
			if ($updateNew) {
				$summaryArray['noNew'] = "";
				$newArray = $lDB->get($updateSelect . $sqlFrom . "
					AND rv_reservation.rv_date_recorded >= '" . $fromDate['jsDate'] . "'
					AND rv_reservation.rv_date_recorded <= '" . $toDate['jsDate'] . "'
					$cancelDateSQL
					$travelDateSQL
					" . $accommFilter['where']
					. $statusFilter['where']
					. $agentFilter['where']
					. $contactFilter['where']
					. $consultantFilter['where']
					. $createdByFilter['where']
					. $originatorFilter['where']
					. $nationalityFilter['where']
					. $rateFilter['where']
					. $agentPostCountryFilter['where']
					. $agentPhysCountryFilter['where']
					. $updateOrder
				,2);
				$summaryArray['newRes'] = renderUpdateSummaryHTML($newArray,$fromDate['jsDate'],$toDate['jsDate'],"* ",$countNew);
			} else {
				$summaryArray['newRes'] = array();
				$summaryArray['noNew'] = "collapse printCollapse";
			}
	
			if ($updateAmended) {
				$summaryArray['noAmend'] = "";
				if ($updateNew && isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
					$hideNew = "
						AND (
							rv_reservation.rv_date_recorded < '" . $fromDate['jsDate'] . "'
							OR rv_reservation.rv_date_recorded > '" . $toDate['jsDate'] . "'
						)
					";
					$newMarker = "";
				} else {
					$hideNew = "";
					$newMarker = "* ";
				}
				$amendedArray = $lDB->get($updateSelect . $sqlFrom . "
					AND 
						rv_reservation.rv_date_changed >= '" . $fromDate['jsDate'] . "'
					AND 
						rv_reservation.rv_date_changed <= '" . $toDate['jsDate'] . "'
					$cancelDateSQL
					$travelDateSQL
					" . $hideNew
					. $accommFilter['where']
					. $statusFilter['where']
					. $agentFilter['where']
					. $contactFilter['where']
					. $consultantFilter['where']
					. $createdByFilter['where']
					. $originatorFilter['where']
					. $nationalityFilter['where']
					. $rateFilter['where']
					. $agentPostCountryFilter['where']
					. $agentPhysCountryFilter['where']
					. $updateOrder
				,2);
				$summaryArray['chngRes'] = renderUpdateSummaryHTML($amendedArray,$fromDate['jsDate'],$toDate['jsDate'],$newMarker);
			} else {
				$summaryArray['chngRes'] = array();
				$summaryArray['noAmend'] = "collapse printCollapse";
			}
	
			$summaryArray['end'] = array(); // @todo - this is a bug, array requires empty array item to work
	
			if ( $renderMode == "html" ) {
				$summaryArray['newRes']['html']		= __DIR__ . "/../../../public/html/report_update_rows.htm";
				$summaryArray['chngRes']['html']	= __DIR__ . "/../../../public/html/report_update_rows.htm";
				$resRows = renderHTML($summaryArray);
			}
	
			if ( $renderMode == "pdf" ) {
				updateSummaryPDF($summaryArray,$pdf,$updateNew,$updateAmended,$reportOptions);
			}
		}
	
		if ( $report == "arr/dep" ) {
			$dataSql = "
				SELECT
					/* 0*/ rv_reservation.rv_reservation_ix,
					/* 1*/ rv_reservation.rv_res_name,
					/* 2*/ ac_accomm_type.ac_accomm_desc,
					/* 3*/ rv_reservation_item.rv_item_accomm_count,
					/* 4*/ rv_reservation.rv_note_general,
					/* 5*/ rv_reservation.rv_provision_expiry_date,
					/* 6*/ rv_reservation_item.rv_item_adult_count,
					/* 7*/ rv_reservation_item.rv_item_child_count,
					/* 8*/ ac_accomm_type.ac_accomm_no_of_units,
					/* 9*/ rv_reservation_item.rv_item_date_arrive,
					/*10*/ rv_reservation_item.rv_item_date_depart,
					/*11*/ rv_reservation.rv_note_general,
					/*12*/ rv_reservation.rv_agent_id,
					/*13*/ rv_reservation_item.rv_reservation_item_ix as resItemId,
					/*14*/ pr_business.pr_bus_name_short
				FROM
					rv_reservation
				INNER JOIN rv_reservation_item ON 
					rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				INNER JOIN ac_accomm_type ON 
					rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				INNER JOIN pr_business ON 
					pr_business.pr_business_id = ac_accomm_type.pr_business_id
				WHERE
					rv_reservation.rf_reservation_status_id = 30
					" . $accommFilter['where']
					. $statusFilter['where']
					. $agentFilter['where']
					. $contactFilter['where']
					. $consultantFilter['where']
					. $originatorFilter['where']
					. $nationalityFilter['where']
					. $rateFilter['where']
					. $agentPostCountryFilter['where']
					. $agentPhysCountryFilter['where'];
			
			$arriveSql = $dataSql."
				AND 
					(
						rv_reservation_item.rv_item_date_arrive >= '" . $fromDate['jsDate'] . "'
						AND 
						rv_reservation_item.rv_item_date_arrive <= '" . $toDate['jsDate'] . "'
					)" . $sqlOrder;
			
			$arriveData = $lDB->get($arriveSql,2);
			$arriveArray = renderArriveDepartSummaryHTML($arriveData,$fromDate['jsDate'],$toDate['jsDate'],$reportOptions);
	
			$stayingSql = $dataSql."
				AND rv_reservation_item.rv_item_date_arrive < '" . $fromDate['jsDate'] . "'
				AND rv_reservation_item.rv_item_date_depart > '" . $toDate['jsDate'] . "'
				" . $sqlOrder;
			
			$stayingData = $lDB->get($stayingSql,2);
			$stayingArray = renderArriveDepartSummaryHTML($stayingData,$fromDate['jsDate'],$toDate['jsDate'],$reportOptions);
	
			$departingSql = $dataSql . "
				AND 
					rv_reservation_item.rv_item_date_depart >= '" . $fromDate['jsDate'] . "'
				AND 
					rv_reservation_item.rv_item_date_depart <= '" . $toDate['jsDate'] . "'
				" . $sqlOrder;
			
			$departingData = $lDB->get($departingSql,2);
			$departingArray = renderArriveDepartSummaryHTML($departingData,$fromDate['jsDate'],$toDate['jsDate'],$reportOptions);
	
			$summaryArray['propertiesNames'] = $accommFilter['names'];
	
			$summaryArray['arriveTotalRoom']		= $arriveArray['totalRoom'];
			$summaryArray['arriveTotalPeople']	= $arriveArray['totalAdult'] + $arriveArray['totalChild'];
			$summaryArray['arriveTotalAdult']		= $arriveArray['totalAdult'];
			$summaryArray['arriveTotalChild']		= $arriveArray['totalChild'];
	
			$summaryArray['stayingTotalRoom']		= $stayingArray['totalRoom'];
			$summaryArray['stayingTotalPeople']	= $stayingArray['totalAdult'] + $stayingArray['totalChild'];
			$summaryArray['stayingTotalAdult']	= $stayingArray['totalAdult'];
			$summaryArray['stayingTotalChild']	= $stayingArray['totalChild'];
	
			$summaryArray['departingTotalRoom']		= $departingArray['totalRoom'];
			$summaryArray['departingTotalPeople']	= $departingArray['totalAdult'] + $departingArray['totalChild'];
			$summaryArray['departingTotalAdult']	= $departingArray['totalAdult'];
			$summaryArray['departingTotalChild']	= $departingArray['totalChild'];
	
			$summaryArray['occupancyTotalRoom']		= $summaryArray['arriveTotalRoom'] + $summaryArray['stayingTotalRoom'];
			$summaryArray['occupancyTotalPeople']	= $summaryArray['arriveTotalPeople'] + $summaryArray['stayingTotalPeople'];
			$summaryArray['occupancyTotalAdult']	= $summaryArray['arriveTotalAdult'] + $summaryArray['stayingTotalAdult'];
			$summaryArray['occupancyTotalChild']	= $summaryArray['arriveTotalChild'] + $summaryArray['stayingTotalChild'];

			$accommFilterWhere = str_replace("rv_reservation_item.ac_accomm_type_id", "ac_accomm_type.ac_accomm_type_id", $accommFilter['where']);
			$capacitySQL = "
				SELECT
					COUNT(ac_accomm_room.ac_accomm_room_id)
				FROM
					ac_accomm_type
				INNER JOIN ac_accomm_room ON 
					ac_accomm_room.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				WHERE
					ac_accomm_type.ac_accomm_type_inactive_yn = 0
				AND 
					ac_accomm_room.ac_accomm_room_inactive_yn = 0
					" . $accommFilterWhere;
				
				$capacityArray = $lDB->get($capacitySQL,"2");
				$capacity = $capacityArray[0][0];
	
			$inactiveCapacitySQL = "
				SELECT
					COUNT(ac_accomm_room.ac_accomm_room_id)
				FROM
					ac_accomm_type
				INNER JOIN ac_accomm_room ON 
					ac_accomm_room.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				WHERE
					ac_accomm_room.ac_accomm_room_inactive_yn <> 0
					" . $accommFilterWhere;
	
			$inactiveCapacityArray = $lDB->get($inactiveCapacitySQL,"2");
			$inactiveCapacity = $inactiveCapacityArray[0][0];
	
			$summaryArray['availableTotalRoom']	= $capacity;
			$summaryArray['inactiveTotalRoom']	= $inactiveCapacity;
			
			if ( $capacity != 0 ) {
				$summaryArray['occupancyPercent'] = round(($summaryArray['arriveTotalRoom'] + $summaryArray['stayingTotalRoom']) / $capacity * 100);
			} else {
				$summaryArray['occupancyPercent'] = "0";
			}
	
			if ( $fromDate['jsDate'] == $toDate['jsDate'] ) {
				$summaryArray['dateUsed'] = $fromDate['htmlDate'];
			} else {
				$summaryArray['dateUsed'] = $fromDate['htmlDate'] . " to " . $toDate['htmlDate'];
			}
				
			if ( $renderMode == "html" ) {
				$summaryArray['html'] = __DIR__ . "/../../../public/html/report_arrive_depart.htm";
				
				if ( sizeof($arriveArray['data']) > 0 ) {
					$summaryArray['arriveRow']					= $arriveArray['data'];
					$summaryArray['arriveRow']['html']	= __DIR__ . "/../../../public/html/report_arrive_depart_detail_rows.htm";
					$summaryArray['rowArrive']					= $arriveArray['data'];
					$summaryArray['rowArrive']['html']	= __DIR__ . "/../../../public/html/report_arrive_depart_summary_rows.htm";
				} else {
					$summaryArray['arriveRow'] = "<tr><td colspan=\"20\">No arrivals</td></tr>";
					$summaryArray['rowArrive'] = "<tr><td colspan=\"4\" align=\"center\">No arrivals</td></tr>";
				}
	
				if ( sizeof($stayingArray['data']) > 0 ) {
					$summaryArray['stayingRow']					= $stayingArray['data'];
					$summaryArray['stayingRow']['html']	= __DIR__ . "/../../../public/html/report_arrive_depart_detail_rows.htm";
					$summaryArray['rowStay']						= $stayingArray['data'];
					$summaryArray['rowStay']['html']		= __DIR__ . "/../../../public/html/report_arrive_depart_summary_rows.htm";
				} else {
					$summaryArray['stayingRow']	= "<tr><td>No stay-overs</td></tr>";
					$summaryArray['rowStay']		= "<tr><td colspan=\"4\" align=\"center\">No stay-overs</td></tr>";
				}
	
				if ( sizeof($departingArray['data']) > 0 ) {
					$summaryArray['departingRow']					= $departingArray['data'];
					$summaryArray['departingRow']['html']	= __DIR__ . "/../../../public/html/report_arrive_depart_detail_rows.htm";
					$summaryArray['rowDepart']						= $departingArray['data'];
					$summaryArray['rowDepart']['html']		= __DIR__ . "/../../../public/html/report_arrive_depart_summary_rows.htm";
				} else {
					$summaryArray['departingRow']	= "<tr><td>No departures</td></tr>";
					$summaryArray['rowDepart']		= "<tr><td colspan=\"4\" align=\"center\">No departures</td></tr>";
				}
				
				if ( $fromDate['jsDate'] == $toDate['jsDate'] ) {
					$summaryArray['showStats'] = "blkBord";
				} else {
					$summaryArray['showStats'] = "collapse";
				}
				$summaryArray['end'] = array(); // @todo - this is a bug, array requires empty array item to work
				$resRows = renderHTML($summaryArray);
			}
	
			if ( $renderMode == "pdf" ) {
				$summaryArray['arriveRow']		= $arriveArray['data'];
				$summaryArray['stayingRow']		= $stayingArray['data'];
				$summaryArray['departingRow']	= $departingArray['data'];
	
				if ( $fromDate['jsDate'] == $toDate['jsDate'] ) {
					arriveDepartSummaryPDF($summaryArray,$pdf,$accommFilter['names'],$fromDate['htmlDate'],$reportOptions,"1");
				} else {
					arriveDepartSummaryPDF($summaryArray,$pdf,$accommFilter['names'],$fromDate['htmlDate']." to " . $toDate['htmlDate'],$reportOptions,"0");
				}
			}
		}
}

	// Detail report
	if (
			(
				(
					$page > 0 && $renderMode == "html"
				) || (
					$renderMode == "pdf"
					&& ($renderType == "view" || $renderType == "send")
					&& (
						(
							$report != "update" && $report != "arr/dep"
						) || (
							($report == "update" || $report == "arr/dep")
							&& $reportOptions[1] == "1"
						)
					)
				) || (
					$renderMode == "csv"
				)
			) && !($options & REP_STYLE_LIST)
			&& !($options & REP_STYLE_ITEM)
			&& !($options & REP_STYLE_FINANCIAL)
		) {
	
		$resArray = $lDB->get($sqlData . $sqlFrom . $sqlDateWhere . $accommFilter['where'] . $statusFilter['where'] . $sourceFilter['where'] . $agentFilter['where'] . $contactFilter['where'] . $consultantFilter['where'] . $createdByFilter['where'] . $originatorFilter['where']. $nationalityFilter['where']. $rateFilter['where'] . $agentPostCountryFilter['where'] . $agentPhysCountryFilter['where'] . $sqlOrder . $sqlLimit,2);
		
		$resNumArray = array();
		
		/*if ( $renderMode == "csv" ) {
			$csvFile = detailHeaderCSV($csvHeader, $report);
			$reportTitle = "detailed";
		}	*/

		foreach ( $resArray as $resItem ) {
			if ( !in_array($resItem['resNum'],$resNumArray) ){
				array_push($resNumArray,$resItem['resNum']);
			}
			$fullResList = join($resNumArray,",");
			$GLOBALS['temp']['fullResList'] = "<input type=\"hidden\" name=\"fullResList\" id=\"fullResList\" value=\"" . $fullResList . "\">";
	
			// Detail Header ------------------------------------------------------------
			$resInfo = getReservationHeader($resItem['resNum']);
			$resItem = array_merge($resItem, $resInfo);
				
			if ( trim($resItem['rv_agent_ref']) == "" ) {
				$resItem['rv_agent_ref'] = "None";
			}
	
			// !!!!!!!!!! Everything should be moved to getReservationHeader
			// !!!!!!!!!! All that should be in the report recordset is rv_reservation.rv_reservation_ix
			/*
			
			getReservationHeader return array:
	
			rv_reservation.rv_corr_persona_id,
			rv_reservation.rv_billing_persona_id,
			rv_reservation.rv_res_name,
			rv_reservation.rv_reservation_ix as rv_reservation_id,
			rf_reservation_status.rf_reservation_status_desc,
			rv_reservation.rv_date_recorded,
			rv_reservation.rv_date_changed,
			ac_pay_plan.ac_pay_plan_desc,
			rt_rate_type.rt_rate_type_desc,
			rf_reservation_status.rf_reservation_status_id,
			*/
	
			$resItem['invCurr'] = getInvCurrSymbol($resItem['resNum']);
	
			if ( $resItem['invCurr'] == "0" ) {
				$resItem['invCurr'] = "";
			}
	
			// !!!!!!!!!! this could possibly be moved to getReservationHeader
			$resItem['rateCurr'] = getRateCurrency($resItem['rateId']);
	
			$resItem['hideSrcHead'] = "visibility: hidden;";
			$resItem['hideSrc'] = "visibility: hidden;";
	
			if ( $resItem['srcDesc'] != "0" && $resItem['srcDesc'] != "" ) {
				$resItem['hideSrcHead'] = "";
				$resItem['hideSrc'] = "";
			}
	
			// Get Originator Name ------------------------------------------------------
			$originName = $lDB->get("SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona_ix = '" . $resItem['originatorId'] . "'",4);
			$resItem['originName'] = $originName;
			$resItem['origHead'] = "printCollapse";
			$resItem['origstyle'] = " style=\"visibility:hidden;\"";
			$resItem['orig'] = "printCollapse";
	
			if ( $resItem['originatorId'] != "0" && $resItem['originatorId'] != "" ) {
				$resItem['origHead'] = "txtb";
				$resItem['orig'] = "expand";
				$resItem['origstyle'] = " style=\"visibility: visible;\"";
			}
	
			// Show the row if there is a source or an originator -----------------------
			$resItem['srcOrig'] = "collapse printCollapse";
			if ( ($resItem['srcDesc'] != "0" && $resItem['srcDesc'] != "")||($resItem['originatorId'] != "0" && $resItem['originatorId'] != "") ) {
				$resItem['srcOrig'] = "";
			}
	
			// !!!!!!!!! this could possibly be moved to getReservationHeader -----------
			$resItem['payPlan'] = getPaymentPlanName($resItem['payId']);
			
			// This is because getReservationHeader preformats the dates - shouldn't this
			// be optional or make copies of the dates to format?
			$dateRecorded = $lDB->get("SELECT rv_reservation.rv_date_recorded FROM rv_reservation WHERE rv_reservation_ix = '".$resItem['resNum']."'",4);
			$dateChanged = $lDB->get("SELECT rv_reservation.rv_date_changed FROM rv_reservation WHERE rv_reservation_ix = '".$resItem['resNum']."'",4);
			
			// !!!!!!!!! This should be read in elsewhere -------------------------------
			$resItem['rf_country_id'] = $lDB->get("SELECT rf_country_id FROM rv_reservation WHERE rv_reservation_ix = '".$resItem['resNum']."'",4);
			$resClass = "";
	
			if ( isset($fromDate['jsDate']) && $dateRecorded >= $fromDate['jsDate'] && isset($toDate['jsDate']) && $dateRecorded <= $toDate['jsDate'] && $report == "update" ) {
				$resClass .= "New";
			}
	
			if ( isset($fromDate['jsDate']) && $dateChanged >= $fromDate['jsDate'] && isset($toDate['jsDate']) && $dateChanged <= $toDate['jsDate'] && $report == "update" ) {
				if ( $resClass != "" ) {
					$resClass .= " / ";
				}
				$resClass .= "Amended";
			}
	
			if ( $resClass != "" ) {
				$resItem['resClass'] = " (".$resClass.")";
			} else {
				$resItem['resClass'] = "";
			}
	
			if ( $resItem['resStatId'] == "20" ) {
				$resItem['provExp'] = "expires: ".chng_date($resItem['provExpDt'],"-");
			} else {
				$resItem['provExp'] = "";
			}
	
			$resItem['provColor'] = "";
			if ( $resItem['resStatId'] == "20" ) {
				$provExpDt = $resItem['provExpDt'];
				$today = date("Y-m-d");
	
				if ( $provExpDt == $today ) {
					$resItem['provColor'] = "#F1C55D";
				} elseif ($provExpDt < $today) {
					$resItem['provColor'] = "#DB4242";
				}
			}
	
			// Detail Rows --------------------------------------------------------------
			$resItem['summRows']		= getReservationSummary($resItem['resNum'],$propertyDetail,$accommFilter);
			$resItem['accommRows']	= getReservationItems($resItem['resNum'],$propertyDetail,$accommFilter);
			$resItem['extraRows']		= getExtraDetails($resItem['resNum'],'0',false,$propertyDetail,$nonPropertyDetail,$propertyFilter);
			$resItem['extraRows']		= array_merge($resItem['extraRows'],getExtraDetails($resItem['resNum'],'1',false,$propertyDetail,$nonPropertyDetail,$propertyFilter));

			$resItem['accomExtraRows'] = getExtraDetails($resItem['resNum'],'3',false,$propertyDetail,$nonPropertyDetail,$propertyFilter);

			foreach($resItem['accomExtraRows'] as $key=>$accomExtra) {
				$accomPropCode = '';
				$accomPropCode = getPropertyCode($accomExtra['pr_business_id']);
				if($accomPropCode != "") {
					$accomPropCode = " (".$accomPropCode.")";
				}
				$resItem['accomExtraRows'][$key]['ac_ext_desc'] .= $accomPropCode;
			}
			
			$resItem['travelRows']	= getTravelDetails($resItem['resNum'],false,$propertyDetail,$nonPropertyDetail,$propertyFilter);
			
			if ( $userStatusId > 1 ) {
				$resItem['compTotals'] = getCompTotals($resItem['resNum']);
			} else {
				$resItem['compTotals'] = array();
			}
			$resItem['exchange']			= getExchange($resItem['resNum']);
			$resItem['exchangeNote']	= $resItem['exchange']['note'];
			$resItem['exchange']			= $resItem['exchange']['extras'];
	
			$currencyCheck = $lDB->get("SELECT COUNT(DISTINCT rf_currency_id) FROM fn_folio WHERE rv_reservation_id = '" . $resItem['resNum'] . "'",4);
			$resItem['showPaymentTotal'] = "";
			
			if ( $currencyCheck > 1 ) {
				$resItem['showPaymentTotal'] = "collapse printCollapse";
			}
	
			$paymentPlan = getPayItems($resItem['resNum']);
			$resItem['payOutstanding'] = $paymentPlan['outstanding'];
	
			if ( sizeof($paymentPlan['items']) > 0 ) {
				$resItem['payRows'] = $paymentPlan['items'];
				$resItem['payRows']['html'] = __DIR__ . "/../../../public/html/docs_pay_item_rows.htm";
			} else {
				$resItem['payRows'] = "<tr><td colspan='2' height='17' class='br txti' align='center'>No payment plan</td></tr>";
			}
	
			if ( sizeof($paymentPlan['payments']) > 0 ) {
				$resItem['payedRows'] = $paymentPlan['payments'];
				$resItem['payedRows']['html'] = __DIR__ . "/../../../public/html/docs_payed_item_rows.htm";
			} else {
				$resItem['payedRows'] = "<tr><td colspan='9' height='15' class='br txti' align='center'>No payments</td></tr>";
			}
	
			// Detail Notes -------------------------------------------------------------
			$resItem['resNote']			= t_decodeHTML(getReservationNote($resItem['resNum']));
			$resItem['guestInfo']		= t_decodeHTML(getReservationGuestInfo($resItem['resNum']));
			$resItem['extraNote']		= getExtraNotes($resItem['resNum'],0,0,$propertyDetail,$nonPropertyDetail,$propertyFilter);
			
			$resItem['travelNote']	= getExtraNotes($resItem['resNum'],1,0,$propertyDetail,$nonPropertyDetail,$propertyFilter);
	
			if ( $userStatusId > 1 ) {
				$resItem['resIntNote'] = t_decodeHTML(getReservationMemo($resItem['resNum']));
			}
	
			$resItem['guestNationality']	= getGuestNationality($resItem['rf_country_id']);
			$resItem['cancelNote']				= t_decodeHTML(getCancelNote($resItem['resNum']));
	
			if ( $userStatusId > 1 ) {
				$resItem['extIntNote']	= getExtraNotes($resItem['resNum'],0,1,$propertyDetail,$nonPropertyDetail,$propertyFilter);
				$resItem['travIntNote']	= getExtraNotes($resItem['resNum'],1,1,$propertyDetail,$nonPropertyDetail,$propertyFilter);
			}
	
			$reservationAuditTrail = new AuditTrail($resItem['resNum'],TYPE_RESERVATION);
			if ( $report == "update" ) {
				$resItem['auditTrail'] = $reservationAuditTrail->fetch($fromDate['jsDate'],$toDate['jsDate']);
			} else {
				$resItem['auditTrail'] = $reservationAuditTrail->fetch();
			}
	
			$resItem['rooming'] = getReservationRooming($resItem['resNum']);
	
			if ( sizeof($resItem['rooming']['rooms']) == 0 ) {
				$resItem['noRooming'] = "collapse printCollapse";
			} else {
				$resItem['noRooming'] = "";
			}
	
			if ( sizeof($resItem['rooming']['guestGroups']) == 1 && sizeof($resItem['rooming']['guestGroups'][0]['rows']) == 1 ) {
				$resItem['noGuestGroups'] = "collapse printCollapse";
			} else {
				$resItem['noGuestGroups'] = "";
			}
	
			if ( sizeof($resItem['rooming']['notes']) == 0 ) {
				$resItem['noGuestNote'] = "collapse printCollapse";
			} else {
				$resItem['noGuestNote'] = "";
			}
	
			if ( sizeof($resItem['rooming']['memos']) == 0 ) {
				$resItem['noGuestMemo'] = "collapse printCollapse";
			} else {
				$resItem['noGuestMemo'] = "";
			}
			
			$resItem = array_merge($resItem,getReservationTotals($resItem));
	
			// Contact Detail -----------------------------------------------------------
			if ( verifyConsultant($resItem['consultantId']) ) {
				$resItem['consultantDetail']	= getPersonaDetail($resItem['consultantId']);
				$resItem['consultPost']				= t_encodeHTML(getContactCorrAddress($resItem['consultantId']));
			} else {
				$resItem['consultantDetail']	= array();
				$resItem['consultPost']				= "";
			}
	
			if ( verifyAgent($resItem['agentId']) ) {
				$resItem['agentDetail']	= getPersonaDetail($resItem['agentId']);
				$resItem['agentPost']		= t_encodeHTML(getContactCorrAddress($resItem['agentId'])); 
			} else {
				$resItem['agentDetail']	= array();
				$resItem['agentPost']		= "";
			}
	
			$resItem['contactDetail']	= getPersonaDetail($resItem['contactId']);
			$resItem['contactPost']		= t_encodeHTML(getContactCorrAddress($resItem['contactId']));
			$resItem['allocDate']			= chng_date($resItem['allocDate'],"-");

			$resItem['origDetail']	= getPersonaDetail($resItem['originatorId']);
			$resItem['origPost']		= t_encodeHTML(getContactCorrAddress($resItem['originatorId']));
			
			if ( $renderMode == "html" ) {
				$resItem['resJob'] = "0";
	
				if ( canEditReservation($resItem['resNum']) ) {
					$resItem['resJob'] = "2";
				}
				array_push($resScrollSet,$resItem['resNum']);
				$resItem['html'] = __DIR__ . "/../../../public/html/rep_detbilling_res_rowsNEW.htm";
	
				// Consultant details ------------------------------------------------------
				if ( verifyConsultantInactive($resItem['consultantId']) ) {
					$resItem['consultName'] = "<i>" . $resItem['consultantDetail']['name'] . "</i>";
				} else {
					$resItem['consultName'] = $resItem['consultantDetail']['name'];
				}
	
				if ( !isset($resItem['consultantDetail']['fax']) || $resItem['consultantDetail']['fax'] == "" ) {
					$resItem['consultFax'] = "";
					$resItem['hideConsultFax'] = "collapse printCollapse";
				} else {
					$resItem['consultFax'] = $resItem['consultantDetail']['fax'];
					$resItem['hideConsultFax'] = "expand";
				}
	
				if ( !isset($resItem['consultantDetail']['telephone']) || $resItem['consultantDetail']['telephone'] == "" ) {
					$resItem['consultTel'] = "";
					$resItem['hideConsultTel'] = "collapse printCollapse";
				} else {
					$resItem['consultTel'] = $resItem['consultantDetail']['telephone'];
					$resItem['hideConsultTel'] = "expand";
				}
	
				if ( !isset($resItem['consultantDetail']['email']) || $resItem['consultantDetail']['email'] == "" ) {
					$resItem['consultEmail'] = "";
					$resItem['hideConsultEmail'] = "collapse printCollapse";
				} else {
					$resItem['consultEmail'] = $resItem['consultantDetail']['email'];
					$resItem['hideConsultEmail'] = "imgLink";
				}
	
				$resItem['hideConsultPost'] = "visible";
	
				if ( !isset($resItem['consultPost']) || $resItem['consultPost'] == "" ){
					$resItem['hideConsultPost'] = "hidden";
				}
	
				// Agent details -----------------------------------------------------------
				$resItem['agentName'] = isset($resItem['agentDetail']['name']) ? $resItem['agentDetail']['name'] : "";
	
				if ( !isset($resItem['agentDetail']['fax']) || $resItem['agentDetail']['fax'] == "" ) {
					$resItem['agentFax'] = "";
					$resItem['hideAgentFax'] = "collapse printCollapse";
				} else {
					$resItem['agentFax'] = $resItem['agentDetail']['fax'];
					$resItem['hideAgentFax'] = "expand";
				}
	
				if ( !isset($resItem['agentDetail']['telephone']) || $resItem['agentDetail']['telephone'] == "" ) {
					$resItem['agentTel'] = "";
					$resItem['hideAgentTel'] = "collapse printCollapse";
				} else {
					$resItem['agentTel'] = $resItem['agentDetail']['telephone'];
					$resItem['hideAgentTel'] = "expand";
				}
	
				if ( !isset($resItem['agentDetail']['email']) || $resItem['agentDetail']['email'] == "" ) {
					$resItem['agentEmail'] = "";
					$resItem['hideAgentEmail'] = "collapse printCollapse";
				} else {
					$resItem['agentEmail'] = $resItem['agentDetail']['email'];
					$resItem['hideAgentEmail'] = "imgLink";
				}
	
				$resItem['hideAgentPost'] = "visible";
	
				if ( !isset($resItem['agentPost']) || $resItem['agentPost'] == "" ) {
					$resItem['hideAgentPost'] = "hidden";
				}
	
				// Contact details ---------------------------------------------------------
				$resItem['contactName'] = $resItem['contactDetail']['name'];
	
				if ( !isset($resItem['contactDetail']['fax']) || $resItem['contactDetail']['fax'] == "" ) {
					$resItem['contactFax'] = "";
					$resItem['hideContactFax'] = "collapse printCollapse";
				} else {
					$resItem['contactFax'] = $resItem['contactDetail']['fax'];
					$resItem['hideContactFax'] = "expand";
				}
	
				if ( !isset($resItem['contactDetail']['telephone']) || $resItem['contactDetail']['telephone'] == "" ) {
					$resItem['contactTel'] = "";
					$resItem['hideContactTel'] = "collapse printCollapse";
				} else {
					$resItem['contactTel'] = $resItem['contactDetail']['telephone'];
					$resItem['hideContactTel'] = "expand";
				}
	
				if ( !isset($resItem['contactDetail']['email']) || $resItem['contactDetail']['email'] == "" ) {
					$resItem['contactEmail'] = "";
					$resItem['hideContactEmail'] = "collapse printCollapse";
				} else {
					$resItem['contactEmail'] = $resItem['contactDetail']['email'];
					$resItem['hideContactEmail'] = "imgLink";
				}
	
				$resItem['hideContactPost'] = "visible";
	
				if ( !isset($resItem['contactPost']) || $resItem['contactPost'] == "" ) {
					$resItem['hideContactPost'] = "hidden";
				}

				//debug($resItem['origDetail']);

				// Originator details -------------------------------------------------
				$resItem['origName'] = $resItem['origDetail']['name'];

				if ( !isset($resItem['origDetail']['fax']) || $resItem['origDetail']['fax'] == "" ) {
					$resItem['origFax'] = "";
					$resItem['hideOrigFax'] = "collapse printCollapse";
				} else {
					$resItem['origFax'] = $resItem['origDetail']['fax'];
					$resItem['hideOrigFax'] = "expand";
				}
				
				if ( !isset($resItem['origDetail']['telephone']) || $resItem['origDetail']['telephone'] == "" ) {
					$resItem['origTel'] = "";
					$resItem['hideOrigTel'] = "collapse printCollapse";
				} else {
					$resItem['origTel'] = $resItem['origDetail']['telephone'];
					$resItem['hideOrigTel'] = "expand";
				}

				if ( !isset($resItem['origDetail']['email']) || $resItem['origDetail']['email'] == "" ) {
					$resItem['origEmail'] = "";
					$resItem['hideOrigEmail'] = "collapse printCollapse";
				} else {
					$resItem['origEmail'] = $resItem['origDetail']['email'];
					$resItem['hideOrigEmail'] = "imgLink";
				}

				$resItem['hideOrigPost'] = "visible";

				if ( !isset($resItem['origPost']) || $resItem['origPost'] == "" ) {
					$resItem['hideOrigPost'] = "hidden";
				}

				// Agent countries ---------------------------------------------------------
				if ( $resItem['agentId'] != "0" && $resItem['agentId'] != "" ) {
					$resItem['physCountry'] = "Physical Country: " . $lDB->get("SELECT rf_country.rf_country_name FROM rf_country INNER JOIN pr_persona ON pr_persona.pr_phys_country_id = rf_country.rf_country_ix WHERE pr_persona.pr_persona_ix = '" . $resItem['agentId'] . "'",4);
					$resItem['hidephysCountry'] = "";
				} else {
					$resItem['hidephysCountry'] = "collapse printCollapse";
				}
	
				$resItem['consultantDetail']	= null;
				$resItem['agentDetail']				= null;
				$resItem['contactDetail']			= null;
				$resItem['origDetail']				= null;
	
				$resItem['payClass'] = "txtb";
	
				if ( $resItem['payPlan'] == "" ) {
					$resItem['paystyle'] = " style=\"visibility: hidden;\"";
				}
	
				$resItem['summRows']['html']							= __DIR__ . "/../../../public/html/rep_detbilling_summ_rows.htm";
				$resItem['accommRows']['html']						= __DIR__ . "/../../../public/html/rep_detbilling_acc_rows.htm";
				$resItem['extraRows']['html']							= __DIR__ . "/../../../public/html/rep_detbilling_extra_rows.htm";
				$resItem['extraRows']['htmlHide']					= "noExtras";
				$resItem['extraRows']['htmlActiveClass']	= "expand";
				$resItem['accomExtraRows']['html'] = __DIR__ . "/../../../public/html/rep_detbilling_acc_extra_rows.htm";
				$resItem['accomExtraRows']['htmlHide'] = "noAccomExtras";
				$resItem['accomExtraRows']['htmlActiveClass'] = "expand";
				$resItem['travelRows']['html']						= __DIR__ . "/../../../public/html/rep_detbilling_travel_rows.htm";
				$resItem['travelRows']['htmlHide']				= "noTravel";
				$resItem['travelRows']['htmlActiveClass']	= "expand";
	
				$compRowHTML = join("", file(__DIR__ . "/../../../public/html/rep_detbilling_component_rows.htm"));
				$compRows = "";
	
				$compSize = sizeof($resItem['compTotals']);
				$resItem['noComponents'] = "collapse printCollapse";
	
				if ( $compSize > "0" ) {
					$resItem['noComponents'] = "expand";
				}
				
				foreach ( $resItem['compTotals'] as $compCat => $compList ) {
					$first = true;
					foreach ( $compList as $compItem ) {
						$compItem['compDescClass'] = "br";
						$compItem['totClass'] = "";
	
						if ( $compItem['compDesc'] == "Totals" ) {
							$compItem['compDescClass'] = "colLtt br bt";
							$compItem['totClass'] = "bt";
						}
	
						$row = showpage($compItem,$compRowHTML);
	
						if ( $first && $compCat != "Totals" ) {
							$first = false;
							$row = str_replace("!cat!",$compCat,$row);
							$row = str_replace("!catClass!","outLtt",$row);
						} else {
							$row = str_replace("!cat!","",$row);
							$row = str_replace("!catClass!","br",$row);
						}
						$compRows .= $row;
					}
				}
	
				$resItem['compTotals'] = null;
	
				$exchangeRowHTML = Join("", file(__DIR__ . "/../../../public/html/rep_detbilling_exchange_rows.htm"));
				$exchangeRows = "";
	
				$exSize = sizeof($resItem['exchange']);
				$resItem['noExchange'] = "collapse printCollapse";
	
				if ( $exSize > "0" ) {
					$resItem['noExchange'] = "expand";
				}
	
				foreach ( $resItem['exchange'] as $exchangeItem ) {
					$exchangeRows .= showPage($exchangeItem,$exchangeRowHTML);
				}
	
				$resItem['exchange'] = $exchangeRows;
	
				$resItem['auditTrail']['html']						= __DIR__ . "/../../../public/html/rep_detbilling_audit_rows.htm";
				$resItem['auditTrail']['htmlHide']				= "noAuditTrail";
				$resItem['auditTrail']['htmlActiveClass']	= "expand";			
				
				$resItem['rooms']				= $resItem['rooming']['rooms'];
				$resItem['guestGroups']	= $resItem['rooming']['guestGroups'];
				$resItem['guestNotes']	= $resItem['rooming']['notes'];
				$resItem['guestMemos']	= $resItem['rooming']['memos'];
				$resItem['rooming']			= null;
	
				$resItem['rooms']['html']				= __DIR__ . "/../../../public/html/rep_detbilling_room_rows.htm";
				$resItem['guestGroups']['html']	= __DIR__ . "/../../../public/html/rep_detbilling_guest_rows.htm";
				$resItem['guestNotes']['html']	= __DIR__ . "/../../../public/html/rep_detbilling_guest_note_rows.htm";
				$resItem['guestMemos']['html']	= __DIR__ . "/../../../public/html/rep_detbilling_guest_note_rows.htm";
				
				$resRow = detailHTML($resItem);
				$resRow = str_replace("!costComponentRows!",$compRows,$resRow);
				$resRow = str_replace("!exchangeNote!",$resItem['exchangeNote'],$resRow);
				$resRow = str_replace("!exchange!",$exchangeRows,$resRow);
				$resRows .= $resRow;
			}
	
			if ( $renderMode == "pdf" ) {
				detailPDF($resItem,$pdf,$options);
				$pdf->AddPage();
			}
			
			if ( $renderMode == "csv" ) {
				if(empty($csvFile)) {
					$csvFile = array();
				}
				$csvFile = array_merge($csvFile,detailCSV($resItem,$options));
			}
		}
		if ( $renderMode == "html" ) {
			setRecordScroll($resScrollSet);
		}
	}

	// [START] LIST and FIND report
	if (
			(
				( $page > 0 && $renderMode == "html" )
				||
				(
					$renderMode == "pdf"
					&&
					( $renderType == "view" || $renderType == "send" )
					&&
					(
						( $report != "update" && $report != "arr/dep" )
						||
						(
							( $report == "update" || $report == "arr/dep" )
							&&
							$reportOptions[1] == "1"
						)
					)
				)
				||
				( $renderMode == "csv" )
			)
			&&
			( $options & REP_STYLE_LIST || $options & REP_STYLE_ITEM )
		) {

		if ( $options & REP_STYLE_LIST ) {
			 $sqlData = "SELECT DISTINCT
				rv_reservation.rv_reservation_ix AS resNum,
				rv_reservation_item.rv_reservation_item_ix AS resItemId,
				rv_reservation.rv_res_name AS resName,
				rv_reservation.rv_agent_id AS agentId,
				rv_reservation.rv_agent_ref AS agentRef,
				rv_reservation.rv_corr_persona_id AS contactId,
				rv_reservation.rv_consultant_id AS consultantId,
				rv_reservation.rv_provision_expiry_date AS provExpDt,
				rv_reservation.rv_date_consultant AS allocDate,
				rv_reservation.rv_date_recorded AS recordDate,
				rv_reservation.rv_date_changed AS amendDate,
				rv_reservation.rt_rate_type_id AS rateId,
				rv_reservation.rv_invoice_currency_id AS invCurrId,
				rv_reservation_item.rv_item_date_arrive AS resArrive,
				rv_reservation_item.rv_item_date_depart AS resDepart,
				rv_reservation_item.rv_item_accomm_count AS resRooms,
				rv_reservation_item.rv_item_adult_count AS numAdults,
				rv_reservation_item.rv_item_child_count AS numChild,
				rv_reservation.rv_commission_perc AS commPerc,
				rv_reservation.rv_commission_deduct_yn AS commDeductYn,
				rv_reservation.rv_exchg_rate AS exchRate,
				rv_reservation.ac_pay_plan_id AS payId,
				(TO_DAYS(rv_reservation_item.rv_item_date_depart) - TO_DAYS(rv_reservation_item.rv_item_date_arrive)) AS numNights,
				rf_reservation_status.rf_reservation_status_id AS resStatId,
				rf_reservation_status.rf_reservation_status_desc AS resStatus,
				ac_accomm_type.ac_accomm_desc AS accommType,
				ac_accomm_type.pr_business_id AS propId,
				pr_persona.pr_name_last AS propName,
				rf_source.rf_source_abbrv AS srcAbbrv
			";
	
			if ( $report != "update" ) {
				$sqlOrder = " ORDER BY ac_accomm_type.pr_business_id,rv_reservation_item.rv_item_date_arrive ASC,rv_reservation.rv_res_name ASC";
			} else {
				$sqlOrder = " ORDER BY ac_accomm_type.pr_business_id,rv_reservation.rv_reservation_ix ASC, rv_reservation_item.rv_item_date_arrive ASC";
			}
		} else {
			$sqlData = "SELECT DISTINCT
				rv_reservation.rv_reservation_ix AS resNum,
				rv_reservation.rv_res_name AS resName,
				rv_reservation.rv_agent_id AS agentId,
				rv_reservation.rv_agent_ref AS agentRef,
				rv_reservation.rv_provision_expiry_date AS provExpDt,
				rv_reservation.rv_date_arrive AS resArrive,
				rv_reservation.rv_date_depart AS resDepart,
				rv_reservation.rv_date_recorded AS createDate,
				rv_reservation.rv_date_changed AS amendDate,
				rv_reservation.rv_prov_date AS provDate,
				rf_reservation_status.rf_reservation_status_id AS resStatId,
				rf_reservation_status.rf_reservation_status_desc AS resStatus
			";
	
			$imgSort1Mode = "std";	// resNum ASC
			$imgSort2Mode = "std";	// - DESC
	
			$imgSort3Mode = "std";	// resName ASC
			$imgSort4Mode = "std";	// - DESC
	
			$imgSort5Mode = "std";	// status ASC
			$imgSort6Mode = "std";	// - DESC
	
			$imgSort7Mode = "std";	// agent ASC
			$imgSort8Mode = "std";	//	- DESC
	
			$imgSort9Mode = "std";	// arrive ASC
			$imgSort10Mode = "std";	// - DESC
			
			$imgSort11Mode = "std";	// Depart ASC
			$imgSort12Mode = "std";	//	- DESC
			
			$imgSort13Mode = "std";	// prov date ASC
			$imgSort14Mode = "std";	//	- desc)
	
			$sqlOrder = "ORDER BY ";
	
			switch ($sortBy) {
				case 0:
					$sqlOrder .= "rv_reservation.rv_reservation_id";
					$imgSort1Mode = "down";
					break;
	
				case 1:
					$sqlOrder .= "rv_reservation.rv_reservation_id desc";
					$imgSort2Mode = "down";
					break;
	
				case 2:
					$sqlOrder .= "rv_reservation.rv_res_name";
					$imgSort3Mode = "down";
					break;
	
				case 3:
					$sqlOrder .= "rv_reservation.rv_res_name desc";
					$imgSort4Mode = "down";
					break;
	
				case 4:
					$sqlOrder .= "rv_reservation.rf_reservation_status_id";
					$imgSort5Mode = "down";
					break;
	
				case 5:
					$sqlOrder .= "rv_reservation.rf_reservation_status_id desc";
					$imgSort6Mode = "down";
					break;
	
				case 6:
					$sqlOrder .= "rv_reservation.rv_agent_id";
					$imgSort7Mode = "down";
					break;
	
				case 7:
					$sqlOrder .= "rv_reservation.rv_agent_id desc";
					$imgSort8Mode = "down";
					break;
	
				case 8:
					$sqlOrder .= "rv_reservation.rv_date_arrive desc";
					$imgSort9Mode = "down";
					break;
	
				case 9:
					$sqlOrder .= "rv_reservation.rv_date_arrive ";
					$imgSort10Mode = "down";
					break;
	
				case 10:
					$sqlOrder .= "rv_reservation.rv_date_depart desc ";
					$imgSort11Mode = "down";
					break;
	
				case 11:
					$sqlOrder .= "rv_reservation.rv_date_depart";
					$imgSort12Mode = "down";
					break;
	
				case 12:
					$sqlOrder .= "rv_reservation.rv_provision_expiry_date desc ";
					$imgSort13Mode = "down";
					break;
	
				case 13:
					$sqlOrder .= "rv_reservation.rv_provision_expiry_date";
					$imgSort14Mode = "down";
					break;
			}
		}
	
		$resArray = $lDB->get($sqlData . $sqlFrom . $sqlDateWhere . $accommFilter['where'] . $statusFilter['where'] . $sourceFilter['where'] . $agentFilter['where'] . $contactFilter['where'] . $consultantFilter['where'] . $createdByFilter['where'] . $originatorFilter['where']. $nationalityFilter['where']. $rateFilter['where'] . $agentPostCountryFilter['where'] . $agentPhysCountryFilter['where'] . $sqlOrder .$sqlLimit,2);

			
		if ( $options & REP_STYLE_LIST ) {
			$resRows = "";
			$propName = "";
			$listRows = array();
			$listRows['html'] = __DIR__ . "/../../../public/html/res_list_item_rows.htm";
			$resNumArray = array();
	
			foreach ( $resArray as $key => $resItem ) {
				if ( !in_array($resItem['resNum'],$resNumArray) ) {
					array_push($resNumArray,$resItem['resNum']);
				}
	
				$resItem['resJob'] = "0";
	
				if ( canEditReservation($resItem['resNum']) ) {
					$resItem['resJob'] = "2";
				}
	
				if ( $propName != $resItem['propName'] ) {
					$propRow = array();
	
					$propRow['html']			= __DIR__ . "/../../../public/html/res_list_prop_rows.htm";
					$propRow['itemRows']		= isset($listRows) ? $listRows : "";
					$propRow['propName']		= isset($propName) ? $propName : "";
					$propRow['hideCreateHead']	= isset($GLOBALS['temp']['hideCreateHead']) ? $GLOBALS['temp']['hideCreateHead'] : "";
					$propRow['hideCreate']		= isset($GLOBALS['temp']['hideCreate']) ? $GLOBALS['temp']['hideCreate'] : "";
					$propRow['hideAmendedHead']	= isset($GLOBALS['temp']['hideAmendedHead']) ? $GLOBALS['temp']['hideAmendedHead'] : "";
					$propRow['hideAmended']		= isset($GLOBALS['temp']['hideAmended']) ? $GLOBALS['temp']['hideAmended'] : "";
					$propRow['hideProvHead']	= isset($GLOBALS['temp']['hideProvHead']) ? $GLOBALS['temp']['hideProvHead'] : "";
					$propRow['hideProv']		= isset($GLOBALS['temp']['hideProv']) ? $GLOBALS['temp']['hideProv'] : "";
					$propRow['hideStatusHead']	= isset($GLOBALS['temp']['hideStatusHead']) ? $GLOBALS['temp']['hideStatusHead'] : "";
					$propRow['expDateHead']		= isset($GLOBALS['temp']['expDateHead']) ? $GLOBALS['temp']['expDateHead'] : "";
					$propRow['hideStatus']		= isset($GLOBALS['temp']['hideStatus']) ? $GLOBALS['temp']['hideStatus'] : "";
					$propRow['expDate']			= isset($GLOBALS['temp']['expDate']) ? $GLOBALS['temp']['expDate'] : "";
					$propRow['table_width']			= isset($GLOBALS['temp']['table_width']) ? $GLOBALS['temp']['table_width'] : "123";
	
					if ( $propName != "" ) {
						$resRows .= renderHTML($propRow);
					}
	
					$propName = $resItem['propName'];
	
					$listRows = array();
					$listRows['html'] = __DIR__ . "/../../../public/html/res_list_item_rows.htm";
				}
	
				$consultant	= getPersonaDetail($resItem['consultantId']);
				$contact		= getPersonaDetail($resItem['contactId']);
				$agent			= getPersonaDetail($resItem['agentId']);
	
				if ( strlen($consultant['name']) > 10 && $renderMode != "csv" ) {
					$resItem['consultName']					= substr($consultant['name'],0,10) . "...";
					$resArray[$key]['consultName']	= substr($consultant['name'],0,10) . "..";
				} else {
					$resItem['consultName']					= $consultant['name'];
					$resArray[$key]['consultName']	= $consultant['name'];
				}
	
				$resItem['consultClick'] = "contactsEmail('".$consultant['email']."','".$resItem['resNum']."','".$resItem['consultantId']."');";
	
				if ( strlen($contact['name']) > 10 && $renderMode != "csv" ) {
					$resItem['contactName']					= substr($contact['name'],0,10) . "..";
					$resArray[$key]['contactName']	= substr($contact['name'],0,10) . "..";
				} else {
					$resItem['contactName']					= $contact['name'];
					$resArray[$key]['contactName']	= $contact['name'];
				}
	
				$resItem['contactClick'] = "contactsEmail('".$contact['email']."','".$resItem['resNum']."','".$resItem['contactId']."');";
	
				if ( strlen($agent['name']) > 10 && $renderMode != "csv" ) {
					$resItem['agentName']					= substr($agent['name'],0,10) . "..";
					$resArray[$key]['agentName']	= substr($agent['name'],0,10) . "..";
				} else {
					$resItem['agentName']					= $agent['name'];
					$resArray[$key]['agentName']	= $agent['name'];
				}
	
				$resItem['agentClick'] = "contactsEmail('".$agent['email']."','".$resItem['resNum']."','".$resItem['agentId']."');";

				if ( $agent['name'] == "" ) {
					$resItem['agentName']					= "Direct Booking";
					$resArray[$key]['agentName']	= "Direct Booking";
					$resItem['agentClick']				= "";
				}
	
				$resItem['accommType'] .= " ".getOptionalComponents($resItem['resItemId']);
	
				if ( strlen($resItem['accommType']) > 11 && $renderMode != "csv" ) {
					$resItem['accommType'] = substr($resItem['accommType'],0,11)."..";
				}
	
				$resArray[$key]['accommType'] .= " ".getOptionalComponents($resItem['resItemId']);
	
				if ( strlen($resItem['resName']) > 15 && $renderMode != "csv" ) {
					$resItem['resName'] = substr($resItem['resName'],0,15)."..";
				}
	
				$resItem['provColor'] = "";
	
				if ( $resItem['resStatId'] == "20" ) {
					$provExpDt = $resItem['provExpDt'];
					$today = date("Y-m-d");
	
					if ( $provExpDt == $today ) {
						$resItem['provColor'] = "#F1C55D";
					} elseif ($provExpDt < $today) {
						$resItem['provColor'] = "#DB4242";
					}
				}
	
				$resItem['cancelled'] = "";
	
				if ( $resItem['resStatId'] == "90" ) {
					$resItem['cancelled'] = "txtb";
				}
	
				$resItem['provExpDt'] = chng_date($resItem['provExpDt'],"-");
				$resItem['resArrive'] = chng_date($resItem['resArrive'],"-");
				$resItem['resDepart'] = chng_date($resItem['resDepart'],"-");
	
				array_push($resScrollSet,$resItem['resNum']);
				array_push($listRows,$resItem);
	
				$fullResList = join($resNumArray,",");
				$GLOBALS['temp']['fullResList'] = "<input type=\"hidden\" name=\"fullResList\" id=\"fullResList\" value=\"" . $fullResList . "\">";
			}
	
			if($renderMode == "html") {
				$propRow = array();
				$propRow['html'] = __DIR__ . "/../../../public/html/res_list_prop_rows.htm";
				$propRow['itemRows'] = $listRows;
				$propRow['propName'] = $propName;
				$propName = $resItem['propName'];
				$propRow['hideCreateHead'] = $GLOBALS['temp']['hideCreateHead'];
				$propRow['hideCreate'] = $GLOBALS['temp']['hideCreate'];
				$propRow['hideAmendedHead'] = $GLOBALS['temp']['hideAmendedHead'];
				$propRow['hideAmended'] = $GLOBALS['temp']['hideAmended'];
				$propRow['hideProvHead'] = $GLOBALS['temp']['hideProvHead'];
				$propRow['hideProv'] = $GLOBALS['temp']['hideProv'];
				$propRow['hideStatusHead'] = $GLOBALS['temp']['hideStatusHead'];
				$propRow['expDateHead'] = $GLOBALS['temp']['expDateHead'];
				$propRow['hideStatus'] = $GLOBALS['temp']['hideStatus'];
				$propRow['expDate'] = $GLOBALS['temp']['expDate'];
				$propRow['table_width'] = $GLOBALS['temp']['table_width'];
				$resRows .= renderHTML($propRow);
				$GLOBALS['temp']['hideButs'] = "off";
				$GLOBALS['temp']['hasPDF'] = "false";
				setRecordScroll($resScrollSet);
			}
	
			if ( $renderMode == "pdf" ) {
				listPDF($resArray,$pdf,$report,$options);
			}
	
			if ( $renderMode == "csv" ) {
				listCSV($resArray,$csvHeader,$reportName,$options, $report);
			}
		}
	
		// [START] Find Reservation -------------------------------------------------
		if ( $options & REP_STYLE_ITEM ) {
			if($report == "provisional") {
				$roomResArray = $lDB->get("
					$sqlData
					".str_replace("WHERE","
					LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
				WHERE
				",
					$sqlFrom).$accommFilter['where'] . $statusFilter['where'] . $sourceFilter['where'] . $agentFilter['where'] . $contactFilter['where'] . $consultantFilter['where'] . $createdByFilter['where'] . $originatorFilter['where']. $nationalityFilter['where']. $rateFilter['where'] . $agentPostCountryFilter['where'] . $agentPhysCountryFilter['where']."
				AND rv_reservation.rf_reservation_status_id = '20'
				AND rv_reservation.rv_provision_expiry_date < '".date("Y-m-d")."'
				$cancelDateSQL
				$travelDateSQL
				AND ac_accomm_room.ac_accomm_room_ix IS NOT NULL
				$sqlOrder
				",2);
				$newRoomResArray = array();
				foreach($roomResArray as $item) {
					$found = false;
					foreach($resArray as $resItem) {
						if($item['resNum'] == $resItem['resNum']) { 
							$found = true;
						}
					}
					if(!$found) {
						array_push($newRoomResArray,$item);
					}
				}
				foreach($newRoomResArray as $item) {
					array_unshift($resArray,$item);
				}

				foreach($resArray as $key=>$item) {
					$resArray[$key]['hasRooms'] = false;
					$roomCheck = $lDB->get("
						SELECT
							COUNT(*)
						FROM
							rv_reservation_item
							INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
							INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
						WHERE
							rv_reservation_item.rv_reservation_id = '$item[resNum]'
					",4);
					if($roomCheck > 0) {
						$resArray[$key]['hasRooms'] = true;
					}
					
					$itemList = $lDB->get("
						SELECT
							rv_reservation_item.ac_accomm_type_id,
							rv_reservation_item.rv_item_date_arrive,
							rv_reservation_item.rv_item_date_depart,
							rv_reservation_item.rv_item_accomm_count
						FROM
							rv_reservation_item
						WHERE
							rv_reservation_item.rv_reservation_id = '$item[resNum]'
					",2);
					$hasAvail = true;
					foreach($itemList as $resItem) {
						$fromDate = $resItem['rv_item_date_arrive'];
						$toDateArray = explode("-",$resItem['rv_item_date_depart']);
						$toDate = date("Y-m-d",mktime(0,0,0,$toDateArray[1],$toDateArray[2]-1,$toDateArray[0]));
						$stock = new Stock($resItem['ac_accomm_type_id'],$fromDate,$toDate);
						$avail =  $stock->ToAvailability();
						foreach($avail as $day) {
							if($item['provExpDt'] >= date("Y-m-d")) {
								if($day < 0) {
									$hasAvail = false;
								}
							} else {
								if($day - $resItem['rv_item_accomm_count'] < 0) {
									$hasAvail = false;
								}
							}
						}
					}
					$resArray[$key]['hasAvail'] = $hasAvail;
				}

			}
			$resRows = "";
			$propName = "";
			$findRows = array();
			if($report == "provisional") {
				$findRows['html']						= __DIR__ . "/../../../public/html/res_list_prov_rows.htm";
			} else {
				$findRows['html']						= __DIR__ . "/../../../public/html/res_list_find_rows.htm";
			}
			$resNumArray = array();
			$provResNumArray = array();
	
			foreach ( $resArray as $key => $resFind ) {
				$resFind['resJob'] = "0";
				$resFind['disableCheck'] = "disabled=\"disabled\"";
	
				if ( canEditReservation($resFind['resNum']) ) {
					$resFind['resJob'] = "2";
					$resFind['disableCheck'] = "";
				}
	
				if ( !in_array($resFind['resNum'],$resNumArray) ) {
					array_push($resNumArray,$resFind['resNum']);
				}
	
				$propArray = $lDB->get("
					SELECT DISTINCT
						pr_business.pr_bus_name_short AS propName
					FROM 
						rv_reservation_item
					INNER JOIN pr_business ON 
						pr_business.pr_business_id = rv_reservation_item.pr_business_id
					WHERE 
						rv_reservation_item.rv_reservation_id = '" . $resFind['resNum'] . "'
				",3);
	
				$properties = join(", ",$propArray);
	
				$resFind['properties']	= $properties;
				$resFind['links']				= "links";
	
				$agent = getPersonaDetail($resFind['agentId']);
	
				if ( strlen($agent['name']) > 10 && $renderMode != "csv" ) {
					$resFind['agentName']					= substr($agent['name'],0,10) . "..";
					$resArray[$key]['agentName']	= substr($agent['name'],0,10) . "..";
				} else {
					$resFind['agentName']					= $agent['name'];
					$resArray[$key]['agentName']	= $agent['name'];
				}
	
				$resFind['agentClick'] = "contactsEmail('" . $agent['email'] . "','" . $resFind['resNum'] . "','" . $resFind['agentId'] . "');";
	
				if ( $agent['name'] == "" ) {
					$resFind['agentName']					= "Direct Booking";
					$resFind['links']							= "txtbr txts";
					$resArray[$key]['agentName']	= "Direct Booking";
					$resFind['agentClick']				= "";
				}
	
				if ( strlen($resFind['resName']) > 15 && $renderMode != "csv" ) {
					$resFind['resName'] = substr($resFind['resName'],0,15)."..";
				}
	
				$resFind['provColor'] = "";
	
				if ( $resFind['resStatId'] == "20") {
					$provExpDt = $resFind['provExpDt'];
					$today = date("Y-m-d");
	
					if ( $provExpDt == $today ) {
						$resFind['provColor'] = "#f1c55d";
					} elseif ($provExpDt < $today) {
						$resFind['provColor'] = "#db4242";
					}
				}
	
				$resFind['cancelled'] = "";
	
				if ( $resFind['resStatId'] == "90" ) {
					$resFind['cancelled'] = "txtb";
				}
	
				$resFind['provExpDt'] = chng_date($resFind['provExpDt'],"-");
				$resFind['resArrive'] = chng_date($resFind['resArrive'],"-");
				$resFind['resDepart'] = chng_date($resFind['resDepart'],"-");
				$resFind['createDate'] = chng_date($resFind['createDate'],"-");
				$resFind['amendDate'] = chng_date($resFind['amendDate'],"-");
				$resFind['provDate'] = chng_date($resFind['provDate'],"-");

				$resFind['hasRoomsColour'] = "";
				$resFind['hasRoomsOver'] = "";
				$resFind['hasRoomsOut'] = "";
				$resFind['hasRoomsClick'] = "";
				$resFind['hasRooms'] = isset($resFind['hasRooms']) ? $resFind['hasRooms'] : false;
				if($resFind['hasRooms']) {
					$resFind['hasRooms'] = "";
					$resFind['hasNoRooms'] = "collapse printCollapse";
					$resFind['hasRoomsClick'] = "window.location='/reservation.php?216+$resFind[resNum]';";
					if ($provExpDt < $today) {
						$resFind['hasRoomsColour'] = "#db4242";
						$resFind['hasRoomsOver'] = "overlib('There are rooms being held by this expired provisional. Go to the reservation rooming tab to release the rooms.',LEFT);";
						$resFind['hasRoomsOut'] = "nd();";
					}
				} else {
					$resFind['hasRooms'] = "collapse printCollapse";
					$resFind['hasNoRooms'] = "";
				}

				$resFind['hasAvailColour'] = "";
				$resFind['hasAvailClick'] = "";
				$resFind['provCheckStyle'] = "";
				$resFind['hasAvail'] = isset($resFind['hasAvail']) ? $resFind['hasAvail'] : false;
				if($resFind['hasAvail']) {
					$resFind['hasAvail'] = "";
					$resFind['hasNoAvail'] = "collapse printCollapse";
					if ( !in_array($resFind['resNum'],$provResNumArray) ) {
						array_push($provResNumArray,$resFind['resNum']);
					}					
				} else {
					$resFind['hasAvail'] = "collapse printCollapse";
					$resFind['hasNoAvail'] = "button";
					$resFind['hasAvailColour'] = "#db4242";
					$resFind['provCheckStyle'] = "visibility: hidden;";
					$resFind['disableCheck'] = "disabled=\"disabled\"";
					$resFind['hasAvailClick'] = "overbookPopup('$resFind[resNum]');";
				}
	
				array_push($resScrollSet,$resFind['resNum']);
				array_push($findRows,$resFind);
			}
	
			$fullResList = join($provResNumArray,",");
			$GLOBALS['temp']['fullResList'] = "<input type=\"hidden\" name=\"fullResList\" id=\"fullResList\" value=\"" . $fullResList . "\">";
	
			if ( $renderMode == "html" ) {
				$propRow = array();
	
				if($report == "provisional") {
					$propRow['html']						= __DIR__ . "/../../../public/html/res_list_prov_prop.htm";
				} else {
					$propRow['html']						= __DIR__ . "/../../../public/html/res_list_find_prop.htm";
				}
				$propRow['findRows']			= $findRows;
				$propRow['propName']			= $propName;
				$propName						= isset($resFind['propName']) ? $resFind['propName'] : "";
				$propRow['imgSort1Mode']		= $imgSort1Mode;
				$propRow['hideCreateHead']		= $GLOBALS['temp']['hideCreateHead'];
				$propRow['hideCreate']			= $GLOBALS['temp']['hideCreate'];
				$propRow['hideAmendedHead']		= $GLOBALS['temp']['hideAmendedHead'];
				$propRow['hideAmended']			= $GLOBALS['temp']['hideAmended'];
				$propRow['hideProvHead']		= $GLOBALS['temp']['hideProvHead'];
				$propRow['hideProv']			= $GLOBALS['temp']['hideProv'];
				$propRow['hideStatusHead']		= $GLOBALS['temp']['hideStatusHead'];
				$propRow['expDateHead']			= $GLOBALS['temp']['expDateHead'];
				$propRow['hideStatus']			= $GLOBALS['temp']['hideStatus'];
				$propRow['expDate']				= $GLOBALS['temp']['expDate'];
				$propRow['chngProvHeader']		= $GLOBALS['temp']['chngProvHeader'];
				$propRow['chngProv']			= $GLOBALS['temp']['chngProv'];
				$propRow['table_width']			= $GLOBALS['temp']['table_width'];
	
				// Sorting columns --------------------------------------------------------
				$propRow['imgSort1Mode']		= $imgSort1Mode;
				$propRow['imgSort2Mode']		= $imgSort2Mode;
				$propRow['imgSort3Mode']		= $imgSort3Mode;
				$propRow['imgSort4Mode']		= $imgSort4Mode;
				$propRow['imgSort5Mode']		= $imgSort5Mode;
				$propRow['imgSort6Mode']		= $imgSort6Mode;
				$propRow['imgSort7Mode']		= $imgSort7Mode;
				$propRow['imgSort8Mode']		= $imgSort8Mode;
				$propRow['imgSort9Mode']		= $imgSort9Mode;
				$propRow['imgSort10Mode']		= $imgSort10Mode;
				$propRow['imgSort11Mode']		= $imgSort11Mode;
				$propRow['imgSort12Mode']		= $imgSort12Mode;
				$propRow['imgSort13Mode']		= $imgSort13Mode;
				$propRow['imgSort14Mode']		= $imgSort14Mode;
	
				$resRows .= renderHTML($propRow);
	
				$GLOBALS['temp']['hideButs']	= "off";
				$GLOBALS['temp']['hasPDF']		= "false";
				setRecordScroll($resScrollSet);
			}
	
			if ( $renderMode == "pdf" ) {
				findPDF($resArray,$pdf,$report,$options,$createDate,$amendDate,$provDate);
			}
	
			if ( $renderMode == "csv" ) {
				findCSV($resArray,$csvHeader,$reportName,$options,$createDate,$amendDate,$provDate);
			}
		}
		// [ END ] Find Reservation -----------------------------------------------
	}

	if ( $renderMode == "html" ) {
		$resRows = isset($resRows) ? $resRows : "";
		$GLOBALS['temp']['rows'] = $resRows;
		$GLOBALS['temp']['hideAll'] = "0";
		$GLOBALS['temp']['hideButts'] = "printCollapse colLt";
	
		if ( ($report == "update" || $report == "arr/dep") && $reportOptions[1] != "1" ) {
			$GLOBALS['temp']['hideButs'] = "off";
		}
	
		if ( isset($GLOBALS['temp']['hideButs']) && $GLOBALS['temp']['hideButs'] != "off" ) {
			$GLOBALS['temp']['hideButs'] = "1";
		}
	
		if ( !isset($totalCount) || $totalCount == 0 ) {
			$GLOBALS['temp']['hideAll']							= "0";
			$GLOBALS['temp']['hideButs']						= "off";
			$GLOBALS['temp']['hidePageSplit']				= "class=\"collapse printCollapse\"";
			$GLOBALS['temp']['rows']								= "<br><table class=\"blkBord\" width=\"770\" height=\"50\"><tr><td class=\"txt\" align=\"center\">&nbsp;&nbsp;No data matched your filter criteria.<br /> Please change your filters and press one of the report buttons above.</td></tr></table><br />";
			$GLOBALS['temp']['hideButts']						= "collapse printCollapse";
			$GLOBALS['temp']['filterStatus']				= "collapse printCollapse";
			$GLOBALS['temp']['showHideButtonText']	= ">> Show Filters";
			
			// List of ids for provisional expiry date update --------------------------
			$GLOBALS['temp']['fullResList'] = "";
		}
	}

	// [START] Financial report ---------------------------------------------------
	if (
			(
				( $renderMode == "html" )
				||
				(
					$renderMode == "pdf"
					&&
					( $renderType == "view" || $renderType == "send" )
					/*&&
					(
						( $report != "update" && $report != "arr/dep" )
						||
						(
							( $report == "update" || $report == "arr/dep" )
							&&
							$reportOptions[1] == "1"
						)
					)*/
				)
				||
				( $renderMode == "csv" )
			)
			&&
			( $options & REP_STYLE_FINANCIAL )
		) {
		
		$GLOBALS['temp']['hideButts'] = "colLt bl bb br";
		
		if ( $report == "update" ) {

			if ($reportOptions[4] != "1") {
				$dateRangeSQL .= " AND rv_reservation.rv_date_depart > '" . date("Y-m-d") . "' ";
			}			
			
			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$newSQL = "
					(
							rv_reservation.rv_date_recorded >= '" . $fromDate['jsDate'] . "' 
							AND 
							rv_reservation.rv_date_recorded <= '" . $toDate['jsDate'] . "'
						)
				";
			}
			
			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$amendedSQL = "
					(
						rv_reservation.rv_date_changed >= '" . $fromDate['jsDate'] . "' 
						AND 
						rv_reservation.rv_date_changed <= '" . $toDate['jsDate'] . "'
					)
				";
			}

			if ( ($updateNew && $updateAmended) || (!$updateNew && !$updateAmended) ) {
				$dateRangeSQL .= " AND (" . $newSQL . " OR " . $amendedSQL . ")";
			}

			if ( $updateNew && !$updateAmended ) {
				$dateRangeSQL .= " AND " . $newSQL;
			}

			if ( !$updateNew && $updateAmended ) {
				$dateRangeSQL .= " AND " . $amendedSQL;
			}
		} elseif ( $report == "consultant" ) {
			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$dateRangeSQL = "
				AND 
					(
						rv_reservation.rv_date_consultant >= '" . $fromDate['jsDate'] . "' 
						AND 
						rv_reservation.rv_date_consultant <= '" . $toDate['jsDate'] . "'
					)";
			}
		} elseif ( $report == "provisional" ) {
			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$dateRangeSQL = " 
					AND 
						rv_reservation.rv_provision_expiry_date >= '" . $fromDate['jsDate'] . "' 
					AND 
						rv_reservation.rv_provision_expiry_date <= '" . $toDate['jsDate'] . "' 
				";
			}
		} else {
			if (isset($fromDate['jsDate']) && isset($toDate['jsDate'])) {
				$dateRangeSQL = "
					AND (
						(
							rv_reservation.rv_date_arrive >= '" . $fromDate['jsDate'] . "' 
							AND 
							rv_reservation.rv_date_arrive <= '" . $toDate['jsDate'] . "'
						)
						OR 
						(
							rv_reservation.rv_date_depart >= '" . $fromDate['jsDate'] . "' 
							AND 
							rv_reservation.rv_date_depart <= '" . $toDate['jsDate'] . "'
						)
						OR 
						(
							rv_reservation.rv_date_arrive < '" . $fromDate['jsDate'] . "' 
							AND 
							rv_reservation.rv_date_depart > '" . $toDate['jsDate'] . "'
						)
					)
				";
			}
		}				
		if ( $fromD=="all" ) {
			$dateRangeSQL = "";
		}

		if($_SERVER['argv'][44] == '1') {
			$agentSQL = " AND rv_reservation.rv_agent_id = fn_folio.fn_folio_to_id";
			$GLOBALS['temp']['agentFolioCheck'] = "checked";
			$GLOBALS['temp']['allFolioCheck'] = "";
		}
		else{
			$agentSQL = " ";
			$GLOBALS['temp']['agentFolioCheck'] = "";
			$GLOBALS['temp']['allFolioCheck'] = "checked";
		}

		$html = "";

		$sqlData = "
			SELECT DISTINCT
		 		rv_reservation.rv_reservation_id,	
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rf_reservation_status.rf_reservation_status_desc,
				rf_reservation_status.rf_reservation_status_id AS resStatId,
				rv_reservation.rv_agent_id AS agentId,
				rv_reservation.rv_provision_expiry_date AS provExpDt,
				invoicing_unit.pr_name_first AS invoicing_unit_name_first,
				invoicing_unit.pr_name_last AS invoicing_unit_name_last,
				TRIM(if((invoicing_unit.pr_name_first<>'' OR invoicing_unit.pr_name_last<>''), CONCAT_WS(' ', invoicing_unit.pr_name_first,invoicing_unit.pr_name_last), 'Cash')) AS invoicing_unit_name,
				fn_folio.fn_folio_db AS environment,
				fn_invoice.fn_invoice_ix AS invoice_number,
				fn_folio.fn_folio_folio_num,
				fn_folio.fn_folio_to_id,
				rv_reservation.rv_date_arrive,
				rv_reservation.rv_date_depart,
				rf_currency.rf_currency_symbol AS currency,
				fn_folio.fn_folio_amount AS total,
				fn_folio.fn_folio_ix
			FROM 
				fn_folio
			INNER JOIN rv_reservation ON 
				rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			INNER JOIN rv_reservation_item ON 
				rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			LEFT JOIN pr_persona AS invoicing_unit ON
				fn_folio.fn_folio_to_id = invoicing_unit.pr_persona_ix 
			LEFT JOIN rf_currency ON
				rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			LEFT JOIN fn_invoice ON
				fn_invoice.fn_invoice_ix = fn_folio.fn_invoice_id
			INNER JOIN rf_reservation_status ON
				rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id 
			INNER JOIN ac_accomm_type ON 
				ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			WHERE 
				rv_reservation.rf_reservation_status_id != '25' 
			AND 
				rv_reservation_item.ac_accomm_type_id IN ('" . join("','",$accommList) . "')
			" . $dateRangeSQL;

		//$groupBy = " GROUP BY fn_folio.rv_reservation_id ";
	
		switch ( $sortBy ) {
			case 0:
				$sqlOrder = " ORDER BY rv_reservation.rv_reservation_id ASC ";
				break;
			case 1:
				$sqlOrder = " ORDER BY rv_reservation.rv_reservation_id DESC ";
				break;
			case 2:
				$sqlOrder = " ORDER BY rv_reservation.rv_res_name ASC ";
				break;
			case 3: 
				$sqlOrder = " ORDER BY rv_reservation.rv_res_name DESC ";
				break;
			case 4:
				$sqlOrder = " ORDER BY invoicing_unit_name ASC ";
				break;
			case 5:
				$sqlOrder = " ORDER BY invoicing_unit_name DESC ";
				break;
			case 6:
				$sqlOrder = " ORDER BY environment ASC ";
				break;
			case 7:
				$sqlOrder = " ORDER BY environment DESC ";
				break;
			case 8:
				$sqlOrder = " ORDER BY fn_folio.fn_folio_folio_num ASC ";
				break;
			case 9:
				$sqlOrder = " ORDER BY fn_folio.fn_folio_folio_num DESC ";
				break;
			case 10:
				$sqlOrder = " ORDER BY rv_reservation.rv_date_arrive ASC ";
				break;
			case 11:
				$sqlOrder = " ORDER BY rv_reservation.rv_date_arrive DESC ";
				break;
			case 12:
				$sqlOrder = " ORDER BY rv_reservation.rv_date_depart ASC ";
				break;
			case 13:
				$sqlOrder = " ORDER BY rv_reservation.rv_date_depart DESC ";
				break;
			case 14:
				$sqlOrder = " ORDER BY currency ASC ";
				break;
			case 15:
				$sqlOrder = " ORDER BY currency DESC ";
				break;
			case 16:
				$sqlOrder = " ORDER BY total ASC ";
				break;
			case 17:
				$sqlOrder = " ORDER BY total DESC ";
				break;
			case 18:
				$sqlOrder = " ORDER BY rf_reservation_status_desc ASC ";
				break;
			case 19:
				$sqlOrder = " ORDER BY rf_reservation_status_desc DESC ";
				break;
			default:
				$sqlOrder = " ORDER BY rv_reservation.rv_reservation_ix ASC ";
		}
	
		// Image highlighting -------------------------------------------------------
		$z = array();
	
		for ( $i = 0; $i < 21; $i++ ) {
			if ( $i == $sortBy ) {
				$z[$i] = "_z";
			} else {
				$z[$i] = "";
			}
		}
		
		$resArray = $lDB->get(
			$sqlData
			. $accommFilter['where']
			. $statusFilter['where']
			. $sourceFilter['where']
			. $agentFilter['where']
			. $contactFilter['where']
			. $consultantFilter['where']
			. $createdByFilter['where']
			. $originatorFilter['where']
			. $nationalityFilter['where']
			. $rateFilter['where']
			. $agentPostCountryFilter['where']
			. $agentPhysCountryFilter['where']
			. $agentSQL
			. $travelDateSQL
			. $sqlOrder,2);			

		if ( count($resArray) > 0 ) {
			if ( $renderMode == "html" ) {
				$html .= "<div id=\"showFinancialColumns\" class=\"showFinancialColumns\" style=\"display: none; padding: 2px 0;\">\n<table width=\"770\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\">\n<tr>\n<td align=\"right\"><input type=\"button\" class=\"button\" style=\"width: 100px; height: 20px;\" value=\"Show all columns\" onclick=\"hideCol('showFinancialColumns');\" /></td>\n</tr>\n</table>\n</div>";
				$html .= "
					<table width=\"770\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\" align=\"center\" class=\"bAll\" style=\"table-layout: fixed;\">\n
						<col id=\"res_number\" class=\"res_number\" width=\"50\" />\n						
						<col id=\"res_name\" class=\"res_name\" width=\"125\" />\n
						<col id=\"status\" class=\"status\" width=\"75\" />\n						
						<col id=\"invoice\" class=\"invoice\" width=\"135\" />\n
						<col id=\"env\" class=\"env\" width=\"45\" />\n
						<col id=\"folio\" class=\"folio\" width=\"75\"/>\n
						<col id=\"arrive\" class=\"arrive\" width=\"70\" />\n
						<col id=\"depart\" class=\"depart\" width=\"70\" />\n
						<col id=\"currency\" width=\"50\" />\n
						<col id=\"total\" align=\"right\" width=\"75\" />\n
						<tr>\n
							<td align=\"center\" class=\"colDK br bb txtb res_number\">Res #<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[0] . ".gif\" onclick=\"chngSort(0);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[1] . ".gif\" onclick=\"chngSort(1);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/column_hide.gif\" onclick=\"hideCol('res_number');\" alt=\"Collapse this column\" title=\"Collapse this column\" class=\"imgLink\" /></div></td>\n
							
							<td align=\"center\" class=\"colDk br bb txtb res_name\">Res Name<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[2] . ".gif\" onclick=\"chngSort(2);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[3] . ".gif\" onclick=\"chngSort(3);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/column_hide.gif\" onclick=\"hideCol('res_name');\" alt=\"Collapse this column\" title=\"Collapse this column\" class=\"imgLink\" /></div></td>\n
							
							<td align=\"center\" class=\"colDk br bb txtb status\">Status<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[18] . ".gif\" onclick=\"chngSort(18);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[19] . ".gif\" onclick=\"chngSort(19);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/column_hide.gif\" onclick=\"hideCol('status');\" alt=\"Collapse this column\" title=\"Collapse this column\" class=\"imgLink\" /></div></td>\n
							
							<td align=\"center\" class=\"colDk br bb txtb invoice\">Invoice to<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[4] . ".gif\" onclick=\"chngSort(4);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[5] . ".gif\" onclick=\"chngSort(5);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/column_hide.gif\" onclick=\"hideCol('invoice');\" alt=\"Collapse this column\" title=\"Collapse this column\" class=\"imgLink\" /></div></td>\n
							
							<td align=\"center\" class=\"colDk br bb txtb env\">Env<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[6] . ".gif\" onclick=\"chngSort(6);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[7] . ".gif\" onclick=\"chngSort(7);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/column_hide.gif\" onclick=\"hideCol('env');\" alt=\"Collapse this column\" title=\"Collapse this column\" class=\"imgLink\" /></div></td>\n
							
							<td align=\"center\" class=\"colDk br bb txtb folio\">Folio<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[8] . ".gif\" onclick=\"chngSort(8);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[9] . ".gif\" onclick=\"chngSort(9);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/column_hide.gif\" onclick=\"hideCol('folio');\" alt=\"Collapse this column\" title=\"Collapse this column\" class=\"imgLink\" /></div></td>\n
							
							<td align=\"center\" class=\"colDk br bb txtb arrive\">Arrival<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[10] . ".gif\" onclick=\"chngSort(10);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[11] . ".gif\" onclick=\"chngSort(11);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/column_hide.gif\" onclick=\"hideCol('arrive');\" alt=\"Collapse this column\" title=\"Collapse this column\" class=\"imgLink\" /></div></td>\n
							
							<td align=\"center\" class=\"colDk br bb txtb depart\">Depart<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[12] . ".gif\" onclick=\"chngSort(12);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[13] . ".gif\" onclick=\"chngSort(13);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/column_hide.gif\" onclick=\"hideCol('depart');\" alt=\"Collapse this column\" title=\"Collapse this column\" class=\"imgLink\" /></div></td>\n
							
							<td align=\"center\" class=\"colDk br bb txtb\">Curr<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[14] . ".gif\" onclick=\"chngSort(14);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[15] . ".gif\" onclick=\"chngSort(15);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /></div></td>\n
		
							<td align=\"center\" class=\"colDk bb txtb\">Total<div><img src=\"/resource/Resrequest/Application/public/img/arrow_up_16" . $z[16] . ".gif\" onclick=\"chngSort(16);\" alt=\"Ascending order\" title=\"Ascending order\" class=\"imgLink\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16" . $z[17] . ".gif\" onclick=\"chngSort(17);\" alt=\"Descending order\" title=\"Descending order\" class=\"imgLink\" /></div></td>\n
						</tr>\n
				";

				$out = array();
				$totals = array();
				$out['html']					= __DIR__ . "/../../../public/html/rep_standard_financial.htm";

				foreach ( $resArray as $k => $row ) {

					$f['res_number']	= $row['rv_reservation_ix'];
					$f['res_name']		= $row['rv_res_name'];

					if ( strlen($f['res_name']) > 16 ) {
						$f['res_name']	= substr($f['res_name'],0,16) . "...";
					}

					$f['status']			= $row['rf_reservation_status_desc'];

					$f['provColor'] = "#FFFFFF";
	
					if ( $row['resStatId'] == "20") {
						$provExpDt = $row['provExpDt'];
						$today = date("Y-m-d");
		
						if ( $provExpDt == $today ) {
							$f['provColor'] = "#f1c55d";
						} elseif ($provExpDt < $today) {
							$f['provColor'] = "#db4242";
						}
					}
		
					$f['cancelled'] = "";
		
					if ( $row['resStatId'] == "90" ) {
						$f['cancelled'] = "txtb";
					}

					$row['invoicing_unit_name'] = trim($row['invoicing_unit_name']);

					if ( $row['invoicing_unit_name'] == "" ) {
						$f['inv'] = "Cash";
					} else {
						$f['inv'] = $row['invoicing_unit_name'];
					}
					
					if ( strlen($f['inv']) > 17 ) {
						$f['inv'] = substr($f['inv'],0,17) . "..";
					}

					$f['env']					= $row['environment'];

					if ( trim($row['invoice_number']) != "" ) {
						$f['folio_num'] = $row['invoice_number'];
					} else {
						$f['folio_num']	= $row['fn_folio_folio_num'];
					}

					$f['arrive']			= chng_date($row['rv_date_arrive'],"-");
					$f['depart']			= chng_date($row['rv_date_depart'],"-");

					$hasTBA = true;
					$accommCount = $lDB->get("
						SELECT
							COUNT(*)
						FROM
							rv_reservation_item
						WHERE
							rv_reservation_item.fn_folio_id = '" . $row['fn_folio_ix'] . "'
					",4);
					$tbaCountList = $lDB->get("
						SELECT
							COUNT(rv_res_item_comp.rv_res_item_comp_ix)
						FROM
							rv_reservation_item
							LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
						WHERE
							rv_reservation_item.fn_folio_id = '" . $row['fn_folio_ix'] . "'
						GROUP BY
							rv_reservation_item.rv_reservation_item_ix
					",3);

					$tbaCount = true;

					foreach ( $tbaCountList as $tbaItem ) {
						if ( $tbaItem == "0" ) {
							$tbaCount = false;
						}
					}

					if ( $accommCount == "0" || $tbaCount ) {
						$hasTBA = false;
					}

					if ( $hasTBA ) { 
						$f['total'] = "TBA";
					} else {
						$f['total'] = $row['total'];
					}

					$f['currency']		= $row['currency'];

					array_push($out,$f);

					if (!$hasTBA ) { 
						if (isset($totals[$row['currency']])) {
							$totals[$row['currency']] += $row['total'];
						} else {
							$totals[$row['currency']] = $row['total'];
						}
					}
				}

				asort($totals);

				$html .= renderHTML($out);

				// Total row for each currency --------------------------------------------
				foreach ( $totals as $currency => $value ) {
					fixAmtDisplay($value);
					$html .= "<tr>\n<td colspan=\"7\" class=\"colLt bt bb totalRow\"></td><td align=\"right\" class=\"colLt bt br bb\"><b>Total</b>&nbsp;&nbsp;</td><td align=\"center\" class=\"bt br bb\"><b>" . $currency . "</b></td><td align=\"right\" class=\"bt bb\"><b>" . $value . "</b></td>\n</tr>\n";
				}
				
				$html .= "</table>";
				$GLOBALS['temp']['rows'] = $html;
			}
		} else {
			$GLOBALS['temp']['hideButts'] = "collapse printCollapse";
			$GLOBALS['temp']['rows'] = "<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"\" class=\"bAll\">\n<tr>\n<td align=\"center\">No data matched your filter criteria.<br />Please change your filters and press one of the report buttons above.</td>\n</tr>\n</table>\n";		
		}

		if ( $renderMode == "pdf" ) {
			$pdf->Row(array(
				array('width' => "8%",	'data' => "Res. #", 'border' => "TRBL",	'fill' => 1),
				array('width' => "20%",	'data' => "Res Name",	'border' => "TRBL",	'fill' => 1),
				array('width' => "9%",	'data' => "Status",	'border' => "TRBL",	'fill' => 1),
				array('width' => "15%",	'data' => "Invoice to", 'border' => "TRBL",	'fill' => 1),
				array('width' => "5%",	'data' => "Env",		'border' => "TRBL",	'fill' => 1),
				array('width' => "5%",	'data' => "Folio",	'border' => "TRBL",	'fill' => 1),
				array('width' => "10%",	'data' => "Arrive",	'border' => "TRBL",	'fill' => 1),
				array('width' => "10%",	'data' => "Depart",	'border' => "TRBL",	'fill' => 1),
				array('width' => "8%",	'data' => "Curr",		'border' => "TRBL",	'fill' => 1,	'align' => "C"),
				array('width' => "10%",	'data' => "Total",	'border' => "TRBL",	'fill' => 1,	'align' => "R")
			));

			$totals = array();
			$folio_num = "";

			foreach ( $resArray as $k => $row ) {
				$pdfRow = array();
				
				if ( strlen($row['rv_res_name']) > 15 ) {
					$row['rv_res_name']	= substr($row['rv_res_name'],0,15) . "...";
				}

				if ( trim($row['invoice_number']) != "" ) {
					$folio_num = $row['invoice_number'];
				} else {
					$folio_num = $row['fn_folio_folio_num'];
				}
				
				$invoice_to = trim($row['invoicing_unit_name']);

				if ( $invoice_to == "" ) {
					$invoice_to = "Cash";
				}
				
				if ( strlen($invoice_to) > 14 ) {
					$invoice_to = substr($invoice_to,0,14) . "...";
				}
				
				$hasTBA = true;
				$accommCount = $lDB->get("
					SELECT
						COUNT(*)
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.fn_folio_id = '$row[fn_folio_ix]'
				",4);
				$tbaCountList = $lDB->get("
					SELECT
						COUNT(rv_res_item_comp.rv_res_item_comp_ix)
					FROM
						rv_reservation_item
						LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					WHERE
						rv_reservation_item.fn_folio_id = '$row[fn_folio_ix]'
					GROUP BY
						rv_reservation_item.rv_reservation_item_ix
				",3);

				$tbaCount = true;

				foreach($tbaCountList as $tbaItem) {
					if($tbaItem == "0") {
						$tbaCount = false;
					}
				}

				if($accommCount == "0" || $tbaCount) {
					$hasTBA = false;
				}

				if ( $hasTBA ) { 
					$row['total'] = "TBA";
				}

				$provFill = 0;
				$provColor = array(0xff,0xff,0xff);
				if ( $row['resStatId'] == "20") {
					$provExpDt = $row['provExpDt'];
					$today = date("Y-m-d");
	
					if ( $provExpDt == $today ) {
						$provColor = array(0xf1,0xc5,0x5d);
					} elseif ($provExpDt < $today) {
						$provColor = array(0xdb,0x42,0x42);
					}
					$provFill = 1;
				}
	
				$cancelled = "";
	
				if ( $row['resStatId'] == "90" ) {
					$cancelled = "B";
				}

				array_push($pdfRow,
					array('width' => "8%",	'data' => $row['rv_reservation_ix'], 'border' => "TRBL"),
					array('width' => "20%",	'data' => $row['rv_res_name'], 'border' => "TRBL"),
					array('width' => "9%",	'data' => $row['rf_reservation_status_desc'],	'border' => "TRBL", 'fill' =>$provFill, 'fillColor' =>$provColor, 'style' => $cancelled),
					array('width' => "15%",	'data' => $invoice_to, 'border' => "TRBL"),
					array('width' => "5%",	'data' => $row['environment'], 'border' => "TRBL"),
					array('width' => "5%",	'data' => $folio_num,	'border' => "TRBL"),
					array('width' => "10%",	'data' => chng_date($row['rv_date_arrive'],"-"),'border' => "TRBL"),
					array('width' => "10%",	'data' => chng_date($row['rv_date_depart'],"-"),'border' => "TRBL"),
					array('width' => "8%",	'data' => $row['currency'], 'border' => "TRBL",	'align' => "C"),
					array('width' => "10%",	'data' => $row['total'], 'border' => "TRBL",	'align' => "R")
				);
				$pdf->Row($pdfRow);

				if (isset($totals[$row['currency']])) {
					$totals[$row['currency']] += $row['total'];
				} else {
					$totals[$row['currency']] = $row['total'];
				}
			}

			asort($totals);

			// Total row for each currency ---------------------------------------------
			foreach ( $totals as $currency => $value ) {
				fixAmtDisplay($value);
				$pdf->Row(array(
					array('width' => "82%",	'data' => "<B>TOTAL</B>",	'border' => "TRBL",	'align' => "R",	'fill' => 1),
					array('width' => "8%",	'data' => $currency,			'border' => "TRBL",	'align' => "C"),
					array('width' => "10%",	'data' => $value,					'border' => "TRBL",	'align' => "R")
				));
			}
		}

		if ( $renderMode == "csv" ) {
			$csvFile = array();

			// Header ----------------------------------------------------------------
			foreach($csvHeader as $head){
				$head[0] = isset($head[0]) ? $head[0] : "";
				$head[1] = isset($head[1]) ? $head[1] : "";
				array_push($csvFile,array($head[0],$head[1]));
			}
			
			array_push($csvFile,array());
			
			array_push($csvFile,array("<B>Res No</B>", "<B>Res Name</B>", "<B>Status</B>", "<B>Invoice To</B>", "<B>Env</B>", "<B>Folio</B>", "<B>Arrival</B>", "<B>Depart</B>", "<B>Currency</B>", "<B>Total</B>"));	

			$totals = array();

			foreach ( $resArray as $k => $row ) {
				$csvRow = array();				

				if ( trim($row['invoice_number']) != "" ) {
					$folio_num = $row['invoice_number'];
				} else {
					$folio_num = $row['fn_folio_folio_num'];
				}

				$hasTBA = true;
				$accommCount = $lDB->get("
					SELECT
						COUNT(*)
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.fn_folio_id = '$row[fn_folio_ix]'
				",4);
				$tbaCountList = $lDB->get("
					SELECT
						COUNT(rv_res_item_comp.rv_res_item_comp_ix)
					FROM
						rv_reservation_item
						LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					WHERE
						rv_reservation_item.fn_folio_id = '$row[fn_folio_ix]'
					GROUP BY
						rv_reservation_item.rv_reservation_item_ix
				",3);

				$tbaCount = true;

				foreach($tbaCountList as $tbaItem) {
					if($tbaItem == "0") {
						$tbaCount = false;
					}
				}

				if($accommCount == "0" || $tbaCount) {
					$hasTBA = false;
				}

				if ( $hasTBA ) { 
					$row['total'] = "TBA";
				}
				
				$inv_to_csv = trim($row['invoicing_unit_name_first'] . " " . $row['invoicing_unit_name_last']);

					if ( $inv_to_csv == "" ) {
						$inv_to_csv = "Cash";
					} 
				array_push($csvRow,$row['rv_reservation_ix'],$row['rv_res_name'],$row['rf_reservation_status_desc'],$inv_to_csv,$row['environment'],$folio_num,$row['rv_date_arrive'],$row['rv_date_depart'],$row['currency'],$row['total']);				

				if (isset($totals[$row['currency']])) {
					$totals[$row['currency']] += $row['total'];
				} else {
					$totals[$row['currency']] = $row['total'];
				}
				array_push($csvFile,$csvRow);	
			}
			
			asort($totals);

			// Total row for each currency ---------------------------------------------
			foreach ( $totals as $currency => $value ) {
				fixAmtDisplay($value);
				array_push($csvFile,array("","","","","","","","TOTAL",$currency,$value));
			}
			outputCSV($csvFile, $reportName);
		}
	}
	// [ END ] Financial report ---------------------------------------------------	

	if ( $renderMode == "pdf" && ($renderType == "view" || $renderType == "send") ) {
		if ( $renderType == "view" ) {
			if ( $GLOBALS['showTime'] ) {
				$GLOBALS['timeEnd'] = getmicrotime();
	
				$timeTaken = $GLOBALS['timeEnd'] - $GLOBALS['timeStart'];
	
				$pdf->Ln(10);
	
				$resSize = sizeof($resArray);
	
				if ( $resSize == 0 ) {
					$resSize = 1;
				}
	
				$pdf->Row(array(
					array('data'=>"Time taken: " . $timeTaken . " seconds, " . ($timeTaken/$resSize . " per record, total records " . sizeof($resArray)))
				));
			}
			$pdf->OutPut();
			die();
		}
	
		if ( $renderType == "send" ) {
			$to 		= $_POST['mail_to'];
			$from 		= $_POST['mail_from'];
			$subject 	= stripslashes($_POST['mail_subj']);
			$message 	= stripslashes($_POST['mail_body']);
			$attachmentName	= $_POST['attachmentName'];

			if ( !isset($principalName) ) {
				// get principal
				$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
				$principalName = getContactFullName($principalId);
			}

			$headers = "From: " . $principalName . "<" . $from . ">\r\n";

			if ( $pdf->state < 3 ) {
				$pdf->Close();
			}
	
			if ( $attachmentName != "!attachmentName!" ) {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from " . $fromDate . " to " . $toDate . ".pdf";
			}
	
			$error = email($from, $to, $subject, $headers, $message, 0, 0, $fromD, $principalName,$pdf->buffer,$pdfName);
	
			if ( !$error ) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
		}
	}

	if ( $renderMode == "csv" ) {
		outputCSV($csvFile, $reportName);
	}
} else {
	$GLOBALS['temp']['hideAll'] = "1";
	$GLOBALS['temp']['options'] = (REP_BUTTON_DETAILS | REP_BUTTON_FINANCIAL | REP_BUTTON_ITINERARY | REP_BUTTON_PAYMENT_SUMMARY);
}

function detailHTML(&$data) {
	$hideList = array(
		array('data' => "resNote",					'id' => "noResNotes"),
		array('data' => "guestInfo",				'id' => "noGuest"),
		array('data' => "extraNote",				'id' => "noExtraNotes"),
		array('data' => "travelNote",				'id' => "noTravelNotes"),
		array('data' => "resIntNote",				'id' => "noResInt"),
		array('data' => "guestNationality",	'id' => "noGuestNationality"),
		array('data' => "cancelNote",				'id' => "noCancelNote"),
		array('data' => "extIntNote",				'id' => "noExtInt"),
		array('data' => "travIntNote",			'id' => "noTravInt")
	);

	reset($hideList);

	foreach ( $hideList as $item ) {
		if ( is_array($data[$item['data']]) ) {
			if ( sizeof($data[$item['data']]) > 0 ) {
				$data[$item['id']] = "expand";
			} else {
				$data[$item['id']] = "collapse printCollapse";
			}
			$data[$item['data']] = renderNoteHTML($data[$item['data']]);
		} else {
			if ( trim($data[$item['data']]) == "" || $data[$item['data']] == "FALSE" ) {
				$data[$item['id']] = "collapse printCollapse";
			} else {
				$data[$item['id']] = "expand";
			}
			$data[$item['data']] = t_encodeHTML($data[$item['data']]);
		}
	}

	if ( trim($data['resIntNote']) == "" && $data['extIntNote'] == "" && $data['travIntNote'] == "" && $data['cancelNote'] == "" && $data['guestNationality'] == "" ) {
		$data['noIntNotes'] = "collapse printCollapse";
	} else {
		$data['noIntNotes'] = "expand";
	}
	return renderHTML($data);
}

function renderNoteHTML(&$data) {
	$html = "";

	foreach ( $data as $key => $value ) {
		if ( trim($value['property']) != "" ) {
			$html .= "<u>" . t_encodeHTML($value['property']) . "</u><br />";
		}
		if ( trim($value['rv_extra_ref']) != "" ) {
			$html .= "Reference:" . t_encodeHTML($value['rv_extra_ref']) . "<br />";
		}
		if ( trim($value['supplier_name']) != "" ) {
			$html .= "Service By:" . t_encodeHTML($value['supplier_name']) . "<br />";
		}
		if ( $value['serviceDate'] != "0000-00-00" && $value['serviceDate'] != "0" && trim($value['serviceDate']) != "" ) {
			if($value['travelType'] == 3) {
				$html .= chng_date($value['serviceDate'],"-")." to ".chng_date($value['departDate'],"-")." (".$value['noNgts']." nights): ";
			} else {
				$html .= chng_date($value['serviceDate'],"-").": ";
			}
		}

		$html .= t_encodeHTML($value['description']);

		if ( array_key_exists("extraCat",$value) ) {
			if ( $value['extraCat'] != "" ) {
				$html .= " (" . $value['extraCat'] . ")";
			} else {
				$html .= "";
			}
		}
		$html .= "<br />" . t_encodeHTML($value['note']) . "<br /><br />";
	}
	return $html;
}

function renderHTMLOld(&$data) {
	// Note: Can't have any non-html related arrays in $data, needs to be fixed
	// Eg: $data['consultantDetail'] has to be set to NULL
	// Note: Must end with an array, if there are not arrays, add an empty one, needs to be fixed
	$html = Join("", file(__DIR__ . "/" . $data['html']));
	$htmlLine = "";
	$htmlHide = true;

	foreach ( $data as $key => $value ) {
		if ( $key != 0 && ( $key == "html" || $key == "htmlHide" ) ) {
			continue;
		}

		if ( is_array($value) ) {
			if ( array_key_exists("html",$value) ) {
				$htmlRender = renderHTML($value);

				if ( array_key_exists("htmlHide",$value) ) {
					if ( $htmlRender == "" ) {
						$html = str_replace("!".$value['htmlHide']."!","collapse",$html);
					} else {
						$html = str_replace("!".$value['htmlHide']."!",$value['htmlActiveClass'],$html);
					}
				}
				$html = str_replace("!".$key."!",$htmlRender,$html);
				$htmlHide = false;
			} else {
				foreach ( $value as $kValue => $vValue ) {
					$value[$kValue] = t_encodeHTML($value[$kValue]);
				}
				$htmlLine .= showpage($value,$html);
			}
		} else {
			$html = str_replace("!".$key."!",$value,$html);
		}
	}

	if ( $htmlLine != "" || $htmlHide ) {
		return $htmlLine;
	} else {
		return $html;
	}
}

function renderHTML(&$data) {
	// Note: Can't have any non-html related arrays in $data, needs to be fixed
	// Eg: $data['consultantDetail'] has to be set to NULL
	// Note: Must end with an array, if there are not arrays, add an empty one, needs to be fixed
	$html = join("", file($data['html']));
	$htmlLine = "";
	$htmlHide = true;
	$htmlTemp = "";
	
	foreach($data as $key=>$value) {
		if($key!=0&&($key=="html"||$key=="htmlHide"||$key=="htmlRow")) {
			continue;
		}
		
		if ( is_array($value) ) {
			if ( array_key_exists("html",$value) ) { 
				$htmlRender = renderHTML($value);
				if ( array_key_exists("htmlHide",$value) ) {
					if ( $htmlRender == "" ) {
						$html = str_replace("!".$value['htmlHide']."!","collapse printCollapse",$html);
					} else {
						$html = str_replace("!".$value['htmlHide']."!",$value['htmlActiveClass'],$html);
					}
				}
				$html = str_replace("!".$key."!",$htmlRender,$html);
				$htmlHide = false;
			} elseif ( array_key_exists("htmlRow",$value) ) {
				$htmlPerRow = $html;
				foreach ( $value as $kValue => $vValue ) {
					if ( $kValue != "htmlRow" ) {
						if ( is_array($vValue) ) {
							$htmlTemp .= str_replace("!".$kValue."!",renderHTML($vValue),$htmlPerRow);
						} else {
							$htmlPerRow = str_replace("!".$kValue."!",$vValue,$htmlPerRow);
						}
					}
				}
				$htmlLine = $htmlTemp;
			} else {
				foreach ( $value as $kValue => $vValue ) {
					$value[$kValue] = t_encodeHTML($value[$kValue]);
				}
				$htmlLine .= showpage($value,$html);
			}
		} else {
			$html = str_replace("!".$key."!",$value,$html);
		}
	}

	if($htmlLine != "" || $htmlHide) {		
		return $htmlLine;
	} else {			
		return $html;
	}
}


function getReservationItems($resNum,$propertyDetail,$accommFilter) {
	$sqlFilter = "";
	if($propertyDetail == "1") {
		$sqlFilter = $accommFilter['where'];
	}
	$itemArray = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_item_date_arrive as resArrive,
			rv_reservation_item.rv_item_date_depart as resDepart,
			rv_reservation_item.rv_item_accomm_count as resRooms,
			rv_reservation_item.rv_item_adult_count as numAdults,
			rv_reservation_item.rv_item_child_count as numChild,
			(TO_DAYS(rv_reservation_item.rv_item_date_depart) - TO_DAYS(rv_reservation_item.rv_item_date_arrive)) as numNights,
			ac_accomm_type.ac_accomm_desc as accommType,
			pr_persona.pr_name_last as propName,
			rv_reservation_item.rv_reservation_item_ix as resItemId
		FROM
			rv_reservation_item
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resNum'
			$sqlFilter
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_last,
			rv_reservation_item.rv_item_accomm_count
	",2);

	$invCurr = getInvCurrSymbol($resNum);

	if ( $invCurr == "0" ) {
		$invCurr = "";
	}

	foreach ( $itemArray as $itemKey => $item ) {
		$itemArray[$itemKey]['resArrive']		= chng_date($itemArray[$itemKey]['resArrive'],"-");
		$itemArray[$itemKey]['resDepart']		= chng_date($itemArray[$itemKey]['resDepart'],"-");
		$itemArray[$itemKey]['accTotal']		= (string) getDisplayItemTotal($item['resItemId']);
		$itemArray[$itemKey]['accommType']	.= " " . getOptionalComponents($item['resItemId']);
		$itemArray[$itemKey]['invCurr']			= $invCurr;		
	}
	return $itemArray;
}

function getReservationSummary($resNum,$propertyDetail,$accommFilter) {
	$sqlFilter = "";
	if($propertyDetail == "1") {
		$sqlFilter = $accommFilter['where'];
	}
	$summaryArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			pr_persona.pr_name_last as propName,
			rv_reservation_item.rv_item_date_arrive as resArrive,
			rv_reservation_item.rv_item_date_depart as resDepart
		FROM
			rv_reservation_item
		INNER JOIN ac_accomm_type ON 
			ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_persona ON 
			pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			rv_reservation_item.rv_reservation_id = '" . $resNum . "'
			$sqlFilter
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_last
	",2);

	for ( $summaryCount = 0; $summaryCount < sizeof($summaryArray); $summaryCount++ ) {
		$summaryArray[$summaryCount]['resArrive'] = chng_date($summaryArray[$summaryCount]['resArrive'],"-");
		$summaryArray[$summaryCount]['resDepart'] = chng_date($summaryArray[$summaryCount]['resDepart'],"-");
	}
	return $summaryArray;
}

function getReservationGuestInfo($resNum) {
	$info = $GLOBALS['lDB']->get("SELECT rv_note_guests FROM rv_reservation WHERE rv_reservation.rv_reservation_ix = '$resNum'",4);
	if(trim($info) == "" || $info == "0") {
		$info = "";
	}
	return $info;
}

function getReservationRooming($resNum) {
	global $lDB;
	$guestList = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_ix,
			pr_guest.pr_guest_note,
			pr_guest.pr_guest_memo
		FROM
			rv_reservation_item
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resNum'
	",2);

	$roomList = $lDB->get("
		SELECT
			rv_reservation_item.rv_item_date_arrive as arrive,
			rv_reservation_item.rv_item_date_depart as depart,
			pr_persona.pr_name_last as property,
			ac_accomm_type.ac_accomm_desc  as accomm,
			ac_accomm_room.ac_desc as room,
			rv_res_item_group.rv_room_requested_yn as locked,
			rv_room_request_reason as reason
		FROM
			rv_reservation_item
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resNum'
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			(ac_accomm_room.ac_desc+0),
			ac_accomm_room.ac_desc
	",2);
	$arrive = null;
	$depart = null;
	$property = null;
	$accomm = null;
	$level = 1;

	foreach ( $roomList as $key => $item ) {
		$roomList[$key]['arrive'] = chng_date($item['arrive'],"-");
		$roomList[$key]['depart'] = chng_date($item['depart'],"-");

		if ( $arrive != $item['arrive'] ) {
			$arrive		= $item['arrive'];
			$depart		= $item['depart'];
			$property	= $item['property'];
			$accomm		= $item['accomm'];
			$level		= 1;
		}

		if ( $depart != $item['depart'] ) {
			$depart		= $item['depart'];
			$property	= $item['property'];
			$accomm		= $item['accomm'];
			$level		= 2;
		}

		if ( $property != $item['property'] ) {
			$property	= $item['property'];
			$accomm		= $item['accomm'];
			$level		= 3;
			}

		if ( $accomm != $item['accomm'] ) {
			$accomm	= $item['accomm'];
			$level	= 4;
		}

      if($level == 2) { $roomList[$key]['arrive'] = ""; }
      if($level == 3) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; }
      if($level == 4) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; $roomList[$key]['property'] = ""; }
      if($level == 5) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; $roomList[$key]['property'] = ""; $roomList[$key]['accomm'] = ""; }

      $level = 5;

      if($item['locked'] == "1") {
      $roomList[$key]['locked'] = "Yes";
      } else {
         $roomList[$key]['locked'] = "No";
         $roomList[$key]['reason'] = "";
      }
   }
   $guestGroup = array();
   $itemList = $lDB->get("
      SELECT
      rv_reservation_item_ix
   FROM
      rv_reservation_item
   WHERE
      rv_reservation_id = '$resNum'
   ",3);

   $groupName = $lDB->get("
      SELECT DISTINCT
      rv_res_item_group.rv_res_item_group_ix
   FROM
      rv_res_item_group
      INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
      INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
      INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
   WHERE
      rv_reservation.rv_reservation_ix = '$resNum'
      AND (
         rv_res_item_group.ac_accomm_room_id = ''
         OR rv_res_item_group.ac_accomm_room_id IS NULL
         OR rv_res_item_group.ac_accomm_room_id = '0'
      )
   ",3);

	for($count = 0; $count < ceil(sizeof($itemList) / 4); $count++) {
      $row = array();
	  $row['itemHeader1'] = "";
	  $row['itemHeader2'] = "";
	  $row['itemHeader3'] = "";
	  $row['itemHeader4'] = "";
      $row['rows'] = array();
      foreach($guestList as $guestItem) {
		  $guestName = $guestItem['pr_name_last'];
		  if($guestItem['pr_name_first'] != "") {
			  if($guestName !="") {
				  $guestName .= ", ";
			  }
			  $guestName .= $guestItem['pr_name_first'];
		  }

		  
         $item = array('name' => $guestName);				 	
         if(trim($guestItem['pr_guest_note']) != "") {
            $item['guestNote'] = "x";
         } else {
            $item['guestNote'] = "";
         }
         if(trim($guestItem['pr_guest_memo']) != "") {
            $item['guestMemo'] = "x";
         } else {
            $item['guestMemo'] = "";
         }

         for($count2 = 0; $count2 < 4; $count2++) {
            if( ($count * 4) + $count2 < sizeof($itemList) ) {
               $guestRoom = $lDB->get("
                  SELECT
                  ac_accomm_room.ac_desc,
                  rv_res_item_group.rv_room_requested_yn,
                  rv_res_item_group.rv_res_item_group_ix as id,
				  rv_reservation_item.rv_item_date_arrive,
				  rv_reservation_item.rv_item_date_depart,
				  rv_reservation_item.rv_item_adult_count,
				  rv_reservation_item.rv_item_child_count,
				  pr_business.pr_bus_name_short,
				  ac_accomm_type.ac_accomm_name_short
               FROM
					rv_reservation_item
					INNER JOIN pr_business ON pr_business.pr_business_id = rv_reservation_item.pr_business_id
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
					INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
					INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
               WHERE
                  rv_reservation_item.rv_reservation_item_ix = '".$itemList[($count * 4) + $count2]."'
                  AND rv_res_item_guest.pr_guest_id = '" . $guestItem['pr_persona_ix'] . "'
               ",1);
			   $useHeader = false;
			   if(sizeof($guestRoom) > 1) {
					$useHeader = true;
				}

               if($guestRoom['ac_desc'] == "" || $guestRoom['ac_desc'] == "0") {
                  $groupKey = array_search($guestRoom['id'],$groupName);
                  if($groupKey === false) {
                     $guestRoom['ac_desc'] = "";
                  } else {
                     $guestRoom['ac_desc'] = "(" . strtolower(IntToRoman($groupKey+1)) . ")";
                  }
               }
               $item["item".($count2+1)] = $guestRoom['ac_desc'];
               if(isset($guestRoom['rv_room_requested_yn']) && $guestRoom['rv_room_requested_yn'] == "1") {
                  $item["item".($count2+1)."Lock"] = "";
               } else {
                  $item["item".($count2+1)."Lock"] = "display:none;";
               }
			   if($useHeader) {
			   		$guestRoom['rv_item_date_arrive'] = isset($guestRoom['rv_item_date_arrive']) ? $guestRoom['rv_item_date_arrive'] : "";
			   		$guestRoom['rv_item_date_depart'] = isset($guestRoom['rv_item_date_depart']) ? $guestRoom['rv_item_date_depart'] : "";
			   		$guestRoom['pr_bus_name_short'] = isset($guestRoom['pr_bus_name_short']) ? $guestRoom['pr_bus_name_short'] : "";
			   		$guestRoom['ac_accomm_name_short'] = isset($guestRoom['ac_accomm_name_short']) ? $guestRoom['ac_accomm_name_short'] : "";
			   		$guestRoom['rv_item_adult_count'] = isset($guestRoom['rv_item_adult_count']) ? $guestRoom['rv_item_adult_count'] : "";
			   		$guestRoom['rv_item_child_count'] = isset($guestRoom['rv_item_child_count']) ? $guestRoom['rv_item_child_count'] : "";

					$row['itemHeader'.($count2+1)] = 
						"Arr: " . chng_date($guestRoom['rv_item_date_arrive'],"-") . "<BR>" . 
						"Dep: " . chng_date($guestRoom['rv_item_date_depart'],"-") . "<BR>" .
						"Prop: " . $guestRoom['pr_bus_name_short'].", ".$guestRoom['ac_accomm_name_short']."<BR>" .
						"Adult: " .$guestRoom['rv_item_adult_count'] . "<BR>" .
						"Child: " .$guestRoom['rv_item_child_count'];
				}
            } else {
               $item["item".($count2+1)] = "";
               $item["item".($count2+1)."Lock"] = "display:none;";
               //$item['guestNote'] = "";
               //$item['guestMemo'] = "";
    		   $row['itemHeader'.($count2+1)] = "&nbsp;";
        }

         }
         array_push($row['rows'],$item);
      }
      $row['rows']['html'] = __DIR__ . "/../../../public/html/rep_detbilling_guest_group_rows.htm";
      $row['htmlRow'] = true;
      array_push($guestGroup,$row);
   }

   $notes = array();
   $memos = array();

   foreach($guestList as $item) {
	  $guestName = $item['pr_name_last'];
	  if($item['pr_name_first'] != "") {
		  if($guestName !="") {
			  $guestName .= ", ";
		  }
		  $guestName .= $item['pr_name_first'];
	  }
      $name = $guestName;
      if(trim($item['pr_guest_note']) != "") {
         array_push($notes,array('name'=>$name, 'note'=>$item['pr_guest_note']));
      }
      if(trim($item['pr_guest_memo']) != "") {
         array_push($memos,array('name'=>$name, 'note'=>$item['pr_guest_memo']));
      }
   }

   return array('guests'=>$guestList, 'rooms'=>$roomList, 'guestGroups'=>$guestGroup, 'notes'=>$notes, 'memos'=>$memos);
}

function getReservationMemo($resNum) {
   $memo = $GLOBALS['lDB']->get("SELECT rv_reservation.rv_note_internal as resInt FROM rv_reservation WHERE rv_reservation.rv_reservation_ix = '".$resNum."'",4);

   if(trim($memo) == "" || $memo == "0") {
      $memo = "";
   }
   return $memo;
}

function getCancelNote($resNum) {
	$memo = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_cancel_reason as resInt
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_reservation_ix = '$resNum'
			AND rv_reservation.rf_reservation_status_id = '90'
	",4);

	if(trim($memo) == "" || $memo == "0") {
		$memo = "";
	}
	return $memo;
}


function getExtraNotes($resNum,$travel=0,$memo=0,$propertyDetail=false,$nonPropertyDetail=false,$propertyFilter=false) {
	if($travel == 0) {
		$travelIndex = " <> 2 ";
	} else {
		$travelIndex = " = 2 ";
	}
	if($memo == 0) {
		$noteType = "rv_extra.rv_extra_note";
	} else {
		$noteType = "rv_extra.rv_extra_note_internal";
	}
	
	$sqlFilter = "";
	if($propertyDetail == "1" && $nonPropertyDetail != "1") {
		$sqlFilter = "
			AND rv_extra.pr_business_id IN ('".join("','",explode(":",$propertyFilter['ids']))."')
		";
	}
	if($propertyDetail != "1" && $nonPropertyDetail == "1") {
		$sqlFilter = "
			AND pr_persona.pr_persona_ix IS NULL
		";
	}
	if($propertyDetail == "1" && $nonPropertyDetail == "1") {
		$sqlFilter = "
			AND (
				rv_extra.pr_business_id IN ('".join("','",explode(":",$propertyFilter['ids']))."')
				OR pr_persona.pr_persona_ix IS NULL
			)
		";
	}
	
	$notes = $GLOBALS['lDB']->get("
		SELECT
			".$noteType." as note,
			pr_persona.pr_name_last as property,
			rv_extra.rv_extra_date_serv as serviceDate,
			rv_extra.rv_extra_date_depart as departDate,
			rv_extra.rv_extra_nights as noNgts,
			rv_extra.rv_extra_ind as travelType,
			ac_extra.ac_ext_desc as description,
			ac_extra_category.ac_extra_cat_desc as extraCat,
			rv_extra.rv_extra_ref,
			CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name
		FROM
			rv_extra
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
			LEFT JOIN ac_extra ON rv_extra.ac_extra_id = ac_extra.ac_extra_ix
			LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id 
			LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id
		WHERE
			rv_extra.rv_reservation_id = '".$resNum."'
			AND rv_extra.rv_extra_ind ".$travelIndex."
			AND trim(".$noteType.") <> ''
			AND rv_extra.rv_extra_void_ind = 0
			$sqlFilter
		ORDER BY
			rv_extra.rv_extra_date_serv, pr_persona.pr_name_last
	",2);
	return $notes;
}

function getRateCurrency($rateId) {
	$rateCurr = $GLOBALS['lDB']->get("
		SELECT
			rf_currency.rf_currency_symbol
		FROM
			rt_rate_type
			INNER JOIN rf_currency ON rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
		WHERE
			rt_rate_type.rt_rate_type_ix = '$rateId'
	",4);
	if(trim($rateCurr) == "" || $rateCurr == "0") {
		$rateCurr = "";
	}
	return $rateCurr;
}

function getPaymentPlanName($planId) {
	$payPlan = $GLOBALS['lDB']->get("
		SELECT
			ac_pay_plan.ac_pay_plan_desc
		FROM
			ac_pay_plan
		WHERE
			ac_pay_plan.ac_pay_plan_ix = '".$planId."'", 4);
	if(trim($payPlan) == "" || $payPlan == "0") {
		$payPlan = "";
	}
	return $payPlan;
}

function getReservationTotals($resItem) {
	//Reservation costs !!!!!!!!!! NEEDS LOOKING AT - MUST BE A BETTER WAY !!!!!!!!!!
	$accommRate	= getAccommRateData($resItem['resNum']);
	$accommRate = isset($accommRate) ? $accommRate : $accommRate=array();
	$extraArray = isset($extraArray) ? $extraArray : $extraArray=array();
	$travelArray = isset($travelArray) ? $travelArray : $travelArray=array();
	$resTotals	= getResDocTotals($resItem['resNum'],$accommRate,$extraArray,$travelArray,"1");
	$payItems		= getPayItems($resItem['resNum']);
	$outStand		= $payItems['outstanding'];
	$totalPd		= $payItems['payedTotal'];

	$resTotals['total_outstanding'] = $outStand;
	$resTotals['total_paid']				= $totalPd;

	if ( 
		(isset($outStand) && (string)$outStand == "TBA") ||
		(isset($totalPd) && (string)$totalPd == "TBA") ||
		(isset($resTotals['total_tax']) && $resTotals['total_tax'] == "TBA") ||
		(isset($resTotals['total_net']) && $resTotals['total_net'] == "TBA") ||
		(isset($resTotals['total_comm']) && $resTotals['total_comm'] == "TBA") ||
		(isset($resTotals['gross']) && $resTotals['gross'] == "TBA")
		) {
		$resTotals['total_outstanding']			= "TBA";
		$resTotals['total_paid']				= "TBA";
		$resTotals['total_tax']					= "TBA";
		$resTotals['total_net']					= "TBA";
		$resTotals['total_comm']				= "TBA";
		$resTotals['total_gross']				= "TBA";
		$resTotals['total_invoice']				= "TBA";
	}

	$currencyCheck = $GLOBALS['lDB']->get("SELECT COUNT(DISTINCT rf_currency_id) FROM fn_folio WHERE rv_reservation_id = '" . $resItem['resNum'] . "'",4);
	$resTotals['showPaymentSummary'] = "";

	if ( $currencyCheck > 1 ) {
		$resTotals['showPaymentSummary'] = "collapse printCollapse";
	}
	return $resTotals;
}

function getOptionalComponents($resItemId) {
	$compArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rt_component.rt_component_abbrv
		FROM
			rv_res_item_comp
		INNER JOIN rt_component ON
			rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '" . $resItemId . "'
		AND 
			rv_item_comp_option_yn = '1' ORDER BY rt_component.rt_component_abbrv
	",2);

	$compList = "";
	
	foreach ( $compArray as $item ) {
		if ( $compList != "" ) {
			$compList .= ", ";
		}
		$compList .= $item['rt_component_abbrv'];
	}

	if ( $compList != "" ) {
		$compList = "(" . $compList . ")";
	}
	return $compList;
}

function listPDF(&$listRows,&$pdf,$report,$options){
	$propId = null;

	foreach ( $listRows as $item ) {
		$cancelled = "0";
		$cancelStyle = "";
		$provFill = 0;
		$provColor = array(0xff,0xff,0xff);
		if ( $item['resStatId'] == "20") {
			$provExpDt = $item['provExpDt'];
			$today = date("Y-m-d");

			if ( $provExpDt == $today ) {
				$provColor = array(0xf1,0xc5,0x5d);
			} elseif ($provExpDt < $today) {
				$provColor = array(0xdb,0x42,0x42);
			}
			$provFill = 1;
		}

		if ( $item['resStatId'] == "90" ){
			$cancelled = "1";
			$cancelStyle = "B";
		}
		
		$pdf->SetFont('Arial', '', 6);

		if ( $propId != $item['propId'] ) {
			$pdf->Ln(2);
			$pdf->Row(array(
				array('width'=>"10%", 'data'=>"Property: ", 'style'=>"B"),
				array('width'=>"50%", 'data' =>$item['propName'], 'style' => "B")
			));

			$propRow = array();

			if ( $options & REP_COL_RES_NO ) {
				array_push($propRow,
					array('width'=>"8%", 'data'=>"Res No", 'border'=>"LTB", 'fill'=>1)
				);
			}

			if ( $options & REP_COL_RES_NAME ) {
				array_push($propRow,
					array('width'=>"16%", 'data'=>"Res Name", 'border'=>"LTB", 'fill'=>1)
				);
			}

			array_push($propRow,
				array('width'=>"7%", 'data'=>"Acc Type", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"8%", 'data'=>"Arrive", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"8%", 'data'=>"Depart", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"4%", 'data'=>"Rms", 'border'=>"LTB", 'fill'=>1),
				array('width'=>"4%", 'data'=>"Nghts", 'border'=>"LTB", 'fill'=>1)
			);

			if ( $report == "provisional" ) {
				array_push($propRow,
					array('width'=>"9%", 'data'=>"Exp Date", 'border'=>"LTB", 'fill'=>1)
				);
			} else {
				array_push($propRow,
					array('width'=>"9%", 'data'=>"Status", 'border'=>"LTB", 'fill'=>1)
				);
			}

			if ( $options & REP_COL_SRC ) {
				array_push($propRow,
					array('width'=>"5%", 'data'=>"Src", 'border'=>"LTB", 'fill'=>1)
				);
			}

			if ( $options & REP_COL_CONSULT ) {
				array_push($propRow,
					array('width'=>"9%", 'data'=>"Consult", 'border'=>"LTB", 'fill'=>1)
				);
			}

			if ( $options & REP_COL_AGENT ) {
				array_push($propRow,
					array('width'=>"9%", 'data'=>"Agent", 'border'=>"LTB", 'fill'=>1)
				);
			}

			if ( $options & REP_COL_CONTACT ) {
				array_push($propRow,
					array('width'=>"9%", 'data'=>"Contact", 'border'=>"LTBR", 'fill'=>1)
				);
			}
			$propId = $item['propId'];
			$pdf->Row($propRow);
		}

		$listRow = array();

		if ( $options & REP_COL_RES_NO ) {
			array_push($listRow,
				array('width'=>"8%", 'data'=>$item['resNum'], 'border'=>"LTB")
			);
		}

		if ( $options & REP_COL_RES_NAME ) {
			array_push($listRow,
				array('width'=>"16%", 'data'=>$item['resName'], 'border'=>"LTB")
			);
		}

		array_push($listRow,
			array('width' => "7%", 'data' => $item['accommType'],								'border' => "LTB"),
			array('width' => "8%", 'data' => chng_date($item['resArrive'],"-"),	'border' => "LTB"),
			array('width' => "8%", 'data' => chng_date($item['resDepart'],"-"),	'border' => "LTB"),
			array('width' => "4%", 'data' => $item['resRooms'],									'border' => "LTB",	'align' => "C"),
			array('width' => "4%", 'data' => $item['numNights'],								'border' => "LTB",	'align' => "C")
		);

		if ( $report == "provisional" ) {
			array_push($listRow,
				array('width'=>"9%", 'data'=>chng_date($item['provExpDt'],"-"), 'border'=>"LTB")
			);
		} else {
			array_push($listRow,
					array('width'=>"9%", 'data'=>$item['resStatus'], 'border'=>"LTB", 'fill' => $provFill, 'fillColor' => $provColor, 'style'=>$cancelStyle)
			);
		}

		if ( $options & REP_COL_SRC ) {
			array_push($listRow,
				array('width'=>"5%", 'data'=>$item['srcAbbrv'], 'border'=>"LTB")
			);
		}

		if ( $options & REP_COL_CONSULT ) {
			array_push($listRow,
				array('width'=>"9%", 'data'=>$item['consultName'], 'border'=>"LTB")
			);
		}

		if ( $options & REP_COL_AGENT ) {
			array_push($listRow,
				array('width'=>"9%", 'data'=>$item['agentName'], 'border'=>"LTB")
			);
		}

		if ( $options & REP_COL_CONTACT ) {
			array_push($listRow,
				array('width'=>"9%", 'data'=>$item['contactName'], 'border'=>"LTBR")
			);
		}
		$pdf->Row($listRow);
	}
}

function listCSV(&$listRows,$csvHeader,$reportName,$options, $report){
   $csvFile = array();
   // Export Header
   foreach($csvHeader as $head){
		$head[0] = isset($head[0]) ? $head[0] : "";
		$head[1] = isset($head[1]) ? $head[1] : "";
		array_push($csvFile,array($head[0],$head[1]));
   }
   array_push($csvFile,array());      

   $propId = null;   
   foreach($listRows as $item) {
   		$cancelled = "0"; 
      if($item['resStatId'] == "90"){
      	$cancelled = "1";
      }
      if($propId != $item['propId']) {
	       array_push($csvFile,array());
	       array_push($csvFile,array("<B>Property:</B> ",$item['propName']));

         $propRow = array();
         if($options & REP_COL_RES_NO){
            array_push($propRow,"<B>Res No</B>");
         }
         if($options & REP_COL_RES_NAME){
            array_push($propRow,"<B>Res Name</B>");
         }
     		 array_push($propRow,"<B>Acc Type</B>","<B>Arrive</B>","<B>Depart</B>","<B>Rms</B>","<B>Nghts</B>","<B>Ad</B>", "<B>Ch</B>");
         if($report == "provisional"){
            array_push($propRow,"<B>Exp Date</B>");
         }else{
            array_push($propRow,"<B>Status</B>");
         }
         if($options & REP_COL_SRC){
						array_push($propRow,"<B>Src</B>");         
         }
         if($options & REP_COL_CONSULT){
            array_push($propRow,"<B>Consult</B>");
         }
         if($options & REP_COL_AGENT){
            array_push($propRow,"<B>Agent</B>");
         }
         if($options & REP_COL_CONTACT){
            array_push($propRow,"<B>Contact</B>");
         }
         $propId = $item['propId'];
				 array_push($csvFile,$propRow);
      }

      $listRow = array();
      if($options & REP_COL_RES_NO){
         array_push($listRow,$item['resNum']);
      }
      if($options & REP_COL_RES_NAME){
         array_push($listRow,$item['resName']);
      }
      array_push($listRow,
      	$item['accommType'], 
        chng_date($item['resArrive'],"-"), 
        chng_date($item['resDepart'],"-"), 
        $item['resRooms'],
        $item['numNights'],
		$item['numAdults'],
		$item['numChild']
      );
      if($report == "provisional"){
         array_push($listRow,chng_date($item['provExpDt'],"-"));
      }else{
         array_push($listRow,$item['resStatus']);
      }
      if($options & REP_COL_SRC){
         array_push($listRow,$item['srcAbbrv']);
      }
      if($options & REP_COL_CONSULT){
         array_push($listRow,$item['consultName']);
      }
      if($options & REP_COL_AGENT){
         array_push($listRow,$item['agentName']);
      }
      if($options & REP_COL_CONTACT){
         array_push($listRow,$item['contactName']);
      }
	 
      array_push($csvFile,$listRow);
   }     
   outputCSV($csvFile, $reportName);
}

function detailPDF(&$data,&$pdf,$options) {
	headerPDF($data,$pdf,$options);
	if($options & REP_BUTTON_CONTACT_INFO) {
		contactPDF($data, $pdf);
	}
	accommodationPDF($data,$pdf,$options);
	accommodationExtraPDF($data,$pdf,$options);
	extrasPDF($data,$pdf,$options);
	if($options & REP_BUTTON_PAYMENT_SUMMARY) {
		totalsPDF($data, $pdf);
	}
	if($options & REP_BUTTON_COMPONENTS) {
		costCompPDF($data, $pdf);
	}
	if($options & REP_BUTTON_EXCHANGE_RATES) {
		exRatePDF($data, $pdf);
	}
	if($options & REP_BUTTON_PAYMENT) {
		paymentPDF($data,$pdf);
	}
	if($options & REP_BUTTON_ROOMING) {
		roomingPDF($data,$pdf);
	}
	if($options & REP_BUTTON_GUEST_NOTE) {
		guestNotePDF($data,$pdf);
	}
	if($options & REP_BUTTON_GUEST_MEMO) {
		guestMemoPDF($data,$pdf);
	}
	notesPDF($data, $pdf, $options);
	auditPDF($data, $pdf, $options);
	$pdf->Ln(4);
}

function detailHeaderCSV($csvHeader, $report) {
	$csvFile = array();
	// Export Header
	array_push($csvFile,array($report." report"));
	//array_push($csvFile,array());
	foreach($csvHeader as $head){
		array_push($csvFile,array($head[0],$head[1]));
	}
	array_push($csvFile,array());
	return $csvFile;
}

function detailCSV(&$data,$options) {
	$csvFile = array();
	$compList = "";
   
	$stateText = $data['rf_reservation_status_desc']. $data['resClass'];
	array_push($csvFile,array($data['resNum'],$data['rv_res_name'],"",$stateText));
	array_push($csvFile,array("Itinerary Summary","","","Date In","Date Out"));
	foreach($data['summRows'] as $summItem) {
		array_push($csvFile,array($summItem['propName'],"","",$summItem['resArrive'],$summItem['resDepart']));
	}
	array_push($csvFile,array());
   
	 array_push($csvFile,array("Voucher Ref: ",$data['rv_agent_ref']));
	 array_push($csvFile,array("Created: ",$data['rv_date_recorded'],"","Rate: ",$data['rt_rate_type_desc']." (".$data['rateCurr'].")"));
	 array_push($csvFile,array("Amended: ",$data['rv_date_changed'],"","Invoice: ",$data['invCurr']));
	 array_push($csvFile,array("Allocated: ",$data['allocDate']));
   if ($data['payPlan'] != "") {
   	 array_push($csvFile,array("Payment Plan: ",$data['payPlan']. " (" . $data['commPerc'].")"));
   }
   if($data['srcDesc'] != "") {  
   	 array_push($csvFile,array("Source: ",$data['srcDesc']));
   }
   array_push($csvFile,array());
   
   #['START'] Contact Info   
   if($options & REP_BUTTON_CONTACT_INFO) {
     array_push($csvFile,array("Consultant (Internal)","Agent","Contact Person","Originator"));

     $contactList = array("consultant","agent","contact","orig");
     $names = array();
     $telephones = array();
     $faxes = array();
     $emails = array();
     foreach($contactList as $item) {
     	$data[$item."Detail"]['name'] = isset($data[$item."Detail"]['name']) ? $data[$item."Detail"]['name'] : "";
     	$data[$item."Detail"]['telephone'] = isset($data[$item."Detail"]['telephone']) ? $data[$item."Detail"]['telephone'] : "";
     	$data[$item."Detail"]['fax'] = isset($data[$item."Detail"]['fax']) ? $data[$item."Detail"]['fax'] : "";
     	$data[$item."Detail"]['email'] = isset($data[$item."Detail"]['email']) ? $data[$item."Detail"]['email'] : "";

		array_push($names,$data[$item."Detail"]['name']);
		array_push($telephones,$data[$item."Detail"]['telephone']);
		array_push($faxes,$data[$item."Detail"]['fax']);
		array_push($emails,$data[$item."Detail"]['email']);
     }
     $postList = array("consult","agent","contact","orig");
     $address = array();
     foreach($postList as $post) {
       array_push($address,$data[$post."Post"]);
     }     
     array_push($csvFile,$names,$telephones,$faxes,$emails,str_replace("<BR>","\n",$address));
     array_push($csvFile,array());
   }
	 #['END'] Contact Info
   
   #['START'] Accommodation
   array_push($csvFile,array("Accommodation"));
   array_push($csvFile,array("Arrive","Depart","Property","Accomm","Rooms","Nights","Adults","Children","Amount"));
   
   foreach($data['accommRows'] as $accomm) {
  	 $accommRow = array();
	   array_push($accommRow,
     	 $accomm['resArrive'],
       $accomm['resDepart'],
       $accomm['propName'],
       $accomm['accommType'].$compList,
       $accomm['resRooms'],
       $accomm['numNights'],
       $accomm['numAdults'],
       $accomm['numChild'],
       $accomm['accTotal']. " " .$accomm['invCurr']);
	   array_push($csvFile,$accommRow);
   }
   
   if(sizeof($data['accomExtraRows']) > 0) {
	   array_push($csvFile,array("Accommodation - Extras"));
		$headerRow = array("Arrive","Depart","Description","Rms","Ngts","Adult","Child");
		
		if($options & REP_BUTTON_FINANCIAL) {
			array_push($headerRow,"Amount");
		}
		array_push($csvFile,$headerRow);
		
		foreach($data['accomExtraRows'] as $accomm) {
			$accomExtraRow = array();
			array_push($accomExtraRow,
				$accomm['date_service'],
				$accomm['date_depart'],
				$accomm['ac_ext_desc'],
				$accomm['rv_extra_units'],
				$accomm['rv_extra_nights'],
				$accomm['rv_extra_adult_count'],
				$accomm['rv_extra_child_count']
			);
			if($options & REP_BUTTON_FINANCIAL) {
				array_push($accomExtraRow,$accomm['total']. " " .$accomm['rf_currency_symbol']);
			}
			array_push($csvFile,$accomExtraRow);
		}
   }
	
   array_push($csvFile,array());
   #['END'] Accommodation

   #['START'] Extras
   if(sizeof($data['extraRows']) > 0) {
   	  array_push($csvFile,array("Extras"));
		  array_push($csvFile,array("Service Date","Property","Category","Description","Room","Qty","Amount"));      
      foreach($data['extraRows'] as $extra) {
        $extraRow = array();
        array_push($extraRow,
          chng_date($extra['rv_extra_date_serv'],"-"),
          $extra['pr_name_last'],
          $extra['ac_extra_cat_desc'],            
          $extra['ac_ext_desc'],            
          $extra['ac_desc'],            
          $extra['rv_extra_units'],
          $extra['total']." ".$extra['rf_currency_symbol']);
      	array_push($csvFile,$extraRow);
      }
   }
   array_push($csvFile,array());
   #['END'] Extras
   #['START'] Travel Extras   
   if(sizeof($data['travelRows']) > 0) {
   	  array_push($csvFile,array("Travel extras"));
		  array_push($csvFile,array("Service Date","Property","Category","Description","ETD","ETA","Type","Qty","Amount"));      
      foreach($data['travelRows'] as $trav) {
        $travelRow = array();
        array_push($travelRow,
          chng_date($trav['rv_extra_date_serv'],"-"),
          $trav['pr_name_last'],
          $trav['ac_extra_cat_desc'],            
          $trav['ac_ext_desc'],
			$trav['rv_extra_travel_etd'],
			$trav['rv_extra_travel_eta'],
		  $trav['travel_type'],            
          $trav['rv_extra_units'],
          $trav['total']." ".$trav['rf_currency_symbol']);
      	array_push($csvFile,$travelRow);
      }
      array_push($csvFile,array());  
   }
   #['END'] Travel Extras
   
   #['START'] Payment Summary
   if($data['showPaymentSummary'] == "") {
     array_push($csvFile,array("Payment Summary"));
		 array_push($csvFile,array("Outstanding","Total Paid","Tax incl","Nett","Commission","Gross","Payable amount"));
     array_push($csvFile,array(
     	 $data['total_outstanding']." ".$data['invCurr'],
       $data['total_paid']." ".$data['invCurr'],
       $data['total_tax']." ".$data['invCurr'],
       $data['total_net']." ".$data['invCurr'],
       $data['total_comm']." ".$data['invCurr'],
       $data['total_gross']." ".$data['invCurr'],
       $data['total_invoice']." ".$data['invCurr']));
   }
   array_push($csvFile,array());
   #['END'] Payment Summary
   
   #['START'] Components
   if($options & REP_BUTTON_COMPONENTS) {
     $compSize = sizeof($data['compTotals']);
     if($compSize > "0"){
       array_push($csvFile,array("Cost Components"));
			 array_push($csvFile,array("","Description","Tax Rate","Tax Included","Amount Payable"));
       foreach($data['compTotals'] as $compCat=>$compList) {
          $first = true;
          foreach($compList as $compItem) {
             //$compItem['rf_currency_symbol'] = $resItem['rf_currency_symbol'];
             if($first && $compCat != "Totals") {
                $first = false;
                array_push($csvFile,array($compCat,$compItem['compDesc'],$compItem['taxRate'],$compItem['taxAmt'],$compItem['payAmt']." ".$compItem['rf_currency_symbol']));
             } else {
                array_push($csvFile,array("",$compItem['compDesc'],$compItem['taxRate'],$compItem['taxAmt'],$compItem['payAmt']." ".$compItem['rf_currency_symbol']));
             }
          }
       }
     }
     array_push($csvFile,array());
   }     
   #['END'] Components
   
   #['START'] Exchange Rate
   if($options & REP_BUTTON_EXCHANGE_RATES) {
     $exSize = sizeof($data['exchange']);
   	 if($exSize > "0"){
       array_push($csvFile,array("Exchange Rate"));
       array_push($csvFile,array($data['exchangeNote']));
       array_push($csvFile,array("Charge","Currency Conversion","Rate","Expiry Date"));
       foreach($data['exchange'] as $exchangeItem) {
         array_push($csvFile,array($exchangeItem['ac_ext_desc'],$exchangeItem['curr_conversion'],$exchangeItem['rv_extra_exch_rate'],$exchangeItem['exch_expiry']));
       }
		   array_push($csvFile,array());
     }
   }
   #['END'] Exchange Rate
   
   #['START'] Payment
   if($options & REP_BUTTON_PAYMENT) {
     array_push($csvFile,array("Payment Plan"));
		 array_push($csvFile,array());
     array_push($csvFile,array("Payments according to the following schedule must be made:"));
		 array_push($csvFile,array("Plan"));
     array_push($csvFile,array("Date Due","Amount"));      
    
	if (isset($data['payRows']) && is_array($data['payRows'])) {
		$max = sizeof($data['payRows']);
		for($count = 0; $count < $max; $count++) {
			if ($count <= ($max-1)) {
				$data['payRows'][$count]['pay_date'] = isset($data['payRows'][$count]['pay_date']) ? $data['payRows'][$count]['pay_date'] : "";
				$data['payRows'][$count]['rv_pay_plan_amount'] = isset($data['payRows'][$count]['rv_pay_plan_amount']) ? $data['payRows'][$count]['rv_pay_plan_amount'] : "";
				$data['payRows'][$count]['rf_currency_symbol'] = isset($data['payRows'][$count]['rf_currency_symbol']) ? $data['payRows'][$count]['rf_currency_symbol'] : "";
				array_push($csvFile,array($data['payRows'][$count]['pay_date'],$data['payRows'][$count]['rv_pay_plan_amount']. " " . $data['payRows'][$count]['rf_currency_symbol']));
			}  
		}
	}
     array_push($csvFile,array());
     array_push($csvFile,array("Payment Analysis"));
     array_push($csvFile,array("Payment Date","Payer","Reference","Curr","Folio","Invoice","Amount"));
	
	if (isset($data['payedRows']) && is_array($data['payedRows'])) {
		$pmax = sizeof($data['payedRows']);
		for($count = 0; $count < $pmax; $count++) {
			if ($count <= ($pmax-1)) {
				$data['payedRows'][$count]['pay_date'] = isset($data['payedRows'][$count]['pay_date']) ? $data['payedRows'][$count]['pay_date'] : "";
				$data['payedRows'][$count]['pr_name_last'] = isset($data['payedRows'][$count]['pr_name_last']) ? $data['payedRows'][$count]['pr_name_last'] : "";
				$data['payedRows'][$count]['rv_pmnt_ref'] = isset($data['payedRows'][$count]['rv_pmnt_ref']) ? $data['payedRows'][$count]['rv_pmnt_ref'] : "";
				$data['payedRows'][$count]['rf_currency_symbol'] = isset($data['payedRows'][$count]['rf_currency_symbol']) ? $data['payedRows'][$count]['rf_currency_symbol'] : "";
				$data['payedRows'][$count]['fn_folio_folio_num'] = isset($data['payedRows'][$count]['fn_folio_folio_num']) ? $data['payedRows'][$count]['fn_folio_folio_num'] : "";
				$data['payedRows'][$count]['fn_invoice_ix'] = isset($data['payedRows'][$count]['fn_invoice_ix']) ? $data['payedRows'][$count]['fn_invoice_ix'] : "";
				$data['payedRows'][$count]['rv_payment_item_amt'] = isset($data['payedRows'][$count]['rv_payment_item_amt']) ? $data['payedRows'][$count]['rv_payment_item_amt'] : "";
				$data['payedRows'][$count]['rf_currency_symbol'] = isset($data['payedRows'][$count]['rf_currency_symbol']) ? $data['payedRows'][$count]['rf_currency_symbol'] : "";

				array_push($csvFile,array(
					$data['payedRows'][$count]['pay_date'],
					$data['payedRows'][$count]['pr_name_last'],
					$data['payedRows'][$count]['rv_pmnt_ref'],
					$data['payedRows'][$count]['rf_currency_symbol'],
					$data['payedRows'][$count]['fn_folio_folio_num'],
					$data['payedRows'][$count]['fn_invoice_ix'],
					$data['payedRows'][$count]['rv_payment_item_amt']. " " . $data['payedRows'][$count]['rf_currency_symbol']
				));
			}
		}
    }
     if($data['showPaymentTotal'] == "") {
       array_push($csvFile,array("Total Amount STILL DUE:",$data['payOutstanding'] ." ".$data['invCurr']));
     }
     array_push($csvFile,array());   
   }
   #['END'] Payment
	 
   #['START'] Rooming
   if($options & REP_BUTTON_ROOMING) {
      array_push($csvFile,array("Room Summary"));	
			array_push($csvFile,array("Arrive","Depart","Property","Accomm","Room","Lock","Reason"));
      foreach($data['rooming']['rooms'] as $item){
				array_push($csvFile,array($item['arrive'],$item['depart'],$item['property'],$item['accomm'],$item['room'],$item['locked'],$item['reason']));          
      }
      array_push($csvFile,array());
      //Guest names
      if(sizeof($data['rooming']['guestGroups']) > 0){     
        array_push($csvFile,array("Room (Guest Names) Summary"));
        foreach($data['rooming']['guestGroups'] as $gkey=>$gGroup){
          if($gkey != "0" && $gkey == "htmlRow") {
          	continue;
          }
          array_push($csvFile,array("Guest Names","Notes","Int Memo",t_decodeHTML($gGroup['itemHeader1']),t_decodeHTML($gGroup['itemHeader2']),t_decodeHTML($gGroup['itemHeader3']),t_decodeHTML($gGroup['itemHeader4'])));
          foreach($gGroup['rows'] as $ikey=>$item){
            if($ikey != "0" && $ikey == "html") {
        			continue;
        		}
        	
            if($item['item1Lock'] != "display:none;"){
            $item['item1'] .= " (Locked)";
            }
            if($item['item2Lock'] != "display:none;"){
            $item['item2'] .= " (Locked)";
            }
            if($item['item3Lock'] != "display:none;"){
            $item['item3'] .= " (Locked)";
            }
            if($item['item4Lock'] != "display:none;"){
            $item['item4'] .= " (Locked)";
            }          
            array_push($csvFile,array($item['name'],$item['guestNote'],$item['guestMemo'],$item['item1'],$item['item2'],$item['item3'],$item['item4']));            
          }     
        }
      }  
      array_push($csvFile,array());
	 }	       
   #['END'] Rooming
	 
   #['START'] Guest Notes
   if($options & REP_BUTTON_GUEST_NOTE) {
     if(sizeof($data['rooming']['guests']) != 0){
	     array_push($csvFile,array("Guest Notes:"));
       foreach($data['rooming']['guests'] as $guests){
         if($guests['pr_guest_note'] != ""){
					 array_push($csvFile,array($guests['pr_name_last'].", ".$guests['pr_name_first']));
           array_push($csvFile,array($guests['pr_guest_note']));
         }
       }         
     }
     array_push($csvFile,array());
   }      
   #['END'] Guest Notes
   
   #['START'] Guest Memo
   if($options & REP_BUTTON_GUEST_MEMO) {
     if(sizeof($data['rooming']['guests']) != 0){
       array_push($csvFile,array("Guest Internal Memos:"));
       foreach($data['rooming']['guests'] as $iguests){
         if($iguests['pr_guest_memo'] != ""){
           array_push($csvFile,array($iguests['pr_name_last'].", ".$iguests['pr_name_first']));
				   array_push($csvFile,array($iguests['pr_guest_memo']));            
         }
	     }                 
     }	   
     array_push($csvFile,array());
   }
   #['END'] Guest Memo
   
   #['START'] Notes
	$hasInternal = false;
	$foundInternal = false;

   $noteList = array(
      array('name'=>"Reservation Notes", 'data'=>"resNote", 'option'=>REP_BUTTON_RESERVATION_NOTES),
      array('name'=>"Guest Information", 'data'=>"guestInfo", 'option'=>REP_BUTTON_GUEST_INFO),
      array('name'=>"Extras notes", 'data'=>"extraNote", 'option'=>REP_BUTTON_EXTRA_NOTES),
      array('name'=>"Travel notes", 'data'=>"travelNote", 'option'=>REP_BUTTON_TRAVEL_NOTES),
      array('name'=>"Reservation Memos", 'data'=>"resIntNote", 'internal'=>true, 'option'=>REP_BUTTON_INTERNAL_NOTES),
      array('name'=>"Guest Nationality", 'data'=>"guestNationality", 'internal'=>true, 'option'=>REP_BUTTON_INTERNAL_NOTES),
      array('name'=>"Extra Memos", 'data'=>"extIntNote", 'internal'=>true, 'option'=>REP_BUTTON_INTERNAL_NOTES),
      array('name'=>"Travel Memos", 'data'=>"travIntNote", 'internal'=>true, 'option'=>REP_BUTTON_INTERNAL_NOTES),
      array('name'=>"Cancellation notes", 'data'=>"cancelNote", 'option'=>REP_BUTTON_CANCEL_NOTES)
   );
   foreach($noteList as $item) {
   	  $item['internal'] = isset($item['internal']) ? $item['internal'] : false;
      if($item['option'] & $options && $item['internal'] && is_array($data[$item['data']]) && sizeof($data[$item['data']]) > 0) {
         $hasInternal = true;
      }
      if($item['option'] & $options && $item['internal'] && !is_array($data[$item['data']]) && $data[$item['data']] != "") {
         $hasInternal = true;
      }
   }
   foreach($noteList as $item) {
   	  $item['internal'] = isset($item['internal']) ? $item['internal'] : false;
      if($hasInternal && !$foundInternal && $item['internal']) {
      	array_push($csvFile,array("Internal Memos"));
        $foundInternal = true;
      }
      if(is_array($data[$item['data']])) {
         if($item['option'] & $options && sizeof($data[$item['data']]) > 0) {
           array_push($csvFile,array($item['name']));
            $text = "";
            foreach($data[$item['data']] as $key=>$value) {
			   if(trim($value['rv_extra_ref']) != "") {
                  $text .= "Reference:" . $value['rv_extra_ref'] . "\n";
               }
			   if(trim($value['supplier_name']) != "") {
                  $text .= "Service By:" . $value['supplier_name'] . "\n";
               }
               if($value['serviceDate'] != "0000-00-00" && $value['serviceDate'] != "0" && trim($value['serviceDate']) != "") {
				   if($value['travelType'] == 3) {
						$text .= chng_date($value['serviceDate'],"-")." to ".chng_date($value['departDate'],"-")." (".$value['noNgts']." nights): ";
					} else {
						$text .= chng_date($value['serviceDate'],"-").": ";
					}
				}
               $text .= $value['description'];
               if(array_key_exists("extraCat",$value)) {
                 if($value['extraCat'] != "") {
                    $text .= " (".$value['extraCat'].")";
                 } else {
                    $text .= "";
                 }
               }
               $text .= "\n" . $value['note'] . "\n\n";
            }
            array_push($csvFile,array($text));
            array_push($csvFile,array());
         }
      } else {
         if($item['option'] & $options && $data[$item['data']] != "" && $data[$item['data']] != "FALSE") {
            array_push($csvFile,array($item['name']));
            array_push($csvFile,array($data[$item['data']]));
         }
      }
      array_push($csvFile,array());
   }   
   #['END'] Notes

   #['START'] Audit Trail
   if(is_array($data['auditTrail']) && ($options & REP_BUTTON_AUDIT)) {
     array_push($csvFile,array("Audit Trail"));
		 array_push($csvFile,array("Date","Time","Server","User","Details"));
      foreach($data['auditTrail'] as $item) {
  			$auditDate = $item["date"];
        if($item["date"] == "&nbsp;"){
        	$auditDate = "";
        }      
        array_push($csvFile,array($auditDate,$item["time"],$item["server"],$item["user"],$item["details"]));
      }
   }   
   #['END'] Audit Trail
   return $csvFile;
}


function outputCSV($csvFile, $reportName = '') {             
   define("COLWIDTH",130);
	$rows = array();
	$cells = array();
	$tables = array();
	$tempCell = array();

	$defaultStyle = array( 
			"alignment" =>array("Horizontal" => "Left", "Vertical" => "Top", "WrapText" => '1')
			);

	$xls = new XLS($defaultStyle);
	$max = 1;
	foreach($csvFile as $csvLine) {
		if(count($csvLine)> $max) {
			$max = count($csvLine);
		}
		foreach($csvLine as $csvItem) {
			if(is_numeric($csvItem)) {
				$dtype = "Number";
			} else {
				$dtype = "String";
			}
			$cell = $xls->Cell(array("type"=>$dtype, "data" => $csvItem));
			array_push($tempCell, $cell);
		}
		$row = $xls->Row($tempCell);
		array_push($rows,$row);
		$tempCell = array();
	}
	for ($i=0; $i<$max; $i++) {
		$xls->Column(COLWIDTH);
	}
	$table = $xls->Table($rows);
	array_push($tables, $table);
	$xls->Worksheet($tables);
	$xls->genrateWorkbook($reportName.".xlsx");
}


function findPDF(&$findRows,&$pdf,$report,$options,$createDate,$amendDate,$provDate){
	$pdf->SetFont('Arial', '', 6);

	if($report == "provisional") {
		$propRow = array(
			array('width'=>"6%", 'data'=>"Res No", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"10%", 'data'=>"Res Name", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"7%", 'data'=>"Properties", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"8%", 'data'=>"Exp Date", 'border'=>"LTB", 'fill'=>1));
		if ($createDate) {
			array_push($propRow, array('width'=>"8%", 'data'=>"Create Date", 'border'=>"LTB", 'fill'=>1) );
		}
		if ($amendDate) {
			array_push($propRow, array('width'=>"8%", 'data'=>"Amended Date", 'border'=>"LTB", 'fill'=>1) );
		}
		if ($provDate) {
			array_push($propRow, array('width'=>"8%", 'data'=>"Prov Date", 'border'=>"LTB", 'fill'=>1) );
		}
		array_push($propRow, array('width'=>"9%", 'data'=>"Agent", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"8%", 'data'=>"Voucher Reference", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"8%", 'data'=>"Arrive", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"8%", 'data'=>"Depart", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"5%", 'data'=>"Rooms alloc", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"4%", 'data'=>"Availability", 'border'=>"LTBR", 'fill'=>1)
		);
	} else {
		$propRow = array(
			array('width'=>"8%", 'data'=>"Res No", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"26%", 'data'=>"Res Name", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"10%", 'data'=>"Properties", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"10%", 'data'=>"Status", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"10%", 'data'=>"Agent", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"16%", 'data'=>"Voucher Reference", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"10%", 'data'=>"Arrive", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"10%", 'data'=>"Depart", 'border'=>"LTBR", 'fill'=>1)
		);
	}

	$pdf->Row($propRow);

	foreach ( $findRows as $item ) {
		//$agent = getPersonaDetail($item['agentId']);

		$propArray = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				pr_business.pr_bus_name_short AS propName
			FROM 
				rv_reservation_item
			INNER JOIN pr_business ON 
				pr_business.pr_business_id = rv_reservation_item.pr_business_id
			WHERE 
				rv_reservation_item.rv_reservation_id = '" . $item['resNum'] . "'
		",3);

		$properties = join(", ",$propArray);
		$cancelled = "0";

		if ( $item['resStatId'] == "90" ) {
			$cancelled = "1";
		}

		if($report == "provisional") {
			if($item['hasRooms']) {
				$hasRooms = "Yes";
			} else {
				$hasRooms = "No";
			}
			if($item['hasAvail']) {
				$hasAvail = "Yes";
			} else {
				$hasAvail = "No";
			}
			$findRow = array(
				array('width'=>"6%", 'data'=>$item['resNum'], 'border'=>"LTB"),
				array('width'=>"10%", 'data'=>$item['resName'], 'border'=>"LTB"),
				array('width'=>"7%", 'data'=>$properties, 'border'=>"LTB"),
				array('width'=>"8%", 'data'=>chng_date($item['provExpDt'],"-"), 'border'=>"LTB") );
			if ($createDate) {
				array_push($findRow, array('width'=>"8%", 'data'=>chng_date($item['createDate'],"-"), 'border'=>"LTB") );
			}
			if ($amendDate) {
				array_push($findRow, array('width'=>"8%", 'data'=>chng_date($item['amendDate'],"-"), 'border'=>"LTB") );
			}
			if ($provDate) {
				array_push($findRow, array('width'=>"8%", 'data'=>chng_date($item['provDate'],"-"), 'border'=>"LTB") );
			}
			array_push($findRow, array('width'=>"9%", 'data'=>$item['agentName'], 'border'=>"LTB"),
				array('width'=>"8%", 'data'=>$item['agentRef'], 'border'=>"LTB"),
				array('width'=>"8%", 'data'=>chng_date($item['resArrive'],"-"), 'border'=>"LTB"),
				array('width'=>"8%", 'data'=>chng_date($item['resDepart'],"-"), 'border'=>"LTB"),
				array('width'=>"5%", 'data'=>$hasRooms, 'border'=>"LTB"),
				array('width'=>"4%", 'data'=>$hasAvail, 'border'=>"LTBR")
			);
		} else {
			if($cancelled == "1") {
				$style = "B";
			} else {
				$style = "";
			}

			$provFill = 0;
			$provColor = array(0xff,0xff,0xff);
			if ( $item['resStatId'] == "20") {
				$provExpDt = $item['provExpDt'];
				$today = date("Y-m-d");

				if ( $provExpDt == $today ) {
					$provColor = array(0xf1,0xc5,0x5d);
				} elseif ($provExpDt < $today) {
					$provColor = array(0xdb,0x42,0x42);
				}
				$provFill = 1;
			}

			$findRow = array(
				array('width'=>"8%", 'data'=>$item['resNum'], 'border'=>"LTB"),
				array('width'=>"26%", 'data'=>$item['resName'], 'border'=>"LTB"),
				array('width'=>"10%", 'data'=>$properties, 'border'=>"LTB"),
				array('width'=>"10%", 'data'=>$item['resStatus'], 'border'=>"LTB", 'style'=>$style, 'fill' => $provFill, 'fillColor' => $provColor),
				array('width'=>"10%", 'data'=>$item['agentName'], 'border'=>"LTB"),
				array('width'=>"16%", 'data'=>$item['agentRef'], 'border'=>"LTB"),
				array('width'=>"10%", 'data'=>chng_date($item['resArrive'],"-"), 'border'=>"LTB"),
				array('width'=>"10%", 'data'=>chng_date($item['resDepart'],"-"), 'border'=>"LTBR")
			);
		}

		$pdf->Row($findRow);
	}
}

function findCSV(&$findRows,$csvHeader,$reportName,$options,$createDate,$amendDate,$provDate) {
	global $report;

	$csvFile = array();
	foreach ( $csvHeader as $head ) {
		$head[0] = isset($head[0]) ? $head[0] : "";
		$head[1] = isset($head[1]) ? $head[1] : "";
		array_push($csvFile,array($head[0],$head[1]));
	}

	array_push($csvFile,array());
	if($report == "provisional") {
		$header_array = array("<B>Res no</B>","<B>Res Name</B>","<B>Properties</B>","<B>Exp Date</B>");
		if ($createDate) { array_push($header_array,"<B>Create Date</B>"); }
		if ($amendDate) { array_push($header_array,"<B>Amended Date</B>"); }
		if ($provDate) { array_push($header_array,"<B>Prov Date</B>"); }
		array_push($header_array,"<B>Agent</B>","<B>Voucher</B> <B>Reference</B>","<B>Arrive</B>","<B>Depart</B>","<B>Rooms Allocated</B>","<B>Availability</B>");
		array_push($csvFile,$header_array);
	} else {
		array_push($csvFile,array("<B>Res no</B>","<B>Res Name</B>","<B>Properties</B>","<B>Status</B>","<B>Agent</B>","<B>Voucher</B> <B>Reference</B>","<B>Arrive</B>","<B>Depart</B>"));
	}

	foreach ( $findRows as $item ) {
		$agent = getPersonaDetail($item['agentId']);
		$agentName = $agent['name'];
		
		if ( $agent['name'] == "" ) {
			$agentName = "Direct Booking";
		}

		$propArray = $GLOBALS['lDB']->get("
			SELECT DISTINCT
				pr_business.pr_bus_name_short AS propName 
			FROM 
				rv_reservation_item 
			INNER JOIN pr_business ON 
				pr_business.pr_business_id = rv_reservation_item.pr_business_id 
			WHERE 
				rv_reservation_item.rv_reservation_id = '" . $item['resNum'] . "'
		",3);

		$properties = join(", ",$propArray);
		$cancelled = "0";

		if ( $item['resStatId'] == "90" ) {
			$cancelled = "1";
		}

		$findRow = array();
		array_push($findRow,$item['resNum'],$item['resName'],$properties);

		if ( $report == "provisional" ) {
			array_push($findRow,chng_date($item['provExpDt'],"-"));
		} else {
			array_push($findRow,$item['resStatus']);
		}

		if ( $report == "provisional" ) {
			if ($createDate) { array_push($findRow,chng_date($item['createDate'],"-")); }
			if ($amendDate) {array_push($findRow,chng_date($item['amendDate'],"-")); }
			if ($provDate) {array_push($findRow,chng_date($item['provDate'],"-")); }
		}

		array_push($findRow,$agentName,$item['agentRef'],chng_date($item['resArrive'],"-"),chng_date($item['resDepart'],"-"));

		if($report == "provisional") {
			if($item['hasRooms']) {
				$hasRooms = "Yes";
			} else {
				$hasRooms = "No";
			}
			if($item['hasAvail']) {
				$hasAvail = "Yes";
			} else {
				$hasAvail = "No";
			}
			array_push($findRow,$hasRooms,$hasAvail);
		}

		array_push($csvFile,$findRow);
	}
	
	outputCSV($csvFile, $reportName);
}

function headerPDF(&$data, &$pdf,$options) {

   $provColor = '';
   $stateText = $data['rf_reservation_status_desc']. $data['resClass'];
   if ($data['rf_reservation_status_id'] == "20") {
		$stateText .= " expires: ".chng_date($data['provExpDt'], "-");
		$provExpDt = $data['provExpDt'];
		$today = date("Y-m-d");

		if ( $provExpDt == $today ) {
			$provColor = array(0xf1,0xc5,0x5d);
		} elseif ($provExpDt < $today) {
			$provColor = array(0xdb,0x42,0x42);
		}
   }


   $pdf->Row(array(
      array('width'=>"50%", 'height'=>"8", 'data'=>$data['resNum'].": ".$data['rv_res_name'], 'border'=>"LTB", 'fill'=>1, 'style'=>"B"),
      array('width' => "50%", 'height'=>"8", 'data' => $stateText, 'border' => "TRB", 'fill' => 1, 'style' => "B", 'align' => "R", 'fillColor' => $provColor)
   ));
	 $pdf->Ln(1);
	if($options & REP_BUTTON_ITINERARY) {
		$pdf->Row(array(
			array('width' => "50%", 'data' => "Itinerary Summary", 'border' => "TLB", 'fill' => 1, 'style' => "B"),
			array('width' => "25%", 'data' => "Date In", 'border' => "TB", 'fill' => 1, 'style' => "B"),
			array('width' => "25%", 'data' => "Date Out", 'border' => "TRB", 'fill' => 1, 'style' => "B")
		));
		foreach($data['summRows'] as $summItem) {
			$pdf->Row(array(
				array('width' => "50%", 'data' => $summItem['propName']),
				array('width' => "25%", 'data' => $summItem['resArrive']),
				array('width' => "25%", 'data' => $summItem['resDepart'])
			));
		}
		$pdf->Row(array(
			array('width' => "100%", 'data' => "", 'border' => "B")
		));
	}

   	if($options & REP_BUTTON_DETAILS) {
		$pdf->Row(array(
			array('width'=>"20%", 'data'=>"Voucher Ref: ", 'border'=>"LTB", 'fill'=>1, 'style'=>"B"),
			array('width'=>"80%", 'data'=>$data['rv_agent_ref'], 'border'=>"TBR", 'fill'=>1),
		));
		$pdf->Row(array(
			array('width'=>"20%", 'data'=>"Created: ", 'border'=>"LB", 'fill'=>1, 'style'=>"B"),
			array('width'=>"30%", 'data'=>$data['rv_date_recorded'], 'border'=>"B", 'fill'=>1),
			array('width'=>"20%", 'data'=>"Rate: ", 'border'=>"B", 'fill'=>1, 'style'=>"B"),
			array('width'=>"30%", 'data'=>$data['rt_rate_type_desc']."  (".$data['rateCurr'].")", 'border'=>"RB", 'fill'=>1)
		));
		$pdf->Row(array(
			array('width'=>"20%", 'data'=>"Amended: ", 'border'=>"LB", 'fill'=>1, 'style'=>"B"),
			array('width'=>"30%", 'data'=>$data['rv_date_changed'], 'border'=>"B", 'fill'=>1),
			array('width'=>"20%", 'data'=>"Invoice: ", 'border'=>"B", 'fill'=>1, 'style'=>"B"),
			array('width'=>"30%", 'data'=>$data['invCurr'], 'border'=>"RB", 'fill'=>1)
		));
		$pdf->Row(array(
			array('width' => "20%", 'data' => "Allocated: ", 'border' => "LB", 'fill' => 1, 'style' => "B"),
			array('width' => "30%", 'data' => $data['allocDate'], 'border' => "B", 'fill' => 1)
		), 0);
		if ($data['payPlan'] != "") {
			$pdf->Row(array(
				array('width' => "20%", 'data' => "Payment Plan: ", 'border' => "B", 'fill' => 1, 'style' => "B"),
				array('width' => "30%", 'data' => $data['payPlan']. " (" . $data['commPerc'].")", 'border' => "RB", 'fill' => 1)
			));
		} else {
			$pdf->Row(array(
				array('width' => "20%", 'data' => "", 'border' => "B", 'fill' => 1, 'style' => "B"),
				array('width' => "30%", 'data' => "", 'border' => "RB", 'fill' => 1, 'style' => "B")
			));
		}
		if($data['srcDesc'] != "") {
			$pdf->Row(array(
				array('width' => "20%", 'data' => "Source: ", 'border' => "LB", 'fill' => 1, 'style' => "B"),
				array('width' => "30%", 'data' => $data['srcDesc'], 'border' => "RB", 'fill' => 1),
				array('width' => "20%", 'data' => "", 'border' => "B", 'fill' => 1, 'style' => "B"),
				array('width' => "30%", 'data' => "", 'border' => "RB", 'fill' => 1)
			));
		}
	}

   $pdf->Ln(1);
}

function accommodationPDF(&$data, &$pdf,$options) {
	$compList = "";
	if($options & REP_BUTTON_FINANCIAL) {
		$full = "100%";
	} else {
		$full = "89%";
	}	
	$pdf->Row(array(
		array('width'=>$full,'data'=>"Accommodation",'border'=>"LTRB",'style'=>"B",'fill'=>1)
	));
	$header = array(
		array('width'=>"10%",'data'=>"Arrive",'border'=>"LRTB",'fill'=>1),
		array('width'=>"10%",'data'=>"Depart",'border'=>"LRTB",'fill'=>1),
		array('width'=>"19%",'data'=>"Property",'border'=>"LRTB",'fill'=>1),
		array('width'=>"18%",'data'=>"Accomm",'border'=>"LRTB",'fill'=>1),
		array('width'=>"8%",'data'=>"Rooms",'border'=>"LRTB",'fill'=>1,'align'=>"C"),
		array('width'=>"8%",'data'=>"Nights",'border'=>"LRTB",'fill'=>1,'align'=>"C"),
		array('width'=>"8%",'data'=>"Adults",'border'=>"LRTB",'fill'=>1,'align'=>"C"),
		array('width'=>"8%",'data'=>"Children",'border'=>"LRTB",'fill'=>1,'align'=>"C")		
	);
	if($options & REP_BUTTON_FINANCIAL) {
		array_push($header,array('width'=>"11%",'data'=>"Amount",'border'=>"LRTB",'fill'=>1,'align'=>"R"));
	}
	$pdf->Row($header);
	foreach($data['accommRows'] as $item) {
		$row = array(
			array('width'=>"10%",'data'=>$item['resArrive'],'border'=>"LR"),
			array('width'=>"10%",'data'=>$item['resDepart'],'border'=>"LR"),
			array('width'=>"19%",'data'=>$item['propName'],'border'=>"LR"),
			array('width'=>"18%",'data'=>$item['accommType'].$compList,'border'=>"LR"),
			array('width'=>"8%",'data'=>$item['resRooms'],'border'=>"LR",'align'=>"C"),
			array('width'=>"8%",'data'=>$item['numNights'],'border'=>"LR",'align'=>"C"),
			array('width'=>"8%",'data'=>$item['numAdults'],'border'=>"LR",'align'=>"C"),
			array('width'=>"8%",'data'=>$item['numChild'],'border'=>"LR",'align'=>"C")			
		);
		if($options & REP_BUTTON_FINANCIAL) {
			array_push($row,array('width'=>"11%",'data'=>$item['accTotal']. " " .$item['invCurr'],'border'=>"LR",'align'=>"R"));
		}
		$pdf->Row($row);
	}
	$pdf->Row(array(array('width'=>$full,'border'=>"T")));
}

function accommodationExtraPDF(&$data, &$pdf,$options) {
	if(sizeof($data['accomExtraRows']) == 0) return false;
	if($options & REP_BUTTON_FINANCIAL) {
		$full = "100%";
	} else {
		$full = "89%";
	}	
	$pdf->Row(array(
		array('width'=>$full,'data'=>"Accommodation - Extras",'border'=>"LTRB",'style'=>"B",'fill'=>1)
	));
	$header = array(
		array('width'=>"10%",'data'=>"Arrive",'border'=>"LRTB",'fill'=>1),
		array('width'=>"10%",'data'=>"Depart",'border'=>"LRTB",'fill'=>1),
		array('width'=>"37%",'data'=>"Description",'border'=>"LRTB",'fill'=>1),
		array('width'=>"8%",'data'=>"Rms",'border'=>"LRTB",'fill'=>1),
		array('width'=>"8%",'data'=>"Ngts",'border'=>"LRTB",'fill'=>1,'align'=>"C"),
		array('width'=>"8%",'data'=>"Adult",'border'=>"LRTB",'fill'=>1,'align'=>"C"),
		array('width'=>"8%",'data'=>"Child",'border'=>"LRTB",'fill'=>1,'align'=>"C")
	);
	if($options & REP_BUTTON_FINANCIAL) {
		array_push($header,array('width'=>"11%",'data'=>"Amount",'border'=>"LRTB",'fill'=>1,'align'=>"R"));
	}
	$pdf->Row($header);
	foreach($data['accomExtraRows'] as $item) {
		$row = array(
			array('width'=>"10%",'data'=>$item['date_service'],'border'=>"LR"),
			array('width'=>"10%",'data'=>$item['date_depart'],'border'=>"LR"),
			array('width'=>"37%",'data'=>$item['ac_ext_desc'],'border'=>"LR"),
			array('width'=>"8%",'data'=>$item['rv_extra_units'],'border'=>"LR",'align'=>"C"),
			array('width'=>"8%",'data'=>$item['rv_extra_nights'],'border'=>"LR",'align'=>"C"),
			array('width'=>"8%",'data'=>$item['rv_extra_adult_count'],'border'=>"LR",'align'=>"C"),
			array('width'=>"8%",'data'=>$item['rv_extra_child_count'],'border'=>"LR",'align'=>"C")			
		);
		if($options & REP_BUTTON_FINANCIAL) {
			array_push($row,array('width'=>"11%",'data'=>$item['total']. " " .$item['rf_currency_symbol'],'border'=>"LR",'align'=>"R"));
		}
		$pdf->Row($row);
	}
	$pdf->Row(array(array('width'=>$full,'border'=>"T")));
}

function extrasPDF(&$data, &$pdf,$options) {
	if($options & REP_BUTTON_FINANCIAL) {
		$full = "100%";
	} else {
		$full = "88%";
	}	
	if(sizeof($data['extraRows']) > 0) {
		$pdf->Row(array(
			array('width'=>$full,'data'=>"Extras",'border'=>"LRTB",'style'=>"B",'fill'=>1)
		));
		$header = array(
			array('width'=>"10%",'data'=>"Service Date",'border'=>"LRTB",'fill'=>1),
			array('width'=>"15%",'data'=>"Property",'border'=>"LRTB",'fill'=>1),
			array('width'=>"13%",'data'=>"Category",'border'=>"LRTB",'fill'=>1),         
			array('width'=>"25%",'data'=>"Description",'border'=>"LRTB",'fill'=>1),
			array('width'=>"20%",'data'=>"Room",'border'=>"LRTB",'fill'=>1),
			array('width'=>"5%",'data'=>"Qty",'border'=>"LRTB",'fill'=>1,'align'=>"C")			
		);
		if($options & REP_BUTTON_FINANCIAL) {
			array_push($header,array('width'=>"12%",'data'=>"Amount",'border'=>"LRTB",'fill'=>1,'align'=>"R"));
		}
		$pdf->Row($header);
		foreach($data['extraRows'] as $item) {
			$row = array(
				array('width'=>"10%",'data'=>chng_date($item['rv_extra_date_serv'],"-"),'border'=>"LR"),
				array('width'=>"15%",'data'=>$item['pr_name_last'],'border'=>"LR"),
				array('width'=>"13%",'data'=>$item['ac_extra_cat_desc'],'border'=>"LR"),
				array('width'=>"25%",'data'=>$item['ac_ext_desc'],'border'=>"LR"),
				array('width'=>"20%",'data'=>$item['ac_desc'],'border'=>"LR"),
				array('width'=>"5%",'data'=>$item['rv_extra_units'],'border'=>"LR",'align'=>"C")				
			);
			if($options & REP_BUTTON_FINANCIAL) {
				array_push($row,array('width'=>"12%",'data'=>$item['total']." ".$item['rf_currency_symbol'],'border'=>"LR",'align'=>"R"));
			}
			$pdf->Row($row);
		}
		$pdf->Row(array(array('width'=>$full,'border'=>"T")));
	}
	if(sizeof($data['travelRows']) > 0) {
		$pdf->Row(array(
			array('width'=>$full,'data'=>"Travel extras",'border'=>"LRTB",'style'=>"B",'fill'=>1)
		));
		$header = array(
			array('width'=>"10%",'data'=>"Service Date",'border'=>"LRTB",'fill'=>1),
			array('width'=>"15%",'data'=>"Property",'border'=>"LRTB",'fill'=>1),
			array('width'=>"13%",'data'=>"Category",'border'=>"LRTB",'fill'=>1),
			array('width'=>"15%",'data'=>"Description",'border'=>"LRTB",'fill'=>1),
			array('width'=>"10%",'data'=>"ETD",'border'=>"LRTB",'fill'=>1),
			array('width'=>"10%",'data'=>"ETA",'border'=>"LRTB",'fill'=>1),
			array('width'=>"10%",'data'=>"Type",'border'=>"LRTB",'fill'=>1,'align'=>"C"),
			array('width'=>"5%",'data'=>"Qty",'border'=>"LRTB",'fill'=>1,'align'=>"C")			
		);
		if($options & REP_BUTTON_FINANCIAL) {
			array_push($header,array('width'=>"12%",'data'=>"Amount",'border'=>"LRTB",'fill'=>1,'align'=>"R"));
		}
		$pdf->Row($header);
		foreach($data['travelRows'] as $item) {
			$row = array(
				array('width'=>"10%",'data'=>chng_date($item['rv_extra_date_serv'],"-"),'border'=>"LR"),
				array('width'=>"15%",'data'=>$item['pr_name_last'],'border'=>"LR"),
				array('width'=>"13%",'data'=>$item['ac_extra_cat_desc'],'border'=>"LR"),
				array('width'=>"15%",'data'=>$item['ac_ext_desc'],'border'=>"LR"),
				array('width'=>"10%",'data'=>$item['rv_extra_travel_etd'],'border'=>"LR"),
				array('width'=>"10%",'data'=>$item['rv_extra_travel_eta'],'border'=>"LR"),
				array('width'=>"10%",'data'=>$item['travel_type'],'border'=>"LR",'align'=>"C"),
				array('width'=>"5%",'data'=>$item['rv_extra_units'],'border'=>"LR",'align'=>"C")
			);
			if($options & REP_BUTTON_FINANCIAL) {
				array_push($row,array('width'=>"12%",'data'=>$item['total']." ".$item['rf_currency_symbol'],'border'=>"LR",'align'=>"R"));
			}
			$pdf->Row($row);
		}
		$pdf->Row(array(array('width'=>$full,'border'=>"T")));
	}
}

function totalsPDF(&$data, &$pdf){
   if($data['showPaymentSummary'] == "") {
   $pdf->Row(array(
      array('width'=>"100%", 'data'=>"Payment Summary", 'border'=>"TLR", 'fill'=>1, 'height'=>"4", 'style'=>"B")
   ));
   $pdf->Row(array(
      array('width'=>"14%", 'data'=>"Outstanding", 'border'=>"TLB", 'fill'=>1, 'height'=>"4", 'align'=>"R"),
      array('width'=>"14%", 'data'=>"Total Paid", 'border'=>"TLB", 'fill'=>1, 'height'=>"4", 'align'=>"R"),
      array('width'=>"14%", 'data'=>"Tax incl", 'border'=>"TLB", 'fill'=>1, 'height'=>"4", 'align'=>"R"),
      array('width'=>"14%", 'data'=>"Nett", 'border'=>"TLB", 'fill'=>1, 'height'=>"4", 'align'=>"R"),
      array('width'=>"14%", 'data'=>"Commission", 'border'=>"TLB", 'fill'=>1, 'height'=>"4", 'align'=>"R"),
      array('width'=>"14%", 'data'=>"Gross", 'border'=>"TLB", 'fill'=>1, 'height'=>"4", 'align'=>"R"),
      array('width'=>"16%", 'data'=>"Payable amount", 'border'=>"TLBR", 'fill'=>1, 'height'=>"4", 'align'=>"R")
   ));
   $pdf->Row(array(
      array('width'=>"14%", 'data'=>$data['total_outstanding']." ".$data['invCurr'], 'border'=>"TLB", 'align'=>"R"),
      array('width'=>"14%", 'data'=>$data['total_paid']." ".$data['invCurr'], 'border'=>"TLB", 'align'=>"R"),
      array('width'=>"14%", 'data'=>$data['total_tax']." ".$data['invCurr'], 'border'=>"TLB", 'align'=>"R"),
      array('width'=>"14%", 'data'=>$data['total_net']." ".$data['invCurr'], 'border'=>"TLB", 'align'=>"R"),
      array('width'=>"14%", 'data'=>$data['total_comm']." ".$data['invCurr'], 'border'=>"TLB", 'align'=>"R"),
      array('width'=>"14%", 'data'=>$data['total_gross']." ".$data['invCurr'], 'border'=>"TLB", 'align'=>"R"),
      array('width'=>"16%", 'data'=>$data['total_invoice']." ".$data['invCurr'], 'border'=>"TLBR", 'align'=>"R")
   ));
   $pdf->Ln(1);
   }
}

function costCompPDF(&$data, &$pdf){
  $compSize = sizeof($data['compTotals']);
  if($compSize > "0"){
     $pdf->Row(array(
        array('data'=>"Cost Components", 'border'=>"LTRB",'style'=>"B", 'fill'=>1, 'height'=>"6")
     ));
     $pdf->Row(array(
        array('width'=>"20%",'data'=>"", 'border'=>"TLB", 'fill'=>1, 'height'=>"6"),
        array('width'=>"32%",'data'=>"Description",'border'=>"TLB",'fill'=>1, 'height'=>"6"),
        array('width'=>"16%",'data'=>"Tax Rate",'border'=>"TLB",'fill'=>1, 'height'=>"6", 'align'=>"R"),
        array('width'=>"16%",'data'=>"Tax Included",'border'=>"TLB",'fill'=>1, 'height'=>"6", 'align'=>"R"),
        array('width'=>"16%",'data'=>"Amount Payable",'border'=>"TLBR",'fill'=>1, 'height'=>"6", 'align'=>"R")
     ));
     foreach($data['compTotals'] as $compCat=>$compList) {
        $first = true;
        foreach($compList as $compItem) {
           //$compItem['rf_currency_symbol'] = $resItem['rf_currency_symbol'];
           if($first && $compCat != "Totals") {
              $first = false;
              $pdf->Row(array(
                 array('width'=>"20%",'data'=>$compCat, 'border'=>"TLB", 'fill'=>1, 'height'=>"4"),
                 array('width'=>"32%",'data'=>$compItem['compDesc'], 'border'=>"TLBR", 'fill'=>1, 'height'=>"4"),
                 array('width'=>"16%",'data'=>$compItem['taxRate'],'border'=>"BR", 'align'=>"R", 'height'=>"4"),
                 array('width'=>"16%",'data'=>$compItem['taxAmt'],'border'=>"BR", 'align'=>"R", 'height'=>"4"),
                 array('width'=>"16%",'data'=>$compItem['payAmt']." ".$compItem['rf_currency_symbol'],'border'=>"BR", 'align'=>"R", 'height'=>"4")
              ));
           } else {
              $pdf->Row(array(
                 array('width'=>"20%",'data'=>"", 'border'=>"LB", 'fill'=>1, 'height'=>"4"),
                 array('width'=>"32%",'data'=>$compItem['compDesc'], 'border'=>"TLBR", 'fill'=>1, 'height'=>"4"),
                 array('width'=>"16%",'data'=>$compItem['taxRate'], 'border'=>"BR", 'align'=>"R", 'height'=>"4"),
                 array('width'=>"16%",'data'=>$compItem['taxAmt'], 'border'=>"BR", 'align'=>"R", 'height'=>"4"),
                 array('width'=>"16%",'data'=>$compItem['payAmt']." ".$compItem['rf_currency_symbol'], 'border'=>"BR", 'align'=>"R", 'height'=>"4")
              ));
           }
        }
     }
  }
  $pdf->Ln(1);
}

function exRatePDF(&$data, &$pdf){
   $exSize = sizeof($data['exchange']);
   if($exSize > "0"){
      $pdf->Row(array(
         array('data'=>"Exchange Rate", 'border'=>"LTRB",'style'=>"B", 'fill'=>1, 'height'=>"6")
      ));
      $pdf->Row(array(
         array('data'=>$data['exchangeNote'], 'border'=>"LTR")
      ));
      $pdf->Row(array(
         array('width'=>"20%",'data'=>"Charge", 'border'=>"LTB", 'fill'=>1, 'height'=>"4"),
         array('width'=>"20%",'data'=>"Currency Conversion", 'border'=>"LTB", 'fill'=>1, 'height'=>"4", 'align'=>"C"),
         array('width'=>"16%",'data'=>"Rate", 'border'=>"LTB", 'fill'=>1, 'height'=>"4", 'align'=>"R"),
         array('width'=>"16%",'data'=>"Expiry Date", 'border'=>"LTBR", 'fill'=>1, 'height'=>"4", 'align'=>"C"),
         array('width'=>"28%",'data'=>"", 'border'=>"R", 'height'=>"4")
      ));
      foreach($data['exchange'] as $exchangeItem) {
         $pdf->Row(array(
            array('width'=>"20%",'data'=>$exchangeItem['ac_ext_desc'], 'border'=>"LB", 'height'=>"4"),
            array('width'=>"20%",'data'=>$exchangeItem['curr_conversion'], 'border'=>"TLBR", 'height'=>"4", 'align'=>"C"),
            array('width'=>"16%",'data'=>$exchangeItem['rv_extra_exch_rate'], 'border'=>"TLBR", 'height'=>"4", 'align'=>"R"),
            array('width'=>"16%",'data'=>$exchangeItem['exch_expiry'], 'border'=>"TLBR", 'height'=>"4", 'align'=>"C"),
            array('width'=>"28%",'data'=>"", 'border'=>"R", 'height'=>"4")
         ));
      }
      $pdf->Row(array(
         array('data'=>"", 'border'=>"LBR", 'height'=>"2")
      ));
      $pdf->Ln(1);
   }
}

function notesPDF(&$data, &$pdf,$options) {
// 8  Contact Info Button
// 16  Reservation Notes Button
// 32 Guest Info Button
// 64 Extra Notes
// 128 Travel Notes
// 256   Internal Notes

	$hasInternal = false;
	$foundInternal = false;

   $noteList = array(
      array('name'=>"Reservation Notes", 'data'=>"resNote", 'option'=>REP_BUTTON_RESERVATION_NOTES),
      array('name'=>"Guest Information", 'data'=>"guestInfo", 'option'=>REP_BUTTON_GUEST_INFO),
      array('name'=>"Extras notes", 'data'=>"extraNote", 'option'=>REP_BUTTON_EXTRA_NOTES),
      array('name'=>"Travel notes", 'data'=>"travelNote", 'option'=>REP_BUTTON_TRAVEL_NOTES),
      array('name'=>"Reservation Memos", 'data'=>"resIntNote", 'internal'=>true, 'option'=>REP_BUTTON_INTERNAL_NOTES),
      array('name'=>"Guest Nationality", 'data'=>"guestNationality", 'internal'=>true, 'option'=>REP_BUTTON_INTERNAL_NOTES),
      array('name'=>"Extra Memos", 'data'=>"extIntNote", 'internal'=>true, 'option'=>REP_BUTTON_INTERNAL_NOTES),
      array('name'=>"Travel Memos", 'data'=>"travIntNote", 'internal'=>true, 'option'=>REP_BUTTON_INTERNAL_NOTES),
      array('name'=>"Cancellation notes", 'data'=>"cancelNote", 'option'=>REP_BUTTON_CANCEL_NOTES)
   );
   foreach($noteList as $item) {
   	  $item['internal'] = isset($item['internal']) ? $item['internal'] : false;
      if($item['option'] & $options && $item['internal'] && is_array($data[$item['data']]) && sizeof($data[$item['data']]) > 0) {
         $hasInternal = true;
      }
      if($item['option'] & $options && $item['internal'] && !is_array($data[$item['data']]) && $data[$item['data']] != "") {
         $hasInternal = true;
      }
   }

   foreach($noteList as $item) {
   	  $item['internal'] = isset($item['internal']) ? $item['internal'] : false;
      if($hasInternal && !$foundInternal && $item['internal']) {
         $pdf->Row(array(
            array('data'=>"Internal Memos",'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"6")
         ));
         $foundInternal = true;
      }
      if(is_array($data[$item['data']])) {
         if($item['option'] & $options && sizeof($data[$item['data']]) > 0) {
            $pdf->Row(array(
               array('data'=>$item['name'],'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"6")
            ));
            $text = "";
            foreach($data[$item['data']] as $key=>$value) {
               if(trim($value['property']) != "") {
                  $text .= "<U>" . $value['property'] . "</U>\n";
               }
			   if(trim($value['rv_extra_ref']) != "") {
                  $text .= "Reference:" . $value['rv_extra_ref'] . "\n";
               }
			   if(trim($value['supplier_name']) != "") {
                  $text .= "Service By:" . $value['supplier_name'] . "\n";
               }
               if($value['serviceDate'] != "0000-00-00" && $value['serviceDate'] != "0" && trim($value['serviceDate']) != "") {
					if($value['travelType'] == 3) {
						$text .= chng_date($value['serviceDate'],"-")." to ".chng_date($value['departDate'],"-")." (".$value['noNgts']." nights): ";
					} else {
						$text .= chng_date($value['serviceDate'],"-").": ";
					}
				}
               $text .= $value['description'];
               if(array_key_exists("extraCat",$value)) {
                 if($value['extraCat'] != "") {
                    $text .= " (".$value['extraCat'].")";
                 } else {
                    $text .= "";
                 }
               }
               $text .= "\n" . $value['note'] . "\n\n";
            }
            $pdf->Row(array(array('data'=>$text)));
            $pdf->Ln(1);
         }
      } else {
         if($item['option'] & $options && $data[$item['data']] != "" && $data[$item['data']] != "FALSE") {
            $pdf->Row(array(
               array('data'=>$item['name'],'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"6")
            ));
            $pdf->Row(array(
               array('data'=>$data[$item['data']])
            ));
            $pdf->Ln(1);
         }

      }
   }
}

function roomingPDF(&$data,&$pdf){
  $pdf->Row(array(
     array('data'=>"Room Summary",'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"4")
  ));
  $pdf->Row(array(
     array('width'=>"13%", 'height'=>"4", 'data'=>"Arrive",'border'=>"LBT",'fill'=>1),
     array('width'=>"13%", 'height'=>"4", 'data'=>"Depart",'border'=>"BT",'fill'=>1),
     array('width'=>"14%", 'height'=>"4", 'data'=>"Property",'border'=>"BT",'fill'=>1),
     array('width'=>"17%", 'height'=>"4", 'data'=>"Accomm",'border'=>"BT",'fill'=>1),
     array('width'=>"13%", 'height'=>"4", 'data'=>"Room",'border'=>"BRT",'fill'=>1),
     array('width'=>"10%", 'height'=>"4", 'data'=>"Lock",'border'=>"BT",'fill'=>1),
     array('width'=>"20%", 'height'=>"4", 'data'=>"Reason",'border'=>"BRT",'fill'=>1)     
  ));  
  foreach($data['rooming']['rooms'] as $item){
    $pdf->Row(array(
       array('width'=>"13%", 'height'=>"4", 'data'=>$item['arrive'],'border'=>"LR"),
       array('width'=>"13%", 'height'=>"4", 'data'=>$item['depart'],'border'=>"R"),
       array('width'=>"14%", 'height'=>"4", 'data'=>$item['property'],'border'=>"R"),
       array('width'=>"17%", 'height'=>"4", 'data'=>$item['accomm'],'border'=>"R"),
       array('width'=>"13%", 'height'=>"4", 'data'=>$item['room'],'border'=>"R"),
       array('width'=>"10%", 'height'=>"4", 'data'=>$item['locked'],'border'=>"R"),
       array('width'=>"20%", 'height'=>"4", 'data'=>$item['reason'],'border'=>"R")     
    ));    
  }
  $pdf->Row(array(
     array('width'=>"100%", 'height'=>"4", 'data'=>"",'border'=>"T")     
  )); 
	
  //Guest names
	$pdf->Row(array(
     array('data'=>"Room (Guest Names) Summary",'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"4")
  ));
  
  foreach($data['rooming']['guestGroups'] as $gkey=>$gGroup){
		if($gkey != "0" && $gkey == "htmlRow") {
			continue;
		}
  	$pdf->Row(array(
       array('width'=>"28%", 'height'=>"4", 'data'=>"Guest Names",'border'=>"LTBR",'fill'=>1),
       array('width'=>"10%", 'height'=>"4", 'data'=>"Notes",'border'=>"TBR",'fill'=>1,'align'=>"C"),
       array('width'=>"10%", 'height'=>"4", 'data'=>"Int Memo",'border'=>"TBR",'fill'=>1, 'align'=>"C"),
       array('width'=>"13%", 'height'=>"4", 'data'=>t_decodeHTML($gGroup['itemHeader1']),'border'=>"TBR",'fill'=>1),
       array('width'=>"13%", 'height'=>"4", 'data'=>t_decodeHTML($gGroup['itemHeader2']),'border'=>"TBR",'fill'=>1),
       array('width'=>"13%", 'height'=>"4", 'data'=>t_decodeHTML($gGroup['itemHeader3']),'border'=>"TBR",'fill'=>1),
       array('width'=>"13%", 'height'=>"4", 'data'=>t_decodeHTML($gGroup['itemHeader4']),'border'=>"TBR",'fill'=>1)
    ));               
    
    foreach($gGroup['rows'] as $ikey=>$item){
      if($ikey != "0" && $ikey == "html") {
  			continue;
  		}
			
      if($item['item1Lock'] != "display:none;"){
		    $item['item1'] .= " (Locked)";
      }
      if($item['item2Lock'] != "display:none;"){
		    $item['item2'] .= " (Locked)";
      }
      if($item['item3Lock'] != "display:none;"){
		    $item['item3'] .= " (Locked)";
      }
      if($item['item4Lock'] != "display:none;"){
		    $item['item4'] .= " (Locked)";
      }                  
      $pdf->Row(array(
         array('width'=>"28%", 'height'=>"4", 'data'=>$item['name'],'border'=>"LR"),
         array('width'=>"10%", 'height'=>"4", 'data'=>$item['guestNote'],'border'=>"R", 'align'=>"C"),
         array('width'=>"10%", 'height'=>"4", 'data'=>$item['guestMemo'],'border'=>"R", 'align'=>"C"),
         array('width'=>"13%", 'height'=>"4", 'data'=>$item['item1'],'border'=>"R"),
         array('width'=>"13%", 'height'=>"4", 'data'=>$item['item2'],'border'=>"R"),
         array('width'=>"13%", 'height'=>"4", 'data'=>$item['item3'],'border'=>"R"),
         array('width'=>"13%", 'height'=>"4", 'data'=>$item['item4'],'border'=>"R")
      ));    
    }
  	$pdf->Row(array(
       array('width'=>"100%", 'height'=>"4", 'data'=>"",'border'=>"T")     
    ));     
  }  
}

function guestNotePDF(&$data,&$pdf){	
  if(sizeof($data['rooming']['guests']) != 0){
    $pdf->Row(array(
      array('data'=>"Guest Notes:",'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"4")
  	));
    foreach($data['rooming']['guests'] as $guests){
    	if($guests['pr_guest_note'] != ""){
    		$pdf->Row(array(
          array('data'=>"",'border'=>"LR",'height'=>"4")
      	));            
    		$pdf->Row(array(
          array('width'=>"2%", 'data'=>"",'border'=>"LR",'height'=>"4"),
          array('width'=>"96%", 'data'=>$guests['pr_name_last'].", ".$guests['pr_name_first'],'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"4"),
          array('width'=>"2%", 'data'=>"",'border'=>"LR",'height'=>"4")
      	));
    		$pdf->Row(array(
          array('width'=>"2%", 'data'=>"",'border'=>"LR"),
          array('width'=>"96%", 'data'=>$guests['pr_guest_note'],'border'=>"LRB"),
          array('width'=>"2%", 'data'=>"",'border'=>"LR")
      	));            
      }
    }
    $pdf->Row(array(
      array('data'=>"",'border'=>"LRB",'height'=>"4")
    ));         
  }
  $pdf->Ln(1);
}

function guestMemoPDF(&$data,&$pdf){
  if(sizeof($data['rooming']['guests']) != 0){
    $pdf->Row(array(
      array('data'=>"Guest Internal Memos:",'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"4")
  	));
    foreach($data['rooming']['guests'] as $iguests){
    	if($iguests['pr_guest_memo'] != ""){
    		$pdf->Row(array(
          array('data'=>"",'border'=>"LR",'height'=>"4")
      	));            
    		$pdf->Row(array(
          array('width'=>"2%", 'data'=>"",'border'=>"LR",'height'=>"4"),
          array('width'=>"96%", 'data'=>$iguests['pr_name_last'].", ".$iguests['pr_name_first'],'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"4"),
          array('width'=>"2%", 'data'=>"",'border'=>"LR",'height'=>"4")
      	));
    		$pdf->Row(array(
          array('width'=>"2%", 'data'=>"",'border'=>"LR"),
          array('width'=>"96%", 'data'=>$iguests['pr_guest_memo'],'border'=>"LRB"),
          array('width'=>"2%", 'data'=>"",'border'=>"LR")
      	));            
      }
    }
    $pdf->Row(array(
      array('data'=>"",'border'=>"LRB",'height'=>"4")
    ));                 
  }	
  $pdf->Ln(1);
}

function auditPDF(&$data, &$pdf,$options) {
   if(is_array($data['auditTrail']) && ($options & REP_BUTTON_AUDIT)) {
      $pdf->Row(array(
         array('data'=>"Audit Trail",'border'=>"LTRB",'style'=>"B",'fill'=>1,'height'=>"6")
      ));
      $pdf->Row(array(
         array('width'=>"13%",'data'=>"Date",'border'=>"LBT",'fill'=>1),
         array('width'=>"13%",'data'=>"Time",'border'=>"BT",'fill'=>1),
         array('width'=>"14%",'data'=>"Server",'border'=>"BT",'fill'=>1),
         array('width'=>"37%",'data'=>"User",'border'=>"BT",'fill'=>1),
         array('width'=>"23%",'data'=>"Details",'border'=>"BRT",'fill'=>1)
      ));      
      foreach($data['auditTrail'] as $item) {
  			$auditDate = $item["date"];
        if($item["date"] == "&nbsp;"){
        	$auditDate = "";
        }      
         $pdf->Row(array(
            array('width'=>"13%",'data'=>$auditDate,'border'=>"LB"),
            array('width'=>"13%",'data'=>$item["time"],'border'=>"B"),
            array('width'=>"14%",'data'=>$item["server"],'border'=>"B"),
            array('width'=>"37%",'data'=>$item["user"],'border'=>"B"),
            array('width'=>"23%",'data'=>$item["details"],'border'=>"BR")
         ));
      }
   }
}

function contactPDF(&$data, &$pdf) {
   $pdf->Row(array(
      array('width'=>"25%",'data'=>"Consultant (Internal)"),
      array('width'=>"25%",'data'=>"Agent"),
      array('width'=>"25%",'data'=>"Contact Person"),
      array('width'=>"25%",'data'=>"Originator")
   ));
   $contactList = array("consultant","agent","contact","orig");
   $names = array();
   $telephones = array();
   $faxes = array();
   foreach($contactList as $item) {
   	$data[$item."Detail"]['name'] = isset($data[$item."Detail"]['name']) ? $data[$item."Detail"]['name'] : "";
   	$data[$item."Detail"]['telephone'] = isset($data[$item."Detail"]['telephone']) ? $data[$item."Detail"]['telephone'] : "";
   	$data[$item."Detail"]['fax'] = isset($data[$item."Detail"]['fax']) ? $data[$item."Detail"]['fax'] : "";

      array_push($names,array('width'=>"25%",'data'=>$data[$item."Detail"]['name']));
      array_push($telephones,array('width'=>"25%",'data'=>$data[$item."Detail"]['telephone']));
      array_push($faxes,array('width'=>"25%",'data'=>$data[$item."Detail"]['fax']));
   }
   $pdf->Row($names);
   $pdf->Row($telephones);
   $pdf->Row($faxes);

   $pic = $pdf->_parsejpg(__DIR__ . "/../../../public/img/button_email.jpg");
   if ($pic['w'] > $pdf->GetPageWidth(1)/70) {
      $pic['w'] = $pdf->GetPageWidth(1)/70;
   }
   $logoY = $pdf->y;

   foreach($contactList as $item) {
   	$data[$item."Detail"]['email'] = isset($data[$item."Detail"]['email']) ? $data[$item."Detail"]['email'] : "";
      if($data[$item."Detail"]['email'] != "") {
         $pdf->Image(__DIR__ . "/../../../public/img/button_email.jpg", $pdf->x, $logoY, $pic['w']);
      }
      $pdf->Row(array(
         array('width'=>"1.5%",'data'=>""),
         array('width'=>"23.5%",'data'=>$data[$item."Detail"]['email'])
      ),0);
   }
   $pdf->Ln(0,1);
   $pdf->Ln(1);
}

function getPersonaFax($personaId) {
   $fax = $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone, rf_phone_type
      WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'",4);
   if(trim($fax) == "" || $fax == "0") {
      $fax = "";
   }
   return $fax;
}

function getPersonaTelephone($personaId) {
   $tel = $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone
      WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'",4);

   if(trim($tel) == "" || $tel == "0") {
      $tel = "";
   }
   return $tel;
}

function getPersonaDetail($personaId) {
	global $lDB;
	$result = array('name'=>"",'fax'=>"",'telephone'=>"",'email'=>"");
	if(empty($personaId)) return $result;
   $detail = $lDB->get("
      SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
      FROM
         pr_persona
      WHERE
         pr_persona.pr_persona_ix = '".$personaId."'",2);
   $detail = isset($detail[0]) ? $detail[0] : $detail=array();
   $name = "";
   if(isset($detail['pr_name_first']) && trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
      $name .= $detail['pr_name_first'] . " ";
   }
   if(isset($detail['pr_name_second']) && trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
      $name .= $detail['pr_name_second'] . " ";
   }
   if(isset($detail['pr_name_last']) && trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
      $name .= $detail['pr_name_last'] . " ";
   }
   
   $result['name'] = trim($name);
   $result['fax'] = getPersonaFax($personaId);
   $result['telephone'] = getPersonaTelephone($personaId);
   $result['email'] = isset($detail['pr_email']) ? $detail['pr_email'] : "";
   if(trim($result['email']) == "" || $result['email'] == "0") {
      $result['email'] = "";
   }
   return $result;
}

function verifyConsultant($personaId) {
	// I'm removing this check for Bug #4245 - if a consultant is set, it should show correctly regardless of the current state of the user record.
	return true;
   $consultantCount = $GLOBALS['lDB']->get("SELECT
            COUNT(sc_user.pr_user_id)
                     FROM
                        sc_group
                     INNER JOIN sc_user ON
                        sc_group.sc_group_id = sc_user.sc_group_id
                     INNER JOIN pr_persona ON
                        sc_user.pr_user_id = pr_persona.pr_persona_ix
                     WHERE
                        sc_group.sc_grp_consultant_yn=1
                     AND
                        pr_persona.pr_persona_inactive_yn=0
         AND
         pr_persona.pr_persona_ix = '$personaId'
                     ORDER BY
                        pr_persona.pr_name_first, pr_persona.pr_name_last",4);
   if($consultantCount > 0) {
      return true;
   }
   return false;
}

function verifyConsultantInactive($personaId) {
	$check = $GLOBALS['lDB']->get("
		SELECT COUNT(*)
		FROM
			pr_persona
			LEFT JOIN pr_user ON pr_user.pr_user_id = pr_persona.pr_persona_ix
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
			AND (
				pr_persona.pr_persona_inactive_yn = '1'
				OR pr_user.pr_user_inactive_yn = '1'
			)
	",4);
	if($check > 0) {
		return true;
	} else {
		return false;
	}
}

function verifyAgent($personaId) {
   $agentCount = $GLOBALS['lDB']->get("
      SELECT
         COUNT(DISTINCT pr_persona.pr_persona_ix)
      FROM
         pr_agent,
         pr_persona
      WHERE
         pr_agent.pr_agent_id = pr_persona.pr_persona_ix AND
         pr_agent.pr_agent_inactive_yn = 0 AND
         pr_persona.pr_sys_code < '6' AND
         pr_persona.pr_persona_ix = '$personaId'
      ORDER BY
         pr_persona.pr_name_last",4);
   if($agentCount > 0) {
      return true;
   }
   return false;
}

function getPayRef($resNum){
		$payRef = $GLOBALS['lDB']->get("
    		SELECT 
          rv_payment.rv_pmnt_ref
        FROM rv_payment
        LEFT JOIN rv_payment_item ON
          rv_payment_item.rv_reservation_id = '$resNum'
        WHERE
          rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
        ",3); 
    return $payRef;      
}

function renderUpdateSummaryHTML(&$data, $fromDate, $toDate, $markSymbol="",$countNew=0) {
	global $lDB;
	global $resScrollSet;
   $renderList = array();
   $listItem = array();
   $lastProperty = "0";
   $half = false;
	 	 
	 foreach($data as $key=>$item) {   
      if($item['dateCompare'] >= $fromDate && $item['dateCompare'] <= $toDate) {
         $mark = $markSymbol;
      } else {
         $mark = "";
      }					
      $itemIds = $lDB->get("SELECT rv_reservation_item.rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_item.rv_reservation_id = '".$item['id']."'",3);
      $roomChange = array();
      $rooming = array();
      foreach($itemIds as $ritem){
      	$roomChngDate = $lDB->get("
        	 SELECT
              rv_res_item_group.rv_grp_date_allocated
           FROM
              rv_res_item_group
           WHERE
              rv_res_item_group.rv_reservation_item_id =  '".$ritem."'",4);              
        if(($roomChngDate >= $fromDate) && ($roomChngDate <= $toDate)){
        	array_push($roomChange,$roomChngDate);
        }
      }
      $roomList = getReservationRooming($item['id']);
      if(sizeof($roomList['guests']) == 0 && sizeof($roomList['rooms']) == 0){
      	$roomChange = array();
        $rooming = array();
      }else{
      	array_push($rooming,"1");
      }
            
      //property change
      if($lastProperty != $item['propId']) {
         //right column        	     
         if($half) {
            $listItem['idB'] = "";
            $listItem['nameB'] = "";
            $listItem['hideB'] = "visibility:hidden";
            $listItem['roomChngB'] = "visibility:hidden;";
            $listItem['roomClassB'] = "";            
            array_push($resScrollSet,$listItem['id']);
            $listItem['resJob'] = "0";
            if (canEditReservation($listItem['id'])) {
               $listItem['resJob'] = "2";
            }
            array_push($renderList,$listItem);                             
         }
         //first res of new prop
         $listItem = array();         
         $listItem['propName'] = $item['propName'];
         $listItem['id'] = $item['id'];
         $listItem['name'] = "(" . $item['statusDesc'] . ") " . $item['name'] ;
         if(strlen($listItem['name']) > 30) {
            $listItem['name'] = substr($listItem['name'], 0, 30)."...";
         }
         if(sizeof($rooming) > 0){
           $listItem['roomChng'] = "visibility:visible;";
           $listItem['roomClass'] = "button bRooms";    
           if(sizeof($roomChange) > 0){
             $listItem['roomClass'] = "button bRoomChange";
           }
         }else{
           $listItem['roomChng'] = "visibility:hidden;";
           $listItem['roomClass'] = "";
         }  
         $listItem['hideB'] = "";
         $listItem['mark'] = $mark;
         $listItem['markB'] = "";      
         $half = true;				 
      } else {//same property
         if($half) {
           $listItem['idB'] = $item['id'];
           $listItem['nameB'] = "(" . $item['statusDesc'] . ") " . $item['name'];
           if(strlen($listItem['nameB']) > 30) {
              $listItem['nameB'] = substr($listItem['nameB'], 0, 30)."...";
           }           
           $listItem['markB'] = $mark;
           if(sizeof($rooming) > 0){
             $listItem['roomChngB'] = "visibility:visible;";
             $listItem['roomClassB'] = "button bRooms";                
             if(sizeof($roomChange) > 0){
               $listItem['roomClassB'] = "button bRoomChange";        
             }
           }else{
             $listItem['roomChngB'] = "visibility:hidden;";
             $listItem['roomClassB'] = "";
           }             
           array_push($resScrollSet,$listItem['id']);
           array_push($resScrollSet,$listItem['idB']);
           $listItem['resJob'] = "0";
           if (canEditReservation($listItem['id'])) {
              $listItem['resJob'] = "2";
           }
           $listItem['resJobB'] = "0";
           if (canEditReservation($listItem['idB'])) {
              $listItem['resJobB'] = "2";
           }
           array_push($renderList,$listItem);
           $listItem = array();
           $listItem['hideB'] = "";                       
           $listItem['mark'] = "";
           $listItem['markB'] = "";                      
           $half = false;
         } else {         
            $listItem['id'] = $item['id'];
            $listItem['name'] = "(" . $item['statusDesc'] . ") " . $item['name'];
            if(strlen($listItem['name']) > 30) {
               $listItem['name'] = substr($listItem['name'], 0, 30)."...";
            }
            $listItem['mark'] = $mark;
            $listItem['propName'] = "";
           	if(sizeof($rooming) > 0){
              $listItem['roomChng'] = "visibility:visible;";
              $listItem['roomClass'] = "button bRooms";           
              if(sizeof($roomChange) > 0){
                $listItem['roomClass'] = "button bRoomChange";        
              }
            }else{
              $listItem['roomChng'] = "visibility:hidden;";
              $listItem['roomClass'] = "";
            }         
            $half = true;
         }         
      }            
      $lastProperty = $item['propId'];			      
   }
   if($half) {      
      $listItem['idB'] = "";
      $listItem['nameB'] = "";
      $listItem['hideB'] = "visibility:hidden";
      array_push($resScrollSet,$listItem['id']);
      $listItem['resJob'] = "0";
      if (canEditReservation($listItem['id'])) {
         $listItem['resJob'] = "2";
      }      
      array_push($renderList,$listItem);
   }   
   setRecordScroll($resScrollSet);
   return $renderList;
}

function renderArriveDepartSummaryHTML(&$data,$fromDate,$toDate,$reportOptions) {
	global $resScrollSet;
   #     /*0*/ rv_reservation.rv_reservation_ix,
   #     /*1*/ rv_reservation.rv_res_name,
   #     /*2*/ ac_accomm_type.ac_accomm_desc,
   #     /*3*/ rv_reservation_item.rv_item_accomm_count,
   #     /*4*/ rv_reservation.rv_note_general,
   #     /*5*/ rv_reservation.rv_provision_expiry_date,
   #     /*6*/ rv_reservation_item.rv_item_adult_count,
   #     /*7*/ rv_reservation_item.rv_item_child_count,
   #     /*8*/ /*ac_accomm_type.ac_accomm_no_of_units,*/ '1' as ac_accomm_no_of_units,
   #     /*9*/ rv_reservation_item.rv_item_date_arrive,
   #     /*10*/   rv_reservation_item.rv_item_date_depart,
   #     /*11*/   rv_reservation.rv_note_general,
   #     /*12*/   rv_reservation.rv_agent_id,
   #     /*13*/   rv_reservation_item_ix as resItemId

	global $lDB;
   $totalRoom = 0;
   $totalAdult = 0;
   $totalChild = 0;


   $renderList = array();
   $renderList['data'] = array();
   $reservationID = "abc";
   $resProp = "";
   $agentNo = 0;
   foreach($data as $item) {
      $lastReservationId = $reservationID;
      $lastResProp = $resProp;
      $reservationID = $item['rv_reservation_ix'];
      $resItemID = $item['resItemId'];
      $resProp = $item['pr_bus_name_short'];
      $compList = " ".getOptionalComponents($item['resItemId']);

      $totalRoom += $item['rv_item_accomm_count'];
      $totalAdult += $item['rv_item_adult_count'] * $item['rv_item_accomm_count'];
      $totalChild += $item['rv_item_child_count'] * $item['rv_item_accomm_count'];
      $rowArray = array();      
      $rowArray['resNumber'] = $item['rv_reservation_ix'];
      if($lastReservationId == $reservationID) {               
         $rowArray['hideResNum'] = "visibility:hidden";
	       $rowArray['resName'] = "";         
         $rowArray['resDesc'] = "";
         if($lastResProp == $resProp){         
			 		 $rowArray['resProp'] = "";          
         }else{
           $rowArray['resProp'] = $item['pr_bus_name_short'];
         }  
      } else {
         //array_push($resScrollSet,$reservationID);                  
         $rowArray['hideResNum'] = "visibility:visible";
         $rowArray['resName'] = $item['rv_res_name'];         
         $rowArray['resDesc'] = $rowArray['resNumber'];// . " - " . $rowArray['resName'];
		 		 $rowArray['resProp'] = $item['pr_bus_name_short'];
      }
      $nights = dateSubtract($item['rv_item_date_depart'],$item['rv_item_date_arrive']);

      $rowArray['accomName'] = $item['ac_accomm_desc'].$compList;
      $rowArray['roomNumber'] = $item['rv_item_accomm_count'];
      $rowArray['adultNumber'] = $item['rv_item_adult_count'];
      $rowArray['childNumber'] = $item['rv_item_child_count'];
      $rowArray['dateArrive'] = chng_date($item['rv_item_date_arrive'],"-");
      $rowArray['dateDepart'] = chng_date($item['rv_item_date_depart'],"-");
      $rowArray['dateNights'] = dateSubtract($item['rv_item_date_depart'],$item['rv_item_date_arrive']);
      $rowArray['resJob'] = "0";
      if (canEditReservation($item['rv_reservation_ix'])) {
         $rowArray['resJob'] = "2";
      }

      if(trim($item['rv_note_general']) == "") {
         $rowArray['noteFlag'] = "";
      } else {
         $rowArray['noteFlag'] = "x";
      }
      // count extras
			
      // Room change
      $rowArray['roomClass'] = "button bRooms";
      $rowArray['roomChng'] = "visibility: visible;";            
      $roomChngDate = $lDB->get("
      	 SELECT
            rv_res_item_group.rv_grp_date_allocated
         FROM
            rv_res_item_group
         WHERE
            rv_res_item_group.rv_reservation_item_id =  '".$item['resItemId']."'",4);

      $roomSql = $lDB->get("SELECT 
      		ac_accomm_room.ac_desc as roomDesc 
        FROM rv_res_item_group 
        INNER JOIN ac_accomm_room ON ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id 
        WHERE rv_res_item_group.rv_reservation_item_id = '".$resItemID."'",3);
      $roomList = join($roomSql,", ");
	  if(sizeof($roomSql) > 0 && $reportOptions[6] == "1") {
		  $rowArray['roomList'] = trim($roomList);
		  $rowArray['roomListClass'] = "";
	  } else {
		  $rowArray['roomList'] = "";
		  $rowArray['roomListClass'] = "collapse";
	  }
      
      $guestSql = $lDB->get("SELECT 
      		rv_res_item_guest.pr_guest_id as roomGuest 
        FROM rv_res_item_guest 
        WHERE rv_res_item_guest.rv_reservation_item_id = '".$resItemID."'",3);
      $guestList = join($guestSql,", ");
      
      if($lastResProp == $resProp){         
        $rowArray['roomClass'] = "";
        $rowArray['roomChng'] = "visibility: hidden;";          
      }      
      if($roomList == "" && $guestList == ""){
        $rowArray['roomClass'] = "";
        $rowArray['roomChng'] = "visibility: hidden;";
      }else{
        $rowArray['roomClass'] = "button bRooms";
        $rowArray['roomChng'] = "visibility: visible;";
        if(($roomChngDate >= $fromDate) && ($roomChngDate <= $toDate)){
          $rowArray['roomClass'] = "button bRoomChange";
        }
      }

      $rowArray['agentNo'] = $agentNo;
      $agentNo++;

      $tmp = getPersonaDetail($item['rv_agent_id']);
      $rowArray['agentName'] = $tmp['name'];
      $tmp = null;

      $paymentPlan = getPayItems($item['rv_reservation_ix']);

      if(sizeof($paymentPlan['items']) > 0) {
         $amountTotal = $paymentPlan['payTotal'];
         fixAmtDisplay($amountTotal);
      } else {
         $amountTotal = "TBA";
      }

      if(/*sizeof($paymentPlan['payments']) > 0 &&*/ sizeof($paymentPlan['items']) > 0) {
         $amountDue = $paymentPlan['outstanding'];
         fixAmtDisplay($amountDue);
      } else {
         $amountDue = "TBA";
      }

      $rowArray['amountTotal'] = $amountTotal;
      $rowArray['amountDue'] = $amountDue;

      $extraCountSQL = "
         SELECT
            count(rv_extra.rv_extra_ix)
         FROM
            rv_extra
         WHERE
            rv_extra.rv_reservation_id = '$reservationID'
			AND rv_extra.rv_extra_void_ind = 0
            AND rv_extra.rv_extra_ind";

      if($lDB->get($extraCountSQL." <> '2'",4) > 0) {
         $rowArray['extraFlag'] = "x";
      } else {
         $rowArray['extraFlag'] = "";
      }

      if($lDB->get($extraCountSQL." = '2'",4) > 0) {
         $rowArray['travelFlag'] = "x";
      } else {
         $rowArray['travelFlag'] = "";
      }

      $rowArray['propertyCount'] = $lDB->get(" SELECT
                        count(DISTINCT ac_accomm_type.pr_business_id)
                     FROM
                        rv_reservation_item
                     INNER JOIN ac_accomm_type ON rv_reservation_item.ac_accomm_type_id =
                     ac_accomm_type.ac_accomm_type_ix
                     WHERE
                        rv_reservation_item.rv_reservation_id =  '".$reservationID."'",4);
      array_push($resScrollSet,$reservationID);


      array_push($renderList['data'],$rowArray);
   }
   $renderList['totalRoom']= $totalRoom ;
   $renderList['totalAdult'] = $totalAdult;
   $renderList['totalChild'] = $totalChild;
   setRecordScroll($resScrollSet);
   return $renderList;
}

function arriveDepartSummaryPDF(&$summaryArray, &$pdf, $propertiesNames, $dateRange, $reportOptions, $showStats) {
   $pdf->SetFont('Arial', '', 6);
   $pdf->Row(array(
      array('data'=>$propertiesNames." (" . $dateRange . ")", 'border'=>'LRTB', 'fill'=>1,'style'=>'B')));

   if($showStats == "1") {
	   $pdf->Row(array(array('border'=>"LR")));

	   $pdf->Row(array(
	   array('width'=>"1.4%",                   'border'=>"L"),
	   array('width'=>"16%"),
	   array('width'=>"9.4%", 'data'=>"Rooms",    'border'=>"LRTB", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>"People",   'border'=>"LRTB", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>"Adults",   'border'=>"LRTB", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>"Children", 'border'=>"LRTB", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"45%",                    'border'=>"R")));

	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%",  'data'=>"Total occupancy overnight", 'border'=>"LRT", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>$summaryArray['occupancyTotalRoom'], 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['occupancyTotalPeople'], 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['occupancyTotalAdult'], 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['occupancyTotalChild'], 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"45%",  'border'=>"R")));

	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%", 'data'=>"Total available rooms", 'border'=>"LR", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>$summaryArray['availableTotalRoom'], 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"45%", 'border'=>"R")));

	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%", 'data'=>"Inactive rooms", 'border'=>"LR", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>$summaryArray['inactiveTotalRoom'], 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"45%", 'border'=>"R")));

	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%", 'data'=>"Room occupancy", 'border'=>"LR", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>$summaryArray['occupancyPercent']."%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"45%", 'border'=>"R")));

	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%",  'border'=>"LR", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"LR", 'align'=>"R"),
	   array('width'=>"45%", 'border'=>"R")));

	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%",  'data'=>"Total arrivals", 'border'=>"LR", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>$summaryArray['arriveTotalRoom'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['arriveTotalPeople'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['arriveTotalAdult'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['arriveTotalChild'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"45%", 'border'=>"R")));

	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%",  'data'=>"Total stay-over", 'border'=>"LR", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>$summaryArray['stayingTotalRoom'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['stayingTotalPeople'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['stayingTotalAdult'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['stayingTotalChild'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"45%", 'border'=>"R")));

	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%",  'data'=>"Total departures", 'border'=>"LR", 'align'=>"R", 'style'=>"B", 'fill'=>1),
	   array('width'=>"9.4%", 'data'=>$summaryArray['departingTotalRoom'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['departingTotalPeople'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['departingTotalAdult'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"9.4%", 'data'=>$summaryArray['departingTotalChild'],'border'=>"LR", 'align'=>"R"),
	   array('width'=>"45%", 'border'=>"R")));


	   $pdf->Row(array(
	   array('width'=>"1.4%", 'border'=>"L"),
	   array('width'=>"16%",  'border'=>"T", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"T", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"T", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"T", 'align'=>"R"),
	   array('width'=>"9.4%", 'border'=>"T", 'align'=>"R"),
	   array('width'=>"45%", 'border'=>"R")));
   }//end stats
   $pdf->Row(array(array('border'=>'LRT')));


   $pdf->Row(array(
   array('width'=>'1.4%','border'=>'L'),
   array('width'=>'31.4%','data'=>"Arriving",'border'=>'LRTB', 'align'=>'C', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.5%','border'=>'L'),
   array('width'=>'31.4%','data'=>"Staying over",'border'=>'LRTB', 'align'=>'C', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.5%','border'=>'L'),
   array('width'=>'31.4%','data'=>"Departing", 'border'=>'LRTB', 'align'=>'C', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.4%','border'=>'R')));

   $pdf->Row(array(
   array('width'=>'1.4%','border'=>'L'),
   array('width'=>'9%','border'=>'LRT', 'fill'=>1),
   array('width'=>'9%','border'=>'LRT', 'fill'=>1),
   array('width'=>'13.4%','data'=>"Rooms",'border'=>'LRTB', 'align'=>'C', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.5%','border'=>"L"),
   array('width'=>'9%','border'=>'LRT', 'fill'=>1),
   array('width'=>'9%','border'=>'LRT', 'fill'=>1),
   array('width'=>'13.4%','data'=>"Rooms",'border'=>'LRTB', 'align'=>'C', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.5%','border'=>"L"),
   array('width'=>'9%','border'=>'LRT', 'fill'=>1),
   array('width'=>'9%','border'=>'LRT', 'fill'=>1),
   array('width'=>'13.4%','data'=>"Rooms",'border'=>'LRTB', 'align'=>'C', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.4%','border'=>'R')));

   $pdf->Row(array(
   array('width'=>'1.4%','border'=>'L'),
   array('width'=>'9%','data'=>"Res #",'border'=>'LRB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'9%','data'=>"Prop",'border'=>'LRB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'9.4%','data'=>"Type",'border'=>'LRTB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'4%','data'=>"Total",'border'=>'LRTB', 'align'=>'R', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.5%','border'=>"L"),
   array('width'=>'9%','data'=>"Res #",'border'=>'LRB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'9%','data'=>"Prop",'border'=>'LRB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'9.4%','data'=>"Type",'border'=>'LRTB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'4%','data'=>"Total",'border'=>'LRTB', 'align'=>'R', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.5%','border'=>"L"),
   array('width'=>'9%','data'=>"Res #",'border'=>'LRB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'9%','data'=>"Prop",'border'=>'LRB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'9.4%','data'=>"Type",'border'=>'LRTB', 'fill'=>1, 'style'=>'B'),
   array('width'=>'4%','data'=>"Total",'border'=>'LRTB', 'align'=>'R', 'fill'=>1, 'style'=>'B'),
   array('width'=>'1.4%','border'=>'R')));

   // find biggest size...
   $biggestSection = sizeof($summaryArray['arriveRow']);
   if(sizeof($summaryArray['stayingRow']) > $biggestSection) {
      $biggestSection = sizeof($summaryArray['stayingRow']);
   }
   if(sizeof($summaryArray['departingRow']) > $biggestSection) {
      $biggestSection = sizeof($summaryArray['departingRow']);
   }

   for($count=0;$count<$biggestSection;$count++) {
      $rowArray = array();
      array_push($rowArray,array("width" => "1.4%", "border" => "L"));
      $rowArray = array_merge($rowArray,arriveDepartSummaryShortListPDF($summaryArray['arriveRow'],$count,"No arrivals"));
      array_push($rowArray,array("width" => "1.5%"));
      $rowArray = array_merge($rowArray,arriveDepartSummaryShortListPDF($summaryArray['stayingRow'],$count,"No stay-overs"));
      array_push($rowArray,array("width" => "1.5%"));
      $rowArray = array_merge($rowArray,arriveDepartSummaryShortListPDF($summaryArray['departingRow'],$count,"No departures"));
      array_push($rowArray,array("width" => "1.4%", "border" => "R"));
      $pdf->Row($rowArray);
   }

   $pdf->Row(array(
      array('width'=>"1.4%", 'border'=>'LB'),
      array('width'=>"9%", 'border'=>'TB'),
      array('width'=>"9%", 'border'=>'TB'),
      array('width'=>"9.4%", 'border'=>'TB'),
      array('width'=>"4%", 'border'=>'TB'),
      array('width'=>"1.5%",'border'=>'B'),
      array('width'=>"9%", 'border'=>'TB'),
      array('width'=>"9%", 'border'=>'TB'),
      array('width'=>"9.4%", 'border'=>'TB'),
      array('width'=>"4%", 'border'=>'TB'),
      array('width'=>"1.5%",'border'=>'B'),
      array('width'=>"9%", 'border'=>'TB'),
      array('width'=>"9%", 'border'=>'TB'),
      array('width'=>"9.4%", 'border'=>'TB'),
      array('width'=>"4%", 'border'=>'TB'),
      array('width'=>"1.4%", 'border'=>'RB')));
   $pdf->Row(array(array()));

   arriveDepartSummaryListPDF($summaryArray['arriveRow'], $pdf, "Arrival summary", "No arrivals",$reportOptions);
   arriveDepartSummaryListPDF($summaryArray['stayingRow'], $pdf, "Stay-over summary", "No stay-overs",$reportOptions);
   arriveDepartSummaryListPDF($summaryArray['departingRow'], $pdf, "Departure summary", "No departures",$reportOptions);

   $pdf->SetFont('Arial', '', 8);
   $pdf->title = "Arrival/Departures (Details)";
   if($reportOptions[1] == "1") {
	   $pdf->AddPage();
   }
   //$pdf->AddPage();
}

function arriveDepartSummaryShortListPDF(&$listArray, $count, $emptyLabel) {
   $rowArray = array();
   if($count < sizeof($listArray)) {   
      array_push($rowArray,
         array('width'=>"9%",  'data'=>$listArray[$count]['resNumber'], 'align'=>"L", 'border'=>"LR"),
         array('width'=>"9%",  'data'=>$listArray[$count]['resProp'], 'align'=>"L", 'border'=>"LR"),
         array('width'=>"9.4%", 'data'=>$listArray[$count]['accomName'],  'align'=>"L", 'border'=>"LR"),
         array('width'=>"4%",   'data'=>$listArray[$count]['roomNumber'],   'align'=>"R", 'border'=>"LR"));
   } else {
      if(sizeof($listArray) == 0 && $count == 0) {
         array_push($rowArray,
            array('width'=>"18%",  'border'=>"LR", 'data'=>$emptyLabel),
            array('width'=>"9.4%", 'border'=>"LR"),
            array('width'=>"4%",   'border'=>"LR"));
      } else {
         array_push($rowArray,
            array('width'=>"9%",  'border'=>"LR"),
            array('width'=>"9%",  'border'=>"LR"),
            array('width'=>"9.4%", 'border'=>"LR"),
            array('width'=>"4%",   'border'=>"LR"));
      }
   }
   return $rowArray;
}

function arriveDepartSummaryListPDF(&$listArray, &$pdf, $heading, $emptyLabel, $reportOptions ) {
	$arrDepOptions	= array_slice($_SERVER['argv'],29,4);
	$arrDepResNum		= $arrDepOptions[0];
	$arrDepResName	= $arrDepOptions[1];
	$arrDepProp			= $arrDepOptions[2];
	$arrDepAgent		= $arrDepOptions[3];
	$width					= 83.2;

	$headerArray = array();

	if ( $arrDepResNum == "1" ) {
		array_push($headerArray,array('width'=>"6.4%",  'data'=>"Res No",   'border'=>"LRTB", 'align'=>"L", 'fill'=>"1", 'style'=>'B'));
	} else {
		$width = $width - 6.4;
	}

	if ( $arrDepResName == "1" ) {
		array_push($headerArray,array('width'=>"13.0%", 'data'=>"Res Name", 'border'=>"LRTB", 'align'=>"L", 'fill'=>"1", 'style'=>'B'));
	} else {
		$width = $width - 13;
	}

	if ( $arrDepProp == "1" ) {
		array_push($headerArray,array('width'=>"6%", 'data'=>"Prop", 'border'=>"LRTB", 'align'=>"L", 'fill'=>"1", 'style'=>'B'));
	} else {
		$width = $width - 6;
	}

	array_push($headerArray,
		array('width'=>"7.8%", 'data' => "Accomm",	'border' => "LRTB", 'align' => "L", 'fill' => "1", 'style' => 'B'),
		array('width'=>"3.6%", 'data' => "Rms",			'border' => "LRTB", 'align' => "R", 'fill' => "1", 'style' => 'B'),
		array('width'=>"3.6%", 'data' => "Adlt",		'border' => "LRTB", 'align' => "R", 'fill' => "1", 'style' => 'B'),
		array('width'=>"3.6%", 'data' => "Chld",		'border' => "LRTB", 'align' => "R", 'fill' => "1", 'style' => 'B'),
		array('width'=>"7.8%", 'data' => "Arrive",	'border' => "LRTB", 'align' => "L", 'fill' => "1", 'style' => 'B'),
		array('width'=>"7.8%", 'data' => "Depart",	'border' => "LRTB", 'align' => "L", 'fill' => "1", 'style' => 'B'),
		array('width'=>"3.2%", 'data' => "Ngt",			'border' => "LRTB", 'align' => "R", 'fill' => "1", 'style' => 'B'),
		array('width'=>"3.2%", 'data' => "Pro",			'border' => "LRTB",								'fill' => "1", 'style' => 'B'),
		array('width'=>"3.2%", 'data' => "Not",			'border' => "LRTB", 'align' => "C", 'fill' => "1", 'style' => 'B'),
		array('width'=>"3.3%", 'data' => "Xtra",		'border' => "LRTB", 'align' => "C", 'fill' => "1", 'style' => 'B'),
		array('width'=>"3.2%", 'data' => "Trvl",		'border' => "LRTB", 'align' => "C", 'fill' => "1", 'style' => 'B')
	);

	if ( $arrDepAgent == "1" ) {
		array_push($headerArray,array('width'=>"7.5%", 'data'=>"Agent",    'border'=>"LRTB", 'align'=>"L", 'fill'=>"1", 'style'=>'B'));
	} else {
		$width = $width - 7.5;
	}

	$pdf->Row(array(array('data'=>$heading, 'width'=>$width."%", 'border'=>"LRTB", 'fill'=>"1", 'style'=>'B')));

	$pdf->Row($headerArray);

	if ( sizeof($listArray) == 0 ) {
		$pdf->Row(array(
 			array('data'=>$emptyLabel, 'width'=>$width."%", 'border'=>"LRB")
		));
	}

	foreach ( $listArray as $item ) {
		$itemRowArray = array();

		if ( $arrDepResNum == "1" ) {
			array_push($itemRowArray,array('width'=>"6.4%", 'data'=>$item['resNumber'], 'border'=>"LR", 'align'=>"L"));
		}

		if ( $arrDepResName == "1" ) {
			array_push($itemRowArray,array('width'=>"13.0%", 'data'=>$item['resName'], 'border'=>"LR", 'align'=>"L"));
		}

		if ( $arrDepProp == "1" ) {
			array_push($itemRowArray,array('width'=>"6%", 'data'=>$item['resProp'], 'border'=>"LR", 'align'=>"L"));
		}

		array_push($itemRowArray,
			array('width'=>"7.8%", 'data'=>$item['accomName'],		'border'=>"LR", 'align'=>"L"),
			array('width'=>"3.6%", 'data'=>$item['roomNumber'],		'border'=>"LR", 'align'=>"R"),
			array('width'=>"3.6%", 'data'=>$item['adultNumber'],	'border'=>"LR", 'align'=>"R"),
			array('width'=>"3.6%", 'data'=>$item['childNumber'],	'border'=>"LR", 'align'=>"R"),
			array('width'=>"7.8%", 'data'=>$item['dateArrive'],		'border'=>"LR", 'align'=>"L"),
			array('width'=>"7.8%", 'data'=>$item['dateDepart'],		'border'=>"LR", 'align'=>"L"),
			array('width'=>"3.2%", 'data'=>$item['dateNights'],		'border'=>"LR", 'align'=>"R"),
			array('width'=>"3.2%", 'data'=>"",										'border'=>"LR"),
			array('width'=>"3.2%", 'data'=>$item['noteFlag'],			'border'=>"LR", 'align'=>"C"),
			array('width'=>"3.3%", 'data'=>$item['extraFlag'],		'border'=>"LR", 'align'=>"C"),
			array('width'=>"3.2%", 'data'=>$item['travelFlag'],		'border'=>"LR", 'align'=>"C")
		);

		if ( $arrDepAgent == "1" ) {
			array_push($itemRowArray,array('width'=>"7.5%", 'data'=>$item['agentName'],   'border'=>"LR", 'align'=>"L"));
		}

		$pdf->Row($itemRowArray);

		if ( $item['roomList'] != "" && $reportOptions[6] == "1" ) {
			$itemRowArray = array();

			if ( $arrDepResNum == "1" ) {
				array_push($itemRowArray,array('width'=>"6.4%", 'data'=>"", 'border'=>"LR", 'align'=>"L"));
			}

			if ( $arrDepResName == "1" ) {
				array_push($itemRowArray,array('width'=>"13.0%", 'data'=>"", 'border'=>"LR", 'align'=>"L"));
			}

			if ( $arrDepProp == "1" ) {
				array_push($itemRowArray,array('width'=>"6%", 'data'=>"", 'border'=>"LR", 'align'=>"L"));
			}

			array_push($itemRowArray,
				array('width'=>"50.3%",  'data'=>$item['roomList'],   'border'=>"LRTB", 'align'=>"L")		 
			);
			$pdf->Row($itemRowArray);
		}
	}
	$pdf->Row(array(array('width'=>$width."%", 'border'=>"T")));
}

function updateSummaryPDF(&$summaryArray,&$pdf,$updateNew,$updateAmended) {
	$pdf->Row(array(
		array('width' => "25%", 'data' => "Date", 'border' => "LTR", 'align' => "L", 'fill' => 1, 'style' => "B"),
		array('width' => "50%", 'data' => $summaryArray['fromDate']." To ".$summaryArray['toDate'], 'border' => "TR")
	));

	if ( $updateNew == "1" ) {
		$pdf->Row(array(
			array('width' => "25%", 'data' => "Total new reservations", 'border' => "LTRB", 'fill' => 1, 'style' => "B"),
			array('width' => "50%", 'data' => $summaryArray['numCreate'], 'border' => "TRB")
		));
	}

	if ( $updateAmended == "1" ) {
		$pdf->Row(array(
			array('width' => "25%", 'data' => "Total amended reservations", 'border' => "LTRB", 'fill' => 1, 'style' => "B"),
			array('width' => "50%", 'data' => $summaryArray['numChange'], 'border' => "TRB")
		));
	}

	$pdf->Ln(4);

	$pdf->Row(array(
		array('width' => "80%", 'data' => "* Indicates where a reservation is created and last edited for the selected date range ")
	));
	$pdf->Ln(4);

	if ( $updateNew == "1" ) {
		updateSummaryListPDF($summaryArray['newRes'],$pdf,"New");
		$pdf->Ln(4);
	}

	if ( $updateAmended == "1" ) {
		updateSummaryListPDF($summaryArray['chngRes'],$pdf,"Amended");
		$pdf->Ln(4);
	}

	$pdf->title = "Update (Details)";
	$pdf->AddPage();
}

function updateSummaryListPDF(&$listArray, &$pdf, $label) {
	$pdf->Row(array(
		array('width' => "100%", 'data' => $label . " Reservations", 'border' => "LTR", 'fill' => 1, 'style' => "B")
	));

	$pdf->Row(array(
		array('width' => "20%", 'data' => "Property", 'border' => "LTRB", 'fill' => 1, 'style' => "B"),
		array('width' => "15%", 'data' => "Reservation Nr", 'border' => "LTRB", 'fill' => 1, 'style' => "B"),
		array('width' => "25%", 'data' => "Reservation Name", 'border' => "LTRB", 'fill' => 1, 'style' => "B"),
		array('width' => "15%", 'data' => "Reservation Nr", 'border' => "LTRB", 'fill' => 1, 'style' => "B"),
		array('width' => "25%", 'data' => "Reservation Name", 'border' => "LTRB", 'fill' => 1, 'style' => "B")
	));

	if ( sizeof($listArray) == 0 ) {
		$pdf->Row(array(
			array('width' => "100%", 'data' =>"There are no " . $label . " reservations", 'border' => "LTRB", 'align' => "C")
		));
	} else {
		foreach ( $listArray as $item ) {
			$pdf->Row(array(
				array('width' => "20%", 'data' => $item['propName'], 'border' => "LTRB"),
				array('width' => "15%", 'data' => $item['id'], 'border' => "LTRB"),
				array('width' => "25%", 'data' => $item['mark'].$item['name'], 'border' => "LTRB"),
				array('width' => "15%", 'data' => $item['idB'], 'border' => "LTRB"),
				array('width' => "25%", 'data' => $item['markB'].$item['nameB'], 'border' => "LTRB")
			));
		}
	}
}

function paymentPDF(&$data, &$pdf) {
	$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Payment plan", 'LRTB', 1, 'L', 1);
	$pdf->Ln(1);
	$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "Payments according to the following schedule must be made:", '', 1, 'L');
	$pdf->Ln(4);
	$pdf->Row(array(
		array('width' => "100%", 'data' => "Plan", 'border' => "LTRB", 'fill' => 1)
	));

	$pdf->Row(array(
		array('width' => "85%", 'data' => "Date Due", 'border' => "LTRB", 'fill' => 1),
		array('width' => "15%", 'data' => "Amount", 'border' => "LTRB", 'fill' => 1)
	));			 

	if (isset($data['payRows']) && is_array($data['payRows'])) {
		$max = sizeof($data['payRows']);
		for ( $count = 0; $count < $max; $count++ ) {
			if ( $count <= ($max-1) ) {
				$data['payRows'][$count]['pay_date'] = isset($data['payRows'][$count]['pay_date']) ? $data['payRows'][$count]['pay_date'] : "";
				$data['payRows'][$count]['rv_pay_plan_amount'] = isset($data['payRows'][$count]['rv_pay_plan_amount']) ? $data['payRows'][$count]['rv_pay_plan_amount'] : "";
				$data['payRows'][$count]['rf_currency_symbol'] = isset($data['payRows'][$count]['rf_currency_symbol']) ? $data['payRows'][$count]['rf_currency_symbol'] : "";
				$pdf->Row(array(
					array('width' => "85%", 'data' => $data['payRows'][$count]['pay_date'], 'border' => "LTRB"),
					array('width' => "15%", 'data' => $data['payRows'][$count]['rv_pay_plan_amount'] . " " . $data['payRows'][$count]['rf_currency_symbol'], 'border' => "LTRB", 'align'=>"R")
				));
			}
		}
	}

	$pdf->Ln(1);
	$pdf->Row(array(
		array('width' => "100%", 'data' => "Payment	Analysis", 'border' => "LTRB", 'fill' => 1, 'style' => "B")
	));

	$pdf->Row(array(
		array('width' => "17%", 'data' => "Payment Date", 'border' => "LTRB", 'fill' => 1),
		array('width' => "25%", 'data' => "Payer", 'border' => "LTRB", 'fill' => 1),
		array('width' => "13%", 'data' => "Reference", 'border' => "LTRB", 'fill' => 1),
		array('width' => "10%", 'data' => "Curr", 'border' => "LTRB", 'fill' => 1),
		array('width' => "10%", 'data' => "Folio", 'border' => "LTRB", 'fill' => 1),
		array('width' => "10%", 'data' => "Invoice", 'border' => "LTRB", 'fill' => 1),
		array('width' => "15%", 'data' => "Amount", 'border' => "LTRB", 'fill' => 1)
	));

	if (isset($data['payedRows']) && is_array($data['payedRows'])) {
		$pmax = sizeof($data['payedRows']);
		for ( $count = 0; $count < $pmax; $count++ ) {
			if ( $count <= ($pmax-1) ) {
				$data['payedRows'][$count]['pay_date'] = isset($data['payedRows'][$count]['pay_date']) ? $data['payedRows'][$count]['pay_date'] : "";
				$data['payedRows'][$count]['pr_name_last'] = isset($data['payedRows'][$count]['pr_name_last']) ? $data['payedRows'][$count]['pr_name_last'] : "";
				$data['payedRows'][$count]['rv_pmnt_ref'] = isset($data['payedRows'][$count]['rv_pmnt_ref']) ? $data['payedRows'][$count]['rv_pmnt_ref'] : "";
				$data['payedRows'][$count]['rf_currency_symbol'] = isset($data['payedRows'][$count]['rf_currency_symbol']) ? $data['payedRows'][$count]['rf_currency_symbol'] : "";
				$data['payedRows'][$count]['fn_folio_folio_num'] = isset($data['payedRows'][$count]['fn_folio_folio_num']) ? $data['payedRows'][$count]['fn_folio_folio_num'] : "";
				$data['payedRows'][$count]['fn_invoice_ix'] = isset($data['payedRows'][$count]['fn_invoice_ix']) ? $data['payedRows'][$count]['fn_invoice_ix'] : "";
				$data['payedRows'][$count]['rv_payment_item_amt'] = isset($data['payedRows'][$count]['rv_payment_item_amt']) ? $data['payedRows'][$count]['rv_payment_item_amt'] : "";
				$pdf->Row(array(
					array('width' => "17%", 'data' => $data['payedRows'][$count]['pay_date'], 'border' => "LTRB"),
					array('width' => "25%", 'data' => $data['payedRows'][$count]['pr_name_last'], 'border' => "LTRB"),
					array('width' => "13%", 'data' => $data['payedRows'][$count]['rv_pmnt_ref'], 'border' => "LTRB"),
					array('width' => "10%", 'data' => $data['payedRows'][$count]['rf_currency_symbol'], 'border' => "LTRB"),
					array('width' => "10%", 'data' => $data['payedRows'][$count]['fn_folio_folio_num'], 'border' => "LTRB"),
					array('width' => "10%", 'data' => $data['payedRows'][$count]['fn_invoice_ix'], 'border' => "LTRB"),
					array('width' => "15%", 'data' => $data['payedRows'][$count]['rv_payment_item_amt'] . " " . $data['payedRows'][$count]['rf_currency_symbol'], 'border' => "LTRB", 'align' => "R")
				));
			}
			$pdf->Ln(0, 1);
		}
	}

	if ( $data['showPaymentTotal'] == "" ) {
		$pdf->Row(array(
			array('width' => "65%", 'data' => "", 'border' => "LTRB"),
			array('width' => "20%", 'data' => "Total Amount STILL DUE: ", 'border' => "LTRB", 'fill' => 1, 'align'=>"R"),
			array('width' => "15%", 'data' => $data['payOutstanding'] ." " . $data['invCurr'], 'border' => "LTRB", 'align'=>"R")
		));
	}
	$pdf->Ln(4);
}

function getGuestNationality($country_id) {
	global $lDB;
	$exists = $lDB->get("SELECT count(rf_country_name) FROM rf_country WHERE rf_country_ix = '" . $country_id . "'",4);

	if ( $exists > 0 ) {
		return $lDB->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '" . $country_id . "'",4);
	}
	return "";
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

function getmicrotime() {
	list($usec, $sec) = explode(" ",microtime());
	return ((float)$usec + (float)$sec);
}


if ( $GLOBALS['showTime'] ) {
	$GLOBALS['timeEnd'] = getmicrotime();

	$timeTaken = $GLOBALS['timeEnd'] - $GLOBALS['timeStart'];

	echo "Took " . $timeTaken . " seconds (this message will only be shown on blackmax and automatically removed elsewhere)<br />";
}
