<?php

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("revenue_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Revenue Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_revenue.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],21,"");

if(trim($_SERVER['argv'][1]) == "" || trim($_SERVER['argv'][1]) == "") {
	$fromDate = date("Y-m") . "-01";
	$toDate = date("Y-m-d",mktime(0,0,0,date("m")+1,0,date("Y")));

	$fromYear = date("Y");
	$toYear = date("Y");
	$fromMonth = date("M");
	$toMonth = date("M");

	$GLOBALS['temp']['fromM'] = date("m");
	$GLOBALS['temp']['toM'] = date("m");
	$GLOBALS['temp']['fromY'] = date("Y");
	$GLOBALS['temp']['toY'] = date("Y");
} else {
	list($fromYear,$fromMonth) = explode("-",$_SERVER['argv'][1]);
	list($toYear,$toMonth) = explode("-",$_SERVER['argv'][2]);

	$fromDate = date("Y-m-d",mktime(0,0,0,$fromMonth,1,$fromYear));
	$toDate = date("Y-m-d",mktime(0,0,0,$toMonth+1,0,$toYear));
	
	$GLOBALS['temp']['fromM'] = $fromMonth;
	$GLOBALS['temp']['toM'] = $toMonth;
	$GLOBALS['temp']['fromY'] = $fromYear;
	$GLOBALS['temp']['toY'] = $toYear;
}
if(strlen($fromMonth) == 1) {
	$fromMonth = "0".$fromMonth;
}
if(strlen($toMonth) == 1) {
	$toMonth = "0".$toMonth;
}
$GLOBALS['temp']['fromDate'] = $fromDate;
$GLOBALS['temp']['toDate'] = $toDate;

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");

$GLOBALS['temp']['fromDateFormat'] = chng_date($fromDate,"-");
$GLOBALS['temp']['toDateFormat'] = chng_date($toDate,"-");
$GLOBALS['temp']['fromPeriodName'] = date("M Y",mktime(0,0,0,(int)$fromMonth,1,$fromYear));
$GLOBALS['temp']['toPeriodName'] = date("M Y",mktime(0,0,0,(int)$toMonth,1,$toYear));

// Create 'period' array
$periods = array();
$periodCurr = $fromYear . "-" . $fromMonth;
$periodEnd = date("Y",mktime(0,0,0,$toMonth+1,1,$toYear)) . "-" . date("m",mktime(0,0,0,$toMonth+1,1,$toYear));
while($periodCurr < $periodEnd) {
	list($periodCurrYear, $periodCurrMonth) = explode("-",$periodCurr);
	$periodCurrStart = date("Y-m-d",mktime(0,0,0,$periodCurrMonth,1,$periodCurrYear));
	$periodCurrEnd =  date("Y-m-d",mktime(0,0,0,$periodCurrMonth+1,0,$periodCurrYear));
	$periodCurrLabel = date("M Y",mktime(0,0,0,$periodCurrMonth,1,$periodCurrYear));
	array_push($periods,array(
		'start'=> $periodCurrStart,
		'end'=> $periodCurrEnd,
		'total'=>0,
		'name'=>$periodCurrLabel
	));
	$periodCurr = date("Y-m", mktime(0,0,0,$periodCurrMonth+1,1,$periodCurrYear));
}

$statusACL = $lDB->get("
	SELECT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id <> 25
		AND rf_reservation_status_id <> 97
",3);

// Properties filter moved down to support property cut after calAcRecurse
$currenciesFilter = useFilter("currencies",$_SERVER['argv'][5],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","rv_reservation.rv_invoice_currency_id",false,false,false);
$agentACL = false;
if($userStatusId < 2) {
	$agentACL = array($calAgentId);
}
$agentFilter = useFilter("agent",$_SERVER['argv'][7],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");
$agentCountryFilter = useFilter("agentCountry",$_SERVER['argv'][8],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_ag.pr_corr_country_id",false,false,false);
$agentSelect = $_SERVER['argv'][6];
$GLOBALS['temp']['agentNameRadioChecked'] = "checked";
$GLOBALS['temp']['agentCountryRadioChecked'] = "";
if($agentSelect == "country") {
	$GLOBALS['temp']['agentNameRadioChecked'] = "";
	$GLOBALS['temp']['agentCountryRadioChecked'] = "checked";
	$agentWhere = $agentCountryFilter['where'];
} else {
	$agentWhere = $agentFilter['where'];
}

// 6 is agent country
if($_SERVER['argv'][1] == "" && $_SERVER['argv'][9] == "") {
	$_SERVER['argv'][9] = "30";
}
$statusFilter = useFilter("statusAlloc",$_SERVER['argv'][9],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);
$consultantFilter = useFilter("consultant",$_SERVER['argv'][10],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");
$originatorFilter = useFilter("originator",$_SERVER['argv'][11],"SELECT pr_persona.pr_name_first,pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_origin_agent_id",false,"No originator","0");
$sourceFilter = useFilter("source",$_SERVER['argv'][12],"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =","rv_reservation.rf_source_ix",false,"No source","0");
// 11 is nationality
$nationalityFilter = useFilter("nationality",$_SERVER['argv'][13],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","rv_reservation.rf_country_id",false,"No nationality","0");
$nationalityFilter['where'] = "AND ( 1 ".$nationalityFilter['where']." OR rv_reservation.rf_country_id IS NULL )";

$level1 = $_SERVER['argv'][14];
$GLOBALS['temp']["level1".$level1] = "selected";
$level2 = $_SERVER['argv'][15];
$GLOBALS['temp']["level2".$level2] = "selected";

$totalSelect = $_SERVER['argv'][16];
$GLOBALS['temp']['totalNettRadioChecked'] = "checked";
$GLOBALS['temp']['totalGrossRadioChecked'] = "";
$GLOBALS['temp']['valueType'] = "Nett Values";

if($totalSelect == "gross") {
	$GLOBALS['temp']['totalNettRadioChecked'] = "";
	$GLOBALS['temp']['totalGrossRadioChecked'] = "checked";
	$GLOBALS['temp']['valueType'] = "Gross Values";
}

$taxToggle = $_SERVER['argv'][17];
$GLOBALS['temp']['taxIncludeRadioChecked'] = "";
$GLOBALS['temp']['taxExcludeRadioChecked'] = "checked";
if($taxToggle == "include") {
	$GLOBALS['temp']['taxIncludeRadioChecked'] = "checked";
	$GLOBALS['temp']['taxExcludeRadioChecked'] = "";
}

$filterStatus = $_SERVER['argv'][18];
$renderOption = $_SERVER['argv'][19];
$showHideButtonText = $_SERVER['argv'][20];

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}

// BUG #5484: END -------------------------------------------------------------


//get property list
if($_SERVER['argc'] < 2 && trim($_SERVER['argv'][4]) == "") {
	$_SERVER['argv'][4] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}
if($level1 == "property" || $level2 == "property") {
	calAcRecurse(0,true); //fix for inactives...
	if($_SERVER['argv'][4] != "") {
		$propList = $lDB->get("SELECT DISTINCT pr_business_id FROM ac_accomm_type WHERE ac_accomm_type_ix IN ('".join("','",explode(":",$_SERVER['argv'][4]))."')",3);
		$GLOBALS['calAcRecurseResult'] =  array_intersect($propList,$GLOBALS['calAcRecurseResult']);
	}
}

$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][4],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

if($_SERVER['argc'] > 1) {
	if($renderOption == 0) {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
	}

	$GLOBALS['temp']['reportGenerated'] = "";

	$dateWhere = "
		(
			(
				fn_invoice.fn_invoice_ix IS NULL
				AND fn_folio.fn_folio_date >= '$fromDate'
				AND fn_folio.fn_folio_date <= '$toDate'
			) OR (
				fn_invoice.fn_invoice_ix IS NOT NULL
				AND fn_invoice.fn_inv_date >= '$fromDate'
				AND fn_invoice.fn_inv_date <= '$toDate'
			)
		)
	";

	$groupBy = array();
	$orderBy = array();
	$levelSelect = "";
	switch($level1) {
	case "all":
		$level1Join = "";
		$GLOBALS['temp']['level1Name'] = "All Reservations";
		$levelSelect .= ",'All' as level1";
		break;
	case "property":
		$level1Join = "INNER JOIN pr_persona AS pr_bus ON ac_accomm_type.pr_business_id = pr_bus.pr_persona_ix";
		array_push($groupBy,"ac_accomm_type.pr_business_id");
		$levelSelect .= ",pr_bus.pr_name_last as level1, pr_bus.pr_persona_ix as level1Id";
		$GLOBALS['temp']['level1Name'] = "Property";
		break;
	case "agent":
		$level1Join = "";
		array_push($groupBy,"rv_reservation.rv_agent_id");
		array_push($orderBy,"pr_ag.pr_name_last");
		$levelSelect .= ",pr_ag.pr_name_last as level1, pr_ag.pr_persona_ix as level1Id";
		$GLOBALS['temp']['level1Name'] = "Agent";
		$level1Empty = "Direct booking";
		break;
	case "source":
		$level1Join = "LEFT JOIN rf_source ON rv_reservation.rf_source_ix = rf_source.rf_source_ix";
		array_push($groupBy,"rv_reservation.rf_source_ix");
		array_push($orderBy,"rf_source.rf_source_desc");
		$levelSelect .= ",rf_source.rf_source_desc as level1, rv_reservation.rf_source_ix as level1Id";
		$GLOBALS['temp']['level1Name'] = "Source";
		$level1Empty = "No source";
		break;
	case "originator":
		$level1Join = "LEFT JOIN pr_persona as pr_orig ON rv_reservation.rv_origin_agent_id = pr_orig.pr_persona_ix";
		array_push($groupBy,"rv_reservation.rv_origin_agent_id");
		array_push($orderBy,"pr_orig.pr_name_last");
		$levelSelect .= ",pr_orig.pr_name_last as level1, pr_orig.pr_persona_ix as level1Id";
		$GLOBALS['temp']['level1Name'] = "Originator";
		$level1Empty = "No originator";
		break;
	case "consultant":
		$level1Join = "LEFT JOIN pr_persona AS pr_cons ON rv_reservation.rv_consultant_id = pr_cons.pr_persona_ix";
		array_push($groupBy,"rv_reservation.rv_consultant_id");
		array_push($orderBy,"pr_cons.pr_name_last");
		$levelSelect .= ",pr_cons.pr_name_last as level1, pr_cons.pr_persona_ix as level1Id";
		$GLOBALS['temp']['level1Name'] = "Consultant";
		$level1Empty = "No consultant";
		break;
	case "nationality":
		$level1Join = "LEFT JOIN rf_country ON rv_reservation.rf_country_id = rf_country.rf_country_ix";
		array_push($groupBy,"rv_reservation.rf_country_id");
		array_push($orderBy,"rf_country.rf_country_name");
		$levelSelect .= ",rf_country.rf_country_name as level1, rv_reservation.rf_country_id as level1Id";
		$GLOBALS['temp']['level1Name'] = "Nationality";
		$level1Empty = "No nationality";
		break;
	}

	switch($level2) {
	case "none":
		$level2Join = "";
		$GLOBALS['temp']['level2Name'] = "";
		$levelSelect .= ",'empty' as level2, 'empty' as level2Id";
		break;
	case "property":
		$level2Join = "INNER JOIN pr_persona AS pr_bus ON ac_accomm_type.pr_business_id = pr_bus.pr_persona_ix";
		array_push($groupBy,"ac_accomm_type.pr_business_id");
		array_push($orderBy,"pr_ag.pr_name_last");
		$levelSelect .= ",pr_bus.pr_name_last as level2, pr_bus.pr_persona_ix as level2Id";
		$GLOBALS['temp']['level2Name'] = "Property";
		break;
	case "agent":
		$level2Join = "";
		array_push($groupBy,"rv_reservation.rv_agent_id");
		$levelSelect .= ",pr_ag.pr_name_last as level2, pr_ag.pr_persona_ix as level2Id";
		$GLOBALS['temp']['level2Name'] = "Agent";
		$level2Empty = "Direct booking";
		break;
	case "source":
		$level2Join = "LEFT JOIN rf_source ON rv_reservation.rf_source_ix = rf_source.rf_source_ix";
		array_push($groupBy,"rv_reservation.rf_source_ix");
		array_push($orderBy,"rf_source.rf_source_desc");
		$levelSelect .= ",rf_source.rf_source_desc as level2, rv_reservation.rf_source_ix as level2Id";
		$GLOBALS['temp']['level2Name'] = "Source";
		$level2Empty = "No source";
		break;
	case "originator":
		$level2Join = "LEFT JOIN pr_persona as pr_orig ON rv_reservation.rv_origin_agent_id = pr_orig.pr_persona_ix";
		array_push($groupBy,"rv_reservation.rv_origin_agent_id");
		array_push($orderBy,"pr_orig.pr_name_last");
		$levelSelect .= ",pr_orig.pr_name_last as level2, pr_orig.pr_persona_ix as level2Id";
		$GLOBALS['temp']['level2Name'] = "Originator";
		$level2Empty = "No originator";
		break;
	case "consultant":
		$level2Join = "LEFT JOIN pr_persona AS pr_cons ON rv_reservation.rv_consultant_id = pr_cons.pr_persona_ix";
		array_push($groupBy,"rv_reservation.rv_consultant_id");
		array_push($orderBy,"pr_cons.pr_name_last");
		$levelSelect .= ",pr_cons.pr_name_last as level2, pr_cons.pr_persona_ix as level2Id";
		$GLOBALS['temp']['level2Name'] = "Consultant";
		$level2Empty = "No consultant";
		break;
	case "nationality":
		$level2Join = "LEFT JOIN rf_country ON rv_reservation.rf_country_id = rf_country.rf_country_ix";
		array_push($groupBy,"rv_reservation.rf_country_id");
		array_push($orderBy,"rf_country.rf_country_name");
		$levelSelect .= ",rf_country.rf_country_name as level2, rv_reservation.rf_country_id as level2Id";
		$GLOBALS['temp']['level2Name'] = "Nationality";
		$level2Empty = "No nationality";
		break;
	}
	array_push($groupBy,"rf_currency.rf_currency_symbol");

	$groupByClause = join(",",$groupBy);
	if(sizeof($orderBy) > 0) {
		$orderByClause = "\nORDER BY " . join(",",$orderBy);
	} else {
		$orderByClause = "";
	}
	$sql = "
		SELECT
			rv_reservation.rv_reservation_ix,
			rf_currency.rf_currency_symbol,
			rv_reservation.rv_invoice_currency_id as currencyId,
			rv_reservation.rv_commission_deduct_yn,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_consultant_id,
			rv_reservation.rv_origin_agent_id,
			rv_reservation.rf_source_ix,
			fn_folio.fn_folio_date,
			fn_invoice.fn_invoice_ix,
			fn_invoice.fn_inv_date,
			1 as resCount,
			(rv_reservation_item.rv_item_nights) as nights,
			(rv_reservation_item.rv_item_adult_count * rv_reservation_item.rv_item_accomm_count * rv_reservation_item.rv_item_nights) as rv_item_adult_count,
			(rv_reservation_item.rv_item_child_count * rv_reservation_item.rv_item_accomm_count * rv_reservation_item.rv_item_nights) as rv_item_child_count,
			(rv_reservation_item.rv_item_amt_comm) as rv_item_amt_comm,
			(rv_reservation_item.rv_item_amt_gross) as rv_item_amt_gross,
			(rv_reservation_item.rv_item_amt_nett) as rv_item_amt_nett,
			(rv_reservation_item.rv_item_amt_tax) as rv_item_amt_tax
			$levelSelect
		FROM
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> '8'			
			LEFT JOIN rf_currency ON rv_reservation.rv_invoice_currency_id = rf_currency.rf_currency_ix
			LEFT JOIN pr_persona as pr_ag ON rv_reservation.rv_agent_id = pr_ag.pr_persona_ix
			LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			$level1Join
			$level2Join
		WHERE
			$dateWhere
			AND rv_reservation_item.rv_item_amt_gross IS NOT NULL
			AND rv_reservation_item.rv_item_amt_nett IS NOT NULL
			AND rv_reservation_item.rv_item_amt_comm IS NOT NULL
			$accommFilter[where]
			$currenciesFilter[where]
			$agentWhere
			$statusFilter[where]
			$consultantFilter[where]
			$originatorFilter[where]
			$sourceFilter[where]
			$nationalityFilter[where]
		$orderByClause
	";

	$listArray = $lDB->get($sql,2);
	$level1Name = $level1;
	$level2Name = $level2;
	$level1 = null;
	$level2 = null;
	$currency = "";
	$level1Total = 0;
	$level2Total = 0;
	$repArray = array();
	foreach($listArray as $item) {
		if($item['level1'] == "") {
			$item['level1'] = $level1Empty;
			$item['level1Id'] = "0";
		}
		if($item['level2'] == "") {
			$item['level2'] = $level2Empty;
			$item['level2Id'] = "0";
		}
		if($level1 != $item['level1']) {
			$level1 = $item['level1'];
			$item['level1Id'] = isset($item['level1Id']) ? $item['level1Id'] : "";
			$repArray[$level1]['id'] = $item['level1Id'];
			$level2 = "";
			$currency = "";
		}
		if($level2 != $item['level2']) {
			$level2 = $item['level2'];
			$repArray[$level1][$level2]['id'] = $item['level2Id'];
			$currency = "";
		}
		if($currency != $item['rf_currency_symbol']) {
			$currency = $item['rf_currency_symbol'];
			if(!isset($repArray[$level1][$level2][$currency])) {
				$repArray[$level1][$level2][$currency] = $periods;
			}
			$repArray[$level1][$level2][$currency]['id'] = $item['currencyId'];
		}
		$item['rv_item_adult_count'] = isset($item['rv_item_adult_count']) ? $item['rv_item_adult_count'] : 0;
		$item['rv_item_child_count'] = isset($item['rv_item_child_count']) ? $item['rv_item_child_count'] : 0;
		$bedNights = ($item['rv_item_adult_count'] + $item['rv_item_child_count']) /* $item['nights']*/;

		if (isset($repArray[$level1]['bedNights'])) {
			$repArray[$level1]['bedNights'] += $bedNights;
		} else {
			$repArray[$level1]['bedNights'] = $bedNights;
		}

		if (isset($repArray[$level1][$level2]['bedNights'])) {
			$repArray[$level1][$level2]['bedNights'] += $bedNights;
		} else {
			$repArray[$level1][$level2]['bedNights'] = $bedNights;
		}

		if (isset($repArray[$level1][$level2][$currency]['bedNights'])) {
			$repArray[$level1][$level2][$currency]['bedNights'] += $bedNights;
		} else {
			$repArray[$level1][$level2][$currency]['bedNights'] = $bedNights;
		}

		$repArray[$level1]['resCount'] = $repArray[$level1]['resCount'] ?? [];
		$repArray[$level1][$level2]['resCount'] = $repArray[$level1][$level2]['resCount'] ?? [];
		$repArray[$level1][$level2][$currency]['resCount'] = $repArray[$level1][$level2][$currency]['resCount'] ?? [];

		// Build arrays of reservation numbers, for a unique list of reservations. We'll flatten it later.
		$repArray[$level1]['resCount'][] = $item['rv_reservation_ix'];
		$repArray[$level1][$level2]['resCount'][] = $item['rv_reservation_ix'];
		$repArray[$level1][$level2][$currency]['resCount'][] = $item['rv_reservation_ix'];
		
		$currencyTotal = 0;
		if($item['fn_invoice_ix']) {
			$item['invDate'] = $item['fn_inv_date'];
		} else {
			$item['invDate'] = $item['fn_folio_date'];
		}
		foreach($periods as $periodKey=>$period) {
			if($item['invDate'] >= $period['start'] && $item['invDate'] <= $period['end']) {
				if($totalSelect == "gross") {
					$repArray[$level1][$level2][$currency][$periodKey]['total'] += $item['rv_item_amt_gross'];
					$currencyTotal += $item['rv_item_amt_gross'];
				} else {
					$repArray[$level1][$level2][$currency][$periodKey]['total'] += $item['rv_item_amt_nett'];
					$currencyTotal += $item['rv_item_amt_nett'];
				}
				if($taxToggle == "exclude") {
					$repArray[$level1][$level2][$currency][$periodKey]['total'] -= $item['rv_item_amt_tax'];
					$currencyTotal -= $item['rv_item_amt_tax'];
				}
			}
		}
		if (isset($repArray[$level1][$level2][$currency]['total'])) {
			$repArray[$level1][$level2][$currency]['total'] += $currencyTotal;
		} else {
			$repArray[$level1][$level2][$currency]['total'] = $currencyTotal;
		}
		
	}

	// Flatten resCount arrays into single values
	foreach ($repArray as $level1 => $level1Item) {
		$repArray[$level1]['resCount'] = array_unique($repArray[$level1]['resCount']);
		$repArray[$level1]['resCount'] = count($repArray[$level1]['resCount']);
		foreach ($level1Item as $level2 => $level2Item) {
			if (isset($repArray[$level1][$level2]['resCount'])) {
				$repArray[$level1][$level2]['resCount'] = array_unique($repArray[$level1][$level2]['resCount']);
				$repArray[$level1][$level2]['resCount'] = count($repArray[$level1][$level2]['resCount']);
			}
			if (is_array($level2Item)) {
				foreach ($level2Item as $currency => $currencyItem) {
					if (isset($repArray[$level1][$level2][$currency]['resCount'])) {
						$repArray[$level1][$level2][$currency]['resCount'] = array_unique($repArray[$level1][$level2][$currency]['resCount']);
						$repArray[$level1][$level2][$currency]['resCount'] = count($repArray[$level1][$level2][$currency]['resCount']);
					}
				}
			}
		}
	}

	// Fix property listing ordering / display
	$newRepArray = array();
	if($level1Name == "property") {
		foreach($GLOBALS['calAcRecurseResult'] as $propertyId) {
			$currentName = "";
			$currentItem = "";
			foreach($repArray as $level1Key=>$level1Item) {
				if($level1Item['id'] == $propertyId) {
					$currentName = $level1Key;
					$currentItem = $level1Item;
				}
			}
			if($currentName == "" || $currentItem == "") {
				$currentName = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$propertyId'",4);
				$newRepArray[$currentName] = array('id'=>$propertyId);
			} else {
				$newRepArray[$currentName] = $currentItem;
			}
		}
		$repArray = $newRepArray;
	}

	$newRepArray = array();
	if($level2Name == "property") {
		foreach($repArray as $level1Key=>$level1Item) {
			$newItem = array();
			$newItem['id'] = $level1Item['id'];
			$newItem['bedNights'] = $level1Item['bedNights'];
			$newItem['resCount'] = $level1Item['resCount'];
			foreach($GLOBALS['calAcRecurseResult'] as $propertyId) {
				$currentName = "";
				$currentItem = "";
				foreach($level1Item as $level2Key=>$level2Item) {
					if(is_array($level2Item)) {
						if($level2Item['id'] == $propertyId) {
							$currentName = $level2Key;
							$currentItem = $level2Item;
						}
					}
				}
				if($currentName != "" && $currentItem != "") {
					$newItem[$currentName] = $currentItem;
				}
			}
			$newRepArray[$level1Key] = $newItem;
		}
		$repArray = $newRepArray;
	}

	$args = array_slice($_SERVER['argv'],1,17);
	$arg_list = join("+",$args);
	$periodCount = sizeof($periods);

	if($renderOption == 0) {
		$rows = "";
		$rowTotal = 1;

		if($periodCount > 6) {
			$detailWidth = $periodCount*76;
		} else {
			$detailWidth = "100%";
		}

		$rowHTML = Join("",file(__DIR__ . "/../../../public/html/rep_revenue_row.htm"));
		$detailHTML = Join("",file(__DIR__ . "/../../../public/html/rep_revenue_detail.htm"));
		$detailHeaderHTML = Join("",file(__DIR__ . "/../../../public/html/rep_revenue_detail_header.htm"));
		$detailRowHTML = Join("",file(__DIR__ . "/../../../public/html/rep_revenue_detail_row.htm"));
		$detailItemHTML = Join("",file(__DIR__ . "/../../../public/html/rep_revenue_detail_item.htm"));

		//START
		$rows = "";
		$details = "";
		if(sizeof($repArray) > 0) {
			foreach($repArray as $level1Key=>$level1Item) {
				if(!is_array($level1Item)) {
					continue;
				}
				$rows .= str_replace("!level1Name!",substr($level1Key,0,12),
					str_replace("!level2Name!","",
					str_replace("!bedNights!",floor( (isset($level1Item['bedNights']) ? $level1Item['bedNights'] : 0) ),
					str_replace("!resCount!", (isset($level1Item['resCount']) ? $level1Item['resCount'] : 0),
					str_replace("!currency!","",
					str_replace("!total!","",
					str_replace("!popupArgs!","$arg_list+$level1Item[id]++",
					str_replace("!rowNum!",$rowTotal,$rowHTML))))))));
				$details .= str_replace("!rowNum!",$rowTotal,
					str_replace("!popupArgs!","$arg_list+$level1Item[id]++",
					str_replace("!items!","<td colspan=\"".($periodCount+1)."\" height=\"17\">&nbsp;</td>",$detailRowHTML)));
				$rowTotal++;
				foreach($level1Item as $level2Key=>$level2Item) {
					if(!is_array($level2Item)) {
						continue;
					}
					if($level2Name != "none") {
						$rows .= str_replace("!level1Name!","",
							str_replace("!level2Name!",substr($level2Key,0,12),
							str_replace("!bedNights!",floor($level2Item['bedNights']),
							str_replace("!resCount!",$level2Item['resCount'],
							str_replace("!currency!","",
							str_replace("!total!","",
							str_replace("!popupArgs!","$arg_list+$level1Item[id]+$level2Item[id]+",
							str_replace("!rowNum!",$rowTotal,$rowHTML))))))));
						$details .= str_replace("!rowNum!",$rowTotal,
							str_replace("!popupArgs!","$arg_list+$level1Item[id]+$level2Item[id]+",
							str_replace("!items!","<td colspan=\"".($periodCount+1)."\" height=\"17\">&nbsp;</td>",$detailRowHTML)));
						$rowTotal++;
					}
					foreach($level2Item as $currencyKey=>$currencyItem) {
						if(!is_array($currencyItem)) {
							continue;
						}
						$detailItems = "";
						foreach($currencyItem as $periodKey=>$pItem) {
							if(is_array($pItem)) {
								fixAmtDisplay($pItem['total']);
								$detailItems .= str_replace("!total!",$pItem['total'],$detailItemHTML);
							}
						}
						$detailItems .= "<td>&nbsp;</td>";

						fixAmtDisplay($currencyItem['total']);
						$rows .= str_replace("!level1Name!","",
							str_replace("!level2Name!","",
							str_replace("!bedNights!",floor($currencyItem['bedNights']),
							str_replace("!resCount!",$currencyItem['resCount'],
							str_replace("!currency!",$currencyKey,
							str_replace("!total!",$currencyItem['total'],
							str_replace("!popupArgs!","$arg_list+$level1Item[id]+$level2Item[id]+$currencyItem[id]",
							str_replace("!rowNum!",$rowTotal,$rowHTML))))))));
						$details .= str_replace("!rowNum!",$rowTotal,
							str_replace("!popupArgs!","$arg_list+$level1Item[id]+$level2Item[id]+$currencyItem[id]",
							str_replace("!items!",$detailItems,$detailRowHTML)));
						$rowTotal++;
					}
				}
			}
			$detailHeader = "";
			foreach($periods as $period) {
				$detailHeader .= str_replace("!periodName!",$period['name'],$detailHeaderHTML);
			}
			$detailHeader .= "<td height=\"17\">&nbsp;</td>";
			$GLOBALS['temp']['rows'] =  str_replace("!header!",$detailHeader,
				str_replace("!detailRows!",$details,
				str_replace("!rowTotal!",$rowTotal+1,
				str_replace("!detailWidth!",$detailWidth,
				str_replace("!rows!",$rows,$detailHTML)))));
		} else {
			$GLOBALS['temp']['rows'] = "<tr><td>No records found</td></tr>";
		}
	}

	if($renderOption == 4) {  //csv
		$csvFile = array();
		$headerLine = array();
		array_push($csvFile,array($title));
		array_push($csvFile,array());
		array_push($csvFile,array("Financial period",(isset($GLOBALS['temp']['periodName']) ? $GLOBALS['temp']['periodName'] : "") . " (" . $GLOBALS['temp']['fromPeriodName'] . " to " . $GLOBALS['temp']['toPeriodName'] . ")"));
		array_push($csvFile,array("Date range",$GLOBALS['temp']['fromDateFormat'] . " to " . $GLOBALS['temp']['toDateFormat']));
		array_push($csvFile,array("Property / Accommodation",$accommFilter['names']));
		array_push($csvFile,array("Currency",$currenciesFilter['names']));
		array_push($csvFile,array("Agent",$agentFilter['names']));
		array_push($csvFile,array("Agent country",$agentCountryFilter['names']));
		array_push($csvFile,array("Status",$statusFilter['names']));
		array_push($csvFile,array("Consultant",$consultantFilter['names']));
		array_push($csvFile,array("Originator",$originatorFilter['names']));
		array_push($csvFile,array("Source",$sourceFilter['names']));
		array_push($csvFile,array("Nationality",$nationalityFilter['names']));
		array_push($csvFile,array("Level 1",(isset($GLOBALS['temp']['level1Name']) ? $GLOBALS['temp']['level1Name'] : "") ));
		array_push($csvFile,array("Level 2",(isset($GLOBALS['temp']['level2Name']) ? $GLOBALS['temp']['level2Name'] : "") ));
		array_push($csvFile,array());
		$headerLine = array($GLOBALS['temp']['level1Name'],$GLOBALS['temp']['level2Name'],"Reservation Count","Bed nights","Currency");
		foreach($periods as $period) {
			array_push($headerLine,$period['name']);
		}
		array_push($headerLine,"Total");
		array_push($csvFile,$headerLine);
		foreach($repArray as $level1Key=>$level1Item) {
			if(!is_array($level1Item)) {
				continue;
			}
			foreach($level1Item as $level2Key=>$level2Item) {
				if(!is_array($level2Item)) {
					continue;
				}
				foreach($level2Item as $currencyKey=>$currencyItem) {
					if(!is_array($currencyItem)) {
						continue;
					}
					$currencyLine = array($level1Key,$level2Key,$currencyItem['resCount'],$currencyItem['bedNights'],$currencyKey);
					foreach($currencyItem as $periodKey=>$pItem) {
						if(is_array($pItem)) {
							fixAmtDisplay($pItem['total']);
							array_push($currencyLine,$pItem['total']);
						}
					}
					array_push($currencyLine,$currencyItem['total']);
					array_push($csvFile,$currencyLine);
				}
			}
		}
		$csvText = "";
		foreach($csvFile as $csvLine) {
			$first = true;
			foreach($csvLine as $csvItem) {
				if(!$first) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}
		if(headers_sent()) {
			//    echo('Some data has already been output to browser, can\'t send PDF file');
		}
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		header("Content-Disposition: inline; filename=".str_replace(" ","_",strtolower($title) . "_".chng_date(date("Y-m-d"),"-").".csv"));
		echo $csvText;
		flush();
		die();
	}
//END
} else {
	$GLOBALS['temp']['reportGenerated'] = "class=\"collapse\"";
	$GLOBALS['temp']['rows'] = "";
}
