<?php

/**
 * init.form257.func.php - Payments due report
 * Job: 706
 * Function: 74
*/

require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.mail.php');   
require_once(__DIR__ . "/functions.financial.php");
require_once(__DIR__ . '/functions.report.php');

require_once(__DIR__ . '/functions.profile.php');

define("REP_EMAIL_AGENT_PDF",12); //To identify email to agent event.
define("REP_EMAIL_AGENT_PDF_SEND",13); //To send email to agent.
define("REP_UPDATE_PAY_PLAN",14); //To update selected pay plan.
define("REP_TRAVEL_DATE_RANGE",16);
define("REP_ADVANCED_OPTIONS",32);

$profileFields = array(
		/* 01 */ "", // To date
		/* 02 */ "fromTravelDate",
		/* 03 */ "toTravelDate",
		/* 04 */ "agentFilter",
		/* 05 */ "statusFilter",
		/* 06 */ "accommFilter",
		/* 07 */ "consultantFilter",
		/* 08 */ "paymentPlanFilter",
		/* 09 */ "showReservationSummary",
		/* 10 */ "includeCredits",
		/* 11 */ "includeExtras",
		/* 12 */ "showTravelSummary",
		/* 13 */ "", //filterStatus,
		/* 14 */ "options", //renderOption -- needed for check boxes included
		/* 15 */ "", //1, // id("currentPage").value, // page
		/* 16 */ "", //1, // per page
		/* 17 */ "", //showHideButtonText,
		/* 18 */ "showSectionTotals",
		/* 19 */ "sectionTotalsToggle",
		/* 20 */ "showConsultants",
		/* 21 */ "useFromDate",
		/* 22 */ "fromDate"
		/* 23 */ //_randomId + "_" + _urlCount.toString()	
);

function getBusinessDetails($resId){ 
	global $lDB;

	$businessArray = array();
	// Get a list of all properties in accommodation list
	$businessArray = $lDB->get("
		SELECT DISTINCT
			pr_business_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '$resId'
			AND pr_business_id != ''
			AND pr_business_id != '0'
			AND pr_business_id IS NOT NULL
	",3);

	// Add the list of all properties in extras list (this may no longer be nessessary)
	// and reduce to each unique business ID
	$businessArray = array_unique(array_merge($businessArray, $lDB->get("
		SELECT DISTINCT
			pr_business_id
		FROM
			rv_extra
		WHERE
			rv_extra.rv_reservation_id = '$resId'
			AND pr_business_id != ''
			AND pr_business_id != '0'
			AND pr_business_id IS NOT NULL
			AND rv_extra.rv_extra_void_ind = '0'
	",3)));
	// Find all billing entities among the business IDs specified and their parents
	$newBusinessArray = array();
	$propertyArray = array();
	foreach($businessArray as $item) {
		$currId = $item;
		while($currId != "0" && trim($currId) != "") {
			array_push($propertyArray,$currId);
			if($lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4) == "1"
				&& !in_array($currId, $newBusinessArray)) {
				array_push($newBusinessArray,$currId);
			}
			$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
			$currId = $parentId;
		}
	}
	$businessArray = $newBusinessArray;

	 // Get the required information on each selected business
	$businessArray = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_business.pr_bus_statutory_1,
			pr_business.pr_bus_statutory_2,
			pr_business.pr_bus_statutory_3
		FROM
			pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_business.pr_business_id IN ('".join("','",$businessArray)."')
	",2);

		return array('billingInfo'=>$businessArray);
}

function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if(trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	", 4);
	if(trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$personaId."'
	",1);
	$name = "";
	if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}
