<?php

/**
 * init.form257.php - Payments due report
 * Job: 706
 * Function: 74
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
	$linkurl = explode("#",$_POST['url']);
}

if(isset($linkurl[0]) && $linkurl[0] != "") {
	$_SERVER['argv'] = explode("+",substr($linkurl[0],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("payments_due_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Payments Due Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_deposit.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],25,"");

//Added to update payment plans.

$method = $_SERVER['argv'][2];

if($method == "customPayPlan") {
	$payItemId = $_SERVER['argv'][3];
	$payAmnt = $_SERVER['argv'][4];
	$payDate = $_SERVER['argv'][5];
	if($payItemId != "0" && $payItemId != "1") {
		// Check for any payment plan items on the same date
		$checkPayPlanItem = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_pay_plan_item
			WHERE
				rv_reservation_id = '$record'
				AND rv_pay_plan_date = '$payDate'
				AND rv_pay_plan_item_ix != '$payItemId'
		",4);
		
		if($checkPayPlanItem > 0) {
			$lDB->put("DELETE FROM rv_pay_plan_item WHERE rv_pay_plan_item_ix = '$payItemId'");
			$payPlanItem = $lDB->get("
				SELECT
					rv_pay_plan_item_ix,
					rv_pay_plan_amount
				FROM
					rv_pay_plan_item
				WHERE
					rv_reservation_id = '$record'
					AND rv_pay_plan_date = '$payDate'
			",1);
			$payItemId = $payPlanItem['rv_pay_plan_item_ix'];
			$finalAmount = $payAmnt + $payPlanItem['rv_pay_plan_amount'];
			$lDB->put("UPDATE rv_pay_plan_item SET rv_pay_plan_amount = '$finalAmount' WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
		} else { 
			$lDB->put("UPDATE rv_pay_plan_item SET rv_pay_plan_amount = '$payAmnt', rv_pay_plan_date = '$payDate' WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
		}
	} else {
		// Check for any payment plan items on the same date
		$checkPayPlanItem = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_pay_plan_item
			WHERE
				rv_reservation_id = '$record'
				AND rv_pay_plan_date = '$payDate'
		",4);
		if($checkPayPlanItem > 0) {
			$payPlanItem = $lDB->get("
				SELECT
					rv_pay_plan_item_ix,
					rv_pay_plan_amount
				FROM
					rv_pay_plan_item
				WHERE
					rv_reservation_id = '$record'
					AND rv_pay_plan_date = '$payDate'
			",1);
			$payItemId = $payPlanItem['rv_pay_plan_item_ix'];
			$finalAmount = $payAmnt + $payPlanItem['rv_pay_plan_amount'];
			$lDB->put("UPDATE rv_pay_plan_item SET rv_pay_plan_amount = '$finalAmount' WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
		} else {
			$lDB->put("
				INSERT INTO rv_pay_plan_item (
					rv_pay_plan_item_db,
					rv_pay_plan_amount,
					rv_pay_plan_date,
					rv_reservation_id
				) values (
					'$GLOBALS[dbcode]',
					'$payAmnt',
					'$payDate',
					'$record'
				)
			");
			$key = $lDB->insert_id;
		}
	}
	ammendReservation($record,"Edit payment plan item");
} elseif($method == "delPayPlan") {
	$payItemId = $_SERVER['argv'][3];
	$lDB->put("DELETE FROM rv_pay_plan_item WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '$payItemId'");
	ammendReservation($record,"Edit payment plan item");
}
$GLOBALS['editPayPlan'] = true;

//End of added to 

// Enable scroll set ----------------------------------------------------------
$resScrollSet = array();

$toDate = useDate("to", $_SERVER['argv'][1]);
$fromTravelDate = useDate("fromTravel", $_SERVER['argv'][2]);
$toTravelDate = useDate("toTravel", $_SERVER['argv'][3]);

$statusACL = $lDB->get("
	SELECT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id <> 25
		AND rf_reservation_status_id <> 15
		AND rf_reservation_status_id <> 97
",3);

$agentACL = false;

if ( $userStatusId < 2 ) {
	$agentACL = array($calAgentId);
}

$agentFilter = useFilter("agent",$_SERVER['argv'][4],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");

if ( $_SERVER['argc'] < 2 && $pf_option_id == "") {
	$_SERVER['argv'][5] = "30";
}

$statusFilter = useFilter("status",$_SERVER['argv'][5],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);
$statusStr = $statusFilter['names'];

if($_SERVER['argv'][6] == "") {
	$_SERVER['argv'][6] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
	",3));
}


$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);

global $accommFilter;

$accommFilter = useFilter("accomm",$_SERVER['argv'][6],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);
$propertyStr = $accommFilter['names'];


$consultantFilter = useFilter("consultant",$_SERVER['argv'][7],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");

$paymentPlanFilter = useFilter("paymentPlan",$_SERVER['argv'][8],"SELECT IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc) as nameLast FROM ac_pay_plan WHERE ac_pay_plan.ac_pay_plan_ix =","rv_reservation.ac_pay_plan_id",false,false,false);

$reservationSummary = $_SERVER['argv'][9];
$includeCredits = $_SERVER['argv'][10];
$includeExtras = $_SERVER['argv'][11];
$travelSummary = $_SERVER['argv'][12];
$filterStatus = $_SERVER['argv'][13];
$options = $_SERVER['argv'][14];
$page = $_SERVER['argv'][15];
$perPage = $_SERVER['argv'][16];
$showHideButtonText = $_SERVER['argv'][17];
$sectionTotals = $_SERVER['argv'][18];
$reportType = $_SERVER['argv'][19];
$showConsultants = $_SERVER['argv'][20];

$fromDateCheck = $_SERVER['argv'][21];
$fromDate = useDate("from", $_SERVER['argv'][22]);
$GLOBALS['temp']['fromDateCheck'] = "";
$fromDateSQL = "";
if($fromDateCheck == "1") {
	$GLOBALS['temp']['fromDateCheck'] = "checked";
	$fromDateSQL = "
		AND rv_pay_plan_item.rv_pay_plan_date >= '$fromDate[jsDate]'		
	";
}

if($showConsultants == 1) {
	$conDisp = "display:block";
} else {
	$conDisp = "display:none";
}

if($reportType == 1) {
	$perReport = 1;
} else {
	$perAgent = 1;
}

$agentList = $_SERVER['argv'][23];

$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// BUG #5484: END -------------------------------------------------------------

$renderMode = "";
$renderType = "";

switch ( $options & 15 ) {
case REP_VIEW_HTML:
	if($_SERVER['argv'][24]=="updatePayPlan"){	
		$renderMode = "paymentplan";
		$renderType = "update";
	} else {
		$renderMode = "html";
		$renderType = "";
	}
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
	break;
case REP_EMAIL_AGENT_PDF:
	$renderMode = "pdf";
	$renderType = "emailToAgent";
	break;
case REP_EMAIL_AGENT_PDF_SEND:
	$renderMode = "pdf";
	$renderType = "emailToAgentSend";
	break;
case REP_UPDATE_PAY_PLAN:
	$renderMode = "payplan";
	$renderType = "update";
	break;
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = "Payments due Report - due to: " . $toDate['htmlDate'];
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
			<tr valign=\"top\">
				<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
				<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
			</tr>
		</table>
	";
	$newOptions = ($options & ~15) + 3;

	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,14))."+$newOptions+".join("+",array_slice($_SERVER['argv'],15,6));

	$GLOBALS[$form]->FormHTML =
		str_replace("!formAction!",(isset($formAction) ? $formAction: ""),
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
	
	// Get principal -------------------------------------------------------------
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
  
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);

	$GLOBALS['temp']['emailTo'] = "";
}

//To send mail to selected agent.

if ( $renderMode == "pdf" && $renderType == "emailToAgent" ) {
	$agentList = explode("-", $agentList);
	$recipients = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
	";
	$i = 0;
	foreach($agentList as $agent) {
		if($agent != '') {
			$i+= 1;
			$agentDetails = $lDB->get("
				SELECT
					pr_persona.pr_persona_ix,
					pr_persona.pr_name_last,
					pr_persona.pr_email
				FROM
					pr_persona
				WHERE
					pr_persona.pr_persona_ix = '$agent'
			",1);
			$recipients .= "
				<tr valign=\"top\">
					<td width=\"46%\">".$agentDetails['pr_name_last']."</td>
					<td width=\"8%\" align=\"center\"><input onclick=\"contact_popup(1, 'mail_to$i')\" type=\"button\" class=\"button bSearch\" id=\"toSearchButton\" value=\"\" /></td>
					<td \"46%%\">
			";
			if($agentDetails['pr_email'] != '') {
				$recipients .= "
					<input type=\"text\" name=\"mail_to\" id=\"mail_to$i\" class=\"txts\" size=\"40\" value=\"$agentDetails[pr_email]\" style=\"width: 180px;\"/>
				";
			} else {
				$recipients .= "
					<input type=\"text\" name=\"mail_to\" id=\"mail_to$i\" class=\"txts\" size=\"40\" value=\"!emailTo!\" style=\"width: 180px;\" />
				";
			}
			$recipients .= "
						<input type=\"hidden\" id=\"agentId$i\" value=\"$agentDetails[pr_persona_ix]\">
					</td>
				</tr>
			";
		}
	}

	$recipients .= "
		</table>
		<input type=\"hidden\" id=\"noOfAgents\" value='".$i."'>
	";

	$pdfName = "Payments due Report - due to: " . $toDate['htmlDate'];
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
			<tr valign=\"top\">
				<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
				<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
			</tr>
		</table>
	";
	$newOptions = ($options & ~15) + 13;

	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,14))."+$newOptions+".join("+",array_slice($_SERVER['argv'],15,6));

	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",(isset($formAction) ? $formAction: ""),
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$pdfName.".pdf",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!recipients!",$recipients,
								str_replace("!emailSubject!",$pdfName,
								Join("", file(__DIR__ . "/../../../public/html/email_agents_popup.htm")))))))));
	
	// Get principal -------------------------------------------------------------
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
  
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);

	$GLOBALS['temp']['emailTo'] = "";
}



if($renderMode == "html") {
	if($showConsultants == 1) {
		$GLOBALS['temp']['showConsultants'] = "checked";
	} else {
		$GLOBALS['temp']['showConsultants'] = "";
	}
	if($reservationSummary == 1) {
		$GLOBALS['temp']['reservationSummary'] = "checked";
	} else {
		$GLOBALS['temp']['reservationSummary'] = "";
	}
	
	if($includeCredits == "1") {
		$GLOBALS['temp']['includeCredits'] = "checked";
	} else {
		$GLOBALS['temp']['includeCredits'] = "";
	}

	if($includeExtras == "1") {
		$GLOBALS['temp']['includeExtras'] = "checked";
	} else {
		$GLOBALS['temp']['includeExtras'] = "";
	}

	if($travelSummary == 1) {
		$GLOBALS['temp']['travelSummary'] = "checked";
	} else {
		$GLOBALS['temp']['travelSummary'] = "";
	}

	if($_SERVER['argv'][1] != "") {
		$GLOBALS['temp']['pageDetail'] = "expand";
	} else {
		$GLOBALS['temp']['pageDetail'] = "collapse";
		$options |= REP_ADVANCED_OPTIONS;
	}
	
	if($options & REP_TRAVEL_DATE_RANGE) {
		$GLOBALS['temp']['travelDateRange'] = "checked";
		$GLOBALS['temp']['travelDateRangeSpan'] = "class=\"expand\"";
	} else {
		$GLOBALS['temp']['travelDateRange'] = "";
		$GLOBALS['temp']['travelDateRangeSpan'] = "class=\"collapse\"";
	}
	
	if($options & REP_ADVANCED_OPTIONS) {
		$GLOBALS['temp']['advancedForm'] = "colLt";
		$GLOBALS['temp']['advancedTag'] = ">>  More";
	} else {
		$GLOBALS['temp']['advancedForm'] = "collapse";
		$GLOBALS['temp']['advancedTag'] = "<<  More";
	}

	//Add sectionDivDisplay   on 19-01-08  
	if(isset($sectionTotals) && $sectionTotals == 1) {
		$GLOBALS['temp']['sectionTotals'] = "checked";
		$GLOBALS['temp']['sectionDivDisplay']="display:block"; 
	} else {
		$GLOBALS['temp']['sectionTotals'] = "";
		$GLOBALS['temp']['sectionDivDisplay'] = "display:none";
	}

	if(isset($perAgent) && $perAgent == 1) {
		$GLOBALS['temp']['perAgent'] = "checked";
	} else {
		$GLOBALS['temp']['perAgent'] = "";
	}

	if(isset($perReport) && $perReport == 1) {
		$GLOBALS['temp']['perReport'] = "checked";
	} else {
		$GLOBALS['temp']['perReport'] = "";
	}

	$GLOBALS['temp']['showEmailButton'] = "";
	if($reservationSummary != 1 || $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] < 10) {
		$GLOBALS['temp']['showEmailButton'] = "style=\"display:none;\" ";
	}

	if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] >= 10) {
		$GLOBALS['temp']['showpaymentOptionLabel'] = "(This option must be selected to update unallocated payments)";
	} else {
		$GLOBALS['temp']['showpaymentOptionLabel'] = "";
	}
}

$sqlFrom = "
	FROM
		rv_pay_plan_item
		LEFT JOIN rv_reservation ON rv_pay_plan_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		LEFT JOIN pr_persona ON rv_reservation.rv_agent_id = pr_persona.pr_persona_ix
		LEFT JOIN rf_currency ON rv_reservation.rv_invoice_currency_id = rf_currency.rf_currency_ix
";

if ( $options & REP_TRAVEL_DATE_RANGE ) {
	$sqlTravelWhere = "
		AND (
			(
				rv_reservation.rv_date_arrive >= '$fromTravelDate[jsDate]' 
				AND rv_reservation.rv_date_arrive <= '$toTravelDate[jsDate]'
			) OR (
				rv_reservation.rv_date_depart >= '$fromTravelDate[jsDate]' 
				AND rv_reservation.rv_date_depart <= '$toTravelDate[jsDate]'
			) OR (
				rv_reservation.rv_date_arrive < '$fromTravelDate[jsDate]' 
				AND rv_reservation.rv_date_depart > '$toTravelDate[jsDate]'
			)
		)
	";
} else {
	$sqlTravelWhere = "";
}

if ( $includeCredits == "1" ) {
	$creditCompare = "AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable) - rv_amt_paid <> 0";
} else {
	$creditCompare = "
		AND (
			(
				(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable) - rv_amt_paid > 0
			) OR (
				(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable) - rv_amt_paid < 0
			)
		)
	";
}

$sqlWhere = "
	WHERE
		rv_pay_plan_item.rv_pay_plan_date <= '$toDate[jsDate]'
		$fromDateSQL
		$creditCompare
		$sqlTravelWhere
		$agentFilter[where]
		$statusFilter[where]
		$consultantFilter[where]
		$paymentPlanFilter[where]
";

$agentArray = $lDB->get("
	SELECT DISTINCT
		rv_reservation.rv_agent_id
	$sqlFrom
	$sqlWhere
	ORDER BY
		pr_persona.pr_name_last
",3);

$agentList = join("','",$agentArray);

$sqlDateTotal = "
	SELECT
		rv_agent_id,
		pr_persona.pr_name_last,
		rf_currency_symbol,
		rv_invoice_currency_id,
		(rv_pay_plan_item.rv_pay_plan_amount) AS payDue,
		(rv_amt_accomm_gross+rv_amt_extra_gross+rv_amt_travel_gross) AS grossTotal,
		(rv_amt_accomm_nett+rv_amt_extra_nett+rv_amt_travel_nett) AS nettTotal,
		(rv_amt_paid) as rv_amt_paid,
		rv_commission_deduct_yn,
		pr_persona.pr_persona_ix,
		rv_reservation.rv_reservation_ix
	$sqlFrom
	$sqlWhere
		AND rv_reservation.rv_agent_id IN ('$agentList')
	ORDER BY
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix,
		rf_currency_symbol,
		rv_reservation_ix
";

$summaryArray = $lDB->get($sqlDateTotal,2);

// Create a list of reservations filtered using the accommodation filter. Used to filter later results by reservation.
global $reservations, $reservationKeys;
$reservations = array();
foreach($summaryArray as $item) {
	$reservations[] = $item['rv_reservation_ix'];
}
$reservations = $lDB->get("
	SELECT DISTINCT
		rv_reservation_item.rv_reservation_id
	FROM
		rv_reservation_item
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
	WHERE
		rv_reservation_item.rv_reservation_id IN ('".join("','",array_unique($reservations))."')
		".str_replace("rv_reservation_item.ac_accomm_type_id","ac_accomm_type.ac_accomm_type_ix",$accommFilter['where'])."

",3);

$reservationKeys = array_flip($reservations);
function applyPropertyFilter($item) {
	global $reservationKeys;
	if(isset($reservationKeys[$item['rv_reservation_ix']])) {
		return true;
	} else {
		return false;
	}
}

// Do any data updating / formatting
if(sizeof($summaryArray) > 0 && $_SERVER['argv'][1] != "") {
	$summaryArray = array_filter($summaryArray, "applyPropertyFilter");
	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
	}

	$agentId = null;
	$currencyId = null;
	$resId = null;
	$newSummary	= array();
	$payDue = 0;
	$amountPaid = 0;
	$invoiceTotal = 0;

	$agents = array();
	$agentDirect = false;

	foreach($summaryArray as $key => $item) {
		if($item['rv_agent_id'] == "" || $item['pr_persona_ix'] == "") {
			$item['rv_agent_id'] = "0";
			$agentDirect = true;
		}

		if($item['rv_agent_id'] != "0") {
			$agents[] = $item['rv_agent_id'];
		}
		
		if($item['rv_agent_id'] != $agentId) {
			if($agentId != null) {
				if(($invoiceTotal - $amountPaid) != 0 && ($includeCredits == "1" || ($invoiceTotal - $amountPaid) > 0)) {
					array_push($newSummary,array(
						'rv_agent_id' => $agentId,
						'pr_name_last' => $lastItem['pr_name_last'],
						'rf_currency_symbol' => $lastItem['rf_currency_symbol'],
						'rv_invoice_currency_id' => $currencyId,
						'payDue' => $payDue,
						'invoiceTotal' => $invoiceTotal,
						'rv_amt_paid' => $amountPaid,
						'rv_commission_deduct_yn' => $lastItem['rv_commission_deduct_yn'],
						'pr_persona_ix' => $lastItem['pr_persona_ix']
					));
				}
				$payDue = 0;
				$invoiceTotal = 0;
				$amountPaid = 0;
			}
			$agentId = $item['rv_agent_id'];
			$currencyId = "";
		}
		
		if($item['rv_invoice_currency_id'] != $currencyId) {
			if($currencyId != null) {
				if(($invoiceTotal - $amountPaid) != 0 && ($includeCredits == "1" || ($invoiceTotal - $amountPaid) > 0)) {
					array_push($newSummary,array(
						'rv_agent_id' => $agentId,
						'pr_name_last' => $lastItem['pr_name_last'],
						'rf_currency_symbol' => $lastItem['rf_currency_symbol'],
						'rv_invoice_currency_id' => $currencyId,
						'payDue' => $payDue,
						'invoiceTotal' => $invoiceTotal,
						'rv_amt_paid' => $amountPaid,
						'rv_commission_deduct_yn' => $lastItem['rv_commission_deduct_yn'],
						'pr_persona_ix' => $lastItem['pr_persona_ix']
					));
				}
				$payDue = 0;
				$invoiceTotal = 0;
				$amountPaid = 0;
			}
			$currencyId = $item['rv_invoice_currency_id'];
		}
		
		if ( $item['rv_commission_deduct_yn'] == "1" ) {
			$item['invoiceTotal'] = $item['nettTotal'];
		} else {
			$item['invoiceTotal'] = $item['grossTotal'];
		}
		
		if ( ($item['invoiceTotal'] - $item['rv_amt_paid'] != 0) && ($includeCredits == "1" || ($item['invoiceTotal'] - $item['rv_amt_paid']) > 0) ) {
			$payDue += $item['payDue'];
			if ( $resId != $item['rv_reservation_ix'] ) {
				$invoiceTotal += $item['invoiceTotal'];
				$amountPaid += $item['rv_amt_paid'];
				$resId = $item['rv_reservation_ix'];
			}
		}
		$lastItem = $item;
	}
	$agents = array_unique($agents);
	$agentWhere = " AND (
		rv_agent_id IN ('".join("','",$agents)."')
	";
	if($agentDirect) {
		$agentWhere .= "
			OR rv_agent_id = '0' OR rv_agent_id = ''
		";
	}
	$agentWhere .= ")";

	if(($invoiceTotal - $amountPaid) != 0 && ($includeCredits == "1" || ($invoiceTotal - $amountPaid) > 0)) {
		array_push($newSummary,array(
			'rv_agent_id' => $agentId,
			'pr_name_last' => $lastItem['pr_name_last'],
			'rf_currency_symbol' => $lastItem['rf_currency_symbol'],
			'rv_invoice_currency_id' => $currencyId,
			'payDue' => $payDue,
			'invoiceTotal' => $invoiceTotal,
			'rv_amt_paid' => $amountPaid,
			'rv_commission_deduct_yn' => $lastItem['rv_commission_deduct_yn'],
			'pr_persona_ix' => $lastItem['pr_persona_ix']
		));
	}
	$summaryArray = $newSummary;
	
	$payList = $lDB->get("
		SELECT
			(rv_payment_item.rv_payment_item_amt) AS payReceive,
			rv_commission_deduct_yn,
			(rv_amt_accomm_gross+rv_amt_extra_gross+rv_amt_travel_gross) AS grossTotal,
			(rv_amt_accomm_nett+rv_amt_extra_nett+rv_amt_travel_nett) AS nettTotal,
			(rv_amt_paid) as rv_amt_paid,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_invoice_currency_id
		FROM
			rv_payment_item
			INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_payment_item.rv_reservation_id
		WHERE
			rv_payment.rv_pmnt_date <= '$toDate[jsDate]'
			$sqlTravelWhere
			$agentFilter[where]
			$statusFilter[where]
			$consultantFilter[where]
			$paymentPlanFilter[where]
			$agentWhere
	",6);
	$payList = array_filter($payList, "applyPropertyFilter");
	$newPayList = array();
	foreach($payList as $item) {
		if(trim($item['rv_agent_id']) == "" || trim($item['rv_agent_id'] == "0")) {
			$item['rv_agent_id'] = "0";
		}
		$key = $item['rv_agent_id'] . "_" . $item['rv_invoice_currency_id'];
		if(!array_key_exists($key,$newPayList)) {
			$newPayList[$key] = array();
		}
		$newPayList[$key][] = $item;
	}
	$payList = $newPayList;
	unset($newPayList);
	foreach ( $summaryArray as $key => $item ) {
		if ( $item['pr_name_last'] == "" ) {
			$summaryArray[$key]['pr_name_last'] = "Direct";
		}
		$payReceive = 0;
		$payKey = $item['rv_agent_id'] . "_" . $item['rv_invoice_currency_id'];
		if(array_key_exists($payKey,$payList)) {
			foreach($payList[$payKey] as $payItem) {
				$payDue = $lDB->get("
					SELECT 
						SUM(rv_pay_plan_amount) 
					FROM 
						rv_pay_plan_item 
					WHERE 
						rv_reservation_id = '$payItem[rv_reservation_ix]'
						AND rv_pay_plan_item.rv_pay_plan_date <= '$toDate[jsDate]'
				",4);
				
				if($item['rv_commission_deduct_yn'] == "1") {
					$invoiceTotal = $payItem['nettTotal'];
				} else {
					$invoiceTotal = $payItem['grossTotal'];
				}
				
				if(($invoiceTotal - $payItem['rv_amt_paid']) != 0 && ($payDue - $payItem['rv_amt_paid']) > 0 && ($includeCredits == "1" || ($invoiceTotal - $payItem['rv_amt_paid']) > 0)) {
					$payReceive += $payItem['payReceive'];
				}
			}
		}
		
		if ( $payReceive == "" ) {
			$summaryArray[$key]['payReceive'] = "0.00";
		} else {
			$summaryArray[$key]['payReceive'] = $payReceive;
		}
		
		$summaryArray[$key]['totalDue'] = $item['payDue'] - $payReceive;
		$summaryArray[$key]['totalBalance'] = $summaryArray[$key]['invoiceTotal'] - $item['rv_amt_paid'];
		fixAmtDisplay($summaryArray[$key]['payDue']);
		fixAmtDisplay($summaryArray[$key]['payReceive']);
		fixAmtDisplay($summaryArray[$key]['totalBalance']);
		fixAmtDisplay($summaryArray[$key]['totalDue']);
		fixAmtDisplay($summaryArray[$key]['invoiceTotal']);
	}

	//To declare array to hold values for per report total values.

	$perReportTotal = array();
	$totalPerAgent = array();
	//End

	$resList = $lDB->get("
		SELECT DISTINCT
			rv_reservation_ix,
			rv_res_name,
			(rv_amt_accomm_gross + rv_amt_extra_gross + rv_amt_travel_gross) as grossTotal,
			(rv_amt_accomm_nett + rv_amt_extra_nett + rv_amt_travel_nett) as nettTotal,
			rv_commission_deduct_yn,
			rv_amt_paid,
			rv_date_arrive,
			rv_date_depart,
			rv_reservation.ac_pay_plan_id,
			concat_WS(' ',pr_persona.pr_name_first, pr_persona.pr_name_second, pr_persona.pr_name_last) as contactName,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_invoice_currency_id
		FROM
			rv_reservation
			INNER JOIN rv_pay_plan_item ON rv_pay_plan_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id
		$sqlWhere
			$agentWhere
		GROUP BY
			rv_reservation.rv_agent_id,
			rv_reservation.rv_invoice_currency_id,
			rv_reservation_ix
		ORDER BY
			rv_pay_plan_date
	",6);
	$resList = array_filter($resList, "applyPropertyFilter");
	$newResList = array();
	foreach($resList as $item) {
		if(trim($item['rv_agent_id']) == "" || trim($item['rv_agent_id'] == "0")) {
			$item['rv_agent_id'] = "0";
		}
		$key = $item['rv_agent_id'] . "_" . $item['rv_invoice_currency_id'];
		if(!array_key_exists($key,$newResList)) {
			$newResList[$key] = array();
		}
		$newResList[$key][] = $item;
	}
	$resList = $newResList;
	unset($newResList);

	$rcdList = $lDB->get("
		SELECT DISTINCT
			rv_payment_item.rv_payment_item_ix,
			rv_reservation_ix,
			rv_pmnt_date,
			rv_pmnt_ref,
			sum(rv_payment_item.rv_payment_item_amt) AS payReceive,
			pr_persona.pr_name_last,
			rv_reservation.ac_pay_plan_id,
			rf_database.rf_db_env_type_ind,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_invoice_currency_id
		FROM
			rv_payment_item
			INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_payment_item.rv_reservation_id
			LEFT JOIN pr_persona ON rv_payment.pr_persona_id = pr_persona.pr_persona_ix
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
			INNER JOIN rf_database ON rf_database.rf_db_code = fn_folio.fn_folio_db
		WHERE
			1
			$sqlTravelWhere
			$agentFilter[where]
			$statusFilter[where]
			$consultantFilter[where]
			$paymentPlanFilter[where]
			$agentWhere
			AND rv_reservation.rv_reservation_ix IN ('".join("','",$reservations)."')
		GROUP BY
			rv_reservation.rv_agent_id,
			rv_reservation.rv_invoice_currency_id,
			rv_reservation.rv_reservation_ix,
			rv_payment_item.rv_payment_item_ix
		ORDER BY
			rv_payment.rv_pmnt_date
	",6);
	$newRcdList = array();
	foreach($rcdList as $item) {
		if(trim($item['rv_agent_id']) == "" || trim($item['rv_agent_id'] == "0")) {
			$item['rv_agent_id'] = "0";
		}
		$key = $item['rv_agent_id'] . "_" . $item['rv_invoice_currency_id'] . "_" . $item['rv_reservation_ix'];
		if(!array_key_exists($key,$newRcdList)) {
			$newRcdList[$key] = array();
		}
		$newRcdList[$key][] = $item;
	}
	$rcdList = $newRcdList;
	unset($newRcdList);

	foreach($summaryArray as $key => $item) {
		$summaryArray[$key]['resItems'] = array();
		$summaryArray[$key]['agentTotal'] = array();

		$totalPayDue = 0;
		$totalPayReceived = 0;
		$totalBalanceDue = 0;
		$totalBalanceTotal = 0;
		$totalInvoice = 0;

		$resKey = $item['rv_agent_id'] . "_" . $item['rv_invoice_currency_id'];
		if(array_key_exists($resKey,$resList)) {
			foreach($resList[$resKey] as $resItem) {
				if($resItem['rv_commission_deduct_yn'] == "1") {
					$invoiceTotal = $resItem['nettTotal'];
				} else {
					$invoiceTotal = $resItem['grossTotal'];
				}
				if(($invoiceTotal - $resItem['rv_amt_paid']) == 0 || ($includeCredits != "1" && ($invoiceTotal - $resItem['rv_amt_paid']) <= 0)) {
					continue;
				}
				$paymentPlanName = $lDB->get("
					SELECT
						IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc)
					FROM
						ac_pay_plan
					WHERE
						ac_pay_plan.ac_pay_plan_ix = '$resItem[ac_pay_plan_id]'
				",4);
				if(trim($paymentPlanName) == "" || $paymentPlanName == "0") {
					$paymentPlanName = "None";
				}
				$dueTotal = 0;
				$sqlDueDetail =  "
					SELECT 
						rv_reservation_ix,
						rv_pay_plan_item_ix,
						rv_pay_plan_date,
						rv_pay_plan_amount AS payDue,
						rv_amt_paid,
						rv_consultant_id,
						rf_reservation_status_id,
						rv_date_arrive,
						rv_date_depart
					$sqlFrom
					WHERE
						rv_reservation.rv_reservation_ix = '$resItem[rv_reservation_ix]'
						AND rv_agent_id = '$item[rv_agent_id]'
						AND rv_invoice_currency_id = '$item[rv_invoice_currency_id]'
						$agentFilter[where]
						$statusFilter[where]
						$consultantFilter[where]
						$paymentPlanFilter[where]
					ORDER BY
						rv_reservation_ix, rv_pay_plan_date
				";

				$dueList = $lDB->get($sqlDueDetail,2);
				$dueItemArray = array();
				$dueRawTotal = 0;
				if($resItem['rv_commission_deduct_yn'] == "1") {
					$invoiceTotal = $resItem['nettTotal'];
					$onsiteExtraAmt = $lDB->get("
						SELECT
							SUM(rv_extra.rv_extra_amt_nett)
						FROM
							rv_extra
							INNER JOIN rf_database ON rf_database.rf_db_code = rv_extra.rv_extra_db
						WHERE
							rv_extra.rv_reservation_id = '$resItem[rv_reservation_ix]'
							AND rv_extra.rv_extra_void_ind = 0
							AND rf_database.rf_db_env_type_ind = '4'
					",4);
				} else {
				$invoiceTotal = $resItem['grossTotal'];
				$onsiteExtraAmt = $lDB->get("
					SELECT
						SUM(rv_extra.rv_extra_amt_gross)
					FROM
						rv_extra
						INNER JOIN rf_database ON rf_database.rf_db_code = rv_extra.rv_extra_db
					WHERE
					rv_extra.rv_reservation_id = '$resItem[rv_reservation_ix]'
						AND rv_extra.rv_extra_void_ind = 0
						AND rf_database.rf_db_env_type_ind = '4'
				",4);
			}

			foreach($dueList as $dueItem) {
				if($reservationSummary == 1) {
					$dueItem['rv_pay_plan_date_fmt'] = chng_date($dueItem['rv_pay_plan_date'],"-");
					$info = "";
					if(strlen($info) > 18) {
						$info = substr($info,0,16) . "...";
					}
					$info = "Planned payment";
					array_push($dueItemArray,array(
						'info' => $info,
						'due' => $dueItem['payDue'],
						'date' => $dueItem['rv_pay_plan_date_fmt'],
						'pay_item_id' =>$dueItem['rv_pay_plan_item_ix']
					));
				}
				$dueRawTotal += $dueItem['payDue'];
						
				if ( $dueItem['rv_pay_plan_date'] <= $toDate['jsDate'] ) {
					$dueTotal += $dueItem['payDue'];
				}
			}

			$unalloc = $invoiceTotal - $dueRawTotal;
			$unallocRes = $unalloc - $onsiteExtraAmt;
			if($unallocRes != 0) {
				fixAmtDisplay($unallocRes);
				array_push($dueItemArray,array(
					"info" => "Planned payment",
					"due" => $unallocRes,
					"date" => "Unallocated",
					"pay_item_id" => 1
				));
			}
			if($dueList[sizeof($dueList)-1]['rv_pay_plan_date'] <= $toDate['jsDate']) {
				$dueTotal += $unallocRes;
			}

			if($onsiteExtraAmt != 0 && $resItem['rv_date_depart'] <= $toDate['jsDate'] && $includeExtras == "1") {
				fixAmtDisplay($onsiteExtraAmt);
				array_push($dueItemArray,array(
					"info" => "Onsite Extras",
					"due" => $onsiteExtraAmt,
					"date" => chng_date($resItem['rv_date_depart'],"-"),
					"pay_item_id" =>1
				));
				$dueTotal += $onsiteExtraAmt;
			} else {
				$invoiceTotal = $invoiceTotal - $onsiteExtraAmt;
			}
			$paidItemArray = array();
			$paidTotal = 0;
			$paidTotalRaw = 0;
			$rcdKey = $item['rv_agent_id'] . "_" . $item['rv_invoice_currency_id'] . "_" . $resItem['rv_reservation_ix'];
			if(array_key_exists($rcdKey,$rcdList)) {
				foreach($rcdList[$rcdKey] as $rcdItem) {
					if($rcdItem['rf_db_env_type_ind'] != 4 || ($rcdItem['rf_db_env_type_ind'] == 4 && $includeExtras == "1")) { 
						if($reservationSummary == 1) {
							$rcdItem['rv_pmnt_date_fmt'] = chng_date($rcdItem['rv_pmnt_date'],"-");
							$info = $rcdItem['rv_pmnt_ref'] . " - " . $rcdItem['pr_name_last'];
							if(strlen($info) > 28) {
								$info = substr($info,0,26) . "...";
							}
							if($rcdItem['rv_pmnt_date'] <= $toDate['jsDate']) {
								array_push($paidItemArray,array(
									'info' => $info,
									'paid' => $rcdItem['payReceive'],
									'date' => $rcdItem['rv_pmnt_date_fmt']
								));
							} else {
								array_push($paidItemArray,array(
									'info' => $info,
									'paid' => $rcdItem['payReceive'],
									'date' => "Future"
								));
							}
						}
						if($rcdItem['rv_pmnt_date'] <= $toDate['jsDate']) {
							$paidTotal += $rcdItem['payReceive'];
						}
						$paidTotalRaw += $rcdItem['payReceive'];
					}

				}
			}
			$balanceDue = $dueTotal - $paidTotal;
			if($balanceDue == 0 || ($includeCredits != "1" && $balanceDue <= 0)) {continue;}
				$balanceTotal = $invoiceTotal - $paidTotalRaw;
				fixAmtDisplay($dueTotal);
				fixAmtDisplay($paidTotal);
				fixAmtDisplay($balanceDue);
				fixAmtDisplay($balanceTotal);
				fixAmtDisplay($invoiceTotal);
				$travelArrive = chng_date($resItem['rv_date_arrive'],"-");
				$travelDepart = chng_date($resItem['rv_date_depart'],"-");
				$travelPropertyCount = $lDB->get("
					SELECT
						COUNT(DISTINCT pr_business_id)
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_id = '$resItem[rv_reservation_ix]'
				",4);

				array_push($summaryArray[$key]['resItems'],array(
					'resNum' => $resItem['rv_reservation_ix'],
					'resName' => $resItem['rv_res_name'],
					'contactName' => $resItem['contactName'],
					'payDue' => $dueTotal,
					'payReceived' => $paidTotal,
					'balanceDue' => $balanceDue,
					'balanceTotal' => $balanceTotal,
					'invoiceTotal' => $invoiceTotal,
					'travelArrive' => $travelArrive,
					'travelDepart' => $travelDepart,
					'travelProperties' => $travelPropertyCount,
					'dueItems' => $dueItemArray,
					'paidItems' => $paidItemArray,
					'paymentPlanName' => $paymentPlanName,
					'pay_plan_id' => $resItem['ac_pay_plan_id']
				));
				array_push($resScrollSet,$resItem['rv_reservation_ix']);

				//To populate total per agent array with values.

				$totalPayDue = $totalPayDue + $dueTotal;
				$totalPayReceived = $totalPayReceived + $paidTotal;
				$totalBalanceDue =	$totalBalanceDue + $balanceDue;
				$totalBalanceTotal	= $totalBalanceTotal + $balanceTotal;
				$totalInvoice = $totalInvoice + $invoiceTotal;
			}
		}
		setRecordScroll($resScrollSet);
	
		if(!isset($agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]) || !is_array($agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']])) {
			$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']] = array();
		}

		$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayDue'] = number_format($totalInvoice, 2, '.', '');
		$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayReceived'] = number_format($totalPayReceived, 2, '.', '');
		$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceDue'] =number_format($totalBalanceTotal, 2, '.', '');
		$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceTotal'] =number_format($totalBalanceDue, 2, '.', '');
	
		if(!array_key_exists($item['rf_currency_symbol'], $perReportTotal)) {
			$perReportTotal[$item['rf_currency_symbol']] =	array();
			$perReportTotal[$item['rf_currency_symbol']]['totalPayDue'] = 0;
			$perReportTotal[$item['rf_currency_symbol']]['totalPayReceived'] = 0;
			$perReportTotal[$item['rf_currency_symbol']]['totalBalanceDue']	 =	0;
			$perReportTotal[$item['rf_currency_symbol']]['totalBalanceTotal'] =	0;
			$perReportTotal[$item['rf_currency_symbol']]['totalInvoice'] = 0;
		}

		$perReportTotal[$item['rf_currency_symbol']]['totalPayDue']+=	$totalPayDue;
		$perReportTotal[$item['rf_currency_symbol']]['totalPayReceived']+=	$totalPayReceived;
		$perReportTotal[$item['rf_currency_symbol']]['totalBalanceDue']+=	$totalBalanceDue;
		$perReportTotal[$item['rf_currency_symbol']]['totalBalanceTotal']+=	$totalBalanceTotal;
		$perReportTotal[$item['rf_currency_symbol']]['totalInvoice']+=	$totalInvoice;

		$perReportTotal[$item['rf_currency_symbol']]['totalPayDue']=	      number_format($perReportTotal[$item['rf_currency_symbol']]['totalPayDue'], 2, '.', '');
		$perReportTotal[$item['rf_currency_symbol']]['totalPayReceived']=	 number_format($perReportTotal[$item['rf_currency_symbol']]['totalPayReceived'], 2, '.', '');

		$perReportTotal[$item['rf_currency_symbol']]['totalBalanceDue']=	 number_format($perReportTotal[$item['rf_currency_symbol']]['totalBalanceDue'], 2, '.', '');
		$perReportTotal[$item['rf_currency_symbol']]['totalBalanceTotal']=	 number_format($perReportTotal[$item['rf_currency_symbol']]['totalBalanceTotal'], 2, '.', '');
		$perReportTotal[$item['rf_currency_symbol']]['totalInvoice']=	 number_format($perReportTotal[$item['rf_currency_symbol']]['totalInvoice'], 2, '.', '');
	}
}

$newSummaryArray = array();
foreach($summaryArray as $key=>$item) {
	if(isset($item['resItems']) && sizeof($item['resItems']) > 0) {
		$newSummaryArray[$key] = $item;
	}
}
$summaryArray = $newSummaryArray;

if($reservationSummary == 1) {
	$showDetail = "expand";
} else {
	$showDetail = "collapse";
}

if($travelSummary == 1) {
	$showTravelSummary = "expand";
} else {
	$showTravelSummary = "collapse";
}

$agent = false;
$currency = "";
$rows = "";
$tmpRows = "";
$tmpCounter = 1;
$rowHTML = Join("",file(__DIR__ . "/../../../public/html/rep_deposit_row.htm"));
$finTabJob = "646";
if(checkjob(647)) {
	$finTabJob = "647";
}
$rowHTML = str_replace("!finTabJob!",$finTabJob,$rowHTML);
$detailRowHTML = Join("",file(__DIR__ . "/../../../public/html/rep_deposit_detail_row.htm"));
$GLOBALS['temp']['collectionHeaderShow'] = "collapse printCollapse";
$GLOBALS['temp']['summaryHeaderShow'] = "expand";


if($renderMode == "html") {
	if(sizeof($summaryArray) > 0) {
		foreach($summaryArray as $key => $item) {
			if( $item['totalBalance'] == 0 ) {
				continue;
			}
			if($agent !== $item['pr_persona_ix']) {
				$agent = $item['pr_persona_ix'];
				$currency = "";
				$rows .= $tmpRows . "
					<tr>
						<td class=\"colLtt\" colspan=\"7\" height=\"20\">
							<input type=\"checkbox\" name=agentToMail[] value=".$item['pr_persona_ix']." onclick=\" addAgent(this.value, this.checked)\">
							<span class=\"txtb\" id=\".$item[pr_persona_ix].\">&nbsp;".$item['pr_name_last']."</span>
						</td>
					</tr>
				";
			}
			//Edit on 19-01-08 totalBalanceTotal display from agentTotal fo item array
			if($currency != $item['rv_invoice_currency_id']) {
				$currency = $item['rv_invoice_currency_id'];
				$rows .= "
					<tr>
						<td width=\"8%\" height=\"20\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"colGry\" width=\"4%\" align=\"center\"><span class=\"txtb\">".$item['rf_currency_symbol']."</span></td>
						<td class=\"colGry\" width=\"40%\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td class=\"colGry\" width=\"12%\" align=\"right\"><span>".$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayDue']." ".$item['rf_currency_symbol']."</span></td>
						<td class=\"colGry\" width=\"12%\" align=\"right\"><span>".$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayReceived']." ".$item['rf_currency_symbol']."</span></td>
						<td class=\"colGry\" width=\"12%\" align=\"right\"><span>".$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceDue']." ".$item['rf_currency_symbol']."</span></td>
						<td class=\"colGry\" width=\"12%\" align=\"right\"><span class=\"txtb\">".$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceTotal']." ".$item['rf_currency_symbol']."</span></td>
					</tr>
				";
			}

			foreach($item['resItems'] as $resItem) {
				if($reservationSummary == 1) {
					// Generate dropdown of all valid rate types
					$acPayPlanId = $lDB->get("SELECT ac_pay_plan_id FROM rv_reservation WHERE rv_reservation_ix = '$resItem[resNum]'",4);
					$GLOBALS[$form]->AddField($form."_sysPayPlanId_".$resItem['resNum'], "sysPayPlanId_".$resItem['resNum'], $acPayPlanId, 3);

					$GLOBALS[$form.'_sysPayPlanId_'.$resItem['resNum']]->Select(combolist($lDB, "
						SELECT 
							ac_pay_plan_ix,
							IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc)
						FROM
							ac_pay_plan
						WHERE
							ac_pay_plan.ac_pay_plan_inactive_yn = 0
							OR ac_pay_plan.ac_pay_plan_ix = '$acPayPlanId'
						ORDER BY
							ac_pay_plan_desc
					"));
					$GLOBALS[$form.'_sysPayPlanId_'.$resItem['resNum']]->TabIndex = 16;
					$GLOBALS[$form.'_sysPayPlanId_'.$resItem['resNum']]->StyleType = "txt";
					$GLOBALS[$form.'_sysPayPlanId_'.$resItem['resNum']]->onChange = "return;";

					if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] >= 10) {
						if(canEditReservation($resItem['resNum'],$checkAccess=true,$job=$_SERVER['argv'][0])) {
							$payPlans = "
								<tr class=\"!showDetail!\">
									<td colspan=\"2\" align=\"right\">
										<input type=\"checkbox\" value='".$resItem['resNum']."' onclick=\"agentSelect(this.checked,this.value)\">
									</td>
									<td colspan=\"5\">
										<table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" class=\"inWh\">
										<tr>
											<td class=\"txt\" height=\"25\" width=\"130\">".$GLOBALS[$form.'_sysPayPlanId_'.$resItem['resNum']]->Show(3)."</td>
											<td><input type=\"button\" !payplanStyle! id=\"addPayPlanButton\" class=\"button bGo printCollapse\" onclick=\"genPayPlan('".$resItem['resNum']."')\" value=\"    \"></td>
										</tr>
										</table>
									</td>
								</tr>
							";
						} else {
							$payPlans = "
								<tr class=\"!showDetail!\">
									<td colspan=\"2\" align=\"right\">&nbsp;</td>
									<td colspan=\"5\">
										<table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" class=\"inWh\">
										<tr>
											<td class=\"txt\" height=\"25\" width=\"130\">".$GLOBALS[$form.'_sysPayPlanId_'.$resItem['resNum']]->Show(3)."</td>
											<td>&nbsp;</td>
										</tr>
										</table>
									</td>
								</tr>
							";
						}
					} else {
						$payPlans = "
							<tr class=\"!showDetail!\">
								<td colspan=\"2\" align=\"right\">&nbsp;</td>
								<td colspan=\"5\">
									<table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" class=\"inWh\">
									<tr>
										<td class=\"txt\" height=\"25\" width=\"130\">".$GLOBALS[$form.'_sysPayPlanId_'.$resItem['resNum']]->Show(3)."</td>
										<td>&nbsp;</td>
									</tr>
									</table>
								</td>
							</tr>
						";
					}
				} else {
					$payPlans = "";
				}
			
				$detail = "";
			
				if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] >= 10) {
					if(canEditReservation($resItem['resNum'],$checkAccess = true,$job=$_SERVER['argv'][0])) {
						$clickThrough = " style=\"cursor:pointer\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" ";
					} else {
						$clickThrough = '';
					}
				} else {
					$clickThrough = '';
				}
			
				foreach($resItem['dueItems'] as $dueItem) {
					if($dueItem['date'] == "Unallocated") {
						$vardate = date("Y-m-d");
					} else {
						$vardate = date("Y-m-d", strtotime($dueItem['date']));
					}

					if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]]>=10) {
						if(canEditReservation($resItem['resNum'],$checkAccess=true,$job=$_SERVER['argv'][0])){
							$editCall = "onclick=\"editPayItem1('".$resItem['resNum']."', '".$dueItem['pay_item_id']."', '".$vardate."', '".$dueItem['due']."', '".$item['rf_currency_symbol']."')\"";
						} else {
							$editCall = '';
						}
					} else {
						$editCall = '';
					}
					/****End of Code block to manage update functionality according user rights.***/
				
					if($dueItem['date'] == "Unallocated") {
						$dueItem['date'] = "<SPAN CLASS=\"txtbred\">" . $dueItem['date'] . "</SPAN>";
						$showHide = " style=\"visibility:hidden\" ";
					} else if ( $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]]<10) {
						$showHide = " style=\"visibility:hidden\" ";
					} else{
						if(canEditReservation($resItem['resNum'],$checkAccess=true,$job=$_SERVER['argv'][0])){
							$showHide = " ";
						} else{
							$showHide = " style=\"visibility:hidden\" ";
						}
					}
				
					if(count($resItem['dueItems']) <= 1) {
						$showHide = " style=\"visibility:hidden\" ";
					}
				
					$detail .= 
						str_replace("!paid!","",
						str_replace("!canEdit!",$clickThrough,
						str_replace("!editCall!",$editCall,
						str_replace("!info!",$dueItem['info'],
						str_replace("!due!",$dueItem['due'] ." ".$item['rf_currency_symbol'],
						str_replace("!hideShowDel!", $showHide,
						str_replace("!pay_id!",$dueItem['pay_item_id'],
						str_replace("!date!",$dueItem['date'],$detailRowHTML))))))));
				}

				foreach($resItem['paidItems'] as $payItem) {
					$detail .=
						str_replace("!paid!",$payItem['paid']." ".$item['rf_currency_symbol'],
						str_replace("!info!",$payItem['info'],
						str_replace("!due!","",
						str_replace("!hideShowDel!"," style=\"visibility:hidden\" ",
						str_replace("!date!",$payItem['date'],$detailRowHTML)))));
				}

				$travelSummaryItem = "
					<tr>
						<td>
							&nbsp;Arrive: ".$resItem['travelArrive']."<BR>
							&nbsp;Depart: ".$resItem['travelDepart']."<BR>
							&nbsp;Number of properties: ".$resItem['travelProperties']."
						</td>
					</tr>
				";
			
				$rows .=
					str_replace("!items!",$detail,
					str_replace("!payDue!",$resItem['payDue'],
					str_replace("!payReceived!",$resItem['payReceived'],
					str_replace("!balanceDue!",$resItem['balanceDue'],
					str_replace("!balanceTotal!",$resItem['balanceTotal'],
					str_replace("!invoiceTotal!",$resItem['invoiceTotal'],
					str_replace("!showDetail!",$showDetail,
					str_replace("!showTravelSummary!",$showTravelSummary,
					str_replace("!rf_currency_symbol!",$item['rf_currency_symbol'],
					str_replace("!travelSummaryItems!",$travelSummaryItem,
					str_replace("!payPlans!",$payPlans,
					str_replace("!resNum!",$resItem['resNum'],
					str_replace("!contName!",$resItem['contactName'],
					str_replace("!conDisp!",$conDisp,
					str_replace("!resName!",$resItem['resName'] . ": " . $resItem['paymentPlanName'],$rowHTML)))))))))))))));  
			}
 
			if(isset($sectionTotals) && $sectionTotals == 1 && isset($perAgent) && $perAgent == 1){
				$tmpRows = "<tr><td colspan=\"7\" height=\"10\">&nbsp;</td></tr>";
				$tmpRows .= "
					<tr>
						<td colspan=\"2\" height=\"20\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
						<td colspan=\"5\" align=\"center\">
							<table width=\"100%\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" class=\"brdr\">
							<tr>
								<td align=\"left\" valign=\"top\">
									<p>&nbsp;&nbsp;<b>Summary</b> of displayed payments due to ".date("d F Y",strtotime($toDate['jsDate']))."</p>
									<p>&nbsp;&nbsp;For $statusStr reservations<BR>&nbsp;&nbsp;Property: $propertyStr
									<BR>&nbsp;&nbsp;Printed on ".date("d M Y")." (refer to additional filters in the report filters section of the report summary section of the PDF).
									</p>
								</td>
							</tr>
							<tr>
								<td align=\"left\" valign=\"top\">
									<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"data_table\">
									<tr>
										<td width=\"38%\" class=\"brdr_right\">&nbsp;</td>
										<td width=\"15%\" align=\"right\" valign=\"middle\" class=\"brdr_right\" ><b>Res Total</b> </td>
										<td width=\"17%\" align=\"right\" valign=\"middle\" class=\"brdr_right\"><b>Received to Date</b> </td>
										<td width=\"15%\" align=\"right\" valign=\"middle\" class=\"brdr_right\" ><b>Balance Due</b> </td>
										<td width=\"15%\" align=\"right\" valign=\"middle\" class=\"bg_yellow\"><strong><b>Due to date</b> </strong></td>
										</tr>
				";

				foreach($agentTotal[$item['rv_agent_id']] as $id => $data){
					$tmpRows .= "
						<tr>
							<td align=\"left\" valign=\"middle\" class=\"brdr_right\" >&nbsp;&nbsp;".$id."</td>
							<td align=\"right\" valign=\"middle\" class=\"brdr_right\" >".$data['totalPayDue']." ".$id."</td>
							<td align=\"right\" valign=\"middle\" class=\"brdr_right\" >".$data['totalPayReceived']." ".$id."</td>
							<td align=\"right\" valign=\"middle\" class=\"brdr_right\" >".$data['totalBalanceDue']." ".$id."</td>
							<td align=\"right\" valign=\"middle\" class=\"bg_yellow\" >".$data['totalBalanceTotal']." ".$id."</td>
							</tr>
					";
				}
				$tmpRows .= "
									</table>
								</td>
							</tr>
							</table>
						</td>
					</tr>
				";
				$tmpRows.= "<tr><td colspan=\"7\" height=\"10\">&nbsp;</td></tr>";

				if($tmpCounter == count($summaryArray)){
					$rows.= $tmpRows;
				}
			}

			$tmpCounter++;
		}
 
		if(isset($sectionTotals) && $sectionTotals == 1 && isset($perReport) && $perReport == 1){
			$rows.= "<tr><td colspan=\"7\" height=\"20\">&nbsp;</td></tr>";
			$rows .= "
				<tr>
					<td colspan=\"2\" height=\"20\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
					<td colspan=\"5\" align=\"left\">
						<table width=\"100%\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" class=\"brdr\">
						<tr>
							<td align=\"left\" valign=\"top\">
								<p>&nbsp;&nbsp;<b>Summary</b> of displayed payments due to ".date("d F Y",strtotime($toDate['jsDate']))."</p>
								<p>&nbsp;&nbsp;For $statusStr reservations.<br>&nbsp;&nbsp;Property: $propertyStr.
								<br>&nbsp;&nbsp;Printed on ".date("d M Y")." (refer to additional filters in the report filters section of the report summary section of the PDF).
								</p>
							</td>
						</tr>
						<tr>
							<td align=\"left\" valign=\"top\">
								<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"data_table\">
								<tr>
									<td width=\"38%\" class=\"brdr_right\">&nbsp;</td>
									<td width=\"15%\" align=\"right\" valign=\"middle\" class=\"brdr_right\" ><b>Res Total</b> </td>
									<td width=\"17%\" align=\"right\" valign=\"middle\" class=\"brdr_right\"><b>Received to Date</b> </td>
									<td width=\"15%\" align=\"right\" valign=\"middle\" class=\"brdr_right\" ><b>Balance Due</b> </td>
									<td width=\"15%\" align=\"right\" valign=\"middle\" class=\"bg_yellow\"><strong><b>Due to date</b> </strong></td>
									</tr>
			";
			foreach($perReportTotal as $id => $data) {
				$rows .= "
					<tr>
						<td align=\"left\" valign=\"middle\" class=\"brdr_right\" >&nbsp;&nbsp;".$id."</td>
						<td align=\"right\" valign=\"middle\" class=\"brdr_right\" >".$data['totalInvoice']." ".$id."</td>
						<td align=\"right\" valign=\"middle\" class=\"brdr_right\" >".$data['totalPayReceived']." ".$id."</td>
						<td align=\"right\" valign=\"middle\" class=\"brdr_right\" >".$data['totalBalanceTotal']." ".$id."</td>
						<td align=\"right\" valign=\"middle\" class=\"bg_yellow\" >".$data['totalBalanceDue']." ".$id."</td>
					</tr>
				";
			}
			$rows.="
								</table>
							</td>
						</tr>
						</table>
					</td>
				</tr>
			";
		}

		$GLOBALS['temp']['rows'] = $rows;
	} else {
		// no records....
		$GLOBALS['temp']['rows'] = "<tr><td colspan=\"7\" class=\"txti\" align=\"center\">No records found</td></tr>";
	}
}


if($renderMode == "paymentplan" && $renderType == "update") {
	$resList = $_SERVER['argv'][23];
	$resList = explode("-", $resList);
	$recipients = "<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
						";
	foreach($resList as $res){
		if($res!=''){
			$resDetails = $lDB->get("
				SELECT
						rv_reservation.rv_reservation_ix, rv_reservation.rv_res_name
				FROM
						rv_reservation
				WHERE
						rv_reservation.rv_reservation_ix = '" .$res. "'
				", 1);
			$recipients.= 
				"<tr valign=\"top\">
					<td width=\"50%\">&nbsp;".$resDetails['rv_reservation_ix']."</td>
					<td width=\"50%%\">".$resDetails['rv_res_name']."</td>
				</tr>
				";
		}
	}
	$recipients.="</table>";


	$GLOBALS[$form]->FormHTML =
		str_replace("!formAction!",(isset($formAction) ? $formAction: ""),
		str_replace("!recipients!",$recipients,
		Join("", file(__DIR__ . "/../../../public/html/payment_plan_confirm_popup.htm"))));
}



// [START] CSV output ---------------------------------------------------------
if($renderMode == "csv") {
	$csvFile = array();
	$tmpFile = array();
	$tmpCounter = 1;

	array_push($csvFile,array("Payments Due Report"));
	array_push($csvFile,array());
	array_push($csvFile,array("Agent",$agentFilter['names']));
	array_push($csvFile,array("Payments due to",$toDate['htmlDate']));
	array_push($csvFile,array("Travel date range",$fromTravelDate['htmlDate']." to " .$toTravelDate['htmlDate']));
	array_push($csvFile,array("Status",$statusFilter['names']));
	array_push($csvFile,array("Consultant",$consultantFilter['names']));
	array_push($csvFile,array("Payment plan",$paymentPlanFilter['names']));
	array_push($csvFile,array());
	array_push($csvFile,array(
		"Agent",
		"Currency",
		"Reservation Number",
		"Reservation Name",
		"Date",
		"Reservation Total",
		"Received to Date",
		"Balance Due",
		"Due to Date"
	));
	$agent = "";
	foreach($summaryArray as $key => $item) {
		if($item['totalBalance'] == 0) continue;
        
		if($agent !== $item['pr_persona_ix']) {
			$agent = $item['pr_persona_ix'];
			$currency = "";
						
			foreach($tmpFile as $tmp){
					array_push($csvFile,$tmp);
			}
					
			array_push($csvFile,array(
				$item['pr_name_last']
			));
		}
		
		$tmpFile = array();

		if($currency != $item['rv_invoice_currency_id']) {
			$currency = $item['rv_invoice_currency_id'];
			array_push($csvFile,array(
				"",
				$item['rf_currency_symbol'],
				"",
				"",
				"",
				$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayDue'],
				$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayReceived'],
				$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceDue'],
				$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceTotal']
			));
		}
		
		foreach ( $item['resItems'] as $resItem ) {
			if($showConsultants ==1) {
				$contName = $resItem['contactName'];
			} else {
				$contName = "";
			}
			array_push($csvFile,array(
				"",
				"",
				$resItem['resNum'],
				$resItem['resName']." (".$contName.")",
				"",
				$resItem['invoiceTotal'],
				$resItem['payReceived'],
				$resItem['balanceTotal'],
				$resItem['balanceDue']
			));

			if ( $reservationSummary == "1" ) {
				foreach ( $resItem['dueItems'] as $d ) {
					array_push($csvFile,array(
						"",
						"",
						"",
						$d["info"],
						$d["date"],
						$d["due"],
						"",
						"",
						""
					));
				}
				foreach ( $resItem['paidItems'] as $p ) {
					array_push($csvFile,array(
						"",
						"",
						"",
						$p["info"],
						$p["date"],
						"",
						$p["paid"],
						"",
						""
					));
				}
			}

			if($travelSummary == "1") {
				array_push($csvFile,array(
					"",
					"",
					"Arrive: ".$resItem['travelArrive']
				));
				array_push($csvFile,array(
					"",
					"",
					"Depart: ".$resItem['travelDepart']
				));
				array_push($csvFile,array(
					"",
					"",
					"Number of properties: ".$resItem['travelProperties']
				));
			}
		}
		
		if($sectionTotals == 1 && $perAgent == 1){
			$summary = "Summary of displayed payments due to ".date("d F Y",strtotime($toDate['jsDate']))."\n For $statusStr reservations\n Property: $propertyStr\n Printed on ".date("d M Y")." (refer to additional filters in the report filters section of the report summary section of the PDF)";

			array_push($tmpFile,array($summary));

			array_push($tmpFile,array(
				"",
				"",
				"",
				"",
				"Currency",
				"Reservation Total",
				"Received to Date",
				"Balance Due",
				"Due to Date"
			));


			foreach($agentTotal[$item['rv_agent_id']] as $id=>$data) {
				array_push($tmpFile,array(
					"",
					"",
					"",
					"",
					$id,
					$data['totalPayDue'],
					$data['totalPayReceived'],
					$data['totalBalanceDue'],
					$data['totalBalanceTotal']
				));
			}

			array_push($tmpFile,array(''));
			if($tmpCounter == count($summaryArray)) {
				foreach($tmpFile as $tmp){
					array_push($csvFile,$tmp);
				}
				$tmpFile = array();
			}
			
		}
		$tmpCounter++;
		
	}
	
	if($sectionTotals == 1 && $perReport==1) {
		$summary	=	"Summary of displayed payments due to ".date("d F Y",strtotime($toDate['jsDate']))."\n For $statusStr reservations\n Property: $propertyStr\n Printed on ".date("d M Y")." (refer to additional filters in the report filters section of the report summary section of the PDF)";

		array_push($csvFile,array($summary));
			
		array_push($csvFile,array(
			"",
			"",
			"",
			"",
			"Currency",
			"Reservation Total",
			"Received to Date",
			"Balance Due",
			"Due to Date"
		));

		foreach($perReportTotal as $id=>$data) {
			array_push($csvFile,array(
				"",
				"",
				"",
				"",
				$id,
				$data['totalInvoice'],
				$data['totalPayReceived'],
				$data['totalBalanceTotal'],
				$data['totalBalanceDue']
			));
		}
	}
	csv_output("payments_due_".$fromDate['htmlDate']."_to_".$toDate['htmlDate'],$csvFile);
}


if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
	$agent = false;
	$currency = "";
	$tmpFile = array();
	$tmpCounter = 1;

	$reportLabel = "Payments Due to ".$toDate['htmlDate'];
	$pdf = new PDF($reportLabel);

	// Main PDF header
	
	$headerArray = array(
		array('name'=>"Agent", 'value'=>$agentFilter['names']),
		array('name'=>"Payments due to", 'value'=>$toDate['htmlDate']),
		array('name'=>"Status", 'value'=>$statusFilter['names']),
		array('name'=>"Property", 'value'=>$accommFilter['names']),
		array('name'=>"Consultant", 'value'=>$consultantFilter['names']),
		array('name'=>"Payment plan", 'value'=>$paymentPlanFilter['names']),
		array('name'=>"Reservation contact", 'value'=>($showConsultants == 1)?"Yes":"No"),
		array('name'=>"Financial summaries", 'value'=>($sectionTotals == 1)?(($perAgent == 1)?"Per agent":"Per report"):"No"),
		array('name'=>"Payment details", 'value'=>($reservationSummary == 1)?"Yes":"No"),
		array('name'=>"Include credits", 'value'=>($includeCredits == "1")?"Yes":"No"),
		array('name'=>"Include onsite extras", 'value'=>($includeExtras == "1")?"Yes":"No"),
		array('name'=>"Travel summary", 'value'=>($travelSummary == 1)?"Yes":"No"),
		array('name'=>"Travel date range", 'value'=>$fromTravelDate['htmlDate']." to " .$toTravelDate['htmlDate'])
	);
	$pdf->ReportHeader($reportLabel, $headerArray);
	$pdfFontSize = 8;
	$pdf->SetFont('Arial', '', $pdfFontSize);
	$pdf->SetFont('Arial', '', 6);

	$pdf->Ln(2);
	$headRow = array();
	array_push($headRow,
		array('width'=>"8%", 'data'=>"Agent", 'border'=>"LT", 'fill'=>1),
		array('width'=>"8%", 'data'=>"Currency", 'border'=>"LT", 'fill'=>1),
		array('width'=>"14%", 'data'=>"Reservation Number", 'border'=>"LT", 'fill'=>1),
		array('width'=>"22%", 'data'=>"Reservation Name", 'border'=>"LT", 'fill'=>1),
		array('width'=>"12%", 'data'=>"Reservation Total", 'border'=>"LT", 'fill'=>1, 'align'=>"R"),
		array('width'=>"12%", 'data'=>"Received to Date", 'border'=>"LRT", 'fill'=>1, 'align'=>"R"),
		array('width'=>"12%", 'data'=>"Balance Due", 'border'=>"LT", 'fill'=>1, 'align'=>"R"),
		array('width'=>"12%", 'data'=>"Due to Date", 'border'=>"LRT", 'fill'=>1, 'align'=>"R")
	);

	$pdf->Row($headRow);
	if(sizeof($summaryArray) > 0) {
		foreach($summaryArray as $key=>$item) {
			if($item['totalBalance'] == 0) continue;
			$listRow = array();
			$currRow = array();
			if($agent !== $item['pr_persona_ix']) {
				$agent = $item['pr_persona_ix'];
				$currency = "";

				foreach($tmpFile as $tmp){
					$pdf->Row($tmp);
				}

				array_push($listRow,
					array('width'=>"100%", 'data'=>$item['pr_name_last'], 'border'=>"LTBR", 'fill'=>1)
				);
				$pdf->Row($listRow);
			}
			$tmpFile = array();

			if($currency != $item['rv_invoice_currency_id']) {
				$currency = $item['rv_invoice_currency_id'];

				array_push($currRow,
					array('width'=>"8%", 'data'=>"", 'border'=>"R"),
					array('width'=>"8%", 'data'=>$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1),
					array('width'=>"36%", 'data'=>"", 'border'=>"TBR", 'fill'=>1),
					array('width'=>"12%", 'data'=>$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayDue']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1, 'align'=>"R"),
					array('width'=>"12%", 'data'=>$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayReceived']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1, 'align'=>"R"),
					array('width'=>"12%", 'data'=>$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceDue']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1, 'align'=>"R"),
					array('width'=>"12%", 'data'=>$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceTotal']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1, 'align'=>"R")
				);
				$pdf->Row($currRow);
			}
			foreach($item['resItems'] as $resItem) {
				if($showConsultants ==1) {
					$contName = $resItem['resName']." (".$resItem['contactName'].")";
				} else {
					$contName = $resItem['resName'];
				}
				$pdf->Row(array(
					array('width'=>"16%", 'data'=>""),
					array('width'=>"14%", 'data'=>$resItem['resNum'], 'border'=>"LTBR", 'align'=>"L"),
					array('width'=>"22%", 'data'=>$contName, 'border'=>"LTBR", 'align'=>"L"),
					array('width'=>"12%", 'data'=>$resItem['invoiceTotal']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'align'=>"R"),
					array('width'=>"12%", 'data'=>$resItem['payReceived']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'align'=>"R"),
					array('width'=>"12%", 'data'=>$resItem['balanceTotal']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'align'=>"R"),
					array('width'=>"12%", 'data'=>$resItem['balanceDue']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'align'=>"R")
				));
				if ( $reservationSummary == "1" ) {
					foreach($resItem['dueItems'] as $dueItem) {
						$pdf->Row(array(
							array('width'=>"16%", 'data'=>""),
							array('width'=>"14%", 'data'=>$dueItem['info'], 'border'=>"LTBR", 'align'=>"R"),
							array('width'=>"22%", 'data'=>$dueItem['date'], 'border'=>"TBR", 'align'=>"R"),
							array('width'=>"12%", 'data'=>$dueItem['due']." ".$item['rf_currency_symbol'], 'border'=>"TBR", 'align'=>"R"),
						    array('width'=>"36%", 'data'=>"", 'border'=>"TBR")
						));
					}
					foreach($resItem['paidItems'] as $dueItem) {
						$pdf->Row(array(
							array('width'=>"16%", 'data'=>""),
							array('width'=>"14%", 'data'=>$dueItem['info'], 'border'=>"LTBR", 'align'=>"R"),
							array('width'=>"22%", 'data'=>$dueItem['date'], 'border'=>"TBR", 'align'=>"R"),
							array('width'=>"12%", 'data'=>"", 'border'=>"LTBR"),
							array('width'=>"12%", 'data'=>$dueItem['paid']." ".$item['rf_currency_symbol'], 'border'=>"TBR", 'align'=>"R"),
							array('width'=>"24%", 'data'=>"", 'border'=>"TBR")
						));
					}
				}
				if($travelSummary == "1") {
					$pdf->Row(array(
						array('width'=>"16%", 'data'=>""),
						array('width'=>"84%", 'data'=>"Arrive: ".$resItem['travelArrive'], 'border'=>"LBTR")
					));
					$pdf->Row(array(
						array('width'=>"16%", 'data'=>""),
						array('width'=>"84%", 'data'=>"Depart: ".$resItem['travelDepart'], 'border'=>"LBTR")
					));
					$pdf->Row(array(
						array('width'=>"16%", 'data'=>""),
                  		array('width'=>"84%", 'data'=>"Number of properties: ".$resItem['travelProperties'], 'border'=>"LBTR")
					));
				}
			}

			//To display agent wise summary in pdf.

			if($sectionTotals==1 && $perAgent==1) {
				$summary = " Summary of displayed payments due to ".date("d F Y",strtotime($toDate['jsDate']))."
				For $statusStr reservations
				Property: $propertyStr
				Printed on ".date("d M Y")." ";
				array_push($tmpFile,array(array('width'=>"100%", 'data'=>'')));
				array_push($tmpFile,array(
					array('width'=>"16%", 'data'=>"", 'border'=>"R"),
					array('width'=>"84%", 'data'=>$summary, 'border'=>"LTBR")
				));
				array_push($tmpFile,array(
					array('width'=>"16%", 'data'=>"", 'border'=>"R"),
					array('width'=>"36%", 'data'=>" ", 'border'=>"LTB"),
					array('width'=>"12%", 'data'=>"Reservation Total", 'border'=>"LTB", 'align'=>"R"),
					array('width'=>"12%", 'data'=>"Received to Date", 'border'=>"LTB", 'align'=>"R"),
					array('width'=>"12%", 'data'=>"Balance Due", 'border'=>"LTB", 'align'=>"R"),
					array('width'=>"12%", 'data'=>"Due to Date", 'border'=>"LBTR", 'align'=>"R",'style' =>"B")
				));

				foreach($agentTotal[$item['rv_agent_id']] as $id=>$data) {
					array_push($tmpFile,array(
						array('width'=>"16%", 'data'=>"", 'border'=>"R"),
						array('width'=>"36%", 'data'=>$id, 'border'=>"LTB"),
						array('width'=>"12%", 'data'=>$data['totalPayDue']." ".$id, 'border'=>"LTB", 'align'=>"R"),
						array('width'=>"12%", 'data'=>$data['totalPayReceived']." ".$id, 'border'=>"LTB", 'align'=>"R"),
						array('width'=>"12%", 'data'=>$data['totalBalanceDue']." ".$id, 'border'=>"LTB", 'align'=>"R"),
						array('width'=>"12%", 'data'=>$data['totalBalanceTotal']." ".$id, 'border'=>"LTBR", 'align'=>"R", 'style' => "B")
					));
				}

				array_push($tmpFile,array(array('width'=>"100%", 'data'=>'')));

				if($tmpCounter==count($summaryArray)) {
					foreach($tmpFile as $tmp){
						$pdf->Row($tmp);
					}
					$tmpFile	=	array();
				}
			}
			$tmpCounter++;	
		}

		if($sectionTotals==1 && $perReport==1) {
			$summary	=	"Summary of displayed payments due to ".date("d F Y",strtotime($toDate['jsDate']))."
				For $statusStr reservations
				Property: $propertyStr
				Printed on ".date("d M Y")." ";
			$pdf->Row(array(array('width'=>"100%", 'data'=>'')));
			$pdf->Row(array(
				array('width'=>"16%", 'data'=>""),
				array('width'=>"84%", 'data'=>$summary, 'border'=>"LTBR")
			));

			$pdf->Row(array(
				array('width'=>"16%", 'data'=>""),
				array('width'=>"36%", 'data'=>" ", 'border'=>"LTB"),
				array('width'=>"12%", 'data'=>"Reservation Total", 'border'=>"LTB", 'align'=>"R"),
				array('width'=>"12%", 'data'=>"Received to Date", 'border'=>"LTB", 'align'=>"R"),
				array('width'=>"12%", 'data'=>"Balance Due", 'border'=>"LTB", 'align'=>"R"),
				array('width'=>"12%", 'data'=>"Due to Date", 'border'=>"LBTR",'style' =>"B",'align'=>"R")
			));

			foreach($perReportTotal as $id=>$data){
				$pdf->Row(array(
					array('width'=>"16%", 'data'=>""),
					array('width'=>"36%", 'data'=>$id, 'border'=>"LTB"),
					array('width'=>"12%", 'data'=>$data['totalInvoice']." ".$id, 'border'=>"LTB", 'align'=>"R"),
					array('width'=>"12%", 'data'=>$data['totalPayReceived']." ".$id, 'border'=>"LTB", 'align'=>"R"),
					array('width'=>"12%", 'data'=>$data['totalBalanceTotal']." ".$id, 'border'=>"LTB", 'align'=>"R"),
					array('width'=>"12%", 'data'=>$data['totalBalanceDue']." ".$id, 'border'=>"LTBR",'style' =>"B", 'align'=>"R")
				));
			}
		}
	} else {
		$pdf->Row(array(
			array('width'=>"100%", 'data'=>"No records found", 'border'=>"LTBR",'align'=>"C",'style'=>"I")
		));
	}

	$pdf->Row(array(array('width'=>"100%", 'data'=>'')));

	if($renderType == "view") {
		$pdf->OutPut();
		die();
	}

	if($renderType == "send") {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = $_POST['mail_subj'];
		$message = $_POST['mail_body'];
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".(isset($GLOBALS['princName']) ? $GLOBALS['princName'] : "")."<$from>\r\n";

		// close the pdf
		if($pdf->state<3) $pdf->Close();

		/* and now mail it */
		if($attachmentName != "!attachmentName!") {
			$pdfName = $attachmentName;
		} else {
			$pdfName = "Update report from $fromDate to $toDate.pdf";
		}

		$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], (isset($GLOBALS['princName']) ? $GLOBALS['princName'] : ""),$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
		if(!$error) {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
			die();
		} else {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
			die();
		}
	}
}


if($renderMode == "pdf" && $renderType == "emailToAgentSend") {
	//getHeader data   add on 30 jan 08
	$principal_id = $_SESSION['principal_id'];
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$resOfficeInfo = getPersonaDetail($resOfficeId);
	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$logoFilename = "top_clientlogo.jpg";

	if(isset($resOfficeInfo['telephone']) && ($resOfficeInfo['telephone'] != '')) {
		$addressee.= "Telephone: " . $resOfficeInfo['telephone'] . "\n";
	}

	if(isset($resOfficeInfo['fax']) && ($resOfficeInfo['fax']!='')) {
		$addressee.= "Fax: " . $resOfficeInfo['fax'] . "\n";
	}
	if(isset($resOfficeInfo['email']) && ($resOfficeInfo['email'] != '')) {
		$addressee.= "Email: " . $resOfficeInfo['email'] . "\n";
	}
	if(isset($addresseeURL) && $addresseeURL != "") {
		$addressee.= "URL:".getContactURL($resOfficeId)."\n";;
	}
	
	$addressee.= "Res-URL: " . $_SESSION['principal_name_short'] . ".resrequest.com\n";
	///////////////////////
	$agent = false;
	$currency = "";
	$tmpFile = array();
	$tmpCounter = 1;
	$confirmList = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
	";
	$tempAgent = $_POST['agentIds'];// exit;
	
	$tempAgentId = explode(":", $tempAgent);
	
	foreach($tempAgentId as $tmpAgent2){
		$tmpList = explode("~", $tmpAgent2);
		
		if($tmpList[0]!='') {
			$agentList2[$tmpList[0]] = $tmpList[1];
		}
	}
	$counter = 1;
	$oldnames=array();
	
	foreach($agentList2 as $agentOne=>$agentEmail) {
		if($agentOne!=''){
			$agentDetails = $lDB->get("
				SELECT
					pr_persona.pr_persona_ix,
					pr_persona.pr_email,
					pr_persona.pr_name_last,pr_web_addr 
				FROM
					pr_persona
				WHERE
					pr_persona.pr_persona_ix = '$agentOne'
			",1);
		}

		$agentPersonalDetails = getPersonaDetail($agentOne);
		$agentPersonalContDetails = getContactCorrAddress($agentOne);

		$regInfo = "";

		$oldprnames = array();
		if(sizeof($summaryArray) > 0) {
			foreach($summaryArray as $key => $item){
				if($agentOne == $item['pr_persona_ix']) {
					if( $item['totalBalance'] == 0 ) continue;
					if(trim($regInfo) =='') {
						if(is_array($item['resItems'])) {
							foreach($item['resItems'] as $it ) {
								$resNum = $it['resNum'];
								$rsBill = getBusinessDetails($resNum);
								if(is_array($rsBill['billingInfo'])) {
									foreach( $rsBill['billingInfo']  as $bill) {
										if(is_array($oldprnames)) {
											if(!in_array($item['pr_name_last'],$oldprnames)) {
												array_push($oldprnames,$item['pr_name_last']);
												$regInfo .= "<B>$bill[pr_name_last]</B>\n";
												$busUnit = $bill['pr_name_last'];
												if(trim($bill['pr_bus_statutory_1']) != "" && $bill['pr_bus_statutory_1'] != "0") {
													$regInfo .= "Reg: $bill[pr_bus_statutory_1]\n";
												}
												if(trim($bill['pr_bus_statutory_2']) != "" && $bill['pr_bus_statutory_2'] != "0") {
													$regInfo .= "VAT: $bill[pr_bus_statutory_2]\n";
												}
											}
										}
									}
								}
								break;
							}  
						}
					}
				}   
			}
		}
		
		$pdf = new PDF("\t");
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$logoY = $pdf->y;
		$resOfficeHead = "<B>Reservation Office:</B>\n";
		$pdf->MultiCell($pdf->GetPageWidth()/3-10, $pdf->FontSize+1, $resOfficeHead.t_decodeHTML($addressee), '', 'L', 0, 1);
		$pdf->MultiCell($pdf->GetPageWidth()/3+20, $pdf->FontSize+1, "", '', 0, '', 1);
		$pdf->MultiCell($pdf->GetPageWidth()/3, $pdf->FontSize+1,t_decodeHTML($regInfo), '', 'L', 0, 1);
		$pdf->Ln(0, 4);
		$server = $_SESSION['server'];
		if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$logoFilename")) {
			$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename");
			if ($pic['w'] > $pdf->GetPageWidth(1)/4) {
				$pic['w'] = $pdf->GetPageWidth(1)/4;
			}
			require_once(__DIR__ . '/functions.imageset.php');
			$logoWidth = imagesetLogoSizeOverride("paymentsDueReportAgentEmailPdfLogoWidthOverride", $pic['w']);
			$finalH = $pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename", ($pdf->GetPageWidth(1)/2)-($pic['w']/2), $logoY, $logoWidth);
			if (($logoY + $finalH) > $pdf->y) {
				$pdf->y = $logoY + $finalH;
			}
		}
		$pdf->Ln(2);
		$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, "", 'B', 1, 'C');
		$pdf->Ln(2);
		$reportLabel = "Payments Due to ".$toDate['htmlDate'];
		$pdf->SetFont('Arial', 'B', 8);
		$pdf->Cell($pdf->GetPageWidth(), $pdf->FontSize+1, t_decodeHTML($reportLabel), '', 1, 'C');
		$pdf->SetFont('Arial', 'B', $pdfFontSize);
		$reportLabel = "Payments Due";
		
		// Main PDF header
		$headerArray = array(
			array('name'=>"Agent", 'value'=>$agentFilter['names']),
			array('name'=>"Payments due to", 'value'=>$toDate['htmlDate']),
			array('name'=>"Status", 'value'=>$statusFilter['names']),
			array('name'=>"Property", 'value'=>$accommFilter['names']),
			array('name'=>"Consultant", 'value'=>$consultantFilter['names']),
			array('name'=>"Payment plan", 'value'=>$paymentPlanFilter['names']),
			array('name'=>"Reservation contact", 'value'=>($showConsultants == 1)?"Yes":"No"),
			array('name'=>"Financial summaries", 'value'=>($sectionTotals == 1)?(($perAgent == 1)?"Per agent":"Per report"):"No"),
			array('name'=>"Payment details", 'value'=>($reservationSummary == 1)?"Yes":"No"),
			array('name'=>"Include credits", 'value'=>($includeCredits == "1")?"Yes":"No"),
			array('name'=>"Include onsite extras", 'value'=>($includeExtras == "1")?"Yes":"No"),
			array('name'=>"Travel summary", 'value'=>($travelSummary == 1)?"Yes":"No"),
			array('name'=>"Travel date range", 'value'=>$fromTravelDate['htmlDate']." to " .$toTravelDate['htmlDate'])
		);
		//added on 30 jan 08
		$pdf->Ln(2);
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$agentCont = "";
		$agentCont.="Created on ".$toDate['htmlDate']."\n";
		$agentCont.="".$agentDetails['pr_name_last']."\n";
		if($agentPersonalContDetails!='') {
			$agentCont.="".$agentPersonalContDetails."";
		}
		$agentCont.="Email:".$agentDetails['pr_email']."\n";
		if(is_array($agentPersonalDetails)) {
			if(trim($agentPersonalDetails['telephone']) != '') {
				$agentCont.="Telephone : ".$agentPersonalDetails['telephone']."\n";
			}
			if(trim($agentPersonalDetails['telephone']) != '') {
				$agentCont.="Fax : ".$agentPersonalDetails['fax']."\n";
			}
		}
		if(trim($agentDetails['pr_web_addr']) != '') {
			$agentCont.="URL : ".$agentDetails['pr_web_addr']."\n";
		}

		$pdf->MultiCell($pdf->GetPageWidth(), $pdf->FontSize+1, t_decodeHTML($agentCont), '', 'L', 0, 1);
		$pdf->Ln(0, 4);

		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->SetFont('Arial', '', 6);

		$pdf->Ln(6);
		
		$headRow = array();
		array_push($headRow,
			array('width'=>"8%", 'data'=>"Agent", 'border'=>"LT", 'fill'=>1),
			array('width'=>"8%", 'data'=>"Currency", 'border'=>"LT", 'fill'=>1),
			array('width'=>"14%", 'data'=>"Reservation Number", 'border'=>"LT", 'fill'=>1),
			array('width'=>"22%", 'data'=>"Reservation Name", 'border'=>"LT", 'fill'=>1),
			array('width'=>"12%", 'data'=>"Reservation Total", 'border'=>"LT", 'fill'=>1, 'align'=>"R"),
			array('width'=>"12%", 'data'=>"Received to Date", 'border'=>"LRT", 'fill'=>1, 'align'=>"R"),
			array('width'=>"12%", 'data'=>"Balance Due", 'border'=>"LT", 'fill'=>1, 'align'=>"R"),
			array('width'=>"12%", 'data'=>"Due to Date", 'border'=>"LRT", 'fill'=>1, 'align'=>"R")
		);
		$pdf->Row($headRow);

		if(sizeof($summaryArray) > 0) {
			foreach($summaryArray as $key=>$item){
				if( $item['totalBalance'] == 0 ) continue;
				$listRow = array();
				$currRow = array();

				if($agentOne == $item['pr_persona_ix']) {
					if(is_array($oldnames)) {
						if(!in_array($item['pr_name_last'],$oldnames)) {
							array_push($oldnames,$item['pr_name_last']);
							$confirmList .= "
								<tr valign=\"top\">
									<td width=\"42%\">".$item['pr_name_last']."</td>
									<td \"42%%\"><input type=\"text\" name=\"mail_to\" id=\"mail_to\" class=\"txts\" size=\"40\" value=".$agentEmail." style=\"width: 150px;\" readonly />
									<td width=\"16%\" align=\"center\">
							";
						}
					}
					if($agent !== $item['pr_persona_ix']) {
						$agent = $item['pr_persona_ix'];
						$currency = "";

						foreach($tmpFile as $tmp){
							//$pdf->Row($tmp);
						}

						array_push($listRow,
							array('width'=>"100%", 'data'=>$item['pr_name_last'], 'border'=>"LTBR", 'fill'=>1)
						);
						$pdf->Row($listRow);
					}
					$tmpFile = array();

					if($currency != $item['rv_invoice_currency_id']) {
						$currency = $item['rv_invoice_currency_id'];

						array_push($currRow,
							array('width'=>"8%", 'data'=>"", 'border'=>"R"),
							array('width'=>"8%", 'data'=>$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1),
							array('width'=>"36%", 'data'=>"", 'border'=>"TBR", 'fill'=>1),
							array('width'=>"12%", 'data'=>$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayDue']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1, 'align'=>"R"),
							array('width'=>"12%", 'data'=>$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalPayReceived']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1, 'align'=>"R"),
							array('width'=>"12%", 'data'=>$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceDue']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1, 'align'=>"R"),
							array('width'=>"12%", 'data'=>$agentTotal[$item['rv_agent_id']][$item['rf_currency_symbol']]['totalBalanceTotal']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'fill'=>1, 'align'=>"R")
						);
						$pdf->Row($currRow);
					}

					foreach($item['resItems'] as $resItem) {
						$pdf->Row(array(
							array('width'=>"16%", 'data'=>""),
							array('width'=>"14%", 'data'=>$resItem['resNum'], 'border'=>"LTBR", 'align'=>"L"),
							array('width'=>"22%", 'data'=>$resItem['resName'], 'border'=>"LTBR", 'align'=>"L"),
							array('width'=>"12%", 'data'=>$resItem['invoiceTotal']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'align'=>"R"),
							array('width'=>"12%", 'data'=>$resItem['payReceived']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'align'=>"R"),
							array('width'=>"12%", 'data'=>$resItem['balanceTotal']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'align'=>"R"),
							array('width'=>"12%", 'data'=>$resItem['balanceDue']." ".$item['rf_currency_symbol'], 'border'=>"LTBR", 'align'=>"R")
						));

						if ( $reservationSummary == "1" ) {
							foreach($resItem['dueItems'] as $dueItem) {
								$pdf->Row(array(
									array('width'=>"16%", 'data'=>""),
									array('width'=>"14%", 'data'=>$dueItem['info'], 'border'=>"LTBR", 'align'=>"R"),
									array('width'=>"22%", 'data'=>$dueItem['date'], 'border'=>"TBR", 'align'=>"R"),
									array('width'=>"12%", 'data'=>$dueItem['due']." ".$item['rf_currency_symbol'], 'border'=>"TBR", 'align'=>"R"),
									array('width'=>"36%", 'data'=>"", 'border'=>"TBR")
								));
							}
							foreach($resItem['paidItems'] as $dueItem) {
								$pdf->Row(array(
								array('width'=>"16%", 'data'=>""),
								array('width'=>"14%", 'data'=>$dueItem['info'], 'border'=>"LTBR", 'align'=>"R"),
								array('width'=>"22%", 'data'=>$dueItem['date'], 'border'=>"TBR", 'align'=>"R"),
								array('width'=>"12%", 'data'=>"", 'border'=>"LTBR"),
								array('width'=>"12%", 'data'=>$dueItem['paid']." ".$item['rf_currency_symbol'], 'border'=>"TBR", 'align'=>"R"),
								array('width'=>"24%", 'data'=>"", 'border'=>"TBR")
							    ));
							}
						}

						if($travelSummary == "1") {
							$pdf->Row(array(
								array('width'=>"16%", 'data'=>""),
								array('width'=>"84%", 'data'=>"Arrive: ".$resItem['travelArrive'], 'border'=>"LBTR")
							));
							$pdf->Row(array(
							   array('width'=>"16%", 'data'=>""),
							   array('width'=>"84%", 'data'=>"Depart: ".$resItem['travelDepart'], 'border'=>"LBTR")
							));
							$pdf->Row(array(
								array('width'=>"16%", 'data'=>""),
								array('width'=>"84%", 'data'=>"Number of properties: ".$resItem['travelProperties'], 'border'=>"LBTR")
							));
						}
					}

					if($sectionTotals == 1 && $perAgent == 1) {
						$summary = " Summary of displayed payments due to ".date("d F Y",strtotime($toDate['jsDate']))."
						For $statusStr reservations
						Property: $propertyStr
						Printed on ".date("d M Y")."";
						array_push($tmpFile,array(array('width' => "100%", 'data'=>'')));
						array_push($tmpFile,array(
							array('width'=>"16%", 'data'=>"", 'border'=>"R"),
							array('width'=>"84%", 'data'=>$summary, 'border'=>"LTBR")
						));

						array_push($tmpFile,array(
							array('width'=>"16%", 'data'=>"", 'border'=>"R"),
							array('width'=>"36%", 'data'=>" ", 'border'=>"LTB"),
							array('width'=>"12%", 'data'=>"Reservation Total", 'border'=>"LTB", 'align'=>"R"),
							array('width'=>"12%", 'data'=>"Received to Date", 'border'=>"LTB", 'align'=>"R"),
							array('width'=>"12%", 'data'=>"Balance Due", 'border'=>"LTB", 'align'=>"R"),
							array('width'=>"12%", 'data'=>"Due to Date", 'border'=>"LBTR", 'align'=>"R",'style' =>"B")
						));

						foreach($agentTotal[$item['rv_agent_id']] as $id=>$data) {
							array_push($tmpFile,array(
								array('width'=>"16%", 'data'=>"", 'border'=>"R"),
								array('width'=>"36%", 'data'=>$id, 'border'=>"LTB"),
								array('width'=>"12%", 'data'=>$data['totalPayDue']." ".$id, 'border'=>"LTB", 'align'=>"R"),
								array('width'=>"12%", 'data'=>$data['totalPayReceived']." ".$id, 'border'=>"LTB", 'align'=>"R"),
								array('width'=>"12%", 'data'=>$data['totalBalanceDue']." ".$id, 'border'=>"LTB", 'align'=>"R"),
								array('width'=>"12%", 'data'=>$data['totalBalanceTotal']." ".$id, 'border'=>"LTBR", 'align'=>"R", 'style' => "B")
							));
						}

						array_push($tmpFile,array(array('width'=>"100%", 'data'=>'')));

						if($tmpCounter == count($summaryArray)){
							foreach($tmpFile as $tmp){
								$pdf->Row($tmp);
							}
							$tmpFile = array();
						}
					}
				}
				$tmpCounter++;

			}
		} else {		    
			$pdf->Row(array(
				array('width'=>"100%", 'data'=>"No records found", 'border'=>"LTBR",'align'=>"C",'style'=>"I")
			));
		}

		foreach($tmpFile as $tmp) {
			$pdf->Row($tmp);
		}
		$pdf->Row(array(array('width'=>"100%", 'data'=>'')));

		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}

		$userId = $_SESSION['userid'];

		$GLOBALS['temp']['emailFrom'] = $lDB->get("
			SELECT
				pr_persona.pr_email
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix = '$userId'
		",4);
		
		$to = $agentEmail;
		$from = $GLOBALS['temp']['emailFrom'];
		$subject = $_POST['mail_subj'];
		$message = $_POST['mail_body'];
		$attachmentName = "Payments due Report - due to: " . $toDate['htmlDate'].".pdf";
		//$attachmentName = "Payments_due_Report_due_to_".$toDate['htmlDate'].".pdf";
		$headers = "From: ".(isset($GLOBALS['princName']) ? $GLOBALS['princName'] : "")."<$from>\r\n";
		
		// close the pdf
		if($pdf->state<3) $pdf->Close();

		/* and now mail it */
		if($attachmentName != "!attachmentName!") {
			$pdfName = $attachmentName;
		} else {
			$pdfName = "Update report from ".$fromDate." to ".$toDate.".pdf";
		}

		$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], (isset($GLOBALS['princName']) ? $GLOBALS['princName'] : ""),$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			
		if(!$error) {
			$confirmList.= "Sent";
		} else {
			$confirmList.= "<a href='#' onclick=\"openMessage('Message send to  ".$to." failed due to error.')\">Failed</a>";
		}
		$confirmList.= "</td></tr>";
	}
	$confirmList.= "</table>";
	
	$GLOBALS[$form]->FormHTML =
		str_replace("!formAction!",(isset($formAction) ? $formAction: ""),
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!recipients!",$confirmList,
		str_replace("!emailSubject!",$pdfName,
		Join("", file(__DIR__ . "/../../../public/html/email_agents_confirm_popup.htm"))))));

}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
