<?php

/*
 * $Id: init.form260.php,v 1.17 2013-04-25 13:07:21 light Exp $
 *
 * $Log: init.form260.php,v $
 * Revision 1.17  2013-04-25 13:07:21  light
 * Bug #8241 - Master / slave switch connectivity check
 *
 * Revision 1.16  2011-05-17 14:08:27  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.15  2009-01-13 14:49:02  light
 * Bug #6538 - [DB] Profile enhancements
 *
 * Revision 1.14  2007-09-10 14:02:24  light
 * Bug #6101 - Slave/Master toggle alert spell error
 *
 * Revision 1.13  2007-03-15 13:57:06  gregs
 * Bug #5745 - Slave/master successful display message
 *
 *
 */

/**
 * init.form260.func.php - Master/slave status change functions
 * Job: 701, 702, 703, 704
 * Function: 75 (DB Status Change)
 */

// Backup the master setting of the database ----------------------------------
$tempMasterData = $GLOBALS['lDB']->isMaster;

// Always set the database to master so it can run updates for this page ------
$lDB->isMaster = "1";
global $system; // to check for demo/training/etc

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/db_status_change.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$sysPrincipalId = $GLOBALS['principal_id'];

while ( $sysPrincipalId[0] == "0" ) {
	$sysPrincipalId = substr($sysPrincipalId,1);
}

$db_master_id = $lDB->get("select rf_sys_db_master_id from rf_system",4);

$cDB = new MySQLDB("censys","root","",$_SESSION['dbHost']);

$environmentId = $lDB->get("select rf_database_id from rf_database where rf_db_code = '" . $GLOBALS['dbcode'] . "'",4);
$prinShort	= $cDB->get("select censys.cn_principal.cn_prn_name_short from censys.cn_principal where censys.cn_principal.cn_principal_id = '".$sysPrincipalId."'",4);

$lDB->select();

$resOffice = false;

if ( $GLOBALS['dbcode'][0] == "R" ) {
	$resOffice = true;
}

$master			= isMasterDB("1");
$status			= "slave";
$confirmed	= $_SERVER['argv'][3];
global $system;

if ( $confirmed == "1" ) {
	cacheClear();
}

$arg = "1";

switch ($_SERVER['argv'][0]) {
	case 701:
		// Verify that this is not a training system ------------------------------
		if ( $system == "training" ) {
			$error = "This function can not be performed on a training system";
			exit_buttons();
			break;
		}

		// Verify that this is the reservations office ------------------------------
		if ( !$resOffice ) {
			$error = "This function can only be performed at the Reservations Office";
			exit_buttons();
			break;
		}

		// Test for internet connection - if none, prompt to connect. ---------------
		if ( !test_online() ) {
			$error = "Please connect to the internet and try again";
			if ( $confirmed != "1" ) {
				$arg = "0";
			}
			break;
		}

		// If not confirmed, prompt confirmation ------------------------------------
		if ( !$confirmed ) {
			$error = "Are you sure you want to set the Web system as the master?";
			break;
		}

		// Update resoffice master_db_id = web_db_id --------------------------------
		$lDB->put("update rf_system set rf_sys_db_master_id = rf_sys_db_web_id");

		// Update db_master_date_changed = now() ------------------------------------
		$lDB->put("
			UPDATE
				censys.cn_principal
			SET
				censys.cn_principal.cn_prn_db_master_date_chg = '" . date("Y-m-d H:i:s") . "'
			WHERE
				censys.cn_principal.cn_principal_id = '" . $sysPrincipalId . "'
		");

		// Insert into ad_db_status -------------------------------------------------
		$lDB->put("INSERT INTO ad_db_status (ad_db_status_db,ad_db_start,ad_db_start_tz,ad_db_function_ind,ad_db_user_id) VALUES ('" . $dbcode . "','" . date("Y-m-d H:i:s") . "','" . date("e") . "','2','" . $GLOBALS['userid'] . "')");

		$ad_db_status_id = $GLOBALS['lDB']->insert_id;

		$web_server = $prinShort.".".$GLOBALS["DTremoteHost".$GLOBALS['remoteDbCode']];

		if ( $_SESSION['system'] == "upgrade" ) {
			$web_server = "upgrade." . $web_server;
		}

		// Trigger web db_master_id = web_db_id (master_date_changed) ---------------
		$remote_job_address = $GLOBALS['http'] . $web_server . "/reservation.php?127+" . $GLOBALS['userid'] . "+4";

		$geturl = fopen($remote_job_address, "r");

		if ( $geturl == false ) {
			$error = "Connection failed.<br />\nReservations office set to slave, web status unknown. Please try again.";
		} else {
			$result = trim(fread($geturl,4096));
			if ( $result == "!TRUE!" ) {
				// Update ad_db, error = �success� ----------------------------------------
				$lDB->put("UPDATE ad_db_status SET ad_db_end = '" . date("Y-m-d H:i:s") . "', ad_db_end_tz = '" . date("e") . "' WHERE ad_db_status_ix = '" . $ad_db_status_id . "'");

				$error = "Database change successful.<br />\nReservations office set to slave, web set to master.";
			} else {
				$error = "Database change failed.<br />\nReservations office set to slave, web status unknown. Please try again.";
			}
		}
		exit_buttons();
		break;

	case 702:
		// Verify that this is not a training system ------------------------------
		if ( $system == "training" ) {
			$error = "This function can not be performed on a training system";
			exit_buttons();
			break;
		}

		// Verify that this is the reservations office ------------------------------
		if (!$resOffice) {
			$error = "This function can only be performed at the Reservations Office";
			exit_buttons();
			break;
		}

		// Test for internet connection - if none, prompt to connect ----------------
		if ( !test_online() ) {
			$error = "Please connect to the internet and try again";
			if ( $confirmed != "1" ) {
				$arg = "0";
			}
			break;
		}

		// If not confirmed, prompt confirmation ------------------------------------
		if ( !$confirmed ) {
			$error = "Are you sure you want to set the Reservations Office system as the master?";
			break;
		}

		// Insert into ad_db_status -------------------------------------------------
		$sql = "insert into ad_db_status (ad_db_status_db,ad_db_start,ad_db_start_tz,ad_db_function_ind,ad_db_user_id) values ('".$dbcode."','".date("Y-m-d H:i:s")."','".date("e")."','4','".$GLOBALS['userid']."')";
		$lDB->put($sql);
		$ad_db_status_id = $GLOBALS['lDB']->insert_id;

		$web_server = $prinShort.".".$GLOBALS["DTremoteHost".$GLOBALS['remoteDbCode']];

		if ( $_SESSION['system'] == "upgrade" ) {
			$web_server = "upgrade.".$web_server;
		}

		// Trigger web db_master_id = web_db_id (master_date_changed) ---------------
		$remote_job_address = $GLOBALS['http'] . $web_server . "/reservation.php?127+" . $GLOBALS['userid'] . "+3+" . $environmentId;

		$geturl = fopen($remote_job_address, "r");

		if ( $geturl == false ) {
			$error = "Connection failed.<br />\nReservations office set to slave, web status unknown. Please try again.";
		} else {
			$result = trim(fread($geturl,4096));
			if ($result == "!TRUE!") {
				// update ad_db, error = �success�
				// update resoffice master_db_id = web_db_id
				$lDB->put("UPDATE rf_system SET rf_sys_db_master_id = '" . $environmentId . "'");

				// update db_master_date_changed = now()
				$lDB->put("UPDATE censys.cn_principal SET censys.cn_principal.cn_prn_db_master_date_chg = '" . date("Y-m-d H:i:s") . "' WHERE censys.cn_principal.cn_principal_id = '" . $sysPrincipalId . "'");

				$lDB->put("UPDATE ad_db_status SET ad_db_end = '".date("Y-m-d H:i:s")."',ad_db_end_tz = '".date("e")."' WHERE ad_db_status_ix = '" . $ad_db_status_id . "'");
				$error = "Database change successful.<br />\nWeb set to slave, Reservations office set to master.";
			} elseif ( strpos($result,"!DENIED!") !== false ) {
				$tmp = explode("!DENIED!",$result);
				$masterId = $tmp[1];
				$masterName = $lDB->get("SELECT rf_db_description FROM rf_database WHERE rf_database_id = '" . $masterId . "'",4);
				$error = "Function not permitted because the web system does not hold master status. It is held by '" . $masterName . "'";
			} else {
				$error = "Database change failed.<br />\nWeb status unknown, Reservations office status unchanged. Please try again.";
			}
		}
		exit_buttons();
		break;

	case 703:
		// Verify that this is not a training system ------------------------------
		if ( $system == "training" ) {
			$error = "This function can not be performed on a training system";
			exit_buttons();
			break;
		}

		// Verify if this is not a training system
		if ($system == "training") {
			$error = "This function can only be performed on non-training systems";
			exit_buttons();
			break;
		}

		if ( !$master ) {
			$error = "System is already set to slave, unable to complete 'Force Slave'.";
			exit_buttons();
			break;
		}

		if ( !$confirmed ) {
			$error = "This is a unilateral setting. It could result in both the Web and Reservations systems holding slave status. You have to manually ensure that this situation does not arise. Are you sure you want to proceed?";
			break;
		}

		$sql = "INSERT INTO ad_db_status (ad_db_status_db,ad_db_start,ad_db_start_tz,ad_db_function_ind,ad_db_user_id) VALUES ('" . $dbcode . "','" . date("Y-m-d H:i:s") . "','" . date("e") . "','6','" . $GLOBALS['userid'] . "')";
		$lDB->put($sql);
		$ad_db_status_id = $GLOBALS['lDB']->insert_id;

		if ( $resOffice ) {
			$lDB->put("UPDATE rf_system SET rf_sys_db_master_id = rf_sys_db_web_id");
		} else {
			$lDB->put("update rf_system set rf_sys_db_master_id = '1'");
		}

		$lDB->put("UPDATE ad_db_status SET ad_db_end = '" . date("Y-m-d H:i:s") . "',ad_db_end_tz = '" . date("e") . "' WHERE ad_db_status_ix = '" . $ad_db_status_id . "'");
		$error = "Force slave successful.";

		echo "<script>\n" . 'menu_system = "' . str_replace('"','\\"',str_replace("\n","",generateMenu())).'";opener.eval(menu_system);</script>';
		exit_buttons();
		break;

	case 704:

		// Verify if this is not a training system
		if ($system == "training") {
			$error = "This function can only be performed on non-training systems";
			exit_buttons();
			break;
		}

		// Verify that this is not a training system ------------------------------
		if ( $system == "training" ) {
			$error = "This function can not be performed on a training system";
			exit_buttons();
			break;
		}

		if ( $master ) {
			$error = "System is already set to master, unable to complete 'Force Master'.";
			exit_buttons();
			break;
		}

		if ( !$confirmed ) {
			$error = "This is a unilateral setting. It could result in both the Web and Reservations systems holding master status and thus compromise database integrity. You have to manually ensure that this situation does not arise. Are you sure you want to proceed?";
			break;
		}

		$lDB->put("INSERT INTO ad_db_status (ad_db_status_db,ad_db_start,ad_db_start_tz,ad_db_function_ind,ad_db_user_id) VALUES ('" . $dbcode . "','" . date("Y-m-d H:i:s") . "','" . date("e") . "','8','" . $GLOBALS['userid'] . "')");
		$ad_db_status_id = $GLOBALS['lDB']->insert_id;

		$lDB->put("UPDATE rf_system SET rf_sys_db_master_id = '" . $environmentId . "'");

		$lDB->put("UPDATE ad_db_status SET ad_db_end = '" . date("Y-m-d H:i:s") . "',ad_db_end_tz = '" . date("e") . "' WHERE ad_db_status_ix = '" . $ad_db_status_id . "'");
		$error = "Force master succesful.";

		echo "<script>\n".'menu_system = "' . str_replace('"','\\"',str_replace("\n","",generateMenu())).'";opener.eval(menu_system);</script>';
		exit_buttons();
		break;
}

// Update server status display -----------------------------------------------
if ( isMasterDB("1") ) {
	$status = "master";
}

$GLOBALS['tagList']['status'] = "\nsetStatus('" . $status . "');\n";

// Display result message -----------------------------------------------------
$GLOBALS['tagList']['message'] = $error;

// Write the job out to the screen --------------------------------------------
$GLOBALS['tagList']['variables'] = "\narg = \"" . $arg . "\";\njob = \"" . $_SERVER['argv'][0] . "\";\n";

// Restore the master setting to the database ---------------------------------
$GLOBALS['lDB']->isMaster = $tempMasterData;


function test_online() {
	// Connect to client.resrequest.com ---------------------------------------------
	$resrequest = fopen($GLOBALS['http'].$GLOBALS['principal_name_short'].".".$GLOBALS["DTremoteHost".$GLOBALS['remoteDbCode']],"rb");
	if ( $resrequest !== false ) {
		return 1;
	} else {
		// Connect to www.google.com ------------------------------------------------
		$google = fopen("http://www.google.com","rb");
		if ( $google !== false ) {
			return 0;
		}
	}
}

function exit_buttons() {
	$GLOBALS['tagList']['proceed']	= blankObject();
	$GLOBALS['tagList']['cancel']	= "Close";
}
