<?php

/**
 * init.form261.php - Component Analysis
 * Job: 709
 * Function: 76 (Reports Financials: Rev, Comp, Folio/Inv)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("component_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Component Analysis";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_component.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],14,"");

$fromDate = useDate("from", $_SERVER['argv'][1]);
$toDate = useDate("to", $_SERVER['argv'][2]);

$propertyACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id 
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		sc_accomm.sc_group_id= '$GLOBALS[sc_group_id]'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = 0
		AND pr_business.pr_bus_inactive_yn= '0'
",3);

$statusACL = $lDB->get("
	SELECT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id <> 25
		AND rf_reservation_status_id <> 15
		AND rf_reservation_status_id <> 97
",3);
				
$propertiesFilter = useFilter("properties",$_SERVER['argv'][3],"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","pr_persona.pr_persona_ix",$propertyACL,false,false);

if($_SERVER['argv'][4] == "" && $_SERVER['argv'][1] == "") {
	$_SERVER['argv'][4] = "30";
}
$statusFilter = useFilter("status",$_SERVER['argv'][4],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);

$componentsFilter = useFilter("components",$_SERVER['argv'][5],"SELECT rt_component.rt_component_desc FROM rt_component WHERE rt_component.rt_component_ix =","rt_component.rt_component_ix",false,false,false);

$currenciesFilter = useFilter("currencies",$_SERVER['argv'][6],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","rv_reservation.rv_invoice_currency_id",false,false,false);

$agentWhere = "";
if($userStatusId < 2) {
	$agentWhere = " AND rv_reservation.rv_agent_id = '$calAgentId' ";
}       

$levelId = trim($_SERVER['argv'][7]);
if($levelId == "" || $levelId == 0) {
	$levelId = LEVEL_COMPONENT;
}

$folioCheck = $_SERVER['argv'][8];
if(trim($folioCheck) == "") { $folioCheck = "0"; }
$invoiceCheck = $_SERVER['argv'][9];
if(trim($invoiceCheck) == "") { $invoiceCheck = "0"; }
$invoiceFilter = "";
if($folioCheck == "0" && $invoiceCheck == "0") { // Invoice filter default
	$folioCheck = "1";
	$invoiceCheck = "1";
}
if($folioCheck == "1" && $invoiceCheck == "0") { // Uninvoiced folios only
	$invoiceFilter = "
		AND fn_invoice.fn_invoice_ix IS NULL
	";
}
if($folioCheck == "0" && $invoiceCheck == "1") { // Invoiced folios only
	$invoiceFilter = "
		AND fn_invoice.fn_invoice_ix IS NOT NULL
	";
}

$removeEmpty = $_SERVER['argv'][10];
$GLOBALS['temp']['removeEmpty'] = "";
if($removeEmpty == "1") {
	$GLOBALS['temp']['removeEmpty'] = "checked";
}

$GLOBALS['temp']['folioChecked'] = "";
if($folioCheck == "1") {
	$GLOBALS['temp']['folioChecked'] = "checked";
}
$GLOBALS['temp']['invoiceChecked'] = "";
if($invoiceCheck == "1") {
	$GLOBALS['temp']['invoiceChecked'] = "checked";	
}

$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");


// BUG #5484 : ----------------------------------------------------------------
// Reports to hide filters by default
$filterDivClass = $_SERVER['argv'][11];
$showHideButtonText = $_SERVER['argv'][12];

$GLOBALS['temp']['filterDivClass'] = urldecode($filterDivClass);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterDivClass == ""){
	$GLOBALS['temp']['filterDivClass'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterDivClass == "") {
		$GLOBALS['temp']['filterDivClass'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// BUG #5484 : END ------------------------------------------------------------

$renderOption = $_SERVER['argv'][13];
$GLOBALS['temp']['compRadio'] = "";
$GLOBLAS['temp']['compPropRadio'] = "";
$GLOBALS['temp']['agentCompRadio'] = "";
$GLOBALS['temp']['propCompRadio'] = "";
$GLOBALS['temp']['level1'] = "";
$GLOBALS['temp']['level2'] = "";

$sqlFromComponent = "
	rt_component
";
$sqlFromProperty = "
	pr_persona
	INNER JOIN pr_business ON pr_persona.pr_persona_ix = pr_business.pr_business_id
	INNER JOIN ac_accomm_type ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
";
$sqlFromAgent = "
	pr_agent
	INNER JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = pr_agent.pr_agent_id
";
$sqlFrom = array();

$level2 = "";
if($levelId == LEVEL_COMPONENT || $levelId == LEVEL_COMPONENT_PROPERTY) {
	$level1 = "component";
	$level1Select = "
		rt_component.rt_component_ix as level1Id,
		rt_component.rt_component_desc as level1Name
	";
	$level1Where = " rv_res_item_comp.rt_component_id = ";
	array_push($sqlFrom,$sqlFromComponent);
	$sqlOrder = " rt_component.rt_component_desc ";
	$GLOBALS['temp']['level1'] = "Component";
}

if($levelId == LEVEL_COMPONENT) {
	$level2Select = "
		'' AS level2Id,
		'' AS level2Name
	";
	$GLOBALS['temp']['level2'] = "&nbsp;";  
	$GLOBALS['temp']['compRadio'] = "checked";
}

if($levelId == LEVEL_COMPONENT_PROPERTY) {
	$level2 = "property";
	$level2Select = "
		pr_persona.pr_persona_ix as level2Id,
		pr_persona.pr_name_last as level2Name
	";
	$level2Where = " ac_accomm_type.pr_business_id = ";
	array_push($sqlFrom,$sqlFromProperty);
	$sqlOrder .= " ,pr_persona.pr_name_last ";
	$GLOBALS['temp']['level2'] = "Property";    
	$GLOBALS['temp']['compPropRadio'] = "checked";
}

if($levelId == LEVEL_PROPERTY_COMPONENT || $levelId == LEVEL_AGENT_COMPONENT) {
	$level2 = "component";
	$level2Select = "
		rt_component.rt_component_ix as level2Id,
		rt_component.rt_component_desc as level2Name
	";
	$level2Where = " rv_res_item_comp.rt_component_id = ";
	array_push($sqlFrom,$sqlFromComponent);
	$sqlOrder = ", rt_component.rt_component_desc ";
	$GLOBALS['temp']['level2'] = "Component";    
}
if($levelId == LEVEL_PROPERTY_COMPONENT) {
	$level1 = "property";
	$level1Select = "
		pr_persona.pr_persona_ix as level1Id,
		pr_persona.pr_name_last as level1Name
	";
	$level1Where = " ac_accomm_type.pr_business_id = ";
	array_unshift($sqlFrom,$sqlFromProperty);
	$sqlOrder = " pr_persona.pr_name_last $sqlOrder";
	$GLOBALS['temp']['level1'] = "Property";
	$GLOBALS['temp']['propCompRadio'] = "checked";
}

if($levelId == LEVEL_AGENT_COMPONENT) {
	$level1 = "agent";
	$level1Select = "
		agent_persona.pr_persona_ix as level1Id,
		agent_persona.pr_name_last as level1Name
	";
	$level1Where = " rv_reservation.rv_agent_id = ";
	array_unshift($sqlFrom,$sqlFromAgent);
	$sqlOrder = " agent_persona.pr_name_last $sqlOrder";
	$GLOBALS['temp']['level1'] = "Agent";
	$GLOBALS['temp']['agentCompRadio'] = "checked";
}
$sqlSelect = "$level1Select, $level2Select";
$sqlFrom = join(",",$sqlFrom);

if($_SERVER['argv'][1] != "" && $_SERVER['argv'][2] != "") {
	if($renderOption == 0) { //HTML render
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
	}

	$rowHTML = Join("", file(__DIR__ . "/../../../public/html/rep_component_row.htm"));
	$totalRowHTML = Join("", file(__DIR__ . "/../../../public/html/rep_component_total_row.htm"));

	$outerList = $lDB->get("
		SELECT DISTINCT
			$sqlSelect
		FROM
			$sqlFrom
		WHERE
			1
			$componentsFilter[where]
			".(($levelId == LEVEL_COMPONENT_PROPERTY || $levelId == LEVEL_PROPERTY_COMPONENT)?$propertiesFilter['where']:"")."
		ORDER BY
			$sqlOrder
	",6);
	if($levelId == LEVEL_AGENT_COMPONENT) {
		$components = $lDB->get("
			SELECT
				rt_component_ix,
				rt_component_desc
			FROM
				rt_component
			WHERE
				1
				$componentsFilter[where]
		",6);
		foreach($components as $component) {
			array_push($outerList,array(
				'level1Id'=>"",
				'level1Name'=>"Direct",
				'level2Id'=>$component['rt_component_ix'],
				'level2Name'=>$component['rt_component_desc']
			));
		}
	}

	$innerList = $lDB->get("
		SELECT
			$sqlSelect,
			(rv_reservation_item.rv_item_adult_count * rv_reservation_item.rv_item_accomm_count) AS adults,
			(rv_reservation_item.rv_item_child_count * rv_reservation_item.rv_item_accomm_count) AS children,
			(rv_reservation_item.rv_item_adult_count * rv_reservation_item.rv_item_accomm_count * (TO_DAYS(rv_reservation_item.rv_item_date_depart) - TO_DAYS(rv_reservation_item.rv_item_date_arrive))) AS AdultBedNights,
			(rv_reservation_item.rv_item_child_count * rv_reservation_item.rv_item_accomm_count * (TO_DAYS(rv_reservation_item.rv_item_date_depart) - TO_DAYS(rv_reservation_item.rv_item_date_arrive))) AS ChildBedNights,
			(rv_res_item_comp.rv_item_comp_amt_tax) as tax,
			(rv_res_item_comp.rv_item_comp_amt_payable) as payable,
			rf_currency.rf_currency_symbol,
			rv_reservation.rv_invoice_currency_id
		FROM
			rv_res_item_comp
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = rv_reservation_item.fn_folio_id AND fn_invoice.fn_inv_status_ind <> 8
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
			LEFT JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = rv_reservation.rv_agent_id
			INNER JOIN ac_accomm_type ON rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			INNER JOIN rf_currency ON rv_reservation.rv_invoice_currency_id = rf_currency.rf_currency_ix
			INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
		WHERE
			rv_reservation_item.rv_item_amt_gross IS NOT NULL
			AND (
				(
					fn_invoice.fn_invoice_ix IS NULL
					AND fn_folio.fn_folio_date BETWEEN '$fromDate[jsDate]' AND '$toDate[jsDate]'
				) OR (
					fn_invoice.fn_invoice_ix IS NOT NULL
					AND fn_invoice.fn_inv_date BETWEEN '$fromDate[jsDate]' AND '$toDate[jsDate]'
				)
			)
			$componentsFilter[where]
			$propertiesFilter[where]
			$statusFilter[where]
			$currenciesFilter[where]
			$agentWhere
			$invoiceFilter
	",6);
	$newInnerList = array();
	$aggregates = array('adults','children','AdultBedNights','ChildBedNights','tax','payable');
	foreach($innerList as $item) {
		$key = $item['level1Id'] . "_" . $item['level2Id'];
		$currencyKey = $item['rv_invoice_currency_id'];
		if(!array_key_exists($key,$newInnerList)) {
			$newInnerList[$key] = array();
		}
		if(!array_key_exists($currencyKey,$newInnerList[$key])) {
			$newInnerList[$key][$currencyKey] = $item;
		} else {
			foreach($aggregates as $aggregate) {
				$newInnerList[$key][$currencyKey][$aggregate] += $item[$aggregate];
			}
		}
	}
	$innerList = $newInnerList;
	unset($newInnerList);

	$reportArray = array();
	$level1Name = null;
	$level2Name = null;
	$totals = array();
	foreach($outerList as $item) {
		if($level1Name !== $item['level1Name']) {
			$level1Name = $item['level1Name'];
			$reportArray[$level1Name] = array();
			$reportArray[$level1Name]['id'] = $item['level1Id'];
		}
		if($level2Name != $item['level2Name']) {
			$level2Name = $item['level2Name'];
			$reportArray[$level1Name][$level2Name] = array();
			$reportArray[$level1Name][$level2Name]['id'] = $item['level2Id'];
		}

		$finalLevel1Where = "$level1Where '$item[level1Id]'";
		if($levelId == 4 && empty($item['level1Id'])) {
			$finalLevel1Where = "agent_persona.pr_persona_ix IS NULL";
		}

		$paxA = 0; $paxC = 0;
		$bnA = 0; $bnC = 0;
		$key = $item['level1Id'] . "_" . $item['level2Id'];
		if(array_key_exists($key,$innerList)) {
			foreach($innerList[$key] as $currencyItem) {
				$total = db_round($currencyItem['payable'],2);
				$exclVat = db_round($total-$currencyItem['tax'],2);
				$currencyItem['tax'] = db_round($currencyItem['tax'],2);

				if($level2 == "") {
					$totalId = "";
					$totalName = "";
				} else {
					$totalId = $item['level1Id'];
					$totalName = $level1Name;
				}
				if(!array_key_exists($totalId,$totals)) {
					$totals[$totalId] = array(
						'name' => $totalName,
						'currencyTotals' => array()
					);
				}
				if(!array_key_exists($currencyItem['rf_currency_symbol'],$totals[$totalId]['currencyTotals'])) {
					$totals[$totalId]['currencyTotals'][$currencyItem['rf_currency_symbol']] = array(
						"excl" => $exclVat,
						"vat" => $currencyItem['tax'],
						"incl" => $total
					); 
				} else {
					$totals[$totalId]['currencyTotals'][$currencyItem['rf_currency_symbol']]['excl'] += $exclVat;
					$totals[$totalId]['currencyTotals'][$currencyItem['rf_currency_symbol']]['vat'] += $currencyItem['tax'];
					$totals[$totalId]['currencyTotals'][$currencyItem['rf_currency_symbol']]['incl'] += $total;
				}
				fixAmtDisplay($total);
				fixAmtDisplay($exclVat);

				$reportArray[$level1Name][$level2Name][$currencyItem['rf_currency_symbol']] = array();
				$reportArray[$level1Name][$level2Name][$currencyItem['rf_currency_symbol']]['id'] = $currencyItem['rv_invoice_currency_id'];
				$reportArray[$level1Name][$level2Name][$currencyItem['rf_currency_symbol']]['exclVat'] = $exclVat;
				$reportArray[$level1Name][$level2Name][$currencyItem['rf_currency_symbol']]['vat'] = $currencyItem['tax'];
				$reportArray[$level1Name][$level2Name][$currencyItem['rf_currency_symbol']]['inclVat'] = $total;
				$paxA += $currencyItem['adults'];
				$paxC += $currencyItem['children'];
				$bnA += $currencyItem['AdultBedNights'];
				$bnC += $currencyItem['ChildBedNights'];
			}
		}
		$reportArray[$level1Name][$level2Name]['adultCount'] = $paxA;
		$reportArray[$level1Name][$level2Name]['childCount'] = $paxC;
		$reportArray[$level1Name][$level2Name]['adultBedNight'] = $bnA;
		$reportArray[$level1Name][$level2Name]['childBedNight'] = $bnC;
	}

	if($removeEmpty == "1") {
		$newReportArray = array();
		foreach($reportArray as $key1=>$level1) {
			if(sizeof($level1) > 1) {
				$newLevel1 = array('id'=>$level1['id']);
				$checkLevel2 = false;
				foreach($level1 as $key2=>$level2) {
					if(!is_array($level2)) {
						continue;
					}
					$checkLevel3 = false;
					foreach($level2 as $level3) {
						if(is_array($level3)) {
							$checkLevel3 = true;
						}
					}
					if(sizeof($level2) > 1 && $checkLevel3) {
						$newLevel1[$key2] = $level2;
						$checkLevel2 = true;
					}
				}
				if($checkLevel2) {
					$newReportArray[$key1] = $newLevel1;
				}
			}
		}
		$reportArray = $newReportArray;
	}

	$rows = "";
	if($renderOption == 0) { //HTML render
		foreach($reportArray as $level1Key=>$level1Item) {
			$level2First = true;
			foreach($level1Item as $level2Key=>$level2Item) {
				if(!is_array($level2Item)) {
					continue;
				}
				if($level2First) {
					$level2First = false;
					$level1Name = $level1Key;
				} else {
					$level1Name = "&nbsp;";
				}
				$currencyFirst = true;
				foreach($level2Item as $currencyKey=>$currencyItem) {
					if(!is_array($currencyItem)) {
						continue;
					}
					if($currencyFirst) {
						$level2Name = $level2Key;
						$level2PaxA = $level2Item['adultCount'];
						$level2PaxC = $level2Item['childCount'];
						$level2BedNightA = $level2Item['adultBedNight'];
						$level2BedNightC = $level2Item['childBedNight'];
						$level2First = false;
						$currencyFirst = false;
					} else {
						$level1Name = "&nbsp;";
						$level2Name = "&nbsp;";
						$level2PaxA = "&nbsp;";
						$level2PaxC = "&nbsp;";
						$level2BedNightA = "&nbsp;";
						$level2BedNightC = "&nbsp;";
					}
					$rows .= 
						str_replace("!level1!",$level1Name,
						str_replace("!level2!",$level2Name,
						str_replace("!level1Id!",$level1Item['id'],
						str_replace("!level2Id!",(isset($level2Item['id']) ? $level2Item['id'] : ""),
						str_replace("!level3Id!",$currencyItem['id'],
						str_replace("!currency!",$currencyKey,
						str_replace("!exclVat!",$currencyItem['exclVat'],
						str_replace("!vat!",$currencyItem['vat'],
						str_replace("!inclVat!",$currencyItem['inclVat'],
						str_replace("!paxA!",$level2PaxA,
						str_replace("!paxC!",$level2PaxC,
						str_replace("!bedNightA!",$level2BedNightA,
						str_replace("!bedNightC!",$level2BedNightC,$rowHTML)))))))))))));
				}
				if($currencyFirst) {
					$rows .= 
						str_replace("!level1!",$level1Name,
						str_replace("!level2!",$level2Key,
						str_replace("!level1Id!",$level1Item['id'],
						str_replace("!level2Id!",(isset($level2Item['id']) ? $level2Item['id'] : ""),
						str_replace("!level3Id!","",
						str_replace("!currency!","&nbsp;",
						str_replace("!exclVat!","&nbsp;",
						str_replace("!vat!","&nbsp;",
						str_replace("!inclVat!","&nbsp;",
						str_replace("!paxA!",$level2Item['adultCount'],
						str_replace("!paxC!",$level2Item['childCount'],
						str_replace("!bedNightA!",$level2Item['adultBedNight'],
						str_replace("!bedNightC!",$level2Item['childBedNight'],$rowHTML)))))))))))));
				}
			}
			if($level2First) {
				$rows .= 
					str_replace("!level1!",$level1Key,
					str_replace("!level2!","&nbsp;",
					str_replace("!paxA!","&nbsp;",
					str_replace("!paxC!","&nbsp;",
					str_replace("!bedNightA!","&nbsp;",
					str_replace("!bedNightC!","&nbsp;",
					str_replace("!currency!","&nbsp;",
					str_replace("!exclVat!","&nbsp;",
					str_replace("!vat!","&nbsp;",
					str_replace("!inclVat!","&nbsp;",
					str_replace("!level1Id!",$level1Item['id'],
					str_replace("!level2Id!","",
					str_replace("!level3Id!","",$rowHTML)))))))))))));
			}
		}
		$firstOuter = true;
		foreach($totals as $totalId => $totalItem) {
			$firstInner = true;
			foreach($totalItem['currencyTotals'] as $currencySymbol => $currencyItem) {
				if($firstOuter) {
					$level1 = "Totals";
					$totalClass = "bt";
				} else {
					$level1 = "&nbsp;";
					$totalClass = "";
				}
				if($firstInner) {
					$level2 = $totalItem['name'];
				} else {
					$level2 = "&nbsp;";
				}
				fixAmtDisplay($currencyItem['excl']);
				fixAmtDisplay($currencyItem['vat']);
				fixAmtDisplay($currencyItem['incl']);
				$rows .= 
					str_replace("!level1!",$level1,
					str_replace("!level2!",$level2,
					str_replace("!currency!",$currencySymbol,
					str_replace("!exclVat!",$currencyItem['excl'],
					str_replace("!vat!",$currencyItem['vat'],
					str_replace("!inclVat!",$currencyItem['incl'],
					str_replace("!totalClass!",$totalClass,$totalRowHTML)))))));
				$firstOuter = false;
				$firstInner = false;
			}
		}
	}

	if($renderOption == 4) { // csv
		$csvFile = array();
		array_push($csvFile,array("Component report"));
		array_push($csvFile,array());
		array_push($csvFile,array("Date range",$fromDate['htmlDate'] . " to " . $toDate['htmlDate']));
		array_push($csvFile,array("Property:",$propertiesFilter['names']));
		array_push($csvFile,array("Status:",$statusFilter['names']));
		array_push($csvFile,array("Component:",$componentsFilter['names']));
		array_push($csvFile,array("Currency:",$currenciesFilter['names']));
		array_push($csvFile,array());
		array_push($csvFile,array(
			"Level 1", "Level 2", "Pax (Adult)", "Pax (Child)", "Bednights (Adult)", "Bednights (Child)",
			"Currency", "Excl VAT", "VAT", "Incl VAT"
		));
		foreach($reportArray as $level1Key=>$level1Item) {
			foreach($level1Item as $level2Key=>$level2Item) {
				if(!is_array($level2Item)) {
					continue;
				}
				array_push($csvFile,array(
					$level1Key,
					$level2Key,
					$level2Item['adultCount'],
					$level2Item['childCount'],
					$level2Item['adultBedNight'],
					$level2Item['childBedNight'],
				));
				
				foreach($level2Item as $currencyKey=>$currencyItem) {
					if(!is_array($currencyItem)) {
						continue;
					}
					array_push($csvFile,array(
						$level1Key,
						$level2Key,
						"",
						"",
						"",
						"",
						$currencyKey,
						$currencyItem['exclVat'],
						$currencyItem['vat'],
						$currencyItem['inclVat']					
					));
				}
			}
		}
		foreach($totals as $totalId => $totalItem) {
			foreach($totalItem['currencyTotals'] as $currencySymbol => $currencyItem) {
				array_push($csvFile,array(
					"Totals",
					$totalItem['name'],
					"",
					"",
					"",
					"",
					$currencySymbol,
					$currencyItem['excl'],
					$currencyItem['vat'],
					$currencyItem['incl']
				));
			}
		}
		
		csv_output("component_".$fromDate['htmlDate']."_to_".$toDate['htmlDate'],$csvFile);
	}

	$GLOBALS['temp']['rows'] = $rows;
	$GLOBALS['temp']['reportGenerate'] = "";

} else {
	$GLOBALS['temp']['reportGenerate'] = "class=\"collapse\"";
}
$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
