<?php

/**
 * init.form263.php - Extras availability popup
 * Job: 711
 * Function: 52 (Reservation: Tabs)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_extras_pop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

// Get parameters
$extraId = $_SERVER['argv'][1];
$date = $_SERVER['argv'][2];
$propertyId = $_SERVER['argv'][3];
$reservationId = $_SERVER['argv'][4];

// Validate range
if($date == "" || $date == "0000-00-00" || $date == "0") {
	if(empty($reservationId)) { 
		// Set default date - POS Code tables have no dates nor reservations
		$fromDate = date("Y-m-d");
		$toDate = date("Y-m-d");
	} else {
	$dates = $lDB->get("SELECT rv_date_arrive, rv_date_depart from rv_reservation where rv_reservation_ix = '".$reservationId."'",1);
	$start = explode("-",$dates['rv_date_arrive']);
	$sMonth = $start[1];
	$sDay = $start[2];
	$sYear = $start[0];
	$fromDate = date("Y-m-d",mktime(0,0,0,$sMonth,$sDay-4,$sYear));

	$end = explode("-",$dates['rv_date_depart']);
	$eMonth = $end[1];
	$eDay = $end[2];
	$eYear = $end[0];
	$toDate = date("Y-m-d",mktime(0,0,0,$eMonth,$eDay+4,$eYear));
	}
} else {
	$fromDate = $date;
	$toDate = $date;
}

$SQL="
	SELECT
		rv_extra.rv_extra_ix as rv_extra_id,
		rv_extra.rv_extra_date_serv,
		rv_extra.rv_extra_ind,
		rv_extra.rv_extra_comm_rec,
		rv_extra.rv_extra_comm_pay,
		rv_extra.rv_extra_discount,
		rv_extra.rv_extra_units,
		rv_extra.rv_extra_charge,
		rv_extra.rv_extra_tax_perc,
		rv_extra.rv_extra_exch_rate,
		rv_extra.rv_extra_note,
		rv_extra.rv_extra_note_internal,
		rv_extra.rf_currency_id,
		rv_extra.ac_extra_id,
		rv_extra.pr_business_id,
		rv_extra.rv_reservation_id,
		rf_currency.rf_currency_symbol,
		pr_persona.pr_name_last as rowPropertyName,
		rv_reservation.rv_res_name as reservationName,
		rv_reservation.rf_reservation_status_id
	FROM
		rv_extra
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_extra.rf_currency_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
		INNER JOIN rv_reservation ON rv_reservation_ix = rv_extra.rv_reservation_id
	WHERE
		rv_extra.ac_extra_id = '".$extraId."'
		AND rv_extra.rv_extra_date_serv >= '$fromDate'
		AND rv_extra.rv_extra_date_serv <= '$toDate'
		AND (
				(
				rv_reservation.rf_reservation_status_id = 20 /* PROVISIONAL */
				AND rv_provision_expiry_date >= CURDATE()
				)
			OR rv_reservation.rf_reservation_status_id = 30 /* COMFIRMED */
			OR rv_reservation.rf_reservation_status_id = 25 /* IN PROGRESS */
		)
		AND rv_extra.rv_extra_void_ind = 0
";

if ($propertyId != "" && $propertyId != "0") {
	$SQL .= "
		AND pr_business_id = '".$propertyId."'
	";
}

$result = $lDB->get($SQL,0);

$unitCount = 0;
$tableRows = "0";
$max = mysqli_num_rows($result);
for($i=0;$i<$max;$i++) {
	if ($i == 0) { $tableRows = array(); }

$row = mysqli_fetch_array($result);
if($row['rf_reservation_status_id'] == 25) {
	$row['reservationName'] = "* In Progress";
}

// Custom or Calculated data
$row['rv_extra_date_serv'] = chng_date($row['rv_extra_date_serv'],"-");

if($row['rowPropertyName'] == "0") {
	$row['rowPropertyName'] = "Unallocated";
}

switch($row['rv_extra_ind']) {
case DB_RV_EXTRA_GENERAL:
	$row['travelType'] = "<i class='material-icons'>collections</i>&nbsp;General";
	break;
case DB_RV_EXTRA_ACTIVITY:
	$row['travelType'] = "<i class='material-icons'>photo_camera</i>&nbsp;Activity";
	break;
case DB_RV_EXTRA_TRAVEL:
	$row['travelType'] = "<i class='material-icons'>flight</i>&nbsp;Travel";
	break;
case DB_RV_EXTRA_ACCOMMODATION:
	$row['travelType'] = "<i class='material-icons'>pin_drop</i>&nbsp;Accommodation";
	break;
}

// Extra public note
$row['note'] = new tpParseObject();
$row['note']->setParam("style","visibility:hidden");
$cellStyle = "";
if($row['rv_extra_note'] != "") {
	$row['note']->setParam("onMouseOver","overlib('".$row['rv_extra_note']."',LEFT)");
	$row['note']->setParam("onMouseOut","nd()");
	$row['note']->setParam("style","visibility:visible");
	$cellStyle = "imgLink";
}
$row['noteCell'] = setNewParam("class",$cellStyle);

// Extra internal note
$row['inote'] = new tpParseObject();
$row['inote']->setParam("style","visibility:hidden");
$cellStyle = "";
if($row['rv_extra_note_internal'] != "") {
	$row['inote']->setParam("onMouseOver","overlib('".$row['rv_extra_note_internal']."',LEFT)");
	$row['inote']->setParam("onMouseOut","nd()");
	$row['inote']->setParam("style","visibility:visible");
	$cellStyle = "imgLink";
}
$row['inoteCell'] = setNewParam("class",$cellStyle);

// Extra total
$extrArray = array(
	"rv_extra_charge" => $row['rv_extra_charge'],
	"rv_extra_discount" => $row['rv_extra_discount'],
	"rv_extra_units" => $row['rv_extra_units'],
	"rv_extra_exch_rate" => $row['rv_extra_exch_rate'],
	"rv_reservation_id" => $row['rv_reservation_id'],
	"rv_extra_comm_pay" => $row['rv_extra_comm_pay'],
	"rv_extra_ind" => $row['rv_extra_ind'],
	"rv_extra_id" => $row['rv_extra_id']);
$row['total'] = getExtraTotal($extrArray);

// Reservation currency
$row['resCurrSymbol'] = getInvCurrSymbol($row['rv_reservation_id']);

fixAmtDisplay($row['rv_extra_exch_rate'],2);
fixAmtDisplay($row['total'],2);

array_push($tableRows,$row);
$unitCount += $row['rv_extra_units'];
unset($row);
}

if(!is_array($tableRows)) {
	$table = new tpParseObject();
	$table->setContent("<tr><td colspan=100 align=center>No records found</td></tr>");
} else {
	$table = new tpParseTable();
	$table->Data = $tableRows;
}

$extraDesc = $lDB->get("SELECT ac_ext_desc, ac_ext_max_yn,ac_ext_max  FROM ac_extra WHERE ac_extra_ix = '".$extraId."'", 1);

$propertyName = "All";
if($propertyId != "" && $propertyId != "0") {
	$propertyName = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '".$propertyId."'",4);
}

// Send data to template engine
$GLOBALS['tagList']['rows'] = $table;

$GLOBALS['tagList']['dateRange'] = setNewValue(chng_date($fromDate,"-")." to ".chng_date($toDate,"-"));
$GLOBALS['tagList']['propertyName'] = setNewValue(t_encodeHTMLField($propertyName));
$GLOBALS['tagList']['extraName'] = "&nbsp;".t_encodeHTMLField($extraDesc['ac_ext_desc']);
$GLOBALS['tagList']['unitCount'] = "&nbsp;".$unitCount;
if ($extraDesc['ac_ext_max_yn'] != 0 && $extraDesc['ac_ext_max'] > 0) {
	$GLOBALS['temp']['maxAvailRow'] = "style='visibility:vissible;'";
	$GLOBALS['tagList']['maxAvail'] = "&nbsp;".$extraDesc['ac_ext_max'];
} else {
	$GLOBALS['temp']['maxAvailRow'] = "style='visibility:hidden;'";
}
