<?php

/**
 * init.form265.php - Contact selection popup
 * Job: 692
 * Function: 66 (General access)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/persona_pop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

$lDB->isMaster = "1";
// Arg definition
#1 = filterMode (the case switch)
#2 = agentId
#3 =

// Defaults
$recordsPerPage = "50";
$autoSelect = true;
$showRelationship = true;
$directStyle = false;
$directLabel = "Direct";
$evalCode = "";

$blankObject = blankObject();

// Get requested paramaters
$createUserFlag = false;
if ((isset($_POST['nLastname']) && $_POST['nLastname'] != "") || (isset($_POST['nFirstname']) && $_POST['nFirstname'])) {
	$createUserFlag = true;
}

$pageNum = $_SERVER['argv'][3];
if ($pageNum < 1) {
	$pageNum = "1";
}

$filterMode = $_SERVER['argv'][1];
if ($filterMode == "") {
	$filterMode = "4";
}
$outputMode = "0";

$calendarFlag = $_SERVER['argv'][4];
if ($calendarFlag == "") {
	$calendarFlag = "1";
}

// reset last search
if ($pageNum == "1") {
	session_set(array(
		'personaPopSearch'=>"",
		'personaPopSearchFName'=>""
	));
}

$nameLast = isset($_POST['lastname'])?$_POST['lastname']:"";
$nameFirst = isset($_POST['firstname'])?$_POST['firstname']:"";
if(!isset($_POST['searched']) || $_POST['searched'] != "true") {
	if ($_SESSION['personaPopSearch'] != "" || $_SESSION['personaPopSearchFName'] != "") {
		$nameLast = $_SESSION['personaPopSearch'];
		$nameFirst = $_SESSION['personaPopSearchFName'];
	}
}

$propId = "RS7";

// Get the agent Id
$agentId = isset($_POST['agentList'])?$_POST['agentList']:"";
if ($agentId == "") {
	$agentId = $_SERVER['argv'][2];
}
if ($agentId == "") {
	$agentId = "0";
}

// Get the contactId
$contactId = $_SERVER['argv'][2];
if ($contactId == "") {
	$contactId = "0";
}
$GLOBALS['temp']['contactId'] = $contactId;

$internal = true;
$external = false;

$showAgentList = false;
$allowCreateContact = false;

$showAllRow = false;
$showDirectRow = false;
$showBlankRow = false;

// Create user code - executed on submit
if ($createUserFlag) {
	$pr_name_last = $_POST['nLastname'];
	$pr_name_first = $_POST['nFirstname'];
	$pr_org_yn = $_POST['org_yn'];
	$pr_email = $_POST['email'];
	$telephone = $_POST['telephone'];
	$link2agent = $_POST['link2agent'];

	$pr_persona_link_id = $agentId;
	if ($link2agent != "1") {
		$pr_persona_link_id = "0";
	}

	$pr_persona_ix = db_pr_persona_insert($pr_org_yn,$pr_name_last,$pr_name_first,'','',$pr_email,'','','','','','','','','','','','','','','','','',$pr_persona_link_id);

	if($telephone != "") {
		$phoneTypeId = $lDB->get("SELECT rf_phone_type_id FROM rf_default", 4);
		db_pr_phone_insert($pr_persona_ix,$phoneTypeId,$telephone,'',true);
	}

	$link = "0";
	$post1 = "";
	$ppost1 = "";
	$post2 = "";
	$ppost2 = "";
	$code = "";
	$pcode = "";

	if ($agentId != "" && $agentId != "0") {
		if ($link2agent == "1") {
			db_pr_link_insert($pr_persona_ix,$agentId,"RS2");
			$link = "1";
			if ($autoSelect) {
				$linkedAddress = getLinkedAddressDetails($pr_persona_ix);
				$post1 = t_encodeOverlib($linkedAddress['pr_corr_addr_line1']);
				$post2 = t_encodeOverlib($linkedAddress['pr_corr_addr_line2']);
				$code = $linkedAddress['pr_corr_post_code'];
				$ppost1 = t_encodeOverlib($linkedAddress['pr_phys_addr_line1']);
				$ppost2 = t_encodeOverlib($linkedAddress['pr_phys_addr_line2']);
				$pcode = $linkedAddress['pr_phys_post_code'];
			}
		}
	}
}

// Define the basic fields to select
$COLUMNlist = array(
	"pr_persona.pr_persona_ix",
	"pr_persona.pr_name_last",
	"pr_persona.pr_name_first",
	"rf_name_suffix.rf_suffix_desc",
	"rf_title.rf_title_desc" 
);
$FROM = "pr_persona";

// Define the basic where clause
$WHERElist = array(
	"pr_persona.pr_persona_inactive_yn = 0",
	"pr_persona.pr_sys_code < 5"
);

// Filter by search critera
$GLOBALS['temp']['lChecked'] = "checked";
$GLOBALS['temp']['fChecked'] = "";
$GLOBALS['temp']['nameLast'] = "";
$GLOBALS['temp']['nameFirst'] = "";
if ($nameLast != "") {
	$GLOBALS['temp']['nameLast'] = $nameLast;
	array_push($WHERElist,"pr_persona.pr_name_last LIKE '".str_replace("*","%",addslashes($nameLast))."'");
	session_set("personaPopSearch",$nameLast);
	$GLOBALS['temp']['lChecked'] = "checked";
	$GLOBALS['temp']['fChecked'] = "";
}
if ($nameFirst != "") {
	$GLOBALS['temp']['nameFirst'] = $nameFirst;
	array_push($WHERElist,"pr_persona.pr_name_first LIKE '".str_replace("*","%",addslashes($nameFirst))."'");
	session_set("personaPopSearchFName",$nameFirst);
	$GLOBALS['temp']['lChecked'] = "";
	$GLOBALS['temp']['fChecked'] = "checked";
}

$func = "contact";

// Switch between filter modes
switch ($filterMode) {
case 0: # List all Individuals
	array_push($WHERElist,"pr_persona.pr_org_yn = 0");
	break;
case 1: # List all Organisations
	array_push($WHERElist,"pr_persona.pr_org_yn = 1");
	break;
case 14: # Used for guest
	$func = "guestAgent";
	$evalCode .= '
		$row[\'func\'] = "guestAgent";
	';
case 2: # List all Agents
	$FROM = "pr_agent INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_agent.pr_agent_id";
	array_push($WHERElist,"pr_agent.pr_agent_inactive_yn = 0");
	break;
case 3: # List all Users
	$FROM = "pr_user INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_user.pr_user_id";
	array_push($WHERElist,"pr_user.pr_user_inactive_yn = 0");
	break;
case 4: # List users OF an agent
	$showAgentList = true;
	$allowCreateContact = true;
	if ($agentId != "0") {
		$FROM = "
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
		";
		array_push($WHERElist,"pr_link.pr_link_to = '".$agentId."' AND pr_link.rf_link_type_id = 'RS2'");
	} else {
		$FROM = "pr_user INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_user.pr_user_id";
		array_push($WHERElist,"pr_user.pr_user_inactive_yn = 0");
	}
	break;
case 5: # List users OF a property
	$FROM = "pr_link INNER JOIN pr_user ON pr_link.pr_link_from = pr_user.pr_user_id INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_user.pr_user_id";
	array_push($WHERElist,"pr_user.pr_user_inactive_yn = 0");
	array_push($WHERElist,"pr_link.pr_link_to = '".$propId."' AND pr_link.rf_link_type_id = 'RS1'");
	break;
case 6: # List users OF a certain status
	$FROM = "pr_link INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from INNER JOIN pr_user ON pr_user.pr_user_id = pr_persona.pr_persona_ix";
	$status = array();
	if ($internal) {
		array_push($status,"pr_link.rf_link_type_id = 'RS1'");
	}
	if ($external) {
		array_push($status,"pr_link.rf_link_type_id = 'RS2'");
	}
	array_push($WHERElist,join(" OR ",$status));
	array_push($WHERElist,"pr_user.pr_user_inactive_yn = 0");
	break;
case 7: # List all NON Agents and NON Businesses
	$FROM = "pr_persona LEFT JOIN pr_agent ON pr_agent_id = pr_persona_ix LEFT JOIN pr_business ON pr_business_id = pr_persona_ix";

	array_push($WHERElist,"pr_agent_id IS NULL");
	array_push($WHERElist,"pr_business_id IS NULL");
	$allowCreateContact = true;

	$func = "contact";
	$evalCode .= '
		$row[\'func\'] = "contact";
	';
	 break;
case 8: # Wizard step 2 and res details originator popup
	$showDirectRow = true;
	$directLabel = "None";
	$allowCreateContact = true;
	$func = "origin";
	$evalCode .= '
		$row[\'func\'] = "origin";
	';
	break;
case 9: # Billings billing contact popup
	$showDirectRow = true;
	$directLabel = "Cash";
	$allowCreateContact = true;
	$func = "billing_contact";
	$evalCode .= '
		$row[\'func\'] = "billing_contact";
	';
	break;
case 10: # Billings invoice contact popup
	$showDirectRow = true;
	$directLabel = "Cash";
	$allowCreateContact = true;
	$func = "invoice_contact";
	$evalCode .= '
		$row[\'func\'] = "invoice_contact";
	';
	break;
case 11: # Calendar contact popup
	$allowCreateContact = true;
	$func = "cal_contact";
	$evalCode .= '
		$row[\'func\'] = "cal_contact";
	';
	if ($agentId != "0") {
		$showAgentList = true;
		$FROM = "pr_link INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from";
		array_push($WHERElist,"pr_link.pr_link_to = '".$agentId."' AND pr_link.rf_link_type_id = 'RS2'");
	}
	array_push($WHERElist,"pr_persona.pr_persona_db <> ''");
	break;
case 12: # Standard contact popup
	$allowCreateContact = true;
	$func = "contact";
	$evalCode .= '
		$row[\'func\'] = "contact";
	';
	if ($agentId != "0") {
		$showAgentList = true;
		$FROM = "pr_link INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from";
		array_push($WHERElist,"pr_link.pr_link_to = '".$agentId."' AND pr_link.rf_link_type_id = 'RS2'");
	}
	array_push($WHERElist,"pr_persona.pr_persona_db <> ''");
	break;
case 13: # Primary guest popup
	$func = "guest";
	$evalCode .= '
		$row[\'func\'] = "guest";
	';
	$FROM = "pr_guest INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_guest.pr_guest_id";
	array_push($WHERElist,"pr_guest.pr_guest_primary_yn = '1'");
	break;
	// NOTE: case 14 is used further up
case 15: # Find payee payment find popup
	$showAllRow = true;
	$showDirectRow = true;
	$directLabel = "Cash";
	$func = "payee";
	$evalCode .= '
		$row[\'func\'] = "payee";
	';
	$FROM = "pr_persona LEFT JOIN pr_business ON pr_persona.pr_persona_ix = pr_business.pr_business_id";
	array_push($WHERElist,"pr_persona.pr_persona_id > 0");
	array_push($WHERElist,"pr_business.pr_business_id Is Null");
	break;
case 16: # Find payee payment find popup
	$showBlankRow = true;
	$func = "recorder";
	$evalCode .= '
		$row[\'func\'] = "recorder";
	';

	$FROM = "rv_payment INNER JOIN pr_persona ON rv_payment.rv_pmnt_user_id = pr_persona.pr_persona_ix";
	#array_push($WHERElist,"rv_payment.rv_pmnt_user_id Is Not Null");
	break;
case 17: # List all Agents (for agent relationship)
	$func = "agentLink";
	$evalCode .= '
		$row[\'func\'] = "agentLink";
	';
	$FROM = "pr_agent INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_agent.pr_agent_id";
	array_push($WHERElist,"pr_agent.pr_agent_inactive_yn = 0");
	break;
case 18: # List all Properties (for property relationship)
	$func = "propLink";
	$evalCode .= '
		$row[\'func\'] = "propLink";
	';
	$FROM = "pr_business INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id";
	array_push($WHERElist,"pr_business.pr_bus_inactive_yn = 0");
	break;
case 19: # List all Contacts (for linked address)
	$func = "addrLink";
	$evalCode .= '
		$row[\'func\'] = "addrLink";
	';
	$FROM = "pr_persona ";
	array_push($WHERElist,"pr_persona.pr_persona_link_id = '0'");
	array_push($WHERElist,"pr_persona.pr_persona_ix != '".$contactId."'");
	break;
case 20: # List all Contacts (for forward contact)
	$func = "fwdLink";
	$evalCode .= '
		$row[\'func\'] = "fwdLink";
	';
	$FROM = "pr_persona ";
	array_push($WHERElist,"pr_persona.pr_persona_ix != '".$contactId."'");
	break;
case 21: # Find payee record payment popup
	$allowCreateContact = true;
	$showDirectRow = true;
	$directLabel = "Cash";
	$func = "record_payee";
	$evalCode .= '
		$row[\'func\'] = "record_payee";
	';
	$FROM = "pr_persona LEFT JOIN pr_business ON pr_persona.pr_persona_ix = pr_business.pr_business_id";
	array_push($WHERElist,"pr_persona.pr_persona_id > 0");
	array_push($WHERElist,"pr_business.pr_business_id Is Null");
	break;
case 22: # Folio contact popup
	$showDirectRow = true;
	$directLabel = "Cash";
	$allowCreateContact = true;
	$func = "folio_contact";
	$evalCode .= '
		$row[\'func\'] = "folio_contact";
	';
	break;
case 23: # List all Agents
	$showAllRow = true;
	$FROM = "pr_agent INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_agent.pr_agent_id";
	array_push($WHERElist,"pr_agent.pr_agent_inactive_yn = 0");
	$func = "occ_agent";
	$evalCode .= '
		$row[\'func\'] = "occ_agent";
	';
	break;
case 24: # List users for code extra page selection
	$allowCreateContact = true;
	$func = "contact_code_extra";
	$evalCode .= '
		$row[\'func\'] = "contact_code_extra";
	';
	if ($agentId != "0") {
		$showAgentList = true;
		$FROM = "pr_link INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from";
		array_push($WHERElist,"pr_link.pr_link_to = '".$agentId."' AND pr_link.rf_link_type_id = 'RS2'");
	}
	array_push($WHERElist,"pr_persona.pr_persona_db <> ''");
	break;

case 25: # Standard contact popup
	$allowCreateContact = true;
	$func = "crm_internal_rep";
	$evalCode .= '
		$row[\'func\'] = "crm_internal_rep";
	';
	$FROM = "pr_link INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from";
	array_push($WHERElist,"pr_link.rf_link_type_id = 'RS1'");
	array_push($WHERElist,"pr_persona.pr_persona_db <> ''");
	break;
case 26: # Standard contact popup
	$allowCreateContact = true;
	$func = "crm_client_rep";
	$evalCode .= '
		$row[\'func\'] = "crm_client_rep";
	';
	if ($agentId != "0") {
		$showAgentList = true;
		$FROM = "pr_link INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from";
		array_push($WHERElist,"pr_link.pr_link_to = '".$agentId."' AND pr_link.rf_link_type_id = 'RS2'");
	}
	array_push($WHERElist,"pr_persona.pr_persona_db <> ''");
	break;
case 27: # Replace contact popup (only contacts with same type and role)
	$func = "replace";
	$evalCode .= '
		$row[\'func\'] = "replace";
	';
	array_push($WHERElist,"pr_persona.pr_persona_ix != '".$lDB->escape($contactId)."'");

	$roles = getContactRoles($contactId);
	if($roles === false) {
		$roles = array('agent' => 0,'business' => 0,'guest' => 0,'supplier' => 0,'user' => 0);
	}
	$FROM = "
		pr_persona
	";

	foreach($roles as $role=>$state) {
		$FROM .= "
			LEFT JOIN pr_" . $role . " ON pr_" . $role . ".pr_" . $role . "_id = pr_persona.pr_persona_ix
		";
		if($state) {
			$check = "IS NOT NULL";
		} else {
			$check = "IS NULL";
		}
		array_push($WHERElist,"pr_" . $role . ".pr_" . $role . "_id " . $check);
	}

	$pr_org_yn = $lDB->get("SELECT pr_org_yn FROM pr_persona WHERE pr_persona_ix = '".$lDB->escape($contactId)."'",4);
	array_push($WHERElist,"pr_persona.pr_org_yn = '".$lDB->escape($pr_org_yn)."'");

	break;
}

$GLOBALS['temp']['func'] = $func;
if ($createUserFlag && $autoSelect) {
	$out = explode("<body",$GLOBALS[$form]->FormHTML);
	$out = $out[0]."<body onload=\"select_".$func."('".t_encodeHTMLField(addslashes($pr_name_last))."','".t_encodeHTMLField(addslashes($pr_name_first))."','".t_encodeHTMLField($pr_persona_ix)."','".t_encodeHTMLField($pr_email)."','','".t_encodeHTMLField($telephone)."','".t_encodeHTMLField($post1)."','".t_encodeHTMLField($post2)."','".t_encodeHTMLField($code)."','".t_encodeHTMLField($link)."');\"></body>";
	echo $out;
	die();
}

// Setup the WHERE sql
$WHEREsql = "";
if (sizeof($WHERElist) > 0) {
	$WHEREsql = " AND (".join(") AND (",$WHERElist).") ";
}

// Prepare the output settings
switch ($outputMode) {
case 0: // Single select with no buttons - include all address details
	array_push($COLUMNlist,"pr_email");
	array_push($COLUMNlist,"pr_corr_addr_line1 as post1");
	array_push($COLUMNlist,"pr_corr_addr_line2 as post2");
	array_push($COLUMNlist,"pr_corr_post_code as code");
	array_push($COLUMNlist,"pr_corr_city as city");
	array_push($COLUMNlist,"pr_corr_country_id as country");
	array_push($COLUMNlist,"pr_phys_addr_line1 as ppost1");
	array_push($COLUMNlist,"pr_phys_addr_line2 as ppost2");
	array_push($COLUMNlist,"pr_phys_post_code as pcode");
	array_push($COLUMNlist,"pr_phys_city as pcity");	
	array_push($COLUMNlist,"pr_phys_country_id as pcountry");
	array_push($COLUMNlist,"pr_persona_link_id as linkId");

	// Setup code to execute inside the loop - AFTER the main rows have been returned
	$evalCode .= '
		// Read linked address
		$row[\'linked\'] = "0";
		if( isset($row[\'linkId\']) && $row[\'linkId\'] != "0") {
			$row[\'linked\'] = "1";
			$linkedAddress = getLinkedAddressDetails($row[\'pr_persona_ix\']);
			$row[\'post1\'] = isset($linkedAddress[\'pr_corr_addr_line1\']) ? t_encodeOverlib($linkedAddress[\'pr_corr_addr_line1\']) : "";
			$row[\'post2\'] = isset($linkedAddress[\'pr_corr_addr_line2\']) ? t_encodeOverlib($linkedAddress[\'pr_corr_addr_line2\']) : "";
			$row[\'code\'] = isset($linkedAddress[\'pr_corr_post_code\']) ? $linkedAddress[\'pr_corr_post_code\'] : "";
			$row[\'city\'] = isset($linkedAddress[\'pr_corr_city\']) ? $linkedAddress[\'pr_corr_city\'] : "";
			$row[\'country\'] = isset($linkedAddress[\'pr_corr_country_id\']) ? $linkedAddress[\'pr_corr_country_id\'] : "";
			$row[\'ppost1\'] = isset($linkedAddress[\'pr_phys_addr_line1\']) ? t_encodeOverlib($linkedAddress[\'pr_phys_addr_line1\']) : "";
			$row[\'ppost2\'] = isset($linkedAddress[\'pr_phys_addr_line2\']) ? t_encodeOverlib($linkedAddress[\'pr_phys_addr_line2\']) : "";
			$row[\'pcode\'] = isset($linkedAddress[\'pr_phys_post_code\']) ? $linkedAddress[\'pr_phys_post_code\'] : "";
			$row[\'pcity\'] = isset($linkedAddress[\'pr_phys_city\']) ? $linkedAddress[\'pr_phys_city\'] : "";
			$row[\'pcountry\'] = isset($linkedAddress[\'pr_phys_country_id\']) ? $linkedAddress[\'pr_phys_country_id\'] : "";
		}
		// Read fax and telephone numbers
		$row[\'fax\'] = isset($row[\'pr_persona_ix\']) ? getFaxNumber($row[\'pr_persona_ix\']) : "";
		$row[\'tel\'] = isset($row[\'pr_persona_ix\']) ? getDefPhoneNumber($row[\'pr_persona_ix\']) : "";
	';

	$HTML = join("",file(__DIR__ . "/../../../public/html/persona_pop_row_single_details.htm"));;
	break;
}

$ORDERsql = "pr_name_last,pr_name_first";

// Count the number of rows that will be found
$total = $lDB->get("
	SELECT
		COUNT(DISTINCT pr_persona.pr_persona_ix)
	FROM
		$FROM
	WHERE
		1
		$WHEREsql
",4);

$GLOBALS['tagList']['agentList'] = $blankObject;
if ($showAgentList) {
	$GLOBALS[$form]->AddField("agentList","agentList",$agentId,3);
	if ($userStatusId > 1) {
		$sql="
			SELECT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
			FROM
				pr_agent
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_agent.pr_agent_id
			WHERE
				pr_agent_inactive_yn = 0
				AND pr_persona.pr_persona_inactive_yn = 0
			ORDER BY
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
		";
		$GLOBALS['agentList']->Select(combolist($lDB,$sql,"0:|:All"));
	} else {
		$agnName = $lDB->get("SELECT pr_name_last, pr_name_first FROM pr_persona WHERE pr_persona_ix = '$calAgentId'",1);
		$GLOBALS['agentList']->Select = array("0:|:All", $calAgentId.":|:".trim($agnName['pr_name_first']." ".$agnName['pr_name_last']));
	}
	$GLOBALS['agentList']->Width = "172";

	$GLOBALS['tagList']['agentList'] = $GLOBALS['agentList'];
}

$pages = $total / $recordsPerPage;
$intPages = ceil($pages);

$recordStart = ($pageNum - 1) * $recordsPerPage;

$GLOBALS['temp']['pageTotal'] = $intPages;
$GLOBALS['temp']['pageCurrent'] = $pageNum;

$nextStart = $recordStart + $recordsPerPage;
$GLOBALS['temp']['next'] = "&nbsp;";
$GLOBALS['temp']['prev'] = "&nbsp;";
$GLOBALS['temp']['hidenextbutton'] = "display: none;";

if ($total > $nextStart) {
	$GLOBALS['temp']['hidenextbutton'] = "";		
	$GLOBALS['temp']['next'] = "<input type=\"button\" style=\"width: 50px; height: 20px; font-size: 1em;\" class=\"button\" onclick=\"window.location='/reservation.php?692+" . $filterMode . "+" . $agentId . "+" . ($pageNum+1) . "'\" value=\"Next >>\" />";
}

if ($pageNum > "1") {
	$GLOBALS['temp']['hidenextbutton'] = "";

	$GLOBALS['temp']['prev'] = "<input type=\"button\" style=\"width: 50px; height: 20px; font-size: 1em;\" class=\"button txtb\" onclick=\"window.location='/reservation.php?692+" . $filterMode . "+" . $agentId . "+" . ($pageNum-1) . "'\" value=\"<< Prev\" />";
}

// Get the rows back from mysql
$sql="
	SELECT DISTINCT ". join(",\n",$COLUMNlist). "
	FROM
		$FROM
		LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
		LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
	WHERE
		1
";
$sql .= $WHEREsql;
$sql .= " ORDER BY ".$ORDERsql;
$sql .= " LIMIT ".$recordStart.", ".$recordsPerPage;
$result = $lDB->get($sql,0);

// Get the number of rows returned
$count = !empty($result) ? mysqli_num_rows($result) : 0;

$output = "";
$rows = array();
for ($i=0;$i<$count;$i++) {
	$row = mysqli_fetch_array($result);
	$tpRow = array();

	if ($showRelationship) {
		if ($lDB->get("select count(*) from pr_link where pr_link_from = '" . $row['pr_persona_ix'] . "'",4) > 0) {
			$sql="
				SELECT
					pr_persona.pr_name_last,
					pr_persona.pr_name_first
				FROM
					pr_link
				INNER JOIN pr_persona ON 
					pr_persona.pr_persona_ix = pr_link.pr_link_to
				WHERE
					pr_link.pr_link_from = '" . $row['pr_persona_ix'] . "'
				ORDER BY
					rf_link_type_id
				LIMIT 1
			";
			$temp = $lDB->get($sql,1);
			$row['relationship'] = "(".trim($temp['pr_name_first']." ".$temp['pr_name_last']).")";
		} else {
			$tpRow = array("relationship" => $blankObject);
		}
	} else {
		$tpRow = array("relationship" => $blankObject);
	}
			
	$primaryGuest = $GLOBALS['lDB']->get("SELECT pr_guest.pr_guest_primary_yn FROM pr_guest WHERE pr_guest_id = '" . $row['pr_persona_ix'] . "'",4);
	$row['pGuestClass'] = "";
	$row['hideButt'] = "display: inline;";

	if ( $primaryGuest == "1" ) {
		$row['pGuestClass'] = "txtb";
	}

	$row['pr_name_last_raw']	= t_encodeHTMLField($row['pr_name_last']);
	$row['pr_name_first_raw']	= t_encodeHTMLField($row['pr_name_first']);
	$row['title']							= $row['rf_title_desc'];

	if ( $row['rf_title_desc'] != "" ) {
		$row['title'] = " ".$row['rf_title_desc'];
	}  

	$row['suffix'] = $row['rf_suffix_desc'];

	if ( $row['rf_suffix_desc'] != "" ) {
		$row['suffix'] = ' ' . $row['rf_suffix_desc'] . ' ';
	}

	$row['pr_name_last']	= t_encodeOverlib($row['pr_name_last']);
	$row['pr_name_first']	= t_encodeOverlib($row['pr_name_first']);

	if(trim($row['pr_name_last'])=="" && trim($row['pr_name_first'])=="") {
		// Do not display blank contacts
		continue;
	}

	$row['post1']	= t_encodeOverlib($row['post1']);
	$row['post2']	= t_encodeOverlib($row['post2']);
	$row['code']	= t_encodeOverlib($row['code']);
	$row['city']	= isset($row['city']) ? t_encodeOverlib($row['city']) : "";
	$row['ppost1']	= t_encodeOverlib($row['ppost1']);
	$row['ppost2']	= t_encodeOverlib($row['ppost2']);
	$row['pcode']   = t_encodeOverlib($row['pcode']);

	$row['func'] = "contact";

	eval($evalCode);

	$row['tel'] = t_encodeOverlib($row['tel']);
	$row['fax'] = t_encodeOverlib($row['fax']);

	$rowHTML = tpParse($tpRow,$HTML);
	$output .= showpage($row,$rowHTML);
}
$GLOBALS['temp']['rows'] = $output;
if ( $output == "" ){
	$GLOBALS['temp']['rows'] = '
		<tr>
			<td colspan="2" align="left">
				&nbsp;&nbsp;Your search - ' . (isset($_POST['lastname']) ? $_POST['lastname'] : "") . ' ' . (isset($_POST['firstname']) ? $_POST['firstname'] : "") . ' - did not match any records.<br /><br />&nbsp;&nbsp;<strong>Suggestions:</strong><br />
				&nbsp;&nbsp;- Use wildcards to assist in your search<br />
				&nbsp;&nbsp;&nbsp;&nbsp;(e.g. B* to list all records starting with B)<br />
				&nbsp;&nbsp;- Use a different keyword.
			</td>
		</tr>
	';
}

if ($showAllRow || $showDirectRow || $showBlankRow) {
	$tpRow = array("relationship" => $blankObject);
	$row['pGuestClass'] = "";
	$row['hideButt'] = "display: none;";
	if ($showAllRow) {
		$row['pr_name_last_raw'] = "All";
		$row['pr_name_first_raw'] = "";

		$row['pr_name_last'] = "All";
		$row['pr_name_first'] = "";         
		$row['title'] = "";
		$row['suffix'] = "";         
	}

	if ($showDirectRow) {
		if($showAllRow) {
			$row['func'] = "contact";

			eval($evalCode);	
			$row['pr_persona_ix'] = "2";
			$row['pr_email'] = "";
			$row['fax'] = "";
			$row['tel'] = "";
			$row['post1'] = "";
			$row['post2'] = "";
			$row['code'] = "";
			$row['linked'] = "";
			$rowHTML = tpParse($tpRow,$HTML);
			$GLOBALS['temp']['rows'] = showpage($row,$rowHTML) . $GLOBALS['temp']['rows'];
			$tpRow = array("relationship" => $blankObject);
		}				
		$row['pr_name_last_raw'] = $directLabel;
		$row['pr_name_first_raw'] = "";

		$row['pr_name_last'] = $directLabel;
		$row['pr_name_first'] = "";
		$row['title'] = "";
		$row['suffix'] = "";         
	}

	if ($showBlankRow) {
		$row['pr_name_last_raw'] = "No name provided";
		$row['pr_name_first_raw'] = "";

		$row['pr_name_last'] = "";
		$row['pr_name_first'] = "";
		$row['title'] = "";
		$row['suffix'] = "";         
	}

	$row['func'] = "contact";

	eval($evalCode);

	$row['pr_persona_ix'] = "0";
	$row['pr_email'] = "";
	$row['fax'] = "";
	$row['tel'] = "";
	$row['post1'] = "";
	$row['post2'] = "";
	$row['code'] = "";
	$row['linked'] = "";

	$rowHTML = tpParse($tpRow,$HTML);
	$GLOBALS['temp']['rows'] = showpage($row,$rowHTML) . $GLOBALS['temp']['rows'];
}

$GLOBALS['temp']['allowCreateContact'] = " style=\"display:none\"";
if ($allowCreateContact) {
	$GLOBALS['temp']['allowCreateContact'] = "";
}

$GLOBALS['temp']['agentTel']			= '';
$GLOBALS['temp']['agentEmail']		= '';
$GLOBALS['temp']['showHideAgent']	= ' style="display: none;"';

if ( $agentId != "0" ) {
	$result = $lDB->get("SELECT pr_name_last, pr_email FROM pr_persona WHERE pr_persona_ix = '" . $agentId . "'",1);
	$GLOBALS['temp']['agentTel'] = getDefPhoneNumber($agentId);
	$GLOBALS['temp']['agentEmail'] = $result['pr_email'];
	$GLOBALS['temp']['agentName'] = $result['pr_name_last'];
	$GLOBALS['temp']['showHideAgent'] = "";
}

$GLOBALS['temp']['filterMode'] = $filterMode;
$GLOBALS['temp']['agentId'] = $agentId;

$GLOBALS['temp']['directStyle'] = ' style="display:none"';
if ( $directStyle ) {
	$GLOBALS['temp']['directStyle'] = '';
}

// Prepare alpha / numeric lists
$alphaList = "";
for ($count = 0; $count < 26; $count++) {
	$alphaList .= '<span class="imgLink txtbr" style="float: left; font-size: 11px; border: 1px solid #dddddd; width: 14px; text-align: center; margin: 2px;" onclick="searchChar(\'' . chr(ord("A") + $count) . '\');">' . chr(ord("A") + $count) . '</span>';
}

$GLOBALS['temp']['alphaList'] = $alphaList;

$numericList = "";
for ($count = 0; $count < 10; $count++) {
	$numericList .= '<span class="imgLink txtbr" style="float: left; font-family: Arial; font-size: 11px; border: 1px solid #dddddd; width: 14px; text-align: center; margin: 2px;" onclick="searchChar(\'' . $count . '\');">' . $count . '</span>';
}
$GLOBALS['temp']['numericList'] = $numericList;
