<?php

/**
 * init.form266.php - Quick search form
 * Job: 693
 * Function: 50
 */

session_set(array(
	'takenStep3'=>false,
	'wizResStatusUpdated'=>true,
	'whichCalendar'=>"quick_search"
));

clearTimedOutReservations();

// The quick search form - supplementing our existing visual calendar
if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/reservation_quick_search.htm");
}

$GLOBALS['wizCancelled'] = false;

/* Prevent undefined index notices */
$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

if ($_SERVER['argv'][1] == "CANCEL") {
	$GLOBALS['wizCancelled'] = true;
}

function genPropAccommAttrTree($selected) {
	global $lDB;

	if (!is_array($selected)) {
		$selected = array($selected);
	}

	$out = '
		<table width="100%" border="0" cellpadding="0" cellspacing="0" summary="">
			<tr>
	';
	$hmax = sizeof($selected);
	$res = ($hmax % 3);

	for ($h = 0; $h < $hmax; $h++) {
		$div = $h+1;

		if ($div % 3 == 1 && $div != 1) {
			$out .= '
				</tr>
				<tr>
			';
		}

		$out .= '<td width="33%" align="center" valign="top">';

		$propertyId = $selected[$h];
		$accommList = $lDB->get("
			SELECT
				ac_accomm_type_ix AS ac_accomm_type_id,
				ac_accomm_desc
			FROM
				ac_accomm_type
			WHERE
				pr_business_id = '".$propertyId."'
				AND ac_accomm_type_inactive_yn = 0
			ORDER BY
				ac_accomm_sequence
		",2);

		$out .= "<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" align=\"center\">\n";
		$imax = sizeof($accommList);

		$out .= "<tr>\n<td width=\"30\" valign=\"top\" align=\"center\"><input type=\"checkbox\" name=\"bus".$propertyId."\" onclick=\"checkChildren(this.name,this)\"></td>\n";
		$out .= "<td colspan=\"3\" class=\"txtb\">&nbsp;".$lDB->get("select pr_name_last from pr_persona where pr_persona_ix = '".$propertyId."'",4)."</td>\n</tr>\n";

		for ($i = 0; $i < $imax; $i++) {
			$accommId 	= $accommList[$i]['ac_accomm_type_id'];
			$accommDesc = $accommList[$i]['ac_accomm_desc'];

			$attribList = $lDB->get("
				SELECT DISTINCT
					ac_accomm_room_attr.rt_component_id,
					rt_component.rt_component_desc
				FROM
					ac_accomm_room_attr
					INNER JOIN rt_component ON rt_component.rt_component_ix = ac_accomm_room_attr.rt_component_id
				WHERE
					ac_accomm_room_attr.ac_accomm_type_id = '".$accommId."'
					AND rt_component.rt_component_sys_code < '5'
				ORDER BY
					rt_component.rt_component_desc
			",2);

			$jmax = sizeof($attribList);
			$out .= "<tr>\n<td colspan=\"2\" align=\"right\" valign=\"top\"><input type=\"checkbox\" name=\"bus".$propertyId."acc".$accommId."\" id=\"".$accommId."\" desc=\"".$accommDesc."\"></td>\n";
			$out .= "<td colspan=\"2\" class=\"txtbbr\">&nbsp;".$accommDesc."</td>\n</tr>\n";

			for ($j = 0; $j < $jmax; $j++) {
				$attribId 	= $attribList[$j]['rt_component_id'];
				$attribDesc = $attribList[$j]['rt_component_desc'];

				$out .= "
					<tr>
						<td width=\"30\">&nbsp;</td>
				";
				$out .= "
						<td width=\"30\">&nbsp;</td>
				";
				$out .= "
						<td width=\"30\" align=\"right\" valign=\"top\"><input type=\"checkbox\" id=\"".$accommId."-".$attribId."\" onclick=\"checkParent('bus".$propertyId."acc".$accommId."',this)\" name=\"abus".$propertyId."acc".$accommId."attrib".$attribId."\"></td>
				";
				$out .= "
						<td>&nbsp;".$attribDesc."</td>
					</tr>
				";
			}
		}
		$out .= "</table>\n</td>\n";
	}

	if ($res > 0) {
		$start = 3 - $res;
		for ($i = 0; $i < $start; $i++) {
			$out .= "<td width=\"33%\" align=\"center\" valign=\"top\">&nbsp;</td>\n";
		}
	}
	return $out."</tr>\n</table>\n";
}

if(array_key_exists('wizResId',$_SESSION)) {
	$wizResId = $_SESSION['wizResId'];
} else {
	$wizResId = "";
}

validResId($wizResId);

$tempMasterData = $GLOBALS['lDB']->isMaster;
$GLOBALS['lDB']->isMaster = "1";
$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");
$thisSession = $_SERVER['argv'][1]."+".$_SERVER['argv'][2]."+".$_SERVER['argv'][3]."+".$_SERVER['argv'][4]."+".$_SERVER['argv'][5]."+".$_SERVER['argv'][6];

if ($_SERVER['argv'][1] == "" && $_SERVER['argv'][2] == "" && $_SERVER['argv'][3] == "" && $_SERVER['argv'][4] == "" && $_SERVER['argv'][5] == "" && $_SERVER['argv'][6] == "") {
	if(isset($_SESSION['calendarParms']) && is_string($_SESSION['calendarParms'])) {
		$thisSession = array_pad(explode("+",$_SESSION['calendarParms']),7,"");
	} else {
		$thisSession = array_pad(array(),7,"");
	}
	$_SERVER['argv'][1] = $thisSession[0];
	$_SERVER['argv'][2] = $thisSession[1];
	$_SERVER['argv'][3] = $thisSession[2];
	$_SERVER['argv'][4] = $thisSession[3];
	$_SERVER['argv'][5] = $thisSession[4];
	$_SERVER['argv'][6] = $thisSession[5];
} else {
	session_set("calendarParms",explode("+",$thisSession));
}

$GLOBALS['temp']['hideRatePopup'] = "";

global $userStatusId;
if($userStatusId == 0) {
	$GLOBALS['temp']['hideRatePopup'] = " style=\"visibility:hidden\"";
}

$GLOBALS['temp']['hideAddItinerary'] = " style=\"display:none\"";
$GLOBALS['temp']['infoPop'] = "/resource/Resrequest/Application/public/html/info/info_avail_read.htm";

$showAddItinerary = false;

$GLOBALS['temp']['canUseWizard'] = "false";
$GLOBALS['CHECKJOBOVERRIDE'] = true;

if (checkjob(20,2) > 5 && ($lDB->get("select rf_sys_locked_yn from rf_system",4) != "1")) {
	$showAddItinerary = true;
	$GLOBALS['temp']['hideAddItinerary'] = "";
	$GLOBALS['temp']['canUseWizard'] = "true";
	$GLOBALS['temp']['infoPop']	= "/resource/Resrequest/Application/public/html/info/info_avail_cal.htm";
}

// Specials access
if (db_sc_group_get_user_setting("sc_grp_res_sp_apply_auto_yn") == "1"){
	$GLOBALS['temp']['displaySpecialsAccess'] = "true";
} else {
	$GLOBALS['temp']['displaySpecialsAccess'] = "false";
}

if (db_sc_group_get_user_setting("sc_grp_res_sp_apply_man_yn") == "1"){
	$GLOBALS['temp']['applySpecialsAccess'] = "true";
} else {
	$GLOBALS['temp']['applySpecialsAccess'] = "false";
}

// Phase 1 - Declare and validate variables
// Paramaters for this page
$calStartDate 	= isset($_SESSION['calStartDate'])?$_SESSION['calStartDate']:"";
$calEndDate 		= isset($_SESSION['calEndDate'])?$_SESSION['calEndDate']:"";
$calPropList 		= isset($_SESSION['calPropList'])?$_SESSION['calPropList']:"";
$calAccommList 	= isset($_SESSION['calAccommList'])?$_SESSION['calAccommList']:"";
$calAgentId 		= isset($_SESSION['calAgentId'])?$_SESSION['calAgentId']:"";
$canCalWizard 	= false;

$calendarLevel = $lDB->get("
	SELECT
		sc_fun_grp_level
	FROM
		sc_fun_group
	WHERE
		sc_group_id = '$GLOBALS[sc_group_id]'
		AND sc_function_id = '50'
",4);

if ($calendarLevel > "5") {
	$canCalWizard = true;
}

$blockRateOverLap = isset($_SESSION['blockRateOverLap'])?$_SESSION['blockRateOverLap']:"";
$calRateList = isset($_SESSION['calRateList'])?$_SESSION['calRateList']:"";

global $calStartDate;
global $calEndDate;
global $wizResId;
global $calAccommList;
global $calAgentId;
global $canCalWizard;
global $blockRateOverLap;
global $calRateList;

$GLOBALS['temp']['alertUser'] = "0";

if ($wizResId != "" && $GLOBALS['lDB']->count("rv_reservation","rv_reservation_ix",$wizResId,1)) {
	// echo "res exists...<br>";
	$resData = $GLOBALS['lDB']->get("
		SELECT
			rf_reservation_status_id,
			rv_create_expiry_date
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$wizResId'
	",1);

	if ($resData[0] == "25") {
		if ($resData[1] < date("Y-m-d H:i:s")) {
			$GLOBALS['temp']['alertUser'] = "1";

			// Delete EVERYTHING
			if ($wizResId != "" && $GLOBALS['lDB']->count("rv_reservation","rv_reservation_ix",$wizResId,1)) {
				$itemList = $GLOBALS['lDB']->get("
					SELECT
						rv_reservation_item_ix
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_id = '$wizResId'
				",3);

				foreach($itemList as $item) {
					$compList = $GLOBALS['lDB']->get("
						SELECT
							rv_res_item_comp.rv_res_item_comp_ix
						FROM
							rv_res_item_comp
						WHERE
							rv_reservation_item_id = '$item'
					",3);

					foreach($compList as $comp) {
						$GLOBALS['lDB']->put("
							DELETE FROM
								rv_res_item_comp
							WHERE
								rv_res_item_comp.rv_res_item_comp_ix = '$comp'
						");
					}

					$GLOBALS['lDB']->put("
						DELETE FROM
							rv_reservation_item
						WHERE
							rv_reservation_item_ix = '$item'
					");
				}
			}

			$list = $GLOBALS['lDB']->get("
				SELECT
					rv_extra_ix
				FROM
					rv_extra
				WHERE
					rv_reservation_id = '$wizResId'
			",3);

			foreach ($list as $extra) {
				$sql = "
					DELETE FROM
						rv_extra
					WHERE
						rv_extra_ix = '$extra'
				";
				$GLOBALS['lDB']->put($sql);
			}

			$GLOBALS['lDB']->put("
				DELETE FROM
					rv_reservation
				WHERE
					rv_reservation_ix = '".$wizResId."'
			");

			unsetWizResId($wizResId);

			session_set(array(
				'addedExpiry'=>false,
				'calStepNumber'=>"1"
			));
		}
	} else {
		unsetWizResId($wizResId);
		session_set(array(
			'addedExpiry'=>false,
			'calStepNumber'=>"1"
		));
	}
}

if (isset($_SESSION['calStepNumber']) && $_SESSION['calStepNumber'] == "2") {
	redirectTo(" reservation.php?639");
}

session_set(array(
	'addedExpiry'=>false,
	'calStepNumber'=>"1"
));

if(isset($_POST['year'])) {
	$calStartDate = $_POST['year'] . "-" . $_POST['select_month'] . "-" . $_POST['select_day'];
} else {
	$calStartDate = $_SERVER['argv'][1];
}

if (trim($_SERVER['argv'][2]) != "") {
	$calPropList = explode(":",$_SERVER['argv'][2]);
}

$calStatusList = "";
if (trim($_SERVER['argv'][3]) != "") {
	$calStatusList = explode(":",$_SERVER['argv'][3]);
}

$wizAgentId	= $_SERVER['argv'][4];
$GLOBALS['temp']['fAgentId'] = $_SERVER['argv'][4];

if (trim($_SERVER['argv'][5]) != "") {
	$calRateList = explode(":",$_SERVER['argv'][5]);
}

$GLOBALS['temp']['fContactId'] = $_SERVER['argv'][6];
// $calStartDate = "2003-04-06";


// System variables
$userId = isset($GLOBALS['userid']) ? $GLOBALS['userid'] : "";
$calLimitDisplay = $GLOBALS['limit_yn'];
$calMaxDisplay = $GLOBALS['sc_grp_avail_limit'];

(isMasterDB()) ? $canCalWizard = "1" : $canCalWizard = "0";

// Determine the userStatus
if ($GLOBALS['pr_sys_code'] == "9") {
	$calAgentId = "0";
	$userStatusId = "3";
} else {
	if ($GLOBALS['pr_business_link'] != "0") {
		$calAgentId = "0";
		$userStatusId = "2";
	} else {
		if ($GLOBALS['is_an_agent']) {
			$calAgentId = $GLOBALS['userid'];
			$userStatusId = "1";
		} elseif ($GLOBALS['pr_agent_link'] != "0") {
			$calAgentId = $GLOBALS['pr_agent_link'];
			$userStatusId = "1";
		} else {
			$calAgentId = "0";
			$userStatusId = "0";
		}
	}
}
if ($userStatusId == 1 || $GLOBALS['temp']['fContactId'] == "0" || $GLOBALS['temp']['fContactId'] == "") {
	if ($calAgentId != "0" && $calAgentId != "") {
		$GLOBALS['temp']['fAgentId'] = $calAgentId;
	}
}

if ($userStatusId > 0 && $GLOBALS['temp']['fAgentId'] == "") {
	$GLOBALS['temp']['fAgentId'] = $calAgentId;
}

$GLOBALS['temp']['canSeePastDates'] = "false";

if ($userStatusId > 1) {
	$GLOBALS['temp']['canSeePastDates'] = "true";
}

// Variables
$userStatusList = array("0" => "Public", "1" => "Agent", "2" => "Internal", "3" => "System");
$userStatusName	= $userStatusList[$userStatusId];

(checkJob(29,0) && $userStatusId > 0) ? $calEnableOcc = "1" : $calEnableOcc = "0";

$calAllowProvs = $GLOBALS['showProv'];

($wizResId != "") ? $wizLoadContents = "1": $wizLoadContents = "0";

if ($wizAgentId == "") {
	$wizAgentId = "0";
}

$calProvStatusId = "20";
$defaultStatusList = array("20","30","25");
$defaultPeriod = "21";
$blockRateOverLap = "0";
$blockRateData = $GLOBALS['lDB']->get("
	SELECT
		rf_period_split
	FROM
		rf_default
",4);

if ($blockRateData == "2") {
	$blockRateOverLap = "1";
}

if($userStatusId <= "1"){
	$GLOBALS['temp']['extRate'] = "";
	$GLOBALS['temp']['intRate'] = "collapse printCollapse";
} else {
	$GLOBALS['temp']['extRate'] = "collapse printCollapse";
	$GLOBALS['temp']['intRate'] = "";
}

// Start process for default access controlled, correctly sequenced proplist
$sql = "
	SELECT
		pr_business_id
	FROM
		pr_business
	WHERE
		pr_bus_inactive_yn = '0'
	ORDER BY
		pr_business_parent ASC
	LIMIT 1
";

$propMaster = $GLOBALS['lDB']->get($sql,4);

calAcRecurse($propMaster);

global $calAcRecurseResult;

// Get access control Property List
$tempPropData = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id,
		pr_persona.pr_name_last
	FROM
		sc_accomm, ac_accomm_type, pr_business, pr_persona
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		AND	ac_accomm_type.ac_accomm_type_inactive_yn=0
		AND	ac_accomm_type.pr_business_id = pr_business.pr_business_id
		AND	pr_business.pr_bus_inactive_yn= '0'
		AND	pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
",2);

$acPropList	= array();
$calPropData = array();
$xmax = sizeof($tempPropData);

for ($x = 0; $x < $xmax; $x++) {
	$key = $tempPropData[$x][0];
	array_push($acPropList,$key);
	$calPropData[$key] = $tempPropData[$x][1];
}

$defaultPropList = array();
$aamax = sizeof($calAcRecurseResult);

for($aa = 0;$aa < $aamax; $aa++) {
	$key = $calAcRecurseResult[$aa];
	if(in_array($key,$acPropList)) {
		array_push($defaultPropList,$key);
	}
}
// End get of default proplist

// Build the sql to find the default rates for this user.
if ($userStatusId > "1") {
	$sql = "
		SELECT
			rt_rate_type.rt_rate_type_ix,
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_symbol
		FROM
			rt_rate_type
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			rt_rate_type.rt_rate_type_inactive_yn = '0'
		ORDER BY
			rt_rate_type.rt_rate_type_desc
	";
} else {
	if ($calAgentId != "0" && !$GLOBALS['lDB']->count("pr_agent_rate","pr_agent_id",$calAgentId,0)) {
		$sql = "
			SELECT
				rt_rate_type.rt_rate_type_ix as rt_rate_type_id,
				rt_rate_type.rt_rate_type_desc,
				rf_currency.rf_currency_symbol
			FROM
				pr_agent_rate
				INNER JOIN rt_rate_type ON pr_agent_rate.rt_rate_type_id = rt_rate_type.rt_rate_type_ix
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
			WHERE
				pr_agent_rate.pr_agent_id = '$calAgentId'
				AND rt_rate_type_inactive_yn = '0'
			ORDER BY
				pr_agent_rate.pr_agent_rate_default_yn DESC,
				rt_rate_type.rt_rate_type_desc
		";
	} else {
		$sql = "
			SELECT
				rt_rate_type.rt_rate_type_ix as rt_rate_type_id,
				rt_rate_type.rt_rate_type_desc,
				rf_currency.rf_currency_symbol
			FROM
				rf_default_rate
				INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rf_default_rate.rf_default_rate_id
				INNER JOIN rf_currency ON rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
			WHERE
				rt_rate_type_inactive_yn = '0'
			ORDER BY
				rt_rate_type.rt_rate_type_desc
		";
	}
}

$tempRateData = $GLOBALS['lDB']->get($sql,2);
$defaultRateList = array();
$calRateData = array();
$ymax = sizeof($tempRateData);

for($y = 0; $y < $ymax; $y++) {
	$key = $tempRateData[$y][0];
	array_push($defaultRateList,$key);
	$calRateData[$key] = $tempRateData[$y];
}

// Default dates
$defaultStartDate = date("Y-m-d");
$defaultStartDateTime = date("Y-m-d H:i:s");
$defaultStartYear = date("Y");
$defaultStartMonth = date("m");
$defaultStartDay = date("d");

// Validate required calendar variables
if ($calStartDate == "") {
	$calStartDate = $defaultStartDate;
	$calStartYear = $defaultStartYear;
	$calStartMonth = $defaultStartMonth;
	$calStartDay = $defaultStartDay;
} else {
	$tempStartDate 		= explode("-",$calStartDate);
	if(sizeof($tempStartDate) == 3) {
		$tempStartDateFmt = date("Y-m-d",mktime(0,0,0,$tempStartDate[1],$tempStartDate[2]+1,$tempStartDate[0]));
	} else {
		$tempStartDateFmt = "0000-00-00";
	}


	if (sizeof($tempStartDate) == "3" && ($tempStartDateFmt >= $defaultStartDate || $userStatusId > 1) ) {
		$calStartYear 	= $tempStartDate[0];
		$calStartMonth 	= $tempStartDate[1];
		$calStartDay 		= $tempStartDate[2];
	} else {
		$calStartDate 	= $defaultStartDate;
		$calStartYear 	= $defaultStartYear;
		$calStartMonth 	= $defaultStartMonth;
		$calStartDay 		= $defaultStartDay;
	}
}

$redoStartDate = "0";

if (strlen($calStartDay) == "1") {
	$calStartDay = str_pad($calStartDay,2,"0",STR_PAD_LEFT);
	$redoStartDate 	= "1";
}

if (strlen($calStartMonth) == "1") {
	$calStartMonth = str_pad($calStartMonth,2,"0",STR_PAD_LEFT);
	$redoStartDate = "1";
}

$calStartDate = $calStartYear."-".$calStartMonth."-".$calStartDay;

// Validate the statusList
if (!is_array($calStatusList)) {
	$calStatusList = $defaultStatusList;
} else {
	$allowedStatusList = $GLOBALS['lDB']->get("SELECT rf_reservation_status_id FROM rf_reservation_status",3);
	$tempStatusList = array();
	$bmax = sizeof($allowedStatusList);

	for($b = 0; $b < $bmax; $b++) {
		if(in_array($allowedStatusList[$b],$calStatusList)){
			array_push($tempStatusList,$allowedStatusList[$b]);
		}
	}

	if (sizeof($tempStatusList) == 0 || $tempStatusList[0] == "0"){
		$calStatusList = $defaultStatusList;
	} else {
		$calStatusList = $tempStatusList;
		unset($tempStatusList);
	}
}

// Validate the propList
if (!is_array($calPropList)) {
	$calPropList = $defaultPropList;
} else {
	$tempPropList = array();
	$cmax = sizeof($defaultPropList);

	for($c = 0; $c < $cmax; $c++) {
		if (in_array($defaultPropList[$c],$calPropList)) {
			array_push($tempPropList,$defaultPropList[$c]);
		}
	}

	if (sizeof($tempPropList) == 0) {
		$calPropList = $defaultPropList;
	} else {
		$calPropList = $tempPropList;
		unset($tempPropList);
	}
}

// Validate the rateList
if (!is_array($calRateList)) {
	$calRateList = $defaultRateList;
} else {
	$tempRateList = array();
	$pmax = sizeof($calRateList);

	for($p = 0; $p < $pmax; $p++) {
		if (in_array($calRateList[$p],$defaultRateList)) {
			array_push($tempRateList,$calRateList[$p]);
		}
	}

	if (sizeof($tempRateList) == 0) {
		$calRateList = $defaultRateList;
	} else {
		$calRateList = $tempRateList;
		unset($tempRateList);
	}
}

// Get default rateTypeId
($wizAgentId != "0" && $wizAgentId != "") ? $defRateIdSql = "select rt_rate_type_id from pr_agent where pr_agent_id = '$wizAgentId'" : $defRateIdSql = "select rt_rate_type_id from rf_default";

$defaultRateId = $GLOBALS['lDB']->get($defRateIdSql,4);

//* For now, only have 1 rate
if (sizeof($calRateList) > 1) { $calRateList = array($defaultRateId); }
if (sizeof($calRateList) < 1) { $calRateList = array("0"); }
//*/

// Generate the AccommList and the availability data array to be used for availability calculation
$tempAvailData = array();
$calAccommList = array();
$calAccommData = array();

$accommList = $GLOBALS['lDB']->get("
	SELECT
		sc_accomm.ac_accomm_type_id
	FROM
		sc_accomm
		INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id
			AND	sc_user.pr_user_id = '".$GLOBALS['userid']."'
",3);

$dmax = sizeof($calPropList);

for ($d = 0; $d < $dmax; $d++) {
	$propId = $calPropList[$d];
	$sql = "
		SELECT
			ac_accomm_type_ix,
			ac_accomm_desc,
			ac_accomm_name_short
		FROM
			ac_accomm_type
		WHERE
			pr_business_id = '$propId'
			AND ac_accomm_type_inactive_yn=0
			AND ac_accomm_type_ix IN ('".join("','",$accommList)."')
		ORDER BY
			ac_accomm_type.pr_business_id,
			ac_accomm_type.ac_accomm_sequence
	";

	$tempResult = $GLOBALS['lDB']->get($sql,2);

	$tempAvailData[$propId] = array();
	$emax = sizeof($tempResult);

	for ($e = 0; $e < $emax; $e++) {
		$key = $tempResult[$e][0];
		$tempResult[$e]['ac_accomm_no_of_units'] = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				ac_accomm_room
			WHERE
				ac_accomm_type_id = '$key'
				AND ac_accomm_room_inactive_yn = 0
		",4);
		$tempResult[$e][3] = $tempResult[$e]['ac_accomm_no_of_units'];

		$tempAvailData[$propId][$key] = array();
		$calAccommData[$key] = $tempResult[$e];

		array_push($calAccommList,$tempResult[$e][0]);
	}
}

// Generate the daylist for the calendar
$calDateList = array();
$calDateKeyList = array();

for ($k = 0; $k < $defaultPeriod; $k++) {
	$date = date("Y-m-d",mktime (0,0,0,$calStartMonth,$calStartDay+$k,$calStartYear));
	$calDateList[$k] = $date;
	$calDateKeyList[$date] = "0";
}

$endDateId 	= $defaultPeriod - 1;
$calEndDate = $calDateList[$endDateId];

$tempEndDate = explode("-",$calEndDate);
$newEndDate = date("Y-m-d",mktime(0,0,0,$tempEndDate[1],$tempEndDate[2]+1,$tempEndDate[0]));

// Get the right periodId
$sql = "
	SELECT
		rt_period.rt_period_ix,
		rt_period_date_from,
		rt_period_date_to,
		rt_period_desc
	FROM
		rt_period
	WHERE
		(
			rt_period.rt_period_date_from >= '$calStartDate'
			AND	rt_period.rt_period_date_from <= '$calEndDate'
		) OR (
			rt_period.rt_period_date_to >= '$calStartDate'
			AND	rt_period.rt_period_date_to <= '$calEndDate'
		) OR (
			rt_period.rt_period_date_from < '$calStartDate'
			AND rt_period.rt_period_date_to > '$calEndDate'
		)
	ORDER BY
		rt_period_date_from
	LIMIT 1
";

$tempAcPeriod = $GLOBALS['lDB'] ->get($sql,1);
$calAcPeriodId = $tempAcPeriod[0];

// Determine Month(s) and Year(s)
$temp = explode("-",$calEndDate);
$calEndYear = $temp[0];
$calEndMonth = $temp[1];
$calEndDay = $temp[2];

$startMonthName = date("F",mktime (0,0,0,$calStartMonth,$calStartDay,$calStartYear));
$startYear = date("Y",mktime (0,0,0,$calStartMonth,$calStartDay,$calStartYear));
$stopMonthName = date("F",mktime (0,0,0,$calEndMonth,$calEndDay,$calEndYear));
$stopYear = date("Y",mktime (0,0,0,$calEndMonth,$calEndDay,$calEndYear));

// Determine Full Weekend Dates
$weekendList = makeDates($calStartDate,$defaultPeriod,"Y-m-d",1);

// Setup the table heads
$headDateList = makeDates($calStartDate,$defaultPeriod,"d");
$wmax = sizeof($headDateList);

for ($w = 0; $w < $wmax; $w++) {
	$date = $headDateList[$w];
	$GLOBALS['temp']["cHD".$w] = $date;

	if (in_array($calDateList[$w],$weekendList)) {
		$GLOBALS['temp']["cHC".$w] = "wkEnd";
	} else {
		$GLOBALS['temp']["cHC".$w] = "wk";
	}
}
// Get all the rate data for each accomm type
$accommRateData = array();
$agmax = sizeof($defaultRateList);

$GLOBALS['temp']['canOccCal'] = " style=\"visibility:hidden\"";

if (checkJob("29")) {
	if ($userStatusId > "0") {
		$GLOBALS['temp']['canOccCal'] = "";
	}
}

$GLOBALS['temp']['provCheck']	= "";
$GLOBALS['temp']['isProv'] 		= "0";
$GLOBALS['temp']['provDis'] 	= "";

if (isset($GLOBALS['temp']['allowProvs']) && $GLOBALS['temp']['allowProvs'] == "0") {
	$GLOBALS['temp']['provDis'] = "";
}

// Phase 4 - Prepare result output for display
$calAccommNotes = array();
$calAccommNotesKey = array();
$aemax = sizeof($calAccommList);

for($ae = 0; $ae < $aemax; $ae++) {
	$accommId = $calAccommList[$ae];
	$accommNote = $GLOBALS['lDB']->get("SELECT ac_accomm_note FROM ac_accomm_type WHERE ac_accomm_type_ix = '$accommId'",4);

	$accommNote = t_encodeOverlib($accommNote);
	$calAccommNotesKey[$accommId] = $accommNote;
	array_push($calAccommNotes,$accommNote);
}

$calPropNotes = array();
$calPropNotesKey = array();
$admax = sizeof($calPropList);
for ($ad=0;$ad<$admax;$ad++) {
	$propid = $calPropList[$ad];
	$propNote = $GLOBALS['lDB']->get("SELECT pr_bus_memo_cal FROM pr_business WHERE pr_business_id = '$propid'",4);

	$propNote = t_encodeOverlib($propNote);
	$calPropNotesKey[$propid] = $propNote;
	array_push($calPropNotes,$propNote);
}

// Phase 5 - Echo variables
$rateId = $_SERVER['argv'][5];

if(trim($rateId) == "" || $rateId == "0") {
	$rateId = $GLOBALS['lDB']->get("
		SELECT
			pr_agent_rate.rt_rate_type_id
		FROM
			pr_agent_rate
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
		WHERE
			pr_agent_id = '$calAgentId'
		ORDER BY
			pr_agent_rate_default_yn DESC,
			rt_rate_type.rt_rate_type_desc ASC
	",4);
	if(trim($rateId) == "" || $rateId == "0") {
		if ($userStatusId == "0"){
			$rateId = $GLOBALS['lDB']->get("select rf_default_rate_id from rf_default_rate", 4);
		} else {
			$rateId = $GLOBALS['lDB']->get("select rt_rate_type_id from rf_default", 4);
		}
	}
}
$rateInfo = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_ix = '$rateId'
",1);

$GLOBALS['temp']['rateSelect'] = "
	<td>
	<button class=\"button buttonFilter\" type=\"button\" style=\"width: 100%; height: 20px;\" onclick=\"rateDropdownShow();\">
		Rate Type
	</button>
	</td>
	<td>
	<input type=\"text\" disabled id=\"rateSelectLabel\" style=\"width:200px;\" value=\"$rateInfo[rt_rate_type_desc], $rateInfo[rf_currency_symbol]\">
	<input type=\"hidden\" id=\"rateSelect\" value=\"$rateId\"></td>";


$GLOBALS['temp']['calendar_data'] = '
	var accommnotes					= ["' . join('","',$calAccommNotes) . '"];
	var accommIdList				= ["' . join('","',$calAccommList) . '"];
	var middledate					= "' . $calStartDay . '-' . $calStartMonth . '-' . $calStartYear . '";
	var middledateR					= "' . $calStartDate . '";
	var days								= ["' . join('","',makeDates($calStartDate,$defaultPeriod,"d")) . '"];
	var weekends						= ["' . join('","',makeDates($calStartDate,$defaultPeriod,"Ymd",1)) . '"];
	var months							= ["' . $calStartMonth . '","' . $calEndMonth . '"];
	var years								= ["' . $calStartYear . '","' . $calEndYear . '"];
	var propertylist				= [];
	var selectedProperties	= "' . join(":",$calPropList) . '";
	var selectedStatuses		= "' . join(":",$calStatusList) . '";
	var propertylistInfo		= ["' . join('","',$calPropNotes) . '"];
	var securitygroup				= "5";
	var calRateId						= "' . $calRateList[0] . '";
';

$calNewPeriodStartDay = "0";
$calNewPeriodStart = "";
$calAcPeriodEndId = "";

if ($calNewPeriodStart >= $calStartDate){
	$calNewPeriodStartDay = substr($calNewPeriodStart,8,2);
}

$GLOBALS['temp']['calendar_data'] .= "var calNewPeriodStart = '".$calNewPeriodStartDay."';\n";
$GLOBALS['temp']['calendar_data'] .= "var calPrdStart = '".str_replace("-","/",$calNewPeriodStart)."';\n";
$GLOBALS['temp']['calendar_data'] .= "var calNewPrdId = '".$calAcPeriodEndId."';\n";
$GLOBALS['temp']['calendar_data'] .= "var calPeriodId = '".$calAcPeriodId."';\n";

// Screen output variables
$GLOBALS['temp']['wizResId'] = (string) $wizResId;
$GLOBALS['temp']['wizLoadContents'] = (string) $wizLoadContents;
$GLOBALS['temp']['wizAgentId'] = (string) $wizAgentId;
$GLOBALS['temp']['masterdb'] = (string) $canCalWizard;
$GLOBALS['temp']['userStatusId'] = (string) $userStatusId;
$GLOBALS['temp']['HaveBizLink'] = (string) "0";
$GLOBALS['temp']['HaveAgnLink'] = (string) "0";
$GLOBALS['temp']['IsPublic'] = (string) "0";

if ($userStatusId > 1) {
	$GLOBALS['temp']['HaveBizLink'] = "1";
}

if ($userStatusId == "1") {
	$GLOBALS['temp']['HaveAgnLink'] = "1";
}

if ($userStatusId == "0") {
	$GLOBALS['temp']['IsPublic'] = "1";
}

(in_array("20",$calStatusList)) ? $GLOBALS['temp']['isProv'] = "1": $GLOBALS['temp']['isProv'] = "0";

$GLOBALS['temp']['canOcc'] = (string) $calEnableOcc;
$GLOBALS['temp']['allowProvs'] = (string) $calAllowProvs;
$GLOBALS['temp']['AgentID'] = (string) $calAgentId;
$GLOBALS['temp']['calAcPeriodId'] = (string) $calAcPeriodId;

(isset($GLOBALS['userid']) ? $GLOBALS['userid'] : "" == $calAgentId) ? $GLOBALS['temp']['isAgent'] = "1": $GLOBALS['temp']['isAgent'] = (string) "0";

$GLOBALS['temp']['calLimitDisplay'] = (string) $calLimitDisplay;
$GLOBALS['temp']['calMaxDisplay'] = (string) $calMaxDisplay;

$GLOBALS['temp']['calPropList'] = join(", ",$calPropList);
$GLOBALS['temp']['defaultPropList'] = join(", ",$defaultPropList);
$GLOBALS['temp']['calAccommList'] = join(", ",$calAccommList);
$GLOBALS['temp']['calStatusList'] = join(", ",$calStatusList);
$GLOBALS['temp']['calRateList'] = join(", ",$calRateList);

$rateData = $GLOBALS['lDB']->get("
	SELECT
		rt_rate_type.rt_rate_type_desc,
		rf_currency.rf_currency_symbol
	FROM
		rt_rate_type
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
	WHERE
		rt_rate_type.rt_rate_type_ix = '".$calRateList[0]."'
",1);

$GLOBALS['temp']['rateDesc'] = $rateData[0];
$GLOBALS['temp']['resCurr'] = $rateData[1];

$GLOBALS['temp']['calStartDate'] = (string) $calStartDate;
$GLOBALS['temp']['calEndDate'] = (string) $calEndDate;

$GLOBALS['temp']['mnLeft'] = (string) $startMonthName;
$GLOBALS['temp']['yrLeft'] = (string) $startYear;
$GLOBALS['temp']['mnRight'] = (string) $stopMonthName;
$GLOBALS['temp']['yrRight'] = (string) $stopYear;
$GLOBALS['temp']['weekendList'] = join(", ",$weekendList);

$GLOBALS['temp']['blockRateOverLap'] = $blockRateOverLap;
$calOutputData = "";
$GLOBALS['temp']['rows'] = $calOutputData;

// Set the form start tag containing the submit action
$GLOBALS['temp']['formstart'] = "<form id=\"quickSearchForm\" name=\"form7\" action=\"".$GLOBALS[$form]->TargetPage."?20\" method=\"".$GLOBALS[$form]->Method."\" enctype=\"".$GLOBALS[$form]->Enctype."\" style=\"padding: 0; margin: 0;\">\n";

$prop_tag = Join(":",$calPropList);

// Set the form submit tag and required hidden fields
if(!isset($GLOBALS['mode'])) {
	$GLOBALS['mode'] = "";
}
if(!isset($value)) {
	$value = "";
}
$GLOBALS['temp']['formsubmit'] = "
		<input type=\"hidden\" name=\"mode\" value=\"$GLOBALS[mode]\">
		<input type=\"hidden\" name=\"jobid\" value=\"\">
		<input type=\"hidden\" name=\"record\" value=\"$value\" disabled>
		<input type=\"hidden\" name=\"middledate\" value=\"$calStartDate\" disabled>
		<input type=\"hidden\" name=\"property_select\" value=\"$prop_tag\" disabled>
		<input type=\"hidden\" id=\"status\" name=\"status\" value=\"".join(":",$calStatusList)."\">
	</form>
";

$GLOBALS[$form]->AddField("form7_resAgentId","rv_agent_id",$GLOBALS['temp']['fAgentId'],0);
$GLOBALS['form7_resAgentId']->onChange = "return;";
$GLOBALS['form7_resAgentId']->IsHidden = "1";

$GLOBALS[$form]->AddField("form7_resContactId","rv_corr_persona_id",$GLOBALS['temp']['fContactId'],0);
$GLOBALS['form7_resContactId']->IsHidden = "1";


// Phase 6 - Show the itinerary
$GLOBALS['temp']['hideItinerary'] = " style=\"display:none\"";
$GLOBALS['temp']['hideClearItineraryButton'] = " style=\"display:none\"";
$GLOBALS['temp']['hideNextStepButton'] = " style=\"display:none\"";

$GLOBALS['temp']['itinTotal'] = "";
$GLOBALS['temp']['itinComm'] = "";
$GLOBALS['temp']['commText'] = "Commission";
$GLOBALS['temp']['itinFinal'] = "";

$GLOBALS['temp']['iRows'] = "";
$GLOBALS['temp']['wizCalIndex'] = "";
$GLOBALS['temp']['wizCalData'] = "";
$GLOBALS['temp']['isItinerary'] = "0";

$GLOBALS['temp']['rv_split_items'] = "";

if($wizResId != "") {
	if(!$GLOBALS['lDB']->count("rv_reservation_item","rv_reservation_id",$wizResId,0)) {
		$list = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item_ix
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_id = '$wizResId'
			ORDER BY
				rv_item_date_arrive,
				ac_accomm_type_id
		",3);

		$resData = $GLOBALS['lDB']->get("
			SELECT
				rt_rate_type.rt_rate_type_desc,
				rf_currency.rf_currency_symbol,
				rv_reservation.rv_invoice_currency_id
			FROM
				rv_reservation
				LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
			WHERE
				rv_reservation_ix = '".$wizResId."'
		",1);

		$rf_currency_symbol = $resData['rf_currency_symbol'];

		if (!isset($GLOBALS['temp']['rateDesc']) || $GLOBALS['temp']['rateDesc'] == "") {
			$GLOBALS['temp']['rateDesc'] = $resData['rt_rate_type_desc'];
		}

		if (!isset($GLOBALS['temp']['resCurr']) || $GLOBALS['temp']['resCurr'] == "") {
			$GLOBALS['temp']['resCurr'] = $resData['rf_currency_symbol'];
		}

		if (!isset($GLOBALS['temp']['resCurrId']) || $GLOBALS['temp']['resCurrId'] == "") {
			$GLOBALS['temp']['resCurrId'] = $resData['rv_invoice_currency_id'];
		}

		$temphtml = Join("\n",File(__DIR__ . "/../../../public/html/cal_reservation_item_table_rows.htm"));
		$prevars = array();
		$wizCalData = array();
		$rv_split_items = array();
		$xmax = sizeof($list);
		$resRate = $GLOBALS['lDB']->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4);
		for ($x = 0; $x < $xmax; $x++) {
			// Input parameters (for testing purposes)
			$rv_reservation_item_id = $list[$x];

			/* -------------------------------------------------------------------------
			 * Obtain reservation item details
			 * ---------------------------------------------------------------------- */

			$itemId = $list[$x];
			$resItem = getItemDetails($rv_reservation_item_id);

			if ($resItem['rv_item_split_yn'] == "1") {
				array_push($rv_split_items,$rv_reservation_item_id);
			}

			$resItem['rt_rate_type_desc_fmt'] = t_encodeOverlib($resItem['rt_rate_type_desc']);
			$special = itemSpecialItinLineIndicator($itemId);
			$resItem['rateLabel'] = "Rte".$special;
			$resItem['rate_text_colour'] = "";
			if($resRate != $resItem['rt_rate_type_id']) {
				$resItem['rateLabel'] = "Ovr".$special;
				$resItem['rate_text_colour'] = "#233f92";
			}
			if($resItem['commPerc'] != $resItem['itemCommPerc']) {
				$resItem['rateLabel'] .= " %";
			}


			$resItem['total'] = getDisplayItemTotal($itemId);
			$resItem['arrive1']	= $resItem['rv_item_date_arrive'];
			$resItem['arrive'] = chng_date($resItem['rv_item_date_arrive'],"-");
			$resItem['depart'] = chng_date($resItem['rv_item_date_depart'],"-");
			$resItem['rv_reservation_item_id']	= $rv_reservation_item_id;

			$resItem['total'] = getDisplayItemTotal($rv_reservation_item_id);

			$resItem['hideCompButton'] = "";
			$resItem['allowCompButton'] = "true";
			$resItem['hideRoomButton'] = "";
			$resItem['allowRoomButton'] = "true";
            $resItem['hideSpecialButton'] = "";
            $resItem['allowSpecialButton']=  "true";

			if ($userStatusId < 2) {
				$resItem['hideCompButton'] = " style=\"visibility:hidden\"";
				$resItem['allowCompButton'] = "false";
				$resItem['hideRoomButton'] = " style=\"visibility:hidden\"";
				$resItem['allowRoomButton'] = "true";
                $resItem['hideSpecialButton'] = " style=\"visibility: hidden;\"";
                $resItem['allowSpecialButton']=  "false";
			}

			$resItem['hideDelButton'] = "";
			$resItem['allowDelButton'] = "true";

			$resItem['showGoTo'] = "";

			// Generate the js array
			if(in_array($resItem['ac_accomm_type_id'],$calAccommList)) {
				$ignore	= "0";
				$period	= $resItem['noNights'];
				$startDate = $resItem['rv_item_date_arrive'];

				if($resItem['rv_item_date_arrive'] < $calStartDate) {
					$startDate 	= $calStartDate;
					$buffer = dateSubtract($calStartDate,$resItem['rv_item_date_arrive']);

					if ($buffer >= $resItem['noNights']) {
						$ignore = "1";
					} else {
						$period = $resItem['noNights'] - $buffer;
					}
				}

				$row = "";

				if ($ignore == "0") {
					$list2 = makeDates($startDate.":".$calEndDate,$period,"m:d:Y");
					$row = "var RI_".$rv_reservation_item_id." = new Array(";

					if (isset($list2[0]) && $list2[0] != "") {
						$lmax = sizeof($list2);
						for ($l = 0; $l < $lmax; $l++) {
							$row .= "\"".$resItem['ac_accomm_type_id'].":".$list2[$l]."\",";
						}

						$row .= (string) $resItem['rv_item_accomm_count'].");\n";
						$wizCalData["RI_".$rv_reservation_item_id] = $row;
					}
				}
			}
			// End the js array
			if (isset($resItem['pr_name_last']) && isset($prevars['pr_name_last']) && ($resItem['pr_name_last'] == $prevars['pr_name_last'])) {
				if ($resItem['depart'] == $prevars['depart'] && $resItem['arrive'] == $prevars['arrive']) {
					$resItem['pr_name_last'] = "";
				}
			} else {
				$prevars['pr_name_last'] = $resItem['pr_name_last'];
			}

			$procvars = array("depart","arrive");
			$zmax = sizeof($procvars);

			for($z = 0; $z < $zmax; $z++) {
				$vali = $procvars[$z];
				if (!isset($prevars[$vali]) || ($resItem[$vali] != $prevars[$vali])) {
					$prevars[$vali] = $resItem[$vali];
				} else {
					if ($resItem['pr_name_last'] == "") {
						$resItem[$vali] = "";
					}
				}
			}

			$roomList = join(":",$GLOBALS['lDB']->get("
				SELECT
					ac_accomm_room_id
				FROM
					rv_res_item_group
				WHERE
					rv_reservation_item_id = '$rv_reservation_item_id'
			",3));

			$roomRequest = $GLOBALS['lDB']->get("
				SELECT
					rv_room_requested_yn,
					rv_room_request_reason
				FROM
					rv_res_item_group
				WHERE
					rv_reservation_item_id = '$rv_reservation_item_id'
			",1);

			$resItem['roomList'] = $roomList;
			$resItem['requestYN'] = $roomRequest['rv_room_requested_yn'];
			$resItem['requestReason'] = str_replace("<BR>","\\n",t_encodeOverlib($roomRequest['rv_room_request_reason']));

			$resItem['rowClass'] = "txt";
			$result = $GLOBALS['lDB']->get("
				SELECT
					COUNT(rv_item_comp_edit_yn)
				FROM
					rv_res_item_comp
				WHERE
					rv_item_comp_edit_yn = 1
					AND rv_reservation_item_id = '$rv_reservation_item_id'
			",4);
			if($result > 0){
				$resItem['rowClass'] = "txtbr";
			}

			$GLOBALS['temp']['iRows'] .= showpage($resItem,$temphtml);
			$GLOBALS['temp']['isItinerary'] = "1";
		}

		$GLOBALS['temp']['wizCalData'] = "";
		$keys = array_keys($wizCalData);
		$jmax = sizeof($keys);

		for($j = 0; $j < $jmax; $j++) {
			$itemId = $keys[$j];
			$GLOBALS['temp']['wizCalData'] .= $wizCalData[$itemId];
		}

		$GLOBALS['temp']['wizCalIndex'] = Join(",",$keys);

		if ($GLOBALS['temp']['iRows'] == "") {
			$GLOBALS['temp']['iRows'] = "
				<tr>
					<td bgcolor='#000000' width='1'><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
					<td colspan='10' width='100%' class='txt' align='center'>No Items found.</td>
					<td bgcolor='#000000' width='1'><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
				</tr>
			";
		}

		$showItinerary = false;

		if ($showAddItinerary) {
    		if ($GLOBALS['temp']['isItinerary'] == "1") {
				$showItinerary = true;
				$GLOBALS['temp']['hideItinerary'] = "";
				$GLOBALS['temp']['hideClearItineraryButton'] = "";
				$GLOBALS['temp']['hideNextStepButton'] = "";
			}
		}

		// Totals Display
		$data = getResDocTotals($wizResId,array(),array(),array(),1);
		$GLOBALS['temp']['itinTotal'] = $data['total_gross'];
		$GLOBALS['temp']['itinComm'] = $data['total_comm'];

		if ($GLOBALS['temp']['itinComm'] < 0) {
			$GLOBALS['temp']['commText'] = "Less Commission";
		}

		$GLOBALS['temp']['itinFinal'] = getDisplayResTotals($wizResId);
	}

	if ($GLOBALS['temp']['iRows'] == "") {
		$GLOBALS['temp']['iRows'] = "
			<tr>
				<td bgcolor='#000000' width='1'><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
				<td colspan='10' width='100%' height='25' class='txt' align='center'>Create an item to continue your reservation.</td>
				<td bgcolor='#000000' width='1'><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
			</tr>
		";
	}

	$sql = "
		SELECT
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_symbol,
			rv_reservation.rt_rate_type_id,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_corr_persona_id,
			rv_reservation.rv_commission_perc,
			rv_reservation.rv_commission_deduct_yn
		FROM
			rv_reservation
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
		WHERE
			rv_reservation.rv_reservation_ix = '$wizResId'
	";

	$rateData = $GLOBALS['lDB']->get($sql,1);

	$GLOBALS['temp']['rateDesc'] = $rateData[0];
	$GLOBALS['temp']['resCurr'] = $rateData[1];
	$GLOBALS['temp']['rateId'] = $rateData[2];
	$GLOBALS['temp']['fAgentId'] = $rateData[3];
	$GLOBALS['temp']['fContactId'] = $rateData[4];
	$GLOBALS['form7_resAgentId']->Value = $GLOBALS['temp']['fAgentId'];
	$GLOBALS['form7_resContactId']->Value = $GLOBALS['temp']['fContactId'];

	if (isset($rv_split_items) && is_array($rv_split_items) && sizeof($rv_split_items) > 0) {
		$GLOBALS['temp']['rv_split_items'] = join(":",$rv_split_items);
	}
}

$GLOBALS['temp']['commPerc'] = "0.00";
$GLOBALS['temp']['commPercDisabled'] = "";
$GLOBALS['temp']['commDeductYes'] = "";
$GLOBALS['temp']['commDeductNo'] = "";
$GLOBALS['temp']['commDeductDisabled'] = "disabled";

$GLOBALS[$form]->AddField("form7_resAgentName","agent_name","",0);

$GLOBALS['form7_resAgentName']->StyleType = "txt";
$GLOBALS['form7_resAgentName']->Size = 18;
$GLOBALS['form7_resAgentName']->Width = 200;
$GLOBALS['form7_resAgentName']->onChange = "return;";
$GLOBALS['temp']['showAgentSearchButton'] = " style=\"display:none\"";
$GLOBALS['temp']['agentNoteButton'] = " style=\"visibility:hidden\"";
$GLOBALS['temp']['hideAgentPopup'] = "";

if ($userStatusId > 0) {
	if ($userStatusId > 1) {
		$GLOBALS['temp']['showAgentSearchButton'] = "";
	}

	$GLOBALS['temp']['agentNoteButton'] = "";

	$name = $lDB->get("
		SELECT
			pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '".$GLOBALS['form7_resAgentId']->Value."'
	",4);

	if ($name == "0") {
		$name = "Direct";
		$GLOBALS['temp']['hideAgentPopup'] = " style=\"visibility:hidden\"";

		// BUG #5486
		$GLOBALS['temp']['commDeductYes'] = "selected='selected'";
		$GLOBALS['temp']['commDeductNo'] 	= "";
		// BUG #5486

	} else {
		$commInfo = $lDB->get("
			SELECT
				pr_agent.pr_agent_commission_perc,
				pr_agent.pr_agent_comm_deduct_yn
			FROM
				pr_agent
			WHERE
				pr_agent_id = '".$GLOBALS['form7_resAgentId']->Value."'
		",1);

		$GLOBALS['temp']['commPerc'] = $commInfo['pr_agent_commission_perc'];
		$GLOBALS['temp']['commPercDisabled'] = "";

		if($commInfo['pr_agent_comm_deduct_yn'] == 1) {
			$GLOBALS['temp']['commDeductYes'] = "selected";
		} else {
			$GLOBALS['temp']['commDeductNo'] = "selected";
		}
		$GLOBALS['temp']['commDeductDisabled'] = "";
	}
	$GLOBALS['form7_resAgentName']->Value = $name;
} else {
	// $GLOBALS['form7_resAgentName']->IsHidden = "1";
	$GLOBALS['form7_resAgentName']->Value = "Direct";

	// BUG #5486
	$GLOBALS['temp']['commDeductYes'] = "selected='selected'";
	$GLOBALS['temp']['commDeductNo'] 	= "";
	// BUG #5486
}

// Only internal users with financial tab update access may edit commission
$allowCommission = ($GLOBALS['userStatusId'] > 1 && isset($GLOBALS['jobLevelArray'][646]) && $GLOBALS['jobLevelArray'][646] > 5);
if(!$allowCommission) {
	$GLOBALS['temp']['commPercDisabled'] = "disabled";
	$GLOBALS['temp']['commDeductDisabled'] = "disabled";
}
$GLOBALS['temp']['allowCommission'] = ($allowCommission ? "1" : "0");

if ($wizResId != "") {
	$agentCount = $lDB->get("SELECT COUNT(pr_persona_ix) FROM pr_persona WHERE pr_persona.pr_persona_ix = '$rateData[rv_agent_id]'",4);

	if($agentCount > 0) {
		$GLOBALS['temp']['commPerc'] = $rateData['rv_commission_perc'];
		// Reset the base agent deduct comm flag setting
		$GLOBALS['temp']['commDeductYes'] = "";
		$GLOBALS['temp']['commDeductNo'] = "";

		if($rateData['rv_commission_deduct_yn'] == 1) {
			$GLOBALS['temp']['commDeductYes'] = "selected";
		} else {
			$GLOBALS['temp']['commDeductNo'] = "selected";
		}
	} else {
		// BUG #5486
		$GLOBALS['temp']['commDeductYes'] = "selected='selected'";
		$GLOBALS['temp']['commDeductNo'] 	= "";
		// BUG #5486
	}
}

$GLOBALS['temp']['showComm'] = "";

if ($userStatusId < 2) {
	$GLOBALS['temp']['showComm'] = "class=\"collapse\"";
}

$GLOBALS[$form]->AddField("form7_resContactName","contact_name","",0);
$GLOBALS['form7_resContactName']->StyleType = "txt";
$GLOBALS['form7_resContactName']->Size = 18;
$GLOBALS['form7_resContactName']->Width = 200;
$GLOBALS['temp']['showAgentSearchButton'] = " style=\"display:none\"";
$GLOBALS['temp']['agentNoteButton'] = " style=\"visibility:hidden\"";

if ($userStatusId > 0) {
	if ($userStatusId > 1) {
		$GLOBALS['temp']['showAgentSearchButton'] = "";
	}

	$GLOBALS['temp']['agentNoteButton'] = "";

	$name = $lDB->get("
		SELECT
			pr_name_first,
			pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '".$GLOBALS['form7_resContactId']->Value."'
	",1);

	$nuname = trim($name['pr_name_first']." ".$name['pr_name_last']);

	if ($nuname == "") {
		$nuname = "No Contact";
	}

	$GLOBALS['form7_resContactName']->Value = $nuname;
} else {
	// $GLOBALS['form7_resContactName']->IsHidden = "1";
	$GLOBALS['form7_resContactName']->Value = "Direct";
}

if ($GLOBALS['temp']['iRows'] == "") {
	$GLOBALS['temp']['iRows'] = "
		<tr>
			<td bgcolor='#000000' width='1'><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
			<td colspan='10' width='100%' height='25' class='txt' align='center'>No itinerary. Click and drag over dates to build an itinerary.</td>
			<td bgcolor='#000000' width='1'><img src='/resource/Resrequest/Application/public/img/1x1.gif'></td>
		</tr>
	";
}

$GLOBALS['temp']['timer'] = "-1";

if ($GLOBALS['temp']['isItinerary'] == "1") {
	$now = date("U");
	$expiry = explode(" ",$lDB->get("
		SELECT
			rv_create_expiry_date
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$wizResId'
	",4));

	$temp1 = explode("-",$expiry[0]);
	$temp2 = explode(":",$expiry[1]);

	// echo $temp2[0]."<br>".$temp2[1]."<br>".$temp2[2]."<br>".$temp1[1]."<br>".$temp1[2]."<br>".$temp1[0]."<br>";

	$expire = date("U",mktime($temp2[0],$temp2[1],$temp2[2],$temp1[1],$temp1[2],$temp1[0]));
	$timer 	= $expire - $now;

	// echo $timer."<br>";
	$GLOBALS['temp']['timer'] = $timer;
}

session_set(array(
	'calStartDate'=>$calStartDate,
	'calEndDate'=>$calEndDate,
	'calPropList'=>$calPropList,
	'calAccommList'=>$calAccommList,
	'calAgentId'=>$calAgentId,
	'calRateList'=>$calRateList,
	'canCalWizard'=>$canCalWizard,
	'blockRateOverLap'=>$blockRateOverLap
));

$GLOBALS['lDB']->isMaster = $tempMasterData;

$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];
$GLOBALS['temp']['EUServer'] = $GLOBALS['EUServer'];

$GLOBALS['temp']['startYear'] = date("Y");
$GLOBALS['temp']['startMonth'] = date("m");
$GLOBALS['temp']['startDay'] = date("d");

$margin = "1";

$GLOBALS['temp']['endYear'] = date("Y",mktime(0,0,0,date("m"),date("d")+$margin,date("Y")));
$GLOBALS['temp']['endMonth'] = date("m",mktime(0,0,0,date("m"),date("d")+$margin,date("Y")));
$GLOBALS['temp']['endDay'] = date("d",mktime(0,0,0,date("m"),date("d")+$margin,date("Y")));

$nights = $margin;

$GLOBALS['temp']['nights'] = $nights;

$calDateLimit = $GLOBALS['lDB']->get("SELECT rf_date_res_limit FROM rf_default",4);

$GLOBALS['temp']['calDateResLimit'] = $calDateLimit;
$GLOBALS['temp']['calDateResLimitNice'] = chng_date($calDateLimit,"-");

/* ----------------------------------------------------------------------------
INSERT INTO sc_job VALUES (693, 'Availability Quick Search', 4, '"1:266:1"', 1);
INSERT INTO sc_job VALUES (694, 'Quick Search Results', 4, '"1:267:1"', 1);
INSERT INTO sc_fun_job VALUES ('', 693, 50, 1);
INSERT INTO sc_fun_job VALUES ('', 694, 50, 1);
---------------------------------------------------------------------------- */
global $principal_id;
global $domain;
$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";
if ($userStatusId == "0" && $GLOBALS['pr_sys_code'] == "7") {
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/reservation_quick_search.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file($GLOBALS['images_dir_on_disk']."/$principal_id/reservation_quick_search.htm")));
	}
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/template_restructure_quick_search.js")) {
		$GLOBALS['temp']['customHTML'] .= '<script>'
			. join("",file($GLOBALS['images_dir_on_disk']."/$principal_id/template_restructure_quick_search.js"))
			. '</script>';
	}

	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/reservation_quick_search.css")) {
			$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />";
			$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/reservation_quick_search.css\" type=\"text/css\" />";
	} elseif(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-reservation_quick-search.css")) {
			$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/template-reservation_quick-search.css\" type=\"text/css\" />";
			$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/shared/global.css\" type=\"text/css\">";
	} else {
		$indexCSS = "<link rel=\"stylesheet\" href=\"styles/reservation_quick_search.css\" type=\"text/css\" />";
	}
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/uikit.min.css")) {
		$indexHTML = "<script type=\"text/javascript\" src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js\"></script>";
		$indexHTML .= "<script type=\"text/javascript\" src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit_image_height.js\"></script>";
		$indexHTML .= "<script type=\"text/javascript\" src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js\"></script>";
		$GLOBALS['temp']['customHTML'] .= $indexHTML;
	} elseif(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/template-reservation_quick-search.css")) {
		$uikitCSS = "<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/ui-kit/uikit.min.css\" />";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js\"></script>\n";
		$uikitCSS .= "<script src=\"/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js\"></script>\n";
	} else {
		$uikitCSS = "";
	}


	$GLOBALS['temp']['customDefaultCSS'] = "
		$uikitCSS
	";

	$GLOBALS['temp']['customCSS'] = "
		
		$indexCSS
	";
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/custom.css")) {
		$GLOBALS['temp']['customCSS'] .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/custom.css\" type=\"text/css\">";
	}

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Don't include anything extra if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customDefaultCSS'] = "";
		$GLOBALS['temp']['customCSS'] = "";
	}
} else {
	$GLOBALS['temp']['customDefaultCSS'] = "";
}