<?php

/**
 * init.form270.php - Reservation Audit Trail Popup
 * Job: 700
 * Function: 52 (Reservation: Tabs)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}
$_SERVER['argv'] = array_pad($_SERVER['argv'],9,"");
$jobId = $_SERVER['argv'][0];
$resnum = $_SERVER['argv'][1];
$showFilters = ($_SERVER['argv'][2] == "True") ? True : False;
$auditDateFrom = $_SERVER['argv'][3];
$auditDateTo = $_SERVER['argv'][4];
$auditTrailUsers = (!empty($_SERVER['argv'][5])) ? $_SERVER['argv'][5] : "";
$modules = (!empty($_SERVER['argv'][6])) ? $_SERVER['argv'][6] : "";
$servers = (!empty($_SERVER['argv'][7])) ? $_SERVER['argv'][7] : "";
$timezone = (!empty($_SERVER['argv'][8])) ? $_SERVER['argv'][8] : date("e");

if (!isset($GLOBALS[$form]) || !is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/audit_res.htm");
}

$rf_reservation_status_id = $lDB->get("SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '" . $lDB->escape($record) . "'",4);
$GLOBALS['temp']['auditType'] = "Reservation";
if($rf_reservation_status_id == "15" || $rf_reservation_status_id == "97") {
	$GLOBALS['temp']['auditType'] = "Allocation";
}

$GLOBALS['temp']['jobId'] = $jobId;
$GLOBALS['temp']['resnum'] = (isset($record)) ? $record : $resnum;
$GLOBALS['tagList']['resnum'] = $record;
$GLOBALS['temp']['showFilters'] = $showFilters;
$GLOBALS['tagList']['resname'] = $lDB->get("select rv_res_name from rv_reservation where rv_reservation_ix = '$record'",4);
$GLOBALS['tagList']['currdate'] = date("d M Y");
$GLOBALS['temp']['auditFromDate'] = $auditDateFrom;
$GLOBALS['temp']['auditToDate'] = $auditDateTo;
$GLOBALS['temp']['auditDateRangeOptAll'] = "";
$GLOBALS['temp']['auditDateRangeOptToday'] = "";
$GLOBALS['temp']['auditDateRangeOptCustomDate'] = "";
$auditFromD = date("d");
$auditFromM = date("m");
$auditFromY = date("Y");
$auditToD = date("d");
$auditToM = date("m");
$auditToY = date("Y");
$noDateRange = false;
if (!empty($auditDateFrom) && $auditDateFrom != "all" && $auditDateFrom != "today") {
	$auditFromD = date("d", strtotime($auditDateFrom));
	$auditFromM = date("m", strtotime($auditDateFrom));
	$auditFromY = date("Y", strtotime($auditDateFrom));
	$noDateRange = true;
}
if (!empty($auditDateTo) && $auditDateTo != "all" && $auditDateTo != "today") {
	$auditToD = date("d", strtotime($auditDateTo));
	$auditToM = date("m", strtotime($auditDateTo));
	$auditToY = date("Y", strtotime($auditDateTo));
	$noDateRange = true;
}
if ($noDateRange) {
	$GLOBALS['temp']['auditDateRangeOptAll'] = "checked";
}
$GLOBALS['temp']['auditFromD'] = $auditFromD;
$GLOBALS['temp']['auditFromM'] = $auditFromM;
$GLOBALS['temp']['auditFromY'] = $auditFromY;
$GLOBALS['temp']['auditToD'] = $auditToD;
$GLOBALS['temp']['auditToM'] = $auditToM;
$GLOBALS['temp']['auditToY'] = $auditToY;
$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
$GLOBALS['temp']['filterLabelWidth'] = "10";
$GLOBALS['temp']['filterButtonWidth'] = "15";
$GLOBALS['temp']['hideRepBut'] = "";
$GLOBALS['temp']['today'] = $GLOBALS['tagList']['currdate'];
$GLOBALS['temp']['profile_ids'] = "";
$GLOBALS['temp']['timezoneName'] = $timezone;
$GLOBALS['temp']['timezoneFilterContainer'] = timezoneFilterContainerHTML();

// Initialise filters
$auditTrailUserFilter = useFilter("auditTrailUser",$auditTrailUsers,"SELECT IFNULL(CONCAT(CONCAT(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","pr_persona.pr_persona_ix",false,"No users found","0");
$moduleFilter = useFilter("auditTrailModule",$modules,"SELECT CONCAT(rf_audit_module_name, ' (', rf_audit_module_description_external, ')') AS namelast FROM rf_audit_module WHERE rf_audit_module_id =","ad_module_field.rf_audit_module_id",false,"No modules found","0");
$serverFilter = useFilter("server",$servers,"SELECT rf_db_description FROM rf_database WHERE  rf_db_code=","fn_folio.fn_folio_db",false,"Reservation Office","Res");
$resList = $lDB->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
$servers = str_replace("Res",join(":",$resList),$servers);

$rows = new tpParseTable();
$data = array(array("expander" => "", "date" => "", "time" => "", "server" => "", "user" => "", "details" => ""));
$rows->Data = $data;
unset($data);

$parameters = array();
$fromDate = ($auditDateFrom == "all") ? false : $auditDateFrom;
$toDate = ($auditDateTo == "all") ? false : $auditDateTo;
if ($toDate != false && !in_array($toDate, array("all","today"))) {
	$toDate = date('Y-m-d', strtotime($toDate . ' + 1 day'));
}
$parameters['users'] = (empty($auditTrailUsers) || $auditTrailUsers == "all") ? false : $auditTrailUsers;
$parameters['modules'] = (empty($modules) || $modules == "all") ? false : $modules;
$parameters['servers'] = (empty($servers) || $servers == "all") ? false : $servers;
$parameters['timezone'] = $timezone;

$reservationAuditTrail = new AuditTrail($record,TYPE_RESERVATION);
$temp = $reservationAuditTrail->fetch($fromDate,$toDate,$parameters);
if($temp !== false) {
	$rows->Data = $temp;
	unset($temp);
}

$GLOBALS['tagList']['rows'] = $rows;
