<?php
/*
 *
 * $Id: init.form273.php,v 1.21 2011-05-17 14:08:27 light Exp $
 *
 * $Log: init.form273.php,v $
 * Revision 1.21  2011-05-17 14:08:27  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.20  2009-05-19 09:35:32  light
 * Code clean up on review DB change report
 *
 * Revision 1.19  2007-02-07 12:21:44  light
 * Bug #4368 - Status bar display in IE
 *
 * Revision 1.18  2006-10-10 07:57:16  gregs
 * BUG #5484 : Reports to hide filters by default
 *
 * Revision 1.17  2006-10-03 09:23:07  gregs
 * Bug #5484 : Reports to hide filters by default
 *
 */

/**
 * init.form273.php - Review DB Changes 
 * Job: 714
 * Function: 75 (DB Status Change)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")+1));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/db_review_chng.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],11,"");

$today = date("Y-m-d");
$fromDate = useDate("from", $_SERVER['argv'][1]);
$toDate = useDate("to", $_SERVER['argv'][2]);
$dbFunction = $_SERVER['argv'][3];
$intUser = $_SERVER['argv'][4];
$server = $_SERVER['argv'][5];
$filterStatus = $_SERVER['argv'][6];
$options = $_SERVER['argv'][7];
$filterButtonText = $_SERVER['argv'][9];
$timezone = !empty($_SERVER['argv'][10]) ? $_SERVER['argv'][10] : date("e");

$GLOBALS['temp']['timezoneName'] = $timezone;
$GLOBALS['temp']['timezoneFilterContainer'] = timezoneFilterContainerHTML();

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
	break;
}

if($renderMode == "pdf" && $renderType == "email") {
	$pdfName = "DB Changes Review" . " from " . $fromDate['htmlDate'] . " to " . $toDate['htmlDate'];
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=top>
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,7))."+".$newOptions;

	$GLOBALS[$form]->FormHTML =
		str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
	// get principal
	$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$GLOBALS['temp']['emailTo'] = "";
}

$where = "";

if(!empty($dbFunction)) {
	switch ($dbFunction) {
	case 1:
		$function = "2";
		break;
	case 2:
		$function = "4";
		break;
	case 3:
		$function = "6";
		break;
	case 4:
		$function = "8";
		break;
	}

	$where .= " AND ad_db_status.ad_db_function_ind = '$function'";
}

if($intUser != "0"){
	$where .= " AND ad_db_status.ad_db_user_id = '$intUser'";
}

if($server != "0"){
	$where .= " AND ad_db_status.ad_db_status_db = '$server'";
}
$sqlList = $GLOBALS['lDB']->get("
	SELECT
		ad_db_status.ad_db_status_db as id,
		ad_db_status.ad_db_start as startDate,
		ad_db_status.ad_db_start_tz as startDateTZ,
		ad_db_status.ad_db_end as endDate,
		ad_db_status.ad_db_end_tz as endDateTZ,
		ad_db_status.ad_db_function_ind as funcId,
		pr_persona.pr_name_first as firstName,
		pr_persona.pr_name_last as lastName
	FROM
		ad_db_status
        INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ad_db_status.ad_db_user_id
	WHERE
		(
			ad_db_status.ad_db_start <= '$toDate[jsDate] 23:59:59'
			AND ad_db_status.ad_db_end > '$fromDate[jsDate]'
		) $where
	ORDER BY
		ad_db_status.ad_db_start desc,
		ad_db_status.ad_db_status_ix
",2);
if($renderMode == "html") {
	$temphtml = Join("\n",File(__DIR__ . "/../../../public/html/db_review_chng_rows.htm"));
	$rows = "";
	foreach($sqlList as $item){

		$startDate = convertDateTimeZone($item['startDate'], $item['startDateTZ'], $timezone);
		$endDate = convertDateTimeZone($item['endDate'], $item['endDateTZ'], $timezone);

		$item['startDate'] = "<span title=\"Original time zone: ".$item['startDateTZ'].", displaying ".$timezone."\">".$startDate['date']." (".$startDate['time'].")</span>";
		$item['endDate'] = "<span title=\"Original time zone: ".$item['endDateTZ'].", displaying ".$timezone."\">".$endDate['date']." (".$endDate['time'].")</span>";
		if($item['firstName']) {
			$item['lastName'] .= ", ";
		}
		$item['fullName'] = $item['lastName'].$item['firstName'];
		switch ($item['funcId']) {
		case 2:
			$item['funcName'] = "Set Web as Master";
			break;
		case 4:
			$item['funcName'] = "Set Res Office as Master";
			break;
		case 6:
			$item['funcName'] = "Force Slave";
			break;
		case 8:
			$item['funcName'] = "Force Master";
			break;
		}
		$out = showpage($item,$temphtml);
		$rows .= $out;
	}
	$GLOBALS['temp']['rows'] = $rows;
	if(!$sqlList) {
		$GLOBALS['temp']['rows'] = "<tr><td align=\"center\" class=\"bl br\" colspan=\"5\">There are no results matching your filter criteria</td></tr>";
	}

	$GLOBALS['temp']['hideAll'] = "";

	if(!$_SERVER['argv'][1]) {
		$GLOBALS['temp']['hideAll'] = "collapse printCollapse";
	}

	$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
	$GLOBALS['temp']['filterButtonText'] = $filterButtonText;
	  
	// Bug #5484 : START ----------------------------------------------------------
	// When rendering a report, hide the filters by default.
	// ----------------------------------------------------------------------------
	if($filterStatus == ""){
		$GLOBALS['temp']['filterStatus'] = "";
	}

	if($filterButtonText == "") {
		$GLOBALS['temp']['filterButtonText'] = "<< Hide Filters";
	}


	if($_SERVER['argc'] > 1) {
		if($filterStatus == ""){
			$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
			$GLOBALS['temp']['filterButtonText'] = ">> Show Filters";
		}
	}
	// Bug #5484: END -------------------------------------------------------------

	// Function drop down
	$GLOBALS[$form]->AddField("dbFunction","dbFunction",$dbFunction,3);
	$funcArray = array("0:|:All","1:|:Set Web as master","2:|:Set Res Office as master","3:|:Force Slave","4:|:Force Master");
	$GLOBALS['dbFunction']->Select($funcArray);
	$GLOBALS['dbFunction']->StyleType = "txt";
	$GLOBALS['dbFunction']->Width = 160;
	$GLOBALS['dbFunction']->Size = 50;
	$GLOBALS['dbFunction']->Value = $dbFunction;
	$GLOBALS['tagList']['dbFunction'] = $GLOBALS['dbFunction'];

	// Server drop down
	$GLOBALS[$form]->AddField("serverDrop","serverDrop","",3);
	$serverArray = combolist($GLOBALS['lDB'],"
		SELECT
			rf_db_code as code,
			'' as x,
			rf_db_description
		FROM
			rf_database
		ORDER BY
			rf_db_description
	","0:|:All");
	$GLOBALS['serverDrop']->Select($serverArray);
	$GLOBALS['serverDrop']->StyleType = "txt";
	$GLOBALS['serverDrop']->Width = 160;
	$GLOBALS['serverDrop']->Size = 50;
	$GLOBALS['serverDrop']->Value = $server;
	$GLOBALS['tagList']['dbServer'] = $GLOBALS['serverDrop'];

	// User drop down
	$GLOBALS[$form]->AddField("userDrop","userDrop","",3);
	$userArray = combolist($GLOBALS['lDB'],"
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM 
			pr_persona
			INNER JOIN ad_db_status ON pr_persona_ix = ad_db_user_id
	","0:|:All");
	$GLOBALS['userDrop']->Select($userArray);
	$GLOBALS['userDrop']->StyleType = "txt";
	$GLOBALS['userDrop']->Width = 160;
	$GLOBALS['userDrop']->Size = 50;
	$GLOBALS['userDrop']->Value = $intUser;
	$GLOBALS['tagList']['intUser'] = $GLOBALS['userDrop'];
}

if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
	$pdf = new PDF("Review DB Changes Report");
	switch($dbFunction) {
	case 0:
		$dbFunction = "All";
		break;
	case 1:
		$dbFunction = "Set Web as Master";
		break;
	case 2:
		$dbFunction = "Set Res Office as Master";
		break;
	case 3:
		$dbFunction = "Force Slave";
		break;
	case 4:
		$dbFunction = "Force Master";
		break;
}
  
	if($intUser == "0") {
		$intUserName = "All";
	} else {
		$name = $GLOBALS['lDB']->get("SELECT pr_persona.pr_name_first, pr_persona.pr_name_last FROM pr_persona WHERE pr_persona_ix = '$intUser'",1);
		$intUserName = trim($name[0]." ".$name[1]);
	}

	if($server == "0") {
		$serverName = "All";
	} else {
		$serverName = $GLOBALS['lDB']->get("SELECT rf_database.rf_db_description FROM rf_database WHERE rf_db_code = '".$server."'",4);
	}

	$pdf->ReportHeader("Review DB Changes Report",array(
		array('name'=>"From Date",'value'=>chng_date($fromDate['jsDate'],"-")),
		array('name'=>"To Date",'value'=>chng_date($toDate['jsDate'],"-")),
		array('name'=>"Function",'value'=>$dbFunction),
		array('name'=>"User",'value'=>$intUserName),
		array('name'=>"Server",'value'=>$serverName),
		array('name'=>"Timezone display", 'value'=>$timezone),
	));

	$pdf->SetFont('Arial', '', 7);
	$headRow = array();
	array_push($headRow,
		array('width'=>"8%", 'height'=>"4", 'data'=>"Process Id", 'fill'=>1, 'border'=>"LTBR", 'style'=>"B"),
		array('width'=>"15%", 'height'=>"4", 'data'=>"Started", 'fill'=>1, 'border'=>"TBR", 'style'=>"B"),
		array('width'=>"15%", 'height'=>"4", 'data'=>"Completed", 'fill'=>1, 'border'=>"TBR", 'fill'=>1, 'style'=>"B"),
		array('width'=>"20%", 'height'=>"4", 'data'=>"Function Description", 'fill'=>1, 'border'=>"TBR", 'style'=>"B"),
		array('width'=>"20%", 'height'=>"4", 'data'=>"User", 'fill'=>1, 'border'=>"TBR", 'style'=>"B")
	);
	$pdf->Row($headRow);
	foreach($sqlList as $item) {

		$startDate = convertDateTimeZone($item['startDate'], $item['startDateTZ'], $timezone);
		$endDate = convertDateTimeZone($item['endDate'], $item['endDateTZ'], $timezone);

		$item['startDate'] = $startDate['date']." (".$startDate['time'].")";
		$item['endDate'] = $endDate['date']." (".$endDate['time'].")";

		if($item['firstName']) {
			$item['firstName'] .= " ,".$item['firstName'];
		}
		$item['fullName'] = $item['lastName'].$item['firstName'];
		switch ($item['funcId']) {
		case 2:
			$funcName = "Set Web as Master";
			break;
		case 4:
			$funcName = "Set Res Office as Master";
			break;
		case 6:
			$funcName = "Force Slave";
			break;
		case 8:
			$funcName = "Force Master";
			break;
		}
		$pdf->SetFont('Arial', '', 7);

		$dataRow = array();
		array_push($dataRow,
			array('width'=>"8%", 'data'=>$item['id'], 'border'=>"LR"),
			array('width'=>"15%", 'data'=>$item['startDate'], 'border'=>"LR"),
			array('width'=>"15%", 'data'=>$item['endDate'], 'border'=>"LR"),
			array('width'=>"20%", 'data'=>$funcName, 'border'=>"LR"),
			array('width'=>"20%", 'data'=>$item['fullName'], 'border'=>"LR")
		);
		$pdf->Row($dataRow);
	}

	$pdf->Row(array(
		array('width'=>"78%", 'data'=>"", 'border'=>"T")
	));
  
	if($renderType == "save") {
		$pdf->OutPut('./PDF/current/dbChanges.pdf');
		echo "PDF created";
	} elseif ($renderType == "view") {
		pdf_view($pdf);
	} elseif ($renderType == "send") {
		pdf_send($pdf,"dbChanges.pdf");
	}
}

if($renderMode == "csv") {
	switch($dbFunction) {
	case 0:
		$dbFunction = "All";
		break;
	case 1:
		$dbFunction = "Set Web as Master";
		break;
	case 2:
		$dbFunction = "Set Res Office as Master";
		break;
	case 3:
		$dbFunction = "Force Slave";
		break;
	case 4:
		$dbFunction = "Force Master";
		break;
	}
	if($intUser == "0") {
		$intUserName = "All";
	} else {
		$name = $GLOBALS['lDB']->get("SELECT pr_persona.pr_name_first, pr_persona.pr_name_last FROM pr_persona WHERE pr_persona_ix = '$intUser'");
		$intUserName = trim($name[0]." ".$name[1]);
	}
	if($server == "0") {
		$serverName = "All";
	} else {
		$serverName = $GLOBALS['lDB']->get("SELECT rf_database.rf_db_description FROM rf_database WHERE rf_db_code = '$server'",4);
	}
	$csvFile = array();
	array_push($csvFile,array("Review DB Changes Report"));
	array_push($csvFile,array());
	array_push($csvFile,array("From Date",chng_date($fromDate['jsDate'],"-")));
	array_push($csvFile,array("To Date",chng_date($toDate['jsDate'],"-")));
	array_push($csvFile,array("Function",$dbFunction));
	array_push($csvFile,array("User",$intUserName));
	array_push($csvFile,array("Server",$serverName));
	array_push($csvFile,array());
	array_push($csvFile,array("Process Id","Started","Completed","Function Description","User"));

	foreach($sqlList as $item) {
		$sdate = explode(" ",$item['startDate']);
		$item['startDate'] = chng_date($sdate[0],"-")." (".$sdate[1].")";
		$edate = explode(" ",$item['endDate']);
		$item['endDate'] = chng_date($edate[0],"-")." (".$edate[1].")";
		if($item['firstName']) {
			$item['firstName'] .= " ,".$item['firstName'];
		}
		$item['fullName'] = $item['lastName'].$item['firstName'];
		switch ($item['funcId']) {
		case 2:
			$funcName = "Set Web as Master";
			break;
		case 4:
			$funcName = "Set Res Office as Master";
			break;
		case 6:
			$funcName = "Force Slave";
			break;
		case 8:
			$funcName = "Force Master";
			break;
		}
		array_push($csvFile,array($item['id'],$item['startDate'],$item['endDate'],$funcName,$item['fullName']));
	}
	csv_output("contact_".chng_date(date("Y-m-d"),"-"),$csvFile);
}

function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	",4);
	if(trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if(trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",2);
	$detail = $detail[0];
	$name = "";
	if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if(trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
