<?php

/**
 * init.form274.php - Commission report
 * Job: 207
 *
 * Function: 77 (Reports Financials: Commission)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}


if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_commission.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],25,"");

if(trim($_SERVER['argv'][1]) == "") {
	$fromDate = date("Y-m") . "-01";
	$toDate = date("Y-m-d",mktime(0,0,0,date("m")+1,0,date("Y")));

	$fromYear = date("Y");
	$toYear = date("Y");
	$fromMonth = date("m");
	$toMonth = date("m");

	$GLOBALS['temp']['fromM'] = date("m");
	$GLOBALS['temp']['toM'] = date("m");
	$GLOBALS['temp']['fromY'] = date("Y");
	$GLOBALS['temp']['toY'] = date("Y");
	
} else {
	list($fromYear,$fromMonth) = explode("-",$_SERVER['argv'][1]);
	list($toYear,$toMonth) = explode("-",$_SERVER['argv'][2]);

	$fromDate = date("Y-m-d",mktime(0,0,0,$fromMonth,1,$fromYear));
	$toDate = date("Y-m-d",mktime(0,0,0,$toMonth+1,0,$toYear));
	
	$GLOBALS['temp']['fromM'] = $fromMonth;
	$GLOBALS['temp']['toM'] = $toMonth;
	$GLOBALS['temp']['fromY'] = $fromYear;
	$GLOBALS['temp']['toY'] = $toYear;
}
if(strlen($fromMonth) == 1) {
	$fromMonth = "0".$fromMonth;
}
if(strlen($toMonth) == 1) {
	$toMonth = "0".$toMonth;
}
$GLOBALS['temp']['fromDate'] = $fromDate;
$GLOBALS['temp']['toDate'] = $toDate;

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");

$GLOBALS['temp']['fromDateFormat'] = chng_date($fromDate,"-");
$GLOBALS['temp']['toDateFormat'] = chng_date($toDate,"-");
$GLOBALS['temp']['fromPeriodName'] = date("M Y",mktime(0,0,0,$fromMonth,1,$fromYear));
$GLOBALS['temp']['toPeriodName'] = date("M Y",mktime(0,0,0,$toMonth,1,$toYear));


// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$filterDivClass = $_SERVER['argv'][23];
$showHideButtonText = $_SERVER['argv'][24];

$GLOBALS['temp']['filterDivClass'] = urldecode($filterDivClass);
$GLOBALS['temp']['showHideButtonText'] = urldecode($showHideButtonText);

if($filterDivClass == "") {
	$GLOBALS['temp']['filterDivClass'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterDivClass == "") {
		$GLOBALS['temp']['filterDivClass'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// BUG #5484 : END ------------------------------------------------------------

$statusACL = $lDB->get("
	SELECT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id <> 25
		AND rf_reservation_status_id <> 97
",3);


$agentACL = false;
if($userStatusId < 2) {
	$agentACL = array($calAgentId);
}       
$agentFilter = useFilter("agent",$_SERVER['argv'][4],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");
$propertyACL= $lDB->get("
			SELECT DISTINCT
				ac_accomm_type.pr_business_id
			FROM
				sc_accomm, ac_accomm_type, pr_business, pr_persona
			WHERE
				sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
			AND
				sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		/*	AND
				ac_accomm_type.ac_accomm_type_inactive_yn=0*/
			AND
				ac_accomm_type.pr_business_id = pr_business.pr_business_id
		/*	AND
				pr_business.pr_bus_inactive_yn= '0'*/
			AND
				pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id",3);
$propertyFilter = useFilter("properties",$_SERVER['argv'][5],"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation_item.pr_business_id",$propertyACL,false,false);
$currenciesFilter = useFilter("currencies",$_SERVER['argv'][6],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","rv_reservation.rv_invoice_currency_id",false,false,false);
if($_SERVER['argv'][1] == "" && $_SERVER['argv'][7] == "") {
	$_SERVER['argv'][7] = "30";
}

$statusFilter = useFilter("statusAlloc",$_SERVER['argv'][7],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);
$fromCommission = $_SERVER['argv'][8];
$toCommission = $_SERVER['argv'][9];
$level1 = $_SERVER['argv'][10];
$GLOBALS['temp']["level1".$level1] = "selected";
$level2 = $_SERVER['argv'][11];
$GLOBALS['temp']["level2".$level2] = "selected";
$renderOption = $_SERVER['argv'][12];
$sortOption = $_SERVER['argv'][13];

$otherSelect = "";
$commDeduct = "";
if(!($renderOption & 8)) {
	$GLOBALS['temp']['chrgNettChecked'] = "checked";
	$commDeduct .= "rv_commission_deduct_yn = '1'";  
}
if(!($renderOption & 16)) {
	$GLOBALS['temp']['chrgGrossChecked'] = "checked";
	if($commDeduct != "" ){
		$commDeduct .= " OR ";
	}
	$commDeduct .= "rv_commission_deduct_yn = '0'";
}
if($renderOption & 32) {
	$GLOBALS['temp']['exclTaxChecked'] = "checked";
} else {
	$GLOBALS['temp']['inclTaxChecked'] = "checked";
}
if(!($renderOption & 64)) {
	$GLOBALS['temp']['accommChecked'] = "checked";
	$otherSelect .= "
			rv_amt_accomm_comm as rv_amt_accomm_comm,
			rv_amt_accomm_gross as rv_amt_accomm_gross,
			rv_amt_accomm_nett as rv_amt_accomm_nett,
			rv_amt_accomm_tax as rv_amt_accomm_tax,";
}
if(($renderOption & 128)) {
	$GLOBALS['temp']['extrasChecked'] = "checked";
	$otherSelect .= "
			rv_amt_extra_comm as rv_amt_extra_comm,
			rv_amt_extra_gross as rv_amt_extra_gross,
			rv_amt_extra_nett as rv_amt_extra_nett,
			rv_amt_extra_tax rv_amt_extra_tax,";
}
if(($renderOption & 256)) {
	$GLOBALS['temp']['travelChecked'] = "checked";
	$otherSelect .= "
			rv_amt_travel_comm as rv_amt_travel_comm,
			rv_amt_travel_gross as rv_amt_travel_gross,
			rv_amt_travel_nett as rv_amt_travel_nett,
			rv_amt_travel_tax as rv_amt_travel_tax,";
}


if($fromCommission == "") {
	$fromCommission = "0";
}
if($toCommission == "") {
	$toCommission = "100";
}
$GLOBALS['temp']['fromComm'] = $fromCommission;
$GLOBALS['temp']['toComm'] = $toCommission;

$GLOBALS['temp']['imgSortLevel2'] = "";
if($level2 == "none") {
	$GLOBALS['temp']['imgSortLevel2'] = "style=\"display:none\"";
}

$GLOBALS['temp']['imgSortLevel1Asc'] = "std";
$GLOBALS['temp']['imgSortLevel1Dsc'] = "std";
$GLOBALS['temp']['imgSortLevel2Asc'] = "std";
$GLOBALS['temp']['imgSortLevel2Dsc'] = "std";
$GLOBALS['temp']['imgSortCommAsc'] = "std";
$GLOBALS['temp']['imgSortCommDsc'] = "std";
switch($sortOption) {
	case 1:
		$GLOBALS['temp']['imgSortLevel1Dsc'] = "down";
		break;
	case 2:
		$GLOBALS['temp']['imgSortLevel2Asc'] = "down";
		break;
	case 3:
		$GLOBALS['temp']['imgSortLevel2Dsc'] = "down";
		break;
	default:
		$GLOBALS['temp']['imgSortLevel1Asc'] = "down";
		break;
		
}

//$GLOBALS['temp'][filterStatus] = "expand";
if($renderOption & 512) {
	$GLOBALS['temp']['filterDivClass'] = "collapse printCollapse";
}

$GLOBALS['temp']['reportGenerated'] = "";
if($_SERVER['argv'][1] == "" && $_SERVER['argv'][2] == "") {
	$GLOBALS['temp']['reportGenerated'] = "class=\"collapse\"";
}

$dateWhere = "fn_folio.fn_folio_date BETWEEN '$fromDate' AND '$toDate' ";
$invDate = "fn_folio.fn_folio_date as invDate,";

$groupBy = array();
$orderBy = array();
$levelSelect = "";
$level1Order = "";
$level2Order = "";
$level1Join = "";
$level2Join = "";

switch($level1) {
	case "all":
		$level1Join = "";
		$GLOBALS['temp']['level1Name'] = "All Reservations";
		$levelSelect .= "'All' as level1,";
		break;
	case "property":
		$level1Join = "INNER JOIN pr_persona AS pr_bus ON rv_reservation_item.pr_business_id = pr_bus.pr_persona_ix";
		array_push($groupBy,"rv_reservation_item.pr_business_id");
		$levelSelect .= "pr_bus.pr_name_last as level1, pr_bus.pr_persona_ix as level1Id,";
		$level1Order = " pr_bus.pr_name_last ";
		$GLOBALS['temp']['level1Name'] = "Property";
		break;
	case "agent":
		$level1Join = "INNER JOIN pr_persona AS pr_agent ON rv_agent_id = pr_agent.pr_persona_ix";
		array_push($groupBy,"rv_reservation.rv_agent_id");
		$levelSelect .= "pr_agent.pr_name_last as level1, pr_agent.pr_persona_ix as level1Id,";
		$level1Order = " pr_agent.pr_name_last ";
		$GLOBALS['temp']['level1Name'] = "Agent";
		$level1Empty = "Direct booking";
		break;
}
switch($level2) {
	case "none":
		$level2Join = "";
		$GLOBALS['temp']['level2Name'] = "";
		$levelSelect .= "'' as level2, '' as level2Id,";
		break;
	case "property":
		$level2Join = "INNER JOIN pr_persona AS pr_bus ON rv_reservation_item.pr_business_id = pr_bus.pr_persona_ix";
		array_push($groupBy,"rv_reservation_item.pr_business_id");
		$levelSelect .= "pr_bus.pr_name_last as level2, pr_bus.pr_persona_ix as level2Id,";
		$level2Order = " pr_bus.pr_name_last ";
		$GLOBALS['temp']['level2Name'] = "Property";
		break;
	case "agent":
		$level2Join = "INNER JOIN pr_persona AS pr_agent ON rv_agent_id = pr_agent.pr_persona_ix";
		array_push($groupBy,"rv_reservation.rv_agent_id");
		$levelSelect .= "pr_agent.pr_name_last as level2, pr_agent.pr_persona_ix as level2Id,";
		$level2Order = " pr_agent.pr_name_last ";
		$GLOBALS['temp']['level2Name'] = "Agent";
		$level2Empty = "Direct booking";
		break;
}

array_push($groupBy,"rf_currency.rf_currency_symbol");
$groupByClause = join(",",$groupBy);
/*switch($sortOption) {
	case 1:
		if($level1 != "all") {
			array_push($orderBy,$level1Order." DESC");
		}
		break;
	case 2:
		if($level2 != "none") {
			array_push($orderBy,$level2Order);
		}
		break;
	case 3:
		if($level2 != "none") {
			array_push($orderBy,$level2Order. " DESC");
		}
		break;
	default:
		if($level1 != "all") {
			array_push($orderBy,$level1Order);
		}
		break;
}*/
if($level1 != "all") {
	array_push($orderBy,$level1Order);
}
if($level2 != "none") {
	array_push($orderBy,$level2Order);
}
array_push($orderBy,"rf_currency.rf_currency_symbol");
array_push($orderBy,"rv_reservation.rv_reservation_ix");
if(sizeof($orderBy) > 0) {
	$orderByClause = "\nORDER BY " . join(",",$orderBy);
} else {
	$orderByClause = "";
}


$sql = "
	SELECT
		rf_currency_symbol,
		rv_agent_id,
		$invDate
		$levelSelect
		$otherSelect
		rv_commission_deduct_yn,
		rv_reservation_ix,
		rv_invoice_currency_id
	FROM
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
		INNER JOIN rf_currency ON rv_invoice_currency_id = rf_currency.rf_currency_ix
		$level1Join
		$level2Join
	WHERE
		$dateWhere
		$agentFilter[where]
		$propertyFilter[where]
		$currenciesFilter[where]
		$statusFilter[where]
		AND ($commDeduct)
/*	GROUP BY
		$groupByClause*/
	$orderByClause
";
//debug($sql);
$listArray = $lDB->get($sql,2);
//debug($listArray);
$newListArray = array();
$level1Id = null;
$level2Id = null;
$currency = null;
$reservationId = null;
$first = true;
$newItem = array();

if($_SERVER['argv'][1] == "" && $_SERVER['argv'][2] == "") {
	$listArray = array();
} else {
	if(($renderOption & 7) == 0) {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
	}
}
if (isset($listArray)) {
	foreach($listArray as $key=>$item) {
		if(isset($item['level1Id']) && $level1Id != $item['level1Id']) {
			$level2Id = null;
			$currency = null;
			$level1Id = $item['level1Id'];
		}
		if(isset($item['level2Id']) && $level2Id != $item['level2Id']) {
			$currency = null;
			$level2Id = $item['level2Id'];
		}
		if(isset($item['rf_currency_symbol']) && $currency != $item['rf_currency_symbol']) {
			if(!$first) { array_push($newListArray,$newItem); }
			
			$newItem['rf_currency_symbol'] = $item['rf_currency_symbol'];
			$newItem['rv_agent_id'] = $item['rv_agent_id'];
			$newItem['rv_commission_deduct_yn'] = $item['rv_commission_deduct_yn'];
			$newItem['level1'] = $item['level1'];
			$newItem['level1Id'] = isset($item['level1Id']) ? $item['level1Id'] : "";
			$newItem['level2'] = $item['level2'];
			$newItem['level2Id'] = $item['level2Id'];
			$newItem['rv_invoice_currency_id'] = $item['rv_invoice_currency_id'];
			$currency = $item['rf_currency_symbol'];
		}
		if(isset($item['rv_reservation_ix']) && $reservationId != $item['rv_reservation_ix']) {
			/*if($item[rv_commission_deduct_yn] == "1") {
				$item[rv_amt_accomm_comm] *= -1;
				$item[rv_amt_extra_comm] *= -1;
				$item[rv_amt_travel_comm] *= -1;
			}*/

			$item['rv_amt_accomm_comm'] = (isset($item['rv_amt_accomm_comm']) ? $item['rv_amt_accomm_comm'] : 0);
			$newItem['rv_amt_accomm_comm'] = (isset($newItem['rv_amt_accomm_comm']) ? $newItem['rv_amt_accomm_comm']+$item['rv_amt_accomm_comm'] : $item['rv_amt_accomm_comm']);

			$item['rv_amt_accomm_gross'] = (isset($item['rv_amt_accomm_gross']) ? $item['rv_amt_accomm_gross'] : 0);
			$newItem['rv_amt_accomm_gross'] = (isset($newItem['rv_amt_accomm_gross']) ? $newItem['rv_amt_accomm_gross']+$item['rv_amt_accomm_gross'] : $item['rv_amt_accomm_gross']);
			
			$item['rv_amt_accomm_nett'] = (isset($item['rv_amt_accomm_nett']) ? $item['rv_amt_accomm_nett'] : 0);
			$newItem['rv_amt_accomm_nett'] = (isset($newItem['rv_amt_accomm_nett']) ? $newItem['rv_amt_accomm_nett']+$item['rv_amt_accomm_nett'] : $item['rv_amt_accomm_nett']);

			$item['rv_amt_accomm_tax'] = (isset($item['rv_amt_accomm_tax']) ? $item['rv_amt_accomm_tax'] : 0);
			$newItem['rv_amt_accomm_tax'] = (isset($newItem['rv_amt_accomm_tax']) ? $newItem['rv_amt_accomm_tax']+$item['rv_amt_accomm_tax'] : $item['rv_amt_accomm_tax']);

			$item['rv_amt_extra_comm'] = (isset($item['rv_amt_extra_comm']) ? $item['rv_amt_extra_comm'] : 0);
			$newItem['rv_amt_extra_comm'] = (isset($newItem['rv_amt_extra_comm']) ? $newItem['rv_amt_extra_comm']+$item['rv_amt_extra_comm'] : $item['rv_amt_extra_comm']);

			$item['rv_amt_extra_gross'] = (isset($item['rv_amt_extra_gross']) ? $item['rv_amt_extra_gross'] : 0);
			$newItem['rv_amt_extra_gross'] = (isset($newItem['rv_amt_extra_gross']) ? $newItem['rv_amt_extra_gross']+$item['rv_amt_extra_gross'] : $item['rv_amt_extra_gross']);

			$item['rv_amt_extra_nett'] = (isset($item['rv_amt_extra_nett']) ? $item['rv_amt_extra_nett'] : 0);
			$newItem['rv_amt_extra_nett'] = (isset($newItem['rv_amt_extra_nett']) ? $newItem['rv_amt_extra_nett']+$item['rv_amt_extra_nett'] : $item['rv_amt_extra_nett']);

			$item['rv_amt_extra_tax'] = (isset($item['rv_amt_extra_tax']) ? $item['rv_amt_extra_tax'] : 0);
			$newItem['rv_amt_extra_tax'] = (isset($newItem['rv_amt_extra_tax']) ? $newItem['rv_amt_extra_tax']+$item['rv_amt_extra_tax'] : $item['rv_amt_extra_tax']);

			$item['rv_amt_travel_comm'] = (isset($item['rv_amt_travel_comm']) ? $item['rv_amt_travel_comm'] : 0);
			$newItem['rv_amt_travel_comm'] = (isset($newItem['rv_amt_travel_comm']) ? $newItem['rv_amt_travel_comm']+$item['rv_amt_travel_comm'] : $item['rv_amt_travel_comm']);

			$item['rv_amt_travel_gross'] = (isset($item['rv_amt_travel_gross']) ? $item['rv_amt_travel_gross'] : 0);
			$newItem['rv_amt_travel_gross'] = (isset($newItem['rv_amt_travel_gross']) ? $newItem['rv_amt_travel_gross']+$item['rv_amt_travel_gross'] : $item['rv_amt_travel_gross']);

			$item['rv_amt_travel_nett'] = (isset($item['rv_amt_travel_nett']) ? $item['rv_amt_travel_nett'] : 0);
			$newItem['rv_amt_travel_nett'] = (isset($newItem['rv_amt_travel_nett']) ? $newItem['rv_amt_travel_nett']+$item['rv_amt_travel_nett'] : $item['rv_amt_travel_nett']);

			$item['rv_amt_travel_tax'] = (isset($item['rv_amt_travel_tax']) ? $item['rv_amt_travel_tax'] : 0);
			$newItem['rv_amt_travel_tax'] = (isset($newItem['rv_amt_travel_tax']) ? $newItem['rv_amt_travel_tax']+$item['rv_amt_travel_tax'] : $item['rv_amt_travel_tax']);

			$reservationId = $item['rv_reservation_ix'];
		}
		$first = false;
	}
}
array_push($newListArray,$newItem);
$listArray = $newListArray;
$newListArray = null;
//$listArray = array();

$newList = array();
foreach($listArray as $key=>$item) {
	if (!empty($item)) {
		$comm = 0;
		$revenue = 0;
		if(!($renderOption & 64)) {
			if (isset($item['rv_amt_accomm_comm'])) {
				$comm += $item['rv_amt_accomm_comm'];
			}
			if (isset($item['rv_amt_accomm_gross'])) {
				$revenue += $item['rv_amt_accomm_gross'];
			}
			if($renderOption & 32) {
				$revenue -= $item['rv_amt_accomm_tax'];
			}
		}
		if(($renderOption & 128)) {
			$comm += $item['rv_amt_extra_comm'];
			$revenue += $item['rv_amt_extra_gross'];
			if($renderOption & 32) {
				$revenue -= $item['rv_amt_extra_tax'];
			}
		}
		if(($renderOption & 256)) {
			$comm += $item['rv_amt_travel_comm'];
			$revenue += $item['rv_amt_travel_gross'];
			if($renderOption & 32) {
				$revenue -= $item['rv_amt_travel_tax'];
			}
		}
		if($revenue != 0) {
			$perc = $comm / $revenue * 100;
		} else {
			$perc = 0;
		}
		if($perc >= $fromCommission && $perc <= $toCommission && !empty($item)) {
			fixAmtDisplay($comm);
			fixAmtDisplay($revenue);
			fixAmtDisplay($perc);
			$newItem = array(
				'level1'=>$item['level1'],
				'level1Id'=>$item['level1Id'],
				'level2'=>$item['level2'],
				'level2Id'=>$item['level2Id'],
				'rf_currency_symbol'=>$item['rf_currency_symbol'],
				'rv_invoice_currency_id'=>$item['rv_invoice_currency_id'],
				'commAmount'=>$comm,
				'revenueAmount'=>$revenue,
				'commPerc'=>$perc
			);
			array_push($newList,$newItem);
		}
	}
}
if(($renderOption & 7) == 0) {
	$rowHTML = Join("",file(__DIR__ . "/../../../public/html/rep_commission_row.htm"));
	$rows = "";
	if(sizeof($newList) > 0) {
		$args = array_slice($_SERVER['argv'],1,13);
		$arg_list = join("+",$args);
		foreach($newList as $item) {
			$rows .= str_replace("!level1!",$item['level1'],
				str_replace("!level2!",$item['level2'],
				str_replace("!rf_currency_symbol!",$item['rf_currency_symbol'],
				str_replace("!commAmount!",$item['commAmount'],
				str_replace("!revenueAmount!",$item['revenueAmount'],
				str_replace("!commPerc!",$item['commPerc'],
				str_replacE("!args!",$arg_list."+$item[level1Id]+$item[level2Id]+$item[rv_invoice_currency_id]",$rowHTML)))))));
		}
		$GLOBALS['temp']['rows'] = $rows;
	} else {
		$GLOBALS['temp']['rows'] = "<tr><td colspan=\"10\"><table class=\"blkBord\" width=\"640\" height=\"50\"><tr><td class=\"txt\" align=\"center\">&nbsp;&nbsp;No data matched your filter criteria.<br> Please change your filters and press one of the report buttons above.</td></tr></table></td></tr>";
	}
}

if(($renderOption & 7) == 4) { //csv
	$csvFile = array();
	array_push($csvFile,array("Commission Report"));
	array_push($csvFile,array());
	array_push($csvFile,array("Financial period",(isset($GLOBALS['temp']['periodName']) ? $GLOBALS['temp']['periodName'] : "") . " (" . $GLOBALS['temp']['fromPeriodName'] . " to " . $GLOBALS['temp']['toPeriodName'] . ")"));
	array_push($csvFile,array("Date range",$GLOBALS['temp']['fromDateFormat'] . " to " . $GLOBALS['temp']['toDateFormat']));
	array_push($csvFile,array("Agents",$agentFilter['names']));
	array_push($csvFile,array("Properties",$propertyFilter['names']));
	array_push($csvFile,array("Currencies",$currenciesFilter['names']));
	array_push($csvFile,array("Status",$statusFilter['names']));
	array_push($csvFile,array("Commission Range",$fromCommission . " to " . $toCommission));
	array_push($csvFile,array("Level 1",$GLOBALS['temp']['level1Name']));
	array_push($csvFile,array("Level 2",$GLOBALS['temp']['level2Name']));
	$includeCharged = "";
	if(!($renderOption & 8)) {
		$includeCharged .= "Nett";
	}
	if(!($renderOption & 16)) {
		if($includeCharged != "") {
			$includeCharged .= " ";
		}
		$includeCharged .= "Gross";
	}
	array_push($csvFile,array("Include reservations charged",$includeCharged));
	if($renderOption & 32) {
		array_push($csvFile,array("Revenue","Exclude tax"));
	} else {
		array_push($csvFile,array("Revenue","Include tax"));
	}		
	$commOn = "";
	if(!($renderOption & 64)) {
		$commOn .= "Accommodation";
	}
	if(($renderOption & 128)) {
		if($commOn != "") {
			$commOn .= " ";
		}
		$commOn .= "Extras";
	};
	if(($renderOption & 256)) {
		if($commOn != "") {
			$commOn .= " ";
		}
		$commOn .= "Travel";
	};
switch($level1) {
	case "all":
		$level1 = "All";
		break;
	case "property":
	  $level1 = "Property";
		break;
	case "agent":
		$level1 = "Agent";
		break;
}	
switch($level2) {
	case "none":
	  $level2 = "";
		break;
	case "property":
	  $level2 = "Property";
		break;
	case "agent":
		$level2 = "Agent";
		break;
}	
	
	array_push($csvFile,array("Include commission on",$commOn));
	array_push($csvFile,array());
	array_push($csvFile,array(
	  $level1,$level2,"Curr","Comm","Revenue","%"
	));
	foreach($newList as $item) {
		array_push($csvFile,array(
			$item['level1'],$item['level2'],$item['rf_currency_symbol'],$item['commAmount'],$item['revenueAmount'],$item['commPerc']
		));
	}
	
	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				$csvText .= ",";
			} else {
				$first = false;
			}
			$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}
	if(headers_sent()) {
//		echo('Some data has already been output to browser, can\'t send PDF file');
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($csvText));
	header("Content-Disposition: inline; filename=commission_".str_replace(" ","_",chng_date(date("Y-m-d"),"-")).".csv");
	echo $csvText;
	flush();
	die();
}
