<?php
/**
 * init.form275.php - Commission report popup
 * Job: 208
 *
 * Function: 77 (Reports Financials: Commission)
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_commission_pop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],17,"");

if(trim($_SERVER['argv'][1]) == "" || trim($_SERVER['argv'][1]) == "") {
	$fromDate = date("Y-m") . "-01";
	$toDate = date("Y-m-d",mktime(0,0,0,date("m")+1,0,date("Y")));

	$fromYear = date("Y");
	$toYear = date("Y");
	$fromMonth = date("M");
	$toMonth = date("M");

	$GLOBALS['temp']['fromM'] = date("m");
	$GLOBALS['temp']['toM'] = date("m");
	$GLOBALS['temp']['fromY'] = date("Y");
	$GLOBALS['temp']['toY'] = date("Y");
	
} else {
	list($fromYear,$fromMonth) = explode("-",$_SERVER['argv'][1]);
	list($toYear,$toMonth) = explode("-",$_SERVER['argv'][2]);

	$fromDate = date("Y-m-d",mktime(0,0,0,$fromMonth,1,$fromYear));
	$toDate = date("Y-m-d",mktime(0,0,0,$toMonth+1,0,$toYear));
	
	$GLOBALS['temp']['fromM'] = $fromMonth;
	$GLOBALS['temp']['toM'] = $toMonth;
	$GLOBALS['temp']['fromY'] = $fromYear;
	$GLOBALS['temp']['toY'] = $toYear;
}
if(strlen($fromMonth) == 1) {
	$fromMonth = "0".$fromMonth;
}
if(strlen($toMonth) == 1) {
	$toMonth = "0".$toMonth;
}
$GLOBALS['temp']['fromDate'] = $fromDate;
$GLOBALS['temp']['toDate'] = $toDate;

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");

$GLOBALS['temp']['fromDateFormat'] = chng_date($fromDate,"-");
$GLOBALS['temp']['toDateFormat'] = chng_date($toDate,"-");
$GLOBALS['temp']['fromPeriodName'] = date("M Y",mktime(0,0,0,$fromMonth,1,$fromYear));
$GLOBALS['temp']['toPeriodName'] = date("M Y",mktime(0,0,0,$toMonth,1,$toYear));


// Create 'period' array
$periods = array();
$periodCurr = $fromYear . "-" . $fromMonth;
$periodEnd = $toYear . "-" . date("m",mktime(0,0,0,$toMonth+1,1,$toYear));
while($periodCurr < $periodEnd) {
	list($periodCurrYear, $periodCurrMonth) = explode("-",$periodCurr);
	$periodCurrStart = date("Y-m-d",mktime(0,0,0,$periodCurrMonth,1,$periodCurrYear));
	$periodCurrEnd =  date("Y-m-d",mktime(0,0,0,$periodCurrMonth+1,0,$periodCurrYear));
	$periodCurrLabel = date("M Y",mktime(0,0,0,$periodCurrMonth,1,$periodCurrYear));
	array_push($periods,array(
		'start'=> $periodCurrStart,
		'end'=> $periodCurrEnd,
		'total'=>0,
		'name'=>$periodCurrLabel
	));
	$periodCurr = date("Y-m", mktime(0,0,0,$periodCurrMonth+1,1,$periodCurrYear));
}

$propertyACL= $lDB->get("
			SELECT DISTINCT
				ac_accomm_type.pr_business_id
			FROM
				sc_accomm, ac_accomm_type, pr_business, pr_persona
			WHERE
				sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
			AND
				sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			AND
				ac_accomm_type.ac_accomm_type_inactive_yn=0
			AND
				ac_accomm_type.pr_business_id = pr_business.pr_business_id
			AND
				pr_business.pr_bus_inactive_yn= '0'
			AND
				pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id",3);
$statusACL = $lDB->get("
			SELECT
				rf_reservation_status_id
			FROM
				rf_reservation_status
			WHERE
				rf_reservation_status_id <> 25",3);


$agentFilter = useFilter("agent",$_SERVER['argv'][4],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",false,"Direct booking","0");
$propertyFilter = useFilter("properties",$_SERVER['argv'][5],"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation_item.pr_business_id",$propertyACL,false,false);
$currenciesFilter = useFilter("currencies",$_SERVER['argv'][6],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","rv_reservation.rv_invoice_currency_id",false,false,false);
if($_SERVER['argv'][1] == "" && $_SERVER['argv'][7] == "") {
	$_SERVER['argv'][7] = "30";
}

$statusFilter = useFilter("status",$_SERVER['argv'][7],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);
$fromCommission = $_SERVER['argv'][8];
$toCommission = $_SERVER['argv'][9];
$level1 = $_SERVER['argv'][10];
$GLOBALS['temp']["level1".$level1] = "selected";
$level2 = $_SERVER['argv'][11];
$GLOBALS['temp']["level2".$level2] = "selected";
$renderOption = $_SERVER['argv'][12];
$sortOption = $_SERVER['argv'][13];
$level1Id = $_SERVER['argv'][14];
$level2Id = $_SERVER['argv'][15];
$currencyId = $_SERVER['argv'][16];

$otherSelect = "";

$commDeduct = "";
if(!($renderOption & 8)) {
	$commDeduct .= "rv_commission_deduct_yn = '1'";  
}
if(!($renderOption & 16)) {
	if($commDeduct != "" ){
		$commDeduct .= " OR ";
	}
	$commDeduct .= "rv_commission_deduct_yn = '0'";
}


if(!($renderOption & 64)) {
	$GLOBALS['temp']['accommChecked'] = "checked";
	$otherSelect .= "
			rv_amt_accomm_comm as rv_amt_accomm_comm,
			rv_amt_accomm_gross as rv_amt_accomm_gross,
			rv_amt_accomm_nett as rv_amt_accomm_nett,
			rv_amt_accomm_tax as rv_amt_accomm_tax,";
}
if(($renderOption & 128)) {
	$GLOBALS['temp']['extrasChecked'] = "checked";
	$otherSelect .= "
			rv_amt_extra_comm as rv_amt_extra_comm,
			rv_amt_extra_gross as rv_amt_extra_gross,
			rv_amt_extra_nett as rv_amt_extra_nett,
			rv_amt_extra_tax rv_amt_extra_tax,";
}
if(($renderOption & 256)) {
	$GLOBALS['temp']['travelChecked'] = "checked";
	$otherSelect .= "
			rv_amt_travel_comm as rv_amt_travel_comm,
			rv_amt_travel_gross as rv_amt_travel_gross,
			rv_amt_travel_nett as rv_amt_travel_nett,
			rv_amt_travel_tax as rv_amt_travel_tax,";
}

$dateWhere = " fn_folio.fn_folio_date BETWEEN '$fromDate' AND '$toDate' ";
$invDate = "fn_folio.fn_folio_date as invDate,";

switch($level1) {
	case "agent":
		$level1Where = "AND rv_reservation.rv_agent_id = '$level1Id'";
		break;
	case "property":
		$level1Where = "AND rv_reservation_item.pr_business_id = '$level1Id'";
		break;
	default:
		$level1Where = "";
		break;			
}

switch($level2) {
	case "agent":
		$level2Where = "AND rv_reservation.rv_agent_id = '$level2Id'";
		break;
	case "property":
		$level2Where = "AND rv_reservation_item.pr_business_id = '$level2Id'";
		break;
	default:
		$level2Where = "";
		break;			
}

$sql = "
	SELECT
		$otherSelect
		rv_reservation.rv_reservation_ix as id,
		rv_reservation.rv_res_name as name,
		rv_commission_deduct_yn
		
	FROM
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
	WHERE
		$dateWhere
		$level1Where
		$level2Where
		$agentFilter[where]
		$propertyFilter[where]
		$currenciesFilter[where]
		$statusFilter[where]
		AND rv_reservation.rv_invoice_currency_id = '$currencyId'
		AND ($commDeduct)
	GROUP BY
		rv_reservation.rv_reservation_ix
";
//debug($sql);
$listArray = $lDB->get($sql,2);
//debug(sizeof($listArray));
$newListArray = array();
$id = null;
$totals = array('revenue'=>0, 'accomm'=>0, 'extra'=>0, 'travel'=>0, 'comm'=>0, 'perc'=>0);
foreach($listArray as $key=>$item) {
	if($id != $item['id']) {
		/*if($item[rv_commission_deduct_yn] == "1") {
			if($item[rv_amt_accomm_comm] != "0") { $item[rv_amt_accomm_comm] *= -1;}
			if($item[rv_amt_extra_comm] != "0") {$item[rv_amt_extra_comm] *= -1;}
			if($item[rv_amt_travel_comm] != "0") {$item[rv_amt_travel_comm] *= -1;}
		}*/

		$comm = 0;
		$revenue = 0;
		if(!($renderOption & 64)) {
			$comm += $item['rv_amt_accomm_comm'];
			$revenue += $item['rv_amt_accomm_gross'];
			if($renderOption & 32) {
				$revenue -= $item['rv_amt_accomm_tax'];
			}
		}
		if(($renderOption & 128)) {
			$comm += $item['rv_amt_extra_comm'];
			$revenue += $item['rv_amt_extra_gross'];
			if($renderOption & 32) {
				$revenue -= $item['rv_amt_extra_tax'];
			}
		}
		if(($renderOption & 256)) {
			$comm += $item['rv_amt_travel_comm'];
			$revenue += $item['rv_amt_travel_gross'];
			if($renderOption & 32) {
			$revenue -= $item['rv_amt_travel_tax'];
			}
		}
		if($revenue > 0) {
			$perc = $comm / $revenue * 100;
		} else {
			$perc = 0;
		}
		
		if($perc >= $fromCommission && $perc <= $toCommission) {
			fixAmtDisplay($comm);
			fixAmtDisplay($revenue);
			fixAmtDisplay($perc);
			$newItem = array(
				'id'=>$item['id'],
				'name'=>$item['name'],
				'rv_amt_accomm_comm'=>$item['rv_amt_accomm_comm'],
				'rv_amt_accomm_gross'=>$item['rv_amt_accomm_gross'],
				'rv_amt_accomm_nett'=>$item['rv_amt_accomm_nett'],
				'rv_amt_accomm_tax'=>$item['rv_amt_accomm_tax'],
				'rv_amt_extra_comm'=>(isset($item['rv_amt_extra_comm']) ? $item['rv_amt_extra_comm'] : 0),
				'rv_amt_extra_gross'=>(isset($item['rv_amt_extra_gross']) ? $item['rv_amt_extra_gross'] : 0),
				'rv_amt_extra_nett'=>(isset($item['rv_amt_extra_nett']) ? $item['rv_amt_extra_nett'] : 0),
				'rv_amt_extra_tax'=>(isset($item['rv_amt_extra_tax']) ? $item['rv_amt_extra_tax'] : 0),
				'rv_amt_travel_comm'=>(isset($item['rv_amt_travel_comm']) ? $item['rv_amt_travel_comm'] : 0),
				'rv_amt_travel_gross'=>(isset($item['rv_amt_travel_gross']) ? $item['rv_amt_travel_gross'] : 0),
				'rv_amt_travel_nett'=>(isset($item['rv_amt_travel_nett']) ? $item['rv_amt_travel_nett'] : 0),
				'rv_amt_travel_tax'=>(isset($item['rv_amt_travel_tax']) ? $item['rv_amt_travel_tax'] : 0),
				'revenue'=>$revenue,
				'comm'=>$comm,
				'perc'=>$perc
			);
			$totals['revenue'] += $revenue;
			$totals['accomm'] += $item['rv_amt_accomm_comm'];
			$totals['extra'] += (isset($item['rv_amt_extra_comm']) ? $item['rv_amt_extra_comm'] : 0);
			$totals['travel'] += (isset($item['rv_amt_travel_comm']) ? $item['rv_amt_travel_comm'] : 0);
			$totals['comm'] += $comm;
			$totals['perc'] += $perc;
		}
		//if($id != null) { debug("NULL FOUND"); array_push($newListArray,$newItem); }
		array_push($newListArray,$newItem);
		$id = $item['id'];
	}
}
$listArray = $newListArray;
$newListArray = null;
foreach($totals as $key=>$item) {
	fixAmtDisplay($totals[$key]);
}

if( ($renderOption & 7) == 0 ) {
	$rowHTML = Join("",file(__DIR__ . "/../../../public/html/rep_commission_pop_row.htm"));
	$rows = "";
	foreach($listArray as $item) {
		if($item['rv_amt_accomm_comm'] == "") {
				$item['rv_amt_accomm_comm'] = "&nbsp;";
		}
		if($item['rv_amt_extra_comm'] == "") {
				$item['rv_amt_extra_comm'] = "&nbsp;";
		}
		if($item['rv_amt_travel_comm'] == "") {
				$item['rv_amt_travel_comm'] = "&nbsp;";
		}
		if($item['comm'] == "") {
				$item['comm'] = "&nbsp;";
		}
		if($item['revenue'] == "") {
				$item['revenue'] = "&nbsp;";
		}
		if($item['perc'] == "") {
				$item['perc'] = "&nbsp;";
		}
		fixAmtDisplay($item['rv_amt_accomm_comm']);
		fixAmtDisplay($item['rv_amt_extra_comm']);
		fixAmtDisplay($item['rv_amt_travel_comm']);
		$row = str_replace("!id!",$item['id'],
			str_replace("!name!",$item['name'],
			str_replace("!accomm!",$item['rv_amt_accomm_comm'],
			str_replace("!extras!",$item['rv_amt_extra_comm'],
			str_replace("!travel!",$item['rv_amt_travel_comm'],
			str_replace("!total!",$item['comm'],
			str_replace("!revenue!",$item['revenue'],
			str_replace("!percent!",$item['perc'],$rowHTML))))))));

		$rows .= $row;	
	}

	$GLOBALS['temp']['totalAccomm'] = $totals['accomm'];
	$GLOBALS['temp']['totalExtras'] = $totals['extra'];
	$GLOBALS['temp']['totalTravel'] = $totals['travel'];
	$GLOBALS['temp']['totalComm'] = $totals['comm'];
	$GLOBALS['temp']['totalRevenue'] = $totals['revenue'];
	$GLOBALS['temp']['totalPercent'] = $totals['perc'];
	$GLOBALS['temp']['rows'] = $rows;
	$csvRender = ($renderOption & 7) + 4;
	$GLOBALS['temp']['csvURL'] = "reservation.php?" . join("+",array_slice($_SERVER['argv'],0,12)) . "+$csvRender+" . join("+",array_slice($_SERVER['argv'],13,10));
}

if( ($renderOption & 7) == 4) {
	$csvFile = array();
	array_push($csvFile,array("Commission Report"));
	array_push($csvFile,array());
	array_push($csvFile,array("Financial period", (isset($GLOBALS['temp']['periodName']) ? $GLOBALS['temp']['periodName'] : "") . " (" . $GLOBALS['temp']['fromPeriodName'] . " to " . $GLOBALS['temp']['toPeriodName'] . ")"));
	array_push($csvFile,array("Date range",$GLOBALS['temp']['fromDateFormat'] . " to " . $GLOBALS['temp']['toDateFormat']));
	array_push($csvFile,array("Agents",$agentFilter['names']));
	array_push($csvFile,array("Properties",$propertyFilter['names']));
	array_push($csvFile,array("Currencies",$currenciesFilter['names']));
	array_push($csvFile,array("Status",$statusFilter['names']));
	array_push($csvFile,array("Commission Range",$fromCommission . " to " . $toCommission));
	array_push($csvFile,array("Level 1",(isset($GLOBALS['temp']['level1Name']) ? $GLOBALS['temp']['level1Name'] : "") ));
	array_push($csvFile,array("Level 2",(isset($GLOBALS['temp']['level2Name']) ? $GLOBALS['temp']['level2Name'] : "") ));

	array_push($csvFile,array());
	array_push($csvFile,array("Res No","Res Name","Accomm","Extras","Travel","Total Comm","Revenue","Percentage"));
	foreach($listArray as $item) {
		array_push($csvFile,array(
			$item['id'],
			$item['name'],
			$item['rv_amt_accomm_comm'],
			$item['rv_amt_extra_comm'],
			$item['rv_amt_travel_comm'],
			$item['comm'],
			$item['revenue'],
			$item['perc']));
	}
	array_push($csvFile,array("","TOTAL",$totals['accomm'],$totals['extra'],$totals['travel'],$totals['comm'],$totals['revenue'],$totals['perc']));
	
	
	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				$csvText .= ",";
			} else {
				$first = false;
			}
			$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}
	if(headers_sent()) {
//		echo('Some data has already been output to browser, can\'t send PDF file');
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($csvText));
	header("Content-Disposition: inline; filename=commission_".date("Y-m-d").".csv");
	echo $csvText;
	flush();
	die();
}
