<?php

/**
 * init.form279.func.php - Guest profile popup
 * Job: 209, 210, 211, 212, 213, 214
 * Function: 84 (Contact Guest Role)
 */

require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . "/class.audit.php");
require_once(__DIR__ . "/db.ad_persona_detail.php");
require_once(__DIR__ . "/db.pr_guest_obj_data.php");
require_once(__DIR__ . "/db.pr_guest.php");
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.rf_obj_guest.php");
require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.rv_registration_card.php");

function createfield($obj, $record, $action=1) {
	global $lDB;
	if($obj['rf_obj_guest_type_ind'] == '') {
		$obj['rf_obj_guest_type_ind'] = 1;
	}

	if($obj['rf_obj_guest_inactive_yn'] ==1) {
		$class = "txtg";
	} else {
		$class = "txt";
	}

	$val = '';
	$objHTML = "";
	$template = "
	<div class=\"uk-child-width-expand@s\" uk-grid>
		<div>
			<div class=\"uk-child-width-expand@s\" uk-grid>
				<div class=\"uk-width-1-3@m\">
					<div class=\"uk-text-left\">
							!label!
					</div>
				</div>
				<div>
					<div class=\"uk-text-left\">
						!element!
					</div>
				</div>
			</div>
		</div>
	</div>";
	$tabIndex = 22+$obj['rf_obj_guest_sort_seq'];
		
	switch($obj['rf_obj_guest_type_ind']) {
	case DB_RF_OBJ_GUEST_TEXTBOX:
		if($obj['rf_obj_guest_sys_code'] == 8) {
			if($action == 3 || $action == 1) {
				$idNum = $lDB->get("
					SELECT 
						pr_persona.pr_identity_no 
					FROM 
						pr_persona 
					WHERE 
						pr_persona_ix = '$record'
				",4);
				if($idNum == "0") {
					$idNum = "";
				}
			}
			$objHTML .= "<input type='text' tabindex='".$tabIndex."' class='txt' maxlength='50' name='rf_obj_guest_".$obj['rf_obj_guest_ix']."' id='rf_obj_guest_".$obj['rf_obj_guest_ix']."' value='". (isset($idNum) ? $idNum : "") ."' style='width: 170px;'/>";
		} else {
			if($action == 3 || $action == 1) {
				$res = $lDB->get("
					SELECT 
						pr_guest_obj_data.pr_guest_obj_data_text 
					FROM 
						pr_guest_obj_data 
					WHERE 
						pr_guest_id = '$record' 
						AND rf_obj_guest_id = '$obj[rf_obj_guest_ix]'
				",2);
				$val = isset($res[0]['pr_guest_obj_data_text']) ? t_encodeHTMLField($res[0]['pr_guest_obj_data_text']) : "";
			} else {
				$val = '';
			}
			$objHTML .= "<input type='text' tabindex='".$tabIndex."' class='$class' maxlength='50' name='rf_obj_guest_".$obj['rf_obj_guest_ix']."' id='rf_obj_guest_".$obj['rf_obj_guest_ix']."' value='$val' style='width: 170px;' />";
		}
		break;
	
	case DB_RF_OBJ_GUEST_TEXTAREA:
		$val = '';
		if($obj['rf_obj_guest_sys_code'] == 4) {
			if($_SESSION['userStatusId'] > 1 && ($action == 3 || $action == 1)) {
				$val = $lDB->get("
					SELECT 
						pr_guest.pr_guest_memo 
					FROM 
						pr_guest 
					WHERE 
						pr_guest_id = '$record'
				", 4);
				if($val == "0") {
					$val = "";
				}
			}
			$disabled = "";
			if($_SESSION['userStatusId'] < 2) {
				$disabled = "disabled";
			}
			$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_guest_memo_row.htm"));
			$objHTML = str_replace("!disabled!", $disabled, $objHTML);
			$objHTML = str_replace("!tabindex!", $tabIndex, $objHTML);
			$objHTML = str_replace("!guest_memo!", 'rf_obj_guest_'.$obj['rf_obj_guest_ix'], $objHTML);
			$objHTML = str_replace("!guest_memo_val!", $val, $objHTML);
			$template = $objHTML;
		} elseif($obj['rf_obj_guest_sys_code'] == 5) {
			if($action == 3 || $action == 1) {
				$val = $lDB->get("
					SELECT 
						pr_guest.pr_guest_note 
					FROM 
						pr_guest 
					WHERE 
						pr_guest_id = '$record'
				", 4);
				if($val == "0") {
					$val = "";
				}
			} 
			$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_guest_note_row.htm"));
			$objHTML = str_replace("!guest_note_val!", $val, $objHTML);
			$objHTML = str_replace("!tabindex!", $tabIndex, $objHTML);
			$objHTML = str_replace("!guest_note!", 'rf_obj_guest_'.$obj['rf_obj_guest_ix'], $objHTML);
			$template = $objHTML;
		} else {
			if($action == 3 || $action == 1) {
				$res = $lDB->get("
					SELECT 
						pr_guest_obj_data.pr_guest_obj_data_memo 
					FROM 
						pr_guest_obj_data 
					WHERE 
						pr_guest_id = '$record' 
						AND rf_obj_guest_id = '$obj[rf_obj_guest_ix]'
				", 2);
					
			}
			$val = isset($res[0]['pr_guest_obj_data_memo']) ? $res[0]['pr_guest_obj_data_memo'] : "";
			
			$objHTML .= "<textarea class='$class' name='rf_obj_guest_".$obj['rf_obj_guest_ix']."' id='rf_obj_guest_". $obj['rf_obj_guest_ix']."' style='width: 170px;' tabindex='".$tabIndex."'>". $val ."</textarea>";
		}
		break;
		
	case DB_RF_OBJ_GUEST_RADIO:
		$val = '';
		if($action == 3 || $action == 1) {
			$val = $lDB->get("
				SELECT 
					pr_guest_obj_data.rf_obj_guest_data_id 
				FROM 
					pr_guest_obj_data 
				WHERE 
					pr_guest_id = '$record' 
					AND rf_obj_guest_id = '$obj[rf_obj_guest_ix]'
			", 4);
		} 
		$obj_data = db_rf_obj_guest_data_select($obj['rf_obj_guest_ix']);
		if(is_array($obj_data) && count($obj_data)>0) {
			foreach($obj_data as $data) {
				if($data['rf_obj_guest_data_inactive_yn'] != 0 && $val != $data['rf_obj_guest_data_ix']) {
					continue;
				}
				if($data['rf_obj_guest_data_inactive_yn'] == 1 || $obj['rf_obj_guest_inactive_yn'] ==1) {
					$inactClass = "txtg";
				} else {
					$inactClass = "txt";
				}
				$objHTML .= "<div style=\"margin: 5px 0px;\"><input type='radio' class=\"uk-radio uk-margin-right\" value='".$data['rf_obj_guest_data_ix']."' name='rf_obj_guest_".$obj['rf_obj_guest_ix']."'";
				if($val == $data['rf_obj_guest_data_ix']) {
					$objHTML .= " checked='checked'";
				}
				$objHTML .= " tabindex='".$tabIndex."'><span class='$inactClass'>". $data['rf_obj_guest_data_content']."</span></div>";
			}
		}
		break;

	case DB_RF_OBJ_GUEST_CHECKBOX:
		$val = array();
		if($action == 3 || $action == 1) {
			$val = $lDB->get("
				SELECT 
					pr_guest_obj_data.rf_obj_guest_data_id 
				FROM 
					pr_guest_obj_data 
				WHERE 
					pr_guest_id = '$record' 
					AND rf_obj_guest_id = '$obj[rf_obj_guest_ix]'
			", 3);
		}
				
		$obj_data = db_rf_obj_guest_data_select($obj['rf_obj_guest_ix']);
		if(is_array($obj_data) && count($obj_data)>0) {
			foreach($obj_data as $data) {
				if($data['rf_obj_guest_data_inactive_yn'] != 0 && !in_array($data['rf_obj_guest_data_ix'], $val)) {
					continue;
				}
				if($data['rf_obj_guest_data_inactive_yn'] == 1 || $obj['rf_obj_guest_inactive_yn'] ==1) {
					$inactClass = "txtg";
				} else {
					$inactClass = "txt";
				}
				$objHTML .= "<div style=\"margin: 5px 0px;\"><input type='checkbox' class=\"uk-checkbox uk-margin-right\" value='".$data['rf_obj_guest_data_ix']."' name='rf_obj_guest_".$obj['rf_obj_guest_ix']."[]'";
				if(in_array($data['rf_obj_guest_data_ix'], $val)) {
					$objHTML .= " checked='checked'";
				}
				$objHTML .= " tabindex='".$tabIndex."'><span class='$inactClass'>". $data['rf_obj_guest_data_content'] ."</span></div>";
			}
		}
		
		break;
		
	case DB_RF_OBJ_GUEST_SELECTBOX:
		$val = '';
		if($obj['rf_obj_guest_sys_code'] == 7) {
			if($action == 3 || $action == 1) {
				$val = $lDB->get("
					SELECT 
						pr_guest.rf_guest_type_id 
					FROM 
						pr_guest 
					WHERE 
						pr_guest_id = '$record'
				", 4);
			} 
			if (isset($GLOBALS['form279_pr_guest_rf_guest_type_ix']->Value)) {
				$pr_guest_rf_guest_type_id_string = "OR (CONCAT(rf_guest_type_db,rf_guest_type_ix) = '".$GLOBALS['form279_pr_guest_rf_guest_type_ix']->Value."')";
			} else {
				$pr_guest_rf_guest_type_id_string = "";
			}

			$sel = $lDB->get("
				SELECT
					rf_guest_type_ix,
					rf_guest_type_name
				FROM
					rf_guest_type
				WHERE
					rf_guest_type_inactive_yn = '0'
					".$pr_guest_rf_guest_type_id_string."		
				ORDER BY 
					rf_guest_type_name
			", 2);

			$objHTML .= "<select id = 'rf_obj_guest_".$obj['rf_obj_guest_ix']."' name= 'rf_obj_guest_". $obj['rf_obj_guest_ix']."' class='forminput' style='width: 170px;' tabindex='".$tabIndex."' >
					<option value=''>&nbsp;</option>";
			
			if(is_array($sel) && count($sel)>0) {
				foreach($sel as $data) {
					$objHTML .= "<option value='".$data['rf_guest_type_ix']."'";
					if($val == $data['rf_guest_type_ix']) {
						$objHTML .= " selected='selected'";
					}
					$objHTML .= " >". $data['rf_guest_type_name']."</option>";
				}
			}
			$objHTML .= "</select>";
		
		} else {
			if($action == 3 || $action == 1) {
				$val = $lDB->get("
					SELECT 
						pr_guest_obj_data.rf_obj_guest_data_id 
					FROM 
						pr_guest_obj_data 
					WHERE 
						pr_guest_id = '$record' 
						AND rf_obj_guest_id = '$obj[rf_obj_guest_ix]'
				", 4);
			}
			$obj_data = db_rf_obj_guest_data_select($obj['rf_obj_guest_ix']);
			
			$objHTML .= "
				<select name='rf_obj_guest_".$obj['rf_obj_guest_ix']."' style='width: 170px;' tabindex='".$tabIndex."'>
					<option value=''>&nbsp;</option>	
			";
			if(is_array($obj_data) && count($obj_data)>0) {
				foreach($obj_data as $data) {
					if($data['rf_obj_guest_data_inactive_yn'] != 0 && $val != $data['rf_obj_guest_data_ix']) {
						continue;
					}
					if($data['rf_obj_guest_data_inactive_yn'] == 1 || $obj['rf_obj_guest_inactive_yn'] ==1) {
						$inactClass = "txtg";
					} else {
						$inactClass = "txt";
					}
					$objHTML .= "<option value='".$data['rf_obj_guest_data_ix']."'";
					if($val == $data['rf_obj_guest_data_ix']) {
						$objHTML .= " selected='selected'";
					}
					$objHTML .= " class='$inactClass'>". $data['rf_obj_guest_data_content']."</option>";
				}
			}
			$objHTML .= "</select>";
		}
		break;
		
	case DB_RF_OBJ_GUEST_NUMERIC:
		$val = '';
		if($action == 3 || $action == 1) {
			$res = $lDB->get("
				SELECT 
					pr_guest_obj_data.pr_guest_obj_data_text 
				FROM 
					pr_guest_obj_data 
				WHERE 
					pr_guest_id = '$record' 
					AND rf_obj_guest_id = '$obj[rf_obj_guest_ix]'
			", 2);

			$val = isset($res[0]['pr_guest_obj_data_text'])? $res[0]['pr_guest_obj_data_text'] : "";
		}
		$objHTML .= "<input type='text' tabindex='".$tabIndex."' class='$class' size='50' maxlength='50' value='$val' name='rf_obj_guest_".$obj['rf_obj_guest_ix']."' id='rf_obj_guest_".$obj['rf_obj_guest_ix']."' onkeypress='ensureNumeric()' />";
		break;
		
	case DB_RF_OBJ_GUEST_DATE:
		$val = '0000-00-00';
		if($obj['rf_obj_guest_sys_code'] == 2) {
			if($action == 3 || $action == 1 || $action == 2) {
				$val = $lDB->get("
					SELECT 
						pr_persona.pr_birthdate 
					FROM 
						pr_persona 
					WHERE 
						pr_persona_ix = '$record'
				",4);
				if($val == "0") {
					$val = "0000-00-00";
				}
			
			} 
			$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_guest_birth_row.htm"));
			$objHTML = str_replace("!tabindex!", $tabIndex, $objHTML);
			$objHTML = str_replace("!guest_birthdate_val!", $val, $objHTML);
			$objHTML = str_replace("!guest_birthdate!", 'rf_obj_guest_'.$obj['rf_obj_guest_ix'], $objHTML);
			$template = $objHTML;
			$GLOBALS['temp']['guest_birthdate'] = 'rf_obj_guest_'.$obj['rf_obj_guest_ix'];
			
		} elseif($obj['rf_obj_guest_sys_code'] == 3) {
			if($action == 3 || $action == 1 || $action == 2) {
				$val = $lDB->get("
					SELECT 
						pr_persona.pr_anniversary 
					FROM 
						pr_persona 
					WHERE 
						pr_persona_ix = '$record'
				",4);
				if($val == "0") {
					$val = "0000-00-00";
				}
			}
			$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_guest_anniversary_row.htm"));
			$objHTML = str_replace("!tabindex!", $tabIndex, $objHTML);
			$objHTML = str_replace("!guest_anniversary_val!", $val, $objHTML);
			$objHTML = str_replace("!guest_anniversary!", 'rf_obj_guest_'.$obj['rf_obj_guest_ix'], $objHTML);
			$template = $objHTML;
			$GLOBALS['temp']['guest_anniversary'] = 'rf_obj_guest_'.$obj['rf_obj_guest_ix'];
		} 
		break;
		
	case DB_RF_OBJ_GUEST_NATION_LOOKUP:
		if($obj['rf_obj_guest_sys_code'] == 1) {
			$nationality = $lDB->get("
				SELECT
					rf_country.rf_country_ix,
					rf_country.rf_country_name
				FROM
					pr_guest
					INNER JOIN rf_country ON rf_country.rf_country_ix = pr_guest.rf_country_id
				WHERE
					pr_guest.pr_guest_id = '$record'
			", 1);

			if(!is_array($nationality) || (is_array($nationality) && (!array_key_exists("rf_country_ix",$nationality) || $nationality['rf_country_ix'] == "" || $nationality['rf_country_ix'] ==  "0")) ) {
				$nationality['rf_country_ix'] = "";
				$nationality['rf_country_name'] = "Unknown";
			}
			$nationality['guest_nation'] = "rf_obj_guest_".$obj['rf_obj_guest_ix'];
			$nationality['tabindex'] = $tabIndex;
		  
			$objHTML .= Join("",file(__DIR__ . "/../../../public/html/contact_guest_nation_row.htm"));
			$objHTML = showpage($nationality,$objHTML);
			$template = $objHTML;
		}
		break;
	}

	if(empty($val) && $obj['rf_obj_guest_inactive_yn'] !=0 && $obj['rf_obj_guest_sys_code']<1) {
		$rowHTML = "";	
	} else {
		$style = "txt";
		if($obj['rf_obj_guest_inactive_yn'] ==1) {
			$style = "txtg";
		}
		$rowHTML = str_replace("!label!", $obj['rf_obj_guest_label'], $template);
		$rowHTML = str_replace("!element!", $objHTML, $rowHTML);
	}
	
	return $rowHTML;
}

function saveChanges($record,$obj_guest) {
	global $lDB;

	$_POST['pr_name_last'] 				= isset($_POST['pr_name_last']) ? $_POST['pr_name_last'] : "";
	$_POST['pr_name_first'] 			= isset($_POST['pr_name_first']) ? $_POST['pr_name_first'] : "";
	$_POST['pr_title_id'] 				= isset($_POST['pr_title_id']) ? $_POST['pr_title_id'] : "";
	$_POST['pr_name_suffix_id'] 		= isset($_POST['pr_name_suffix_id']) ? $_POST['pr_name_suffix_id'] : "";
	$_POST['pr_email'] 					= isset($_POST['pr_email']) ? $_POST['pr_email'] : "";
	$_POST['pr_corr_addr_line1'] 		= isset($_POST['pr_corr_addr_line1']) ? $_POST['pr_corr_addr_line1'] : "";
	$_POST['pr_corr_addr_line2'] 		= isset($_POST['pr_corr_addr_line2']) ? $_POST['pr_corr_addr_line2'] : "";
	$_POST['pr_corr_addr_line3'] 		= isset($_POST['pr_corr_addr_line3']) ? $_POST['pr_corr_addr_line3'] : "";
	$_POST['pr_corr_city'] 				= isset($_POST['pr_corr_city']) ? $_POST['pr_corr_city'] : "";
	$_POST['pr_corr_country_id'] 		= isset($_POST['pr_corr_country_id']) ? $_POST['pr_corr_country_id'] : "";
	$_POST['pr_corr_post_code'] 		= isset($_POST['pr_corr_post_code']) ? $_POST['pr_corr_post_code'] : "";
	$_POST['pr_phys_addr_line1'] 		= isset($_POST['pr_phys_addr_line1']) ? $_POST['pr_phys_addr_line1'] : "";
	$_POST['pr_phys_addr_line2'] 		= isset($_POST['pr_phys_addr_line2']) ? $_POST['pr_phys_addr_line2'] : "";
	$_POST['pr_phys_addr_line3'] 		= isset($_POST['pr_phys_addr_line3']) ? $_POST['pr_phys_addr_line3'] : "";
	$_POST['pr_phys_city'] 				= isset($_POST['pr_phys_city']) ? $_POST['pr_phys_city'] : "";
	$_POST['pr_phys_country_id'] 		= isset($_POST['pr_phys_country_id']) ? $_POST['pr_phys_country_id'] : "";
	$_POST['pr_phys_post_code'] 		= isset($_POST['pr_phys_post_code']) ? $_POST['pr_phys_post_code'] : "";
	$_POST['rf_comms_preference_id'] 	= isset($_POST['rf_comms_preference_id']) ? $_POST['rf_comms_preference_id'] : "";

	$audit = new AuditTrail($record,TYPE_PERSONA);

	if(!db_pr_persona_exists($record)) {
		$new = true;
		$record = db_pr_persona_insert("0",$_POST['pr_name_last'],$_POST['pr_name_first'],$_POST['pr_title_id'],$_POST['pr_name_suffix_id'],$_POST['pr_email'],$_POST['pr_corr_addr_line1'],$_POST['pr_corr_addr_line2'],$_POST['pr_corr_addr_line3'],$_POST['pr_corr_city'],$_POST['pr_corr_country_id'],$_POST['pr_corr_post_code'],$_POST['pr_phys_addr_line1'],$_POST['pr_phys_addr_line2'],$_POST['pr_phys_addr_line3'],$_POST['pr_phys_city'],$_POST['pr_phys_country_id'],$_POST['pr_phys_post_code'],$_POST['rf_comms_preference_id']);
	} else {
		$new = false;
		$current = $GLOBALS['lDB']->get("
			SELECT
				*
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix = '".$lDB->escape($record)."'
		",1);
		db_pr_persona_update($record,$_POST['pr_name_last'],$_POST['pr_name_first'],$_POST['pr_title_id'],$_POST['pr_name_suffix_id'],$_POST['pr_email'],$_POST['pr_corr_addr_line1'],$_POST['pr_corr_addr_line2'],$_POST['pr_corr_addr_line3'],$_POST['pr_corr_city'],$_POST['pr_corr_country_id'],$_POST['pr_corr_post_code'],$_POST['pr_phys_addr_line1'],$_POST['pr_phys_addr_line2'],$_POST['pr_phys_addr_line3'],$_POST['pr_phys_city'],$_POST['pr_phys_country_id'],$_POST['pr_phys_post_code'],$_POST['rf_comms_preference_id']);
	}

	db_pr_guest_insert($record);

	foreach($obj_guest as $obj) {
		if(isset($_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]) && is_array($_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']])) {
			$pr_guest_obj_datas = $lDB->get("
				SELECT
					pr_guest_obj_data_ix,
					rf_obj_guest_data_id
				FROM
					pr_guest_obj_data
				WHERE
					pr_guest_id = '".$lDB->escape($record)."'
					AND rf_obj_guest_id = '".$lDB->escape($obj['rf_obj_guest_ix'])."'
			", 2);
			$rf_obj_guest_data_ids = [];
		
			if(is_array($pr_guest_obj_datas) && !empty($pr_guest_obj_datas)) {
				foreach ($pr_guest_obj_datas as $pr_guest_obj_data) {
					$pr_guest_obj_data_id = $pr_guest_obj_data['pr_guest_obj_data_ix'];
					$rf_obj_guest_data_ids[] = $rf_obj_guest_data_id = $pr_guest_obj_data['rf_obj_guest_data_id'];
					if(!in_array($rf_obj_guest_data_id, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']])) {
						$all = db_pr_guest_obj_data_get_all($pr_guest_obj_data_id);
						$audit->addDetail($all['id'], "", $pr_guest_obj_data_id, "", DB_AD_PERSONA_DETAIL_ACTION_DELETE, "guest", "pr_guest_obj_data.", $obj['rf_obj_guest_ix'], $all['value'], "");
						db_pr_guest_obj_data_delete($pr_guest_obj_data_id);
					}
				}
			}
			foreach($_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']] as $chk) {
				if(!in_array($chk, $rf_obj_guest_data_ids)) {
					$pr_guest_obj_data_id = db_pr_guest_obj_data_insert($record, $obj['rf_obj_guest_ix'], $chk);
					$all = db_pr_guest_obj_data_get_all($pr_guest_obj_data_id);

					$audit->addDetail("", $all['id'], "", $pr_guest_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "guest", "pr_guest_obj_data.", $obj['rf_obj_guest_ix'], "", $all['value']);
				}
			}
			
		} else {
			if(array_key_exists('rf_obj_guest_'. $obj['rf_obj_guest_ix'],$_POST)) {
				$newAll = db_rf_obj_guest_get_all($obj['rf_obj_guest_ix'], $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
				if(db_pr_guest_obj_data_exists_by_guest($record, $obj['rf_obj_guest_ix'])) {
					$pr_guest_obj_data_id = db_pr_guest_obj_data_select_by_guest($record, $obj['rf_obj_guest_ix']);
					
					if(array_key_exists('rf_obj_guest_'. $obj['rf_obj_guest_ix'],$_POST)) {
						$oldAll = db_pr_guest_obj_data_get_all($pr_guest_obj_data_id);
						db_pr_guest_obj_data_update($pr_guest_obj_data_id, $obj['rf_obj_guest_ix'], $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
						$audit->addDetail($oldAll['id'], $newAll['id'], $pr_guest_obj_data_id, $pr_guest_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "guest", "pr_guest_obj_data.", $obj['rf_obj_guest_ix'], $oldAll['value'], $newAll['value']);
					}
				} else {
					$pr_guest_obj_data_id = db_pr_guest_obj_data_insert($record, $obj['rf_obj_guest_ix'], $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
					$audit->addDetail("", $newAll['id'], "", $pr_guest_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "guest", "pr_guest_obj_data.", $obj['rf_obj_guest_ix'], "", $newAll['value']);
				}
				
				if($obj['rf_obj_guest_sys_code'] > 0) {
					$fieldName = db_rf_obj_guest_find_field_name($obj['rf_obj_guest_sys_code']);
					if($fieldName == "pr_identity_no") {
						db_pr_persona_update_identity($record,$_POST['rf_obj_guest_'. $obj['rf_obj_guest_ix']]);
					} else {
						switch($fieldName) {
						case "pr_guest_gender":
							if($_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']] == "RS1") {
								$gender = "M";
						} else if($_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']] == "RS2") {
							$gender = "F";
						} else {
							$gender = "";
						}
							db_pr_guest_set_gender($record, $gender);
							break;
						case "rf_guest_type_ix":
							db_pr_guest_set_type($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						case "rf_country_id":
							db_pr_guest_set_country($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						case "pr_anniversary":
							db_pr_persona_update_anniversary($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						case "pr_birthdate":
							db_pr_persona_update_birthdate($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						case "pr_guest_note":
							db_pr_guest_set_note($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						case "pr_guest_memo":
							db_pr_guest_set_memo($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						case "pr_guest_memo":
							db_pr_guest_set_gender($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						case "pr_guest_primary_yn":
							db_pr_guest_set_role($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						case "pr_guest_inactive_yn":
							db_pr_guest_set_inactive($record, $_POST['rf_obj_guest_'.$obj['rf_obj_guest_ix']]);
							break;
						}
					}
				}
			} else {
				// Remove all pr_guest_obj_data records
				$pr_guest_obj_data = $lDB->get("SELECT rf_obj_guest_data_id, pr_guest_obj_data_ix FROM pr_guest_obj_data WHERE rf_obj_guest_id = '".$obj['rf_obj_guest_ix']."' AND pr_guest_id = '".$record."'", 2);
				if(is_array($pr_guest_obj_data) && !empty($pr_guest_obj_data)) {
					foreach ($pr_guest_obj_data as $pr_guest_obj) {
						db_pr_guest_obj_data_delete($pr_guest_obj['pr_guest_obj_data_ix']);
					}
				}				
			}
		}
	}
	saveRole($record, $audit);
	saveTelephone($record, $audit);
	savePrimaryLink($record);
	saveAgentLink($record);
	if(array_key_exists("pr_guest_inactive_yn",$_POST)) {
		db_pr_guest_set_inactive($record,$_POST['pr_guest_inactive_yn']);
	}
	$audit->save("Guest details (Edit)");
	return $record;
}

function saveTelephone($record,$audit) {
	global $dbcode;
	global $lDB;

	$newphone = $_POST['phone_default'];
	$pr_phone_id = $lDB->get("SELECT pr_phone_ix FROM pr_phone WHERE pr_persona_id = '".$lDB->escape($record)."' AND pr_default_yn = '1'",4);
	if (!empty($pr_phone_id)) {
		$oldphone = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'",4);
		if ($newphone != $oldphone) {
			$lDB->put("UPDATE pr_phone SET pr_phone_number = '".$lDB->escape($newphone)."' WHERE pr_persona_id = '$record' and pr_default_yn = '1'");
			$audit->addDetail($oldphone, $newphone, $pr_phone_id, $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "phone", "pr_phone.pr_phone_number");
		}
	} else {
		if ($newphone != "") {
			$lDB->put("
				INSERT INTO pr_phone (
					pr_phone_db,
					pr_phone_id,
					pr_phone_number,
					pr_persona_id,
					pr_default_yn,
					rf_phone_type_id
				) VALUES (
					'".$lDB->escape($dbcode)."',
					'',
					'".$lDB->escape($newphone)."',
					'".$lDB->escape($record)."',
					'1',
					'RS3'
				)
			");
			$pr_phone_id = $lDB->insert_id;
			$audit->addDetail("", 1, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_default_yn");
			$audit->addDetail("", $newphone, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number");
			$audit->addDetail("", "RS3", "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id");
		}
	}	
}

function savePrimaryLink($record) {
	global $dbcode;
	global $lDB;

	if($_POST['primaryLinkId'] != "" && $_POST['primaryLinkId'] != $record) {
		$linkId = $lDB->get("
			SELECT
				pr_link_ix as id
			FROM
				pr_link
			WHERE
				pr_link_from = '$record'
				AND rf_link_type_id = 'RS3'
		",2);
		foreach($linkId as $item) {
			$lDB->put("DELETE FROM	pr_link	WHERE pr_link_ix='$item[id]'");
		}
		$lDB->put("
			INSERT INTO
				pr_link (
					pr_link_db,
					pr_link_to,
					pr_link_from,
					rf_link_type_id
				) VALUES (
					'".$lDB->escape($dbcode)."',
					'".$lDB->escape($_POST['primaryLinkId'])."',
					'".$lDB->escape($record)."',
					'RS3'
				)
		");
		// check for linked address
		$linkId = $lDB->get("
			SELECT
				pr_persona_link_id
			FROM
				pr_persona
			WHERE
				pr_persona_ix = '$record'
		",4);
		$addressInfo = $lDB->get("
			SELECT
				concat(pr_corr_addr_line1,
				pr_corr_addr_line2,
				pr_corr_addr_line3,
				pr_phys_addr_line1,
				pr_phys_addr_line2,
				pr_phys_addr_line3)
			FROM
				pr_persona
			WHERE
				pr_persona_ix = '$record'
		", 4);
        if( ( $linkId != "0" || trim($addressInfo) == "") && $_POST['primaryLinkId'] != $record) {
			$lDB->put("
				UPDATE
					pr_persona
				SET
					pr_persona_link_id = '".$lDB->escape($_POST['primaryLinkId'])."'
				WHERE
					pr_persona_ix = '$record'
			");
        }
    }	
}

function saveAgentLink($record) {
	global $dbcode;
	global $lDB;

	if($_POST['agentLinkId'] != "") {
		$linkId = $lDB->get("
			SELECT
				pr_link_ix as id
			FROM
				pr_link
			WHERE
				pr_link_from = '$record'
				AND rf_link_type_id = 'RS4'
		", 2);
		foreach($linkId as $item) {
			$lDB->put("DELETE FROM pr_link WHERE pr_link_ix='$item[id]'");
		}
		$lDB->put("
			INSERT
		 INTO
			pr_link (
			   pr_link_db,
			   pr_link_to,
			   pr_link_from,
			   rf_link_type_id
			) VALUES (
			   '".$lDB->escape($dbcode)."',
			   '".$lDB->escape($_POST['agentLinkId'])."',
			   '".$lDB->escape($record)."',
			   'RS4'
			)
		");
	}
	if($_POST['secondaryLinkId'] != "") {
		$lDB->put("
			DELETE
			FROM
				pr_link
			WHERE
				pr_link.pr_link_ix = '".$_POST['secondaryLinkId']."'
		");
	}	
}

function saveRole($record, $audit) {
	global $lDB;

	$pr_guest_primary_yn = $_POST['pr_guest_primary_yn'];

	if($pr_guest_primary_yn == "0") {
		$linkCount = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				pr_link
			WHERE
				rf_link_type_id = 'RS3'
				AND pr_link_to = '$record'
		",4);
		if($linkCount > 0) {
			$pr_guest_primary_yn = "1";
		}
	} else {
		$linkId = $lDB->get("
			SELECT
				pr_link_ix as id
			FROM
				pr_link
			WHERE
				rf_link_type_id = 'RS3'
				AND pr_link_from = '$record'
		",2);
		if(sizeof($linkId) > 0) {
			foreach($linkId as $item) {
				$lDB->put("DELETE FROM pr_link WHERE pr_link_ix = '$item[id]'");
			}
		}
	}	

	$oldValue = $lDB->get("SELECT pr_guest_primary_yn FROM pr_guest WHERE pr_guest.pr_guest_id = '".$lDB->escape($record)."'",4);
	if($pr_guest_primary_yn != $oldValue) {
		$audit->addDetail($oldValue, $pr_guest_primary_yn, $record, $record, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "guest", "pr_guest.pr_guest_primary_yn");
	}

	db_pr_guest_set_role($record,$pr_guest_primary_yn);
}
