<?php

/**
 * Reservation rooming tab
 */

$_SERVER['argv'] = array_pad($_SERVER['argv'],3,"");

if (
	checkJob(216) &&
	$_SERVER['argv'][0] == "215" &&
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	redirectTo(" reservation.php?216+". $_SERVER['argv'][1]);
	die();
}

$wetu = new Wetu($record, $GLOBALS['lDB']);
$GLOBALS['temp']['wetuDropdownOptions'] = $wetu->GenerateButtontext();

$colours = array(
	array('#FFFFDF','#FAF9C7','#FCFBB6','#FBFAA1','#F4F38D','#F6F576','#F8F761','#F0EF57'),
	array('#FDE7C4','#FCDBA8','#FAD396','#FACF8B','#F9CB83','#F7C370','#F4BB61','#F0B557'),
	array('#E8DDBB','#DFD2AB','#D8CBA3','#D1C399','#C7B88C','#BCAC7D','#B5A471','#AE9C66'),
	array('#C0E5C0','#A6DBA6','#91D491','#7AC87A','#6FBE6F','#60B260','#57AB57','#4F9E4F'),
	array('#D5E8F4','#C2D7E4','#B8CFDD','#ADC6D6','#9FBBCC','#97B5C7','#85A7BC','#6D96AE')
);

$colX = sizeof($colours);
$colY = sizeof($colours[0]);

$record = $_SERVER['argv'][1];
$view = $_SERVER['argv'][2];
if($view == "1") {
	$GLOBALS['temp']['view'] = "guest";
} else {
	$GLOBALS['temp']['view'] = "group";
}

if(!isset($GLOBALS[$form])) {
	if($view == "1") {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/reservation_rooming.htm");
	} else {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/reservation_rooming_rooms.htm");
	}
}

$GLOBALS['temp']['record'] = $record;

// Define scrollset -----------------------------------------------------------
if($_SERVER['argv'][2] != "" && substr($_SERVER['argv'][2], 0, 13) == "resScrollSet:") {
	session_set("resScrollSet",array_values(explode(":", substr($_SERVER['argv'][2],13))));
}

$resScrollSet = isset($_SESSION['resScrollSet'])?$_SESSION['resScrollSet']:array();
if ( !is_array($resScrollSet) ) {
	$resScrollSet = array();
}
// Setup the record scrolling -------------------------------------------------
$rPrev = $record;
$rNext = $record;

if (is_array($resScrollSet)) {
	for ($q = 0; $q < sizeof($resScrollSet); $q++) {
		$key = isset($resScrollSet[$q]) ? $resScrollSet[$q] : "";

		if ($key == $record) {

			if ($q > "0") {
				$rPrev = $resScrollSet[$q-1];
			}

			if ($q + 1 < sizeof($resScrollSet)) {
				$rNext = $resScrollSet[$q+1];
			}
		}
	}
}
$recordnext = $rNext;
$recordprev = $rPrev;
addLastRes($record);
$value = $record;
if ($value == "0") {
	$value = "";
}
if(!isset($naviset_str)) {
	$naviset_str = "";
}
$GLOBALS['temp']['value'] = $value;
$GLOBALS['temp']['recordnext'] = $recordnext;
$GLOBALS['temp']['recordprev'] = $recordprev;
$GLOBALS['temp']['naviset'] = $naviset_str;

# Display/hide notes icon
$GLOBALS['temp']['nflag'] = "noNotes";
$nflag = $GLOBALS['lDB']->get("SELECT rv_note_general FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
$GLOBALS['temp']['resNote'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($nflag)));
      
$iflag = $GLOBALS['lDB']->get("SELECT rv_note_internal FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
$GLOBALS['temp']['intNote'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($iflag)));

$gflag = $GLOBALS['lDB']->get("SELECT rv_note_guests FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
$GLOBALS['temp']['guestNote'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($gflag)));

$GLOBALS['temp']['intOnly'] = "";

if($_SESSION['userStatusId'] > 1) {
	if (((strlen(trim($nflag)) > 0) || (strlen(trim($iflag)) > 0) || (strlen(trim($gflag)) > 0)) && $action != "2") {
		$GLOBALS['temp']['nflag'] = "notes";
	}
} else {
	if (((strlen(trim($nflag)) > 0) || (strlen(trim($gflag)) > 0)) && $action != "2") {
		$GLOBALS['temp']['nflag'] = "notes";
	}
	$GLOBALS['temp']['intOnly'] = "collapse printCollapse";
}
   
$GLOBALS['temp']['eflag'] = "noExtras";
$eflag = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_extra WHERE rv_reservation_id = '$record'",1);
if($eflag[0] > 0) {
	$GLOBALS['temp']['eflag'] = "extras";
}

$GLOBALS['temp']['rtabflag'] = "";
$GLOBALS['temp']['handlerClass'] = "tabNoData";
$rtabflag = getReservationRooming($record);    
if(sizeof($rtabflag['guests']) > 0 || sizeof($rtabflag['rooms']) > 0){
	$GLOBALS['temp']['rtabflag'] = "signal_cellular_4_bar";;
}

$userSQL = "";
if($_SESSION['userStatusId'] <= 1) {
	$userSQL = " AND em_mail_log.pr_user_id = '$GLOBALS[userid]'";
}   
$ctabflag = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		em_mail
		INNER JOIN em_mail_log ON em_mail.em_mail_ix = em_mail_log.em_mail_id
	WHERE
		em_action = '-1'
		AND rv_reservation_id LIKE '$record'
		$userSQL
",4);
$commProvCheck = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		ad_reservation
	WHERE
		ad_reservation.rv_reservation_id LIKE '$record'
		AND ad_reservation.ad_res_form = 'Sent Prov Notification'
",4);
$GLOBALS['temp']['ctabflag'] = "";
if($ctabflag > 0 || $commProvCheck > 0){
	$GLOBALS['temp']['ctabflag'] = "bEmail";
}

$remSQL = "SELECT COUNT(*) FROM re_reminder WHERE re_reminder_link_to_ind_id = '1' AND re_reminder_link_to_id  = '{$record}'";
$GLOBALS['temp']['retabflag'] = ($GLOBALS['lDB']->get($remSQL,4) > 0 ) ? "show" : "";


// Details for the Itinerary Summary Popup in functions.reservation.php
getItinSummary($record);  
   
$roomCheckIn = $GLOBALS['lDB']->get("
	SELECT 
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '5'
",4);
$roomCheckOut = $GLOBALS['lDB']->get("
	SELECT 
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '8'
",4);

$GLOBALS['temp']['rflag'] = "roomNone";
if($roomCheckIn > 0 || $roomCheckOut > 0) {
	$roomCheckTime = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_group.rv_grp_status_time
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
			AND (
				rv_res_item_group.rv_grp_status_ind = '5'
				OR rv_res_item_group.rv_grp_status_ind = '8'
			)
		ORDER BY
			rv_res_item_group.rv_grp_status_time DESC
	",4);
}
if($roomCheckIn > 0) {
	$GLOBALS['temp']['rflag'] = "roomIn";
}
if($roomCheckOut > 0) {
	$GLOBALS['temp']['rflag'] = "roomOut";
}

$resInfo = $GLOBALS['lDB']->get("
	SELECT
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation.rv_date_changed,
		rv_reservation.rv_date_recorded,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first
	FROM
		rv_reservation
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.pr_reservation_user_id
	WHERE
		rv_reservation_ix = '$record'
",2);

$GLOBALS['temp']['resId'] = $resInfo[0]['rv_reservation_ix'];
$GLOBALS['temp']['resName'] = $resInfo[0]['rv_res_name'];
$GLOBALS['temp']['resDateCreated'] = chng_date($resInfo[0]['rv_date_recorded'],"-");
$GLOBALS['temp']['resDateChanged'] = chng_date($resInfo[0]['rv_date_changed'],"-");
$resPersonaName = $resInfo[0]['pr_name_last'];
if(trim($resInfo[0]['pr_name_first']) != "") {
   $resPersonaName = $resInfo[0]['pr_name_first'] . "  " . $resPersonaName;
}
if(trim($resPersonaName) == "") {
	$resPersonaName = "N/A";
}
$GLOBALS['temp']['resPersonaName'] = $resPersonaName;
//Reservation Status
//Reservation Status
$resStatus = $GLOBALS['lDB']->get("
	SELECT 
		rf_reservation_status.rf_reservation_status_id as resStatusId,
		rf_reservation_status.rf_reservation_status_desc as resStatusDesc
	FROM 
		rv_reservation
		INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id 
	WHERE 
		rv_reservation.rv_reservation_ix = '$record'
",1);
$GLOBALS['temp']['statusDesc'] = $resStatus['resStatusDesc'];
$GLOBALS['temp']['statusClass'] = "txt";
if($resStatus['resStatusId'] == "90"){
	$GLOBALS['temp']['statusClass'] = "txtb";
}
if($resStatus['resStatusId'] == "20"){
	$expDate = $lDB->get("SELECT rv_provision_expiry_date FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);

	$today = date("Y-m-d");
	if($today == $expDate) {
		$GLOBALS['temp']['provBg'] = "#F1C55D";
		$GLOBALS['temp']['statusDesc'] .= " (Expires: ".chng_date($expDate, "-").")";
	} elseif($today > $expDate) {
		$GLOBALS['temp']['provBg'] = "#DB4242";
		$GLOBALS['temp']['statusDesc'] .= " (Expires: ".chng_date($expDate, "-").")";
	}
}

$GLOBALS['temp']['notesTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['notesDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][138])) {
	$GLOBALS['temp']['notesTabClass'] = "buttonTabDisabled";
	$GLOBALS['temp']['notesDisabled'] = "disabled";
}

$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['roomingDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][215])) {
	$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['roomingDisabled'] = "disabled";
}

$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['financialDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][646])) {
	$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['financialDisabled'] = "disabled";
}


if (
	array_key_exists(2,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][2] > 5 &&		// Edit reservation form
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['resDetailJob'] = "reservation.php?2+".$record;
} else {
	$GLOBALS['temp']['resDetailJob'] = "reservation.php?0+".$record;
}
if (
	array_key_exists(137,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][137] > 5 &&	// Reservation Notes Add Note
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['resNoteJob'] = "reservation.php?137+".$record;
} else {
	$GLOBALS['temp']['resNoteJob'] = "reservation.php?138+".$record;
}
if(checkjob(610)) {
	$GLOBALS['temp']['resExtraJob'] = "reservation.php?610+".$record;
} else {
	$GLOBALS['temp']['resExtraJob'] = "reservation.php?609+".$record;
}
if (
	array_key_exists(647,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][647] > 5 &&		// Reservation Billings Edit
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5				// Res tabs
) {
	$GLOBALS['temp']['resBillingJob'] = "reservation.php?647+".$record;
} else {
	$GLOBALS['temp']['resBillingJob'] = "reservation.php?646+".$record;
}

$GLOBALS['temp']['resCommJob'] = "reservation.php?191+".$record;
$GLOBALS['temp']['resNotifyJob'] = "reservation.php?642+".$record."+4";
$GLOBALS['temp']['resDocumentJob'] = "reservation.php?642+".$record;
$GLOBALS['temp']['resAuditJob'] = "reservation.php?700+".$record;
if($_SERVER['argv'][0] == "215") {
	$GLOBALS['temp']['resRoomGuestJob'] = "reservation.php?215+$record+1";
	$GLOBALS['temp']['resRoomGroupJob'] = "reservation.php?215+$record";
} else {
	$GLOBALS['temp']['resRoomGuestJob'] = "reservation.php?216+$record+1";
	$GLOBALS['temp']['resRoomGroupJob'] = "reservation.php?216+$record";
}

$GLOBALS['temp']['copyGroupId'] = "";
$_POST['copyGroupId'] = isset($_POST['copyGroupId'])?$_POST['copyGroupId']:"";
if($_POST['copyGroupId'] != "") {
	$GLOBALS['temp']['copyGroupId'] = $_POST['copyGroupId'];
}

$disableDisplay = "";
if($action == 1 || $view == 1) {
	$disableDisplay = "disabled";
}
$GLOBALS['temp']['disableDisplay'] = $disableDisplay;

// update / save
if($pmode == "1") {
	if(isset($_POST['guestImportList']) && $_POST['guestImportList'] != "") {
		$guestList = explode(":",$_POST['guestImportList']);
		$groupId = $_POST['guestImportGroup'];
		if($groupId == "" && $_POST['guestImportResItem'] != "") {
			$newGuestList = array();
			foreach($guestList as $item) {
				$check = $GLOBALS['lDB']->get("
					SELECT
						COUNT(rv_res_item_guest_id)
					FROM
						rv_res_item_guest
					WHERE
						rv_reservation_item_id = '$_POST[guestImportResItem]'
						AND pr_guest_id = '$item'
				",4);
				if($check == 0) {
					array_push($newGuestList,$item);
				}
			}
			$guestList = $newGuestList;
			unset($newGuestList);
			if(sizeof($guestList) > 0) {
				$groupId = db_rv_res_item_group_insert($_POST['guestImportResItem']);
			}
		}
		foreach($guestList as $item) {
			db_pr_guest_insert($item);
			db_rv_reservation_guest_insert($record,$item);
			if($groupId != "") {
				db_rv_res_item_guest_insert($item, $groupId);
			}
			$guestName = getContactFullName($item,false);
			ammendReservation($record,"Guests (Insert: $guestName [".$item."])");				
		}
	}
	if(isset($_POST['guestGroupList']) && $_POST['guestGroupList'] != ""
		&& isset($_POST['resItemGroupList']) && $_POST['resItemGroupList'] != ""
	) {
		$guestArray = explode(":",$_POST['guestGroupList']);
		$itemArray = explode(":",$_POST['resItemGroupList']);
		foreach($itemArray as $item) {
			$groupId = db_rv_res_item_group_insert($item);
			if(!($groupId === false)) {
				$addedGuest = false;
				foreach($guestArray as $guestId) {
					if(!(db_rv_res_item_guest_insert($guestId, $groupId) === false)) {
						$addedGuest = true;
						$guestName = getContactFullName($guestId,false);
						ammendReservation($record,"Guests (Insert: $guestName [".$guestId."])");						
					}
				}
				if(!$addedGuest) {
					db_rv_res_item_group_delete($groupId);
				}
			}
		}
	}
	if(isset($_POST['groupAllList']) && $_POST['groupAllList'] != "") {
		$guestArray = explode(":",$_POST['groupAllList']);
		$itemArray = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$record'",3);
		foreach($itemArray as $item) {
			$groupId = db_rv_res_item_group_insert($item);
			if(!($groupId === false)) {
				$addedGuest = false;
				foreach($guestArray as $guestId) {
					if(!(db_rv_res_item_guest_insert($guestId, $groupId) === false)) {
						$addedGuest = true;
						$guestName = getContactFullName($guestId,false);
						ammendReservation($record,"Guests (Insert: $guestName [".$guestId."])");								
					}
				}
				if(!$addedGuest) {
					db_rv_res_item_group_delete($groupId);
				}
			}
		}
	}
	if(isset($_POST['removeGroupId']) && $_POST['removeGroupId'] != ""
		&& isset($_POST['removeResItemId']) && $_POST['removeResItemId'] != ""
	) {
		db_rv_res_item_guest_delete_by_group($_POST['removeGroupId']);
		db_rv_res_item_group_delete($_POST['removeGroupId']);

		ammendReservation($record,"Guests (Remove group [".$_POST['removeGroupId']."])");			
	}
	if(isset($_POST['removeGroupId']) && $_POST['removeGroupId'] != ""
		&& isset($_POST['removeGuestId']) && $_POST['removeGuestId'] != ""
	) {
		if($_POST['removeGroupGuestAll'] != "") {
			db_rv_res_item_guest_delete_by_guest($_POST['removeGuestId'], $record);
			if($_POST['removeGroupGuestRes'] != "") {
				db_rv_reservation_guest_delete_by_all($record, $_POST['removeGuestId']);
				if($_POST['removeGroupGuestContact'] != "") {
					$resCheck = $GLOBALS['lDB']->get("
						SELECT
							COUNT(rv_reservation_id)
						FROM
							rv_reservation_guest
						WHERE
							pr_guest_id = '$_POST[removeGuestId]'
					",4);
					$linkCheck = $GLOBALS['lDB']->get("
						SELECT
							COUNT(pr_link_from)
						FROM
							pr_link
						WHERE
							(
								pr_link_to = '$_POST[removeGuestId]'
								AND rf_link_type_id <> 'RS3'
								AND rf_link_type_id <> 'RS4'
							) OR (
								pr_link_from = '$_POST[removeGuestId]'
								AND rf_link_type_id <> 'RS3'
								AND rf_link_type_id <> 'RS4'
							)
					",4);
					if($resCheck > 0) {
						db_pr_guest_set_inactive($_POST['removeGuestId']);
						if($linkCheck == 0) {
							$GLOBALS['lDB']->put("
								UPDATE pr_guest SET
									pr_guest_inactive_yn = '1'
								WHERE
									pr_guest_id = '$_POST[removeGuestId]'
							");
						}
					} else {
						db_pr_guest_delete($_POST['removeGuestId']);
						if(canDeleteContact($_POST['removeGuestId'])) {
							cleanContact($_POST['removeGuestId']);
							$GLOBALS['lDB']->put("DELETE FROM pr_persona WHERE pr_persona_ix = '$_POST[removeGuestId]'");
						}
					}
				}
			}
		} else {
			db_rv_res_item_guest_delete_by_group_guest($_POST['removeGuestId'], $_POST['removeGroupId']);
		}
		
		$guestName = getContactFullName($_POST['removeGuestId'],false);
		ammendReservation($record,"Guests (Remove: $guestName [".$_POST['removeGuestId']."])");			
	}
	if(isset($_POST['removeGuestId']) && $_POST['removeGuestId'] != ""
		&& isset($_POST['removeGroupId']) && $_POST['removeGroupId'] == ""
	) {
		db_rv_res_item_guest_delete_by_guest($_POST['removeGuestId'], $record);
		db_rv_reservation_guest_delete_by_all($record, $_POST['removeGuestId']);
		
		$guestName = getContactFullName($_POST['removeGuestId'],false);
		ammendReservation($record,"Guests (Remove: $guestName [".$_POST['removeGuestId']."])");		
	}
	if(isset($_POST['setRoomId']) && $_POST['setRoomId'] != "") {
		$args = explode("+",$_POST['setRoomId']);
		$groupId = $args[0];
		$roomList = explode(":",$args[1]);
		$resItemId = $args[2];
		// check if this room is allocated within this resItem....
		foreach($roomList as $roomId) {
			$checkAlloc = $GLOBALS['lDB']->get("
				SELECT
					COUNT(*)
				FROM
					rv_res_item_group
					INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
				WHERE
					rv_res_item_group.rv_reservation_item_id = '$resItemId'
					AND rv_res_item_group.ac_accomm_room_id = '$roomId'
					AND rv_res_item_group.rv_res_item_group_ix != '$groupId'
			",4);
			if($checkAlloc < 1) {
				$requestYN = $args[3];
				$requestReason = $_POST['requestReason'];
				if($roomId == "0" || trim($roomId) == "") {
					$requestYN = "0";
					$requestReason = "";
				}

				if($groupId == '') {
					$groupId = db_rv_res_item_group_insert($resItemId);
				}
				db_rv_res_item_group_set_room($groupId, $roomId, $requestYN, $requestReason);
			}
			$groupId = '';
			
			if ($roomId == '0'){
				ammendReservation($record,"Rooming (Deallocate)");	
			} else {
				ammendReservation($record,"Rooming (Allocate [".getRoomDesc($roomId)."])");	
			}
		}
		
	}
	if(isset($_POST['checkInGroupId']) && $_POST['checkInGroupId'] != "") {
		db_rv_res_item_group_set_status($_POST['checkInGroupId'],5);
	}
	if(isset($_POST['checkOutGroupId']) && $_POST['checkOutGroupId'] != "") {
		db_rv_res_item_group_set_status($_POST['checkOutGroupId'],8);
	}
	if($_POST['copyGroupId'] != "" && ($_POST['pasteGroupId'] != "" || $_POST['pasteResItemId'] != "")) {
		$fromGroupId = $_POST['copyGroupId'];
		$toGroupId = $_POST['pasteGroupId'];
		$toResItemId = $_POST['pasteResItemId'];
		if($toGroupId == "") {
			$toGroupId = db_rv_res_item_group_insert($toResItemId);
		} else {
			db_rv_res_item_guest_delete_by_group($toGroupId);
		}
		$guestList = $GLOBALS['lDB']->get("SELECT pr_guest_id FROM rv_res_item_guest WHERE rv_res_item_group_id = '$fromGroupId'",3);
		foreach($guestList as $item) {
			db_rv_res_item_guest_insert($item, $toGroupId);
		}

		$guestName = getContactFullName($toGroupId,false);
		ammendReservation($record,"Guests (Insert: $guestName [".$toGroupId."])");			
		
	}
	$GLOBALS['lDB']->put("UPDATE rv_reservation SET rv_date_changed = '".date('Y-m-d')."' WHERE rv_reservation_ix = '$record'");
}

$resStatus = $GLOBALS['lDB']->get("SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);

$hideRoom = "visibility: hidden;";
$hideCheckIn = "visibility: hidden;";
$disableRoom = "disabled";
$disableCheckIn = "disabled";
if($resStatus == "20" || $resStatus == "30") { // Confirmed or provisional
	$hideRoom = "";
	$disableRoom = "";
}

if($resStatus == "30") { //confirmed
	$hideCheckIn = "";
}

if($view == "1") {
	$guestRowHTML = Join("", file(__DIR__ . "/../../../public/html/reservation_rooming_guest_row.htm"));
	$guestArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_ix,
			rf_title.rf_title_desc,
			rf_name_suffix.rf_suffix_desc,
			pr_guest.pr_guest_note,
			pr_guest.pr_guest_memo,
			pr_primary.pr_name_last as primary_name_last,
			pr_primary.pr_name_first as primary_name_first,
			pr_primary_title.rf_title_desc as primary_title
		FROM
			rv_reservation_item
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_guest.pr_guest_id
			LEFT JOIN pr_link ON pr_link.pr_link_from = pr_guest.pr_guest_id AND pr_link.rf_link_type_id = 'RS3'
			LEFT JOIN pr_persona AS pr_primary ON pr_primary.pr_persona_ix = pr_link.pr_link_to
			LEFT JOIN rf_title as pr_primary_title ON pr_primary_title.rf_title_ix = pr_primary.pr_title_id
			LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
			LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
	",2);

	$guestRows = "";
	$GLOBALS['temp']['guestCount'] = sizeof($guestArray)+3;
	foreach($guestArray as $key=>$item) {
		$guestName = $item['pr_name_last'];
		if($item['rf_suffix_desc'] != "") {
			$guestName .= " $item[rf_suffix_desc]";
		}
		if($item['pr_name_first'] != "") {
			$guestName .= ", $item[pr_name_first]";
		}
		if($item['rf_title_desc'] != "") {
			$guestName .= " $item[rf_title_desc]";
		}
		if(strlen($guestName) > 17) {
			$guestName = substr($guestName,0,17) . "...";
		}
		$primaryName = $item['primary_name_last'];
		if($item['primary_name_first'] != "" && $item['primary_name_first'] != "0") {
			$primaryName .= ", $item[primary_name_first]";
		}
		if($item['primary_title'] != "" && $item['primary_title'] != "0") {
			$primaryName .= " $item[primary_title]";
		}
		if(strlen($primaryName) > 14) {
			$primaryName = substr($primaryName,0,14) . "...";
		}
		$note = "disabled";
		if(trim($item['pr_guest_note']) != "") {
			$note = "onmouseover=\"overlib('".t_encodeOverlib($item['pr_guest_note'])."',LEFT,WIDTH,150);\" onmouseout=\"nd();\"";
		}
		$memo = "disabled";
		if(trim($item['pr_guest_memo']) != "") {
			$memo = "onmouseover=\"overlib('".t_encodeOverlib($item['pr_guest_memo'])."',LEFT,WIDTH,150);\" onmouseout=\"nd();\"";
		}
		if($_SESSION['userStatusId'] < 2) {
			$memo = "style=\"visibility:hidden\"";
		}

		$id = $item['pr_persona_ix'];
		$result = array(
			'guestName'=>$guestName,
			'primaryName'=>$primaryName,
			'id'=>$id,
			'note'=>$note,
			'memo'=>$memo,
			'disableDisplay'=>$disableDisplay
		);
		$guestRows .= showpage($result,$guestRowHTML);
		$guestArray[$key]['allowGroupAll'] = true;
	}
	$GLOBALS['temp']['guestRows'] = $guestRows;

	$resItemArray = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.ac_accomm_type_id,      
			ac_accomm_type.ac_accomm_desc,
			pr_persona.pr_name_last,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_accomm_count,
			COUNT(rv_res_item_group.rv_res_item_group_ix) as accommUsed
		FROM
			rv_reservation_item
			LEFT JOIN rv_res_item_group ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN pr_persona ON rv_reservation_item.pr_business_id = pr_persona.pr_persona_ix
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
		GROUP BY
			rv_reservation_item.rv_reservation_item_ix
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart
	",2);

	$resItemHTML = Join("", file(__DIR__ . "/../../../public/html/reservation_rooming_item_header.htm"));
	$resItems = "";

	foreach($resItemArray as $item) {
		$compArray = $GLOBALS['lDB']->get("
			SELECT
				rt_component_desc
			FROM
				rv_res_item_comp
				INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			WHERE
				rv_res_item_comp.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
				AND rv_res_item_comp.rv_item_comp_option_yn = '1'
		",3);
		$groupCount = $GLOBALS['lDB']->get("
			SELECT
				COUNT(rv_res_item_group_id)
			FROM
				rv_res_item_group
			WHERE
				rv_reservation_item_id = '$item[rv_reservation_item_ix]'
		",4);
		$groupCount = "$item[accommUsed] / $item[rv_item_accomm_count]";
		$item['accommAvail'] = $item['rv_item_accomm_count'] - $item['accommUsed'];

		$result = array(
			'dateArrive'=>chng_date($item["rv_item_date_arrive"],"-"),
			'dateDepart'=>chng_date($item["rv_item_date_depart"],"-"),
			'accommType'=>t_encodeHTMLField($item['ac_accomm_desc']),
			'property'=>t_encodeHTMLField($item['pr_name_last']),
			'adultCount'=>$item['rv_item_adult_count'],
			'childCount'=>$item['rv_item_child_count'],
			'optionals'=>join(", ", $compArray),
			'groupCount'=>$groupCount,
			'accommAvail'=>"",
			'id'=>$item['rv_reservation_item_ix']
		);
		$resItems .= showpage($result,$resItemHTML);
	}
	$GLOBALS['temp']['itemHeaders'] = $resItems;
	$groupInfo = array();
	srand(999);
	$baseGroup = array();
	$first = true;
	$lastCol = "";
	foreach($resItemArray as $item) {
		$groupArray = $GLOBALS['lDB']->get("SELECT rv_res_item_group_ix FROM rv_res_item_group WHERE rv_reservation_item_id = '$item[rv_reservation_item_ix]'",3);
		foreach($groupArray as $groupItem) {
			$r = rand(100,255);
			$g = rand(100,255);
			$b = rand(100,255);
			$col = sprintf("%X%X%X",$r,$g,$b);
			$groupInfo[$item['rv_reservation_item_ix']."_".$groupItem]['colour'] = $col;
		}
		if($first) {
			foreach($groupArray as $groupItem) {
				$r = rand(100,255);
				$g = rand(100,255);
				$b = rand(100,255);
				$col = sprintf("%X%X%X",$r,$g,$b);
				$guestList = $GLOBALS['lDB']->get("
					SELECT
						pr_guest_id
					FROM
						rv_res_item_guest
						INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_guest_id
					WHERE
						rv_res_item_group_id = '$groupItem'
					ORDER BY
						pr_persona.pr_name_last, pr_persona.pr_name_first, pr_persona.pr_persona_ix
				",4);
				$baseItem = array('founder'=>$guestList,'colour'=>$col);
				array_push($baseGroup,$baseItem);
			}
		}
		$first = false;
	}

	$details = "";
	$detailSpace = "";
	foreach($resItemArray as $item) {
		$details .= "
			<td>
				<table cellspacing=\"0\" cellpadding=\"0\" width=\"142\">
		";

		foreach($guestArray as $guestKey=>$guestItem) {
			$checkGroup = $GLOBALS['lDB']->get("
				SELECT
					COUNT(rv_res_item_guest_id)
				FROM
					rv_res_item_guest
				WHERE
					rv_reservation_item_id = '$item[rv_reservation_item_ix]'
					AND pr_guest_id = '$guestItem[pr_persona_ix]'
			",4);
			if($checkGroup > 0) {
				$groupId = $GLOBALS['lDB']->get("
					SELECT
						rv_res_item_group_id
					FROM
						rv_res_item_guest
					WHERE
						rv_reservation_item_id = '$item[rv_reservation_item_ix]'
						AND pr_guest_id = '$guestItem[pr_persona_ix]'
				",4);
				$roomId = $GLOBALS['lDB']->get("
					SELECT
						ac_accomm_room_id
					FROM
						rv_res_item_group
					WHERE
						rv_res_item_group.rv_res_item_group_ix = '$groupId'
				",4);
				$accommTypeId = $GLOBALS['lDB']->get("
					SELECT
						ac_accomm_room.ac_accomm_type_id
					FROM
						rv_res_item_group
						INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
					WHERE
						rv_res_item_group.rv_res_item_group_ix = '$groupId'
				",4);
				$groupStatus = $GLOBALS['lDB']->get("
					SELECT
						rv_grp_status_ind,
						rv_grp_status_time
					FROM
						rv_res_item_group
						INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
					WHERE
						rv_res_item_group.rv_res_item_group_ix = '$groupId'
				",1);
				$roomName = "Room";
				$roomImage = "bRooms";
				if($roomId != "0" && trim($roomId) != "") {
					$roomName = $GLOBALS['lDB']->get("SELECT ac_desc FROM ac_accomm_room WHERE ac_accomm_room_ix = '$roomId'",4);
					if($item['ac_accomm_type_id'] != $accommTypeId) {
						$roomName .= "/U";
					}
					$temp = explode(" ",$groupStatus['rv_grp_status_time']);
					$startDate = $temp[0];
					if($item['rv_item_date_depart'] != $startDate && $groupStatus['rv_grp_status_ind'] == "8") {
						$roomName .= "/E";
					}
					$requestYN = $GLOBALS['lDB']->get("
						SELECT
							rv_room_requested_yn
						FROM
							rv_res_item_group
						WHERE
							rv_res_item_group.rv_res_item_group_ix = '$groupId'
					",4);
					if($requestYN == "1") {
						$roomImage = "bRoomLock";
					}
				}
				$checkInYN = $GLOBALS['lDB']->get("
					SELECT
						rv_guest_checked_in_yn
					FROM
						rv_res_item_guest
					WHERE
						rv_res_item_group_id = '$groupId'
						AND pr_guest_id = '$guestItem[pr_persona_ix]'
				",4);
				if($checkInYN == "1") {
					$checkInAction = "onclick=\"checkOutGuest('$groupId', '$guestItem[pr_persona_ix]');\"";
					$checkInClass = "buttonGrn";
				} else {
					$checkInAction = "onclick=\"checkInGuest('$groupId', '$guestItem[pr_persona_ix]');\"";
					$checkInClass = "buttonRed";
				}
				$guestList = $GLOBALS['lDB']->get("SELECT pr_guest_id FROM rv_res_item_guest WHERE rv_res_item_group_id = '$groupId'",3);
				$col = $groupInfo[$item['rv_reservation_item_ix']."_".$groupId]['colour'];
				$foundCol = false;
				foreach($guestList as $guestCheck) {
					foreach($baseGroup as $baseItem) {
						if($baseItem['founder'] == $guestCheck) {
							$col = $baseItem['colour'];
							$foundCol = true;
						}
					}
				}
				if(!$foundCol) {
					array_push($baseGroup,array('founder'=>$guestItem['pr_persona_ix'],'colour'=>$col));
				}
				$details .= "
					<tr>
						<td class=\"grp\" style=\"background-color: #".$col.";\" height=\"20\" align=\"right\">
							<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
							<tr>
								<td align=\"left\">
									<input type=\"button\" style=\"width:20; height:15; background-position: center ;\" class=\"button bRemLink\" onclick=\"removeGroup('$groupId','$item[rv_reservation_item_ix]');\" $disableDisplay>&nbsp;
								</td>
								<td>
									<input type=\"button\" style=\"width:70px;height:15;$hideRoom\" class=\"button $roomImage\" value=\"   $roomName\" onclick=\"selectRoom('$groupId','$roomId');\" $disableDisplay>
								</td>
								<td align=\"right\">
									<input type=\"button\" style=\"width:10; height:15; background-position: center ; $hideCheckIn\" class=\"$checkInClass\" $checkInAction $disableDisplay>&nbsp;
								</td>
							</tr>
							</table>
						</td>
					</tr>
				";
				$guestArray[$guestKey]['allowGroupAll'] = false;
			} else {
				$details .= "
					<tr>
						<td height=\"20\" class=\"br\">&nbsp;</td>
					</tr>
				";
			}
		}
		$details .= "
				</table>
			</td>
		";
		$detailSpace .= "<td class=\"br\" height=\"20\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>";
	}
	if($details == "" || sizeof($guestArray) == 0) {
		$details = "<td class=\"txti\" align=\"center\">No guest rooming defined</td>";
	}
	$GLOBALS['temp']['details'] = $details;
	$GLOBALS['temp']['detailSpace'] = $detailSpace;

	$allowGroupAllArray = array();
	foreach($guestArray as $item) {
		if($item['allowGroupAll']) {
			array_push($allowGroupAllArray,$item['pr_persona_ix']);
		}
	}
	$GLOBALS['temp']['allowGroupAll'] = join(":",$allowGroupAllArray);
} else {
	$maxSize = $GLOBALS['lDB']->get("
		SELECT
			max(rv_reservation_item.rv_item_adult_count+rv_reservation_item.rv_item_child_count)
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
	",4);
	$maxAccommCount = $GLOBALS['lDB']->get("
		SELECT
			max(rv_item_accomm_count)
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
	",4);

	$resItemArray = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.ac_accomm_type_id,
			ac_accomm_type.ac_accomm_desc,
			pr_persona.pr_name_last,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_accomm_count,
			COUNT(rv_res_item_group.rv_res_item_group_ix) as accommUsed
		FROM
			rv_reservation_item
			LEFT JOIN rv_res_item_group ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN ac_accomm_type ON rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			INNER JOIN pr_persona ON rv_reservation_item.pr_business_id = pr_persona.pr_persona_ix
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
		GROUP BY
			rv_reservation_item.rv_reservation_item_ix
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			pr_persona.pr_persona_ix
	",2);

	$resItemHTML = Join("", file(__DIR__ . "/../../../public/html/reservation_rooming_rooms_header.htm"));
	$resItemRowHTML = Join("", file(__DIR__ . "/../../../public/html/reservation_rooming_rooms_row.htm"));
	$resItemRowFiller = "
		<td class=\"outLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
	";
	$resItems = "";

	$firstLookup = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_group.rv_res_item_group_ix as id
		FROM
			rv_res_item_group
		WHERE
			rv_reservation_item_id = '".$resItemArray[0]['rv_reservation_item_ix']."'
	",2);
	$primaryList = array_fill(0,$maxAccommCount,"");
	$curr = 0;
	foreach($firstLookup as $item) {
		$guestId = $GLOBALS['lDB']->get("
			SELECT
				pr_guest.pr_guest_id
			FROM
				rv_res_item_guest
				INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			WHERE
				rv_res_item_guest.rv_res_item_group_id = '$item[id]'
			ORDER BY
				pr_guest_primary_yn DESC,
				pr_name_last,
				pr_name_first
		",4);
		$primaryList[$curr] = $guestId;
		$curr++;
	}

	$resCount = 0;
	$resItemRows = "";
	foreach($resItemArray as $item) {
		$compArray = $GLOBALS['lDB']->get("
			SELECT
				rt_component_desc
			FROM
				rv_res_item_comp
				INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			WHERE
				rv_res_item_comp.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
				AND rv_res_item_comp.rv_item_comp_option_yn = '1'
		",3);
		$groupCount = $GLOBALS['lDB']->get("
			SELECT
				count(rv_res_item_group_id)
			FROM
				rv_res_item_group
			WHERE
				rv_reservation_item_id = '$item[rv_reservation_item_ix]'
		",4);
		$groupCount = "$item[accommUsed] / $item[rv_item_accomm_count]";
		$item['accommAvail'] = $item['rv_item_accomm_count'] - $item['accommUsed'];

		// Group lookup start
		$groupLookup = $GLOBALS['lDB']->get("
			SELECT
				rv_res_item_group.rv_res_item_group_ix as id,
				ac_accomm_room_id,
				rv_room_requested_yn,
				rv_room_request_reason,
				rv_grp_status_ind,
				rv_grp_status_time
			FROM
				rv_res_item_group
			WHERE
				rv_reservation_item_id = '$item[rv_reservation_item_ix]'
		",2);
		foreach($groupLookup as $groupKey=>$groupItem) {
			$groupLookup[$groupKey]['guestList'] = $GLOBALS['lDB']->get("
				SELECT
					pr_guest_id
				FROM
					rv_res_item_guest
				WHERE
					rv_res_item_group_id = '$groupItem[id]'
			",3);
			$groupLookup[$groupKey]['used'] = false;

			$groupLookup[$groupKey]['groupStatusList'] = $GLOBALS['lDB']->get("
				SELECT
					rv_res_item_grp_status.rv_grp_status_ind,
					rv_res_item_grp_status.rv_grp_status_time,
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart
				FROM
					rv_res_item_grp_status
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_grp_status.rv_res_item_group_id
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				WHERE
					rv_res_item_grp_status.rv_res_item_group_id = '$groupItem[id]'
				ORDER BY
					rv_grp_status_time
			",2);
		}

		$groupOutput = $primaryList;
		$groupOrder = array();
		$groupFinal = array_fill(0,$maxAccommCount,"");
		for($count = 0; $count < sizeof($groupOutput); $count++) {
			foreach($groupLookup as $groupLookKey=>$groupLookItem) {
				if(in_array($groupOutput[$count],$groupLookItem['guestList']) && !$groupLookItem['used']) {
					$groupFinal[$count] = $groupLookItem;
					$groupLookup[$groupLookKey]['used'] = true;
					break;
				}
			}
		}
		for($count = 0; $count < sizeof($groupFinal); $count++) {
			if($groupFinal[$count] == "") {
				foreach($groupLookup as $groupLookKey=>$groupLookItem) {
					if(!$groupLookItem['used']) {
						$groupFinal[$count] = $groupLookItem;
						$groupLookup[$groupLookKey]['used'] = true;
						break;
					}
				}
			}
		}

		// Group lookup end
		// Group rows...

		// This code prevents cases where an item with less rooms shares a guest with an item with more 
		// rooms (and the item with more rooms puts the guests lower down in the display).
		$newGroupFinal = array();
		foreach($groupFinal as $groupFinalItem) {
			if($groupFinalItem != "") {
				array_push($newGroupFinal,$groupFinalItem);
			}
		}
		$groupFinal = $newGroupFinal;
		unset($newGroupFinal);

		$rows = "";
		$itemSize = $item['rv_item_adult_count'] + $item['rv_item_child_count'];
		$rowClass = "grp1";
		for($count=0; $count < $item['rv_item_accomm_count']; $count++) {
			$rowColour = $colours[$resCount % $colX][$count % $colY];
			if(!isset($groupFinal[$count])) {
				$groupFinal[$count] = array(
					'id'=>"",
					'ac_accomm_room_id'=>"",
					'guestList'=>array(),
					'rv_room_requested_yn'=>"",
					'rv_grp_status_ind'=>"",
					'groupStatusList'=>array()
				);
			}
			$groupId = $groupFinal[$count]['id'];
			$countExtra = $GLOBALS['lDB']->get("
				SELECT
					count(rv_extra_id)
				FROM
					rv_extra
				WHERE
					rv_extra.rv_res_item_group_id = '$groupId'
					AND rv_extra.rv_reservation_id = '$record'
					AND rv_extra.rv_extra_void_ind = '0'
			",4);

			$roomId = $groupFinal[$count]['ac_accomm_room_id'];
			if(is_array($groupFinal[$count]['guestList']) && sizeof($groupFinal[$count]['guestList']) > 0) {
				$name = getReverseName($groupFinal[$count]['guestList'][0]);
				if(strlen($name) > 15) {
					$name = substr($name,0,15) . "...";
				}
				$guestImage = "bRemCont";
				$guestClick = "removeGroupGuest('$groupId', '".$groupFinal[$count]['guestList'][0]."')";
			} else {
				$name = "&nbsp;";
				$guestImage = "bAgent";
				if($groupId != "") {
					$guestClick = "importContact('$groupId');";
				} else {
					$guestClick = "importContact(false,'$item[rv_reservation_item_ix]');";
				}
			}
			$roomName = $GLOBALS['lDB']->get("
				SELECT
					ac_desc
				FROM
					ac_accomm_room
				WHERE
					ac_accomm_room.ac_accomm_room_ix = '$roomId'
			",4);
			if($roomName == "" || $roomName == "0") {
				$roomName = "Room";
			} else {
				$accommTypeId = $GLOBALS['lDB']->get("
					SELECT
						ac_accomm_room.ac_accomm_type_id
					FROM
						rv_res_item_group
						INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
					WHERE
						rv_res_item_group.rv_res_item_group_ix = '$groupId'
				",4);
				$groupStatus = $GLOBALS['lDB']->get("
					SELECT
						rv_grp_status_ind,
						rv_grp_status_time
					FROM
						rv_res_item_group
						INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
					WHERE
						rv_res_item_group.rv_res_item_group_ix = '$groupId'
				",1);
				if($item['ac_accomm_type_id'] != $accommTypeId) {
					$roomName .= "/U";
				}
				$temp = explode(" ",$groupStatus['rv_grp_status_time']);
				$startDate = $temp[0];
				if($item['rv_item_date_depart'] != $startDate && $groupStatus['rv_grp_status_ind'] == "8") {
					$roomName .= "/E";
				}
			}
			$roomImage = "bRooms";
			$roomOverlib = "";
			if($groupFinal[$count]['rv_room_requested_yn'] == "1") {
				$roomImage = "bRoomLock";
				$roomOverlib = " onmouseover=\"overlib('".t_encodeOverlib($groupFinal[$count]['rv_room_request_reason'])."');\" onmouseout=\"nd();\" ";
			}
			$copyOverlib = "";
			if($_POST['copyGroupId'] == "") {
				if($groupId != "" && is_array($groupFinal[$count]['guestList']) && sizeof($groupFinal[$count]['guestList']) > 0) {
					$showCopy = "";
					$copyClass = "button bCopy";
					$copyLabel = "Copy";
					$copyClick = "copyGroup('$groupId');";
					$copyDisable = "";
					$copyOverlib = " onmouseover=\"overlib('When Copy is activated (by clicking it) a red border appears around the icon and Paste icons display on groups where the naming list can be applied. To apply a copy of the naming list, click the respective Paste buttons. To end the copy function, click the red-copy button again.');\" onmouseout=\"nd();\" ";
				} else {
					$showCopy = "";
					$copyClass = "button";
					$copyLabel = "";
					$copyClick = "";
					$copyDisable = "disabled";
				}
			} else {
				if($_POST['copyGroupId'] == $groupId) {
					$showCopy = "border-color:red;";
					$copyClass = "buttonIn bCopy";
					$copyLabel = "Copy";
					$copyClick = "resetCopy();";
					$copyDisable = "";
					$copyOverlib = " onmouseover=\"overlib('When Copy is activated (by clicking it) a red border appears around the icon and Paste icons display on groups where the naming list can be applied. To apply a copy of the naming list, click the respective Paste buttons. To end the copy function, click the red-copy button again.');\" onmouseout=\"nd();\" ";
				} else {
					$copyCount = $GLOBALS['lDB']->get("
						SELECT
							COUNT(rv_res_item_guest_id)
						FROM
							rv_res_item_guest
						WHERE
							rv_res_item_group_id = '$_POST[copyGroupId]'
					",4);
					$copyResItemId = $GLOBALS['lDB']->get("
						SELECT
							rv_reservation_item_id
						FROM
							rv_res_item_group
						WHERE
							rv_res_item_group_ix = '$_POST[copyGroupId]'
					",4);
					$copyGuestList = "'" . join("','",$GLOBALS['lDB']->get("
						SELECT
							pr_guest_id
						FROM
							rv_res_item_guest
						WHERE
							rv_res_item_group_id = '$_POST[copyGroupId]'
					",3)) . "'";
					$copyResItemCheck = $GLOBALS['lDB']->get("
						SELECT
							COUNT(pr_guest_id)
						FROM
							rv_res_item_group
							INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
						WHERE
							rv_res_item_group.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
							AND pr_guest_id IN ($copyGuestList)
					",4);
					if($copyCount <= $itemSize && $copyResItemId != $item['rv_reservation_item_ix'] && $copyResItemCheck == 0) {
						$showCopy = "";
						$copyClass = "button bPaste";
						$copyLabel = "Paste";
						$copyClick = "pasteGroup('$groupId','$item[rv_reservation_item_ix]');";
						$copyDisable = "";
					} else {
						$showCopy = "";
						$copyClass = "button";
						$copyLabel = "";
						$copyClick = "";
						$copyDisable = "disabled";
					}
				}
			}
			if(sizeof($resItemArray) == 1) {
				$showCopy = "";
				$copyClass = "button";
				$copyLabel = "";
				$copyClick = "";
				$copyDisable = "disabled";
			}
			if($groupFinal[$count]['rv_grp_status_ind'] <= 2) {
				$statusClass = "bRoomNone";
				$statusClick = "onclick=\"checkInGroup('$groupId', '".$groupFinal[$count]['rv_grp_status_ind']."');\"";
				$statusHover = "";
			}
			$groupStatusOverlib = "";
			if($groupFinal[$count]['rv_grp_status_ind'] == 5) {
				$groupStatusOverlib = "<b>Checked in</b>\n".$groupFinal[$count]['rv_grp_status_time'];
			} elseif($groupFinal[$count]['rv_grp_status_ind'] == 8) {
				$groupStatusOverlib = "<b>Checked out</b>\n".$groupFinal[$count]['rv_grp_status_time'];
			}
			if(sizeof($groupFinal[$count]['groupStatusList']) > 0) {
				$groupStatusOverlib .= "\n-------------------------------------------\n";
				if(is_array($groupFinal[$count]['groupStatusList'])) {
					foreach($groupFinal[$count]['groupStatusList'] as $statusItem) {
						if($statusItem['rv_grp_status_ind'] == "5") {
							$groupStatusOverlib .= "Checked in: $statusItem[rv_grp_status_time]\n";
						} elseif($statusItem['rv_grp_status_ind'] == "8") {
							if(substr($statusItem['rv_grp_status_time'],0,10) < $statusItem['rv_item_date_depart']) {
								$groupStatusOverlib .= "Checked out (<b>early</b>): $statusItem[rv_grp_status_time]\n";
							} else {
								$groupStatusOverlib .= "Checked out: $statusItem[rv_grp_status_time]\n";
							}
						}
					}
				}
			}
			$groupStatusOverlib = t_encodeOverlib($groupStatusOverlib);
			if($groupFinal[$count]['rv_grp_status_ind'] == 5) {
				$statusClass = "bRoomIn";
				$statusClick = "onclick=\"checkOutGroup('$groupId', '".$groupFinal[$count]['rv_grp_status_ind']."');\"";
				$statusHover = " onmouseout=\"nd();\" onmouseover=\"overlib('$groupStatusOverlib')\" ";
			}
			if($groupFinal[$count]['rv_grp_status_ind'] == 8) {
				$statusClass = "bRoomOut";
				$statusClick = "onclick=\"checkInGroup('$groupId', '".$groupFinal[$count]['rv_grp_status_ind']."');\"";
				$statusHover = " onmouseout=\"nd();\" onmouseover=\"overlib('$groupStatusOverlib')\" ";
			}
			if($disableCheckIn == "disabled") {
				$statusClick = "";
			}
			$rows .= "
				<tr class=\"\" style=\"background-color:$rowColour;\">
					<td class=\"bb \" align=\"left\"><input type=\"button\" style=\"width:20;height:20;$showCopy\" class=\"$copyClass\" value=\"\" onclick=\"$copyClick\" $copyDisable $disableDisplay $copyOverlib></td>
					<td class=\"bb imglink\" align=\"center\" colspan=\"3\" $roomOverlib><span><input type=\"button\" class=\"button $roomImage\" value=\"      $roomName\" onclick=\"selectRoom('$groupId','$roomId','$item[rv_reservation_item_ix]');\" style=\"width:80;height:20; text-align: left; margin: 1px;\" $disableDisplay $disableRoom></td>
					<td class=\"bb br\" align=\"right\"><input type=\"button\" style=\"width:20;height:20;\" class=\"button $statusClass\" value=\"  \" $statusClick $disableDisplay $statusHover></td>
				</tr>
			";
			for($count2=0; $count2 < $maxSize; $count2++) {
				if($count2 < $itemSize) {
					if($groupFinal[$count] != "" && sizeof($groupFinal[$count]['guestList']) > $count2) {
						$name = getReverseName($groupFinal[$count]['guestList'][$count2]);
						$guestId = $groupFinal[$count]['guestList'][$count2];
						$countGuest = $GLOBALS['lDB']->get("
							SELECT
								COUNT(rv_res_item_guest_id)
							FROM
								rv_res_item_guest
								INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_guest.rv_reservation_item_id
								INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
							WHERE
								rv_reservation.rv_reservation_ix = '$record'
								AND pr_guest_id = '".$groupFinal[$count]['guestList'][$count2]."'
						",4);
						if(strlen($name) > 35) {
							$name = substr($name,0,35) . "...";
						}
						$guestImage = "bRemCont";
						if($countExtra > 0 && sizeof($groupFinal[$count]['guestList']) == 1) {
							$guestClick = "openMessage('You may not remove this guest as there are extras allocated to this group');";
						} else {
							$guestClick = "removeGroupGuest('$groupId', '".$groupFinal[$count]['guestList'][$count2]."')";
						}
						$editGuest = "onclick=\"editGuest('$guestId','$record');\"";
					} else {
						$name = "&nbsp;";
						$guestImage = "bAgent";
						if($groupId != "") {
							$guestClick = "importContact('$groupId');";
						} else {
							$guestClick = "importContact(false,'$item[rv_reservation_item_ix]');";
						}
						$editGuest = "";
					}
					$rows .= "
						<tr class=\"\" style=\"background-color:$rowColour;\">
							<td class=\"bb\" width=\"10%\" height=\"20\"><input type=\"button\" style=\"background-position:center;width:20;\" class=\"button $guestImage\" onclick=\"$guestClick\" $disableDisplay></td>
							<td class=\"bb br imgLink\" colspan=\"4\" onmouseover=\"if(this.onclick) {this.style.backgroundColor = '#CCFFCC'}\"  onmouseout=\"this.style.backgroundColor = ''\" $editGuest>&nbsp;$name</td>
						</tr>
					";
				} else {
					$rows .= "
						<tr>
							<td colspan=\"5\" height=\"20\" style=\"background:#FFFFFF;\" class=\"br bb\">
								<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">
							</td>
						</tr>
					";
				}
			}
		}

		$resItems .=
			str_replace("!dateArrive!",chng_date($item["rv_item_date_arrive"],"-"),
			str_replace("!dateDepart!",chng_date($item["rv_item_date_depart"],"-"),
			str_replace("!accommType!",t_encodeHTMLField($item['ac_accomm_desc']),
			str_replace("!property!",t_encodeHTMLField($item['pr_name_last']),
			str_replace("!adultCount!",$item['rv_item_adult_count'],
			str_replace("!childCount!",$item['rv_item_child_count'],
			str_replace("!optionals!",join(", ",$compArray),
			str_replace("!groupCount!",$groupCount,
			str_replace("!accommAvail!",$item['accommAvail'],
			str_replace("!id!",$item['rv_reservation_item_ix'],
			$resItemHTML))))))))));
		$resItemRows .= str_replace("!rows!",$rows,$resItemRowHTML);

		$resCount++;
	}
	if(sizeof($resItemArray) < 3) {
		$resItems .= $resItemRowFiller;
	}
	$GLOBALS['temp']['items'] = $resItemRows;
	$GLOBALS['temp']['headerRow'] = $resItems;
}

$newr = 216;
$edit = 216;
$view = 215;
$dele = 217;
$sedit = 217;
$snewr = 217;
// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == ACT_NEW || $action == ACT_EDIT) {
	$pgJOBS['save'] = "1";
}
if ($action == ACT_NEW || $action == ACT_DELETE || $record == null) {
	$pgJOBS['edit'] = "0";
}
if ($action == ACT_EDIT) {
	$pgJOBS['edit'] = $pgJOBS['view'];
    $canDeleteReservation = canDeleteReservation($record);
	if (checkJob($dele) && ($userStatusId > "1" || isMasterDB()) && $canDeleteReservation) {
		$pgJOBS['del'] = "1";
	}
}
$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"$pgJOBS[add]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"$pgJOBS[del]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">\n";

// Action switch
switch ($action) {
case (1) : // Display Record
	$GLOBALS['temp']['mode'] = "display";
	break;
case (2) : // Add Record
case (3) : // Edit Record
case (4) : // Delete Record
	$GLOBALS['temp']['mode'] = "edit";
	break;
}
