<?php

/**
 * Reservation rooming contact import popup
 */

if(!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/contact_import.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],8,"");

$record = $_SERVER['argv'][1];
$groupId = $_SERVER['argv'][2];
$resItemId = $_SERVER['argv'][3];
$filter = $_SERVER['argv'][4]; // default (0) = linked to reservation, 1 = Linked to agent, 2= All guests, 3=All contacts
$search = $_SERVER['argv'][5];
$page = $_SERVER['argv'][6];
$agentId = $_SERVER['argv'][7];
if($userStatusId < 2) {
   $agentId = $calAgentId;
}

if($filter == "") {
   $filter = "0";
}
if($search == "") {
   $search = "*";
}
if($page == "") {
   $page = 1;
}
if($agentId == "" || $agentId == "0") {
	$agentInfo = $GLOBALS['lDB']->get("
		SELECT
			rv_agent_id,
			pr_persona.pr_name_last
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
		WHERE
			rv_reservation_ix = '$record'
	",1);	
	if($agentInfo['pr_name_last'] != "") {
		$agentName = $agentInfo['pr_name_last'];
		$agentId = $agentInfo['rv_agent_id'];
	} else {
	   $agentName = "Direct";
	   $agentId = "0";
	}
} else {
   $agentName = $GLOBALS['lDB']->get("
      SELECT
         pr_name_last
      FROM
         pr_persona
      WHERE
         pr_persona_ix = '$agentId'
   ",4);
}
$GLOBALS['temp']['agentName'] = $agentName;
$GLOBALS['temp']['agentId'] = $agentId;

$search = urldecode($search);

$GLOBALS['temp']['lastsearch'] = $search;

$search = str_replace("*","%",$search);

$GLOBALS['temp']['record'] = $record;
$GLOBALS['temp']['groupId'] = $groupId;
$GLOBALS['temp']['resItemId'] = $resItemId;
$GLOBALS['temp']['filter'] = $filter;

$GLOBALS['temp']['linkResCheck'] = "";
$GLOBALS['temp']['linkAgentCheck'] = "";
$GLOBALS['temp']['allGuestCheck'] = "";
$GLOBALS['temp']['allContactCheck'] = "";

// Some pre-requisite work for the "All Contacts Linked to Reservation" option
if ($filter == "4"){
	$personaArray = array();

	$personaArray = $GLOBALS['lDB']->get("
		SELECT
			pr_persona_ix
		FROM
			rv_reservation
			INNER JOIN rv_reservation_guest ON rv_reservation_guest.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_guest.pr_guest_id
			LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
			LEFT JOIN pr_link ON pr_link.pr_link_from = rv_reservation_guest.pr_guest_id AND pr_link.rf_link_type_id = 'RS3'
		WHERE
			rv_reservation.rv_reservation_ix = '$record'
			AND (pr_guest.pr_guest_primary_yn = '1' OR pr_link.pr_link_ix IS NULL)
			AND pr_persona.pr_name_last LIKE '$search'
			AND pr_persona.pr_sys_code <= 6
			AND pr_persona. pr_persona_inactive_yn = 0
		ORDER BY
			pr_persona.pr_name_last, pr_persona.pr_name_first
	",3);

	$personaArray = array_merge($personaArray,$GLOBALS['lDB']->get("
		SELECT
			pr_persona_ix
		FROM
			rv_reservation_item
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
			LEFT JOIN pr_link ON pr_link.pr_link_from = rv_res_item_guest.pr_guest_id AND pr_link.rf_link_type_id = 'RS3'
		WHERE
			rv_reservation.rv_reservation_ix = '$record'
			AND (pr_guest.pr_guest_primary_yn = '1' OR pr_link.pr_link_ix IS NULL)
			AND pr_persona.pr_name_last LIKE '$search'
			AND pr_persona.pr_sys_code <= 6
			AND pr_persona. pr_persona_inactive_yn = 0
		ORDER BY
			pr_persona.pr_name_last, pr_persona.pr_name_first
	",3));

	$resRelated = $GLOBALS['lDB']->get("
		SELECT
			rv_corr_persona_id,
			rv_billing_persona_id,
			rv_agent_id,
			rv_consultant_id,
			rv_invoice_persona_id,
			rv_origin_agent_id
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_reservation_ix = '$record'
	",1);

	foreach($resRelated as $item){
		if(!empty($item)) {
			array_push($personaArray, $item);
		}
	}	

	$folioPersona = $GLOBALS['lDB']->get("
		SELECT
			fn_folio.fn_folio_to_id
		FROM
			fn_folio 
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
		WHERE
			rv_reservation.rv_reservation_ix = '$record'
	",1);
	if(is_array($folioPersona)) {
		$personaArray = array_merge($personaArray,$folioPersona);
	}

	$paymentPersona = $GLOBALS['lDB']->get("
		SELECT
			pr_persona_id
		FROM
			rv_payment 
			INNER JOIN rv_payment_item ON rv_payment_item.rv_payment_id = rv_payment.rv_payment_ix
			INNER JOIN rv_reservation ON rv_payment_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		WHERE
			rv_reservation.rv_reservation_ix = '$record'
	",1);
	if(is_array($paymentPersona)) {
		$personaArray = array_merge($personaArray,$paymentPersona);
	}
	
	$personaArray = array_unique($personaArray);
}



switch($filter) {
   case "1":
      $GLOBALS['temp']['linkAgentCheck'] = "checked";
      if($agentId != "0") {
         $sqlFrom = "
            FROM
				pr_link
				INNER JOIN pr_guest ON pr_guest.pr_guest_id = pr_link.pr_link_from
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_guest.pr_guest_id
				LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
				LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
				LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
            WHERE
				pr_link.rf_link_type_id = 'RS4'
				AND pr_guest.pr_guest_primary_yn = '1'
				AND pr_link.pr_link_to = '$agentId'
				AND pr_persona.pr_name_last LIKE '$search'
				AND NOT (pr_persona.pr_name_last = '' AND pr_persona.pr_name_first = '')			   
				AND pr_persona.pr_sys_code <= 6
				AND pr_persona. pr_persona_inactive_yn = 0
            ORDER BY
               pr_persona.pr_name_last, pr_persona.pr_name_first
         ";
      } else {
         $sqlFrom = "
            FROM
				pr_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_guest.pr_guest_id
				LEFT JOIN pr_link ON pr_link.pr_link_from = pr_guest.pr_guest_id
				  AND pr_link.rf_link_type_id = 'RS4'
				LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
				LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
				LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
            WHERE
				pr_link.pr_link_to IS NULL
				AND pr_persona.pr_name_last LIKE '$search'
				AND NOT (pr_persona.pr_name_last = '' AND pr_persona.pr_name_first = '')
				AND pr_persona.pr_sys_code <= 6
				AND pr_persona. pr_persona_inactive_yn = 0
            ORDER BY
               pr_persona.pr_name_last, pr_persona.pr_name_first
         ";
      }
      break;
   case "2":
      $GLOBALS['temp']['allGuestCheck'] = "checked";
      $agentWhere = "";
      if($userStatusId < 2) {
         $agentWhere = "AND agentLink.pr_link_to = '$calAgentId'";
      }

      $sqlFrom = "
         FROM
            pr_guest
            INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_guest.pr_guest_id
            LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
            LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
            LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
            LEFT JOIN pr_link ON pr_link.pr_link_from = pr_guest.pr_guest_id AND pr_link.rf_link_type_id = 'RS3'
            LEFT JOIN pr_link AS agentLink ON agentLink.pr_link_from = pr_guest.pr_guest_id AND agentLink.rf_link_type_id = 'RS4'
         WHERE
            (pr_guest.pr_guest_primary_yn = '1' OR pr_link.pr_link_ix IS NULL)

            AND pr_persona.pr_name_last LIKE '$search'
            AND NOT (pr_persona.pr_name_last = '' AND pr_persona.pr_name_first = '')
            $agentWhere
            AND pr_persona.pr_sys_code <= 6
		   AND pr_persona. pr_persona_inactive_yn = 0
         ORDER BY
            pr_persona.pr_name_last, pr_persona.pr_name_first
      ";
      break;
   case "3":
      $GLOBALS['temp']['allContactCheck'] = "checked";
      $agentWhere = "";
      if($userStatusId < 2) {
         $agentWhere = "AND (agentGuestLink.pr_link_to = '$calAgentId' OR agentLink.pr_link_to = '$calAgentId')";
      }
      $sqlFrom = "
         FROM
            pr_persona
            LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
            LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
            LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
            LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
            LEFT JOIN pr_link AS agentGuestLink ON agentGuestLink.pr_link_from = pr_guest.pr_guest_id AND agentGuestLink.rf_link_type_id = 'RS4'
            LEFT JOIN pr_link AS agentLink ON agentLink.pr_link_from = pr_persona.pr_persona_ix AND agentLink.rf_link_type_id = 'RS2'
         WHERE
            pr_persona.pr_name_last LIKE '$search'
			AND NOT (pr_persona.pr_name_last = '' AND pr_persona.pr_name_first = '')
            $agentWhere
            AND pr_persona.pr_sys_code <= 6
			AND pr_persona.pr_org_yn = 0
		   AND pr_persona. pr_persona_inactive_yn = 0
         ORDER BY
            pr_persona.pr_name_last, pr_persona.pr_name_first
      ";
      break;
   case "4":	// All contacts linked to reservation
      $GLOBALS['temp']['linkContactCheck'] = "checked";
      $sqlFrom = "
         FROM
            pr_persona
            LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
            LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
            LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
            LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
            LEFT JOIN pr_link AS agentGuestLink ON agentGuestLink.pr_link_from = pr_guest.pr_guest_id AND agentGuestLink.rf_link_type_id = 'RS4'
            LEFT JOIN pr_link AS agentLink ON agentLink.pr_link_from = pr_persona.pr_persona_ix AND agentLink.rf_link_type_id = 'RS2'
         WHERE
            pr_persona.pr_persona_ix IN ('".join("','",$personaArray)."')
			AND NOT (pr_persona.pr_name_last = '' AND pr_persona.pr_name_first = '')
			AND pr_persona.pr_org_yn = 0
         ORDER BY
            pr_persona.pr_name_last, pr_persona.pr_name_first
      ";
      break;	  
   default:
      $GLOBALS['temp']['linkResCheck'] = "checked";
      $sqlFrom = "
         FROM
            rv_reservation
            INNER JOIN rv_reservation_guest ON rv_reservation_guest.rv_reservation_id = rv_reservation.rv_reservation_ix
            INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_guest.pr_guest_id
            LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
            LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
            LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
            LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
            LEFT JOIN pr_link ON pr_link.pr_link_from = rv_reservation_guest.pr_guest_id AND pr_link.rf_link_type_id = 'RS3'
         WHERE
            rv_reservation.rv_reservation_ix = '$record'
            AND (pr_guest.pr_guest_primary_yn = '1' OR pr_link.pr_link_ix IS NULL)
            AND pr_persona.pr_name_last LIKE '$search'
			AND NOT (pr_persona.pr_name_last = '' AND pr_persona.pr_name_first = '')
            AND pr_persona.pr_sys_code <= 6
    	   AND pr_persona. pr_persona_inactive_yn = 0
	     ORDER BY
            pr_persona.pr_name_last, pr_persona.pr_name_first
      ";
      break;
}

$perPage = 20;

$guestCount = $GLOBALS['lDB']->get("SELECT COUNT(pr_persona.pr_persona_ix)".$sqlFrom,4);
$pageCount = ceil($guestCount / $perPage);

if($page < 1) { $page = 1; }
if($page > $pageCount) { $page = $pageCount; }

$startCount = ($page-1) * $perPage;
if($startCount < 0) {
	$startCount = 0;
}

$GLOBALS['temp']['page'] = $page;
$GLOBALS['temp']['recordCount'] = $guestCount;
$GLOBALS['temp']['pageCount'] = $pageCount;
$GLOBALS['temp']['pageList'] = "";
$GLOBALS['temp']['prevShow'] = "style=\"visibility: hidden;\"";
$GLOBALS['temp']['nextShow'] = "style=\"visibility: hidden;\"";
if($page > 1) { $GLOBALS['temp']['prevShow'] = ""; }
if($page < $pageCount) { $GLOBALS['temp']['nextShow'] = ""; }


$guestArray = $GLOBALS['lDB']->get("
   SELECT
      pr_persona.pr_name_first,
      pr_persona.pr_name_second,
      pr_persona.pr_name_last,
      pr_persona.pr_persona_ix,
      rf_title.rf_title_desc,
      rf_name_suffix.rf_suffix_desc,
      rf_country.rf_country_name,
      rf_country.rf_country_code,
      pr_guest.pr_guest_note,
      pr_guest.pr_guest_memo,
      pr_guest.pr_guest_id

   ".$sqlFrom."
   LIMIT $startCount, $perPage
   "
   ,2);

if($groupId != "false" && $groupId != "") {
   $resItemId = $GLOBALS['lDB']->get("SELECT rv_reservation_item_id FROM rv_res_item_group WHERE rv_res_item_group_ix = '$groupId'",4);
   $guestGroupCount = $GLOBALS['lDB']->get("
      SELECT
         count(pr_guest_id)
      FROM
         rv_res_item_guest
      WHERE
         rv_res_item_group_id = '$groupId'
   ",4);
} else {
   $guestGroupCount = 0;
}

$guestActive = $GLOBALS['lDB']->get("
   SELECT
      pr_guest_id
   FROM
      rv_res_item_guest
   WHERE
      rv_reservation_item_id = '$resItemId'
",3);



$maxSize = $GLOBALS['lDB']->get("
   SELECT
      rv_reservation_item.rv_item_adult_count+rv_reservation_item.rv_item_child_count
   FROM
      rv_reservation_item
   WHERE
      rv_reservation_item.rv_reservation_item_ix = '$resItemId'
",4);

$GLOBALS['temp']['maxAllowed'] = $maxSize - $guestGroupCount;

$rows = "";
$rowHTML = Join("", file(__DIR__ . "/../../../public/html/contact_import_primary_row.htm"));
$secondaryRowHTML = Join("", file(__DIR__ . "/../../../public/html/contact_import_secondary_row.htm"));
$secondaryItemHTML = Join("", file(__DIR__ . "/../../../public/html/contact_import_secondary_item.htm"));
$secondCount = 1;

$GLOBALS['temp']['showExpandCollapse'] = " class=\"collapse\" ";
$GLOBALS['temp']['dataHeight'] = "265";
foreach($guestArray as $item) {
   $agentCheck = $GLOBALS['lDB']->get("
      SELECT
         pr_name_last
      FROM
         pr_link
         INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
      WHERE
         pr_link_from = '$item[pr_persona_ix]'
         AND rf_link_type_id = 'RS4'
   ",2);
   $agentName = "Direct";
   if(sizeof($agentCheck) > 0) {
      $agentName = $agentCheck[0]['pr_name_last'];
   }
   $guestName = $item['pr_name_last'];
   if($item['rf_suffix_desc'] != "" && $item['rf_suffix_desc'] != "0") {
      $guestName .= " " . $item['rf_suffix_desc'];
   }
   if($item['pr_name_first'] != "" && $item['pr_name_first'] != "0") {
	  if(trim($guestName) != "") {
	      $guestName .= ", " . $item['pr_name_first'];
	  } else {
		  $guestName = $item['pr_name_first'];
	  }
      if($item['pr_name_second'] != "" && $item['pr_name_second'] != "0") {
         $guestName .= " " . $item['pr_name_second'];
      }
   }
   if($item['rf_title_desc'] != "" && $item['rf_title_desc'] != "0") {
      $guestName .= " " . $item['rf_title_desc'];
   }
   if($item['rf_country_code'] != "" && $item['rf_country_code'] != "0") {
      $guestName .= " (" . $item['rf_country_code'] . ")";
   } elseif($item['rf_country_name'] != "" && $item['rf_country_name'] != "0") {
      $guestName .= " (" . substr($item['rf_country_name'],0,4) . ")";
   }
   $note = "visibility:hidden;";
   $noteonclick = "";
   if(trim($item['pr_guest_note']) != "") {
	  $note = "";
      $noteonclick = "onmouseover=\"overlib('".t_encodeOverlib($item['pr_guest_note'])."',LEFT,WIDTH,150);\" onmouseout=\"nd();\"";
   }
   $memo = "visibility:hidden;";
   $memoonclick = "";
   if(trim($item['pr_guest_memo']) != "") {
	  $memo = "";
      $memoonclick = "onmouseover=\"overlib('".t_encodeOverlib($item['pr_guest_memo'])."',LEFT,WIDTH,150);\" onmouseout=\"nd();\"";
   }
   if($_SESSION['userStatusId'] < 2) {
      $memo = "visibility:hidden;";
   }
   $showTravel = "";
   if($item['pr_persona_ix'] != $item['pr_guest_id']) {
      $showTravel = "visibility:hidden;";
   }

   $guestChecked = "";
   $guestDisabled = "";
   if(in_array($item['pr_persona_ix'],$guestActive)) {
      $guestChecked = "checked";
      $guestDisabled = "disabled";
   }

   $rows .= str_replace("!guestName!",$guestName,
      str_replace("!agentName!",$agentName,
      str_replace("!id!",$item['pr_persona_ix'],
      str_replace("!note!",$note,
	  str_replace("!noteonclick!",$noteonclick,
      str_replace("!memo!",$memo,
	  str_replace("!memoonclick!",$memoonclick,
      str_replace("!showTravel!",$showTravel,
      str_replace("!guestChecked!",$guestChecked,
      str_replace("!guestDisabled!",$guestDisabled,
      $rowHTML))))))))));
   $secondaryArray = $GLOBALS['lDB']->get("
      SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_persona_ix,
         rf_title.rf_title_desc,
         rf_name_suffix.rf_suffix_desc,
         rf_country.rf_country_name,
         rf_country.rf_country_code,
         pr_guest.pr_guest_note,
         pr_guest.pr_guest_memo
      FROM
         pr_link
         INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
         INNER JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
         LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
         LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
         LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
      WHERE
         pr_link.pr_link_to = '$item[pr_persona_ix]'
              AND pr_link.rf_link_type_id = 'RS3'
   ",2);
   if(sizeof($secondaryArray) > 0 && $filter != "3") { // All filters except for 'All contacts' which is a flat list
   	  $GLOBALS['temp']['showExpandCollapse'] = " class=\"expand\" ";
	  $GLOBALS['temp']['dataHeight'] = "245";
      $secondaryRow = "";
      foreach($secondaryArray as $secondaryItem) {
         $secondaryName = $secondaryItem['pr_name_last'];
         if($secondaryItem['rf_suffix_desc'] != "" && $secondaryItem['rf_suffix_desc'] != "0") {
            $secondaryName .= " " . $secondaryItem['rf_suffix_desc'];
         }
         if($secondaryItem['pr_name_first'] != "" && $secondaryItem['pr_name_first'] != "0") {
			if(trim($secondaryName) != "") {
	            $secondaryName .= ", " . $secondaryItem['pr_name_first'];
			} else {
				$secondaryName = $secondaryItem['pr_name_first'];
			}
            if($secondaryItem['pr_name_second'] != "" && $secondaryItem['pr_name_second'] != "0") {
               $secondaryName .= " " . $secondaryItem['pr_name_second'];
            }
         }
         if($secondaryItem['rf_title_desc'] != "" && $secondaryItem['rf_title_desc'] != "0") {
            $secondaryName .= " " . $secondaryItem['rf_title_desc'];
         }
         if($secondaryItem['rf_country_code'] != "" && $secondaryItem['rf_country_code'] != "0") {
            $secondaryName .= " (" . $secondaryItem['rf_country_code'] . ")";
         } elseif($secondaryItem['rf_country_name'] != "" && $secondaryItem['rf_country_name'] != "0") {
            $secondaryName .= " (" . substr($secondaryItem['rf_country_name'],0,4) . ")";
         }
         $note = "visibility:hidden;";
		 $noteonclick = "";
         if(trim($secondaryItem['pr_guest_note']) != "") {
			$note = "";
            $noteonclick = "onmouseover=\"overlib('".t_encodeOverlib($secondaryItem['pr_guest_note'])."',LEFT,WIDTH,150);\" onmouseout=\"nd();\"";
         }
         $memo = "visibility:hidden;";
		 $memoonclick = "";
         if(trim($secondaryItem['pr_guest_memo']) != "") {
			$memo = "";
            $memoonclick = "onmouseover=\"overlib('".t_encodeOverlib($secondaryItem['pr_guest_memo'])."',LEFT,WIDTH,150);\" onmouseout=\"nd();\"";
         }
         if($_SESSION['userStatusId'] < 2) {
            $memo = "visibility:hidden;";
         }
         $guestChecked = "";
         $guestDisabled = "";
         if(in_array($secondaryItem['pr_persona_ix'],$guestActive)) {
            $guestChecked = "checked";
            $guestDisabled = "disabled";
         }
         $secondaryRow .= str_replace("!guestName!",$secondaryName,
               str_replace("!id!",$secondaryItem['pr_persona_ix'],
               str_replace("!guestChecked!",$guestChecked,
               str_replace("!guestDisabled!",$guestDisabled,
               str_replace("!note!",$note,
			   str_replace("!noteonclick!",$noteonclick,
               str_replace("!memo!",$memo,
			   str_replace("!memoonclick!",$memoonclick,
			   $secondaryItemHTML))))))));
      }
      $rows .= str_replace("!items!",$secondaryRow,
         str_replace("!num!",$secondCount,$secondaryRowHTML));
      $secondCount++;

   }
}
if(trim($rows) != "") {
	$GLOBALS['temp']['rows'] = $rows;
} else {
	$GLOBALS['temp']['rows'] = "
		<tr><td align=\"center\" class=\"txti\">No contacts found matching your search</td></tr>
	";
}
